"use strict";
var assets = require("@pixi/assets"), compressedTextures = require("@pixi/compressed-textures"), core = require("@pixi/core"), Basis = require("../Basis.js"), TranscoderWorker = require("../TranscoderWorker.js"), BasisParser = require("./BasisParser.js");
const loadBasis = {
  extension: {
    type: core.ExtensionType.LoadParser,
    priority: assets.LoaderParserPriority.High
  },
  name: "loadBasis",
  test(url) {
    return assets.checkExtension(url, ".basis");
  },
  async load(url, asset, loader) {
    await TranscoderWorker.TranscoderWorker.onTranscoderInitialized;
    const arrayBuffer = await (await core.settings.ADAPTER.fetch(url)).arrayBuffer(), resources = await BasisParser.BasisParser.transcode(arrayBuffer), type = Basis.BASIS_FORMAT_TO_TYPE[resources.basisFormat], format = resources.basisFormat !== Basis.BASIS_FORMATS.cTFRGBA32 ? core.FORMATS.RGB : core.FORMATS.RGBA, textures = resources.map((resource) => {
      const base = new core.BaseTexture(resource, {
        mipmap: resource instanceof compressedTextures.CompressedTextureResource && resource.levels > 1 ? core.MIPMAP_MODES.ON_MANUAL : core.MIPMAP_MODES.OFF,
        alphaMode: core.ALPHA_MODES.NO_PREMULTIPLIED_ALPHA,
        type,
        format,
        ...asset.data
      });
      return assets.createTexture(base, loader, url);
    });
    return textures.length === 1 ? textures[0] : textures;
  },
  unload(texture) {
    Array.isArray(texture) ? texture.forEach((t) => t.destroy(!0)) : texture.destroy(!0);
  }
};
core.extensions.add(loadBasis);
exports.loadBasis = loadBasis;
//# sourceMappingURL=loadBasis.js.map
