'use strict';

if (!global) { var global = globalThis || window; }

Object.defineProperty(exports, '__esModule', { value: true });

function getDefaultExportFromNamespaceIfPresent (n) {
	return n && Object.prototype.hasOwnProperty.call(n, 'default') ? n['default'] : n;
}

var eslintLinterBrowserify = {};

var global$1 = (typeof global !== "undefined" ? global :
  typeof self !== "undefined" ? self :
  typeof window !== "undefined" ? window : {});

// shim for using process in browser
// based off https://github.com/defunctzombie/node-process/blob/master/browser.js

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
var cachedSetTimeout = defaultSetTimout;
var cachedClearTimeout = defaultClearTimeout;
if (typeof global$1.setTimeout === 'function') {
    cachedSetTimeout = setTimeout;
}
if (typeof global$1.clearTimeout === 'function') {
    cachedClearTimeout = clearTimeout;
}

function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}
function nextTick(fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
}
// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
var title$1 = 'browser';
var platform = 'browser';
var browser$2 = true;
var env = {};
var argv = [];
var version$2 = ''; // empty string to avoid regexp issues
var versions = {};
var release = {};
var config$1 = {};

function noop() {}

var on = noop;
var addListener = noop;
var once = noop;
var off = noop;
var removeListener = noop;
var removeAllListeners = noop;
var emit = noop;

function binding(name) {
    throw new Error('process.binding is not supported');
}

function cwd () { return '/' }
function chdir (dir) {
    throw new Error('process.chdir is not supported');
}function umask() { return 0; }

// from https://github.com/kumavis/browser-process-hrtime/blob/master/index.js
var performance = global$1.performance || {};
var performanceNow =
  performance.now        ||
  performance.mozNow     ||
  performance.msNow      ||
  performance.oNow       ||
  performance.webkitNow  ||
  function(){ return (new Date()).getTime() };

// generate timestamp or delta
// see http://nodejs.org/api/process.html#process_process_hrtime
function hrtime(previousTimestamp){
  var clocktime = performanceNow.call(performance)*1e-3;
  var seconds = Math.floor(clocktime);
  var nanoseconds = Math.floor((clocktime%1)*1e9);
  if (previousTimestamp) {
    seconds = seconds - previousTimestamp[0];
    nanoseconds = nanoseconds - previousTimestamp[1];
    if (nanoseconds<0) {
      seconds--;
      nanoseconds += 1e9;
    }
  }
  return [seconds,nanoseconds]
}

var startTime = new Date();
function uptime() {
  var currentTime = new Date();
  var dif = currentTime - startTime;
  return dif / 1000;
}

var browser$1$1 = {
  nextTick: nextTick,
  title: title$1,
  browser: browser$2,
  env: env,
  argv: argv,
  version: version$2,
  versions: versions,
  on: on,
  addListener: addListener,
  once: once,
  off: off,
  removeListener: removeListener,
  removeAllListeners: removeAllListeners,
  emit: emit,
  binding: binding,
  cwd: cwd,
  chdir: chdir,
  umask: umask,
  hrtime: hrtime,
  platform: platform,
  release: release,
  config: config$1,
  uptime: uptime
};

// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

// resolves . and .. elements in a path array with directory names there
// must be no slashes, empty elements, or device names (c:\) in the array
// (so also no leading and trailing slashes - it does not distinguish
// relative and absolute paths)
function normalizeArray(parts, allowAboveRoot) {
  // if the path tries to go above the root, `up` ends up > 0
  var up = 0;
  for (var i = parts.length - 1; i >= 0; i--) {
    var last = parts[i];
    if (last === '.') {
      parts.splice(i, 1);
    } else if (last === '..') {
      parts.splice(i, 1);
      up++;
    } else if (up) {
      parts.splice(i, 1);
      up--;
    }
  }

  // if the path is allowed to go above the root, restore leading ..s
  if (allowAboveRoot) {
    for (; up--; up) {
      parts.unshift('..');
    }
  }

  return parts;
}

// Split a filename into [root, dir, basename, ext], unix version
// 'root' is just a slash, or nothing.
var splitPathRe =
    /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
var splitPath = function(filename) {
  return splitPathRe.exec(filename).slice(1);
};

// path.resolve([from ...], to)
// posix version
function resolve() {
  var resolvedPath = '',
      resolvedAbsolute = false;

  for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
    var path = (i >= 0) ? arguments[i] : '/';

    // Skip empty and invalid entries
    if (typeof path !== 'string') {
      throw new TypeError('Arguments to path.resolve must be strings');
    } else if (!path) {
      continue;
    }

    resolvedPath = path + '/' + resolvedPath;
    resolvedAbsolute = path.charAt(0) === '/';
  }

  // At this point the path should be resolved to a full absolute path, but
  // handle relative paths to be safe (might happen when process.cwd() fails)

  // Normalize the path
  resolvedPath = normalizeArray(filter(resolvedPath.split('/'), function(p) {
    return !!p;
  }), !resolvedAbsolute).join('/');

  return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
}
// path.normalize(path)
// posix version
function normalize(path) {
  var isPathAbsolute = isAbsolute(path),
      trailingSlash = substr(path, -1) === '/';

  // Normalize the path
  path = normalizeArray(filter(path.split('/'), function(p) {
    return !!p;
  }), !isPathAbsolute).join('/');

  if (!path && !isPathAbsolute) {
    path = '.';
  }
  if (path && trailingSlash) {
    path += '/';
  }

  return (isPathAbsolute ? '/' : '') + path;
}
// posix version
function isAbsolute(path) {
  return path.charAt(0) === '/';
}

// posix version
function join() {
  var paths = Array.prototype.slice.call(arguments, 0);
  return normalize(filter(paths, function(p, index) {
    if (typeof p !== 'string') {
      throw new TypeError('Arguments to path.join must be strings');
    }
    return p;
  }).join('/'));
}


// path.relative(from, to)
// posix version
function relative(from, to) {
  from = resolve(from).substr(1);
  to = resolve(to).substr(1);

  function trim(arr) {
    var start = 0;
    for (; start < arr.length; start++) {
      if (arr[start] !== '') break;
    }

    var end = arr.length - 1;
    for (; end >= 0; end--) {
      if (arr[end] !== '') break;
    }

    if (start > end) return [];
    return arr.slice(start, end - start + 1);
  }

  var fromParts = trim(from.split('/'));
  var toParts = trim(to.split('/'));

  var length = Math.min(fromParts.length, toParts.length);
  var samePartsLength = length;
  for (var i = 0; i < length; i++) {
    if (fromParts[i] !== toParts[i]) {
      samePartsLength = i;
      break;
    }
  }

  var outputParts = [];
  for (var i = samePartsLength; i < fromParts.length; i++) {
    outputParts.push('..');
  }

  outputParts = outputParts.concat(toParts.slice(samePartsLength));

  return outputParts.join('/');
}

var sep = '/';
var delimiter = ':';

function dirname(path) {
  var result = splitPath(path),
      root = result[0],
      dir = result[1];

  if (!root && !dir) {
    // No dirname whatsoever
    return '.';
  }

  if (dir) {
    // It has a dirname, strip trailing slash
    dir = dir.substr(0, dir.length - 1);
  }

  return root + dir;
}

function basename(path, ext) {
  var f = splitPath(path)[2];
  // TODO: make this comparison case-insensitive on windows?
  if (ext && f.substr(-1 * ext.length) === ext) {
    f = f.substr(0, f.length - ext.length);
  }
  return f;
}


function extname(path) {
  return splitPath(path)[3];
}
var _polyfillNode_path = {
  extname: extname,
  basename: basename,
  dirname: dirname,
  sep: sep,
  delimiter: delimiter,
  relative: relative,
  join: join,
  isAbsolute: isAbsolute,
  normalize: normalize,
  resolve: resolve
};
function filter (xs, f) {
    if (xs.filter) return xs.filter(f);
    var res = [];
    for (var i = 0; i < xs.length; i++) {
        if (f(xs[i], i, xs)) res.push(xs[i]);
    }
    return res;
}

// String.prototype.substr - negative index don't work in IE8
var substr = 'ab'.substr(-1) === 'b' ?
    function (str, start, len) { return str.substr(start, len) } :
    function (str, start, len) {
        if (start < 0) start = str.length + start;
        return str.substr(start, len);
    }
;

var _polyfillNode_path$1 = /*#__PURE__*/Object.freeze({
	__proto__: null,
	basename: basename,
	default: _polyfillNode_path,
	delimiter: delimiter,
	dirname: dirname,
	extname: extname,
	isAbsolute: isAbsolute,
	join: join,
	normalize: normalize,
	relative: relative,
	resolve: resolve,
	sep: sep
});

var require$$0$1 = /*@__PURE__*/getDefaultExportFromNamespaceIfPresent(_polyfillNode_path$1);

var eslintScope = {};

var estraverse = {};

/*
  Copyright (C) 2012-2013 Yusuke Suzuki <utatane.tea@gmail.com>
  Copyright (C) 2012 Ariya Hidayat <ariya.hidayat@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

var hasRequiredEstraverse;

function requireEstraverse () {
	if (hasRequiredEstraverse) return estraverse;
	hasRequiredEstraverse = 1;
	(function (exports) {
		/*jslint vars:false, bitwise:true*/
		/*jshint indent:4*/
		/*global exports:true*/
		(function clone(exports) {

		    var Syntax,
		        VisitorOption,
		        VisitorKeys,
		        BREAK,
		        SKIP,
		        REMOVE;

		    function deepCopy(obj) {
		        var ret = {}, key, val;
		        for (key in obj) {
		            if (obj.hasOwnProperty(key)) {
		                val = obj[key];
		                if (typeof val === 'object' && val !== null) {
		                    ret[key] = deepCopy(val);
		                } else {
		                    ret[key] = val;
		                }
		            }
		        }
		        return ret;
		    }

		    // based on LLVM libc++ upper_bound / lower_bound
		    // MIT License

		    function upperBound(array, func) {
		        var diff, len, i, current;

		        len = array.length;
		        i = 0;

		        while (len) {
		            diff = len >>> 1;
		            current = i + diff;
		            if (func(array[current])) {
		                len = diff;
		            } else {
		                i = current + 1;
		                len -= diff + 1;
		            }
		        }
		        return i;
		    }

		    Syntax = {
		        AssignmentExpression: 'AssignmentExpression',
		        AssignmentPattern: 'AssignmentPattern',
		        ArrayExpression: 'ArrayExpression',
		        ArrayPattern: 'ArrayPattern',
		        ArrowFunctionExpression: 'ArrowFunctionExpression',
		        AwaitExpression: 'AwaitExpression', // CAUTION: It's deferred to ES7.
		        BlockStatement: 'BlockStatement',
		        BinaryExpression: 'BinaryExpression',
		        BreakStatement: 'BreakStatement',
		        CallExpression: 'CallExpression',
		        CatchClause: 'CatchClause',
		        ChainExpression: 'ChainExpression',
		        ClassBody: 'ClassBody',
		        ClassDeclaration: 'ClassDeclaration',
		        ClassExpression: 'ClassExpression',
		        ComprehensionBlock: 'ComprehensionBlock',  // CAUTION: It's deferred to ES7.
		        ComprehensionExpression: 'ComprehensionExpression',  // CAUTION: It's deferred to ES7.
		        ConditionalExpression: 'ConditionalExpression',
		        ContinueStatement: 'ContinueStatement',
		        DebuggerStatement: 'DebuggerStatement',
		        DirectiveStatement: 'DirectiveStatement',
		        DoWhileStatement: 'DoWhileStatement',
		        EmptyStatement: 'EmptyStatement',
		        ExportAllDeclaration: 'ExportAllDeclaration',
		        ExportDefaultDeclaration: 'ExportDefaultDeclaration',
		        ExportNamedDeclaration: 'ExportNamedDeclaration',
		        ExportSpecifier: 'ExportSpecifier',
		        ExpressionStatement: 'ExpressionStatement',
		        ForStatement: 'ForStatement',
		        ForInStatement: 'ForInStatement',
		        ForOfStatement: 'ForOfStatement',
		        FunctionDeclaration: 'FunctionDeclaration',
		        FunctionExpression: 'FunctionExpression',
		        GeneratorExpression: 'GeneratorExpression',  // CAUTION: It's deferred to ES7.
		        Identifier: 'Identifier',
		        IfStatement: 'IfStatement',
		        ImportExpression: 'ImportExpression',
		        ImportDeclaration: 'ImportDeclaration',
		        ImportDefaultSpecifier: 'ImportDefaultSpecifier',
		        ImportNamespaceSpecifier: 'ImportNamespaceSpecifier',
		        ImportSpecifier: 'ImportSpecifier',
		        Literal: 'Literal',
		        LabeledStatement: 'LabeledStatement',
		        LogicalExpression: 'LogicalExpression',
		        MemberExpression: 'MemberExpression',
		        MetaProperty: 'MetaProperty',
		        MethodDefinition: 'MethodDefinition',
		        ModuleSpecifier: 'ModuleSpecifier',
		        NewExpression: 'NewExpression',
		        ObjectExpression: 'ObjectExpression',
		        ObjectPattern: 'ObjectPattern',
		        PrivateIdentifier: 'PrivateIdentifier',
		        Program: 'Program',
		        Property: 'Property',
		        PropertyDefinition: 'PropertyDefinition',
		        RestElement: 'RestElement',
		        ReturnStatement: 'ReturnStatement',
		        SequenceExpression: 'SequenceExpression',
		        SpreadElement: 'SpreadElement',
		        Super: 'Super',
		        SwitchStatement: 'SwitchStatement',
		        SwitchCase: 'SwitchCase',
		        TaggedTemplateExpression: 'TaggedTemplateExpression',
		        TemplateElement: 'TemplateElement',
		        TemplateLiteral: 'TemplateLiteral',
		        ThisExpression: 'ThisExpression',
		        ThrowStatement: 'ThrowStatement',
		        TryStatement: 'TryStatement',
		        UnaryExpression: 'UnaryExpression',
		        UpdateExpression: 'UpdateExpression',
		        VariableDeclaration: 'VariableDeclaration',
		        VariableDeclarator: 'VariableDeclarator',
		        WhileStatement: 'WhileStatement',
		        WithStatement: 'WithStatement',
		        YieldExpression: 'YieldExpression'
		    };

		    VisitorKeys = {
		        AssignmentExpression: ['left', 'right'],
		        AssignmentPattern: ['left', 'right'],
		        ArrayExpression: ['elements'],
		        ArrayPattern: ['elements'],
		        ArrowFunctionExpression: ['params', 'body'],
		        AwaitExpression: ['argument'], // CAUTION: It's deferred to ES7.
		        BlockStatement: ['body'],
		        BinaryExpression: ['left', 'right'],
		        BreakStatement: ['label'],
		        CallExpression: ['callee', 'arguments'],
		        CatchClause: ['param', 'body'],
		        ChainExpression: ['expression'],
		        ClassBody: ['body'],
		        ClassDeclaration: ['id', 'superClass', 'body'],
		        ClassExpression: ['id', 'superClass', 'body'],
		        ComprehensionBlock: ['left', 'right'],  // CAUTION: It's deferred to ES7.
		        ComprehensionExpression: ['blocks', 'filter', 'body'],  // CAUTION: It's deferred to ES7.
		        ConditionalExpression: ['test', 'consequent', 'alternate'],
		        ContinueStatement: ['label'],
		        DebuggerStatement: [],
		        DirectiveStatement: [],
		        DoWhileStatement: ['body', 'test'],
		        EmptyStatement: [],
		        ExportAllDeclaration: ['source'],
		        ExportDefaultDeclaration: ['declaration'],
		        ExportNamedDeclaration: ['declaration', 'specifiers', 'source'],
		        ExportSpecifier: ['exported', 'local'],
		        ExpressionStatement: ['expression'],
		        ForStatement: ['init', 'test', 'update', 'body'],
		        ForInStatement: ['left', 'right', 'body'],
		        ForOfStatement: ['left', 'right', 'body'],
		        FunctionDeclaration: ['id', 'params', 'body'],
		        FunctionExpression: ['id', 'params', 'body'],
		        GeneratorExpression: ['blocks', 'filter', 'body'],  // CAUTION: It's deferred to ES7.
		        Identifier: [],
		        IfStatement: ['test', 'consequent', 'alternate'],
		        ImportExpression: ['source'],
		        ImportDeclaration: ['specifiers', 'source'],
		        ImportDefaultSpecifier: ['local'],
		        ImportNamespaceSpecifier: ['local'],
		        ImportSpecifier: ['imported', 'local'],
		        Literal: [],
		        LabeledStatement: ['label', 'body'],
		        LogicalExpression: ['left', 'right'],
		        MemberExpression: ['object', 'property'],
		        MetaProperty: ['meta', 'property'],
		        MethodDefinition: ['key', 'value'],
		        ModuleSpecifier: [],
		        NewExpression: ['callee', 'arguments'],
		        ObjectExpression: ['properties'],
		        ObjectPattern: ['properties'],
		        PrivateIdentifier: [],
		        Program: ['body'],
		        Property: ['key', 'value'],
		        PropertyDefinition: ['key', 'value'],
		        RestElement: [ 'argument' ],
		        ReturnStatement: ['argument'],
		        SequenceExpression: ['expressions'],
		        SpreadElement: ['argument'],
		        Super: [],
		        SwitchStatement: ['discriminant', 'cases'],
		        SwitchCase: ['test', 'consequent'],
		        TaggedTemplateExpression: ['tag', 'quasi'],
		        TemplateElement: [],
		        TemplateLiteral: ['quasis', 'expressions'],
		        ThisExpression: [],
		        ThrowStatement: ['argument'],
		        TryStatement: ['block', 'handler', 'finalizer'],
		        UnaryExpression: ['argument'],
		        UpdateExpression: ['argument'],
		        VariableDeclaration: ['declarations'],
		        VariableDeclarator: ['id', 'init'],
		        WhileStatement: ['test', 'body'],
		        WithStatement: ['object', 'body'],
		        YieldExpression: ['argument']
		    };

		    // unique id
		    BREAK = {};
		    SKIP = {};
		    REMOVE = {};

		    VisitorOption = {
		        Break: BREAK,
		        Skip: SKIP,
		        Remove: REMOVE
		    };

		    function Reference(parent, key) {
		        this.parent = parent;
		        this.key = key;
		    }

		    Reference.prototype.replace = function replace(node) {
		        this.parent[this.key] = node;
		    };

		    Reference.prototype.remove = function remove() {
		        if (Array.isArray(this.parent)) {
		            this.parent.splice(this.key, 1);
		            return true;
		        } else {
		            this.replace(null);
		            return false;
		        }
		    };

		    function Element(node, path, wrap, ref) {
		        this.node = node;
		        this.path = path;
		        this.wrap = wrap;
		        this.ref = ref;
		    }

		    function Controller() { }

		    // API:
		    // return property path array from root to current node
		    Controller.prototype.path = function path() {
		        var i, iz, j, jz, result, element;

		        function addToPath(result, path) {
		            if (Array.isArray(path)) {
		                for (j = 0, jz = path.length; j < jz; ++j) {
		                    result.push(path[j]);
		                }
		            } else {
		                result.push(path);
		            }
		        }

		        // root node
		        if (!this.__current.path) {
		            return null;
		        }

		        // first node is sentinel, second node is root element
		        result = [];
		        for (i = 2, iz = this.__leavelist.length; i < iz; ++i) {
		            element = this.__leavelist[i];
		            addToPath(result, element.path);
		        }
		        addToPath(result, this.__current.path);
		        return result;
		    };

		    // API:
		    // return type of current node
		    Controller.prototype.type = function () {
		        var node = this.current();
		        return node.type || this.__current.wrap;
		    };

		    // API:
		    // return array of parent elements
		    Controller.prototype.parents = function parents() {
		        var i, iz, result;

		        // first node is sentinel
		        result = [];
		        for (i = 1, iz = this.__leavelist.length; i < iz; ++i) {
		            result.push(this.__leavelist[i].node);
		        }

		        return result;
		    };

		    // API:
		    // return current node
		    Controller.prototype.current = function current() {
		        return this.__current.node;
		    };

		    Controller.prototype.__execute = function __execute(callback, element) {
		        var previous, result;

		        result = undefined;

		        previous  = this.__current;
		        this.__current = element;
		        this.__state = null;
		        if (callback) {
		            result = callback.call(this, element.node, this.__leavelist[this.__leavelist.length - 1].node);
		        }
		        this.__current = previous;

		        return result;
		    };

		    // API:
		    // notify control skip / break
		    Controller.prototype.notify = function notify(flag) {
		        this.__state = flag;
		    };

		    // API:
		    // skip child nodes of current node
		    Controller.prototype.skip = function () {
		        this.notify(SKIP);
		    };

		    // API:
		    // break traversals
		    Controller.prototype['break'] = function () {
		        this.notify(BREAK);
		    };

		    // API:
		    // remove node
		    Controller.prototype.remove = function () {
		        this.notify(REMOVE);
		    };

		    Controller.prototype.__initialize = function(root, visitor) {
		        this.visitor = visitor;
		        this.root = root;
		        this.__worklist = [];
		        this.__leavelist = [];
		        this.__current = null;
		        this.__state = null;
		        this.__fallback = null;
		        if (visitor.fallback === 'iteration') {
		            this.__fallback = Object.keys;
		        } else if (typeof visitor.fallback === 'function') {
		            this.__fallback = visitor.fallback;
		        }

		        this.__keys = VisitorKeys;
		        if (visitor.keys) {
		            this.__keys = Object.assign(Object.create(this.__keys), visitor.keys);
		        }
		    };

		    function isNode(node) {
		        if (node == null) {
		            return false;
		        }
		        return typeof node === 'object' && typeof node.type === 'string';
		    }

		    function isProperty(nodeType, key) {
		        return (nodeType === Syntax.ObjectExpression || nodeType === Syntax.ObjectPattern) && 'properties' === key;
		    }
		  
		    function candidateExistsInLeaveList(leavelist, candidate) {
		        for (var i = leavelist.length - 1; i >= 0; --i) {
		            if (leavelist[i].node === candidate) {
		                return true;
		            }
		        }
		        return false;
		    }

		    Controller.prototype.traverse = function traverse(root, visitor) {
		        var worklist,
		            leavelist,
		            element,
		            node,
		            nodeType,
		            ret,
		            key,
		            current,
		            current2,
		            candidates,
		            candidate,
		            sentinel;

		        this.__initialize(root, visitor);

		        sentinel = {};

		        // reference
		        worklist = this.__worklist;
		        leavelist = this.__leavelist;

		        // initialize
		        worklist.push(new Element(root, null, null, null));
		        leavelist.push(new Element(null, null, null, null));

		        while (worklist.length) {
		            element = worklist.pop();

		            if (element === sentinel) {
		                element = leavelist.pop();

		                ret = this.__execute(visitor.leave, element);

		                if (this.__state === BREAK || ret === BREAK) {
		                    return;
		                }
		                continue;
		            }

		            if (element.node) {

		                ret = this.__execute(visitor.enter, element);

		                if (this.__state === BREAK || ret === BREAK) {
		                    return;
		                }

		                worklist.push(sentinel);
		                leavelist.push(element);

		                if (this.__state === SKIP || ret === SKIP) {
		                    continue;
		                }

		                node = element.node;
		                nodeType = node.type || element.wrap;
		                candidates = this.__keys[nodeType];
		                if (!candidates) {
		                    if (this.__fallback) {
		                        candidates = this.__fallback(node);
		                    } else {
		                        throw new Error('Unknown node type ' + nodeType + '.');
		                    }
		                }

		                current = candidates.length;
		                while ((current -= 1) >= 0) {
		                    key = candidates[current];
		                    candidate = node[key];
		                    if (!candidate) {
		                        continue;
		                    }

		                    if (Array.isArray(candidate)) {
		                        current2 = candidate.length;
		                        while ((current2 -= 1) >= 0) {
		                            if (!candidate[current2]) {
		                                continue;
		                            }

		                            if (candidateExistsInLeaveList(leavelist, candidate[current2])) {
		                              continue;
		                            }

		                            if (isProperty(nodeType, candidates[current])) {
		                                element = new Element(candidate[current2], [key, current2], 'Property', null);
		                            } else if (isNode(candidate[current2])) {
		                                element = new Element(candidate[current2], [key, current2], null, null);
		                            } else {
		                                continue;
		                            }
		                            worklist.push(element);
		                        }
		                    } else if (isNode(candidate)) {
		                        if (candidateExistsInLeaveList(leavelist, candidate)) {
		                          continue;
		                        }

		                        worklist.push(new Element(candidate, key, null, null));
		                    }
		                }
		            }
		        }
		    };

		    Controller.prototype.replace = function replace(root, visitor) {
		        var worklist,
		            leavelist,
		            node,
		            nodeType,
		            target,
		            element,
		            current,
		            current2,
		            candidates,
		            candidate,
		            sentinel,
		            outer,
		            key;

		        function removeElem(element) {
		            var i,
		                key,
		                nextElem,
		                parent;

		            if (element.ref.remove()) {
		                // When the reference is an element of an array.
		                key = element.ref.key;
		                parent = element.ref.parent;

		                // If removed from array, then decrease following items' keys.
		                i = worklist.length;
		                while (i--) {
		                    nextElem = worklist[i];
		                    if (nextElem.ref && nextElem.ref.parent === parent) {
		                        if  (nextElem.ref.key < key) {
		                            break;
		                        }
		                        --nextElem.ref.key;
		                    }
		                }
		            }
		        }

		        this.__initialize(root, visitor);

		        sentinel = {};

		        // reference
		        worklist = this.__worklist;
		        leavelist = this.__leavelist;

		        // initialize
		        outer = {
		            root: root
		        };
		        element = new Element(root, null, null, new Reference(outer, 'root'));
		        worklist.push(element);
		        leavelist.push(element);

		        while (worklist.length) {
		            element = worklist.pop();

		            if (element === sentinel) {
		                element = leavelist.pop();

		                target = this.__execute(visitor.leave, element);

		                // node may be replaced with null,
		                // so distinguish between undefined and null in this place
		                if (target !== undefined && target !== BREAK && target !== SKIP && target !== REMOVE) {
		                    // replace
		                    element.ref.replace(target);
		                }

		                if (this.__state === REMOVE || target === REMOVE) {
		                    removeElem(element);
		                }

		                if (this.__state === BREAK || target === BREAK) {
		                    return outer.root;
		                }
		                continue;
		            }

		            target = this.__execute(visitor.enter, element);

		            // node may be replaced with null,
		            // so distinguish between undefined and null in this place
		            if (target !== undefined && target !== BREAK && target !== SKIP && target !== REMOVE) {
		                // replace
		                element.ref.replace(target);
		                element.node = target;
		            }

		            if (this.__state === REMOVE || target === REMOVE) {
		                removeElem(element);
		                element.node = null;
		            }

		            if (this.__state === BREAK || target === BREAK) {
		                return outer.root;
		            }

		            // node may be null
		            node = element.node;
		            if (!node) {
		                continue;
		            }

		            worklist.push(sentinel);
		            leavelist.push(element);

		            if (this.__state === SKIP || target === SKIP) {
		                continue;
		            }

		            nodeType = node.type || element.wrap;
		            candidates = this.__keys[nodeType];
		            if (!candidates) {
		                if (this.__fallback) {
		                    candidates = this.__fallback(node);
		                } else {
		                    throw new Error('Unknown node type ' + nodeType + '.');
		                }
		            }

		            current = candidates.length;
		            while ((current -= 1) >= 0) {
		                key = candidates[current];
		                candidate = node[key];
		                if (!candidate) {
		                    continue;
		                }

		                if (Array.isArray(candidate)) {
		                    current2 = candidate.length;
		                    while ((current2 -= 1) >= 0) {
		                        if (!candidate[current2]) {
		                            continue;
		                        }
		                        if (isProperty(nodeType, candidates[current])) {
		                            element = new Element(candidate[current2], [key, current2], 'Property', new Reference(candidate, current2));
		                        } else if (isNode(candidate[current2])) {
		                            element = new Element(candidate[current2], [key, current2], null, new Reference(candidate, current2));
		                        } else {
		                            continue;
		                        }
		                        worklist.push(element);
		                    }
		                } else if (isNode(candidate)) {
		                    worklist.push(new Element(candidate, key, null, new Reference(node, key)));
		                }
		            }
		        }

		        return outer.root;
		    };

		    function traverse(root, visitor) {
		        var controller = new Controller();
		        return controller.traverse(root, visitor);
		    }

		    function replace(root, visitor) {
		        var controller = new Controller();
		        return controller.replace(root, visitor);
		    }

		    function extendCommentRange(comment, tokens) {
		        var target;

		        target = upperBound(tokens, function search(token) {
		            return token.range[0] > comment.range[0];
		        });

		        comment.extendedRange = [comment.range[0], comment.range[1]];

		        if (target !== tokens.length) {
		            comment.extendedRange[1] = tokens[target].range[0];
		        }

		        target -= 1;
		        if (target >= 0) {
		            comment.extendedRange[0] = tokens[target].range[1];
		        }

		        return comment;
		    }

		    function attachComments(tree, providedComments, tokens) {
		        // At first, we should calculate extended comment ranges.
		        var comments = [], comment, len, i, cursor;

		        if (!tree.range) {
		            throw new Error('attachComments needs range information');
		        }

		        // tokens array is empty, we attach comments to tree as 'leadingComments'
		        if (!tokens.length) {
		            if (providedComments.length) {
		                for (i = 0, len = providedComments.length; i < len; i += 1) {
		                    comment = deepCopy(providedComments[i]);
		                    comment.extendedRange = [0, tree.range[0]];
		                    comments.push(comment);
		                }
		                tree.leadingComments = comments;
		            }
		            return tree;
		        }

		        for (i = 0, len = providedComments.length; i < len; i += 1) {
		            comments.push(extendCommentRange(deepCopy(providedComments[i]), tokens));
		        }

		        // This is based on John Freeman's implementation.
		        cursor = 0;
		        traverse(tree, {
		            enter: function (node) {
		                var comment;

		                while (cursor < comments.length) {
		                    comment = comments[cursor];
		                    if (comment.extendedRange[1] > node.range[0]) {
		                        break;
		                    }

		                    if (comment.extendedRange[1] === node.range[0]) {
		                        if (!node.leadingComments) {
		                            node.leadingComments = [];
		                        }
		                        node.leadingComments.push(comment);
		                        comments.splice(cursor, 1);
		                    } else {
		                        cursor += 1;
		                    }
		                }

		                // already out of owned node
		                if (cursor === comments.length) {
		                    return VisitorOption.Break;
		                }

		                if (comments[cursor].extendedRange[0] > node.range[1]) {
		                    return VisitorOption.Skip;
		                }
		            }
		        });

		        cursor = 0;
		        traverse(tree, {
		            leave: function (node) {
		                var comment;

		                while (cursor < comments.length) {
		                    comment = comments[cursor];
		                    if (node.range[1] < comment.extendedRange[0]) {
		                        break;
		                    }

		                    if (node.range[1] === comment.extendedRange[0]) {
		                        if (!node.trailingComments) {
		                            node.trailingComments = [];
		                        }
		                        node.trailingComments.push(comment);
		                        comments.splice(cursor, 1);
		                    } else {
		                        cursor += 1;
		                    }
		                }

		                // already out of owned node
		                if (cursor === comments.length) {
		                    return VisitorOption.Break;
		                }

		                if (comments[cursor].extendedRange[0] > node.range[1]) {
		                    return VisitorOption.Skip;
		                }
		            }
		        });

		        return tree;
		    }

		    exports.Syntax = Syntax;
		    exports.traverse = traverse;
		    exports.replace = replace;
		    exports.attachComments = attachComments;
		    exports.VisitorKeys = VisitorKeys;
		    exports.VisitorOption = VisitorOption;
		    exports.Controller = Controller;
		    exports.cloneEnvironment = function () { return clone({}); };

		    return exports;
		}(exports));
		/* vim: set sw=4 ts=4 et tw=80 : */ 
	} (estraverse));
	return estraverse;
}

var esrecurse = {};

var version$1 = "4.3.0";
var require$$1$2 = {
	version: version$1};

/*
  Copyright (C) 2014 Yusuke Suzuki <utatane.tea@gmail.com>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

var hasRequiredEsrecurse;

function requireEsrecurse () {
	if (hasRequiredEsrecurse) return esrecurse;
	hasRequiredEsrecurse = 1;
	(function () {

	    var estraverse = requireEstraverse();

	    function isNode(node) {
	        if (node == null) {
	            return false;
	        }
	        return typeof node === 'object' && typeof node.type === 'string';
	    }

	    function isProperty(nodeType, key) {
	        return (nodeType === estraverse.Syntax.ObjectExpression || nodeType === estraverse.Syntax.ObjectPattern) && key === 'properties';
	    }

	    function Visitor(visitor, options) {
	        options = options || {};

	        this.__visitor = visitor ||  this;
	        this.__childVisitorKeys = options.childVisitorKeys
	            ? Object.assign({}, estraverse.VisitorKeys, options.childVisitorKeys)
	            : estraverse.VisitorKeys;
	        if (options.fallback === 'iteration') {
	            this.__fallback = Object.keys;
	        } else if (typeof options.fallback === 'function') {
	            this.__fallback = options.fallback;
	        }
	    }

	    /* Default method for visiting children.
	     * When you need to call default visiting operation inside custom visiting
	     * operation, you can use it with `this.visitChildren(node)`.
	     */
	    Visitor.prototype.visitChildren = function (node) {
	        var type, children, i, iz, j, jz, child;

	        if (node == null) {
	            return;
	        }

	        type = node.type || estraverse.Syntax.Property;

	        children = this.__childVisitorKeys[type];
	        if (!children) {
	            if (this.__fallback) {
	                children = this.__fallback(node);
	            } else {
	                throw new Error('Unknown node type ' + type + '.');
	            }
	        }

	        for (i = 0, iz = children.length; i < iz; ++i) {
	            child = node[children[i]];
	            if (child) {
	                if (Array.isArray(child)) {
	                    for (j = 0, jz = child.length; j < jz; ++j) {
	                        if (child[j]) {
	                            if (isNode(child[j]) || isProperty(type, children[i])) {
	                                this.visit(child[j]);
	                            }
	                        }
	                    }
	                } else if (isNode(child)) {
	                    this.visit(child);
	                }
	            }
	        }
	    };

	    /* Dispatching node. */
	    Visitor.prototype.visit = function (node) {
	        var type;

	        if (node == null) {
	            return;
	        }

	        type = node.type || estraverse.Syntax.Property;
	        if (this.__visitor[type]) {
	            this.__visitor[type].call(this, node);
	            return;
	        }
	        this.visitChildren(node);
	    };

	    esrecurse.version = require$$1$2.version;
	    esrecurse.Visitor = Visitor;
	    esrecurse.visit = function (node, visitor, options) {
	        var v = new Visitor(visitor, options);
	        v.visit(node);
	    };
	}());
	/* vim: set sw=4 ts=4 et tw=80 : */
	return esrecurse;
}

var hasRequiredEslintScope;

function requireEslintScope () {
	if (hasRequiredEslintScope) return eslintScope;
	hasRequiredEslintScope = 1;

	Object.defineProperty(eslintScope, '__esModule', { value: true });

	var estraverse = requireEstraverse();
	var esrecurse = requireEsrecurse();

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var estraverse__default = /*#__PURE__*/_interopDefaultLegacy(estraverse);
	var esrecurse__default = /*#__PURE__*/_interopDefaultLegacy(esrecurse);

	/**
	 * @fileoverview Assertion utilities.
	 * @author Nicholas C. Zakas
	 */

	/**
	 * Throws an error if the given condition is not truthy.
	 * @param {boolean} condition The condition to check.
	 * @param {string} message The message to include with the error.
	 * @returns {void}
	 * @throws {Error} When the condition is not truthy.
	 */
	function assert(condition, message = "Assertion failed.") {
	    if (!condition) {
	        throw new Error(message);
	    }
	}

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	const READ = 0x1;
	const WRITE = 0x2;
	const RW = READ | WRITE;

	/**
	 * A Reference represents a single occurrence of an identifier in code.
	 * @constructor Reference
	 */
	class Reference {
	    constructor(ident, scope, flag, writeExpr, maybeImplicitGlobal, partial, init) {

	        /**
	         * Identifier syntax node.
	         * @member {espreeIdentifier} Reference#identifier
	         */
	        this.identifier = ident;

	        /**
	         * Reference to the enclosing Scope.
	         * @member {Scope} Reference#from
	         */
	        this.from = scope;

	        /**
	         * Whether the reference comes from a dynamic scope (such as 'eval',
	         * 'with', etc.), and may be trapped by dynamic scopes.
	         * @member {boolean} Reference#tainted
	         */
	        this.tainted = false;

	        /**
	         * The variable this reference is resolved with.
	         * @member {Variable} Reference#resolved
	         */
	        this.resolved = null;

	        /**
	         * The read-write mode of the reference. (Value is one of {@link
	         * Reference.READ}, {@link Reference.RW}, {@link Reference.WRITE}).
	         * @member {number} Reference#flag
	         * @private
	         */
	        this.flag = flag;
	        if (this.isWrite()) {

	            /**
	             * If reference is writeable, this is the tree being written to it.
	             * @member {espreeNode} Reference#writeExpr
	             */
	            this.writeExpr = writeExpr;

	            /**
	             * Whether the Reference might refer to a partial value of writeExpr.
	             * @member {boolean} Reference#partial
	             */
	            this.partial = partial;

	            /**
	             * Whether the Reference is to write of initialization.
	             * @member {boolean} Reference#init
	             */
	            this.init = init;
	        }
	        this.__maybeImplicitGlobal = maybeImplicitGlobal;
	    }

	    /**
	     * Whether the reference is static.
	     * @function Reference#isStatic
	     * @returns {boolean} static
	     */
	    isStatic() {
	        return !this.tainted && this.resolved && this.resolved.scope.isStatic();
	    }

	    /**
	     * Whether the reference is writeable.
	     * @function Reference#isWrite
	     * @returns {boolean} write
	     */
	    isWrite() {
	        return !!(this.flag & Reference.WRITE);
	    }

	    /**
	     * Whether the reference is readable.
	     * @function Reference#isRead
	     * @returns {boolean} read
	     */
	    isRead() {
	        return !!(this.flag & Reference.READ);
	    }

	    /**
	     * Whether the reference is read-only.
	     * @function Reference#isReadOnly
	     * @returns {boolean} read only
	     */
	    isReadOnly() {
	        return this.flag === Reference.READ;
	    }

	    /**
	     * Whether the reference is write-only.
	     * @function Reference#isWriteOnly
	     * @returns {boolean} write only
	     */
	    isWriteOnly() {
	        return this.flag === Reference.WRITE;
	    }

	    /**
	     * Whether the reference is read-write.
	     * @function Reference#isReadWrite
	     * @returns {boolean} read write
	     */
	    isReadWrite() {
	        return this.flag === Reference.RW;
	    }
	}

	/**
	 * @constant Reference.READ
	 * @private
	 */
	Reference.READ = READ;

	/**
	 * @constant Reference.WRITE
	 * @private
	 */
	Reference.WRITE = WRITE;

	/**
	 * @constant Reference.RW
	 * @private
	 */
	Reference.RW = RW;

	/* vim: set sw=4 ts=4 et tw=80 : */

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	/**
	 * A Variable represents a locally scoped identifier. These include arguments to
	 * functions.
	 * @constructor Variable
	 */
	class Variable {
	    constructor(name, scope) {

	        /**
	         * The variable name, as given in the source code.
	         * @member {string} Variable#name
	         */
	        this.name = name;

	        /**
	         * List of defining occurrences of this variable (like in 'var ...'
	         * statements or as parameter), as AST nodes.
	         * @member {espree.Identifier[]} Variable#identifiers
	         */
	        this.identifiers = [];

	        /**
	         * List of {@link Reference|references} of this variable (excluding parameter entries)
	         * in its defining scope and all nested scopes. For defining
	         * occurrences only see {@link Variable#defs}.
	         * @member {Reference[]} Variable#references
	         */
	        this.references = [];

	        /**
	         * List of defining occurrences of this variable (like in 'var ...'
	         * statements or as parameter), as custom objects.
	         * @member {Definition[]} Variable#defs
	         */
	        this.defs = [];

	        this.tainted = false;

	        /**
	         * Whether this is a stack variable.
	         * @member {boolean} Variable#stack
	         */
	        this.stack = true;

	        /**
	         * Reference to the enclosing Scope.
	         * @member {Scope} Variable#scope
	         */
	        this.scope = scope;
	    }
	}

	Variable.CatchClause = "CatchClause";
	Variable.Parameter = "Parameter";
	Variable.FunctionName = "FunctionName";
	Variable.ClassName = "ClassName";
	Variable.Variable = "Variable";
	Variable.ImportBinding = "ImportBinding";
	Variable.ImplicitGlobalVariable = "ImplicitGlobalVariable";

	/* vim: set sw=4 ts=4 et tw=80 : */

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	/**
	 * @constructor Definition
	 */
	class Definition {
	    constructor(type, name, node, parent, index, kind) {

	        /**
	         * @member {string} Definition#type - type of the occurrence (e.g. "Parameter", "Variable", ...).
	         */
	        this.type = type;

	        /**
	         * @member {espree.Identifier} Definition#name - the identifier AST node of the occurrence.
	         */
	        this.name = name;

	        /**
	         * @member {espree.Node} Definition#node - the enclosing node of the identifier.
	         */
	        this.node = node;

	        /**
	         * @member {espree.Node?} Definition#parent - the enclosing statement node of the identifier.
	         */
	        this.parent = parent;

	        /**
	         * @member {number?} Definition#index - the index in the declaration statement.
	         */
	        this.index = index;

	        /**
	         * @member {string?} Definition#kind - the kind of the declaration statement.
	         */
	        this.kind = kind;
	    }
	}

	/**
	 * @constructor ParameterDefinition
	 */
	class ParameterDefinition extends Definition {
	    constructor(name, node, index, rest) {
	        super(Variable.Parameter, name, node, null, index, null);

	        /**
	         * Whether the parameter definition is a part of a rest parameter.
	         * @member {boolean} ParameterDefinition#rest
	         */
	        this.rest = rest;
	    }
	}

	/* vim: set sw=4 ts=4 et tw=80 : */

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	const { Syntax: Syntax$2 } = estraverse__default["default"];

	/**
	 * Test if scope is struct
	 * @param {Scope} scope scope
	 * @param {Block} block block
	 * @param {boolean} isMethodDefinition is method definition
	 * @returns {boolean} is strict scope
	 */
	function isStrictScope(scope, block, isMethodDefinition) {
	    let body;

	    // When upper scope is exists and strict, inner scope is also strict.
	    if (scope.upper && scope.upper.isStrict) {
	        return true;
	    }

	    if (isMethodDefinition) {
	        return true;
	    }

	    if (scope.type === "class" || scope.type === "module") {
	        return true;
	    }

	    if (scope.type === "block" || scope.type === "switch") {
	        return false;
	    }

	    if (scope.type === "function") {
	        if (block.type === Syntax$2.ArrowFunctionExpression && block.body.type !== Syntax$2.BlockStatement) {
	            return false;
	        }

	        if (block.type === Syntax$2.Program) {
	            body = block;
	        } else {
	            body = block.body;
	        }

	        if (!body) {
	            return false;
	        }
	    } else if (scope.type === "global") {
	        body = block;
	    } else {
	        return false;
	    }

	    // Search for a 'use strict' directive.
	    for (let i = 0, iz = body.body.length; i < iz; ++i) {
	        const stmt = body.body[i];

	        /*
	         * Check if the current statement is a directive.
	         * If it isn't, then we're past the directive prologue
	         * so stop the search because directives cannot
	         * appear after this point.
	         *
	         * Some parsers set `directive:null` on non-directive
	         * statements, so the `typeof` check is safer than
	         * checking for property existence.
	         */
	        if (typeof stmt.directive !== "string") {
	            break;
	        }

	        if (stmt.directive === "use strict") {
	            return true;
	        }
	    }

	    return false;
	}

	/**
	 * Register scope
	 * @param {ScopeManager} scopeManager scope manager
	 * @param {Scope} scope scope
	 * @returns {void}
	 */
	function registerScope(scopeManager, scope) {
	    scopeManager.scopes.push(scope);

	    const scopes = scopeManager.__nodeToScope.get(scope.block);

	    if (scopes) {
	        scopes.push(scope);
	    } else {
	        scopeManager.__nodeToScope.set(scope.block, [scope]);
	    }
	}

	/**
	 * Should be statically
	 * @param {Object} def def
	 * @returns {boolean} should be statically
	 */
	function shouldBeStatically(def) {
	    return (
	        (def.type === Variable.ClassName) ||
	        (def.type === Variable.Variable && def.parent.kind !== "var")
	    );
	}

	/**
	 * @constructor Scope
	 */
	class Scope {
	    constructor(scopeManager, type, upperScope, block, isMethodDefinition) {

	        /**
	         * One of "global", "module", "function", "function-expression-name", "block", "switch", "catch", "with", "for",
	         * "class", "class-field-initializer", "class-static-block".
	         * @member {string} Scope#type
	         */
	        this.type = type;

	        /**
	         * The scoped {@link Variable}s of this scope, as <code>{ Variable.name
	         * : Variable }</code>.
	         * @member {Map} Scope#set
	         */
	        this.set = new Map();

	        /**
	         * The tainted variables of this scope, as <code>{ Variable.name :
	         * boolean }</code>.
	         *  @member {Map} Scope#taints
	         */
	        this.taints = new Map();

	        /**
	         * Generally, through the lexical scoping of JS you can always know
	         * which variable an identifier in the source code refers to. There are
	         * a few exceptions to this rule. With 'global' and 'with' scopes you
	         * can only decide at runtime which variable a reference refers to.
	         * Moreover, if 'eval()' is used in a scope, it might introduce new
	         * bindings in this or its parent scopes.
	         * All those scopes are considered 'dynamic'.
	         * @member {boolean} Scope#dynamic
	         */
	        this.dynamic = this.type === "global" || this.type === "with";

	        /**
	         * A reference to the scope-defining syntax node.
	         * @member {espree.Node} Scope#block
	         */
	        this.block = block;

	        /**
	         * The {@link Reference|references} that are not resolved with this scope.
	         * @member {Reference[]} Scope#through
	         */
	        this.through = [];

	        /**
	         * The scoped {@link Variable}s of this scope. In the case of a
	         * 'function' scope this includes the automatic argument <em>arguments</em> as
	         * its first element, as well as all further formal arguments.
	         * @member {Variable[]} Scope#variables
	         */
	        this.variables = [];

	        /**
	         * Any variable {@link Reference|reference} found in this scope. This
	         * includes occurrences of local variables as well as variables from
	         * parent scopes (including the global scope). For local variables
	         * this also includes defining occurrences (like in a 'var' statement).
	         * In a 'function' scope this does not include the occurrences of the
	         * formal parameter in the parameter list.
	         * @member {Reference[]} Scope#references
	         */
	        this.references = [];

	        /**
	         * For 'global' and 'function' scopes, this is a self-reference. For
	         * other scope types this is the <em>variableScope</em> value of the
	         * parent scope.
	         * @member {Scope} Scope#variableScope
	         */
	        this.variableScope =
	            this.type === "global" ||
	            this.type === "module" ||
	            this.type === "function" ||
	            this.type === "class-field-initializer" ||
	            this.type === "class-static-block"
	                ? this
	                : upperScope.variableScope;

	        /**
	         * Whether this scope is created by a FunctionExpression.
	         * @member {boolean} Scope#functionExpressionScope
	         */
	        this.functionExpressionScope = false;

	        /**
	         * Whether this is a scope that contains an 'eval()' invocation.
	         * @member {boolean} Scope#directCallToEvalScope
	         */
	        this.directCallToEvalScope = false;

	        /**
	         * @member {boolean} Scope#thisFound
	         */
	        this.thisFound = false;

	        this.__left = [];

	        /**
	         * Reference to the parent {@link Scope|scope}.
	         * @member {Scope} Scope#upper
	         */
	        this.upper = upperScope;

	        /**
	         * Whether 'use strict' is in effect in this scope.
	         * @member {boolean} Scope#isStrict
	         */
	        this.isStrict = scopeManager.isStrictModeSupported()
	            ? isStrictScope(this, block, isMethodDefinition)
	            : false;

	        /**
	         * List of nested {@link Scope}s.
	         * @member {Scope[]} Scope#childScopes
	         */
	        this.childScopes = [];
	        if (this.upper) {
	            this.upper.childScopes.push(this);
	        }

	        this.__declaredVariables = scopeManager.__declaredVariables;

	        registerScope(scopeManager, this);
	    }

	    __shouldStaticallyClose(scopeManager) {
	        return (!this.dynamic || scopeManager.__isOptimistic());
	    }

	    __shouldStaticallyCloseForGlobal(ref) {

	        // On global scope, let/const/class declarations should be resolved statically.
	        const name = ref.identifier.name;

	        if (!this.set.has(name)) {
	            return false;
	        }

	        const variable = this.set.get(name);
	        const defs = variable.defs;

	        return defs.length > 0 && defs.every(shouldBeStatically);
	    }

	    __staticCloseRef(ref) {
	        if (!this.__resolve(ref)) {
	            this.__delegateToUpperScope(ref);
	        }
	    }

	    __dynamicCloseRef(ref) {

	        // notify all names are through to global
	        let current = this;

	        do {
	            current.through.push(ref);
	            current = current.upper;
	        } while (current);
	    }

	    __globalCloseRef(ref) {

	        // let/const/class declarations should be resolved statically.
	        // others should be resolved dynamically.
	        if (this.__shouldStaticallyCloseForGlobal(ref)) {
	            this.__staticCloseRef(ref);
	        } else {
	            this.__dynamicCloseRef(ref);
	        }
	    }

	    __close(scopeManager) {
	        let closeRef;

	        if (this.__shouldStaticallyClose(scopeManager)) {
	            closeRef = this.__staticCloseRef;
	        } else if (this.type !== "global") {
	            closeRef = this.__dynamicCloseRef;
	        } else {
	            closeRef = this.__globalCloseRef;
	        }

	        // Try Resolving all references in this scope.
	        for (let i = 0, iz = this.__left.length; i < iz; ++i) {
	            const ref = this.__left[i];

	            closeRef.call(this, ref);
	        }
	        this.__left = null;

	        return this.upper;
	    }

	    // To override by function scopes.
	    // References in default parameters isn't resolved to variables which are in their function body.
	    __isValidResolution(ref, variable) { // eslint-disable-line class-methods-use-this, no-unused-vars  -- Desired as instance method with signature
	        return true;
	    }

	    __resolve(ref) {
	        const name = ref.identifier.name;

	        if (!this.set.has(name)) {
	            return false;
	        }
	        const variable = this.set.get(name);

	        if (!this.__isValidResolution(ref, variable)) {
	            return false;
	        }
	        variable.references.push(ref);
	        variable.stack = variable.stack && ref.from.variableScope === this.variableScope;
	        if (ref.tainted) {
	            variable.tainted = true;
	            this.taints.set(variable.name, true);
	        }
	        ref.resolved = variable;

	        return true;
	    }

	    __delegateToUpperScope(ref) {
	        if (this.upper) {
	            this.upper.__left.push(ref);
	        }
	        this.through.push(ref);
	    }

	    __addDeclaredVariablesOfNode(variable, node) {
	        if (node === null || node === void 0) {
	            return;
	        }

	        let variables = this.__declaredVariables.get(node);

	        if (variables === null || variables === void 0) {
	            variables = [];
	            this.__declaredVariables.set(node, variables);
	        }
	        if (!variables.includes(variable)) {
	            variables.push(variable);
	        }
	    }

	    __defineGeneric(name, set, variables, node, def) {
	        let variable;

	        variable = set.get(name);
	        if (!variable) {
	            variable = new Variable(name, this);
	            set.set(name, variable);
	            variables.push(variable);
	        }

	        if (def) {
	            variable.defs.push(def);
	            this.__addDeclaredVariablesOfNode(variable, def.node);
	            this.__addDeclaredVariablesOfNode(variable, def.parent);
	        }
	        if (node) {
	            variable.identifiers.push(node);
	        }
	    }

	    __define(node, def) {
	        if (node && node.type === Syntax$2.Identifier) {
	            this.__defineGeneric(
	                node.name,
	                this.set,
	                this.variables,
	                node,
	                def
	            );
	        }
	    }

	    __referencing(node, assign, writeExpr, maybeImplicitGlobal, partial, init) {

	        // because Array element may be null
	        if (!node || (node.type !== Syntax$2.Identifier && node.type !== "JSXIdentifier")) {
	            return;
	        }

	        // Specially handle like `this`.
	        if (node.name === "super") {
	            return;
	        }

	        const ref = new Reference(node, this, assign || Reference.READ, writeExpr, maybeImplicitGlobal, !!partial, !!init);

	        this.references.push(ref);
	        this.__left.push(ref);
	    }

	    __detectEval() {
	        let current = this;

	        this.directCallToEvalScope = true;
	        do {
	            current.dynamic = true;
	            current = current.upper;
	        } while (current);
	    }

	    __detectThis() {
	        this.thisFound = true;
	    }

	    __isClosed() {
	        return this.__left === null;
	    }

	    /**
	     * returns resolved {Reference}
	     * @function Scope#resolve
	     * @param {Espree.Identifier} ident identifier to be resolved.
	     * @returns {Reference} reference
	     */
	    resolve(ident) {
	        let ref, i, iz;

	        assert(this.__isClosed(), "Scope should be closed.");
	        assert(ident.type === Syntax$2.Identifier, "Target should be identifier.");
	        for (i = 0, iz = this.references.length; i < iz; ++i) {
	            ref = this.references[i];
	            if (ref.identifier === ident) {
	                return ref;
	            }
	        }
	        return null;
	    }

	    /**
	     * returns this scope is static
	     * @function Scope#isStatic
	     * @returns {boolean} static
	     */
	    isStatic() {
	        return !this.dynamic;
	    }

	    /**
	     * returns this scope has materialized arguments
	     * @function Scope#isArgumentsMaterialized
	     * @returns {boolean} arguemnts materialized
	     */
	    isArgumentsMaterialized() { // eslint-disable-line class-methods-use-this -- Desired as instance method
	        return true;
	    }

	    /**
	     * returns this scope has materialized `this` reference
	     * @function Scope#isThisMaterialized
	     * @returns {boolean} this materialized
	     */
	    isThisMaterialized() { // eslint-disable-line class-methods-use-this -- Desired as instance method
	        return true;
	    }

	    isUsedName(name) {
	        if (this.set.has(name)) {
	            return true;
	        }
	        for (let i = 0, iz = this.through.length; i < iz; ++i) {
	            if (this.through[i].identifier.name === name) {
	                return true;
	            }
	        }
	        return false;
	    }
	}

	/**
	 * Global scope.
	 */
	class GlobalScope extends Scope {
	    constructor(scopeManager, block) {
	        super(scopeManager, "global", null, block, false);
	        this.implicit = {
	            set: new Map(),
	            variables: [],

	            /**
	             * List of {@link Reference}s that are left to be resolved (i.e. which
	             * need to be linked to the variable they refer to).
	             * @member {Reference[]} Scope#implicit#left
	             */
	            left: []
	        };
	    }

	    __close(scopeManager) {
	        const implicit = [];

	        for (let i = 0, iz = this.__left.length; i < iz; ++i) {
	            const ref = this.__left[i];

	            if (ref.__maybeImplicitGlobal && !this.set.has(ref.identifier.name)) {
	                implicit.push(ref.__maybeImplicitGlobal);
	            }
	        }

	        // create an implicit global variable from assignment expression
	        for (let i = 0, iz = implicit.length; i < iz; ++i) {
	            const info = implicit[i];

	            this.__defineImplicit(info.pattern,
	                new Definition(
	                    Variable.ImplicitGlobalVariable,
	                    info.pattern,
	                    info.node,
	                    null,
	                    null,
	                    null
	                ));

	        }

	        this.implicit.left = this.__left;

	        return super.__close(scopeManager);
	    }

	    __defineImplicit(node, def) {
	        if (node && node.type === Syntax$2.Identifier) {
	            this.__defineGeneric(
	                node.name,
	                this.implicit.set,
	                this.implicit.variables,
	                node,
	                def
	            );
	        }
	    }
	}

	/**
	 * Module scope.
	 */
	class ModuleScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "module", upperScope, block, false);
	    }
	}

	/**
	 * Function expression name scope.
	 */
	class FunctionExpressionNameScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "function-expression-name", upperScope, block, false);
	        this.__define(block.id,
	            new Definition(
	                Variable.FunctionName,
	                block.id,
	                block,
	                null,
	                null,
	                null
	            ));
	        this.functionExpressionScope = true;
	    }
	}

	/**
	 * Catch scope.
	 */
	class CatchScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "catch", upperScope, block, false);
	    }
	}

	/**
	 * With statement scope.
	 */
	class WithScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "with", upperScope, block, false);
	    }

	    __close(scopeManager) {
	        if (this.__shouldStaticallyClose(scopeManager)) {
	            return super.__close(scopeManager);
	        }

	        for (let i = 0, iz = this.__left.length; i < iz; ++i) {
	            const ref = this.__left[i];

	            ref.tainted = true;
	            this.__delegateToUpperScope(ref);
	        }
	        this.__left = null;

	        return this.upper;
	    }
	}

	/**
	 * Block scope.
	 */
	class BlockScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "block", upperScope, block, false);
	    }
	}

	/**
	 * Switch scope.
	 */
	class SwitchScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "switch", upperScope, block, false);
	    }
	}

	/**
	 * Function scope.
	 */
	class FunctionScope extends Scope {
	    constructor(scopeManager, upperScope, block, isMethodDefinition) {
	        super(scopeManager, "function", upperScope, block, isMethodDefinition);

	        // section 9.2.13, FunctionDeclarationInstantiation.
	        // NOTE Arrow functions never have an arguments objects.
	        if (this.block.type !== Syntax$2.ArrowFunctionExpression) {
	            this.__defineArguments();
	        }
	    }

	    isArgumentsMaterialized() {

	        // TODO(Constellation)
	        // We can more aggressive on this condition like this.
	        //
	        // function t() {
	        //     // arguments of t is always hidden.
	        //     function arguments() {
	        //     }
	        // }
	        if (this.block.type === Syntax$2.ArrowFunctionExpression) {
	            return false;
	        }

	        if (!this.isStatic()) {
	            return true;
	        }

	        const variable = this.set.get("arguments");

	        assert(variable, "Always have arguments variable.");
	        return variable.tainted || variable.references.length !== 0;
	    }

	    isThisMaterialized() {
	        if (!this.isStatic()) {
	            return true;
	        }
	        return this.thisFound;
	    }

	    __defineArguments() {
	        this.__defineGeneric(
	            "arguments",
	            this.set,
	            this.variables,
	            null,
	            null
	        );
	        this.taints.set("arguments", true);
	    }

	    // References in default parameters isn't resolved to variables which are in their function body.
	    //     const x = 1
	    //     function f(a = x) { // This `x` is resolved to the `x` in the outer scope.
	    //         const x = 2
	    //         console.log(a)
	    //     }
	    __isValidResolution(ref, variable) {

	        // If `options.nodejsScope` is true, `this.block` becomes a Program node.
	        if (this.block.type === "Program") {
	            return true;
	        }

	        const bodyStart = this.block.body.range[0];

	        // It's invalid resolution in the following case:
	        return !(
	            variable.scope === this &&
	            ref.identifier.range[0] < bodyStart && // the reference is in the parameter part.
	            variable.defs.every(d => d.name.range[0] >= bodyStart) // the variable is in the body.
	        );
	    }
	}

	/**
	 * Scope of for, for-in, and for-of statements.
	 */
	class ForScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "for", upperScope, block, false);
	    }
	}

	/**
	 * Class scope.
	 */
	class ClassScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "class", upperScope, block, false);
	    }
	}

	/**
	 * Class field initializer scope.
	 */
	class ClassFieldInitializerScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "class-field-initializer", upperScope, block, true);
	    }
	}

	/**
	 * Class static block scope.
	 */
	class ClassStaticBlockScope extends Scope {
	    constructor(scopeManager, upperScope, block) {
	        super(scopeManager, "class-static-block", upperScope, block, true);
	    }
	}

	/* vim: set sw=4 ts=4 et tw=80 : */

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	/**
	 * @constructor ScopeManager
	 */
	class ScopeManager {
	    constructor(options) {
	        this.scopes = [];
	        this.globalScope = null;
	        this.__nodeToScope = new WeakMap();
	        this.__currentScope = null;
	        this.__options = options;
	        this.__declaredVariables = new WeakMap();
	    }

	    __isOptimistic() {
	        return this.__options.optimistic;
	    }

	    __ignoreEval() {
	        return this.__options.ignoreEval;
	    }

	    __isJSXEnabled() {
	        return this.__options.jsx === true;
	    }

	    isGlobalReturn() {
	        return this.__options.nodejsScope || this.__options.sourceType === "commonjs";
	    }

	    isModule() {
	        return this.__options.sourceType === "module";
	    }

	    isImpliedStrict() {
	        return this.__options.impliedStrict;
	    }

	    isStrictModeSupported() {
	        return this.__options.ecmaVersion >= 5;
	    }

	    // Returns appropriate scope for this node.
	    __get(node) {
	        return this.__nodeToScope.get(node);
	    }

	    /**
	     * Get variables that are declared by the node.
	     *
	     * "are declared by the node" means the node is same as `Variable.defs[].node` or `Variable.defs[].parent`.
	     * If the node declares nothing, this method returns an empty array.
	     * CAUTION: This API is experimental. See https://github.com/estools/escope/pull/69 for more details.
	     * @param {Espree.Node} node a node to get.
	     * @returns {Variable[]} variables that declared by the node.
	     */
	    getDeclaredVariables(node) {
	        return this.__declaredVariables.get(node) || [];
	    }

	    /**
	     * acquire scope from node.
	     * @function ScopeManager#acquire
	     * @param {Espree.Node} node node for the acquired scope.
	     * @param {?boolean} [inner=false] look up the most inner scope, default value is false.
	     * @returns {Scope?} Scope from node
	     */
	    acquire(node, inner) {

	        /**
	         * predicate
	         * @param {Scope} testScope scope to test
	         * @returns {boolean} predicate
	         */
	        function predicate(testScope) {
	            if (testScope.type === "function" && testScope.functionExpressionScope) {
	                return false;
	            }
	            return true;
	        }

	        const scopes = this.__get(node);

	        if (!scopes || scopes.length === 0) {
	            return null;
	        }

	        // Heuristic selection from all scopes.
	        // If you would like to get all scopes, please use ScopeManager#acquireAll.
	        if (scopes.length === 1) {
	            return scopes[0];
	        }

	        if (inner) {
	            for (let i = scopes.length - 1; i >= 0; --i) {
	                const scope = scopes[i];

	                if (predicate(scope)) {
	                    return scope;
	                }
	            }
	        } else {
	            for (let i = 0, iz = scopes.length; i < iz; ++i) {
	                const scope = scopes[i];

	                if (predicate(scope)) {
	                    return scope;
	                }
	            }
	        }

	        return null;
	    }

	    /**
	     * acquire all scopes from node.
	     * @function ScopeManager#acquireAll
	     * @param {Espree.Node} node node for the acquired scope.
	     * @returns {Scopes?} Scope array
	     */
	    acquireAll(node) {
	        return this.__get(node);
	    }

	    /**
	     * release the node.
	     * @function ScopeManager#release
	     * @param {Espree.Node} node releasing node.
	     * @param {?boolean} [inner=false] look up the most inner scope, default value is false.
	     * @returns {Scope?} upper scope for the node.
	     */
	    release(node, inner) {
	        const scopes = this.__get(node);

	        if (scopes && scopes.length) {
	            const scope = scopes[0].upper;

	            if (!scope) {
	                return null;
	            }
	            return this.acquire(scope.block, inner);
	        }
	        return null;
	    }

	    attach() { } // eslint-disable-line class-methods-use-this -- Desired as instance method

	    detach() { } // eslint-disable-line class-methods-use-this -- Desired as instance method

	    __nestScope(scope) {
	        if (scope instanceof GlobalScope) {
	            assert(this.__currentScope === null);
	            this.globalScope = scope;
	        }
	        this.__currentScope = scope;
	        return scope;
	    }

	    __nestGlobalScope(node) {
	        return this.__nestScope(new GlobalScope(this, node));
	    }

	    __nestBlockScope(node) {
	        return this.__nestScope(new BlockScope(this, this.__currentScope, node));
	    }

	    __nestFunctionScope(node, isMethodDefinition) {
	        return this.__nestScope(new FunctionScope(this, this.__currentScope, node, isMethodDefinition));
	    }

	    __nestForScope(node) {
	        return this.__nestScope(new ForScope(this, this.__currentScope, node));
	    }

	    __nestCatchScope(node) {
	        return this.__nestScope(new CatchScope(this, this.__currentScope, node));
	    }

	    __nestWithScope(node) {
	        return this.__nestScope(new WithScope(this, this.__currentScope, node));
	    }

	    __nestClassScope(node) {
	        return this.__nestScope(new ClassScope(this, this.__currentScope, node));
	    }

	    __nestClassFieldInitializerScope(node) {
	        return this.__nestScope(new ClassFieldInitializerScope(this, this.__currentScope, node));
	    }

	    __nestClassStaticBlockScope(node) {
	        return this.__nestScope(new ClassStaticBlockScope(this, this.__currentScope, node));
	    }

	    __nestSwitchScope(node) {
	        return this.__nestScope(new SwitchScope(this, this.__currentScope, node));
	    }

	    __nestModuleScope(node) {
	        return this.__nestScope(new ModuleScope(this, this.__currentScope, node));
	    }

	    __nestFunctionExpressionNameScope(node) {
	        return this.__nestScope(new FunctionExpressionNameScope(this, this.__currentScope, node));
	    }

	    __isES6() {
	        return this.__options.ecmaVersion >= 6;
	    }
	}

	/* vim: set sw=4 ts=4 et tw=80 : */

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	const { Syntax: Syntax$1 } = estraverse__default["default"];

	/**
	 * Get last array element
	 * @param {Array} xs array
	 * @returns {any} Last elment
	 */
	function getLast(xs) {
	    return xs.at(-1) || null;
	}

	/**
	 * Visitor for destructuring patterns.
	 */
	class PatternVisitor extends esrecurse__default["default"].Visitor {
	    static isPattern(node) {
	        const nodeType = node.type;

	        return (
	            nodeType === Syntax$1.Identifier ||
	            nodeType === Syntax$1.ObjectPattern ||
	            nodeType === Syntax$1.ArrayPattern ||
	            nodeType === Syntax$1.SpreadElement ||
	            nodeType === Syntax$1.RestElement ||
	            nodeType === Syntax$1.AssignmentPattern
	        );
	    }

	    constructor(options, rootPattern, callback) {
	        super(null, options);
	        this.rootPattern = rootPattern;
	        this.callback = callback;
	        this.assignments = [];
	        this.rightHandNodes = [];
	        this.restElements = [];
	    }

	    Identifier(pattern) {
	        const lastRestElement = getLast(this.restElements);

	        this.callback(pattern, {
	            topLevel: pattern === this.rootPattern,
	            rest: lastRestElement !== null && lastRestElement !== void 0 && lastRestElement.argument === pattern,
	            assignments: this.assignments
	        });
	    }

	    Property(property) {

	        // Computed property's key is a right hand node.
	        if (property.computed) {
	            this.rightHandNodes.push(property.key);
	        }

	        // If it's shorthand, its key is same as its value.
	        // If it's shorthand and has its default value, its key is same as its value.left (the value is AssignmentPattern).
	        // If it's not shorthand, the name of new variable is its value's.
	        this.visit(property.value);
	    }

	    ArrayPattern(pattern) {
	        for (let i = 0, iz = pattern.elements.length; i < iz; ++i) {
	            const element = pattern.elements[i];

	            this.visit(element);
	        }
	    }

	    AssignmentPattern(pattern) {
	        this.assignments.push(pattern);
	        this.visit(pattern.left);
	        this.rightHandNodes.push(pattern.right);
	        this.assignments.pop();
	    }

	    RestElement(pattern) {
	        this.restElements.push(pattern);
	        this.visit(pattern.argument);
	        this.restElements.pop();
	    }

	    MemberExpression(node) {

	        // Computed property's key is a right hand node.
	        if (node.computed) {
	            this.rightHandNodes.push(node.property);
	        }

	        // the object is only read, write to its property.
	        this.rightHandNodes.push(node.object);
	    }

	    //
	    // ForInStatement.left and AssignmentExpression.left are LeftHandSideExpression.
	    // By spec, LeftHandSideExpression is Pattern or MemberExpression.
	    //   (see also: https://github.com/estree/estree/pull/20#issuecomment-74584758)
	    // But espree 2.0 parses to ArrayExpression, ObjectExpression, etc...
	    //

	    SpreadElement(node) {
	        this.visit(node.argument);
	    }

	    ArrayExpression(node) {
	        node.elements.forEach(this.visit, this);
	    }

	    AssignmentExpression(node) {
	        this.assignments.push(node);
	        this.visit(node.left);
	        this.rightHandNodes.push(node.right);
	        this.assignments.pop();
	    }

	    CallExpression(node) {

	        // arguments are right hand nodes.
	        node.arguments.forEach(a => {
	            this.rightHandNodes.push(a);
	        });
	        this.visit(node.callee);
	    }
	}

	/* vim: set sw=4 ts=4 et tw=80 : */

	/*
	  Copyright (C) 2015 Yusuke Suzuki <utatane.tea@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	const { Syntax } = estraverse__default["default"];

	/**
	 * Traverse identifier in pattern
	 * @param {Object} options options
	 * @param {pattern} rootPattern root pattern
	 * @param {Refencer} referencer referencer
	 * @param {callback} callback callback
	 * @returns {void}
	 */
	function traverseIdentifierInPattern(options, rootPattern, referencer, callback) {

	    // Call the callback at left hand identifier nodes, and Collect right hand nodes.
	    const visitor = new PatternVisitor(options, rootPattern, callback);

	    visitor.visit(rootPattern);

	    // Process the right hand nodes recursively.
	    if (referencer !== null && referencer !== void 0) {
	        visitor.rightHandNodes.forEach(referencer.visit, referencer);
	    }
	}

	// Importing ImportDeclaration.
	// http://people.mozilla.org/~jorendorff/es6-draft.html#sec-moduledeclarationinstantiation
	// https://github.com/estree/estree/blob/master/es6.md#importdeclaration
	// FIXME: Now, we don't create module environment, because the context is
	// implementation dependent.

	/**
	 * Visitor for import specifiers.
	 */
	class Importer extends esrecurse__default["default"].Visitor {
	    constructor(declaration, referencer) {
	        super(null, referencer.options);
	        this.declaration = declaration;
	        this.referencer = referencer;
	    }

	    visitImport(id, specifier) {
	        this.referencer.visitPattern(id, pattern => {
	            this.referencer.currentScope().__define(pattern,
	                new Definition(
	                    Variable.ImportBinding,
	                    pattern,
	                    specifier,
	                    this.declaration,
	                    null,
	                    null
	                ));
	        });
	    }

	    ImportNamespaceSpecifier(node) {
	        const local = (node.local || node.id);

	        if (local) {
	            this.visitImport(local, node);
	        }
	    }

	    ImportDefaultSpecifier(node) {
	        const local = (node.local || node.id);

	        this.visitImport(local, node);
	    }

	    ImportSpecifier(node) {
	        const local = (node.local || node.id);

	        if (node.name) {
	            this.visitImport(node.name, node);
	        } else {
	            this.visitImport(local, node);
	        }
	    }
	}

	/**
	 * Referencing variables and creating bindings.
	 */
	class Referencer extends esrecurse__default["default"].Visitor {
	    constructor(options, scopeManager) {
	        super(null, options);
	        this.options = options;
	        this.scopeManager = scopeManager;
	        this.parent = null;
	        this.isInnerMethodDefinition = false;
	    }

	    currentScope() {
	        return this.scopeManager.__currentScope;
	    }

	    close(node) {
	        while (this.currentScope() && node === this.currentScope().block) {
	            this.scopeManager.__currentScope = this.currentScope().__close(this.scopeManager);
	        }
	    }

	    pushInnerMethodDefinition(isInnerMethodDefinition) {
	        const previous = this.isInnerMethodDefinition;

	        this.isInnerMethodDefinition = isInnerMethodDefinition;
	        return previous;
	    }

	    popInnerMethodDefinition(isInnerMethodDefinition) {
	        this.isInnerMethodDefinition = isInnerMethodDefinition;
	    }

	    referencingDefaultValue(pattern, assignments, maybeImplicitGlobal, init) {
	        const scope = this.currentScope();

	        assignments.forEach(assignment => {
	            scope.__referencing(
	                pattern,
	                Reference.WRITE,
	                assignment.right,
	                maybeImplicitGlobal,
	                pattern !== assignment.left,
	                init
	            );
	        });
	    }

	    visitPattern(node, options, callback) {
	        let visitPatternOptions = options;
	        let visitPatternCallback = callback;

	        if (typeof options === "function") {
	            visitPatternCallback = options;
	            visitPatternOptions = { processRightHandNodes: false };
	        }

	        traverseIdentifierInPattern(
	            this.options,
	            node,
	            visitPatternOptions.processRightHandNodes ? this : null,
	            visitPatternCallback
	        );
	    }

	    visitFunction(node) {
	        let i, iz;

	        // FunctionDeclaration name is defined in upper scope
	        // NOTE: Not referring variableScope. It is intended.
	        // Since
	        //  in ES5, FunctionDeclaration should be in FunctionBody.
	        //  in ES6, FunctionDeclaration should be block scoped.

	        if (node.type === Syntax.FunctionDeclaration) {

	            // id is defined in upper scope
	            this.currentScope().__define(node.id,
	                new Definition(
	                    Variable.FunctionName,
	                    node.id,
	                    node,
	                    null,
	                    null,
	                    null
	                ));
	        }

	        // FunctionExpression with name creates its special scope;
	        // FunctionExpressionNameScope.
	        if (node.type === Syntax.FunctionExpression && node.id) {
	            this.scopeManager.__nestFunctionExpressionNameScope(node);
	        }

	        // Consider this function is in the MethodDefinition.
	        this.scopeManager.__nestFunctionScope(node, this.isInnerMethodDefinition);

	        const that = this;

	        /**
	         * Visit pattern callback
	         * @param {pattern} pattern pattern
	         * @param {Object} info info
	         * @returns {void}
	         */
	        function visitPatternCallback(pattern, info) {
	            that.currentScope().__define(pattern,
	                new ParameterDefinition(
	                    pattern,
	                    node,
	                    i,
	                    info.rest
	                ));

	            that.referencingDefaultValue(pattern, info.assignments, null, true);
	        }

	        // Process parameter declarations.
	        for (i = 0, iz = node.params.length; i < iz; ++i) {
	            this.visitPattern(node.params[i], { processRightHandNodes: true }, visitPatternCallback);
	        }

	        // if there's a rest argument, add that
	        if (node.rest) {
	            this.visitPattern({
	                type: "RestElement",
	                argument: node.rest
	            }, pattern => {
	                this.currentScope().__define(pattern,
	                    new ParameterDefinition(
	                        pattern,
	                        node,
	                        node.params.length,
	                        true
	                    ));
	            });
	        }

	        // In TypeScript there are a number of function-like constructs which have no body,
	        // so check it exists before traversing
	        if (node.body) {

	            // Skip BlockStatement to prevent creating BlockStatement scope.
	            if (node.body.type === Syntax.BlockStatement) {
	                this.visitChildren(node.body);
	            } else {
	                this.visit(node.body);
	            }
	        }

	        this.close(node);
	    }

	    visitClass(node) {
	        if (node.type === Syntax.ClassDeclaration) {
	            this.currentScope().__define(node.id,
	                new Definition(
	                    Variable.ClassName,
	                    node.id,
	                    node,
	                    null,
	                    null,
	                    null
	                ));
	        }

	        this.scopeManager.__nestClassScope(node);

	        if (node.id) {
	            this.currentScope().__define(node.id,
	                new Definition(
	                    Variable.ClassName,
	                    node.id,
	                    node
	                ));
	        }

	        this.visit(node.superClass);
	        this.visit(node.body);

	        this.close(node);
	    }

	    visitProperty(node) {
	        let previous;

	        if (node.computed) {
	            this.visit(node.key);
	        }

	        const isMethodDefinition = node.type === Syntax.MethodDefinition;

	        if (isMethodDefinition) {
	            previous = this.pushInnerMethodDefinition(true);
	        }
	        this.visit(node.value);
	        if (isMethodDefinition) {
	            this.popInnerMethodDefinition(previous);
	        }
	    }

	    visitForIn(node) {
	        if (node.left.type === Syntax.VariableDeclaration && node.left.kind !== "var") {
	            this.scopeManager.__nestForScope(node);
	        }

	        if (node.left.type === Syntax.VariableDeclaration) {
	            this.visit(node.left);
	            this.visitPattern(node.left.declarations[0].id, pattern => {
	                this.currentScope().__referencing(pattern, Reference.WRITE, node.right, null, true, true);
	            });
	        } else {
	            this.visitPattern(node.left, { processRightHandNodes: true }, (pattern, info) => {
	                let maybeImplicitGlobal = null;

	                if (!this.currentScope().isStrict) {
	                    maybeImplicitGlobal = {
	                        pattern,
	                        node
	                    };
	                }
	                this.referencingDefaultValue(pattern, info.assignments, maybeImplicitGlobal, false);
	                this.currentScope().__referencing(pattern, Reference.WRITE, node.right, maybeImplicitGlobal, true, false);
	            });
	        }
	        this.visit(node.right);
	        this.visit(node.body);

	        this.close(node);
	    }

	    visitVariableDeclaration(variableTargetScope, type, node, index) {

	        const decl = node.declarations[index];
	        const init = decl.init;

	        this.visitPattern(decl.id, { processRightHandNodes: true }, (pattern, info) => {
	            variableTargetScope.__define(
	                pattern,
	                new Definition(
	                    type,
	                    pattern,
	                    decl,
	                    node,
	                    index,
	                    node.kind
	                )
	            );

	            this.referencingDefaultValue(pattern, info.assignments, null, true);
	            if (init) {
	                this.currentScope().__referencing(pattern, Reference.WRITE, init, null, !info.topLevel, true);
	            }
	        });
	    }

	    AssignmentExpression(node) {
	        if (PatternVisitor.isPattern(node.left)) {
	            if (node.operator === "=") {
	                this.visitPattern(node.left, { processRightHandNodes: true }, (pattern, info) => {
	                    let maybeImplicitGlobal = null;

	                    if (!this.currentScope().isStrict) {
	                        maybeImplicitGlobal = {
	                            pattern,
	                            node
	                        };
	                    }
	                    this.referencingDefaultValue(pattern, info.assignments, maybeImplicitGlobal, false);
	                    this.currentScope().__referencing(pattern, Reference.WRITE, node.right, maybeImplicitGlobal, !info.topLevel, false);
	                });
	            } else {
	                this.currentScope().__referencing(node.left, Reference.RW, node.right);
	            }
	        } else {
	            this.visit(node.left);
	        }
	        this.visit(node.right);
	    }

	    CatchClause(node) {
	        this.scopeManager.__nestCatchScope(node);

	        this.visitPattern(node.param, { processRightHandNodes: true }, (pattern, info) => {
	            this.currentScope().__define(pattern,
	                new Definition(
	                    Variable.CatchClause,
	                    pattern,
	                    node,
	                    null,
	                    null,
	                    null
	                ));
	            this.referencingDefaultValue(pattern, info.assignments, null, true);
	        });
	        this.visit(node.body);

	        this.close(node);
	    }

	    Program(node) {
	        this.scopeManager.__nestGlobalScope(node);

	        if (this.scopeManager.isGlobalReturn()) {

	            // Force strictness of GlobalScope to false when using node.js scope.
	            this.currentScope().isStrict = false;
	            this.scopeManager.__nestFunctionScope(node, false);
	        }

	        if (this.scopeManager.__isES6() && this.scopeManager.isModule()) {
	            this.scopeManager.__nestModuleScope(node);
	        }

	        if (this.scopeManager.isStrictModeSupported() && this.scopeManager.isImpliedStrict()) {
	            this.currentScope().isStrict = true;
	        }

	        this.visitChildren(node);
	        this.close(node);
	    }

	    Identifier(node) {
	        this.currentScope().__referencing(node);
	    }

	    // eslint-disable-next-line class-methods-use-this -- Desired as instance method
	    PrivateIdentifier() {

	        // Do nothing.
	    }

	    UpdateExpression(node) {
	        if (PatternVisitor.isPattern(node.argument)) {
	            this.currentScope().__referencing(node.argument, Reference.RW, null);
	        } else {
	            this.visitChildren(node);
	        }
	    }

	    MemberExpression(node) {
	        this.visit(node.object);
	        if (node.computed) {
	            this.visit(node.property);
	        }
	    }

	    Property(node) {
	        this.visitProperty(node);
	    }

	    PropertyDefinition(node) {
	        const { computed, key, value } = node;

	        if (computed) {
	            this.visit(key);
	        }
	        if (value) {
	            this.scopeManager.__nestClassFieldInitializerScope(value);
	            this.visit(value);
	            this.close(value);
	        }
	    }

	    StaticBlock(node) {
	        this.scopeManager.__nestClassStaticBlockScope(node);

	        this.visitChildren(node);

	        this.close(node);
	    }

	    MethodDefinition(node) {
	        this.visitProperty(node);
	    }

	    BreakStatement() {} // eslint-disable-line class-methods-use-this -- Desired as instance method

	    ContinueStatement() {} // eslint-disable-line class-methods-use-this -- Desired as instance method

	    LabeledStatement(node) {
	        this.visit(node.body);
	    }

	    ForStatement(node) {

	        // Create ForStatement declaration.
	        // NOTE: In ES6, ForStatement dynamically generates
	        // per iteration environment. However, escope is
	        // a static analyzer, we only generate one scope for ForStatement.
	        if (node.init && node.init.type === Syntax.VariableDeclaration && node.init.kind !== "var") {
	            this.scopeManager.__nestForScope(node);
	        }

	        this.visitChildren(node);

	        this.close(node);
	    }

	    ClassExpression(node) {
	        this.visitClass(node);
	    }

	    ClassDeclaration(node) {
	        this.visitClass(node);
	    }

	    CallExpression(node) {

	        // Check this is direct call to eval
	        if (!this.scopeManager.__ignoreEval() && node.callee.type === Syntax.Identifier && node.callee.name === "eval") {

	            // NOTE: This should be `variableScope`. Since direct eval call always creates Lexical environment and
	            // let / const should be enclosed into it. Only VariableDeclaration affects on the caller's environment.
	            this.currentScope().variableScope.__detectEval();
	        }
	        this.visitChildren(node);
	    }

	    BlockStatement(node) {
	        if (this.scopeManager.__isES6()) {
	            this.scopeManager.__nestBlockScope(node);
	        }

	        this.visitChildren(node);

	        this.close(node);
	    }

	    ThisExpression() {
	        this.currentScope().variableScope.__detectThis();
	    }

	    WithStatement(node) {
	        this.visit(node.object);

	        // Then nest scope for WithStatement.
	        this.scopeManager.__nestWithScope(node);

	        this.visit(node.body);

	        this.close(node);
	    }

	    VariableDeclaration(node) {
	        const variableTargetScope = (node.kind === "var") ? this.currentScope().variableScope : this.currentScope();

	        for (let i = 0, iz = node.declarations.length; i < iz; ++i) {
	            const decl = node.declarations[i];

	            this.visitVariableDeclaration(variableTargetScope, Variable.Variable, node, i);
	            if (decl.init) {
	                this.visit(decl.init);
	            }
	        }
	    }

	    // sec 13.11.8
	    SwitchStatement(node) {
	        this.visit(node.discriminant);

	        if (this.scopeManager.__isES6()) {
	            this.scopeManager.__nestSwitchScope(node);
	        }

	        for (let i = 0, iz = node.cases.length; i < iz; ++i) {
	            this.visit(node.cases[i]);
	        }

	        this.close(node);
	    }

	    FunctionDeclaration(node) {
	        this.visitFunction(node);
	    }

	    FunctionExpression(node) {
	        this.visitFunction(node);
	    }

	    ForOfStatement(node) {
	        this.visitForIn(node);
	    }

	    ForInStatement(node) {
	        this.visitForIn(node);
	    }

	    ArrowFunctionExpression(node) {
	        this.visitFunction(node);
	    }

	    ImportDeclaration(node) {
	        assert(this.scopeManager.__isES6() && this.scopeManager.isModule(), "ImportDeclaration should appear when the mode is ES6 and in the module context.");

	        const importer = new Importer(node, this);

	        importer.visit(node);
	    }

	    visitExportDeclaration(node) {
	        if (node.source) {
	            return;
	        }
	        if (node.declaration) {
	            this.visit(node.declaration);
	            return;
	        }

	        this.visitChildren(node);
	    }

	    // TODO: ExportDeclaration doesn't exist. for bc?
	    ExportDeclaration(node) {
	        this.visitExportDeclaration(node);
	    }

	    ExportAllDeclaration(node) {
	        this.visitExportDeclaration(node);
	    }

	    ExportDefaultDeclaration(node) {
	        this.visitExportDeclaration(node);
	    }

	    ExportNamedDeclaration(node) {
	        this.visitExportDeclaration(node);
	    }

	    ExportSpecifier(node) {

	        // TODO: `node.id` doesn't exist. for bc?
	        const local = (node.id || node.local);

	        this.visit(local);
	    }

	    MetaProperty() { // eslint-disable-line class-methods-use-this -- Desired as instance method

	        // do nothing.
	    }

	    JSXIdentifier(node) {

	        // Special case: "this" should not count as a reference
	        if (this.scopeManager.__isJSXEnabled() && node.name !== "this") {
	            this.currentScope().__referencing(node);
	        }
	    }

	    JSXMemberExpression(node) {
	        this.visit(node.object);
	    }

	    JSXElement(node) {
	        if (this.scopeManager.__isJSXEnabled()) {
	            this.visit(node.openingElement);
	            node.children.forEach(this.visit, this);
	        } else {
	            this.visitChildren(node);
	        }
	    }

	    JSXOpeningElement(node) {
	        if (this.scopeManager.__isJSXEnabled()) {

	            const nameNode = node.name;
	            const isComponentName = nameNode.type === "JSXIdentifier" && nameNode.name[0].toUpperCase() === nameNode.name[0];
	            const isComponent = isComponentName || nameNode.type === "JSXMemberExpression";

	            // we only want to visit JSXIdentifier nodes if they are capitalized
	            if (isComponent) {
	                this.visit(nameNode);
	            }
	        }

	        node.attributes.forEach(this.visit, this);
	    }

	    JSXAttribute(node) {
	        if (node.value) {
	            this.visit(node.value);
	        }
	    }

	    JSXExpressionContainer(node) {
	        this.visit(node.expression);
	    }

	    JSXNamespacedName(node) {
	        this.visit(node.namespace);
	        this.visit(node.name);
	    }
	}

	/* vim: set sw=4 ts=4 et tw=80 : */

	const version = "8.3.0";

	/*
	  Copyright (C) 2012-2014 Yusuke Suzuki <utatane.tea@gmail.com>
	  Copyright (C) 2013 Alex Seville <hi@alexanderseville.com>
	  Copyright (C) 2014 Thiago de Arruda <tpadilha84@gmail.com>

	  Redistribution and use in source and binary forms, with or without
	  modification, are permitted provided that the following conditions are met:

	    * Redistributions of source code must retain the above copyright
	      notice, this list of conditions and the following disclaimer.
	    * Redistributions in binary form must reproduce the above copyright
	      notice, this list of conditions and the following disclaimer in the
	      documentation and/or other materials provided with the distribution.

	  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	  ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	*/

	/**
	 * Set the default options
	 * @returns {Object} options
	 */
	function defaultOptions() {
	    return {
	        optimistic: false,
	        nodejsScope: false,
	        impliedStrict: false,
	        sourceType: "script", // one of ['script', 'module', 'commonjs']
	        ecmaVersion: 5,
	        childVisitorKeys: null,
	        fallback: "iteration"
	    };
	}

	/**
	 * Preform deep update on option object
	 * @param {Object} target Options
	 * @param {Object} override Updates
	 * @returns {Object} Updated options
	 */
	function updateDeeply(target, override) {

	    /**
	     * Is hash object
	     * @param {Object} value Test value
	     * @returns {boolean} Result
	     */
	    function isHashObject(value) {
	        return typeof value === "object" && value instanceof Object && !(value instanceof Array) && !(value instanceof RegExp);
	    }

	    for (const key in override) {
	        if (Object.hasOwn(override, key)) {
	            const val = override[key];

	            if (isHashObject(val)) {
	                if (isHashObject(target[key])) {
	                    updateDeeply(target[key], val);
	                } else {
	                    target[key] = updateDeeply({}, val);
	                }
	            } else {
	                target[key] = val;
	            }
	        }
	    }
	    return target;
	}

	/**
	 * Main interface function. Takes an Espree syntax tree and returns the
	 * analyzed scopes.
	 * @function analyze
	 * @param {espree.Tree} tree Abstract Syntax Tree
	 * @param {Object} providedOptions Options that tailor the scope analysis
	 * @param {boolean} [providedOptions.optimistic=false] the optimistic flag
	 * @param {boolean} [providedOptions.ignoreEval=false] whether to check 'eval()' calls
	 * @param {boolean} [providedOptions.nodejsScope=false] whether the whole
	 * script is executed under node.js environment. When enabled, escope adds
	 * a function scope immediately following the global scope.
	 * @param {boolean} [providedOptions.impliedStrict=false] implied strict mode
	 * (if ecmaVersion >= 5).
	 * @param {string} [providedOptions.sourceType='script'] the source type of the script. one of 'script', 'module', and 'commonjs'
	 * @param {number} [providedOptions.ecmaVersion=5] which ECMAScript version is considered
	 * @param {boolean} [providedOptions.jsx=false] support JSX references
	 * @param {Object} [providedOptions.childVisitorKeys=null] Additional known visitor keys. See [esrecurse](https://github.com/estools/esrecurse)'s the `childVisitorKeys` option.
	 * @param {string} [providedOptions.fallback='iteration'] A kind of the fallback in order to encounter with unknown node. See [esrecurse](https://github.com/estools/esrecurse)'s the `fallback` option.
	 * @returns {ScopeManager} ScopeManager
	 */
	function analyze(tree, providedOptions) {
	    const options = updateDeeply(defaultOptions(), providedOptions);
	    const scopeManager = new ScopeManager(options);
	    const referencer = new Referencer(options, scopeManager);

	    referencer.visit(tree);

	    assert(scopeManager.__currentScope === null, "currentScope should be null.");

	    return scopeManager;
	}

	/* vim: set sw=4 ts=4 et tw=80 : */

	eslintScope.Definition = Definition;
	eslintScope.PatternVisitor = PatternVisitor;
	eslintScope.Reference = Reference;
	eslintScope.Referencer = Referencer;
	eslintScope.Scope = Scope;
	eslintScope.ScopeManager = ScopeManager;
	eslintScope.Variable = Variable;
	eslintScope.analyze = analyze;
	eslintScope.version = version;
	
	return eslintScope;
}

var eslintVisitorKeys$2 = {};

var hasRequiredEslintVisitorKeys$2;

function requireEslintVisitorKeys$2 () {
	if (hasRequiredEslintVisitorKeys$2) return eslintVisitorKeys$2;
	hasRequiredEslintVisitorKeys$2 = 1;

	/* eslint-disable jsdoc/valid-types -- doesn't allow `readonly`.
	   TODO: remove eslint-disable when https://github.com/jsdoc-type-pratt-parser/jsdoc-type-pratt-parser/issues/164 is fixed
	*/
	/**
	 * @typedef {{ readonly [type: string]: ReadonlyArray<string> }} VisitorKeys
	 */
	/* eslint-enable jsdoc/valid-types -- doesn't allow `readonly string[]`. TODO: check why */

	/**
	 * @type {VisitorKeys}
	 */
	const KEYS = {
	    ArrayExpression: [
	        "elements"
	    ],
	    ArrayPattern: [
	        "elements"
	    ],
	    ArrowFunctionExpression: [
	        "params",
	        "body"
	    ],
	    AssignmentExpression: [
	        "left",
	        "right"
	    ],
	    AssignmentPattern: [
	        "left",
	        "right"
	    ],
	    AwaitExpression: [
	        "argument"
	    ],
	    BinaryExpression: [
	        "left",
	        "right"
	    ],
	    BlockStatement: [
	        "body"
	    ],
	    BreakStatement: [
	        "label"
	    ],
	    CallExpression: [
	        "callee",
	        "arguments"
	    ],
	    CatchClause: [
	        "param",
	        "body"
	    ],
	    ChainExpression: [
	        "expression"
	    ],
	    ClassBody: [
	        "body"
	    ],
	    ClassDeclaration: [
	        "id",
	        "superClass",
	        "body"
	    ],
	    ClassExpression: [
	        "id",
	        "superClass",
	        "body"
	    ],
	    ConditionalExpression: [
	        "test",
	        "consequent",
	        "alternate"
	    ],
	    ContinueStatement: [
	        "label"
	    ],
	    DebuggerStatement: [],
	    DoWhileStatement: [
	        "body",
	        "test"
	    ],
	    EmptyStatement: [],
	    ExperimentalRestProperty: [
	        "argument"
	    ],
	    ExperimentalSpreadProperty: [
	        "argument"
	    ],
	    ExportAllDeclaration: [
	        "exported",
	        "source",
	        "attributes"
	    ],
	    ExportDefaultDeclaration: [
	        "declaration"
	    ],
	    ExportNamedDeclaration: [
	        "declaration",
	        "specifiers",
	        "source",
	        "attributes"
	    ],
	    ExportSpecifier: [
	        "exported",
	        "local"
	    ],
	    ExpressionStatement: [
	        "expression"
	    ],
	    ForInStatement: [
	        "left",
	        "right",
	        "body"
	    ],
	    ForOfStatement: [
	        "left",
	        "right",
	        "body"
	    ],
	    ForStatement: [
	        "init",
	        "test",
	        "update",
	        "body"
	    ],
	    FunctionDeclaration: [
	        "id",
	        "params",
	        "body"
	    ],
	    FunctionExpression: [
	        "id",
	        "params",
	        "body"
	    ],
	    Identifier: [],
	    IfStatement: [
	        "test",
	        "consequent",
	        "alternate"
	    ],
	    ImportAttribute: [
	        "key",
	        "value"
	    ],
	    ImportDeclaration: [
	        "specifiers",
	        "source",
	        "attributes"
	    ],
	    ImportDefaultSpecifier: [
	        "local"
	    ],
	    ImportExpression: [
	        "source",
	        "options"
	    ],
	    ImportNamespaceSpecifier: [
	        "local"
	    ],
	    ImportSpecifier: [
	        "imported",
	        "local"
	    ],
	    JSXAttribute: [
	        "name",
	        "value"
	    ],
	    JSXClosingElement: [
	        "name"
	    ],
	    JSXClosingFragment: [],
	    JSXElement: [
	        "openingElement",
	        "children",
	        "closingElement"
	    ],
	    JSXEmptyExpression: [],
	    JSXExpressionContainer: [
	        "expression"
	    ],
	    JSXFragment: [
	        "openingFragment",
	        "children",
	        "closingFragment"
	    ],
	    JSXIdentifier: [],
	    JSXMemberExpression: [
	        "object",
	        "property"
	    ],
	    JSXNamespacedName: [
	        "namespace",
	        "name"
	    ],
	    JSXOpeningElement: [
	        "name",
	        "attributes"
	    ],
	    JSXOpeningFragment: [],
	    JSXSpreadAttribute: [
	        "argument"
	    ],
	    JSXSpreadChild: [
	        "expression"
	    ],
	    JSXText: [],
	    LabeledStatement: [
	        "label",
	        "body"
	    ],
	    Literal: [],
	    LogicalExpression: [
	        "left",
	        "right"
	    ],
	    MemberExpression: [
	        "object",
	        "property"
	    ],
	    MetaProperty: [
	        "meta",
	        "property"
	    ],
	    MethodDefinition: [
	        "key",
	        "value"
	    ],
	    NewExpression: [
	        "callee",
	        "arguments"
	    ],
	    ObjectExpression: [
	        "properties"
	    ],
	    ObjectPattern: [
	        "properties"
	    ],
	    PrivateIdentifier: [],
	    Program: [
	        "body"
	    ],
	    Property: [
	        "key",
	        "value"
	    ],
	    PropertyDefinition: [
	        "key",
	        "value"
	    ],
	    RestElement: [
	        "argument"
	    ],
	    ReturnStatement: [
	        "argument"
	    ],
	    SequenceExpression: [
	        "expressions"
	    ],
	    SpreadElement: [
	        "argument"
	    ],
	    StaticBlock: [
	        "body"
	    ],
	    Super: [],
	    SwitchCase: [
	        "test",
	        "consequent"
	    ],
	    SwitchStatement: [
	        "discriminant",
	        "cases"
	    ],
	    TaggedTemplateExpression: [
	        "tag",
	        "quasi"
	    ],
	    TemplateElement: [],
	    TemplateLiteral: [
	        "quasis",
	        "expressions"
	    ],
	    ThisExpression: [],
	    ThrowStatement: [
	        "argument"
	    ],
	    TryStatement: [
	        "block",
	        "handler",
	        "finalizer"
	    ],
	    UnaryExpression: [
	        "argument"
	    ],
	    UpdateExpression: [
	        "argument"
	    ],
	    VariableDeclaration: [
	        "declarations"
	    ],
	    VariableDeclarator: [
	        "id",
	        "init"
	    ],
	    WhileStatement: [
	        "test",
	        "body"
	    ],
	    WithStatement: [
	        "object",
	        "body"
	    ],
	    YieldExpression: [
	        "argument"
	    ]
	};

	// Types.
	const NODE_TYPES = Object.keys(KEYS);

	// Freeze the keys.
	for (const type of NODE_TYPES) {
	    Object.freeze(KEYS[type]);
	}
	Object.freeze(KEYS);

	/**
	 * @author Toru Nagashima <https://github.com/mysticatea>
	 * See LICENSE file in root directory for full license.
	 */

	/**
	 * @typedef {import('./visitor-keys.js').VisitorKeys} VisitorKeys
	 */

	// List to ignore keys.
	const KEY_BLACKLIST = new Set([
	    "parent",
	    "leadingComments",
	    "trailingComments"
	]);

	/**
	 * Check whether a given key should be used or not.
	 * @param {string} key The key to check.
	 * @returns {boolean} `true` if the key should be used.
	 */
	function filterKey(key) {
	    return !KEY_BLACKLIST.has(key) && key[0] !== "_";
	}


	/* eslint-disable jsdoc/valid-types -- doesn't allow `readonly`.
	   TODO: remove eslint-disable when https://github.com/jsdoc-type-pratt-parser/jsdoc-type-pratt-parser/issues/164 is fixed
	*/
	/**
	 * Get visitor keys of a given node.
	 * @param {Object} node The AST node to get keys.
	 * @returns {readonly string[]} Visitor keys of the node.
	 */
	function getKeys(node) {
	    return Object.keys(node).filter(filterKey);
	}
	/* eslint-enable jsdoc/valid-types -- doesn't allow `readonly` */

	/**
	 * Make the union set with `KEYS` and given keys.
	 * @param {VisitorKeys} additionalKeys The additional keys.
	 * @returns {VisitorKeys} The union set.
	 */
	function unionWith(additionalKeys) {
	    const retv = /** @type {{ [type: string]: ReadonlyArray<string> }} */
	        (Object.assign({}, KEYS));

	    for (const type of Object.keys(additionalKeys)) {
	        if (Object.hasOwn(retv, type)) {
	            const keys = new Set(additionalKeys[type]);

	            for (const key of retv[type]) {
	                keys.add(key);
	            }

	            retv[type] = Object.freeze(Array.from(keys));
	        } else {
	            retv[type] = Object.freeze(Array.from(additionalKeys[type]));
	        }
	    }

	    return Object.freeze(retv);
	}

	eslintVisitorKeys$2.KEYS = KEYS;
	eslintVisitorKeys$2.getKeys = getKeys;
	eslintVisitorKeys$2.unionWith = unionWith;
	return eslintVisitorKeys$2;
}

var espree = {};

var acorn = {exports: {}};

var hasRequiredAcorn;

function requireAcorn () {
	if (hasRequiredAcorn) return acorn.exports;
	hasRequiredAcorn = 1;
	(function (module, exports) {
		(function (global, factory) {
		  factory(exports) ;
		})(this, (function (exports) {
		  // This file was generated. Do not modify manually!
		  var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 7, 9, 32, 4, 318, 1, 80, 3, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 68, 8, 2, 0, 3, 0, 2, 3, 2, 4, 2, 0, 15, 1, 83, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 7, 19, 58, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 343, 9, 54, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 10, 5350, 0, 7, 14, 11465, 27, 2343, 9, 87, 9, 39, 4, 60, 6, 26, 9, 535, 9, 470, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4178, 9, 519, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 245, 1, 2, 9, 726, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

		  // This file was generated. Do not modify manually!
		  var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 4, 51, 13, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 39, 27, 10, 22, 251, 41, 7, 1, 17, 2, 60, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 31, 9, 2, 0, 3, 0, 2, 37, 2, 0, 26, 0, 2, 0, 45, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 200, 32, 32, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 26, 3994, 6, 582, 6842, 29, 1763, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 433, 44, 212, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 42, 9, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 229, 29, 3, 0, 496, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];

		  // This file was generated. Do not modify manually!
		  var nonASCIIidentifierChars = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u0897-\u089f\u08ca-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3c\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0cf3\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ece\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u180f-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf-\u1ace\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1dff\u200c\u200d\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\u30fb\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f\uff65";

		  // This file was generated. Do not modify manually!
		  var nonASCIIidentifierStartChars = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u0870-\u0887\u0889-\u088e\u08a0-\u08c9\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c5d\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cdd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u1711\u171f-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4c\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c8a\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7cd\ua7d0\ua7d1\ua7d3\ua7d5-\ua7dc\ua7f2-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";

		  // These are a run-length and offset encoded representation of the
		  // >0xffff code points that are a valid part of identifiers. The
		  // offset starts at 0x10000, and each pair of numbers represents an
		  // offset to the next range, and then a size of the range.

		  // Reserved word lists for various dialects of the language

		  var reservedWords = {
		    3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
		    5: "class enum extends super const export import",
		    6: "enum",
		    strict: "implements interface let package private protected public static yield",
		    strictBind: "eval arguments"
		  };

		  // And the keywords

		  var ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";

		  var keywords$1 = {
		    5: ecma5AndLessKeywords,
		    "5module": ecma5AndLessKeywords + " export import",
		    6: ecma5AndLessKeywords + " const class extends export import super"
		  };

		  var keywordRelationalOperator = /^in(stanceof)?$/;

		  // ## Character categories

		  var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
		  var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");

		  // This has a complexity linear to the value of the code. The
		  // assumption is that looking up astral identifier characters is
		  // rare.
		  function isInAstralSet(code, set) {
		    var pos = 0x10000;
		    for (var i = 0; i < set.length; i += 2) {
		      pos += set[i];
		      if (pos > code) { return false }
		      pos += set[i + 1];
		      if (pos >= code) { return true }
		    }
		    return false
		  }

		  // Test whether a given character code starts an identifier.

		  function isIdentifierStart(code, astral) {
		    if (code < 65) { return code === 36 }
		    if (code < 91) { return true }
		    if (code < 97) { return code === 95 }
		    if (code < 123) { return true }
		    if (code <= 0xffff) { return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code)) }
		    if (astral === false) { return false }
		    return isInAstralSet(code, astralIdentifierStartCodes)
		  }

		  // Test whether a given character is part of an identifier.

		  function isIdentifierChar(code, astral) {
		    if (code < 48) { return code === 36 }
		    if (code < 58) { return true }
		    if (code < 65) { return false }
		    if (code < 91) { return true }
		    if (code < 97) { return code === 95 }
		    if (code < 123) { return true }
		    if (code <= 0xffff) { return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code)) }
		    if (astral === false) { return false }
		    return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes)
		  }

		  // ## Token types

		  // The assignment of fine-grained, information-carrying type objects
		  // allows the tokenizer to store the information it has about a
		  // token in a way that is very cheap for the parser to look up.

		  // All token type variables start with an underscore, to make them
		  // easy to recognize.

		  // The `beforeExpr` property is used to disambiguate between regular
		  // expressions and divisions. It is set on all token types that can
		  // be followed by an expression (thus, a slash after them would be a
		  // regular expression).
		  //
		  // The `startsExpr` property is used to check if the token ends a
		  // `yield` expression. It is set on all token types that either can
		  // directly start an expression (like a quotation mark) or can
		  // continue an expression (like the body of a string).
		  //
		  // `isLoop` marks a keyword as starting a loop, which is important
		  // to know when parsing a label, in order to allow or disallow
		  // continue jumps to that label.

		  var TokenType = function TokenType(label, conf) {
		    if ( conf === void 0 ) conf = {};

		    this.label = label;
		    this.keyword = conf.keyword;
		    this.beforeExpr = !!conf.beforeExpr;
		    this.startsExpr = !!conf.startsExpr;
		    this.isLoop = !!conf.isLoop;
		    this.isAssign = !!conf.isAssign;
		    this.prefix = !!conf.prefix;
		    this.postfix = !!conf.postfix;
		    this.binop = conf.binop || null;
		    this.updateContext = null;
		  };

		  function binop(name, prec) {
		    return new TokenType(name, {beforeExpr: true, binop: prec})
		  }
		  var beforeExpr = {beforeExpr: true}, startsExpr = {startsExpr: true};

		  // Map keyword names to token types.

		  var keywords = {};

		  // Succinct definitions of keyword token types
		  function kw(name, options) {
		    if ( options === void 0 ) options = {};

		    options.keyword = name;
		    return keywords[name] = new TokenType(name, options)
		  }

		  var types$1 = {
		    num: new TokenType("num", startsExpr),
		    regexp: new TokenType("regexp", startsExpr),
		    string: new TokenType("string", startsExpr),
		    name: new TokenType("name", startsExpr),
		    privateId: new TokenType("privateId", startsExpr),
		    eof: new TokenType("eof"),

		    // Punctuation token types.
		    bracketL: new TokenType("[", {beforeExpr: true, startsExpr: true}),
		    bracketR: new TokenType("]"),
		    braceL: new TokenType("{", {beforeExpr: true, startsExpr: true}),
		    braceR: new TokenType("}"),
		    parenL: new TokenType("(", {beforeExpr: true, startsExpr: true}),
		    parenR: new TokenType(")"),
		    comma: new TokenType(",", beforeExpr),
		    semi: new TokenType(";", beforeExpr),
		    colon: new TokenType(":", beforeExpr),
		    dot: new TokenType("."),
		    question: new TokenType("?", beforeExpr),
		    questionDot: new TokenType("?."),
		    arrow: new TokenType("=>", beforeExpr),
		    template: new TokenType("template"),
		    invalidTemplate: new TokenType("invalidTemplate"),
		    ellipsis: new TokenType("...", beforeExpr),
		    backQuote: new TokenType("`", startsExpr),
		    dollarBraceL: new TokenType("${", {beforeExpr: true, startsExpr: true}),

		    // Operators. These carry several kinds of properties to help the
		    // parser use them properly (the presence of these properties is
		    // what categorizes them as operators).
		    //
		    // `binop`, when present, specifies that this operator is a binary
		    // operator, and will refer to its precedence.
		    //
		    // `prefix` and `postfix` mark the operator as a prefix or postfix
		    // unary operator.
		    //
		    // `isAssign` marks all of `=`, `+=`, `-=` etcetera, which act as
		    // binary operators with a very low precedence, that should result
		    // in AssignmentExpression nodes.

		    eq: new TokenType("=", {beforeExpr: true, isAssign: true}),
		    assign: new TokenType("_=", {beforeExpr: true, isAssign: true}),
		    incDec: new TokenType("++/--", {prefix: true, postfix: true, startsExpr: true}),
		    prefix: new TokenType("!/~", {beforeExpr: true, prefix: true, startsExpr: true}),
		    logicalOR: binop("||", 1),
		    logicalAND: binop("&&", 2),
		    bitwiseOR: binop("|", 3),
		    bitwiseXOR: binop("^", 4),
		    bitwiseAND: binop("&", 5),
		    equality: binop("==/!=/===/!==", 6),
		    relational: binop("</>/<=/>=", 7),
		    bitShift: binop("<</>>/>>>", 8),
		    plusMin: new TokenType("+/-", {beforeExpr: true, binop: 9, prefix: true, startsExpr: true}),
		    modulo: binop("%", 10),
		    star: binop("*", 10),
		    slash: binop("/", 10),
		    starstar: new TokenType("**", {beforeExpr: true}),
		    coalesce: binop("??", 1),

		    // Keyword token types.
		    _break: kw("break"),
		    _case: kw("case", beforeExpr),
		    _catch: kw("catch"),
		    _continue: kw("continue"),
		    _debugger: kw("debugger"),
		    _default: kw("default", beforeExpr),
		    _do: kw("do", {isLoop: true, beforeExpr: true}),
		    _else: kw("else", beforeExpr),
		    _finally: kw("finally"),
		    _for: kw("for", {isLoop: true}),
		    _function: kw("function", startsExpr),
		    _if: kw("if"),
		    _return: kw("return", beforeExpr),
		    _switch: kw("switch"),
		    _throw: kw("throw", beforeExpr),
		    _try: kw("try"),
		    _var: kw("var"),
		    _const: kw("const"),
		    _while: kw("while", {isLoop: true}),
		    _with: kw("with"),
		    _new: kw("new", {beforeExpr: true, startsExpr: true}),
		    _this: kw("this", startsExpr),
		    _super: kw("super", startsExpr),
		    _class: kw("class", startsExpr),
		    _extends: kw("extends", beforeExpr),
		    _export: kw("export"),
		    _import: kw("import", startsExpr),
		    _null: kw("null", startsExpr),
		    _true: kw("true", startsExpr),
		    _false: kw("false", startsExpr),
		    _in: kw("in", {beforeExpr: true, binop: 7}),
		    _instanceof: kw("instanceof", {beforeExpr: true, binop: 7}),
		    _typeof: kw("typeof", {beforeExpr: true, prefix: true, startsExpr: true}),
		    _void: kw("void", {beforeExpr: true, prefix: true, startsExpr: true}),
		    _delete: kw("delete", {beforeExpr: true, prefix: true, startsExpr: true})
		  };

		  // Matches a whole line break (where CRLF is considered a single
		  // line break). Used to count lines.

		  var lineBreak = /\r\n?|\n|\u2028|\u2029/;
		  var lineBreakG = new RegExp(lineBreak.source, "g");

		  function isNewLine(code) {
		    return code === 10 || code === 13 || code === 0x2028 || code === 0x2029
		  }

		  function nextLineBreak(code, from, end) {
		    if ( end === void 0 ) end = code.length;

		    for (var i = from; i < end; i++) {
		      var next = code.charCodeAt(i);
		      if (isNewLine(next))
		        { return i < end - 1 && next === 13 && code.charCodeAt(i + 1) === 10 ? i + 2 : i + 1 }
		    }
		    return -1
		  }

		  var nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/;

		  var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;

		  var ref = Object.prototype;
		  var hasOwnProperty = ref.hasOwnProperty;
		  var toString = ref.toString;

		  var hasOwn = Object.hasOwn || (function (obj, propName) { return (
		    hasOwnProperty.call(obj, propName)
		  ); });

		  var isArray = Array.isArray || (function (obj) { return (
		    toString.call(obj) === "[object Array]"
		  ); });

		  var regexpCache = Object.create(null);

		  function wordsRegexp(words) {
		    return regexpCache[words] || (regexpCache[words] = new RegExp("^(?:" + words.replace(/ /g, "|") + ")$"))
		  }

		  function codePointToString(code) {
		    // UTF-16 Decoding
		    if (code <= 0xFFFF) { return String.fromCharCode(code) }
		    code -= 0x10000;
		    return String.fromCharCode((code >> 10) + 0xD800, (code & 1023) + 0xDC00)
		  }

		  var loneSurrogate = /(?:[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/;

		  // These are used when `options.locations` is on, for the
		  // `startLoc` and `endLoc` properties.

		  var Position = function Position(line, col) {
		    this.line = line;
		    this.column = col;
		  };

		  Position.prototype.offset = function offset (n) {
		    return new Position(this.line, this.column + n)
		  };

		  var SourceLocation = function SourceLocation(p, start, end) {
		    this.start = start;
		    this.end = end;
		    if (p.sourceFile !== null) { this.source = p.sourceFile; }
		  };

		  // The `getLineInfo` function is mostly useful when the
		  // `locations` option is off (for performance reasons) and you
		  // want to find the line/column position for a given character
		  // offset. `input` should be the code string that the offset refers
		  // into.

		  function getLineInfo(input, offset) {
		    for (var line = 1, cur = 0;;) {
		      var nextBreak = nextLineBreak(input, cur, offset);
		      if (nextBreak < 0) { return new Position(line, offset - cur) }
		      ++line;
		      cur = nextBreak;
		    }
		  }

		  // A second argument must be given to configure the parser process.
		  // These options are recognized (only `ecmaVersion` is required):

		  var defaultOptions = {
		    // `ecmaVersion` indicates the ECMAScript version to parse. Must be
		    // either 3, 5, 6 (or 2015), 7 (2016), 8 (2017), 9 (2018), 10
		    // (2019), 11 (2020), 12 (2021), 13 (2022), 14 (2023), or `"latest"`
		    // (the latest version the library supports). This influences
		    // support for strict mode, the set of reserved words, and support
		    // for new syntax features.
		    ecmaVersion: null,
		    // `sourceType` indicates the mode the code should be parsed in.
		    // Can be either `"script"` or `"module"`. This influences global
		    // strict mode and parsing of `import` and `export` declarations.
		    sourceType: "script",
		    // `onInsertedSemicolon` can be a callback that will be called when
		    // a semicolon is automatically inserted. It will be passed the
		    // position of the inserted semicolon as an offset, and if
		    // `locations` is enabled, it is given the location as a `{line,
		    // column}` object as second argument.
		    onInsertedSemicolon: null,
		    // `onTrailingComma` is similar to `onInsertedSemicolon`, but for
		    // trailing commas.
		    onTrailingComma: null,
		    // By default, reserved words are only enforced if ecmaVersion >= 5.
		    // Set `allowReserved` to a boolean value to explicitly turn this on
		    // an off. When this option has the value "never", reserved words
		    // and keywords can also not be used as property names.
		    allowReserved: null,
		    // When enabled, a return at the top level is not considered an
		    // error.
		    allowReturnOutsideFunction: false,
		    // When enabled, import/export statements are not constrained to
		    // appearing at the top of the program, and an import.meta expression
		    // in a script isn't considered an error.
		    allowImportExportEverywhere: false,
		    // By default, await identifiers are allowed to appear at the top-level scope only if ecmaVersion >= 2022.
		    // When enabled, await identifiers are allowed to appear at the top-level scope,
		    // but they are still not allowed in non-async functions.
		    allowAwaitOutsideFunction: null,
		    // When enabled, super identifiers are not constrained to
		    // appearing in methods and do not raise an error when they appear elsewhere.
		    allowSuperOutsideMethod: null,
		    // When enabled, hashbang directive in the beginning of file is
		    // allowed and treated as a line comment. Enabled by default when
		    // `ecmaVersion` >= 2023.
		    allowHashBang: false,
		    // By default, the parser will verify that private properties are
		    // only used in places where they are valid and have been declared.
		    // Set this to false to turn such checks off.
		    checkPrivateFields: true,
		    // When `locations` is on, `loc` properties holding objects with
		    // `start` and `end` properties in `{line, column}` form (with
		    // line being 1-based and column 0-based) will be attached to the
		    // nodes.
		    locations: false,
		    // A function can be passed as `onToken` option, which will
		    // cause Acorn to call that function with object in the same
		    // format as tokens returned from `tokenizer().getToken()`. Note
		    // that you are not allowed to call the parser from the
		    // callback—that will corrupt its internal state.
		    onToken: null,
		    // A function can be passed as `onComment` option, which will
		    // cause Acorn to call that function with `(block, text, start,
		    // end)` parameters whenever a comment is skipped. `block` is a
		    // boolean indicating whether this is a block (`/* */`) comment,
		    // `text` is the content of the comment, and `start` and `end` are
		    // character offsets that denote the start and end of the comment.
		    // When the `locations` option is on, two more parameters are
		    // passed, the full `{line, column}` locations of the start and
		    // end of the comments. Note that you are not allowed to call the
		    // parser from the callback—that will corrupt its internal state.
		    // When this option has an array as value, objects representing the
		    // comments are pushed to it.
		    onComment: null,
		    // Nodes have their start and end characters offsets recorded in
		    // `start` and `end` properties (directly on the node, rather than
		    // the `loc` object, which holds line/column data. To also add a
		    // [semi-standardized][range] `range` property holding a `[start,
		    // end]` array with the same numbers, set the `ranges` option to
		    // `true`.
		    //
		    // [range]: https://bugzilla.mozilla.org/show_bug.cgi?id=745678
		    ranges: false,
		    // It is possible to parse multiple files into a single AST by
		    // passing the tree produced by parsing the first file as
		    // `program` option in subsequent parses. This will add the
		    // toplevel forms of the parsed file to the `Program` (top) node
		    // of an existing parse tree.
		    program: null,
		    // When `locations` is on, you can pass this to record the source
		    // file in every node's `loc` object.
		    sourceFile: null,
		    // This value, if given, is stored in every node, whether
		    // `locations` is on or off.
		    directSourceFile: null,
		    // When enabled, parenthesized expressions are represented by
		    // (non-standard) ParenthesizedExpression nodes
		    preserveParens: false
		  };

		  // Interpret and default an options object

		  var warnedAboutEcmaVersion = false;

		  function getOptions(opts) {
		    var options = {};

		    for (var opt in defaultOptions)
		      { options[opt] = opts && hasOwn(opts, opt) ? opts[opt] : defaultOptions[opt]; }

		    if (options.ecmaVersion === "latest") {
		      options.ecmaVersion = 1e8;
		    } else if (options.ecmaVersion == null) {
		      if (!warnedAboutEcmaVersion && typeof console === "object" && console.warn) {
		        warnedAboutEcmaVersion = true;
		        console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.");
		      }
		      options.ecmaVersion = 11;
		    } else if (options.ecmaVersion >= 2015) {
		      options.ecmaVersion -= 2009;
		    }

		    if (options.allowReserved == null)
		      { options.allowReserved = options.ecmaVersion < 5; }

		    if (!opts || opts.allowHashBang == null)
		      { options.allowHashBang = options.ecmaVersion >= 14; }

		    if (isArray(options.onToken)) {
		      var tokens = options.onToken;
		      options.onToken = function (token) { return tokens.push(token); };
		    }
		    if (isArray(options.onComment))
		      { options.onComment = pushComment(options, options.onComment); }

		    return options
		  }

		  function pushComment(options, array) {
		    return function(block, text, start, end, startLoc, endLoc) {
		      var comment = {
		        type: block ? "Block" : "Line",
		        value: text,
		        start: start,
		        end: end
		      };
		      if (options.locations)
		        { comment.loc = new SourceLocation(this, startLoc, endLoc); }
		      if (options.ranges)
		        { comment.range = [start, end]; }
		      array.push(comment);
		    }
		  }

		  // Each scope gets a bitset that may contain these flags
		  var
		      SCOPE_TOP = 1,
		      SCOPE_FUNCTION = 2,
		      SCOPE_ASYNC = 4,
		      SCOPE_GENERATOR = 8,
		      SCOPE_ARROW = 16,
		      SCOPE_SIMPLE_CATCH = 32,
		      SCOPE_SUPER = 64,
		      SCOPE_DIRECT_SUPER = 128,
		      SCOPE_CLASS_STATIC_BLOCK = 256,
		      SCOPE_VAR = SCOPE_TOP | SCOPE_FUNCTION | SCOPE_CLASS_STATIC_BLOCK;

		  function functionFlags(async, generator) {
		    return SCOPE_FUNCTION | (async ? SCOPE_ASYNC : 0) | (generator ? SCOPE_GENERATOR : 0)
		  }

		  // Used in checkLVal* and declareName to determine the type of a binding
		  var
		      BIND_NONE = 0, // Not a binding
		      BIND_VAR = 1, // Var-style binding
		      BIND_LEXICAL = 2, // Let- or const-style binding
		      BIND_FUNCTION = 3, // Function declaration
		      BIND_SIMPLE_CATCH = 4, // Simple (identifier pattern) catch binding
		      BIND_OUTSIDE = 5; // Special case for function names as bound inside the function

		  var Parser = function Parser(options, input, startPos) {
		    this.options = options = getOptions(options);
		    this.sourceFile = options.sourceFile;
		    this.keywords = wordsRegexp(keywords$1[options.ecmaVersion >= 6 ? 6 : options.sourceType === "module" ? "5module" : 5]);
		    var reserved = "";
		    if (options.allowReserved !== true) {
		      reserved = reservedWords[options.ecmaVersion >= 6 ? 6 : options.ecmaVersion === 5 ? 5 : 3];
		      if (options.sourceType === "module") { reserved += " await"; }
		    }
		    this.reservedWords = wordsRegexp(reserved);
		    var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
		    this.reservedWordsStrict = wordsRegexp(reservedStrict);
		    this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords.strictBind);
		    this.input = String(input);

		    // Used to signal to callers of `readWord1` whether the word
		    // contained any escape sequences. This is needed because words with
		    // escape sequences must not be interpreted as keywords.
		    this.containsEsc = false;

		    // Set up token state

		    // The current position of the tokenizer in the input.
		    if (startPos) {
		      this.pos = startPos;
		      this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
		      this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
		    } else {
		      this.pos = this.lineStart = 0;
		      this.curLine = 1;
		    }

		    // Properties of the current token:
		    // Its type
		    this.type = types$1.eof;
		    // For tokens that include more information than their type, the value
		    this.value = null;
		    // Its start and end offset
		    this.start = this.end = this.pos;
		    // And, if locations are used, the {line, column} object
		    // corresponding to those offsets
		    this.startLoc = this.endLoc = this.curPosition();

		    // Position information for the previous token
		    this.lastTokEndLoc = this.lastTokStartLoc = null;
		    this.lastTokStart = this.lastTokEnd = this.pos;

		    // The context stack is used to superficially track syntactic
		    // context to predict whether a regular expression is allowed in a
		    // given position.
		    this.context = this.initialContext();
		    this.exprAllowed = true;

		    // Figure out if it's a module code.
		    this.inModule = options.sourceType === "module";
		    this.strict = this.inModule || this.strictDirective(this.pos);

		    // Used to signify the start of a potential arrow function
		    this.potentialArrowAt = -1;
		    this.potentialArrowInForAwait = false;

		    // Positions to delayed-check that yield/await does not exist in default parameters.
		    this.yieldPos = this.awaitPos = this.awaitIdentPos = 0;
		    // Labels in scope.
		    this.labels = [];
		    // Thus-far undefined exports.
		    this.undefinedExports = Object.create(null);

		    // If enabled, skip leading hashbang line.
		    if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!")
		      { this.skipLineComment(2); }

		    // Scope tracking for duplicate variable names (see scope.js)
		    this.scopeStack = [];
		    this.enterScope(SCOPE_TOP);

		    // For RegExp validation
		    this.regexpState = null;

		    // The stack of private names.
		    // Each element has two properties: 'declared' and 'used'.
		    // When it exited from the outermost class definition, all used private names must be declared.
		    this.privateNameStack = [];
		  };

		  var prototypeAccessors = { inFunction: { configurable: true },inGenerator: { configurable: true },inAsync: { configurable: true },canAwait: { configurable: true },allowSuper: { configurable: true },allowDirectSuper: { configurable: true },treatFunctionsAsVar: { configurable: true },allowNewDotTarget: { configurable: true },inClassStaticBlock: { configurable: true } };

		  Parser.prototype.parse = function parse () {
		    var node = this.options.program || this.startNode();
		    this.nextToken();
		    return this.parseTopLevel(node)
		  };

		  prototypeAccessors.inFunction.get = function () { return (this.currentVarScope().flags & SCOPE_FUNCTION) > 0 };

		  prototypeAccessors.inGenerator.get = function () { return (this.currentVarScope().flags & SCOPE_GENERATOR) > 0 && !this.currentVarScope().inClassFieldInit };

		  prototypeAccessors.inAsync.get = function () { return (this.currentVarScope().flags & SCOPE_ASYNC) > 0 && !this.currentVarScope().inClassFieldInit };

		  prototypeAccessors.canAwait.get = function () {
		    for (var i = this.scopeStack.length - 1; i >= 0; i--) {
		      var scope = this.scopeStack[i];
		      if (scope.inClassFieldInit || scope.flags & SCOPE_CLASS_STATIC_BLOCK) { return false }
		      if (scope.flags & SCOPE_FUNCTION) { return (scope.flags & SCOPE_ASYNC) > 0 }
		    }
		    return (this.inModule && this.options.ecmaVersion >= 13) || this.options.allowAwaitOutsideFunction
		  };

		  prototypeAccessors.allowSuper.get = function () {
		    var ref = this.currentThisScope();
		      var flags = ref.flags;
		      var inClassFieldInit = ref.inClassFieldInit;
		    return (flags & SCOPE_SUPER) > 0 || inClassFieldInit || this.options.allowSuperOutsideMethod
		  };

		  prototypeAccessors.allowDirectSuper.get = function () { return (this.currentThisScope().flags & SCOPE_DIRECT_SUPER) > 0 };

		  prototypeAccessors.treatFunctionsAsVar.get = function () { return this.treatFunctionsAsVarInScope(this.currentScope()) };

		  prototypeAccessors.allowNewDotTarget.get = function () {
		    var ref = this.currentThisScope();
		      var flags = ref.flags;
		      var inClassFieldInit = ref.inClassFieldInit;
		    return (flags & (SCOPE_FUNCTION | SCOPE_CLASS_STATIC_BLOCK)) > 0 || inClassFieldInit
		  };

		  prototypeAccessors.inClassStaticBlock.get = function () {
		    return (this.currentVarScope().flags & SCOPE_CLASS_STATIC_BLOCK) > 0
		  };

		  Parser.extend = function extend () {
		      var plugins = [], len = arguments.length;
		      while ( len-- ) plugins[ len ] = arguments[ len ];

		    var cls = this;
		    for (var i = 0; i < plugins.length; i++) { cls = plugins[i](cls); }
		    return cls
		  };

		  Parser.parse = function parse (input, options) {
		    return new this(options, input).parse()
		  };

		  Parser.parseExpressionAt = function parseExpressionAt (input, pos, options) {
		    var parser = new this(options, input, pos);
		    parser.nextToken();
		    return parser.parseExpression()
		  };

		  Parser.tokenizer = function tokenizer (input, options) {
		    return new this(options, input)
		  };

		  Object.defineProperties( Parser.prototype, prototypeAccessors );

		  var pp$9 = Parser.prototype;

		  // ## Parser utilities

		  var literal = /^(?:'((?:\\[^]|[^'\\])*?)'|"((?:\\[^]|[^"\\])*?)")/;
		  pp$9.strictDirective = function(start) {
		    if (this.options.ecmaVersion < 5) { return false }
		    for (;;) {
		      // Try to find string literal.
		      skipWhiteSpace.lastIndex = start;
		      start += skipWhiteSpace.exec(this.input)[0].length;
		      var match = literal.exec(this.input.slice(start));
		      if (!match) { return false }
		      if ((match[1] || match[2]) === "use strict") {
		        skipWhiteSpace.lastIndex = start + match[0].length;
		        var spaceAfter = skipWhiteSpace.exec(this.input), end = spaceAfter.index + spaceAfter[0].length;
		        var next = this.input.charAt(end);
		        return next === ";" || next === "}" ||
		          (lineBreak.test(spaceAfter[0]) &&
		           !(/[(`.[+\-/*%<>=,?^&]/.test(next) || next === "!" && this.input.charAt(end + 1) === "="))
		      }
		      start += match[0].length;

		      // Skip semicolon, if any.
		      skipWhiteSpace.lastIndex = start;
		      start += skipWhiteSpace.exec(this.input)[0].length;
		      if (this.input[start] === ";")
		        { start++; }
		    }
		  };

		  // Predicate that tests whether the next token is of the given
		  // type, and if yes, consumes it as a side effect.

		  pp$9.eat = function(type) {
		    if (this.type === type) {
		      this.next();
		      return true
		    } else {
		      return false
		    }
		  };

		  // Tests whether parsed token is a contextual keyword.

		  pp$9.isContextual = function(name) {
		    return this.type === types$1.name && this.value === name && !this.containsEsc
		  };

		  // Consumes contextual keyword if possible.

		  pp$9.eatContextual = function(name) {
		    if (!this.isContextual(name)) { return false }
		    this.next();
		    return true
		  };

		  // Asserts that following token is given contextual keyword.

		  pp$9.expectContextual = function(name) {
		    if (!this.eatContextual(name)) { this.unexpected(); }
		  };

		  // Test whether a semicolon can be inserted at the current position.

		  pp$9.canInsertSemicolon = function() {
		    return this.type === types$1.eof ||
		      this.type === types$1.braceR ||
		      lineBreak.test(this.input.slice(this.lastTokEnd, this.start))
		  };

		  pp$9.insertSemicolon = function() {
		    if (this.canInsertSemicolon()) {
		      if (this.options.onInsertedSemicolon)
		        { this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc); }
		      return true
		    }
		  };

		  // Consume a semicolon, or, failing that, see if we are allowed to
		  // pretend that there is a semicolon at this position.

		  pp$9.semicolon = function() {
		    if (!this.eat(types$1.semi) && !this.insertSemicolon()) { this.unexpected(); }
		  };

		  pp$9.afterTrailingComma = function(tokType, notNext) {
		    if (this.type === tokType) {
		      if (this.options.onTrailingComma)
		        { this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc); }
		      if (!notNext)
		        { this.next(); }
		      return true
		    }
		  };

		  // Expect a token of a given type. If found, consume it, otherwise,
		  // raise an unexpected token error.

		  pp$9.expect = function(type) {
		    this.eat(type) || this.unexpected();
		  };

		  // Raise an unexpected token error.

		  pp$9.unexpected = function(pos) {
		    this.raise(pos != null ? pos : this.start, "Unexpected token");
		  };

		  var DestructuringErrors = function DestructuringErrors() {
		    this.shorthandAssign =
		    this.trailingComma =
		    this.parenthesizedAssign =
		    this.parenthesizedBind =
		    this.doubleProto =
		      -1;
		  };

		  pp$9.checkPatternErrors = function(refDestructuringErrors, isAssign) {
		    if (!refDestructuringErrors) { return }
		    if (refDestructuringErrors.trailingComma > -1)
		      { this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element"); }
		    var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
		    if (parens > -1) { this.raiseRecoverable(parens, isAssign ? "Assigning to rvalue" : "Parenthesized pattern"); }
		  };

		  pp$9.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
		    if (!refDestructuringErrors) { return false }
		    var shorthandAssign = refDestructuringErrors.shorthandAssign;
		    var doubleProto = refDestructuringErrors.doubleProto;
		    if (!andThrow) { return shorthandAssign >= 0 || doubleProto >= 0 }
		    if (shorthandAssign >= 0)
		      { this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns"); }
		    if (doubleProto >= 0)
		      { this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property"); }
		  };

		  pp$9.checkYieldAwaitInDefaultParams = function() {
		    if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos))
		      { this.raise(this.yieldPos, "Yield expression cannot be a default value"); }
		    if (this.awaitPos)
		      { this.raise(this.awaitPos, "Await expression cannot be a default value"); }
		  };

		  pp$9.isSimpleAssignTarget = function(expr) {
		    if (expr.type === "ParenthesizedExpression")
		      { return this.isSimpleAssignTarget(expr.expression) }
		    return expr.type === "Identifier" || expr.type === "MemberExpression"
		  };

		  var pp$8 = Parser.prototype;

		  // ### Statement parsing

		  // Parse a program. Initializes the parser, reads any number of
		  // statements, and wraps them in a Program node.  Optionally takes a
		  // `program` argument.  If present, the statements will be appended
		  // to its body instead of creating a new node.

		  pp$8.parseTopLevel = function(node) {
		    var exports = Object.create(null);
		    if (!node.body) { node.body = []; }
		    while (this.type !== types$1.eof) {
		      var stmt = this.parseStatement(null, true, exports);
		      node.body.push(stmt);
		    }
		    if (this.inModule)
		      { for (var i = 0, list = Object.keys(this.undefinedExports); i < list.length; i += 1)
		        {
		          var name = list[i];

		          this.raiseRecoverable(this.undefinedExports[name].start, ("Export '" + name + "' is not defined"));
		        } }
		    this.adaptDirectivePrologue(node.body);
		    this.next();
		    node.sourceType = this.options.sourceType;
		    return this.finishNode(node, "Program")
		  };

		  var loopLabel = {kind: "loop"}, switchLabel = {kind: "switch"};

		  pp$8.isLet = function(context) {
		    if (this.options.ecmaVersion < 6 || !this.isContextual("let")) { return false }
		    skipWhiteSpace.lastIndex = this.pos;
		    var skip = skipWhiteSpace.exec(this.input);
		    var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
		    // For ambiguous cases, determine if a LexicalDeclaration (or only a
		    // Statement) is allowed here. If context is not empty then only a Statement
		    // is allowed. However, `let [` is an explicit negative lookahead for
		    // ExpressionStatement, so special-case it first.
		    if (nextCh === 91 || nextCh === 92) { return true } // '[', '\'
		    if (context) { return false }

		    if (nextCh === 123 || nextCh > 0xd7ff && nextCh < 0xdc00) { return true } // '{', astral
		    if (isIdentifierStart(nextCh, true)) {
		      var pos = next + 1;
		      while (isIdentifierChar(nextCh = this.input.charCodeAt(pos), true)) { ++pos; }
		      if (nextCh === 92 || nextCh > 0xd7ff && nextCh < 0xdc00) { return true }
		      var ident = this.input.slice(next, pos);
		      if (!keywordRelationalOperator.test(ident)) { return true }
		    }
		    return false
		  };

		  // check 'async [no LineTerminator here] function'
		  // - 'async /*foo*/ function' is OK.
		  // - 'async /*\n*/ function' is invalid.
		  pp$8.isAsyncFunction = function() {
		    if (this.options.ecmaVersion < 8 || !this.isContextual("async"))
		      { return false }

		    skipWhiteSpace.lastIndex = this.pos;
		    var skip = skipWhiteSpace.exec(this.input);
		    var next = this.pos + skip[0].length, after;
		    return !lineBreak.test(this.input.slice(this.pos, next)) &&
		      this.input.slice(next, next + 8) === "function" &&
		      (next + 8 === this.input.length ||
		       !(isIdentifierChar(after = this.input.charCodeAt(next + 8)) || after > 0xd7ff && after < 0xdc00))
		  };

		  // Parse a single statement.
		  //
		  // If expecting a statement and finding a slash operator, parse a
		  // regular expression literal. This is to handle cases like
		  // `if (foo) /blah/.exec(foo)`, where looking at the previous token
		  // does not help.

		  pp$8.parseStatement = function(context, topLevel, exports) {
		    var starttype = this.type, node = this.startNode(), kind;

		    if (this.isLet(context)) {
		      starttype = types$1._var;
		      kind = "let";
		    }

		    // Most types of statements are recognized by the keyword they
		    // start with. Many are trivial to parse, some require a bit of
		    // complexity.

		    switch (starttype) {
		    case types$1._break: case types$1._continue: return this.parseBreakContinueStatement(node, starttype.keyword)
		    case types$1._debugger: return this.parseDebuggerStatement(node)
		    case types$1._do: return this.parseDoStatement(node)
		    case types$1._for: return this.parseForStatement(node)
		    case types$1._function:
		      // Function as sole body of either an if statement or a labeled statement
		      // works, but not when it is part of a labeled statement that is the sole
		      // body of an if statement.
		      if ((context && (this.strict || context !== "if" && context !== "label")) && this.options.ecmaVersion >= 6) { this.unexpected(); }
		      return this.parseFunctionStatement(node, false, !context)
		    case types$1._class:
		      if (context) { this.unexpected(); }
		      return this.parseClass(node, true)
		    case types$1._if: return this.parseIfStatement(node)
		    case types$1._return: return this.parseReturnStatement(node)
		    case types$1._switch: return this.parseSwitchStatement(node)
		    case types$1._throw: return this.parseThrowStatement(node)
		    case types$1._try: return this.parseTryStatement(node)
		    case types$1._const: case types$1._var:
		      kind = kind || this.value;
		      if (context && kind !== "var") { this.unexpected(); }
		      return this.parseVarStatement(node, kind)
		    case types$1._while: return this.parseWhileStatement(node)
		    case types$1._with: return this.parseWithStatement(node)
		    case types$1.braceL: return this.parseBlock(true, node)
		    case types$1.semi: return this.parseEmptyStatement(node)
		    case types$1._export:
		    case types$1._import:
		      if (this.options.ecmaVersion > 10 && starttype === types$1._import) {
		        skipWhiteSpace.lastIndex = this.pos;
		        var skip = skipWhiteSpace.exec(this.input);
		        var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
		        if (nextCh === 40 || nextCh === 46) // '(' or '.'
		          { return this.parseExpressionStatement(node, this.parseExpression()) }
		      }

		      if (!this.options.allowImportExportEverywhere) {
		        if (!topLevel)
		          { this.raise(this.start, "'import' and 'export' may only appear at the top level"); }
		        if (!this.inModule)
		          { this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'"); }
		      }
		      return starttype === types$1._import ? this.parseImport(node) : this.parseExport(node, exports)

		      // If the statement does not start with a statement keyword or a
		      // brace, it's an ExpressionStatement or LabeledStatement. We
		      // simply start parsing an expression, and afterwards, if the
		      // next token is a colon and the expression was a simple
		      // Identifier node, we switch to interpreting it as a label.
		    default:
		      if (this.isAsyncFunction()) {
		        if (context) { this.unexpected(); }
		        this.next();
		        return this.parseFunctionStatement(node, true, !context)
		      }

		      var maybeName = this.value, expr = this.parseExpression();
		      if (starttype === types$1.name && expr.type === "Identifier" && this.eat(types$1.colon))
		        { return this.parseLabeledStatement(node, maybeName, expr, context) }
		      else { return this.parseExpressionStatement(node, expr) }
		    }
		  };

		  pp$8.parseBreakContinueStatement = function(node, keyword) {
		    var isBreak = keyword === "break";
		    this.next();
		    if (this.eat(types$1.semi) || this.insertSemicolon()) { node.label = null; }
		    else if (this.type !== types$1.name) { this.unexpected(); }
		    else {
		      node.label = this.parseIdent();
		      this.semicolon();
		    }

		    // Verify that there is an actual destination to break or
		    // continue to.
		    var i = 0;
		    for (; i < this.labels.length; ++i) {
		      var lab = this.labels[i];
		      if (node.label == null || lab.name === node.label.name) {
		        if (lab.kind != null && (isBreak || lab.kind === "loop")) { break }
		        if (node.label && isBreak) { break }
		      }
		    }
		    if (i === this.labels.length) { this.raise(node.start, "Unsyntactic " + keyword); }
		    return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement")
		  };

		  pp$8.parseDebuggerStatement = function(node) {
		    this.next();
		    this.semicolon();
		    return this.finishNode(node, "DebuggerStatement")
		  };

		  pp$8.parseDoStatement = function(node) {
		    this.next();
		    this.labels.push(loopLabel);
		    node.body = this.parseStatement("do");
		    this.labels.pop();
		    this.expect(types$1._while);
		    node.test = this.parseParenExpression();
		    if (this.options.ecmaVersion >= 6)
		      { this.eat(types$1.semi); }
		    else
		      { this.semicolon(); }
		    return this.finishNode(node, "DoWhileStatement")
		  };

		  // Disambiguating between a `for` and a `for`/`in` or `for`/`of`
		  // loop is non-trivial. Basically, we have to parse the init `var`
		  // statement or expression, disallowing the `in` operator (see
		  // the second parameter to `parseExpression`), and then check
		  // whether the next token is `in` or `of`. When there is no init
		  // part (semicolon immediately after the opening parenthesis), it
		  // is a regular `for` loop.

		  pp$8.parseForStatement = function(node) {
		    this.next();
		    var awaitAt = (this.options.ecmaVersion >= 9 && this.canAwait && this.eatContextual("await")) ? this.lastTokStart : -1;
		    this.labels.push(loopLabel);
		    this.enterScope(0);
		    this.expect(types$1.parenL);
		    if (this.type === types$1.semi) {
		      if (awaitAt > -1) { this.unexpected(awaitAt); }
		      return this.parseFor(node, null)
		    }
		    var isLet = this.isLet();
		    if (this.type === types$1._var || this.type === types$1._const || isLet) {
		      var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
		      this.next();
		      this.parseVar(init$1, true, kind);
		      this.finishNode(init$1, "VariableDeclaration");
		      if ((this.type === types$1._in || (this.options.ecmaVersion >= 6 && this.isContextual("of"))) && init$1.declarations.length === 1) {
		        if (this.options.ecmaVersion >= 9) {
		          if (this.type === types$1._in) {
		            if (awaitAt > -1) { this.unexpected(awaitAt); }
		          } else { node.await = awaitAt > -1; }
		        }
		        return this.parseForIn(node, init$1)
		      }
		      if (awaitAt > -1) { this.unexpected(awaitAt); }
		      return this.parseFor(node, init$1)
		    }
		    var startsWithLet = this.isContextual("let"), isForOf = false;
		    var containsEsc = this.containsEsc;
		    var refDestructuringErrors = new DestructuringErrors;
		    var initPos = this.start;
		    var init = awaitAt > -1
		      ? this.parseExprSubscripts(refDestructuringErrors, "await")
		      : this.parseExpression(true, refDestructuringErrors);
		    if (this.type === types$1._in || (isForOf = this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
		      if (awaitAt > -1) { // implies `ecmaVersion >= 9` (see declaration of awaitAt)
		        if (this.type === types$1._in) { this.unexpected(awaitAt); }
		        node.await = true;
		      } else if (isForOf && this.options.ecmaVersion >= 8) {
		        if (init.start === initPos && !containsEsc && init.type === "Identifier" && init.name === "async") { this.unexpected(); }
		        else if (this.options.ecmaVersion >= 9) { node.await = false; }
		      }
		      if (startsWithLet && isForOf) { this.raise(init.start, "The left-hand side of a for-of loop may not start with 'let'."); }
		      this.toAssignable(init, false, refDestructuringErrors);
		      this.checkLValPattern(init);
		      return this.parseForIn(node, init)
		    } else {
		      this.checkExpressionErrors(refDestructuringErrors, true);
		    }
		    if (awaitAt > -1) { this.unexpected(awaitAt); }
		    return this.parseFor(node, init)
		  };

		  pp$8.parseFunctionStatement = function(node, isAsync, declarationPosition) {
		    this.next();
		    return this.parseFunction(node, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync)
		  };

		  pp$8.parseIfStatement = function(node) {
		    this.next();
		    node.test = this.parseParenExpression();
		    // allow function declarations in branches, but only in non-strict mode
		    node.consequent = this.parseStatement("if");
		    node.alternate = this.eat(types$1._else) ? this.parseStatement("if") : null;
		    return this.finishNode(node, "IfStatement")
		  };

		  pp$8.parseReturnStatement = function(node) {
		    if (!this.inFunction && !this.options.allowReturnOutsideFunction)
		      { this.raise(this.start, "'return' outside of function"); }
		    this.next();

		    // In `return` (and `break`/`continue`), the keywords with
		    // optional arguments, we eagerly look for a semicolon or the
		    // possibility to insert one.

		    if (this.eat(types$1.semi) || this.insertSemicolon()) { node.argument = null; }
		    else { node.argument = this.parseExpression(); this.semicolon(); }
		    return this.finishNode(node, "ReturnStatement")
		  };

		  pp$8.parseSwitchStatement = function(node) {
		    this.next();
		    node.discriminant = this.parseParenExpression();
		    node.cases = [];
		    this.expect(types$1.braceL);
		    this.labels.push(switchLabel);
		    this.enterScope(0);

		    // Statements under must be grouped (by label) in SwitchCase
		    // nodes. `cur` is used to keep the node that we are currently
		    // adding statements to.

		    var cur;
		    for (var sawDefault = false; this.type !== types$1.braceR;) {
		      if (this.type === types$1._case || this.type === types$1._default) {
		        var isCase = this.type === types$1._case;
		        if (cur) { this.finishNode(cur, "SwitchCase"); }
		        node.cases.push(cur = this.startNode());
		        cur.consequent = [];
		        this.next();
		        if (isCase) {
		          cur.test = this.parseExpression();
		        } else {
		          if (sawDefault) { this.raiseRecoverable(this.lastTokStart, "Multiple default clauses"); }
		          sawDefault = true;
		          cur.test = null;
		        }
		        this.expect(types$1.colon);
		      } else {
		        if (!cur) { this.unexpected(); }
		        cur.consequent.push(this.parseStatement(null));
		      }
		    }
		    this.exitScope();
		    if (cur) { this.finishNode(cur, "SwitchCase"); }
		    this.next(); // Closing brace
		    this.labels.pop();
		    return this.finishNode(node, "SwitchStatement")
		  };

		  pp$8.parseThrowStatement = function(node) {
		    this.next();
		    if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start)))
		      { this.raise(this.lastTokEnd, "Illegal newline after throw"); }
		    node.argument = this.parseExpression();
		    this.semicolon();
		    return this.finishNode(node, "ThrowStatement")
		  };

		  // Reused empty array added for node fields that are always empty.

		  var empty$1 = [];

		  pp$8.parseCatchClauseParam = function() {
		    var param = this.parseBindingAtom();
		    var simple = param.type === "Identifier";
		    this.enterScope(simple ? SCOPE_SIMPLE_CATCH : 0);
		    this.checkLValPattern(param, simple ? BIND_SIMPLE_CATCH : BIND_LEXICAL);
		    this.expect(types$1.parenR);

		    return param
		  };

		  pp$8.parseTryStatement = function(node) {
		    this.next();
		    node.block = this.parseBlock();
		    node.handler = null;
		    if (this.type === types$1._catch) {
		      var clause = this.startNode();
		      this.next();
		      if (this.eat(types$1.parenL)) {
		        clause.param = this.parseCatchClauseParam();
		      } else {
		        if (this.options.ecmaVersion < 10) { this.unexpected(); }
		        clause.param = null;
		        this.enterScope(0);
		      }
		      clause.body = this.parseBlock(false);
		      this.exitScope();
		      node.handler = this.finishNode(clause, "CatchClause");
		    }
		    node.finalizer = this.eat(types$1._finally) ? this.parseBlock() : null;
		    if (!node.handler && !node.finalizer)
		      { this.raise(node.start, "Missing catch or finally clause"); }
		    return this.finishNode(node, "TryStatement")
		  };

		  pp$8.parseVarStatement = function(node, kind, allowMissingInitializer) {
		    this.next();
		    this.parseVar(node, false, kind, allowMissingInitializer);
		    this.semicolon();
		    return this.finishNode(node, "VariableDeclaration")
		  };

		  pp$8.parseWhileStatement = function(node) {
		    this.next();
		    node.test = this.parseParenExpression();
		    this.labels.push(loopLabel);
		    node.body = this.parseStatement("while");
		    this.labels.pop();
		    return this.finishNode(node, "WhileStatement")
		  };

		  pp$8.parseWithStatement = function(node) {
		    if (this.strict) { this.raise(this.start, "'with' in strict mode"); }
		    this.next();
		    node.object = this.parseParenExpression();
		    node.body = this.parseStatement("with");
		    return this.finishNode(node, "WithStatement")
		  };

		  pp$8.parseEmptyStatement = function(node) {
		    this.next();
		    return this.finishNode(node, "EmptyStatement")
		  };

		  pp$8.parseLabeledStatement = function(node, maybeName, expr, context) {
		    for (var i$1 = 0, list = this.labels; i$1 < list.length; i$1 += 1)
		      {
		      var label = list[i$1];

		      if (label.name === maybeName)
		        { this.raise(expr.start, "Label '" + maybeName + "' is already declared");
		    } }
		    var kind = this.type.isLoop ? "loop" : this.type === types$1._switch ? "switch" : null;
		    for (var i = this.labels.length - 1; i >= 0; i--) {
		      var label$1 = this.labels[i];
		      if (label$1.statementStart === node.start) {
		        // Update information about previous labels on this node
		        label$1.statementStart = this.start;
		        label$1.kind = kind;
		      } else { break }
		    }
		    this.labels.push({name: maybeName, kind: kind, statementStart: this.start});
		    node.body = this.parseStatement(context ? context.indexOf("label") === -1 ? context + "label" : context : "label");
		    this.labels.pop();
		    node.label = expr;
		    return this.finishNode(node, "LabeledStatement")
		  };

		  pp$8.parseExpressionStatement = function(node, expr) {
		    node.expression = expr;
		    this.semicolon();
		    return this.finishNode(node, "ExpressionStatement")
		  };

		  // Parse a semicolon-enclosed block of statements, handling `"use
		  // strict"` declarations when `allowStrict` is true (used for
		  // function bodies).

		  pp$8.parseBlock = function(createNewLexicalScope, node, exitStrict) {
		    if ( createNewLexicalScope === void 0 ) createNewLexicalScope = true;
		    if ( node === void 0 ) node = this.startNode();

		    node.body = [];
		    this.expect(types$1.braceL);
		    if (createNewLexicalScope) { this.enterScope(0); }
		    while (this.type !== types$1.braceR) {
		      var stmt = this.parseStatement(null);
		      node.body.push(stmt);
		    }
		    if (exitStrict) { this.strict = false; }
		    this.next();
		    if (createNewLexicalScope) { this.exitScope(); }
		    return this.finishNode(node, "BlockStatement")
		  };

		  // Parse a regular `for` loop. The disambiguation code in
		  // `parseStatement` will already have parsed the init statement or
		  // expression.

		  pp$8.parseFor = function(node, init) {
		    node.init = init;
		    this.expect(types$1.semi);
		    node.test = this.type === types$1.semi ? null : this.parseExpression();
		    this.expect(types$1.semi);
		    node.update = this.type === types$1.parenR ? null : this.parseExpression();
		    this.expect(types$1.parenR);
		    node.body = this.parseStatement("for");
		    this.exitScope();
		    this.labels.pop();
		    return this.finishNode(node, "ForStatement")
		  };

		  // Parse a `for`/`in` and `for`/`of` loop, which are almost
		  // same from parser's perspective.

		  pp$8.parseForIn = function(node, init) {
		    var isForIn = this.type === types$1._in;
		    this.next();

		    if (
		      init.type === "VariableDeclaration" &&
		      init.declarations[0].init != null &&
		      (
		        !isForIn ||
		        this.options.ecmaVersion < 8 ||
		        this.strict ||
		        init.kind !== "var" ||
		        init.declarations[0].id.type !== "Identifier"
		      )
		    ) {
		      this.raise(
		        init.start,
		        ((isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer")
		      );
		    }
		    node.left = init;
		    node.right = isForIn ? this.parseExpression() : this.parseMaybeAssign();
		    this.expect(types$1.parenR);
		    node.body = this.parseStatement("for");
		    this.exitScope();
		    this.labels.pop();
		    return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement")
		  };

		  // Parse a list of variable declarations.

		  pp$8.parseVar = function(node, isFor, kind, allowMissingInitializer) {
		    node.declarations = [];
		    node.kind = kind;
		    for (;;) {
		      var decl = this.startNode();
		      this.parseVarId(decl, kind);
		      if (this.eat(types$1.eq)) {
		        decl.init = this.parseMaybeAssign(isFor);
		      } else if (!allowMissingInitializer && kind === "const" && !(this.type === types$1._in || (this.options.ecmaVersion >= 6 && this.isContextual("of")))) {
		        this.unexpected();
		      } else if (!allowMissingInitializer && decl.id.type !== "Identifier" && !(isFor && (this.type === types$1._in || this.isContextual("of")))) {
		        this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value");
		      } else {
		        decl.init = null;
		      }
		      node.declarations.push(this.finishNode(decl, "VariableDeclarator"));
		      if (!this.eat(types$1.comma)) { break }
		    }
		    return node
		  };

		  pp$8.parseVarId = function(decl, kind) {
		    decl.id = this.parseBindingAtom();
		    this.checkLValPattern(decl.id, kind === "var" ? BIND_VAR : BIND_LEXICAL, false);
		  };

		  var FUNC_STATEMENT = 1, FUNC_HANGING_STATEMENT = 2, FUNC_NULLABLE_ID = 4;

		  // Parse a function declaration or literal (depending on the
		  // `statement & FUNC_STATEMENT`).

		  // Remove `allowExpressionBody` for 7.0.0, as it is only called with false
		  pp$8.parseFunction = function(node, statement, allowExpressionBody, isAsync, forInit) {
		    this.initFunction(node);
		    if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) {
		      if (this.type === types$1.star && (statement & FUNC_HANGING_STATEMENT))
		        { this.unexpected(); }
		      node.generator = this.eat(types$1.star);
		    }
		    if (this.options.ecmaVersion >= 8)
		      { node.async = !!isAsync; }

		    if (statement & FUNC_STATEMENT) {
		      node.id = (statement & FUNC_NULLABLE_ID) && this.type !== types$1.name ? null : this.parseIdent();
		      if (node.id && !(statement & FUNC_HANGING_STATEMENT))
		        // If it is a regular function declaration in sloppy mode, then it is
		        // subject to Annex B semantics (BIND_FUNCTION). Otherwise, the binding
		        // mode depends on properties of the current scope (see
		        // treatFunctionsAsVar).
		        { this.checkLValSimple(node.id, (this.strict || node.generator || node.async) ? this.treatFunctionsAsVar ? BIND_VAR : BIND_LEXICAL : BIND_FUNCTION); }
		    }

		    var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
		    this.yieldPos = 0;
		    this.awaitPos = 0;
		    this.awaitIdentPos = 0;
		    this.enterScope(functionFlags(node.async, node.generator));

		    if (!(statement & FUNC_STATEMENT))
		      { node.id = this.type === types$1.name ? this.parseIdent() : null; }

		    this.parseFunctionParams(node);
		    this.parseFunctionBody(node, allowExpressionBody, false, forInit);

		    this.yieldPos = oldYieldPos;
		    this.awaitPos = oldAwaitPos;
		    this.awaitIdentPos = oldAwaitIdentPos;
		    return this.finishNode(node, (statement & FUNC_STATEMENT) ? "FunctionDeclaration" : "FunctionExpression")
		  };

		  pp$8.parseFunctionParams = function(node) {
		    this.expect(types$1.parenL);
		    node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
		    this.checkYieldAwaitInDefaultParams();
		  };

		  // Parse a class declaration or literal (depending on the
		  // `isStatement` parameter).

		  pp$8.parseClass = function(node, isStatement) {
		    this.next();

		    // ecma-262 14.6 Class Definitions
		    // A class definition is always strict mode code.
		    var oldStrict = this.strict;
		    this.strict = true;

		    this.parseClassId(node, isStatement);
		    this.parseClassSuper(node);
		    var privateNameMap = this.enterClassBody();
		    var classBody = this.startNode();
		    var hadConstructor = false;
		    classBody.body = [];
		    this.expect(types$1.braceL);
		    while (this.type !== types$1.braceR) {
		      var element = this.parseClassElement(node.superClass !== null);
		      if (element) {
		        classBody.body.push(element);
		        if (element.type === "MethodDefinition" && element.kind === "constructor") {
		          if (hadConstructor) { this.raiseRecoverable(element.start, "Duplicate constructor in the same class"); }
		          hadConstructor = true;
		        } else if (element.key && element.key.type === "PrivateIdentifier" && isPrivateNameConflicted(privateNameMap, element)) {
		          this.raiseRecoverable(element.key.start, ("Identifier '#" + (element.key.name) + "' has already been declared"));
		        }
		      }
		    }
		    this.strict = oldStrict;
		    this.next();
		    node.body = this.finishNode(classBody, "ClassBody");
		    this.exitClassBody();
		    return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression")
		  };

		  pp$8.parseClassElement = function(constructorAllowsSuper) {
		    if (this.eat(types$1.semi)) { return null }

		    var ecmaVersion = this.options.ecmaVersion;
		    var node = this.startNode();
		    var keyName = "";
		    var isGenerator = false;
		    var isAsync = false;
		    var kind = "method";
		    var isStatic = false;

		    if (this.eatContextual("static")) {
		      // Parse static init block
		      if (ecmaVersion >= 13 && this.eat(types$1.braceL)) {
		        this.parseClassStaticBlock(node);
		        return node
		      }
		      if (this.isClassElementNameStart() || this.type === types$1.star) {
		        isStatic = true;
		      } else {
		        keyName = "static";
		      }
		    }
		    node.static = isStatic;
		    if (!keyName && ecmaVersion >= 8 && this.eatContextual("async")) {
		      if ((this.isClassElementNameStart() || this.type === types$1.star) && !this.canInsertSemicolon()) {
		        isAsync = true;
		      } else {
		        keyName = "async";
		      }
		    }
		    if (!keyName && (ecmaVersion >= 9 || !isAsync) && this.eat(types$1.star)) {
		      isGenerator = true;
		    }
		    if (!keyName && !isAsync && !isGenerator) {
		      var lastValue = this.value;
		      if (this.eatContextual("get") || this.eatContextual("set")) {
		        if (this.isClassElementNameStart()) {
		          kind = lastValue;
		        } else {
		          keyName = lastValue;
		        }
		      }
		    }

		    // Parse element name
		    if (keyName) {
		      // 'async', 'get', 'set', or 'static' were not a keyword contextually.
		      // The last token is any of those. Make it the element name.
		      node.computed = false;
		      node.key = this.startNodeAt(this.lastTokStart, this.lastTokStartLoc);
		      node.key.name = keyName;
		      this.finishNode(node.key, "Identifier");
		    } else {
		      this.parseClassElementName(node);
		    }

		    // Parse element value
		    if (ecmaVersion < 13 || this.type === types$1.parenL || kind !== "method" || isGenerator || isAsync) {
		      var isConstructor = !node.static && checkKeyName(node, "constructor");
		      var allowsDirectSuper = isConstructor && constructorAllowsSuper;
		      // Couldn't move this check into the 'parseClassMethod' method for backward compatibility.
		      if (isConstructor && kind !== "method") { this.raise(node.key.start, "Constructor can't have get/set modifier"); }
		      node.kind = isConstructor ? "constructor" : kind;
		      this.parseClassMethod(node, isGenerator, isAsync, allowsDirectSuper);
		    } else {
		      this.parseClassField(node);
		    }

		    return node
		  };

		  pp$8.isClassElementNameStart = function() {
		    return (
		      this.type === types$1.name ||
		      this.type === types$1.privateId ||
		      this.type === types$1.num ||
		      this.type === types$1.string ||
		      this.type === types$1.bracketL ||
		      this.type.keyword
		    )
		  };

		  pp$8.parseClassElementName = function(element) {
		    if (this.type === types$1.privateId) {
		      if (this.value === "constructor") {
		        this.raise(this.start, "Classes can't have an element named '#constructor'");
		      }
		      element.computed = false;
		      element.key = this.parsePrivateIdent();
		    } else {
		      this.parsePropertyName(element);
		    }
		  };

		  pp$8.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
		    // Check key and flags
		    var key = method.key;
		    if (method.kind === "constructor") {
		      if (isGenerator) { this.raise(key.start, "Constructor can't be a generator"); }
		      if (isAsync) { this.raise(key.start, "Constructor can't be an async method"); }
		    } else if (method.static && checkKeyName(method, "prototype")) {
		      this.raise(key.start, "Classes may not have a static property named prototype");
		    }

		    // Parse value
		    var value = method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);

		    // Check value
		    if (method.kind === "get" && value.params.length !== 0)
		      { this.raiseRecoverable(value.start, "getter should have no params"); }
		    if (method.kind === "set" && value.params.length !== 1)
		      { this.raiseRecoverable(value.start, "setter should have exactly one param"); }
		    if (method.kind === "set" && value.params[0].type === "RestElement")
		      { this.raiseRecoverable(value.params[0].start, "Setter cannot use rest params"); }

		    return this.finishNode(method, "MethodDefinition")
		  };

		  pp$8.parseClassField = function(field) {
		    if (checkKeyName(field, "constructor")) {
		      this.raise(field.key.start, "Classes can't have a field named 'constructor'");
		    } else if (field.static && checkKeyName(field, "prototype")) {
		      this.raise(field.key.start, "Classes can't have a static field named 'prototype'");
		    }

		    if (this.eat(types$1.eq)) {
		      // To raise SyntaxError if 'arguments' exists in the initializer.
		      var scope = this.currentThisScope();
		      var inClassFieldInit = scope.inClassFieldInit;
		      scope.inClassFieldInit = true;
		      field.value = this.parseMaybeAssign();
		      scope.inClassFieldInit = inClassFieldInit;
		    } else {
		      field.value = null;
		    }
		    this.semicolon();

		    return this.finishNode(field, "PropertyDefinition")
		  };

		  pp$8.parseClassStaticBlock = function(node) {
		    node.body = [];

		    var oldLabels = this.labels;
		    this.labels = [];
		    this.enterScope(SCOPE_CLASS_STATIC_BLOCK | SCOPE_SUPER);
		    while (this.type !== types$1.braceR) {
		      var stmt = this.parseStatement(null);
		      node.body.push(stmt);
		    }
		    this.next();
		    this.exitScope();
		    this.labels = oldLabels;

		    return this.finishNode(node, "StaticBlock")
		  };

		  pp$8.parseClassId = function(node, isStatement) {
		    if (this.type === types$1.name) {
		      node.id = this.parseIdent();
		      if (isStatement)
		        { this.checkLValSimple(node.id, BIND_LEXICAL, false); }
		    } else {
		      if (isStatement === true)
		        { this.unexpected(); }
		      node.id = null;
		    }
		  };

		  pp$8.parseClassSuper = function(node) {
		    node.superClass = this.eat(types$1._extends) ? this.parseExprSubscripts(null, false) : null;
		  };

		  pp$8.enterClassBody = function() {
		    var element = {declared: Object.create(null), used: []};
		    this.privateNameStack.push(element);
		    return element.declared
		  };

		  pp$8.exitClassBody = function() {
		    var ref = this.privateNameStack.pop();
		    var declared = ref.declared;
		    var used = ref.used;
		    if (!this.options.checkPrivateFields) { return }
		    var len = this.privateNameStack.length;
		    var parent = len === 0 ? null : this.privateNameStack[len - 1];
		    for (var i = 0; i < used.length; ++i) {
		      var id = used[i];
		      if (!hasOwn(declared, id.name)) {
		        if (parent) {
		          parent.used.push(id);
		        } else {
		          this.raiseRecoverable(id.start, ("Private field '#" + (id.name) + "' must be declared in an enclosing class"));
		        }
		      }
		    }
		  };

		  function isPrivateNameConflicted(privateNameMap, element) {
		    var name = element.key.name;
		    var curr = privateNameMap[name];

		    var next = "true";
		    if (element.type === "MethodDefinition" && (element.kind === "get" || element.kind === "set")) {
		      next = (element.static ? "s" : "i") + element.kind;
		    }

		    // `class { get #a(){}; static set #a(_){} }` is also conflict.
		    if (
		      curr === "iget" && next === "iset" ||
		      curr === "iset" && next === "iget" ||
		      curr === "sget" && next === "sset" ||
		      curr === "sset" && next === "sget"
		    ) {
		      privateNameMap[name] = "true";
		      return false
		    } else if (!curr) {
		      privateNameMap[name] = next;
		      return false
		    } else {
		      return true
		    }
		  }

		  function checkKeyName(node, name) {
		    var computed = node.computed;
		    var key = node.key;
		    return !computed && (
		      key.type === "Identifier" && key.name === name ||
		      key.type === "Literal" && key.value === name
		    )
		  }

		  // Parses module export declaration.

		  pp$8.parseExportAllDeclaration = function(node, exports) {
		    if (this.options.ecmaVersion >= 11) {
		      if (this.eatContextual("as")) {
		        node.exported = this.parseModuleExportName();
		        this.checkExport(exports, node.exported, this.lastTokStart);
		      } else {
		        node.exported = null;
		      }
		    }
		    this.expectContextual("from");
		    if (this.type !== types$1.string) { this.unexpected(); }
		    node.source = this.parseExprAtom();
		    if (this.options.ecmaVersion >= 16)
		      { node.attributes = this.parseWithClause(); }
		    this.semicolon();
		    return this.finishNode(node, "ExportAllDeclaration")
		  };

		  pp$8.parseExport = function(node, exports) {
		    this.next();
		    // export * from '...'
		    if (this.eat(types$1.star)) {
		      return this.parseExportAllDeclaration(node, exports)
		    }
		    if (this.eat(types$1._default)) { // export default ...
		      this.checkExport(exports, "default", this.lastTokStart);
		      node.declaration = this.parseExportDefaultDeclaration();
		      return this.finishNode(node, "ExportDefaultDeclaration")
		    }
		    // export var|const|let|function|class ...
		    if (this.shouldParseExportStatement()) {
		      node.declaration = this.parseExportDeclaration(node);
		      if (node.declaration.type === "VariableDeclaration")
		        { this.checkVariableExport(exports, node.declaration.declarations); }
		      else
		        { this.checkExport(exports, node.declaration.id, node.declaration.id.start); }
		      node.specifiers = [];
		      node.source = null;
		    } else { // export { x, y as z } [from '...']
		      node.declaration = null;
		      node.specifiers = this.parseExportSpecifiers(exports);
		      if (this.eatContextual("from")) {
		        if (this.type !== types$1.string) { this.unexpected(); }
		        node.source = this.parseExprAtom();
		        if (this.options.ecmaVersion >= 16)
		          { node.attributes = this.parseWithClause(); }
		      } else {
		        for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
		          // check for keywords used as local names
		          var spec = list[i];

		          this.checkUnreserved(spec.local);
		          // check if export is defined
		          this.checkLocalExport(spec.local);

		          if (spec.local.type === "Literal") {
		            this.raise(spec.local.start, "A string literal cannot be used as an exported binding without `from`.");
		          }
		        }

		        node.source = null;
		      }
		      this.semicolon();
		    }
		    return this.finishNode(node, "ExportNamedDeclaration")
		  };

		  pp$8.parseExportDeclaration = function(node) {
		    return this.parseStatement(null)
		  };

		  pp$8.parseExportDefaultDeclaration = function() {
		    var isAsync;
		    if (this.type === types$1._function || (isAsync = this.isAsyncFunction())) {
		      var fNode = this.startNode();
		      this.next();
		      if (isAsync) { this.next(); }
		      return this.parseFunction(fNode, FUNC_STATEMENT | FUNC_NULLABLE_ID, false, isAsync)
		    } else if (this.type === types$1._class) {
		      var cNode = this.startNode();
		      return this.parseClass(cNode, "nullableID")
		    } else {
		      var declaration = this.parseMaybeAssign();
		      this.semicolon();
		      return declaration
		    }
		  };

		  pp$8.checkExport = function(exports, name, pos) {
		    if (!exports) { return }
		    if (typeof name !== "string")
		      { name = name.type === "Identifier" ? name.name : name.value; }
		    if (hasOwn(exports, name))
		      { this.raiseRecoverable(pos, "Duplicate export '" + name + "'"); }
		    exports[name] = true;
		  };

		  pp$8.checkPatternExport = function(exports, pat) {
		    var type = pat.type;
		    if (type === "Identifier")
		      { this.checkExport(exports, pat, pat.start); }
		    else if (type === "ObjectPattern")
		      { for (var i = 0, list = pat.properties; i < list.length; i += 1)
		        {
		          var prop = list[i];

		          this.checkPatternExport(exports, prop);
		        } }
		    else if (type === "ArrayPattern")
		      { for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
		        var elt = list$1[i$1];

		          if (elt) { this.checkPatternExport(exports, elt); }
		      } }
		    else if (type === "Property")
		      { this.checkPatternExport(exports, pat.value); }
		    else if (type === "AssignmentPattern")
		      { this.checkPatternExport(exports, pat.left); }
		    else if (type === "RestElement")
		      { this.checkPatternExport(exports, pat.argument); }
		  };

		  pp$8.checkVariableExport = function(exports, decls) {
		    if (!exports) { return }
		    for (var i = 0, list = decls; i < list.length; i += 1)
		      {
		      var decl = list[i];

		      this.checkPatternExport(exports, decl.id);
		    }
		  };

		  pp$8.shouldParseExportStatement = function() {
		    return this.type.keyword === "var" ||
		      this.type.keyword === "const" ||
		      this.type.keyword === "class" ||
		      this.type.keyword === "function" ||
		      this.isLet() ||
		      this.isAsyncFunction()
		  };

		  // Parses a comma-separated list of module exports.

		  pp$8.parseExportSpecifier = function(exports) {
		    var node = this.startNode();
		    node.local = this.parseModuleExportName();

		    node.exported = this.eatContextual("as") ? this.parseModuleExportName() : node.local;
		    this.checkExport(
		      exports,
		      node.exported,
		      node.exported.start
		    );

		    return this.finishNode(node, "ExportSpecifier")
		  };

		  pp$8.parseExportSpecifiers = function(exports) {
		    var nodes = [], first = true;
		    // export { x, y as z } [from '...']
		    this.expect(types$1.braceL);
		    while (!this.eat(types$1.braceR)) {
		      if (!first) {
		        this.expect(types$1.comma);
		        if (this.afterTrailingComma(types$1.braceR)) { break }
		      } else { first = false; }

		      nodes.push(this.parseExportSpecifier(exports));
		    }
		    return nodes
		  };

		  // Parses import declaration.

		  pp$8.parseImport = function(node) {
		    this.next();

		    // import '...'
		    if (this.type === types$1.string) {
		      node.specifiers = empty$1;
		      node.source = this.parseExprAtom();
		    } else {
		      node.specifiers = this.parseImportSpecifiers();
		      this.expectContextual("from");
		      node.source = this.type === types$1.string ? this.parseExprAtom() : this.unexpected();
		    }
		    if (this.options.ecmaVersion >= 16)
		      { node.attributes = this.parseWithClause(); }
		    this.semicolon();
		    return this.finishNode(node, "ImportDeclaration")
		  };

		  // Parses a comma-separated list of module imports.

		  pp$8.parseImportSpecifier = function() {
		    var node = this.startNode();
		    node.imported = this.parseModuleExportName();

		    if (this.eatContextual("as")) {
		      node.local = this.parseIdent();
		    } else {
		      this.checkUnreserved(node.imported);
		      node.local = node.imported;
		    }
		    this.checkLValSimple(node.local, BIND_LEXICAL);

		    return this.finishNode(node, "ImportSpecifier")
		  };

		  pp$8.parseImportDefaultSpecifier = function() {
		    // import defaultObj, { x, y as z } from '...'
		    var node = this.startNode();
		    node.local = this.parseIdent();
		    this.checkLValSimple(node.local, BIND_LEXICAL);
		    return this.finishNode(node, "ImportDefaultSpecifier")
		  };

		  pp$8.parseImportNamespaceSpecifier = function() {
		    var node = this.startNode();
		    this.next();
		    this.expectContextual("as");
		    node.local = this.parseIdent();
		    this.checkLValSimple(node.local, BIND_LEXICAL);
		    return this.finishNode(node, "ImportNamespaceSpecifier")
		  };

		  pp$8.parseImportSpecifiers = function() {
		    var nodes = [], first = true;
		    if (this.type === types$1.name) {
		      nodes.push(this.parseImportDefaultSpecifier());
		      if (!this.eat(types$1.comma)) { return nodes }
		    }
		    if (this.type === types$1.star) {
		      nodes.push(this.parseImportNamespaceSpecifier());
		      return nodes
		    }
		    this.expect(types$1.braceL);
		    while (!this.eat(types$1.braceR)) {
		      if (!first) {
		        this.expect(types$1.comma);
		        if (this.afterTrailingComma(types$1.braceR)) { break }
		      } else { first = false; }

		      nodes.push(this.parseImportSpecifier());
		    }
		    return nodes
		  };

		  pp$8.parseWithClause = function() {
		    var nodes = [];
		    if (!this.eat(types$1._with)) {
		      return nodes
		    }
		    this.expect(types$1.braceL);
		    var attributeKeys = {};
		    var first = true;
		    while (!this.eat(types$1.braceR)) {
		      if (!first) {
		        this.expect(types$1.comma);
		        if (this.afterTrailingComma(types$1.braceR)) { break }
		      } else { first = false; }

		      var attr = this.parseImportAttribute();
		      var keyName = attr.key.type === "Identifier" ? attr.key.name : attr.key.value;
		      if (hasOwn(attributeKeys, keyName))
		        { this.raiseRecoverable(attr.key.start, "Duplicate attribute key '" + keyName + "'"); }
		      attributeKeys[keyName] = true;
		      nodes.push(attr);
		    }
		    return nodes
		  };

		  pp$8.parseImportAttribute = function() {
		    var node = this.startNode();
		    node.key = this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
		    this.expect(types$1.colon);
		    if (this.type !== types$1.string) {
		      this.unexpected();
		    }
		    node.value = this.parseExprAtom();
		    return this.finishNode(node, "ImportAttribute")
		  };

		  pp$8.parseModuleExportName = function() {
		    if (this.options.ecmaVersion >= 13 && this.type === types$1.string) {
		      var stringLiteral = this.parseLiteral(this.value);
		      if (loneSurrogate.test(stringLiteral.value)) {
		        this.raise(stringLiteral.start, "An export name cannot include a lone surrogate.");
		      }
		      return stringLiteral
		    }
		    return this.parseIdent(true)
		  };

		  // Set `ExpressionStatement#directive` property for directive prologues.
		  pp$8.adaptDirectivePrologue = function(statements) {
		    for (var i = 0; i < statements.length && this.isDirectiveCandidate(statements[i]); ++i) {
		      statements[i].directive = statements[i].expression.raw.slice(1, -1);
		    }
		  };
		  pp$8.isDirectiveCandidate = function(statement) {
		    return (
		      this.options.ecmaVersion >= 5 &&
		      statement.type === "ExpressionStatement" &&
		      statement.expression.type === "Literal" &&
		      typeof statement.expression.value === "string" &&
		      // Reject parenthesized strings.
		      (this.input[statement.start] === "\"" || this.input[statement.start] === "'")
		    )
		  };

		  var pp$7 = Parser.prototype;

		  // Convert existing expression atom to assignable pattern
		  // if possible.

		  pp$7.toAssignable = function(node, isBinding, refDestructuringErrors) {
		    if (this.options.ecmaVersion >= 6 && node) {
		      switch (node.type) {
		      case "Identifier":
		        if (this.inAsync && node.name === "await")
		          { this.raise(node.start, "Cannot use 'await' as identifier inside an async function"); }
		        break

		      case "ObjectPattern":
		      case "ArrayPattern":
		      case "AssignmentPattern":
		      case "RestElement":
		        break

		      case "ObjectExpression":
		        node.type = "ObjectPattern";
		        if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
		        for (var i = 0, list = node.properties; i < list.length; i += 1) {
		          var prop = list[i];

		        this.toAssignable(prop, isBinding);
		          // Early error:
		          //   AssignmentRestProperty[Yield, Await] :
		          //     `...` DestructuringAssignmentTarget[Yield, Await]
		          //
		          //   It is a Syntax Error if |DestructuringAssignmentTarget| is an |ArrayLiteral| or an |ObjectLiteral|.
		          if (
		            prop.type === "RestElement" &&
		            (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")
		          ) {
		            this.raise(prop.argument.start, "Unexpected token");
		          }
		        }
		        break

		      case "Property":
		        // AssignmentProperty has type === "Property"
		        if (node.kind !== "init") { this.raise(node.key.start, "Object pattern can't contain getter or setter"); }
		        this.toAssignable(node.value, isBinding);
		        break

		      case "ArrayExpression":
		        node.type = "ArrayPattern";
		        if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
		        this.toAssignableList(node.elements, isBinding);
		        break

		      case "SpreadElement":
		        node.type = "RestElement";
		        this.toAssignable(node.argument, isBinding);
		        if (node.argument.type === "AssignmentPattern")
		          { this.raise(node.argument.start, "Rest elements cannot have a default value"); }
		        break

		      case "AssignmentExpression":
		        if (node.operator !== "=") { this.raise(node.left.end, "Only '=' operator can be used for specifying default value."); }
		        node.type = "AssignmentPattern";
		        delete node.operator;
		        this.toAssignable(node.left, isBinding);
		        break

		      case "ParenthesizedExpression":
		        this.toAssignable(node.expression, isBinding, refDestructuringErrors);
		        break

		      case "ChainExpression":
		        this.raiseRecoverable(node.start, "Optional chaining cannot appear in left-hand side");
		        break

		      case "MemberExpression":
		        if (!isBinding) { break }

		      default:
		        this.raise(node.start, "Assigning to rvalue");
		      }
		    } else if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
		    return node
		  };

		  // Convert list of expression atoms to binding list.

		  pp$7.toAssignableList = function(exprList, isBinding) {
		    var end = exprList.length;
		    for (var i = 0; i < end; i++) {
		      var elt = exprList[i];
		      if (elt) { this.toAssignable(elt, isBinding); }
		    }
		    if (end) {
		      var last = exprList[end - 1];
		      if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier")
		        { this.unexpected(last.argument.start); }
		    }
		    return exprList
		  };

		  // Parses spread element.

		  pp$7.parseSpread = function(refDestructuringErrors) {
		    var node = this.startNode();
		    this.next();
		    node.argument = this.parseMaybeAssign(false, refDestructuringErrors);
		    return this.finishNode(node, "SpreadElement")
		  };

		  pp$7.parseRestBinding = function() {
		    var node = this.startNode();
		    this.next();

		    // RestElement inside of a function parameter must be an identifier
		    if (this.options.ecmaVersion === 6 && this.type !== types$1.name)
		      { this.unexpected(); }

		    node.argument = this.parseBindingAtom();

		    return this.finishNode(node, "RestElement")
		  };

		  // Parses lvalue (assignable) atom.

		  pp$7.parseBindingAtom = function() {
		    if (this.options.ecmaVersion >= 6) {
		      switch (this.type) {
		      case types$1.bracketL:
		        var node = this.startNode();
		        this.next();
		        node.elements = this.parseBindingList(types$1.bracketR, true, true);
		        return this.finishNode(node, "ArrayPattern")

		      case types$1.braceL:
		        return this.parseObj(true)
		      }
		    }
		    return this.parseIdent()
		  };

		  pp$7.parseBindingList = function(close, allowEmpty, allowTrailingComma, allowModifiers) {
		    var elts = [], first = true;
		    while (!this.eat(close)) {
		      if (first) { first = false; }
		      else { this.expect(types$1.comma); }
		      if (allowEmpty && this.type === types$1.comma) {
		        elts.push(null);
		      } else if (allowTrailingComma && this.afterTrailingComma(close)) {
		        break
		      } else if (this.type === types$1.ellipsis) {
		        var rest = this.parseRestBinding();
		        this.parseBindingListItem(rest);
		        elts.push(rest);
		        if (this.type === types$1.comma) { this.raiseRecoverable(this.start, "Comma is not permitted after the rest element"); }
		        this.expect(close);
		        break
		      } else {
		        elts.push(this.parseAssignableListItem(allowModifiers));
		      }
		    }
		    return elts
		  };

		  pp$7.parseAssignableListItem = function(allowModifiers) {
		    var elem = this.parseMaybeDefault(this.start, this.startLoc);
		    this.parseBindingListItem(elem);
		    return elem
		  };

		  pp$7.parseBindingListItem = function(param) {
		    return param
		  };

		  // Parses assignment pattern around given atom if possible.

		  pp$7.parseMaybeDefault = function(startPos, startLoc, left) {
		    left = left || this.parseBindingAtom();
		    if (this.options.ecmaVersion < 6 || !this.eat(types$1.eq)) { return left }
		    var node = this.startNodeAt(startPos, startLoc);
		    node.left = left;
		    node.right = this.parseMaybeAssign();
		    return this.finishNode(node, "AssignmentPattern")
		  };

		  // The following three functions all verify that a node is an lvalue —
		  // something that can be bound, or assigned to. In order to do so, they perform
		  // a variety of checks:
		  //
		  // - Check that none of the bound/assigned-to identifiers are reserved words.
		  // - Record name declarations for bindings in the appropriate scope.
		  // - Check duplicate argument names, if checkClashes is set.
		  //
		  // If a complex binding pattern is encountered (e.g., object and array
		  // destructuring), the entire pattern is recursively checked.
		  //
		  // There are three versions of checkLVal*() appropriate for different
		  // circumstances:
		  //
		  // - checkLValSimple() shall be used if the syntactic construct supports
		  //   nothing other than identifiers and member expressions. Parenthesized
		  //   expressions are also correctly handled. This is generally appropriate for
		  //   constructs for which the spec says
		  //
		  //   > It is a Syntax Error if AssignmentTargetType of [the production] is not
		  //   > simple.
		  //
		  //   It is also appropriate for checking if an identifier is valid and not
		  //   defined elsewhere, like import declarations or function/class identifiers.
		  //
		  //   Examples where this is used include:
		  //     a += …;
		  //     import a from '…';
		  //   where a is the node to be checked.
		  //
		  // - checkLValPattern() shall be used if the syntactic construct supports
		  //   anything checkLValSimple() supports, as well as object and array
		  //   destructuring patterns. This is generally appropriate for constructs for
		  //   which the spec says
		  //
		  //   > It is a Syntax Error if [the production] is neither an ObjectLiteral nor
		  //   > an ArrayLiteral and AssignmentTargetType of [the production] is not
		  //   > simple.
		  //
		  //   Examples where this is used include:
		  //     (a = …);
		  //     const a = …;
		  //     try { … } catch (a) { … }
		  //   where a is the node to be checked.
		  //
		  // - checkLValInnerPattern() shall be used if the syntactic construct supports
		  //   anything checkLValPattern() supports, as well as default assignment
		  //   patterns, rest elements, and other constructs that may appear within an
		  //   object or array destructuring pattern.
		  //
		  //   As a special case, function parameters also use checkLValInnerPattern(),
		  //   as they also support defaults and rest constructs.
		  //
		  // These functions deliberately support both assignment and binding constructs,
		  // as the logic for both is exceedingly similar. If the node is the target of
		  // an assignment, then bindingType should be set to BIND_NONE. Otherwise, it
		  // should be set to the appropriate BIND_* constant, like BIND_VAR or
		  // BIND_LEXICAL.
		  //
		  // If the function is called with a non-BIND_NONE bindingType, then
		  // additionally a checkClashes object may be specified to allow checking for
		  // duplicate argument names. checkClashes is ignored if the provided construct
		  // is an assignment (i.e., bindingType is BIND_NONE).

		  pp$7.checkLValSimple = function(expr, bindingType, checkClashes) {
		    if ( bindingType === void 0 ) bindingType = BIND_NONE;

		    var isBind = bindingType !== BIND_NONE;

		    switch (expr.type) {
		    case "Identifier":
		      if (this.strict && this.reservedWordsStrictBind.test(expr.name))
		        { this.raiseRecoverable(expr.start, (isBind ? "Binding " : "Assigning to ") + expr.name + " in strict mode"); }
		      if (isBind) {
		        if (bindingType === BIND_LEXICAL && expr.name === "let")
		          { this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name"); }
		        if (checkClashes) {
		          if (hasOwn(checkClashes, expr.name))
		            { this.raiseRecoverable(expr.start, "Argument name clash"); }
		          checkClashes[expr.name] = true;
		        }
		        if (bindingType !== BIND_OUTSIDE) { this.declareName(expr.name, bindingType, expr.start); }
		      }
		      break

		    case "ChainExpression":
		      this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
		      break

		    case "MemberExpression":
		      if (isBind) { this.raiseRecoverable(expr.start, "Binding member expression"); }
		      break

		    case "ParenthesizedExpression":
		      if (isBind) { this.raiseRecoverable(expr.start, "Binding parenthesized expression"); }
		      return this.checkLValSimple(expr.expression, bindingType, checkClashes)

		    default:
		      this.raise(expr.start, (isBind ? "Binding" : "Assigning to") + " rvalue");
		    }
		  };

		  pp$7.checkLValPattern = function(expr, bindingType, checkClashes) {
		    if ( bindingType === void 0 ) bindingType = BIND_NONE;

		    switch (expr.type) {
		    case "ObjectPattern":
		      for (var i = 0, list = expr.properties; i < list.length; i += 1) {
		        var prop = list[i];

		      this.checkLValInnerPattern(prop, bindingType, checkClashes);
		      }
		      break

		    case "ArrayPattern":
		      for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
		        var elem = list$1[i$1];

		      if (elem) { this.checkLValInnerPattern(elem, bindingType, checkClashes); }
		      }
		      break

		    default:
		      this.checkLValSimple(expr, bindingType, checkClashes);
		    }
		  };

		  pp$7.checkLValInnerPattern = function(expr, bindingType, checkClashes) {
		    if ( bindingType === void 0 ) bindingType = BIND_NONE;

		    switch (expr.type) {
		    case "Property":
		      // AssignmentProperty has type === "Property"
		      this.checkLValInnerPattern(expr.value, bindingType, checkClashes);
		      break

		    case "AssignmentPattern":
		      this.checkLValPattern(expr.left, bindingType, checkClashes);
		      break

		    case "RestElement":
		      this.checkLValPattern(expr.argument, bindingType, checkClashes);
		      break

		    default:
		      this.checkLValPattern(expr, bindingType, checkClashes);
		    }
		  };

		  // The algorithm used to determine whether a regexp can appear at a
		  // given point in the program is loosely based on sweet.js' approach.
		  // See https://github.com/mozilla/sweet.js/wiki/design


		  var TokContext = function TokContext(token, isExpr, preserveSpace, override, generator) {
		    this.token = token;
		    this.isExpr = !!isExpr;
		    this.preserveSpace = !!preserveSpace;
		    this.override = override;
		    this.generator = !!generator;
		  };

		  var types = {
		    b_stat: new TokContext("{", false),
		    b_expr: new TokContext("{", true),
		    b_tmpl: new TokContext("${", false),
		    p_stat: new TokContext("(", false),
		    p_expr: new TokContext("(", true),
		    q_tmpl: new TokContext("`", true, true, function (p) { return p.tryReadTemplateToken(); }),
		    f_stat: new TokContext("function", false),
		    f_expr: new TokContext("function", true),
		    f_expr_gen: new TokContext("function", true, false, null, true),
		    f_gen: new TokContext("function", false, false, null, true)
		  };

		  var pp$6 = Parser.prototype;

		  pp$6.initialContext = function() {
		    return [types.b_stat]
		  };

		  pp$6.curContext = function() {
		    return this.context[this.context.length - 1]
		  };

		  pp$6.braceIsBlock = function(prevType) {
		    var parent = this.curContext();
		    if (parent === types.f_expr || parent === types.f_stat)
		      { return true }
		    if (prevType === types$1.colon && (parent === types.b_stat || parent === types.b_expr))
		      { return !parent.isExpr }

		    // The check for `tt.name && exprAllowed` detects whether we are
		    // after a `yield` or `of` construct. See the `updateContext` for
		    // `tt.name`.
		    if (prevType === types$1._return || prevType === types$1.name && this.exprAllowed)
		      { return lineBreak.test(this.input.slice(this.lastTokEnd, this.start)) }
		    if (prevType === types$1._else || prevType === types$1.semi || prevType === types$1.eof || prevType === types$1.parenR || prevType === types$1.arrow)
		      { return true }
		    if (prevType === types$1.braceL)
		      { return parent === types.b_stat }
		    if (prevType === types$1._var || prevType === types$1._const || prevType === types$1.name)
		      { return false }
		    return !this.exprAllowed
		  };

		  pp$6.inGeneratorContext = function() {
		    for (var i = this.context.length - 1; i >= 1; i--) {
		      var context = this.context[i];
		      if (context.token === "function")
		        { return context.generator }
		    }
		    return false
		  };

		  pp$6.updateContext = function(prevType) {
		    var update, type = this.type;
		    if (type.keyword && prevType === types$1.dot)
		      { this.exprAllowed = false; }
		    else if (update = type.updateContext)
		      { update.call(this, prevType); }
		    else
		      { this.exprAllowed = type.beforeExpr; }
		  };

		  // Used to handle edge cases when token context could not be inferred correctly during tokenization phase

		  pp$6.overrideContext = function(tokenCtx) {
		    if (this.curContext() !== tokenCtx) {
		      this.context[this.context.length - 1] = tokenCtx;
		    }
		  };

		  // Token-specific context update code

		  types$1.parenR.updateContext = types$1.braceR.updateContext = function() {
		    if (this.context.length === 1) {
		      this.exprAllowed = true;
		      return
		    }
		    var out = this.context.pop();
		    if (out === types.b_stat && this.curContext().token === "function") {
		      out = this.context.pop();
		    }
		    this.exprAllowed = !out.isExpr;
		  };

		  types$1.braceL.updateContext = function(prevType) {
		    this.context.push(this.braceIsBlock(prevType) ? types.b_stat : types.b_expr);
		    this.exprAllowed = true;
		  };

		  types$1.dollarBraceL.updateContext = function() {
		    this.context.push(types.b_tmpl);
		    this.exprAllowed = true;
		  };

		  types$1.parenL.updateContext = function(prevType) {
		    var statementParens = prevType === types$1._if || prevType === types$1._for || prevType === types$1._with || prevType === types$1._while;
		    this.context.push(statementParens ? types.p_stat : types.p_expr);
		    this.exprAllowed = true;
		  };

		  types$1.incDec.updateContext = function() {
		    // tokExprAllowed stays unchanged
		  };

		  types$1._function.updateContext = types$1._class.updateContext = function(prevType) {
		    if (prevType.beforeExpr && prevType !== types$1._else &&
		        !(prevType === types$1.semi && this.curContext() !== types.p_stat) &&
		        !(prevType === types$1._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) &&
		        !((prevType === types$1.colon || prevType === types$1.braceL) && this.curContext() === types.b_stat))
		      { this.context.push(types.f_expr); }
		    else
		      { this.context.push(types.f_stat); }
		    this.exprAllowed = false;
		  };

		  types$1.colon.updateContext = function() {
		    if (this.curContext().token === "function") { this.context.pop(); }
		    this.exprAllowed = true;
		  };

		  types$1.backQuote.updateContext = function() {
		    if (this.curContext() === types.q_tmpl)
		      { this.context.pop(); }
		    else
		      { this.context.push(types.q_tmpl); }
		    this.exprAllowed = false;
		  };

		  types$1.star.updateContext = function(prevType) {
		    if (prevType === types$1._function) {
		      var index = this.context.length - 1;
		      if (this.context[index] === types.f_expr)
		        { this.context[index] = types.f_expr_gen; }
		      else
		        { this.context[index] = types.f_gen; }
		    }
		    this.exprAllowed = true;
		  };

		  types$1.name.updateContext = function(prevType) {
		    var allowed = false;
		    if (this.options.ecmaVersion >= 6 && prevType !== types$1.dot) {
		      if (this.value === "of" && !this.exprAllowed ||
		          this.value === "yield" && this.inGeneratorContext())
		        { allowed = true; }
		    }
		    this.exprAllowed = allowed;
		  };

		  // A recursive descent parser operates by defining functions for all
		  // syntactic elements, and recursively calling those, each function
		  // advancing the input stream and returning an AST node. Precedence
		  // of constructs (for example, the fact that `!x[1]` means `!(x[1])`
		  // instead of `(!x)[1]` is handled by the fact that the parser
		  // function that parses unary prefix operators is called first, and
		  // in turn calls the function that parses `[]` subscripts — that
		  // way, it'll receive the node for `x[1]` already parsed, and wraps
		  // *that* in the unary operator node.
		  //
		  // Acorn uses an [operator precedence parser][opp] to handle binary
		  // operator precedence, because it is much more compact than using
		  // the technique outlined above, which uses different, nesting
		  // functions to specify precedence, for all of the ten binary
		  // precedence levels that JavaScript defines.
		  //
		  // [opp]: http://en.wikipedia.org/wiki/Operator-precedence_parser


		  var pp$5 = Parser.prototype;

		  // Check if property name clashes with already added.
		  // Object/class getters and setters are not allowed to clash —
		  // either with each other or with an init property — and in
		  // strict mode, init properties are also not allowed to be repeated.

		  pp$5.checkPropClash = function(prop, propHash, refDestructuringErrors) {
		    if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement")
		      { return }
		    if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand))
		      { return }
		    var key = prop.key;
		    var name;
		    switch (key.type) {
		    case "Identifier": name = key.name; break
		    case "Literal": name = String(key.value); break
		    default: return
		    }
		    var kind = prop.kind;
		    if (this.options.ecmaVersion >= 6) {
		      if (name === "__proto__" && kind === "init") {
		        if (propHash.proto) {
		          if (refDestructuringErrors) {
		            if (refDestructuringErrors.doubleProto < 0) {
		              refDestructuringErrors.doubleProto = key.start;
		            }
		          } else {
		            this.raiseRecoverable(key.start, "Redefinition of __proto__ property");
		          }
		        }
		        propHash.proto = true;
		      }
		      return
		    }
		    name = "$" + name;
		    var other = propHash[name];
		    if (other) {
		      var redefinition;
		      if (kind === "init") {
		        redefinition = this.strict && other.init || other.get || other.set;
		      } else {
		        redefinition = other.init || other[kind];
		      }
		      if (redefinition)
		        { this.raiseRecoverable(key.start, "Redefinition of property"); }
		    } else {
		      other = propHash[name] = {
		        init: false,
		        get: false,
		        set: false
		      };
		    }
		    other[kind] = true;
		  };

		  // ### Expression parsing

		  // These nest, from the most general expression type at the top to
		  // 'atomic', nondivisible expression types at the bottom. Most of
		  // the functions will simply let the function(s) below them parse,
		  // and, *if* the syntactic construct they handle is present, wrap
		  // the AST node that the inner parser gave them in another node.

		  // Parse a full expression. The optional arguments are used to
		  // forbid the `in` operator (in for loops initalization expressions)
		  // and provide reference for storing '=' operator inside shorthand
		  // property assignment in contexts where both object expression
		  // and object pattern might appear (so it's possible to raise
		  // delayed syntax error at correct position).

		  pp$5.parseExpression = function(forInit, refDestructuringErrors) {
		    var startPos = this.start, startLoc = this.startLoc;
		    var expr = this.parseMaybeAssign(forInit, refDestructuringErrors);
		    if (this.type === types$1.comma) {
		      var node = this.startNodeAt(startPos, startLoc);
		      node.expressions = [expr];
		      while (this.eat(types$1.comma)) { node.expressions.push(this.parseMaybeAssign(forInit, refDestructuringErrors)); }
		      return this.finishNode(node, "SequenceExpression")
		    }
		    return expr
		  };

		  // Parse an assignment expression. This includes applications of
		  // operators like `+=`.

		  pp$5.parseMaybeAssign = function(forInit, refDestructuringErrors, afterLeftParse) {
		    if (this.isContextual("yield")) {
		      if (this.inGenerator) { return this.parseYield(forInit) }
		      // The tokenizer will assume an expression is allowed after
		      // `yield`, but this isn't that kind of yield
		      else { this.exprAllowed = false; }
		    }

		    var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1, oldDoubleProto = -1;
		    if (refDestructuringErrors) {
		      oldParenAssign = refDestructuringErrors.parenthesizedAssign;
		      oldTrailingComma = refDestructuringErrors.trailingComma;
		      oldDoubleProto = refDestructuringErrors.doubleProto;
		      refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
		    } else {
		      refDestructuringErrors = new DestructuringErrors;
		      ownDestructuringErrors = true;
		    }

		    var startPos = this.start, startLoc = this.startLoc;
		    if (this.type === types$1.parenL || this.type === types$1.name) {
		      this.potentialArrowAt = this.start;
		      this.potentialArrowInForAwait = forInit === "await";
		    }
		    var left = this.parseMaybeConditional(forInit, refDestructuringErrors);
		    if (afterLeftParse) { left = afterLeftParse.call(this, left, startPos, startLoc); }
		    if (this.type.isAssign) {
		      var node = this.startNodeAt(startPos, startLoc);
		      node.operator = this.value;
		      if (this.type === types$1.eq)
		        { left = this.toAssignable(left, false, refDestructuringErrors); }
		      if (!ownDestructuringErrors) {
		        refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1;
		      }
		      if (refDestructuringErrors.shorthandAssign >= left.start)
		        { refDestructuringErrors.shorthandAssign = -1; } // reset because shorthand default was used correctly
		      if (this.type === types$1.eq)
		        { this.checkLValPattern(left); }
		      else
		        { this.checkLValSimple(left); }
		      node.left = left;
		      this.next();
		      node.right = this.parseMaybeAssign(forInit);
		      if (oldDoubleProto > -1) { refDestructuringErrors.doubleProto = oldDoubleProto; }
		      return this.finishNode(node, "AssignmentExpression")
		    } else {
		      if (ownDestructuringErrors) { this.checkExpressionErrors(refDestructuringErrors, true); }
		    }
		    if (oldParenAssign > -1) { refDestructuringErrors.parenthesizedAssign = oldParenAssign; }
		    if (oldTrailingComma > -1) { refDestructuringErrors.trailingComma = oldTrailingComma; }
		    return left
		  };

		  // Parse a ternary conditional (`?:`) operator.

		  pp$5.parseMaybeConditional = function(forInit, refDestructuringErrors) {
		    var startPos = this.start, startLoc = this.startLoc;
		    var expr = this.parseExprOps(forInit, refDestructuringErrors);
		    if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
		    if (this.eat(types$1.question)) {
		      var node = this.startNodeAt(startPos, startLoc);
		      node.test = expr;
		      node.consequent = this.parseMaybeAssign();
		      this.expect(types$1.colon);
		      node.alternate = this.parseMaybeAssign(forInit);
		      return this.finishNode(node, "ConditionalExpression")
		    }
		    return expr
		  };

		  // Start the precedence parser.

		  pp$5.parseExprOps = function(forInit, refDestructuringErrors) {
		    var startPos = this.start, startLoc = this.startLoc;
		    var expr = this.parseMaybeUnary(refDestructuringErrors, false, false, forInit);
		    if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
		    return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, forInit)
		  };

		  // Parse binary operators with the operator precedence parsing
		  // algorithm. `left` is the left-hand side of the operator.
		  // `minPrec` provides context that allows the function to stop and
		  // defer further parser to one of its callers when it encounters an
		  // operator that has a lower precedence than the set it is parsing.

		  pp$5.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, forInit) {
		    var prec = this.type.binop;
		    if (prec != null && (!forInit || this.type !== types$1._in)) {
		      if (prec > minPrec) {
		        var logical = this.type === types$1.logicalOR || this.type === types$1.logicalAND;
		        var coalesce = this.type === types$1.coalesce;
		        if (coalesce) {
		          // Handle the precedence of `tt.coalesce` as equal to the range of logical expressions.
		          // In other words, `node.right` shouldn't contain logical expressions in order to check the mixed error.
		          prec = types$1.logicalAND.binop;
		        }
		        var op = this.value;
		        this.next();
		        var startPos = this.start, startLoc = this.startLoc;
		        var right = this.parseExprOp(this.parseMaybeUnary(null, false, false, forInit), startPos, startLoc, prec, forInit);
		        var node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
		        if ((logical && this.type === types$1.coalesce) || (coalesce && (this.type === types$1.logicalOR || this.type === types$1.logicalAND))) {
		          this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses");
		        }
		        return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, forInit)
		      }
		    }
		    return left
		  };

		  pp$5.buildBinary = function(startPos, startLoc, left, right, op, logical) {
		    if (right.type === "PrivateIdentifier") { this.raise(right.start, "Private identifier can only be left side of binary expression"); }
		    var node = this.startNodeAt(startPos, startLoc);
		    node.left = left;
		    node.operator = op;
		    node.right = right;
		    return this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression")
		  };

		  // Parse unary operators, both prefix and postfix.

		  pp$5.parseMaybeUnary = function(refDestructuringErrors, sawUnary, incDec, forInit) {
		    var startPos = this.start, startLoc = this.startLoc, expr;
		    if (this.isContextual("await") && this.canAwait) {
		      expr = this.parseAwait(forInit);
		      sawUnary = true;
		    } else if (this.type.prefix) {
		      var node = this.startNode(), update = this.type === types$1.incDec;
		      node.operator = this.value;
		      node.prefix = true;
		      this.next();
		      node.argument = this.parseMaybeUnary(null, true, update, forInit);
		      this.checkExpressionErrors(refDestructuringErrors, true);
		      if (update) { this.checkLValSimple(node.argument); }
		      else if (this.strict && node.operator === "delete" && isLocalVariableAccess(node.argument))
		        { this.raiseRecoverable(node.start, "Deleting local variable in strict mode"); }
		      else if (node.operator === "delete" && isPrivateFieldAccess(node.argument))
		        { this.raiseRecoverable(node.start, "Private fields can not be deleted"); }
		      else { sawUnary = true; }
		      expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
		    } else if (!sawUnary && this.type === types$1.privateId) {
		      if ((forInit || this.privateNameStack.length === 0) && this.options.checkPrivateFields) { this.unexpected(); }
		      expr = this.parsePrivateIdent();
		      // only could be private fields in 'in', such as #x in obj
		      if (this.type !== types$1._in) { this.unexpected(); }
		    } else {
		      expr = this.parseExprSubscripts(refDestructuringErrors, forInit);
		      if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
		      while (this.type.postfix && !this.canInsertSemicolon()) {
		        var node$1 = this.startNodeAt(startPos, startLoc);
		        node$1.operator = this.value;
		        node$1.prefix = false;
		        node$1.argument = expr;
		        this.checkLValSimple(expr);
		        this.next();
		        expr = this.finishNode(node$1, "UpdateExpression");
		      }
		    }

		    if (!incDec && this.eat(types$1.starstar)) {
		      if (sawUnary)
		        { this.unexpected(this.lastTokStart); }
		      else
		        { return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false, false, forInit), "**", false) }
		    } else {
		      return expr
		    }
		  };

		  function isLocalVariableAccess(node) {
		    return (
		      node.type === "Identifier" ||
		      node.type === "ParenthesizedExpression" && isLocalVariableAccess(node.expression)
		    )
		  }

		  function isPrivateFieldAccess(node) {
		    return (
		      node.type === "MemberExpression" && node.property.type === "PrivateIdentifier" ||
		      node.type === "ChainExpression" && isPrivateFieldAccess(node.expression) ||
		      node.type === "ParenthesizedExpression" && isPrivateFieldAccess(node.expression)
		    )
		  }

		  // Parse call, dot, and `[]`-subscript expressions.

		  pp$5.parseExprSubscripts = function(refDestructuringErrors, forInit) {
		    var startPos = this.start, startLoc = this.startLoc;
		    var expr = this.parseExprAtom(refDestructuringErrors, forInit);
		    if (expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")")
		      { return expr }
		    var result = this.parseSubscripts(expr, startPos, startLoc, false, forInit);
		    if (refDestructuringErrors && result.type === "MemberExpression") {
		      if (refDestructuringErrors.parenthesizedAssign >= result.start) { refDestructuringErrors.parenthesizedAssign = -1; }
		      if (refDestructuringErrors.parenthesizedBind >= result.start) { refDestructuringErrors.parenthesizedBind = -1; }
		      if (refDestructuringErrors.trailingComma >= result.start) { refDestructuringErrors.trailingComma = -1; }
		    }
		    return result
		  };

		  pp$5.parseSubscripts = function(base, startPos, startLoc, noCalls, forInit) {
		    var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base.type === "Identifier" && base.name === "async" &&
		        this.lastTokEnd === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 &&
		        this.potentialArrowAt === base.start;
		    var optionalChained = false;

		    while (true) {
		      var element = this.parseSubscript(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit);

		      if (element.optional) { optionalChained = true; }
		      if (element === base || element.type === "ArrowFunctionExpression") {
		        if (optionalChained) {
		          var chainNode = this.startNodeAt(startPos, startLoc);
		          chainNode.expression = element;
		          element = this.finishNode(chainNode, "ChainExpression");
		        }
		        return element
		      }

		      base = element;
		    }
		  };

		  pp$5.shouldParseAsyncArrow = function() {
		    return !this.canInsertSemicolon() && this.eat(types$1.arrow)
		  };

		  pp$5.parseSubscriptAsyncArrow = function(startPos, startLoc, exprList, forInit) {
		    return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true, forInit)
		  };

		  pp$5.parseSubscript = function(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit) {
		    var optionalSupported = this.options.ecmaVersion >= 11;
		    var optional = optionalSupported && this.eat(types$1.questionDot);
		    if (noCalls && optional) { this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions"); }

		    var computed = this.eat(types$1.bracketL);
		    if (computed || (optional && this.type !== types$1.parenL && this.type !== types$1.backQuote) || this.eat(types$1.dot)) {
		      var node = this.startNodeAt(startPos, startLoc);
		      node.object = base;
		      if (computed) {
		        node.property = this.parseExpression();
		        this.expect(types$1.bracketR);
		      } else if (this.type === types$1.privateId && base.type !== "Super") {
		        node.property = this.parsePrivateIdent();
		      } else {
		        node.property = this.parseIdent(this.options.allowReserved !== "never");
		      }
		      node.computed = !!computed;
		      if (optionalSupported) {
		        node.optional = optional;
		      }
		      base = this.finishNode(node, "MemberExpression");
		    } else if (!noCalls && this.eat(types$1.parenL)) {
		      var refDestructuringErrors = new DestructuringErrors, oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
		      this.yieldPos = 0;
		      this.awaitPos = 0;
		      this.awaitIdentPos = 0;
		      var exprList = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
		      if (maybeAsyncArrow && !optional && this.shouldParseAsyncArrow()) {
		        this.checkPatternErrors(refDestructuringErrors, false);
		        this.checkYieldAwaitInDefaultParams();
		        if (this.awaitIdentPos > 0)
		          { this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function"); }
		        this.yieldPos = oldYieldPos;
		        this.awaitPos = oldAwaitPos;
		        this.awaitIdentPos = oldAwaitIdentPos;
		        return this.parseSubscriptAsyncArrow(startPos, startLoc, exprList, forInit)
		      }
		      this.checkExpressionErrors(refDestructuringErrors, true);
		      this.yieldPos = oldYieldPos || this.yieldPos;
		      this.awaitPos = oldAwaitPos || this.awaitPos;
		      this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
		      var node$1 = this.startNodeAt(startPos, startLoc);
		      node$1.callee = base;
		      node$1.arguments = exprList;
		      if (optionalSupported) {
		        node$1.optional = optional;
		      }
		      base = this.finishNode(node$1, "CallExpression");
		    } else if (this.type === types$1.backQuote) {
		      if (optional || optionalChained) {
		        this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
		      }
		      var node$2 = this.startNodeAt(startPos, startLoc);
		      node$2.tag = base;
		      node$2.quasi = this.parseTemplate({isTagged: true});
		      base = this.finishNode(node$2, "TaggedTemplateExpression");
		    }
		    return base
		  };

		  // Parse an atomic expression — either a single token that is an
		  // expression, an expression started by a keyword like `function` or
		  // `new`, or an expression wrapped in punctuation like `()`, `[]`,
		  // or `{}`.

		  pp$5.parseExprAtom = function(refDestructuringErrors, forInit, forNew) {
		    // If a division operator appears in an expression position, the
		    // tokenizer got confused, and we force it to read a regexp instead.
		    if (this.type === types$1.slash) { this.readRegexp(); }

		    var node, canBeArrow = this.potentialArrowAt === this.start;
		    switch (this.type) {
		    case types$1._super:
		      if (!this.allowSuper)
		        { this.raise(this.start, "'super' keyword outside a method"); }
		      node = this.startNode();
		      this.next();
		      if (this.type === types$1.parenL && !this.allowDirectSuper)
		        { this.raise(node.start, "super() call outside constructor of a subclass"); }
		      // The `super` keyword can appear at below:
		      // SuperProperty:
		      //     super [ Expression ]
		      //     super . IdentifierName
		      // SuperCall:
		      //     super ( Arguments )
		      if (this.type !== types$1.dot && this.type !== types$1.bracketL && this.type !== types$1.parenL)
		        { this.unexpected(); }
		      return this.finishNode(node, "Super")

		    case types$1._this:
		      node = this.startNode();
		      this.next();
		      return this.finishNode(node, "ThisExpression")

		    case types$1.name:
		      var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
		      var id = this.parseIdent(false);
		      if (this.options.ecmaVersion >= 8 && !containsEsc && id.name === "async" && !this.canInsertSemicolon() && this.eat(types$1._function)) {
		        this.overrideContext(types.f_expr);
		        return this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true, forInit)
		      }
		      if (canBeArrow && !this.canInsertSemicolon()) {
		        if (this.eat(types$1.arrow))
		          { return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false, forInit) }
		        if (this.options.ecmaVersion >= 8 && id.name === "async" && this.type === types$1.name && !containsEsc &&
		            (!this.potentialArrowInForAwait || this.value !== "of" || this.containsEsc)) {
		          id = this.parseIdent(false);
		          if (this.canInsertSemicolon() || !this.eat(types$1.arrow))
		            { this.unexpected(); }
		          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true, forInit)
		        }
		      }
		      return id

		    case types$1.regexp:
		      var value = this.value;
		      node = this.parseLiteral(value.value);
		      node.regex = {pattern: value.pattern, flags: value.flags};
		      return node

		    case types$1.num: case types$1.string:
		      return this.parseLiteral(this.value)

		    case types$1._null: case types$1._true: case types$1._false:
		      node = this.startNode();
		      node.value = this.type === types$1._null ? null : this.type === types$1._true;
		      node.raw = this.type.keyword;
		      this.next();
		      return this.finishNode(node, "Literal")

		    case types$1.parenL:
		      var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow, forInit);
		      if (refDestructuringErrors) {
		        if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr))
		          { refDestructuringErrors.parenthesizedAssign = start; }
		        if (refDestructuringErrors.parenthesizedBind < 0)
		          { refDestructuringErrors.parenthesizedBind = start; }
		      }
		      return expr

		    case types$1.bracketL:
		      node = this.startNode();
		      this.next();
		      node.elements = this.parseExprList(types$1.bracketR, true, true, refDestructuringErrors);
		      return this.finishNode(node, "ArrayExpression")

		    case types$1.braceL:
		      this.overrideContext(types.b_expr);
		      return this.parseObj(false, refDestructuringErrors)

		    case types$1._function:
		      node = this.startNode();
		      this.next();
		      return this.parseFunction(node, 0)

		    case types$1._class:
		      return this.parseClass(this.startNode(), false)

		    case types$1._new:
		      return this.parseNew()

		    case types$1.backQuote:
		      return this.parseTemplate()

		    case types$1._import:
		      if (this.options.ecmaVersion >= 11) {
		        return this.parseExprImport(forNew)
		      } else {
		        return this.unexpected()
		      }

		    default:
		      return this.parseExprAtomDefault()
		    }
		  };

		  pp$5.parseExprAtomDefault = function() {
		    this.unexpected();
		  };

		  pp$5.parseExprImport = function(forNew) {
		    var node = this.startNode();

		    // Consume `import` as an identifier for `import.meta`.
		    // Because `this.parseIdent(true)` doesn't check escape sequences, it needs the check of `this.containsEsc`.
		    if (this.containsEsc) { this.raiseRecoverable(this.start, "Escape sequence in keyword import"); }
		    this.next();

		    if (this.type === types$1.parenL && !forNew) {
		      return this.parseDynamicImport(node)
		    } else if (this.type === types$1.dot) {
		      var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
		      meta.name = "import";
		      node.meta = this.finishNode(meta, "Identifier");
		      return this.parseImportMeta(node)
		    } else {
		      this.unexpected();
		    }
		  };

		  pp$5.parseDynamicImport = function(node) {
		    this.next(); // skip `(`

		    // Parse node.source.
		    node.source = this.parseMaybeAssign();

		    if (this.options.ecmaVersion >= 16) {
		      if (!this.eat(types$1.parenR)) {
		        this.expect(types$1.comma);
		        if (!this.afterTrailingComma(types$1.parenR)) {
		          node.options = this.parseMaybeAssign();
		          if (!this.eat(types$1.parenR)) {
		            this.expect(types$1.comma);
		            if (!this.afterTrailingComma(types$1.parenR)) {
		              this.unexpected();
		            }
		          }
		        } else {
		          node.options = null;
		        }
		      } else {
		        node.options = null;
		      }
		    } else {
		      // Verify ending.
		      if (!this.eat(types$1.parenR)) {
		        var errorPos = this.start;
		        if (this.eat(types$1.comma) && this.eat(types$1.parenR)) {
		          this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()");
		        } else {
		          this.unexpected(errorPos);
		        }
		      }
		    }

		    return this.finishNode(node, "ImportExpression")
		  };

		  pp$5.parseImportMeta = function(node) {
		    this.next(); // skip `.`

		    var containsEsc = this.containsEsc;
		    node.property = this.parseIdent(true);

		    if (node.property.name !== "meta")
		      { this.raiseRecoverable(node.property.start, "The only valid meta property for import is 'import.meta'"); }
		    if (containsEsc)
		      { this.raiseRecoverable(node.start, "'import.meta' must not contain escaped characters"); }
		    if (this.options.sourceType !== "module" && !this.options.allowImportExportEverywhere)
		      { this.raiseRecoverable(node.start, "Cannot use 'import.meta' outside a module"); }

		    return this.finishNode(node, "MetaProperty")
		  };

		  pp$5.parseLiteral = function(value) {
		    var node = this.startNode();
		    node.value = value;
		    node.raw = this.input.slice(this.start, this.end);
		    if (node.raw.charCodeAt(node.raw.length - 1) === 110) { node.bigint = node.raw.slice(0, -1).replace(/_/g, ""); }
		    this.next();
		    return this.finishNode(node, "Literal")
		  };

		  pp$5.parseParenExpression = function() {
		    this.expect(types$1.parenL);
		    var val = this.parseExpression();
		    this.expect(types$1.parenR);
		    return val
		  };

		  pp$5.shouldParseArrow = function(exprList) {
		    return !this.canInsertSemicolon()
		  };

		  pp$5.parseParenAndDistinguishExpression = function(canBeArrow, forInit) {
		    var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
		    if (this.options.ecmaVersion >= 6) {
		      this.next();

		      var innerStartPos = this.start, innerStartLoc = this.startLoc;
		      var exprList = [], first = true, lastIsComma = false;
		      var refDestructuringErrors = new DestructuringErrors, oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
		      this.yieldPos = 0;
		      this.awaitPos = 0;
		      // Do not save awaitIdentPos to allow checking awaits nested in parameters
		      while (this.type !== types$1.parenR) {
		        first ? first = false : this.expect(types$1.comma);
		        if (allowTrailingComma && this.afterTrailingComma(types$1.parenR, true)) {
		          lastIsComma = true;
		          break
		        } else if (this.type === types$1.ellipsis) {
		          spreadStart = this.start;
		          exprList.push(this.parseParenItem(this.parseRestBinding()));
		          if (this.type === types$1.comma) {
		            this.raiseRecoverable(
		              this.start,
		              "Comma is not permitted after the rest element"
		            );
		          }
		          break
		        } else {
		          exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
		        }
		      }
		      var innerEndPos = this.lastTokEnd, innerEndLoc = this.lastTokEndLoc;
		      this.expect(types$1.parenR);

		      if (canBeArrow && this.shouldParseArrow(exprList) && this.eat(types$1.arrow)) {
		        this.checkPatternErrors(refDestructuringErrors, false);
		        this.checkYieldAwaitInDefaultParams();
		        this.yieldPos = oldYieldPos;
		        this.awaitPos = oldAwaitPos;
		        return this.parseParenArrowList(startPos, startLoc, exprList, forInit)
		      }

		      if (!exprList.length || lastIsComma) { this.unexpected(this.lastTokStart); }
		      if (spreadStart) { this.unexpected(spreadStart); }
		      this.checkExpressionErrors(refDestructuringErrors, true);
		      this.yieldPos = oldYieldPos || this.yieldPos;
		      this.awaitPos = oldAwaitPos || this.awaitPos;

		      if (exprList.length > 1) {
		        val = this.startNodeAt(innerStartPos, innerStartLoc);
		        val.expressions = exprList;
		        this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
		      } else {
		        val = exprList[0];
		      }
		    } else {
		      val = this.parseParenExpression();
		    }

		    if (this.options.preserveParens) {
		      var par = this.startNodeAt(startPos, startLoc);
		      par.expression = val;
		      return this.finishNode(par, "ParenthesizedExpression")
		    } else {
		      return val
		    }
		  };

		  pp$5.parseParenItem = function(item) {
		    return item
		  };

		  pp$5.parseParenArrowList = function(startPos, startLoc, exprList, forInit) {
		    return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, false, forInit)
		  };

		  // New's precedence is slightly tricky. It must allow its argument to
		  // be a `[]` or dot subscript expression, but not a call — at least,
		  // not without wrapping it in parentheses. Thus, it uses the noCalls
		  // argument to parseSubscripts to prevent it from consuming the
		  // argument list.

		  var empty = [];

		  pp$5.parseNew = function() {
		    if (this.containsEsc) { this.raiseRecoverable(this.start, "Escape sequence in keyword new"); }
		    var node = this.startNode();
		    this.next();
		    if (this.options.ecmaVersion >= 6 && this.type === types$1.dot) {
		      var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
		      meta.name = "new";
		      node.meta = this.finishNode(meta, "Identifier");
		      this.next();
		      var containsEsc = this.containsEsc;
		      node.property = this.parseIdent(true);
		      if (node.property.name !== "target")
		        { this.raiseRecoverable(node.property.start, "The only valid meta property for new is 'new.target'"); }
		      if (containsEsc)
		        { this.raiseRecoverable(node.start, "'new.target' must not contain escaped characters"); }
		      if (!this.allowNewDotTarget)
		        { this.raiseRecoverable(node.start, "'new.target' can only be used in functions and class static block"); }
		      return this.finishNode(node, "MetaProperty")
		    }
		    var startPos = this.start, startLoc = this.startLoc;
		    node.callee = this.parseSubscripts(this.parseExprAtom(null, false, true), startPos, startLoc, true, false);
		    if (this.eat(types$1.parenL)) { node.arguments = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false); }
		    else { node.arguments = empty; }
		    return this.finishNode(node, "NewExpression")
		  };

		  // Parse template expression.

		  pp$5.parseTemplateElement = function(ref) {
		    var isTagged = ref.isTagged;

		    var elem = this.startNode();
		    if (this.type === types$1.invalidTemplate) {
		      if (!isTagged) {
		        this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
		      }
		      elem.value = {
		        raw: this.value.replace(/\r\n?/g, "\n"),
		        cooked: null
		      };
		    } else {
		      elem.value = {
		        raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
		        cooked: this.value
		      };
		    }
		    this.next();
		    elem.tail = this.type === types$1.backQuote;
		    return this.finishNode(elem, "TemplateElement")
		  };

		  pp$5.parseTemplate = function(ref) {
		    if ( ref === void 0 ) ref = {};
		    var isTagged = ref.isTagged; if ( isTagged === void 0 ) isTagged = false;

		    var node = this.startNode();
		    this.next();
		    node.expressions = [];
		    var curElt = this.parseTemplateElement({isTagged: isTagged});
		    node.quasis = [curElt];
		    while (!curElt.tail) {
		      if (this.type === types$1.eof) { this.raise(this.pos, "Unterminated template literal"); }
		      this.expect(types$1.dollarBraceL);
		      node.expressions.push(this.parseExpression());
		      this.expect(types$1.braceR);
		      node.quasis.push(curElt = this.parseTemplateElement({isTagged: isTagged}));
		    }
		    this.next();
		    return this.finishNode(node, "TemplateLiteral")
		  };

		  pp$5.isAsyncProp = function(prop) {
		    return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" &&
		      (this.type === types$1.name || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword || (this.options.ecmaVersion >= 9 && this.type === types$1.star)) &&
		      !lineBreak.test(this.input.slice(this.lastTokEnd, this.start))
		  };

		  // Parse an object literal or binding pattern.

		  pp$5.parseObj = function(isPattern, refDestructuringErrors) {
		    var node = this.startNode(), first = true, propHash = {};
		    node.properties = [];
		    this.next();
		    while (!this.eat(types$1.braceR)) {
		      if (!first) {
		        this.expect(types$1.comma);
		        if (this.options.ecmaVersion >= 5 && this.afterTrailingComma(types$1.braceR)) { break }
		      } else { first = false; }

		      var prop = this.parseProperty(isPattern, refDestructuringErrors);
		      if (!isPattern) { this.checkPropClash(prop, propHash, refDestructuringErrors); }
		      node.properties.push(prop);
		    }
		    return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression")
		  };

		  pp$5.parseProperty = function(isPattern, refDestructuringErrors) {
		    var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
		    if (this.options.ecmaVersion >= 9 && this.eat(types$1.ellipsis)) {
		      if (isPattern) {
		        prop.argument = this.parseIdent(false);
		        if (this.type === types$1.comma) {
		          this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
		        }
		        return this.finishNode(prop, "RestElement")
		      }
		      // Parse argument.
		      prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
		      // To disallow trailing comma via `this.toAssignable()`.
		      if (this.type === types$1.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
		        refDestructuringErrors.trailingComma = this.start;
		      }
		      // Finish
		      return this.finishNode(prop, "SpreadElement")
		    }
		    if (this.options.ecmaVersion >= 6) {
		      prop.method = false;
		      prop.shorthand = false;
		      if (isPattern || refDestructuringErrors) {
		        startPos = this.start;
		        startLoc = this.startLoc;
		      }
		      if (!isPattern)
		        { isGenerator = this.eat(types$1.star); }
		    }
		    var containsEsc = this.containsEsc;
		    this.parsePropertyName(prop);
		    if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
		      isAsync = true;
		      isGenerator = this.options.ecmaVersion >= 9 && this.eat(types$1.star);
		      this.parsePropertyName(prop);
		    } else {
		      isAsync = false;
		    }
		    this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
		    return this.finishNode(prop, "Property")
		  };

		  pp$5.parseGetterSetter = function(prop) {
		    prop.kind = prop.key.name;
		    this.parsePropertyName(prop);
		    prop.value = this.parseMethod(false);
		    var paramCount = prop.kind === "get" ? 0 : 1;
		    if (prop.value.params.length !== paramCount) {
		      var start = prop.value.start;
		      if (prop.kind === "get")
		        { this.raiseRecoverable(start, "getter should have no params"); }
		      else
		        { this.raiseRecoverable(start, "setter should have exactly one param"); }
		    } else {
		      if (prop.kind === "set" && prop.value.params[0].type === "RestElement")
		        { this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params"); }
		    }
		  };

		  pp$5.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
		    if ((isGenerator || isAsync) && this.type === types$1.colon)
		      { this.unexpected(); }

		    if (this.eat(types$1.colon)) {
		      prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
		      prop.kind = "init";
		    } else if (this.options.ecmaVersion >= 6 && this.type === types$1.parenL) {
		      if (isPattern) { this.unexpected(); }
		      prop.kind = "init";
		      prop.method = true;
		      prop.value = this.parseMethod(isGenerator, isAsync);
		    } else if (!isPattern && !containsEsc &&
		               this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" &&
		               (prop.key.name === "get" || prop.key.name === "set") &&
		               (this.type !== types$1.comma && this.type !== types$1.braceR && this.type !== types$1.eq)) {
		      if (isGenerator || isAsync) { this.unexpected(); }
		      this.parseGetterSetter(prop);
		    } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
		      if (isGenerator || isAsync) { this.unexpected(); }
		      this.checkUnreserved(prop.key);
		      if (prop.key.name === "await" && !this.awaitIdentPos)
		        { this.awaitIdentPos = startPos; }
		      prop.kind = "init";
		      if (isPattern) {
		        prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
		      } else if (this.type === types$1.eq && refDestructuringErrors) {
		        if (refDestructuringErrors.shorthandAssign < 0)
		          { refDestructuringErrors.shorthandAssign = this.start; }
		        prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
		      } else {
		        prop.value = this.copyNode(prop.key);
		      }
		      prop.shorthand = true;
		    } else { this.unexpected(); }
		  };

		  pp$5.parsePropertyName = function(prop) {
		    if (this.options.ecmaVersion >= 6) {
		      if (this.eat(types$1.bracketL)) {
		        prop.computed = true;
		        prop.key = this.parseMaybeAssign();
		        this.expect(types$1.bracketR);
		        return prop.key
		      } else {
		        prop.computed = false;
		      }
		    }
		    return prop.key = this.type === types$1.num || this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never")
		  };

		  // Initialize empty function node.

		  pp$5.initFunction = function(node) {
		    node.id = null;
		    if (this.options.ecmaVersion >= 6) { node.generator = node.expression = false; }
		    if (this.options.ecmaVersion >= 8) { node.async = false; }
		  };

		  // Parse object or class method.

		  pp$5.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
		    var node = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;

		    this.initFunction(node);
		    if (this.options.ecmaVersion >= 6)
		      { node.generator = isGenerator; }
		    if (this.options.ecmaVersion >= 8)
		      { node.async = !!isAsync; }

		    this.yieldPos = 0;
		    this.awaitPos = 0;
		    this.awaitIdentPos = 0;
		    this.enterScope(functionFlags(isAsync, node.generator) | SCOPE_SUPER | (allowDirectSuper ? SCOPE_DIRECT_SUPER : 0));

		    this.expect(types$1.parenL);
		    node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
		    this.checkYieldAwaitInDefaultParams();
		    this.parseFunctionBody(node, false, true, false);

		    this.yieldPos = oldYieldPos;
		    this.awaitPos = oldAwaitPos;
		    this.awaitIdentPos = oldAwaitIdentPos;
		    return this.finishNode(node, "FunctionExpression")
		  };

		  // Parse arrow function expression with given parameters.

		  pp$5.parseArrowExpression = function(node, params, isAsync, forInit) {
		    var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;

		    this.enterScope(functionFlags(isAsync, false) | SCOPE_ARROW);
		    this.initFunction(node);
		    if (this.options.ecmaVersion >= 8) { node.async = !!isAsync; }

		    this.yieldPos = 0;
		    this.awaitPos = 0;
		    this.awaitIdentPos = 0;

		    node.params = this.toAssignableList(params, true);
		    this.parseFunctionBody(node, true, false, forInit);

		    this.yieldPos = oldYieldPos;
		    this.awaitPos = oldAwaitPos;
		    this.awaitIdentPos = oldAwaitIdentPos;
		    return this.finishNode(node, "ArrowFunctionExpression")
		  };

		  // Parse function body and check parameters.

		  pp$5.parseFunctionBody = function(node, isArrowFunction, isMethod, forInit) {
		    var isExpression = isArrowFunction && this.type !== types$1.braceL;
		    var oldStrict = this.strict, useStrict = false;

		    if (isExpression) {
		      node.body = this.parseMaybeAssign(forInit);
		      node.expression = true;
		      this.checkParams(node, false);
		    } else {
		      var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
		      if (!oldStrict || nonSimple) {
		        useStrict = this.strictDirective(this.end);
		        // If this is a strict mode function, verify that argument names
		        // are not repeated, and it does not try to bind the words `eval`
		        // or `arguments`.
		        if (useStrict && nonSimple)
		          { this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list"); }
		      }
		      // Start a new scope with regard to labels and the `inFunction`
		      // flag (restore them to their old value afterwards).
		      var oldLabels = this.labels;
		      this.labels = [];
		      if (useStrict) { this.strict = true; }

		      // Add the params to varDeclaredNames to ensure that an error is thrown
		      // if a let/const declaration in the function clashes with one of the params.
		      this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && !isMethod && this.isSimpleParamList(node.params));
		      // Ensure the function name isn't a forbidden identifier in strict mode, e.g. 'eval'
		      if (this.strict && node.id) { this.checkLValSimple(node.id, BIND_OUTSIDE); }
		      node.body = this.parseBlock(false, undefined, useStrict && !oldStrict);
		      node.expression = false;
		      this.adaptDirectivePrologue(node.body.body);
		      this.labels = oldLabels;
		    }
		    this.exitScope();
		  };

		  pp$5.isSimpleParamList = function(params) {
		    for (var i = 0, list = params; i < list.length; i += 1)
		      {
		      var param = list[i];

		      if (param.type !== "Identifier") { return false
		    } }
		    return true
		  };

		  // Checks function params for various disallowed patterns such as using "eval"
		  // or "arguments" and duplicate parameters.

		  pp$5.checkParams = function(node, allowDuplicates) {
		    var nameHash = Object.create(null);
		    for (var i = 0, list = node.params; i < list.length; i += 1)
		      {
		      var param = list[i];

		      this.checkLValInnerPattern(param, BIND_VAR, allowDuplicates ? null : nameHash);
		    }
		  };

		  // Parses a comma-separated list of expressions, and returns them as
		  // an array. `close` is the token type that ends the list, and
		  // `allowEmpty` can be turned on to allow subsequent commas with
		  // nothing in between them to be parsed as `null` (which is needed
		  // for array literals).

		  pp$5.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
		    var elts = [], first = true;
		    while (!this.eat(close)) {
		      if (!first) {
		        this.expect(types$1.comma);
		        if (allowTrailingComma && this.afterTrailingComma(close)) { break }
		      } else { first = false; }

		      var elt = (void 0);
		      if (allowEmpty && this.type === types$1.comma)
		        { elt = null; }
		      else if (this.type === types$1.ellipsis) {
		        elt = this.parseSpread(refDestructuringErrors);
		        if (refDestructuringErrors && this.type === types$1.comma && refDestructuringErrors.trailingComma < 0)
		          { refDestructuringErrors.trailingComma = this.start; }
		      } else {
		        elt = this.parseMaybeAssign(false, refDestructuringErrors);
		      }
		      elts.push(elt);
		    }
		    return elts
		  };

		  pp$5.checkUnreserved = function(ref) {
		    var start = ref.start;
		    var end = ref.end;
		    var name = ref.name;

		    if (this.inGenerator && name === "yield")
		      { this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator"); }
		    if (this.inAsync && name === "await")
		      { this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function"); }
		    if (this.currentThisScope().inClassFieldInit && name === "arguments")
		      { this.raiseRecoverable(start, "Cannot use 'arguments' in class field initializer"); }
		    if (this.inClassStaticBlock && (name === "arguments" || name === "await"))
		      { this.raise(start, ("Cannot use " + name + " in class static initialization block")); }
		    if (this.keywords.test(name))
		      { this.raise(start, ("Unexpected keyword '" + name + "'")); }
		    if (this.options.ecmaVersion < 6 &&
		      this.input.slice(start, end).indexOf("\\") !== -1) { return }
		    var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
		    if (re.test(name)) {
		      if (!this.inAsync && name === "await")
		        { this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function"); }
		      this.raiseRecoverable(start, ("The keyword '" + name + "' is reserved"));
		    }
		  };

		  // Parse the next token as an identifier. If `liberal` is true (used
		  // when parsing properties), it will also convert keywords into
		  // identifiers.

		  pp$5.parseIdent = function(liberal) {
		    var node = this.parseIdentNode();
		    this.next(!!liberal);
		    this.finishNode(node, "Identifier");
		    if (!liberal) {
		      this.checkUnreserved(node);
		      if (node.name === "await" && !this.awaitIdentPos)
		        { this.awaitIdentPos = node.start; }
		    }
		    return node
		  };

		  pp$5.parseIdentNode = function() {
		    var node = this.startNode();
		    if (this.type === types$1.name) {
		      node.name = this.value;
		    } else if (this.type.keyword) {
		      node.name = this.type.keyword;

		      // To fix https://github.com/acornjs/acorn/issues/575
		      // `class` and `function` keywords push new context into this.context.
		      // But there is no chance to pop the context if the keyword is consumed as an identifier such as a property name.
		      // If the previous token is a dot, this does not apply because the context-managing code already ignored the keyword
		      if ((node.name === "class" || node.name === "function") &&
		        (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
		        this.context.pop();
		      }
		      this.type = types$1.name;
		    } else {
		      this.unexpected();
		    }
		    return node
		  };

		  pp$5.parsePrivateIdent = function() {
		    var node = this.startNode();
		    if (this.type === types$1.privateId) {
		      node.name = this.value;
		    } else {
		      this.unexpected();
		    }
		    this.next();
		    this.finishNode(node, "PrivateIdentifier");

		    // For validating existence
		    if (this.options.checkPrivateFields) {
		      if (this.privateNameStack.length === 0) {
		        this.raise(node.start, ("Private field '#" + (node.name) + "' must be declared in an enclosing class"));
		      } else {
		        this.privateNameStack[this.privateNameStack.length - 1].used.push(node);
		      }
		    }

		    return node
		  };

		  // Parses yield expression inside generator.

		  pp$5.parseYield = function(forInit) {
		    if (!this.yieldPos) { this.yieldPos = this.start; }

		    var node = this.startNode();
		    this.next();
		    if (this.type === types$1.semi || this.canInsertSemicolon() || (this.type !== types$1.star && !this.type.startsExpr)) {
		      node.delegate = false;
		      node.argument = null;
		    } else {
		      node.delegate = this.eat(types$1.star);
		      node.argument = this.parseMaybeAssign(forInit);
		    }
		    return this.finishNode(node, "YieldExpression")
		  };

		  pp$5.parseAwait = function(forInit) {
		    if (!this.awaitPos) { this.awaitPos = this.start; }

		    var node = this.startNode();
		    this.next();
		    node.argument = this.parseMaybeUnary(null, true, false, forInit);
		    return this.finishNode(node, "AwaitExpression")
		  };

		  var pp$4 = Parser.prototype;

		  // This function is used to raise exceptions on parse errors. It
		  // takes an offset integer (into the current `input`) to indicate
		  // the location of the error, attaches the position to the end
		  // of the error message, and then raises a `SyntaxError` with that
		  // message.

		  pp$4.raise = function(pos, message) {
		    var loc = getLineInfo(this.input, pos);
		    message += " (" + loc.line + ":" + loc.column + ")";
		    var err = new SyntaxError(message);
		    err.pos = pos; err.loc = loc; err.raisedAt = this.pos;
		    throw err
		  };

		  pp$4.raiseRecoverable = pp$4.raise;

		  pp$4.curPosition = function() {
		    if (this.options.locations) {
		      return new Position(this.curLine, this.pos - this.lineStart)
		    }
		  };

		  var pp$3 = Parser.prototype;

		  var Scope = function Scope(flags) {
		    this.flags = flags;
		    // A list of var-declared names in the current lexical scope
		    this.var = [];
		    // A list of lexically-declared names in the current lexical scope
		    this.lexical = [];
		    // A list of lexically-declared FunctionDeclaration names in the current lexical scope
		    this.functions = [];
		    // A switch to disallow the identifier reference 'arguments'
		    this.inClassFieldInit = false;
		  };

		  // The functions in this module keep track of declared variables in the current scope in order to detect duplicate variable names.

		  pp$3.enterScope = function(flags) {
		    this.scopeStack.push(new Scope(flags));
		  };

		  pp$3.exitScope = function() {
		    this.scopeStack.pop();
		  };

		  // The spec says:
		  // > At the top level of a function, or script, function declarations are
		  // > treated like var declarations rather than like lexical declarations.
		  pp$3.treatFunctionsAsVarInScope = function(scope) {
		    return (scope.flags & SCOPE_FUNCTION) || !this.inModule && (scope.flags & SCOPE_TOP)
		  };

		  pp$3.declareName = function(name, bindingType, pos) {
		    var redeclared = false;
		    if (bindingType === BIND_LEXICAL) {
		      var scope = this.currentScope();
		      redeclared = scope.lexical.indexOf(name) > -1 || scope.functions.indexOf(name) > -1 || scope.var.indexOf(name) > -1;
		      scope.lexical.push(name);
		      if (this.inModule && (scope.flags & SCOPE_TOP))
		        { delete this.undefinedExports[name]; }
		    } else if (bindingType === BIND_SIMPLE_CATCH) {
		      var scope$1 = this.currentScope();
		      scope$1.lexical.push(name);
		    } else if (bindingType === BIND_FUNCTION) {
		      var scope$2 = this.currentScope();
		      if (this.treatFunctionsAsVar)
		        { redeclared = scope$2.lexical.indexOf(name) > -1; }
		      else
		        { redeclared = scope$2.lexical.indexOf(name) > -1 || scope$2.var.indexOf(name) > -1; }
		      scope$2.functions.push(name);
		    } else {
		      for (var i = this.scopeStack.length - 1; i >= 0; --i) {
		        var scope$3 = this.scopeStack[i];
		        if (scope$3.lexical.indexOf(name) > -1 && !((scope$3.flags & SCOPE_SIMPLE_CATCH) && scope$3.lexical[0] === name) ||
		            !this.treatFunctionsAsVarInScope(scope$3) && scope$3.functions.indexOf(name) > -1) {
		          redeclared = true;
		          break
		        }
		        scope$3.var.push(name);
		        if (this.inModule && (scope$3.flags & SCOPE_TOP))
		          { delete this.undefinedExports[name]; }
		        if (scope$3.flags & SCOPE_VAR) { break }
		      }
		    }
		    if (redeclared) { this.raiseRecoverable(pos, ("Identifier '" + name + "' has already been declared")); }
		  };

		  pp$3.checkLocalExport = function(id) {
		    // scope.functions must be empty as Module code is always strict.
		    if (this.scopeStack[0].lexical.indexOf(id.name) === -1 &&
		        this.scopeStack[0].var.indexOf(id.name) === -1) {
		      this.undefinedExports[id.name] = id;
		    }
		  };

		  pp$3.currentScope = function() {
		    return this.scopeStack[this.scopeStack.length - 1]
		  };

		  pp$3.currentVarScope = function() {
		    for (var i = this.scopeStack.length - 1;; i--) {
		      var scope = this.scopeStack[i];
		      if (scope.flags & SCOPE_VAR) { return scope }
		    }
		  };

		  // Could be useful for `this`, `new.target`, `super()`, `super.property`, and `super[property]`.
		  pp$3.currentThisScope = function() {
		    for (var i = this.scopeStack.length - 1;; i--) {
		      var scope = this.scopeStack[i];
		      if (scope.flags & SCOPE_VAR && !(scope.flags & SCOPE_ARROW)) { return scope }
		    }
		  };

		  var Node = function Node(parser, pos, loc) {
		    this.type = "";
		    this.start = pos;
		    this.end = 0;
		    if (parser.options.locations)
		      { this.loc = new SourceLocation(parser, loc); }
		    if (parser.options.directSourceFile)
		      { this.sourceFile = parser.options.directSourceFile; }
		    if (parser.options.ranges)
		      { this.range = [pos, 0]; }
		  };

		  // Start an AST node, attaching a start offset.

		  var pp$2 = Parser.prototype;

		  pp$2.startNode = function() {
		    return new Node(this, this.start, this.startLoc)
		  };

		  pp$2.startNodeAt = function(pos, loc) {
		    return new Node(this, pos, loc)
		  };

		  // Finish an AST node, adding `type` and `end` properties.

		  function finishNodeAt(node, type, pos, loc) {
		    node.type = type;
		    node.end = pos;
		    if (this.options.locations)
		      { node.loc.end = loc; }
		    if (this.options.ranges)
		      { node.range[1] = pos; }
		    return node
		  }

		  pp$2.finishNode = function(node, type) {
		    return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc)
		  };

		  // Finish node at given position

		  pp$2.finishNodeAt = function(node, type, pos, loc) {
		    return finishNodeAt.call(this, node, type, pos, loc)
		  };

		  pp$2.copyNode = function(node) {
		    var newNode = new Node(this, node.start, this.startLoc);
		    for (var prop in node) { newNode[prop] = node[prop]; }
		    return newNode
		  };

		  // This file was generated by "bin/generate-unicode-script-values.js". Do not modify manually!
		  var scriptValuesAddedInUnicode = "Gara Garay Gukh Gurung_Khema Hrkt Katakana_Or_Hiragana Kawi Kirat_Rai Krai Nag_Mundari Nagm Ol_Onal Onao Sunu Sunuwar Todhri Todr Tulu_Tigalari Tutg Unknown Zzzz";

		  // This file contains Unicode properties extracted from the ECMAScript specification.
		  // The lists are extracted like so:
		  // $$('#table-binary-unicode-properties > figure > table > tbody > tr > td:nth-child(1) code').map(el => el.innerText)

		  // #table-binary-unicode-properties
		  var ecma9BinaryProperties = "ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS";
		  var ecma10BinaryProperties = ecma9BinaryProperties + " Extended_Pictographic";
		  var ecma11BinaryProperties = ecma10BinaryProperties;
		  var ecma12BinaryProperties = ecma11BinaryProperties + " EBase EComp EMod EPres ExtPict";
		  var ecma13BinaryProperties = ecma12BinaryProperties;
		  var ecma14BinaryProperties = ecma13BinaryProperties;

		  var unicodeBinaryProperties = {
		    9: ecma9BinaryProperties,
		    10: ecma10BinaryProperties,
		    11: ecma11BinaryProperties,
		    12: ecma12BinaryProperties,
		    13: ecma13BinaryProperties,
		    14: ecma14BinaryProperties
		  };

		  // #table-binary-unicode-properties-of-strings
		  var ecma14BinaryPropertiesOfStrings = "Basic_Emoji Emoji_Keycap_Sequence RGI_Emoji_Modifier_Sequence RGI_Emoji_Flag_Sequence RGI_Emoji_Tag_Sequence RGI_Emoji_ZWJ_Sequence RGI_Emoji";

		  var unicodeBinaryPropertiesOfStrings = {
		    9: "",
		    10: "",
		    11: "",
		    12: "",
		    13: "",
		    14: ecma14BinaryPropertiesOfStrings
		  };

		  // #table-unicode-general-category-values
		  var unicodeGeneralCategoryValues = "Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu";

		  // #table-unicode-script-values
		  var ecma9ScriptValues = "Adlam Adlm Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb";
		  var ecma10ScriptValues = ecma9ScriptValues + " Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd";
		  var ecma11ScriptValues = ecma10ScriptValues + " Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho";
		  var ecma12ScriptValues = ecma11ScriptValues + " Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi";
		  var ecma13ScriptValues = ecma12ScriptValues + " Cypro_Minoan Cpmn Old_Uyghur Ougr Tangsa Tnsa Toto Vithkuqi Vith";
		  var ecma14ScriptValues = ecma13ScriptValues + " " + scriptValuesAddedInUnicode;

		  var unicodeScriptValues = {
		    9: ecma9ScriptValues,
		    10: ecma10ScriptValues,
		    11: ecma11ScriptValues,
		    12: ecma12ScriptValues,
		    13: ecma13ScriptValues,
		    14: ecma14ScriptValues
		  };

		  var data = {};
		  function buildUnicodeData(ecmaVersion) {
		    var d = data[ecmaVersion] = {
		      binary: wordsRegexp(unicodeBinaryProperties[ecmaVersion] + " " + unicodeGeneralCategoryValues),
		      binaryOfStrings: wordsRegexp(unicodeBinaryPropertiesOfStrings[ecmaVersion]),
		      nonBinary: {
		        General_Category: wordsRegexp(unicodeGeneralCategoryValues),
		        Script: wordsRegexp(unicodeScriptValues[ecmaVersion])
		      }
		    };
		    d.nonBinary.Script_Extensions = d.nonBinary.Script;

		    d.nonBinary.gc = d.nonBinary.General_Category;
		    d.nonBinary.sc = d.nonBinary.Script;
		    d.nonBinary.scx = d.nonBinary.Script_Extensions;
		  }

		  for (var i = 0, list = [9, 10, 11, 12, 13, 14]; i < list.length; i += 1) {
		    var ecmaVersion = list[i];

		    buildUnicodeData(ecmaVersion);
		  }

		  var pp$1 = Parser.prototype;

		  // Track disjunction structure to determine whether a duplicate
		  // capture group name is allowed because it is in a separate branch.
		  var BranchID = function BranchID(parent, base) {
		    // Parent disjunction branch
		    this.parent = parent;
		    // Identifies this set of sibling branches
		    this.base = base || this;
		  };

		  BranchID.prototype.separatedFrom = function separatedFrom (alt) {
		    // A branch is separate from another branch if they or any of
		    // their parents are siblings in a given disjunction
		    for (var self = this; self; self = self.parent) {
		      for (var other = alt; other; other = other.parent) {
		        if (self.base === other.base && self !== other) { return true }
		      }
		    }
		    return false
		  };

		  BranchID.prototype.sibling = function sibling () {
		    return new BranchID(this.parent, this.base)
		  };

		  var RegExpValidationState = function RegExpValidationState(parser) {
		    this.parser = parser;
		    this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "") + (parser.options.ecmaVersion >= 13 ? "d" : "") + (parser.options.ecmaVersion >= 15 ? "v" : "");
		    this.unicodeProperties = data[parser.options.ecmaVersion >= 14 ? 14 : parser.options.ecmaVersion];
		    this.source = "";
		    this.flags = "";
		    this.start = 0;
		    this.switchU = false;
		    this.switchV = false;
		    this.switchN = false;
		    this.pos = 0;
		    this.lastIntValue = 0;
		    this.lastStringValue = "";
		    this.lastAssertionIsQuantifiable = false;
		    this.numCapturingParens = 0;
		    this.maxBackReference = 0;
		    this.groupNames = Object.create(null);
		    this.backReferenceNames = [];
		    this.branchID = null;
		  };

		  RegExpValidationState.prototype.reset = function reset (start, pattern, flags) {
		    var unicodeSets = flags.indexOf("v") !== -1;
		    var unicode = flags.indexOf("u") !== -1;
		    this.start = start | 0;
		    this.source = pattern + "";
		    this.flags = flags;
		    if (unicodeSets && this.parser.options.ecmaVersion >= 15) {
		      this.switchU = true;
		      this.switchV = true;
		      this.switchN = true;
		    } else {
		      this.switchU = unicode && this.parser.options.ecmaVersion >= 6;
		      this.switchV = false;
		      this.switchN = unicode && this.parser.options.ecmaVersion >= 9;
		    }
		  };

		  RegExpValidationState.prototype.raise = function raise (message) {
		    this.parser.raiseRecoverable(this.start, ("Invalid regular expression: /" + (this.source) + "/: " + message));
		  };

		  // If u flag is given, this returns the code point at the index (it combines a surrogate pair).
		  // Otherwise, this returns the code unit of the index (can be a part of a surrogate pair).
		  RegExpValidationState.prototype.at = function at (i, forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    var s = this.source;
		    var l = s.length;
		    if (i >= l) {
		      return -1
		    }
		    var c = s.charCodeAt(i);
		    if (!(forceU || this.switchU) || c <= 0xD7FF || c >= 0xE000 || i + 1 >= l) {
		      return c
		    }
		    var next = s.charCodeAt(i + 1);
		    return next >= 0xDC00 && next <= 0xDFFF ? (c << 10) + next - 0x35FDC00 : c
		  };

		  RegExpValidationState.prototype.nextIndex = function nextIndex (i, forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    var s = this.source;
		    var l = s.length;
		    if (i >= l) {
		      return l
		    }
		    var c = s.charCodeAt(i), next;
		    if (!(forceU || this.switchU) || c <= 0xD7FF || c >= 0xE000 || i + 1 >= l ||
		        (next = s.charCodeAt(i + 1)) < 0xDC00 || next > 0xDFFF) {
		      return i + 1
		    }
		    return i + 2
		  };

		  RegExpValidationState.prototype.current = function current (forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    return this.at(this.pos, forceU)
		  };

		  RegExpValidationState.prototype.lookahead = function lookahead (forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    return this.at(this.nextIndex(this.pos, forceU), forceU)
		  };

		  RegExpValidationState.prototype.advance = function advance (forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    this.pos = this.nextIndex(this.pos, forceU);
		  };

		  RegExpValidationState.prototype.eat = function eat (ch, forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    if (this.current(forceU) === ch) {
		      this.advance(forceU);
		      return true
		    }
		    return false
		  };

		  RegExpValidationState.prototype.eatChars = function eatChars (chs, forceU) {
		      if ( forceU === void 0 ) forceU = false;

		    var pos = this.pos;
		    for (var i = 0, list = chs; i < list.length; i += 1) {
		      var ch = list[i];

		        var current = this.at(pos, forceU);
		      if (current === -1 || current !== ch) {
		        return false
		      }
		      pos = this.nextIndex(pos, forceU);
		    }
		    this.pos = pos;
		    return true
		  };

		  /**
		   * Validate the flags part of a given RegExpLiteral.
		   *
		   * @param {RegExpValidationState} state The state to validate RegExp.
		   * @returns {void}
		   */
		  pp$1.validateRegExpFlags = function(state) {
		    var validFlags = state.validFlags;
		    var flags = state.flags;

		    var u = false;
		    var v = false;

		    for (var i = 0; i < flags.length; i++) {
		      var flag = flags.charAt(i);
		      if (validFlags.indexOf(flag) === -1) {
		        this.raise(state.start, "Invalid regular expression flag");
		      }
		      if (flags.indexOf(flag, i + 1) > -1) {
		        this.raise(state.start, "Duplicate regular expression flag");
		      }
		      if (flag === "u") { u = true; }
		      if (flag === "v") { v = true; }
		    }
		    if (this.options.ecmaVersion >= 15 && u && v) {
		      this.raise(state.start, "Invalid regular expression flag");
		    }
		  };

		  function hasProp(obj) {
		    for (var _ in obj) { return true }
		    return false
		  }

		  /**
		   * Validate the pattern part of a given RegExpLiteral.
		   *
		   * @param {RegExpValidationState} state The state to validate RegExp.
		   * @returns {void}
		   */
		  pp$1.validateRegExpPattern = function(state) {
		    this.regexp_pattern(state);

		    // The goal symbol for the parse is |Pattern[~U, ~N]|. If the result of
		    // parsing contains a |GroupName|, reparse with the goal symbol
		    // |Pattern[~U, +N]| and use this result instead. Throw a *SyntaxError*
		    // exception if _P_ did not conform to the grammar, if any elements of _P_
		    // were not matched by the parse, or if any Early Error conditions exist.
		    if (!state.switchN && this.options.ecmaVersion >= 9 && hasProp(state.groupNames)) {
		      state.switchN = true;
		      this.regexp_pattern(state);
		    }
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-Pattern
		  pp$1.regexp_pattern = function(state) {
		    state.pos = 0;
		    state.lastIntValue = 0;
		    state.lastStringValue = "";
		    state.lastAssertionIsQuantifiable = false;
		    state.numCapturingParens = 0;
		    state.maxBackReference = 0;
		    state.groupNames = Object.create(null);
		    state.backReferenceNames.length = 0;
		    state.branchID = null;

		    this.regexp_disjunction(state);

		    if (state.pos !== state.source.length) {
		      // Make the same messages as V8.
		      if (state.eat(0x29 /* ) */)) {
		        state.raise("Unmatched ')'");
		      }
		      if (state.eat(0x5D /* ] */) || state.eat(0x7D /* } */)) {
		        state.raise("Lone quantifier brackets");
		      }
		    }
		    if (state.maxBackReference > state.numCapturingParens) {
		      state.raise("Invalid escape");
		    }
		    for (var i = 0, list = state.backReferenceNames; i < list.length; i += 1) {
		      var name = list[i];

		      if (!state.groupNames[name]) {
		        state.raise("Invalid named capture referenced");
		      }
		    }
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-Disjunction
		  pp$1.regexp_disjunction = function(state) {
		    var trackDisjunction = this.options.ecmaVersion >= 16;
		    if (trackDisjunction) { state.branchID = new BranchID(state.branchID, null); }
		    this.regexp_alternative(state);
		    while (state.eat(0x7C /* | */)) {
		      if (trackDisjunction) { state.branchID = state.branchID.sibling(); }
		      this.regexp_alternative(state);
		    }
		    if (trackDisjunction) { state.branchID = state.branchID.parent; }

		    // Make the same message as V8.
		    if (this.regexp_eatQuantifier(state, true)) {
		      state.raise("Nothing to repeat");
		    }
		    if (state.eat(0x7B /* { */)) {
		      state.raise("Lone quantifier brackets");
		    }
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-Alternative
		  pp$1.regexp_alternative = function(state) {
		    while (state.pos < state.source.length && this.regexp_eatTerm(state)) {}
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-Term
		  pp$1.regexp_eatTerm = function(state) {
		    if (this.regexp_eatAssertion(state)) {
		      // Handle `QuantifiableAssertion Quantifier` alternative.
		      // `state.lastAssertionIsQuantifiable` is true if the last eaten Assertion
		      // is a QuantifiableAssertion.
		      if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
		        // Make the same message as V8.
		        if (state.switchU) {
		          state.raise("Invalid quantifier");
		        }
		      }
		      return true
		    }

		    if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
		      this.regexp_eatQuantifier(state);
		      return true
		    }

		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-Assertion
		  pp$1.regexp_eatAssertion = function(state) {
		    var start = state.pos;
		    state.lastAssertionIsQuantifiable = false;

		    // ^, $
		    if (state.eat(0x5E /* ^ */) || state.eat(0x24 /* $ */)) {
		      return true
		    }

		    // \b \B
		    if (state.eat(0x5C /* \ */)) {
		      if (state.eat(0x42 /* B */) || state.eat(0x62 /* b */)) {
		        return true
		      }
		      state.pos = start;
		    }

		    // Lookahead / Lookbehind
		    if (state.eat(0x28 /* ( */) && state.eat(0x3F /* ? */)) {
		      var lookbehind = false;
		      if (this.options.ecmaVersion >= 9) {
		        lookbehind = state.eat(0x3C /* < */);
		      }
		      if (state.eat(0x3D /* = */) || state.eat(0x21 /* ! */)) {
		        this.regexp_disjunction(state);
		        if (!state.eat(0x29 /* ) */)) {
		          state.raise("Unterminated group");
		        }
		        state.lastAssertionIsQuantifiable = !lookbehind;
		        return true
		      }
		    }

		    state.pos = start;
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-Quantifier
		  pp$1.regexp_eatQuantifier = function(state, noError) {
		    if ( noError === void 0 ) noError = false;

		    if (this.regexp_eatQuantifierPrefix(state, noError)) {
		      state.eat(0x3F /* ? */);
		      return true
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-QuantifierPrefix
		  pp$1.regexp_eatQuantifierPrefix = function(state, noError) {
		    return (
		      state.eat(0x2A /* * */) ||
		      state.eat(0x2B /* + */) ||
		      state.eat(0x3F /* ? */) ||
		      this.regexp_eatBracedQuantifier(state, noError)
		    )
		  };
		  pp$1.regexp_eatBracedQuantifier = function(state, noError) {
		    var start = state.pos;
		    if (state.eat(0x7B /* { */)) {
		      var min = 0, max = -1;
		      if (this.regexp_eatDecimalDigits(state)) {
		        min = state.lastIntValue;
		        if (state.eat(0x2C /* , */) && this.regexp_eatDecimalDigits(state)) {
		          max = state.lastIntValue;
		        }
		        if (state.eat(0x7D /* } */)) {
		          // SyntaxError in https://www.ecma-international.org/ecma-262/8.0/#sec-term
		          if (max !== -1 && max < min && !noError) {
		            state.raise("numbers out of order in {} quantifier");
		          }
		          return true
		        }
		      }
		      if (state.switchU && !noError) {
		        state.raise("Incomplete quantifier");
		      }
		      state.pos = start;
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-Atom
		  pp$1.regexp_eatAtom = function(state) {
		    return (
		      this.regexp_eatPatternCharacters(state) ||
		      state.eat(0x2E /* . */) ||
		      this.regexp_eatReverseSolidusAtomEscape(state) ||
		      this.regexp_eatCharacterClass(state) ||
		      this.regexp_eatUncapturingGroup(state) ||
		      this.regexp_eatCapturingGroup(state)
		    )
		  };
		  pp$1.regexp_eatReverseSolidusAtomEscape = function(state) {
		    var start = state.pos;
		    if (state.eat(0x5C /* \ */)) {
		      if (this.regexp_eatAtomEscape(state)) {
		        return true
		      }
		      state.pos = start;
		    }
		    return false
		  };
		  pp$1.regexp_eatUncapturingGroup = function(state) {
		    var start = state.pos;
		    if (state.eat(0x28 /* ( */)) {
		      if (state.eat(0x3F /* ? */)) {
		        if (this.options.ecmaVersion >= 16) {
		          var addModifiers = this.regexp_eatModifiers(state);
		          var hasHyphen = state.eat(0x2D /* - */);
		          if (addModifiers || hasHyphen) {
		            for (var i = 0; i < addModifiers.length; i++) {
		              var modifier = addModifiers.charAt(i);
		              if (addModifiers.indexOf(modifier, i + 1) > -1) {
		                state.raise("Duplicate regular expression modifiers");
		              }
		            }
		            if (hasHyphen) {
		              var removeModifiers = this.regexp_eatModifiers(state);
		              if (!addModifiers && !removeModifiers && state.current() === 0x3A /* : */) {
		                state.raise("Invalid regular expression modifiers");
		              }
		              for (var i$1 = 0; i$1 < removeModifiers.length; i$1++) {
		                var modifier$1 = removeModifiers.charAt(i$1);
		                if (
		                  removeModifiers.indexOf(modifier$1, i$1 + 1) > -1 ||
		                  addModifiers.indexOf(modifier$1) > -1
		                ) {
		                  state.raise("Duplicate regular expression modifiers");
		                }
		              }
		            }
		          }
		        }
		        if (state.eat(0x3A /* : */)) {
		          this.regexp_disjunction(state);
		          if (state.eat(0x29 /* ) */)) {
		            return true
		          }
		          state.raise("Unterminated group");
		        }
		      }
		      state.pos = start;
		    }
		    return false
		  };
		  pp$1.regexp_eatCapturingGroup = function(state) {
		    if (state.eat(0x28 /* ( */)) {
		      if (this.options.ecmaVersion >= 9) {
		        this.regexp_groupSpecifier(state);
		      } else if (state.current() === 0x3F /* ? */) {
		        state.raise("Invalid group");
		      }
		      this.regexp_disjunction(state);
		      if (state.eat(0x29 /* ) */)) {
		        state.numCapturingParens += 1;
		        return true
		      }
		      state.raise("Unterminated group");
		    }
		    return false
		  };
		  // RegularExpressionModifiers ::
		  //   [empty]
		  //   RegularExpressionModifiers RegularExpressionModifier
		  pp$1.regexp_eatModifiers = function(state) {
		    var modifiers = "";
		    var ch = 0;
		    while ((ch = state.current()) !== -1 && isRegularExpressionModifier(ch)) {
		      modifiers += codePointToString(ch);
		      state.advance();
		    }
		    return modifiers
		  };
		  // RegularExpressionModifier :: one of
		  //   `i` `m` `s`
		  function isRegularExpressionModifier(ch) {
		    return ch === 0x69 /* i */ || ch === 0x6d /* m */ || ch === 0x73 /* s */
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ExtendedAtom
		  pp$1.regexp_eatExtendedAtom = function(state) {
		    return (
		      state.eat(0x2E /* . */) ||
		      this.regexp_eatReverseSolidusAtomEscape(state) ||
		      this.regexp_eatCharacterClass(state) ||
		      this.regexp_eatUncapturingGroup(state) ||
		      this.regexp_eatCapturingGroup(state) ||
		      this.regexp_eatInvalidBracedQuantifier(state) ||
		      this.regexp_eatExtendedPatternCharacter(state)
		    )
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-InvalidBracedQuantifier
		  pp$1.regexp_eatInvalidBracedQuantifier = function(state) {
		    if (this.regexp_eatBracedQuantifier(state, true)) {
		      state.raise("Nothing to repeat");
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-SyntaxCharacter
		  pp$1.regexp_eatSyntaxCharacter = function(state) {
		    var ch = state.current();
		    if (isSyntaxCharacter(ch)) {
		      state.lastIntValue = ch;
		      state.advance();
		      return true
		    }
		    return false
		  };
		  function isSyntaxCharacter(ch) {
		    return (
		      ch === 0x24 /* $ */ ||
		      ch >= 0x28 /* ( */ && ch <= 0x2B /* + */ ||
		      ch === 0x2E /* . */ ||
		      ch === 0x3F /* ? */ ||
		      ch >= 0x5B /* [ */ && ch <= 0x5E /* ^ */ ||
		      ch >= 0x7B /* { */ && ch <= 0x7D /* } */
		    )
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-PatternCharacter
		  // But eat eager.
		  pp$1.regexp_eatPatternCharacters = function(state) {
		    var start = state.pos;
		    var ch = 0;
		    while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
		      state.advance();
		    }
		    return state.pos !== start
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ExtendedPatternCharacter
		  pp$1.regexp_eatExtendedPatternCharacter = function(state) {
		    var ch = state.current();
		    if (
		      ch !== -1 &&
		      ch !== 0x24 /* $ */ &&
		      !(ch >= 0x28 /* ( */ && ch <= 0x2B /* + */) &&
		      ch !== 0x2E /* . */ &&
		      ch !== 0x3F /* ? */ &&
		      ch !== 0x5B /* [ */ &&
		      ch !== 0x5E /* ^ */ &&
		      ch !== 0x7C /* | */
		    ) {
		      state.advance();
		      return true
		    }
		    return false
		  };

		  // GroupSpecifier ::
		  //   [empty]
		  //   `?` GroupName
		  pp$1.regexp_groupSpecifier = function(state) {
		    if (state.eat(0x3F /* ? */)) {
		      if (!this.regexp_eatGroupName(state)) { state.raise("Invalid group"); }
		      var trackDisjunction = this.options.ecmaVersion >= 16;
		      var known = state.groupNames[state.lastStringValue];
		      if (known) {
		        if (trackDisjunction) {
		          for (var i = 0, list = known; i < list.length; i += 1) {
		            var altID = list[i];

		            if (!altID.separatedFrom(state.branchID))
		              { state.raise("Duplicate capture group name"); }
		          }
		        } else {
		          state.raise("Duplicate capture group name");
		        }
		      }
		      if (trackDisjunction) {
		        (known || (state.groupNames[state.lastStringValue] = [])).push(state.branchID);
		      } else {
		        state.groupNames[state.lastStringValue] = true;
		      }
		    }
		  };

		  // GroupName ::
		  //   `<` RegExpIdentifierName `>`
		  // Note: this updates `state.lastStringValue` property with the eaten name.
		  pp$1.regexp_eatGroupName = function(state) {
		    state.lastStringValue = "";
		    if (state.eat(0x3C /* < */)) {
		      if (this.regexp_eatRegExpIdentifierName(state) && state.eat(0x3E /* > */)) {
		        return true
		      }
		      state.raise("Invalid capture group name");
		    }
		    return false
		  };

		  // RegExpIdentifierName ::
		  //   RegExpIdentifierStart
		  //   RegExpIdentifierName RegExpIdentifierPart
		  // Note: this updates `state.lastStringValue` property with the eaten name.
		  pp$1.regexp_eatRegExpIdentifierName = function(state) {
		    state.lastStringValue = "";
		    if (this.regexp_eatRegExpIdentifierStart(state)) {
		      state.lastStringValue += codePointToString(state.lastIntValue);
		      while (this.regexp_eatRegExpIdentifierPart(state)) {
		        state.lastStringValue += codePointToString(state.lastIntValue);
		      }
		      return true
		    }
		    return false
		  };

		  // RegExpIdentifierStart ::
		  //   UnicodeIDStart
		  //   `$`
		  //   `_`
		  //   `\` RegExpUnicodeEscapeSequence[+U]
		  pp$1.regexp_eatRegExpIdentifierStart = function(state) {
		    var start = state.pos;
		    var forceU = this.options.ecmaVersion >= 11;
		    var ch = state.current(forceU);
		    state.advance(forceU);

		    if (ch === 0x5C /* \ */ && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
		      ch = state.lastIntValue;
		    }
		    if (isRegExpIdentifierStart(ch)) {
		      state.lastIntValue = ch;
		      return true
		    }

		    state.pos = start;
		    return false
		  };
		  function isRegExpIdentifierStart(ch) {
		    return isIdentifierStart(ch, true) || ch === 0x24 /* $ */ || ch === 0x5F /* _ */
		  }

		  // RegExpIdentifierPart ::
		  //   UnicodeIDContinue
		  //   `$`
		  //   `_`
		  //   `\` RegExpUnicodeEscapeSequence[+U]
		  //   <ZWNJ>
		  //   <ZWJ>
		  pp$1.regexp_eatRegExpIdentifierPart = function(state) {
		    var start = state.pos;
		    var forceU = this.options.ecmaVersion >= 11;
		    var ch = state.current(forceU);
		    state.advance(forceU);

		    if (ch === 0x5C /* \ */ && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
		      ch = state.lastIntValue;
		    }
		    if (isRegExpIdentifierPart(ch)) {
		      state.lastIntValue = ch;
		      return true
		    }

		    state.pos = start;
		    return false
		  };
		  function isRegExpIdentifierPart(ch) {
		    return isIdentifierChar(ch, true) || ch === 0x24 /* $ */ || ch === 0x5F /* _ */ || ch === 0x200C /* <ZWNJ> */ || ch === 0x200D /* <ZWJ> */
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-AtomEscape
		  pp$1.regexp_eatAtomEscape = function(state) {
		    if (
		      this.regexp_eatBackReference(state) ||
		      this.regexp_eatCharacterClassEscape(state) ||
		      this.regexp_eatCharacterEscape(state) ||
		      (state.switchN && this.regexp_eatKGroupName(state))
		    ) {
		      return true
		    }
		    if (state.switchU) {
		      // Make the same message as V8.
		      if (state.current() === 0x63 /* c */) {
		        state.raise("Invalid unicode escape");
		      }
		      state.raise("Invalid escape");
		    }
		    return false
		  };
		  pp$1.regexp_eatBackReference = function(state) {
		    var start = state.pos;
		    if (this.regexp_eatDecimalEscape(state)) {
		      var n = state.lastIntValue;
		      if (state.switchU) {
		        // For SyntaxError in https://www.ecma-international.org/ecma-262/8.0/#sec-atomescape
		        if (n > state.maxBackReference) {
		          state.maxBackReference = n;
		        }
		        return true
		      }
		      if (n <= state.numCapturingParens) {
		        return true
		      }
		      state.pos = start;
		    }
		    return false
		  };
		  pp$1.regexp_eatKGroupName = function(state) {
		    if (state.eat(0x6B /* k */)) {
		      if (this.regexp_eatGroupName(state)) {
		        state.backReferenceNames.push(state.lastStringValue);
		        return true
		      }
		      state.raise("Invalid named reference");
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-CharacterEscape
		  pp$1.regexp_eatCharacterEscape = function(state) {
		    return (
		      this.regexp_eatControlEscape(state) ||
		      this.regexp_eatCControlLetter(state) ||
		      this.regexp_eatZero(state) ||
		      this.regexp_eatHexEscapeSequence(state) ||
		      this.regexp_eatRegExpUnicodeEscapeSequence(state, false) ||
		      (!state.switchU && this.regexp_eatLegacyOctalEscapeSequence(state)) ||
		      this.regexp_eatIdentityEscape(state)
		    )
		  };
		  pp$1.regexp_eatCControlLetter = function(state) {
		    var start = state.pos;
		    if (state.eat(0x63 /* c */)) {
		      if (this.regexp_eatControlLetter(state)) {
		        return true
		      }
		      state.pos = start;
		    }
		    return false
		  };
		  pp$1.regexp_eatZero = function(state) {
		    if (state.current() === 0x30 /* 0 */ && !isDecimalDigit(state.lookahead())) {
		      state.lastIntValue = 0;
		      state.advance();
		      return true
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-ControlEscape
		  pp$1.regexp_eatControlEscape = function(state) {
		    var ch = state.current();
		    if (ch === 0x74 /* t */) {
		      state.lastIntValue = 0x09; /* \t */
		      state.advance();
		      return true
		    }
		    if (ch === 0x6E /* n */) {
		      state.lastIntValue = 0x0A; /* \n */
		      state.advance();
		      return true
		    }
		    if (ch === 0x76 /* v */) {
		      state.lastIntValue = 0x0B; /* \v */
		      state.advance();
		      return true
		    }
		    if (ch === 0x66 /* f */) {
		      state.lastIntValue = 0x0C; /* \f */
		      state.advance();
		      return true
		    }
		    if (ch === 0x72 /* r */) {
		      state.lastIntValue = 0x0D; /* \r */
		      state.advance();
		      return true
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-ControlLetter
		  pp$1.regexp_eatControlLetter = function(state) {
		    var ch = state.current();
		    if (isControlLetter(ch)) {
		      state.lastIntValue = ch % 0x20;
		      state.advance();
		      return true
		    }
		    return false
		  };
		  function isControlLetter(ch) {
		    return (
		      (ch >= 0x41 /* A */ && ch <= 0x5A /* Z */) ||
		      (ch >= 0x61 /* a */ && ch <= 0x7A /* z */)
		    )
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-RegExpUnicodeEscapeSequence
		  pp$1.regexp_eatRegExpUnicodeEscapeSequence = function(state, forceU) {
		    if ( forceU === void 0 ) forceU = false;

		    var start = state.pos;
		    var switchU = forceU || state.switchU;

		    if (state.eat(0x75 /* u */)) {
		      if (this.regexp_eatFixedHexDigits(state, 4)) {
		        var lead = state.lastIntValue;
		        if (switchU && lead >= 0xD800 && lead <= 0xDBFF) {
		          var leadSurrogateEnd = state.pos;
		          if (state.eat(0x5C /* \ */) && state.eat(0x75 /* u */) && this.regexp_eatFixedHexDigits(state, 4)) {
		            var trail = state.lastIntValue;
		            if (trail >= 0xDC00 && trail <= 0xDFFF) {
		              state.lastIntValue = (lead - 0xD800) * 0x400 + (trail - 0xDC00) + 0x10000;
		              return true
		            }
		          }
		          state.pos = leadSurrogateEnd;
		          state.lastIntValue = lead;
		        }
		        return true
		      }
		      if (
		        switchU &&
		        state.eat(0x7B /* { */) &&
		        this.regexp_eatHexDigits(state) &&
		        state.eat(0x7D /* } */) &&
		        isValidUnicode(state.lastIntValue)
		      ) {
		        return true
		      }
		      if (switchU) {
		        state.raise("Invalid unicode escape");
		      }
		      state.pos = start;
		    }

		    return false
		  };
		  function isValidUnicode(ch) {
		    return ch >= 0 && ch <= 0x10FFFF
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-IdentityEscape
		  pp$1.regexp_eatIdentityEscape = function(state) {
		    if (state.switchU) {
		      if (this.regexp_eatSyntaxCharacter(state)) {
		        return true
		      }
		      if (state.eat(0x2F /* / */)) {
		        state.lastIntValue = 0x2F; /* / */
		        return true
		      }
		      return false
		    }

		    var ch = state.current();
		    if (ch !== 0x63 /* c */ && (!state.switchN || ch !== 0x6B /* k */)) {
		      state.lastIntValue = ch;
		      state.advance();
		      return true
		    }

		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-DecimalEscape
		  pp$1.regexp_eatDecimalEscape = function(state) {
		    state.lastIntValue = 0;
		    var ch = state.current();
		    if (ch >= 0x31 /* 1 */ && ch <= 0x39 /* 9 */) {
		      do {
		        state.lastIntValue = 10 * state.lastIntValue + (ch - 0x30 /* 0 */);
		        state.advance();
		      } while ((ch = state.current()) >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */)
		      return true
		    }
		    return false
		  };

		  // Return values used by character set parsing methods, needed to
		  // forbid negation of sets that can match strings.
		  var CharSetNone = 0; // Nothing parsed
		  var CharSetOk = 1; // Construct parsed, cannot contain strings
		  var CharSetString = 2; // Construct parsed, can contain strings

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-CharacterClassEscape
		  pp$1.regexp_eatCharacterClassEscape = function(state) {
		    var ch = state.current();

		    if (isCharacterClassEscape(ch)) {
		      state.lastIntValue = -1;
		      state.advance();
		      return CharSetOk
		    }

		    var negate = false;
		    if (
		      state.switchU &&
		      this.options.ecmaVersion >= 9 &&
		      ((negate = ch === 0x50 /* P */) || ch === 0x70 /* p */)
		    ) {
		      state.lastIntValue = -1;
		      state.advance();
		      var result;
		      if (
		        state.eat(0x7B /* { */) &&
		        (result = this.regexp_eatUnicodePropertyValueExpression(state)) &&
		        state.eat(0x7D /* } */)
		      ) {
		        if (negate && result === CharSetString) { state.raise("Invalid property name"); }
		        return result
		      }
		      state.raise("Invalid property name");
		    }

		    return CharSetNone
		  };

		  function isCharacterClassEscape(ch) {
		    return (
		      ch === 0x64 /* d */ ||
		      ch === 0x44 /* D */ ||
		      ch === 0x73 /* s */ ||
		      ch === 0x53 /* S */ ||
		      ch === 0x77 /* w */ ||
		      ch === 0x57 /* W */
		    )
		  }

		  // UnicodePropertyValueExpression ::
		  //   UnicodePropertyName `=` UnicodePropertyValue
		  //   LoneUnicodePropertyNameOrValue
		  pp$1.regexp_eatUnicodePropertyValueExpression = function(state) {
		    var start = state.pos;

		    // UnicodePropertyName `=` UnicodePropertyValue
		    if (this.regexp_eatUnicodePropertyName(state) && state.eat(0x3D /* = */)) {
		      var name = state.lastStringValue;
		      if (this.regexp_eatUnicodePropertyValue(state)) {
		        var value = state.lastStringValue;
		        this.regexp_validateUnicodePropertyNameAndValue(state, name, value);
		        return CharSetOk
		      }
		    }
		    state.pos = start;

		    // LoneUnicodePropertyNameOrValue
		    if (this.regexp_eatLoneUnicodePropertyNameOrValue(state)) {
		      var nameOrValue = state.lastStringValue;
		      return this.regexp_validateUnicodePropertyNameOrValue(state, nameOrValue)
		    }
		    return CharSetNone
		  };

		  pp$1.regexp_validateUnicodePropertyNameAndValue = function(state, name, value) {
		    if (!hasOwn(state.unicodeProperties.nonBinary, name))
		      { state.raise("Invalid property name"); }
		    if (!state.unicodeProperties.nonBinary[name].test(value))
		      { state.raise("Invalid property value"); }
		  };

		  pp$1.regexp_validateUnicodePropertyNameOrValue = function(state, nameOrValue) {
		    if (state.unicodeProperties.binary.test(nameOrValue)) { return CharSetOk }
		    if (state.switchV && state.unicodeProperties.binaryOfStrings.test(nameOrValue)) { return CharSetString }
		    state.raise("Invalid property name");
		  };

		  // UnicodePropertyName ::
		  //   UnicodePropertyNameCharacters
		  pp$1.regexp_eatUnicodePropertyName = function(state) {
		    var ch = 0;
		    state.lastStringValue = "";
		    while (isUnicodePropertyNameCharacter(ch = state.current())) {
		      state.lastStringValue += codePointToString(ch);
		      state.advance();
		    }
		    return state.lastStringValue !== ""
		  };

		  function isUnicodePropertyNameCharacter(ch) {
		    return isControlLetter(ch) || ch === 0x5F /* _ */
		  }

		  // UnicodePropertyValue ::
		  //   UnicodePropertyValueCharacters
		  pp$1.regexp_eatUnicodePropertyValue = function(state) {
		    var ch = 0;
		    state.lastStringValue = "";
		    while (isUnicodePropertyValueCharacter(ch = state.current())) {
		      state.lastStringValue += codePointToString(ch);
		      state.advance();
		    }
		    return state.lastStringValue !== ""
		  };
		  function isUnicodePropertyValueCharacter(ch) {
		    return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch)
		  }

		  // LoneUnicodePropertyNameOrValue ::
		  //   UnicodePropertyValueCharacters
		  pp$1.regexp_eatLoneUnicodePropertyNameOrValue = function(state) {
		    return this.regexp_eatUnicodePropertyValue(state)
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-CharacterClass
		  pp$1.regexp_eatCharacterClass = function(state) {
		    if (state.eat(0x5B /* [ */)) {
		      var negate = state.eat(0x5E /* ^ */);
		      var result = this.regexp_classContents(state);
		      if (!state.eat(0x5D /* ] */))
		        { state.raise("Unterminated character class"); }
		      if (negate && result === CharSetString)
		        { state.raise("Negated character class may contain strings"); }
		      return true
		    }
		    return false
		  };

		  // https://tc39.es/ecma262/#prod-ClassContents
		  // https://www.ecma-international.org/ecma-262/8.0/#prod-ClassRanges
		  pp$1.regexp_classContents = function(state) {
		    if (state.current() === 0x5D /* ] */) { return CharSetOk }
		    if (state.switchV) { return this.regexp_classSetExpression(state) }
		    this.regexp_nonEmptyClassRanges(state);
		    return CharSetOk
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-NonemptyClassRanges
		  // https://www.ecma-international.org/ecma-262/8.0/#prod-NonemptyClassRangesNoDash
		  pp$1.regexp_nonEmptyClassRanges = function(state) {
		    while (this.regexp_eatClassAtom(state)) {
		      var left = state.lastIntValue;
		      if (state.eat(0x2D /* - */) && this.regexp_eatClassAtom(state)) {
		        var right = state.lastIntValue;
		        if (state.switchU && (left === -1 || right === -1)) {
		          state.raise("Invalid character class");
		        }
		        if (left !== -1 && right !== -1 && left > right) {
		          state.raise("Range out of order in character class");
		        }
		      }
		    }
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-ClassAtom
		  // https://www.ecma-international.org/ecma-262/8.0/#prod-ClassAtomNoDash
		  pp$1.regexp_eatClassAtom = function(state) {
		    var start = state.pos;

		    if (state.eat(0x5C /* \ */)) {
		      if (this.regexp_eatClassEscape(state)) {
		        return true
		      }
		      if (state.switchU) {
		        // Make the same message as V8.
		        var ch$1 = state.current();
		        if (ch$1 === 0x63 /* c */ || isOctalDigit(ch$1)) {
		          state.raise("Invalid class escape");
		        }
		        state.raise("Invalid escape");
		      }
		      state.pos = start;
		    }

		    var ch = state.current();
		    if (ch !== 0x5D /* ] */) {
		      state.lastIntValue = ch;
		      state.advance();
		      return true
		    }

		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ClassEscape
		  pp$1.regexp_eatClassEscape = function(state) {
		    var start = state.pos;

		    if (state.eat(0x62 /* b */)) {
		      state.lastIntValue = 0x08; /* <BS> */
		      return true
		    }

		    if (state.switchU && state.eat(0x2D /* - */)) {
		      state.lastIntValue = 0x2D; /* - */
		      return true
		    }

		    if (!state.switchU && state.eat(0x63 /* c */)) {
		      if (this.regexp_eatClassControlLetter(state)) {
		        return true
		      }
		      state.pos = start;
		    }

		    return (
		      this.regexp_eatCharacterClassEscape(state) ||
		      this.regexp_eatCharacterEscape(state)
		    )
		  };

		  // https://tc39.es/ecma262/#prod-ClassSetExpression
		  // https://tc39.es/ecma262/#prod-ClassUnion
		  // https://tc39.es/ecma262/#prod-ClassIntersection
		  // https://tc39.es/ecma262/#prod-ClassSubtraction
		  pp$1.regexp_classSetExpression = function(state) {
		    var result = CharSetOk, subResult;
		    if (this.regexp_eatClassSetRange(state)) ; else if (subResult = this.regexp_eatClassSetOperand(state)) {
		      if (subResult === CharSetString) { result = CharSetString; }
		      // https://tc39.es/ecma262/#prod-ClassIntersection
		      var start = state.pos;
		      while (state.eatChars([0x26, 0x26] /* && */)) {
		        if (
		          state.current() !== 0x26 /* & */ &&
		          (subResult = this.regexp_eatClassSetOperand(state))
		        ) {
		          if (subResult !== CharSetString) { result = CharSetOk; }
		          continue
		        }
		        state.raise("Invalid character in character class");
		      }
		      if (start !== state.pos) { return result }
		      // https://tc39.es/ecma262/#prod-ClassSubtraction
		      while (state.eatChars([0x2D, 0x2D] /* -- */)) {
		        if (this.regexp_eatClassSetOperand(state)) { continue }
		        state.raise("Invalid character in character class");
		      }
		      if (start !== state.pos) { return result }
		    } else {
		      state.raise("Invalid character in character class");
		    }
		    // https://tc39.es/ecma262/#prod-ClassUnion
		    for (;;) {
		      if (this.regexp_eatClassSetRange(state)) { continue }
		      subResult = this.regexp_eatClassSetOperand(state);
		      if (!subResult) { return result }
		      if (subResult === CharSetString) { result = CharSetString; }
		    }
		  };

		  // https://tc39.es/ecma262/#prod-ClassSetRange
		  pp$1.regexp_eatClassSetRange = function(state) {
		    var start = state.pos;
		    if (this.regexp_eatClassSetCharacter(state)) {
		      var left = state.lastIntValue;
		      if (state.eat(0x2D /* - */) && this.regexp_eatClassSetCharacter(state)) {
		        var right = state.lastIntValue;
		        if (left !== -1 && right !== -1 && left > right) {
		          state.raise("Range out of order in character class");
		        }
		        return true
		      }
		      state.pos = start;
		    }
		    return false
		  };

		  // https://tc39.es/ecma262/#prod-ClassSetOperand
		  pp$1.regexp_eatClassSetOperand = function(state) {
		    if (this.regexp_eatClassSetCharacter(state)) { return CharSetOk }
		    return this.regexp_eatClassStringDisjunction(state) || this.regexp_eatNestedClass(state)
		  };

		  // https://tc39.es/ecma262/#prod-NestedClass
		  pp$1.regexp_eatNestedClass = function(state) {
		    var start = state.pos;
		    if (state.eat(0x5B /* [ */)) {
		      var negate = state.eat(0x5E /* ^ */);
		      var result = this.regexp_classContents(state);
		      if (state.eat(0x5D /* ] */)) {
		        if (negate && result === CharSetString) {
		          state.raise("Negated character class may contain strings");
		        }
		        return result
		      }
		      state.pos = start;
		    }
		    if (state.eat(0x5C /* \ */)) {
		      var result$1 = this.regexp_eatCharacterClassEscape(state);
		      if (result$1) {
		        return result$1
		      }
		      state.pos = start;
		    }
		    return null
		  };

		  // https://tc39.es/ecma262/#prod-ClassStringDisjunction
		  pp$1.regexp_eatClassStringDisjunction = function(state) {
		    var start = state.pos;
		    if (state.eatChars([0x5C, 0x71] /* \q */)) {
		      if (state.eat(0x7B /* { */)) {
		        var result = this.regexp_classStringDisjunctionContents(state);
		        if (state.eat(0x7D /* } */)) {
		          return result
		        }
		      } else {
		        // Make the same message as V8.
		        state.raise("Invalid escape");
		      }
		      state.pos = start;
		    }
		    return null
		  };

		  // https://tc39.es/ecma262/#prod-ClassStringDisjunctionContents
		  pp$1.regexp_classStringDisjunctionContents = function(state) {
		    var result = this.regexp_classString(state);
		    while (state.eat(0x7C /* | */)) {
		      if (this.regexp_classString(state) === CharSetString) { result = CharSetString; }
		    }
		    return result
		  };

		  // https://tc39.es/ecma262/#prod-ClassString
		  // https://tc39.es/ecma262/#prod-NonEmptyClassString
		  pp$1.regexp_classString = function(state) {
		    var count = 0;
		    while (this.regexp_eatClassSetCharacter(state)) { count++; }
		    return count === 1 ? CharSetOk : CharSetString
		  };

		  // https://tc39.es/ecma262/#prod-ClassSetCharacter
		  pp$1.regexp_eatClassSetCharacter = function(state) {
		    var start = state.pos;
		    if (state.eat(0x5C /* \ */)) {
		      if (
		        this.regexp_eatCharacterEscape(state) ||
		        this.regexp_eatClassSetReservedPunctuator(state)
		      ) {
		        return true
		      }
		      if (state.eat(0x62 /* b */)) {
		        state.lastIntValue = 0x08; /* <BS> */
		        return true
		      }
		      state.pos = start;
		      return false
		    }
		    var ch = state.current();
		    if (ch < 0 || ch === state.lookahead() && isClassSetReservedDoublePunctuatorCharacter(ch)) { return false }
		    if (isClassSetSyntaxCharacter(ch)) { return false }
		    state.advance();
		    state.lastIntValue = ch;
		    return true
		  };

		  // https://tc39.es/ecma262/#prod-ClassSetReservedDoublePunctuator
		  function isClassSetReservedDoublePunctuatorCharacter(ch) {
		    return (
		      ch === 0x21 /* ! */ ||
		      ch >= 0x23 /* # */ && ch <= 0x26 /* & */ ||
		      ch >= 0x2A /* * */ && ch <= 0x2C /* , */ ||
		      ch === 0x2E /* . */ ||
		      ch >= 0x3A /* : */ && ch <= 0x40 /* @ */ ||
		      ch === 0x5E /* ^ */ ||
		      ch === 0x60 /* ` */ ||
		      ch === 0x7E /* ~ */
		    )
		  }

		  // https://tc39.es/ecma262/#prod-ClassSetSyntaxCharacter
		  function isClassSetSyntaxCharacter(ch) {
		    return (
		      ch === 0x28 /* ( */ ||
		      ch === 0x29 /* ) */ ||
		      ch === 0x2D /* - */ ||
		      ch === 0x2F /* / */ ||
		      ch >= 0x5B /* [ */ && ch <= 0x5D /* ] */ ||
		      ch >= 0x7B /* { */ && ch <= 0x7D /* } */
		    )
		  }

		  // https://tc39.es/ecma262/#prod-ClassSetReservedPunctuator
		  pp$1.regexp_eatClassSetReservedPunctuator = function(state) {
		    var ch = state.current();
		    if (isClassSetReservedPunctuator(ch)) {
		      state.lastIntValue = ch;
		      state.advance();
		      return true
		    }
		    return false
		  };

		  // https://tc39.es/ecma262/#prod-ClassSetReservedPunctuator
		  function isClassSetReservedPunctuator(ch) {
		    return (
		      ch === 0x21 /* ! */ ||
		      ch === 0x23 /* # */ ||
		      ch === 0x25 /* % */ ||
		      ch === 0x26 /* & */ ||
		      ch === 0x2C /* , */ ||
		      ch === 0x2D /* - */ ||
		      ch >= 0x3A /* : */ && ch <= 0x3E /* > */ ||
		      ch === 0x40 /* @ */ ||
		      ch === 0x60 /* ` */ ||
		      ch === 0x7E /* ~ */
		    )
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ClassControlLetter
		  pp$1.regexp_eatClassControlLetter = function(state) {
		    var ch = state.current();
		    if (isDecimalDigit(ch) || ch === 0x5F /* _ */) {
		      state.lastIntValue = ch % 0x20;
		      state.advance();
		      return true
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-HexEscapeSequence
		  pp$1.regexp_eatHexEscapeSequence = function(state) {
		    var start = state.pos;
		    if (state.eat(0x78 /* x */)) {
		      if (this.regexp_eatFixedHexDigits(state, 2)) {
		        return true
		      }
		      if (state.switchU) {
		        state.raise("Invalid escape");
		      }
		      state.pos = start;
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-DecimalDigits
		  pp$1.regexp_eatDecimalDigits = function(state) {
		    var start = state.pos;
		    var ch = 0;
		    state.lastIntValue = 0;
		    while (isDecimalDigit(ch = state.current())) {
		      state.lastIntValue = 10 * state.lastIntValue + (ch - 0x30 /* 0 */);
		      state.advance();
		    }
		    return state.pos !== start
		  };
		  function isDecimalDigit(ch) {
		    return ch >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-HexDigits
		  pp$1.regexp_eatHexDigits = function(state) {
		    var start = state.pos;
		    var ch = 0;
		    state.lastIntValue = 0;
		    while (isHexDigit(ch = state.current())) {
		      state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
		      state.advance();
		    }
		    return state.pos !== start
		  };
		  function isHexDigit(ch) {
		    return (
		      (ch >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */) ||
		      (ch >= 0x41 /* A */ && ch <= 0x46 /* F */) ||
		      (ch >= 0x61 /* a */ && ch <= 0x66 /* f */)
		    )
		  }
		  function hexToInt(ch) {
		    if (ch >= 0x41 /* A */ && ch <= 0x46 /* F */) {
		      return 10 + (ch - 0x41 /* A */)
		    }
		    if (ch >= 0x61 /* a */ && ch <= 0x66 /* f */) {
		      return 10 + (ch - 0x61 /* a */)
		    }
		    return ch - 0x30 /* 0 */
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-LegacyOctalEscapeSequence
		  // Allows only 0-377(octal) i.e. 0-255(decimal).
		  pp$1.regexp_eatLegacyOctalEscapeSequence = function(state) {
		    if (this.regexp_eatOctalDigit(state)) {
		      var n1 = state.lastIntValue;
		      if (this.regexp_eatOctalDigit(state)) {
		        var n2 = state.lastIntValue;
		        if (n1 <= 3 && this.regexp_eatOctalDigit(state)) {
		          state.lastIntValue = n1 * 64 + n2 * 8 + state.lastIntValue;
		        } else {
		          state.lastIntValue = n1 * 8 + n2;
		        }
		      } else {
		        state.lastIntValue = n1;
		      }
		      return true
		    }
		    return false
		  };

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-OctalDigit
		  pp$1.regexp_eatOctalDigit = function(state) {
		    var ch = state.current();
		    if (isOctalDigit(ch)) {
		      state.lastIntValue = ch - 0x30; /* 0 */
		      state.advance();
		      return true
		    }
		    state.lastIntValue = 0;
		    return false
		  };
		  function isOctalDigit(ch) {
		    return ch >= 0x30 /* 0 */ && ch <= 0x37 /* 7 */
		  }

		  // https://www.ecma-international.org/ecma-262/8.0/#prod-Hex4Digits
		  // https://www.ecma-international.org/ecma-262/8.0/#prod-HexDigit
		  // And HexDigit HexDigit in https://www.ecma-international.org/ecma-262/8.0/#prod-HexEscapeSequence
		  pp$1.regexp_eatFixedHexDigits = function(state, length) {
		    var start = state.pos;
		    state.lastIntValue = 0;
		    for (var i = 0; i < length; ++i) {
		      var ch = state.current();
		      if (!isHexDigit(ch)) {
		        state.pos = start;
		        return false
		      }
		      state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
		      state.advance();
		    }
		    return true
		  };

		  // Object type used to represent tokens. Note that normally, tokens
		  // simply exist as properties on the parser object. This is only
		  // used for the onToken callback and the external tokenizer.

		  var Token = function Token(p) {
		    this.type = p.type;
		    this.value = p.value;
		    this.start = p.start;
		    this.end = p.end;
		    if (p.options.locations)
		      { this.loc = new SourceLocation(p, p.startLoc, p.endLoc); }
		    if (p.options.ranges)
		      { this.range = [p.start, p.end]; }
		  };

		  // ## Tokenizer

		  var pp = Parser.prototype;

		  // Move to the next token

		  pp.next = function(ignoreEscapeSequenceInKeyword) {
		    if (!ignoreEscapeSequenceInKeyword && this.type.keyword && this.containsEsc)
		      { this.raiseRecoverable(this.start, "Escape sequence in keyword " + this.type.keyword); }
		    if (this.options.onToken)
		      { this.options.onToken(new Token(this)); }

		    this.lastTokEnd = this.end;
		    this.lastTokStart = this.start;
		    this.lastTokEndLoc = this.endLoc;
		    this.lastTokStartLoc = this.startLoc;
		    this.nextToken();
		  };

		  pp.getToken = function() {
		    this.next();
		    return new Token(this)
		  };

		  // If we're in an ES6 environment, make parsers iterable
		  if (typeof Symbol !== "undefined")
		    { pp[Symbol.iterator] = function() {
		      var this$1$1 = this;

		      return {
		        next: function () {
		          var token = this$1$1.getToken();
		          return {
		            done: token.type === types$1.eof,
		            value: token
		          }
		        }
		      }
		    }; }

		  // Toggle strict mode. Re-reads the next number or string to please
		  // pedantic tests (`"use strict"; 010;` should fail).

		  // Read a single token, updating the parser object's token-related
		  // properties.

		  pp.nextToken = function() {
		    var curContext = this.curContext();
		    if (!curContext || !curContext.preserveSpace) { this.skipSpace(); }

		    this.start = this.pos;
		    if (this.options.locations) { this.startLoc = this.curPosition(); }
		    if (this.pos >= this.input.length) { return this.finishToken(types$1.eof) }

		    if (curContext.override) { return curContext.override(this) }
		    else { this.readToken(this.fullCharCodeAtPos()); }
		  };

		  pp.readToken = function(code) {
		    // Identifier or keyword. '\uXXXX' sequences are allowed in
		    // identifiers, so '\' also dispatches to that.
		    if (isIdentifierStart(code, this.options.ecmaVersion >= 6) || code === 92 /* '\' */)
		      { return this.readWord() }

		    return this.getTokenFromCode(code)
		  };

		  pp.fullCharCodeAtPos = function() {
		    var code = this.input.charCodeAt(this.pos);
		    if (code <= 0xd7ff || code >= 0xdc00) { return code }
		    var next = this.input.charCodeAt(this.pos + 1);
		    return next <= 0xdbff || next >= 0xe000 ? code : (code << 10) + next - 0x35fdc00
		  };

		  pp.skipBlockComment = function() {
		    var startLoc = this.options.onComment && this.curPosition();
		    var start = this.pos, end = this.input.indexOf("*/", this.pos += 2);
		    if (end === -1) { this.raise(this.pos - 2, "Unterminated comment"); }
		    this.pos = end + 2;
		    if (this.options.locations) {
		      for (var nextBreak = (void 0), pos = start; (nextBreak = nextLineBreak(this.input, pos, this.pos)) > -1;) {
		        ++this.curLine;
		        pos = this.lineStart = nextBreak;
		      }
		    }
		    if (this.options.onComment)
		      { this.options.onComment(true, this.input.slice(start + 2, end), start, this.pos,
		                             startLoc, this.curPosition()); }
		  };

		  pp.skipLineComment = function(startSkip) {
		    var start = this.pos;
		    var startLoc = this.options.onComment && this.curPosition();
		    var ch = this.input.charCodeAt(this.pos += startSkip);
		    while (this.pos < this.input.length && !isNewLine(ch)) {
		      ch = this.input.charCodeAt(++this.pos);
		    }
		    if (this.options.onComment)
		      { this.options.onComment(false, this.input.slice(start + startSkip, this.pos), start, this.pos,
		                             startLoc, this.curPosition()); }
		  };

		  // Called at the start of the parse and after every token. Skips
		  // whitespace and comments, and.

		  pp.skipSpace = function() {
		    loop: while (this.pos < this.input.length) {
		      var ch = this.input.charCodeAt(this.pos);
		      switch (ch) {
		      case 32: case 160: // ' '
		        ++this.pos;
		        break
		      case 13:
		        if (this.input.charCodeAt(this.pos + 1) === 10) {
		          ++this.pos;
		        }
		      case 10: case 8232: case 8233:
		        ++this.pos;
		        if (this.options.locations) {
		          ++this.curLine;
		          this.lineStart = this.pos;
		        }
		        break
		      case 47: // '/'
		        switch (this.input.charCodeAt(this.pos + 1)) {
		        case 42: // '*'
		          this.skipBlockComment();
		          break
		        case 47:
		          this.skipLineComment(2);
		          break
		        default:
		          break loop
		        }
		        break
		      default:
		        if (ch > 8 && ch < 14 || ch >= 5760 && nonASCIIwhitespace.test(String.fromCharCode(ch))) {
		          ++this.pos;
		        } else {
		          break loop
		        }
		      }
		    }
		  };

		  // Called at the end of every token. Sets `end`, `val`, and
		  // maintains `context` and `exprAllowed`, and skips the space after
		  // the token, so that the next one's `start` will point at the
		  // right position.

		  pp.finishToken = function(type, val) {
		    this.end = this.pos;
		    if (this.options.locations) { this.endLoc = this.curPosition(); }
		    var prevType = this.type;
		    this.type = type;
		    this.value = val;

		    this.updateContext(prevType);
		  };

		  // ### Token reading

		  // This is the function that is called to fetch the next token. It
		  // is somewhat obscure, because it works in character codes rather
		  // than characters, and because operator parsing has been inlined
		  // into it.
		  //
		  // All in the name of speed.
		  //
		  pp.readToken_dot = function() {
		    var next = this.input.charCodeAt(this.pos + 1);
		    if (next >= 48 && next <= 57) { return this.readNumber(true) }
		    var next2 = this.input.charCodeAt(this.pos + 2);
		    if (this.options.ecmaVersion >= 6 && next === 46 && next2 === 46) { // 46 = dot '.'
		      this.pos += 3;
		      return this.finishToken(types$1.ellipsis)
		    } else {
		      ++this.pos;
		      return this.finishToken(types$1.dot)
		    }
		  };

		  pp.readToken_slash = function() { // '/'
		    var next = this.input.charCodeAt(this.pos + 1);
		    if (this.exprAllowed) { ++this.pos; return this.readRegexp() }
		    if (next === 61) { return this.finishOp(types$1.assign, 2) }
		    return this.finishOp(types$1.slash, 1)
		  };

		  pp.readToken_mult_modulo_exp = function(code) { // '%*'
		    var next = this.input.charCodeAt(this.pos + 1);
		    var size = 1;
		    var tokentype = code === 42 ? types$1.star : types$1.modulo;

		    // exponentiation operator ** and **=
		    if (this.options.ecmaVersion >= 7 && code === 42 && next === 42) {
		      ++size;
		      tokentype = types$1.starstar;
		      next = this.input.charCodeAt(this.pos + 2);
		    }

		    if (next === 61) { return this.finishOp(types$1.assign, size + 1) }
		    return this.finishOp(tokentype, size)
		  };

		  pp.readToken_pipe_amp = function(code) { // '|&'
		    var next = this.input.charCodeAt(this.pos + 1);
		    if (next === code) {
		      if (this.options.ecmaVersion >= 12) {
		        var next2 = this.input.charCodeAt(this.pos + 2);
		        if (next2 === 61) { return this.finishOp(types$1.assign, 3) }
		      }
		      return this.finishOp(code === 124 ? types$1.logicalOR : types$1.logicalAND, 2)
		    }
		    if (next === 61) { return this.finishOp(types$1.assign, 2) }
		    return this.finishOp(code === 124 ? types$1.bitwiseOR : types$1.bitwiseAND, 1)
		  };

		  pp.readToken_caret = function() { // '^'
		    var next = this.input.charCodeAt(this.pos + 1);
		    if (next === 61) { return this.finishOp(types$1.assign, 2) }
		    return this.finishOp(types$1.bitwiseXOR, 1)
		  };

		  pp.readToken_plus_min = function(code) { // '+-'
		    var next = this.input.charCodeAt(this.pos + 1);
		    if (next === code) {
		      if (next === 45 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 62 &&
		          (this.lastTokEnd === 0 || lineBreak.test(this.input.slice(this.lastTokEnd, this.pos)))) {
		        // A `-->` line comment
		        this.skipLineComment(3);
		        this.skipSpace();
		        return this.nextToken()
		      }
		      return this.finishOp(types$1.incDec, 2)
		    }
		    if (next === 61) { return this.finishOp(types$1.assign, 2) }
		    return this.finishOp(types$1.plusMin, 1)
		  };

		  pp.readToken_lt_gt = function(code) { // '<>'
		    var next = this.input.charCodeAt(this.pos + 1);
		    var size = 1;
		    if (next === code) {
		      size = code === 62 && this.input.charCodeAt(this.pos + 2) === 62 ? 3 : 2;
		      if (this.input.charCodeAt(this.pos + size) === 61) { return this.finishOp(types$1.assign, size + 1) }
		      return this.finishOp(types$1.bitShift, size)
		    }
		    if (next === 33 && code === 60 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 45 &&
		        this.input.charCodeAt(this.pos + 3) === 45) {
		      // `<!--`, an XML-style comment that should be interpreted as a line comment
		      this.skipLineComment(4);
		      this.skipSpace();
		      return this.nextToken()
		    }
		    if (next === 61) { size = 2; }
		    return this.finishOp(types$1.relational, size)
		  };

		  pp.readToken_eq_excl = function(code) { // '=!'
		    var next = this.input.charCodeAt(this.pos + 1);
		    if (next === 61) { return this.finishOp(types$1.equality, this.input.charCodeAt(this.pos + 2) === 61 ? 3 : 2) }
		    if (code === 61 && next === 62 && this.options.ecmaVersion >= 6) { // '=>'
		      this.pos += 2;
		      return this.finishToken(types$1.arrow)
		    }
		    return this.finishOp(code === 61 ? types$1.eq : types$1.prefix, 1)
		  };

		  pp.readToken_question = function() { // '?'
		    var ecmaVersion = this.options.ecmaVersion;
		    if (ecmaVersion >= 11) {
		      var next = this.input.charCodeAt(this.pos + 1);
		      if (next === 46) {
		        var next2 = this.input.charCodeAt(this.pos + 2);
		        if (next2 < 48 || next2 > 57) { return this.finishOp(types$1.questionDot, 2) }
		      }
		      if (next === 63) {
		        if (ecmaVersion >= 12) {
		          var next2$1 = this.input.charCodeAt(this.pos + 2);
		          if (next2$1 === 61) { return this.finishOp(types$1.assign, 3) }
		        }
		        return this.finishOp(types$1.coalesce, 2)
		      }
		    }
		    return this.finishOp(types$1.question, 1)
		  };

		  pp.readToken_numberSign = function() { // '#'
		    var ecmaVersion = this.options.ecmaVersion;
		    var code = 35; // '#'
		    if (ecmaVersion >= 13) {
		      ++this.pos;
		      code = this.fullCharCodeAtPos();
		      if (isIdentifierStart(code, true) || code === 92 /* '\' */) {
		        return this.finishToken(types$1.privateId, this.readWord1())
		      }
		    }

		    this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
		  };

		  pp.getTokenFromCode = function(code) {
		    switch (code) {
		    // The interpretation of a dot depends on whether it is followed
		    // by a digit or another two dots.
		    case 46: // '.'
		      return this.readToken_dot()

		    // Punctuation tokens.
		    case 40: ++this.pos; return this.finishToken(types$1.parenL)
		    case 41: ++this.pos; return this.finishToken(types$1.parenR)
		    case 59: ++this.pos; return this.finishToken(types$1.semi)
		    case 44: ++this.pos; return this.finishToken(types$1.comma)
		    case 91: ++this.pos; return this.finishToken(types$1.bracketL)
		    case 93: ++this.pos; return this.finishToken(types$1.bracketR)
		    case 123: ++this.pos; return this.finishToken(types$1.braceL)
		    case 125: ++this.pos; return this.finishToken(types$1.braceR)
		    case 58: ++this.pos; return this.finishToken(types$1.colon)

		    case 96: // '`'
		      if (this.options.ecmaVersion < 6) { break }
		      ++this.pos;
		      return this.finishToken(types$1.backQuote)

		    case 48: // '0'
		      var next = this.input.charCodeAt(this.pos + 1);
		      if (next === 120 || next === 88) { return this.readRadixNumber(16) } // '0x', '0X' - hex number
		      if (this.options.ecmaVersion >= 6) {
		        if (next === 111 || next === 79) { return this.readRadixNumber(8) } // '0o', '0O' - octal number
		        if (next === 98 || next === 66) { return this.readRadixNumber(2) } // '0b', '0B' - binary number
		      }

		    // Anything else beginning with a digit is an integer, octal
		    // number, or float.
		    case 49: case 50: case 51: case 52: case 53: case 54: case 55: case 56: case 57: // 1-9
		      return this.readNumber(false)

		    // Quotes produce strings.
		    case 34: case 39: // '"', "'"
		      return this.readString(code)

		    // Operators are parsed inline in tiny state machines. '=' (61) is
		    // often referred to. `finishOp` simply skips the amount of
		    // characters it is given as second argument, and returns a token
		    // of the type given by its first argument.
		    case 47: // '/'
		      return this.readToken_slash()

		    case 37: case 42: // '%*'
		      return this.readToken_mult_modulo_exp(code)

		    case 124: case 38: // '|&'
		      return this.readToken_pipe_amp(code)

		    case 94: // '^'
		      return this.readToken_caret()

		    case 43: case 45: // '+-'
		      return this.readToken_plus_min(code)

		    case 60: case 62: // '<>'
		      return this.readToken_lt_gt(code)

		    case 61: case 33: // '=!'
		      return this.readToken_eq_excl(code)

		    case 63: // '?'
		      return this.readToken_question()

		    case 126: // '~'
		      return this.finishOp(types$1.prefix, 1)

		    case 35: // '#'
		      return this.readToken_numberSign()
		    }

		    this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
		  };

		  pp.finishOp = function(type, size) {
		    var str = this.input.slice(this.pos, this.pos + size);
		    this.pos += size;
		    return this.finishToken(type, str)
		  };

		  pp.readRegexp = function() {
		    var escaped, inClass, start = this.pos;
		    for (;;) {
		      if (this.pos >= this.input.length) { this.raise(start, "Unterminated regular expression"); }
		      var ch = this.input.charAt(this.pos);
		      if (lineBreak.test(ch)) { this.raise(start, "Unterminated regular expression"); }
		      if (!escaped) {
		        if (ch === "[") { inClass = true; }
		        else if (ch === "]" && inClass) { inClass = false; }
		        else if (ch === "/" && !inClass) { break }
		        escaped = ch === "\\";
		      } else { escaped = false; }
		      ++this.pos;
		    }
		    var pattern = this.input.slice(start, this.pos);
		    ++this.pos;
		    var flagsStart = this.pos;
		    var flags = this.readWord1();
		    if (this.containsEsc) { this.unexpected(flagsStart); }

		    // Validate pattern
		    var state = this.regexpState || (this.regexpState = new RegExpValidationState(this));
		    state.reset(start, pattern, flags);
		    this.validateRegExpFlags(state);
		    this.validateRegExpPattern(state);

		    // Create Literal#value property value.
		    var value = null;
		    try {
		      value = new RegExp(pattern, flags);
		    } catch (e) {
		      // ESTree requires null if it failed to instantiate RegExp object.
		      // https://github.com/estree/estree/blob/a27003adf4fd7bfad44de9cef372a2eacd527b1c/es5.md#regexpliteral
		    }

		    return this.finishToken(types$1.regexp, {pattern: pattern, flags: flags, value: value})
		  };

		  // Read an integer in the given radix. Return null if zero digits
		  // were read, the integer value otherwise. When `len` is given, this
		  // will return `null` unless the integer has exactly `len` digits.

		  pp.readInt = function(radix, len, maybeLegacyOctalNumericLiteral) {
		    // `len` is used for character escape sequences. In that case, disallow separators.
		    var allowSeparators = this.options.ecmaVersion >= 12 && len === undefined;

		    // `maybeLegacyOctalNumericLiteral` is true if it doesn't have prefix (0x,0o,0b)
		    // and isn't fraction part nor exponent part. In that case, if the first digit
		    // is zero then disallow separators.
		    var isLegacyOctalNumericLiteral = maybeLegacyOctalNumericLiteral && this.input.charCodeAt(this.pos) === 48;

		    var start = this.pos, total = 0, lastCode = 0;
		    for (var i = 0, e = len == null ? Infinity : len; i < e; ++i, ++this.pos) {
		      var code = this.input.charCodeAt(this.pos), val = (void 0);

		      if (allowSeparators && code === 95) {
		        if (isLegacyOctalNumericLiteral) { this.raiseRecoverable(this.pos, "Numeric separator is not allowed in legacy octal numeric literals"); }
		        if (lastCode === 95) { this.raiseRecoverable(this.pos, "Numeric separator must be exactly one underscore"); }
		        if (i === 0) { this.raiseRecoverable(this.pos, "Numeric separator is not allowed at the first of digits"); }
		        lastCode = code;
		        continue
		      }

		      if (code >= 97) { val = code - 97 + 10; } // a
		      else if (code >= 65) { val = code - 65 + 10; } // A
		      else if (code >= 48 && code <= 57) { val = code - 48; } // 0-9
		      else { val = Infinity; }
		      if (val >= radix) { break }
		      lastCode = code;
		      total = total * radix + val;
		    }

		    if (allowSeparators && lastCode === 95) { this.raiseRecoverable(this.pos - 1, "Numeric separator is not allowed at the last of digits"); }
		    if (this.pos === start || len != null && this.pos - start !== len) { return null }

		    return total
		  };

		  function stringToNumber(str, isLegacyOctalNumericLiteral) {
		    if (isLegacyOctalNumericLiteral) {
		      return parseInt(str, 8)
		    }

		    // `parseFloat(value)` stops parsing at the first numeric separator then returns a wrong value.
		    return parseFloat(str.replace(/_/g, ""))
		  }

		  function stringToBigInt(str) {
		    if (typeof BigInt !== "function") {
		      return null
		    }

		    // `BigInt(value)` throws syntax error if the string contains numeric separators.
		    return BigInt(str.replace(/_/g, ""))
		  }

		  pp.readRadixNumber = function(radix) {
		    var start = this.pos;
		    this.pos += 2; // 0x
		    var val = this.readInt(radix);
		    if (val == null) { this.raise(this.start + 2, "Expected number in radix " + radix); }
		    if (this.options.ecmaVersion >= 11 && this.input.charCodeAt(this.pos) === 110) {
		      val = stringToBigInt(this.input.slice(start, this.pos));
		      ++this.pos;
		    } else if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }
		    return this.finishToken(types$1.num, val)
		  };

		  // Read an integer, octal integer, or floating-point number.

		  pp.readNumber = function(startsWithDot) {
		    var start = this.pos;
		    if (!startsWithDot && this.readInt(10, undefined, true) === null) { this.raise(start, "Invalid number"); }
		    var octal = this.pos - start >= 2 && this.input.charCodeAt(start) === 48;
		    if (octal && this.strict) { this.raise(start, "Invalid number"); }
		    var next = this.input.charCodeAt(this.pos);
		    if (!octal && !startsWithDot && this.options.ecmaVersion >= 11 && next === 110) {
		      var val$1 = stringToBigInt(this.input.slice(start, this.pos));
		      ++this.pos;
		      if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }
		      return this.finishToken(types$1.num, val$1)
		    }
		    if (octal && /[89]/.test(this.input.slice(start, this.pos))) { octal = false; }
		    if (next === 46 && !octal) { // '.'
		      ++this.pos;
		      this.readInt(10);
		      next = this.input.charCodeAt(this.pos);
		    }
		    if ((next === 69 || next === 101) && !octal) { // 'eE'
		      next = this.input.charCodeAt(++this.pos);
		      if (next === 43 || next === 45) { ++this.pos; } // '+-'
		      if (this.readInt(10) === null) { this.raise(start, "Invalid number"); }
		    }
		    if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }

		    var val = stringToNumber(this.input.slice(start, this.pos), octal);
		    return this.finishToken(types$1.num, val)
		  };

		  // Read a string value, interpreting backslash-escapes.

		  pp.readCodePoint = function() {
		    var ch = this.input.charCodeAt(this.pos), code;

		    if (ch === 123) { // '{'
		      if (this.options.ecmaVersion < 6) { this.unexpected(); }
		      var codePos = ++this.pos;
		      code = this.readHexChar(this.input.indexOf("}", this.pos) - this.pos);
		      ++this.pos;
		      if (code > 0x10FFFF) { this.invalidStringToken(codePos, "Code point out of bounds"); }
		    } else {
		      code = this.readHexChar(4);
		    }
		    return code
		  };

		  pp.readString = function(quote) {
		    var out = "", chunkStart = ++this.pos;
		    for (;;) {
		      if (this.pos >= this.input.length) { this.raise(this.start, "Unterminated string constant"); }
		      var ch = this.input.charCodeAt(this.pos);
		      if (ch === quote) { break }
		      if (ch === 92) { // '\'
		        out += this.input.slice(chunkStart, this.pos);
		        out += this.readEscapedChar(false);
		        chunkStart = this.pos;
		      } else if (ch === 0x2028 || ch === 0x2029) {
		        if (this.options.ecmaVersion < 10) { this.raise(this.start, "Unterminated string constant"); }
		        ++this.pos;
		        if (this.options.locations) {
		          this.curLine++;
		          this.lineStart = this.pos;
		        }
		      } else {
		        if (isNewLine(ch)) { this.raise(this.start, "Unterminated string constant"); }
		        ++this.pos;
		      }
		    }
		    out += this.input.slice(chunkStart, this.pos++);
		    return this.finishToken(types$1.string, out)
		  };

		  // Reads template string tokens.

		  var INVALID_TEMPLATE_ESCAPE_ERROR = {};

		  pp.tryReadTemplateToken = function() {
		    this.inTemplateElement = true;
		    try {
		      this.readTmplToken();
		    } catch (err) {
		      if (err === INVALID_TEMPLATE_ESCAPE_ERROR) {
		        this.readInvalidTemplateToken();
		      } else {
		        throw err
		      }
		    }

		    this.inTemplateElement = false;
		  };

		  pp.invalidStringToken = function(position, message) {
		    if (this.inTemplateElement && this.options.ecmaVersion >= 9) {
		      throw INVALID_TEMPLATE_ESCAPE_ERROR
		    } else {
		      this.raise(position, message);
		    }
		  };

		  pp.readTmplToken = function() {
		    var out = "", chunkStart = this.pos;
		    for (;;) {
		      if (this.pos >= this.input.length) { this.raise(this.start, "Unterminated template"); }
		      var ch = this.input.charCodeAt(this.pos);
		      if (ch === 96 || ch === 36 && this.input.charCodeAt(this.pos + 1) === 123) { // '`', '${'
		        if (this.pos === this.start && (this.type === types$1.template || this.type === types$1.invalidTemplate)) {
		          if (ch === 36) {
		            this.pos += 2;
		            return this.finishToken(types$1.dollarBraceL)
		          } else {
		            ++this.pos;
		            return this.finishToken(types$1.backQuote)
		          }
		        }
		        out += this.input.slice(chunkStart, this.pos);
		        return this.finishToken(types$1.template, out)
		      }
		      if (ch === 92) { // '\'
		        out += this.input.slice(chunkStart, this.pos);
		        out += this.readEscapedChar(true);
		        chunkStart = this.pos;
		      } else if (isNewLine(ch)) {
		        out += this.input.slice(chunkStart, this.pos);
		        ++this.pos;
		        switch (ch) {
		        case 13:
		          if (this.input.charCodeAt(this.pos) === 10) { ++this.pos; }
		        case 10:
		          out += "\n";
		          break
		        default:
		          out += String.fromCharCode(ch);
		          break
		        }
		        if (this.options.locations) {
		          ++this.curLine;
		          this.lineStart = this.pos;
		        }
		        chunkStart = this.pos;
		      } else {
		        ++this.pos;
		      }
		    }
		  };

		  // Reads a template token to search for the end, without validating any escape sequences
		  pp.readInvalidTemplateToken = function() {
		    for (; this.pos < this.input.length; this.pos++) {
		      switch (this.input[this.pos]) {
		      case "\\":
		        ++this.pos;
		        break

		      case "$":
		        if (this.input[this.pos + 1] !== "{") { break }
		        // fall through
		      case "`":
		        return this.finishToken(types$1.invalidTemplate, this.input.slice(this.start, this.pos))

		      case "\r":
		        if (this.input[this.pos + 1] === "\n") { ++this.pos; }
		        // fall through
		      case "\n": case "\u2028": case "\u2029":
		        ++this.curLine;
		        this.lineStart = this.pos + 1;
		        break
		      }
		    }
		    this.raise(this.start, "Unterminated template");
		  };

		  // Used to read escaped characters

		  pp.readEscapedChar = function(inTemplate) {
		    var ch = this.input.charCodeAt(++this.pos);
		    ++this.pos;
		    switch (ch) {
		    case 110: return "\n" // 'n' -> '\n'
		    case 114: return "\r" // 'r' -> '\r'
		    case 120: return String.fromCharCode(this.readHexChar(2)) // 'x'
		    case 117: return codePointToString(this.readCodePoint()) // 'u'
		    case 116: return "\t" // 't' -> '\t'
		    case 98: return "\b" // 'b' -> '\b'
		    case 118: return "\u000b" // 'v' -> '\u000b'
		    case 102: return "\f" // 'f' -> '\f'
		    case 13: if (this.input.charCodeAt(this.pos) === 10) { ++this.pos; } // '\r\n'
		    case 10: // ' \n'
		      if (this.options.locations) { this.lineStart = this.pos; ++this.curLine; }
		      return ""
		    case 56:
		    case 57:
		      if (this.strict) {
		        this.invalidStringToken(
		          this.pos - 1,
		          "Invalid escape sequence"
		        );
		      }
		      if (inTemplate) {
		        var codePos = this.pos - 1;

		        this.invalidStringToken(
		          codePos,
		          "Invalid escape sequence in template string"
		        );
		      }
		    default:
		      if (ch >= 48 && ch <= 55) {
		        var octalStr = this.input.substr(this.pos - 1, 3).match(/^[0-7]+/)[0];
		        var octal = parseInt(octalStr, 8);
		        if (octal > 255) {
		          octalStr = octalStr.slice(0, -1);
		          octal = parseInt(octalStr, 8);
		        }
		        this.pos += octalStr.length - 1;
		        ch = this.input.charCodeAt(this.pos);
		        if ((octalStr !== "0" || ch === 56 || ch === 57) && (this.strict || inTemplate)) {
		          this.invalidStringToken(
		            this.pos - 1 - octalStr.length,
		            inTemplate
		              ? "Octal literal in template string"
		              : "Octal literal in strict mode"
		          );
		        }
		        return String.fromCharCode(octal)
		      }
		      if (isNewLine(ch)) {
		        // Unicode new line characters after \ get removed from output in both
		        // template literals and strings
		        if (this.options.locations) { this.lineStart = this.pos; ++this.curLine; }
		        return ""
		      }
		      return String.fromCharCode(ch)
		    }
		  };

		  // Used to read character escape sequences ('\x', '\u', '\U').

		  pp.readHexChar = function(len) {
		    var codePos = this.pos;
		    var n = this.readInt(16, len);
		    if (n === null) { this.invalidStringToken(codePos, "Bad character escape sequence"); }
		    return n
		  };

		  // Read an identifier, and return it as a string. Sets `this.containsEsc`
		  // to whether the word contained a '\u' escape.
		  //
		  // Incrementally adds only escaped chars, adding other chunks as-is
		  // as a micro-optimization.

		  pp.readWord1 = function() {
		    this.containsEsc = false;
		    var word = "", first = true, chunkStart = this.pos;
		    var astral = this.options.ecmaVersion >= 6;
		    while (this.pos < this.input.length) {
		      var ch = this.fullCharCodeAtPos();
		      if (isIdentifierChar(ch, astral)) {
		        this.pos += ch <= 0xffff ? 1 : 2;
		      } else if (ch === 92) { // "\"
		        this.containsEsc = true;
		        word += this.input.slice(chunkStart, this.pos);
		        var escStart = this.pos;
		        if (this.input.charCodeAt(++this.pos) !== 117) // "u"
		          { this.invalidStringToken(this.pos, "Expecting Unicode escape sequence \\uXXXX"); }
		        ++this.pos;
		        var esc = this.readCodePoint();
		        if (!(first ? isIdentifierStart : isIdentifierChar)(esc, astral))
		          { this.invalidStringToken(escStart, "Invalid Unicode escape"); }
		        word += codePointToString(esc);
		        chunkStart = this.pos;
		      } else {
		        break
		      }
		      first = false;
		    }
		    return word + this.input.slice(chunkStart, this.pos)
		  };

		  // Read an identifier or keyword token. Will check for reserved
		  // words when necessary.

		  pp.readWord = function() {
		    var word = this.readWord1();
		    var type = types$1.name;
		    if (this.keywords.test(word)) {
		      type = keywords[word];
		    }
		    return this.finishToken(type, word)
		  };

		  // Acorn is a tiny, fast JavaScript parser written in JavaScript.
		  //
		  // Acorn was written by Marijn Haverbeke, Ingvar Stepanyan, and
		  // various contributors and released under an MIT license.
		  //
		  // Git repositories for Acorn are available at
		  //
		  //     http://marijnhaverbeke.nl/git/acorn
		  //     https://github.com/acornjs/acorn.git
		  //
		  // Please use the [github bug tracker][ghbt] to report issues.
		  //
		  // [ghbt]: https://github.com/acornjs/acorn/issues
		  //
		  // [walk]: util/walk.js


		  var version = "8.14.0";

		  Parser.acorn = {
		    Parser: Parser,
		    version: version,
		    defaultOptions: defaultOptions,
		    Position: Position,
		    SourceLocation: SourceLocation,
		    getLineInfo: getLineInfo,
		    Node: Node,
		    TokenType: TokenType,
		    tokTypes: types$1,
		    keywordTypes: keywords,
		    TokContext: TokContext,
		    tokContexts: types,
		    isIdentifierChar: isIdentifierChar,
		    isIdentifierStart: isIdentifierStart,
		    Token: Token,
		    isNewLine: isNewLine,
		    lineBreak: lineBreak,
		    lineBreakG: lineBreakG,
		    nonASCIIwhitespace: nonASCIIwhitespace
		  };

		  // The main exported interface (under `self.acorn` when in the
		  // browser) is a `parse` function that takes a code string and returns
		  // an abstract syntax tree as specified by the [ESTree spec][estree].
		  //
		  // [estree]: https://github.com/estree/estree

		  function parse(input, options) {
		    return Parser.parse(input, options)
		  }

		  // This function tries to parse a single expression at a given
		  // offset in a string. Useful for parsing mixed-language formats
		  // that embed JavaScript expressions.

		  function parseExpressionAt(input, pos, options) {
		    return Parser.parseExpressionAt(input, pos, options)
		  }

		  // Acorn is organized as a tokenizer and a recursive-descent parser.
		  // The `tokenizer` export provides an interface to the tokenizer.

		  function tokenizer(input, options) {
		    return Parser.tokenizer(input, options)
		  }

		  exports.Node = Node;
		  exports.Parser = Parser;
		  exports.Position = Position;
		  exports.SourceLocation = SourceLocation;
		  exports.TokContext = TokContext;
		  exports.Token = Token;
		  exports.TokenType = TokenType;
		  exports.defaultOptions = defaultOptions;
		  exports.getLineInfo = getLineInfo;
		  exports.isIdentifierChar = isIdentifierChar;
		  exports.isIdentifierStart = isIdentifierStart;
		  exports.isNewLine = isNewLine;
		  exports.keywordTypes = keywords;
		  exports.lineBreak = lineBreak;
		  exports.lineBreakG = lineBreakG;
		  exports.nonASCIIwhitespace = nonASCIIwhitespace;
		  exports.parse = parse;
		  exports.parseExpressionAt = parseExpressionAt;
		  exports.tokContexts = types;
		  exports.tokTypes = types$1;
		  exports.tokenizer = tokenizer;
		  exports.version = version;

		})); 
	} (acorn, acorn.exports));
	return acorn.exports;
}

var acornJsx = {exports: {}};

var xhtml;
var hasRequiredXhtml;

function requireXhtml () {
	if (hasRequiredXhtml) return xhtml;
	hasRequiredXhtml = 1;
	xhtml = {
	  quot: '\u0022',
	  amp: '&',
	  apos: '\u0027',
	  lt: '<',
	  gt: '>',
	  nbsp: '\u00A0',
	  iexcl: '\u00A1',
	  cent: '\u00A2',
	  pound: '\u00A3',
	  curren: '\u00A4',
	  yen: '\u00A5',
	  brvbar: '\u00A6',
	  sect: '\u00A7',
	  uml: '\u00A8',
	  copy: '\u00A9',
	  ordf: '\u00AA',
	  laquo: '\u00AB',
	  not: '\u00AC',
	  shy: '\u00AD',
	  reg: '\u00AE',
	  macr: '\u00AF',
	  deg: '\u00B0',
	  plusmn: '\u00B1',
	  sup2: '\u00B2',
	  sup3: '\u00B3',
	  acute: '\u00B4',
	  micro: '\u00B5',
	  para: '\u00B6',
	  middot: '\u00B7',
	  cedil: '\u00B8',
	  sup1: '\u00B9',
	  ordm: '\u00BA',
	  raquo: '\u00BB',
	  frac14: '\u00BC',
	  frac12: '\u00BD',
	  frac34: '\u00BE',
	  iquest: '\u00BF',
	  Agrave: '\u00C0',
	  Aacute: '\u00C1',
	  Acirc: '\u00C2',
	  Atilde: '\u00C3',
	  Auml: '\u00C4',
	  Aring: '\u00C5',
	  AElig: '\u00C6',
	  Ccedil: '\u00C7',
	  Egrave: '\u00C8',
	  Eacute: '\u00C9',
	  Ecirc: '\u00CA',
	  Euml: '\u00CB',
	  Igrave: '\u00CC',
	  Iacute: '\u00CD',
	  Icirc: '\u00CE',
	  Iuml: '\u00CF',
	  ETH: '\u00D0',
	  Ntilde: '\u00D1',
	  Ograve: '\u00D2',
	  Oacute: '\u00D3',
	  Ocirc: '\u00D4',
	  Otilde: '\u00D5',
	  Ouml: '\u00D6',
	  times: '\u00D7',
	  Oslash: '\u00D8',
	  Ugrave: '\u00D9',
	  Uacute: '\u00DA',
	  Ucirc: '\u00DB',
	  Uuml: '\u00DC',
	  Yacute: '\u00DD',
	  THORN: '\u00DE',
	  szlig: '\u00DF',
	  agrave: '\u00E0',
	  aacute: '\u00E1',
	  acirc: '\u00E2',
	  atilde: '\u00E3',
	  auml: '\u00E4',
	  aring: '\u00E5',
	  aelig: '\u00E6',
	  ccedil: '\u00E7',
	  egrave: '\u00E8',
	  eacute: '\u00E9',
	  ecirc: '\u00EA',
	  euml: '\u00EB',
	  igrave: '\u00EC',
	  iacute: '\u00ED',
	  icirc: '\u00EE',
	  iuml: '\u00EF',
	  eth: '\u00F0',
	  ntilde: '\u00F1',
	  ograve: '\u00F2',
	  oacute: '\u00F3',
	  ocirc: '\u00F4',
	  otilde: '\u00F5',
	  ouml: '\u00F6',
	  divide: '\u00F7',
	  oslash: '\u00F8',
	  ugrave: '\u00F9',
	  uacute: '\u00FA',
	  ucirc: '\u00FB',
	  uuml: '\u00FC',
	  yacute: '\u00FD',
	  thorn: '\u00FE',
	  yuml: '\u00FF',
	  OElig: '\u0152',
	  oelig: '\u0153',
	  Scaron: '\u0160',
	  scaron: '\u0161',
	  Yuml: '\u0178',
	  fnof: '\u0192',
	  circ: '\u02C6',
	  tilde: '\u02DC',
	  Alpha: '\u0391',
	  Beta: '\u0392',
	  Gamma: '\u0393',
	  Delta: '\u0394',
	  Epsilon: '\u0395',
	  Zeta: '\u0396',
	  Eta: '\u0397',
	  Theta: '\u0398',
	  Iota: '\u0399',
	  Kappa: '\u039A',
	  Lambda: '\u039B',
	  Mu: '\u039C',
	  Nu: '\u039D',
	  Xi: '\u039E',
	  Omicron: '\u039F',
	  Pi: '\u03A0',
	  Rho: '\u03A1',
	  Sigma: '\u03A3',
	  Tau: '\u03A4',
	  Upsilon: '\u03A5',
	  Phi: '\u03A6',
	  Chi: '\u03A7',
	  Psi: '\u03A8',
	  Omega: '\u03A9',
	  alpha: '\u03B1',
	  beta: '\u03B2',
	  gamma: '\u03B3',
	  delta: '\u03B4',
	  epsilon: '\u03B5',
	  zeta: '\u03B6',
	  eta: '\u03B7',
	  theta: '\u03B8',
	  iota: '\u03B9',
	  kappa: '\u03BA',
	  lambda: '\u03BB',
	  mu: '\u03BC',
	  nu: '\u03BD',
	  xi: '\u03BE',
	  omicron: '\u03BF',
	  pi: '\u03C0',
	  rho: '\u03C1',
	  sigmaf: '\u03C2',
	  sigma: '\u03C3',
	  tau: '\u03C4',
	  upsilon: '\u03C5',
	  phi: '\u03C6',
	  chi: '\u03C7',
	  psi: '\u03C8',
	  omega: '\u03C9',
	  thetasym: '\u03D1',
	  upsih: '\u03D2',
	  piv: '\u03D6',
	  ensp: '\u2002',
	  emsp: '\u2003',
	  thinsp: '\u2009',
	  zwnj: '\u200C',
	  zwj: '\u200D',
	  lrm: '\u200E',
	  rlm: '\u200F',
	  ndash: '\u2013',
	  mdash: '\u2014',
	  lsquo: '\u2018',
	  rsquo: '\u2019',
	  sbquo: '\u201A',
	  ldquo: '\u201C',
	  rdquo: '\u201D',
	  bdquo: '\u201E',
	  dagger: '\u2020',
	  Dagger: '\u2021',
	  bull: '\u2022',
	  hellip: '\u2026',
	  permil: '\u2030',
	  prime: '\u2032',
	  Prime: '\u2033',
	  lsaquo: '\u2039',
	  rsaquo: '\u203A',
	  oline: '\u203E',
	  frasl: '\u2044',
	  euro: '\u20AC',
	  image: '\u2111',
	  weierp: '\u2118',
	  real: '\u211C',
	  trade: '\u2122',
	  alefsym: '\u2135',
	  larr: '\u2190',
	  uarr: '\u2191',
	  rarr: '\u2192',
	  darr: '\u2193',
	  harr: '\u2194',
	  crarr: '\u21B5',
	  lArr: '\u21D0',
	  uArr: '\u21D1',
	  rArr: '\u21D2',
	  dArr: '\u21D3',
	  hArr: '\u21D4',
	  forall: '\u2200',
	  part: '\u2202',
	  exist: '\u2203',
	  empty: '\u2205',
	  nabla: '\u2207',
	  isin: '\u2208',
	  notin: '\u2209',
	  ni: '\u220B',
	  prod: '\u220F',
	  sum: '\u2211',
	  minus: '\u2212',
	  lowast: '\u2217',
	  radic: '\u221A',
	  prop: '\u221D',
	  infin: '\u221E',
	  ang: '\u2220',
	  and: '\u2227',
	  or: '\u2228',
	  cap: '\u2229',
	  cup: '\u222A',
	  'int': '\u222B',
	  there4: '\u2234',
	  sim: '\u223C',
	  cong: '\u2245',
	  asymp: '\u2248',
	  ne: '\u2260',
	  equiv: '\u2261',
	  le: '\u2264',
	  ge: '\u2265',
	  sub: '\u2282',
	  sup: '\u2283',
	  nsub: '\u2284',
	  sube: '\u2286',
	  supe: '\u2287',
	  oplus: '\u2295',
	  otimes: '\u2297',
	  perp: '\u22A5',
	  sdot: '\u22C5',
	  lceil: '\u2308',
	  rceil: '\u2309',
	  lfloor: '\u230A',
	  rfloor: '\u230B',
	  lang: '\u2329',
	  rang: '\u232A',
	  loz: '\u25CA',
	  spades: '\u2660',
	  clubs: '\u2663',
	  hearts: '\u2665',
	  diams: '\u2666'
	};
	return xhtml;
}

var hasRequiredAcornJsx;

function requireAcornJsx () {
	if (hasRequiredAcornJsx) return acornJsx.exports;
	hasRequiredAcornJsx = 1;
	(function (module) {

		const XHTMLEntities = requireXhtml();

		const hexNumber = /^[\da-fA-F]+$/;
		const decimalNumber = /^\d+$/;

		// The map to `acorn-jsx` tokens from `acorn` namespace objects.
		const acornJsxMap = new WeakMap();

		// Get the original tokens for the given `acorn` namespace object.
		function getJsxTokens(acorn) {
		  acorn = acorn.Parser.acorn || acorn;
		  let acornJsx = acornJsxMap.get(acorn);
		  if (!acornJsx) {
		    const tt = acorn.tokTypes;
		    const TokContext = acorn.TokContext;
		    const TokenType = acorn.TokenType;
		    const tc_oTag = new TokContext('<tag', false);
		    const tc_cTag = new TokContext('</tag', false);
		    const tc_expr = new TokContext('<tag>...</tag>', true, true);
		    const tokContexts = {
		      tc_oTag: tc_oTag,
		      tc_cTag: tc_cTag,
		      tc_expr: tc_expr
		    };
		    const tokTypes = {
		      jsxName: new TokenType('jsxName'),
		      jsxText: new TokenType('jsxText', {beforeExpr: true}),
		      jsxTagStart: new TokenType('jsxTagStart', {startsExpr: true}),
		      jsxTagEnd: new TokenType('jsxTagEnd')
		    };

		    tokTypes.jsxTagStart.updateContext = function() {
		      this.context.push(tc_expr); // treat as beginning of JSX expression
		      this.context.push(tc_oTag); // start opening tag context
		      this.exprAllowed = false;
		    };
		    tokTypes.jsxTagEnd.updateContext = function(prevType) {
		      let out = this.context.pop();
		      if (out === tc_oTag && prevType === tt.slash || out === tc_cTag) {
		        this.context.pop();
		        this.exprAllowed = this.curContext() === tc_expr;
		      } else {
		        this.exprAllowed = true;
		      }
		    };

		    acornJsx = { tokContexts: tokContexts, tokTypes: tokTypes };
		    acornJsxMap.set(acorn, acornJsx);
		  }

		  return acornJsx;
		}

		// Transforms JSX element name to string.

		function getQualifiedJSXName(object) {
		  if (!object)
		    return object;

		  if (object.type === 'JSXIdentifier')
		    return object.name;

		  if (object.type === 'JSXNamespacedName')
		    return object.namespace.name + ':' + object.name.name;

		  if (object.type === 'JSXMemberExpression')
		    return getQualifiedJSXName(object.object) + '.' +
		    getQualifiedJSXName(object.property);
		}

		module.exports = function(options) {
		  options = options || {};
		  return function(Parser) {
		    return plugin({
		      allowNamespaces: options.allowNamespaces !== false,
		      allowNamespacedObjects: !!options.allowNamespacedObjects
		    }, Parser);
		  };
		};

		// This is `tokTypes` of the peer dep.
		// This can be different instances from the actual `tokTypes` this plugin uses.
		Object.defineProperty(module.exports, "tokTypes", {
		  get: function get_tokTypes() {
		    return getJsxTokens(requireAcorn()).tokTypes;
		  },
		  configurable: true,
		  enumerable: true
		});

		function plugin(options, Parser) {
		  const acorn = Parser.acorn || requireAcorn();
		  const acornJsx = getJsxTokens(acorn);
		  const tt = acorn.tokTypes;
		  const tok = acornJsx.tokTypes;
		  const tokContexts = acorn.tokContexts;
		  const tc_oTag = acornJsx.tokContexts.tc_oTag;
		  const tc_cTag = acornJsx.tokContexts.tc_cTag;
		  const tc_expr = acornJsx.tokContexts.tc_expr;
		  const isNewLine = acorn.isNewLine;
		  const isIdentifierStart = acorn.isIdentifierStart;
		  const isIdentifierChar = acorn.isIdentifierChar;

		  return class extends Parser {
		    // Expose actual `tokTypes` and `tokContexts` to other plugins.
		    static get acornJsx() {
		      return acornJsx;
		    }

		    // Reads inline JSX contents token.
		    jsx_readToken() {
		      let out = '', chunkStart = this.pos;
		      for (;;) {
		        if (this.pos >= this.input.length)
		          this.raise(this.start, 'Unterminated JSX contents');
		        let ch = this.input.charCodeAt(this.pos);

		        switch (ch) {
		        case 60: // '<'
		        case 123: // '{'
		          if (this.pos === this.start) {
		            if (ch === 60 && this.exprAllowed) {
		              ++this.pos;
		              return this.finishToken(tok.jsxTagStart);
		            }
		            return this.getTokenFromCode(ch);
		          }
		          out += this.input.slice(chunkStart, this.pos);
		          return this.finishToken(tok.jsxText, out);

		        case 38: // '&'
		          out += this.input.slice(chunkStart, this.pos);
		          out += this.jsx_readEntity();
		          chunkStart = this.pos;
		          break;

		        case 62: // '>'
		        case 125: // '}'
		          this.raise(
		            this.pos,
		            "Unexpected token `" + this.input[this.pos] + "`. Did you mean `" +
		              (ch === 62 ? "&gt;" : "&rbrace;") + "` or " + "`{\"" + this.input[this.pos] + "\"}" + "`?"
		          );

		        default:
		          if (isNewLine(ch)) {
		            out += this.input.slice(chunkStart, this.pos);
		            out += this.jsx_readNewLine(true);
		            chunkStart = this.pos;
		          } else {
		            ++this.pos;
		          }
		        }
		      }
		    }

		    jsx_readNewLine(normalizeCRLF) {
		      let ch = this.input.charCodeAt(this.pos);
		      let out;
		      ++this.pos;
		      if (ch === 13 && this.input.charCodeAt(this.pos) === 10) {
		        ++this.pos;
		        out = normalizeCRLF ? '\n' : '\r\n';
		      } else {
		        out = String.fromCharCode(ch);
		      }
		      if (this.options.locations) {
		        ++this.curLine;
		        this.lineStart = this.pos;
		      }

		      return out;
		    }

		    jsx_readString(quote) {
		      let out = '', chunkStart = ++this.pos;
		      for (;;) {
		        if (this.pos >= this.input.length)
		          this.raise(this.start, 'Unterminated string constant');
		        let ch = this.input.charCodeAt(this.pos);
		        if (ch === quote) break;
		        if (ch === 38) { // '&'
		          out += this.input.slice(chunkStart, this.pos);
		          out += this.jsx_readEntity();
		          chunkStart = this.pos;
		        } else if (isNewLine(ch)) {
		          out += this.input.slice(chunkStart, this.pos);
		          out += this.jsx_readNewLine(false);
		          chunkStart = this.pos;
		        } else {
		          ++this.pos;
		        }
		      }
		      out += this.input.slice(chunkStart, this.pos++);
		      return this.finishToken(tt.string, out);
		    }

		    jsx_readEntity() {
		      let str = '', count = 0, entity;
		      let ch = this.input[this.pos];
		      if (ch !== '&')
		        this.raise(this.pos, 'Entity must start with an ampersand');
		      let startPos = ++this.pos;
		      while (this.pos < this.input.length && count++ < 10) {
		        ch = this.input[this.pos++];
		        if (ch === ';') {
		          if (str[0] === '#') {
		            if (str[1] === 'x') {
		              str = str.substr(2);
		              if (hexNumber.test(str))
		                entity = String.fromCharCode(parseInt(str, 16));
		            } else {
		              str = str.substr(1);
		              if (decimalNumber.test(str))
		                entity = String.fromCharCode(parseInt(str, 10));
		            }
		          } else {
		            entity = XHTMLEntities[str];
		          }
		          break;
		        }
		        str += ch;
		      }
		      if (!entity) {
		        this.pos = startPos;
		        return '&';
		      }
		      return entity;
		    }

		    // Read a JSX identifier (valid tag or attribute name).
		    //
		    // Optimized version since JSX identifiers can't contain
		    // escape characters and so can be read as single slice.
		    // Also assumes that first character was already checked
		    // by isIdentifierStart in readToken.

		    jsx_readWord() {
		      let ch, start = this.pos;
		      do {
		        ch = this.input.charCodeAt(++this.pos);
		      } while (isIdentifierChar(ch) || ch === 45); // '-'
		      return this.finishToken(tok.jsxName, this.input.slice(start, this.pos));
		    }

		    // Parse next token as JSX identifier

		    jsx_parseIdentifier() {
		      let node = this.startNode();
		      if (this.type === tok.jsxName)
		        node.name = this.value;
		      else if (this.type.keyword)
		        node.name = this.type.keyword;
		      else
		        this.unexpected();
		      this.next();
		      return this.finishNode(node, 'JSXIdentifier');
		    }

		    // Parse namespaced identifier.

		    jsx_parseNamespacedName() {
		      let startPos = this.start, startLoc = this.startLoc;
		      let name = this.jsx_parseIdentifier();
		      if (!options.allowNamespaces || !this.eat(tt.colon)) return name;
		      var node = this.startNodeAt(startPos, startLoc);
		      node.namespace = name;
		      node.name = this.jsx_parseIdentifier();
		      return this.finishNode(node, 'JSXNamespacedName');
		    }

		    // Parses element name in any form - namespaced, member
		    // or single identifier.

		    jsx_parseElementName() {
		      if (this.type === tok.jsxTagEnd) return '';
		      let startPos = this.start, startLoc = this.startLoc;
		      let node = this.jsx_parseNamespacedName();
		      if (this.type === tt.dot && node.type === 'JSXNamespacedName' && !options.allowNamespacedObjects) {
		        this.unexpected();
		      }
		      while (this.eat(tt.dot)) {
		        let newNode = this.startNodeAt(startPos, startLoc);
		        newNode.object = node;
		        newNode.property = this.jsx_parseIdentifier();
		        node = this.finishNode(newNode, 'JSXMemberExpression');
		      }
		      return node;
		    }

		    // Parses any type of JSX attribute value.

		    jsx_parseAttributeValue() {
		      switch (this.type) {
		      case tt.braceL:
		        let node = this.jsx_parseExpressionContainer();
		        if (node.expression.type === 'JSXEmptyExpression')
		          this.raise(node.start, 'JSX attributes must only be assigned a non-empty expression');
		        return node;

		      case tok.jsxTagStart:
		      case tt.string:
		        return this.parseExprAtom();

		      default:
		        this.raise(this.start, 'JSX value should be either an expression or a quoted JSX text');
		      }
		    }

		    // JSXEmptyExpression is unique type since it doesn't actually parse anything,
		    // and so it should start at the end of last read token (left brace) and finish
		    // at the beginning of the next one (right brace).

		    jsx_parseEmptyExpression() {
		      let node = this.startNodeAt(this.lastTokEnd, this.lastTokEndLoc);
		      return this.finishNodeAt(node, 'JSXEmptyExpression', this.start, this.startLoc);
		    }

		    // Parses JSX expression enclosed into curly brackets.

		    jsx_parseExpressionContainer() {
		      let node = this.startNode();
		      this.next();
		      node.expression = this.type === tt.braceR
		        ? this.jsx_parseEmptyExpression()
		        : this.parseExpression();
		      this.expect(tt.braceR);
		      return this.finishNode(node, 'JSXExpressionContainer');
		    }

		    // Parses following JSX attribute name-value pair.

		    jsx_parseAttribute() {
		      let node = this.startNode();
		      if (this.eat(tt.braceL)) {
		        this.expect(tt.ellipsis);
		        node.argument = this.parseMaybeAssign();
		        this.expect(tt.braceR);
		        return this.finishNode(node, 'JSXSpreadAttribute');
		      }
		      node.name = this.jsx_parseNamespacedName();
		      node.value = this.eat(tt.eq) ? this.jsx_parseAttributeValue() : null;
		      return this.finishNode(node, 'JSXAttribute');
		    }

		    // Parses JSX opening tag starting after '<'.

		    jsx_parseOpeningElementAt(startPos, startLoc) {
		      let node = this.startNodeAt(startPos, startLoc);
		      node.attributes = [];
		      let nodeName = this.jsx_parseElementName();
		      if (nodeName) node.name = nodeName;
		      while (this.type !== tt.slash && this.type !== tok.jsxTagEnd)
		        node.attributes.push(this.jsx_parseAttribute());
		      node.selfClosing = this.eat(tt.slash);
		      this.expect(tok.jsxTagEnd);
		      return this.finishNode(node, nodeName ? 'JSXOpeningElement' : 'JSXOpeningFragment');
		    }

		    // Parses JSX closing tag starting after '</'.

		    jsx_parseClosingElementAt(startPos, startLoc) {
		      let node = this.startNodeAt(startPos, startLoc);
		      let nodeName = this.jsx_parseElementName();
		      if (nodeName) node.name = nodeName;
		      this.expect(tok.jsxTagEnd);
		      return this.finishNode(node, nodeName ? 'JSXClosingElement' : 'JSXClosingFragment');
		    }

		    // Parses entire JSX element, including it's opening tag
		    // (starting after '<'), attributes, contents and closing tag.

		    jsx_parseElementAt(startPos, startLoc) {
		      let node = this.startNodeAt(startPos, startLoc);
		      let children = [];
		      let openingElement = this.jsx_parseOpeningElementAt(startPos, startLoc);
		      let closingElement = null;

		      if (!openingElement.selfClosing) {
		        contents: for (;;) {
		          switch (this.type) {
		          case tok.jsxTagStart:
		            startPos = this.start; startLoc = this.startLoc;
		            this.next();
		            if (this.eat(tt.slash)) {
		              closingElement = this.jsx_parseClosingElementAt(startPos, startLoc);
		              break contents;
		            }
		            children.push(this.jsx_parseElementAt(startPos, startLoc));
		            break;

		          case tok.jsxText:
		            children.push(this.parseExprAtom());
		            break;

		          case tt.braceL:
		            children.push(this.jsx_parseExpressionContainer());
		            break;

		          default:
		            this.unexpected();
		          }
		        }
		        if (getQualifiedJSXName(closingElement.name) !== getQualifiedJSXName(openingElement.name)) {
		          this.raise(
		            closingElement.start,
		            'Expected corresponding JSX closing tag for <' + getQualifiedJSXName(openingElement.name) + '>');
		        }
		      }
		      let fragmentOrElement = openingElement.name ? 'Element' : 'Fragment';

		      node['opening' + fragmentOrElement] = openingElement;
		      node['closing' + fragmentOrElement] = closingElement;
		      node.children = children;
		      if (this.type === tt.relational && this.value === "<") {
		        this.raise(this.start, "Adjacent JSX elements must be wrapped in an enclosing tag");
		      }
		      return this.finishNode(node, 'JSX' + fragmentOrElement);
		    }

		    // Parse JSX text

		    jsx_parseText() {
		      let node = this.parseLiteral(this.value);
		      node.type = "JSXText";
		      return node;
		    }

		    // Parses entire JSX element from current position.

		    jsx_parseElement() {
		      let startPos = this.start, startLoc = this.startLoc;
		      this.next();
		      return this.jsx_parseElementAt(startPos, startLoc);
		    }

		    parseExprAtom(refShortHandDefaultPos) {
		      if (this.type === tok.jsxText)
		        return this.jsx_parseText();
		      else if (this.type === tok.jsxTagStart)
		        return this.jsx_parseElement();
		      else
		        return super.parseExprAtom(refShortHandDefaultPos);
		    }

		    readToken(code) {
		      let context = this.curContext();

		      if (context === tc_expr) return this.jsx_readToken();

		      if (context === tc_oTag || context === tc_cTag) {
		        if (isIdentifierStart(code)) return this.jsx_readWord();

		        if (code == 62) {
		          ++this.pos;
		          return this.finishToken(tok.jsxTagEnd);
		        }

		        if ((code === 34 || code === 39) && context == tc_oTag)
		          return this.jsx_readString(code);
		      }

		      if (code === 60 && this.exprAllowed && this.input.charCodeAt(this.pos + 1) !== 33) {
		        ++this.pos;
		        return this.finishToken(tok.jsxTagStart);
		      }
		      return super.readToken(code);
		    }

		    updateContext(prevType) {
		      if (this.type == tt.braceL) {
		        var curContext = this.curContext();
		        if (curContext == tc_oTag) this.context.push(tokContexts.b_expr);
		        else if (curContext == tc_expr) this.context.push(tokContexts.b_tmpl);
		        else super.updateContext(prevType);
		        this.exprAllowed = true;
		      } else if (this.type === tt.slash && prevType === tok.jsxTagStart) {
		        this.context.length -= 2; // do not consider JSX expr -> JSX open tag -> ... anymore
		        this.context.push(tc_cTag); // reconsider as closing tag context
		        this.exprAllowed = false;
		      } else {
		        return super.updateContext(prevType);
		      }
		    }
		  };
		} 
	} (acornJsx));
	return acornJsx.exports;
}

var eslintVisitorKeys$1 = {};

var hasRequiredEslintVisitorKeys$1;

function requireEslintVisitorKeys$1 () {
	if (hasRequiredEslintVisitorKeys$1) return eslintVisitorKeys$1;
	hasRequiredEslintVisitorKeys$1 = 1;

	/* eslint-disable jsdoc/valid-types -- doesn't allow `readonly`.
	   TODO: remove eslint-disable when https://github.com/jsdoc-type-pratt-parser/jsdoc-type-pratt-parser/issues/164 is fixed
	*/
	/**
	 * @typedef {{ readonly [type: string]: ReadonlyArray<string> }} VisitorKeys
	 */
	/* eslint-enable jsdoc/valid-types -- doesn't allow `readonly string[]`. TODO: check why */

	/**
	 * @type {VisitorKeys}
	 */
	const KEYS = {
	    ArrayExpression: [
	        "elements"
	    ],
	    ArrayPattern: [
	        "elements"
	    ],
	    ArrowFunctionExpression: [
	        "params",
	        "body"
	    ],
	    AssignmentExpression: [
	        "left",
	        "right"
	    ],
	    AssignmentPattern: [
	        "left",
	        "right"
	    ],
	    AwaitExpression: [
	        "argument"
	    ],
	    BinaryExpression: [
	        "left",
	        "right"
	    ],
	    BlockStatement: [
	        "body"
	    ],
	    BreakStatement: [
	        "label"
	    ],
	    CallExpression: [
	        "callee",
	        "arguments"
	    ],
	    CatchClause: [
	        "param",
	        "body"
	    ],
	    ChainExpression: [
	        "expression"
	    ],
	    ClassBody: [
	        "body"
	    ],
	    ClassDeclaration: [
	        "id",
	        "superClass",
	        "body"
	    ],
	    ClassExpression: [
	        "id",
	        "superClass",
	        "body"
	    ],
	    ConditionalExpression: [
	        "test",
	        "consequent",
	        "alternate"
	    ],
	    ContinueStatement: [
	        "label"
	    ],
	    DebuggerStatement: [],
	    DoWhileStatement: [
	        "body",
	        "test"
	    ],
	    EmptyStatement: [],
	    ExperimentalRestProperty: [
	        "argument"
	    ],
	    ExperimentalSpreadProperty: [
	        "argument"
	    ],
	    ExportAllDeclaration: [
	        "exported",
	        "source",
	        "attributes"
	    ],
	    ExportDefaultDeclaration: [
	        "declaration"
	    ],
	    ExportNamedDeclaration: [
	        "declaration",
	        "specifiers",
	        "source",
	        "attributes"
	    ],
	    ExportSpecifier: [
	        "exported",
	        "local"
	    ],
	    ExpressionStatement: [
	        "expression"
	    ],
	    ForInStatement: [
	        "left",
	        "right",
	        "body"
	    ],
	    ForOfStatement: [
	        "left",
	        "right",
	        "body"
	    ],
	    ForStatement: [
	        "init",
	        "test",
	        "update",
	        "body"
	    ],
	    FunctionDeclaration: [
	        "id",
	        "params",
	        "body"
	    ],
	    FunctionExpression: [
	        "id",
	        "params",
	        "body"
	    ],
	    Identifier: [],
	    IfStatement: [
	        "test",
	        "consequent",
	        "alternate"
	    ],
	    ImportAttribute: [
	        "key",
	        "value"
	    ],
	    ImportDeclaration: [
	        "specifiers",
	        "source",
	        "attributes"
	    ],
	    ImportDefaultSpecifier: [
	        "local"
	    ],
	    ImportExpression: [
	        "source",
	        "options"
	    ],
	    ImportNamespaceSpecifier: [
	        "local"
	    ],
	    ImportSpecifier: [
	        "imported",
	        "local"
	    ],
	    JSXAttribute: [
	        "name",
	        "value"
	    ],
	    JSXClosingElement: [
	        "name"
	    ],
	    JSXClosingFragment: [],
	    JSXElement: [
	        "openingElement",
	        "children",
	        "closingElement"
	    ],
	    JSXEmptyExpression: [],
	    JSXExpressionContainer: [
	        "expression"
	    ],
	    JSXFragment: [
	        "openingFragment",
	        "children",
	        "closingFragment"
	    ],
	    JSXIdentifier: [],
	    JSXMemberExpression: [
	        "object",
	        "property"
	    ],
	    JSXNamespacedName: [
	        "namespace",
	        "name"
	    ],
	    JSXOpeningElement: [
	        "name",
	        "attributes"
	    ],
	    JSXOpeningFragment: [],
	    JSXSpreadAttribute: [
	        "argument"
	    ],
	    JSXSpreadChild: [
	        "expression"
	    ],
	    JSXText: [],
	    LabeledStatement: [
	        "label",
	        "body"
	    ],
	    Literal: [],
	    LogicalExpression: [
	        "left",
	        "right"
	    ],
	    MemberExpression: [
	        "object",
	        "property"
	    ],
	    MetaProperty: [
	        "meta",
	        "property"
	    ],
	    MethodDefinition: [
	        "key",
	        "value"
	    ],
	    NewExpression: [
	        "callee",
	        "arguments"
	    ],
	    ObjectExpression: [
	        "properties"
	    ],
	    ObjectPattern: [
	        "properties"
	    ],
	    PrivateIdentifier: [],
	    Program: [
	        "body"
	    ],
	    Property: [
	        "key",
	        "value"
	    ],
	    PropertyDefinition: [
	        "key",
	        "value"
	    ],
	    RestElement: [
	        "argument"
	    ],
	    ReturnStatement: [
	        "argument"
	    ],
	    SequenceExpression: [
	        "expressions"
	    ],
	    SpreadElement: [
	        "argument"
	    ],
	    StaticBlock: [
	        "body"
	    ],
	    Super: [],
	    SwitchCase: [
	        "test",
	        "consequent"
	    ],
	    SwitchStatement: [
	        "discriminant",
	        "cases"
	    ],
	    TaggedTemplateExpression: [
	        "tag",
	        "quasi"
	    ],
	    TemplateElement: [],
	    TemplateLiteral: [
	        "quasis",
	        "expressions"
	    ],
	    ThisExpression: [],
	    ThrowStatement: [
	        "argument"
	    ],
	    TryStatement: [
	        "block",
	        "handler",
	        "finalizer"
	    ],
	    UnaryExpression: [
	        "argument"
	    ],
	    UpdateExpression: [
	        "argument"
	    ],
	    VariableDeclaration: [
	        "declarations"
	    ],
	    VariableDeclarator: [
	        "id",
	        "init"
	    ],
	    WhileStatement: [
	        "test",
	        "body"
	    ],
	    WithStatement: [
	        "object",
	        "body"
	    ],
	    YieldExpression: [
	        "argument"
	    ]
	};

	// Types.
	const NODE_TYPES = Object.keys(KEYS);

	// Freeze the keys.
	for (const type of NODE_TYPES) {
	    Object.freeze(KEYS[type]);
	}
	Object.freeze(KEYS);

	/**
	 * @author Toru Nagashima <https://github.com/mysticatea>
	 * See LICENSE file in root directory for full license.
	 */

	/**
	 * @typedef {import('./visitor-keys.js').VisitorKeys} VisitorKeys
	 */

	// List to ignore keys.
	const KEY_BLACKLIST = new Set([
	    "parent",
	    "leadingComments",
	    "trailingComments"
	]);

	/**
	 * Check whether a given key should be used or not.
	 * @param {string} key The key to check.
	 * @returns {boolean} `true` if the key should be used.
	 */
	function filterKey(key) {
	    return !KEY_BLACKLIST.has(key) && key[0] !== "_";
	}


	/* eslint-disable jsdoc/valid-types -- doesn't allow `readonly`.
	   TODO: remove eslint-disable when https://github.com/jsdoc-type-pratt-parser/jsdoc-type-pratt-parser/issues/164 is fixed
	*/
	/**
	 * Get visitor keys of a given node.
	 * @param {Object} node The AST node to get keys.
	 * @returns {readonly string[]} Visitor keys of the node.
	 */
	function getKeys(node) {
	    return Object.keys(node).filter(filterKey);
	}
	/* eslint-enable jsdoc/valid-types -- doesn't allow `readonly` */

	/**
	 * Make the union set with `KEYS` and given keys.
	 * @param {VisitorKeys} additionalKeys The additional keys.
	 * @returns {VisitorKeys} The union set.
	 */
	function unionWith(additionalKeys) {
	    const retv = /** @type {{ [type: string]: ReadonlyArray<string> }} */
	        (Object.assign({}, KEYS));

	    for (const type of Object.keys(additionalKeys)) {
	        if (Object.hasOwn(retv, type)) {
	            const keys = new Set(additionalKeys[type]);

	            for (const key of retv[type]) {
	                keys.add(key);
	            }

	            retv[type] = Object.freeze(Array.from(keys));
	        } else {
	            retv[type] = Object.freeze(Array.from(additionalKeys[type]));
	        }
	    }

	    return Object.freeze(retv);
	}

	eslintVisitorKeys$1.KEYS = KEYS;
	eslintVisitorKeys$1.getKeys = getKeys;
	eslintVisitorKeys$1.unionWith = unionWith;
	return eslintVisitorKeys$1;
}

var hasRequiredEspree;

function requireEspree () {
	if (hasRequiredEspree) return espree;
	hasRequiredEspree = 1;

	Object.defineProperty(espree, '__esModule', { value: true });

	var acorn = requireAcorn();
	var jsx = requireAcornJsx();
	var visitorKeys = requireEslintVisitorKeys$1();

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	function _interopNamespace(e) {
	    if (e && e.__esModule) return e;
	    var n = Object.create(null);
	    if (e) {
	        Object.keys(e).forEach(function (k) {
	            if (k !== 'default') {
	                var d = Object.getOwnPropertyDescriptor(e, k);
	                Object.defineProperty(n, k, d.get ? d : {
	                    enumerable: true,
	                    get: function () { return e[k]; }
	                });
	            }
	        });
	    }
	    n["default"] = e;
	    return Object.freeze(n);
	}

	var acorn__namespace = /*#__PURE__*/_interopNamespace(acorn);
	var jsx__default = /*#__PURE__*/_interopDefaultLegacy(jsx);
	var visitorKeys__namespace = /*#__PURE__*/_interopNamespace(visitorKeys);

	/**
	 * @fileoverview Translates tokens between Acorn format and Esprima format.
	 * @author Nicholas C. Zakas
	 */

	//------------------------------------------------------------------------------
	// Requirements
	//------------------------------------------------------------------------------

	// none!

	//------------------------------------------------------------------------------
	// Private
	//------------------------------------------------------------------------------


	// Esprima Token Types
	const Token = {
	    Boolean: "Boolean",
	    Identifier: "Identifier",
	    PrivateIdentifier: "PrivateIdentifier",
	    Keyword: "Keyword",
	    Null: "Null",
	    Numeric: "Numeric",
	    Punctuator: "Punctuator",
	    String: "String",
	    RegularExpression: "RegularExpression",
	    Template: "Template",
	    JSXIdentifier: "JSXIdentifier",
	    JSXText: "JSXText"
	};

	/**
	 * Converts part of a template into an Esprima token.
	 * @param {AcornToken[]} tokens The Acorn tokens representing the template.
	 * @param {string} code The source code.
	 * @returns {EsprimaToken} The Esprima equivalent of the template token.
	 * @private
	 */
	function convertTemplatePart(tokens, code) {
	    const firstToken = tokens[0],
	        lastTemplateToken = tokens.at(-1);

	    const token = {
	        type: Token.Template,
	        value: code.slice(firstToken.start, lastTemplateToken.end)
	    };

	    if (firstToken.loc) {
	        token.loc = {
	            start: firstToken.loc.start,
	            end: lastTemplateToken.loc.end
	        };
	    }

	    if (firstToken.range) {
	        token.start = firstToken.range[0];
	        token.end = lastTemplateToken.range[1];
	        token.range = [token.start, token.end];
	    }

	    return token;
	}

	/**
	 * Contains logic to translate Acorn tokens into Esprima tokens.
	 * @param {Object} acornTokTypes The Acorn token types.
	 * @param {string} code The source code Acorn is parsing. This is necessary
	 *      to correct the "value" property of some tokens.
	 * @constructor
	 */
	function TokenTranslator(acornTokTypes, code) {

	    // token types
	    this._acornTokTypes = acornTokTypes;

	    // token buffer for templates
	    this._tokens = [];

	    // track the last curly brace
	    this._curlyBrace = null;

	    // the source code
	    this._code = code;

	}

	TokenTranslator.prototype = {
	    constructor: TokenTranslator,

	    /**
	     * Translates a single Esprima token to a single Acorn token. This may be
	     * inaccurate due to how templates are handled differently in Esprima and
	     * Acorn, but should be accurate for all other tokens.
	     * @param {AcornToken} token The Acorn token to translate.
	     * @param {Object} extra Espree extra object.
	     * @returns {EsprimaToken} The Esprima version of the token.
	     */
	    translate(token, extra) {

	        const type = token.type,
	            tt = this._acornTokTypes;

	        if (type === tt.name) {
	            token.type = Token.Identifier;

	            // TODO: See if this is an Acorn bug
	            if (token.value === "static") {
	                token.type = Token.Keyword;
	            }

	            if (extra.ecmaVersion > 5 && (token.value === "yield" || token.value === "let")) {
	                token.type = Token.Keyword;
	            }

	        } else if (type === tt.privateId) {
	            token.type = Token.PrivateIdentifier;

	        } else if (type === tt.semi || type === tt.comma ||
	                 type === tt.parenL || type === tt.parenR ||
	                 type === tt.braceL || type === tt.braceR ||
	                 type === tt.dot || type === tt.bracketL ||
	                 type === tt.colon || type === tt.question ||
	                 type === tt.bracketR || type === tt.ellipsis ||
	                 type === tt.arrow || type === tt.jsxTagStart ||
	                 type === tt.incDec || type === tt.starstar ||
	                 type === tt.jsxTagEnd || type === tt.prefix ||
	                 type === tt.questionDot ||
	                 (type.binop && !type.keyword) ||
	                 type.isAssign) {

	            token.type = Token.Punctuator;
	            token.value = this._code.slice(token.start, token.end);
	        } else if (type === tt.jsxName) {
	            token.type = Token.JSXIdentifier;
	        } else if (type.label === "jsxText" || type === tt.jsxAttrValueToken) {
	            token.type = Token.JSXText;
	        } else if (type.keyword) {
	            if (type.keyword === "true" || type.keyword === "false") {
	                token.type = Token.Boolean;
	            } else if (type.keyword === "null") {
	                token.type = Token.Null;
	            } else {
	                token.type = Token.Keyword;
	            }
	        } else if (type === tt.num) {
	            token.type = Token.Numeric;
	            token.value = this._code.slice(token.start, token.end);
	        } else if (type === tt.string) {

	            if (extra.jsxAttrValueToken) {
	                extra.jsxAttrValueToken = false;
	                token.type = Token.JSXText;
	            } else {
	                token.type = Token.String;
	            }

	            token.value = this._code.slice(token.start, token.end);
	        } else if (type === tt.regexp) {
	            token.type = Token.RegularExpression;
	            const value = token.value;

	            token.regex = {
	                flags: value.flags,
	                pattern: value.pattern
	            };
	            token.value = `/${value.pattern}/${value.flags}`;
	        }

	        return token;
	    },

	    /**
	     * Function to call during Acorn's onToken handler.
	     * @param {AcornToken} token The Acorn token.
	     * @param {Object} extra The Espree extra object.
	     * @returns {void}
	     */
	    onToken(token, extra) {

	        const tt = this._acornTokTypes,
	            tokens = extra.tokens,
	            templateTokens = this._tokens;

	        /**
	         * Flushes the buffered template tokens and resets the template
	         * tracking.
	         * @returns {void}
	         * @private
	         */
	        const translateTemplateTokens = () => {
	            tokens.push(convertTemplatePart(this._tokens, this._code));
	            this._tokens = [];
	        };

	        if (token.type === tt.eof) {

	            // might be one last curlyBrace
	            if (this._curlyBrace) {
	                tokens.push(this.translate(this._curlyBrace, extra));
	            }

	            return;
	        }

	        if (token.type === tt.backQuote) {

	            // if there's already a curly, it's not part of the template
	            if (this._curlyBrace) {
	                tokens.push(this.translate(this._curlyBrace, extra));
	                this._curlyBrace = null;
	            }

	            templateTokens.push(token);

	            // it's the end
	            if (templateTokens.length > 1) {
	                translateTemplateTokens();
	            }

	            return;
	        }
	        if (token.type === tt.dollarBraceL) {
	            templateTokens.push(token);
	            translateTemplateTokens();
	            return;
	        }
	        if (token.type === tt.braceR) {

	            // if there's already a curly, it's not part of the template
	            if (this._curlyBrace) {
	                tokens.push(this.translate(this._curlyBrace, extra));
	            }

	            // store new curly for later
	            this._curlyBrace = token;
	            return;
	        }
	        if (token.type === tt.template || token.type === tt.invalidTemplate) {
	            if (this._curlyBrace) {
	                templateTokens.push(this._curlyBrace);
	                this._curlyBrace = null;
	            }

	            templateTokens.push(token);
	            return;
	        }

	        if (this._curlyBrace) {
	            tokens.push(this.translate(this._curlyBrace, extra));
	            this._curlyBrace = null;
	        }

	        tokens.push(this.translate(token, extra));
	    }
	};

	/**
	 * @fileoverview A collection of methods for processing Espree's options.
	 * @author Kai Cataldo
	 */

	//------------------------------------------------------------------------------
	// Helpers
	//------------------------------------------------------------------------------

	const SUPPORTED_VERSIONS = [
	    3,
	    5,
	    6, // 2015
	    7, // 2016
	    8, // 2017
	    9, // 2018
	    10, // 2019
	    11, // 2020
	    12, // 2021
	    13, // 2022
	    14, // 2023
	    15, // 2024
	    16 // 2025
	];

	/**
	 * Get the latest ECMAScript version supported by Espree.
	 * @returns {number} The latest ECMAScript version.
	 */
	function getLatestEcmaVersion() {
	    return SUPPORTED_VERSIONS.at(-1);
	}

	/**
	 * Get the list of ECMAScript versions supported by Espree.
	 * @returns {number[]} An array containing the supported ECMAScript versions.
	 */
	function getSupportedEcmaVersions() {
	    return [...SUPPORTED_VERSIONS];
	}

	/**
	 * Normalize ECMAScript version from the initial config
	 * @param {(number|"latest")} ecmaVersion ECMAScript version from the initial config
	 * @throws {Error} throws an error if the ecmaVersion is invalid.
	 * @returns {number} normalized ECMAScript version
	 */
	function normalizeEcmaVersion(ecmaVersion = 5) {

	    let version = ecmaVersion === "latest" ? getLatestEcmaVersion() : ecmaVersion;

	    if (typeof version !== "number") {
	        throw new Error(`ecmaVersion must be a number or "latest". Received value of type ${typeof ecmaVersion} instead.`);
	    }

	    // Calculate ECMAScript edition number from official year version starting with
	    // ES2015, which corresponds with ES6 (or a difference of 2009).
	    if (version >= 2015) {
	        version -= 2009;
	    }

	    if (!SUPPORTED_VERSIONS.includes(version)) {
	        throw new Error("Invalid ecmaVersion.");
	    }

	    return version;
	}

	/**
	 * Normalize sourceType from the initial config
	 * @param {string} sourceType to normalize
	 * @throws {Error} throw an error if sourceType is invalid
	 * @returns {string} normalized sourceType
	 */
	function normalizeSourceType(sourceType = "script") {
	    if (sourceType === "script" || sourceType === "module") {
	        return sourceType;
	    }

	    if (sourceType === "commonjs") {
	        return "script";
	    }

	    throw new Error("Invalid sourceType.");
	}

	/**
	 * Normalize parserOptions
	 * @param {Object} options the parser options to normalize
	 * @throws {Error} throw an error if found invalid option.
	 * @returns {Object} normalized options
	 */
	function normalizeOptions(options) {
	    const ecmaVersion = normalizeEcmaVersion(options.ecmaVersion);
	    const sourceType = normalizeSourceType(options.sourceType);
	    const ranges = options.range === true;
	    const locations = options.loc === true;

	    if (ecmaVersion !== 3 && options.allowReserved) {

	        // a value of `false` is intentionally allowed here, so a shared config can overwrite it when needed
	        throw new Error("`allowReserved` is only supported when ecmaVersion is 3");
	    }
	    if (typeof options.allowReserved !== "undefined" && typeof options.allowReserved !== "boolean") {
	        throw new Error("`allowReserved`, when present, must be `true` or `false`");
	    }
	    const allowReserved = ecmaVersion === 3 ? (options.allowReserved || "never") : false;
	    const ecmaFeatures = options.ecmaFeatures || {};
	    const allowReturnOutsideFunction = options.sourceType === "commonjs" ||
	        Boolean(ecmaFeatures.globalReturn);

	    if (sourceType === "module" && ecmaVersion < 6) {
	        throw new Error("sourceType 'module' is not supported when ecmaVersion < 2015. Consider adding `{ ecmaVersion: 2015 }` to the parser options.");
	    }

	    return Object.assign({}, options, {
	        ecmaVersion,
	        sourceType,
	        ranges,
	        locations,
	        allowReserved,
	        allowReturnOutsideFunction
	    });
	}

	/* eslint no-param-reassign: 0 -- stylistic choice */


	const STATE = Symbol("espree's internal state");
	const ESPRIMA_FINISH_NODE = Symbol("espree's esprimaFinishNode");


	/**
	 * Converts an Acorn comment to a Esprima comment.
	 * @param {boolean} block True if it's a block comment, false if not.
	 * @param {string} text The text of the comment.
	 * @param {int} start The index at which the comment starts.
	 * @param {int} end The index at which the comment ends.
	 * @param {Location} startLoc The location at which the comment starts.
	 * @param {Location} endLoc The location at which the comment ends.
	 * @param {string} code The source code being parsed.
	 * @returns {Object} The comment object.
	 * @private
	 */
	function convertAcornCommentToEsprimaComment(block, text, start, end, startLoc, endLoc, code) {
	    let type;

	    if (block) {
	        type = "Block";
	    } else if (code.slice(start, start + 2) === "#!") {
	        type = "Hashbang";
	    } else {
	        type = "Line";
	    }

	    const comment = {
	        type,
	        value: text
	    };

	    if (typeof start === "number") {
	        comment.start = start;
	        comment.end = end;
	        comment.range = [start, end];
	    }

	    if (typeof startLoc === "object") {
	        comment.loc = {
	            start: startLoc,
	            end: endLoc
	        };
	    }

	    return comment;
	}

	var espree$1 = () => Parser => {
	    const tokTypes = Object.assign({}, Parser.acorn.tokTypes);

	    if (Parser.acornJsx) {
	        Object.assign(tokTypes, Parser.acornJsx.tokTypes);
	    }

	    return class Espree extends Parser {
	        constructor(opts, code) {
	            if (typeof opts !== "object" || opts === null) {
	                opts = {};
	            }
	            if (typeof code !== "string" && !(code instanceof String)) {
	                code = String(code);
	            }

	            // save original source type in case of commonjs
	            const originalSourceType = opts.sourceType;
	            const options = normalizeOptions(opts);
	            const ecmaFeatures = options.ecmaFeatures || {};
	            const tokenTranslator =
	                options.tokens === true
	                    ? new TokenTranslator(tokTypes, code)
	                    : null;

	            /*
	             * Data that is unique to Espree and is not represented internally
	             * in Acorn.
	             *
	             * For ES2023 hashbangs, Espree will call `onComment()` during the
	             * constructor, so we must define state before having access to
	             * `this`.
	             */
	            const state = {
	                originalSourceType: originalSourceType || options.sourceType,
	                tokens: tokenTranslator ? [] : null,
	                comments: options.comment === true ? [] : null,
	                impliedStrict: ecmaFeatures.impliedStrict === true && options.ecmaVersion >= 5,
	                ecmaVersion: options.ecmaVersion,
	                jsxAttrValueToken: false,
	                lastToken: null,
	                templateElements: []
	            };

	            // Initialize acorn parser.
	            super({

	                // do not use spread, because we don't want to pass any unknown options to acorn
	                ecmaVersion: options.ecmaVersion,
	                sourceType: options.sourceType,
	                ranges: options.ranges,
	                locations: options.locations,
	                allowReserved: options.allowReserved,

	                // Truthy value is true for backward compatibility.
	                allowReturnOutsideFunction: options.allowReturnOutsideFunction,

	                // Collect tokens
	                onToken(token) {
	                    if (tokenTranslator) {

	                        // Use `tokens`, `ecmaVersion`, and `jsxAttrValueToken` in the state.
	                        tokenTranslator.onToken(token, state);
	                    }
	                    if (token.type !== tokTypes.eof) {
	                        state.lastToken = token;
	                    }
	                },

	                // Collect comments
	                onComment(block, text, start, end, startLoc, endLoc) {
	                    if (state.comments) {
	                        const comment = convertAcornCommentToEsprimaComment(block, text, start, end, startLoc, endLoc, code);

	                        state.comments.push(comment);
	                    }
	                }
	            }, code);

	            /*
	             * We put all of this data into a symbol property as a way to avoid
	             * potential naming conflicts with future versions of Acorn.
	             */
	            this[STATE] = state;
	        }

	        tokenize() {
	            do {
	                this.next();
	            } while (this.type !== tokTypes.eof);

	            // Consume the final eof token
	            this.next();

	            const extra = this[STATE];
	            const tokens = extra.tokens;

	            if (extra.comments) {
	                tokens.comments = extra.comments;
	            }

	            return tokens;
	        }

	        finishNode(...args) {
	            const result = super.finishNode(...args);

	            return this[ESPRIMA_FINISH_NODE](result);
	        }

	        finishNodeAt(...args) {
	            const result = super.finishNodeAt(...args);

	            return this[ESPRIMA_FINISH_NODE](result);
	        }

	        parse() {
	            const extra = this[STATE];
	            const program = super.parse();

	            program.sourceType = extra.originalSourceType;

	            if (extra.comments) {
	                program.comments = extra.comments;
	            }
	            if (extra.tokens) {
	                program.tokens = extra.tokens;
	            }

	            /*
	             * Adjust opening and closing position of program to match Esprima.
	             * Acorn always starts programs at range 0 whereas Esprima starts at the
	             * first AST node's start (the only real difference is when there's leading
	             * whitespace or leading comments). Acorn also counts trailing whitespace
	             * as part of the program whereas Esprima only counts up to the last token.
	             */
	            if (program.body.length) {
	                const [firstNode] = program.body;

	                if (program.range) {
	                    program.range[0] = firstNode.range[0];
	                }
	                if (program.loc) {
	                    program.loc.start = firstNode.loc.start;
	                }
	                program.start = firstNode.start;
	            }
	            if (extra.lastToken) {
	                if (program.range) {
	                    program.range[1] = extra.lastToken.range[1];
	                }
	                if (program.loc) {
	                    program.loc.end = extra.lastToken.loc.end;
	                }
	                program.end = extra.lastToken.end;
	            }


	            /*
	             * https://github.com/eslint/espree/issues/349
	             * Ensure that template elements have correct range information.
	             * This is one location where Acorn produces a different value
	             * for its start and end properties vs. the values present in the
	             * range property. In order to avoid confusion, we set the start
	             * and end properties to the values that are present in range.
	             * This is done here, instead of in finishNode(), because Acorn
	             * uses the values of start and end internally while parsing, making
	             * it dangerous to change those values while parsing is ongoing.
	             * By waiting until the end of parsing, we can safely change these
	             * values without affect any other part of the process.
	             */
	            this[STATE].templateElements.forEach(templateElement => {
	                const startOffset = -1;
	                const endOffset = templateElement.tail ? 1 : 2;

	                templateElement.start += startOffset;
	                templateElement.end += endOffset;

	                if (templateElement.range) {
	                    templateElement.range[0] += startOffset;
	                    templateElement.range[1] += endOffset;
	                }

	                if (templateElement.loc) {
	                    templateElement.loc.start.column += startOffset;
	                    templateElement.loc.end.column += endOffset;
	                }
	            });

	            return program;
	        }

	        parseTopLevel(node) {
	            if (this[STATE].impliedStrict) {
	                this.strict = true;
	            }
	            return super.parseTopLevel(node);
	        }

	        /**
	         * Overwrites the default raise method to throw Esprima-style errors.
	         * @param {int} pos The position of the error.
	         * @param {string} message The error message.
	         * @throws {SyntaxError} A syntax error.
	         * @returns {void}
	         */
	        raise(pos, message) {
	            const loc = Parser.acorn.getLineInfo(this.input, pos);
	            const err = new SyntaxError(message);

	            err.index = pos;
	            err.lineNumber = loc.line;
	            err.column = loc.column + 1; // acorn uses 0-based columns
	            throw err;
	        }

	        /**
	         * Overwrites the default raise method to throw Esprima-style errors.
	         * @param {int} pos The position of the error.
	         * @param {string} message The error message.
	         * @throws {SyntaxError} A syntax error.
	         * @returns {void}
	         */
	        raiseRecoverable(pos, message) {
	            this.raise(pos, message);
	        }

	        /**
	         * Overwrites the default unexpected method to throw Esprima-style errors.
	         * @param {int} pos The position of the error.
	         * @throws {SyntaxError} A syntax error.
	         * @returns {void}
	         */
	        unexpected(pos) {
	            let message = "Unexpected token";

	            if (pos !== null && pos !== void 0) {
	                this.pos = pos;

	                if (this.options.locations) {
	                    while (this.pos < this.lineStart) {
	                        this.lineStart = this.input.lastIndexOf("\n", this.lineStart - 2) + 1;
	                        --this.curLine;
	                    }
	                }

	                this.nextToken();
	            }

	            if (this.end > this.start) {
	                message += ` ${this.input.slice(this.start, this.end)}`;
	            }

	            this.raise(this.start, message);
	        }

	        /*
	        * Esprima-FB represents JSX strings as tokens called "JSXText", but Acorn-JSX
	        * uses regular tt.string without any distinction between this and regular JS
	        * strings. As such, we intercept an attempt to read a JSX string and set a flag
	        * on extra so that when tokens are converted, the next token will be switched
	        * to JSXText via onToken.
	        */
	        jsx_readString(quote) { // eslint-disable-line camelcase -- required by API
	            const result = super.jsx_readString(quote);

	            if (this.type === tokTypes.string) {
	                this[STATE].jsxAttrValueToken = true;
	            }
	            return result;
	        }

	        /**
	         * Performs last-minute Esprima-specific compatibility checks and fixes.
	         * @param {ASTNode} result The node to check.
	         * @returns {ASTNode} The finished node.
	         */
	        [ESPRIMA_FINISH_NODE](result) {

	            // Acorn doesn't count the opening and closing backticks as part of templates
	            // so we have to adjust ranges/locations appropriately.
	            if (result.type === "TemplateElement") {

	                // save template element references to fix start/end later
	                this[STATE].templateElements.push(result);
	            }

	            if (result.type.includes("Function") && !result.generator) {
	                result.generator = false;
	            }

	            return result;
	        }
	    };
	};

	const version$1 = "10.3.0";

	/**
	 * @fileoverview Main Espree file that converts Acorn into Esprima output.
	 *
	 * This file contains code from the following MIT-licensed projects:
	 * 1. Acorn
	 * 2. Babylon
	 * 3. Babel-ESLint
	 *
	 * This file also contains code from Esprima, which is BSD licensed.
	 *
	 * Acorn is Copyright 2012-2015 Acorn Contributors (https://github.com/marijnh/acorn/blob/master/AUTHORS)
	 * Babylon is Copyright 2014-2015 various contributors (https://github.com/babel/babel/blob/master/packages/babylon/AUTHORS)
	 * Babel-ESLint is Copyright 2014-2015 Sebastian McKenzie <sebmck@gmail.com>
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions are met:
	 *
	 * * Redistributions of source code must retain the above copyright
	 *   notice, this list of conditions and the following disclaimer.
	 * * Redistributions in binary form must reproduce the above copyright
	 *   notice, this list of conditions and the following disclaimer in the
	 *   documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	 * ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	 *
	 * Esprima is Copyright (c) jQuery Foundation, Inc. and Contributors, All Rights Reserved.
	 *
	 * Redistribution and use in source and binary forms, with or without
	 * modification, are permitted provided that the following conditions are met:
	 *
	 *   * Redistributions of source code must retain the above copyright
	 *     notice, this list of conditions and the following disclaimer.
	 *   * Redistributions in binary form must reproduce the above copyright
	 *     notice, this list of conditions and the following disclaimer in the
	 *     documentation and/or other materials provided with the distribution.
	 *
	 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
	 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
	 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
	 * ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
	 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
	 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
	 */


	// To initialize lazily.
	const parsers = {
	    _regular: null,
	    _jsx: null,

	    get regular() {
	        if (this._regular === null) {
	            this._regular = acorn__namespace.Parser.extend(espree$1());
	        }
	        return this._regular;
	    },

	    get jsx() {
	        if (this._jsx === null) {
	            this._jsx = acorn__namespace.Parser.extend(jsx__default["default"](), espree$1());
	        }
	        return this._jsx;
	    },

	    get(options) {
	        const useJsx = Boolean(
	            options &&
	            options.ecmaFeatures &&
	            options.ecmaFeatures.jsx
	        );

	        return useJsx ? this.jsx : this.regular;
	    }
	};

	//------------------------------------------------------------------------------
	// Tokenizer
	//------------------------------------------------------------------------------

	/**
	 * Tokenizes the given code.
	 * @param {string} code The code to tokenize.
	 * @param {Object} options Options defining how to tokenize.
	 * @returns {Token[]} An array of tokens.
	 * @throws {SyntaxError} If the input code is invalid.
	 * @private
	 */
	function tokenize(code, options) {
	    const Parser = parsers.get(options);

	    // Ensure to collect tokens.
	    if (!options || options.tokens !== true) {
	        options = Object.assign({}, options, { tokens: true }); // eslint-disable-line no-param-reassign -- stylistic choice
	    }

	    return new Parser(options, code).tokenize();
	}

	//------------------------------------------------------------------------------
	// Parser
	//------------------------------------------------------------------------------

	/**
	 * Parses the given code.
	 * @param {string} code The code to tokenize.
	 * @param {Object} options Options defining how to tokenize.
	 * @returns {ASTNode} The "Program" AST node.
	 * @throws {SyntaxError} If the input code is invalid.
	 */
	function parse(code, options) {
	    const Parser = parsers.get(options);

	    return new Parser(options, code).parse();
	}

	//------------------------------------------------------------------------------
	// Public
	//------------------------------------------------------------------------------

	const version = version$1;
	const name = "espree";

	/* istanbul ignore next */
	const VisitorKeys = (function() {
	    return visitorKeys__namespace.KEYS;
	}());

	// Derive node types from VisitorKeys
	/* istanbul ignore next */
	const Syntax = (function() {
	    let key,
	        types = {};

	    if (typeof Object.create === "function") {
	        types = Object.create(null);
	    }

	    for (key in VisitorKeys) {
	        if (Object.hasOwn(VisitorKeys, key)) {
	            types[key] = key;
	        }
	    }

	    if (typeof Object.freeze === "function") {
	        Object.freeze(types);
	    }

	    return types;
	}());

	const latestEcmaVersion = getLatestEcmaVersion();

	const supportedEcmaVersions = getSupportedEcmaVersions();

	espree.Syntax = Syntax;
	espree.VisitorKeys = VisitorKeys;
	espree.latestEcmaVersion = latestEcmaVersion;
	espree.name = name;
	espree.parse = parse;
	espree.supportedEcmaVersions = supportedEcmaVersions;
	espree.tokenize = tokenize;
	espree.version = version;
	return espree;
}

var lodash_merge = {exports: {}};

lodash_merge.exports;

var hasRequiredLodash_merge;

function requireLodash_merge () {
	if (hasRequiredLodash_merge) return lodash_merge.exports;
	hasRequiredLodash_merge = 1;
	(function (module, exports) {
		/** Used as the size to enable large array optimizations. */
		var LARGE_ARRAY_SIZE = 200;

		/** Used to stand-in for `undefined` hash values. */
		var HASH_UNDEFINED = '__lodash_hash_undefined__';

		/** Used to detect hot functions by number of calls within a span of milliseconds. */
		var HOT_COUNT = 800,
		    HOT_SPAN = 16;

		/** Used as references for various `Number` constants. */
		var MAX_SAFE_INTEGER = 9007199254740991;

		/** `Object#toString` result references. */
		var argsTag = '[object Arguments]',
		    arrayTag = '[object Array]',
		    asyncTag = '[object AsyncFunction]',
		    boolTag = '[object Boolean]',
		    dateTag = '[object Date]',
		    errorTag = '[object Error]',
		    funcTag = '[object Function]',
		    genTag = '[object GeneratorFunction]',
		    mapTag = '[object Map]',
		    numberTag = '[object Number]',
		    nullTag = '[object Null]',
		    objectTag = '[object Object]',
		    proxyTag = '[object Proxy]',
		    regexpTag = '[object RegExp]',
		    setTag = '[object Set]',
		    stringTag = '[object String]',
		    undefinedTag = '[object Undefined]',
		    weakMapTag = '[object WeakMap]';

		var arrayBufferTag = '[object ArrayBuffer]',
		    dataViewTag = '[object DataView]',
		    float32Tag = '[object Float32Array]',
		    float64Tag = '[object Float64Array]',
		    int8Tag = '[object Int8Array]',
		    int16Tag = '[object Int16Array]',
		    int32Tag = '[object Int32Array]',
		    uint8Tag = '[object Uint8Array]',
		    uint8ClampedTag = '[object Uint8ClampedArray]',
		    uint16Tag = '[object Uint16Array]',
		    uint32Tag = '[object Uint32Array]';

		/**
		 * Used to match `RegExp`
		 * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).
		 */
		var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;

		/** Used to detect host constructors (Safari). */
		var reIsHostCtor = /^\[object .+?Constructor\]$/;

		/** Used to detect unsigned integer values. */
		var reIsUint = /^(?:0|[1-9]\d*)$/;

		/** Used to identify `toStringTag` values of typed arrays. */
		var typedArrayTags = {};
		typedArrayTags[float32Tag] = typedArrayTags[float64Tag] =
		typedArrayTags[int8Tag] = typedArrayTags[int16Tag] =
		typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =
		typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =
		typedArrayTags[uint32Tag] = true;
		typedArrayTags[argsTag] = typedArrayTags[arrayTag] =
		typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =
		typedArrayTags[dataViewTag] = typedArrayTags[dateTag] =
		typedArrayTags[errorTag] = typedArrayTags[funcTag] =
		typedArrayTags[mapTag] = typedArrayTags[numberTag] =
		typedArrayTags[objectTag] = typedArrayTags[regexpTag] =
		typedArrayTags[setTag] = typedArrayTags[stringTag] =
		typedArrayTags[weakMapTag] = false;

		/** Detect free variable `global` from Node.js. */
		var freeGlobal = typeof global$1 == 'object' && global$1 && global$1.Object === Object && global$1;

		/** Detect free variable `self`. */
		var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

		/** Used as a reference to the global object. */
		var root = freeGlobal || freeSelf || Function('return this')();

		/** Detect free variable `exports`. */
		var freeExports = exports && !exports.nodeType && exports;

		/** Detect free variable `module`. */
		var freeModule = freeExports && 'object' == 'object' && module && !module.nodeType && module;

		/** Detect the popular CommonJS extension `module.exports`. */
		var moduleExports = freeModule && freeModule.exports === freeExports;

		/** Detect free variable `process` from Node.js. */
		var freeProcess = moduleExports && freeGlobal.process;

		/** Used to access faster Node.js helpers. */
		var nodeUtil = (function() {
		  try {
		    // Use `util.types` for Node.js 10+.
		    var types = freeModule && freeModule.require && freeModule.require('util').types;

		    if (types) {
		      return types;
		    }

		    // Legacy `process.binding('util')` for Node.js < 10.
		    return freeProcess && freeProcess.binding && freeProcess.binding('util');
		  } catch (e) {}
		}());

		/* Node.js helper references. */
		var nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;

		/**
		 * A faster alternative to `Function#apply`, this function invokes `func`
		 * with the `this` binding of `thisArg` and the arguments of `args`.
		 *
		 * @private
		 * @param {Function} func The function to invoke.
		 * @param {*} thisArg The `this` binding of `func`.
		 * @param {Array} args The arguments to invoke `func` with.
		 * @returns {*} Returns the result of `func`.
		 */
		function apply(func, thisArg, args) {
		  switch (args.length) {
		    case 0: return func.call(thisArg);
		    case 1: return func.call(thisArg, args[0]);
		    case 2: return func.call(thisArg, args[0], args[1]);
		    case 3: return func.call(thisArg, args[0], args[1], args[2]);
		  }
		  return func.apply(thisArg, args);
		}

		/**
		 * The base implementation of `_.times` without support for iteratee shorthands
		 * or max array length checks.
		 *
		 * @private
		 * @param {number} n The number of times to invoke `iteratee`.
		 * @param {Function} iteratee The function invoked per iteration.
		 * @returns {Array} Returns the array of results.
		 */
		function baseTimes(n, iteratee) {
		  var index = -1,
		      result = Array(n);

		  while (++index < n) {
		    result[index] = iteratee(index);
		  }
		  return result;
		}

		/**
		 * The base implementation of `_.unary` without support for storing metadata.
		 *
		 * @private
		 * @param {Function} func The function to cap arguments for.
		 * @returns {Function} Returns the new capped function.
		 */
		function baseUnary(func) {
		  return function(value) {
		    return func(value);
		  };
		}

		/**
		 * Gets the value at `key` of `object`.
		 *
		 * @private
		 * @param {Object} [object] The object to query.
		 * @param {string} key The key of the property to get.
		 * @returns {*} Returns the property value.
		 */
		function getValue(object, key) {
		  return object == null ? undefined : object[key];
		}

		/**
		 * Creates a unary function that invokes `func` with its argument transformed.
		 *
		 * @private
		 * @param {Function} func The function to wrap.
		 * @param {Function} transform The argument transform.
		 * @returns {Function} Returns the new function.
		 */
		function overArg(func, transform) {
		  return function(arg) {
		    return func(transform(arg));
		  };
		}

		/** Used for built-in method references. */
		var arrayProto = Array.prototype,
		    funcProto = Function.prototype,
		    objectProto = Object.prototype;

		/** Used to detect overreaching core-js shims. */
		var coreJsData = root['__core-js_shared__'];

		/** Used to resolve the decompiled source of functions. */
		var funcToString = funcProto.toString;

		/** Used to check objects for own properties. */
		var hasOwnProperty = objectProto.hasOwnProperty;

		/** Used to detect methods masquerading as native. */
		var maskSrcKey = (function() {
		  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');
		  return uid ? ('Symbol(src)_1.' + uid) : '';
		}());

		/**
		 * Used to resolve the
		 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
		 * of values.
		 */
		var nativeObjectToString = objectProto.toString;

		/** Used to infer the `Object` constructor. */
		var objectCtorString = funcToString.call(Object);

		/** Used to detect if a method is native. */
		var reIsNative = RegExp('^' +
		  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\$&')
		  .replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, '$1.*?') + '$'
		);

		/** Built-in value references. */
		var Buffer = moduleExports ? root.Buffer : undefined,
		    Symbol = root.Symbol,
		    Uint8Array = root.Uint8Array;
		    Buffer ? Buffer.allocUnsafe : undefined;
		    var getPrototype = overArg(Object.getPrototypeOf, Object),
		    objectCreate = Object.create,
		    propertyIsEnumerable = objectProto.propertyIsEnumerable,
		    splice = arrayProto.splice,
		    symToStringTag = Symbol ? Symbol.toStringTag : undefined;

		var defineProperty = (function() {
		  try {
		    var func = getNative(Object, 'defineProperty');
		    func({}, '', {});
		    return func;
		  } catch (e) {}
		}());

		/* Built-in method references for those with the same name as other `lodash` methods. */
		var nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,
		    nativeMax = Math.max,
		    nativeNow = Date.now;

		/* Built-in method references that are verified to be native. */
		var Map = getNative(root, 'Map'),
		    nativeCreate = getNative(Object, 'create');

		/**
		 * The base implementation of `_.create` without support for assigning
		 * properties to the created object.
		 *
		 * @private
		 * @param {Object} proto The object to inherit from.
		 * @returns {Object} Returns the new object.
		 */
		var baseCreate = (function() {
		  function object() {}
		  return function(proto) {
		    if (!isObject(proto)) {
		      return {};
		    }
		    if (objectCreate) {
		      return objectCreate(proto);
		    }
		    object.prototype = proto;
		    var result = new object;
		    object.prototype = undefined;
		    return result;
		  };
		}());

		/**
		 * Creates a hash object.
		 *
		 * @private
		 * @constructor
		 * @param {Array} [entries] The key-value pairs to cache.
		 */
		function Hash(entries) {
		  var index = -1,
		      length = entries == null ? 0 : entries.length;

		  this.clear();
		  while (++index < length) {
		    var entry = entries[index];
		    this.set(entry[0], entry[1]);
		  }
		}

		/**
		 * Removes all key-value entries from the hash.
		 *
		 * @private
		 * @name clear
		 * @memberOf Hash
		 */
		function hashClear() {
		  this.__data__ = nativeCreate ? nativeCreate(null) : {};
		  this.size = 0;
		}

		/**
		 * Removes `key` and its value from the hash.
		 *
		 * @private
		 * @name delete
		 * @memberOf Hash
		 * @param {Object} hash The hash to modify.
		 * @param {string} key The key of the value to remove.
		 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
		 */
		function hashDelete(key) {
		  var result = this.has(key) && delete this.__data__[key];
		  this.size -= result ? 1 : 0;
		  return result;
		}

		/**
		 * Gets the hash value for `key`.
		 *
		 * @private
		 * @name get
		 * @memberOf Hash
		 * @param {string} key The key of the value to get.
		 * @returns {*} Returns the entry value.
		 */
		function hashGet(key) {
		  var data = this.__data__;
		  if (nativeCreate) {
		    var result = data[key];
		    return result === HASH_UNDEFINED ? undefined : result;
		  }
		  return hasOwnProperty.call(data, key) ? data[key] : undefined;
		}

		/**
		 * Checks if a hash value for `key` exists.
		 *
		 * @private
		 * @name has
		 * @memberOf Hash
		 * @param {string} key The key of the entry to check.
		 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
		 */
		function hashHas(key) {
		  var data = this.__data__;
		  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);
		}

		/**
		 * Sets the hash `key` to `value`.
		 *
		 * @private
		 * @name set
		 * @memberOf Hash
		 * @param {string} key The key of the value to set.
		 * @param {*} value The value to set.
		 * @returns {Object} Returns the hash instance.
		 */
		function hashSet(key, value) {
		  var data = this.__data__;
		  this.size += this.has(key) ? 0 : 1;
		  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;
		  return this;
		}

		// Add methods to `Hash`.
		Hash.prototype.clear = hashClear;
		Hash.prototype['delete'] = hashDelete;
		Hash.prototype.get = hashGet;
		Hash.prototype.has = hashHas;
		Hash.prototype.set = hashSet;

		/**
		 * Creates an list cache object.
		 *
		 * @private
		 * @constructor
		 * @param {Array} [entries] The key-value pairs to cache.
		 */
		function ListCache(entries) {
		  var index = -1,
		      length = entries == null ? 0 : entries.length;

		  this.clear();
		  while (++index < length) {
		    var entry = entries[index];
		    this.set(entry[0], entry[1]);
		  }
		}

		/**
		 * Removes all key-value entries from the list cache.
		 *
		 * @private
		 * @name clear
		 * @memberOf ListCache
		 */
		function listCacheClear() {
		  this.__data__ = [];
		  this.size = 0;
		}

		/**
		 * Removes `key` and its value from the list cache.
		 *
		 * @private
		 * @name delete
		 * @memberOf ListCache
		 * @param {string} key The key of the value to remove.
		 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
		 */
		function listCacheDelete(key) {
		  var data = this.__data__,
		      index = assocIndexOf(data, key);

		  if (index < 0) {
		    return false;
		  }
		  var lastIndex = data.length - 1;
		  if (index == lastIndex) {
		    data.pop();
		  } else {
		    splice.call(data, index, 1);
		  }
		  --this.size;
		  return true;
		}

		/**
		 * Gets the list cache value for `key`.
		 *
		 * @private
		 * @name get
		 * @memberOf ListCache
		 * @param {string} key The key of the value to get.
		 * @returns {*} Returns the entry value.
		 */
		function listCacheGet(key) {
		  var data = this.__data__,
		      index = assocIndexOf(data, key);

		  return index < 0 ? undefined : data[index][1];
		}

		/**
		 * Checks if a list cache value for `key` exists.
		 *
		 * @private
		 * @name has
		 * @memberOf ListCache
		 * @param {string} key The key of the entry to check.
		 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
		 */
		function listCacheHas(key) {
		  return assocIndexOf(this.__data__, key) > -1;
		}

		/**
		 * Sets the list cache `key` to `value`.
		 *
		 * @private
		 * @name set
		 * @memberOf ListCache
		 * @param {string} key The key of the value to set.
		 * @param {*} value The value to set.
		 * @returns {Object} Returns the list cache instance.
		 */
		function listCacheSet(key, value) {
		  var data = this.__data__,
		      index = assocIndexOf(data, key);

		  if (index < 0) {
		    ++this.size;
		    data.push([key, value]);
		  } else {
		    data[index][1] = value;
		  }
		  return this;
		}

		// Add methods to `ListCache`.
		ListCache.prototype.clear = listCacheClear;
		ListCache.prototype['delete'] = listCacheDelete;
		ListCache.prototype.get = listCacheGet;
		ListCache.prototype.has = listCacheHas;
		ListCache.prototype.set = listCacheSet;

		/**
		 * Creates a map cache object to store key-value pairs.
		 *
		 * @private
		 * @constructor
		 * @param {Array} [entries] The key-value pairs to cache.
		 */
		function MapCache(entries) {
		  var index = -1,
		      length = entries == null ? 0 : entries.length;

		  this.clear();
		  while (++index < length) {
		    var entry = entries[index];
		    this.set(entry[0], entry[1]);
		  }
		}

		/**
		 * Removes all key-value entries from the map.
		 *
		 * @private
		 * @name clear
		 * @memberOf MapCache
		 */
		function mapCacheClear() {
		  this.size = 0;
		  this.__data__ = {
		    'hash': new Hash,
		    'map': new (Map || ListCache),
		    'string': new Hash
		  };
		}

		/**
		 * Removes `key` and its value from the map.
		 *
		 * @private
		 * @name delete
		 * @memberOf MapCache
		 * @param {string} key The key of the value to remove.
		 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
		 */
		function mapCacheDelete(key) {
		  var result = getMapData(this, key)['delete'](key);
		  this.size -= result ? 1 : 0;
		  return result;
		}

		/**
		 * Gets the map value for `key`.
		 *
		 * @private
		 * @name get
		 * @memberOf MapCache
		 * @param {string} key The key of the value to get.
		 * @returns {*} Returns the entry value.
		 */
		function mapCacheGet(key) {
		  return getMapData(this, key).get(key);
		}

		/**
		 * Checks if a map value for `key` exists.
		 *
		 * @private
		 * @name has
		 * @memberOf MapCache
		 * @param {string} key The key of the entry to check.
		 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
		 */
		function mapCacheHas(key) {
		  return getMapData(this, key).has(key);
		}

		/**
		 * Sets the map `key` to `value`.
		 *
		 * @private
		 * @name set
		 * @memberOf MapCache
		 * @param {string} key The key of the value to set.
		 * @param {*} value The value to set.
		 * @returns {Object} Returns the map cache instance.
		 */
		function mapCacheSet(key, value) {
		  var data = getMapData(this, key),
		      size = data.size;

		  data.set(key, value);
		  this.size += data.size == size ? 0 : 1;
		  return this;
		}

		// Add methods to `MapCache`.
		MapCache.prototype.clear = mapCacheClear;
		MapCache.prototype['delete'] = mapCacheDelete;
		MapCache.prototype.get = mapCacheGet;
		MapCache.prototype.has = mapCacheHas;
		MapCache.prototype.set = mapCacheSet;

		/**
		 * Creates a stack cache object to store key-value pairs.
		 *
		 * @private
		 * @constructor
		 * @param {Array} [entries] The key-value pairs to cache.
		 */
		function Stack(entries) {
		  var data = this.__data__ = new ListCache(entries);
		  this.size = data.size;
		}

		/**
		 * Removes all key-value entries from the stack.
		 *
		 * @private
		 * @name clear
		 * @memberOf Stack
		 */
		function stackClear() {
		  this.__data__ = new ListCache;
		  this.size = 0;
		}

		/**
		 * Removes `key` and its value from the stack.
		 *
		 * @private
		 * @name delete
		 * @memberOf Stack
		 * @param {string} key The key of the value to remove.
		 * @returns {boolean} Returns `true` if the entry was removed, else `false`.
		 */
		function stackDelete(key) {
		  var data = this.__data__,
		      result = data['delete'](key);

		  this.size = data.size;
		  return result;
		}

		/**
		 * Gets the stack value for `key`.
		 *
		 * @private
		 * @name get
		 * @memberOf Stack
		 * @param {string} key The key of the value to get.
		 * @returns {*} Returns the entry value.
		 */
		function stackGet(key) {
		  return this.__data__.get(key);
		}

		/**
		 * Checks if a stack value for `key` exists.
		 *
		 * @private
		 * @name has
		 * @memberOf Stack
		 * @param {string} key The key of the entry to check.
		 * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.
		 */
		function stackHas(key) {
		  return this.__data__.has(key);
		}

		/**
		 * Sets the stack `key` to `value`.
		 *
		 * @private
		 * @name set
		 * @memberOf Stack
		 * @param {string} key The key of the value to set.
		 * @param {*} value The value to set.
		 * @returns {Object} Returns the stack cache instance.
		 */
		function stackSet(key, value) {
		  var data = this.__data__;
		  if (data instanceof ListCache) {
		    var pairs = data.__data__;
		    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {
		      pairs.push([key, value]);
		      this.size = ++data.size;
		      return this;
		    }
		    data = this.__data__ = new MapCache(pairs);
		  }
		  data.set(key, value);
		  this.size = data.size;
		  return this;
		}

		// Add methods to `Stack`.
		Stack.prototype.clear = stackClear;
		Stack.prototype['delete'] = stackDelete;
		Stack.prototype.get = stackGet;
		Stack.prototype.has = stackHas;
		Stack.prototype.set = stackSet;

		/**
		 * Creates an array of the enumerable property names of the array-like `value`.
		 *
		 * @private
		 * @param {*} value The value to query.
		 * @param {boolean} inherited Specify returning inherited property names.
		 * @returns {Array} Returns the array of property names.
		 */
		function arrayLikeKeys(value, inherited) {
		  var isArr = isArray(value),
		      isArg = !isArr && isArguments(value),
		      isBuff = !isArr && !isArg && isBuffer(value),
		      isType = !isArr && !isArg && !isBuff && isTypedArray(value),
		      skipIndexes = isArr || isArg || isBuff || isType,
		      result = skipIndexes ? baseTimes(value.length, String) : [],
		      length = result.length;

		  for (var key in value) {
		    if (!(skipIndexes && (
		           // Safari 9 has enumerable `arguments.length` in strict mode.
		           key == 'length' ||
		           // Node.js 0.10 has enumerable non-index properties on buffers.
		           (isBuff && (key == 'offset' || key == 'parent')) ||
		           // PhantomJS 2 has enumerable non-index properties on typed arrays.
		           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||
		           // Skip index properties.
		           isIndex(key, length)
		        ))) {
		      result.push(key);
		    }
		  }
		  return result;
		}

		/**
		 * This function is like `assignValue` except that it doesn't assign
		 * `undefined` values.
		 *
		 * @private
		 * @param {Object} object The object to modify.
		 * @param {string} key The key of the property to assign.
		 * @param {*} value The value to assign.
		 */
		function assignMergeValue(object, key, value) {
		  if ((value !== undefined && !eq(object[key], value)) ||
		      (value === undefined && !(key in object))) {
		    baseAssignValue(object, key, value);
		  }
		}

		/**
		 * Assigns `value` to `key` of `object` if the existing value is not equivalent
		 * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
		 * for equality comparisons.
		 *
		 * @private
		 * @param {Object} object The object to modify.
		 * @param {string} key The key of the property to assign.
		 * @param {*} value The value to assign.
		 */
		function assignValue(object, key, value) {
		  var objValue = object[key];
		  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||
		      (value === undefined && !(key in object))) {
		    baseAssignValue(object, key, value);
		  }
		}

		/**
		 * Gets the index at which the `key` is found in `array` of key-value pairs.
		 *
		 * @private
		 * @param {Array} array The array to inspect.
		 * @param {*} key The key to search for.
		 * @returns {number} Returns the index of the matched value, else `-1`.
		 */
		function assocIndexOf(array, key) {
		  var length = array.length;
		  while (length--) {
		    if (eq(array[length][0], key)) {
		      return length;
		    }
		  }
		  return -1;
		}

		/**
		 * The base implementation of `assignValue` and `assignMergeValue` without
		 * value checks.
		 *
		 * @private
		 * @param {Object} object The object to modify.
		 * @param {string} key The key of the property to assign.
		 * @param {*} value The value to assign.
		 */
		function baseAssignValue(object, key, value) {
		  if (key == '__proto__' && defineProperty) {
		    defineProperty(object, key, {
		      'configurable': true,
		      'enumerable': true,
		      'value': value,
		      'writable': true
		    });
		  } else {
		    object[key] = value;
		  }
		}

		/**
		 * The base implementation of `baseForOwn` which iterates over `object`
		 * properties returned by `keysFunc` and invokes `iteratee` for each property.
		 * Iteratee functions may exit iteration early by explicitly returning `false`.
		 *
		 * @private
		 * @param {Object} object The object to iterate over.
		 * @param {Function} iteratee The function invoked per iteration.
		 * @param {Function} keysFunc The function to get the keys of `object`.
		 * @returns {Object} Returns `object`.
		 */
		var baseFor = createBaseFor();

		/**
		 * The base implementation of `getTag` without fallbacks for buggy environments.
		 *
		 * @private
		 * @param {*} value The value to query.
		 * @returns {string} Returns the `toStringTag`.
		 */
		function baseGetTag(value) {
		  if (value == null) {
		    return value === undefined ? undefinedTag : nullTag;
		  }
		  return (symToStringTag && symToStringTag in Object(value))
		    ? getRawTag(value)
		    : objectToString(value);
		}

		/**
		 * The base implementation of `_.isArguments`.
		 *
		 * @private
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
		 */
		function baseIsArguments(value) {
		  return isObjectLike(value) && baseGetTag(value) == argsTag;
		}

		/**
		 * The base implementation of `_.isNative` without bad shim checks.
		 *
		 * @private
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a native function,
		 *  else `false`.
		 */
		function baseIsNative(value) {
		  if (!isObject(value) || isMasked(value)) {
		    return false;
		  }
		  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;
		  return pattern.test(toSource(value));
		}

		/**
		 * The base implementation of `_.isTypedArray` without Node.js optimizations.
		 *
		 * @private
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
		 */
		function baseIsTypedArray(value) {
		  return isObjectLike(value) &&
		    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];
		}

		/**
		 * The base implementation of `_.keysIn` which doesn't treat sparse arrays as dense.
		 *
		 * @private
		 * @param {Object} object The object to query.
		 * @returns {Array} Returns the array of property names.
		 */
		function baseKeysIn(object) {
		  if (!isObject(object)) {
		    return nativeKeysIn(object);
		  }
		  var isProto = isPrototype(object),
		      result = [];

		  for (var key in object) {
		    if (!(key == 'constructor' && (isProto || !hasOwnProperty.call(object, key)))) {
		      result.push(key);
		    }
		  }
		  return result;
		}

		/**
		 * The base implementation of `_.merge` without support for multiple sources.
		 *
		 * @private
		 * @param {Object} object The destination object.
		 * @param {Object} source The source object.
		 * @param {number} srcIndex The index of `source`.
		 * @param {Function} [customizer] The function to customize merged values.
		 * @param {Object} [stack] Tracks traversed source values and their merged
		 *  counterparts.
		 */
		function baseMerge(object, source, srcIndex, customizer, stack) {
		  if (object === source) {
		    return;
		  }
		  baseFor(source, function(srcValue, key) {
		    stack || (stack = new Stack);
		    if (isObject(srcValue)) {
		      baseMergeDeep(object, source, key, srcIndex, baseMerge, customizer, stack);
		    }
		    else {
		      var newValue = customizer
		        ? customizer(safeGet(object, key), srcValue, (key + ''), object, source, stack)
		        : undefined;

		      if (newValue === undefined) {
		        newValue = srcValue;
		      }
		      assignMergeValue(object, key, newValue);
		    }
		  }, keysIn);
		}

		/**
		 * A specialized version of `baseMerge` for arrays and objects which performs
		 * deep merges and tracks traversed objects enabling objects with circular
		 * references to be merged.
		 *
		 * @private
		 * @param {Object} object The destination object.
		 * @param {Object} source The source object.
		 * @param {string} key The key of the value to merge.
		 * @param {number} srcIndex The index of `source`.
		 * @param {Function} mergeFunc The function to merge values.
		 * @param {Function} [customizer] The function to customize assigned values.
		 * @param {Object} [stack] Tracks traversed source values and their merged
		 *  counterparts.
		 */
		function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
		  var objValue = safeGet(object, key),
		      srcValue = safeGet(source, key),
		      stacked = stack.get(srcValue);

		  if (stacked) {
		    assignMergeValue(object, key, stacked);
		    return;
		  }
		  var newValue = customizer
		    ? customizer(objValue, srcValue, (key + ''), object, source, stack)
		    : undefined;

		  var isCommon = newValue === undefined;

		  if (isCommon) {
		    var isArr = isArray(srcValue),
		        isBuff = !isArr && isBuffer(srcValue),
		        isTyped = !isArr && !isBuff && isTypedArray(srcValue);

		    newValue = srcValue;
		    if (isArr || isBuff || isTyped) {
		      if (isArray(objValue)) {
		        newValue = objValue;
		      }
		      else if (isArrayLikeObject(objValue)) {
		        newValue = copyArray(objValue);
		      }
		      else if (isBuff) {
		        isCommon = false;
		        newValue = cloneBuffer(srcValue);
		      }
		      else if (isTyped) {
		        isCommon = false;
		        newValue = cloneTypedArray(srcValue);
		      }
		      else {
		        newValue = [];
		      }
		    }
		    else if (isPlainObject(srcValue) || isArguments(srcValue)) {
		      newValue = objValue;
		      if (isArguments(objValue)) {
		        newValue = toPlainObject(objValue);
		      }
		      else if (!isObject(objValue) || isFunction(objValue)) {
		        newValue = initCloneObject(srcValue);
		      }
		    }
		    else {
		      isCommon = false;
		    }
		  }
		  if (isCommon) {
		    // Recursively merge objects and arrays (susceptible to call stack limits).
		    stack.set(srcValue, newValue);
		    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
		    stack['delete'](srcValue);
		  }
		  assignMergeValue(object, key, newValue);
		}

		/**
		 * The base implementation of `_.rest` which doesn't validate or coerce arguments.
		 *
		 * @private
		 * @param {Function} func The function to apply a rest parameter to.
		 * @param {number} [start=func.length-1] The start position of the rest parameter.
		 * @returns {Function} Returns the new function.
		 */
		function baseRest(func, start) {
		  return setToString(overRest(func, start, identity), func + '');
		}

		/**
		 * The base implementation of `setToString` without support for hot loop shorting.
		 *
		 * @private
		 * @param {Function} func The function to modify.
		 * @param {Function} string The `toString` result.
		 * @returns {Function} Returns `func`.
		 */
		var baseSetToString = !defineProperty ? identity : function(func, string) {
		  return defineProperty(func, 'toString', {
		    'configurable': true,
		    'enumerable': false,
		    'value': constant(string),
		    'writable': true
		  });
		};

		/**
		 * Creates a clone of  `buffer`.
		 *
		 * @private
		 * @param {Buffer} buffer The buffer to clone.
		 * @param {boolean} [isDeep] Specify a deep clone.
		 * @returns {Buffer} Returns the cloned buffer.
		 */
		function cloneBuffer(buffer, isDeep) {
		  {
		    return buffer.slice();
		  }
		}

		/**
		 * Creates a clone of `arrayBuffer`.
		 *
		 * @private
		 * @param {ArrayBuffer} arrayBuffer The array buffer to clone.
		 * @returns {ArrayBuffer} Returns the cloned array buffer.
		 */
		function cloneArrayBuffer(arrayBuffer) {
		  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
		  new Uint8Array(result).set(new Uint8Array(arrayBuffer));
		  return result;
		}

		/**
		 * Creates a clone of `typedArray`.
		 *
		 * @private
		 * @param {Object} typedArray The typed array to clone.
		 * @param {boolean} [isDeep] Specify a deep clone.
		 * @returns {Object} Returns the cloned typed array.
		 */
		function cloneTypedArray(typedArray, isDeep) {
		  var buffer = cloneArrayBuffer(typedArray.buffer) ;
		  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
		}

		/**
		 * Copies the values of `source` to `array`.
		 *
		 * @private
		 * @param {Array} source The array to copy values from.
		 * @param {Array} [array=[]] The array to copy values to.
		 * @returns {Array} Returns `array`.
		 */
		function copyArray(source, array) {
		  var index = -1,
		      length = source.length;

		  array || (array = Array(length));
		  while (++index < length) {
		    array[index] = source[index];
		  }
		  return array;
		}

		/**
		 * Copies properties of `source` to `object`.
		 *
		 * @private
		 * @param {Object} source The object to copy properties from.
		 * @param {Array} props The property identifiers to copy.
		 * @param {Object} [object={}] The object to copy properties to.
		 * @param {Function} [customizer] The function to customize copied values.
		 * @returns {Object} Returns `object`.
		 */
		function copyObject(source, props, object, customizer) {
		  var isNew = !object;
		  object || (object = {});

		  var index = -1,
		      length = props.length;

		  while (++index < length) {
		    var key = props[index];

		    var newValue = undefined;

		    if (newValue === undefined) {
		      newValue = source[key];
		    }
		    if (isNew) {
		      baseAssignValue(object, key, newValue);
		    } else {
		      assignValue(object, key, newValue);
		    }
		  }
		  return object;
		}

		/**
		 * Creates a function like `_.assign`.
		 *
		 * @private
		 * @param {Function} assigner The function to assign values.
		 * @returns {Function} Returns the new assigner function.
		 */
		function createAssigner(assigner) {
		  return baseRest(function(object, sources) {
		    var index = -1,
		        length = sources.length,
		        customizer = length > 1 ? sources[length - 1] : undefined,
		        guard = length > 2 ? sources[2] : undefined;

		    customizer = (assigner.length > 3 && typeof customizer == 'function')
		      ? (length--, customizer)
		      : undefined;

		    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
		      customizer = length < 3 ? undefined : customizer;
		      length = 1;
		    }
		    object = Object(object);
		    while (++index < length) {
		      var source = sources[index];
		      if (source) {
		        assigner(object, source, index, customizer);
		      }
		    }
		    return object;
		  });
		}

		/**
		 * Creates a base function for methods like `_.forIn` and `_.forOwn`.
		 *
		 * @private
		 * @param {boolean} [fromRight] Specify iterating from right to left.
		 * @returns {Function} Returns the new base function.
		 */
		function createBaseFor(fromRight) {
		  return function(object, iteratee, keysFunc) {
		    var index = -1,
		        iterable = Object(object),
		        props = keysFunc(object),
		        length = props.length;

		    while (length--) {
		      var key = props[++index];
		      if (iteratee(iterable[key], key, iterable) === false) {
		        break;
		      }
		    }
		    return object;
		  };
		}

		/**
		 * Gets the data for `map`.
		 *
		 * @private
		 * @param {Object} map The map to query.
		 * @param {string} key The reference key.
		 * @returns {*} Returns the map data.
		 */
		function getMapData(map, key) {
		  var data = map.__data__;
		  return isKeyable(key)
		    ? data[typeof key == 'string' ? 'string' : 'hash']
		    : data.map;
		}

		/**
		 * Gets the native function at `key` of `object`.
		 *
		 * @private
		 * @param {Object} object The object to query.
		 * @param {string} key The key of the method to get.
		 * @returns {*} Returns the function if it's native, else `undefined`.
		 */
		function getNative(object, key) {
		  var value = getValue(object, key);
		  return baseIsNative(value) ? value : undefined;
		}

		/**
		 * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.
		 *
		 * @private
		 * @param {*} value The value to query.
		 * @returns {string} Returns the raw `toStringTag`.
		 */
		function getRawTag(value) {
		  var isOwn = hasOwnProperty.call(value, symToStringTag),
		      tag = value[symToStringTag];

		  try {
		    value[symToStringTag] = undefined;
		    var unmasked = true;
		  } catch (e) {}

		  var result = nativeObjectToString.call(value);
		  if (unmasked) {
		    if (isOwn) {
		      value[symToStringTag] = tag;
		    } else {
		      delete value[symToStringTag];
		    }
		  }
		  return result;
		}

		/**
		 * Initializes an object clone.
		 *
		 * @private
		 * @param {Object} object The object to clone.
		 * @returns {Object} Returns the initialized clone.
		 */
		function initCloneObject(object) {
		  return (typeof object.constructor == 'function' && !isPrototype(object))
		    ? baseCreate(getPrototype(object))
		    : {};
		}

		/**
		 * Checks if `value` is a valid array-like index.
		 *
		 * @private
		 * @param {*} value The value to check.
		 * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.
		 * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.
		 */
		function isIndex(value, length) {
		  var type = typeof value;
		  length = length == null ? MAX_SAFE_INTEGER : length;

		  return !!length &&
		    (type == 'number' ||
		      (type != 'symbol' && reIsUint.test(value))) &&
		        (value > -1 && value % 1 == 0 && value < length);
		}

		/**
		 * Checks if the given arguments are from an iteratee call.
		 *
		 * @private
		 * @param {*} value The potential iteratee value argument.
		 * @param {*} index The potential iteratee index or key argument.
		 * @param {*} object The potential iteratee object argument.
		 * @returns {boolean} Returns `true` if the arguments are from an iteratee call,
		 *  else `false`.
		 */
		function isIterateeCall(value, index, object) {
		  if (!isObject(object)) {
		    return false;
		  }
		  var type = typeof index;
		  if (type == 'number'
		        ? (isArrayLike(object) && isIndex(index, object.length))
		        : (type == 'string' && index in object)
		      ) {
		    return eq(object[index], value);
		  }
		  return false;
		}

		/**
		 * Checks if `value` is suitable for use as unique object key.
		 *
		 * @private
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is suitable, else `false`.
		 */
		function isKeyable(value) {
		  var type = typeof value;
		  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')
		    ? (value !== '__proto__')
		    : (value === null);
		}

		/**
		 * Checks if `func` has its source masked.
		 *
		 * @private
		 * @param {Function} func The function to check.
		 * @returns {boolean} Returns `true` if `func` is masked, else `false`.
		 */
		function isMasked(func) {
		  return !!maskSrcKey && (maskSrcKey in func);
		}

		/**
		 * Checks if `value` is likely a prototype object.
		 *
		 * @private
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.
		 */
		function isPrototype(value) {
		  var Ctor = value && value.constructor,
		      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;

		  return value === proto;
		}

		/**
		 * This function is like
		 * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)
		 * except that it includes inherited enumerable properties.
		 *
		 * @private
		 * @param {Object} object The object to query.
		 * @returns {Array} Returns the array of property names.
		 */
		function nativeKeysIn(object) {
		  var result = [];
		  if (object != null) {
		    for (var key in Object(object)) {
		      result.push(key);
		    }
		  }
		  return result;
		}

		/**
		 * Converts `value` to a string using `Object.prototype.toString`.
		 *
		 * @private
		 * @param {*} value The value to convert.
		 * @returns {string} Returns the converted string.
		 */
		function objectToString(value) {
		  return nativeObjectToString.call(value);
		}

		/**
		 * A specialized version of `baseRest` which transforms the rest array.
		 *
		 * @private
		 * @param {Function} func The function to apply a rest parameter to.
		 * @param {number} [start=func.length-1] The start position of the rest parameter.
		 * @param {Function} transform The rest array transform.
		 * @returns {Function} Returns the new function.
		 */
		function overRest(func, start, transform) {
		  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);
		  return function() {
		    var args = arguments,
		        index = -1,
		        length = nativeMax(args.length - start, 0),
		        array = Array(length);

		    while (++index < length) {
		      array[index] = args[start + index];
		    }
		    index = -1;
		    var otherArgs = Array(start + 1);
		    while (++index < start) {
		      otherArgs[index] = args[index];
		    }
		    otherArgs[start] = transform(array);
		    return apply(func, this, otherArgs);
		  };
		}

		/**
		 * Gets the value at `key`, unless `key` is "__proto__" or "constructor".
		 *
		 * @private
		 * @param {Object} object The object to query.
		 * @param {string} key The key of the property to get.
		 * @returns {*} Returns the property value.
		 */
		function safeGet(object, key) {
		  if (key === 'constructor' && typeof object[key] === 'function') {
		    return;
		  }

		  if (key == '__proto__') {
		    return;
		  }

		  return object[key];
		}

		/**
		 * Sets the `toString` method of `func` to return `string`.
		 *
		 * @private
		 * @param {Function} func The function to modify.
		 * @param {Function} string The `toString` result.
		 * @returns {Function} Returns `func`.
		 */
		var setToString = shortOut(baseSetToString);

		/**
		 * Creates a function that'll short out and invoke `identity` instead
		 * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`
		 * milliseconds.
		 *
		 * @private
		 * @param {Function} func The function to restrict.
		 * @returns {Function} Returns the new shortable function.
		 */
		function shortOut(func) {
		  var count = 0,
		      lastCalled = 0;

		  return function() {
		    var stamp = nativeNow(),
		        remaining = HOT_SPAN - (stamp - lastCalled);

		    lastCalled = stamp;
		    if (remaining > 0) {
		      if (++count >= HOT_COUNT) {
		        return arguments[0];
		      }
		    } else {
		      count = 0;
		    }
		    return func.apply(undefined, arguments);
		  };
		}

		/**
		 * Converts `func` to its source code.
		 *
		 * @private
		 * @param {Function} func The function to convert.
		 * @returns {string} Returns the source code.
		 */
		function toSource(func) {
		  if (func != null) {
		    try {
		      return funcToString.call(func);
		    } catch (e) {}
		    try {
		      return (func + '');
		    } catch (e) {}
		  }
		  return '';
		}

		/**
		 * Performs a
		 * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
		 * comparison between two values to determine if they are equivalent.
		 *
		 * @static
		 * @memberOf _
		 * @since 4.0.0
		 * @category Lang
		 * @param {*} value The value to compare.
		 * @param {*} other The other value to compare.
		 * @returns {boolean} Returns `true` if the values are equivalent, else `false`.
		 * @example
		 *
		 * var object = { 'a': 1 };
		 * var other = { 'a': 1 };
		 *
		 * _.eq(object, object);
		 * // => true
		 *
		 * _.eq(object, other);
		 * // => false
		 *
		 * _.eq('a', 'a');
		 * // => true
		 *
		 * _.eq('a', Object('a'));
		 * // => false
		 *
		 * _.eq(NaN, NaN);
		 * // => true
		 */
		function eq(value, other) {
		  return value === other || (value !== value && other !== other);
		}

		/**
		 * Checks if `value` is likely an `arguments` object.
		 *
		 * @static
		 * @memberOf _
		 * @since 0.1.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is an `arguments` object,
		 *  else `false`.
		 * @example
		 *
		 * _.isArguments(function() { return arguments; }());
		 * // => true
		 *
		 * _.isArguments([1, 2, 3]);
		 * // => false
		 */
		var isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {
		  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&
		    !propertyIsEnumerable.call(value, 'callee');
		};

		/**
		 * Checks if `value` is classified as an `Array` object.
		 *
		 * @static
		 * @memberOf _
		 * @since 0.1.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is an array, else `false`.
		 * @example
		 *
		 * _.isArray([1, 2, 3]);
		 * // => true
		 *
		 * _.isArray(document.body.children);
		 * // => false
		 *
		 * _.isArray('abc');
		 * // => false
		 *
		 * _.isArray(_.noop);
		 * // => false
		 */
		var isArray = Array.isArray;

		/**
		 * Checks if `value` is array-like. A value is considered array-like if it's
		 * not a function and has a `value.length` that's an integer greater than or
		 * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.
		 *
		 * @static
		 * @memberOf _
		 * @since 4.0.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is array-like, else `false`.
		 * @example
		 *
		 * _.isArrayLike([1, 2, 3]);
		 * // => true
		 *
		 * _.isArrayLike(document.body.children);
		 * // => true
		 *
		 * _.isArrayLike('abc');
		 * // => true
		 *
		 * _.isArrayLike(_.noop);
		 * // => false
		 */
		function isArrayLike(value) {
		  return value != null && isLength(value.length) && !isFunction(value);
		}

		/**
		 * This method is like `_.isArrayLike` except that it also checks if `value`
		 * is an object.
		 *
		 * @static
		 * @memberOf _
		 * @since 4.0.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is an array-like object,
		 *  else `false`.
		 * @example
		 *
		 * _.isArrayLikeObject([1, 2, 3]);
		 * // => true
		 *
		 * _.isArrayLikeObject(document.body.children);
		 * // => true
		 *
		 * _.isArrayLikeObject('abc');
		 * // => false
		 *
		 * _.isArrayLikeObject(_.noop);
		 * // => false
		 */
		function isArrayLikeObject(value) {
		  return isObjectLike(value) && isArrayLike(value);
		}

		/**
		 * Checks if `value` is a buffer.
		 *
		 * @static
		 * @memberOf _
		 * @since 4.3.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.
		 * @example
		 *
		 * _.isBuffer(new Buffer(2));
		 * // => true
		 *
		 * _.isBuffer(new Uint8Array(2));
		 * // => false
		 */
		var isBuffer = nativeIsBuffer || stubFalse;

		/**
		 * Checks if `value` is classified as a `Function` object.
		 *
		 * @static
		 * @memberOf _
		 * @since 0.1.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a function, else `false`.
		 * @example
		 *
		 * _.isFunction(_);
		 * // => true
		 *
		 * _.isFunction(/abc/);
		 * // => false
		 */
		function isFunction(value) {
		  if (!isObject(value)) {
		    return false;
		  }
		  // The use of `Object#toString` avoids issues with the `typeof` operator
		  // in Safari 9 which returns 'object' for typed arrays and other constructors.
		  var tag = baseGetTag(value);
		  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
		}

		/**
		 * Checks if `value` is a valid array-like length.
		 *
		 * **Note:** This method is loosely based on
		 * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).
		 *
		 * @static
		 * @memberOf _
		 * @since 4.0.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.
		 * @example
		 *
		 * _.isLength(3);
		 * // => true
		 *
		 * _.isLength(Number.MIN_VALUE);
		 * // => false
		 *
		 * _.isLength(Infinity);
		 * // => false
		 *
		 * _.isLength('3');
		 * // => false
		 */
		function isLength(value) {
		  return typeof value == 'number' &&
		    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;
		}

		/**
		 * Checks if `value` is the
		 * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)
		 * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)
		 *
		 * @static
		 * @memberOf _
		 * @since 0.1.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is an object, else `false`.
		 * @example
		 *
		 * _.isObject({});
		 * // => true
		 *
		 * _.isObject([1, 2, 3]);
		 * // => true
		 *
		 * _.isObject(_.noop);
		 * // => true
		 *
		 * _.isObject(null);
		 * // => false
		 */
		function isObject(value) {
		  var type = typeof value;
		  return value != null && (type == 'object' || type == 'function');
		}

		/**
		 * Checks if `value` is object-like. A value is object-like if it's not `null`
		 * and has a `typeof` result of "object".
		 *
		 * @static
		 * @memberOf _
		 * @since 4.0.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
		 * @example
		 *
		 * _.isObjectLike({});
		 * // => true
		 *
		 * _.isObjectLike([1, 2, 3]);
		 * // => true
		 *
		 * _.isObjectLike(_.noop);
		 * // => false
		 *
		 * _.isObjectLike(null);
		 * // => false
		 */
		function isObjectLike(value) {
		  return value != null && typeof value == 'object';
		}

		/**
		 * Checks if `value` is a plain object, that is, an object created by the
		 * `Object` constructor or one with a `[[Prototype]]` of `null`.
		 *
		 * @static
		 * @memberOf _
		 * @since 0.8.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.
		 * @example
		 *
		 * function Foo() {
		 *   this.a = 1;
		 * }
		 *
		 * _.isPlainObject(new Foo);
		 * // => false
		 *
		 * _.isPlainObject([1, 2, 3]);
		 * // => false
		 *
		 * _.isPlainObject({ 'x': 0, 'y': 0 });
		 * // => true
		 *
		 * _.isPlainObject(Object.create(null));
		 * // => true
		 */
		function isPlainObject(value) {
		  if (!isObjectLike(value) || baseGetTag(value) != objectTag) {
		    return false;
		  }
		  var proto = getPrototype(value);
		  if (proto === null) {
		    return true;
		  }
		  var Ctor = hasOwnProperty.call(proto, 'constructor') && proto.constructor;
		  return typeof Ctor == 'function' && Ctor instanceof Ctor &&
		    funcToString.call(Ctor) == objectCtorString;
		}

		/**
		 * Checks if `value` is classified as a typed array.
		 *
		 * @static
		 * @memberOf _
		 * @since 3.0.0
		 * @category Lang
		 * @param {*} value The value to check.
		 * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.
		 * @example
		 *
		 * _.isTypedArray(new Uint8Array);
		 * // => true
		 *
		 * _.isTypedArray([]);
		 * // => false
		 */
		var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;

		/**
		 * Converts `value` to a plain object flattening inherited enumerable string
		 * keyed properties of `value` to own properties of the plain object.
		 *
		 * @static
		 * @memberOf _
		 * @since 3.0.0
		 * @category Lang
		 * @param {*} value The value to convert.
		 * @returns {Object} Returns the converted plain object.
		 * @example
		 *
		 * function Foo() {
		 *   this.b = 2;
		 * }
		 *
		 * Foo.prototype.c = 3;
		 *
		 * _.assign({ 'a': 1 }, new Foo);
		 * // => { 'a': 1, 'b': 2 }
		 *
		 * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));
		 * // => { 'a': 1, 'b': 2, 'c': 3 }
		 */
		function toPlainObject(value) {
		  return copyObject(value, keysIn(value));
		}

		/**
		 * Creates an array of the own and inherited enumerable property names of `object`.
		 *
		 * **Note:** Non-object values are coerced to objects.
		 *
		 * @static
		 * @memberOf _
		 * @since 3.0.0
		 * @category Object
		 * @param {Object} object The object to query.
		 * @returns {Array} Returns the array of property names.
		 * @example
		 *
		 * function Foo() {
		 *   this.a = 1;
		 *   this.b = 2;
		 * }
		 *
		 * Foo.prototype.c = 3;
		 *
		 * _.keysIn(new Foo);
		 * // => ['a', 'b', 'c'] (iteration order is not guaranteed)
		 */
		function keysIn(object) {
		  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeysIn(object);
		}

		/**
		 * This method is like `_.assign` except that it recursively merges own and
		 * inherited enumerable string keyed properties of source objects into the
		 * destination object. Source properties that resolve to `undefined` are
		 * skipped if a destination value exists. Array and plain object properties
		 * are merged recursively. Other objects and value types are overridden by
		 * assignment. Source objects are applied from left to right. Subsequent
		 * sources overwrite property assignments of previous sources.
		 *
		 * **Note:** This method mutates `object`.
		 *
		 * @static
		 * @memberOf _
		 * @since 0.5.0
		 * @category Object
		 * @param {Object} object The destination object.
		 * @param {...Object} [sources] The source objects.
		 * @returns {Object} Returns `object`.
		 * @example
		 *
		 * var object = {
		 *   'a': [{ 'b': 2 }, { 'd': 4 }]
		 * };
		 *
		 * var other = {
		 *   'a': [{ 'c': 3 }, { 'e': 5 }]
		 * };
		 *
		 * _.merge(object, other);
		 * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }
		 */
		var merge = createAssigner(function(object, source, srcIndex) {
		  baseMerge(object, source, srcIndex);
		});

		/**
		 * Creates a function that returns `value`.
		 *
		 * @static
		 * @memberOf _
		 * @since 2.4.0
		 * @category Util
		 * @param {*} value The value to return from the new function.
		 * @returns {Function} Returns the new constant function.
		 * @example
		 *
		 * var objects = _.times(2, _.constant({ 'a': 1 }));
		 *
		 * console.log(objects);
		 * // => [{ 'a': 1 }, { 'a': 1 }]
		 *
		 * console.log(objects[0] === objects[1]);
		 * // => true
		 */
		function constant(value) {
		  return function() {
		    return value;
		  };
		}

		/**
		 * This method returns the first argument it receives.
		 *
		 * @static
		 * @since 0.1.0
		 * @memberOf _
		 * @category Util
		 * @param {*} value Any value.
		 * @returns {*} Returns `value`.
		 * @example
		 *
		 * var object = { 'a': 1 };
		 *
		 * console.log(_.identity(object) === object);
		 * // => true
		 */
		function identity(value) {
		  return value;
		}

		/**
		 * This method returns `false`.
		 *
		 * @static
		 * @memberOf _
		 * @since 4.13.0
		 * @category Util
		 * @returns {boolean} Returns `false`.
		 * @example
		 *
		 * _.times(2, _.stubFalse);
		 * // => [false, false]
		 */
		function stubFalse() {
		  return false;
		}

		module.exports = merge; 
	} (lodash_merge, lodash_merge.exports));
	return lodash_merge.exports;
}

var version = "9.23.0";
var require$$5 = {
	version: version};

var eslintrcUniversal = {};

var lookup = [];
var revLookup = [];
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
var inited = false;
function init () {
  inited = true;
  var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
  for (var i = 0, len = code.length; i < len; ++i) {
    lookup[i] = code[i];
    revLookup[code.charCodeAt(i)] = i;
  }

  revLookup['-'.charCodeAt(0)] = 62;
  revLookup['_'.charCodeAt(0)] = 63;
}

function toByteArray (b64) {
  if (!inited) {
    init();
  }
  var i, j, l, tmp, placeHolders, arr;
  var len = b64.length;

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // the number of equal signs (place holders)
  // if there are two placeholders, than the two characters before it
  // represent one byte
  // if there is only one, then the three characters before it represent 2 bytes
  // this is just a cheap hack to not do indexOf twice
  placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

  // base64 is 4/3 + up to two characters of the original data
  arr = new Arr(len * 3 / 4 - placeHolders);

  // if there are placeholders, only get up to the last complete 4 chars
  l = placeHolders > 0 ? len - 4 : len;

  var L = 0;

  for (i = 0, j = 0; i < l; i += 4, j += 3) {
    tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
    arr[L++] = (tmp >> 16) & 0xFF;
    arr[L++] = (tmp >> 8) & 0xFF;
    arr[L++] = tmp & 0xFF;
  }

  if (placeHolders === 2) {
    tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
    arr[L++] = tmp & 0xFF;
  } else if (placeHolders === 1) {
    tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
    arr[L++] = (tmp >> 8) & 0xFF;
    arr[L++] = tmp & 0xFF;
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp;
  var output = [];
  for (var i = start; i < end; i += 3) {
    tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
    output.push(tripletToBase64(tmp));
  }
  return output.join('')
}

function fromByteArray (uint8) {
  if (!inited) {
    init();
  }
  var tmp;
  var len = uint8.length;
  var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
  var output = '';
  var parts = [];
  var maxChunkLength = 16383; // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1];
    output += lookup[tmp >> 2];
    output += lookup[(tmp << 4) & 0x3F];
    output += '==';
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
    output += lookup[tmp >> 10];
    output += lookup[(tmp >> 4) & 0x3F];
    output += lookup[(tmp << 2) & 0x3F];
    output += '=';
  }

  parts.push(output);

  return parts.join('')
}

function read (buffer, offset, isLE, mLen, nBytes) {
  var e, m;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var nBits = -7;
  var i = isLE ? (nBytes - 1) : 0;
  var d = isLE ? -1 : 1;
  var s = buffer[offset + i];

  i += d;

  e = s & ((1 << (-nBits)) - 1);
  s >>= (-nBits);
  nBits += eLen;
  for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1);
  e >>= (-nBits);
  nBits += mLen;
  for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias;
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen);
    e = e - eBias;
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

function write (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c;
  var eLen = nBytes * 8 - mLen - 1;
  var eMax = (1 << eLen) - 1;
  var eBias = eMax >> 1;
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
  var i = isLE ? 0 : (nBytes - 1);
  var d = isLE ? 1 : -1;
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

  value = Math.abs(value);

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0;
    e = eMax;
  } else {
    e = Math.floor(Math.log(value) / Math.LN2);
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--;
      c *= 2;
    }
    if (e + eBias >= 1) {
      value += rt / c;
    } else {
      value += rt * Math.pow(2, 1 - eBias);
    }
    if (value * c >= 2) {
      e++;
      c /= 2;
    }

    if (e + eBias >= eMax) {
      m = 0;
      e = eMax;
    } else if (e + eBias >= 1) {
      m = (value * c - 1) * Math.pow(2, mLen);
      e = e + eBias;
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
      e = 0;
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m;
  eLen += mLen;
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128;
}

var toString = {}.toString;

var isArray$1 = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};

/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */


var INSPECT_MAX_BYTES = 50;

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global$1.TYPED_ARRAY_SUPPORT !== undefined
  ? global$1.TYPED_ARRAY_SUPPORT
  : true;

/*
 * Export kMaxLength after typed array support is determined.
 */
kMaxLength();

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length);
    that.__proto__ = Buffer.prototype;
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length);
    }
    that.length = length;
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192; // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype;
  return arr
};

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
};

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype;
  Buffer.__proto__ = Uint8Array;
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) ;
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size);
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
};

function allocUnsafe (that, size) {
  assertSize(size);
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0;
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
};
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
};

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8';
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0;
  that = createBuffer(that, length);

  var actual = that.write(string, encoding);

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual);
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0;
  that = createBuffer(that, length);
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255;
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength; // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array);
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset);
  } else {
    array = new Uint8Array(array, byteOffset, length);
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array;
    that.__proto__ = Buffer.prototype;
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array);
  }
  return that
}

function fromObject (that, obj) {
  if (internalIsBuffer(obj)) {
    var len = checked(obj.length) | 0;
    that = createBuffer(that, len);

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len);
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray$1(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}
Buffer.isBuffer = isBuffer$1;
function internalIsBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length;
  var y = b.length;

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i];
      y = b[i];
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
};

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
};

Buffer.concat = function concat (list, length) {
  if (!isArray$1(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i;
  if (length === undefined) {
    length = 0;
    for (i = 0; i < list.length; ++i) {
      length += list[i].length;
    }
  }

  var buffer = Buffer.allocUnsafe(length);
  var pos = 0;
  for (i = 0; i < list.length; ++i) {
    var buf = list[i];
    if (!internalIsBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos);
    pos += buf.length;
  }
  return buffer
};

function byteLength (string, encoding) {
  if (internalIsBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string;
  }

  var len = string.length;
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
}
Buffer.byteLength = byteLength;

function slowToString (encoding, start, end) {
  var loweredCase = false;

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0;
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length;
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0;
  start >>>= 0;

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8';

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase();
        loweredCase = true;
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true;

function swap (b, n, m) {
  var i = b[n];
  b[n] = b[m];
  b[m] = i;
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length;
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1);
  }
  return this
};

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length;
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3);
    swap(this, i + 1, i + 2);
  }
  return this
};

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length;
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7);
    swap(this, i + 1, i + 6);
    swap(this, i + 2, i + 5);
    swap(this, i + 3, i + 4);
  }
  return this
};

Buffer.prototype.toString = function toString () {
  var length = this.length | 0;
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
};

Buffer.prototype.equals = function equals (b) {
  if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
};

Buffer.prototype.inspect = function inspect () {
  var str = '';
  var max = INSPECT_MAX_BYTES;
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
    if (this.length > max) str += ' ... ';
  }
  return '<Buffer ' + str + '>'
};

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!internalIsBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0;
  }
  if (end === undefined) {
    end = target ? target.length : 0;
  }
  if (thisStart === undefined) {
    thisStart = 0;
  }
  if (thisEnd === undefined) {
    thisEnd = this.length;
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0;
  end >>>= 0;
  thisStart >>>= 0;
  thisEnd >>>= 0;

  if (this === target) return 0

  var x = thisEnd - thisStart;
  var y = end - start;
  var len = Math.min(x, y);

  var thisCopy = this.slice(thisStart, thisEnd);
  var targetCopy = target.slice(start, end);

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i];
      y = targetCopy[i];
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
};

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset;
    byteOffset = 0;
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff;
  } else if (byteOffset < -2147483648) {
    byteOffset = -2147483648;
  }
  byteOffset = +byteOffset;  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1);
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1;
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0;
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding);
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (internalIsBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF; // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1;
  var arrLength = arr.length;
  var valLength = val.length;

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase();
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2;
      arrLength /= 2;
      valLength /= 2;
      byteOffset /= 2;
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i;
  if (dir) {
    var foundIndex = -1;
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i;
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex;
        foundIndex = -1;
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
    for (i = byteOffset; i >= 0; i--) {
      var found = true;
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false;
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
};

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
};

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
};

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0;
  var remaining = buf.length - offset;
  if (!length) {
    length = remaining;
  } else {
    length = Number(length);
    if (length > remaining) {
      length = remaining;
    }
  }

  // must be an even number of digits
  var strLen = string.length;
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2;
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16);
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed;
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8';
    length = this.length;
    offset = 0;
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset;
    length = this.length;
    offset = 0;
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0;
    if (isFinite(length)) {
      length = length | 0;
      if (encoding === undefined) encoding = 'utf8';
    } else {
      encoding = length;
      length = undefined;
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset;
  if (length === undefined || length > remaining) length = remaining;

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8';

  var loweredCase = false;
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase();
        loweredCase = true;
    }
  }
};

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
};

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return fromByteArray(buf)
  } else {
    return fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end);
  var res = [];

  var i = start;
  while (i < end) {
    var firstByte = buf[i];
    var codePoint = null;
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1;

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint;

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte;
          }
          break
        case 2:
          secondByte = buf[i + 1];
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint;
            }
          }
          break
        case 3:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint;
            }
          }
          break
        case 4:
          secondByte = buf[i + 1];
          thirdByte = buf[i + 2];
          fourthByte = buf[i + 3];
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint;
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD;
      bytesPerSequence = 1;
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000;
      res.push(codePoint >>> 10 & 0x3FF | 0xD800);
      codePoint = 0xDC00 | codePoint & 0x3FF;
    }

    res.push(codePoint);
    i += bytesPerSequence;
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000;

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length;
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = '';
  var i = 0;
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    );
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = '';
  end = Math.min(buf.length, end);

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F);
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = '';
  end = Math.min(buf.length, end);

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i]);
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length;

  if (!start || start < 0) start = 0;
  if (!end || end < 0 || end > len) end = len;

  var out = '';
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i]);
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end);
  var res = '';
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length;
  start = ~~start;
  end = end === undefined ? len : ~~end;

  if (start < 0) {
    start += len;
    if (start < 0) start = 0;
  } else if (start > len) {
    start = len;
  }

  if (end < 0) {
    end += len;
    if (end < 0) end = 0;
  } else if (end > len) {
    end = len;
  }

  if (end < start) end = start;

  var newBuf;
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end);
    newBuf.__proto__ = Buffer.prototype;
  } else {
    var sliceLen = end - start;
    newBuf = new Buffer(sliceLen, undefined);
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start];
    }
  }

  return newBuf
};

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  var val = this[offset];
  var mul = 1;
  var i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }

  return val
};

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length);
  }

  var val = this[offset + --byteLength];
  var mul = 1;
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul;
  }

  return val
};

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length);
  return this[offset]
};

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  return this[offset] | (this[offset + 1] << 8)
};

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  return (this[offset] << 8) | this[offset + 1]
};

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
};

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
};

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  var val = this[offset];
  var mul = 1;
  var i = 0;
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul;
  }
  mul *= 0x80;

  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

  return val
};

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) checkOffset(offset, byteLength, this.length);

  var i = byteLength;
  var mul = 1;
  var val = this[offset + --i];
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul;
  }
  mul *= 0x80;

  if (val >= mul) val -= Math.pow(2, 8 * byteLength);

  return val
};

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length);
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
};

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  var val = this[offset] | (this[offset + 1] << 8);
  return (val & 0x8000) ? val | 0xFFFF0000 : val
};

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length);
  var val = this[offset + 1] | (this[offset] << 8);
  return (val & 0x8000) ? val | 0xFFFF0000 : val
};

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
};

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
};

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);
  return read(this, offset, true, 23, 4)
};

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length);
  return read(this, offset, false, 23, 4)
};

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length);
  return read(this, offset, true, 52, 8)
};

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length);
  return read(this, offset, false, 52, 8)
};

function checkInt (buf, value, offset, ext, max, min) {
  if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }

  var mul = 1;
  var i = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  byteLength = byteLength | 0;
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1;
    checkInt(this, value, offset, byteLength, maxBytes, 0);
  }

  var i = byteLength - 1;
  var mul = 1;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
  this[offset] = (value & 0xff);
  return offset + 1
};

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1;
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8;
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff);
    this[offset + 1] = (value >>> 8);
  } else {
    objectWriteUInt16(this, value, offset, true);
  }
  return offset + 2
};

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8);
    this[offset + 1] = (value & 0xff);
  } else {
    objectWriteUInt16(this, value, offset, false);
  }
  return offset + 2
};

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1;
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24);
    this[offset + 2] = (value >>> 16);
    this[offset + 1] = (value >>> 8);
    this[offset] = (value & 0xff);
  } else {
    objectWriteUInt32(this, value, offset, true);
  }
  return offset + 4
};

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24);
    this[offset + 1] = (value >>> 16);
    this[offset + 2] = (value >>> 8);
    this[offset + 3] = (value & 0xff);
  } else {
    objectWriteUInt32(this, value, offset, false);
  }
  return offset + 4
};

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1);

    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }

  var i = 0;
  var mul = 1;
  var sub = 0;
  this[offset] = value & 0xFF;
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1);

    checkInt(this, value, offset, byteLength, limit - 1, -limit);
  }

  var i = byteLength - 1;
  var mul = 1;
  var sub = 0;
  this[offset + i] = value & 0xFF;
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1;
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
  }

  return offset + byteLength
};

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -128);
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
  if (value < 0) value = 0xff + value + 1;
  this[offset] = (value & 0xff);
  return offset + 1
};

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -32768);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff);
    this[offset + 1] = (value >>> 8);
  } else {
    objectWriteUInt16(this, value, offset, true);
  }
  return offset + 2
};

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -32768);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8);
    this[offset + 1] = (value & 0xff);
  } else {
    objectWriteUInt16(this, value, offset, false);
  }
  return offset + 2
};

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -2147483648);
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff);
    this[offset + 1] = (value >>> 8);
    this[offset + 2] = (value >>> 16);
    this[offset + 3] = (value >>> 24);
  } else {
    objectWriteUInt32(this, value, offset, true);
  }
  return offset + 4
};

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value;
  offset = offset | 0;
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -2147483648);
  if (value < 0) value = 0xffffffff + value + 1;
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24);
    this[offset + 1] = (value >>> 16);
    this[offset + 2] = (value >>> 8);
    this[offset + 3] = (value & 0xff);
  } else {
    objectWriteUInt32(this, value, offset, false);
  }
  return offset + 4
};

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4);
  }
  write(buf, value, offset, littleEndian, 23, 4);
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
};

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
};

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8);
  }
  write(buf, value, offset, littleEndian, 52, 8);
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
};

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
};

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0;
  if (!end && end !== 0) end = this.length;
  if (targetStart >= target.length) targetStart = target.length;
  if (!targetStart) targetStart = 0;
  if (end > 0 && end < start) end = start;

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length;
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start;
  }

  var len = end - start;
  var i;

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start];
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start];
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    );
  }

  return len
};

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start;
      start = 0;
      end = this.length;
    } else if (typeof end === 'string') {
      encoding = end;
      end = this.length;
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0);
      if (code < 256) {
        val = code;
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255;
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0;
  end = end === undefined ? this.length : end >>> 0;

  if (!val) val = 0;

  var i;
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val;
    }
  } else {
    var bytes = internalIsBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString());
    var len = bytes.length;
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len];
    }
  }

  return this
};

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '');
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '=';
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity;
  var codePoint;
  var length = string.length;
  var leadSurrogate = null;
  var bytes = [];

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i);

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
          continue
        }

        // valid lead
        leadSurrogate = codePoint;

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
        leadSurrogate = codePoint;
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
    }

    leadSurrogate = null;

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint);
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      );
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      );
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      );
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = [];
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF);
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo;
  var byteArray = [];
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i);
    hi = c >> 8;
    lo = c % 256;
    byteArray.push(lo);
    byteArray.push(hi);
  }

  return byteArray
}


function base64ToBytes (str) {
  return toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i];
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}


// the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
// The _isBuffer check is for Safari 5-7 support, because it's missing
// Object.prototype.constructor. Remove this eventually
function isBuffer$1(obj) {
  return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
}

function isFastBuffer (obj) {
  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
}

// For Node v0.10 support. Remove this eventually.
function isSlowBuffer (obj) {
  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
}

var inherits;
if (typeof Object.create === 'function'){
  inherits = function inherits(ctor, superCtor) {
    // implementation from standard node.js 'util' module
    ctor.super_ = superCtor;
    ctor.prototype = Object.create(superCtor.prototype, {
      constructor: {
        value: ctor,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });
  };
} else {
  inherits = function inherits(ctor, superCtor) {
    ctor.super_ = superCtor;
    var TempCtor = function () {};
    TempCtor.prototype = superCtor.prototype;
    ctor.prototype = new TempCtor();
    ctor.prototype.constructor = ctor;
  };
}

var getOwnPropertyDescriptors = Object.getOwnPropertyDescriptors ||
  function getOwnPropertyDescriptors(obj) {
    var keys = Object.keys(obj);
    var descriptors = {};
    for (var i = 0; i < keys.length; i++) {
      descriptors[keys[i]] = Object.getOwnPropertyDescriptor(obj, keys[i]);
    }
    return descriptors;
  };

var formatRegExp = /%[sdj%]/g;
function format$1(f) {
  if (!isString(f)) {
    var objects = [];
    for (var i = 0; i < arguments.length; i++) {
      objects.push(inspect(arguments[i]));
    }
    return objects.join(' ');
  }

  var i = 1;
  var args = arguments;
  var len = args.length;
  var str = String(f).replace(formatRegExp, function(x) {
    if (x === '%%') return '%';
    if (i >= len) return x;
    switch (x) {
      case '%s': return String(args[i++]);
      case '%d': return Number(args[i++]);
      case '%j':
        try {
          return JSON.stringify(args[i++]);
        } catch (_) {
          return '[Circular]';
        }
      default:
        return x;
    }
  });
  for (var x = args[i]; i < len; x = args[++i]) {
    if (isNull(x) || !isObject(x)) {
      str += ' ' + x;
    } else {
      str += ' ' + inspect(x);
    }
  }
  return str;
}

// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
function deprecate(fn, msg) {
  // Allow for deprecating things in the process of starting up.
  if (isUndefined(global$1.process)) {
    return function() {
      return deprecate(fn, msg).apply(this, arguments);
    };
  }

  if (browser$1$1.noDeprecation === true) {
    return fn;
  }

  var warned = false;
  function deprecated() {
    if (!warned) {
      if (browser$1$1.throwDeprecation) {
        throw new Error(msg);
      } else if (browser$1$1.traceDeprecation) {
        console.trace(msg);
      } else {
        console.error(msg);
      }
      warned = true;
    }
    return fn.apply(this, arguments);
  }

  return deprecated;
}

var debugs = {};
var debugEnviron;
function debuglog(set) {
  if (isUndefined(debugEnviron))
    debugEnviron = browser$1$1.env.NODE_DEBUG || '';
  set = set.toUpperCase();
  if (!debugs[set]) {
    if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
      var pid = 0;
      debugs[set] = function() {
        var msg = format$1.apply(null, arguments);
        console.error('%s %d: %s', set, pid, msg);
      };
    } else {
      debugs[set] = function() {};
    }
  }
  return debugs[set];
}

/**
 * Echos the value of a value. Trys to print the value out
 * in the best way possible given the different types.
 *
 * @param {Object} obj The object to print out.
 * @param {Object} opts Optional options object that alters the output.
 */
/* legacy: obj, showHidden, depth, colors*/
function inspect(obj, opts) {
  // default options
  var ctx = {
    seen: [],
    stylize: stylizeNoColor
  };
  // legacy...
  if (arguments.length >= 3) ctx.depth = arguments[2];
  if (arguments.length >= 4) ctx.colors = arguments[3];
  if (isBoolean(opts)) {
    // legacy...
    ctx.showHidden = opts;
  } else if (opts) {
    // got an "options" object
    _extend(ctx, opts);
  }
  // set default options
  if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
  if (isUndefined(ctx.depth)) ctx.depth = 2;
  if (isUndefined(ctx.colors)) ctx.colors = false;
  if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
  if (ctx.colors) ctx.stylize = stylizeWithColor;
  return formatValue(ctx, obj, ctx.depth);
}

// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
inspect.colors = {
  'bold' : [1, 22],
  'italic' : [3, 23],
  'underline' : [4, 24],
  'inverse' : [7, 27],
  'white' : [37, 39],
  'grey' : [90, 39],
  'black' : [30, 39],
  'blue' : [34, 39],
  'cyan' : [36, 39],
  'green' : [32, 39],
  'magenta' : [35, 39],
  'red' : [31, 39],
  'yellow' : [33, 39]
};

// Don't use 'blue' not visible on cmd.exe
inspect.styles = {
  'special': 'cyan',
  'number': 'yellow',
  'boolean': 'yellow',
  'undefined': 'grey',
  'null': 'bold',
  'string': 'green',
  'date': 'magenta',
  // "name": intentionally not styling
  'regexp': 'red'
};


function stylizeWithColor(str, styleType) {
  var style = inspect.styles[styleType];

  if (style) {
    return '\u001b[' + inspect.colors[style][0] + 'm' + str +
           '\u001b[' + inspect.colors[style][1] + 'm';
  } else {
    return str;
  }
}


function stylizeNoColor(str, styleType) {
  return str;
}


function arrayToHash(array) {
  var hash = {};

  array.forEach(function(val, idx) {
    hash[val] = true;
  });

  return hash;
}


function formatValue(ctx, value, recurseTimes) {
  // Provide a hook for user-specified inspect functions.
  // Check that value is an object with an inspect function on it
  if (ctx.customInspect &&
      value &&
      isFunction(value.inspect) &&
      // Filter out the util module, it's inspect function is special
      value.inspect !== inspect &&
      // Also filter out any prototype objects using the circular check.
      !(value.constructor && value.constructor.prototype === value)) {
    var ret = value.inspect(recurseTimes, ctx);
    if (!isString(ret)) {
      ret = formatValue(ctx, ret, recurseTimes);
    }
    return ret;
  }

  // Primitive types cannot have properties
  var primitive = formatPrimitive(ctx, value);
  if (primitive) {
    return primitive;
  }

  // Look up the keys of the object.
  var keys = Object.keys(value);
  var visibleKeys = arrayToHash(keys);

  if (ctx.showHidden) {
    keys = Object.getOwnPropertyNames(value);
  }

  // IE doesn't make error fields non-enumerable
  // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
  if (isError(value)
      && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
    return formatError(value);
  }

  // Some type of object without properties can be shortcutted.
  if (keys.length === 0) {
    if (isFunction(value)) {
      var name = value.name ? ': ' + value.name : '';
      return ctx.stylize('[Function' + name + ']', 'special');
    }
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    }
    if (isDate(value)) {
      return ctx.stylize(Date.prototype.toString.call(value), 'date');
    }
    if (isError(value)) {
      return formatError(value);
    }
  }

  var base = '', array = false, braces = ['{', '}'];

  // Make Array say that they are Array
  if (isArray(value)) {
    array = true;
    braces = ['[', ']'];
  }

  // Make functions say that they are functions
  if (isFunction(value)) {
    var n = value.name ? ': ' + value.name : '';
    base = ' [Function' + n + ']';
  }

  // Make RegExps say that they are RegExps
  if (isRegExp(value)) {
    base = ' ' + RegExp.prototype.toString.call(value);
  }

  // Make dates with properties first say the date
  if (isDate(value)) {
    base = ' ' + Date.prototype.toUTCString.call(value);
  }

  // Make error with message first say the error
  if (isError(value)) {
    base = ' ' + formatError(value);
  }

  if (keys.length === 0 && (!array || value.length == 0)) {
    return braces[0] + base + braces[1];
  }

  if (recurseTimes < 0) {
    if (isRegExp(value)) {
      return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
    } else {
      return ctx.stylize('[Object]', 'special');
    }
  }

  ctx.seen.push(value);

  var output;
  if (array) {
    output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
  } else {
    output = keys.map(function(key) {
      return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
    });
  }

  ctx.seen.pop();

  return reduceToSingleString(output, base, braces);
}


function formatPrimitive(ctx, value) {
  if (isUndefined(value))
    return ctx.stylize('undefined', 'undefined');
  if (isString(value)) {
    var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                             .replace(/'/g, "\\'")
                                             .replace(/\\"/g, '"') + '\'';
    return ctx.stylize(simple, 'string');
  }
  if (isNumber(value))
    return ctx.stylize('' + value, 'number');
  if (isBoolean(value))
    return ctx.stylize('' + value, 'boolean');
  // For some reason typeof null is "object", so special case here.
  if (isNull(value))
    return ctx.stylize('null', 'null');
}


function formatError(value) {
  return '[' + Error.prototype.toString.call(value) + ']';
}


function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
  var output = [];
  for (var i = 0, l = value.length; i < l; ++i) {
    if (hasOwnProperty(value, String(i))) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          String(i), true));
    } else {
      output.push('');
    }
  }
  keys.forEach(function(key) {
    if (!key.match(/^\d+$/)) {
      output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
          key, true));
    }
  });
  return output;
}


function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
  var name, str, desc;
  desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
  if (desc.get) {
    if (desc.set) {
      str = ctx.stylize('[Getter/Setter]', 'special');
    } else {
      str = ctx.stylize('[Getter]', 'special');
    }
  } else {
    if (desc.set) {
      str = ctx.stylize('[Setter]', 'special');
    }
  }
  if (!hasOwnProperty(visibleKeys, key)) {
    name = '[' + key + ']';
  }
  if (!str) {
    if (ctx.seen.indexOf(desc.value) < 0) {
      if (isNull(recurseTimes)) {
        str = formatValue(ctx, desc.value, null);
      } else {
        str = formatValue(ctx, desc.value, recurseTimes - 1);
      }
      if (str.indexOf('\n') > -1) {
        if (array) {
          str = str.split('\n').map(function(line) {
            return '  ' + line;
          }).join('\n').substr(2);
        } else {
          str = '\n' + str.split('\n').map(function(line) {
            return '   ' + line;
          }).join('\n');
        }
      }
    } else {
      str = ctx.stylize('[Circular]', 'special');
    }
  }
  if (isUndefined(name)) {
    if (array && key.match(/^\d+$/)) {
      return str;
    }
    name = JSON.stringify('' + key);
    if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
      name = name.substr(1, name.length - 2);
      name = ctx.stylize(name, 'name');
    } else {
      name = name.replace(/'/g, "\\'")
                 .replace(/\\"/g, '"')
                 .replace(/(^"|"$)/g, "'");
      name = ctx.stylize(name, 'string');
    }
  }

  return name + ': ' + str;
}


function reduceToSingleString(output, base, braces) {
  var length = output.reduce(function(prev, cur) {
    if (cur.indexOf('\n') >= 0) ;
    return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
  }, 0);

  if (length > 60) {
    return braces[0] +
           (base === '' ? '' : base + '\n ') +
           ' ' +
           output.join(',\n  ') +
           ' ' +
           braces[1];
  }

  return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
}


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
function isArray(ar) {
  return Array.isArray(ar);
}

function isBoolean(arg) {
  return typeof arg === 'boolean';
}

function isNull(arg) {
  return arg === null;
}

function isNullOrUndefined(arg) {
  return arg == null;
}

function isNumber(arg) {
  return typeof arg === 'number';
}

function isString(arg) {
  return typeof arg === 'string';
}

function isSymbol(arg) {
  return typeof arg === 'symbol';
}

function isUndefined(arg) {
  return arg === void 0;
}

function isRegExp(re) {
  return isObject(re) && objectToString(re) === '[object RegExp]';
}

function isObject(arg) {
  return typeof arg === 'object' && arg !== null;
}

function isDate(d) {
  return isObject(d) && objectToString(d) === '[object Date]';
}

function isError(e) {
  return isObject(e) &&
      (objectToString(e) === '[object Error]' || e instanceof Error);
}

function isFunction(arg) {
  return typeof arg === 'function';
}

function isPrimitive(arg) {
  return arg === null ||
         typeof arg === 'boolean' ||
         typeof arg === 'number' ||
         typeof arg === 'string' ||
         typeof arg === 'symbol' ||  // ES6 symbol
         typeof arg === 'undefined';
}

function isBuffer(maybeBuf) {
  return Buffer.isBuffer(maybeBuf);
}

function objectToString(o) {
  return Object.prototype.toString.call(o);
}


function pad(n) {
  return n < 10 ? '0' + n.toString(10) : n.toString(10);
}


var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
              'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
function timestamp() {
  var d = new Date();
  var time = [pad(d.getHours()),
              pad(d.getMinutes()),
              pad(d.getSeconds())].join(':');
  return [d.getDate(), months[d.getMonth()], time].join(' ');
}


// log is just a thin wrapper to console.log that prepends a timestamp
function log() {
  console.log('%s - %s', timestamp(), format$1.apply(null, arguments));
}

function _extend(origin, add) {
  // Don't do anything if add isn't an object
  if (!add || !isObject(add)) return origin;

  var keys = Object.keys(add);
  var i = keys.length;
  while (i--) {
    origin[keys[i]] = add[keys[i]];
  }
  return origin;
}
function hasOwnProperty(obj, prop) {
  return Object.prototype.hasOwnProperty.call(obj, prop);
}

var kCustomPromisifiedSymbol = typeof Symbol !== 'undefined' ? Symbol('util.promisify.custom') : undefined;

function promisify(original) {
  if (typeof original !== 'function')
    throw new TypeError('The "original" argument must be of type Function');

  if (kCustomPromisifiedSymbol && original[kCustomPromisifiedSymbol]) {
    var fn = original[kCustomPromisifiedSymbol];
    if (typeof fn !== 'function') {
      throw new TypeError('The "util.promisify.custom" argument must be of type Function');
    }
    Object.defineProperty(fn, kCustomPromisifiedSymbol, {
      value: fn, enumerable: false, writable: false, configurable: true
    });
    return fn;
  }

  function fn() {
    var promiseResolve, promiseReject;
    var promise = new Promise(function (resolve, reject) {
      promiseResolve = resolve;
      promiseReject = reject;
    });

    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }
    args.push(function (err, value) {
      if (err) {
        promiseReject(err);
      } else {
        promiseResolve(value);
      }
    });

    try {
      original.apply(this, args);
    } catch (err) {
      promiseReject(err);
    }

    return promise;
  }

  Object.setPrototypeOf(fn, Object.getPrototypeOf(original));

  if (kCustomPromisifiedSymbol) Object.defineProperty(fn, kCustomPromisifiedSymbol, {
    value: fn, enumerable: false, writable: false, configurable: true
  });
  return Object.defineProperties(
    fn,
    getOwnPropertyDescriptors(original)
  );
}

promisify.custom = kCustomPromisifiedSymbol;

function callbackifyOnRejected(reason, cb) {
  // `!reason` guard inspired by bluebird (Ref: https://goo.gl/t5IS6M).
  // Because `null` is a special error value in callbacks which means "no error
  // occurred", we error-wrap so the callback consumer can distinguish between
  // "the promise rejected with null" or "the promise fulfilled with undefined".
  if (!reason) {
    var newReason = new Error('Promise was rejected with a falsy value');
    newReason.reason = reason;
    reason = newReason;
  }
  return cb(reason);
}

function callbackify(original) {
  if (typeof original !== 'function') {
    throw new TypeError('The "original" argument must be of type Function');
  }

  // We DO NOT return the promise as it gives the user a false sense that
  // the promise is actually somehow related to the callback's execution
  // and that the callback throwing will reject the promise.
  function callbackified() {
    var args = [];
    for (var i = 0; i < arguments.length; i++) {
      args.push(arguments[i]);
    }

    var maybeCb = args.pop();
    if (typeof maybeCb !== 'function') {
      throw new TypeError('The last argument must be of type Function');
    }
    var self = this;
    var cb = function() {
      return maybeCb.apply(self, arguments);
    };
    // In true node style we process the callback on `nextTick` with all the
    // implications (stack, `uncaughtException`, `async_hooks`)
    original.apply(this, args)
      .then(function(ret) { browser$1$1.nextTick(cb.bind(null, null, ret)); },
        function(rej) { browser$1$1.nextTick(callbackifyOnRejected.bind(null, rej, cb)); });
  }

  Object.setPrototypeOf(callbackified, Object.getPrototypeOf(original));
  Object.defineProperties(callbackified, getOwnPropertyDescriptors(original));
  return callbackified;
}

var _polyfillNode_util = {
  inherits: inherits,
  _extend: _extend,
  log: log,
  isBuffer: isBuffer,
  isPrimitive: isPrimitive,
  isFunction: isFunction,
  isError: isError,
  isDate: isDate,
  isObject: isObject,
  isRegExp: isRegExp,
  isUndefined: isUndefined,
  isSymbol: isSymbol,
  isString: isString,
  isNumber: isNumber,
  isNullOrUndefined: isNullOrUndefined,
  isNull: isNull,
  isBoolean: isBoolean,
  isArray: isArray,
  inspect: inspect,
  deprecate: deprecate,
  format: format$1,
  debuglog: debuglog,
  promisify: promisify,
  callbackify: callbackify,
};

var _polyfillNode_util$1 = /*#__PURE__*/Object.freeze({
	__proto__: null,
	_extend: _extend,
	callbackify: callbackify,
	debuglog: debuglog,
	default: _polyfillNode_util,
	deprecate: deprecate,
	format: format$1,
	inherits: inherits,
	inspect: inspect,
	isArray: isArray,
	isBoolean: isBoolean,
	isBuffer: isBuffer,
	isDate: isDate,
	isError: isError,
	isFunction: isFunction,
	isNull: isNull,
	isNullOrUndefined: isNullOrUndefined,
	isNumber: isNumber,
	isObject: isObject,
	isPrimitive: isPrimitive,
	isRegExp: isRegExp,
	isString: isString,
	isSymbol: isSymbol,
	isUndefined: isUndefined,
	log: log,
	promisify: promisify
});

var require$$1$1 = /*@__PURE__*/getDefaultExportFromNamespaceIfPresent(_polyfillNode_util$1);

var uri_all = {exports: {}};

/** @license URI.js v4.4.1 (c) 2011 Gary Court. License: http://github.com/garycourt/uri-js */

var hasRequiredUri_all;

function requireUri_all () {
	if (hasRequiredUri_all) return uri_all.exports;
	hasRequiredUri_all = 1;
	(function (module, exports) {
		(function (global, factory) {
			factory(exports) ;
		}(this, (function (exports) {
		function merge() {
		    for (var _len = arguments.length, sets = Array(_len), _key = 0; _key < _len; _key++) {
		        sets[_key] = arguments[_key];
		    }

		    if (sets.length > 1) {
		        sets[0] = sets[0].slice(0, -1);
		        var xl = sets.length - 1;
		        for (var x = 1; x < xl; ++x) {
		            sets[x] = sets[x].slice(1, -1);
		        }
		        sets[xl] = sets[xl].slice(1);
		        return sets.join('');
		    } else {
		        return sets[0];
		    }
		}
		function subexp(str) {
		    return "(?:" + str + ")";
		}
		function typeOf(o) {
		    return o === undefined ? "undefined" : o === null ? "null" : Object.prototype.toString.call(o).split(" ").pop().split("]").shift().toLowerCase();
		}
		function toUpperCase(str) {
		    return str.toUpperCase();
		}
		function toArray(obj) {
		    return obj !== undefined && obj !== null ? obj instanceof Array ? obj : typeof obj.length !== "number" || obj.split || obj.setInterval || obj.call ? [obj] : Array.prototype.slice.call(obj) : [];
		}
		function assign(target, source) {
		    var obj = target;
		    if (source) {
		        for (var key in source) {
		            obj[key] = source[key];
		        }
		    }
		    return obj;
		}

		function buildExps(isIRI) {
		    var ALPHA$$ = "[A-Za-z]",
		        DIGIT$$ = "[0-9]",
		        HEXDIG$$ = merge(DIGIT$$, "[A-Fa-f]"),
		        PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$)),
		        //expanded
		    GEN_DELIMS$$ = "[\\:\\/\\?\\#\\[\\]\\@]",
		        SUB_DELIMS$$ = "[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]",
		        RESERVED$$ = merge(GEN_DELIMS$$, SUB_DELIMS$$),
		        UCSCHAR$$ = isIRI ? "[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]" : "[]",
		        //subset, excludes bidi control characters
		    IPRIVATE$$ = isIRI ? "[\\uE000-\\uF8FF]" : "[]",
		        //subset
		    UNRESERVED$$ = merge(ALPHA$$, DIGIT$$, "[\\-\\.\\_\\~]", UCSCHAR$$);
		        subexp(ALPHA$$ + merge(ALPHA$$, DIGIT$$, "[\\+\\-\\.]") + "*");
		        subexp(subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\:]")) + "*");
		        var DEC_OCTET_RELAXED$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("0?[1-9]" + DIGIT$$) + "|0?0?" + DIGIT$$),
		        //relaxed parsing rules
		    IPV4ADDRESS$ = subexp(DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$),
		        H16$ = subexp(HEXDIG$$ + "{1,4}"),
		        LS32$ = subexp(subexp(H16$ + "\\:" + H16$) + "|" + IPV4ADDRESS$),
		        IPV6ADDRESS1$ = subexp(subexp(H16$ + "\\:") + "{6}" + LS32$),
		        //                           6( h16 ":" ) ls32
		    IPV6ADDRESS2$ = subexp("\\:\\:" + subexp(H16$ + "\\:") + "{5}" + LS32$),
		        //                      "::" 5( h16 ":" ) ls32
		    IPV6ADDRESS3$ = subexp(subexp(H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{4}" + LS32$),
		        //[               h16 ] "::" 4( h16 ":" ) ls32
		    IPV6ADDRESS4$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,1}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{3}" + LS32$),
		        //[ *1( h16 ":" ) h16 ] "::" 3( h16 ":" ) ls32
		    IPV6ADDRESS5$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,2}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{2}" + LS32$),
		        //[ *2( h16 ":" ) h16 ] "::" 2( h16 ":" ) ls32
		    IPV6ADDRESS6$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,3}" + H16$) + "?\\:\\:" + H16$ + "\\:" + LS32$),
		        //[ *3( h16 ":" ) h16 ] "::"    h16 ":"   ls32
		    IPV6ADDRESS7$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,4}" + H16$) + "?\\:\\:" + LS32$),
		        //[ *4( h16 ":" ) h16 ] "::"              ls32
		    IPV6ADDRESS8$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,5}" + H16$) + "?\\:\\:" + H16$),
		        //[ *5( h16 ":" ) h16 ] "::"              h16
		    IPV6ADDRESS9$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,6}" + H16$) + "?\\:\\:"),
		        //[ *6( h16 ":" ) h16 ] "::"
		    IPV6ADDRESS$ = subexp([IPV6ADDRESS1$, IPV6ADDRESS2$, IPV6ADDRESS3$, IPV6ADDRESS4$, IPV6ADDRESS5$, IPV6ADDRESS6$, IPV6ADDRESS7$, IPV6ADDRESS8$, IPV6ADDRESS9$].join("|")),
		        ZONEID$ = subexp(subexp(UNRESERVED$$ + "|" + PCT_ENCODED$) + "+");
		        //RFC 6874, with relaxed parsing rules
		    subexp("[vV]" + HEXDIG$$ + "+\\." + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\:]") + "+");
		        //RFC 6874
		    subexp(subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$)) + "*");
		        var PCHAR$ = subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\:\\@]"));
		        subexp(subexp(PCT_ENCODED$ + "|" + merge(UNRESERVED$$, SUB_DELIMS$$, "[\\@]")) + "+");
		        subexp(subexp(PCHAR$ + "|" + merge("[\\/\\?]", IPRIVATE$$)) + "*");
		    return {
		        NOT_SCHEME: new RegExp(merge("[^]", ALPHA$$, DIGIT$$, "[\\+\\-\\.]"), "g"),
		        NOT_USERINFO: new RegExp(merge("[^\\%\\:]", UNRESERVED$$, SUB_DELIMS$$), "g"),
		        NOT_HOST: new RegExp(merge("[^\\%\\[\\]\\:]", UNRESERVED$$, SUB_DELIMS$$), "g"),
		        NOT_PATH: new RegExp(merge("[^\\%\\/\\:\\@]", UNRESERVED$$, SUB_DELIMS$$), "g"),
		        NOT_PATH_NOSCHEME: new RegExp(merge("[^\\%\\/\\@]", UNRESERVED$$, SUB_DELIMS$$), "g"),
		        NOT_QUERY: new RegExp(merge("[^\\%]", UNRESERVED$$, SUB_DELIMS$$, "[\\:\\@\\/\\?]", IPRIVATE$$), "g"),
		        NOT_FRAGMENT: new RegExp(merge("[^\\%]", UNRESERVED$$, SUB_DELIMS$$, "[\\:\\@\\/\\?]"), "g"),
		        ESCAPE: new RegExp(merge("[^]", UNRESERVED$$, SUB_DELIMS$$), "g"),
		        UNRESERVED: new RegExp(UNRESERVED$$, "g"),
		        OTHER_CHARS: new RegExp(merge("[^\\%]", UNRESERVED$$, RESERVED$$), "g"),
		        PCT_ENCODED: new RegExp(PCT_ENCODED$, "g"),
		        IPV4ADDRESS: new RegExp("^(" + IPV4ADDRESS$ + ")$"),
		        IPV6ADDRESS: new RegExp("^\\[?(" + IPV6ADDRESS$ + ")" + subexp(subexp("\\%25|\\%(?!" + HEXDIG$$ + "{2})") + "(" + ZONEID$ + ")") + "?\\]?$") //RFC 6874, with relaxed parsing rules
		    };
		}
		var URI_PROTOCOL = buildExps(false);

		var IRI_PROTOCOL = buildExps(true);

		var slicedToArray = function () {
		  function sliceIterator(arr, i) {
		    var _arr = [];
		    var _n = true;
		    var _d = false;
		    var _e = undefined;

		    try {
		      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
		        _arr.push(_s.value);

		        if (i && _arr.length === i) break;
		      }
		    } catch (err) {
		      _d = true;
		      _e = err;
		    } finally {
		      try {
		        if (!_n && _i["return"]) _i["return"]();
		      } finally {
		        if (_d) throw _e;
		      }
		    }

		    return _arr;
		  }

		  return function (arr, i) {
		    if (Array.isArray(arr)) {
		      return arr;
		    } else if (Symbol.iterator in Object(arr)) {
		      return sliceIterator(arr, i);
		    } else {
		      throw new TypeError("Invalid attempt to destructure non-iterable instance");
		    }
		  };
		}();













		var toConsumableArray = function (arr) {
		  if (Array.isArray(arr)) {
		    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

		    return arr2;
		  } else {
		    return Array.from(arr);
		  }
		};

		/** Highest positive signed 32-bit float value */

		var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

		/** Bootstring parameters */
		var base = 36;
		var tMin = 1;
		var tMax = 26;
		var skew = 38;
		var damp = 700;
		var initialBias = 72;
		var initialN = 128; // 0x80
		var delimiter = '-'; // '\x2D'

		/** Regular expressions */
		var regexPunycode = /^xn--/;
		var regexNonASCII = /[^\0-\x7E]/; // non-ASCII chars
		var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

		/** Error messages */
		var errors = {
			'overflow': 'Overflow: input needs wider integers to process',
			'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
			'invalid-input': 'Invalid input'
		};

		/** Convenience shortcuts */
		var baseMinusTMin = base - tMin;
		var floor = Math.floor;
		var stringFromCharCode = String.fromCharCode;

		/*--------------------------------------------------------------------------*/

		/**
		 * A generic error utility function.
		 * @private
		 * @param {String} type The error type.
		 * @returns {Error} Throws a `RangeError` with the applicable error message.
		 */
		function error$1(type) {
			throw new RangeError(errors[type]);
		}

		/**
		 * A generic `Array#map` utility function.
		 * @private
		 * @param {Array} array The array to iterate over.
		 * @param {Function} callback The function that gets called for every array
		 * item.
		 * @returns {Array} A new array of values returned by the callback function.
		 */
		function map(array, fn) {
			var result = [];
			var length = array.length;
			while (length--) {
				result[length] = fn(array[length]);
			}
			return result;
		}

		/**
		 * A simple `Array#map`-like wrapper to work with domain name strings or email
		 * addresses.
		 * @private
		 * @param {String} domain The domain name or email address.
		 * @param {Function} callback The function that gets called for every
		 * character.
		 * @returns {Array} A new string of characters returned by the callback
		 * function.
		 */
		function mapDomain(string, fn) {
			var parts = string.split('@');
			var result = '';
			if (parts.length > 1) {
				// In email addresses, only the domain name should be punycoded. Leave
				// the local part (i.e. everything up to `@`) intact.
				result = parts[0] + '@';
				string = parts[1];
			}
			// Avoid `split(regex)` for IE8 compatibility. See #17.
			string = string.replace(regexSeparators, '\x2E');
			var labels = string.split('.');
			var encoded = map(labels, fn).join('.');
			return result + encoded;
		}

		/**
		 * Creates an array containing the numeric code points of each Unicode
		 * character in the string. While JavaScript uses UCS-2 internally,
		 * this function will convert a pair of surrogate halves (each of which
		 * UCS-2 exposes as separate characters) into a single code point,
		 * matching UTF-16.
		 * @see `punycode.ucs2.encode`
		 * @see <https://mathiasbynens.be/notes/javascript-encoding>
		 * @memberOf punycode.ucs2
		 * @name decode
		 * @param {String} string The Unicode input string (UCS-2).
		 * @returns {Array} The new array of code points.
		 */
		function ucs2decode(string) {
			var output = [];
			var counter = 0;
			var length = string.length;
			while (counter < length) {
				var value = string.charCodeAt(counter++);
				if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
					// It's a high surrogate, and there is a next character.
					var extra = string.charCodeAt(counter++);
					if ((extra & 0xFC00) == 0xDC00) {
						// Low surrogate.
						output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
					} else {
						// It's an unmatched surrogate; only append this code unit, in case the
						// next code unit is the high surrogate of a surrogate pair.
						output.push(value);
						counter--;
					}
				} else {
					output.push(value);
				}
			}
			return output;
		}

		/**
		 * Creates a string based on an array of numeric code points.
		 * @see `punycode.ucs2.decode`
		 * @memberOf punycode.ucs2
		 * @name encode
		 * @param {Array} codePoints The array of numeric code points.
		 * @returns {String} The new Unicode string (UCS-2).
		 */
		var ucs2encode = function ucs2encode(array) {
			return String.fromCodePoint.apply(String, toConsumableArray(array));
		};

		/**
		 * Converts a basic code point into a digit/integer.
		 * @see `digitToBasic()`
		 * @private
		 * @param {Number} codePoint The basic numeric code point value.
		 * @returns {Number} The numeric value of a basic code point (for use in
		 * representing integers) in the range `0` to `base - 1`, or `base` if
		 * the code point does not represent a value.
		 */
		var basicToDigit = function basicToDigit(codePoint) {
			if (codePoint - 0x30 < 0x0A) {
				return codePoint - 0x16;
			}
			if (codePoint - 0x41 < 0x1A) {
				return codePoint - 0x41;
			}
			if (codePoint - 0x61 < 0x1A) {
				return codePoint - 0x61;
			}
			return base;
		};

		/**
		 * Converts a digit/integer into a basic code point.
		 * @see `basicToDigit()`
		 * @private
		 * @param {Number} digit The numeric value of a basic code point.
		 * @returns {Number} The basic code point whose value (when used for
		 * representing integers) is `digit`, which needs to be in the range
		 * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
		 * used; else, the lowercase form is used. The behavior is undefined
		 * if `flag` is non-zero and `digit` has no uppercase form.
		 */
		var digitToBasic = function digitToBasic(digit, flag) {
			//  0..25 map to ASCII a..z or A..Z
			// 26..35 map to ASCII 0..9
			return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
		};

		/**
		 * Bias adaptation function as per section 3.4 of RFC 3492.
		 * https://tools.ietf.org/html/rfc3492#section-3.4
		 * @private
		 */
		var adapt = function adapt(delta, numPoints, firstTime) {
			var k = 0;
			delta = firstTime ? floor(delta / damp) : delta >> 1;
			delta += floor(delta / numPoints);
			for (; /* no initialization */delta > baseMinusTMin * tMax >> 1; k += base) {
				delta = floor(delta / baseMinusTMin);
			}
			return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
		};

		/**
		 * Converts a Punycode string of ASCII-only symbols to a string of Unicode
		 * symbols.
		 * @memberOf punycode
		 * @param {String} input The Punycode string of ASCII-only symbols.
		 * @returns {String} The resulting string of Unicode symbols.
		 */
		var decode = function decode(input) {
			// Don't use UCS-2.
			var output = [];
			var inputLength = input.length;
			var i = 0;
			var n = initialN;
			var bias = initialBias;

			// Handle the basic code points: let `basic` be the number of input code
			// points before the last delimiter, or `0` if there is none, then copy
			// the first basic code points to the output.

			var basic = input.lastIndexOf(delimiter);
			if (basic < 0) {
				basic = 0;
			}

			for (var j = 0; j < basic; ++j) {
				// if it's not a basic code point
				if (input.charCodeAt(j) >= 0x80) {
					error$1('not-basic');
				}
				output.push(input.charCodeAt(j));
			}

			// Main decoding loop: start just after the last delimiter if any basic code
			// points were copied; start at the beginning otherwise.

			for (var index = basic > 0 ? basic + 1 : 0; index < inputLength;) /* no final expression */{

				// `index` is the index of the next character to be consumed.
				// Decode a generalized variable-length integer into `delta`,
				// which gets added to `i`. The overflow checking is easier
				// if we increase `i` as we go, then subtract off its starting
				// value at the end to obtain `delta`.
				var oldi = i;
				for (var w = 1, k = base;; /* no condition */k += base) {

					if (index >= inputLength) {
						error$1('invalid-input');
					}

					var digit = basicToDigit(input.charCodeAt(index++));

					if (digit >= base || digit > floor((maxInt - i) / w)) {
						error$1('overflow');
					}

					i += digit * w;
					var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;

					if (digit < t) {
						break;
					}

					var baseMinusT = base - t;
					if (w > floor(maxInt / baseMinusT)) {
						error$1('overflow');
					}

					w *= baseMinusT;
				}

				var out = output.length + 1;
				bias = adapt(i - oldi, out, oldi == 0);

				// `i` was supposed to wrap around from `out` to `0`,
				// incrementing `n` each time, so we'll fix that now:
				if (floor(i / out) > maxInt - n) {
					error$1('overflow');
				}

				n += floor(i / out);
				i %= out;

				// Insert `n` at position `i` of the output.
				output.splice(i++, 0, n);
			}

			return String.fromCodePoint.apply(String, output);
		};

		/**
		 * Converts a string of Unicode symbols (e.g. a domain name label) to a
		 * Punycode string of ASCII-only symbols.
		 * @memberOf punycode
		 * @param {String} input The string of Unicode symbols.
		 * @returns {String} The resulting Punycode string of ASCII-only symbols.
		 */
		var encode = function encode(input) {
			var output = [];

			// Convert the input in UCS-2 to an array of Unicode code points.
			input = ucs2decode(input);

			// Cache the length.
			var inputLength = input.length;

			// Initialize the state.
			var n = initialN;
			var delta = 0;
			var bias = initialBias;

			// Handle the basic code points.
			var _iteratorNormalCompletion = true;
			var _didIteratorError = false;
			var _iteratorError = undefined;

			try {
				for (var _iterator = input[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
					var _currentValue2 = _step.value;

					if (_currentValue2 < 0x80) {
						output.push(stringFromCharCode(_currentValue2));
					}
				}
			} catch (err) {
				_didIteratorError = true;
				_iteratorError = err;
			} finally {
				try {
					if (!_iteratorNormalCompletion && _iterator.return) {
						_iterator.return();
					}
				} finally {
					if (_didIteratorError) {
						throw _iteratorError;
					}
				}
			}

			var basicLength = output.length;
			var handledCPCount = basicLength;

			// `handledCPCount` is the number of code points that have been handled;
			// `basicLength` is the number of basic code points.

			// Finish the basic string with a delimiter unless it's empty.
			if (basicLength) {
				output.push(delimiter);
			}

			// Main encoding loop:
			while (handledCPCount < inputLength) {

				// All non-basic code points < n have been handled already. Find the next
				// larger one:
				var m = maxInt;
				var _iteratorNormalCompletion2 = true;
				var _didIteratorError2 = false;
				var _iteratorError2 = undefined;

				try {
					for (var _iterator2 = input[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
						var currentValue = _step2.value;

						if (currentValue >= n && currentValue < m) {
							m = currentValue;
						}
					}

					// Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
					// but guard against overflow.
				} catch (err) {
					_didIteratorError2 = true;
					_iteratorError2 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion2 && _iterator2.return) {
							_iterator2.return();
						}
					} finally {
						if (_didIteratorError2) {
							throw _iteratorError2;
						}
					}
				}

				var handledCPCountPlusOne = handledCPCount + 1;
				if (m - n > floor((maxInt - delta) / handledCPCountPlusOne)) {
					error$1('overflow');
				}

				delta += (m - n) * handledCPCountPlusOne;
				n = m;

				var _iteratorNormalCompletion3 = true;
				var _didIteratorError3 = false;
				var _iteratorError3 = undefined;

				try {
					for (var _iterator3 = input[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
						var _currentValue = _step3.value;

						if (_currentValue < n && ++delta > maxInt) {
							error$1('overflow');
						}
						if (_currentValue == n) {
							// Represent delta as a generalized variable-length integer.
							var q = delta;
							for (var k = base;; /* no condition */k += base) {
								var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
								if (q < t) {
									break;
								}
								var qMinusT = q - t;
								var baseMinusT = base - t;
								output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0)));
								q = floor(qMinusT / baseMinusT);
							}

							output.push(stringFromCharCode(digitToBasic(q, 0)));
							bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
							delta = 0;
							++handledCPCount;
						}
					}
				} catch (err) {
					_didIteratorError3 = true;
					_iteratorError3 = err;
				} finally {
					try {
						if (!_iteratorNormalCompletion3 && _iterator3.return) {
							_iterator3.return();
						}
					} finally {
						if (_didIteratorError3) {
							throw _iteratorError3;
						}
					}
				}

				++delta;
				++n;
			}
			return output.join('');
		};

		/**
		 * Converts a Punycode string representing a domain name or an email address
		 * to Unicode. Only the Punycoded parts of the input will be converted, i.e.
		 * it doesn't matter if you call it on a string that has already been
		 * converted to Unicode.
		 * @memberOf punycode
		 * @param {String} input The Punycoded domain name or email address to
		 * convert to Unicode.
		 * @returns {String} The Unicode representation of the given Punycode
		 * string.
		 */
		var toUnicode = function toUnicode(input) {
			return mapDomain(input, function (string) {
				return regexPunycode.test(string) ? decode(string.slice(4).toLowerCase()) : string;
			});
		};

		/**
		 * Converts a Unicode string representing a domain name or an email address to
		 * Punycode. Only the non-ASCII parts of the domain name will be converted,
		 * i.e. it doesn't matter if you call it with a domain that's already in
		 * ASCII.
		 * @memberOf punycode
		 * @param {String} input The domain name or email address to convert, as a
		 * Unicode string.
		 * @returns {String} The Punycode representation of the given domain name or
		 * email address.
		 */
		var toASCII = function toASCII(input) {
			return mapDomain(input, function (string) {
				return regexNonASCII.test(string) ? 'xn--' + encode(string) : string;
			});
		};

		/*--------------------------------------------------------------------------*/

		/** Define the public API */
		var punycode = {
			/**
		  * A string representing the current Punycode.js version number.
		  * @memberOf punycode
		  * @type String
		  */
			'version': '2.1.0',
			/**
		  * An object of methods to convert from JavaScript's internal character
		  * representation (UCS-2) to Unicode code points, and back.
		  * @see <https://mathiasbynens.be/notes/javascript-encoding>
		  * @memberOf punycode
		  * @type Object
		  */
			'ucs2': {
				'decode': ucs2decode,
				'encode': ucs2encode
			},
			'decode': decode,
			'encode': encode,
			'toASCII': toASCII,
			'toUnicode': toUnicode
		};

		/**
		 * URI.js
		 *
		 * @fileoverview An RFC 3986 compliant, scheme extendable URI parsing/validating/resolving library for JavaScript.
		 * @author <a href="mailto:gary.court@gmail.com">Gary Court</a>
		 * @see http://github.com/garycourt/uri-js
		 */
		/**
		 * Copyright 2011 Gary Court. All rights reserved.
		 *
		 * Redistribution and use in source and binary forms, with or without modification, are
		 * permitted provided that the following conditions are met:
		 *
		 *    1. Redistributions of source code must retain the above copyright notice, this list of
		 *       conditions and the following disclaimer.
		 *
		 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
		 *       of conditions and the following disclaimer in the documentation and/or other materials
		 *       provided with the distribution.
		 *
		 * THIS SOFTWARE IS PROVIDED BY GARY COURT ``AS IS'' AND ANY EXPRESS OR IMPLIED
		 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
		 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GARY COURT OR
		 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
		 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
		 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
		 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
		 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
		 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
		 *
		 * The views and conclusions contained in the software and documentation are those of the
		 * authors and should not be interpreted as representing official policies, either expressed
		 * or implied, of Gary Court.
		 */
		var SCHEMES = {};
		function pctEncChar(chr) {
		    var c = chr.charCodeAt(0);
		    var e = void 0;
		    if (c < 16) e = "%0" + c.toString(16).toUpperCase();else if (c < 128) e = "%" + c.toString(16).toUpperCase();else if (c < 2048) e = "%" + (c >> 6 | 192).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();else e = "%" + (c >> 12 | 224).toString(16).toUpperCase() + "%" + (c >> 6 & 63 | 128).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();
		    return e;
		}
		function pctDecChars(str) {
		    var newStr = "";
		    var i = 0;
		    var il = str.length;
		    while (i < il) {
		        var c = parseInt(str.substr(i + 1, 2), 16);
		        if (c < 128) {
		            newStr += String.fromCharCode(c);
		            i += 3;
		        } else if (c >= 194 && c < 224) {
		            if (il - i >= 6) {
		                var c2 = parseInt(str.substr(i + 4, 2), 16);
		                newStr += String.fromCharCode((c & 31) << 6 | c2 & 63);
		            } else {
		                newStr += str.substr(i, 6);
		            }
		            i += 6;
		        } else if (c >= 224) {
		            if (il - i >= 9) {
		                var _c = parseInt(str.substr(i + 4, 2), 16);
		                var c3 = parseInt(str.substr(i + 7, 2), 16);
		                newStr += String.fromCharCode((c & 15) << 12 | (_c & 63) << 6 | c3 & 63);
		            } else {
		                newStr += str.substr(i, 9);
		            }
		            i += 9;
		        } else {
		            newStr += str.substr(i, 3);
		            i += 3;
		        }
		    }
		    return newStr;
		}
		function _normalizeComponentEncoding(components, protocol) {
		    function decodeUnreserved(str) {
		        var decStr = pctDecChars(str);
		        return !decStr.match(protocol.UNRESERVED) ? str : decStr;
		    }
		    if (components.scheme) components.scheme = String(components.scheme).replace(protocol.PCT_ENCODED, decodeUnreserved).toLowerCase().replace(protocol.NOT_SCHEME, "");
		    if (components.userinfo !== undefined) components.userinfo = String(components.userinfo).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(protocol.NOT_USERINFO, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
		    if (components.host !== undefined) components.host = String(components.host).replace(protocol.PCT_ENCODED, decodeUnreserved).toLowerCase().replace(protocol.NOT_HOST, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
		    if (components.path !== undefined) components.path = String(components.path).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(components.scheme ? protocol.NOT_PATH : protocol.NOT_PATH_NOSCHEME, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
		    if (components.query !== undefined) components.query = String(components.query).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(protocol.NOT_QUERY, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
		    if (components.fragment !== undefined) components.fragment = String(components.fragment).replace(protocol.PCT_ENCODED, decodeUnreserved).replace(protocol.NOT_FRAGMENT, pctEncChar).replace(protocol.PCT_ENCODED, toUpperCase);
		    return components;
		}

		function _stripLeadingZeros(str) {
		    return str.replace(/^0*(.*)/, "$1") || "0";
		}
		function _normalizeIPv4(host, protocol) {
		    var matches = host.match(protocol.IPV4ADDRESS) || [];

		    var _matches = slicedToArray(matches, 2),
		        address = _matches[1];

		    if (address) {
		        return address.split(".").map(_stripLeadingZeros).join(".");
		    } else {
		        return host;
		    }
		}
		function _normalizeIPv6(host, protocol) {
		    var matches = host.match(protocol.IPV6ADDRESS) || [];

		    var _matches2 = slicedToArray(matches, 3),
		        address = _matches2[1],
		        zone = _matches2[2];

		    if (address) {
		        var _address$toLowerCase$ = address.toLowerCase().split('::').reverse(),
		            _address$toLowerCase$2 = slicedToArray(_address$toLowerCase$, 2),
		            last = _address$toLowerCase$2[0],
		            first = _address$toLowerCase$2[1];

		        var firstFields = first ? first.split(":").map(_stripLeadingZeros) : [];
		        var lastFields = last.split(":").map(_stripLeadingZeros);
		        var isLastFieldIPv4Address = protocol.IPV4ADDRESS.test(lastFields[lastFields.length - 1]);
		        var fieldCount = isLastFieldIPv4Address ? 7 : 8;
		        var lastFieldsStart = lastFields.length - fieldCount;
		        var fields = Array(fieldCount);
		        for (var x = 0; x < fieldCount; ++x) {
		            fields[x] = firstFields[x] || lastFields[lastFieldsStart + x] || '';
		        }
		        if (isLastFieldIPv4Address) {
		            fields[fieldCount - 1] = _normalizeIPv4(fields[fieldCount - 1], protocol);
		        }
		        var allZeroFields = fields.reduce(function (acc, field, index) {
		            if (!field || field === "0") {
		                var lastLongest = acc[acc.length - 1];
		                if (lastLongest && lastLongest.index + lastLongest.length === index) {
		                    lastLongest.length++;
		                } else {
		                    acc.push({ index: index, length: 1 });
		                }
		            }
		            return acc;
		        }, []);
		        var longestZeroFields = allZeroFields.sort(function (a, b) {
		            return b.length - a.length;
		        })[0];
		        var newHost = void 0;
		        if (longestZeroFields && longestZeroFields.length > 1) {
		            var newFirst = fields.slice(0, longestZeroFields.index);
		            var newLast = fields.slice(longestZeroFields.index + longestZeroFields.length);
		            newHost = newFirst.join(":") + "::" + newLast.join(":");
		        } else {
		            newHost = fields.join(":");
		        }
		        if (zone) {
		            newHost += "%" + zone;
		        }
		        return newHost;
		    } else {
		        return host;
		    }
		}
		var URI_PARSE = /^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i;
		var NO_MATCH_IS_UNDEFINED = "".match(/(){0}/)[1] === undefined;
		function parse(uriString) {
		    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

		    var components = {};
		    var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
		    if (options.reference === "suffix") uriString = (options.scheme ? options.scheme + ":" : "") + "//" + uriString;
		    var matches = uriString.match(URI_PARSE);
		    if (matches) {
		        if (NO_MATCH_IS_UNDEFINED) {
		            //store each component
		            components.scheme = matches[1];
		            components.userinfo = matches[3];
		            components.host = matches[4];
		            components.port = parseInt(matches[5], 10);
		            components.path = matches[6] || "";
		            components.query = matches[7];
		            components.fragment = matches[8];
		            //fix port number
		            if (isNaN(components.port)) {
		                components.port = matches[5];
		            }
		        } else {
		            //IE FIX for improper RegExp matching
		            //store each component
		            components.scheme = matches[1] || undefined;
		            components.userinfo = uriString.indexOf("@") !== -1 ? matches[3] : undefined;
		            components.host = uriString.indexOf("//") !== -1 ? matches[4] : undefined;
		            components.port = parseInt(matches[5], 10);
		            components.path = matches[6] || "";
		            components.query = uriString.indexOf("?") !== -1 ? matches[7] : undefined;
		            components.fragment = uriString.indexOf("#") !== -1 ? matches[8] : undefined;
		            //fix port number
		            if (isNaN(components.port)) {
		                components.port = uriString.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/) ? matches[4] : undefined;
		            }
		        }
		        if (components.host) {
		            //normalize IP hosts
		            components.host = _normalizeIPv6(_normalizeIPv4(components.host, protocol), protocol);
		        }
		        //determine reference type
		        if (components.scheme === undefined && components.userinfo === undefined && components.host === undefined && components.port === undefined && !components.path && components.query === undefined) {
		            components.reference = "same-document";
		        } else if (components.scheme === undefined) {
		            components.reference = "relative";
		        } else if (components.fragment === undefined) {
		            components.reference = "absolute";
		        } else {
		            components.reference = "uri";
		        }
		        //check for reference errors
		        if (options.reference && options.reference !== "suffix" && options.reference !== components.reference) {
		            components.error = components.error || "URI is not a " + options.reference + " reference.";
		        }
		        //find scheme handler
		        var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
		        //check if scheme can't handle IRIs
		        if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
		            //if host component is a domain name
		            if (components.host && (options.domainHost || schemeHandler && schemeHandler.domainHost)) {
		                //convert Unicode IDN -> ASCII IDN
		                try {
		                    components.host = punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase());
		                } catch (e) {
		                    components.error = components.error || "Host's domain name can not be converted to ASCII via punycode: " + e;
		                }
		            }
		            //convert IRI -> URI
		            _normalizeComponentEncoding(components, URI_PROTOCOL);
		        } else {
		            //normalize encodings
		            _normalizeComponentEncoding(components, protocol);
		        }
		        //perform scheme specific parsing
		        if (schemeHandler && schemeHandler.parse) {
		            schemeHandler.parse(components, options);
		        }
		    } else {
		        components.error = components.error || "URI can not be parsed.";
		    }
		    return components;
		}

		function _recomposeAuthority(components, options) {
		    var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
		    var uriTokens = [];
		    if (components.userinfo !== undefined) {
		        uriTokens.push(components.userinfo);
		        uriTokens.push("@");
		    }
		    if (components.host !== undefined) {
		        //normalize IP hosts, add brackets and escape zone separator for IPv6
		        uriTokens.push(_normalizeIPv6(_normalizeIPv4(String(components.host), protocol), protocol).replace(protocol.IPV6ADDRESS, function (_, $1, $2) {
		            return "[" + $1 + ($2 ? "%25" + $2 : "") + "]";
		        }));
		    }
		    if (typeof components.port === "number" || typeof components.port === "string") {
		        uriTokens.push(":");
		        uriTokens.push(String(components.port));
		    }
		    return uriTokens.length ? uriTokens.join("") : undefined;
		}

		var RDS1 = /^\.\.?\//;
		var RDS2 = /^\/\.(\/|$)/;
		var RDS3 = /^\/\.\.(\/|$)/;
		var RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/;
		function removeDotSegments(input) {
		    var output = [];
		    while (input.length) {
		        if (input.match(RDS1)) {
		            input = input.replace(RDS1, "");
		        } else if (input.match(RDS2)) {
		            input = input.replace(RDS2, "/");
		        } else if (input.match(RDS3)) {
		            input = input.replace(RDS3, "/");
		            output.pop();
		        } else if (input === "." || input === "..") {
		            input = "";
		        } else {
		            var im = input.match(RDS5);
		            if (im) {
		                var s = im[0];
		                input = input.slice(s.length);
		                output.push(s);
		            } else {
		                throw new Error("Unexpected dot segment condition");
		            }
		        }
		    }
		    return output.join("");
		}

		function serialize(components) {
		    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

		    var protocol = options.iri ? IRI_PROTOCOL : URI_PROTOCOL;
		    var uriTokens = [];
		    //find scheme handler
		    var schemeHandler = SCHEMES[(options.scheme || components.scheme || "").toLowerCase()];
		    //perform scheme specific serialization
		    if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
		    if (components.host) {
		        //if host component is an IPv6 address
		        if (protocol.IPV6ADDRESS.test(components.host)) ;
		        //TODO: normalize IPv6 address as per RFC 5952

		        //if host component is a domain name
		        else if (options.domainHost || schemeHandler && schemeHandler.domainHost) {
		                //convert IDN via punycode
		                try {
		                    components.host = !options.iri ? punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars).toLowerCase()) : punycode.toUnicode(components.host);
		                } catch (e) {
		                    components.error = components.error || "Host's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
		                }
		            }
		    }
		    //normalize encoding
		    _normalizeComponentEncoding(components, protocol);
		    if (options.reference !== "suffix" && components.scheme) {
		        uriTokens.push(components.scheme);
		        uriTokens.push(":");
		    }
		    var authority = _recomposeAuthority(components, options);
		    if (authority !== undefined) {
		        if (options.reference !== "suffix") {
		            uriTokens.push("//");
		        }
		        uriTokens.push(authority);
		        if (components.path && components.path.charAt(0) !== "/") {
		            uriTokens.push("/");
		        }
		    }
		    if (components.path !== undefined) {
		        var s = components.path;
		        if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
		            s = removeDotSegments(s);
		        }
		        if (authority === undefined) {
		            s = s.replace(/^\/\//, "/%2F"); //don't allow the path to start with "//"
		        }
		        uriTokens.push(s);
		    }
		    if (components.query !== undefined) {
		        uriTokens.push("?");
		        uriTokens.push(components.query);
		    }
		    if (components.fragment !== undefined) {
		        uriTokens.push("#");
		        uriTokens.push(components.fragment);
		    }
		    return uriTokens.join(""); //merge tokens into a string
		}

		function resolveComponents(base, relative) {
		    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
		    var skipNormalization = arguments[3];

		    var target = {};
		    if (!skipNormalization) {
		        base = parse(serialize(base, options), options); //normalize base components
		        relative = parse(serialize(relative, options), options); //normalize relative components
		    }
		    options = options || {};
		    if (!options.tolerant && relative.scheme) {
		        target.scheme = relative.scheme;
		        //target.authority = relative.authority;
		        target.userinfo = relative.userinfo;
		        target.host = relative.host;
		        target.port = relative.port;
		        target.path = removeDotSegments(relative.path || "");
		        target.query = relative.query;
		    } else {
		        if (relative.userinfo !== undefined || relative.host !== undefined || relative.port !== undefined) {
		            //target.authority = relative.authority;
		            target.userinfo = relative.userinfo;
		            target.host = relative.host;
		            target.port = relative.port;
		            target.path = removeDotSegments(relative.path || "");
		            target.query = relative.query;
		        } else {
		            if (!relative.path) {
		                target.path = base.path;
		                if (relative.query !== undefined) {
		                    target.query = relative.query;
		                } else {
		                    target.query = base.query;
		                }
		            } else {
		                if (relative.path.charAt(0) === "/") {
		                    target.path = removeDotSegments(relative.path);
		                } else {
		                    if ((base.userinfo !== undefined || base.host !== undefined || base.port !== undefined) && !base.path) {
		                        target.path = "/" + relative.path;
		                    } else if (!base.path) {
		                        target.path = relative.path;
		                    } else {
		                        target.path = base.path.slice(0, base.path.lastIndexOf("/") + 1) + relative.path;
		                    }
		                    target.path = removeDotSegments(target.path);
		                }
		                target.query = relative.query;
		            }
		            //target.authority = base.authority;
		            target.userinfo = base.userinfo;
		            target.host = base.host;
		            target.port = base.port;
		        }
		        target.scheme = base.scheme;
		    }
		    target.fragment = relative.fragment;
		    return target;
		}

		function resolve(baseURI, relativeURI, options) {
		    var schemelessOptions = assign({ scheme: 'null' }, options);
		    return serialize(resolveComponents(parse(baseURI, schemelessOptions), parse(relativeURI, schemelessOptions), schemelessOptions, true), schemelessOptions);
		}

		function normalize(uri, options) {
		    if (typeof uri === "string") {
		        uri = serialize(parse(uri, options), options);
		    } else if (typeOf(uri) === "object") {
		        uri = parse(serialize(uri, options), options);
		    }
		    return uri;
		}

		function equal(uriA, uriB, options) {
		    if (typeof uriA === "string") {
		        uriA = serialize(parse(uriA, options), options);
		    } else if (typeOf(uriA) === "object") {
		        uriA = serialize(uriA, options);
		    }
		    if (typeof uriB === "string") {
		        uriB = serialize(parse(uriB, options), options);
		    } else if (typeOf(uriB) === "object") {
		        uriB = serialize(uriB, options);
		    }
		    return uriA === uriB;
		}

		function escapeComponent(str, options) {
		    return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.ESCAPE : IRI_PROTOCOL.ESCAPE, pctEncChar);
		}

		function unescapeComponent(str, options) {
		    return str && str.toString().replace(!options || !options.iri ? URI_PROTOCOL.PCT_ENCODED : IRI_PROTOCOL.PCT_ENCODED, pctDecChars);
		}

		var handler = {
		    scheme: "http",
		    domainHost: true,
		    parse: function parse(components, options) {
		        //report missing host
		        if (!components.host) {
		            components.error = components.error || "HTTP URIs must have a host.";
		        }
		        return components;
		    },
		    serialize: function serialize(components, options) {
		        var secure = String(components.scheme).toLowerCase() === "https";
		        //normalize the default port
		        if (components.port === (secure ? 443 : 80) || components.port === "") {
		            components.port = undefined;
		        }
		        //normalize the empty path
		        if (!components.path) {
		            components.path = "/";
		        }
		        //NOTE: We do not parse query strings for HTTP URIs
		        //as WWW Form Url Encoded query strings are part of the HTML4+ spec,
		        //and not the HTTP spec.
		        return components;
		    }
		};

		var handler$1 = {
		    scheme: "https",
		    domainHost: handler.domainHost,
		    parse: handler.parse,
		    serialize: handler.serialize
		};

		function isSecure(wsComponents) {
		    return typeof wsComponents.secure === 'boolean' ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === "wss";
		}
		//RFC 6455
		var handler$2 = {
		    scheme: "ws",
		    domainHost: true,
		    parse: function parse(components, options) {
		        var wsComponents = components;
		        //indicate if the secure flag is set
		        wsComponents.secure = isSecure(wsComponents);
		        //construct resouce name
		        wsComponents.resourceName = (wsComponents.path || '/') + (wsComponents.query ? '?' + wsComponents.query : '');
		        wsComponents.path = undefined;
		        wsComponents.query = undefined;
		        return wsComponents;
		    },
		    serialize: function serialize(wsComponents, options) {
		        //normalize the default port
		        if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === "") {
		            wsComponents.port = undefined;
		        }
		        //ensure scheme matches secure flag
		        if (typeof wsComponents.secure === 'boolean') {
		            wsComponents.scheme = wsComponents.secure ? 'wss' : 'ws';
		            wsComponents.secure = undefined;
		        }
		        //reconstruct path from resource name
		        if (wsComponents.resourceName) {
		            var _wsComponents$resourc = wsComponents.resourceName.split('?'),
		                _wsComponents$resourc2 = slicedToArray(_wsComponents$resourc, 2),
		                path = _wsComponents$resourc2[0],
		                query = _wsComponents$resourc2[1];

		            wsComponents.path = path && path !== '/' ? path : undefined;
		            wsComponents.query = query;
		            wsComponents.resourceName = undefined;
		        }
		        //forbid fragment component
		        wsComponents.fragment = undefined;
		        return wsComponents;
		    }
		};

		var handler$3 = {
		    scheme: "wss",
		    domainHost: handler$2.domainHost,
		    parse: handler$2.parse,
		    serialize: handler$2.serialize
		};

		var O = {};
		//RFC 3986
		var UNRESERVED$$ = "[A-Za-z0-9\\-\\.\\_\\~" + ("\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF" ) + "]";
		var HEXDIG$$ = "[0-9A-Fa-f]"; //case-insensitive
		var PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$)); //expanded
		//RFC 5322, except these symbols as per RFC 6068: @ : / ? # [ ] & ; =
		//const ATEXT$$ = "[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]";
		//const WSP$$ = "[\\x20\\x09]";
		//const OBS_QTEXT$$ = "[\\x01-\\x08\\x0B\\x0C\\x0E-\\x1F\\x7F]";  //(%d1-8 / %d11-12 / %d14-31 / %d127)
		//const QTEXT$$ = merge("[\\x21\\x23-\\x5B\\x5D-\\x7E]", OBS_QTEXT$$);  //%d33 / %d35-91 / %d93-126 / obs-qtext
		//const VCHAR$$ = "[\\x21-\\x7E]";
		//const WSP$$ = "[\\x20\\x09]";
		//const OBS_QP$ = subexp("\\\\" + merge("[\\x00\\x0D\\x0A]", OBS_QTEXT$$));  //%d0 / CR / LF / obs-qtext
		//const FWS$ = subexp(subexp(WSP$$ + "*" + "\\x0D\\x0A") + "?" + WSP$$ + "+");
		//const QUOTED_PAIR$ = subexp(subexp("\\\\" + subexp(VCHAR$$ + "|" + WSP$$)) + "|" + OBS_QP$);
		//const QUOTED_STRING$ = subexp('\\"' + subexp(FWS$ + "?" + QCONTENT$) + "*" + FWS$ + "?" + '\\"');
		var ATEXT$$ = "[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]";
		var QTEXT$$ = "[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]";
		var VCHAR$$ = merge(QTEXT$$, "[\\\"\\\\]");
		var SOME_DELIMS$$ = "[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]";
		var UNRESERVED = new RegExp(UNRESERVED$$, "g");
		var PCT_ENCODED = new RegExp(PCT_ENCODED$, "g");
		var NOT_LOCAL_PART = new RegExp(merge("[^]", ATEXT$$, "[\\.]", '[\\"]', VCHAR$$), "g");
		var NOT_HFNAME = new RegExp(merge("[^]", UNRESERVED$$, SOME_DELIMS$$), "g");
		var NOT_HFVALUE = NOT_HFNAME;
		function decodeUnreserved(str) {
		    var decStr = pctDecChars(str);
		    return !decStr.match(UNRESERVED) ? str : decStr;
		}
		var handler$4 = {
		    scheme: "mailto",
		    parse: function parse$$1(components, options) {
		        var mailtoComponents = components;
		        var to = mailtoComponents.to = mailtoComponents.path ? mailtoComponents.path.split(",") : [];
		        mailtoComponents.path = undefined;
		        if (mailtoComponents.query) {
		            var unknownHeaders = false;
		            var headers = {};
		            var hfields = mailtoComponents.query.split("&");
		            for (var x = 0, xl = hfields.length; x < xl; ++x) {
		                var hfield = hfields[x].split("=");
		                switch (hfield[0]) {
		                    case "to":
		                        var toAddrs = hfield[1].split(",");
		                        for (var _x = 0, _xl = toAddrs.length; _x < _xl; ++_x) {
		                            to.push(toAddrs[_x]);
		                        }
		                        break;
		                    case "subject":
		                        mailtoComponents.subject = unescapeComponent(hfield[1], options);
		                        break;
		                    case "body":
		                        mailtoComponents.body = unescapeComponent(hfield[1], options);
		                        break;
		                    default:
		                        unknownHeaders = true;
		                        headers[unescapeComponent(hfield[0], options)] = unescapeComponent(hfield[1], options);
		                        break;
		                }
		            }
		            if (unknownHeaders) mailtoComponents.headers = headers;
		        }
		        mailtoComponents.query = undefined;
		        for (var _x2 = 0, _xl2 = to.length; _x2 < _xl2; ++_x2) {
		            var addr = to[_x2].split("@");
		            addr[0] = unescapeComponent(addr[0]);
		            if (!options.unicodeSupport) {
		                //convert Unicode IDN -> ASCII IDN
		                try {
		                    addr[1] = punycode.toASCII(unescapeComponent(addr[1], options).toLowerCase());
		                } catch (e) {
		                    mailtoComponents.error = mailtoComponents.error || "Email address's domain name can not be converted to ASCII via punycode: " + e;
		                }
		            } else {
		                addr[1] = unescapeComponent(addr[1], options).toLowerCase();
		            }
		            to[_x2] = addr.join("@");
		        }
		        return mailtoComponents;
		    },
		    serialize: function serialize$$1(mailtoComponents, options) {
		        var components = mailtoComponents;
		        var to = toArray(mailtoComponents.to);
		        if (to) {
		            for (var x = 0, xl = to.length; x < xl; ++x) {
		                var toAddr = String(to[x]);
		                var atIdx = toAddr.lastIndexOf("@");
		                var localPart = toAddr.slice(0, atIdx).replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_LOCAL_PART, pctEncChar);
		                var domain = toAddr.slice(atIdx + 1);
		                //convert IDN via punycode
		                try {
		                    domain = !options.iri ? punycode.toASCII(unescapeComponent(domain, options).toLowerCase()) : punycode.toUnicode(domain);
		                } catch (e) {
		                    components.error = components.error || "Email address's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
		                }
		                to[x] = localPart + "@" + domain;
		            }
		            components.path = to.join(",");
		        }
		        var headers = mailtoComponents.headers = mailtoComponents.headers || {};
		        if (mailtoComponents.subject) headers["subject"] = mailtoComponents.subject;
		        if (mailtoComponents.body) headers["body"] = mailtoComponents.body;
		        var fields = [];
		        for (var name in headers) {
		            if (headers[name] !== O[name]) {
		                fields.push(name.replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFNAME, pctEncChar) + "=" + headers[name].replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFVALUE, pctEncChar));
		            }
		        }
		        if (fields.length) {
		            components.query = fields.join("&");
		        }
		        return components;
		    }
		};

		var URN_PARSE = /^([^\:]+)\:(.*)/;
		//RFC 2141
		var handler$5 = {
		    scheme: "urn",
		    parse: function parse$$1(components, options) {
		        var matches = components.path && components.path.match(URN_PARSE);
		        var urnComponents = components;
		        if (matches) {
		            var scheme = options.scheme || urnComponents.scheme || "urn";
		            var nid = matches[1].toLowerCase();
		            var nss = matches[2];
		            var urnScheme = scheme + ":" + (options.nid || nid);
		            var schemeHandler = SCHEMES[urnScheme];
		            urnComponents.nid = nid;
		            urnComponents.nss = nss;
		            urnComponents.path = undefined;
		            if (schemeHandler) {
		                urnComponents = schemeHandler.parse(urnComponents, options);
		            }
		        } else {
		            urnComponents.error = urnComponents.error || "URN can not be parsed.";
		        }
		        return urnComponents;
		    },
		    serialize: function serialize$$1(urnComponents, options) {
		        var scheme = options.scheme || urnComponents.scheme || "urn";
		        var nid = urnComponents.nid;
		        var urnScheme = scheme + ":" + (options.nid || nid);
		        var schemeHandler = SCHEMES[urnScheme];
		        if (schemeHandler) {
		            urnComponents = schemeHandler.serialize(urnComponents, options);
		        }
		        var uriComponents = urnComponents;
		        var nss = urnComponents.nss;
		        uriComponents.path = (nid || options.nid) + ":" + nss;
		        return uriComponents;
		    }
		};

		var UUID = /^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/;
		//RFC 4122
		var handler$6 = {
		    scheme: "urn:uuid",
		    parse: function parse(urnComponents, options) {
		        var uuidComponents = urnComponents;
		        uuidComponents.uuid = uuidComponents.nss;
		        uuidComponents.nss = undefined;
		        if (!options.tolerant && (!uuidComponents.uuid || !uuidComponents.uuid.match(UUID))) {
		            uuidComponents.error = uuidComponents.error || "UUID is not valid.";
		        }
		        return uuidComponents;
		    },
		    serialize: function serialize(uuidComponents, options) {
		        var urnComponents = uuidComponents;
		        //normalize UUID
		        urnComponents.nss = (uuidComponents.uuid || "").toLowerCase();
		        return urnComponents;
		    }
		};

		SCHEMES[handler.scheme] = handler;
		SCHEMES[handler$1.scheme] = handler$1;
		SCHEMES[handler$2.scheme] = handler$2;
		SCHEMES[handler$3.scheme] = handler$3;
		SCHEMES[handler$4.scheme] = handler$4;
		SCHEMES[handler$5.scheme] = handler$5;
		SCHEMES[handler$6.scheme] = handler$6;

		exports.SCHEMES = SCHEMES;
		exports.pctEncChar = pctEncChar;
		exports.pctDecChars = pctDecChars;
		exports.parse = parse;
		exports.removeDotSegments = removeDotSegments;
		exports.serialize = serialize;
		exports.resolveComponents = resolveComponents;
		exports.resolve = resolve;
		exports.normalize = normalize;
		exports.equal = equal;
		exports.escapeComponent = escapeComponent;
		exports.unescapeComponent = unescapeComponent;

		Object.defineProperty(exports, '__esModule', { value: true });

		})));
		
	} (uri_all, uri_all.exports));
	return uri_all.exports;
}

var fastDeepEqual;
var hasRequiredFastDeepEqual;

function requireFastDeepEqual () {
	if (hasRequiredFastDeepEqual) return fastDeepEqual;
	hasRequiredFastDeepEqual = 1;

	// do not edit .js files directly - edit src/index.jst



	fastDeepEqual = function equal(a, b) {
	  if (a === b) return true;

	  if (a && b && typeof a == 'object' && typeof b == 'object') {
	    if (a.constructor !== b.constructor) return false;

	    var length, i, keys;
	    if (Array.isArray(a)) {
	      length = a.length;
	      if (length != b.length) return false;
	      for (i = length; i-- !== 0;)
	        if (!equal(a[i], b[i])) return false;
	      return true;
	    }



	    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
	    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
	    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

	    keys = Object.keys(a);
	    length = keys.length;
	    if (length !== Object.keys(b).length) return false;

	    for (i = length; i-- !== 0;)
	      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

	    for (i = length; i-- !== 0;) {
	      var key = keys[i];

	      if (!equal(a[key], b[key])) return false;
	    }

	    return true;
	  }

	  // true if both NaN, false otherwise
	  return a!==a && b!==b;
	};
	return fastDeepEqual;
}

var ucs2length;
var hasRequiredUcs2length;

function requireUcs2length () {
	if (hasRequiredUcs2length) return ucs2length;
	hasRequiredUcs2length = 1;

	// https://mathiasbynens.be/notes/javascript-encoding
	// https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
	ucs2length = function ucs2length(str) {
	  var length = 0
	    , len = str.length
	    , pos = 0
	    , value;
	  while (pos < len) {
	    length++;
	    value = str.charCodeAt(pos++);
	    if (value >= 0xD800 && value <= 0xDBFF && pos < len) {
	      // high surrogate, and there is a next character
	      value = str.charCodeAt(pos);
	      if ((value & 0xFC00) == 0xDC00) pos++; // low surrogate
	    }
	  }
	  return length;
	};
	return ucs2length;
}

var util;
var hasRequiredUtil;

function requireUtil () {
	if (hasRequiredUtil) return util;
	hasRequiredUtil = 1;


	util = {
	  copy: copy,
	  checkDataType: checkDataType,
	  checkDataTypes: checkDataTypes,
	  coerceToTypes: coerceToTypes,
	  toHash: toHash,
	  getProperty: getProperty,
	  escapeQuotes: escapeQuotes,
	  equal: requireFastDeepEqual(),
	  ucs2length: requireUcs2length(),
	  varOccurences: varOccurences,
	  varReplace: varReplace,
	  schemaHasRules: schemaHasRules,
	  schemaHasRulesExcept: schemaHasRulesExcept,
	  schemaUnknownRules: schemaUnknownRules,
	  toQuotedString: toQuotedString,
	  getPathExpr: getPathExpr,
	  getPath: getPath,
	  getData: getData,
	  unescapeFragment: unescapeFragment,
	  unescapeJsonPointer: unescapeJsonPointer,
	  escapeFragment: escapeFragment,
	  escapeJsonPointer: escapeJsonPointer
	};


	function copy(o, to) {
	  to = to || {};
	  for (var key in o) to[key] = o[key];
	  return to;
	}


	function checkDataType(dataType, data, strictNumbers, negate) {
	  var EQUAL = negate ? ' !== ' : ' === '
	    , AND = negate ? ' || ' : ' && '
	    , OK = negate ? '!' : ''
	    , NOT = negate ? '' : '!';
	  switch (dataType) {
	    case 'null': return data + EQUAL + 'null';
	    case 'array': return OK + 'Array.isArray(' + data + ')';
	    case 'object': return '(' + OK + data + AND +
	                          'typeof ' + data + EQUAL + '"object"' + AND +
	                          NOT + 'Array.isArray(' + data + '))';
	    case 'integer': return '(typeof ' + data + EQUAL + '"number"' + AND +
	                           NOT + '(' + data + ' % 1)' +
	                           AND + data + EQUAL + data +
	                           (strictNumbers ? (AND + OK + 'isFinite(' + data + ')') : '') + ')';
	    case 'number': return '(typeof ' + data + EQUAL + '"' + dataType + '"' +
	                          (strictNumbers ? (AND + OK + 'isFinite(' + data + ')') : '') + ')';
	    default: return 'typeof ' + data + EQUAL + '"' + dataType + '"';
	  }
	}


	function checkDataTypes(dataTypes, data, strictNumbers) {
	  switch (dataTypes.length) {
	    case 1: return checkDataType(dataTypes[0], data, strictNumbers, true);
	    default:
	      var code = '';
	      var types = toHash(dataTypes);
	      if (types.array && types.object) {
	        code = types.null ? '(': '(!' + data + ' || ';
	        code += 'typeof ' + data + ' !== "object")';
	        delete types.null;
	        delete types.array;
	        delete types.object;
	      }
	      if (types.number) delete types.integer;
	      for (var t in types)
	        code += (code ? ' && ' : '' ) + checkDataType(t, data, strictNumbers, true);

	      return code;
	  }
	}


	var COERCE_TO_TYPES = toHash([ 'string', 'number', 'integer', 'boolean', 'null' ]);
	function coerceToTypes(optionCoerceTypes, dataTypes) {
	  if (Array.isArray(dataTypes)) {
	    var types = [];
	    for (var i=0; i<dataTypes.length; i++) {
	      var t = dataTypes[i];
	      if (COERCE_TO_TYPES[t]) types[types.length] = t;
	      else if (optionCoerceTypes === 'array' && t === 'array') types[types.length] = t;
	    }
	    if (types.length) return types;
	  } else if (COERCE_TO_TYPES[dataTypes]) {
	    return [dataTypes];
	  } else if (optionCoerceTypes === 'array' && dataTypes === 'array') {
	    return ['array'];
	  }
	}


	function toHash(arr) {
	  var hash = {};
	  for (var i=0; i<arr.length; i++) hash[arr[i]] = true;
	  return hash;
	}


	var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
	var SINGLE_QUOTE = /'|\\/g;
	function getProperty(key) {
	  return typeof key == 'number'
	          ? '[' + key + ']'
	          : IDENTIFIER.test(key)
	            ? '.' + key
	            : "['" + escapeQuotes(key) + "']";
	}


	function escapeQuotes(str) {
	  return str.replace(SINGLE_QUOTE, '\\$&')
	            .replace(/\n/g, '\\n')
	            .replace(/\r/g, '\\r')
	            .replace(/\f/g, '\\f')
	            .replace(/\t/g, '\\t');
	}


	function varOccurences(str, dataVar) {
	  dataVar += '[^0-9]';
	  var matches = str.match(new RegExp(dataVar, 'g'));
	  return matches ? matches.length : 0;
	}


	function varReplace(str, dataVar, expr) {
	  dataVar += '([^0-9])';
	  expr = expr.replace(/\$/g, '$$$$');
	  return str.replace(new RegExp(dataVar, 'g'), expr + '$1');
	}


	function schemaHasRules(schema, rules) {
	  if (typeof schema == 'boolean') return !schema;
	  for (var key in schema) if (rules[key]) return true;
	}


	function schemaHasRulesExcept(schema, rules, exceptKeyword) {
	  if (typeof schema == 'boolean') return !schema && exceptKeyword != 'not';
	  for (var key in schema) if (key != exceptKeyword && rules[key]) return true;
	}


	function schemaUnknownRules(schema, rules) {
	  if (typeof schema == 'boolean') return;
	  for (var key in schema) if (!rules[key]) return key;
	}


	function toQuotedString(str) {
	  return '\'' + escapeQuotes(str) + '\'';
	}


	function getPathExpr(currentPath, expr, jsonPointers, isNumber) {
	  var path = jsonPointers // false by default
	              ? '\'/\' + ' + expr + (isNumber ? '' : '.replace(/~/g, \'~0\').replace(/\\//g, \'~1\')')
	              : (isNumber ? '\'[\' + ' + expr + ' + \']\'' : '\'[\\\'\' + ' + expr + ' + \'\\\']\'');
	  return joinPaths(currentPath, path);
	}


	function getPath(currentPath, prop, jsonPointers) {
	  var path = jsonPointers // false by default
	              ? toQuotedString('/' + escapeJsonPointer(prop))
	              : toQuotedString(getProperty(prop));
	  return joinPaths(currentPath, path);
	}


	var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
	var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
	function getData($data, lvl, paths) {
	  var up, jsonPointer, data, matches;
	  if ($data === '') return 'rootData';
	  if ($data[0] == '/') {
	    if (!JSON_POINTER.test($data)) throw new Error('Invalid JSON-pointer: ' + $data);
	    jsonPointer = $data;
	    data = 'rootData';
	  } else {
	    matches = $data.match(RELATIVE_JSON_POINTER);
	    if (!matches) throw new Error('Invalid JSON-pointer: ' + $data);
	    up = +matches[1];
	    jsonPointer = matches[2];
	    if (jsonPointer == '#') {
	      if (up >= lvl) throw new Error('Cannot access property/index ' + up + ' levels up, current level is ' + lvl);
	      return paths[lvl - up];
	    }

	    if (up > lvl) throw new Error('Cannot access data ' + up + ' levels up, current level is ' + lvl);
	    data = 'data' + ((lvl - up) || '');
	    if (!jsonPointer) return data;
	  }

	  var expr = data;
	  var segments = jsonPointer.split('/');
	  for (var i=0; i<segments.length; i++) {
	    var segment = segments[i];
	    if (segment) {
	      data += getProperty(unescapeJsonPointer(segment));
	      expr += ' && ' + data;
	    }
	  }
	  return expr;
	}


	function joinPaths (a, b) {
	  if (a == '""') return b;
	  return (a + ' + ' + b).replace(/([^\\])' \+ '/g, '$1');
	}


	function unescapeFragment(str) {
	  return unescapeJsonPointer(decodeURIComponent(str));
	}


	function escapeFragment(str) {
	  return encodeURIComponent(escapeJsonPointer(str));
	}


	function escapeJsonPointer(str) {
	  return str.replace(/~/g, '~0').replace(/\//g, '~1');
	}


	function unescapeJsonPointer(str) {
	  return str.replace(/~1/g, '/').replace(/~0/g, '~');
	}
	return util;
}

var schema_obj;
var hasRequiredSchema_obj;

function requireSchema_obj () {
	if (hasRequiredSchema_obj) return schema_obj;
	hasRequiredSchema_obj = 1;

	var util = requireUtil();

	schema_obj = SchemaObject;

	function SchemaObject(obj) {
	  util.copy(obj, this);
	}
	return schema_obj;
}

var jsonSchemaTraverse = {exports: {}};

var hasRequiredJsonSchemaTraverse;

function requireJsonSchemaTraverse () {
	if (hasRequiredJsonSchemaTraverse) return jsonSchemaTraverse.exports;
	hasRequiredJsonSchemaTraverse = 1;

	var traverse = jsonSchemaTraverse.exports = function (schema, opts, cb) {
	  // Legacy support for v0.3.1 and earlier.
	  if (typeof opts == 'function') {
	    cb = opts;
	    opts = {};
	  }

	  cb = opts.cb || cb;
	  var pre = (typeof cb == 'function') ? cb : cb.pre || function() {};
	  var post = cb.post || function() {};

	  _traverse(opts, pre, post, schema, '', schema);
	};


	traverse.keywords = {
	  additionalItems: true,
	  items: true,
	  contains: true,
	  additionalProperties: true,
	  propertyNames: true,
	  not: true
	};

	traverse.arrayKeywords = {
	  items: true,
	  allOf: true,
	  anyOf: true,
	  oneOf: true
	};

	traverse.propsKeywords = {
	  definitions: true,
	  properties: true,
	  patternProperties: true,
	  dependencies: true
	};

	traverse.skipKeywords = {
	  default: true,
	  enum: true,
	  const: true,
	  required: true,
	  maximum: true,
	  minimum: true,
	  exclusiveMaximum: true,
	  exclusiveMinimum: true,
	  multipleOf: true,
	  maxLength: true,
	  minLength: true,
	  pattern: true,
	  format: true,
	  maxItems: true,
	  minItems: true,
	  uniqueItems: true,
	  maxProperties: true,
	  minProperties: true
	};


	function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
	  if (schema && typeof schema == 'object' && !Array.isArray(schema)) {
	    pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
	    for (var key in schema) {
	      var sch = schema[key];
	      if (Array.isArray(sch)) {
	        if (key in traverse.arrayKeywords) {
	          for (var i=0; i<sch.length; i++)
	            _traverse(opts, pre, post, sch[i], jsonPtr + '/' + key + '/' + i, rootSchema, jsonPtr, key, schema, i);
	        }
	      } else if (key in traverse.propsKeywords) {
	        if (sch && typeof sch == 'object') {
	          for (var prop in sch)
	            _traverse(opts, pre, post, sch[prop], jsonPtr + '/' + key + '/' + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
	        }
	      } else if (key in traverse.keywords || (opts.allKeys && !(key in traverse.skipKeywords))) {
	        _traverse(opts, pre, post, sch, jsonPtr + '/' + key, rootSchema, jsonPtr, key, schema);
	      }
	    }
	    post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
	  }
	}


	function escapeJsonPtr(str) {
	  return str.replace(/~/g, '~0').replace(/\//g, '~1');
	}
	return jsonSchemaTraverse.exports;
}

var resolve_1;
var hasRequiredResolve;

function requireResolve () {
	if (hasRequiredResolve) return resolve_1;
	hasRequiredResolve = 1;

	var URI = requireUri_all()
	  , equal = requireFastDeepEqual()
	  , util = requireUtil()
	  , SchemaObject = requireSchema_obj()
	  , traverse = requireJsonSchemaTraverse();

	resolve_1 = resolve;

	resolve.normalizeId = normalizeId;
	resolve.fullPath = getFullPath;
	resolve.url = resolveUrl;
	resolve.ids = resolveIds;
	resolve.inlineRef = inlineRef;
	resolve.schema = resolveSchema;

	/**
	 * [resolve and compile the references ($ref)]
	 * @this   Ajv
	 * @param  {Function} compile reference to schema compilation funciton (localCompile)
	 * @param  {Object} root object with information about the root schema for the current schema
	 * @param  {String} ref reference to resolve
	 * @return {Object|Function} schema object (if the schema can be inlined) or validation function
	 */
	function resolve(compile, root, ref) {
	  /* jshint validthis: true */
	  var refVal = this._refs[ref];
	  if (typeof refVal == 'string') {
	    if (this._refs[refVal]) refVal = this._refs[refVal];
	    else return resolve.call(this, compile, root, refVal);
	  }

	  refVal = refVal || this._schemas[ref];
	  if (refVal instanceof SchemaObject) {
	    return inlineRef(refVal.schema, this._opts.inlineRefs)
	            ? refVal.schema
	            : refVal.validate || this._compile(refVal);
	  }

	  var res = resolveSchema.call(this, root, ref);
	  var schema, v, baseId;
	  if (res) {
	    schema = res.schema;
	    root = res.root;
	    baseId = res.baseId;
	  }

	  if (schema instanceof SchemaObject) {
	    v = schema.validate || compile.call(this, schema.schema, root, undefined, baseId);
	  } else if (schema !== undefined) {
	    v = inlineRef(schema, this._opts.inlineRefs)
	        ? schema
	        : compile.call(this, schema, root, undefined, baseId);
	  }

	  return v;
	}


	/**
	 * Resolve schema, its root and baseId
	 * @this Ajv
	 * @param  {Object} root root object with properties schema, refVal, refs
	 * @param  {String} ref  reference to resolve
	 * @return {Object} object with properties schema, root, baseId
	 */
	function resolveSchema(root, ref) {
	  /* jshint validthis: true */
	  var p = URI.parse(ref)
	    , refPath = _getFullPath(p)
	    , baseId = getFullPath(this._getId(root.schema));
	  if (Object.keys(root.schema).length === 0 || refPath !== baseId) {
	    var id = normalizeId(refPath);
	    var refVal = this._refs[id];
	    if (typeof refVal == 'string') {
	      return resolveRecursive.call(this, root, refVal, p);
	    } else if (refVal instanceof SchemaObject) {
	      if (!refVal.validate) this._compile(refVal);
	      root = refVal;
	    } else {
	      refVal = this._schemas[id];
	      if (refVal instanceof SchemaObject) {
	        if (!refVal.validate) this._compile(refVal);
	        if (id == normalizeId(ref))
	          return { schema: refVal, root: root, baseId: baseId };
	        root = refVal;
	      } else {
	        return;
	      }
	    }
	    if (!root.schema) return;
	    baseId = getFullPath(this._getId(root.schema));
	  }
	  return getJsonPointer.call(this, p, baseId, root.schema, root);
	}


	/* @this Ajv */
	function resolveRecursive(root, ref, parsedRef) {
	  /* jshint validthis: true */
	  var res = resolveSchema.call(this, root, ref);
	  if (res) {
	    var schema = res.schema;
	    var baseId = res.baseId;
	    root = res.root;
	    var id = this._getId(schema);
	    if (id) baseId = resolveUrl(baseId, id);
	    return getJsonPointer.call(this, parsedRef, baseId, schema, root);
	  }
	}


	var PREVENT_SCOPE_CHANGE = util.toHash(['properties', 'patternProperties', 'enum', 'dependencies', 'definitions']);
	/* @this Ajv */
	function getJsonPointer(parsedRef, baseId, schema, root) {
	  /* jshint validthis: true */
	  parsedRef.fragment = parsedRef.fragment || '';
	  if (parsedRef.fragment.slice(0,1) != '/') return;
	  var parts = parsedRef.fragment.split('/');

	  for (var i = 1; i < parts.length; i++) {
	    var part = parts[i];
	    if (part) {
	      part = util.unescapeFragment(part);
	      schema = schema[part];
	      if (schema === undefined) break;
	      var id;
	      if (!PREVENT_SCOPE_CHANGE[part]) {
	        id = this._getId(schema);
	        if (id) baseId = resolveUrl(baseId, id);
	        if (schema.$ref) {
	          var $ref = resolveUrl(baseId, schema.$ref);
	          var res = resolveSchema.call(this, root, $ref);
	          if (res) {
	            schema = res.schema;
	            root = res.root;
	            baseId = res.baseId;
	          }
	        }
	      }
	    }
	  }
	  if (schema !== undefined && schema !== root.schema)
	    return { schema: schema, root: root, baseId: baseId };
	}


	var SIMPLE_INLINED = util.toHash([
	  'type', 'format', 'pattern',
	  'maxLength', 'minLength',
	  'maxProperties', 'minProperties',
	  'maxItems', 'minItems',
	  'maximum', 'minimum',
	  'uniqueItems', 'multipleOf',
	  'required', 'enum'
	]);
	function inlineRef(schema, limit) {
	  if (limit === false) return false;
	  if (limit === undefined || limit === true) return checkNoRef(schema);
	  else if (limit) return countKeys(schema) <= limit;
	}


	function checkNoRef(schema) {
	  var item;
	  if (Array.isArray(schema)) {
	    for (var i=0; i<schema.length; i++) {
	      item = schema[i];
	      if (typeof item == 'object' && !checkNoRef(item)) return false;
	    }
	  } else {
	    for (var key in schema) {
	      if (key == '$ref') return false;
	      item = schema[key];
	      if (typeof item == 'object' && !checkNoRef(item)) return false;
	    }
	  }
	  return true;
	}


	function countKeys(schema) {
	  var count = 0, item;
	  if (Array.isArray(schema)) {
	    for (var i=0; i<schema.length; i++) {
	      item = schema[i];
	      if (typeof item == 'object') count += countKeys(item);
	      if (count == Infinity) return Infinity;
	    }
	  } else {
	    for (var key in schema) {
	      if (key == '$ref') return Infinity;
	      if (SIMPLE_INLINED[key]) {
	        count++;
	      } else {
	        item = schema[key];
	        if (typeof item == 'object') count += countKeys(item) + 1;
	        if (count == Infinity) return Infinity;
	      }
	    }
	  }
	  return count;
	}


	function getFullPath(id, normalize) {
	  if (normalize !== false) id = normalizeId(id);
	  var p = URI.parse(id);
	  return _getFullPath(p);
	}


	function _getFullPath(p) {
	  return URI.serialize(p).split('#')[0] + '#';
	}


	var TRAILING_SLASH_HASH = /#\/?$/;
	function normalizeId(id) {
	  return id ? id.replace(TRAILING_SLASH_HASH, '') : '';
	}


	function resolveUrl(baseId, id) {
	  id = normalizeId(id);
	  return URI.resolve(baseId, id);
	}


	/* @this Ajv */
	function resolveIds(schema) {
	  var schemaId = normalizeId(this._getId(schema));
	  var baseIds = {'': schemaId};
	  var fullPaths = {'': getFullPath(schemaId, false)};
	  var localRefs = {};
	  var self = this;

	  traverse(schema, {allKeys: true}, function(sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
	    if (jsonPtr === '') return;
	    var id = self._getId(sch);
	    var baseId = baseIds[parentJsonPtr];
	    var fullPath = fullPaths[parentJsonPtr] + '/' + parentKeyword;
	    if (keyIndex !== undefined)
	      fullPath += '/' + (typeof keyIndex == 'number' ? keyIndex : util.escapeFragment(keyIndex));

	    if (typeof id == 'string') {
	      id = baseId = normalizeId(baseId ? URI.resolve(baseId, id) : id);

	      var refVal = self._refs[id];
	      if (typeof refVal == 'string') refVal = self._refs[refVal];
	      if (refVal && refVal.schema) {
	        if (!equal(sch, refVal.schema))
	          throw new Error('id "' + id + '" resolves to more than one schema');
	      } else if (id != normalizeId(fullPath)) {
	        if (id[0] == '#') {
	          if (localRefs[id] && !equal(sch, localRefs[id]))
	            throw new Error('id "' + id + '" resolves to more than one schema');
	          localRefs[id] = sch;
	        } else {
	          self._refs[id] = fullPath;
	        }
	      }
	    }
	    baseIds[jsonPtr] = baseId;
	    fullPaths[jsonPtr] = fullPath;
	  });

	  return localRefs;
	}
	return resolve_1;
}

var error_classes;
var hasRequiredError_classes;

function requireError_classes () {
	if (hasRequiredError_classes) return error_classes;
	hasRequiredError_classes = 1;

	var resolve = requireResolve();

	error_classes = {
	  Validation: errorSubclass(ValidationError),
	  MissingRef: errorSubclass(MissingRefError)
	};


	function ValidationError(errors) {
	  this.message = 'validation failed';
	  this.errors = errors;
	  this.ajv = this.validation = true;
	}


	MissingRefError.message = function (baseId, ref) {
	  return 'can\'t resolve reference ' + ref + ' from id ' + baseId;
	};


	function MissingRefError(baseId, ref, message) {
	  this.message = message || MissingRefError.message(baseId, ref);
	  this.missingRef = resolve.url(baseId, ref);
	  this.missingSchema = resolve.normalizeId(resolve.fullPath(this.missingRef));
	}


	function errorSubclass(Subclass) {
	  Subclass.prototype = Object.create(Error.prototype);
	  Subclass.prototype.constructor = Subclass;
	  return Subclass;
	}
	return error_classes;
}

var fastJsonStableStringify;
var hasRequiredFastJsonStableStringify;

function requireFastJsonStableStringify () {
	if (hasRequiredFastJsonStableStringify) return fastJsonStableStringify;
	hasRequiredFastJsonStableStringify = 1;

	fastJsonStableStringify = function (data, opts) {
	    if (!opts) opts = {};
	    if (typeof opts === 'function') opts = { cmp: opts };
	    var cycles = (typeof opts.cycles === 'boolean') ? opts.cycles : false;

	    var cmp = opts.cmp && (function (f) {
	        return function (node) {
	            return function (a, b) {
	                var aobj = { key: a, value: node[a] };
	                var bobj = { key: b, value: node[b] };
	                return f(aobj, bobj);
	            };
	        };
	    })(opts.cmp);

	    var seen = [];
	    return (function stringify (node) {
	        if (node && node.toJSON && typeof node.toJSON === 'function') {
	            node = node.toJSON();
	        }

	        if (node === undefined) return;
	        if (typeof node == 'number') return isFinite(node) ? '' + node : 'null';
	        if (typeof node !== 'object') return JSON.stringify(node);

	        var i, out;
	        if (Array.isArray(node)) {
	            out = '[';
	            for (i = 0; i < node.length; i++) {
	                if (i) out += ',';
	                out += stringify(node[i]) || 'null';
	            }
	            return out + ']';
	        }

	        if (node === null) return 'null';

	        if (seen.indexOf(node) !== -1) {
	            if (cycles) return JSON.stringify('__cycle__');
	            throw new TypeError('Converting circular structure to JSON');
	        }

	        var seenIndex = seen.push(node) - 1;
	        var keys = Object.keys(node).sort(cmp && cmp(node));
	        out = '';
	        for (i = 0; i < keys.length; i++) {
	            var key = keys[i];
	            var value = stringify(node[key]);

	            if (!value) continue;
	            if (out) out += ',';
	            out += JSON.stringify(key) + ':' + value;
	        }
	        seen.splice(seenIndex, 1);
	        return '{' + out + '}';
	    })(data);
	};
	return fastJsonStableStringify;
}

var validate;
var hasRequiredValidate;

function requireValidate () {
	if (hasRequiredValidate) return validate;
	hasRequiredValidate = 1;
	validate = function generate_validate(it, $keyword, $ruleType) {
	  var out = '';
	  var $async = it.schema.$async === true,
	    $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, '$ref'),
	    $id = it.self._getId(it.schema);
	  if (it.opts.strictKeywords) {
	    var $unknownKwd = it.util.schemaUnknownRules(it.schema, it.RULES.keywords);
	    if ($unknownKwd) {
	      var $keywordsMsg = 'unknown keyword: ' + $unknownKwd;
	      if (it.opts.strictKeywords === 'log') it.logger.warn($keywordsMsg);
	      else throw new Error($keywordsMsg);
	    }
	  }
	  if (it.isTop) {
	    out += ' var validate = ';
	    if ($async) {
	      it.async = true;
	      out += 'async ';
	    }
	    out += 'function(data, dataPath, parentData, parentDataProperty, rootData) { \'use strict\'; ';
	    if ($id && (it.opts.sourceCode || it.opts.processCode)) {
	      out += ' ' + ('/\*# sourceURL=' + $id + ' */') + ' ';
	    }
	  }
	  if (typeof it.schema == 'boolean' || !($refKeywords || it.schema.$ref)) {
	    var $keyword = 'false schema';
	    var $lvl = it.level;
	    var $dataLvl = it.dataLevel;
	    var $schema = it.schema[$keyword];
	    var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	    var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	    var $breakOnError = !it.opts.allErrors;
	    var $errorKeyword;
	    var $data = 'data' + ($dataLvl || '');
	    var $valid = 'valid' + $lvl;
	    if (it.schema === false) {
	      if (it.isTop) {
	        $breakOnError = true;
	      } else {
	        out += ' var ' + ($valid) + ' = false; ';
	      }
	      var $$outStack = $$outStack || [];
	      $$outStack.push(out);
	      out = ''; /* istanbul ignore else */
	      if (it.createErrors !== false) {
	        out += ' { keyword: \'' + ($errorKeyword || 'false schema') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
	        if (it.opts.messages !== false) {
	          out += ' , message: \'boolean schema is false\' ';
	        }
	        if (it.opts.verbose) {
	          out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	        }
	        out += ' } ';
	      } else {
	        out += ' {} ';
	      }
	      var __err = out;
	      out = $$outStack.pop();
	      if (!it.compositeRule && $breakOnError) {
	        /* istanbul ignore if */
	        if (it.async) {
	          out += ' throw new ValidationError([' + (__err) + ']); ';
	        } else {
	          out += ' validate.errors = [' + (__err) + ']; return false; ';
	        }
	      } else {
	        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	      }
	    } else {
	      if (it.isTop) {
	        if ($async) {
	          out += ' return data; ';
	        } else {
	          out += ' validate.errors = null; return true; ';
	        }
	      } else {
	        out += ' var ' + ($valid) + ' = true; ';
	      }
	    }
	    if (it.isTop) {
	      out += ' }; return validate; ';
	    }
	    return out;
	  }
	  if (it.isTop) {
	    var $top = it.isTop,
	      $lvl = it.level = 0,
	      $dataLvl = it.dataLevel = 0,
	      $data = 'data';
	    it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
	    it.baseId = it.baseId || it.rootId;
	    delete it.isTop;
	    it.dataPathArr = [""];
	    if (it.schema.default !== undefined && it.opts.useDefaults && it.opts.strictDefaults) {
	      var $defaultMsg = 'default is ignored in the schema root';
	      if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
	      else throw new Error($defaultMsg);
	    }
	    out += ' var vErrors = null; ';
	    out += ' var errors = 0;     ';
	    out += ' if (rootData === undefined) rootData = data; ';
	  } else {
	    var $lvl = it.level,
	      $dataLvl = it.dataLevel,
	      $data = 'data' + ($dataLvl || '');
	    if ($id) it.baseId = it.resolve.url(it.baseId, $id);
	    if ($async && !it.async) throw new Error('async schema in sync schema');
	    out += ' var errs_' + ($lvl) + ' = errors;';
	  }
	  var $valid = 'valid' + $lvl,
	    $breakOnError = !it.opts.allErrors,
	    $closingBraces1 = '',
	    $closingBraces2 = '';
	  var $errorKeyword;
	  var $typeSchema = it.schema.type,
	    $typeIsArray = Array.isArray($typeSchema);
	  if ($typeSchema && it.opts.nullable && it.schema.nullable === true) {
	    if ($typeIsArray) {
	      if ($typeSchema.indexOf('null') == -1) $typeSchema = $typeSchema.concat('null');
	    } else if ($typeSchema != 'null') {
	      $typeSchema = [$typeSchema, 'null'];
	      $typeIsArray = true;
	    }
	  }
	  if ($typeIsArray && $typeSchema.length == 1) {
	    $typeSchema = $typeSchema[0];
	    $typeIsArray = false;
	  }
	  if (it.schema.$ref && $refKeywords) {
	    if (it.opts.extendRefs == 'fail') {
	      throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
	    } else if (it.opts.extendRefs !== true) {
	      $refKeywords = false;
	      it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
	    }
	  }
	  if (it.schema.$comment && it.opts.$comment) {
	    out += ' ' + (it.RULES.all.$comment.code(it, '$comment'));
	  }
	  if ($typeSchema) {
	    if (it.opts.coerceTypes) {
	      var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
	    }
	    var $rulesGroup = it.RULES.types[$typeSchema];
	    if ($coerceToTypes || $typeIsArray || $rulesGroup === true || ($rulesGroup && !$shouldUseGroup($rulesGroup))) {
	      var $schemaPath = it.schemaPath + '.type',
	        $errSchemaPath = it.errSchemaPath + '/type';
	      var $schemaPath = it.schemaPath + '.type',
	        $errSchemaPath = it.errSchemaPath + '/type',
	        $method = $typeIsArray ? 'checkDataTypes' : 'checkDataType';
	      out += ' if (' + (it.util[$method]($typeSchema, $data, it.opts.strictNumbers, true)) + ') { ';
	      if ($coerceToTypes) {
	        var $dataType = 'dataType' + $lvl,
	          $coerced = 'coerced' + $lvl;
	        out += ' var ' + ($dataType) + ' = typeof ' + ($data) + '; var ' + ($coerced) + ' = undefined; ';
	        if (it.opts.coerceTypes == 'array') {
	          out += ' if (' + ($dataType) + ' == \'object\' && Array.isArray(' + ($data) + ') && ' + ($data) + '.length == 1) { ' + ($data) + ' = ' + ($data) + '[0]; ' + ($dataType) + ' = typeof ' + ($data) + '; if (' + (it.util.checkDataType(it.schema.type, $data, it.opts.strictNumbers)) + ') ' + ($coerced) + ' = ' + ($data) + '; } ';
	        }
	        out += ' if (' + ($coerced) + ' !== undefined) ; ';
	        var arr1 = $coerceToTypes;
	        if (arr1) {
	          var $type, $i = -1,
	            l1 = arr1.length - 1;
	          while ($i < l1) {
	            $type = arr1[$i += 1];
	            if ($type == 'string') {
	              out += ' else if (' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\') ' + ($coerced) + ' = \'\' + ' + ($data) + '; else if (' + ($data) + ' === null) ' + ($coerced) + ' = \'\'; ';
	            } else if ($type == 'number' || $type == 'integer') {
	              out += ' else if (' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' === null || (' + ($dataType) + ' == \'string\' && ' + ($data) + ' && ' + ($data) + ' == +' + ($data) + ' ';
	              if ($type == 'integer') {
	                out += ' && !(' + ($data) + ' % 1)';
	              }
	              out += ')) ' + ($coerced) + ' = +' + ($data) + '; ';
	            } else if ($type == 'boolean') {
	              out += ' else if (' + ($data) + ' === \'false\' || ' + ($data) + ' === 0 || ' + ($data) + ' === null) ' + ($coerced) + ' = false; else if (' + ($data) + ' === \'true\' || ' + ($data) + ' === 1) ' + ($coerced) + ' = true; ';
	            } else if ($type == 'null') {
	              out += ' else if (' + ($data) + ' === \'\' || ' + ($data) + ' === 0 || ' + ($data) + ' === false) ' + ($coerced) + ' = null; ';
	            } else if (it.opts.coerceTypes == 'array' && $type == 'array') {
	              out += ' else if (' + ($dataType) + ' == \'string\' || ' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' == null) ' + ($coerced) + ' = [' + ($data) + ']; ';
	            }
	          }
	        }
	        out += ' else {   ';
	        var $$outStack = $$outStack || [];
	        $$outStack.push(out);
	        out = ''; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
	          if ($typeIsArray) {
	            out += '' + ($typeSchema.join(","));
	          } else {
	            out += '' + ($typeSchema);
	          }
	          out += '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'should be ';
	            if ($typeIsArray) {
	              out += '' + ($typeSchema.join(","));
	            } else {
	              out += '' + ($typeSchema);
	            }
	            out += '\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        var __err = out;
	        out = $$outStack.pop();
	        if (!it.compositeRule && $breakOnError) {
	          /* istanbul ignore if */
	          if (it.async) {
	            out += ' throw new ValidationError([' + (__err) + ']); ';
	          } else {
	            out += ' validate.errors = [' + (__err) + ']; return false; ';
	          }
	        } else {
	          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	        }
	        out += ' } if (' + ($coerced) + ' !== undefined) {  ';
	        var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
	          $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
	        out += ' ' + ($data) + ' = ' + ($coerced) + '; ';
	        if (!$dataLvl) {
	          out += 'if (' + ($parentData) + ' !== undefined)';
	        }
	        out += ' ' + ($parentData) + '[' + ($parentDataProperty) + '] = ' + ($coerced) + '; } ';
	      } else {
	        var $$outStack = $$outStack || [];
	        $$outStack.push(out);
	        out = ''; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
	          if ($typeIsArray) {
	            out += '' + ($typeSchema.join(","));
	          } else {
	            out += '' + ($typeSchema);
	          }
	          out += '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'should be ';
	            if ($typeIsArray) {
	              out += '' + ($typeSchema.join(","));
	            } else {
	              out += '' + ($typeSchema);
	            }
	            out += '\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        var __err = out;
	        out = $$outStack.pop();
	        if (!it.compositeRule && $breakOnError) {
	          /* istanbul ignore if */
	          if (it.async) {
	            out += ' throw new ValidationError([' + (__err) + ']); ';
	          } else {
	            out += ' validate.errors = [' + (__err) + ']; return false; ';
	          }
	        } else {
	          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	        }
	      }
	      out += ' } ';
	    }
	  }
	  if (it.schema.$ref && !$refKeywords) {
	    out += ' ' + (it.RULES.all.$ref.code(it, '$ref')) + ' ';
	    if ($breakOnError) {
	      out += ' } if (errors === ';
	      if ($top) {
	        out += '0';
	      } else {
	        out += 'errs_' + ($lvl);
	      }
	      out += ') { ';
	      $closingBraces2 += '}';
	    }
	  } else {
	    var arr2 = it.RULES;
	    if (arr2) {
	      var $rulesGroup, i2 = -1,
	        l2 = arr2.length - 1;
	      while (i2 < l2) {
	        $rulesGroup = arr2[i2 += 1];
	        if ($shouldUseGroup($rulesGroup)) {
	          if ($rulesGroup.type) {
	            out += ' if (' + (it.util.checkDataType($rulesGroup.type, $data, it.opts.strictNumbers)) + ') { ';
	          }
	          if (it.opts.useDefaults) {
	            if ($rulesGroup.type == 'object' && it.schema.properties) {
	              var $schema = it.schema.properties,
	                $schemaKeys = Object.keys($schema);
	              var arr3 = $schemaKeys;
	              if (arr3) {
	                var $propertyKey, i3 = -1,
	                  l3 = arr3.length - 1;
	                while (i3 < l3) {
	                  $propertyKey = arr3[i3 += 1];
	                  var $sch = $schema[$propertyKey];
	                  if ($sch.default !== undefined) {
	                    var $passData = $data + it.util.getProperty($propertyKey);
	                    if (it.compositeRule) {
	                      if (it.opts.strictDefaults) {
	                        var $defaultMsg = 'default is ignored for: ' + $passData;
	                        if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
	                        else throw new Error($defaultMsg);
	                      }
	                    } else {
	                      out += ' if (' + ($passData) + ' === undefined ';
	                      if (it.opts.useDefaults == 'empty') {
	                        out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
	                      }
	                      out += ' ) ' + ($passData) + ' = ';
	                      if (it.opts.useDefaults == 'shared') {
	                        out += ' ' + (it.useDefault($sch.default)) + ' ';
	                      } else {
	                        out += ' ' + (JSON.stringify($sch.default)) + ' ';
	                      }
	                      out += '; ';
	                    }
	                  }
	                }
	              }
	            } else if ($rulesGroup.type == 'array' && Array.isArray(it.schema.items)) {
	              var arr4 = it.schema.items;
	              if (arr4) {
	                var $sch, $i = -1,
	                  l4 = arr4.length - 1;
	                while ($i < l4) {
	                  $sch = arr4[$i += 1];
	                  if ($sch.default !== undefined) {
	                    var $passData = $data + '[' + $i + ']';
	                    if (it.compositeRule) {
	                      if (it.opts.strictDefaults) {
	                        var $defaultMsg = 'default is ignored for: ' + $passData;
	                        if (it.opts.strictDefaults === 'log') it.logger.warn($defaultMsg);
	                        else throw new Error($defaultMsg);
	                      }
	                    } else {
	                      out += ' if (' + ($passData) + ' === undefined ';
	                      if (it.opts.useDefaults == 'empty') {
	                        out += ' || ' + ($passData) + ' === null || ' + ($passData) + ' === \'\' ';
	                      }
	                      out += ' ) ' + ($passData) + ' = ';
	                      if (it.opts.useDefaults == 'shared') {
	                        out += ' ' + (it.useDefault($sch.default)) + ' ';
	                      } else {
	                        out += ' ' + (JSON.stringify($sch.default)) + ' ';
	                      }
	                      out += '; ';
	                    }
	                  }
	                }
	              }
	            }
	          }
	          var arr5 = $rulesGroup.rules;
	          if (arr5) {
	            var $rule, i5 = -1,
	              l5 = arr5.length - 1;
	            while (i5 < l5) {
	              $rule = arr5[i5 += 1];
	              if ($shouldUseRule($rule)) {
	                var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
	                if ($code) {
	                  out += ' ' + ($code) + ' ';
	                  if ($breakOnError) {
	                    $closingBraces1 += '}';
	                  }
	                }
	              }
	            }
	          }
	          if ($breakOnError) {
	            out += ' ' + ($closingBraces1) + ' ';
	            $closingBraces1 = '';
	          }
	          if ($rulesGroup.type) {
	            out += ' } ';
	            if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
	              out += ' else { ';
	              var $schemaPath = it.schemaPath + '.type',
	                $errSchemaPath = it.errSchemaPath + '/type';
	              var $$outStack = $$outStack || [];
	              $$outStack.push(out);
	              out = ''; /* istanbul ignore else */
	              if (it.createErrors !== false) {
	                out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
	                if ($typeIsArray) {
	                  out += '' + ($typeSchema.join(","));
	                } else {
	                  out += '' + ($typeSchema);
	                }
	                out += '\' } ';
	                if (it.opts.messages !== false) {
	                  out += ' , message: \'should be ';
	                  if ($typeIsArray) {
	                    out += '' + ($typeSchema.join(","));
	                  } else {
	                    out += '' + ($typeSchema);
	                  }
	                  out += '\' ';
	                }
	                if (it.opts.verbose) {
	                  out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	                }
	                out += ' } ';
	              } else {
	                out += ' {} ';
	              }
	              var __err = out;
	              out = $$outStack.pop();
	              if (!it.compositeRule && $breakOnError) {
	                /* istanbul ignore if */
	                if (it.async) {
	                  out += ' throw new ValidationError([' + (__err) + ']); ';
	                } else {
	                  out += ' validate.errors = [' + (__err) + ']; return false; ';
	                }
	              } else {
	                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	              }
	              out += ' } ';
	            }
	          }
	          if ($breakOnError) {
	            out += ' if (errors === ';
	            if ($top) {
	              out += '0';
	            } else {
	              out += 'errs_' + ($lvl);
	            }
	            out += ') { ';
	            $closingBraces2 += '}';
	          }
	        }
	      }
	    }
	  }
	  if ($breakOnError) {
	    out += ' ' + ($closingBraces2) + ' ';
	  }
	  if ($top) {
	    if ($async) {
	      out += ' if (errors === 0) return data;           ';
	      out += ' else throw new ValidationError(vErrors); ';
	    } else {
	      out += ' validate.errors = vErrors; ';
	      out += ' return errors === 0;       ';
	    }
	    out += ' }; return validate;';
	  } else {
	    out += ' var ' + ($valid) + ' = errors === errs_' + ($lvl) + ';';
	  }

	  function $shouldUseGroup($rulesGroup) {
	    var rules = $rulesGroup.rules;
	    for (var i = 0; i < rules.length; i++)
	      if ($shouldUseRule(rules[i])) return true;
	  }

	  function $shouldUseRule($rule) {
	    return it.schema[$rule.keyword] !== undefined || ($rule.implements && $ruleImplementsSomeKeyword($rule));
	  }

	  function $ruleImplementsSomeKeyword($rule) {
	    var impl = $rule.implements;
	    for (var i = 0; i < impl.length; i++)
	      if (it.schema[impl[i]] !== undefined) return true;
	  }
	  return out;
	};
	return validate;
}

var compile_1;
var hasRequiredCompile;

function requireCompile () {
	if (hasRequiredCompile) return compile_1;
	hasRequiredCompile = 1;

	var resolve = requireResolve()
	  , util = requireUtil()
	  , errorClasses = requireError_classes()
	  , stableStringify = requireFastJsonStableStringify();

	var validateGenerator = requireValidate();

	/**
	 * Functions below are used inside compiled validations function
	 */

	var ucs2length = util.ucs2length;
	var equal = requireFastDeepEqual();

	// this error is thrown by async schemas to return validation errors via exception
	var ValidationError = errorClasses.Validation;

	compile_1 = compile;


	/**
	 * Compiles schema to validation function
	 * @this   Ajv
	 * @param  {Object} schema schema object
	 * @param  {Object} root object with information about the root schema for this schema
	 * @param  {Object} localRefs the hash of local references inside the schema (created by resolve.id), used for inline resolution
	 * @param  {String} baseId base ID for IDs in the schema
	 * @return {Function} validation function
	 */
	function compile(schema, root, localRefs, baseId) {
	  /* jshint validthis: true, evil: true */
	  /* eslint no-shadow: 0 */
	  var self = this
	    , opts = this._opts
	    , refVal = [ undefined ]
	    , refs = {}
	    , patterns = []
	    , patternsHash = {}
	    , defaults = []
	    , defaultsHash = {}
	    , customRules = [];

	  root = root || { schema: schema, refVal: refVal, refs: refs };

	  var c = checkCompiling.call(this, schema, root, baseId);
	  var compilation = this._compilations[c.index];
	  if (c.compiling) return (compilation.callValidate = callValidate);

	  var formats = this._formats;
	  var RULES = this.RULES;

	  try {
	    var v = localCompile(schema, root, localRefs, baseId);
	    compilation.validate = v;
	    var cv = compilation.callValidate;
	    if (cv) {
	      cv.schema = v.schema;
	      cv.errors = null;
	      cv.refs = v.refs;
	      cv.refVal = v.refVal;
	      cv.root = v.root;
	      cv.$async = v.$async;
	      if (opts.sourceCode) cv.source = v.source;
	    }
	    return v;
	  } finally {
	    endCompiling.call(this, schema, root, baseId);
	  }

	  /* @this   {*} - custom context, see passContext option */
	  function callValidate() {
	    /* jshint validthis: true */
	    var validate = compilation.validate;
	    var result = validate.apply(this, arguments);
	    callValidate.errors = validate.errors;
	    return result;
	  }

	  function localCompile(_schema, _root, localRefs, baseId) {
	    var isRoot = !_root || (_root && _root.schema == _schema);
	    if (_root.schema != root.schema)
	      return compile.call(self, _schema, _root, localRefs, baseId);

	    var $async = _schema.$async === true;

	    var sourceCode = validateGenerator({
	      isTop: true,
	      schema: _schema,
	      isRoot: isRoot,
	      baseId: baseId,
	      root: _root,
	      schemaPath: '',
	      errSchemaPath: '#',
	      errorPath: '""',
	      MissingRefError: errorClasses.MissingRef,
	      RULES: RULES,
	      validate: validateGenerator,
	      util: util,
	      resolve: resolve,
	      resolveRef: resolveRef,
	      usePattern: usePattern,
	      useDefault: useDefault,
	      useCustomRule: useCustomRule,
	      opts: opts,
	      formats: formats,
	      logger: self.logger,
	      self: self
	    });

	    sourceCode = vars(refVal, refValCode) + vars(patterns, patternCode)
	                   + vars(defaults, defaultCode) + vars(customRules, customRuleCode)
	                   + sourceCode;

	    if (opts.processCode) sourceCode = opts.processCode(sourceCode, _schema);
	    // console.log('\n\n\n *** \n', JSON.stringify(sourceCode));
	    var validate;
	    try {
	      var makeValidate = new Function(
	        'self',
	        'RULES',
	        'formats',
	        'root',
	        'refVal',
	        'defaults',
	        'customRules',
	        'equal',
	        'ucs2length',
	        'ValidationError',
	        sourceCode
	      );

	      validate = makeValidate(
	        self,
	        RULES,
	        formats,
	        root,
	        refVal,
	        defaults,
	        customRules,
	        equal,
	        ucs2length,
	        ValidationError
	      );

	      refVal[0] = validate;
	    } catch(e) {
	      self.logger.error('Error compiling schema, function code:', sourceCode);
	      throw e;
	    }

	    validate.schema = _schema;
	    validate.errors = null;
	    validate.refs = refs;
	    validate.refVal = refVal;
	    validate.root = isRoot ? validate : _root;
	    if ($async) validate.$async = true;
	    if (opts.sourceCode === true) {
	      validate.source = {
	        code: sourceCode,
	        patterns: patterns,
	        defaults: defaults
	      };
	    }

	    return validate;
	  }

	  function resolveRef(baseId, ref, isRoot) {
	    ref = resolve.url(baseId, ref);
	    var refIndex = refs[ref];
	    var _refVal, refCode;
	    if (refIndex !== undefined) {
	      _refVal = refVal[refIndex];
	      refCode = 'refVal[' + refIndex + ']';
	      return resolvedRef(_refVal, refCode);
	    }
	    if (!isRoot && root.refs) {
	      var rootRefId = root.refs[ref];
	      if (rootRefId !== undefined) {
	        _refVal = root.refVal[rootRefId];
	        refCode = addLocalRef(ref, _refVal);
	        return resolvedRef(_refVal, refCode);
	      }
	    }

	    refCode = addLocalRef(ref);
	    var v = resolve.call(self, localCompile, root, ref);
	    if (v === undefined) {
	      var localSchema = localRefs && localRefs[ref];
	      if (localSchema) {
	        v = resolve.inlineRef(localSchema, opts.inlineRefs)
	            ? localSchema
	            : compile.call(self, localSchema, root, localRefs, baseId);
	      }
	    }

	    if (v === undefined) {
	      removeLocalRef(ref);
	    } else {
	      replaceLocalRef(ref, v);
	      return resolvedRef(v, refCode);
	    }
	  }

	  function addLocalRef(ref, v) {
	    var refId = refVal.length;
	    refVal[refId] = v;
	    refs[ref] = refId;
	    return 'refVal' + refId;
	  }

	  function removeLocalRef(ref) {
	    delete refs[ref];
	  }

	  function replaceLocalRef(ref, v) {
	    var refId = refs[ref];
	    refVal[refId] = v;
	  }

	  function resolvedRef(refVal, code) {
	    return typeof refVal == 'object' || typeof refVal == 'boolean'
	            ? { code: code, schema: refVal, inline: true }
	            : { code: code, $async: refVal && !!refVal.$async };
	  }

	  function usePattern(regexStr) {
	    var index = patternsHash[regexStr];
	    if (index === undefined) {
	      index = patternsHash[regexStr] = patterns.length;
	      patterns[index] = regexStr;
	    }
	    return 'pattern' + index;
	  }

	  function useDefault(value) {
	    switch (typeof value) {
	      case 'boolean':
	      case 'number':
	        return '' + value;
	      case 'string':
	        return util.toQuotedString(value);
	      case 'object':
	        if (value === null) return 'null';
	        var valueStr = stableStringify(value);
	        var index = defaultsHash[valueStr];
	        if (index === undefined) {
	          index = defaultsHash[valueStr] = defaults.length;
	          defaults[index] = value;
	        }
	        return 'default' + index;
	    }
	  }

	  function useCustomRule(rule, schema, parentSchema, it) {
	    if (self._opts.validateSchema !== false) {
	      var deps = rule.definition.dependencies;
	      if (deps && !deps.every(function(keyword) {
	        return Object.prototype.hasOwnProperty.call(parentSchema, keyword);
	      }))
	        throw new Error('parent schema must have all required keywords: ' + deps.join(','));

	      var validateSchema = rule.definition.validateSchema;
	      if (validateSchema) {
	        var valid = validateSchema(schema);
	        if (!valid) {
	          var message = 'keyword schema is invalid: ' + self.errorsText(validateSchema.errors);
	          if (self._opts.validateSchema == 'log') self.logger.error(message);
	          else throw new Error(message);
	        }
	      }
	    }

	    var compile = rule.definition.compile
	      , inline = rule.definition.inline
	      , macro = rule.definition.macro;

	    var validate;
	    if (compile) {
	      validate = compile.call(self, schema, parentSchema, it);
	    } else if (macro) {
	      validate = macro.call(self, schema, parentSchema, it);
	      if (opts.validateSchema !== false) self.validateSchema(validate, true);
	    } else if (inline) {
	      validate = inline.call(self, it, rule.keyword, schema, parentSchema);
	    } else {
	      validate = rule.definition.validate;
	      if (!validate) return;
	    }

	    if (validate === undefined)
	      throw new Error('custom keyword "' + rule.keyword + '"failed to compile');

	    var index = customRules.length;
	    customRules[index] = validate;

	    return {
	      code: 'customRule' + index,
	      validate: validate
	    };
	  }
	}


	/**
	 * Checks if the schema is currently compiled
	 * @this   Ajv
	 * @param  {Object} schema schema to compile
	 * @param  {Object} root root object
	 * @param  {String} baseId base schema ID
	 * @return {Object} object with properties "index" (compilation index) and "compiling" (boolean)
	 */
	function checkCompiling(schema, root, baseId) {
	  /* jshint validthis: true */
	  var index = compIndex.call(this, schema, root, baseId);
	  if (index >= 0) return { index: index, compiling: true };
	  index = this._compilations.length;
	  this._compilations[index] = {
	    schema: schema,
	    root: root,
	    baseId: baseId
	  };
	  return { index: index, compiling: false };
	}


	/**
	 * Removes the schema from the currently compiled list
	 * @this   Ajv
	 * @param  {Object} schema schema to compile
	 * @param  {Object} root root object
	 * @param  {String} baseId base schema ID
	 */
	function endCompiling(schema, root, baseId) {
	  /* jshint validthis: true */
	  var i = compIndex.call(this, schema, root, baseId);
	  if (i >= 0) this._compilations.splice(i, 1);
	}


	/**
	 * Index of schema compilation in the currently compiled list
	 * @this   Ajv
	 * @param  {Object} schema schema to compile
	 * @param  {Object} root root object
	 * @param  {String} baseId base schema ID
	 * @return {Integer} compilation index
	 */
	function compIndex(schema, root, baseId) {
	  /* jshint validthis: true */
	  for (var i=0; i<this._compilations.length; i++) {
	    var c = this._compilations[i];
	    if (c.schema == schema && c.root == root && c.baseId == baseId) return i;
	  }
	  return -1;
	}


	function patternCode(i, patterns) {
	  return 'var pattern' + i + ' = new RegExp(' + util.toQuotedString(patterns[i]) + ');';
	}


	function defaultCode(i) {
	  return 'var default' + i + ' = defaults[' + i + '];';
	}


	function refValCode(i, refVal) {
	  return refVal[i] === undefined ? '' : 'var refVal' + i + ' = refVal[' + i + '];';
	}


	function customRuleCode(i) {
	  return 'var customRule' + i + ' = customRules[' + i + '];';
	}


	function vars(arr, statement) {
	  if (!arr.length) return '';
	  var code = '';
	  for (var i=0; i<arr.length; i++)
	    code += statement(i, arr);
	  return code;
	}
	return compile_1;
}

var cache = {exports: {}};

var hasRequiredCache;

function requireCache () {
	if (hasRequiredCache) return cache.exports;
	hasRequiredCache = 1;


	var Cache = cache.exports = function Cache() {
	  this._cache = {};
	};


	Cache.prototype.put = function Cache_put(key, value) {
	  this._cache[key] = value;
	};


	Cache.prototype.get = function Cache_get(key) {
	  return this._cache[key];
	};


	Cache.prototype.del = function Cache_del(key) {
	  delete this._cache[key];
	};


	Cache.prototype.clear = function Cache_clear() {
	  this._cache = {};
	};
	return cache.exports;
}

var formats_1;
var hasRequiredFormats;

function requireFormats () {
	if (hasRequiredFormats) return formats_1;
	hasRequiredFormats = 1;

	var util = requireUtil();

	var DATE = /^(\d\d\d\d)-(\d\d)-(\d\d)$/;
	var DAYS = [0,31,28,31,30,31,30,31,31,30,31,30,31];
	var TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d(?::?\d\d)?)?$/i;
	var HOSTNAME = /^(?=.{1,253}\.?$)[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*\.?$/i;
	var URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
	var URIREF = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
	// uri-template: https://tools.ietf.org/html/rfc6570
	var URITEMPLATE = /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;
	// For the source: https://gist.github.com/dperini/729294
	// For test cases: https://mathiasbynens.be/demo/url-regex
	// @todo Delete current URL in favour of the commented out URL rule when this issue is fixed https://github.com/eslint/eslint/issues/7983.
	// var URL = /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u{00a1}-\u{ffff}0-9]+-)*[a-z\u{00a1}-\u{ffff}0-9]+)(?:\.(?:[a-z\u{00a1}-\u{ffff}0-9]+-)*[a-z\u{00a1}-\u{ffff}0-9]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu;
	var URL = /^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-)*(?:[0-9a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[a-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i;
	var UUID = /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
	var JSON_POINTER = /^(?:\/(?:[^~/]|~0|~1)*)*$/;
	var JSON_POINTER_URI_FRAGMENT = /^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;
	var RELATIVE_JSON_POINTER = /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;


	formats_1 = formats;

	function formats(mode) {
	  mode = mode == 'full' ? 'full' : 'fast';
	  return util.copy(formats[mode]);
	}


	formats.fast = {
	  // date: http://tools.ietf.org/html/rfc3339#section-5.6
	  date: /^\d\d\d\d-[0-1]\d-[0-3]\d$/,
	  // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
	  time: /^(?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)?$/i,
	  'date-time': /^\d\d\d\d-[0-1]\d-[0-3]\d[t\s](?:[0-2]\d:[0-5]\d:[0-5]\d|23:59:60)(?:\.\d+)?(?:z|[+-]\d\d(?::?\d\d)?)$/i,
	  // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
	  uri: /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/)?[^\s]*$/i,
	  'uri-reference': /^(?:(?:[a-z][a-z0-9+\-.]*:)?\/?\/)?(?:[^\\\s#][^\s#]*)?(?:#[^\\\s]*)?$/i,
	  'uri-template': URITEMPLATE,
	  url: URL,
	  // email (sources from jsen validator):
	  // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
	  // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'willful violation')
	  email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
	  hostname: HOSTNAME,
	  // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
	  ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
	  // optimized http://stackoverflow.com/questions/53497/regular-expression-that-matches-valid-ipv6-addresses
	  ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
	  regex: regex,
	  // uuid: http://tools.ietf.org/html/rfc4122
	  uuid: UUID,
	  // JSON-pointer: https://tools.ietf.org/html/rfc6901
	  // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
	  'json-pointer': JSON_POINTER,
	  'json-pointer-uri-fragment': JSON_POINTER_URI_FRAGMENT,
	  // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
	  'relative-json-pointer': RELATIVE_JSON_POINTER
	};


	formats.full = {
	  date: date,
	  time: time,
	  'date-time': date_time,
	  uri: uri,
	  'uri-reference': URIREF,
	  'uri-template': URITEMPLATE,
	  url: URL,
	  email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
	  hostname: HOSTNAME,
	  ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
	  ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
	  regex: regex,
	  uuid: UUID,
	  'json-pointer': JSON_POINTER,
	  'json-pointer-uri-fragment': JSON_POINTER_URI_FRAGMENT,
	  'relative-json-pointer': RELATIVE_JSON_POINTER
	};


	function isLeapYear(year) {
	  // https://tools.ietf.org/html/rfc3339#appendix-C
	  return year % 4 === 0 && (year % 100 !== 0 || year % 400 === 0);
	}


	function date(str) {
	  // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
	  var matches = str.match(DATE);
	  if (!matches) return false;

	  var year = +matches[1];
	  var month = +matches[2];
	  var day = +matches[3];

	  return month >= 1 && month <= 12 && day >= 1 &&
	          day <= (month == 2 && isLeapYear(year) ? 29 : DAYS[month]);
	}


	function time(str, full) {
	  var matches = str.match(TIME);
	  if (!matches) return false;

	  var hour = matches[1];
	  var minute = matches[2];
	  var second = matches[3];
	  var timeZone = matches[5];
	  return ((hour <= 23 && minute <= 59 && second <= 59) ||
	          (hour == 23 && minute == 59 && second == 60)) &&
	         (!full || timeZone);
	}


	var DATE_TIME_SEPARATOR = /t|\s/i;
	function date_time(str) {
	  // http://tools.ietf.org/html/rfc3339#section-5.6
	  var dateTime = str.split(DATE_TIME_SEPARATOR);
	  return dateTime.length == 2 && date(dateTime[0]) && time(dateTime[1], true);
	}


	var NOT_URI_FRAGMENT = /\/|:/;
	function uri(str) {
	  // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
	  return NOT_URI_FRAGMENT.test(str) && URI.test(str);
	}


	var Z_ANCHOR = /[^\\]\\Z/;
	function regex(str) {
	  if (Z_ANCHOR.test(str)) return false;
	  try {
	    new RegExp(str);
	    return true;
	  } catch(e) {
	    return false;
	  }
	}
	return formats_1;
}

var ref;
var hasRequiredRef;

function requireRef () {
	if (hasRequiredRef) return ref;
	hasRequiredRef = 1;
	ref = function generate_ref(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $async, $refCode;
	  if ($schema == '#' || $schema == '#/') {
	    if (it.isRoot) {
	      $async = it.async;
	      $refCode = 'validate';
	    } else {
	      $async = it.root.schema.$async === true;
	      $refCode = 'root.refVal[0]';
	    }
	  } else {
	    var $refVal = it.resolveRef(it.baseId, $schema, it.isRoot);
	    if ($refVal === undefined) {
	      var $message = it.MissingRefError.message(it.baseId, $schema);
	      if (it.opts.missingRefs == 'fail') {
	        it.logger.error($message);
	        var $$outStack = $$outStack || [];
	        $$outStack.push(out);
	        out = ''; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ('$ref') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { ref: \'' + (it.util.escapeQuotes($schema)) + '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'can\\\'t resolve reference ' + (it.util.escapeQuotes($schema)) + '\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: ' + (it.util.toQuotedString($schema)) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        var __err = out;
	        out = $$outStack.pop();
	        if (!it.compositeRule && $breakOnError) {
	          /* istanbul ignore if */
	          if (it.async) {
	            out += ' throw new ValidationError([' + (__err) + ']); ';
	          } else {
	            out += ' validate.errors = [' + (__err) + ']; return false; ';
	          }
	        } else {
	          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	        }
	        if ($breakOnError) {
	          out += ' if (false) { ';
	        }
	      } else if (it.opts.missingRefs == 'ignore') {
	        it.logger.warn($message);
	        if ($breakOnError) {
	          out += ' if (true) { ';
	        }
	      } else {
	        throw new it.MissingRefError(it.baseId, $schema, $message);
	      }
	    } else if ($refVal.inline) {
	      var $it = it.util.copy(it);
	      $it.level++;
	      var $nextValid = 'valid' + $it.level;
	      $it.schema = $refVal.schema;
	      $it.schemaPath = '';
	      $it.errSchemaPath = $schema;
	      var $code = it.validate($it).replace(/validate\.schema/g, $refVal.code);
	      out += ' ' + ($code) + ' ';
	      if ($breakOnError) {
	        out += ' if (' + ($nextValid) + ') { ';
	      }
	    } else {
	      $async = $refVal.$async === true || (it.async && $refVal.$async !== false);
	      $refCode = $refVal.code;
	    }
	  }
	  if ($refCode) {
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = '';
	    if (it.opts.passContext) {
	      out += ' ' + ($refCode) + '.call(this, ';
	    } else {
	      out += ' ' + ($refCode) + '( ';
	    }
	    out += ' ' + ($data) + ', (dataPath || \'\')';
	    if (it.errorPath != '""') {
	      out += ' + ' + (it.errorPath);
	    }
	    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
	      $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
	    out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ', rootData)  ';
	    var __callValidate = out;
	    out = $$outStack.pop();
	    if ($async) {
	      if (!it.async) throw new Error('async schema referenced by sync schema');
	      if ($breakOnError) {
	        out += ' var ' + ($valid) + '; ';
	      }
	      out += ' try { await ' + (__callValidate) + '; ';
	      if ($breakOnError) {
	        out += ' ' + ($valid) + ' = true; ';
	      }
	      out += ' } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ';
	      if ($breakOnError) {
	        out += ' ' + ($valid) + ' = false; ';
	      }
	      out += ' } ';
	      if ($breakOnError) {
	        out += ' if (' + ($valid) + ') { ';
	      }
	    } else {
	      out += ' if (!' + (__callValidate) + ') { if (vErrors === null) vErrors = ' + ($refCode) + '.errors; else vErrors = vErrors.concat(' + ($refCode) + '.errors); errors = vErrors.length; } ';
	      if ($breakOnError) {
	        out += ' else { ';
	      }
	    }
	  }
	  return out;
	};
	return ref;
}

var allOf;
var hasRequiredAllOf;

function requireAllOf () {
	if (hasRequiredAllOf) return allOf;
	hasRequiredAllOf = 1;
	allOf = function generate_allOf(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $currentBaseId = $it.baseId,
	    $allSchemasEmpty = true;
	  var arr1 = $schema;
	  if (arr1) {
	    var $sch, $i = -1,
	      l1 = arr1.length - 1;
	    while ($i < l1) {
	      $sch = arr1[$i += 1];
	      if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
	        $allSchemasEmpty = false;
	        $it.schema = $sch;
	        $it.schemaPath = $schemaPath + '[' + $i + ']';
	        $it.errSchemaPath = $errSchemaPath + '/' + $i;
	        out += '  ' + (it.validate($it)) + ' ';
	        $it.baseId = $currentBaseId;
	        if ($breakOnError) {
	          out += ' if (' + ($nextValid) + ') { ';
	          $closingBraces += '}';
	        }
	      }
	    }
	  }
	  if ($breakOnError) {
	    if ($allSchemasEmpty) {
	      out += ' if (true) { ';
	    } else {
	      out += ' ' + ($closingBraces.slice(0, -1)) + ' ';
	    }
	  }
	  return out;
	};
	return allOf;
}

var anyOf;
var hasRequiredAnyOf;

function requireAnyOf () {
	if (hasRequiredAnyOf) return anyOf;
	hasRequiredAnyOf = 1;
	anyOf = function generate_anyOf(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $noEmptySchema = $schema.every(function($sch) {
	    return (it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all));
	  });
	  if ($noEmptySchema) {
	    var $currentBaseId = $it.baseId;
	    out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = false;  ';
	    var $wasComposite = it.compositeRule;
	    it.compositeRule = $it.compositeRule = true;
	    var arr1 = $schema;
	    if (arr1) {
	      var $sch, $i = -1,
	        l1 = arr1.length - 1;
	      while ($i < l1) {
	        $sch = arr1[$i += 1];
	        $it.schema = $sch;
	        $it.schemaPath = $schemaPath + '[' + $i + ']';
	        $it.errSchemaPath = $errSchemaPath + '/' + $i;
	        out += '  ' + (it.validate($it)) + ' ';
	        $it.baseId = $currentBaseId;
	        out += ' ' + ($valid) + ' = ' + ($valid) + ' || ' + ($nextValid) + '; if (!' + ($valid) + ') { ';
	        $closingBraces += '}';
	      }
	    }
	    it.compositeRule = $it.compositeRule = $wasComposite;
	    out += ' ' + ($closingBraces) + ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ('anyOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'should match some schema in anyOf\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError(vErrors); ';
	      } else {
	        out += ' validate.errors = vErrors; return false; ';
	      }
	    }
	    out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
	    if (it.opts.allErrors) {
	      out += ' } ';
	    }
	  } else {
	    if ($breakOnError) {
	      out += ' if (true) { ';
	    }
	  }
	  return out;
	};
	return anyOf;
}

var comment;
var hasRequiredComment;

function requireComment () {
	if (hasRequiredComment) return comment;
	hasRequiredComment = 1;
	comment = function generate_comment(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $schema = it.schema[$keyword];
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  !it.opts.allErrors;
	  var $comment = it.util.toQuotedString($schema);
	  if (it.opts.$comment === true) {
	    out += ' console.log(' + ($comment) + ');';
	  } else if (typeof it.opts.$comment == 'function') {
	    out += ' self._opts.$comment(' + ($comment) + ', ' + (it.util.toQuotedString($errSchemaPath)) + ', validate.root.schema);';
	  }
	  return out;
	};
	return comment;
}

var _const;
var hasRequired_const;

function require_const () {
	if (hasRequired_const) return _const;
	hasRequired_const = 1;
	_const = function generate_const(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $isData = it.opts.$data && $schema && $schema.$data;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	  }
	  if (!$isData) {
	    out += ' var schema' + ($lvl) + ' = validate.schema' + ($schemaPath) + ';';
	  }
	  out += 'var ' + ($valid) + ' = equal(' + ($data) + ', schema' + ($lvl) + '); if (!' + ($valid) + ') {   ';
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('const') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValue: schema' + ($lvl) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should be equal to constant\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += ' }';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return _const;
}

var contains;
var hasRequiredContains;

function requireContains () {
	if (hasRequiredContains) return contains;
	hasRequiredContains = 1;
	contains = function generate_contains(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $idx = 'i' + $lvl,
	    $dataNxt = $it.dataLevel = it.dataLevel + 1,
	    $nextData = 'data' + $dataNxt,
	    $currentBaseId = it.baseId,
	    $nonEmptySchema = (it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all));
	  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
	  if ($nonEmptySchema) {
	    var $wasComposite = it.compositeRule;
	    it.compositeRule = $it.compositeRule = true;
	    $it.schema = $schema;
	    $it.schemaPath = $schemaPath;
	    $it.errSchemaPath = $errSchemaPath;
	    out += ' var ' + ($nextValid) + ' = false; for (var ' + ($idx) + ' = 0; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
	    $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
	    var $passData = $data + '[' + $idx + ']';
	    $it.dataPathArr[$dataNxt] = $idx;
	    var $code = it.validate($it);
	    $it.baseId = $currentBaseId;
	    if (it.util.varOccurences($code, $nextData) < 2) {
	      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	    } else {
	      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	    }
	    out += ' if (' + ($nextValid) + ') break; }  ';
	    it.compositeRule = $it.compositeRule = $wasComposite;
	    out += ' ' + ($closingBraces) + ' if (!' + ($nextValid) + ') {';
	  } else {
	    out += ' if (' + ($data) + '.length == 0) {';
	  }
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('contains') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should contain a valid item\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += ' } else { ';
	  if ($nonEmptySchema) {
	    out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
	  }
	  if (it.opts.allErrors) {
	    out += ' } ';
	  }
	  return out;
	};
	return contains;
}

var dependencies$1;
var hasRequiredDependencies;

function requireDependencies () {
	if (hasRequiredDependencies) return dependencies$1;
	hasRequiredDependencies = 1;
	dependencies$1 = function generate_dependencies(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $schemaDeps = {},
	    $propertyDeps = {},
	    $ownProperties = it.opts.ownProperties;
	  for ($property in $schema) {
	    if ($property == '__proto__') continue;
	    var $sch = $schema[$property];
	    var $deps = Array.isArray($sch) ? $propertyDeps : $schemaDeps;
	    $deps[$property] = $sch;
	  }
	  out += 'var ' + ($errs) + ' = errors;';
	  var $currentErrorPath = it.errorPath;
	  out += 'var missing' + ($lvl) + ';';
	  for (var $property in $propertyDeps) {
	    $deps = $propertyDeps[$property];
	    if ($deps.length) {
	      out += ' if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
	      if ($ownProperties) {
	        out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
	      }
	      if ($breakOnError) {
	        out += ' && ( ';
	        var arr1 = $deps;
	        if (arr1) {
	          var $propertyKey, $i = -1,
	            l1 = arr1.length - 1;
	          while ($i < l1) {
	            $propertyKey = arr1[$i += 1];
	            if ($i) {
	              out += ' || ';
	            }
	            var $prop = it.util.getProperty($propertyKey),
	              $useData = $data + $prop;
	            out += ' ( ( ' + ($useData) + ' === undefined ';
	            if ($ownProperties) {
	              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	            }
	            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
	          }
	        }
	        out += ')) {  ';
	        var $propertyPath = 'missing' + $lvl,
	          $missingProperty = '\' + ' + $propertyPath + ' + \'';
	        if (it.opts._errorDataPathProperty) {
	          it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
	        }
	        var $$outStack = $$outStack || [];
	        $$outStack.push(out);
	        out = ''; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'should have ';
	            if ($deps.length == 1) {
	              out += 'property ' + (it.util.escapeQuotes($deps[0]));
	            } else {
	              out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
	            }
	            out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        var __err = out;
	        out = $$outStack.pop();
	        if (!it.compositeRule && $breakOnError) {
	          /* istanbul ignore if */
	          if (it.async) {
	            out += ' throw new ValidationError([' + (__err) + ']); ';
	          } else {
	            out += ' validate.errors = [' + (__err) + ']; return false; ';
	          }
	        } else {
	          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	        }
	      } else {
	        out += ' ) { ';
	        var arr2 = $deps;
	        if (arr2) {
	          var $propertyKey, i2 = -1,
	            l2 = arr2.length - 1;
	          while (i2 < l2) {
	            $propertyKey = arr2[i2 += 1];
	            var $prop = it.util.getProperty($propertyKey),
	              $missingProperty = it.util.escapeQuotes($propertyKey),
	              $useData = $data + $prop;
	            if (it.opts._errorDataPathProperty) {
	              it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
	            }
	            out += ' if ( ' + ($useData) + ' === undefined ';
	            if ($ownProperties) {
	              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	            }
	            out += ') {  var err =   '; /* istanbul ignore else */
	            if (it.createErrors !== false) {
	              out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
	              if (it.opts.messages !== false) {
	                out += ' , message: \'should have ';
	                if ($deps.length == 1) {
	                  out += 'property ' + (it.util.escapeQuotes($deps[0]));
	                } else {
	                  out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
	                }
	                out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
	              }
	              if (it.opts.verbose) {
	                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	              }
	              out += ' } ';
	            } else {
	              out += ' {} ';
	            }
	            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
	          }
	        }
	      }
	      out += ' }   ';
	      if ($breakOnError) {
	        $closingBraces += '}';
	        out += ' else { ';
	      }
	    }
	  }
	  it.errorPath = $currentErrorPath;
	  var $currentBaseId = $it.baseId;
	  for (var $property in $schemaDeps) {
	    var $sch = $schemaDeps[$property];
	    if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
	      out += ' ' + ($nextValid) + ' = true; if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
	      if ($ownProperties) {
	        out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
	      }
	      out += ') { ';
	      $it.schema = $sch;
	      $it.schemaPath = $schemaPath + it.util.getProperty($property);
	      $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($property);
	      out += '  ' + (it.validate($it)) + ' ';
	      $it.baseId = $currentBaseId;
	      out += ' }  ';
	      if ($breakOnError) {
	        out += ' if (' + ($nextValid) + ') { ';
	        $closingBraces += '}';
	      }
	    }
	  }
	  if ($breakOnError) {
	    out += '   ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
	  }
	  return out;
	};
	return dependencies$1;
}

var _enum;
var hasRequired_enum;

function require_enum () {
	if (hasRequired_enum) return _enum;
	hasRequired_enum = 1;
	_enum = function generate_enum(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $isData = it.opts.$data && $schema && $schema.$data;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	  }
	  var $i = 'i' + $lvl,
	    $vSchema = 'schema' + $lvl;
	  if (!$isData) {
	    out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + ';';
	  }
	  out += 'var ' + ($valid) + ';';
	  if ($isData) {
	    out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
	  }
	  out += '' + ($valid) + ' = false;for (var ' + ($i) + '=0; ' + ($i) + '<' + ($vSchema) + '.length; ' + ($i) + '++) if (equal(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + '])) { ' + ($valid) + ' = true; break; }';
	  if ($isData) {
	    out += '  }  ';
	  }
	  out += ' if (!' + ($valid) + ') {   ';
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('enum') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValues: schema' + ($lvl) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should be equal to one of the allowed values\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += ' }';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return _enum;
}

var format;
var hasRequiredFormat;

function requireFormat () {
	if (hasRequiredFormat) return format;
	hasRequiredFormat = 1;
	format = function generate_format(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  if (it.opts.format === false) {
	    if ($breakOnError) {
	      out += ' if (true) { ';
	    }
	    return out;
	  }
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  var $unknownFormats = it.opts.unknownFormats,
	    $allowUnknown = Array.isArray($unknownFormats);
	  if ($isData) {
	    var $format = 'format' + $lvl,
	      $isObject = 'isObject' + $lvl,
	      $formatType = 'formatType' + $lvl;
	    out += ' var ' + ($format) + ' = formats[' + ($schemaValue) + ']; var ' + ($isObject) + ' = typeof ' + ($format) + ' == \'object\' && !(' + ($format) + ' instanceof RegExp) && ' + ($format) + '.validate; var ' + ($formatType) + ' = ' + ($isObject) + ' && ' + ($format) + '.type || \'string\'; if (' + ($isObject) + ') { ';
	    if (it.async) {
	      out += ' var async' + ($lvl) + ' = ' + ($format) + '.async; ';
	    }
	    out += ' ' + ($format) + ' = ' + ($format) + '.validate; } if (  ';
	    if ($isData) {
	      out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
	    }
	    out += ' (';
	    if ($unknownFormats != 'ignore') {
	      out += ' (' + ($schemaValue) + ' && !' + ($format) + ' ';
	      if ($allowUnknown) {
	        out += ' && self._opts.unknownFormats.indexOf(' + ($schemaValue) + ') == -1 ';
	      }
	      out += ') || ';
	    }
	    out += ' (' + ($format) + ' && ' + ($formatType) + ' == \'' + ($ruleType) + '\' && !(typeof ' + ($format) + ' == \'function\' ? ';
	    if (it.async) {
	      out += ' (async' + ($lvl) + ' ? await ' + ($format) + '(' + ($data) + ') : ' + ($format) + '(' + ($data) + ')) ';
	    } else {
	      out += ' ' + ($format) + '(' + ($data) + ') ';
	    }
	    out += ' : ' + ($format) + '.test(' + ($data) + '))))) {';
	  } else {
	    var $format = it.formats[$schema];
	    if (!$format) {
	      if ($unknownFormats == 'ignore') {
	        it.logger.warn('unknown format "' + $schema + '" ignored in schema at path "' + it.errSchemaPath + '"');
	        if ($breakOnError) {
	          out += ' if (true) { ';
	        }
	        return out;
	      } else if ($allowUnknown && $unknownFormats.indexOf($schema) >= 0) {
	        if ($breakOnError) {
	          out += ' if (true) { ';
	        }
	        return out;
	      } else {
	        throw new Error('unknown format "' + $schema + '" is used in schema at path "' + it.errSchemaPath + '"');
	      }
	    }
	    var $isObject = typeof $format == 'object' && !($format instanceof RegExp) && $format.validate;
	    var $formatType = $isObject && $format.type || 'string';
	    if ($isObject) {
	      var $async = $format.async === true;
	      $format = $format.validate;
	    }
	    if ($formatType != $ruleType) {
	      if ($breakOnError) {
	        out += ' if (true) { ';
	      }
	      return out;
	    }
	    if ($async) {
	      if (!it.async) throw new Error('async format in sync schema');
	      var $formatRef = 'formats' + it.util.getProperty($schema) + '.validate';
	      out += ' if (!(await ' + ($formatRef) + '(' + ($data) + '))) { ';
	    } else {
	      out += ' if (! ';
	      var $formatRef = 'formats' + it.util.getProperty($schema);
	      if ($isObject) $formatRef += '.validate';
	      if (typeof $format == 'function') {
	        out += ' ' + ($formatRef) + '(' + ($data) + ') ';
	      } else {
	        out += ' ' + ($formatRef) + '.test(' + ($data) + ') ';
	      }
	      out += ') { ';
	    }
	  }
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('format') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { format:  ';
	    if ($isData) {
	      out += '' + ($schemaValue);
	    } else {
	      out += '' + (it.util.toQuotedString($schema));
	    }
	    out += '  } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should match format "';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue) + ' + \'';
	      } else {
	        out += '' + (it.util.escapeQuotes($schema));
	      }
	      out += '"\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + (it.util.toQuotedString($schema));
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += ' } ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return format;
}

var _if;
var hasRequired_if;

function require_if () {
	if (hasRequired_if) return _if;
	hasRequired_if = 1;
	_if = function generate_if(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $thenSch = it.schema['then'],
	    $elseSch = it.schema['else'],
	    $thenPresent = $thenSch !== undefined && (it.opts.strictKeywords ? (typeof $thenSch == 'object' && Object.keys($thenSch).length > 0) || $thenSch === false : it.util.schemaHasRules($thenSch, it.RULES.all)),
	    $elsePresent = $elseSch !== undefined && (it.opts.strictKeywords ? (typeof $elseSch == 'object' && Object.keys($elseSch).length > 0) || $elseSch === false : it.util.schemaHasRules($elseSch, it.RULES.all)),
	    $currentBaseId = $it.baseId;
	  if ($thenPresent || $elsePresent) {
	    var $ifClause;
	    $it.createErrors = false;
	    $it.schema = $schema;
	    $it.schemaPath = $schemaPath;
	    $it.errSchemaPath = $errSchemaPath;
	    out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = true;  ';
	    var $wasComposite = it.compositeRule;
	    it.compositeRule = $it.compositeRule = true;
	    out += '  ' + (it.validate($it)) + ' ';
	    $it.baseId = $currentBaseId;
	    $it.createErrors = true;
	    out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }  ';
	    it.compositeRule = $it.compositeRule = $wasComposite;
	    if ($thenPresent) {
	      out += ' if (' + ($nextValid) + ') {  ';
	      $it.schema = it.schema['then'];
	      $it.schemaPath = it.schemaPath + '.then';
	      $it.errSchemaPath = it.errSchemaPath + '/then';
	      out += '  ' + (it.validate($it)) + ' ';
	      $it.baseId = $currentBaseId;
	      out += ' ' + ($valid) + ' = ' + ($nextValid) + '; ';
	      if ($thenPresent && $elsePresent) {
	        $ifClause = 'ifClause' + $lvl;
	        out += ' var ' + ($ifClause) + ' = \'then\'; ';
	      } else {
	        $ifClause = '\'then\'';
	      }
	      out += ' } ';
	      if ($elsePresent) {
	        out += ' else { ';
	      }
	    } else {
	      out += ' if (!' + ($nextValid) + ') { ';
	    }
	    if ($elsePresent) {
	      $it.schema = it.schema['else'];
	      $it.schemaPath = it.schemaPath + '.else';
	      $it.errSchemaPath = it.errSchemaPath + '/else';
	      out += '  ' + (it.validate($it)) + ' ';
	      $it.baseId = $currentBaseId;
	      out += ' ' + ($valid) + ' = ' + ($nextValid) + '; ';
	      if ($thenPresent && $elsePresent) {
	        $ifClause = 'ifClause' + $lvl;
	        out += ' var ' + ($ifClause) + ' = \'else\'; ';
	      } else {
	        $ifClause = '\'else\'';
	      }
	      out += ' } ';
	    }
	    out += ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ('if') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { failingKeyword: ' + ($ifClause) + ' } ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'should match "\' + ' + ($ifClause) + ' + \'" schema\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError(vErrors); ';
	      } else {
	        out += ' validate.errors = vErrors; return false; ';
	      }
	    }
	    out += ' }   ';
	    if ($breakOnError) {
	      out += ' else { ';
	    }
	  } else {
	    if ($breakOnError) {
	      out += ' if (true) { ';
	    }
	  }
	  return out;
	};
	return _if;
}

var items;
var hasRequiredItems;

function requireItems () {
	if (hasRequiredItems) return items;
	hasRequiredItems = 1;
	items = function generate_items(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $idx = 'i' + $lvl,
	    $dataNxt = $it.dataLevel = it.dataLevel + 1,
	    $nextData = 'data' + $dataNxt,
	    $currentBaseId = it.baseId;
	  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
	  if (Array.isArray($schema)) {
	    var $additionalItems = it.schema.additionalItems;
	    if ($additionalItems === false) {
	      out += ' ' + ($valid) + ' = ' + ($data) + '.length <= ' + ($schema.length) + '; ';
	      var $currErrSchemaPath = $errSchemaPath;
	      $errSchemaPath = it.errSchemaPath + '/additionalItems';
	      out += '  if (!' + ($valid) + ') {   ';
	      var $$outStack = $$outStack || [];
	      $$outStack.push(out);
	      out = ''; /* istanbul ignore else */
	      if (it.createErrors !== false) {
	        out += ' { keyword: \'' + ('additionalItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schema.length) + ' } ';
	        if (it.opts.messages !== false) {
	          out += ' , message: \'should NOT have more than ' + ($schema.length) + ' items\' ';
	        }
	        if (it.opts.verbose) {
	          out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	        }
	        out += ' } ';
	      } else {
	        out += ' {} ';
	      }
	      var __err = out;
	      out = $$outStack.pop();
	      if (!it.compositeRule && $breakOnError) {
	        /* istanbul ignore if */
	        if (it.async) {
	          out += ' throw new ValidationError([' + (__err) + ']); ';
	        } else {
	          out += ' validate.errors = [' + (__err) + ']; return false; ';
	        }
	      } else {
	        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	      }
	      out += ' } ';
	      $errSchemaPath = $currErrSchemaPath;
	      if ($breakOnError) {
	        $closingBraces += '}';
	        out += ' else { ';
	      }
	    }
	    var arr1 = $schema;
	    if (arr1) {
	      var $sch, $i = -1,
	        l1 = arr1.length - 1;
	      while ($i < l1) {
	        $sch = arr1[$i += 1];
	        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
	          out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($i) + ') { ';
	          var $passData = $data + '[' + $i + ']';
	          $it.schema = $sch;
	          $it.schemaPath = $schemaPath + '[' + $i + ']';
	          $it.errSchemaPath = $errSchemaPath + '/' + $i;
	          $it.errorPath = it.util.getPathExpr(it.errorPath, $i, it.opts.jsonPointers, true);
	          $it.dataPathArr[$dataNxt] = $i;
	          var $code = it.validate($it);
	          $it.baseId = $currentBaseId;
	          if (it.util.varOccurences($code, $nextData) < 2) {
	            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	          } else {
	            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	          }
	          out += ' }  ';
	          if ($breakOnError) {
	            out += ' if (' + ($nextValid) + ') { ';
	            $closingBraces += '}';
	          }
	        }
	      }
	    }
	    if (typeof $additionalItems == 'object' && (it.opts.strictKeywords ? (typeof $additionalItems == 'object' && Object.keys($additionalItems).length > 0) || $additionalItems === false : it.util.schemaHasRules($additionalItems, it.RULES.all))) {
	      $it.schema = $additionalItems;
	      $it.schemaPath = it.schemaPath + '.additionalItems';
	      $it.errSchemaPath = it.errSchemaPath + '/additionalItems';
	      out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($schema.length) + ') {  for (var ' + ($idx) + ' = ' + ($schema.length) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
	      $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
	      var $passData = $data + '[' + $idx + ']';
	      $it.dataPathArr[$dataNxt] = $idx;
	      var $code = it.validate($it);
	      $it.baseId = $currentBaseId;
	      if (it.util.varOccurences($code, $nextData) < 2) {
	        out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	      } else {
	        out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	      }
	      if ($breakOnError) {
	        out += ' if (!' + ($nextValid) + ') break; ';
	      }
	      out += ' } }  ';
	      if ($breakOnError) {
	        out += ' if (' + ($nextValid) + ') { ';
	        $closingBraces += '}';
	      }
	    }
	  } else if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
	    $it.schema = $schema;
	    $it.schemaPath = $schemaPath;
	    $it.errSchemaPath = $errSchemaPath;
	    out += '  for (var ' + ($idx) + ' = ' + (0) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
	    $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
	    var $passData = $data + '[' + $idx + ']';
	    $it.dataPathArr[$dataNxt] = $idx;
	    var $code = it.validate($it);
	    $it.baseId = $currentBaseId;
	    if (it.util.varOccurences($code, $nextData) < 2) {
	      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	    } else {
	      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	    }
	    if ($breakOnError) {
	      out += ' if (!' + ($nextValid) + ') break; ';
	    }
	    out += ' }';
	  }
	  if ($breakOnError) {
	    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
	  }
	  return out;
	};
	return items;
}

var _limit;
var hasRequired_limit;

function require_limit () {
	if (hasRequired_limit) return _limit;
	hasRequired_limit = 1;
	_limit = function generate__limit(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $errorKeyword;
	  var $data = 'data' + ($dataLvl || '');
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  var $isMax = $keyword == 'maximum',
	    $exclusiveKeyword = $isMax ? 'exclusiveMaximum' : 'exclusiveMinimum',
	    $schemaExcl = it.schema[$exclusiveKeyword],
	    $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data,
	    $op = $isMax ? '<' : '>',
	    $notOp = $isMax ? '>' : '<',
	    $errorKeyword = undefined;
	  if (!($isData || typeof $schema == 'number' || $schema === undefined)) {
	    throw new Error($keyword + ' must be number');
	  }
	  if (!($isDataExcl || $schemaExcl === undefined || typeof $schemaExcl == 'number' || typeof $schemaExcl == 'boolean')) {
	    throw new Error($exclusiveKeyword + ' must be number or boolean');
	  }
	  if ($isDataExcl) {
	    var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr),
	      $exclusive = 'exclusive' + $lvl,
	      $exclType = 'exclType' + $lvl,
	      $exclIsNumber = 'exclIsNumber' + $lvl,
	      $opExpr = 'op' + $lvl,
	      $opStr = '\' + ' + $opExpr + ' + \'';
	    out += ' var schemaExcl' + ($lvl) + ' = ' + ($schemaValueExcl) + '; ';
	    $schemaValueExcl = 'schemaExcl' + $lvl;
	    out += ' var ' + ($exclusive) + '; var ' + ($exclType) + ' = typeof ' + ($schemaValueExcl) + '; if (' + ($exclType) + ' != \'boolean\' && ' + ($exclType) + ' != \'undefined\' && ' + ($exclType) + ' != \'number\') { ';
	    var $errorKeyword = $exclusiveKeyword;
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = ''; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ($errorKeyword || '_exclusiveLimit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'' + ($exclusiveKeyword) + ' should be boolean\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    var __err = out;
	    out = $$outStack.pop();
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError([' + (__err) + ']); ';
	      } else {
	        out += ' validate.errors = [' + (__err) + ']; return false; ';
	      }
	    } else {
	      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    }
	    out += ' } else if ( ';
	    if ($isData) {
	      out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
	    }
	    out += ' ' + ($exclType) + ' == \'number\' ? ( (' + ($exclusive) + ' = ' + ($schemaValue) + ' === undefined || ' + ($schemaValueExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ') ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValueExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) : ( (' + ($exclusive) + ' = ' + ($schemaValueExcl) + ' === true) ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValue) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { var op' + ($lvl) + ' = ' + ($exclusive) + ' ? \'' + ($op) + '\' : \'' + ($op) + '=\'; ';
	    if ($schema === undefined) {
	      $errorKeyword = $exclusiveKeyword;
	      $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
	      $schemaValue = $schemaValueExcl;
	      $isData = $isDataExcl;
	    }
	  } else {
	    var $exclIsNumber = typeof $schemaExcl == 'number',
	      $opStr = $op;
	    if ($exclIsNumber && $isData) {
	      var $opExpr = '\'' + $opStr + '\'';
	      out += ' if ( ';
	      if ($isData) {
	        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
	      }
	      out += ' ( ' + ($schemaValue) + ' === undefined || ' + ($schemaExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ' ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { ';
	    } else {
	      if ($exclIsNumber && $schema === undefined) {
	        $exclusive = true;
	        $errorKeyword = $exclusiveKeyword;
	        $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
	        $schemaValue = $schemaExcl;
	        $notOp += '=';
	      } else {
	        if ($exclIsNumber) $schemaValue = Math[$isMax ? 'min' : 'max']($schemaExcl, $schema);
	        if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
	          $exclusive = true;
	          $errorKeyword = $exclusiveKeyword;
	          $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
	          $notOp += '=';
	        } else {
	          $exclusive = false;
	          $opStr += '=';
	        }
	      }
	      var $opExpr = '\'' + $opStr + '\'';
	      out += ' if ( ';
	      if ($isData) {
	        out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
	      }
	      out += ' ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' || ' + ($data) + ' !== ' + ($data) + ') { ';
	    }
	  }
	  $errorKeyword = $errorKeyword || $keyword;
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ($errorKeyword || '_limit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { comparison: ' + ($opExpr) + ', limit: ' + ($schemaValue) + ', exclusive: ' + ($exclusive) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should be ' + ($opStr) + ' ';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue);
	      } else {
	        out += '' + ($schemaValue) + '\'';
	      }
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + ($schema);
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += ' } ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return _limit;
}

var _limitItems;
var hasRequired_limitItems;

function require_limitItems () {
	if (hasRequired_limitItems) return _limitItems;
	hasRequired_limitItems = 1;
	_limitItems = function generate__limitItems(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $errorKeyword;
	  var $data = 'data' + ($dataLvl || '');
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  if (!($isData || typeof $schema == 'number')) {
	    throw new Error($keyword + ' must be number');
	  }
	  var $op = $keyword == 'maxItems' ? '>' : '<';
	  out += 'if ( ';
	  if ($isData) {
	    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
	  }
	  out += ' ' + ($data) + '.length ' + ($op) + ' ' + ($schemaValue) + ') { ';
	  var $errorKeyword = $keyword;
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ($errorKeyword || '_limitItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should NOT have ';
	      if ($keyword == 'maxItems') {
	        out += 'more';
	      } else {
	        out += 'fewer';
	      }
	      out += ' than ';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue) + ' + \'';
	      } else {
	        out += '' + ($schema);
	      }
	      out += ' items\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + ($schema);
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += '} ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return _limitItems;
}

var _limitLength;
var hasRequired_limitLength;

function require_limitLength () {
	if (hasRequired_limitLength) return _limitLength;
	hasRequired_limitLength = 1;
	_limitLength = function generate__limitLength(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $errorKeyword;
	  var $data = 'data' + ($dataLvl || '');
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  if (!($isData || typeof $schema == 'number')) {
	    throw new Error($keyword + ' must be number');
	  }
	  var $op = $keyword == 'maxLength' ? '>' : '<';
	  out += 'if ( ';
	  if ($isData) {
	    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
	  }
	  if (it.opts.unicode === false) {
	    out += ' ' + ($data) + '.length ';
	  } else {
	    out += ' ucs2length(' + ($data) + ') ';
	  }
	  out += ' ' + ($op) + ' ' + ($schemaValue) + ') { ';
	  var $errorKeyword = $keyword;
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ($errorKeyword || '_limitLength') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should NOT be ';
	      if ($keyword == 'maxLength') {
	        out += 'longer';
	      } else {
	        out += 'shorter';
	      }
	      out += ' than ';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue) + ' + \'';
	      } else {
	        out += '' + ($schema);
	      }
	      out += ' characters\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + ($schema);
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += '} ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return _limitLength;
}

var _limitProperties;
var hasRequired_limitProperties;

function require_limitProperties () {
	if (hasRequired_limitProperties) return _limitProperties;
	hasRequired_limitProperties = 1;
	_limitProperties = function generate__limitProperties(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $errorKeyword;
	  var $data = 'data' + ($dataLvl || '');
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  if (!($isData || typeof $schema == 'number')) {
	    throw new Error($keyword + ' must be number');
	  }
	  var $op = $keyword == 'maxProperties' ? '>' : '<';
	  out += 'if ( ';
	  if ($isData) {
	    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
	  }
	  out += ' Object.keys(' + ($data) + ').length ' + ($op) + ' ' + ($schemaValue) + ') { ';
	  var $errorKeyword = $keyword;
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ($errorKeyword || '_limitProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should NOT have ';
	      if ($keyword == 'maxProperties') {
	        out += 'more';
	      } else {
	        out += 'fewer';
	      }
	      out += ' than ';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue) + ' + \'';
	      } else {
	        out += '' + ($schema);
	      }
	      out += ' properties\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + ($schema);
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += '} ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return _limitProperties;
}

var multipleOf;
var hasRequiredMultipleOf;

function requireMultipleOf () {
	if (hasRequiredMultipleOf) return multipleOf;
	hasRequiredMultipleOf = 1;
	multipleOf = function generate_multipleOf(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  if (!($isData || typeof $schema == 'number')) {
	    throw new Error($keyword + ' must be number');
	  }
	  out += 'var division' + ($lvl) + ';if (';
	  if ($isData) {
	    out += ' ' + ($schemaValue) + ' !== undefined && ( typeof ' + ($schemaValue) + ' != \'number\' || ';
	  }
	  out += ' (division' + ($lvl) + ' = ' + ($data) + ' / ' + ($schemaValue) + ', ';
	  if (it.opts.multipleOfPrecision) {
	    out += ' Math.abs(Math.round(division' + ($lvl) + ') - division' + ($lvl) + ') > 1e-' + (it.opts.multipleOfPrecision) + ' ';
	  } else {
	    out += ' division' + ($lvl) + ' !== parseInt(division' + ($lvl) + ') ';
	  }
	  out += ' ) ';
	  if ($isData) {
	    out += '  )  ';
	  }
	  out += ' ) {   ';
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('multipleOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { multipleOf: ' + ($schemaValue) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should be multiple of ';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue);
	      } else {
	        out += '' + ($schemaValue) + '\'';
	      }
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + ($schema);
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += '} ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return multipleOf;
}

var not;
var hasRequiredNot;

function requireNot () {
	if (hasRequiredNot) return not;
	hasRequiredNot = 1;
	not = function generate_not(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
	    $it.schema = $schema;
	    $it.schemaPath = $schemaPath;
	    $it.errSchemaPath = $errSchemaPath;
	    out += ' var ' + ($errs) + ' = errors;  ';
	    var $wasComposite = it.compositeRule;
	    it.compositeRule = $it.compositeRule = true;
	    $it.createErrors = false;
	    var $allErrorsOption;
	    if ($it.opts.allErrors) {
	      $allErrorsOption = $it.opts.allErrors;
	      $it.opts.allErrors = false;
	    }
	    out += ' ' + (it.validate($it)) + ' ';
	    $it.createErrors = true;
	    if ($allErrorsOption) $it.opts.allErrors = $allErrorsOption;
	    it.compositeRule = $it.compositeRule = $wasComposite;
	    out += ' if (' + ($nextValid) + ') {   ';
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = ''; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'should NOT be valid\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    var __err = out;
	    out = $$outStack.pop();
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError([' + (__err) + ']); ';
	      } else {
	        out += ' validate.errors = [' + (__err) + ']; return false; ';
	      }
	    } else {
	      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    }
	    out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
	    if (it.opts.allErrors) {
	      out += ' } ';
	    }
	  } else {
	    out += '  var err =   '; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'should NOT be valid\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    if ($breakOnError) {
	      out += ' if (false) { ';
	    }
	  }
	  return out;
	};
	return not;
}

var oneOf;
var hasRequiredOneOf;

function requireOneOf () {
	if (hasRequiredOneOf) return oneOf;
	hasRequiredOneOf = 1;
	oneOf = function generate_oneOf(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $currentBaseId = $it.baseId,
	    $prevValid = 'prevValid' + $lvl,
	    $passingSchemas = 'passingSchemas' + $lvl;
	  out += 'var ' + ($errs) + ' = errors , ' + ($prevValid) + ' = false , ' + ($valid) + ' = false , ' + ($passingSchemas) + ' = null; ';
	  var $wasComposite = it.compositeRule;
	  it.compositeRule = $it.compositeRule = true;
	  var arr1 = $schema;
	  if (arr1) {
	    var $sch, $i = -1,
	      l1 = arr1.length - 1;
	    while ($i < l1) {
	      $sch = arr1[$i += 1];
	      if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
	        $it.schema = $sch;
	        $it.schemaPath = $schemaPath + '[' + $i + ']';
	        $it.errSchemaPath = $errSchemaPath + '/' + $i;
	        out += '  ' + (it.validate($it)) + ' ';
	        $it.baseId = $currentBaseId;
	      } else {
	        out += ' var ' + ($nextValid) + ' = true; ';
	      }
	      if ($i) {
	        out += ' if (' + ($nextValid) + ' && ' + ($prevValid) + ') { ' + ($valid) + ' = false; ' + ($passingSchemas) + ' = [' + ($passingSchemas) + ', ' + ($i) + ']; } else { ';
	        $closingBraces += '}';
	      }
	      out += ' if (' + ($nextValid) + ') { ' + ($valid) + ' = ' + ($prevValid) + ' = true; ' + ($passingSchemas) + ' = ' + ($i) + '; }';
	    }
	  }
	  it.compositeRule = $it.compositeRule = $wasComposite;
	  out += '' + ($closingBraces) + 'if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('oneOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { passingSchemas: ' + ($passingSchemas) + ' } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should match exactly one schema in oneOf\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError(vErrors); ';
	    } else {
	      out += ' validate.errors = vErrors; return false; ';
	    }
	  }
	  out += '} else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }';
	  if (it.opts.allErrors) {
	    out += ' } ';
	  }
	  return out;
	};
	return oneOf;
}

var pattern;
var hasRequiredPattern;

function requirePattern () {
	if (hasRequiredPattern) return pattern;
	hasRequiredPattern = 1;
	pattern = function generate_pattern(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  var $regexp = $isData ? '(new RegExp(' + $schemaValue + '))' : it.usePattern($schema);
	  out += 'if ( ';
	  if ($isData) {
	    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
	  }
	  out += ' !' + ($regexp) + '.test(' + ($data) + ') ) {   ';
	  var $$outStack = $$outStack || [];
	  $$outStack.push(out);
	  out = ''; /* istanbul ignore else */
	  if (it.createErrors !== false) {
	    out += ' { keyword: \'' + ('pattern') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { pattern:  ';
	    if ($isData) {
	      out += '' + ($schemaValue);
	    } else {
	      out += '' + (it.util.toQuotedString($schema));
	    }
	    out += '  } ';
	    if (it.opts.messages !== false) {
	      out += ' , message: \'should match pattern "';
	      if ($isData) {
	        out += '\' + ' + ($schemaValue) + ' + \'';
	      } else {
	        out += '' + (it.util.escapeQuotes($schema));
	      }
	      out += '"\' ';
	    }
	    if (it.opts.verbose) {
	      out += ' , schema:  ';
	      if ($isData) {
	        out += 'validate.schema' + ($schemaPath);
	      } else {
	        out += '' + (it.util.toQuotedString($schema));
	      }
	      out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	    }
	    out += ' } ';
	  } else {
	    out += ' {} ';
	  }
	  var __err = out;
	  out = $$outStack.pop();
	  if (!it.compositeRule && $breakOnError) {
	    /* istanbul ignore if */
	    if (it.async) {
	      out += ' throw new ValidationError([' + (__err) + ']); ';
	    } else {
	      out += ' validate.errors = [' + (__err) + ']; return false; ';
	    }
	  } else {
	    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	  }
	  out += '} ';
	  if ($breakOnError) {
	    out += ' else { ';
	  }
	  return out;
	};
	return pattern;
}

var properties$3;
var hasRequiredProperties;

function requireProperties () {
	if (hasRequiredProperties) return properties$3;
	hasRequiredProperties = 1;
	properties$3 = function generate_properties(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  var $key = 'key' + $lvl,
	    $idx = 'idx' + $lvl,
	    $dataNxt = $it.dataLevel = it.dataLevel + 1,
	    $nextData = 'data' + $dataNxt,
	    $dataProperties = 'dataProperties' + $lvl;
	  var $schemaKeys = Object.keys($schema || {}).filter(notProto),
	    $pProperties = it.schema.patternProperties || {},
	    $pPropertyKeys = Object.keys($pProperties).filter(notProto),
	    $aProperties = it.schema.additionalProperties,
	    $someProperties = $schemaKeys.length || $pPropertyKeys.length,
	    $noAdditional = $aProperties === false,
	    $additionalIsSchema = typeof $aProperties == 'object' && Object.keys($aProperties).length,
	    $removeAdditional = it.opts.removeAdditional,
	    $checkAdditional = $noAdditional || $additionalIsSchema || $removeAdditional,
	    $ownProperties = it.opts.ownProperties,
	    $currentBaseId = it.baseId;
	  var $required = it.schema.required;
	  if ($required && !(it.opts.$data && $required.$data) && $required.length < it.opts.loopRequired) {
	    var $requiredHash = it.util.toHash($required);
	  }

	  function notProto(p) {
	    return p !== '__proto__';
	  }
	  out += 'var ' + ($errs) + ' = errors;var ' + ($nextValid) + ' = true;';
	  if ($ownProperties) {
	    out += ' var ' + ($dataProperties) + ' = undefined;';
	  }
	  if ($checkAdditional) {
	    if ($ownProperties) {
	      out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
	    } else {
	      out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
	    }
	    if ($someProperties) {
	      out += ' var isAdditional' + ($lvl) + ' = !(false ';
	      if ($schemaKeys.length) {
	        if ($schemaKeys.length > 8) {
	          out += ' || validate.schema' + ($schemaPath) + '.hasOwnProperty(' + ($key) + ') ';
	        } else {
	          var arr1 = $schemaKeys;
	          if (arr1) {
	            var $propertyKey, i1 = -1,
	              l1 = arr1.length - 1;
	            while (i1 < l1) {
	              $propertyKey = arr1[i1 += 1];
	              out += ' || ' + ($key) + ' == ' + (it.util.toQuotedString($propertyKey)) + ' ';
	            }
	          }
	        }
	      }
	      if ($pPropertyKeys.length) {
	        var arr2 = $pPropertyKeys;
	        if (arr2) {
	          var $pProperty, $i = -1,
	            l2 = arr2.length - 1;
	          while ($i < l2) {
	            $pProperty = arr2[$i += 1];
	            out += ' || ' + (it.usePattern($pProperty)) + '.test(' + ($key) + ') ';
	          }
	        }
	      }
	      out += ' ); if (isAdditional' + ($lvl) + ') { ';
	    }
	    if ($removeAdditional == 'all') {
	      out += ' delete ' + ($data) + '[' + ($key) + ']; ';
	    } else {
	      var $currentErrorPath = it.errorPath;
	      var $additionalProperty = '\' + ' + $key + ' + \'';
	      if (it.opts._errorDataPathProperty) {
	        it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
	      }
	      if ($noAdditional) {
	        if ($removeAdditional) {
	          out += ' delete ' + ($data) + '[' + ($key) + ']; ';
	        } else {
	          out += ' ' + ($nextValid) + ' = false; ';
	          var $currErrSchemaPath = $errSchemaPath;
	          $errSchemaPath = it.errSchemaPath + '/additionalProperties';
	          var $$outStack = $$outStack || [];
	          $$outStack.push(out);
	          out = ''; /* istanbul ignore else */
	          if (it.createErrors !== false) {
	            out += ' { keyword: \'' + ('additionalProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { additionalProperty: \'' + ($additionalProperty) + '\' } ';
	            if (it.opts.messages !== false) {
	              out += ' , message: \'';
	              if (it.opts._errorDataPathProperty) {
	                out += 'is an invalid additional property';
	              } else {
	                out += 'should NOT have additional properties';
	              }
	              out += '\' ';
	            }
	            if (it.opts.verbose) {
	              out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	            }
	            out += ' } ';
	          } else {
	            out += ' {} ';
	          }
	          var __err = out;
	          out = $$outStack.pop();
	          if (!it.compositeRule && $breakOnError) {
	            /* istanbul ignore if */
	            if (it.async) {
	              out += ' throw new ValidationError([' + (__err) + ']); ';
	            } else {
	              out += ' validate.errors = [' + (__err) + ']; return false; ';
	            }
	          } else {
	            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	          }
	          $errSchemaPath = $currErrSchemaPath;
	          if ($breakOnError) {
	            out += ' break; ';
	          }
	        }
	      } else if ($additionalIsSchema) {
	        if ($removeAdditional == 'failing') {
	          out += ' var ' + ($errs) + ' = errors;  ';
	          var $wasComposite = it.compositeRule;
	          it.compositeRule = $it.compositeRule = true;
	          $it.schema = $aProperties;
	          $it.schemaPath = it.schemaPath + '.additionalProperties';
	          $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
	          $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
	          var $passData = $data + '[' + $key + ']';
	          $it.dataPathArr[$dataNxt] = $key;
	          var $code = it.validate($it);
	          $it.baseId = $currentBaseId;
	          if (it.util.varOccurences($code, $nextData) < 2) {
	            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	          } else {
	            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	          }
	          out += ' if (!' + ($nextValid) + ') { errors = ' + ($errs) + '; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete ' + ($data) + '[' + ($key) + ']; }  ';
	          it.compositeRule = $it.compositeRule = $wasComposite;
	        } else {
	          $it.schema = $aProperties;
	          $it.schemaPath = it.schemaPath + '.additionalProperties';
	          $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
	          $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
	          var $passData = $data + '[' + $key + ']';
	          $it.dataPathArr[$dataNxt] = $key;
	          var $code = it.validate($it);
	          $it.baseId = $currentBaseId;
	          if (it.util.varOccurences($code, $nextData) < 2) {
	            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	          } else {
	            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	          }
	          if ($breakOnError) {
	            out += ' if (!' + ($nextValid) + ') break; ';
	          }
	        }
	      }
	      it.errorPath = $currentErrorPath;
	    }
	    if ($someProperties) {
	      out += ' } ';
	    }
	    out += ' }  ';
	    if ($breakOnError) {
	      out += ' if (' + ($nextValid) + ') { ';
	      $closingBraces += '}';
	    }
	  }
	  var $useDefaults = it.opts.useDefaults && !it.compositeRule;
	  if ($schemaKeys.length) {
	    var arr3 = $schemaKeys;
	    if (arr3) {
	      var $propertyKey, i3 = -1,
	        l3 = arr3.length - 1;
	      while (i3 < l3) {
	        $propertyKey = arr3[i3 += 1];
	        var $sch = $schema[$propertyKey];
	        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
	          var $prop = it.util.getProperty($propertyKey),
	            $passData = $data + $prop,
	            $hasDefault = $useDefaults && $sch.default !== undefined;
	          $it.schema = $sch;
	          $it.schemaPath = $schemaPath + $prop;
	          $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($propertyKey);
	          $it.errorPath = it.util.getPath(it.errorPath, $propertyKey, it.opts.jsonPointers);
	          $it.dataPathArr[$dataNxt] = it.util.toQuotedString($propertyKey);
	          var $code = it.validate($it);
	          $it.baseId = $currentBaseId;
	          if (it.util.varOccurences($code, $nextData) < 2) {
	            $code = it.util.varReplace($code, $nextData, $passData);
	            var $useData = $passData;
	          } else {
	            var $useData = $nextData;
	            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ';
	          }
	          if ($hasDefault) {
	            out += ' ' + ($code) + ' ';
	          } else {
	            if ($requiredHash && $requiredHash[$propertyKey]) {
	              out += ' if ( ' + ($useData) + ' === undefined ';
	              if ($ownProperties) {
	                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	              }
	              out += ') { ' + ($nextValid) + ' = false; ';
	              var $currentErrorPath = it.errorPath,
	                $currErrSchemaPath = $errSchemaPath,
	                $missingProperty = it.util.escapeQuotes($propertyKey);
	              if (it.opts._errorDataPathProperty) {
	                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
	              }
	              $errSchemaPath = it.errSchemaPath + '/required';
	              var $$outStack = $$outStack || [];
	              $$outStack.push(out);
	              out = ''; /* istanbul ignore else */
	              if (it.createErrors !== false) {
	                out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
	                if (it.opts.messages !== false) {
	                  out += ' , message: \'';
	                  if (it.opts._errorDataPathProperty) {
	                    out += 'is a required property';
	                  } else {
	                    out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
	                  }
	                  out += '\' ';
	                }
	                if (it.opts.verbose) {
	                  out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	                }
	                out += ' } ';
	              } else {
	                out += ' {} ';
	              }
	              var __err = out;
	              out = $$outStack.pop();
	              if (!it.compositeRule && $breakOnError) {
	                /* istanbul ignore if */
	                if (it.async) {
	                  out += ' throw new ValidationError([' + (__err) + ']); ';
	                } else {
	                  out += ' validate.errors = [' + (__err) + ']; return false; ';
	                }
	              } else {
	                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	              }
	              $errSchemaPath = $currErrSchemaPath;
	              it.errorPath = $currentErrorPath;
	              out += ' } else { ';
	            } else {
	              if ($breakOnError) {
	                out += ' if ( ' + ($useData) + ' === undefined ';
	                if ($ownProperties) {
	                  out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	                }
	                out += ') { ' + ($nextValid) + ' = true; } else { ';
	              } else {
	                out += ' if (' + ($useData) + ' !== undefined ';
	                if ($ownProperties) {
	                  out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	                }
	                out += ' ) { ';
	              }
	            }
	            out += ' ' + ($code) + ' } ';
	          }
	        }
	        if ($breakOnError) {
	          out += ' if (' + ($nextValid) + ') { ';
	          $closingBraces += '}';
	        }
	      }
	    }
	  }
	  if ($pPropertyKeys.length) {
	    var arr4 = $pPropertyKeys;
	    if (arr4) {
	      var $pProperty, i4 = -1,
	        l4 = arr4.length - 1;
	      while (i4 < l4) {
	        $pProperty = arr4[i4 += 1];
	        var $sch = $pProperties[$pProperty];
	        if ((it.opts.strictKeywords ? (typeof $sch == 'object' && Object.keys($sch).length > 0) || $sch === false : it.util.schemaHasRules($sch, it.RULES.all))) {
	          $it.schema = $sch;
	          $it.schemaPath = it.schemaPath + '.patternProperties' + it.util.getProperty($pProperty);
	          $it.errSchemaPath = it.errSchemaPath + '/patternProperties/' + it.util.escapeFragment($pProperty);
	          if ($ownProperties) {
	            out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
	          } else {
	            out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
	          }
	          out += ' if (' + (it.usePattern($pProperty)) + '.test(' + ($key) + ')) { ';
	          $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
	          var $passData = $data + '[' + $key + ']';
	          $it.dataPathArr[$dataNxt] = $key;
	          var $code = it.validate($it);
	          $it.baseId = $currentBaseId;
	          if (it.util.varOccurences($code, $nextData) < 2) {
	            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	          } else {
	            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	          }
	          if ($breakOnError) {
	            out += ' if (!' + ($nextValid) + ') break; ';
	          }
	          out += ' } ';
	          if ($breakOnError) {
	            out += ' else ' + ($nextValid) + ' = true; ';
	          }
	          out += ' }  ';
	          if ($breakOnError) {
	            out += ' if (' + ($nextValid) + ') { ';
	            $closingBraces += '}';
	          }
	        }
	      }
	    }
	  }
	  if ($breakOnError) {
	    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
	  }
	  return out;
	};
	return properties$3;
}

var propertyNames;
var hasRequiredPropertyNames;

function requirePropertyNames () {
	if (hasRequiredPropertyNames) return propertyNames;
	hasRequiredPropertyNames = 1;
	propertyNames = function generate_propertyNames(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $errs = 'errs__' + $lvl;
	  var $it = it.util.copy(it);
	  var $closingBraces = '';
	  $it.level++;
	  var $nextValid = 'valid' + $it.level;
	  out += 'var ' + ($errs) + ' = errors;';
	  if ((it.opts.strictKeywords ? (typeof $schema == 'object' && Object.keys($schema).length > 0) || $schema === false : it.util.schemaHasRules($schema, it.RULES.all))) {
	    $it.schema = $schema;
	    $it.schemaPath = $schemaPath;
	    $it.errSchemaPath = $errSchemaPath;
	    var $key = 'key' + $lvl,
	      $idx = 'idx' + $lvl,
	      $i = 'i' + $lvl,
	      $invalidName = '\' + ' + $key + ' + \'',
	      $dataNxt = $it.dataLevel = it.dataLevel + 1,
	      $nextData = 'data' + $dataNxt,
	      $dataProperties = 'dataProperties' + $lvl,
	      $ownProperties = it.opts.ownProperties,
	      $currentBaseId = it.baseId;
	    if ($ownProperties) {
	      out += ' var ' + ($dataProperties) + ' = undefined; ';
	    }
	    if ($ownProperties) {
	      out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
	    } else {
	      out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
	    }
	    out += ' var startErrs' + ($lvl) + ' = errors; ';
	    var $passData = $key;
	    var $wasComposite = it.compositeRule;
	    it.compositeRule = $it.compositeRule = true;
	    var $code = it.validate($it);
	    $it.baseId = $currentBaseId;
	    if (it.util.varOccurences($code, $nextData) < 2) {
	      out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
	    } else {
	      out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
	    }
	    it.compositeRule = $it.compositeRule = $wasComposite;
	    out += ' if (!' + ($nextValid) + ') { for (var ' + ($i) + '=startErrs' + ($lvl) + '; ' + ($i) + '<errors; ' + ($i) + '++) { vErrors[' + ($i) + '].propertyName = ' + ($key) + '; }   var err =   '; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ('propertyNames') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { propertyName: \'' + ($invalidName) + '\' } ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'property name \\\'' + ($invalidName) + '\\\' is invalid\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError(vErrors); ';
	      } else {
	        out += ' validate.errors = vErrors; return false; ';
	      }
	    }
	    if ($breakOnError) {
	      out += ' break; ';
	    }
	    out += ' } }';
	  }
	  if ($breakOnError) {
	    out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
	  }
	  return out;
	};
	return propertyNames;
}

var required$1;
var hasRequiredRequired;

function requireRequired () {
	if (hasRequiredRequired) return required$1;
	hasRequiredRequired = 1;
	required$1 = function generate_required(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $isData = it.opts.$data && $schema && $schema.$data;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	  }
	  var $vSchema = 'schema' + $lvl;
	  if (!$isData) {
	    if ($schema.length < it.opts.loopRequired && it.schema.properties && Object.keys(it.schema.properties).length) {
	      var $required = [];
	      var arr1 = $schema;
	      if (arr1) {
	        var $property, i1 = -1,
	          l1 = arr1.length - 1;
	        while (i1 < l1) {
	          $property = arr1[i1 += 1];
	          var $propertySch = it.schema.properties[$property];
	          if (!($propertySch && (it.opts.strictKeywords ? (typeof $propertySch == 'object' && Object.keys($propertySch).length > 0) || $propertySch === false : it.util.schemaHasRules($propertySch, it.RULES.all)))) {
	            $required[$required.length] = $property;
	          }
	        }
	      }
	    } else {
	      var $required = $schema;
	    }
	  }
	  if ($isData || $required.length) {
	    var $currentErrorPath = it.errorPath,
	      $loopRequired = $isData || $required.length >= it.opts.loopRequired,
	      $ownProperties = it.opts.ownProperties;
	    if ($breakOnError) {
	      out += ' var missing' + ($lvl) + '; ';
	      if ($loopRequired) {
	        if (!$isData) {
	          out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
	        }
	        var $i = 'i' + $lvl,
	          $propertyPath = 'schema' + $lvl + '[' + $i + ']',
	          $missingProperty = '\' + ' + $propertyPath + ' + \'';
	        if (it.opts._errorDataPathProperty) {
	          it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
	        }
	        out += ' var ' + ($valid) + ' = true; ';
	        if ($isData) {
	          out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
	        }
	        out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { ' + ($valid) + ' = ' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] !== undefined ';
	        if ($ownProperties) {
	          out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
	        }
	        out += '; if (!' + ($valid) + ') break; } ';
	        if ($isData) {
	          out += '  }  ';
	        }
	        out += '  if (!' + ($valid) + ') {   ';
	        var $$outStack = $$outStack || [];
	        $$outStack.push(out);
	        out = ''; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'';
	            if (it.opts._errorDataPathProperty) {
	              out += 'is a required property';
	            } else {
	              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
	            }
	            out += '\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        var __err = out;
	        out = $$outStack.pop();
	        if (!it.compositeRule && $breakOnError) {
	          /* istanbul ignore if */
	          if (it.async) {
	            out += ' throw new ValidationError([' + (__err) + ']); ';
	          } else {
	            out += ' validate.errors = [' + (__err) + ']; return false; ';
	          }
	        } else {
	          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	        }
	        out += ' } else { ';
	      } else {
	        out += ' if ( ';
	        var arr2 = $required;
	        if (arr2) {
	          var $propertyKey, $i = -1,
	            l2 = arr2.length - 1;
	          while ($i < l2) {
	            $propertyKey = arr2[$i += 1];
	            if ($i) {
	              out += ' || ';
	            }
	            var $prop = it.util.getProperty($propertyKey),
	              $useData = $data + $prop;
	            out += ' ( ( ' + ($useData) + ' === undefined ';
	            if ($ownProperties) {
	              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	            }
	            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
	          }
	        }
	        out += ') {  ';
	        var $propertyPath = 'missing' + $lvl,
	          $missingProperty = '\' + ' + $propertyPath + ' + \'';
	        if (it.opts._errorDataPathProperty) {
	          it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
	        }
	        var $$outStack = $$outStack || [];
	        $$outStack.push(out);
	        out = ''; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'';
	            if (it.opts._errorDataPathProperty) {
	              out += 'is a required property';
	            } else {
	              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
	            }
	            out += '\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        var __err = out;
	        out = $$outStack.pop();
	        if (!it.compositeRule && $breakOnError) {
	          /* istanbul ignore if */
	          if (it.async) {
	            out += ' throw new ValidationError([' + (__err) + ']); ';
	          } else {
	            out += ' validate.errors = [' + (__err) + ']; return false; ';
	          }
	        } else {
	          out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	        }
	        out += ' } else { ';
	      }
	    } else {
	      if ($loopRequired) {
	        if (!$isData) {
	          out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
	        }
	        var $i = 'i' + $lvl,
	          $propertyPath = 'schema' + $lvl + '[' + $i + ']',
	          $missingProperty = '\' + ' + $propertyPath + ' + \'';
	        if (it.opts._errorDataPathProperty) {
	          it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
	        }
	        if ($isData) {
	          out += ' if (' + ($vSchema) + ' && !Array.isArray(' + ($vSchema) + ')) {  var err =   '; /* istanbul ignore else */
	          if (it.createErrors !== false) {
	            out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
	            if (it.opts.messages !== false) {
	              out += ' , message: \'';
	              if (it.opts._errorDataPathProperty) {
	                out += 'is a required property';
	              } else {
	                out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
	              }
	              out += '\' ';
	            }
	            if (it.opts.verbose) {
	              out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	            }
	            out += ' } ';
	          } else {
	            out += ' {} ';
	          }
	          out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if (' + ($vSchema) + ' !== undefined) { ';
	        }
	        out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { if (' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] === undefined ';
	        if ($ownProperties) {
	          out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
	        }
	        out += ') {  var err =   '; /* istanbul ignore else */
	        if (it.createErrors !== false) {
	          out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
	          if (it.opts.messages !== false) {
	            out += ' , message: \'';
	            if (it.opts._errorDataPathProperty) {
	              out += 'is a required property';
	            } else {
	              out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
	            }
	            out += '\' ';
	          }
	          if (it.opts.verbose) {
	            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	          }
	          out += ' } ';
	        } else {
	          out += ' {} ';
	        }
	        out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ';
	        if ($isData) {
	          out += '  }  ';
	        }
	      } else {
	        var arr3 = $required;
	        if (arr3) {
	          var $propertyKey, i3 = -1,
	            l3 = arr3.length - 1;
	          while (i3 < l3) {
	            $propertyKey = arr3[i3 += 1];
	            var $prop = it.util.getProperty($propertyKey),
	              $missingProperty = it.util.escapeQuotes($propertyKey),
	              $useData = $data + $prop;
	            if (it.opts._errorDataPathProperty) {
	              it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
	            }
	            out += ' if ( ' + ($useData) + ' === undefined ';
	            if ($ownProperties) {
	              out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
	            }
	            out += ') {  var err =   '; /* istanbul ignore else */
	            if (it.createErrors !== false) {
	              out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
	              if (it.opts.messages !== false) {
	                out += ' , message: \'';
	                if (it.opts._errorDataPathProperty) {
	                  out += 'is a required property';
	                } else {
	                  out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
	                }
	                out += '\' ';
	              }
	              if (it.opts.verbose) {
	                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	              }
	              out += ' } ';
	            } else {
	              out += ' {} ';
	            }
	            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
	          }
	        }
	      }
	    }
	    it.errorPath = $currentErrorPath;
	  } else if ($breakOnError) {
	    out += ' if (true) {';
	  }
	  return out;
	};
	return required$1;
}

var uniqueItems;
var hasRequiredUniqueItems;

function requireUniqueItems () {
	if (hasRequiredUniqueItems) return uniqueItems;
	hasRequiredUniqueItems = 1;
	uniqueItems = function generate_uniqueItems(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  if (($schema || $isData) && it.opts.uniqueItems !== false) {
	    if ($isData) {
	      out += ' var ' + ($valid) + '; if (' + ($schemaValue) + ' === false || ' + ($schemaValue) + ' === undefined) ' + ($valid) + ' = true; else if (typeof ' + ($schemaValue) + ' != \'boolean\') ' + ($valid) + ' = false; else { ';
	    }
	    out += ' var i = ' + ($data) + '.length , ' + ($valid) + ' = true , j; if (i > 1) { ';
	    var $itemType = it.schema.items && it.schema.items.type,
	      $typeIsArray = Array.isArray($itemType);
	    if (!$itemType || $itemType == 'object' || $itemType == 'array' || ($typeIsArray && ($itemType.indexOf('object') >= 0 || $itemType.indexOf('array') >= 0))) {
	      out += ' outer: for (;i--;) { for (j = i; j--;) { if (equal(' + ($data) + '[i], ' + ($data) + '[j])) { ' + ($valid) + ' = false; break outer; } } } ';
	    } else {
	      out += ' var itemIndices = {}, item; for (;i--;) { var item = ' + ($data) + '[i]; ';
	      var $method = 'checkDataType' + ($typeIsArray ? 's' : '');
	      out += ' if (' + (it.util[$method]($itemType, 'item', it.opts.strictNumbers, true)) + ') continue; ';
	      if ($typeIsArray) {
	        out += ' if (typeof item == \'string\') item = \'"\' + item; ';
	      }
	      out += ' if (typeof itemIndices[item] == \'number\') { ' + ($valid) + ' = false; j = itemIndices[item]; break; } itemIndices[item] = i; } ';
	    }
	    out += ' } ';
	    if ($isData) {
	      out += '  }  ';
	    }
	    out += ' if (!' + ($valid) + ') {   ';
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = ''; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ('uniqueItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { i: i, j: j } ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'should NOT have duplicate items (items ## \' + j + \' and \' + i + \' are identical)\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema:  ';
	        if ($isData) {
	          out += 'validate.schema' + ($schemaPath);
	        } else {
	          out += '' + ($schema);
	        }
	        out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    var __err = out;
	    out = $$outStack.pop();
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError([' + (__err) + ']); ';
	      } else {
	        out += ' validate.errors = [' + (__err) + ']; return false; ';
	      }
	    } else {
	      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    }
	    out += ' } ';
	    if ($breakOnError) {
	      out += ' else { ';
	    }
	  } else {
	    if ($breakOnError) {
	      out += ' if (true) { ';
	    }
	  }
	  return out;
	};
	return uniqueItems;
}

var dotjs;
var hasRequiredDotjs;

function requireDotjs () {
	if (hasRequiredDotjs) return dotjs;
	hasRequiredDotjs = 1;

	//all requires must be explicit because browserify won't work with dynamic requires
	dotjs = {
	  '$ref': requireRef(),
	  allOf: requireAllOf(),
	  anyOf: requireAnyOf(),
	  '$comment': requireComment(),
	  const: require_const(),
	  contains: requireContains(),
	  dependencies: requireDependencies(),
	  'enum': require_enum(),
	  format: requireFormat(),
	  'if': require_if(),
	  items: requireItems(),
	  maximum: require_limit(),
	  minimum: require_limit(),
	  maxItems: require_limitItems(),
	  minItems: require_limitItems(),
	  maxLength: require_limitLength(),
	  minLength: require_limitLength(),
	  maxProperties: require_limitProperties(),
	  minProperties: require_limitProperties(),
	  multipleOf: requireMultipleOf(),
	  not: requireNot(),
	  oneOf: requireOneOf(),
	  pattern: requirePattern(),
	  properties: requireProperties(),
	  propertyNames: requirePropertyNames(),
	  required: requireRequired(),
	  uniqueItems: requireUniqueItems(),
	  validate: requireValidate()
	};
	return dotjs;
}

var rules$3;
var hasRequiredRules$2;

function requireRules$2 () {
	if (hasRequiredRules$2) return rules$3;
	hasRequiredRules$2 = 1;

	var ruleModules = requireDotjs()
	  , toHash = requireUtil().toHash;

	rules$3 = function rules() {
	  var RULES = [
	    { type: 'number',
	      rules: [ { 'maximum': ['exclusiveMaximum'] },
	               { 'minimum': ['exclusiveMinimum'] }, 'multipleOf', 'format'] },
	    { type: 'string',
	      rules: [ 'maxLength', 'minLength', 'pattern', 'format' ] },
	    { type: 'array',
	      rules: [ 'maxItems', 'minItems', 'items', 'contains', 'uniqueItems' ] },
	    { type: 'object',
	      rules: [ 'maxProperties', 'minProperties', 'required', 'dependencies', 'propertyNames',
	               { 'properties': ['additionalProperties', 'patternProperties'] } ] },
	    { rules: [ '$ref', 'const', 'enum', 'not', 'anyOf', 'oneOf', 'allOf', 'if' ] }
	  ];

	  var ALL = [ 'type', '$comment' ];
	  var KEYWORDS = [
	    '$schema', '$id', 'id', '$data', '$async', 'title',
	    'description', 'default', 'definitions',
	    'examples', 'readOnly', 'writeOnly',
	    'contentMediaType', 'contentEncoding',
	    'additionalItems', 'then', 'else'
	  ];
	  var TYPES = [ 'number', 'integer', 'string', 'array', 'object', 'boolean', 'null' ];
	  RULES.all = toHash(ALL);
	  RULES.types = toHash(TYPES);

	  RULES.forEach(function (group) {
	    group.rules = group.rules.map(function (keyword) {
	      var implKeywords;
	      if (typeof keyword == 'object') {
	        var key = Object.keys(keyword)[0];
	        implKeywords = keyword[key];
	        keyword = key;
	        implKeywords.forEach(function (k) {
	          ALL.push(k);
	          RULES.all[k] = true;
	        });
	      }
	      ALL.push(keyword);
	      var rule = RULES.all[keyword] = {
	        keyword: keyword,
	        code: ruleModules[keyword],
	        implements: implKeywords
	      };
	      return rule;
	    });

	    RULES.all.$comment = {
	      keyword: '$comment',
	      code: ruleModules.$comment
	    };

	    if (group.type) RULES.types[group.type] = group;
	  });

	  RULES.keywords = toHash(ALL.concat(KEYWORDS));
	  RULES.custom = {};

	  return RULES;
	};
	return rules$3;
}

var data;
var hasRequiredData;

function requireData () {
	if (hasRequiredData) return data;
	hasRequiredData = 1;

	var KEYWORDS = [
	  'multipleOf',
	  'maximum',
	  'exclusiveMaximum',
	  'minimum',
	  'exclusiveMinimum',
	  'maxLength',
	  'minLength',
	  'pattern',
	  'additionalItems',
	  'maxItems',
	  'minItems',
	  'uniqueItems',
	  'maxProperties',
	  'minProperties',
	  'required',
	  'additionalProperties',
	  'enum',
	  'format',
	  'const'
	];

	data = function (metaSchema, keywordsJsonPointers) {
	  for (var i=0; i<keywordsJsonPointers.length; i++) {
	    metaSchema = JSON.parse(JSON.stringify(metaSchema));
	    var segments = keywordsJsonPointers[i].split('/');
	    var keywords = metaSchema;
	    var j;
	    for (j=1; j<segments.length; j++)
	      keywords = keywords[segments[j]];

	    for (j=0; j<KEYWORDS.length; j++) {
	      var key = KEYWORDS[j];
	      var schema = keywords[key];
	      if (schema) {
	        keywords[key] = {
	          anyOf: [
	            schema,
	            { $ref: 'https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#' }
	          ]
	        };
	      }
	    }
	  }

	  return metaSchema;
	};
	return data;
}

var async;
var hasRequiredAsync;

function requireAsync () {
	if (hasRequiredAsync) return async;
	hasRequiredAsync = 1;

	var MissingRefError = requireError_classes().MissingRef;

	async = compileAsync;


	/**
	 * Creates validating function for passed schema with asynchronous loading of missing schemas.
	 * `loadSchema` option should be a function that accepts schema uri and returns promise that resolves with the schema.
	 * @this  Ajv
	 * @param {Object}   schema schema object
	 * @param {Boolean}  meta optional true to compile meta-schema; this parameter can be skipped
	 * @param {Function} callback an optional node-style callback, it is called with 2 parameters: error (or null) and validating function.
	 * @return {Promise} promise that resolves with a validating function.
	 */
	function compileAsync(schema, meta, callback) {
	  /* eslint no-shadow: 0 */
	  /* global Promise */
	  /* jshint validthis: true */
	  var self = this;
	  if (typeof this._opts.loadSchema != 'function')
	    throw new Error('options.loadSchema should be a function');

	  if (typeof meta == 'function') {
	    callback = meta;
	    meta = undefined;
	  }

	  var p = loadMetaSchemaOf(schema).then(function () {
	    var schemaObj = self._addSchema(schema, undefined, meta);
	    return schemaObj.validate || _compileAsync(schemaObj);
	  });

	  if (callback) {
	    p.then(
	      function(v) { callback(null, v); },
	      callback
	    );
	  }

	  return p;


	  function loadMetaSchemaOf(sch) {
	    var $schema = sch.$schema;
	    return $schema && !self.getSchema($schema)
	            ? compileAsync.call(self, { $ref: $schema }, true)
	            : Promise.resolve();
	  }


	  function _compileAsync(schemaObj) {
	    try { return self._compile(schemaObj); }
	    catch(e) {
	      if (e instanceof MissingRefError) return loadMissingSchema(e);
	      throw e;
	    }


	    function loadMissingSchema(e) {
	      var ref = e.missingSchema;
	      if (added(ref)) throw new Error('Schema ' + ref + ' is loaded but ' + e.missingRef + ' cannot be resolved');

	      var schemaPromise = self._loadingSchemas[ref];
	      if (!schemaPromise) {
	        schemaPromise = self._loadingSchemas[ref] = self._opts.loadSchema(ref);
	        schemaPromise.then(removePromise, removePromise);
	      }

	      return schemaPromise.then(function (sch) {
	        if (!added(ref)) {
	          return loadMetaSchemaOf(sch).then(function () {
	            if (!added(ref)) self.addSchema(sch, ref, undefined, meta);
	          });
	        }
	      }).then(function() {
	        return _compileAsync(schemaObj);
	      });

	      function removePromise() {
	        delete self._loadingSchemas[ref];
	      }

	      function added(ref) {
	        return self._refs[ref] || self._schemas[ref];
	      }
	    }
	  }
	}
	return async;
}

var custom;
var hasRequiredCustom;

function requireCustom () {
	if (hasRequiredCustom) return custom;
	hasRequiredCustom = 1;
	custom = function generate_custom(it, $keyword, $ruleType) {
	  var out = ' ';
	  var $lvl = it.level;
	  var $dataLvl = it.dataLevel;
	  var $schema = it.schema[$keyword];
	  var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
	  var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
	  var $breakOnError = !it.opts.allErrors;
	  var $errorKeyword;
	  var $data = 'data' + ($dataLvl || '');
	  var $valid = 'valid' + $lvl;
	  var $errs = 'errs__' + $lvl;
	  var $isData = it.opts.$data && $schema && $schema.$data,
	    $schemaValue;
	  if ($isData) {
	    out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
	    $schemaValue = 'schema' + $lvl;
	  } else {
	    $schemaValue = $schema;
	  }
	  var $rule = this,
	    $definition = 'definition' + $lvl,
	    $rDef = $rule.definition,
	    $closingBraces = '';
	  var $compile, $inline, $macro, $ruleValidate, $validateCode;
	  if ($isData && $rDef.$data) {
	    $validateCode = 'keywordValidate' + $lvl;
	    var $validateSchema = $rDef.validateSchema;
	    out += ' var ' + ($definition) + ' = RULES.custom[\'' + ($keyword) + '\'].definition; var ' + ($validateCode) + ' = ' + ($definition) + '.validate;';
	  } else {
	    $ruleValidate = it.useCustomRule($rule, $schema, it.schema, it);
	    if (!$ruleValidate) return;
	    $schemaValue = 'validate.schema' + $schemaPath;
	    $validateCode = $ruleValidate.code;
	    $compile = $rDef.compile;
	    $inline = $rDef.inline;
	    $macro = $rDef.macro;
	  }
	  var $ruleErrs = $validateCode + '.errors',
	    $i = 'i' + $lvl,
	    $ruleErr = 'ruleErr' + $lvl,
	    $asyncKeyword = $rDef.async;
	  if ($asyncKeyword && !it.async) throw new Error('async keyword in sync schema');
	  if (!($inline || $macro)) {
	    out += '' + ($ruleErrs) + ' = null;';
	  }
	  out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
	  if ($isData && $rDef.$data) {
	    $closingBraces += '}';
	    out += ' if (' + ($schemaValue) + ' === undefined) { ' + ($valid) + ' = true; } else { ';
	    if ($validateSchema) {
	      $closingBraces += '}';
	      out += ' ' + ($valid) + ' = ' + ($definition) + '.validateSchema(' + ($schemaValue) + '); if (' + ($valid) + ') { ';
	    }
	  }
	  if ($inline) {
	    if ($rDef.statements) {
	      out += ' ' + ($ruleValidate.validate) + ' ';
	    } else {
	      out += ' ' + ($valid) + ' = ' + ($ruleValidate.validate) + '; ';
	    }
	  } else if ($macro) {
	    var $it = it.util.copy(it);
	    var $closingBraces = '';
	    $it.level++;
	    var $nextValid = 'valid' + $it.level;
	    $it.schema = $ruleValidate.validate;
	    $it.schemaPath = '';
	    var $wasComposite = it.compositeRule;
	    it.compositeRule = $it.compositeRule = true;
	    var $code = it.validate($it).replace(/validate\.schema/g, $validateCode);
	    it.compositeRule = $it.compositeRule = $wasComposite;
	    out += ' ' + ($code);
	  } else {
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = '';
	    out += '  ' + ($validateCode) + '.call( ';
	    if (it.opts.passContext) {
	      out += 'this';
	    } else {
	      out += 'self';
	    }
	    if ($compile || $rDef.schema === false) {
	      out += ' , ' + ($data) + ' ';
	    } else {
	      out += ' , ' + ($schemaValue) + ' , ' + ($data) + ' , validate.schema' + (it.schemaPath) + ' ';
	    }
	    out += ' , (dataPath || \'\')';
	    if (it.errorPath != '""') {
	      out += ' + ' + (it.errorPath);
	    }
	    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData',
	      $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
	    out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ' , rootData )  ';
	    var def_callRuleValidate = out;
	    out = $$outStack.pop();
	    if ($rDef.errors === false) {
	      out += ' ' + ($valid) + ' = ';
	      if ($asyncKeyword) {
	        out += 'await ';
	      }
	      out += '' + (def_callRuleValidate) + '; ';
	    } else {
	      if ($asyncKeyword) {
	        $ruleErrs = 'customErrors' + $lvl;
	        out += ' var ' + ($ruleErrs) + ' = null; try { ' + ($valid) + ' = await ' + (def_callRuleValidate) + '; } catch (e) { ' + ($valid) + ' = false; if (e instanceof ValidationError) ' + ($ruleErrs) + ' = e.errors; else throw e; } ';
	      } else {
	        out += ' ' + ($ruleErrs) + ' = null; ' + ($valid) + ' = ' + (def_callRuleValidate) + '; ';
	      }
	    }
	  }
	  if ($rDef.modifying) {
	    out += ' if (' + ($parentData) + ') ' + ($data) + ' = ' + ($parentData) + '[' + ($parentDataProperty) + '];';
	  }
	  out += '' + ($closingBraces);
	  if ($rDef.valid) {
	    if ($breakOnError) {
	      out += ' if (true) { ';
	    }
	  } else {
	    out += ' if ( ';
	    if ($rDef.valid === undefined) {
	      out += ' !';
	      if ($macro) {
	        out += '' + ($nextValid);
	      } else {
	        out += '' + ($valid);
	      }
	    } else {
	      out += ' ' + (!$rDef.valid) + ' ';
	    }
	    out += ') { ';
	    $errorKeyword = $rule.keyword;
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = '';
	    var $$outStack = $$outStack || [];
	    $$outStack.push(out);
	    out = ''; /* istanbul ignore else */
	    if (it.createErrors !== false) {
	      out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
	      if (it.opts.messages !== false) {
	        out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
	      }
	      if (it.opts.verbose) {
	        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	      }
	      out += ' } ';
	    } else {
	      out += ' {} ';
	    }
	    var __err = out;
	    out = $$outStack.pop();
	    if (!it.compositeRule && $breakOnError) {
	      /* istanbul ignore if */
	      if (it.async) {
	        out += ' throw new ValidationError([' + (__err) + ']); ';
	      } else {
	        out += ' validate.errors = [' + (__err) + ']; return false; ';
	      }
	    } else {
	      out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	    }
	    var def_customError = out;
	    out = $$outStack.pop();
	    if ($inline) {
	      if ($rDef.errors) {
	        if ($rDef.errors != 'full') {
	          out += '  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
	          if (it.opts.verbose) {
	            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
	          }
	          out += ' } ';
	        }
	      } else {
	        if ($rDef.errors === false) {
	          out += ' ' + (def_customError) + ' ';
	        } else {
	          out += ' if (' + ($errs) + ' == errors) { ' + (def_customError) + ' } else {  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
	          if (it.opts.verbose) {
	            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
	          }
	          out += ' } } ';
	        }
	      }
	    } else if ($macro) {
	      out += '   var err =   '; /* istanbul ignore else */
	      if (it.createErrors !== false) {
	        out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
	        if (it.opts.messages !== false) {
	          out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
	        }
	        if (it.opts.verbose) {
	          out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
	        }
	        out += ' } ';
	      } else {
	        out += ' {} ';
	      }
	      out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
	      if (!it.compositeRule && $breakOnError) {
	        /* istanbul ignore if */
	        if (it.async) {
	          out += ' throw new ValidationError(vErrors); ';
	        } else {
	          out += ' validate.errors = vErrors; return false; ';
	        }
	      }
	    } else {
	      if ($rDef.errors === false) {
	        out += ' ' + (def_customError) + ' ';
	      } else {
	        out += ' if (Array.isArray(' + ($ruleErrs) + ')) { if (vErrors === null) vErrors = ' + ($ruleErrs) + '; else vErrors = vErrors.concat(' + ($ruleErrs) + '); errors = vErrors.length;  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + ';  ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '";  ';
	        if (it.opts.verbose) {
	          out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
	        }
	        out += ' } } else { ' + (def_customError) + ' } ';
	      }
	    }
	    out += ' } ';
	    if ($breakOnError) {
	      out += ' else { ';
	    }
	  }
	  return out;
	};
	return custom;
}

var $schema$2 = "http://json-schema.org/draft-07/schema#";
var $id$1 = "http://json-schema.org/draft-07/schema#";
var title = "Core schema meta-schema";
var definitions$1 = {
	schemaArray: {
		type: "array",
		minItems: 1,
		items: {
			$ref: "#"
		}
	},
	nonNegativeInteger: {
		type: "integer",
		minimum: 0
	},
	nonNegativeIntegerDefault0: {
		allOf: [
			{
				$ref: "#/definitions/nonNegativeInteger"
			},
			{
				"default": 0
			}
		]
	},
	simpleTypes: {
		"enum": [
			"array",
			"boolean",
			"integer",
			"null",
			"number",
			"object",
			"string"
		]
	},
	stringArray: {
		type: "array",
		items: {
			type: "string"
		},
		uniqueItems: true,
		"default": [
		]
	}
};
var type$2 = [
	"object",
	"boolean"
];
var properties$2 = {
	$id: {
		type: "string",
		format: "uri-reference"
	},
	$schema: {
		type: "string",
		format: "uri"
	},
	$ref: {
		type: "string",
		format: "uri-reference"
	},
	$comment: {
		type: "string"
	},
	title: {
		type: "string"
	},
	description: {
		type: "string"
	},
	"default": true,
	readOnly: {
		type: "boolean",
		"default": false
	},
	examples: {
		type: "array",
		items: true
	},
	multipleOf: {
		type: "number",
		exclusiveMinimum: 0
	},
	maximum: {
		type: "number"
	},
	exclusiveMaximum: {
		type: "number"
	},
	minimum: {
		type: "number"
	},
	exclusiveMinimum: {
		type: "number"
	},
	maxLength: {
		$ref: "#/definitions/nonNegativeInteger"
	},
	minLength: {
		$ref: "#/definitions/nonNegativeIntegerDefault0"
	},
	pattern: {
		type: "string",
		format: "regex"
	},
	additionalItems: {
		$ref: "#"
	},
	items: {
		anyOf: [
			{
				$ref: "#"
			},
			{
				$ref: "#/definitions/schemaArray"
			}
		],
		"default": true
	},
	maxItems: {
		$ref: "#/definitions/nonNegativeInteger"
	},
	minItems: {
		$ref: "#/definitions/nonNegativeIntegerDefault0"
	},
	uniqueItems: {
		type: "boolean",
		"default": false
	},
	contains: {
		$ref: "#"
	},
	maxProperties: {
		$ref: "#/definitions/nonNegativeInteger"
	},
	minProperties: {
		$ref: "#/definitions/nonNegativeIntegerDefault0"
	},
	required: {
		$ref: "#/definitions/stringArray"
	},
	additionalProperties: {
		$ref: "#"
	},
	definitions: {
		type: "object",
		additionalProperties: {
			$ref: "#"
		},
		"default": {
		}
	},
	properties: {
		type: "object",
		additionalProperties: {
			$ref: "#"
		},
		"default": {
		}
	},
	patternProperties: {
		type: "object",
		additionalProperties: {
			$ref: "#"
		},
		propertyNames: {
			format: "regex"
		},
		"default": {
		}
	},
	dependencies: {
		type: "object",
		additionalProperties: {
			anyOf: [
				{
					$ref: "#"
				},
				{
					$ref: "#/definitions/stringArray"
				}
			]
		}
	},
	propertyNames: {
		$ref: "#"
	},
	"const": true,
	"enum": {
		type: "array",
		items: true,
		minItems: 1,
		uniqueItems: true
	},
	type: {
		anyOf: [
			{
				$ref: "#/definitions/simpleTypes"
			},
			{
				type: "array",
				items: {
					$ref: "#/definitions/simpleTypes"
				},
				minItems: 1,
				uniqueItems: true
			}
		]
	},
	format: {
		type: "string"
	},
	contentMediaType: {
		type: "string"
	},
	contentEncoding: {
		type: "string"
	},
	"if": {
		$ref: "#"
	},
	then: {
		$ref: "#"
	},
	"else": {
		$ref: "#"
	},
	allOf: {
		$ref: "#/definitions/schemaArray"
	},
	anyOf: {
		$ref: "#/definitions/schemaArray"
	},
	oneOf: {
		$ref: "#/definitions/schemaArray"
	},
	not: {
		$ref: "#"
	}
};
var require$$13 = {
	$schema: $schema$2,
	$id: $id$1,
	title: title,
	definitions: definitions$1,
	type: type$2,
	properties: properties$2,
	"default": true
};

var definition_schema;
var hasRequiredDefinition_schema;

function requireDefinition_schema () {
	if (hasRequiredDefinition_schema) return definition_schema;
	hasRequiredDefinition_schema = 1;

	var metaSchema = require$$13;

	definition_schema = {
	  $id: 'https://github.com/ajv-validator/ajv/blob/master/lib/definition_schema.js',
	  definitions: {
	    simpleTypes: metaSchema.definitions.simpleTypes
	  },
	  type: 'object',
	  dependencies: {
	    schema: ['validate'],
	    $data: ['validate'],
	    statements: ['inline'],
	    valid: {not: {required: ['macro']}}
	  },
	  properties: {
	    type: metaSchema.properties.type,
	    schema: {type: 'boolean'},
	    statements: {type: 'boolean'},
	    dependencies: {
	      type: 'array',
	      items: {type: 'string'}
	    },
	    metaSchema: {type: 'object'},
	    modifying: {type: 'boolean'},
	    valid: {type: 'boolean'},
	    $data: {type: 'boolean'},
	    async: {type: 'boolean'},
	    errors: {
	      anyOf: [
	        {type: 'boolean'},
	        {const: 'full'}
	      ]
	    }
	  }
	};
	return definition_schema;
}

var keyword$1;
var hasRequiredKeyword$1;

function requireKeyword$1 () {
	if (hasRequiredKeyword$1) return keyword$1;
	hasRequiredKeyword$1 = 1;

	var IDENTIFIER = /^[a-z_$][a-z0-9_$-]*$/i;
	var customRuleCode = requireCustom();
	var definitionSchema = requireDefinition_schema();

	keyword$1 = {
	  add: addKeyword,
	  get: getKeyword,
	  remove: removeKeyword,
	  validate: validateKeyword
	};


	/**
	 * Define custom keyword
	 * @this  Ajv
	 * @param {String} keyword custom keyword, should be unique (including different from all standard, custom and macro keywords).
	 * @param {Object} definition keyword definition object with properties `type` (type(s) which the keyword applies to), `validate` or `compile`.
	 * @return {Ajv} this for method chaining
	 */
	function addKeyword(keyword, definition) {
	  /* jshint validthis: true */
	  /* eslint no-shadow: 0 */
	  var RULES = this.RULES;
	  if (RULES.keywords[keyword])
	    throw new Error('Keyword ' + keyword + ' is already defined');

	  if (!IDENTIFIER.test(keyword))
	    throw new Error('Keyword ' + keyword + ' is not a valid identifier');

	  if (definition) {
	    this.validateKeyword(definition, true);

	    var dataType = definition.type;
	    if (Array.isArray(dataType)) {
	      for (var i=0; i<dataType.length; i++)
	        _addRule(keyword, dataType[i], definition);
	    } else {
	      _addRule(keyword, dataType, definition);
	    }

	    var metaSchema = definition.metaSchema;
	    if (metaSchema) {
	      if (definition.$data && this._opts.$data) {
	        metaSchema = {
	          anyOf: [
	            metaSchema,
	            { '$ref': 'https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#' }
	          ]
	        };
	      }
	      definition.validateSchema = this.compile(metaSchema, true);
	    }
	  }

	  RULES.keywords[keyword] = RULES.all[keyword] = true;


	  function _addRule(keyword, dataType, definition) {
	    var ruleGroup;
	    for (var i=0; i<RULES.length; i++) {
	      var rg = RULES[i];
	      if (rg.type == dataType) {
	        ruleGroup = rg;
	        break;
	      }
	    }

	    if (!ruleGroup) {
	      ruleGroup = { type: dataType, rules: [] };
	      RULES.push(ruleGroup);
	    }

	    var rule = {
	      keyword: keyword,
	      definition: definition,
	      custom: true,
	      code: customRuleCode,
	      implements: definition.implements
	    };
	    ruleGroup.rules.push(rule);
	    RULES.custom[keyword] = rule;
	  }

	  return this;
	}


	/**
	 * Get keyword
	 * @this  Ajv
	 * @param {String} keyword pre-defined or custom keyword.
	 * @return {Object|Boolean} custom keyword definition, `true` if it is a predefined keyword, `false` otherwise.
	 */
	function getKeyword(keyword) {
	  /* jshint validthis: true */
	  var rule = this.RULES.custom[keyword];
	  return rule ? rule.definition : this.RULES.keywords[keyword] || false;
	}


	/**
	 * Remove keyword
	 * @this  Ajv
	 * @param {String} keyword pre-defined or custom keyword.
	 * @return {Ajv} this for method chaining
	 */
	function removeKeyword(keyword) {
	  /* jshint validthis: true */
	  var RULES = this.RULES;
	  delete RULES.keywords[keyword];
	  delete RULES.all[keyword];
	  delete RULES.custom[keyword];
	  for (var i=0; i<RULES.length; i++) {
	    var rules = RULES[i].rules;
	    for (var j=0; j<rules.length; j++) {
	      if (rules[j].keyword == keyword) {
	        rules.splice(j, 1);
	        break;
	      }
	    }
	  }
	  return this;
	}


	/**
	 * Validate keyword definition
	 * @this  Ajv
	 * @param {Object} definition keyword definition object.
	 * @param {Boolean} throwError true to throw exception if definition is invalid
	 * @return {boolean} validation result
	 */
	function validateKeyword(definition, throwError) {
	  validateKeyword.errors = null;
	  var v = this._validateKeyword = this._validateKeyword
	                                  || this.compile(definitionSchema, true);

	  if (v(definition)) return true;
	  validateKeyword.errors = v.errors;
	  if (throwError)
	    throw new Error('custom keyword definition is invalid: '  + this.errorsText(v.errors));
	  else
	    return false;
	}
	return keyword$1;
}

var $schema$1 = "http://json-schema.org/draft-07/schema#";
var $id = "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#";
var description$1 = "Meta-schema for $data reference (JSON Schema extension proposal)";
var type$1 = "object";
var required = [
	"$data"
];
var properties$1 = {
	$data: {
		type: "string",
		anyOf: [
			{
				format: "relative-json-pointer"
			},
			{
				format: "json-pointer"
			}
		]
	}
};
var additionalProperties = false;
var require$$12 = {
	$schema: $schema$1,
	$id: $id,
	description: description$1,
	type: type$1,
	required: required,
	properties: properties$1,
	additionalProperties: additionalProperties
};

var ajv$1;
var hasRequiredAjv$1;

function requireAjv$1 () {
	if (hasRequiredAjv$1) return ajv$1;
	hasRequiredAjv$1 = 1;

	var compileSchema = requireCompile()
	  , resolve = requireResolve()
	  , Cache = requireCache()
	  , SchemaObject = requireSchema_obj()
	  , stableStringify = requireFastJsonStableStringify()
	  , formats = requireFormats()
	  , rules = requireRules$2()
	  , $dataMetaSchema = requireData()
	  , util = requireUtil();

	ajv$1 = Ajv;

	Ajv.prototype.validate = validate;
	Ajv.prototype.compile = compile;
	Ajv.prototype.addSchema = addSchema;
	Ajv.prototype.addMetaSchema = addMetaSchema;
	Ajv.prototype.validateSchema = validateSchema;
	Ajv.prototype.getSchema = getSchema;
	Ajv.prototype.removeSchema = removeSchema;
	Ajv.prototype.addFormat = addFormat;
	Ajv.prototype.errorsText = errorsText;

	Ajv.prototype._addSchema = _addSchema;
	Ajv.prototype._compile = _compile;

	Ajv.prototype.compileAsync = requireAsync();
	var customKeyword = requireKeyword$1();
	Ajv.prototype.addKeyword = customKeyword.add;
	Ajv.prototype.getKeyword = customKeyword.get;
	Ajv.prototype.removeKeyword = customKeyword.remove;
	Ajv.prototype.validateKeyword = customKeyword.validate;

	var errorClasses = requireError_classes();
	Ajv.ValidationError = errorClasses.Validation;
	Ajv.MissingRefError = errorClasses.MissingRef;
	Ajv.$dataMetaSchema = $dataMetaSchema;

	var META_SCHEMA_ID = 'http://json-schema.org/draft-07/schema';

	var META_IGNORE_OPTIONS = [ 'removeAdditional', 'useDefaults', 'coerceTypes', 'strictDefaults' ];
	var META_SUPPORT_DATA = ['/properties'];

	/**
	 * Creates validator instance.
	 * Usage: `Ajv(opts)`
	 * @param {Object} opts optional options
	 * @return {Object} ajv instance
	 */
	function Ajv(opts) {
	  if (!(this instanceof Ajv)) return new Ajv(opts);
	  opts = this._opts = util.copy(opts) || {};
	  setLogger(this);
	  this._schemas = {};
	  this._refs = {};
	  this._fragments = {};
	  this._formats = formats(opts.format);

	  this._cache = opts.cache || new Cache;
	  this._loadingSchemas = {};
	  this._compilations = [];
	  this.RULES = rules();
	  this._getId = chooseGetId(opts);

	  opts.loopRequired = opts.loopRequired || Infinity;
	  if (opts.errorDataPath == 'property') opts._errorDataPathProperty = true;
	  if (opts.serialize === undefined) opts.serialize = stableStringify;
	  this._metaOpts = getMetaSchemaOptions(this);

	  if (opts.formats) addInitialFormats(this);
	  if (opts.keywords) addInitialKeywords(this);
	  addDefaultMetaSchema(this);
	  if (typeof opts.meta == 'object') this.addMetaSchema(opts.meta);
	  if (opts.nullable) this.addKeyword('nullable', {metaSchema: {type: 'boolean'}});
	  addInitialSchemas(this);
	}



	/**
	 * Validate data using schema
	 * Schema will be compiled and cached (using serialized JSON as key. [fast-json-stable-stringify](https://github.com/epoberezkin/fast-json-stable-stringify) is used to serialize.
	 * @this   Ajv
	 * @param  {String|Object} schemaKeyRef key, ref or schema object
	 * @param  {Any} data to be validated
	 * @return {Boolean} validation result. Errors from the last validation will be available in `ajv.errors` (and also in compiled schema: `schema.errors`).
	 */
	function validate(schemaKeyRef, data) {
	  var v;
	  if (typeof schemaKeyRef == 'string') {
	    v = this.getSchema(schemaKeyRef);
	    if (!v) throw new Error('no schema with key or ref "' + schemaKeyRef + '"');
	  } else {
	    var schemaObj = this._addSchema(schemaKeyRef);
	    v = schemaObj.validate || this._compile(schemaObj);
	  }

	  var valid = v(data);
	  if (v.$async !== true) this.errors = v.errors;
	  return valid;
	}


	/**
	 * Create validating function for passed schema.
	 * @this   Ajv
	 * @param  {Object} schema schema object
	 * @param  {Boolean} _meta true if schema is a meta-schema. Used internally to compile meta schemas of custom keywords.
	 * @return {Function} validating function
	 */
	function compile(schema, _meta) {
	  var schemaObj = this._addSchema(schema, undefined, _meta);
	  return schemaObj.validate || this._compile(schemaObj);
	}


	/**
	 * Adds schema to the instance.
	 * @this   Ajv
	 * @param {Object|Array} schema schema or array of schemas. If array is passed, `key` and other parameters will be ignored.
	 * @param {String} key Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
	 * @param {Boolean} _skipValidation true to skip schema validation. Used internally, option validateSchema should be used instead.
	 * @param {Boolean} _meta true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
	 * @return {Ajv} this for method chaining
	 */
	function addSchema(schema, key, _skipValidation, _meta) {
	  if (Array.isArray(schema)){
	    for (var i=0; i<schema.length; i++) this.addSchema(schema[i], undefined, _skipValidation, _meta);
	    return this;
	  }
	  var id = this._getId(schema);
	  if (id !== undefined && typeof id != 'string')
	    throw new Error('schema id must be string');
	  key = resolve.normalizeId(key || id);
	  checkUnique(this, key);
	  this._schemas[key] = this._addSchema(schema, _skipValidation, _meta, true);
	  return this;
	}


	/**
	 * Add schema that will be used to validate other schemas
	 * options in META_IGNORE_OPTIONS are alway set to false
	 * @this   Ajv
	 * @param {Object} schema schema object
	 * @param {String} key optional schema key
	 * @param {Boolean} skipValidation true to skip schema validation, can be used to override validateSchema option for meta-schema
	 * @return {Ajv} this for method chaining
	 */
	function addMetaSchema(schema, key, skipValidation) {
	  this.addSchema(schema, key, skipValidation, true);
	  return this;
	}


	/**
	 * Validate schema
	 * @this   Ajv
	 * @param {Object} schema schema to validate
	 * @param {Boolean} throwOrLogError pass true to throw (or log) an error if invalid
	 * @return {Boolean} true if schema is valid
	 */
	function validateSchema(schema, throwOrLogError) {
	  var $schema = schema.$schema;
	  if ($schema !== undefined && typeof $schema != 'string')
	    throw new Error('$schema must be a string');
	  $schema = $schema || this._opts.defaultMeta || defaultMeta(this);
	  if (!$schema) {
	    this.logger.warn('meta-schema not available');
	    this.errors = null;
	    return true;
	  }
	  var valid = this.validate($schema, schema);
	  if (!valid && throwOrLogError) {
	    var message = 'schema is invalid: ' + this.errorsText();
	    if (this._opts.validateSchema == 'log') this.logger.error(message);
	    else throw new Error(message);
	  }
	  return valid;
	}


	function defaultMeta(self) {
	  var meta = self._opts.meta;
	  self._opts.defaultMeta = typeof meta == 'object'
	                            ? self._getId(meta) || meta
	                            : self.getSchema(META_SCHEMA_ID)
	                              ? META_SCHEMA_ID
	                              : undefined;
	  return self._opts.defaultMeta;
	}


	/**
	 * Get compiled schema from the instance by `key` or `ref`.
	 * @this   Ajv
	 * @param  {String} keyRef `key` that was passed to `addSchema` or full schema reference (`schema.id` or resolved id).
	 * @return {Function} schema validating function (with property `schema`).
	 */
	function getSchema(keyRef) {
	  var schemaObj = _getSchemaObj(this, keyRef);
	  switch (typeof schemaObj) {
	    case 'object': return schemaObj.validate || this._compile(schemaObj);
	    case 'string': return this.getSchema(schemaObj);
	    case 'undefined': return _getSchemaFragment(this, keyRef);
	  }
	}


	function _getSchemaFragment(self, ref) {
	  var res = resolve.schema.call(self, { schema: {} }, ref);
	  if (res) {
	    var schema = res.schema
	      , root = res.root
	      , baseId = res.baseId;
	    var v = compileSchema.call(self, schema, root, undefined, baseId);
	    self._fragments[ref] = new SchemaObject({
	      ref: ref,
	      fragment: true,
	      schema: schema,
	      root: root,
	      baseId: baseId,
	      validate: v
	    });
	    return v;
	  }
	}


	function _getSchemaObj(self, keyRef) {
	  keyRef = resolve.normalizeId(keyRef);
	  return self._schemas[keyRef] || self._refs[keyRef] || self._fragments[keyRef];
	}


	/**
	 * Remove cached schema(s).
	 * If no parameter is passed all schemas but meta-schemas are removed.
	 * If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
	 * Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
	 * @this   Ajv
	 * @param  {String|Object|RegExp} schemaKeyRef key, ref, pattern to match key/ref or schema object
	 * @return {Ajv} this for method chaining
	 */
	function removeSchema(schemaKeyRef) {
	  if (schemaKeyRef instanceof RegExp) {
	    _removeAllSchemas(this, this._schemas, schemaKeyRef);
	    _removeAllSchemas(this, this._refs, schemaKeyRef);
	    return this;
	  }
	  switch (typeof schemaKeyRef) {
	    case 'undefined':
	      _removeAllSchemas(this, this._schemas);
	      _removeAllSchemas(this, this._refs);
	      this._cache.clear();
	      return this;
	    case 'string':
	      var schemaObj = _getSchemaObj(this, schemaKeyRef);
	      if (schemaObj) this._cache.del(schemaObj.cacheKey);
	      delete this._schemas[schemaKeyRef];
	      delete this._refs[schemaKeyRef];
	      return this;
	    case 'object':
	      var serialize = this._opts.serialize;
	      var cacheKey = serialize ? serialize(schemaKeyRef) : schemaKeyRef;
	      this._cache.del(cacheKey);
	      var id = this._getId(schemaKeyRef);
	      if (id) {
	        id = resolve.normalizeId(id);
	        delete this._schemas[id];
	        delete this._refs[id];
	      }
	  }
	  return this;
	}


	function _removeAllSchemas(self, schemas, regex) {
	  for (var keyRef in schemas) {
	    var schemaObj = schemas[keyRef];
	    if (!schemaObj.meta && (!regex || regex.test(keyRef))) {
	      self._cache.del(schemaObj.cacheKey);
	      delete schemas[keyRef];
	    }
	  }
	}


	/* @this   Ajv */
	function _addSchema(schema, skipValidation, meta, shouldAddSchema) {
	  if (typeof schema != 'object' && typeof schema != 'boolean')
	    throw new Error('schema should be object or boolean');
	  var serialize = this._opts.serialize;
	  var cacheKey = serialize ? serialize(schema) : schema;
	  var cached = this._cache.get(cacheKey);
	  if (cached) return cached;

	  shouldAddSchema = shouldAddSchema || this._opts.addUsedSchema !== false;

	  var id = resolve.normalizeId(this._getId(schema));
	  if (id && shouldAddSchema) checkUnique(this, id);

	  var willValidate = this._opts.validateSchema !== false && !skipValidation;
	  var recursiveMeta;
	  if (willValidate && !(recursiveMeta = id && id == resolve.normalizeId(schema.$schema)))
	    this.validateSchema(schema, true);

	  var localRefs = resolve.ids.call(this, schema);

	  var schemaObj = new SchemaObject({
	    id: id,
	    schema: schema,
	    localRefs: localRefs,
	    cacheKey: cacheKey,
	    meta: meta
	  });

	  if (id[0] != '#' && shouldAddSchema) this._refs[id] = schemaObj;
	  this._cache.put(cacheKey, schemaObj);

	  if (willValidate && recursiveMeta) this.validateSchema(schema, true);

	  return schemaObj;
	}


	/* @this   Ajv */
	function _compile(schemaObj, root) {
	  if (schemaObj.compiling) {
	    schemaObj.validate = callValidate;
	    callValidate.schema = schemaObj.schema;
	    callValidate.errors = null;
	    callValidate.root = root ? root : callValidate;
	    if (schemaObj.schema.$async === true)
	      callValidate.$async = true;
	    return callValidate;
	  }
	  schemaObj.compiling = true;

	  var currentOpts;
	  if (schemaObj.meta) {
	    currentOpts = this._opts;
	    this._opts = this._metaOpts;
	  }

	  var v;
	  try { v = compileSchema.call(this, schemaObj.schema, root, schemaObj.localRefs); }
	  catch(e) {
	    delete schemaObj.validate;
	    throw e;
	  }
	  finally {
	    schemaObj.compiling = false;
	    if (schemaObj.meta) this._opts = currentOpts;
	  }

	  schemaObj.validate = v;
	  schemaObj.refs = v.refs;
	  schemaObj.refVal = v.refVal;
	  schemaObj.root = v.root;
	  return v;


	  /* @this   {*} - custom context, see passContext option */
	  function callValidate() {
	    /* jshint validthis: true */
	    var _validate = schemaObj.validate;
	    var result = _validate.apply(this, arguments);
	    callValidate.errors = _validate.errors;
	    return result;
	  }
	}


	function chooseGetId(opts) {
	  switch (opts.schemaId) {
	    case 'auto': return _get$IdOrId;
	    case 'id': return _getId;
	    default: return _get$Id;
	  }
	}

	/* @this   Ajv */
	function _getId(schema) {
	  if (schema.$id) this.logger.warn('schema $id ignored', schema.$id);
	  return schema.id;
	}

	/* @this   Ajv */
	function _get$Id(schema) {
	  if (schema.id) this.logger.warn('schema id ignored', schema.id);
	  return schema.$id;
	}


	function _get$IdOrId(schema) {
	  if (schema.$id && schema.id && schema.$id != schema.id)
	    throw new Error('schema $id is different from id');
	  return schema.$id || schema.id;
	}


	/**
	 * Convert array of error message objects to string
	 * @this   Ajv
	 * @param  {Array<Object>} errors optional array of validation errors, if not passed errors from the instance are used.
	 * @param  {Object} options optional options with properties `separator` and `dataVar`.
	 * @return {String} human readable string with all errors descriptions
	 */
	function errorsText(errors, options) {
	  errors = errors || this.errors;
	  if (!errors) return 'No errors';
	  options = options || {};
	  var separator = options.separator === undefined ? ', ' : options.separator;
	  var dataVar = options.dataVar === undefined ? 'data' : options.dataVar;

	  var text = '';
	  for (var i=0; i<errors.length; i++) {
	    var e = errors[i];
	    if (e) text += dataVar + e.dataPath + ' ' + e.message + separator;
	  }
	  return text.slice(0, -separator.length);
	}


	/**
	 * Add custom format
	 * @this   Ajv
	 * @param {String} name format name
	 * @param {String|RegExp|Function} format string is converted to RegExp; function should return boolean (true when valid)
	 * @return {Ajv} this for method chaining
	 */
	function addFormat(name, format) {
	  if (typeof format == 'string') format = new RegExp(format);
	  this._formats[name] = format;
	  return this;
	}


	function addDefaultMetaSchema(self) {
	  var $dataSchema;
	  if (self._opts.$data) {
	    $dataSchema = require$$12;
	    self.addMetaSchema($dataSchema, $dataSchema.$id, true);
	  }
	  if (self._opts.meta === false) return;
	  var metaSchema = require$$13;
	  if (self._opts.$data) metaSchema = $dataMetaSchema(metaSchema, META_SUPPORT_DATA);
	  self.addMetaSchema(metaSchema, META_SCHEMA_ID, true);
	  self._refs['http://json-schema.org/schema'] = META_SCHEMA_ID;
	}


	function addInitialSchemas(self) {
	  var optsSchemas = self._opts.schemas;
	  if (!optsSchemas) return;
	  if (Array.isArray(optsSchemas)) self.addSchema(optsSchemas);
	  else for (var key in optsSchemas) self.addSchema(optsSchemas[key], key);
	}


	function addInitialFormats(self) {
	  for (var name in self._opts.formats) {
	    var format = self._opts.formats[name];
	    self.addFormat(name, format);
	  }
	}


	function addInitialKeywords(self) {
	  for (var name in self._opts.keywords) {
	    var keyword = self._opts.keywords[name];
	    self.addKeyword(name, keyword);
	  }
	}


	function checkUnique(self, id) {
	  if (self._schemas[id] || self._refs[id])
	    throw new Error('schema with key or id "' + id + '" already exists');
	}


	function getMetaSchemaOptions(self) {
	  var metaOpts = util.copy(self._opts);
	  for (var i=0; i<META_IGNORE_OPTIONS.length; i++)
	    delete metaOpts[META_IGNORE_OPTIONS[i]];
	  return metaOpts;
	}


	function setLogger(self) {
	  var logger = self._opts.logger;
	  if (logger === false) {
	    self.logger = {log: noop, warn: noop, error: noop};
	  } else {
	    if (logger === undefined) logger = console;
	    if (!(typeof logger == 'object' && logger.log && logger.warn && logger.error))
	      throw new Error('logger must implement log, warn and error methods');
	    self.logger = logger;
	  }
	}


	function noop() {}
	return ajv$1;
}

var builtin = {
	AggregateError: false,
	"Array": false,
	"ArrayBuffer": false,
	Atomics: false,
	BigInt: false,
	BigInt64Array: false,
	BigUint64Array: false,
	"Boolean": false,
	constructor: false,
	"DataView": false,
	"Date": false,
	"decodeURI": false,
	"decodeURIComponent": false,
	"encodeURI": false,
	"encodeURIComponent": false,
	"Error": false,
	"escape": false,
	"eval": false,
	"EvalError": false,
	FinalizationRegistry: false,
	"Float32Array": false,
	"Float64Array": false,
	"Function": false,
	globalThis: false,
	hasOwnProperty: false,
	"Infinity": false,
	"Int16Array": false,
	"Int32Array": false,
	"Int8Array": false,
	"isFinite": false,
	"isNaN": false,
	isPrototypeOf: false,
	"JSON": false,
	"Map": false,
	"Math": false,
	"NaN": false,
	"Number": false,
	"Object": false,
	"parseFloat": false,
	"parseInt": false,
	"Promise": false,
	propertyIsEnumerable: false,
	"Proxy": false,
	"RangeError": false,
	"ReferenceError": false,
	"Reflect": false,
	"RegExp": false,
	"Set": false,
	SharedArrayBuffer: false,
	"String": false,
	"Symbol": false,
	"SyntaxError": false,
	toLocaleString: false,
	toString: false,
	"TypeError": false,
	"Uint16Array": false,
	"Uint32Array": false,
	"Uint8Array": false,
	"Uint8ClampedArray": false,
	"undefined": false,
	"unescape": false,
	"URIError": false,
	valueOf: false,
	"WeakMap": false,
	WeakRef: false,
	"WeakSet": false
};
var es5 = {
	"Array": false,
	"Boolean": false,
	constructor: false,
	"Date": false,
	"decodeURI": false,
	"decodeURIComponent": false,
	"encodeURI": false,
	"encodeURIComponent": false,
	"Error": false,
	"escape": false,
	"eval": false,
	"EvalError": false,
	"Function": false,
	hasOwnProperty: false,
	"Infinity": false,
	"isFinite": false,
	"isNaN": false,
	isPrototypeOf: false,
	"JSON": false,
	"Math": false,
	"NaN": false,
	"Number": false,
	"Object": false,
	"parseFloat": false,
	"parseInt": false,
	propertyIsEnumerable: false,
	"RangeError": false,
	"ReferenceError": false,
	"RegExp": false,
	"String": false,
	"SyntaxError": false,
	toLocaleString: false,
	toString: false,
	"TypeError": false,
	"undefined": false,
	"unescape": false,
	"URIError": false,
	valueOf: false
};
var es2015 = {
	"Array": false,
	"ArrayBuffer": false,
	"Boolean": false,
	constructor: false,
	"DataView": false,
	"Date": false,
	"decodeURI": false,
	"decodeURIComponent": false,
	"encodeURI": false,
	"encodeURIComponent": false,
	"Error": false,
	"escape": false,
	"eval": false,
	"EvalError": false,
	"Float32Array": false,
	"Float64Array": false,
	"Function": false,
	hasOwnProperty: false,
	"Infinity": false,
	"Int16Array": false,
	"Int32Array": false,
	"Int8Array": false,
	"isFinite": false,
	"isNaN": false,
	isPrototypeOf: false,
	"JSON": false,
	"Map": false,
	"Math": false,
	"NaN": false,
	"Number": false,
	"Object": false,
	"parseFloat": false,
	"parseInt": false,
	"Promise": false,
	propertyIsEnumerable: false,
	"Proxy": false,
	"RangeError": false,
	"ReferenceError": false,
	"Reflect": false,
	"RegExp": false,
	"Set": false,
	"String": false,
	"Symbol": false,
	"SyntaxError": false,
	toLocaleString: false,
	toString: false,
	"TypeError": false,
	"Uint16Array": false,
	"Uint32Array": false,
	"Uint8Array": false,
	"Uint8ClampedArray": false,
	"undefined": false,
	"unescape": false,
	"URIError": false,
	valueOf: false,
	"WeakMap": false,
	"WeakSet": false
};
var es2017 = {
	"Array": false,
	"ArrayBuffer": false,
	Atomics: false,
	"Boolean": false,
	constructor: false,
	"DataView": false,
	"Date": false,
	"decodeURI": false,
	"decodeURIComponent": false,
	"encodeURI": false,
	"encodeURIComponent": false,
	"Error": false,
	"escape": false,
	"eval": false,
	"EvalError": false,
	"Float32Array": false,
	"Float64Array": false,
	"Function": false,
	hasOwnProperty: false,
	"Infinity": false,
	"Int16Array": false,
	"Int32Array": false,
	"Int8Array": false,
	"isFinite": false,
	"isNaN": false,
	isPrototypeOf: false,
	"JSON": false,
	"Map": false,
	"Math": false,
	"NaN": false,
	"Number": false,
	"Object": false,
	"parseFloat": false,
	"parseInt": false,
	"Promise": false,
	propertyIsEnumerable: false,
	"Proxy": false,
	"RangeError": false,
	"ReferenceError": false,
	"Reflect": false,
	"RegExp": false,
	"Set": false,
	SharedArrayBuffer: false,
	"String": false,
	"Symbol": false,
	"SyntaxError": false,
	toLocaleString: false,
	toString: false,
	"TypeError": false,
	"Uint16Array": false,
	"Uint32Array": false,
	"Uint8Array": false,
	"Uint8ClampedArray": false,
	"undefined": false,
	"unescape": false,
	"URIError": false,
	valueOf: false,
	"WeakMap": false,
	"WeakSet": false
};
var es2020 = {
	"Array": false,
	"ArrayBuffer": false,
	Atomics: false,
	BigInt: false,
	BigInt64Array: false,
	BigUint64Array: false,
	"Boolean": false,
	constructor: false,
	"DataView": false,
	"Date": false,
	"decodeURI": false,
	"decodeURIComponent": false,
	"encodeURI": false,
	"encodeURIComponent": false,
	"Error": false,
	"escape": false,
	"eval": false,
	"EvalError": false,
	"Float32Array": false,
	"Float64Array": false,
	"Function": false,
	globalThis: false,
	hasOwnProperty: false,
	"Infinity": false,
	"Int16Array": false,
	"Int32Array": false,
	"Int8Array": false,
	"isFinite": false,
	"isNaN": false,
	isPrototypeOf: false,
	"JSON": false,
	"Map": false,
	"Math": false,
	"NaN": false,
	"Number": false,
	"Object": false,
	"parseFloat": false,
	"parseInt": false,
	"Promise": false,
	propertyIsEnumerable: false,
	"Proxy": false,
	"RangeError": false,
	"ReferenceError": false,
	"Reflect": false,
	"RegExp": false,
	"Set": false,
	SharedArrayBuffer: false,
	"String": false,
	"Symbol": false,
	"SyntaxError": false,
	toLocaleString: false,
	toString: false,
	"TypeError": false,
	"Uint16Array": false,
	"Uint32Array": false,
	"Uint8Array": false,
	"Uint8ClampedArray": false,
	"undefined": false,
	"unescape": false,
	"URIError": false,
	valueOf: false,
	"WeakMap": false,
	"WeakSet": false
};
var es2021 = {
	AggregateError: false,
	"Array": false,
	"ArrayBuffer": false,
	Atomics: false,
	BigInt: false,
	BigInt64Array: false,
	BigUint64Array: false,
	"Boolean": false,
	constructor: false,
	"DataView": false,
	"Date": false,
	"decodeURI": false,
	"decodeURIComponent": false,
	"encodeURI": false,
	"encodeURIComponent": false,
	"Error": false,
	"escape": false,
	"eval": false,
	"EvalError": false,
	FinalizationRegistry: false,
	"Float32Array": false,
	"Float64Array": false,
	"Function": false,
	globalThis: false,
	hasOwnProperty: false,
	"Infinity": false,
	"Int16Array": false,
	"Int32Array": false,
	"Int8Array": false,
	"isFinite": false,
	"isNaN": false,
	isPrototypeOf: false,
	"JSON": false,
	"Map": false,
	"Math": false,
	"NaN": false,
	"Number": false,
	"Object": false,
	"parseFloat": false,
	"parseInt": false,
	"Promise": false,
	propertyIsEnumerable: false,
	"Proxy": false,
	"RangeError": false,
	"ReferenceError": false,
	"Reflect": false,
	"RegExp": false,
	"Set": false,
	SharedArrayBuffer: false,
	"String": false,
	"Symbol": false,
	"SyntaxError": false,
	toLocaleString: false,
	toString: false,
	"TypeError": false,
	"Uint16Array": false,
	"Uint32Array": false,
	"Uint8Array": false,
	"Uint8ClampedArray": false,
	"undefined": false,
	"unescape": false,
	"URIError": false,
	valueOf: false,
	"WeakMap": false,
	WeakRef: false,
	"WeakSet": false
};
var browser$1 = {
	AbortController: false,
	AbortSignal: false,
	addEventListener: false,
	alert: false,
	AnalyserNode: false,
	Animation: false,
	AnimationEffectReadOnly: false,
	AnimationEffectTiming: false,
	AnimationEffectTimingReadOnly: false,
	AnimationEvent: false,
	AnimationPlaybackEvent: false,
	AnimationTimeline: false,
	applicationCache: false,
	ApplicationCache: false,
	ApplicationCacheErrorEvent: false,
	atob: false,
	Attr: false,
	Audio: false,
	AudioBuffer: false,
	AudioBufferSourceNode: false,
	AudioContext: false,
	AudioDestinationNode: false,
	AudioListener: false,
	AudioNode: false,
	AudioParam: false,
	AudioProcessingEvent: false,
	AudioScheduledSourceNode: false,
	AudioWorkletGlobalScope: false,
	AudioWorkletNode: false,
	AudioWorkletProcessor: false,
	BarProp: false,
	BaseAudioContext: false,
	BatteryManager: false,
	BeforeUnloadEvent: false,
	BiquadFilterNode: false,
	Blob: false,
	BlobEvent: false,
	blur: false,
	BroadcastChannel: false,
	btoa: false,
	BudgetService: false,
	ByteLengthQueuingStrategy: false,
	Cache: false,
	caches: false,
	CacheStorage: false,
	cancelAnimationFrame: false,
	cancelIdleCallback: false,
	CanvasCaptureMediaStreamTrack: false,
	CanvasGradient: false,
	CanvasPattern: false,
	CanvasRenderingContext2D: false,
	ChannelMergerNode: false,
	ChannelSplitterNode: false,
	CharacterData: false,
	clearInterval: false,
	clearTimeout: false,
	clientInformation: false,
	ClipboardEvent: false,
	ClipboardItem: false,
	close: false,
	closed: false,
	CloseEvent: false,
	Comment: false,
	CompositionEvent: false,
	CompressionStream: false,
	confirm: false,
	console: false,
	ConstantSourceNode: false,
	ConvolverNode: false,
	CountQueuingStrategy: false,
	createImageBitmap: false,
	Credential: false,
	CredentialsContainer: false,
	crypto: false,
	Crypto: false,
	CryptoKey: false,
	CSS: false,
	CSSConditionRule: false,
	CSSFontFaceRule: false,
	CSSGroupingRule: false,
	CSSImportRule: false,
	CSSKeyframeRule: false,
	CSSKeyframesRule: false,
	CSSMatrixComponent: false,
	CSSMediaRule: false,
	CSSNamespaceRule: false,
	CSSPageRule: false,
	CSSPerspective: false,
	CSSRotate: false,
	CSSRule: false,
	CSSRuleList: false,
	CSSScale: false,
	CSSSkew: false,
	CSSSkewX: false,
	CSSSkewY: false,
	CSSStyleDeclaration: false,
	CSSStyleRule: false,
	CSSStyleSheet: false,
	CSSSupportsRule: false,
	CSSTransformValue: false,
	CSSTranslate: false,
	CustomElementRegistry: false,
	customElements: false,
	CustomEvent: false,
	DataTransfer: false,
	DataTransferItem: false,
	DataTransferItemList: false,
	DecompressionStream: false,
	defaultstatus: false,
	defaultStatus: false,
	DelayNode: false,
	DeviceMotionEvent: false,
	DeviceOrientationEvent: false,
	devicePixelRatio: false,
	dispatchEvent: false,
	document: false,
	Document: false,
	DocumentFragment: false,
	DocumentType: false,
	DOMError: false,
	DOMException: false,
	DOMImplementation: false,
	DOMMatrix: false,
	DOMMatrixReadOnly: false,
	DOMParser: false,
	DOMPoint: false,
	DOMPointReadOnly: false,
	DOMQuad: false,
	DOMRect: false,
	DOMRectList: false,
	DOMRectReadOnly: false,
	DOMStringList: false,
	DOMStringMap: false,
	DOMTokenList: false,
	DragEvent: false,
	DynamicsCompressorNode: false,
	Element: false,
	ErrorEvent: false,
	event: false,
	Event: false,
	EventSource: false,
	EventTarget: false,
	external: false,
	fetch: false,
	File: false,
	FileList: false,
	FileReader: false,
	find: false,
	focus: false,
	FocusEvent: false,
	FontFace: false,
	FontFaceSetLoadEvent: false,
	FormData: false,
	FormDataEvent: false,
	frameElement: false,
	frames: false,
	GainNode: false,
	Gamepad: false,
	GamepadButton: false,
	GamepadEvent: false,
	getComputedStyle: false,
	getSelection: false,
	HashChangeEvent: false,
	Headers: false,
	history: false,
	History: false,
	HTMLAllCollection: false,
	HTMLAnchorElement: false,
	HTMLAreaElement: false,
	HTMLAudioElement: false,
	HTMLBaseElement: false,
	HTMLBodyElement: false,
	HTMLBRElement: false,
	HTMLButtonElement: false,
	HTMLCanvasElement: false,
	HTMLCollection: false,
	HTMLContentElement: false,
	HTMLDataElement: false,
	HTMLDataListElement: false,
	HTMLDetailsElement: false,
	HTMLDialogElement: false,
	HTMLDirectoryElement: false,
	HTMLDivElement: false,
	HTMLDListElement: false,
	HTMLDocument: false,
	HTMLElement: false,
	HTMLEmbedElement: false,
	HTMLFieldSetElement: false,
	HTMLFontElement: false,
	HTMLFormControlsCollection: false,
	HTMLFormElement: false,
	HTMLFrameElement: false,
	HTMLFrameSetElement: false,
	HTMLHeadElement: false,
	HTMLHeadingElement: false,
	HTMLHRElement: false,
	HTMLHtmlElement: false,
	HTMLIFrameElement: false,
	HTMLImageElement: false,
	HTMLInputElement: false,
	HTMLLabelElement: false,
	HTMLLegendElement: false,
	HTMLLIElement: false,
	HTMLLinkElement: false,
	HTMLMapElement: false,
	HTMLMarqueeElement: false,
	HTMLMediaElement: false,
	HTMLMenuElement: false,
	HTMLMetaElement: false,
	HTMLMeterElement: false,
	HTMLModElement: false,
	HTMLObjectElement: false,
	HTMLOListElement: false,
	HTMLOptGroupElement: false,
	HTMLOptionElement: false,
	HTMLOptionsCollection: false,
	HTMLOutputElement: false,
	HTMLParagraphElement: false,
	HTMLParamElement: false,
	HTMLPictureElement: false,
	HTMLPreElement: false,
	HTMLProgressElement: false,
	HTMLQuoteElement: false,
	HTMLScriptElement: false,
	HTMLSelectElement: false,
	HTMLShadowElement: false,
	HTMLSlotElement: false,
	HTMLSourceElement: false,
	HTMLSpanElement: false,
	HTMLStyleElement: false,
	HTMLTableCaptionElement: false,
	HTMLTableCellElement: false,
	HTMLTableColElement: false,
	HTMLTableElement: false,
	HTMLTableRowElement: false,
	HTMLTableSectionElement: false,
	HTMLTemplateElement: false,
	HTMLTextAreaElement: false,
	HTMLTimeElement: false,
	HTMLTitleElement: false,
	HTMLTrackElement: false,
	HTMLUListElement: false,
	HTMLUnknownElement: false,
	HTMLVideoElement: false,
	IDBCursor: false,
	IDBCursorWithValue: false,
	IDBDatabase: false,
	IDBFactory: false,
	IDBIndex: false,
	IDBKeyRange: false,
	IDBObjectStore: false,
	IDBOpenDBRequest: false,
	IDBRequest: false,
	IDBTransaction: false,
	IDBVersionChangeEvent: false,
	IdleDeadline: false,
	IIRFilterNode: false,
	Image: false,
	ImageBitmap: false,
	ImageBitmapRenderingContext: false,
	ImageCapture: false,
	ImageData: false,
	indexedDB: false,
	innerHeight: false,
	innerWidth: false,
	InputEvent: false,
	IntersectionObserver: false,
	IntersectionObserverEntry: false,
	"Intl": false,
	isSecureContext: false,
	KeyboardEvent: false,
	KeyframeEffect: false,
	KeyframeEffectReadOnly: false,
	length: false,
	localStorage: false,
	location: true,
	Location: false,
	locationbar: false,
	matchMedia: false,
	MediaDeviceInfo: false,
	MediaDevices: false,
	MediaElementAudioSourceNode: false,
	MediaEncryptedEvent: false,
	MediaError: false,
	MediaKeyMessageEvent: false,
	MediaKeySession: false,
	MediaKeyStatusMap: false,
	MediaKeySystemAccess: false,
	MediaList: false,
	MediaMetadata: false,
	MediaQueryList: false,
	MediaQueryListEvent: false,
	MediaRecorder: false,
	MediaSettingsRange: false,
	MediaSource: false,
	MediaStream: false,
	MediaStreamAudioDestinationNode: false,
	MediaStreamAudioSourceNode: false,
	MediaStreamConstraints: false,
	MediaStreamEvent: false,
	MediaStreamTrack: false,
	MediaStreamTrackEvent: false,
	menubar: false,
	MessageChannel: false,
	MessageEvent: false,
	MessagePort: false,
	MIDIAccess: false,
	MIDIConnectionEvent: false,
	MIDIInput: false,
	MIDIInputMap: false,
	MIDIMessageEvent: false,
	MIDIOutput: false,
	MIDIOutputMap: false,
	MIDIPort: false,
	MimeType: false,
	MimeTypeArray: false,
	MouseEvent: false,
	moveBy: false,
	moveTo: false,
	MutationEvent: false,
	MutationObserver: false,
	MutationRecord: false,
	name: false,
	NamedNodeMap: false,
	NavigationPreloadManager: false,
	navigator: false,
	Navigator: false,
	NavigatorUAData: false,
	NetworkInformation: false,
	Node: false,
	NodeFilter: false,
	NodeIterator: false,
	NodeList: false,
	Notification: false,
	OfflineAudioCompletionEvent: false,
	OfflineAudioContext: false,
	offscreenBuffering: false,
	OffscreenCanvas: true,
	OffscreenCanvasRenderingContext2D: false,
	onabort: true,
	onafterprint: true,
	onanimationend: true,
	onanimationiteration: true,
	onanimationstart: true,
	onappinstalled: true,
	onauxclick: true,
	onbeforeinstallprompt: true,
	onbeforeprint: true,
	onbeforeunload: true,
	onblur: true,
	oncancel: true,
	oncanplay: true,
	oncanplaythrough: true,
	onchange: true,
	onclick: true,
	onclose: true,
	oncontextmenu: true,
	oncuechange: true,
	ondblclick: true,
	ondevicemotion: true,
	ondeviceorientation: true,
	ondeviceorientationabsolute: true,
	ondrag: true,
	ondragend: true,
	ondragenter: true,
	ondragleave: true,
	ondragover: true,
	ondragstart: true,
	ondrop: true,
	ondurationchange: true,
	onemptied: true,
	onended: true,
	onerror: true,
	onfocus: true,
	ongotpointercapture: true,
	onhashchange: true,
	oninput: true,
	oninvalid: true,
	onkeydown: true,
	onkeypress: true,
	onkeyup: true,
	onlanguagechange: true,
	onload: true,
	onloadeddata: true,
	onloadedmetadata: true,
	onloadstart: true,
	onlostpointercapture: true,
	onmessage: true,
	onmessageerror: true,
	onmousedown: true,
	onmouseenter: true,
	onmouseleave: true,
	onmousemove: true,
	onmouseout: true,
	onmouseover: true,
	onmouseup: true,
	onmousewheel: true,
	onoffline: true,
	ononline: true,
	onpagehide: true,
	onpageshow: true,
	onpause: true,
	onplay: true,
	onplaying: true,
	onpointercancel: true,
	onpointerdown: true,
	onpointerenter: true,
	onpointerleave: true,
	onpointermove: true,
	onpointerout: true,
	onpointerover: true,
	onpointerup: true,
	onpopstate: true,
	onprogress: true,
	onratechange: true,
	onrejectionhandled: true,
	onreset: true,
	onresize: true,
	onscroll: true,
	onsearch: true,
	onseeked: true,
	onseeking: true,
	onselect: true,
	onstalled: true,
	onstorage: true,
	onsubmit: true,
	onsuspend: true,
	ontimeupdate: true,
	ontoggle: true,
	ontransitionend: true,
	onunhandledrejection: true,
	onunload: true,
	onvolumechange: true,
	onwaiting: true,
	onwheel: true,
	open: false,
	openDatabase: false,
	opener: false,
	Option: false,
	origin: false,
	OscillatorNode: false,
	outerHeight: false,
	outerWidth: false,
	OverconstrainedError: false,
	PageTransitionEvent: false,
	pageXOffset: false,
	pageYOffset: false,
	PannerNode: false,
	parent: false,
	Path2D: false,
	PaymentAddress: false,
	PaymentRequest: false,
	PaymentRequestUpdateEvent: false,
	PaymentResponse: false,
	performance: false,
	Performance: false,
	PerformanceEntry: false,
	PerformanceLongTaskTiming: false,
	PerformanceMark: false,
	PerformanceMeasure: false,
	PerformanceNavigation: false,
	PerformanceNavigationTiming: false,
	PerformanceObserver: false,
	PerformanceObserverEntryList: false,
	PerformancePaintTiming: false,
	PerformanceResourceTiming: false,
	PerformanceTiming: false,
	PeriodicWave: false,
	Permissions: false,
	PermissionStatus: false,
	personalbar: false,
	PhotoCapabilities: false,
	Plugin: false,
	PluginArray: false,
	PointerEvent: false,
	PopStateEvent: false,
	postMessage: false,
	Presentation: false,
	PresentationAvailability: false,
	PresentationConnection: false,
	PresentationConnectionAvailableEvent: false,
	PresentationConnectionCloseEvent: false,
	PresentationConnectionList: false,
	PresentationReceiver: false,
	PresentationRequest: false,
	print: false,
	ProcessingInstruction: false,
	ProgressEvent: false,
	PromiseRejectionEvent: false,
	prompt: false,
	PushManager: false,
	PushSubscription: false,
	PushSubscriptionOptions: false,
	queueMicrotask: false,
	RadioNodeList: false,
	Range: false,
	ReadableByteStreamController: false,
	ReadableStream: false,
	ReadableStreamBYOBReader: false,
	ReadableStreamBYOBRequest: false,
	ReadableStreamDefaultController: false,
	ReadableStreamDefaultReader: false,
	registerProcessor: false,
	RemotePlayback: false,
	removeEventListener: false,
	reportError: false,
	Request: false,
	requestAnimationFrame: false,
	requestIdleCallback: false,
	resizeBy: false,
	ResizeObserver: false,
	ResizeObserverEntry: false,
	resizeTo: false,
	Response: false,
	RTCCertificate: false,
	RTCDataChannel: false,
	RTCDataChannelEvent: false,
	RTCDtlsTransport: false,
	RTCIceCandidate: false,
	RTCIceGatherer: false,
	RTCIceTransport: false,
	RTCPeerConnection: false,
	RTCPeerConnectionIceEvent: false,
	RTCRtpContributingSource: false,
	RTCRtpReceiver: false,
	RTCRtpSender: false,
	RTCSctpTransport: false,
	RTCSessionDescription: false,
	RTCStatsReport: false,
	RTCTrackEvent: false,
	screen: false,
	Screen: false,
	screenLeft: false,
	ScreenOrientation: false,
	screenTop: false,
	screenX: false,
	screenY: false,
	ScriptProcessorNode: false,
	scroll: false,
	scrollbars: false,
	scrollBy: false,
	scrollTo: false,
	scrollX: false,
	scrollY: false,
	SecurityPolicyViolationEvent: false,
	Selection: false,
	self: false,
	ServiceWorker: false,
	ServiceWorkerContainer: false,
	ServiceWorkerRegistration: false,
	sessionStorage: false,
	setInterval: false,
	setTimeout: false,
	ShadowRoot: false,
	SharedWorker: false,
	SourceBuffer: false,
	SourceBufferList: false,
	speechSynthesis: false,
	SpeechSynthesisEvent: false,
	SpeechSynthesisUtterance: false,
	StaticRange: false,
	status: false,
	statusbar: false,
	StereoPannerNode: false,
	stop: false,
	Storage: false,
	StorageEvent: false,
	StorageManager: false,
	structuredClone: false,
	styleMedia: false,
	StyleSheet: false,
	StyleSheetList: false,
	SubmitEvent: false,
	SubtleCrypto: false,
	SVGAElement: false,
	SVGAngle: false,
	SVGAnimatedAngle: false,
	SVGAnimatedBoolean: false,
	SVGAnimatedEnumeration: false,
	SVGAnimatedInteger: false,
	SVGAnimatedLength: false,
	SVGAnimatedLengthList: false,
	SVGAnimatedNumber: false,
	SVGAnimatedNumberList: false,
	SVGAnimatedPreserveAspectRatio: false,
	SVGAnimatedRect: false,
	SVGAnimatedString: false,
	SVGAnimatedTransformList: false,
	SVGAnimateElement: false,
	SVGAnimateMotionElement: false,
	SVGAnimateTransformElement: false,
	SVGAnimationElement: false,
	SVGCircleElement: false,
	SVGClipPathElement: false,
	SVGComponentTransferFunctionElement: false,
	SVGDefsElement: false,
	SVGDescElement: false,
	SVGDiscardElement: false,
	SVGElement: false,
	SVGEllipseElement: false,
	SVGFEBlendElement: false,
	SVGFEColorMatrixElement: false,
	SVGFEComponentTransferElement: false,
	SVGFECompositeElement: false,
	SVGFEConvolveMatrixElement: false,
	SVGFEDiffuseLightingElement: false,
	SVGFEDisplacementMapElement: false,
	SVGFEDistantLightElement: false,
	SVGFEDropShadowElement: false,
	SVGFEFloodElement: false,
	SVGFEFuncAElement: false,
	SVGFEFuncBElement: false,
	SVGFEFuncGElement: false,
	SVGFEFuncRElement: false,
	SVGFEGaussianBlurElement: false,
	SVGFEImageElement: false,
	SVGFEMergeElement: false,
	SVGFEMergeNodeElement: false,
	SVGFEMorphologyElement: false,
	SVGFEOffsetElement: false,
	SVGFEPointLightElement: false,
	SVGFESpecularLightingElement: false,
	SVGFESpotLightElement: false,
	SVGFETileElement: false,
	SVGFETurbulenceElement: false,
	SVGFilterElement: false,
	SVGForeignObjectElement: false,
	SVGGElement: false,
	SVGGeometryElement: false,
	SVGGradientElement: false,
	SVGGraphicsElement: false,
	SVGImageElement: false,
	SVGLength: false,
	SVGLengthList: false,
	SVGLinearGradientElement: false,
	SVGLineElement: false,
	SVGMarkerElement: false,
	SVGMaskElement: false,
	SVGMatrix: false,
	SVGMetadataElement: false,
	SVGMPathElement: false,
	SVGNumber: false,
	SVGNumberList: false,
	SVGPathElement: false,
	SVGPatternElement: false,
	SVGPoint: false,
	SVGPointList: false,
	SVGPolygonElement: false,
	SVGPolylineElement: false,
	SVGPreserveAspectRatio: false,
	SVGRadialGradientElement: false,
	SVGRect: false,
	SVGRectElement: false,
	SVGScriptElement: false,
	SVGSetElement: false,
	SVGStopElement: false,
	SVGStringList: false,
	SVGStyleElement: false,
	SVGSVGElement: false,
	SVGSwitchElement: false,
	SVGSymbolElement: false,
	SVGTextContentElement: false,
	SVGTextElement: false,
	SVGTextPathElement: false,
	SVGTextPositioningElement: false,
	SVGTitleElement: false,
	SVGTransform: false,
	SVGTransformList: false,
	SVGTSpanElement: false,
	SVGUnitTypes: false,
	SVGUseElement: false,
	SVGViewElement: false,
	TaskAttributionTiming: false,
	Text: false,
	TextDecoder: false,
	TextDecoderStream: false,
	TextEncoder: false,
	TextEncoderStream: false,
	TextEvent: false,
	TextMetrics: false,
	TextTrack: false,
	TextTrackCue: false,
	TextTrackCueList: false,
	TextTrackList: false,
	TimeRanges: false,
	ToggleEvent: false,
	toolbar: false,
	top: false,
	Touch: false,
	TouchEvent: false,
	TouchList: false,
	TrackEvent: false,
	TransformStream: false,
	TransformStreamDefaultController: false,
	TransitionEvent: false,
	TreeWalker: false,
	UIEvent: false,
	URL: false,
	URLSearchParams: false,
	ValidityState: false,
	visualViewport: false,
	VisualViewport: false,
	VTTCue: false,
	WaveShaperNode: false,
	WebAssembly: false,
	WebGL2RenderingContext: false,
	WebGLActiveInfo: false,
	WebGLBuffer: false,
	WebGLContextEvent: false,
	WebGLFramebuffer: false,
	WebGLProgram: false,
	WebGLQuery: false,
	WebGLRenderbuffer: false,
	WebGLRenderingContext: false,
	WebGLSampler: false,
	WebGLShader: false,
	WebGLShaderPrecisionFormat: false,
	WebGLSync: false,
	WebGLTexture: false,
	WebGLTransformFeedback: false,
	WebGLUniformLocation: false,
	WebGLVertexArrayObject: false,
	WebSocket: false,
	WheelEvent: false,
	window: false,
	Window: false,
	Worker: false,
	WritableStream: false,
	WritableStreamDefaultController: false,
	WritableStreamDefaultWriter: false,
	XMLDocument: false,
	XMLHttpRequest: false,
	XMLHttpRequestEventTarget: false,
	XMLHttpRequestUpload: false,
	XMLSerializer: false,
	XPathEvaluator: false,
	XPathExpression: false,
	XPathResult: false,
	XRAnchor: false,
	XRBoundedReferenceSpace: false,
	XRCPUDepthInformation: false,
	XRDepthInformation: false,
	XRFrame: false,
	XRInputSource: false,
	XRInputSourceArray: false,
	XRInputSourceEvent: false,
	XRInputSourcesChangeEvent: false,
	XRPose: false,
	XRReferenceSpace: false,
	XRReferenceSpaceEvent: false,
	XRRenderState: false,
	XRRigidTransform: false,
	XRSession: false,
	XRSessionEvent: false,
	XRSpace: false,
	XRSystem: false,
	XRView: false,
	XRViewerPose: false,
	XRViewport: false,
	XRWebGLBinding: false,
	XRWebGLDepthInformation: false,
	XRWebGLLayer: false,
	XSLTProcessor: false
};
var worker = {
	addEventListener: false,
	applicationCache: false,
	atob: false,
	Blob: false,
	BroadcastChannel: false,
	btoa: false,
	ByteLengthQueuingStrategy: false,
	Cache: false,
	caches: false,
	clearInterval: false,
	clearTimeout: false,
	close: true,
	CompressionStream: false,
	console: false,
	CountQueuingStrategy: false,
	crypto: false,
	Crypto: false,
	CryptoKey: false,
	CustomEvent: false,
	DecompressionStream: false,
	ErrorEvent: false,
	Event: false,
	fetch: false,
	File: false,
	FileReaderSync: false,
	FormData: false,
	Headers: false,
	IDBCursor: false,
	IDBCursorWithValue: false,
	IDBDatabase: false,
	IDBFactory: false,
	IDBIndex: false,
	IDBKeyRange: false,
	IDBObjectStore: false,
	IDBOpenDBRequest: false,
	IDBRequest: false,
	IDBTransaction: false,
	IDBVersionChangeEvent: false,
	ImageData: false,
	importScripts: true,
	indexedDB: false,
	location: false,
	MessageChannel: false,
	MessageEvent: false,
	MessagePort: false,
	name: false,
	navigator: false,
	Notification: false,
	onclose: true,
	onconnect: true,
	onerror: true,
	onlanguagechange: true,
	onmessage: true,
	onoffline: true,
	ononline: true,
	onrejectionhandled: true,
	onunhandledrejection: true,
	performance: false,
	Performance: false,
	PerformanceEntry: false,
	PerformanceMark: false,
	PerformanceMeasure: false,
	PerformanceNavigation: false,
	PerformanceObserver: false,
	PerformanceObserverEntryList: false,
	PerformanceResourceTiming: false,
	PerformanceTiming: false,
	postMessage: true,
	"Promise": false,
	queueMicrotask: false,
	ReadableByteStreamController: false,
	ReadableStream: false,
	ReadableStreamBYOBReader: false,
	ReadableStreamBYOBRequest: false,
	ReadableStreamDefaultController: false,
	ReadableStreamDefaultReader: false,
	removeEventListener: false,
	reportError: false,
	Request: false,
	Response: false,
	self: true,
	ServiceWorkerRegistration: false,
	setInterval: false,
	setTimeout: false,
	SubtleCrypto: false,
	TextDecoder: false,
	TextDecoderStream: false,
	TextEncoder: false,
	TextEncoderStream: false,
	TransformStream: false,
	TransformStreamDefaultController: false,
	URL: false,
	URLSearchParams: false,
	WebAssembly: false,
	WebSocket: false,
	Worker: false,
	WorkerGlobalScope: false,
	WritableStream: false,
	WritableStreamDefaultController: false,
	WritableStreamDefaultWriter: false,
	XMLHttpRequest: false
};
var node = {
	__dirname: false,
	__filename: false,
	AbortController: false,
	AbortSignal: false,
	atob: false,
	Blob: false,
	BroadcastChannel: false,
	btoa: false,
	Buffer: false,
	ByteLengthQueuingStrategy: false,
	clearImmediate: false,
	clearInterval: false,
	clearTimeout: false,
	CompressionStream: false,
	console: false,
	CountQueuingStrategy: false,
	crypto: false,
	Crypto: false,
	CryptoKey: false,
	CustomEvent: false,
	DecompressionStream: false,
	DOMException: false,
	Event: false,
	EventTarget: false,
	exports: true,
	fetch: false,
	File: false,
	FormData: false,
	global: false,
	Headers: false,
	"Intl": false,
	MessageChannel: false,
	MessageEvent: false,
	MessagePort: false,
	module: false,
	performance: false,
	PerformanceEntry: false,
	PerformanceMark: false,
	PerformanceMeasure: false,
	PerformanceObserver: false,
	PerformanceObserverEntryList: false,
	PerformanceResourceTiming: false,
	process: false,
	queueMicrotask: false,
	ReadableByteStreamController: false,
	ReadableStream: false,
	ReadableStreamBYOBReader: false,
	ReadableStreamBYOBRequest: false,
	ReadableStreamDefaultController: false,
	ReadableStreamDefaultReader: false,
	Request: false,
	require: false,
	Response: false,
	setImmediate: false,
	setInterval: false,
	setTimeout: false,
	structuredClone: false,
	SubtleCrypto: false,
	TextDecoder: false,
	TextDecoderStream: false,
	TextEncoder: false,
	TextEncoderStream: false,
	TransformStream: false,
	TransformStreamDefaultController: false,
	URL: false,
	URLSearchParams: false,
	WebAssembly: false,
	WritableStream: false,
	WritableStreamDefaultController: false,
	WritableStreamDefaultWriter: false
};
var nodeBuiltin = {
	AbortController: false,
	AbortSignal: false,
	atob: false,
	Blob: false,
	BroadcastChannel: false,
	btoa: false,
	Buffer: false,
	ByteLengthQueuingStrategy: false,
	clearImmediate: false,
	clearInterval: false,
	clearTimeout: false,
	CompressionStream: false,
	console: false,
	CountQueuingStrategy: false,
	crypto: false,
	Crypto: false,
	CryptoKey: false,
	CustomEvent: false,
	DecompressionStream: false,
	DOMException: false,
	Event: false,
	EventTarget: false,
	fetch: false,
	File: false,
	FormData: false,
	global: false,
	Headers: false,
	"Intl": false,
	MessageChannel: false,
	MessageEvent: false,
	MessagePort: false,
	performance: false,
	PerformanceEntry: false,
	PerformanceMark: false,
	PerformanceMeasure: false,
	PerformanceObserver: false,
	PerformanceObserverEntryList: false,
	PerformanceResourceTiming: false,
	process: false,
	queueMicrotask: false,
	ReadableByteStreamController: false,
	ReadableStream: false,
	ReadableStreamBYOBReader: false,
	ReadableStreamBYOBRequest: false,
	ReadableStreamDefaultController: false,
	ReadableStreamDefaultReader: false,
	Request: false,
	Response: false,
	setImmediate: false,
	setInterval: false,
	setTimeout: false,
	structuredClone: false,
	SubtleCrypto: false,
	TextDecoder: false,
	TextDecoderStream: false,
	TextEncoder: false,
	TextEncoderStream: false,
	TransformStream: false,
	TransformStreamDefaultController: false,
	URL: false,
	URLSearchParams: false,
	WebAssembly: false,
	WritableStream: false,
	WritableStreamDefaultController: false,
	WritableStreamDefaultWriter: false
};
var commonjs = {
	exports: true,
	global: false,
	module: false,
	require: false
};
var amd = {
	define: false,
	require: false
};
var mocha = {
	after: false,
	afterEach: false,
	before: false,
	beforeEach: false,
	context: false,
	describe: false,
	it: false,
	mocha: false,
	run: false,
	setup: false,
	specify: false,
	suite: false,
	suiteSetup: false,
	suiteTeardown: false,
	teardown: false,
	test: false,
	xcontext: false,
	xdescribe: false,
	xit: false,
	xspecify: false
};
var jasmine = {
	afterAll: false,
	afterEach: false,
	beforeAll: false,
	beforeEach: false,
	describe: false,
	expect: false,
	expectAsync: false,
	fail: false,
	fdescribe: false,
	fit: false,
	it: false,
	jasmine: false,
	pending: false,
	runs: false,
	spyOn: false,
	spyOnAllFunctions: false,
	spyOnProperty: false,
	waits: false,
	waitsFor: false,
	xdescribe: false,
	xit: false
};
var jest = {
	afterAll: false,
	afterEach: false,
	beforeAll: false,
	beforeEach: false,
	describe: false,
	expect: false,
	fdescribe: false,
	fit: false,
	it: false,
	jest: false,
	pit: false,
	require: false,
	test: false,
	xdescribe: false,
	xit: false,
	xtest: false
};
var qunit = {
	asyncTest: false,
	deepEqual: false,
	equal: false,
	expect: false,
	module: false,
	notDeepEqual: false,
	notEqual: false,
	notOk: false,
	notPropEqual: false,
	notStrictEqual: false,
	ok: false,
	propEqual: false,
	QUnit: false,
	raises: false,
	start: false,
	stop: false,
	strictEqual: false,
	test: false,
	throws: false
};
var phantomjs = {
	console: true,
	exports: true,
	phantom: true,
	require: true,
	WebPage: true
};
var couch = {
	emit: false,
	exports: false,
	getRow: false,
	log: false,
	module: false,
	provides: false,
	require: false,
	respond: false,
	send: false,
	start: false,
	sum: false
};
var rhino = {
	defineClass: false,
	deserialize: false,
	gc: false,
	help: false,
	importClass: false,
	importPackage: false,
	java: false,
	load: false,
	loadClass: false,
	Packages: false,
	print: false,
	quit: false,
	readFile: false,
	readUrl: false,
	runCommand: false,
	seal: false,
	serialize: false,
	spawn: false,
	sync: false,
	toint32: false,
	version: false
};
var nashorn = {
	__DIR__: false,
	__FILE__: false,
	__LINE__: false,
	com: false,
	edu: false,
	exit: false,
	java: false,
	Java: false,
	javafx: false,
	JavaImporter: false,
	javax: false,
	JSAdapter: false,
	load: false,
	loadWithNewGlobal: false,
	org: false,
	Packages: false,
	print: false,
	quit: false
};
var wsh = {
	ActiveXObject: false,
	CollectGarbage: false,
	Debug: false,
	Enumerator: false,
	GetObject: false,
	RuntimeObject: false,
	ScriptEngine: false,
	ScriptEngineBuildVersion: false,
	ScriptEngineMajorVersion: false,
	ScriptEngineMinorVersion: false,
	VBArray: false,
	WScript: false,
	WSH: false
};
var jquery = {
	$: false,
	jQuery: false
};
var yui = {
	YAHOO: false,
	YAHOO_config: false,
	YUI: false,
	YUI_config: false
};
var shelljs = {
	cat: false,
	cd: false,
	chmod: false,
	config: false,
	cp: false,
	dirs: false,
	echo: false,
	env: false,
	error: false,
	exec: false,
	exit: false,
	find: false,
	grep: false,
	ln: false,
	ls: false,
	mkdir: false,
	mv: false,
	popd: false,
	pushd: false,
	pwd: false,
	rm: false,
	sed: false,
	set: false,
	target: false,
	tempdir: false,
	test: false,
	touch: false,
	which: false
};
var prototypejs = {
	$: false,
	$$: false,
	$A: false,
	$break: false,
	$continue: false,
	$F: false,
	$H: false,
	$R: false,
	$w: false,
	Abstract: false,
	Ajax: false,
	Autocompleter: false,
	Builder: false,
	Class: false,
	Control: false,
	Draggable: false,
	Draggables: false,
	Droppables: false,
	Effect: false,
	Element: false,
	Enumerable: false,
	Event: false,
	Field: false,
	Form: false,
	Hash: false,
	Insertion: false,
	ObjectRange: false,
	PeriodicalExecuter: false,
	Position: false,
	Prototype: false,
	Scriptaculous: false,
	Selector: false,
	Sortable: false,
	SortableObserver: false,
	Sound: false,
	Template: false,
	Toggle: false,
	Try: false
};
var meteor = {
	$: false,
	Accounts: false,
	AccountsClient: false,
	AccountsCommon: false,
	AccountsServer: false,
	App: false,
	Assets: false,
	Blaze: false,
	check: false,
	Cordova: false,
	DDP: false,
	DDPRateLimiter: false,
	DDPServer: false,
	Deps: false,
	EJSON: false,
	Email: false,
	HTTP: false,
	Log: false,
	Match: false,
	Meteor: false,
	Mongo: false,
	MongoInternals: false,
	Npm: false,
	Package: false,
	Plugin: false,
	process: false,
	Random: false,
	ReactiveDict: false,
	ReactiveVar: false,
	Router: false,
	ServiceConfiguration: false,
	Session: false,
	share: false,
	Spacebars: false,
	Template: false,
	Tinytest: false,
	Tracker: false,
	UI: false,
	Utils: false,
	WebApp: false,
	WebAppInternals: false
};
var mongo = {
	_isWindows: false,
	_rand: false,
	BulkWriteResult: false,
	cat: false,
	cd: false,
	connect: false,
	db: false,
	getHostName: false,
	getMemInfo: false,
	hostname: false,
	ISODate: false,
	listFiles: false,
	load: false,
	ls: false,
	md5sumFile: false,
	mkdir: false,
	Mongo: false,
	NumberInt: false,
	NumberLong: false,
	ObjectId: false,
	PlanCache: false,
	print: false,
	printjson: false,
	pwd: false,
	quit: false,
	removeFile: false,
	rs: false,
	sh: false,
	UUID: false,
	version: false,
	WriteResult: false
};
var applescript = {
	$: false,
	Application: false,
	Automation: false,
	console: false,
	delay: false,
	Library: false,
	ObjC: false,
	ObjectSpecifier: false,
	Path: false,
	Progress: false,
	Ref: false
};
var serviceworker = {
	addEventListener: false,
	applicationCache: false,
	atob: false,
	Blob: false,
	BroadcastChannel: false,
	btoa: false,
	ByteLengthQueuingStrategy: false,
	Cache: false,
	caches: false,
	CacheStorage: false,
	clearInterval: false,
	clearTimeout: false,
	Client: false,
	clients: false,
	Clients: false,
	close: true,
	CompressionStream: false,
	console: false,
	CountQueuingStrategy: false,
	crypto: false,
	Crypto: false,
	CryptoKey: false,
	CustomEvent: false,
	DecompressionStream: false,
	ErrorEvent: false,
	Event: false,
	ExtendableEvent: false,
	ExtendableMessageEvent: false,
	fetch: false,
	FetchEvent: false,
	File: false,
	FileReaderSync: false,
	FormData: false,
	Headers: false,
	IDBCursor: false,
	IDBCursorWithValue: false,
	IDBDatabase: false,
	IDBFactory: false,
	IDBIndex: false,
	IDBKeyRange: false,
	IDBObjectStore: false,
	IDBOpenDBRequest: false,
	IDBRequest: false,
	IDBTransaction: false,
	IDBVersionChangeEvent: false,
	ImageData: false,
	importScripts: false,
	indexedDB: false,
	location: false,
	MessageChannel: false,
	MessageEvent: false,
	MessagePort: false,
	name: false,
	navigator: false,
	Notification: false,
	onclose: true,
	onconnect: true,
	onerror: true,
	onfetch: true,
	oninstall: true,
	onlanguagechange: true,
	onmessage: true,
	onmessageerror: true,
	onnotificationclick: true,
	onnotificationclose: true,
	onoffline: true,
	ononline: true,
	onpush: true,
	onpushsubscriptionchange: true,
	onrejectionhandled: true,
	onsync: true,
	onunhandledrejection: true,
	performance: false,
	Performance: false,
	PerformanceEntry: false,
	PerformanceMark: false,
	PerformanceMeasure: false,
	PerformanceNavigation: false,
	PerformanceObserver: false,
	PerformanceObserverEntryList: false,
	PerformanceResourceTiming: false,
	PerformanceTiming: false,
	postMessage: true,
	"Promise": false,
	queueMicrotask: false,
	ReadableByteStreamController: false,
	ReadableStream: false,
	ReadableStreamBYOBReader: false,
	ReadableStreamBYOBRequest: false,
	ReadableStreamDefaultController: false,
	ReadableStreamDefaultReader: false,
	registration: false,
	removeEventListener: false,
	Request: false,
	Response: false,
	self: false,
	ServiceWorker: false,
	ServiceWorkerContainer: false,
	ServiceWorkerGlobalScope: false,
	ServiceWorkerMessageEvent: false,
	ServiceWorkerRegistration: false,
	setInterval: false,
	setTimeout: false,
	skipWaiting: false,
	SubtleCrypto: false,
	TextDecoder: false,
	TextDecoderStream: false,
	TextEncoder: false,
	TextEncoderStream: false,
	TransformStream: false,
	TransformStreamDefaultController: false,
	URL: false,
	URLSearchParams: false,
	WebAssembly: false,
	WebSocket: false,
	WindowClient: false,
	Worker: false,
	WorkerGlobalScope: false,
	WritableStream: false,
	WritableStreamDefaultController: false,
	WritableStreamDefaultWriter: false,
	XMLHttpRequest: false
};
var atomtest = {
	advanceClock: false,
	atom: false,
	fakeClearInterval: false,
	fakeClearTimeout: false,
	fakeSetInterval: false,
	fakeSetTimeout: false,
	resetTimeouts: false,
	waitsForPromise: false
};
var embertest = {
	andThen: false,
	click: false,
	currentPath: false,
	currentRouteName: false,
	currentURL: false,
	fillIn: false,
	find: false,
	findAll: false,
	findWithAssert: false,
	keyEvent: false,
	pauseTest: false,
	resumeTest: false,
	triggerEvent: false,
	visit: false,
	wait: false
};
var protractor = {
	$: false,
	$$: false,
	browser: false,
	by: false,
	By: false,
	DartObject: false,
	element: false,
	protractor: false
};
var webextensions = {
	browser: false,
	chrome: false,
	opr: false
};
var greasemonkey = {
	cloneInto: false,
	createObjectIn: false,
	exportFunction: false,
	GM: false,
	GM_addElement: false,
	GM_addStyle: false,
	GM_addValueChangeListener: false,
	GM_deleteValue: false,
	GM_download: false,
	GM_getResourceText: false,
	GM_getResourceURL: false,
	GM_getTab: false,
	GM_getTabs: false,
	GM_getValue: false,
	GM_info: false,
	GM_listValues: false,
	GM_log: false,
	GM_notification: false,
	GM_openInTab: false,
	GM_registerMenuCommand: false,
	GM_removeValueChangeListener: false,
	GM_saveTab: false,
	GM_setClipboard: false,
	GM_setValue: false,
	GM_unregisterMenuCommand: false,
	GM_xmlhttpRequest: false,
	unsafeWindow: false
};
var devtools = {
	$: false,
	$_: false,
	$$: false,
	$0: false,
	$1: false,
	$2: false,
	$3: false,
	$4: false,
	$x: false,
	chrome: false,
	clear: false,
	copy: false,
	debug: false,
	dir: false,
	dirxml: false,
	getEventListeners: false,
	inspect: false,
	keys: false,
	monitor: false,
	monitorEvents: false,
	profile: false,
	profileEnd: false,
	queryObjects: false,
	table: false,
	undebug: false,
	unmonitor: false,
	unmonitorEvents: false,
	values: false
};
var require$$0 = {
	builtin: builtin,
	es5: es5,
	es2015: es2015,
	es2017: es2017,
	es2020: es2020,
	es2021: es2021,
	browser: browser$1,
	worker: worker,
	node: node,
	nodeBuiltin: nodeBuiltin,
	commonjs: commonjs,
	amd: amd,
	mocha: mocha,
	jasmine: jasmine,
	jest: jest,
	qunit: qunit,
	phantomjs: phantomjs,
	couch: couch,
	rhino: rhino,
	nashorn: nashorn,
	wsh: wsh,
	jquery: jquery,
	yui: yui,
	shelljs: shelljs,
	prototypejs: prototypejs,
	meteor: meteor,
	mongo: mongo,
	applescript: applescript,
	serviceworker: serviceworker,
	atomtest: atomtest,
	embertest: embertest,
	protractor: protractor,
	"shared-node-browser": {
	AbortController: false,
	AbortSignal: false,
	atob: false,
	Blob: false,
	BroadcastChannel: false,
	btoa: false,
	ByteLengthQueuingStrategy: false,
	clearInterval: false,
	clearTimeout: false,
	CompressionStream: false,
	console: false,
	CountQueuingStrategy: false,
	crypto: false,
	Crypto: false,
	CryptoKey: false,
	CustomEvent: false,
	DecompressionStream: false,
	DOMException: false,
	Event: false,
	EventTarget: false,
	fetch: false,
	File: false,
	FormData: false,
	Headers: false,
	"Intl": false,
	MessageChannel: false,
	MessageEvent: false,
	MessagePort: false,
	performance: false,
	PerformanceEntry: false,
	PerformanceMark: false,
	PerformanceMeasure: false,
	PerformanceObserver: false,
	PerformanceObserverEntryList: false,
	PerformanceResourceTiming: false,
	queueMicrotask: false,
	ReadableByteStreamController: false,
	ReadableStream: false,
	ReadableStreamBYOBReader: false,
	ReadableStreamBYOBRequest: false,
	ReadableStreamDefaultController: false,
	ReadableStreamDefaultReader: false,
	Request: false,
	Response: false,
	setInterval: false,
	setTimeout: false,
	structuredClone: false,
	SubtleCrypto: false,
	TextDecoder: false,
	TextDecoderStream: false,
	TextEncoder: false,
	TextEncoderStream: false,
	TransformStream: false,
	TransformStreamDefaultController: false,
	URL: false,
	URLSearchParams: false,
	WebAssembly: false,
	WritableStream: false,
	WritableStreamDefaultController: false,
	WritableStreamDefaultWriter: false
},
	webextensions: webextensions,
	greasemonkey: greasemonkey,
	devtools: devtools
};

var globals$1;
var hasRequiredGlobals$1;

function requireGlobals$1 () {
	if (hasRequiredGlobals$1) return globals$1;
	hasRequiredGlobals$1 = 1;
	globals$1 = require$$0;
	return globals$1;
}

var hasRequiredEslintrcUniversal;

function requireEslintrcUniversal () {
	if (hasRequiredEslintrcUniversal) return eslintrcUniversal;
	hasRequiredEslintrcUniversal = 1;

	Object.defineProperty(eslintrcUniversal, '__esModule', { value: true });

	var util = require$$1$1;
	var path = require$$0$1;
	var Ajv = requireAjv$1();
	var globals = /*@__PURE__*/ requireGlobals$1();

	function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

	var util__default = /*#__PURE__*/_interopDefaultLegacy(util);
	var path__default = /*#__PURE__*/_interopDefaultLegacy(path);
	var Ajv__default = /*#__PURE__*/_interopDefaultLegacy(Ajv);
	var globals__default = /*#__PURE__*/_interopDefaultLegacy(globals);

	/**
	 * @fileoverview Config file operations. This file must be usable in the browser,
	 * so no Node-specific code can be here.
	 * @author Nicholas C. Zakas
	 */

	//------------------------------------------------------------------------------
	// Private
	//------------------------------------------------------------------------------

	const RULE_SEVERITY_STRINGS = ["off", "warn", "error"],
	    RULE_SEVERITY = RULE_SEVERITY_STRINGS.reduce((map, value, index) => {
	        map[value] = index;
	        return map;
	    }, {}),
	    VALID_SEVERITIES = new Set([0, 1, 2, "off", "warn", "error"]);

	//------------------------------------------------------------------------------
	// Public Interface
	//------------------------------------------------------------------------------

	/**
	 * Normalizes the severity value of a rule's configuration to a number
	 * @param {(number|string|[number, ...*]|[string, ...*])} ruleConfig A rule's configuration value, generally
	 * received from the user. A valid config value is either 0, 1, 2, the string "off" (treated the same as 0),
	 * the string "warn" (treated the same as 1), the string "error" (treated the same as 2), or an array
	 * whose first element is one of the above values. Strings are matched case-insensitively.
	 * @returns {(0|1|2)} The numeric severity value if the config value was valid, otherwise 0.
	 */
	function getRuleSeverity(ruleConfig) {
	    const severityValue = Array.isArray(ruleConfig) ? ruleConfig[0] : ruleConfig;

	    if (severityValue === 0 || severityValue === 1 || severityValue === 2) {
	        return severityValue;
	    }

	    if (typeof severityValue === "string") {
	        return RULE_SEVERITY[severityValue.toLowerCase()] || 0;
	    }

	    return 0;
	}

	/**
	 * Converts old-style severity settings (0, 1, 2) into new-style
	 * severity settings (off, warn, error) for all rules. Assumption is that severity
	 * values have already been validated as correct.
	 * @param {Object} config The config object to normalize.
	 * @returns {void}
	 */
	function normalizeToStrings(config) {

	    if (config.rules) {
	        Object.keys(config.rules).forEach(ruleId => {
	            const ruleConfig = config.rules[ruleId];

	            if (typeof ruleConfig === "number") {
	                config.rules[ruleId] = RULE_SEVERITY_STRINGS[ruleConfig] || RULE_SEVERITY_STRINGS[0];
	            } else if (Array.isArray(ruleConfig) && typeof ruleConfig[0] === "number") {
	                ruleConfig[0] = RULE_SEVERITY_STRINGS[ruleConfig[0]] || RULE_SEVERITY_STRINGS[0];
	            }
	        });
	    }
	}

	/**
	 * Determines if the severity for the given rule configuration represents an error.
	 * @param {int|string|Array} ruleConfig The configuration for an individual rule.
	 * @returns {boolean} True if the rule represents an error, false if not.
	 */
	function isErrorSeverity(ruleConfig) {
	    return getRuleSeverity(ruleConfig) === 2;
	}

	/**
	 * Checks whether a given config has valid severity or not.
	 * @param {number|string|Array} ruleConfig The configuration for an individual rule.
	 * @returns {boolean} `true` if the configuration has valid severity.
	 */
	function isValidSeverity(ruleConfig) {
	    let severity = Array.isArray(ruleConfig) ? ruleConfig[0] : ruleConfig;

	    if (typeof severity === "string") {
	        severity = severity.toLowerCase();
	    }
	    return VALID_SEVERITIES.has(severity);
	}

	/**
	 * Checks whether every rule of a given config has valid severity or not.
	 * @param {Object} config The configuration for rules.
	 * @returns {boolean} `true` if the configuration has valid severity.
	 */
	function isEverySeverityValid(config) {
	    return Object.keys(config).every(ruleId => isValidSeverity(config[ruleId]));
	}

	/**
	 * Normalizes a value for a global in a config
	 * @param {(boolean|string|null)} configuredValue The value given for a global in configuration or in
	 * a global directive comment
	 * @returns {("readable"|"writeable"|"off")} The value normalized as a string
	 * @throws Error if global value is invalid
	 */
	function normalizeConfigGlobal(configuredValue) {
	    switch (configuredValue) {
	        case "off":
	            return "off";

	        case true:
	        case "true":
	        case "writeable":
	        case "writable":
	            return "writable";

	        case null:
	        case false:
	        case "false":
	        case "readable":
	        case "readonly":
	            return "readonly";

	        default:
	            throw new Error(`'${configuredValue}' is not a valid configuration for a global (use 'readonly', 'writable', or 'off')`);
	    }
	}

	var ConfigOps = {
	    __proto__: null,
	    getRuleSeverity: getRuleSeverity,
	    normalizeToStrings: normalizeToStrings,
	    isErrorSeverity: isErrorSeverity,
	    isValidSeverity: isValidSeverity,
	    isEverySeverityValid: isEverySeverityValid,
	    normalizeConfigGlobal: normalizeConfigGlobal
	};

	/**
	 * @fileoverview Provide the function that emits deprecation warnings.
	 * @author Toru Nagashima <http://github.com/mysticatea>
	 */

	//------------------------------------------------------------------------------
	// Private
	//------------------------------------------------------------------------------

	// Defitions for deprecation warnings.
	const deprecationWarningMessages = {
	    ESLINT_LEGACY_ECMAFEATURES:
	        "The 'ecmaFeatures' config file property is deprecated and has no effect.",
	    ESLINT_PERSONAL_CONFIG_LOAD:
	        "'~/.eslintrc.*' config files have been deprecated. " +
	        "Please use a config file per project or the '--config' option.",
	    ESLINT_PERSONAL_CONFIG_SUPPRESS:
	        "'~/.eslintrc.*' config files have been deprecated. " +
	        "Please remove it or add 'root:true' to the config files in your " +
	        "projects in order to avoid loading '~/.eslintrc.*' accidentally."
	};

	const sourceFileErrorCache = new Set();

	/**
	 * Emits a deprecation warning containing a given filepath. A new deprecation warning is emitted
	 * for each unique file path, but repeated invocations with the same file path have no effect.
	 * No warnings are emitted if the `--no-deprecation` or `--no-warnings` Node runtime flags are active.
	 * @param {string} source The name of the configuration source to report the warning for.
	 * @param {string} errorCode The warning message to show.
	 * @returns {void}
	 */
	function emitDeprecationWarning(source, errorCode) {
	    const cacheKey = JSON.stringify({ source, errorCode });

	    if (sourceFileErrorCache.has(cacheKey)) {
	        return;
	    }
	    sourceFileErrorCache.add(cacheKey);

	    const rel = path__default["default"].relative(process.cwd(), source);
	    const message = deprecationWarningMessages[errorCode];

	    process.emitWarning(
	        `${message} (found in "${rel}")`,
	        "DeprecationWarning",
	        errorCode
	    );
	}

	/**
	 * @fileoverview The instance of Ajv validator.
	 * @author Evgeny Poberezkin
	 */

	//-----------------------------------------------------------------------------
	// Helpers
	//-----------------------------------------------------------------------------

	/*
	 * Copied from ajv/lib/refs/json-schema-draft-04.json
	 * The MIT License (MIT)
	 * Copyright (c) 2015-2017 Evgeny Poberezkin
	 */
	const metaSchema = {
	    id: "http://json-schema.org/draft-04/schema#",
	    $schema: "http://json-schema.org/draft-04/schema#",
	    description: "Core schema meta-schema",
	    definitions: {
	        schemaArray: {
	            type: "array",
	            minItems: 1,
	            items: { $ref: "#" }
	        },
	        positiveInteger: {
	            type: "integer",
	            minimum: 0
	        },
	        positiveIntegerDefault0: {
	            allOf: [{ $ref: "#/definitions/positiveInteger" }, { default: 0 }]
	        },
	        simpleTypes: {
	            enum: ["array", "boolean", "integer", "null", "number", "object", "string"]
	        },
	        stringArray: {
	            type: "array",
	            items: { type: "string" },
	            minItems: 1,
	            uniqueItems: true
	        }
	    },
	    type: "object",
	    properties: {
	        id: {
	            type: "string"
	        },
	        $schema: {
	            type: "string"
	        },
	        title: {
	            type: "string"
	        },
	        description: {
	            type: "string"
	        },
	        default: { },
	        multipleOf: {
	            type: "number",
	            minimum: 0,
	            exclusiveMinimum: true
	        },
	        maximum: {
	            type: "number"
	        },
	        exclusiveMaximum: {
	            type: "boolean",
	            default: false
	        },
	        minimum: {
	            type: "number"
	        },
	        exclusiveMinimum: {
	            type: "boolean",
	            default: false
	        },
	        maxLength: { $ref: "#/definitions/positiveInteger" },
	        minLength: { $ref: "#/definitions/positiveIntegerDefault0" },
	        pattern: {
	            type: "string",
	            format: "regex"
	        },
	        additionalItems: {
	            anyOf: [
	                { type: "boolean" },
	                { $ref: "#" }
	            ],
	            default: { }
	        },
	        items: {
	            anyOf: [
	                { $ref: "#" },
	                { $ref: "#/definitions/schemaArray" }
	            ],
	            default: { }
	        },
	        maxItems: { $ref: "#/definitions/positiveInteger" },
	        minItems: { $ref: "#/definitions/positiveIntegerDefault0" },
	        uniqueItems: {
	            type: "boolean",
	            default: false
	        },
	        maxProperties: { $ref: "#/definitions/positiveInteger" },
	        minProperties: { $ref: "#/definitions/positiveIntegerDefault0" },
	        required: { $ref: "#/definitions/stringArray" },
	        additionalProperties: {
	            anyOf: [
	                { type: "boolean" },
	                { $ref: "#" }
	            ],
	            default: { }
	        },
	        definitions: {
	            type: "object",
	            additionalProperties: { $ref: "#" },
	            default: { }
	        },
	        properties: {
	            type: "object",
	            additionalProperties: { $ref: "#" },
	            default: { }
	        },
	        patternProperties: {
	            type: "object",
	            additionalProperties: { $ref: "#" },
	            default: { }
	        },
	        dependencies: {
	            type: "object",
	            additionalProperties: {
	                anyOf: [
	                    { $ref: "#" },
	                    { $ref: "#/definitions/stringArray" }
	                ]
	            }
	        },
	        enum: {
	            type: "array",
	            minItems: 1,
	            uniqueItems: true
	        },
	        type: {
	            anyOf: [
	                { $ref: "#/definitions/simpleTypes" },
	                {
	                    type: "array",
	                    items: { $ref: "#/definitions/simpleTypes" },
	                    minItems: 1,
	                    uniqueItems: true
	                }
	            ]
	        },
	        format: { type: "string" },
	        allOf: { $ref: "#/definitions/schemaArray" },
	        anyOf: { $ref: "#/definitions/schemaArray" },
	        oneOf: { $ref: "#/definitions/schemaArray" },
	        not: { $ref: "#" }
	    },
	    dependencies: {
	        exclusiveMaximum: ["maximum"],
	        exclusiveMinimum: ["minimum"]
	    },
	    default: { }
	};

	//------------------------------------------------------------------------------
	// Public Interface
	//------------------------------------------------------------------------------

	var ajvOrig = (additionalOptions = {}) => {
	    const ajv = new Ajv__default["default"]({
	        meta: false,
	        useDefaults: true,
	        validateSchema: false,
	        missingRefs: "ignore",
	        verbose: true,
	        schemaId: "auto",
	        ...additionalOptions
	    });

	    ajv.addMetaSchema(metaSchema);
	    // eslint-disable-next-line no-underscore-dangle -- part of the API
	    ajv._opts.defaultMeta = metaSchema.id;

	    return ajv;
	};

	/**
	 * @fileoverview Applies default rule options
	 * @author JoshuaKGoldberg
	 */

	/**
	 * Check if the variable contains an object strictly rejecting arrays
	 * @param {unknown} value an object
	 * @returns {boolean} Whether value is an object
	 */
	function isObjectNotArray(value) {
	    return typeof value === "object" && value !== null && !Array.isArray(value);
	}

	/**
	 * Deeply merges second on top of first, creating a new {} object if needed.
	 * @param {T} first Base, default value.
	 * @param {U} second User-specified value.
	 * @returns {T | U | (T & U)} Merged equivalent of second on top of first.
	 */
	function deepMergeObjects(first, second) {
	    if (second === void 0) {
	        return first;
	    }

	    if (!isObjectNotArray(first) || !isObjectNotArray(second)) {
	        return second;
	    }

	    const result = { ...first, ...second };

	    for (const key of Object.keys(second)) {
	        if (Object.prototype.propertyIsEnumerable.call(first, key)) {
	            result[key] = deepMergeObjects(first[key], second[key]);
	        }
	    }

	    return result;
	}

	/**
	 * Deeply merges second on top of first, creating a new [] array if needed.
	 * @param {T[] | undefined} first Base, default values.
	 * @param {U[] | undefined} second User-specified values.
	 * @returns {(T | U | (T & U))[]} Merged equivalent of second on top of first.
	 */
	function deepMergeArrays(first, second) {
	    if (!first || !second) {
	        return second || first || [];
	    }

	    return [
	        ...first.map((value, i) => deepMergeObjects(value, second[i])),
	        ...second.slice(first.length)
	    ];
	}

	/**
	 * @fileoverview Defines a schema for configs.
	 * @author Sylvan Mably
	 */

	const baseConfigProperties = {
	    $schema: { type: "string" },
	    env: { type: "object" },
	    extends: { $ref: "#/definitions/stringOrStrings" },
	    globals: { type: "object" },
	    overrides: {
	        type: "array",
	        items: { $ref: "#/definitions/overrideConfig" },
	        additionalItems: false
	    },
	    parser: { type: ["string", "null"] },
	    parserOptions: { type: "object" },
	    plugins: { type: "array" },
	    processor: { type: "string" },
	    rules: { type: "object" },
	    settings: { type: "object" },
	    noInlineConfig: { type: "boolean" },
	    reportUnusedDisableDirectives: { type: "boolean" },

	    ecmaFeatures: { type: "object" } // deprecated; logs a warning when used
	};

	const configSchema = {
	    definitions: {
	        stringOrStrings: {
	            oneOf: [
	                { type: "string" },
	                {
	                    type: "array",
	                    items: { type: "string" },
	                    additionalItems: false
	                }
	            ]
	        },
	        stringOrStringsRequired: {
	            oneOf: [
	                { type: "string" },
	                {
	                    type: "array",
	                    items: { type: "string" },
	                    additionalItems: false,
	                    minItems: 1
	                }
	            ]
	        },

	        // Config at top-level.
	        objectConfig: {
	            type: "object",
	            properties: {
	                root: { type: "boolean" },
	                ignorePatterns: { $ref: "#/definitions/stringOrStrings" },
	                ...baseConfigProperties
	            },
	            additionalProperties: false
	        },

	        // Config in `overrides`.
	        overrideConfig: {
	            type: "object",
	            properties: {
	                excludedFiles: { $ref: "#/definitions/stringOrStrings" },
	                files: { $ref: "#/definitions/stringOrStringsRequired" },
	                ...baseConfigProperties
	            },
	            required: ["files"],
	            additionalProperties: false
	        }
	    },

	    $ref: "#/definitions/objectConfig"
	};

	/**
	 * @fileoverview Defines environment settings and globals.
	 * @author Elan Shanker
	 */

	//------------------------------------------------------------------------------
	// Helpers
	//------------------------------------------------------------------------------

	/**
	 * Get the object that has difference.
	 * @param {Record<string,boolean>} current The newer object.
	 * @param {Record<string,boolean>} prev The older object.
	 * @returns {Record<string,boolean>} The difference object.
	 */
	function getDiff(current, prev) {
	    const retv = {};

	    for (const [key, value] of Object.entries(current)) {
	        if (!Object.hasOwn(prev, key)) {
	            retv[key] = value;
	        }
	    }

	    return retv;
	}

	const newGlobals2015 = getDiff(globals__default["default"].es2015, globals__default["default"].es5); // 19 variables such as Promise, Map, ...
	const newGlobals2017 = {
	    Atomics: false,
	    SharedArrayBuffer: false
	};
	const newGlobals2020 = {
	    BigInt: false,
	    BigInt64Array: false,
	    BigUint64Array: false,
	    globalThis: false
	};

	const newGlobals2021 = {
	    AggregateError: false,
	    FinalizationRegistry: false,
	    WeakRef: false
	};

	//------------------------------------------------------------------------------
	// Public Interface
	//------------------------------------------------------------------------------

	/** @type {Map<string, import("../lib/shared/types").Environment>} */
	var environments = new Map(Object.entries({

	    // Language
	    builtin: {
	        globals: globals__default["default"].es5
	    },
	    es6: {
	        globals: newGlobals2015,
	        parserOptions: {
	            ecmaVersion: 6
	        }
	    },
	    es2015: {
	        globals: newGlobals2015,
	        parserOptions: {
	            ecmaVersion: 6
	        }
	    },
	    es2016: {
	        globals: newGlobals2015,
	        parserOptions: {
	            ecmaVersion: 7
	        }
	    },
	    es2017: {
	        globals: { ...newGlobals2015, ...newGlobals2017 },
	        parserOptions: {
	            ecmaVersion: 8
	        }
	    },
	    es2018: {
	        globals: { ...newGlobals2015, ...newGlobals2017 },
	        parserOptions: {
	            ecmaVersion: 9
	        }
	    },
	    es2019: {
	        globals: { ...newGlobals2015, ...newGlobals2017 },
	        parserOptions: {
	            ecmaVersion: 10
	        }
	    },
	    es2020: {
	        globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020 },
	        parserOptions: {
	            ecmaVersion: 11
	        }
	    },
	    es2021: {
	        globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
	        parserOptions: {
	            ecmaVersion: 12
	        }
	    },
	    es2022: {
	        globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
	        parserOptions: {
	            ecmaVersion: 13
	        }
	    },
	    es2023: {
	        globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
	        parserOptions: {
	            ecmaVersion: 14
	        }
	    },
	    es2024: {
	        globals: { ...newGlobals2015, ...newGlobals2017, ...newGlobals2020, ...newGlobals2021 },
	        parserOptions: {
	            ecmaVersion: 15
	        }
	    },

	    // Platforms
	    browser: {
	        globals: globals__default["default"].browser
	    },
	    node: {
	        globals: globals__default["default"].node,
	        parserOptions: {
	            ecmaFeatures: {
	                globalReturn: true
	            }
	        }
	    },
	    "shared-node-browser": {
	        globals: globals__default["default"]["shared-node-browser"]
	    },
	    worker: {
	        globals: globals__default["default"].worker
	    },
	    serviceworker: {
	        globals: globals__default["default"].serviceworker
	    },

	    // Frameworks
	    commonjs: {
	        globals: globals__default["default"].commonjs,
	        parserOptions: {
	            ecmaFeatures: {
	                globalReturn: true
	            }
	        }
	    },
	    amd: {
	        globals: globals__default["default"].amd
	    },
	    mocha: {
	        globals: globals__default["default"].mocha
	    },
	    jasmine: {
	        globals: globals__default["default"].jasmine
	    },
	    jest: {
	        globals: globals__default["default"].jest
	    },
	    phantomjs: {
	        globals: globals__default["default"].phantomjs
	    },
	    jquery: {
	        globals: globals__default["default"].jquery
	    },
	    qunit: {
	        globals: globals__default["default"].qunit
	    },
	    prototypejs: {
	        globals: globals__default["default"].prototypejs
	    },
	    shelljs: {
	        globals: globals__default["default"].shelljs
	    },
	    meteor: {
	        globals: globals__default["default"].meteor
	    },
	    mongo: {
	        globals: globals__default["default"].mongo
	    },
	    protractor: {
	        globals: globals__default["default"].protractor
	    },
	    applescript: {
	        globals: globals__default["default"].applescript
	    },
	    nashorn: {
	        globals: globals__default["default"].nashorn
	    },
	    atomtest: {
	        globals: globals__default["default"].atomtest
	    },
	    embertest: {
	        globals: globals__default["default"].embertest
	    },
	    webextensions: {
	        globals: globals__default["default"].webextensions
	    },
	    greasemonkey: {
	        globals: globals__default["default"].greasemonkey
	    }
	}));

	/**
	 * @fileoverview Validates configs.
	 * @author Brandon Mills
	 */

	const ajv = ajvOrig();

	const ruleValidators = new WeakMap();
	const noop = Function.prototype;

	//------------------------------------------------------------------------------
	// Private
	//------------------------------------------------------------------------------
	let validateSchema;
	const severityMap = {
	    error: 2,
	    warn: 1,
	    off: 0
	};

	const validated = new WeakSet();

	// JSON schema that disallows passing any options
	const noOptionsSchema = Object.freeze({
	    type: "array",
	    minItems: 0,
	    maxItems: 0
	});

	//-----------------------------------------------------------------------------
	// Exports
	//-----------------------------------------------------------------------------

	/**
	 * Validator for configuration objects.
	 */
	class ConfigValidator {
	    constructor({ builtInRules = new Map() } = {}) {
	        this.builtInRules = builtInRules;
	    }

	    /**
	     * Gets a complete options schema for a rule.
	     * @param {Rule} rule A rule object
	     * @throws {TypeError} If `meta.schema` is specified but is not an array, object or `false`.
	     * @returns {Object|null} JSON Schema for the rule's options.
	     *      `null` if rule wasn't passed or its `meta.schema` is `false`.
	     */
	    getRuleOptionsSchema(rule) {
	        if (!rule) {
	            return null;
	        }

	        if (!rule.meta) {
	            return { ...noOptionsSchema }; // default if `meta.schema` is not specified
	        }

	        const schema = rule.meta.schema;

	        if (typeof schema === "undefined") {
	            return { ...noOptionsSchema }; // default if `meta.schema` is not specified
	        }

	        // `schema:false` is an allowed explicit opt-out of options validation for the rule
	        if (schema === false) {
	            return null;
	        }

	        if (typeof schema !== "object" || schema === null) {
	            throw new TypeError("Rule's `meta.schema` must be an array or object");
	        }

	        // ESLint-specific array form needs to be converted into a valid JSON Schema definition
	        if (Array.isArray(schema)) {
	            if (schema.length) {
	                return {
	                    type: "array",
	                    items: schema,
	                    minItems: 0,
	                    maxItems: schema.length
	                };
	            }

	            // `schema:[]` is an explicit way to specify that the rule does not accept any options
	            return { ...noOptionsSchema };
	        }

	        // `schema:<object>` is assumed to be a valid JSON Schema definition
	        return schema;
	    }

	    /**
	     * Validates a rule's severity and returns the severity value. Throws an error if the severity is invalid.
	     * @param {options} options The given options for the rule.
	     * @returns {number|string} The rule's severity value
	     * @throws {Error} If the severity is invalid.
	     */
	    validateRuleSeverity(options) {
	        const severity = Array.isArray(options) ? options[0] : options;
	        const normSeverity = typeof severity === "string" ? severityMap[severity.toLowerCase()] : severity;

	        if (normSeverity === 0 || normSeverity === 1 || normSeverity === 2) {
	            return normSeverity;
	        }

	        throw new Error(`\tSeverity should be one of the following: 0 = off, 1 = warn, 2 = error (you passed '${util__default["default"].inspect(severity).replace(/'/gu, "\"").replace(/\n/gu, "")}').\n`);

	    }

	    /**
	     * Validates the non-severity options passed to a rule, based on its schema.
	     * @param {{create: Function}} rule The rule to validate
	     * @param {Array} localOptions The options for the rule, excluding severity
	     * @returns {void}
	     * @throws {Error} If the options are invalid.
	     */
	    validateRuleSchema(rule, localOptions) {
	        if (!ruleValidators.has(rule)) {
	            try {
	                const schema = this.getRuleOptionsSchema(rule);

	                if (schema) {
	                    ruleValidators.set(rule, ajv.compile(schema));
	                }
	            } catch (err) {
	                const errorWithCode = new Error(err.message, { cause: err });

	                errorWithCode.code = "ESLINT_INVALID_RULE_OPTIONS_SCHEMA";

	                throw errorWithCode;
	            }
	        }

	        const validateRule = ruleValidators.get(rule);

	        if (validateRule) {
	            const mergedOptions = deepMergeArrays(rule.meta?.defaultOptions, localOptions);

	            validateRule(mergedOptions);

	            if (validateRule.errors) {
	                throw new Error(validateRule.errors.map(
	                    error => `\tValue ${JSON.stringify(error.data)} ${error.message}.\n`
	                ).join(""));
	            }
	        }
	    }

	    /**
	     * Validates a rule's options against its schema.
	     * @param {{create: Function}|null} rule The rule that the config is being validated for
	     * @param {string} ruleId The rule's unique name.
	     * @param {Array|number} options The given options for the rule.
	     * @param {string|null} source The name of the configuration source to report in any errors. If null or undefined,
	     * no source is prepended to the message.
	     * @returns {void}
	     * @throws {Error} If the options are invalid.
	     */
	    validateRuleOptions(rule, ruleId, options, source = null) {
	        try {
	            const severity = this.validateRuleSeverity(options);

	            if (severity !== 0) {
	                this.validateRuleSchema(rule, Array.isArray(options) ? options.slice(1) : []);
	            }
	        } catch (err) {
	            let enhancedMessage = err.code === "ESLINT_INVALID_RULE_OPTIONS_SCHEMA"
	                ? `Error while processing options validation schema of rule '${ruleId}': ${err.message}`
	                : `Configuration for rule "${ruleId}" is invalid:\n${err.message}`;

	            if (typeof source === "string") {
	                enhancedMessage = `${source}:\n\t${enhancedMessage}`;
	            }

	            const enhancedError = new Error(enhancedMessage, { cause: err });

	            if (err.code) {
	                enhancedError.code = err.code;
	            }

	            throw enhancedError;
	        }
	    }

	    /**
	     * Validates an environment object
	     * @param {Object} environment The environment config object to validate.
	     * @param {string} source The name of the configuration source to report in any errors.
	     * @param {(envId:string) => Object} [getAdditionalEnv] A map from strings to loaded environments.
	     * @returns {void}
	     * @throws {Error} If the environment is invalid.
	     */
	    validateEnvironment(
	        environment,
	        source,
	        getAdditionalEnv = noop
	    ) {

	        // not having an environment is ok
	        if (!environment) {
	            return;
	        }

	        Object.keys(environment).forEach(id => {
	            const env = getAdditionalEnv(id) || environments.get(id) || null;

	            if (!env) {
	                const message = `${source}:\n\tEnvironment key "${id}" is unknown\n`;

	                throw new Error(message);
	            }
	        });
	    }

	    /**
	     * Validates a rules config object
	     * @param {Object} rulesConfig The rules config object to validate.
	     * @param {string} source The name of the configuration source to report in any errors.
	     * @param {(ruleId:string) => Object} getAdditionalRule A map from strings to loaded rules
	     * @returns {void}
	     */
	    validateRules(
	        rulesConfig,
	        source,
	        getAdditionalRule = noop
	    ) {
	        if (!rulesConfig) {
	            return;
	        }

	        Object.keys(rulesConfig).forEach(id => {
	            const rule = getAdditionalRule(id) || this.builtInRules.get(id) || null;

	            this.validateRuleOptions(rule, id, rulesConfig[id], source);
	        });
	    }

	    /**
	     * Validates a `globals` section of a config file
	     * @param {Object} globalsConfig The `globals` section
	     * @param {string|null} source The name of the configuration source to report in the event of an error.
	     * @returns {void}
	     */
	    validateGlobals(globalsConfig, source = null) {
	        if (!globalsConfig) {
	            return;
	        }

	        Object.entries(globalsConfig)
	            .forEach(([configuredGlobal, configuredValue]) => {
	                try {
	                    normalizeConfigGlobal(configuredValue);
	                } catch (err) {
	                    throw new Error(`ESLint configuration of global '${configuredGlobal}' in ${source} is invalid:\n${err.message}`);
	                }
	            });
	    }

	    /**
	     * Validate `processor` configuration.
	     * @param {string|undefined} processorName The processor name.
	     * @param {string} source The name of config file.
	     * @param {(id:string) => Processor} getProcessor The getter of defined processors.
	     * @returns {void}
	     * @throws {Error} If the processor is invalid.
	     */
	    validateProcessor(processorName, source, getProcessor) {
	        if (processorName && !getProcessor(processorName)) {
	            throw new Error(`ESLint configuration of processor in '${source}' is invalid: '${processorName}' was not found.`);
	        }
	    }

	    /**
	     * Formats an array of schema validation errors.
	     * @param {Array} errors An array of error messages to format.
	     * @returns {string} Formatted error message
	     */
	    formatErrors(errors) {
	        return errors.map(error => {
	            if (error.keyword === "additionalProperties") {
	                const formattedPropertyPath = error.dataPath.length ? `${error.dataPath.slice(1)}.${error.params.additionalProperty}` : error.params.additionalProperty;

	                return `Unexpected top-level property "${formattedPropertyPath}"`;
	            }
	            if (error.keyword === "type") {
	                const formattedField = error.dataPath.slice(1);
	                const formattedExpectedType = Array.isArray(error.schema) ? error.schema.join("/") : error.schema;
	                const formattedValue = JSON.stringify(error.data);

	                return `Property "${formattedField}" is the wrong type (expected ${formattedExpectedType} but got \`${formattedValue}\`)`;
	            }

	            const field = error.dataPath[0] === "." ? error.dataPath.slice(1) : error.dataPath;

	            return `"${field}" ${error.message}. Value: ${JSON.stringify(error.data)}`;
	        }).map(message => `\t- ${message}.\n`).join("");
	    }

	    /**
	     * Validates the top level properties of the config object.
	     * @param {Object} config The config object to validate.
	     * @param {string} source The name of the configuration source to report in any errors.
	     * @returns {void}
	     * @throws {Error} If the config is invalid.
	     */
	    validateConfigSchema(config, source = null) {
	        validateSchema = validateSchema || ajv.compile(configSchema);

	        if (!validateSchema(config)) {
	            throw new Error(`ESLint configuration in ${source} is invalid:\n${this.formatErrors(validateSchema.errors)}`);
	        }

	        if (Object.hasOwn(config, "ecmaFeatures")) {
	            emitDeprecationWarning(source, "ESLINT_LEGACY_ECMAFEATURES");
	        }
	    }

	    /**
	     * Validates an entire config object.
	     * @param {Object} config The config object to validate.
	     * @param {string} source The name of the configuration source to report in any errors.
	     * @param {(ruleId:string) => Object} [getAdditionalRule] A map from strings to loaded rules.
	     * @param {(envId:string) => Object} [getAdditionalEnv] A map from strings to loaded envs.
	     * @returns {void}
	     */
	    validate(config, source, getAdditionalRule, getAdditionalEnv) {
	        this.validateConfigSchema(config, source);
	        this.validateRules(config.rules, source, getAdditionalRule);
	        this.validateEnvironment(config.env, source, getAdditionalEnv);
	        this.validateGlobals(config.globals, source);

	        for (const override of config.overrides || []) {
	            this.validateRules(override.rules, source, getAdditionalRule);
	            this.validateEnvironment(override.env, source, getAdditionalEnv);
	            this.validateGlobals(config.globals, source);
	        }
	    }

	    /**
	     * Validate config array object.
	     * @param {ConfigArray} configArray The config array to validate.
	     * @returns {void}
	     */
	    validateConfigArray(configArray) {
	        const getPluginEnv = Map.prototype.get.bind(configArray.pluginEnvironments);
	        const getPluginProcessor = Map.prototype.get.bind(configArray.pluginProcessors);
	        const getPluginRule = Map.prototype.get.bind(configArray.pluginRules);

	        // Validate.
	        for (const element of configArray) {
	            if (validated.has(element)) {
	                continue;
	            }
	            validated.add(element);

	            this.validateEnvironment(element.env, element.name, getPluginEnv);
	            this.validateGlobals(element.globals, element.name);
	            this.validateProcessor(element.processor, element.name, getPluginProcessor);
	            this.validateRules(element.rules, element.name, getPluginRule);
	        }
	    }

	}

	/**
	 * @fileoverview Common helpers for naming of plugins, formatters and configs
	 */

	const NAMESPACE_REGEX = /^@.*\//iu;

	/**
	 * Brings package name to correct format based on prefix
	 * @param {string} name The name of the package.
	 * @param {string} prefix Can be either "eslint-plugin", "eslint-config" or "eslint-formatter"
	 * @returns {string} Normalized name of the package
	 * @private
	 */
	function normalizePackageName(name, prefix) {
	    let normalizedName = name;

	    /**
	     * On Windows, name can come in with Windows slashes instead of Unix slashes.
	     * Normalize to Unix first to avoid errors later on.
	     * https://github.com/eslint/eslint/issues/5644
	     */
	    if (normalizedName.includes("\\")) {
	        normalizedName = normalizedName.replace(/\\/gu, "/");
	    }

	    if (normalizedName.charAt(0) === "@") {

	        /**
	         * it's a scoped package
	         * package name is the prefix, or just a username
	         */
	        const scopedPackageShortcutRegex = new RegExp(`^(@[^/]+)(?:/(?:${prefix})?)?$`, "u"),
	            scopedPackageNameRegex = new RegExp(`^${prefix}(-|$)`, "u");

	        if (scopedPackageShortcutRegex.test(normalizedName)) {
	            normalizedName = normalizedName.replace(scopedPackageShortcutRegex, `$1/${prefix}`);
	        } else if (!scopedPackageNameRegex.test(normalizedName.split("/")[1])) {

	            /**
	             * for scoped packages, insert the prefix after the first / unless
	             * the path is already @scope/eslint or @scope/eslint-xxx-yyy
	             */
	            normalizedName = normalizedName.replace(/^@([^/]+)\/(.*)$/u, `@$1/${prefix}-$2`);
	        }
	    } else if (!normalizedName.startsWith(`${prefix}-`)) {
	        normalizedName = `${prefix}-${normalizedName}`;
	    }

	    return normalizedName;
	}

	/**
	 * Removes the prefix from a fullname.
	 * @param {string} fullname The term which may have the prefix.
	 * @param {string} prefix The prefix to remove.
	 * @returns {string} The term without prefix.
	 */
	function getShorthandName(fullname, prefix) {
	    if (fullname[0] === "@") {
	        let matchResult = new RegExp(`^(@[^/]+)/${prefix}$`, "u").exec(fullname);

	        if (matchResult) {
	            return matchResult[1];
	        }

	        matchResult = new RegExp(`^(@[^/]+)/${prefix}-(.+)$`, "u").exec(fullname);
	        if (matchResult) {
	            return `${matchResult[1]}/${matchResult[2]}`;
	        }
	    } else if (fullname.startsWith(`${prefix}-`)) {
	        return fullname.slice(prefix.length + 1);
	    }

	    return fullname;
	}

	/**
	 * Gets the scope (namespace) of a term.
	 * @param {string} term The term which may have the namespace.
	 * @returns {string} The namespace of the term if it has one.
	 */
	function getNamespaceFromTerm(term) {
	    const match = term.match(NAMESPACE_REGEX);

	    return match ? match[0] : "";
	}

	var naming = {
	    __proto__: null,
	    normalizePackageName: normalizePackageName,
	    getShorthandName: getShorthandName,
	    getNamespaceFromTerm: getNamespaceFromTerm
	};

	/**
	 * @fileoverview Package exports for @eslint/eslintrc
	 * @author Nicholas C. Zakas
	 */

	//-----------------------------------------------------------------------------
	// Exports
	//-----------------------------------------------------------------------------

	const Legacy = {
	    environments,

	    // shared
	    ConfigOps,
	    ConfigValidator,
	    naming
	};

	eslintrcUniversal.Legacy = Legacy;
	
	return eslintrcUniversal;
}

var src = {exports: {}};

var browser = {exports: {}};

/**
 * Helpers.
 */

var ms;
var hasRequiredMs;

function requireMs () {
	if (hasRequiredMs) return ms;
	hasRequiredMs = 1;
	var s = 1000;
	var m = s * 60;
	var h = m * 60;
	var d = h * 24;
	var w = d * 7;
	var y = d * 365.25;

	/**
	 * Parse or format the given `val`.
	 *
	 * Options:
	 *
	 *  - `long` verbose formatting [false]
	 *
	 * @param {String|Number} val
	 * @param {Object} [options]
	 * @throws {Error} throw an error if val is not a non-empty string or a number
	 * @return {String|Number}
	 * @api public
	 */

	ms = function (val, options) {
	  options = options || {};
	  var type = typeof val;
	  if (type === 'string' && val.length > 0) {
	    return parse(val);
	  } else if (type === 'number' && isFinite(val)) {
	    return options.long ? fmtLong(val) : fmtShort(val);
	  }
	  throw new Error(
	    'val is not a non-empty string or a valid number. val=' +
	      JSON.stringify(val)
	  );
	};

	/**
	 * Parse the given `str` and return milliseconds.
	 *
	 * @param {String} str
	 * @return {Number}
	 * @api private
	 */

	function parse(str) {
	  str = String(str);
	  if (str.length > 100) {
	    return;
	  }
	  var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
	    str
	  );
	  if (!match) {
	    return;
	  }
	  var n = parseFloat(match[1]);
	  var type = (match[2] || 'ms').toLowerCase();
	  switch (type) {
	    case 'years':
	    case 'year':
	    case 'yrs':
	    case 'yr':
	    case 'y':
	      return n * y;
	    case 'weeks':
	    case 'week':
	    case 'w':
	      return n * w;
	    case 'days':
	    case 'day':
	    case 'd':
	      return n * d;
	    case 'hours':
	    case 'hour':
	    case 'hrs':
	    case 'hr':
	    case 'h':
	      return n * h;
	    case 'minutes':
	    case 'minute':
	    case 'mins':
	    case 'min':
	    case 'm':
	      return n * m;
	    case 'seconds':
	    case 'second':
	    case 'secs':
	    case 'sec':
	    case 's':
	      return n * s;
	    case 'milliseconds':
	    case 'millisecond':
	    case 'msecs':
	    case 'msec':
	    case 'ms':
	      return n;
	    default:
	      return undefined;
	  }
	}

	/**
	 * Short format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtShort(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return Math.round(ms / d) + 'd';
	  }
	  if (msAbs >= h) {
	    return Math.round(ms / h) + 'h';
	  }
	  if (msAbs >= m) {
	    return Math.round(ms / m) + 'm';
	  }
	  if (msAbs >= s) {
	    return Math.round(ms / s) + 's';
	  }
	  return ms + 'ms';
	}

	/**
	 * Long format for `ms`.
	 *
	 * @param {Number} ms
	 * @return {String}
	 * @api private
	 */

	function fmtLong(ms) {
	  var msAbs = Math.abs(ms);
	  if (msAbs >= d) {
	    return plural(ms, msAbs, d, 'day');
	  }
	  if (msAbs >= h) {
	    return plural(ms, msAbs, h, 'hour');
	  }
	  if (msAbs >= m) {
	    return plural(ms, msAbs, m, 'minute');
	  }
	  if (msAbs >= s) {
	    return plural(ms, msAbs, s, 'second');
	  }
	  return ms + ' ms';
	}

	/**
	 * Pluralization helper.
	 */

	function plural(ms, msAbs, n, name) {
	  var isPlural = msAbs >= n * 1.5;
	  return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
	}
	return ms;
}

var common;
var hasRequiredCommon;

function requireCommon () {
	if (hasRequiredCommon) return common;
	hasRequiredCommon = 1;
	/**
	 * This is the common logic for both the Node.js and web browser
	 * implementations of `debug()`.
	 */

	function setup(env) {
		createDebug.debug = createDebug;
		createDebug.default = createDebug;
		createDebug.coerce = coerce;
		createDebug.disable = disable;
		createDebug.enable = enable;
		createDebug.enabled = enabled;
		createDebug.humanize = requireMs();
		createDebug.destroy = destroy;

		Object.keys(env).forEach(key => {
			createDebug[key] = env[key];
		});

		/**
		* The currently active debug mode names, and names to skip.
		*/

		createDebug.names = [];
		createDebug.skips = [];

		/**
		* Map of special "%n" handling functions, for the debug "format" argument.
		*
		* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
		*/
		createDebug.formatters = {};

		/**
		* Selects a color for a debug namespace
		* @param {String} namespace The namespace string for the debug instance to be colored
		* @return {Number|String} An ANSI color code for the given namespace
		* @api private
		*/
		function selectColor(namespace) {
			let hash = 0;

			for (let i = 0; i < namespace.length; i++) {
				hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
				hash |= 0; // Convert to 32bit integer
			}

			return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
		}
		createDebug.selectColor = selectColor;

		/**
		* Create a debugger with the given `namespace`.
		*
		* @param {String} namespace
		* @return {Function}
		* @api public
		*/
		function createDebug(namespace) {
			let prevTime;
			let enableOverride = null;
			let namespacesCache;
			let enabledCache;

			function debug(...args) {
				// Disabled?
				if (!debug.enabled) {
					return;
				}

				const self = debug;

				// Set `diff` timestamp
				const curr = Number(new Date());
				const ms = curr - (prevTime || curr);
				self.diff = ms;
				self.prev = prevTime;
				self.curr = curr;
				prevTime = curr;

				args[0] = createDebug.coerce(args[0]);

				if (typeof args[0] !== 'string') {
					// Anything else let's inspect with %O
					args.unshift('%O');
				}

				// Apply any `formatters` transformations
				let index = 0;
				args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
					// If we encounter an escaped % then don't increase the array index
					if (match === '%%') {
						return '%';
					}
					index++;
					const formatter = createDebug.formatters[format];
					if (typeof formatter === 'function') {
						const val = args[index];
						match = formatter.call(self, val);

						// Now we need to remove `args[index]` since it's inlined in the `format`
						args.splice(index, 1);
						index--;
					}
					return match;
				});

				// Apply env-specific formatting (colors, etc.)
				createDebug.formatArgs.call(self, args);

				const logFn = self.log || createDebug.log;
				logFn.apply(self, args);
			}

			debug.namespace = namespace;
			debug.useColors = createDebug.useColors();
			debug.color = createDebug.selectColor(namespace);
			debug.extend = extend;
			debug.destroy = createDebug.destroy; // XXX Temporary. Will be removed in the next major release.

			Object.defineProperty(debug, 'enabled', {
				enumerable: true,
				configurable: false,
				get: () => {
					if (enableOverride !== null) {
						return enableOverride;
					}
					if (namespacesCache !== createDebug.namespaces) {
						namespacesCache = createDebug.namespaces;
						enabledCache = createDebug.enabled(namespace);
					}

					return enabledCache;
				},
				set: v => {
					enableOverride = v;
				}
			});

			// Env-specific initialization logic for debug instances
			if (typeof createDebug.init === 'function') {
				createDebug.init(debug);
			}

			return debug;
		}

		function extend(namespace, delimiter) {
			const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
			newDebug.log = this.log;
			return newDebug;
		}

		/**
		* Enables a debug mode by namespaces. This can include modes
		* separated by a colon and wildcards.
		*
		* @param {String} namespaces
		* @api public
		*/
		function enable(namespaces) {
			createDebug.save(namespaces);
			createDebug.namespaces = namespaces;

			createDebug.names = [];
			createDebug.skips = [];

			const split = (typeof namespaces === 'string' ? namespaces : '')
				.trim()
				.replace(' ', ',')
				.split(',')
				.filter(Boolean);

			for (const ns of split) {
				if (ns[0] === '-') {
					createDebug.skips.push(ns.slice(1));
				} else {
					createDebug.names.push(ns);
				}
			}
		}

		/**
		 * Checks if the given string matches a namespace template, honoring
		 * asterisks as wildcards.
		 *
		 * @param {String} search
		 * @param {String} template
		 * @return {Boolean}
		 */
		function matchesTemplate(search, template) {
			let searchIndex = 0;
			let templateIndex = 0;
			let starIndex = -1;
			let matchIndex = 0;

			while (searchIndex < search.length) {
				if (templateIndex < template.length && (template[templateIndex] === search[searchIndex] || template[templateIndex] === '*')) {
					// Match character or proceed with wildcard
					if (template[templateIndex] === '*') {
						starIndex = templateIndex;
						matchIndex = searchIndex;
						templateIndex++; // Skip the '*'
					} else {
						searchIndex++;
						templateIndex++;
					}
				} else if (starIndex !== -1) { // eslint-disable-line no-negated-condition
					// Backtrack to the last '*' and try to match more characters
					templateIndex = starIndex + 1;
					matchIndex++;
					searchIndex = matchIndex;
				} else {
					return false; // No match
				}
			}

			// Handle trailing '*' in template
			while (templateIndex < template.length && template[templateIndex] === '*') {
				templateIndex++;
			}

			return templateIndex === template.length;
		}

		/**
		* Disable debug output.
		*
		* @return {String} namespaces
		* @api public
		*/
		function disable() {
			const namespaces = [
				...createDebug.names,
				...createDebug.skips.map(namespace => '-' + namespace)
			].join(',');
			createDebug.enable('');
			return namespaces;
		}

		/**
		* Returns true if the given mode name is enabled, false otherwise.
		*
		* @param {String} name
		* @return {Boolean}
		* @api public
		*/
		function enabled(name) {
			for (const skip of createDebug.skips) {
				if (matchesTemplate(name, skip)) {
					return false;
				}
			}

			for (const ns of createDebug.names) {
				if (matchesTemplate(name, ns)) {
					return true;
				}
			}

			return false;
		}

		/**
		* Coerce `val`.
		*
		* @param {Mixed} val
		* @return {Mixed}
		* @api private
		*/
		function coerce(val) {
			if (val instanceof Error) {
				return val.stack || val.message;
			}
			return val;
		}

		/**
		* XXX DO NOT USE. This is a temporary stub function.
		* XXX It WILL be removed in the next major release.
		*/
		function destroy() {
			console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
		}

		createDebug.enable(createDebug.load());

		return createDebug;
	}

	common = setup;
	return common;
}

var hasRequiredBrowser;

function requireBrowser () {
	if (hasRequiredBrowser) return browser.exports;
	hasRequiredBrowser = 1;
	(function (module, exports) {
		/**
		 * This is the web browser implementation of `debug()`.
		 */

		exports.formatArgs = formatArgs;
		exports.save = save;
		exports.load = load;
		exports.useColors = useColors;
		exports.storage = localstorage();
		exports.destroy = (() => {
			let warned = false;

			return () => {
				if (!warned) {
					warned = true;
					console.warn('Instance method `debug.destroy()` is deprecated and no longer does anything. It will be removed in the next major version of `debug`.');
				}
			};
		})();

		/**
		 * Colors.
		 */

		exports.colors = [
			'#0000CC',
			'#0000FF',
			'#0033CC',
			'#0033FF',
			'#0066CC',
			'#0066FF',
			'#0099CC',
			'#0099FF',
			'#00CC00',
			'#00CC33',
			'#00CC66',
			'#00CC99',
			'#00CCCC',
			'#00CCFF',
			'#3300CC',
			'#3300FF',
			'#3333CC',
			'#3333FF',
			'#3366CC',
			'#3366FF',
			'#3399CC',
			'#3399FF',
			'#33CC00',
			'#33CC33',
			'#33CC66',
			'#33CC99',
			'#33CCCC',
			'#33CCFF',
			'#6600CC',
			'#6600FF',
			'#6633CC',
			'#6633FF',
			'#66CC00',
			'#66CC33',
			'#9900CC',
			'#9900FF',
			'#9933CC',
			'#9933FF',
			'#99CC00',
			'#99CC33',
			'#CC0000',
			'#CC0033',
			'#CC0066',
			'#CC0099',
			'#CC00CC',
			'#CC00FF',
			'#CC3300',
			'#CC3333',
			'#CC3366',
			'#CC3399',
			'#CC33CC',
			'#CC33FF',
			'#CC6600',
			'#CC6633',
			'#CC9900',
			'#CC9933',
			'#CCCC00',
			'#CCCC33',
			'#FF0000',
			'#FF0033',
			'#FF0066',
			'#FF0099',
			'#FF00CC',
			'#FF00FF',
			'#FF3300',
			'#FF3333',
			'#FF3366',
			'#FF3399',
			'#FF33CC',
			'#FF33FF',
			'#FF6600',
			'#FF6633',
			'#FF9900',
			'#FF9933',
			'#FFCC00',
			'#FFCC33'
		];

		/**
		 * Currently only WebKit-based Web Inspectors, Firefox >= v31,
		 * and the Firebug extension (any Firefox version) are known
		 * to support "%c" CSS customizations.
		 *
		 * TODO: add a `localStorage` variable to explicitly enable/disable colors
		 */

		// eslint-disable-next-line complexity
		function useColors() {
			// NB: In an Electron preload script, document will be defined but not fully
			// initialized. Since we know we're in Chrome, we'll just detect this case
			// explicitly
			if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
				return true;
			}

			// Internet Explorer and Edge do not support colors.
			if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
				return false;
			}

			let m;

			// Is webkit? http://stackoverflow.com/a/16459606/376773
			// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
			// eslint-disable-next-line no-return-assign
			return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
				// Is firebug? http://stackoverflow.com/a/398120/376773
				(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
				// Is firefox >= v31?
				// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
				(typeof navigator !== 'undefined' && navigator.userAgent && (m = navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/)) && parseInt(m[1], 10) >= 31) ||
				// Double check webkit in userAgent just in case we are in a worker
				(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
		}

		/**
		 * Colorize log arguments if enabled.
		 *
		 * @api public
		 */

		function formatArgs(args) {
			args[0] = (this.useColors ? '%c' : '') +
				this.namespace +
				(this.useColors ? ' %c' : ' ') +
				args[0] +
				(this.useColors ? '%c ' : ' ') +
				'+' + module.exports.humanize(this.diff);

			if (!this.useColors) {
				return;
			}

			const c = 'color: ' + this.color;
			args.splice(1, 0, c, 'color: inherit');

			// The final "%c" is somewhat tricky, because there could be other
			// arguments passed either before or after the %c, so we need to
			// figure out the correct index to insert the CSS into
			let index = 0;
			let lastC = 0;
			args[0].replace(/%[a-zA-Z%]/g, match => {
				if (match === '%%') {
					return;
				}
				index++;
				if (match === '%c') {
					// We only are interested in the *last* %c
					// (the user may have provided their own)
					lastC = index;
				}
			});

			args.splice(lastC, 0, c);
		}

		/**
		 * Invokes `console.debug()` when available.
		 * No-op when `console.debug` is not a "function".
		 * If `console.debug` is not available, falls back
		 * to `console.log`.
		 *
		 * @api public
		 */
		exports.log = console.debug || console.log || (() => {});

		/**
		 * Save `namespaces`.
		 *
		 * @param {String} namespaces
		 * @api private
		 */
		function save(namespaces) {
			try {
				if (namespaces) {
					exports.storage.setItem('debug', namespaces);
				} else {
					exports.storage.removeItem('debug');
				}
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}
		}

		/**
		 * Load `namespaces`.
		 *
		 * @return {String} returns the previously persisted debug modes
		 * @api private
		 */
		function load() {
			let r;
			try {
				r = exports.storage.getItem('debug');
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}

			// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
			if (!r && typeof browser$1$1 !== 'undefined' && 'env' in browser$1$1) {
				r = browser$1$1.env.DEBUG;
			}

			return r;
		}

		/**
		 * Localstorage attempts to return the localstorage.
		 *
		 * This is necessary because safari throws
		 * when a user disables cookies/localstorage
		 * and you attempt to access it.
		 *
		 * @return {LocalStorage}
		 * @api private
		 */

		function localstorage() {
			try {
				// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
				// The Browser also has localStorage in the global context.
				return localStorage;
			} catch (error) {
				// Swallow
				// XXX (@Qix-) should we be logging these?
			}
		}

		module.exports = requireCommon()(exports);

		const {formatters} = module.exports;

		/**
		 * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
		 */

		formatters.j = function (v) {
			try {
				return JSON.stringify(v);
			} catch (error) {
				return '[UnexpectedJSONParseError]: ' + error.message;
			}
		}; 
	} (browser, browser.exports));
	return browser.exports;
}

var hasRequiredSrc;

function requireSrc () {
	if (hasRequiredSrc) return src.exports;
	hasRequiredSrc = 1;
	{
		src.exports = requireBrowser();
	}
	return src.exports;
}

/**
 * @fileoverview Traverser to traverse AST trees.
 * @author Nicholas C. Zakas
 * @author Toru Nagashima
 */

var traverser;
var hasRequiredTraverser;

function requireTraverser () {
	if (hasRequiredTraverser) return traverser;
	hasRequiredTraverser = 1;

	//------------------------------------------------------------------------------
	// Requirements
	//------------------------------------------------------------------------------

	const vk = requireEslintVisitorKeys$2();
	const debug = requireSrc()("eslint:traverser");

	//------------------------------------------------------------------------------
	// Helpers
	//------------------------------------------------------------------------------

	/**
	 * Do nothing.
	 * @returns {void}
	 */
	function noop() {
		// do nothing.
	}

	/**
	 * Check whether the given value is an ASTNode or not.
	 * @param {any} x The value to check.
	 * @returns {boolean} `true` if the value is an ASTNode.
	 */
	function isNode(x) {
		return x !== null && typeof x === "object" && typeof x.type === "string";
	}

	/**
	 * Get the visitor keys of a given node.
	 * @param {Object} visitorKeys The map of visitor keys.
	 * @param {ASTNode} node The node to get their visitor keys.
	 * @returns {string[]} The visitor keys of the node.
	 */
	function getVisitorKeys(visitorKeys, node) {
		let keys = visitorKeys[node.type];

		if (!keys) {
			keys = vk.getKeys(node);
			debug(
				'Unknown node type "%s": Estimated visitor keys %j',
				node.type,
				keys,
			);
		}

		return keys;
	}

	/**
	 * The traverser class to traverse AST trees.
	 */
	class Traverser {
		constructor() {
			this._current = null;
			this._parents = [];
			this._skipped = false;
			this._broken = false;
			this._visitorKeys = null;
			this._enter = null;
			this._leave = null;
		}

		/**
		 * Gives current node.
		 * @returns {ASTNode} The current node.
		 */
		current() {
			return this._current;
		}

		/**
		 * Gives a copy of the ancestor nodes.
		 * @returns {ASTNode[]} The ancestor nodes.
		 */
		parents() {
			return this._parents.slice(0);
		}

		/**
		 * Break the current traversal.
		 * @returns {void}
		 */
		break() {
			this._broken = true;
		}

		/**
		 * Skip child nodes for the current traversal.
		 * @returns {void}
		 */
		skip() {
			this._skipped = true;
		}

		/**
		 * Traverse the given AST tree.
		 * @param {ASTNode} node The root node to traverse.
		 * @param {Object} options The option object.
		 * @param {Object} [options.visitorKeys=DEFAULT_VISITOR_KEYS] The keys of each node types to traverse child nodes. Default is `./default-visitor-keys.json`.
		 * @param {Function} [options.enter=noop] The callback function which is called on entering each node.
		 * @param {Function} [options.leave=noop] The callback function which is called on leaving each node.
		 * @returns {void}
		 */
		traverse(node, options) {
			this._current = null;
			this._parents = [];
			this._skipped = false;
			this._broken = false;
			this._visitorKeys = options.visitorKeys || vk.KEYS;
			this._enter = options.enter || noop;
			this._leave = options.leave || noop;
			this._traverse(node, null);
		}

		/**
		 * Traverse the given AST tree recursively.
		 * @param {ASTNode} node The current node.
		 * @param {ASTNode|null} parent The parent node.
		 * @returns {void}
		 * @private
		 */
		_traverse(node, parent) {
			if (!isNode(node)) {
				return;
			}

			this._current = node;
			this._skipped = false;
			this._enter(node, parent);

			if (!this._skipped && !this._broken) {
				const keys = getVisitorKeys(this._visitorKeys, node);

				if (keys.length >= 1) {
					this._parents.push(node);
					for (let i = 0; i < keys.length && !this._broken; ++i) {
						const child = node[keys[i]];

						if (Array.isArray(child)) {
							for (
								let j = 0;
								j < child.length && !this._broken;
								++j
							) {
								this._traverse(child[j], node);
							}
						} else {
							this._traverse(child, node);
						}
					}
					this._parents.pop();
				}
			}

			if (!this._broken) {
				this._leave(node, parent);
			}

			this._current = parent;
		}

		/**
		 * Calculates the keys to use for traversal.
		 * @param {ASTNode} node The node to read keys from.
		 * @returns {string[]} An array of keys to visit on the node.
		 * @private
		 */
		static getKeys(node) {
			return vk.getKeys(node);
		}

		/**
		 * Traverse the given AST tree.
		 * @param {ASTNode} node The root node to traverse.
		 * @param {Object} options The option object.
		 * @param {Object} [options.visitorKeys=DEFAULT_VISITOR_KEYS] The keys of each node types to traverse child nodes. Default is `./default-visitor-keys.json`.
		 * @param {Function} [options.enter=noop] The callback function which is called on entering each node.
		 * @param {Function} [options.leave=noop] The callback function which is called on leaving each node.
		 * @returns {void}
		 */
		static traverse(node, options) {
			new Traverser().traverse(node, options);
		}

		/**
		 * The default visitor keys.
		 * @type {Object}
		 */
		static get DEFAULT_VISITOR_KEYS() {
			return vk.KEYS;
		}
	}

	traverser = Traverser;
	return traverser;
}

var eslintUtils = {};

var eslintVisitorKeys = {};

var hasRequiredEslintVisitorKeys;

function requireEslintVisitorKeys () {
	if (hasRequiredEslintVisitorKeys) return eslintVisitorKeys;
	hasRequiredEslintVisitorKeys = 1;

	Object.defineProperty(eslintVisitorKeys, '__esModule', { value: true });

	/**
	 * @typedef {{ readonly [type: string]: ReadonlyArray<string> }} VisitorKeys
	 */

	/**
	 * @type {VisitorKeys}
	 */
	const KEYS = {
	    ArrayExpression: [
	        "elements"
	    ],
	    ArrayPattern: [
	        "elements"
	    ],
	    ArrowFunctionExpression: [
	        "params",
	        "body"
	    ],
	    AssignmentExpression: [
	        "left",
	        "right"
	    ],
	    AssignmentPattern: [
	        "left",
	        "right"
	    ],
	    AwaitExpression: [
	        "argument"
	    ],
	    BinaryExpression: [
	        "left",
	        "right"
	    ],
	    BlockStatement: [
	        "body"
	    ],
	    BreakStatement: [
	        "label"
	    ],
	    CallExpression: [
	        "callee",
	        "arguments"
	    ],
	    CatchClause: [
	        "param",
	        "body"
	    ],
	    ChainExpression: [
	        "expression"
	    ],
	    ClassBody: [
	        "body"
	    ],
	    ClassDeclaration: [
	        "id",
	        "superClass",
	        "body"
	    ],
	    ClassExpression: [
	        "id",
	        "superClass",
	        "body"
	    ],
	    ConditionalExpression: [
	        "test",
	        "consequent",
	        "alternate"
	    ],
	    ContinueStatement: [
	        "label"
	    ],
	    DebuggerStatement: [],
	    DoWhileStatement: [
	        "body",
	        "test"
	    ],
	    EmptyStatement: [],
	    ExperimentalRestProperty: [
	        "argument"
	    ],
	    ExperimentalSpreadProperty: [
	        "argument"
	    ],
	    ExportAllDeclaration: [
	        "exported",
	        "source"
	    ],
	    ExportDefaultDeclaration: [
	        "declaration"
	    ],
	    ExportNamedDeclaration: [
	        "declaration",
	        "specifiers",
	        "source"
	    ],
	    ExportSpecifier: [
	        "exported",
	        "local"
	    ],
	    ExpressionStatement: [
	        "expression"
	    ],
	    ForInStatement: [
	        "left",
	        "right",
	        "body"
	    ],
	    ForOfStatement: [
	        "left",
	        "right",
	        "body"
	    ],
	    ForStatement: [
	        "init",
	        "test",
	        "update",
	        "body"
	    ],
	    FunctionDeclaration: [
	        "id",
	        "params",
	        "body"
	    ],
	    FunctionExpression: [
	        "id",
	        "params",
	        "body"
	    ],
	    Identifier: [],
	    IfStatement: [
	        "test",
	        "consequent",
	        "alternate"
	    ],
	    ImportDeclaration: [
	        "specifiers",
	        "source"
	    ],
	    ImportDefaultSpecifier: [
	        "local"
	    ],
	    ImportExpression: [
	        "source"
	    ],
	    ImportNamespaceSpecifier: [
	        "local"
	    ],
	    ImportSpecifier: [
	        "imported",
	        "local"
	    ],
	    JSXAttribute: [
	        "name",
	        "value"
	    ],
	    JSXClosingElement: [
	        "name"
	    ],
	    JSXClosingFragment: [],
	    JSXElement: [
	        "openingElement",
	        "children",
	        "closingElement"
	    ],
	    JSXEmptyExpression: [],
	    JSXExpressionContainer: [
	        "expression"
	    ],
	    JSXFragment: [
	        "openingFragment",
	        "children",
	        "closingFragment"
	    ],
	    JSXIdentifier: [],
	    JSXMemberExpression: [
	        "object",
	        "property"
	    ],
	    JSXNamespacedName: [
	        "namespace",
	        "name"
	    ],
	    JSXOpeningElement: [
	        "name",
	        "attributes"
	    ],
	    JSXOpeningFragment: [],
	    JSXSpreadAttribute: [
	        "argument"
	    ],
	    JSXSpreadChild: [
	        "expression"
	    ],
	    JSXText: [],
	    LabeledStatement: [
	        "label",
	        "body"
	    ],
	    Literal: [],
	    LogicalExpression: [
	        "left",
	        "right"
	    ],
	    MemberExpression: [
	        "object",
	        "property"
	    ],
	    MetaProperty: [
	        "meta",
	        "property"
	    ],
	    MethodDefinition: [
	        "key",
	        "value"
	    ],
	    NewExpression: [
	        "callee",
	        "arguments"
	    ],
	    ObjectExpression: [
	        "properties"
	    ],
	    ObjectPattern: [
	        "properties"
	    ],
	    PrivateIdentifier: [],
	    Program: [
	        "body"
	    ],
	    Property: [
	        "key",
	        "value"
	    ],
	    PropertyDefinition: [
	        "key",
	        "value"
	    ],
	    RestElement: [
	        "argument"
	    ],
	    ReturnStatement: [
	        "argument"
	    ],
	    SequenceExpression: [
	        "expressions"
	    ],
	    SpreadElement: [
	        "argument"
	    ],
	    StaticBlock: [
	        "body"
	    ],
	    Super: [],
	    SwitchCase: [
	        "test",
	        "consequent"
	    ],
	    SwitchStatement: [
	        "discriminant",
	        "cases"
	    ],
	    TaggedTemplateExpression: [
	        "tag",
	        "quasi"
	    ],
	    TemplateElement: [],
	    TemplateLiteral: [
	        "quasis",
	        "expressions"
	    ],
	    ThisExpression: [],
	    ThrowStatement: [
	        "argument"
	    ],
	    TryStatement: [
	        "block",
	        "handler",
	        "finalizer"
	    ],
	    UnaryExpression: [
	        "argument"
	    ],
	    UpdateExpression: [
	        "argument"
	    ],
	    VariableDeclaration: [
	        "declarations"
	    ],
	    VariableDeclarator: [
	        "id",
	        "init"
	    ],
	    WhileStatement: [
	        "test",
	        "body"
	    ],
	    WithStatement: [
	        "object",
	        "body"
	    ],
	    YieldExpression: [
	        "argument"
	    ]
	};

	// Types.
	const NODE_TYPES = Object.keys(KEYS);

	// Freeze the keys.
	for (const type of NODE_TYPES) {
	    Object.freeze(KEYS[type]);
	}
	Object.freeze(KEYS);

	/**
	 * @author Toru Nagashima <https://github.com/mysticatea>
	 * See LICENSE file in root directory for full license.
	 */

	/**
	 * @typedef {import('./visitor-keys.js').VisitorKeys} VisitorKeys
	 */

	// List to ignore keys.
	const KEY_BLACKLIST = new Set([
	    "parent",
	    "leadingComments",
	    "trailingComments"
	]);

	/**
	 * Check whether a given key should be used or not.
	 * @param {string} key The key to check.
	 * @returns {boolean} `true` if the key should be used.
	 */
	function filterKey(key) {
	    return !KEY_BLACKLIST.has(key) && key[0] !== "_";
	}

	/**
	 * Get visitor keys of a given node.
	 * @param {object} node The AST node to get keys.
	 * @returns {readonly string[]} Visitor keys of the node.
	 */
	function getKeys(node) {
	    return Object.keys(node).filter(filterKey);
	}

	// Disable valid-jsdoc rule because it reports syntax error on the type of @returns.
	// eslint-disable-next-line valid-jsdoc
	/**
	 * Make the union set with `KEYS` and given keys.
	 * @param {VisitorKeys} additionalKeys The additional keys.
	 * @returns {VisitorKeys} The union set.
	 */
	function unionWith(additionalKeys) {
	    const retv = /** @type {{
	        [type: string]: ReadonlyArray<string>
	    }} */ (Object.assign({}, KEYS));

	    for (const type of Object.keys(additionalKeys)) {
	        if (Object.prototype.hasOwnProperty.call(retv, type)) {
	            const keys = new Set(additionalKeys[type]);

	            for (const key of retv[type]) {
	                keys.add(key);
	            }

	            retv[type] = Object.freeze(Array.from(keys));
	        } else {
	            retv[type] = Object.freeze(Array.from(additionalKeys[type]));
	        }
	    }

	    return Object.freeze(retv);
	}

	eslintVisitorKeys.KEYS = KEYS;
	eslintVisitorKeys.getKeys = getKeys;
	eslintVisitorKeys.unionWith = unionWith;
	return eslintVisitorKeys;
}

var hasRequiredEslintUtils;

function requireEslintUtils () {
	if (hasRequiredEslintUtils) return eslintUtils;
	hasRequiredEslintUtils = 1;
	(function (exports) {

		Object.defineProperty(exports, '__esModule', { value: true });

		var eslintVisitorKeys = requireEslintVisitorKeys();

		/**
		 * Get the innermost scope which contains a given location.
		 * @param {Scope} initialScope The initial scope to search.
		 * @param {Node} node The location to search.
		 * @returns {Scope} The innermost scope.
		 */
		function getInnermostScope(initialScope, node) {
		    const location = node.range[0];

		    let scope = initialScope;
		    let found = false;
		    do {
		        found = false;
		        for (const childScope of scope.childScopes) {
		            const range = childScope.block.range;

		            if (range[0] <= location && location < range[1]) {
		                scope = childScope;
		                found = true;
		                break
		            }
		        }
		    } while (found)

		    return scope
		}

		/**
		 * Find the variable of a given name.
		 * @param {Scope} initialScope The scope to start finding.
		 * @param {string|Node} nameOrNode The variable name to find. If this is a Node object then it should be an Identifier node.
		 * @returns {Variable|null} The found variable or null.
		 */
		function findVariable(initialScope, nameOrNode) {
		    let name = "";
		    let scope = initialScope;

		    if (typeof nameOrNode === "string") {
		        name = nameOrNode;
		    } else {
		        name = nameOrNode.name;
		        scope = getInnermostScope(scope, nameOrNode);
		    }

		    while (scope != null) {
		        const variable = scope.set.get(name);
		        if (variable != null) {
		            return variable
		        }
		        scope = scope.upper;
		    }

		    return null
		}

		/**
		 * Negate the result of `this` calling.
		 * @param {Token} token The token to check.
		 * @returns {boolean} `true` if the result of `this(token)` is `false`.
		 */
		function negate0(token) {
		    return !this(token) //eslint-disable-line no-invalid-this
		}

		/**
		 * Creates the negate function of the given function.
		 * @param {function(Token):boolean} f - The function to negate.
		 * @returns {function(Token):boolean} Negated function.
		 */
		function negate(f) {
		    return negate0.bind(f)
		}

		/**
		 * Checks if the given token is a PunctuatorToken with the given value
		 * @param {Token} token - The token to check.
		 * @param {string} value - The value to check.
		 * @returns {boolean} `true` if the token is a PunctuatorToken with the given value.
		 */
		function isPunctuatorTokenWithValue(token, value) {
		    return token.type === "Punctuator" && token.value === value
		}

		/**
		 * Checks if the given token is an arrow token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is an arrow token.
		 */
		function isArrowToken(token) {
		    return isPunctuatorTokenWithValue(token, "=>")
		}

		/**
		 * Checks if the given token is a comma token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a comma token.
		 */
		function isCommaToken(token) {
		    return isPunctuatorTokenWithValue(token, ",")
		}

		/**
		 * Checks if the given token is a semicolon token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a semicolon token.
		 */
		function isSemicolonToken(token) {
		    return isPunctuatorTokenWithValue(token, ";")
		}

		/**
		 * Checks if the given token is a colon token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a colon token.
		 */
		function isColonToken(token) {
		    return isPunctuatorTokenWithValue(token, ":")
		}

		/**
		 * Checks if the given token is an opening parenthesis token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is an opening parenthesis token.
		 */
		function isOpeningParenToken(token) {
		    return isPunctuatorTokenWithValue(token, "(")
		}

		/**
		 * Checks if the given token is a closing parenthesis token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a closing parenthesis token.
		 */
		function isClosingParenToken(token) {
		    return isPunctuatorTokenWithValue(token, ")")
		}

		/**
		 * Checks if the given token is an opening square bracket token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is an opening square bracket token.
		 */
		function isOpeningBracketToken(token) {
		    return isPunctuatorTokenWithValue(token, "[")
		}

		/**
		 * Checks if the given token is a closing square bracket token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a closing square bracket token.
		 */
		function isClosingBracketToken(token) {
		    return isPunctuatorTokenWithValue(token, "]")
		}

		/**
		 * Checks if the given token is an opening brace token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is an opening brace token.
		 */
		function isOpeningBraceToken(token) {
		    return isPunctuatorTokenWithValue(token, "{")
		}

		/**
		 * Checks if the given token is a closing brace token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a closing brace token.
		 */
		function isClosingBraceToken(token) {
		    return isPunctuatorTokenWithValue(token, "}")
		}

		/**
		 * Checks if the given token is a comment token or not.
		 * @param {Token} token - The token to check.
		 * @returns {boolean} `true` if the token is a comment token.
		 */
		function isCommentToken(token) {
		    return ["Block", "Line", "Shebang"].includes(token.type)
		}

		const isNotArrowToken = negate(isArrowToken);
		const isNotCommaToken = negate(isCommaToken);
		const isNotSemicolonToken = negate(isSemicolonToken);
		const isNotColonToken = negate(isColonToken);
		const isNotOpeningParenToken = negate(isOpeningParenToken);
		const isNotClosingParenToken = negate(isClosingParenToken);
		const isNotOpeningBracketToken = negate(isOpeningBracketToken);
		const isNotClosingBracketToken = negate(isClosingBracketToken);
		const isNotOpeningBraceToken = negate(isOpeningBraceToken);
		const isNotClosingBraceToken = negate(isClosingBraceToken);
		const isNotCommentToken = negate(isCommentToken);

		/**
		 * Get the `(` token of the given function node.
		 * @param {Node} node - The function node to get.
		 * @param {SourceCode} sourceCode - The source code object to get tokens.
		 * @returns {Token} `(` token.
		 */
		function getOpeningParenOfParams(node, sourceCode) {
		    return node.id
		        ? sourceCode.getTokenAfter(node.id, isOpeningParenToken)
		        : sourceCode.getFirstToken(node, isOpeningParenToken)
		}

		/**
		 * Get the location of the given function node for reporting.
		 * @param {Node} node - The function node to get.
		 * @param {SourceCode} sourceCode - The source code object to get tokens.
		 * @returns {string} The location of the function node for reporting.
		 */
		function getFunctionHeadLocation(node, sourceCode) {
		    const parent = node.parent;
		    let start = null;
		    let end = null;

		    if (node.type === "ArrowFunctionExpression") {
		        const arrowToken = sourceCode.getTokenBefore(node.body, isArrowToken);

		        start = arrowToken.loc.start;
		        end = arrowToken.loc.end;
		    } else if (
		        parent.type === "Property" ||
		        parent.type === "MethodDefinition" ||
		        parent.type === "PropertyDefinition"
		    ) {
		        start = parent.loc.start;
		        end = getOpeningParenOfParams(node, sourceCode).loc.start;
		    } else {
		        start = node.loc.start;
		        end = getOpeningParenOfParams(node, sourceCode).loc.start;
		    }

		    return {
		        start: { ...start },
		        end: { ...end },
		    }
		}

		/* globals globalThis, global, self, window */

		const globalObject =
		    typeof globalThis !== "undefined"
		        ? globalThis
		        : typeof self !== "undefined"
		        ? self
		        : typeof window !== "undefined"
		        ? window
		        : typeof global$1 !== "undefined"
		        ? global$1
		        : {};

		const builtinNames = Object.freeze(
		    new Set([
		        "Array",
		        "ArrayBuffer",
		        "BigInt",
		        "BigInt64Array",
		        "BigUint64Array",
		        "Boolean",
		        "DataView",
		        "Date",
		        "decodeURI",
		        "decodeURIComponent",
		        "encodeURI",
		        "encodeURIComponent",
		        "escape",
		        "Float32Array",
		        "Float64Array",
		        "Function",
		        "Infinity",
		        "Int16Array",
		        "Int32Array",
		        "Int8Array",
		        "isFinite",
		        "isNaN",
		        "isPrototypeOf",
		        "JSON",
		        "Map",
		        "Math",
		        "NaN",
		        "Number",
		        "Object",
		        "parseFloat",
		        "parseInt",
		        "Promise",
		        "Proxy",
		        "Reflect",
		        "RegExp",
		        "Set",
		        "String",
		        "Symbol",
		        "Uint16Array",
		        "Uint32Array",
		        "Uint8Array",
		        "Uint8ClampedArray",
		        "undefined",
		        "unescape",
		        "WeakMap",
		        "WeakSet",
		    ]),
		);
		const callAllowed = new Set(
		    [
		        Array.isArray,
		        typeof BigInt === "function" ? BigInt : undefined,
		        Boolean,
		        Date,
		        Date.parse,
		        decodeURI,
		        decodeURIComponent,
		        encodeURI,
		        encodeURIComponent,
		        escape,
		        isFinite,
		        isNaN,
		        isPrototypeOf,
		        ...Object.getOwnPropertyNames(Math)
		            .map((k) => Math[k])
		            .filter((f) => typeof f === "function"),
		        Number,
		        Number.isFinite,
		        Number.isNaN,
		        Number.parseFloat,
		        Number.parseInt,
		        Object,
		        Object.entries,
		        Object.is,
		        Object.isExtensible,
		        Object.isFrozen,
		        Object.isSealed,
		        Object.keys,
		        Object.values,
		        parseFloat,
		        parseInt,
		        RegExp,
		        String,
		        String.fromCharCode,
		        String.fromCodePoint,
		        String.raw,
		        Symbol.for,
		        Symbol.keyFor,
		        unescape,
		    ].filter((f) => typeof f === "function"),
		);
		const callPassThrough = new Set([
		    Object.freeze,
		    Object.preventExtensions,
		    Object.seal,
		]);

		/**
		 * Get the property descriptor.
		 * @param {object} object The object to get.
		 * @param {string|number|symbol} name The property name to get.
		 */
		function getPropertyDescriptor(object, name) {
		    let x = object;
		    while ((typeof x === "object" || typeof x === "function") && x !== null) {
		        const d = Object.getOwnPropertyDescriptor(x, name);
		        if (d) {
		            return d
		        }
		        x = Object.getPrototypeOf(x);
		    }
		    return null
		}

		/**
		 * Check if a property is getter or not.
		 * @param {object} object The object to check.
		 * @param {string|number|symbol} name The property name to check.
		 */
		function isGetter(object, name) {
		    const d = getPropertyDescriptor(object, name);
		    return d != null && d.get != null
		}

		/**
		 * Get the element values of a given node list.
		 * @param {Node[]} nodeList The node list to get values.
		 * @param {Scope|undefined} initialScope The initial scope to find variables.
		 * @returns {any[]|null} The value list if all nodes are constant. Otherwise, null.
		 */
		function getElementValues(nodeList, initialScope) {
		    const valueList = [];

		    for (let i = 0; i < nodeList.length; ++i) {
		        const elementNode = nodeList[i];

		        if (elementNode == null) {
		            valueList.length = i + 1;
		        } else if (elementNode.type === "SpreadElement") {
		            const argument = getStaticValueR(elementNode.argument, initialScope);
		            if (argument == null) {
		                return null
		            }
		            valueList.push(...argument.value);
		        } else {
		            const element = getStaticValueR(elementNode, initialScope);
		            if (element == null) {
		                return null
		            }
		            valueList.push(element.value);
		        }
		    }

		    return valueList
		}

		const operations = Object.freeze({
		    ArrayExpression(node, initialScope) {
		        const elements = getElementValues(node.elements, initialScope);
		        return elements != null ? { value: elements } : null
		    },

		    AssignmentExpression(node, initialScope) {
		        if (node.operator === "=") {
		            return getStaticValueR(node.right, initialScope)
		        }
		        return null
		    },

		    //eslint-disable-next-line complexity
		    BinaryExpression(node, initialScope) {
		        if (node.operator === "in" || node.operator === "instanceof") {
		            // Not supported.
		            return null
		        }

		        const left = getStaticValueR(node.left, initialScope);
		        const right = getStaticValueR(node.right, initialScope);
		        if (left != null && right != null) {
		            switch (node.operator) {
		                case "==":
		                    return { value: left.value == right.value } //eslint-disable-line eqeqeq
		                case "!=":
		                    return { value: left.value != right.value } //eslint-disable-line eqeqeq
		                case "===":
		                    return { value: left.value === right.value }
		                case "!==":
		                    return { value: left.value !== right.value }
		                case "<":
		                    return { value: left.value < right.value }
		                case "<=":
		                    return { value: left.value <= right.value }
		                case ">":
		                    return { value: left.value > right.value }
		                case ">=":
		                    return { value: left.value >= right.value }
		                case "<<":
		                    return { value: left.value << right.value }
		                case ">>":
		                    return { value: left.value >> right.value }
		                case ">>>":
		                    return { value: left.value >>> right.value }
		                case "+":
		                    return { value: left.value + right.value }
		                case "-":
		                    return { value: left.value - right.value }
		                case "*":
		                    return { value: left.value * right.value }
		                case "/":
		                    return { value: left.value / right.value }
		                case "%":
		                    return { value: left.value % right.value }
		                case "**":
		                    return { value: left.value ** right.value }
		                case "|":
		                    return { value: left.value | right.value }
		                case "^":
		                    return { value: left.value ^ right.value }
		                case "&":
		                    return { value: left.value & right.value }

		                // no default
		            }
		        }

		        return null
		    },

		    CallExpression(node, initialScope) {
		        const calleeNode = node.callee;
		        const args = getElementValues(node.arguments, initialScope);

		        if (args != null) {
		            if (calleeNode.type === "MemberExpression") {
		                if (calleeNode.property.type === "PrivateIdentifier") {
		                    return null
		                }
		                const object = getStaticValueR(calleeNode.object, initialScope);
		                if (object != null) {
		                    if (
		                        object.value == null &&
		                        (object.optional || node.optional)
		                    ) {
		                        return { value: undefined, optional: true }
		                    }
		                    const property = getStaticPropertyNameValue(
		                        calleeNode,
		                        initialScope,
		                    );

		                    if (property != null) {
		                        const receiver = object.value;
		                        const methodName = property.value;
		                        if (callAllowed.has(receiver[methodName])) {
		                            return { value: receiver[methodName](...args) }
		                        }
		                        if (callPassThrough.has(receiver[methodName])) {
		                            return { value: args[0] }
		                        }
		                    }
		                }
		            } else {
		                const callee = getStaticValueR(calleeNode, initialScope);
		                if (callee != null) {
		                    if (callee.value == null && node.optional) {
		                        return { value: undefined, optional: true }
		                    }
		                    const func = callee.value;
		                    if (callAllowed.has(func)) {
		                        return { value: func(...args) }
		                    }
		                    if (callPassThrough.has(func)) {
		                        return { value: args[0] }
		                    }
		                }
		            }
		        }

		        return null
		    },

		    ConditionalExpression(node, initialScope) {
		        const test = getStaticValueR(node.test, initialScope);
		        if (test != null) {
		            return test.value
		                ? getStaticValueR(node.consequent, initialScope)
		                : getStaticValueR(node.alternate, initialScope)
		        }
		        return null
		    },

		    ExpressionStatement(node, initialScope) {
		        return getStaticValueR(node.expression, initialScope)
		    },

		    Identifier(node, initialScope) {
		        if (initialScope != null) {
		            const variable = findVariable(initialScope, node);

		            // Built-in globals.
		            if (
		                variable != null &&
		                variable.defs.length === 0 &&
		                builtinNames.has(variable.name) &&
		                variable.name in globalObject
		            ) {
		                return { value: globalObject[variable.name] }
		            }

		            // Constants.
		            if (variable != null && variable.defs.length === 1) {
		                const def = variable.defs[0];
		                if (
		                    def.parent &&
		                    def.parent.kind === "const" &&
		                    // TODO(mysticatea): don't support destructuring here.
		                    def.node.id.type === "Identifier"
		                ) {
		                    return getStaticValueR(def.node.init, initialScope)
		                }
		            }
		        }
		        return null
		    },

		    Literal(node) {
		        //istanbul ignore if : this is implementation-specific behavior.
		        if ((node.regex != null || node.bigint != null) && node.value == null) {
		            // It was a RegExp/BigInt literal, but Node.js didn't support it.
		            return null
		        }
		        return { value: node.value }
		    },

		    LogicalExpression(node, initialScope) {
		        const left = getStaticValueR(node.left, initialScope);
		        if (left != null) {
		            if (
		                (node.operator === "||" && Boolean(left.value) === true) ||
		                (node.operator === "&&" && Boolean(left.value) === false) ||
		                (node.operator === "??" && left.value != null)
		            ) {
		                return left
		            }

		            const right = getStaticValueR(node.right, initialScope);
		            if (right != null) {
		                return right
		            }
		        }

		        return null
		    },

		    MemberExpression(node, initialScope) {
		        if (node.property.type === "PrivateIdentifier") {
		            return null
		        }
		        const object = getStaticValueR(node.object, initialScope);
		        if (object != null) {
		            if (object.value == null && (object.optional || node.optional)) {
		                return { value: undefined, optional: true }
		            }
		            const property = getStaticPropertyNameValue(node, initialScope);

		            if (property != null && !isGetter(object.value, property.value)) {
		                return { value: object.value[property.value] }
		            }
		        }
		        return null
		    },

		    ChainExpression(node, initialScope) {
		        const expression = getStaticValueR(node.expression, initialScope);
		        if (expression != null) {
		            return { value: expression.value }
		        }
		        return null
		    },

		    NewExpression(node, initialScope) {
		        const callee = getStaticValueR(node.callee, initialScope);
		        const args = getElementValues(node.arguments, initialScope);

		        if (callee != null && args != null) {
		            const Func = callee.value;
		            if (callAllowed.has(Func)) {
		                return { value: new Func(...args) }
		            }
		        }

		        return null
		    },

		    ObjectExpression(node, initialScope) {
		        const object = {};

		        for (const propertyNode of node.properties) {
		            if (propertyNode.type === "Property") {
		                if (propertyNode.kind !== "init") {
		                    return null
		                }
		                const key = getStaticPropertyNameValue(
		                    propertyNode,
		                    initialScope,
		                );
		                const value = getStaticValueR(propertyNode.value, initialScope);
		                if (key == null || value == null) {
		                    return null
		                }
		                object[key.value] = value.value;
		            } else if (
		                propertyNode.type === "SpreadElement" ||
		                propertyNode.type === "ExperimentalSpreadProperty"
		            ) {
		                const argument = getStaticValueR(
		                    propertyNode.argument,
		                    initialScope,
		                );
		                if (argument == null) {
		                    return null
		                }
		                Object.assign(object, argument.value);
		            } else {
		                return null
		            }
		        }

		        return { value: object }
		    },

		    SequenceExpression(node, initialScope) {
		        const last = node.expressions[node.expressions.length - 1];
		        return getStaticValueR(last, initialScope)
		    },

		    TaggedTemplateExpression(node, initialScope) {
		        const tag = getStaticValueR(node.tag, initialScope);
		        const expressions = getElementValues(
		            node.quasi.expressions,
		            initialScope,
		        );

		        if (tag != null && expressions != null) {
		            const func = tag.value;
		            const strings = node.quasi.quasis.map((q) => q.value.cooked);
		            strings.raw = node.quasi.quasis.map((q) => q.value.raw);

		            if (func === String.raw) {
		                return { value: func(strings, ...expressions) }
		            }
		        }

		        return null
		    },

		    TemplateLiteral(node, initialScope) {
		        const expressions = getElementValues(node.expressions, initialScope);
		        if (expressions != null) {
		            let value = node.quasis[0].value.cooked;
		            for (let i = 0; i < expressions.length; ++i) {
		                value += expressions[i];
		                value += node.quasis[i + 1].value.cooked;
		            }
		            return { value }
		        }
		        return null
		    },

		    UnaryExpression(node, initialScope) {
		        if (node.operator === "delete") {
		            // Not supported.
		            return null
		        }
		        if (node.operator === "void") {
		            return { value: undefined }
		        }

		        const arg = getStaticValueR(node.argument, initialScope);
		        if (arg != null) {
		            switch (node.operator) {
		                case "-":
		                    return { value: -arg.value }
		                case "+":
		                    return { value: +arg.value } //eslint-disable-line no-implicit-coercion
		                case "!":
		                    return { value: !arg.value }
		                case "~":
		                    return { value: ~arg.value }
		                case "typeof":
		                    return { value: typeof arg.value }

		                // no default
		            }
		        }

		        return null
		    },
		});

		/**
		 * Get the value of a given node if it's a static value.
		 * @param {Node} node The node to get.
		 * @param {Scope|undefined} initialScope The scope to start finding variable.
		 * @returns {{value:any}|{value:undefined,optional?:true}|null} The static value of the node, or `null`.
		 */
		function getStaticValueR(node, initialScope) {
		    if (node != null && Object.hasOwnProperty.call(operations, node.type)) {
		        return operations[node.type](node, initialScope)
		    }
		    return null
		}

		/**
		 * Get the static value of property name from a MemberExpression node or a Property node.
		 * @param {Node} node The node to get.
		 * @param {Scope} [initialScope] The scope to start finding variable. Optional. If the node is a computed property node and this scope was given, this checks the computed property name by the `getStringIfConstant` function with the scope, and returns the value of it.
		 * @returns {{value:any}|{value:undefined,optional?:true}|null} The static value of the property name of the node, or `null`.
		 */
		function getStaticPropertyNameValue(node, initialScope) {
		    const nameNode = node.type === "Property" ? node.key : node.property;

		    if (node.computed) {
		        return getStaticValueR(nameNode, initialScope)
		    }

		    if (nameNode.type === "Identifier") {
		        return { value: nameNode.name }
		    }

		    if (nameNode.type === "Literal") {
		        if (nameNode.bigint) {
		            return { value: nameNode.bigint }
		        }
		        return { value: String(nameNode.value) }
		    }

		    return null
		}

		/**
		 * Get the value of a given node if it's a static value.
		 * @param {Node} node The node to get.
		 * @param {Scope} [initialScope] The scope to start finding variable. Optional. If this scope was given, this tries to resolve identifier references which are in the given node as much as possible.
		 * @returns {{value:any}|{value:undefined,optional?:true}|null} The static value of the node, or `null`.
		 */
		function getStaticValue(node, initialScope = null) {
		    try {
		        return getStaticValueR(node, initialScope)
		    } catch (_error) {
		        return null
		    }
		}

		/**
		 * Get the value of a given node if it's a literal or a template literal.
		 * @param {Node} node The node to get.
		 * @param {Scope} [initialScope] The scope to start finding variable. Optional. If the node is an Identifier node and this scope was given, this checks the variable of the identifier, and returns the value of it if the variable is a constant.
		 * @returns {string|null} The value of the node, or `null`.
		 */
		function getStringIfConstant(node, initialScope = null) {
		    // Handle the literals that the platform doesn't support natively.
		    if (node && node.type === "Literal" && node.value === null) {
		        if (node.regex) {
		            return `/${node.regex.pattern}/${node.regex.flags}`
		        }
		        if (node.bigint) {
		            return node.bigint
		        }
		    }

		    const evaluated = getStaticValue(node, initialScope);
		    return evaluated && String(evaluated.value)
		}

		/**
		 * Get the property name from a MemberExpression node or a Property node.
		 * @param {Node} node The node to get.
		 * @param {Scope} [initialScope] The scope to start finding variable. Optional. If the node is a computed property node and this scope was given, this checks the computed property name by the `getStringIfConstant` function with the scope, and returns the value of it.
		 * @returns {string|null} The property name of the node.
		 */
		function getPropertyName(node, initialScope) {
		    switch (node.type) {
		        case "MemberExpression":
		            if (node.computed) {
		                return getStringIfConstant(node.property, initialScope)
		            }
		            if (node.property.type === "PrivateIdentifier") {
		                return null
		            }
		            return node.property.name

		        case "Property":
		        case "MethodDefinition":
		        case "PropertyDefinition":
		            if (node.computed) {
		                return getStringIfConstant(node.key, initialScope)
		            }
		            if (node.key.type === "Literal") {
		                return String(node.key.value)
		            }
		            if (node.key.type === "PrivateIdentifier") {
		                return null
		            }
		            return node.key.name

		        // no default
		    }

		    return null
		}

		/**
		 * Get the name and kind of the given function node.
		 * @param {ASTNode} node - The function node to get.
		 * @param {SourceCode} [sourceCode] The source code object to get the code of computed property keys.
		 * @returns {string} The name and kind of the function node.
		 */
		// eslint-disable-next-line complexity
		function getFunctionNameWithKind(node, sourceCode) {
		    const parent = node.parent;
		    const tokens = [];
		    const isObjectMethod = parent.type === "Property" && parent.value === node;
		    const isClassMethod =
		        parent.type === "MethodDefinition" && parent.value === node;
		    const isClassFieldMethod =
		        parent.type === "PropertyDefinition" && parent.value === node;

		    // Modifiers.
		    if (isClassMethod || isClassFieldMethod) {
		        if (parent.static) {
		            tokens.push("static");
		        }
		        if (parent.key.type === "PrivateIdentifier") {
		            tokens.push("private");
		        }
		    }
		    if (node.async) {
		        tokens.push("async");
		    }
		    if (node.generator) {
		        tokens.push("generator");
		    }

		    // Kinds.
		    if (isObjectMethod || isClassMethod) {
		        if (parent.kind === "constructor") {
		            return "constructor"
		        }
		        if (parent.kind === "get") {
		            tokens.push("getter");
		        } else if (parent.kind === "set") {
		            tokens.push("setter");
		        } else {
		            tokens.push("method");
		        }
		    } else if (isClassFieldMethod) {
		        tokens.push("method");
		    } else {
		        if (node.type === "ArrowFunctionExpression") {
		            tokens.push("arrow");
		        }
		        tokens.push("function");
		    }

		    // Names.
		    if (isObjectMethod || isClassMethod || isClassFieldMethod) {
		        if (parent.key.type === "PrivateIdentifier") {
		            tokens.push(`#${parent.key.name}`);
		        } else {
		            const name = getPropertyName(parent);
		            if (name) {
		                tokens.push(`'${name}'`);
		            } else if (sourceCode) {
		                const keyText = sourceCode.getText(parent.key);
		                if (!keyText.includes("\n")) {
		                    tokens.push(`[${keyText}]`);
		                }
		            }
		        }
		    } else if (node.id) {
		        tokens.push(`'${node.id.name}'`);
		    } else if (
		        parent.type === "VariableDeclarator" &&
		        parent.id &&
		        parent.id.type === "Identifier"
		    ) {
		        tokens.push(`'${parent.id.name}'`);
		    } else if (
		        (parent.type === "AssignmentExpression" ||
		            parent.type === "AssignmentPattern") &&
		        parent.left &&
		        parent.left.type === "Identifier"
		    ) {
		        tokens.push(`'${parent.left.name}'`);
		    } else if (
		        parent.type === "ExportDefaultDeclaration" &&
		        parent.declaration === node
		    ) {
		        tokens.push("'default'");
		    }

		    return tokens.join(" ")
		}

		const typeConversionBinaryOps = Object.freeze(
		    new Set([
		        "==",
		        "!=",
		        "<",
		        "<=",
		        ">",
		        ">=",
		        "<<",
		        ">>",
		        ">>>",
		        "+",
		        "-",
		        "*",
		        "/",
		        "%",
		        "|",
		        "^",
		        "&",
		        "in",
		    ]),
		);
		const typeConversionUnaryOps = Object.freeze(new Set(["-", "+", "!", "~"]));

		/**
		 * Check whether the given value is an ASTNode or not.
		 * @param {any} x The value to check.
		 * @returns {boolean} `true` if the value is an ASTNode.
		 */
		function isNode(x) {
		    return x !== null && typeof x === "object" && typeof x.type === "string"
		}

		const visitor = Object.freeze(
		    Object.assign(Object.create(null), {
		        $visit(node, options, visitorKeys) {
		            const { type } = node;

		            if (typeof this[type] === "function") {
		                return this[type](node, options, visitorKeys)
		            }

		            return this.$visitChildren(node, options, visitorKeys)
		        },

		        $visitChildren(node, options, visitorKeys) {
		            const { type } = node;

		            for (const key of visitorKeys[type] || eslintVisitorKeys.getKeys(node)) {
		                const value = node[key];

		                if (Array.isArray(value)) {
		                    for (const element of value) {
		                        if (
		                            isNode(element) &&
		                            this.$visit(element, options, visitorKeys)
		                        ) {
		                            return true
		                        }
		                    }
		                } else if (
		                    isNode(value) &&
		                    this.$visit(value, options, visitorKeys)
		                ) {
		                    return true
		                }
		            }

		            return false
		        },

		        ArrowFunctionExpression() {
		            return false
		        },
		        AssignmentExpression() {
		            return true
		        },
		        AwaitExpression() {
		            return true
		        },
		        BinaryExpression(node, options, visitorKeys) {
		            if (
		                options.considerImplicitTypeConversion &&
		                typeConversionBinaryOps.has(node.operator) &&
		                (node.left.type !== "Literal" || node.right.type !== "Literal")
		            ) {
		                return true
		            }
		            return this.$visitChildren(node, options, visitorKeys)
		        },
		        CallExpression() {
		            return true
		        },
		        FunctionExpression() {
		            return false
		        },
		        ImportExpression() {
		            return true
		        },
		        MemberExpression(node, options, visitorKeys) {
		            if (options.considerGetters) {
		                return true
		            }
		            if (
		                options.considerImplicitTypeConversion &&
		                node.computed &&
		                node.property.type !== "Literal"
		            ) {
		                return true
		            }
		            return this.$visitChildren(node, options, visitorKeys)
		        },
		        MethodDefinition(node, options, visitorKeys) {
		            if (
		                options.considerImplicitTypeConversion &&
		                node.computed &&
		                node.key.type !== "Literal"
		            ) {
		                return true
		            }
		            return this.$visitChildren(node, options, visitorKeys)
		        },
		        NewExpression() {
		            return true
		        },
		        Property(node, options, visitorKeys) {
		            if (
		                options.considerImplicitTypeConversion &&
		                node.computed &&
		                node.key.type !== "Literal"
		            ) {
		                return true
		            }
		            return this.$visitChildren(node, options, visitorKeys)
		        },
		        PropertyDefinition(node, options, visitorKeys) {
		            if (
		                options.considerImplicitTypeConversion &&
		                node.computed &&
		                node.key.type !== "Literal"
		            ) {
		                return true
		            }
		            return this.$visitChildren(node, options, visitorKeys)
		        },
		        UnaryExpression(node, options, visitorKeys) {
		            if (node.operator === "delete") {
		                return true
		            }
		            if (
		                options.considerImplicitTypeConversion &&
		                typeConversionUnaryOps.has(node.operator) &&
		                node.argument.type !== "Literal"
		            ) {
		                return true
		            }
		            return this.$visitChildren(node, options, visitorKeys)
		        },
		        UpdateExpression() {
		            return true
		        },
		        YieldExpression() {
		            return true
		        },
		    }),
		);

		/**
		 * Check whether a given node has any side effect or not.
		 * @param {Node} node The node to get.
		 * @param {SourceCode} sourceCode The source code object.
		 * @param {object} [options] The option object.
		 * @param {boolean} [options.considerGetters=false] If `true` then it considers member accesses as the node which has side effects.
		 * @param {boolean} [options.considerImplicitTypeConversion=false] If `true` then it considers implicit type conversion as the node which has side effects.
		 * @param {object} [options.visitorKeys=KEYS] The keys to traverse nodes. Use `context.getSourceCode().visitorKeys`.
		 * @returns {boolean} `true` if the node has a certain side effect.
		 */
		function hasSideEffect(
		    node,
		    sourceCode,
		    { considerGetters = false, considerImplicitTypeConversion = false } = {},
		) {
		    return visitor.$visit(
		        node,
		        { considerGetters, considerImplicitTypeConversion },
		        sourceCode.visitorKeys || eslintVisitorKeys.KEYS,
		    )
		}

		/**
		 * Get the left parenthesis of the parent node syntax if it exists.
		 * E.g., `if (a) {}` then the `(`.
		 * @param {Node} node The AST node to check.
		 * @param {SourceCode} sourceCode The source code object to get tokens.
		 * @returns {Token|null} The left parenthesis of the parent node syntax
		 */
		function getParentSyntaxParen(node, sourceCode) {
		    const parent = node.parent;

		    switch (parent.type) {
		        case "CallExpression":
		        case "NewExpression":
		            if (parent.arguments.length === 1 && parent.arguments[0] === node) {
		                return sourceCode.getTokenAfter(
		                    parent.callee,
		                    isOpeningParenToken,
		                )
		            }
		            return null

		        case "DoWhileStatement":
		            if (parent.test === node) {
		                return sourceCode.getTokenAfter(
		                    parent.body,
		                    isOpeningParenToken,
		                )
		            }
		            return null

		        case "IfStatement":
		        case "WhileStatement":
		            if (parent.test === node) {
		                return sourceCode.getFirstToken(parent, 1)
		            }
		            return null

		        case "ImportExpression":
		            if (parent.source === node) {
		                return sourceCode.getFirstToken(parent, 1)
		            }
		            return null

		        case "SwitchStatement":
		            if (parent.discriminant === node) {
		                return sourceCode.getFirstToken(parent, 1)
		            }
		            return null

		        case "WithStatement":
		            if (parent.object === node) {
		                return sourceCode.getFirstToken(parent, 1)
		            }
		            return null

		        default:
		            return null
		    }
		}

		/**
		 * Check whether a given node is parenthesized or not.
		 * @param {number} times The number of parantheses.
		 * @param {Node} node The AST node to check.
		 * @param {SourceCode} sourceCode The source code object to get tokens.
		 * @returns {boolean} `true` if the node is parenthesized the given times.
		 */
		/**
		 * Check whether a given node is parenthesized or not.
		 * @param {Node} node The AST node to check.
		 * @param {SourceCode} sourceCode The source code object to get tokens.
		 * @returns {boolean} `true` if the node is parenthesized.
		 */
		function isParenthesized(
		    timesOrNode,
		    nodeOrSourceCode,
		    optionalSourceCode,
		) {
		    let times, node, sourceCode, maybeLeftParen, maybeRightParen;
		    if (typeof timesOrNode === "number") {
		        times = timesOrNode | 0;
		        node = nodeOrSourceCode;
		        sourceCode = optionalSourceCode;
		        if (!(times >= 1)) {
		            throw new TypeError("'times' should be a positive integer.")
		        }
		    } else {
		        times = 1;
		        node = timesOrNode;
		        sourceCode = nodeOrSourceCode;
		    }

		    if (
		        node == null ||
		        // `Program` can't be parenthesized
		        node.parent == null ||
		        // `CatchClause.param` can't be parenthesized, example `try {} catch (error) {}`
		        (node.parent.type === "CatchClause" && node.parent.param === node)
		    ) {
		        return false
		    }

		    maybeLeftParen = maybeRightParen = node;
		    do {
		       