'use strict';

// Token Attacher and General Initialization

(async () => {
	const topLevelUrl = new URL(import.meta.url + '/../..');
	const moduleFetch = await fetch(topLevelUrl+ '/module.json');
	const moduleJSON = await moduleFetch.json();

	const moduleName = moduleJSON.name ?? moduleJSON.id;
	const moduleLabel = moduleJSON.title;

	// Scene Packer Initialization

		/**
		 * welcomeJournal (if set) will automatically be imported and opened after the first activation of a scene imported from the module compendium.
		 * Set to the following to disable:
		 *   const welcomeJournal = '';
		 */
		const welcomeJournal = '';
		/**
		 * additionalJournals will automatically be imported.
		 * Set to the following to disable:
		 *   const additionalJournals = [];
		 */
		const additionalJournals = [];
		/**
		 * additionalMacros will automatically be imported. Each name must match exactly and are case sensitive.
		 * Set to the following to disable:
		 *   const additionalMacros = [];
		 */
		const additionalMacros = [];
		/**
		 * creaturePacks is a list of compendium packs to look in for Actors by name (in prioritised order).
		 * The first entry here assumes that you have an Actor pack in your module with the "name" of "actors".
		 * Set to the following to disable:
		 *   const creaturePacks = [];
		 */
		const creaturePacks = [];
		/**
		 * journalPacks is a list of compendium packs to look in for Journals by name (in prioritised order).
		 * The first entry here assumes that you have a Journal pack in your module with the "name" of "journals".
		 * Set to the following to disable:
		 *   const journalPacks = [];
		 */
		const journalPacks = [];
		/**
		 * macroPacks is a list of compendium packs to look in for Macros by name (in prioritised order).
		 * The first entry here assumes that you have a Macro pack in your module with the "name" of "macros".
		 * Set to the following to disable:
		 *   const macroPacks = [];
		 */
		const macroPacks = [];
		/**
		 * playlistPacks is a list of compendium packs to look in for Playlists by name (in prioritised order).
		 * The first entry here assumes that you have a Playlist pack in your module with the "name" of "playlists".
		 * Set to the following to disable:
		 *   const playlistPacks = [];
		 */
	  const playlistPacks = [];
		/**
		 * additionalModulePacks is a list of modules whose compendium packs can be looked in for entities by name (in prioritised order).
		 * Enter just the "name" of the module/s you want to be considered.
		 * For example, if you wanted to allow the packs from
		 * the [Free Loot Tavern's Magic Item Vault]{@link https://foundryvtt.com/packages/free-loot-tavern-compendium}
		 * and [Dynamic Active Effects SRD]{@link https://foundryvtt.com/packages/Dynamic-Effects-SRD}
		 * modules to be searchable:
		 *   const playlistPacks = ['free-loot-tavern-compendium', 'Dynamic-Effects-SRD'];
		 * Set to the following to disable:
		 *   const additionalModulePacks = [];
		 */
	  const additionalModulePacks = ['dnd5e', 'baileywiki-nuts-and-bolts'];

	//Hook into Scene Packer

	  Hooks.once('scenePackerReady', ScenePacker => {
        // Initialise the Scene Packer with your adventure name and module name
        let packer = ScenePacker.Initialise({
          adventureName: moduleLabel,
          moduleName,
          creaturePacks,
          journalPacks,
          macroPacks,
          playlistPacks,
          welcomeJournal,
          additionalJournals,
          additionalMacros,
          allowImportPrompts: false, // Set to false if you don't want the popup
        });
    });

	//Hook into Moulinette
	Hooks.once("ready", async function () {
		if(game.moulinette) {
		game.moulinette.sources.push({ type: "tiles", publisher: "Baileywiki", pack: `${moduleLabel}`, source: "data", path: `modules/${moduleName}` })
		}
	}); 
})();