# BarBawl Profiles Module for Foundry VTT

**BarBawl Profiles** is a Foundry Virtual Tabletop (VTT) module designed to enhance the functionality of the BarBawl module. With this extension, users can create and manage profiles to quickly load and apply bar settings for tokens. These profiles streamline customization and can even be saved globally for consistent use across your game world.
Profiles can also be assigned when create a new actor.

---

## Requirements

- **Bar Brawl Module** 
- **FoundryVTT V12**
- **Token Mold Module(optional)** 

---

## Features

- **Quick Profile Application:** Instantly load pre-configured bar settings to any token with ease.
- **Global Profile Saving:** Save profiles globally for access and use across all tokens in your game world.
- **Efficient Workflow:** Eliminate repetitive adjustments by reusing your predefined profiles.
- **Token Mold Compatibility:** Seamlessly integrates with the Token Mold module to assign default profiles to new tokens automatically, simplifying token setup.

---

## How It Works

### 1. Creating a Profile
- Open the BarBawl interface on the token config.
- Customize the bar settings to your liking.
- Save these settings as a global profile by using the option on the “Save in...” button and clicking on the Save Profile option, making them available on all tokens.

### 2. Applying a Profile
- Open the BarBawl interface on the token config.
- Choose a global profile by using the option on the "Load from...” button and clicking on the Load Profile option to instantly apply the settings.

### 3. Token Mold Compatibility
- In the Token Mold interface, designate one of your saved profiles as the default profile.
- When a new token is created through Token Mold, the default profile is automatically overwritten to the token bar configuration.


---

## Installation

1. Open the **Add-on Modules** tab in your Foundry VTT setup.
2. Click on **Install Module** and search for **BarBawl Profiles**.
3. Click **Install** to add the module to your game.

Alternatively, you can install it directly using the following manifest URL:
```
https://github.com/joaquinpereyra98/barbrawl-profiles/releases/latest/download/module.json
```

---

## How to Use

1. Enable the **BarBawl Profiles** module in your game's module settings.
2. Access the profiles menu from the BarBawl configuration interface.
3. Create, apply, save, and manage profiles to customize your gameplay experience.

---

## Compatibility

- **Requires BarBawl Module** to function. Make sure you have BarBawl installed and enabled.
- Tested with FoundryVTT v12.

---

## Feedback and Support

We love hearing from our users! If you encounter issues or have suggestions, feel free to share them on our [GitHub Repository](https://github.com/joaquinpereyra98/barbrawl-profiles) or join send me mail to joaquinpereyra98@gmail.com

---

## License

This module is distributed under the [MIT License](https://github.com/joaquinpereyra98/barbrawl-profiles/blob/main/LICENSE).
