class DiceSystem{static SETTING_SCOPE={LOCAL:0,SHARED:1};static SETTING_TYPE={BOOLEAN:"boolean",SELECT:"select",COLOR:"color",FILE:"file",RANGE:"range",STRING:"string"};static SETTING_FORMATING={SEPARATOR:"separator",HTML:"html"};static DICE_EVENT_TYPE={SPAWN:0,CLICK:1,RESULT:2,COLLIDE:3,DESPAWN:4};static generateHash=e=>{let t,s,i=0;if(0===e.length)return i;for(t=0;t<e.length;t++)s=e.charCodeAt(t),i=(i<<5)-i+s,i|=0;return i};constructor(e,t,s="default",i=null){this._id=e,this._name=t,this._dice=new DiceMap(this),this._mode=s,this._group=i,this._settings=[],this._scopedSettings=new Map,this._listeners=[],this._registeredProcessMaterialCallbacks=[],this._registeredBeforeShaderCompileCallbacks=[]}get id(){return this._id}get name(){return this._name}get dice(){return this._dice}get mode(){return this._mode}get group(){return this._group}get settings(){const e=Object.values(DiceSystem.SETTING_TYPE);return this._settings.filter((t=>e.includes(t.type)))}on(e,t){if(!Object.values(DiceSystem.DICE_EVENT_TYPE).includes(e))throw new Error(`[DiceSystem.fire] Invalid dice event type: ${e}`);this._listeners[e]||(this._listeners[e]=[]),this._listeners[e].push(t)}off(e,t){if(!this._listeners[e])return;const s=this._listeners[e].indexOf(t);s>-1&&this._listeners[e].splice(s,1)}fire(e,t){if(!Object.values(DiceSystem.DICE_EVENT_TYPE).includes(e))throw new Error(`[DiceSystem.fire] Invalid dice event type: ${e}`);this._dispatchEvent(e,t)}_dispatchEvent(e,t){if(this._listeners[e])for(const s of this._listeners[e])s(t)}getSettingsByDiceType(e){return this._scopedSettings.get(e)||this._scopedSettings.get("global")}getCacheString(e){return this.id+JSON.stringify(Object.values(e))}processMaterial(e,t,s){if(this.dice.has(e)){for(const i of this._registeredProcessMaterialCallbacks)i(e,t,s);t.userData.diceType=e,t.userData.system=this.id,t.userData.appearance=s}return t}beforeShaderCompile(e,t){let s=e.fragmentShader,i=e.vertexShader;for(const s of this._registeredBeforeShaderCompileCallbacks)s(e,t,t.userData.diceType,t.userData.appearance);t.userData.shaderCacheKey=DiceSystem.generateHash(e.fragmentShader+e.vertexShader),s==e.fragmentShader&&i==e.vertexShader||(t.customProgramCacheKey=()=>t.userData.shaderCacheKey,t.needsUpdate=!0)}registerProcessMaterialCallback(e){this._registeredProcessMaterialCallbacks.push(e)}registerBeforeShaderCompileCallback(e){this._registeredBeforeShaderCompileCallbacks.push(e)}updateSettings(e="global",t){this._scopedSettings.set(e,{...t})}loadSettings(){this._scopedSettings=new Map;const e=game.user.getFlag("dice-so-nice","appearance"),t=this.settings.reduce(((e,{id:t,defaultValue:s})=>({...e,[t]:s})),{});if(this._scopedSettings.set("global",t),e)for(let t of Object.keys(e))e[t].system===this.id&&this._scopedSettings.set(t,{...e[t].systemSettings})}_createSetting(e,t,s,i,a,n={}){if(!Object.values(DiceSystem.SETTING_TYPE).includes(e)&&!Object.values(DiceSystem.SETTING_FORMATING).includes(e))throw new Error(`[DiceSystem._createSetting] Invalid setting type: ${e}`);if(!Object.values(DiceSystem.SETTING_SCOPE).includes(i)&&!Object.values(DiceSystem.SETTING_SCOPE).includes(i))throw new Error(`[DiceSystem._createSetting] Invalid setting scope: ${i}`);if(DiceSystem.SETTING_TYPE.hasOwnProperty(e)){if(!t)throw new Error(`[DiceSystem._createSetting] Invalid setting id: ${t}`);if(!s)throw new Error(`[DiceSystem._createSetting] Invalid setting name: ${s}`)}this._settings.push({type:e,id:t,name:s,defaultValue:a,scope:i,...n})}addSettingSeparator({name:e=""}={}){this._createSetting("separator",null,e,DiceSystem.SETTING_SCOPE.LOCAL,null)}addSettingHTML({name:e}){this._createSetting("html",null,e,DiceSystem.SETTING_SCOPE.LOCAL,null)}addSettingBoolean({id:e,name:t,scope:s=DiceSystem.SETTING_SCOPE.SHARED,defaultValue:i=!1}){this._createSetting("boolean",e,t,s,i)}addSettingColor({id:e,name:t,scope:s=DiceSystem.SETTING_SCOPE.SHARED,defaultValue:i="#ffffff"}){this._createSetting("color",e,t,s,i)}addSettingRange({id:e,name:t,scope:s=DiceSystem.SETTING_SCOPE.SHARED,defaultValue:i=0,min:a=0,max:n=100,step:l=1}){this._createSetting("range",e,t,s,i,{min:a,max:n,step:l})}addSettingFile({id:e,name:t,scope:s=DiceSystem.SETTING_SCOPE.SHARED,defaultValue:i=""}){i=i||"",this._createSetting("file",e,t,s,i)}addSettingSelect({id:e,name:t,scope:s=DiceSystem.SETTING_SCOPE.SHARED,defaultValue:i=null,options:a={}}){this._createSetting("select",e,t,s,i,{options:a})}addSettingString({id:e,name:t,scope:s=DiceSystem.SETTING_SCOPE.SHARED,defaultValue:i=""}){i=i||"",this._createSetting("string",e,t,s,i)}getDiceByShapeAndValues(e,t){for(let s of this.dice.values())if(s.shape==e&&s.values.length==t.length)return s;return null}getScopedSettingValue(e,t){return this._scopedSettings.get(e)?.[t]??this._scopedSettings.get("global")?.[t]}getSettingsDialogLine(e,t){let s={content:"",data:{}};switch(e.type){case DiceSystem.SETTING_TYPE.BOOLEAN:s.content=`\n                    <div class="form-group">\n                        <label>${e.name}</label>\n                        <div class="form-fields">\n                            <input type="checkbox" name="appearance[${t}][systemSettings][${e.id}]" data-dtype="Boolean" {{checked ${e.id}.value}} />\n                        </div>\n                    </div>\n                `,s.data={value:this.getScopedSettingValue(t,e.id)};break;case DiceSystem.SETTING_TYPE.STRING:s.content=`\n                    <div class="form-group">\n                        <label>${e.name}</label>\n                        <div class="form-fields">\n                            <input type="text" name="appearance[${t}][systemSettings][${e.id}]" value="{{${e.id}.value}}" data-dtype="String" />\n                        </div>\n                    </div>\n                `,s.data={value:this.getScopedSettingValue(t,e.id)};break;case DiceSystem.SETTING_TYPE.COLOR:s.content=`\n                    <div class="form-group">\n                        <label>${e.name}</label>\n                        <div class="form-fields">\n                            <input type="text" data-colorpicker name="appearance[${t}][systemSettings][${e.id}]" value="{{${e.id}.value}}" data-dtype="String" />\n                            <input type="color" name="appearance[${t}][systemSettings][${e.id}Selector]" value="{{${e.id}.value}}"\n                                data-edit="appearance[${t}][systemSettings][${e.id}]" data-${e.id}Selector />\n                        </div>\n                    </div>\n                `,s.data={value:this.getScopedSettingValue(t,e.id)};break;case DiceSystem.SETTING_TYPE.RANGE:s.content=`\n                    <div class="form-group">\n                        <label>${e.name}</label>\n                        <div class="form-fields">\n                            <input type="range" name="appearance[${t}][systemSettings][${e.id}]" value="{{${e.id}.value}}" min="{{${e.id}.min}}" max="{{${e.id}.max}}" step="{{${e.id}.step}}" data-dtype="Number">\n                            <span class="range-value">{{${e.id}.value}}</span>\n                        </div>\n                    </div>\n                `,s.data={value:this.getScopedSettingValue(t,e.id),min:e.min,max:e.max,step:e.step};break;case DiceSystem.SETTING_TYPE.FILE:s.content=`\n                    <div class="form-group">\n                        <label>${e.name}</label>\n                        <div class="form-fields">\n                            <input type="file" name="appearance[${t}][systemSettings][${e.id}]" value="{{${e.id}.value}}"\n                                data-edit="appearance[${t}][systemSettings][${e.id}]" data-${e.id} />\n                        </div>\n                    </div>\n                `,s.data={value:this.getScopedSettingValue(t,e.id)};break;case DiceSystem.SETTING_TYPE.SELECT:s.content=`\n                    <div class="form-group">\n                        <label>${e.name}</label>\n                        <div class="form-fields">\n                            <select name="appearance[${t}][systemSettings][${e.id}]" data-dtype="String">\n                                {{selectOptions ${e.id}.options selected=${e.id}.value}}\n                            </select>\n                        </div>\n                    </div>\n                `,s.data={value:this.getScopedSettingValue(t,e.id),options:e.options};break;case DiceSystem.SETTING_FORMATING.SEPARATOR:""!=e.name?s.content=`<h2>${e.name}</h2>`:s.content="<hr />";break;case DiceSystem.SETTING_FORMATING.HTML:s.content=e.name}return s}getSettingsDialogContent(e){let t={content:"",data:{}};if(!this._settings.length)return t;for(let s of this._settings){let i=this.getSettingsDialogLine(s,e);t.content+=i.content,t.data[s.id]=i.data}return t.content=`<div data-systemSettings="${this.id}">${t.content}</div>`,t}getDefaultSettings(){let e=this.settings,t={};for(let s of e)t[s.id]=s.defaultValue;return t}}class DiceMap extends Map{constructor(e,...t){super(...t),this._diceSystem=e}set(e,t){return this.has(e)||(t.diceSystem=this._diceSystem),super.set(e,t)}}class DiceSFX{static PLAY_ONLY_ONCE_PER_MESH=!1;get nameLocalized(){return game.i18n.localize(this._name)}constructor(e,t,s){this.options=foundry.utils.mergeObject({isGlobal:!1,muteSound:!1},s),this.dicemesh=t,this.box=e,this.destroyed=!1,this.enableGC=!1,this.renderReady=!1,this.volume=t.options.secretRoll&&e.muteSoundSecretRolls||this.options.muteSound?0:this.box.volume}static async init(){return!0}computeScale(){let e=this.box.dicefactory.baseScale/100;switch(this.dicemesh.shape){case"d2":case"d20":e*=1.3;break;case"d4":case"d8":e*=1.1;break;case"d6":case"d10":break;case"d12":e*=1.2}return e}async play(){return Promise.resolve()}static async loadAsset(e,t){return new Promise(((s,i)=>{e.load(t,(e=>s(e)),null,i)}))}static getDialogContent(e,t){let s={},i=game.user.isGM?"":'disabled="disabled"';return s.content=`<div class="form-group">\n                                    <label>{{localize "DICESONICE.sfxOptionsIsGlobal"}}</label>\n                                    <div class="form-fields">\n                                        <input type="checkbox" name="sfxLine[{{id}}][options][isGlobal]" data-dtype="Boolean" ${i} {{checked isGlobal}} />\n                                    </div>\n                                </div>\n                                <div class="form-group">\n                                    <label>{{localize "DICESONICE.sfxOptionsMuteSound"}}</label>\n                                    <div class="form-fields">\n                                        <input type="checkbox" name="sfxLine[{{id}}][options][muteSound]" data-dtype="Boolean" ${i} {{checked muteSound}} />\n                                    </div>\n                                </div>`,s.data={isGlobal:!!e.options&&e.options.isGlobal,muteSound:!!e.options&&e.options.muteSound,id:t},s}}export{DiceSFX,DiceSystem};
//# sourceMappingURL=api.js.map
