import { MODULE_ID } from "./main.js";

export function registerSettings() {
    const settings = {
        recentRolls: {
            scope: "world",
            config: false,
            type: Array,
            default: [],
        },
        defaultOptions: {
            scope: "world",
            config: false,
            type: Object,
            default: {
                showRollResults: true,
                color: 0,
                autoColor: true,
            },
        },
        recapMessage: {
            name: `${MODULE_ID}.settings.recapMessage.name`,
            hint: `${MODULE_ID}.settings.recapMessage.hint`,
            scope: "world",
            config: true,
            type: String,
            choices: {
                none: `${MODULE_ID}.settings.recapMessage.options.none`,
                gm: `${MODULE_ID}.settings.recapMessage.options.gm`,
                public: `${MODULE_ID}.settings.recapMessage.options.public`,
            },
            default: "gm",
        },
        cleanupMessages: {
            name: `${MODULE_ID}.settings.cleanupMessages.name`,
            hint: `${MODULE_ID}.settings.cleanupMessages.hint`,
            scope: "world",
            config: true,
            type: Boolean,
            default: false,
        },

        introSound: {
            name: `${MODULE_ID}.settings.introSound.name`,
            hint: `${MODULE_ID}.settings.introSound.hint`,
            scope: "world",
            config: true,
            type: String,
            default: "modules/epic-rolls-5e/assets/epic_battle_music_1-6275.ogg",
            filePicker: "audio",
        },
        successSound: {
            name: `${MODULE_ID}.settings.successSound.name`,
            hint: `${MODULE_ID}.settings.successSound.hint`,
            scope: "world",
            config: true,
            type: String,
            default: "sounds/drums.wav",
            filePicker: "audio",
        },
        failureSound: {
            name: `${MODULE_ID}.settings.failureSound.name`,
            hint: `${MODULE_ID}.settings.failureSound.hint`,
            scope: "world",
            config: true,
            type: String,
            default: "sounds/combat/epic-start-horn.ogg",
            filePicker: "audio",
        },
    };
    registerSettingsArray(settings);
}

export function getSetting(key) {
    return game.settings.get(MODULE_ID, key);
}

export async function setSetting(key, value) {
    return await game.settings.set(MODULE_ID, key, value);
}

function registerSettingsArray(settings) {
    for (const [key, value] of Object.entries(settings)) {
        game.settings.register(MODULE_ID, key, value);
    }
}
