Hooks.once("init", async function () {
  game.settings.register("foundry-taskbar", "taskbarColor", {
    name: "Taskbar Main Color",
    hint: "Color of the Taskbar",
    scope: "world",
    config: true,
    type: String,
    default: "#b7b7b71b",
    onChange: function (sett) {
      document.body.style.setProperty("--ft-background-color", sett);
    },
  });

  game.settings.register("foundry-taskbar", "taskbarSettings", {
    scope: "client",
    config: false,
    type: Object,
    default: {},
  });

  game.settings.register("foundry-taskbar", "enableplayers", {
    name: "Enable For Players",
    hint: "Enable the taskbar for players.",
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
    onChange: () => {
      new Taskbar();
    },
  });

  game.settings.register("foundry-taskbar", "moveplayersmacro", {
    name: "Move Players and Macro",
    hint: "Move players and macros up to not get covered by the taskbar. (requires refresh)",
    scope: "client",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("foundry-taskbar", "reduceSidebar", {
    name: "Reduce Sidebar",
    hint: "Reduce the size of the sidebar to have the taskbar always at full width. (requires refresh)",
    scope: "client",
    config: true,
    type: Boolean,
    default: false,
  });

  /*game.settings.register("foundry-taskbar", "dockPlayersList", {
    name: "Dock Players List",
    hint: "Docks player list in taskbar",
    scope: "client",
    config: true,
    type: Boolean,
    default: false,    
  });*/

  game.settings.register("foundry-taskbar", "dockMacroBar", {
    name: "Dock Macro Bar",
    hint: "Docks macro bar in taskbar",
    scope: "client",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("foundry-taskbar", "showOfflinePlayersInDockedMode", {
    name: "Show Offline Players",
    hint: "When Players is Docked, Show offline Players.",
    scope: "client",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("foundry-taskbar", "autodocksmalltime", {
    name: "Auto Dock SmallTime",
    hint: "Automatically Dock SmallTime on startup",
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
  });

  Hooks.on("getApplicationHeaderButtons", Taskbar.injectButtons);
  Hooks.on("renderApplicationV2", Taskbar.injectButtonsV2);
  Hooks.on("getItemSheetHeaderButtons", Taskbar.injectButtons);
  Hooks.on("getActorSheetHeaderButtons", Taskbar.injectButtons);
  Hooks.on("getSidebarTabHeaderButtons", Taskbar.injectButtons);
  Hooks.on("renderApplication", Taskbar.createTaskbarButton);
  Hooks.on("renderApplicationV2", Taskbar.createTaskbarButton);
  Hooks.on("renderItemSheet", Taskbar.createTaskbarButton);
  Hooks.on("renderActorSheet", Taskbar.createTaskbarButton);
  Hooks.on("renderSidebarTab", Taskbar.createTaskbarButton);
  Hooks.on("closeApplication", Taskbar.removeTaskbarButton);
  Hooks.on("closeApplicationV2", Taskbar.removeTaskbarButton);
  Hooks.on("closeItemSheet", Taskbar.removeTaskbarButton);
  Hooks.on("closeActorSheet", Taskbar.removeTaskbarButton);
  Hooks.on("closeSidebarTab", Taskbar.removeTaskbarButton);

  Hooks.on("renderSettingsConfig", (app, html, data) => {
    addColorPicker(html.querySelector(`[name="foundry-taskbar.taskbarColor"]`), {
      opacity: true,
    });
  });

  function addColorPicker(input, { value, opacity = false } = {}) {
    const hexToComponents = (hex) => {
      const hexColor = hex.length < 9 ? hex + "f".repeat(9 - hex.length) : hex;

      const colorValue = hexColor.slice(0, 7);
      const alphaValue = parseInt(hexColor.slice(7, 9), 16) / 255;
      return { color: colorValue, alpha: alphaValue };
    };

    const componentsToHex = (color, alpha) => {
      const colorValue = color.replace("#", "");
      const alphaValue = Math.round(alpha * 255)
        .toString(16)
        .padStart(2, "0");
      return `#${colorValue}${alphaValue}`;
    };

    const textInput =
      input.type === "text" ? input : input.querySelector("input[type='text']");
    if (textInput.classList.contains("color-picker-added")) return;

    textInput.classList.add("color-picker-added");
    textInput.classList.add("color");
    const parent = textInput.parentElement;

    value ??= textInput.value || "#000000ff";

    const { color, alpha } = hexToComponents(value);

    const colorPickerElement = document.createElement("input");
    colorPickerElement.setAttribute("type", "color");
    if (opacity) colorPickerElement.style.maxWidth = "2rem";

    const alphaPickerHtml = `<range-picker min="0" max="1" step="0.01" value="${alpha}" data-tooltip="Alpha" style="min-width: 6rem;"></range-picker>`;
    const alphaPickerElement = new DOMParser()
      .parseFromString(alphaPickerHtml, "text/html")
      .querySelector("range-picker");

    const updateTextInput = (color, alpha) => {
      const hex = componentsToHex(color, alpha);
      if (!opacity) textInput.value = hex.slice(0, 7);
      else textInput.value = hex;
      textInput.dispatchEvent(new Event("change"));
    };

    colorPickerElement.value = color;
    alphaPickerElement.value = alpha;

    colorPickerElement.addEventListener("input", (event) => {
      const color = event.target.value;
      const alpha = alphaPickerElement.value;
      updateTextInput(color, alpha);
    });

    alphaPickerElement.addEventListener("input", (event) => {
      const alpha = event.target.value;
      const color = colorPickerElement.value;
      updateTextInput(color, alpha);
    });

    textInput.after(colorPickerElement);
    opacity && colorPickerElement.after(alphaPickerElement);
  }
});

Hooks.once("ready", function () {
  if (
    game.settings.get("foundry-taskbar", "moveplayersmacro") &&
    (game.user.isGM || game.settings.get("foundry-taskbar", "enableplayers"))
  ) {
    const sheet = document.createElement("style");
    sheet.id = "ft-move-players-macro";
    sheet.innerHTML = `
        #ui-left {
            padding-bottom: calc( calc( 16px + var(--ft-height)) / var(--ui-scale));
        }
        
        #ui-bottom {
          margin-bottom: calc(var(--ft-height));
        }`;
    document.body.appendChild(sheet);
  }
  if (
    game.settings.get("foundry-taskbar", "reduceSidebar") &&
    (game.user.isGM || game.settings.get("foundry-taskbar", "enableplayers"))
  ) {
    const sheet = document.createElement("style");
    sheet.id = "ft-reducesidebar";
    sheet.innerHTML = `
        #ui-right{
          height: calc(calc(100% - var(--ft-height)) / var(--ui-scale));
      }`;
    document.body.appendChild(sheet);
    document.body.style.setProperty("--ft-sidebar", "0px");
  }

  ui.taskbar = new Taskbar();
});

//Module Handling

Hooks.once("renderSmallTimeApp", (app, html) => {
  setTimeout(() => {
    if (game.settings.get("foundry-taskbar", "autodocksmalltime")) {
      if (game.modules.get("smalltime")?.active)
        game.settings.set("smalltime", "pinned", false);

      $(".taskbar-tray").prepend(html.closest(".app"));
    }
  }, 1);
});
