import {l} from "./lib/utils.js";
import {MODULE_ID} from "./main.js";


export function initConfig() {

    Hooks.on("renderSceneConfig", (app, html, data) => {
        const target = html.querySelector(`.tab[data-tab="basics"]`);
        const checkbox = `
        <fieldset>
            <legend>Hexplorer</legend>
        <div class="form-group">
                <label for="flags.${MODULE_ID}.enabled">${l("hexplorer.scene.enable.name")}</label>
                <input type="checkbox" name="flags.${MODULE_ID}.enabled" ${app.document.flags[MODULE_ID]?.enabled ? "checked" : ""}>
        </div>
        </fieldset>
        `
        target.insertAdjacentHTML("beforeend", checkbox);
        app.setPosition({height: "auto"});
    });
}