import { initConfig } from "./config.js";
import { getSetting, registerSettings, setSetting } from "./settings.js";
import { l } from "./lib/utils.js";
import { enableHexplorer, disableHexplorer, toggleActive, onGetSceneControlButtons } from "./canvas/setup.js";
import { HexplorerApp } from "./app/HexplorerApp.js";
import { showBannerText } from "./app/BannerText.js";
import { Socket } from "./lib/socket.js";
import { GridUtils } from "./canvas/GridUtils.js";

export const MODULE_ID = "hexplorer";

Hooks.on("init", () => {
    initConfig();
    registerSettings();
});

Hooks.on("getSceneControlButtons", onGetSceneControlButtons);

Hooks.on("ready", () => {

    Socket.register("createMessageAsGM", async ({ message }) => {
        if(game.users.activeGM?.isSelf) {
            message.speaker.actor = fromUuidSync(message.speaker.actor);
            message.speaker.token = fromUuidSync(message.speaker.token);
            ChatMessage.create(message);
        }
    });

    Socket.register("showBannerText", ({ text, subtitle, duration }) => {
        showBannerText(text, { subtitle, duration });
    });

    Socket.register("createScrollingText", ({ origin, content, options }) => {
        canvas.interface.createScrollingText(origin, content, options);
    });

    if (game.user.isGM) {
        document.addEventListener("click", (event) => {
            const button = event.target.closest(".hexplorer-request-button");
            if (!button) return;
            const message = game.messages.get(button.closest(".message").dataset.messageId);
            const points = message.getFlag(MODULE_ID, "points");
            const destination = { x: button.dataset.destinationX, y: button.dataset.destinationY };
            destination.x = parseFloat(destination.x);
            destination.y = parseFloat(destination.y);
            const uuid = button.dataset.uuid;
            const tokenDocument = fromUuidSync(uuid);
            const scene = tokenDocument.parent;
            if (canvas.scene !== scene) return ui.notifications.warn(`${MODULE_ID}.request.not-in-scene`);
            //tokenDocument.update({x: destination.x, y: destination.y}, {hexplorerConfirmed: true, animation: {duration:6000}});
            GridUtils.executeSegmentedMovement(points, tokenDocument);
            //use regex to remove all button elements from message
            message.update({ content: message.content.replace(/<button.*?>.*?<\/button>/g, "") });
        });
    }
});

Hooks.on("updateScene", (scene, update) => {
    if (update.flags?.[MODULE_ID]?.enabled !== undefined && scene === canvas.scene) {
        toggleActive(scene);
    }
});

Hooks.on("canvasReady", () => {
    toggleActive(canvas.scene);
});
