import { getCellData } from "../app/HexplorerApp";
import { MODULE_ID } from "../main";
import { GridUtils } from "./GridUtils.js";

export class HexplorerHighlightLayer {
    constructor(scene) {
        this.scene = scene;
        this.init();
    }

    init() {
        this.overlay = new PIXI.Graphics();
        this.overlay.zIndex = 10;
        canvas.primary.addChild(this.overlay);
        this.overlay.visible = false;
    }

    draw() {
        if(!this.overlay.visible) return;
        const overlay = this.overlay;
        overlay.clear();
        const exploration = this.scene.getFlag(MODULE_ID, "exploration") ?? {};
        const rows = canvas.scene.dimensions.rows;
        const cols = canvas.scene.dimensions.columns;
        const cellShape = canvas.grid.getShape();
        for (let i = 0; i < rows; i++) {
            for (let j = 0; j < cols; j++) {
                const cellData = getCellData({ i, j });
                if (cellData.color === "#000000" || !cellData.color) continue;
                overlay.lineStyle(0, 0x000000, 0);
                overlay.beginFill(cellData.color, 0.5);
                const topLeft = canvas.grid.getCenterPoint({ i, j });
                const offsetShape = cellShape.map((p) => ({ x: p.x + topLeft.x, y: p.y + topLeft.y }));
                overlay.drawPolygon(offsetShape);
                overlay.endFill();
            }
        }
    }

    toggle(enabled) {
        if (!enabled) {
            this.overlay.visible = false;
            this.overlay.clear();
        } else {
            this.overlay.visible = true;
            this.draw();
        }
    }

    destroy() {
        this.overlay.removeFromParent();
        if(!this.overlay.destroyed) this.overlay.destroy(true);
    }
}
