import { MODULE_ID } from "../main.js";
import { Hexplorer } from "./Hexplorer.js";
import { HexplorerApp } from "../app/HexplorerApp.js";
import { getSetting, setSetting } from "../settings.js";
import { l } from "../lib/utils.js";

let enabled = false;


export function toggleActive(scene) {
    const hexplorerActive = scene.getFlag(MODULE_ID, "enabled");
    if(hexplorerActive && scene.grid.type === CONST.GRID_TYPES.GRIDLESS) ui.notifications.warn(l(`${MODULE_ID}.err.gridless`));
    if (hexplorerActive && scene.grid.type !== CONST.GRID_TYPES.GRIDLESS) {
        enableHexplorer(scene);
    } else {
        disableHexplorer(scene);
    }
}

export function enableHexplorer(scene) {
    if (enabled) disableHexplorer(scene);
    Hooks.on("renderSceneControls", onRenderSceneControls);
    Hooks.on("renderTokenConfig", onRenderTokenConfig);
    Hooks.on("renderPrototypeTokenConfig", onRenderTokenConfig);
    new Hexplorer(scene);
    ui.controls.render(true);
    enabled = true;
}

export function disableHexplorer(scene) {
    if (!enabled) return;
    canvas.hexplorer?.destroy();

    Hooks.off("renderSceneControls", onRenderSceneControls);
    Hooks.off("renderTokenConfig", onRenderTokenConfig);
    Hooks.off("renderPrototypeTokenConfig", onRenderTokenConfig);
    ui.controls.render(true);
    enabled = false;
}

function onRenderSceneControls(controls, b, c) {
    if (!game.user.isGM || !canvas.scene) return;
    const hexplorerActive = canvas.scene.getFlag(MODULE_ID, "enabled");
    if (!hexplorerActive) return;
    const mainControls = document.querySelector("#scene-controls-layers");
    if (!mainControls || mainControls.querySelector("button[data-control='hexplorer']")) return;
    const li = document.createElement("li");
    li.innerHTML = `<button type="button" class="control ui-control layer icon  fa-solid fa-compass" data-control="hexplorer" data-tooltip="Hexplorer"></button>`;
    li.querySelector("button").addEventListener("click", async (e) => {
        new HexplorerApp(canvas.scene).render(true);
    });
    mainControls.appendChild(li);
}

/**
 * 
    document.querySelector("#scene-controls-layers").insertAdjacentHTML(
      "beforeend",
      `<li>
                <button type="button" class="control ui-control layer icon  fa-solid fa-layer-group" role="tab" data-action="levels" data-control="levels" data-tooltip="${game.i18n.localize(
                  "levels.controls.main.name"
                )}" aria-controls="scene-controls-tools"></button>
                </li>`
    );
 */

export function onGetSceneControlButtons(controls, b, c) {
    if (!canvas.scene) return;
    const hexplorerActive = canvas.scene.getFlag(MODULE_ID, "enabled");
    if (!hexplorerActive) return;
    if (game.user.isGM || canvas.scene.getFlag(MODULE_ID, "config")?.showColor) {
        console.log(controls.tokens.tools)
        controls.tokens.tools.hexplorerShowColor= {
            active: getSetting("showColor"),
            icon: "fas fa-compass",
            name: "hexplorerShowColor",
            title: `${MODULE_ID}.fog.showColor`,
            onChange: (event, toggle) => {
                setSetting("showColor", toggle);
            },
            toggle: true,
        };
    }
}

function onRenderTokenConfig(app, html, data) {
    const sceneEnabled = app.document?.parent?.getFlag(MODULE_ID, "enabled") ?? game.scenes.viewed?.getFlag(MODULE_ID, "enabled");
    if (!sceneEnabled) return;
    const target = html.querySelector(`.tab[data-tab="identity"]`);
    const document = app.token ?? app.document;
    const checkbox = `
    <fieldset>
        <legend>Hexplorer</legend>
    <div class="form-group">
            <label for="flags.${MODULE_ID}.enabled">${l("hexplorer.token.enable.name")}</label>
            <input type="checkbox" name="flags.${MODULE_ID}.enabled" ${document.flags[MODULE_ID]?.enabled ? "checked" : ""}>
    </div>
    <div class="form-group">
        <label for="flags.${MODULE_ID}.revealRadius">${l("hexplorer.token.revealRadius.name")}</label>
        <input type="number" step="0.01" name="flags.${MODULE_ID}.revealRadius" value="${document.flags[MODULE_ID]?.revealRadius ?? 0}">
        <p class="hint">${l("hexplorer.token.revealRadius.hint")}</p>
    </div>
    <div class="form-group">
        <label for="flags.${MODULE_ID}.speed">${l("hexplorer.token.speed.name")}<span class="units"> (${game.scenes?.viewed?.grid?.units}/h)</span></label>
        
        <input type="number" step="0.01" name="flags.${MODULE_ID}.speed" value="${document.flags[MODULE_ID]?.speed ?? 0}">
        <p class="hint">${l("hexplorer.token.speed.hint")}</p>
    </div>
    </fieldset>
    `;
    target.insertAdjacentHTML("beforeend", checkbox);
    app.setPosition({ height: "auto" });
}
