import { DistanceTooltip } from "./module.js";
import { moveToToken } from "./moveTo.js";

export function registerSettings() {
    Hooks.once("init", async function () {
        libWrapper.register("hover-distance", "Token.prototype.draw", DistanceTooltip.tokenDraw, "WRAPPER");
        Token.prototype.drawDistanceTooltip = DistanceTooltip.draw;
        Token.prototype.clearDistanceTooltip = DistanceTooltip.clear;

        game.settings.register("hover-distance", "enableDistTooltip", {
            name: "Enable Hover Distance",
            hint: "If enabled, when overing over a token, show text indicating the distance to that token",
            scope: "client",
            config: true,
            type: Boolean,
            default: true,
        });

        game.settings.register("hover-distance", "tooltipPosition", {
            name: "Distance Tooltip Position",
            hint: "Where to show the distance tooltip",
            scope: "world",
            config: true,
            type: String,
            default: "center",
            choices: {
                top: "Top",
                bottom: "Bottom",
                center: "Center",
            },
        });

        game.settings.register("hover-distance", "verticalDistance", {
            name: "Vertical Distance",
            hint: "What behavior to use when a vertical distance is present between tokens. Note that 'Use Core Ruler Measurement' is the only option that guarantees hover distance is faithful to core ruler measurements, settings and rules.",
            scope: "world",
            config: true,
            type: String,
            default: "useCoreRuler",
            choices: {
                useCoreRuler: "Use Core Ruler Measurement",
                euclidean: "Euclidean",
                useHighest: "Use Highest",
                ignore: "Ignore",
            },
        });

        game.settings.register("hover-distance", "highlightGrid", {
            name: "Highlight Token",
            hint: "Highlight the token when overing over it",
            scope: "client",
            config: true,
            type: Boolean,
            default: true,
        });

        game.settings.register("hover-distance", "onlyInCombat", {
            name: "Highlight Only in Combat",
            hint: "Highlight only when a combat is started",
            scope: "world",
            config: true,
            type: Boolean,
            default: false,
        });

        game.settings.register("hover-distance", "roundMeasurement", {
            name: "Round Measurements",
            hint: "Round measurements to the closest multiple of this number. 0 to cut decimals",
            scope: "world",
            config: true,
            type: Number,
            default: 0,
        });

        game.settings.register("hover-distance", "rangeBands", {
            name: "Range Bands",
            hint: "Define range bands to use instead of the measurement. eg: 0,Short Range,60,Medium Range,120,Long Range",
            scope: "world",
            config: true,
            type: String,
            default: "",
        });

        game.settings.register("hover-distance", "rangeBandsNumbers", {
            name: "Show Measurement in Range Bands",
            hint: "When using range bands, show the measurement in addition to the range band name",
            scope: "world",
            config: true,
            type: Boolean,
            default: true,
        });

        game.keybindings.register("hover-distance", "moveTo", {
            name: "Move to Hovered Location",
            editable: [{ key: "KeyM" }],
            restricted: false,
            precedence: CONST.KEYBINDING_PRECEDENCE.PRIORITY,
            onDown: async () => {
                const hovered = canvas.tokens.hover;
                let position;
                if (game?.Levels3DPreview?._active) {
                    const pos3d = game.Levels3DPreview.interactionManager.canvas2dMousePosition;
                    position = { x: pos3d.x, y: pos3d.y, elevation: pos3d.z };
                } else {
                    position = canvas.app.renderer.events.pointer.getLocalPosition(canvas.app.stage);
                }
                const [x, y] = canvas.grid.getTopLeft(position.x, position.y);
                position.x = x;
                position.y = y;
                for (const token of canvas.tokens.controlled) {
                    await moveToToken(position, hovered, token);
                }
            },
        });
    });
}
