const quality = 4;

export function createFilter(sprite, strength, blurMulti){
    if(!strength) return;
    strength = strength/blurMulti;
    const hasFilter = sprite?.filters && sprite?.filters.find(f => f.name === "lle-blur");
    if(hasFilter || !sprite) return;

    const filter = new PIXI.filters.BlurFilter(strength, quality);
    filter.name = "lle-blur";
    
    if(!sprite.filters){
        sprite.filters = [filter];
    }else{
        sprite.filters.push(filter);
    }
}

export function removeFilter(sprite){
    if(!sprite) return;

    if(sprite.filters){
        sprite.filters = sprite.filters.filter(f => f.name !== "lle-blur");
    }
}

export function isBelow(object, token){
    const elevation = object?.elevation ?? object.document?.elevation;
    const height = token.document.elevation;
    if(height < elevation) return false;
    return height - elevation;
}

export function clearAll(){
    canvas.tokens.placeables.forEach(t => removeFilter(t.mesh));
    canvas.tiles.placeables.forEach(t => removeFilter(t.mesh));
    removeFilter(canvas.primary.background);
}