import {createFilter, removeFilter, isBelow, clearAll} from "./module.js";


Hooks.on("refreshToken", (token)=>{
    if(token.controlled) computeFiltersDebounced(token)
})

Hooks.on("controlToken", (token, controlled) => {
    if(controlled) {
        computeFilters(token);
        return;
    }
    setTimeout(() => {
        if(!canvas.tokens.controlled.length) clearAll();
    }, 100);
})


function computeFilters(ctoken){
    if(!ctoken || !canvas.scene.getFlag("levels-layer-effects", "enableEffects") || game.settings.get("levels-layer-effects", "disableBlur")) return;
    const blurMulti = canvas.scene.getFlag("levels-layer-effects", "blurMulti") || 10;
    for(let tile of canvas.tiles.placeables){
        removeFilter(tile.mesh);
        createFilter(tile.mesh, isBelow(tile, ctoken), blurMulti);
    }
    for(let token of canvas.tokens.placeables){
        removeFilter(token.mesh);
        createFilter(token.mesh, isBelow(token, ctoken), blurMulti);
    }
    const bg = canvas.primary.background
    removeFilter(bg);
    createFilter(bg, isBelow(bg, ctoken), blurMulti);

}

const computeFiltersDebounced = foundry.utils.debounce(computeFilters, 300)
