Hooks.on("init",()=>{

  game.settings.register("levelsautocover", "apiMode", {
    name: game.i18n.localize("levelsautocover.settings.apiMode.name"),
    hint: game.i18n.localize("levelsautocover.settings.apiMode.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
    requiresReload: true
  });

  game.settings.register("levelsautocover", "coverMessageAPI", {
    name: game.i18n.localize("levelsautocover.settings.coverMessageAPI.name"),
    hint: game.i18n.localize("levelsautocover.settings.coverMessageAPI.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
    requiresReload: true
  });

  game.settings.register("levelsautocover", "onlyOwnedNames", {
    name: game.i18n.localize("levelsautocover.settings.onlyOwnedNames.name"),
    hint: game.i18n.localize("levelsautocover.settings.onlyOwnedNames.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
    requiresReload: true
  });

  game.settings.register("levelsautocover", "coverRestriction", {
    name: game.i18n.localize("levelsautocover.settings.coverRestriction.text"),
    hint: game.i18n.localize("levelsautocover.settings.coverRestriction.hint"),
    scope: "world",
    config: true,
    type: Number,
    range: {
      min: 2,
      max: 20,
      step: 1,
    },
    default: 4,
  });

  game.settings.register("levelsautocover", "displayChat", {
    name: game.i18n.localize("levels.settings.displayChat.name"),
    hint: game.i18n.localize("levels.settings.displayChat.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
  });

  /*game.settings.register("levelsautocover", "displayToken", {
    name: game.i18n.localize("levels.settings.displayToken.name"),
    hint: game.i18n.localize("levels.settings.displayToken.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
  });*/

  game.settings.register("levelsautocover", "tokensProvideCover", {
    name: game.i18n.localize("levels.settings.tokensProvideCover.name"),
    hint: game.i18n.localize("levels.settings.tokensProvideCover.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
  });

  game.settings.register("levelsautocover", "tokenCoverAA", {
    name: game.i18n.localize("levels.settings.tokenCoverAA.name"),
    hint: game.i18n.localize("levels.settings.tokenCoverAA.hint"),
    scope: "world",
    config: true,
    type: String,
    default: "Half Cover",
  });

  game.settings.register("levelsautocover", "copsesProvideCover", {
    name: game.i18n.localize("levels.settings.copsesProvideCover.name"),
    hint: game.i18n.localize("levels.settings.copsesProvideCover.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("levelsautocover", "ignoreFriendly", {
    name: game.i18n.localize("levels.settings.ignoreFriendly.name"),
    hint: game.i18n.localize("levels.settings.ignoreFriendly.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("levelsautocover", "tokenhppath", {
    name: game.i18n.localize("levels.settings.tokenhppath.name"),
    hint: game.i18n.localize("levels.settings.tokenhppath.hint"),
    scope: "world",
    config: true,
    type: String,
    default: "actor.system.attributes.hp.value",
  });

  game.settings.register("levelsautocover", "tokenCoverText", {
    name: game.i18n.localize("levels.settings.tokenCoverText.name"),
    hint: game.i18n.localize("levels.settings.tokenCoverText.hint"),
    scope: "world",
    config: true,
    type: String,
    default: "Obstructed",
  });

  game.settings.register("levelsautocover", "enableActiveEffect", {
    name: game.i18n.localize("levels.settings.enableActiveEffect.name"),
    hint: game.i18n.localize("levels.settings.enableActiveEffect.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("levelsautocover", "activeEffectDefinition", {
    name: game.i18n.localize("levels.settings.activeEffectDefinition.name"),
    hint: game.i18n.localize("levels.settings.activeEffectDefinition.hint"),
    scope: "world",
    config: true,
    type: String,
    default: "25,Three Quarters Cover|50,Half Cover",
  });

  /*game.settings.register("levelsautocover", "textSize", {
    name: game.i18n.localize("levels.settings.textSize.name"),
    hint: game.i18n.localize("levels.settings.textSize.hint"),
    scope: "world",
    config: true,
    type: Number,
    default: 0,
  });*/

  game.settings.register("levelsautocover", "enableDucking", {
    name: game.i18n.localize("levels.settings.enableDucking.name"),
    hint: game.i18n.localize("levels.settings.enableDucking.hint"),
    scope: "world",
    config: true,
    type: Boolean,
    default: false,
  });

  game.settings.register("levelsautocover", "duckingIcon", {
    name: game.i18n.localize("levels.settings.duckingIcon.name"),
    hint: game.i18n.localize("levels.settings.duckingIcon.hint"),
    scope: "world",
    config: true,
    type: String,
    default: "modules/levelsautocover/icons/ducking.png",
    filePicker: true
  });

})

Hooks.on("ready", () => {
  if(game.settings.get("levelsautocover", "apiMode")) return;

  Hooks.on("targetToken",async (user,token,targeted)=>{
    if(game.combat?.current?.tokenId != _token?.id || !game.combat?.started) return; 
    if(targeted && canvas.tokens.controlled[0] && user.id == game.user.id && Array.from(game.user.targets).length == 1){
      AutoCover.computeCover(token);
    }else{
      //AutoCover.clearCover(token)
      if(canvas.tokens.controlled[0]) AutoCover.clearActiveEffects(canvas.tokens.controlled[0])
      if(CONFIG.Levels?.API?.DEBUG) canvas.controls.debug.clear()
    
    }
    })
    
    Hooks.on("updateToken", (token,updates)=>{
      if(game.combat?.current?.tokenId != _token?.id) return; 
      if(_token?.actor?.hasPlayerOwner && game.user.isGM) return;
      const targets = Array.from(game.user.targets)
      if(!("x" in updates || "y" in updates) || !game.combat?.started || targets.length != 1) return;
      const target = targets[0]
      AutoCover.computeCover(target);
    })
    
  Hooks.on("renderChatMessageHTML", (message, html, data) => {
      if(message.flags?.levelsautocover?.isCoverMessage){
        if(game.users.find(u => u.isGM)?.id == game.user?.id){
          const oldMessages = game.messages.filter(m => m.flags?.levelsautocover?.isCoverMessage).map(m => m.id)
          oldMessages.pop();
          AutoCover.deleteChatMessages(oldMessages);
          }
      }
    })
    
    Hooks.on("updateCombat", ()=>{
      AutoCover.clearAllEffects()
      if(game.combat?.current?.tokenId != _token?.id || game.user.isGM) return; 
      const targets = Array.from(game.user.targets)
      if(!game.combat?.started || targets.length != 1) return;
      const target = targets[0]
      AutoCover.computeCover(target);
    })
    
    Hooks.on("deleteCombat", () => {
      if(game.users.find(u => u.isGM)?.id == game.user?.id){
        const oldMessages = game.messages.filter(m => m.flags?.levelsautocover?.isCoverMessage).map(m => m.id)
        ChatMessage.deleteDocuments(oldMessages);
        }
    })
});

Hooks.on("ready", () => {
  if (game.settings.get("levelsautocover", "apiMode") && game.settings.get("levelsautocover", "coverMessageAPI")) {
    Hooks.on("targetToken", (user, token, targeted) => {
      if (!targeted || !_token || user !== game.user) return;
      AutoCover.manualCoverCheck();
    })
  }


  if (!game.user.isGM || game.system.id != "dnd5e") return;
  const coverItem = game.items.getName("LevelsAutoCoverDnD5e");
  if (coverItem) return;
  const coverItemData = {
    "name": "LevelsAutoCoverDnD5e",
    "type": "feat",
    "img": "icons/skills/targeting/crosshair-pointed-orange.webp",
    "effects": [
      {
        "_id": "SoVPhTnWUj0Gf1TL",
        "changes": [
          {
            "key": "system.bonuses.All-Attacks",
            "mode": 0,
            "value": "-2",
            "priority": null
          }
        ],
        "disabled": false,
        "duration": {
          "startTime": null,
          "rounds": 1,
          "seconds": null,
          "combat": null,
          "turns": null,
          "startRound": null,
          "startTurn": null
        },
        "icon": "icons/equipment/shield/heater-steel-worn.webp",
        "origin": "Item.gysy00ECjOVRGRJh",
        "transfer": true,
        "flags": {
          "dae": {
            "stackable": false,
            "macroRepeat": "none",
            "specialDuration": [],
            "transfer": true
          }
        },
        "tint": "#f3b91b",
        "name": "Half Cover",
        "description": "",
        "statuses": []
      },
      {
        "_id": "7zt45ap0ih8dXIsu",
        "changes": [
          {
            "key": "system.bonuses.All-Attacks",
            "mode": 0,
            "value": "-5",
            "priority": null
          }
        ],
        "disabled": false,
        "duration": {
          "startTime": null,
          "rounds": 1,
          "seconds": null,
          "combat": null,
          "turns": null,
          "startRound": null,
          "startTurn": null
        },
        "icon": "icons/equipment/shield/heater-steel-worn.webp",
        "origin": "Item.gysy00ECjOVRGRJh",
        "transfer": true,
        "flags": {
          "dae": {
            "stackable": false,
            "macroRepeat": "none",
            "specialDuration": [],
            "transfer": true
          }
        },
        "tint": "#ea3e3e",
        "name": "Three Quarters Cover",
        "description": "",
        "statuses": []
      }
    ],
    "flags": {
      "core": {},
      "exportSource": {
        "world": "v11-testing",
        "system": "dnd5e",
        "coreVersion": "11.315",
        "systemVersion": "2.4.0"
      }
    },
    "system": {
      "description": {
        "value": "<p>Corresponding text for the Cover Definition setting</p>\n<p> </p>\n<p>25,Three Quarters Cover|50,Half Cover</p>",
        "chat": "",
        "unidentified": ""
      },
      "source": {
        "custom": ""
      },
      "activation": {
        "type": "",
        "cost": 0,
        "condition": ""
      },
      "duration": {
        "value": "",
        "units": ""
      },
      "cover": null,
      "crewed": false,
      "target": {
        "value": null,
        "width": null,
        "units": "",
        "type": "",
        "prompt": true
      },
      "range": {
        "value": null,
        "long": null,
        "units": ""
      },
      "uses": {
        "value": 0,
        "max": "",
        "per": null,
        "recovery": "",
        "prompt": true
      },
      "consume": {
        "type": "",
        "target": null,
        "amount": null,
        "scale": false
      },
      "ability": null,
      "actionType": "",
      "attackBonus": "",
      "chatFlavor": "",
      "critical": {
        "threshold": null,
        "damage": ""
      },
      "damage": {
        "parts": [],
        "versatile": ""
      },
      "formula": "",
      "save": {
        "ability": "",
        "dc": null,
        "scaling": "spell"
      },
      "type": {
        "value": "",
        "subtype": ""
      },
      "requirements": "",
      "recharge": {
        "value": null,
        "charged": false
      }
    },
    "_stats": {
      "systemId": "dnd5e",
      "systemVersion": "2.4.0",
      "coreVersion": "11.315",
      "createdTime": 1662981790237,
      "modifiedTime": 1701622801887,
      "lastModifiedBy": "URgs0MORGSiJAyV8"
    },
    "folder": null
  }
  Item.create(coverItemData);
  ui.notifications.info("levelsautocover.coverItemCreated", { localize: true });
});