Hooks.on("renderTokenHUD", (data, hud, drawData) => {

  if (!game.settings.get("levelsautocover", "enableDucking")) return;
  const duckingIcon = game.settings.get("levelsautocover", "duckingIcon");

  let token = data.object.document;
  let active = token.getFlag("levelsautocover", "ducking") || false;
  let toggleDuckbtn = `<div class="control-icon${
    active ? " active" : ""
  }" id="toggleDuck">
              <img src="${duckingIcon}" width="36" height="36" title='${game.i18n.localize(
                "levels.ui.duck"
              )}'></i>
                              </div>`;
  const controlIcons = hud.querySelectorAll(".control-icon");
  controlIcons[controlIcons.length - 1].insertAdjacentHTML("afterend", toggleDuckbtn);

  const toggleDuckElement = hud.querySelector(`div[id="toggleDuck"]`);
  toggleDuckElement.addEventListener("click", toggDuck);

  async function toggDuck() {
    active = !active;
    await token.setFlag(
      "levelsautocover",
      "ducking",
      !(token.getFlag("levelsautocover", "ducking") || false)
    );
    if (active) toggleDuckElement.classList.add("active");
    else toggleDuckElement.classList.remove("active");
    await token.update({ overlayEffect: active ? duckingIcon : "" });
    canvas.tokens.get(data.object.id).initializeSources();
    // canvas.sight.refresh();
  }
});

