# PF2E Visioner Scripts

This directory contains the modular JavaScript files for the PF2E Visioner module.

## File Structure

### Core Files

- **`main.js`** - Main module entry point and initialization
- **`constants.js`** - Module constants and configuration
- **`utils.js`** - Utility functions for visibility calculations
- **`settings.js`** - Module settings registration and management

### Feature Modules

- **`off-guard-ephemeral.js`** - Off-guard condition automation using individual ephemeral effects
- **`targeting.js`** - Token targeting event handling
- **`visual-effects.js`** - Token visual effects and appearance management
<!-- effects-coordinator.js removed in refactor; visuals handled by visual-effects.js -->

### Integration Modules

- **`detection-wrapper.js`** - PF2E detection system integration
- **`visibility-manager.js`** - Visibility management UI and controls
- **`hover-tooltips.js`** - Interactive visibility tooltips with hover and Alt/O key support
- **`hooks.js`** - FoundryVTT hook registrations
- **`api.js`** - Public API for other modules

## Module Architecture

The module follows a modular architecture where each file has a specific responsibility:

1. **Separation of Concerns**: Visual effects, mechanical effects, and UI are separated
2. **Clean Dependencies**: Each module imports only what it needs
3. **Backwards Compatibility**: Legacy functions are preserved for compatibility
4. **Extensibility**: New features can be added as separate modules

## Key Features

- **Off-Guard Automation**: Automatically applies off-guard conditions when attackers are hidden/undetected
- **Interactive Tooltips**: Real-time visibility tooltips with hover and keyboard shortcuts (Alt/O keys)
- **Visual Indicators**: Provides visual feedback for token visibility states
- **PF2E Integration**: Deep integration with the PF2E system's detection mechanics
- **Performance Optimized**: Minimal overhead with efficient visibility calculations

### Tooltip System Details

The `hover-tooltips.js` module provides:

- **Hover Detection**: Token pointerover/pointerout event handling
- **Mode Switching**: O key toggles between observer and target perspectives
- **Alt Key Integration**: Uses FoundryVTT's highlightObjects hook for controlled token tooltips
- **Dynamic Indicators**: Real-time visibility state labels with proper positioning
- **Clean State Management**: Prevents mode conflicts and ensures proper cleanup
