import fs from "fs";
import path from "path";
import View from "./dist/server/views/view.mjs";
import {getRoute} from "./common/utils/helpers.mjs";

const _FILENAME_CSS = "setup.css";
const _FILENAME_JS = "setup.js";

export default () => {
	const {logger} = global;

	const boundGetStaticContent = View._getStaticContent.bind(View);
	View._getStaticContent = (...args) => {
		const out = boundGetStaticContent(...args);

		if (!!global.game?.world?.id || !args[0]?.setup) return out;

		if (fs.existsSync(path.join(global.paths.data, _FILENAME_CSS))) {
			logger.debug(`Found "${_FILENAME_CSS}" additional login style file for setup page; serving...`);
			out.styles.core.push({
				src: getRoute(_FILENAME_CSS, {prefix: global.config.options.routePrefix}),
				type: "style",
				priority: 1,
				layer: undefined,
				isModule: false,
			});
		}

		if (fs.existsSync(path.join(global.paths.data, _FILENAME_JS))) {
			logger.debug(`Found "${_FILENAME_JS}" additional login script file for setup page; serving...`);
			out.scripts.push({
				src: getRoute(_FILENAME_JS, {prefix: global.config.options.routePrefix}),
				type: "script",
				priority: 2,
				layer: undefined,
				isModule: false,
			});
		}

		return out;
	};
};
