import {MODULE_ID} from "./main.js";

export function getBinSettingId() {
    return `${game.world.id}.bin`;
}

export function registerSettings() {
    game.settings.register(MODULE_ID, getBinSettingId(), {
        scope: "client",
        config: false,
        type: Array,
        default: [],
    })

    game.settings.register(MODULE_ID, "maxPermanentItems", {
        name: `${MODULE_ID}.settings.maxPermanentItems.name`,
        hint: `${MODULE_ID}.settings.maxPermanentItems.hint`,
        scope: "world",
        config: true,
        type: Number,
        default: 20,
    })

    game.settings.register(MODULE_ID, "maxTemporaryItems", {
        name: `${MODULE_ID}.settings.maxTemporaryItems.name`,
        hint: `${MODULE_ID}.settings.maxTemporaryItems.hint`,
        scope: "world",
        config: true,
        type: Number,
        default: 100,
    })


}