import {initConfig, initAutoTooltips} from "./config.js";
import { registerSettings } from "./settings.js";

export const MODULE_ID = "rich-info-tooltips";

export const JOURNAL_NAME = "Rich Info Tooltips";

export const MAX_TEXT_LENGTH = 1000;

Hooks.on("init", () => {
    registerSettings();
});

Hooks.once("setup", () => {
    initConfig();
});

Hooks.once("ready", () => {
    initAutoTooltips(); 
    if (!game.user.isGM) return;
    
    const infoJournal = game.journal.getName(JOURNAL_NAME);
    if(!infoJournal) {
        JournalEntry.create({
            name: JOURNAL_NAME,
            folder: null,
        });
    }

})