export const MOON_PRESETS = [
    { "label": "simple-timekeeping.moonPhase.new", "color": "#E0E0E0", "icon": "🌑" },
    { "label": "simple-timekeeping.moonPhase.waxingCrescent", "color": "#F0F0F0", "icon": "🌒" },
    { "label": "simple-timekeeping.moonPhase.firstQuarter", "color": "#FAFAFA", "icon": "🌓" },
    { "label": "simple-timekeeping.moonPhase.waxingGibbous", "color": "#FFFFF0", "icon": "🌔" },
    { "label": "simple-timekeeping.moonPhase.full", "color": "#FFFFCC", "icon": "🌕" },
    { "label": "simple-timekeeping.moonPhase.waningGibbous", "color": "#FFF8DC", "icon": "🌖" },
    { "label": "simple-timekeeping.moonPhase.lastQuarter", "color": "#F5F5F5", "icon": "🌗" },
    { "label": "simple-timekeeping.moonPhase.waningCrescent", "color": "#ECECEC", "icon": "🌘" },

    { "label": "simple-timekeeping.moonPhase.bloodMoon", "color": "#FFCCCC", "icon": "🩸" },
    { "label": "simple-timekeeping.moonPhase.eclipse", "color": "#D3D3D3", "icon": "🌚" },
    { "label": "simple-timekeeping.moonPhase.voidMoon", "color": "#CCCCFF", "icon": "🕳️" },
    { "label": "simple-timekeeping.moonPhase.twinMoons", "color": "#FFF0F5", "icon": "🌕🌕" },
    { "label": "simple-timekeeping.moonPhase.manaMoon", "color": "#E0BBFF", "icon": "✨" },
    { "label": "simple-timekeeping.moonPhase.celestialAlignment", "color": "#FFE4B5", "icon": "🌝" },
    { "label": "simple-timekeeping.moonPhase.shatteredMoon", "color": "#E6E6FA", "icon": "🌗💫" },
    { "label": "simple-timekeeping.moonPhase.spiritMoon", "color": "#F8F8FF", "icon": "👻" }
]

export const WEATHER_PRESETS = [
    { "id": "clear", "color": "#FFEE88", "icon": "fas fa-sun long-context-menu", "weatherEffect": "none", "weatherEffect3d": "none" },
    { "id": "partlyCloudy", "color": "#D0E8FF", "icon": "fas fa-cloud-sun", "weatherEffect": "none", "weatherEffect3d": "none" },
    { "id": "cloudy", "color": "#B0C4DE", "icon": "fas fa-cloud", "weatherEffect": "none", "weatherEffect3d": "none" },
    { "id": "overcast", "color": "#CCCCCC", "icon": "fas fa-smog", "weatherEffect": "none", "weatherEffect3d": "none" },
    { "id": "rain", "color": "#A0D8EF", "icon": "fas fa-cloud-showers-heavy", "weatherEffect": "rain", "weatherEffect3d": "rain" },
    { "id": "thunderstorm", "color": "#FFD966", "icon": "fas fa-bolt", "weatherEffect": "rainStorm", "weatherEffect3d": "heavyrain" },
    { "id": "drizzle", "color": "#CDEFFF", "icon": "fas fa-cloud-rain", "weatherEffect": "rain", "weatherEffect3d": "rain" },
    { "id": "snow", "color": "#FFFFFF", "icon": "fas fa-snowflake", "weatherEffect": "snow", "weatherEffect3d": "snow" },
    { "id": "blizzard", "color": "#E0F7FF", "icon": "fas fa-snowman", "weatherEffect": "blizzard", "weatherEffect3d": "snow" },
    { "id": "hail", "color": "#D1EFFF", "icon": "fas fa-cloud-meatball", "weatherEffect": "snow", "weatherEffect3d": "hail" },
    { "id": "fog", "color": "#E6E6E6", "icon": "fas fa-smog", "weatherEffect": "fog", "weatherEffect3d": "smoke" },
    { "id": "mist", "color": "#F0F8FF", "icon": "fas fa-water", "weatherEffect": "fog", "weatherEffect3d": "dust" },
    { "id": "windy", "color": "#E0F7FA", "icon": "fas fa-wind", "weatherEffect": "leaves", "weatherEffect3d": "leaves" },
    { "id": "tornado", "color": "#FFD1DC", "icon": "fas fa-poo-storm", "weatherEffect": "rainStorm", "weatherEffect3d": "dust" },
    { "id": "hurricane", "color": "#FFE599", "icon": "fas fa-hurricane", "weatherEffect": "rainStorm", "weatherEffect3d": "heavyrain" },
    { "id": "ashfall", "color": "#DADADA", "icon": "fas fa-cloud", "weatherEffect": "fog", "weatherEffect3d": "embers" },
    { "id": "sandstorm", "color": "#F4E1A1", "icon": "fas fa-cloud-sun", "weatherEffect": "fog", "weatherEffect3d": "sand" },
    { "id": "luminousSky", "color": "#E0BBFF", "icon": "fas fa-star", "weatherEffect": "none", "weatherEffect3d": "stars" },
    { "id": "bloodRain", "color": "#FFB3BA", "icon": "fas fa-tint", "weatherEffect": "rain", "weatherEffect3d": "rain" },
    { "id": "manaStorm", "color": "#B3E5FC", "icon": "fas fa-magic", "weatherEffect": "rainStorm", "weatherEffect3d": "heavyrain" },
    { "id": "arcaneFog", "color": "#E6CCFF", "icon": "fas fa-hat-wizard", "weatherEffect": "fog", "weatherEffect3d": "toxic" },
    { "id": "voidstorm", "color": "#C9C9FF", "icon": "fas fa-ghost", "weatherEffect": "rainStorm", "weatherEffect3d": "heavyrain" },
    { "id": "celestialEclipse", "color": "#FFE0B2", "icon": "fas fa-moon", "weatherEffect": "none", "weatherEffect3d": "mysteriouslights" },
    { "id": "meteorShower", "color": "#FFECB3", "icon": "fas fa-meteor", "weatherEffect": null, "weatherEffect3d": "starfall" },
    { "id": "frozenHell", "color": "#D0FFFF", "icon": "fas fa-icicles", "weatherEffect": "blizzard", "weatherEffect3d": "snow" },
    { "id": "sunshower", "color": "#FCEABB", "icon": "fas fa-cloud-sun-rain", "weatherEffect": "rain", "weatherEffect3d": "rain" },
    { "id": "spectralStorm", "color": "#D9E2F3", "icon": "fas fa-bolt", "weatherEffect": "rainStorm", "weatherEffect3d": "heavyrain" },
    { "id": "etherealDrizzle", "color": "#E0F7F9", "icon": "fas fa-water", "weatherEffect": "rain", "weatherEffect3d": "rain" },
    { "id": "wildMagicWinds", "color": "#FFFACD", "icon": "fas fa-wind", "weatherEffect": "leaves", "weatherEffect3d": "leaves" }
];

export const CLIMATE_DATA = {
    tropical: {
        temperature: {
            default: { min: 24, max: 35 }
        },
        weather: {
            default: {
                clear: 8,
                partlyCloudy: 5,
                rain: 7,
                thunderstorm: 3,
                fog: 2,
                sunshower: 1
            }
        }
    },
    subtropical: {
        temperature: {
            summer: { min: 15, max: 32 },
            winter: { min: 5, max: 17 },
            default: { min: 10, max: 25 }
        },
        weather: {
            summer: {
                clear: 5,
                partlyCloudy: 4,
                rain: 5,
                drizzle: 2,
                sunshower: 1
            },
            winter: {
                clear: 2,
                cloudy: 4,
                rain: 3,
                mist: 2,
                fog: 1
            },
            default: {
                clear: 4,
                partlyCloudy: 5,
                cloudy: 3,
                rain: 2
            }
        }
    },
    temperate: {
        temperature: {
            summer: { min: 18, max: 30 },
            winter: { min: -5, max: 5 },
            default: { min: 8, max: 20 }
        },
        weather: {
            summer: {
                clear: 6,
                partlyCloudy: 4,
                thunderstorm: 2
            },
            winter: {
                snow: 5,
                blizzard: 3,
                fog: 2
            },
            default: {
                rain: 3,
                cloudy: 3,
                mist: 2,
                drizzle: 2
            }
        }
    },
    polar: {
        temperature: {
            winter: { min: -40, max: -10 },
            default: { min: -5, max: 5 }
        },
        weather: {
            winter: {
                blizzard: 6,
                snow: 5
            },
            default: {
                clear: 4,
                partlyCloudy: 3,
                windy: 2,
                mist: 1
            }
        }
    }
}

export const DEFAULT_PHASE_NAMES = [
    "simple-timekeeping.moonPhase.new",
    "simple-timekeeping.moonPhase.waxingCrescent",
    "simple-timekeeping.moonPhase.firstQuarter",
    "simple-timekeeping.moonPhase.waxingGibbous",
    "simple-timekeeping.moonPhase.full",
    "simple-timekeeping.moonPhase.waningGibbous",
    "simple-timekeeping.moonPhase.lastQuarter",
    "simple-timekeeping.moonPhase.waningCrescent"
]