import { MODULE_ID } from "./main.js";

export function registerSettings() {

    game.settings.register(MODULE_ID, "showChatMessage", {
        name: game.i18n.localize("tidbits.settings.showChatMessage.name"),
        hint: game.i18n.localize("tidbits.settings.showChatMessage.hint"),
        scope: "world",
        config: true,
        default: "everyone",
        type: String,
        choices: {
            "everyone": game.i18n.localize("tidbits.settings.showChatMessage.choices.everyone"),
            "players": game.i18n.localize("tidbits.settings.showChatMessage.choices.players"),
            "gamemaster": game.i18n.localize("tidbits.settings.showChatMessage.choices.gamemaster"),
            "none": game.i18n.localize("tidbits.settings.showChatMessage.choices.none")
        }
    });

    game.settings.register(MODULE_ID, "showLoadingScreen", {
        name: game.i18n.localize("tidbits.settings.showLoadingScreen.name"),
        hint: game.i18n.localize("tidbits.settings.showLoadingScreen.hint"),
        scope: "world",
        config: true,
        default: "everyone",
        type: String,
        choices: {
            "everyone": game.i18n.localize("tidbits.settings.showLoadingScreen.choices.everyone"),
            "players": game.i18n.localize("tidbits.settings.showLoadingScreen.choices.players"),
            "gamemaster": game.i18n.localize("tidbits.settings.showLoadingScreen.choices.gamemaster"),
            "none": game.i18n.localize("tidbits.settings.showLoadingScreen.choices.none")
        }
    });

    game.settings.register(MODULE_ID, "startupLoadingScreen", {
        name: game.i18n.localize("tidbits.settings.startupLoadingScreen.name"),
        hint: game.i18n.localize("tidbits.settings.startupLoadingScreen.hint"),
        scope: "world",
        config: true,
        default: 5,
        type: Number,
        range: {
            min: 0,
            max: 15,
            step: 1
        }
    });

    game.settings.register(MODULE_ID, "loadingScreenMinimumDuration", {
        name: game.i18n.localize("tidbits.settings.loadingScreenMinimumDuration.name"),
        hint: game.i18n.localize("tidbits.settings.loadingScreenMinimumDuration.hint"),
        scope: "world",
        config: true,
        default: 4,
        type: Number,
        range: {
            min: 1,
            max: 15,
            step: 0.1
        }
    });

    game.settings.register(MODULE_ID, "loadingScreenGradient", {
        name: game.i18n.localize("tidbits.settings.loadingScreenGradient.name"),
        hint: game.i18n.localize("tidbits.settings.loadingScreenGradient.hint"),
        scope: "world",
        config: true,
        default: true,
        type: Boolean,
    });

    game.settings.register(MODULE_ID, "pauseText", {
        name: game.i18n.localize("tidbits.settings.pauseText.name"),
        hint: game.i18n.localize("tidbits.settings.pauseText.hint"),
        scope: "world",
        config: true,
        default: true,
        type: Boolean
    });

    game.settings.register(MODULE_ID, "autoCycle", {
        name: game.i18n.localize("tidbits.settings.autoCycle.name"),
        hint: game.i18n.localize("tidbits.settings.autoCycle.hint"),
        scope: "world",
        config: true,
        default: false,
        type: Number,
        range: {
            min: 0,
            max: 60,
            step: 1
        }
    });

    game.settings.register(MODULE_ID, "didYouKnowText", {
        name: game.i18n.localize("tidbits.settings.didYouKnowText.name"),
        hint: game.i18n.localize("tidbits.settings.didYouKnowText.hint"),
        scope: "world",
        config: true,
        default: "",
        type: String,
    });

    game.settings.register(MODULE_ID, "useDefaultSources", {
        name: game.i18n.localize("tidbits.settings.useDefaultSources.name"),
        hint: game.i18n.localize("tidbits.settings.useDefaultSources.hint"),
        scope: "world",
        config: true,
        default: true,
        type: Boolean
    });

    game.settings.register(MODULE_ID, "customSource", {
        name: game.i18n.localize("tidbits.settings.customSource.name"),
        hint: game.i18n.localize("tidbits.settings.customSource.hint"),
        scope: "world",
        config: true,
        default: "",
        type: String,
        filePicker: "any",
    });

    game.settings.register(MODULE_ID, "imageSource", {
        name: game.i18n.localize("tidbits.settings.imageSource.name"),
        hint: game.i18n.localize("tidbits.settings.imageSource.hint"),
        scope: "world",
        config: true,
        default: "modules/tidbits/assets/images",
        type: String,
        filePicker: "folder",
    });

    game.settings.register(MODULE_ID, "imagePaths", {
        scope: "world",
        config: false,
        default: [],
        type: Array,
    });

}

