import { MODULE_ID } from "./main.js";

export function initConfig() {
    if (!game.settings.get(MODULE_ID, "showLoadingScreen")) return;

    Hooks.on("3DCanvasReady", () => {
        libWrapper.register(MODULE_ID, "game.Levels3DPreview.setProgressBar", function (wrapped, ...args) {
            const progress = args[1];
            if (progress > 0 && progress < 100) {
                ui.tidbits.showLoadingScreen()
            } else {
                ui.tidbits.hideLoadingScreen()
            }
            return wrapped(...args);
        }, "WRAPPER");
    });

    Hooks.on("canvasInit", () => {
        if (!game.settings.get(MODULE_ID, "showLoadingScreen")) return;
        ui.tidbits?.showLoadingScreen()
        Hooks.once("canvasReady", () => {
            ui.tidbits?.hideLoadingScreen()
        })
    })
}