import { flip } from "../Flip.js";
import {HandlebarsApplication} from "../lib/utils.js";
import {mergeClone} from "../lib/utils.js";
import {MODULE_ID} from "../main.js";

export class FlipMenu extends HandlebarsApplication {
    constructor(token, hud) {
        super();
        this.object = token;
        this.document = token.document;
        this.hud = hud;
    }

    static get DEFAULT_OPTIONS() {
        return mergeClone(super.DEFAULT_OPTIONS, {
            classes: [this.APP_ID, "placeable-hud", "control-icon"],
            id: 'flip-menu',
            window: {
                title: `${MODULE_ID}.${this.APP_ID}.title`,
                icon: "",
                resizable: false,
                frame: false,
            },
            position: {
                width: 300,
                height: "auto",
            },
        });
    }

    static get PARTS() {
        return {
            content: {
                template: `modules/${MODULE_ID}/templates/${this.APP_ID}.hbs`,
                classes: [],
                scrollable: [],
            },
        };
    }

    async _prepareContext(options) {
        return {
            tokenfaces: (this.document.getFlag("tokenflip", "tokenfaces") ?? []).map((t) => ({
                actorId: t.actorId,
                actorName: game.actors.get(t.actorId)?.name,
                img: t.img,
                subject: t.subject,
                id: t.id,
            })),
        };
    }

    _onRender(context, options) {
        const html = this.element;
        html.querySelectorAll("li").forEach((li) => {
            li.addEventListener("click", (e) => {
                flip(this.object, e.currentTarget.dataset.id);
            });
        });
        const hud = this.hud;
        const container = hud.querySelector(".col.right");
        const scale = parseFloat(hud.closest("#hud").style.transform.match(/scale\(([0-9.]+)\)/)[1]);
        const containerOffset = container.getBoundingClientRect();
        const buttonOffset = hud.querySelector(`div[data-action="tokenflip"]`).getBoundingClientRect();
        const btnWidth = buttonOffset.width;
        this.setPosition({ top: (buttonOffset.top - containerOffset.top) / scale, left: (btnWidth + buttonOffset.left - containerOffset.left) / scale });
        container.appendChild(html);
    }
}
