# Video Game Music

![GitHub release](https://img.shields.io/github/v/release/Sayshal/vgmusic?style=for-the-badge)
![GitHub Downloads (specific asset, all releases)](https://img.shields.io/github/downloads/Sayshal/vgmusic/module.zip?style=for-the-badge&logo=foundryvirtualtabletop&logoColor=white&logoSize=auto&label=Downloads%20(Total)&color=ff144f)
![GitHub Downloads (specific asset, latest release)](https://img.shields.io/github/downloads/Sayshal/vgmusic/latest/module.zip?sort=date&style=for-the-badge&logo=foundryvirtualtabletop&logoColor=white&logoSize=auto&label=Downloads%20(Latest)&color=ff144f)

![Foundry Version](https://img.shields.io/endpoint?url=https%3A%2F%2Ffoundryshields.com%2Fversion%3Fstyle%3Dfor-the-badge%26url%3Dhttps%3A%2F%2Fgithub.com%2FSayshal%2Fvgmusic%2Freleases%2Flatest%2Fdownload%2Fmodule.json)

## Supporting The Module

[![Discord](https://dcbadge.limes.pink/api/server/PzzUwU9gdz)](https://discord.gg/PzzUwU9gdz)

## Introduction

**Video Game Music** transforms your FoundryVTT experience with dynamic, context-aware audio management that brings your virtual tabletop to life! Just like in video games, music seamlessly transitions between exploration, combat, and dramatic moments, creating an immersive atmosphere that responds to the action.

Say goodbye to manually managing playlists and hello to intelligent audio that knows when to build tension for combat, provide ambiance for exploration, and resume exactly where it left off when the action calms down.

---

## Key Features

### 🎵 **Dynamic Music Contexts**

- **Area Music**: Automatic ambient soundscapes for scenes and locations
- **Combat Music**: Intense battle tracks that activate during encounters
- **Smart Transitions**: Seamless fade-ins and fade-outs between music contexts
- **Position Memory**: Music resumes from where it was interrupted

### 🎭 **Per-Actor Combat Themes**

- **Individual Battle Music**: Each actor can have their own signature combat theme
- **Priority System**: Hierarchical music selection based on current combat focus
- **Flexible Fallbacks**: Multiple fallback options when actors don't have dedicated themes

### 🎛️ **Advanced Playlist Management**

- **Scene Integration**: Configure area and combat music directly in scene settings
- **Actor Customization**: Add battle themes through actor sheet controls
- **Default Music System**: Set fallback music for various situations
- **Initial Track Selection**: Choose specific starting tracks within playlists

### ⚙️ **Intelligent Audio Control**

- **Silent Combat Modes**: Configurable behavior when combat actors lack dedicated music
- **Suppression Controls**: Temporarily disable area or combat music with hotkeys
- **Priority Sorting**: Smart music selection based on context and actor importance
- **Fade Duration Control**: Customizable transition timing for smooth audio experiences

---

## Installation

Get Video Game Music through Foundry's **Module Manager** for instant setup.

### Manual Installation

1. Open **Foundry's Configuration and Setup** screen
2. Click **Install Module** in the Add-on Modules section
3. Paste this URL in the **Manifest URL** field: [https://github.com/Sayshal/vgmusic/releases/latest/download/module.json](https://github.com/Sayshal/vgmusic/releases/latest/download/module.json)
4. Click **Install**
5. Enable Video Game Music in the **Manage Modules** section

---

## Configuration

### Quick Setup

1. **Install and Enable**: Add the module through Foundry's module manager
2. **Configure Scenes**: Use the music configuration button in scene settings
3. **Set Actor Themes**: Add battle music through actor sheet controls
4. **Customize Behavior**: Adjust settings for silent combat modes and suppression

### Scene Music Configuration

Access scene audio settings through the scene configuration panel:

- **Music Configuration Button**: Located in the scene settings for easy access
- **Drag & Drop Interface**: Simply drag playlists from the sidebar to assign them
- **Track Selection**: Choose specific starting tracks from assigned playlists
- **Priority Settings**: Control music hierarchy during complex scenarios

### Actor Music Setup

Configure actor battle themes through the actor sheet:

- **Header Controls**: Music configuration button in actor sheet headers
- **Combat Music Section**: Dedicated interface for assigning battle themes
- **Priority Configuration**: Set importance levels for music conflicts
- **Initial Track Selection**: Choose starting points within assigned playlists

### Global Settings

Customize module behavior through world settings:

- **Silent Combat Music Mode**: Choose fallback behavior for actors without themes
- **Default Music Configuration**: Set system-wide fallback audio
- **Suppression Controls**: Configure hotkeys for temporary audio control

---

## Why Video Game Music?

Traditional tabletop audio management requires constant manual intervention. You have to:

- Remember to start appropriate music for each scene
- Manually change tracks when combat begins
- Constantly adjust audio for different situations
- Deal with jarring transitions and interruptions

**Video Game Music** eliminates these hassles by providing:

- **Automatic Context Detection**: Music changes based on game state without manual intervention
- **Seamless Transitions**: Smooth fade-ins and fade-outs create professional audio experiences
- **Position Memory**: Tracks resume exactly where they left off, maintaining audio continuity
- **Intelligent Prioritization**: Smart selection of appropriate music based on current situation
- **Flexible Control**: Easy suppression and override options when manual control is needed

Whether you're running a quick one-shot or a complex long-term campaign, Video Game Music creates the atmospheric audio experience your players deserve without the constant management overhead!

---

## Support & Community

- **Discord**: [Join our community for support, suggestions, and updates](https://discord.gg/PzzUwU9gdz)
- **GitHub Issues**: [Report bugs or request features](https://github.com/Sayshal/vgmusic/issues)
