const JB2APATREONDB = {};
async function initializeJB2APatreonDB(path) {
  JB2APATREONDB._templates = {
    ranged: [200, 200, 200]
  };
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l0 = prefix("Cantrip");
  const l1 = prefix("1st_Level");
  const l2 = prefix("2nd_Level");
  const l3 = prefix("3rd_Level");
  const l4 = prefix("4th_Level");
  const l5 = prefix("5th_Level");
  const l6 = prefix("6th_Level");
  const l7 = prefix("7th_Level");
  const lg = prefix("Generic");
  JB2APATREONDB.range = {
    _template: "ranged",
    weapon: {
      arrow: {
        "regular": {
          regular: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Glowing_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Glowing_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Glowing_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Glowing_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Glowing_Green_90ft_4000x400.webm`]
          }
        },
        "physical": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Physical_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Physical_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Physical_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Physical_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Physical_90ft_4000x400.webm`]
          },
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_White_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_White_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_White_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_White_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_White_Physical_90ft_4000x400.webm`]
          }
        },
        "poison": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Poison_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Poison_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Poison_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Poison_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Poison_90ft_4000x400.webm`]
          }
        },
        "fire": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Fire_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Fire_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Fire_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Fire_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Fire_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Fire_90ft_4000x400.webm`]
          }
        },
        "cold": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Cold_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Cold_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Cold_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Cold_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Cold_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Cold_90ft_4000x400.webm`]
          }
        },
        "lightning": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Lightning_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Green_Lightning_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Orange_Lightning_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Pink_Lightning_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Purple_Lightning_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Red_Lightning_90ft_4000x400.webm`]
          }
        }
      },
      bolt: {
        "physical": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Physical_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Physical_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Physical_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Physical_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Physical_90ft_4000x400.webm`]
          },
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_White_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_White_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_White_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_White_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_White_Physical_90ft_4000x400.webm`]
          }
        },
        "poison": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Poison_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Poison_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Poison_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Poison_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Poison_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Poison_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Poison_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Poison_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Poison_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Poison_90ft_4000x400.webm`]
          }
        },
        "fire": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Fire_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Fire_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Fire_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Fire_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Fire_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Fire_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Fire_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Fire_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Fire_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Fire_90ft_4000x400.webm`]
          }
        },
        "cold": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Cold_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Cold_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Cold_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Cold_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Cold_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Cold_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Cold_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Cold_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Cold_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Cold_90ft_4000x400.webm`]
          }
        },
        "lightning": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Blue_Lightning_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Green_Lightning_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Lightning_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Pink_Lightning_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Purple_Lightning_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Lightning_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Lightning_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Lightning_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Lightning_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Red_Lightning_90ft_4000x400.webm`]
          }
        }
      },
      bomb: {
        "01": {
          black: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Green_90ft_4000x400.webm`]
          },
          grey: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Grey_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Grey_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Grey_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Grey_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Grey_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      boulder: {
        "01": {
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_01_Regular_White_05ft_600x500.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_01_Regular_White_15ft_1000x500.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_01_Regular_White_30ft_1600x500.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_01_Regular_White_60ft_2800x500.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_01_Regular_White_90ft_4000x500.webm`]
          }
        }
      },
      bone: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      bullet: {
        "1": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Green_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "2": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Green_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "3": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Orange_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Green_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      cannonball: {
        "01": {
          black: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_90ft_4000x400.webm`]
          }
        }
      },
      chakram: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_90ft_4000x400.webm`]
          }
        },
        "02": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Chakram01_02_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Chakram01_02_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Chakram01_02_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Chakram01_02_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      dagger: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_90ft_4000x400.webm`]
          },
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_90ft_4000x400.webm`]
          },
          darkpurple: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_90ft_4000x400.webm`]
          },
          pink: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Pink_90ft_4000x400.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "02": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_90ft_4000x400.webm`]
          },
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_90ft_4000x400.webm`]
          },
          darkpurple: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_90ft_4000x400.webm`]
          },
          pink: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_90ft_4000x400.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "kunai": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Kunai01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Kunai01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Kunai01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Kunai01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      dart: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      flask: {
        "01": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_90ft_4000x400.webm`]
          }
        },
        "02": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Blue_90ft_4000x400.webm`]
          }
        },
        "03": {
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Green_90ft_4000x400.webm`]
          }
        }
      },
      greataxe: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_White_90ft_4000x600.webm`]
          },
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Blue_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Blue_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Blue_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Blue_90ft_4000x600.webm`]
          },
          yellow: {
            "15ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Yellow_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Yellow_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Yellow_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Yellow_90ft_4000x600.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Red_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Red_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Red_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/GreatAxe01_01_Regular_Red_90ft_4000x600.webm`]
          }
        }
      },
      greatsword: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_90ft_4000x600.webm`]
          }
        }
      },
      grenade: {
        "01": {
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade01_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade01_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade01_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade01_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade01_01_Regular_Green_90ft_4000x400.webm`]
          }
        },
        "02": {
          blackyellow: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade02_01_Regular_BlackYellow_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade02_01_Regular_BlackYellow_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade02_01_Regular_BlackYellow_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade02_01_Regular_BlackYellow_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade02_01_Regular_BlackYellow_90ft_4000x400.webm`]
          }
        },
        "03": {
          blackblue: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_BlackBlue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_BlackBlue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_BlackBlue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_BlackBlue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_BlackBlue_90ft_4000x400.webm`]
          }
        },
        stick: {
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowStickGrenade01_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowStickGrenade01_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowStickGrenade01_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowStickGrenade01_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowStickGrenade01_01_Regular_Green_90ft_4000x400.webm`]
          }
        }
      },
      grenadelaunch: {
        "01": {
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade01_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade01_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade01_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade01_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade01_01_Regular_Green_90ft_4000x400.webm`]
          }
        },
        "02": {
          blackyellow: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade02_01_Regular_BlackYellow_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade02_01_Regular_BlackYellow_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade02_01_Regular_BlackYellow_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade02_01_Regular_BlackYellow_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade02_01_Regular_BlackYellow_90ft_4000x400.webm`]
          }
        },
        "03": {
          blackblue: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_BlackBlue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_BlackBlue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_BlackBlue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_BlackBlue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_BlackBlue_90ft_4000x400.webm`]
          }
        }
      },
      hammer: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      handaxe: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/HandAxe01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/HandAxe01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/HandAxe01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/HandAxe01_01_Regular_White_90ft_4000x400.webm`]
          }
        },
        "02": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/HandAxe02_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/HandAxe02_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/HandAxe02_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/HandAxe02_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      javelin: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      lasershot: {
        "01": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Pink_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Purple_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Purple_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Purple_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Purple_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Purple_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      lasersword: {
        "01": {
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_90ft_4000x600.webm`]
          },
          blue03: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue03_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue03_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue03_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue03_90ft_4000x600.webm`]
          },
          darkred: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_Red_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_Red_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_Red_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_Red_90ft_4000x600.webm`]
          },
          darkwhite: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Dark_White_90ft_4000x600.webm`]
          },
          darkblue: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue02_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue02_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue02_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue02_90ft_4000x600.webm`]
          },
          green: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green_90ft_4000x600.webm`]
          },
          palegreen: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green02_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green02_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green02_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Green02_90ft_4000x600.webm`]
          },
          orange: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Orange_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Orange_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Orange_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Orange_90ft_4000x600.webm`]
          },
          purple: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Purple_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Purple_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Purple_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Purple_90ft_4000x600.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Red_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Red_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Red_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Red_90ft_4000x600.webm`]
          },
          yellow: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Yellow_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Yellow_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Yellow_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Yellow_90ft_4000x600.webm`]
          },
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_White_90ft_4000x600.webm`]
          }
        },
        "02": {
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue_90ft_4000x600.webm`]
          },
          blue02: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue03_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue03_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue03_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue03_90ft_4000x600.webm`]
          },
          darkred: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_Red_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_Red_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_Red_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_Red_90ft_4000x600.webm`]
          },
          darkwhite: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Dark_White_90ft_4000x600.webm`]
          },
          darkblue: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue02_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue02_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue02_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Blue02_90ft_4000x600.webm`]
          },
          green: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green_90ft_4000x600.webm`]
          },
          palegreen: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green02_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green02_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green02_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Green02_90ft_4000x600.webm`]
          },
          orange: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Orange_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Orange_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Orange_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Orange_90ft_4000x600.webm`]
          },
          purple: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Purple_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Purple_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Purple_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Purple_90ft_4000x600.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_90ft_4000x600.webm`]
          },
          yellow: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Yellow_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Yellow_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Yellow_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Yellow_90ft_4000x600.webm`]
          },
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_White_90ft_4000x600.webm`]
          }
        }
      },
      mace: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Mace01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Mace01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Mace01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Mace01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      pumpkin: {
        "01": {
          regular: {
            "05ft": [lg`Weapon_Attacks/Ranged/PumpkinToss01_01_Regular_Orange_05ft_600x500.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/PumpkinToss01_01_Regular_Orange_15ft_1000x500.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/PumpkinToss01_01_Regular_Orange_30ft_1600x500.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/PumpkinToss01_01_Regular_Orange_60ft_2800x500.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/PumpkinToss01_01_Regular_Orange_90ft_4000x500.webm`]
          }
        }
      },
      siegeboulder: {
        "01": {
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/SiegeBoulder01_01_Regular_White_05ft_600x500.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/SiegeBoulder01_01_Regular_White_15ft_1000x500.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/SiegeBoulder01_01_Regular_White_30ft_1600x500.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/SiegeBoulder01_01_Regular_White_60ft_2800x500.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/SiegeBoulder01_01_Regular_White_90ft_4000x500.webm`]
          }
        }
      },
      sling: {
        "01": {
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/SlingShot_01_Regular_White_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/SlingShot_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/SlingShot_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/SlingShot_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/SlingShot_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      snipe: {
        "01": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Green_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Orange_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      snowball: {
        "01": {
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_05ft_600x500.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_15ft_1000x500.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_30ft_1600x500.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_60ft_2800x500.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_90ft_4000x500.webm`]
          }
        }
      },
      spear: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      sword: {
        "01": {
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/Sword01_02_Regular_Blue_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Sword01_02_Regular_Blue_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Sword01_02_Regular_Blue_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Sword01_02_Regular_Blue_90ft_4000x600.webm`]
          },
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Sword01_01_Regular_White_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Sword01_01_Regular_White_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Sword01_01_Regular_White_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Sword01_01_Regular_White_90ft_4000x600.webm`]
          }
        }
      }
    },
    spell: {
      chainlightning: {
        primary: {
          blue: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_90ft_Primary_4000x400.webm`]
          },
          darkgreen: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_90ft_Primary_4000x400.webm`]
          },
          darkpurple: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_90ft_Primary_4000x400.webm`]
          },
          darkred: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_90ft_Primary_4000x400.webm`]
          },
          green: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_90ft_Primary_4000x400.webm`]
          },
          orange: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_90ft_Primary_4000x400.webm`]
          },
          purple: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_90ft_Primary_4000x400.webm`]
          },
          purpleblue: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_90ft_Primary_4000x400.webm`]
          },
          red: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_90ft_Primary_4000x400.webm`]
          },
          yellow: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_90ft_Primary_4000x400.webm`]
          }
        },
        secondary: {
          blue: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_90ft_Secondary_4000x400.webm`]
          },
          darkgreen: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green02_90ft_Secondary_4000x400.webm`]
          },
          darkpurple: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Purple_90ft_Secondary_4000x400.webm`]
          },
          darkred: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Dark_Red_90ft_Secondary_4000x400.webm`]
          },
          green: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Green_90ft_Secondary_4000x400.webm`]
          },
          orange: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Orange_90ft_Secondary_4000x400.webm`]
          },
          purple: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Purple_90ft_Secondary_4000x400.webm`]
          },
          purpleblue: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue02_90ft_Secondary_4000x400.webm`]
          },
          red: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Red_90ft_Secondary_4000x400.webm`]
          },
          yellow: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Yellow_90ft_Secondary_4000x400.webm`]
          }
        }
      },
      disintegrate: {
        "01": {
          green: {
            "05ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_05ft_600x400.webm`],
            "15ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_15ft_1000x400.webm`],
            "30ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_30ft_1600x400.webm`],
            "60ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_60ft_2800x400.webm`],
            "90ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_90ft_4000x400.webm`]
          },
          darkred: {
            "05ft": [l6`Disintegrate/Disintegrate_01_Dark_Red_05ft_600x400.webm`],
            "15ft": [l6`Disintegrate/Disintegrate_01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [l6`Disintegrate/Disintegrate_01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [l6`Disintegrate/Disintegrate_01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [l6`Disintegrate/Disintegrate_01_Dark_Red_90ft_4000x400.webm`]
          },
          orangepink: {
            "05ft": [l6`Disintegrate/Disintegrate_01_Regular_OrangePink_05ft_600x400.webm`],
            "15ft": [l6`Disintegrate/Disintegrate_01_Regular_OrangePink_15ft_1000x400.webm`],
            "30ft": [l6`Disintegrate/Disintegrate_01_Regular_OrangePink_30ft_1600x400.webm`],
            "60ft": [l6`Disintegrate/Disintegrate_01_Regular_OrangePink_60ft_2800x400.webm`],
            "90ft": [l6`Disintegrate/Disintegrate_01_Regular_OrangePink_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [l6`Disintegrate/Disintegrate_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [l6`Disintegrate/Disintegrate_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [l6`Disintegrate/Disintegrate_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [l6`Disintegrate/Disintegrate_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [l6`Disintegrate/Disintegrate_01_Regular_Pink_90ft_4000x400.webm`]
          },
          purpleblue: {
            "05ft": [l6`Disintegrate/Disintegrate_01_Regular_PurpleBlue_05ft_600x400.webm`],
            "15ft": [l6`Disintegrate/Disintegrate_01_Regular_PurpleBlue_15ft_1000x400.webm`],
            "30ft": [l6`Disintegrate/Disintegrate_01_Regular_PurpleBlue_30ft_1600x400.webm`],
            "60ft": [l6`Disintegrate/Disintegrate_01_Regular_PurpleBlue_60ft_2800x400.webm`],
            "90ft": [l6`Disintegrate/Disintegrate_01_Regular_PurpleBlue_90ft_4000x400.webm`]
          }
        }
      },
      eldritchblast: {
        "01": {
          purple: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_90ft_4000x400.webm`]
          },
          darkpurple: {
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Purple_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Purple_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Purple_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Green_90ft_4000x400.webm`]
          },
          yellow: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Yellow_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Yellow_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Yellow_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Yellow_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Yellow_90ft_4000x400.webm`]
          },
          darkred: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Red_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Red_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Orange_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Pink_90ft_4000x400.webm`]
          },
          lightgreen: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightGreen_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightGreen_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightGreen_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightGreen_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightGreen_90ft_4000x400.webm`]
          },
          darkgreen: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Green_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Green_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Green_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Green_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Dark_Green_90ft_4000x400.webm`]
          },
          rainbow: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Rainbow_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Rainbow_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Rainbow_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Rainbow_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Rainbow_90ft_4000x400.webm`]
          },
          lightblue: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightBlue_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightBlue_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightBlue_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightBlue_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_LightBlue_90ft_4000x400.webm`]
          }
        }
      },
      fireballbeam: {
        "01": {
          blue: {
            "05ft": [l3`Fireball/FireballBeam_01_Blue_05ft_600x400.webm`],
            "15ft": [l3`Fireball/FireballBeam_01_Blue_15ft_1000x400.webm`],
            "30ft": [l3`Fireball/FireballBeam_01_Blue_30ft_1600x400.webm`],
            "60ft": [l3`Fireball/FireballBeam_01_Blue_60ft_2800x400.webm`],
            "90ft": [l3`Fireball/FireballBeam_01_Blue_90ft_4000x400.webm`]
          },
          darkpurple: {
            "05ft": [l3`Fireball/FireballBeam_01_Dark_Purple_05ft_600x400.webm`],
            "15ft": [l3`Fireball/FireballBeam_01_Dark_Purple_15ft_1000x400.webm`],
            "30ft": [l3`Fireball/FireballBeam_01_Dark_Purple_30ft_1600x400.webm`],
            "60ft": [l3`Fireball/FireballBeam_01_Dark_Purple_60ft_2800x400.webm`],
            "90ft": [l3`Fireball/FireballBeam_01_Dark_Purple_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [l3`Fireball/FireballBeam_01_Orange_05ft_600x400.webm`],
            "15ft": [l3`Fireball/FireballBeam_01_Orange_15ft_1000x400.webm`],
            "30ft": [l3`Fireball/FireballBeam_01_Orange_30ft_1600x400.webm`],
            "60ft": [l3`Fireball/FireballBeam_01_Orange_60ft_2800x400.webm`],
            "90ft": [l3`Fireball/FireballBeam_01_Orange_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [l3`Fireball/FireballBeam_01_Purple_05ft_600x400.webm`],
            "15ft": [l3`Fireball/FireballBeam_01_Purple_15ft_1000x400.webm`],
            "30ft": [l3`Fireball/FireballBeam_01_Purple_30ft_1600x400.webm`],
            "60ft": [l3`Fireball/FireballBeam_01_Purple_60ft_2800x400.webm`],
            "90ft": [l3`Fireball/FireballBeam_01_Purple_90ft_4000x400.webm`]
          }
        }
      },
      firebolt: {
        "01": {
          orange: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Dark_Red_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Dark_Red_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Regular_Purple_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Regular_Purple_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Regular_Purple_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Regular_Purple_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Regular_Purple_90ft_4000x400.webm`]
          },
          darkgreen: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Dark_Green02_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Dark_Green02_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Dark_Green02_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Dark_Green02_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Dark_Green02_90ft_4000x400.webm`]
          },
          palegreen: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green02_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green02_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green02_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green02_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Regular_Green02_90ft_4000x400.webm`]
          }
        }
      },
      guidingbolt: {
        "01": {
          yellowblue: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_90ft_4000x400.webm`]
          },
          greenorange: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_GreenOrange_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_GreenOrange_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_GreenOrange_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_GreenOrange_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_GreenOrange_90ft_4000x400.webm`]
          },
          purplepink: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_PurplePink_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_PurplePink_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_PurplePink_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_PurplePink_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_PurplePink_90ft_4000x400.webm`]
          },
          whiteblue: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Dark_BlueWhite_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Dark_BlueWhite_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Dark_BlueWhite_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Dark_BlueWhite_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Dark_BlueWhite_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Pink_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "02": {
          yellowblue: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_BlueYellow_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_BlueYellow_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_BlueYellow_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_BlueYellow_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_BlueYellow_90ft_4000x400.webm`]
          },
          greenorange: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_GreenOrange_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_GreenOrange_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_GreenOrange_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_GreenOrange_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_GreenOrange_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Pink_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Pink_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Red_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Red_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Red_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Red_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Red_90ft_4000x400.webm`]
          },
          purplepink: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_PurplePink_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_PurplePink_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_PurplePink_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_PurplePink_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_PurplePink_90ft_4000x400.webm`]
          },
          whiteblue: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Dark_BlueWhite_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Dark_BlueWhite_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Dark_BlueWhite_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Dark_BlueWhite_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Dark_BlueWhite_90ft_4000x400.webm`]
          }
        }
      },
      magicmissile: {
        "01": {
          blue: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Blue_90ft_04_4000x400.webm`
            ]
          },
          darkred: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Dark_Red_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Dark_Red_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Dark_Red_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Dark_Red_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Dark_Red_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Dark_Red_90ft_04_4000x400.webm`
            ]
          },
          green: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Green_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Green_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Green_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Green_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Green_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Green_90ft_04_4000x400.webm`
            ]
          },
          purple: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_04_4000x400.webm`
            ]
          },
          yellow: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Yellow_90ft_04_4000x400.webm`
            ]
          },
          orange: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Orange_90ft_04_4000x400.webm`
            ]
          }
        }
      },
      rayoffrost: {
        "01": {
          blue: {
            "05ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Green_90ft_4000x400.webm`]
          },
          purpleteal: {
            "05ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_PurpleTeal_05ft_600x400.webm`],
            "15ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_PurpleTeal_15ft_1000x400.webm`],
            "30ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_PurpleTeal_30ft_1600x400.webm`],
            "60ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_PurpleTeal_60ft_2800x400.webm`],
            "90ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_PurpleTeal_90ft_4000x400.webm`]
          },
          yellowblue: {
            "05ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_BlueYellow_05ft_600x400.webm`],
            "15ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_BlueYellow_15ft_1000x400.webm`],
            "30ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_BlueYellow_30ft_1600x400.webm`],
            "60ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_BlueYellow_60ft_2800x400.webm`],
            "90ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_BlueYellow_90ft_4000x400.webm`]
          }
        }
      },
      scorchingray: {
        "01": {
          orange: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Green_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Pink_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Purple_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Purple_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Purple_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Purple_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Purple_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Red_90ft_4000x400.webm`]
          },
          yellow: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Yellow_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Yellow_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Yellow_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Yellow_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Yellow_90ft_4000x400.webm`]
          },
          rainbow01: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow01_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow01_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow01_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow01_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow01_90ft_4000x400.webm`]
          },
          rainbow02: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow02_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow02_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow02_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow02_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Rainbow02_90ft_4000x400.webm`]
          }
        },
        "02": {
          blue: {
            "05ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_05ft_01_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_05ft_02_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_05ft_03_600x400.webm`
            ],
            "15ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_15ft_01_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_15ft_02_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_15ft_03_1000x400.webm`
            ],
            "30ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_30ft_01_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_30ft_02_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_30ft_03_1600x400.webm`
            ],
            "60ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_60ft_01_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_60ft_02_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_60ft_03_2800x400.webm`
            ],
            "90ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_90ft_01_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_90ft_02_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Blue_90ft_03_4000x400.webm`
            ]
          },
          green: {
            "05ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_05ft_01_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_05ft_02_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_05ft_03_600x400.webm`
            ],
            "15ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_15ft_01_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_15ft_02_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_15ft_03_1000x400.webm`
            ],
            "30ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_30ft_01_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_30ft_02_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_30ft_03_1600x400.webm`
            ],
            "60ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_60ft_01_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_60ft_02_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_60ft_03_2800x400.webm`
            ],
            "90ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_90ft_01_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_90ft_02_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Green_90ft_03_4000x400.webm`
            ]
          },
          orange: {
            "05ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_05ft_01_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_05ft_02_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_05ft_03_600x400.webm`
            ],
            "15ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_15ft_01_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_15ft_02_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_15ft_03_1000x400.webm`
            ],
            "30ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_30ft_01_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_30ft_02_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_30ft_03_1600x400.webm`
            ],
            "60ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_60ft_01_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_60ft_02_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_60ft_03_2800x400.webm`
            ],
            "90ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_90ft_01_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_90ft_02_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Orange_90ft_03_4000x400.webm`
            ]
          },
          pink: {
            "05ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_05ft_01_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_05ft_02_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_05ft_03_600x400.webm`
            ],
            "15ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_15ft_01_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_15ft_02_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_15ft_03_1000x400.webm`
            ],
            "30ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_30ft_01_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_30ft_02_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_30ft_03_1600x400.webm`
            ],
            "60ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_60ft_01_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_60ft_02_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_60ft_03_2800x400.webm`
            ],
            "90ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_90ft_01_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_90ft_02_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Pink_90ft_03_4000x400.webm`
            ]
          },
          purple: {
            "05ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_05ft_01_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_05ft_02_600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_05ft_03_600x400.webm`
            ],
            "15ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_15ft_01_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_15ft_02_1000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_15ft_03_1000x400.webm`
            ],
            "30ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_30ft_01_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_30ft_02_1600x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_30ft_03_1600x400.webm`
            ],
            "60ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_60ft_01_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_60ft_02_2800x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_60ft_03_2800x400.webm`
            ],
            "90ft": [
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_90ft_01_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_90ft_02_4000x400.webm`,
              l2`Scorching_Ray/ScorchingRay_02_Regular_Purple_90ft_03_4000x400.webm`
            ]
          }
        },
        loop: {
          orange: {
            "05ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Orange_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Green_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRayLoop_01_Regular_Pink_90ft_4000x400.webm`]
          }
        }
      },
      witchbolt: {
        "01": {
          blue: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Green_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Red_90ft_4000x400.webm`]
          },
          yellow: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Yellow_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Yellow_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Yellow_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Yellow_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Yellow_90ft_4000x400.webm`]
          },
          darkred: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Red_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Red_90ft_4000x400.webm`]
          },
          darkgreen: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Green_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Green_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Green_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Green_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Green_90ft_4000x400.webm`]
          },
          darkpurple: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Purple_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Purple_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Purple_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Purple_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Dark_Purple_90ft_4000x400.webm`]
          }
        }
      }
    },
    generic: {
      conduit: {
        square: {
          purpleblue: {
            "05ft": [lg`Energy/EnergyConduitSquare_01_Regular_BluePurple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyConduitSquare_01_Regular_BluePurple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyConduitSquare_01_Regular_BluePurple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyConduitSquare_01_Regular_BluePurple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyConduitSquare_01_Regular_BluePurple_90ft_4000x400.webm`]
          },
          greenyellow: {
            "05ft": [lg`Energy/EnergyConduitSquare_01_Regular_GreenYellow_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyConduitSquare_01_Regular_GreenYellow_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyConduitSquare_01_Regular_GreenYellow_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyConduitSquare_01_Regular_GreenYellow_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyConduitSquare_01_Regular_GreenYellow_90ft_4000x400.webm`]
          }
        },
        circle: {
          purpleblue: {
            "05ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_90ft_4000x400.webm`]
          },
          greenyellow: {
            "05ft": [lg`Energy/EnergyConduitCircle_01_Regular_GreenYellow_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyConduitCircle_01_Regular_GreenYellow_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyConduitCircle_01_Regular_GreenYellow_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyConduitCircle_01_Regular_GreenYellow_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyConduitCircle_01_Regular_GreenYellow_90ft_4000x400.webm`]
          }
        }
      },
      energybeam: {
        "01": {
          blue: {
            "15ft": [lg`Energy/EnergyBeam_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_01_Regular_Blue_90ft_4000x400.webm`]
          },
          bluegreen: {
            "15ft": [lg`Energy/EnergyBeam_01_Regular_BlueGreen_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_01_Regular_BlueGreen_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_01_Regular_BlueGreen_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_01_Regular_BlueGreen_90ft_4000x400.webm`]
          },
          darkgreen: {
            "15ft": [lg`Energy/EnergyBeam_01_Dark_Green_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_01_Dark_Green_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_01_Dark_Green_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_01_Dark_Green_90ft_4000x400.webm`]
          },
          darkred: {
            "15ft": [lg`Energy/EnergyBeam_01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_01_Dark_Red_90ft_4000x400.webm`]
          },
          red: {
            "15ft": [lg`Energy/EnergyBeam_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_01_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "02": {
          darkgreenpurple: {
            "05ft": [lg`Energy/EnergyBeam_02_Dark_GreenPurple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_02_Dark_GreenPurple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_02_Dark_GreenPurple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_02_Dark_GreenPurple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_02_Dark_GreenPurple_90ft_4000x400.webm`]
          },
          darkpurplered: {
            "05ft": [lg`Energy/EnergyBeam_02_Dark_PurpleRed_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_02_Dark_PurpleRed_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_02_Dark_PurpleRed_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_02_Dark_PurpleRed_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_02_Dark_PurpleRed_90ft_4000x400.webm`]
          },
          bluepink: {
            "05ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_90ft_4000x400.webm`]
          },
          greenyellow: {
            "05ft": [lg`Energy/EnergyBeam_02_Regular_GreenYellow_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_02_Regular_GreenYellow_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_02_Regular_GreenYellow_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_02_Regular_GreenYellow_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_02_Regular_GreenYellow_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Energy/EnergyBeam_02_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_02_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_02_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_02_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_02_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "03": {
          darkgreenpurple: {
            "05ft": [lg`Energy/EnergyBeam_03_Dark_GreenPurple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_03_Dark_GreenPurple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_03_Dark_GreenPurple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_03_Dark_GreenPurple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_03_Dark_GreenPurple_90ft_4000x400.webm`]
          },
          darkpurplered: {
            "05ft": [lg`Energy/EnergyBeam_03_Dark_PurpleRed_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_03_Dark_PurpleRed_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_03_Dark_PurpleRed_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_03_Dark_PurpleRed_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_03_Dark_PurpleRed_90ft_4000x400.webm`]
          },
          bluepink: {
            "05ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_90ft_4000x400.webm`]
          },
          greenyellow: {
            "05ft": [lg`Energy/EnergyBeam_03_Regular_GreenYellow_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_03_Regular_GreenYellow_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_03_Regular_GreenYellow_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_03_Regular_GreenYellow_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_03_Regular_GreenYellow_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Energy/EnergyBeam_03_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyBeam_03_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_03_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_03_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_03_Regular_Red_90ft_4000x400.webm`]
          }
        },
        reverse: {
          blue: {
            "15ft": [lg`Energy/EnergyBeamReverse_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeamReverse_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeamReverse_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeamReverse_01_Regular_Blue_90ft_4000x400.webm`]
          },
          bluegreen: {
            "15ft": [lg`Energy/EnergyBeamReverse_01_Regular_BlueGreen_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeamReverse_01_Regular_BlueGreen_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeamReverse_01_Regular_BlueGreen_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeamReverse_01_Regular_BlueGreen_90ft_4000x400.webm`]
          },
          darkgreen: {
            "15ft": [lg`Energy/EnergyBeamReverse_01_Dark_Green_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeamReverse_01_Dark_Green_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeamReverse_01_Dark_Green_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeamReverse_01_Dark_Green_90ft_4000x400.webm`]
          },
          darkred: {
            "15ft": [lg`Energy/EnergyBeamReverse_01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeamReverse_01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeamReverse_01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeamReverse_01_Dark_Red_90ft_4000x400.webm`]
          },
          red: {
            "15ft": [lg`Energy/EnergyBeamReverse_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeamReverse_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeamReverse_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeamReverse_01_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      energystrand: {
        "01": {
          darkgreen: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Dark_Green_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Green_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Green_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Green_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Dark_Green_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Green_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Green_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Green_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Dark_Green_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Green_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Green_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Green_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Dark_Green_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Green_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Green_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Green_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Dark_Green_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Green_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Green_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Green_90ft_4000x400.webm`
            ]
          },
          darkpurple: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Dark_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Purple_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Dark_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Purple_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Dark_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Purple_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Dark_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Purple_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Dark_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Purple_90ft_4000x400.webm`
            ]
          },
          darkred: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Dark_Red_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Red_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Red_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Red_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Dark_Red_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Red_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Red_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Red_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Dark_Red_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Red_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Red_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Red_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Dark_Red_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Red_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Red_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Red_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Dark_Red_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Dark_Red_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Dark_Red_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Dark_Red_90ft_4000x400.webm`
            ]
          },
          blue: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Regular_Blue_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Blue_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Blue_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Blue_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Regular_Blue_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Blue_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Blue_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Blue_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Regular_Blue_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Blue_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Blue_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Blue_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Regular_Blue_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Blue_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Blue_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Blue_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Regular_Blue_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Blue_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Blue_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Blue_90ft_4000x400.webm`
            ]
          },
          orange: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Regular_Orange_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Orange_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Orange_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Orange_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Regular_Orange_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Orange_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Orange_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Orange_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Regular_Orange_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Orange_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Orange_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Orange_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Regular_Orange_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Orange_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Orange_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Orange_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Regular_Orange_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Orange_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Orange_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Orange_90ft_4000x400.webm`
            ]
          },
          purple: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_90ft_4000x400.webm`
            ]
          },
          red: {
            "05ft": [lg`Energy/EnergyStrand_05_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_05_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_05_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_05_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_05_Regular_Red_90ft_4000x400.webm`]
          }
        },
        "02": {
          darkgreen: {
            "05ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Green_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Green_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Green_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Green_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Green_90ft_4000x400.webm`]
          },
          darkpurple: {
            "05ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Purple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Purple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Purple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Purple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Purple_90ft_4000x400.webm`]
          },
          darkred: {
            "05ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Red_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Red_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Red_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Red_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple01_Dark_Red_90ft_4000x400.webm`]
          },
          blue: {
            "05ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Blue_90ft_4000x400.webm`]
          },
          purple: {
            "05ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Purple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Purple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Purple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Purple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple01_Regular_Purple_90ft_4000x400.webm`]
          }
        },
        "03": {
          bluepink: {
            "05ft": [lg`Energy/EnergyStrand_Multiple02_Regular_BluePink_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple02_Regular_BluePink_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple02_Regular_BluePink_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple02_Regular_BluePink_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple02_Regular_BluePink_90ft_4000x400.webm`]
          },
          greenyellow: {
            "05ft": [lg`Energy/EnergyStrand_Multiple02_Regular_GreenYellow_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple02_Regular_GreenYellow_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple02_Regular_GreenYellow_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple02_Regular_GreenYellow_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple02_Regular_GreenYellow_90ft_4000x400.webm`]
          },
          darkpurplered: {
            "05ft": [lg`Energy/EnergyStrand_Multiple02_Dark_PurpleRed_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple02_Dark_PurpleRed_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple02_Dark_PurpleRed_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple02_Dark_PurpleRed_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple02_Dark_PurpleRed_90ft_4000x400.webm`]
          },
          darkgreenpurple: {
            "05ft": [lg`Energy/EnergyStrand_Multiple02_Dark_GreenPurple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyStrand_Multiple02_Dark_GreenPurple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyStrand_Multiple02_Dark_GreenPurple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyStrand_Multiple02_Dark_GreenPurple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyStrand_Multiple02_Dark_GreenPurple_90ft_4000x400.webm`]
          }
        }
      },
      heart: {
        "01": {
          pinkyellow: {
            "05ft": [lg`RangedSpell/ProjectileHeart01_01_Regular_PinkYellow_05ft_600x400.webm`],
            "15ft": [lg`RangedSpell/ProjectileHeart01_01_Regular_PinkYellow_15ft_1000x400.webm`],
            "30ft": [lg`RangedSpell/ProjectileHeart01_01_Regular_PinkYellow_30ft_1600x400.webm`],
            "60ft": [lg`RangedSpell/ProjectileHeart01_01_Regular_PinkYellow_60ft_2800x400.webm`],
            "90ft": [lg`RangedSpell/ProjectileHeart01_01_Regular_PinkYellow_90ft_4000x400.webm`]
          }
        }
      },
      iceshard: {
        "01": {
          blue: {
            "05ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_90ft_4000x400.webm`]
          }
        }
      },
      leaves: {
        "01": {
          blue: {
            "05ft": [lg`Nature/SwirlingLeaves01_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Nature/SwirlingLeaves01_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Nature/SwirlingLeaves01_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Nature/SwirlingLeaves01_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Nature/SwirlingLeaves01_01_Regular_Blue_90ft_4000x400.webm`]
          },
          greenorange: {
            "05ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_05ft_600x400.webm`],
            "15ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_15ft_1000x400.webm`],
            "30ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_30ft_1600x400.webm`],
            "60ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_60ft_2800x400.webm`],
            "90ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_90ft_4000x400.webm`]
          },
          orangepink: {
            "05ft": [lg`Nature/SwirlingLeaves01_01_Regular_OrangePink_05ft_600x400.webm`],
            "15ft": [lg`Nature/SwirlingLeaves01_01_Regular_OrangePink_15ft_1000x400.webm`],
            "30ft": [lg`Nature/SwirlingLeaves01_01_Regular_OrangePink_30ft_1600x400.webm`],
            "60ft": [lg`Nature/SwirlingLeaves01_01_Regular_OrangePink_60ft_2800x400.webm`],
            "90ft": [lg`Nature/SwirlingLeaves01_01_Regular_OrangePink_90ft_4000x400.webm`]
          },
          pink: {
            "05ft": [lg`Nature/SwirlingLeaves01_01_Regular_Pink_05ft_600x400.webm`],
            "15ft": [lg`Nature/SwirlingLeaves01_01_Regular_Pink_15ft_1000x400.webm`],
            "30ft": [lg`Nature/SwirlingLeaves01_01_Regular_Pink_30ft_1600x400.webm`],
            "60ft": [lg`Nature/SwirlingLeaves01_01_Regular_Pink_60ft_2800x400.webm`],
            "90ft": [lg`Nature/SwirlingLeaves01_01_Regular_Pink_90ft_4000x400.webm`]
          }
        }
      },
      musicnote: {
        "01": {
          greenyellow: {
            "05ft": [lg`RangedSpell/ProjectileMusicNote01_01_Regular_GreenYellow_05ft_600x400.webm`],
            "15ft": [lg`RangedSpell/ProjectileMusicNote01_01_Regular_GreenYellow_15ft_1000x400.webm`],
            "30ft": [lg`RangedSpell/ProjectileMusicNote01_01_Regular_GreenYellow_30ft_1600x400.webm`],
            "60ft": [lg`RangedSpell/ProjectileMusicNote01_01_Regular_GreenYellow_60ft_2800x400.webm`],
            "90ft": [lg`RangedSpell/ProjectileMusicNote01_01_Regular_GreenYellow_90ft_4000x400.webm`]
          }
        }
      },
      skull: {
        "01": {
          purplepink: {
            "05ft": [lg`RangedSpell/ProjectileSkull01_01_Regular_PinkPurple_05ft_600x400.webm`],
            "15ft": [lg`RangedSpell/ProjectileSkull01_01_Regular_PinkPurple_15ft_1000x400.webm`],
            "30ft": [lg`RangedSpell/ProjectileSkull01_01_Regular_PinkPurple_30ft_1600x400.webm`],
            "60ft": [lg`RangedSpell/ProjectileSkull01_01_Regular_PinkPurple_60ft_2800x400.webm`],
            "90ft": [lg`RangedSpell/ProjectileSkull01_01_Regular_PinkPurple_90ft_4000x400.webm`]
          }
        }
      }
    }
  };
  JB2APATREONDB.melee = {
    creature: {
      bite: {
        "01": {
          red: [lg`Creature/Bite_01_Regular_Red_400x400.webm`],
          blue: [lg`Creature/Bite_01_Regular_Blue_400x400.webm`],
          green: [lg`Creature/Bite_01_Regular_Green_400x400.webm`],
          grey: [lg`Creature/Bite_01_Regular_Grey_400x400.webm`],
          orange: [lg`Creature/Bite_01_Regular_Orange_400x400.webm`],
          purple: [lg`Creature/Bite_01_Regular_Purple_400x400.webm`],
          yellow: [lg`Creature/Bite_01_Regular_Yellow_400x400.webm`]
        }
      },
      claw: {
        "01": {
          blue: [lg`Creature/Claws_01_Bright_Blue_400x400.webm`],
          brown: [lg`Creature/Claws_01_Regular_Brown_400x400.webm`],
          darkred: [lg`Creature/Claws_01_Dark_Red_400x400.webm`],
          green: [lg`Creature/Claws_01_Bright_Green_400x400.webm`],
          orange: [lg`Creature/Claws_01_Bright_Orange_400x400.webm`],
          purple: [lg`Creature/Claws_01_Bright_Purple_400x400.webm`],
          red: [lg`Creature/Claws_01_Regular_Red_400x400.webm`],
          yellow: [lg`Creature/Claws_01_Bright_Yellow_400x400.webm`]
        }
      }
    },
    generic: {
      "1hs": {
        "01": {
          white: [lg`Weapon_Attacks/Melee/DmgSlashing_01_Regular_Yellow_1Handed_800x600.webm`]
        }
      },
      "2hs": {
        "01": {
          white: [lg`Weapon_Attacks/Melee/DmgSlashing_01_Regular_Yellow_2Handed_800x600.webm`]
        }
      },
      "1hb": {
        "01": {
          white: [lg`Weapon_Attacks/Melee/DmgBludgeoning_01_Regular_Yellow_1Handed_800x600.webm`]
        }
      },
      "2hb": {
        "01": {
          white: [lg`Weapon_Attacks/Melee/DmgBludgeoning_01_Regular_Yellow_2Handed_800x600.webm`]
        }
      },
      "1hp": {
        "01": {
          white: [lg`Weapon_Attacks/Melee/DmgPiercing_01_Regular_Yellow_1Handed_800x600.webm`]
        }
      },
      "2hp": {
        "01": {
          white: [lg`Weapon_Attacks/Melee/DmgPiercing_01_Regular_Yellow_2Handed_800x600.webm`]
        }
      }
    },
    weapon: {
      club: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Club01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_06_Regular_White_800x600.webm`]
          ],
          blue: [
            [lg`Weapon_Attacks/Melee/Club01_01_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_02_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_03_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_04_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_05_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_06_Regular_Blue_800x600.webm`]
          ],
          orange: [
            [lg`Weapon_Attacks/Melee/Club01_01_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_02_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_03_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_04_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_05_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_06_Regular_Orange_800x600.webm`]
          ],
          purple: [
            [lg`Weapon_Attacks/Melee/Club01_01_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_02_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_03_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_04_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_05_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_06_Regular_Purple_800x600.webm`]
          ],
          darkorangepurple: [
            [lg`Weapon_Attacks/Melee/Club01_01_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_02_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_03_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_04_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_05_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_06_Dark_OrangePurple_800x600.webm`]
          ]
        }
      },
      dagger: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/Dagger02_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Regular_Green_800x600.webm`],
          darkpurple: [lg`Weapon_Attacks/Melee/Dagger02_Fire_Dark_Purple_800x600.webm`]
        }
      },
      falchion: {
        "01": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Dark_OrangePurple_800x600.webm`
          ],
          black: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Regular_Black_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Regular_White_800x600.webm`
          ]
        }
      },
      flurryofblows: {
        "magical": {
          darkred: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Dark_Red_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Dark_Red_Magical02_800x600.webm`
          ],
          darkpurple: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Dark_Purple_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Dark_Purple_Magical02_800x600.webm`
          ],
          blue: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Blue_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Blue_Magical02_800x600.webm`
          ],
          green: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Green_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Green_Magical02_800x600.webm`
          ],
          orange: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Orange_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Orange_Magical02_800x600.webm`
          ],
          purplepink: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_PinkPurple_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_PinkPurple_Magical02_800x600.webm`
          ],
          yellow: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Yellow_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Yellow_Magical02_800x600.webm`
          ]
        },
        "physical": {
          darkred: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Dark_Red_Physical01_800x600.webm`
          ],
          darkpurple: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Dark_Purple_Physical01_800x600.webm`
          ],
          blue: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Blue_Physical01_800x600.webm`
          ],
          green: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Green_Physical01_800x600.webm`
          ],
          orange: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Orange_Physical01_800x600.webm`
          ],
          purplepink: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_PinkPurple_Physical01_800x600.webm`
          ],
          yellow: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Yellow_Physical01_800x600.webm`
          ]
        },
        "nohit": {
          blue: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlowsNoHit_01_Regular_Blue_800x600.webm`
          ],
          yellow: [
            lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlowsNoHit_01_Regular_Yellow_800x600.webm`
          ]
        }
      },
      glaive: {
        "01": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Dark_OrangePurple_800x600.webm`
          ],
          black: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Regular_Black_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Regular_White_800x600.webm`
          ]
        },
        "02": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Glaive02_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_06_Dark_OrangePurple_800x600.webm`
          ],
          black: [
            lg`Weapon_Attacks/Melee/Glaive02_01_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_02_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_03_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_04_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_05_Regular_Black_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_06_Regular_Black_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Glaive02_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Glaive02_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Glaive02_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Glaive02_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive02_06_Regular_White_800x600.webm`
          ]
        }
      },
      greataxe: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/GreatAxe01_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/GreatAxe01_Fire_Regular_Green_800x600.webm`]
        }
      },
      greatclub: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/GreatClub01_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/GreatClub01_Fire_Regular_Green_800x600.webm`]
        }
      },
      greatsword: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/GreatSword01_01_Regular_White_800x600.webm`],
          black: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Black_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/GreatSword01_Fire_Regular_Green_800x600.webm`]
        }
      },
      halberd: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Halberd01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Halberd01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Halberd01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Halberd01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_06_Regular_Purple_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Halberd01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_06_Dark_OrangePurple_800x600.webm`
          ]
        }
      },
      hammer: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Hammer01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Hammer01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Hammer01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Hammer01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_06_Regular_Purple_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Hammer01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_06_Dark_OrangePurple_800x600.webm`
          ],
          yellow: [
            lg`Weapon_Attacks/Melee/Hammer01_01_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_02_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_03_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_04_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_05_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Hammer01_06_Regular_Yellow_800x600.webm`
          ]
        }
      },
      handaxe: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/HandAxe02_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/HandAxe02_Fire_Regular_Green_800x600.webm`]
        }
      },
      lasersword: {
        "01": {
          blue: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Blue_800x600.webm`],
          blue02: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Blue02_800x600.webm`],
          blue03: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Blue03_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Orange_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Yellow_800x600.webm`],
          darkred: [lg`Weapon_Attacks/Melee/LaserSword01_01_Dark_Red_800x600.webm`],
          darkwhite: [lg`Weapon_Attacks/Melee/LaserSword01_01_Dark_White_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Purple_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Green_800x600.webm`],
          green02: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Green02_800x600.webm`],
          white: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_White_800x600.webm`]
        }
      },
      mace: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/Legacy/Mace01_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/Mace01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/Mace01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/Mace01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/Mace01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/Mace01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/Mace01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/Mace01_Fire_Regular_Green_800x600.webm`]
        },
        "02": {
          white: [
            [lg`Weapon_Attacks/Melee/Mace01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_06_Regular_White_800x600.webm`]
          ],
          blue: [
            [lg`Weapon_Attacks/Melee/Mace01_01_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_02_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_03_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_04_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_05_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_06_Regular_Blue_800x600.webm`]
          ],
          orange: [
            [lg`Weapon_Attacks/Melee/Mace01_01_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_02_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_03_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_04_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_05_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_06_Regular_Orange_800x600.webm`]
          ],
          purple: [
            [lg`Weapon_Attacks/Melee/Mace01_01_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_02_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_03_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_04_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_05_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_06_Regular_Purple_800x600.webm`]
          ],
          darkorangepurple: [
            [lg`Weapon_Attacks/Melee/Mace01_01_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_02_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_03_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_04_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_05_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_06_Dark_OrangePurple_800x600.webm`]
          ]
        }
      },
      maul: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/Maul01_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/Maul01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/Maul01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/Maul01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/Maul01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/Maul01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/Maul01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/Maul01_Fire_Regular_Green_800x600.webm`]
        }
      },
      quarterstaff: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Quarterstaff01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Quarterstaff01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Quarterstaff01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Quarterstaff01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_06_Regular_Purple_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Quarterstaff01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff01_06_Dark_OrangePurple_800x600.webm`
          ]
        },
        "02": {
          white: [
            lg`Weapon_Attacks/Melee/Quarterstaff02_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Quarterstaff02_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Quarterstaff02_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Quarterstaff02_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_06_Regular_Purple_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Quarterstaff02_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff02_06_Dark_OrangePurple_800x600.webm`
          ]
        },
        "03": {
          white: [
            lg`Weapon_Attacks/Melee/Quarterstaff03_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Quarterstaff03_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Quarterstaff03_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Quarterstaff03_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_06_Regular_Purple_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Quarterstaff03_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff03_06_Dark_OrangePurple_800x600.webm`
          ]
        },
        "04": {
          white: [
            lg`Weapon_Attacks/Melee/Quarterstaff04_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Quarterstaff04_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Quarterstaff04_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Quarterstaff04_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_06_Regular_Purple_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Quarterstaff04_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Quarterstaff04_06_Dark_OrangePurple_800x600.webm`
          ]
        }
      },
      rapier: {
        fire: {
          white: [lg`Weapon_Attacks/Melee/Legacy/Rapier01_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/Rapier01_Fire_Regular_Green_800x600.webm`]
        },
        "01": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Rapier01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_06_Dark_OrangePurple_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Rapier01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Rapier01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Rapier01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Rapier01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_06_Regular_White_800x600.webm`
          ]
        }
      },
      scimitar: {
        "01": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Scimitar01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_06_Dark_OrangePurple_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Scimitar01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Scimitar01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Scimitar01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Scimitar01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_06_Regular_White_800x600.webm`
          ]
        }
      },
      shortsword: {
        "01": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Dark_OrangePurple_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Regular_White_800x600.webm`
          ],
          yellow: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Regular_Yellow_800x600.webm`
          ]
        }
      },
      spear: {
        "fire": {
          white: [lg`Weapon_Attacks/Melee/Legacy/Spear01_01_Regular_White_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/Spear01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/Spear01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/Spear01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/Spear01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/Spear01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/Spear01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/Spear01_Fire_Regular_Green_800x600.webm`]
        },
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Spear01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Regular_White_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Spear01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Spear01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Spear01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Regular_Purple_800x600.webm`
          ],
          yellow: [
            lg`Weapon_Attacks/Melee/Spear01_01_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Regular_Yellow_800x600.webm`
          ],
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Spear01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Dark_OrangePurple_800x600.webm`
          ]
        }
      },
      sword: {
        fire: {
          white: [lg`Weapon_Attacks/Melee/Legacy/Sword01_01_Regular_White_800x600.webm`],
          black: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Black_800x600.webm`],
          orange: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Orange_800x600.webm`],
          pink: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Pink_800x600.webm`],
          red: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Red_800x600.webm`],
          yellow: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Yellow_800x600.webm`],
          purple: [lg`Weapon_Attacks/Melee/Sword01_Fire_Dark_Purple_800x600.webm`],
          blue: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Blue_800x600.webm`],
          green: [lg`Weapon_Attacks/Melee/Sword01_Fire_Regular_Green_800x600.webm`]
        },
        "01": {
          darkorangepurple: [
            lg`Weapon_Attacks/Melee/Sword01_01_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Dark_OrangePurple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Dark_OrangePurple_800x600.webm`
          ],
          blue: [
            lg`Weapon_Attacks/Melee/Sword01_01_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Regular_Blue_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Regular_Blue_800x600.webm`
          ],
          orange: [
            lg`Weapon_Attacks/Melee/Sword01_01_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Regular_Orange_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Regular_Orange_800x600.webm`
          ],
          purple: [
            lg`Weapon_Attacks/Melee/Sword01_01_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Regular_Purple_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Regular_Purple_800x600.webm`
          ],
          white: [
            lg`Weapon_Attacks/Melee/Sword01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Regular_White_800x600.webm`
          ],
          yellow: [
            lg`Weapon_Attacks/Melee/Sword01_01_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Regular_Yellow_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Regular_Yellow_800x600.webm`
          ]
        }
      },
      unarmedstrike: {
        "magical": {
          darkred: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Red_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Red_Magical02_800x600.webm`
          ],
          darkpurple: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Purple_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Purple_Magical02_800x600.webm`
          ],
          blue: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Magical02_800x600.webm`
          ],
          green: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Green_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Green_Magical02_800x600.webm`
          ],
          orange: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Orange_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Orange_Magical02_800x600.webm`
          ],
          purplepink: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_PinkPurple_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_PinkPurple_Magical02_800x600.webm`
          ],
          yellow: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Yellow_Magical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Yellow_Magical02_800x600.webm`
          ]
        },
        "physical": {
          darkred: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Red_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Red_Physical02_800x600.webm`
          ],
          darkpurple: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Purple_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Dark_Purple_Physical02_800x600.webm`
          ],
          blue: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Physical02_800x600.webm`
          ],
          green: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Green_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Green_Physical02_800x600.webm`
          ],
          orange: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Orange_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Orange_Physical02_800x600.webm`
          ],
          purplepink: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_PinkPurple_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_PinkPurple_Physical02_800x600.webm`
          ],
          yellow: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Yellow_Physical01_800x600.webm`,
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Yellow_Physical02_800x600.webm`
          ]
        },
        "nohit": {
          blue: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrikeNoHit_01_Regular_Blue_800x600.webm`
          ],
          yellow: [
            lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrikeNoHit_01_Regular_Yellow_800x600.webm`
          ]
        }
      },
      warhammer: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Warhammer01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_06_Regular_White_800x600.webm`]
          ],
          blue: [
            [lg`Weapon_Attacks/Melee/Warhammer01_01_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_02_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_03_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_04_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_05_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_06_Regular_Blue_800x600.webm`]
          ],
          orange: [
            [lg`Weapon_Attacks/Melee/Warhammer01_01_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_02_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_03_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_04_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_05_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_06_Regular_Orange_800x600.webm`]
          ],
          purple: [
            [lg`Weapon_Attacks/Melee/Warhammer01_01_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_02_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_03_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_04_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_05_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_06_Regular_Purple_800x600.webm`]
          ],
          darkorangepurple: [
            [lg`Weapon_Attacks/Melee/Warhammer01_01_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_02_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_03_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_04_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_05_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_06_Dark_OrangePurple_800x600.webm`]
          ]
        }
      },
      wrench: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Wrench01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_06_Regular_White_800x600.webm`]
          ],
          blue: [
            [lg`Weapon_Attacks/Melee/Wrench01_01_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_02_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_03_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_04_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_05_Regular_Blue_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_06_Regular_Blue_800x600.webm`]
          ],
          orange: [
            [lg`Weapon_Attacks/Melee/Wrench01_01_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_02_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_03_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_04_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_05_Regular_Orange_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_06_Regular_Orange_800x600.webm`]
          ],
          purple: [
            [lg`Weapon_Attacks/Melee/Wrench01_01_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_02_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_03_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_04_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_05_Regular_Purple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_06_Regular_Purple_800x600.webm`]
          ],
          darkorangepurple: [
            [lg`Weapon_Attacks/Melee/Wrench01_01_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_02_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_03_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_04_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_05_Dark_OrangePurple_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_06_Dark_OrangePurple_800x600.webm`]
          ]
        }
      }
    }
  };
  JB2APATREONDB.templatefx = {
    circle: {
      armsofhadar: {
        "01": {
          darkgreen: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Green_500x500.webm`],
          darkpurple: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Purple_500x500.webm`],
          darkred: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Red_500x500.webm`]
        }
      },
      blacktentacles: {
        "01": {
          darkgreen: [l4`Black_Tentacles/BlackTentacles_01_Dark_Green_600x600.webm`],
          darkpurple: [l4`Black_Tentacles/BlackTentacles_01_Dark_Purple_600x600.webm`],
          darkred: [l4`Black_Tentacles/BlackTentacles_01_Dark_Red_600x600.webm`]
        }
      },
      calllightning: {
        "01": {
          blue: [l3`Call_Lightning/CallLightning_01_Blue_1000x1000.webm`],
          blueorange: [l3`Call_Lightning/CallLightning_01_BlueOrange_1000x1000.webm`],
          green: [l3`Call_Lightning/CallLightning_01_Green_1000x1000.webm`],
          pinkyellow: [l3`Call_Lightning/CallLightning_01_PinkYellow_1000x1000.webm`],
          purple: [l3`Call_Lightning/CallLightning_01_Purple_1000x1000.webm`],
          red: [l3`Call_Lightning/CallLightning_01_Red_1000x1000.webm`],
          yellow: [l3`Call_Lightning/CallLightning_01_Yellow_1000x1000.webm`]
        }
      },
      cloudofdaggers: {
        "01": {
          darkpurple: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Dark_Purple_400x400.webm`],
          darkred: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Dark_Red_400x400.webm`],
          blue: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Blue_400x400.webm`],
          green: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Green_400x400.webm`],
          orange: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Orange_400x400.webm`],
          purple: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Purple_400x400.webm`],
          red: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Red_400x400.webm`],
          yellow: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Yellow_400x400.webm`]
        },
        kunai: {
          darkpurple: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Dark_Purple_400x400.webm`],
          darkred: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Dark_Red_400x400.webm`],
          blue: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Blue_400x400.webm`],
          green: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Green_400x400.webm`],
          orange: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Orange_400x400.webm`],
          purple: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Purple_400x400.webm`],
          red: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Red_400x400.webm`],
          yellow: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Yellow_400x400.webm`]
        }
      },
      crackedshield: {
        "01": {
          darkred: [lg`Template/Circle/TemplateShieldCrackedCircle_01_Dark_Red_800x800.webm`],
          darkpurple: [lg`Template/Circle/TemplateShieldCrackedCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      darkness: {
        "01": {
          black: [l2`Darkness/Darkness_01_Black_600x600.webm`],
          green: [l2`Darkness/Darkness_01_Green_600x600.webm`]
        }
      },
      detectmagic: {
        "01": {
          blue: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Blue_1200x1200.webm`],
          green: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Green_1200x1200.webm`],
          greenorange: [l1`Detect_Magic/DetectMagicCircle_01_Regular_GreenOrange_1200x1200.webm`],
          grey: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Grey_1200x1200.webm`],
          purple: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Purple_1200x1200.webm`]
        }
      },
      drop: {
        "01": {
          darkgreen: [lg`Template/Circle/TemplateDropCircle_01_Dark_Green_800x800.webm`],
          red: [lg`Template/Circle/TemplateDropCircle_01_Regular_Red_800x800.webm`]
        }
      },
      explosion: {
        "01": {
          darkpurple: [
            lg`Explosion/Explosion_04_Dark_Purple_400x400.webm`
          ],
          darkred: [
            lg`Explosion/Explosion_04_Dark_Red_400x400.webm`
          ],
          blue: [
            lg`Explosion/Explosion_01_Blue_400x400.webm`,
            lg`Explosion/Explosion_02_Blue_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Blue_400x400.webm`
          ],
          green: [
            lg`Explosion/Explosion_01_Green_400x400.webm`,
            lg`Explosion/Explosion_02_Green_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Green_400x400.webm`
          ],
          greenorange: [
            lg`Explosion/Explosion_03_Regular_GreenOrange_400x400.webm`
          ],
          orange: [
            lg`Explosion/Explosion_01_Orange_400x400.webm`,
            lg`Explosion/Explosion_02_Orange_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Orange_400x400.webm`
          ],
          pink: [
            lg`Explosion/Explosion_03_Regular_Pink_400x400.webm`
          ],
          purplepink: [
            lg`Explosion/Explosion_03_Regular_PurplePink_400x400.webm`
          ],
          purple: [
            lg`Explosion/Explosion_01_Purple_400x400.webm`,
            lg`Explosion/Explosion_02_Purple_400x400.webm`
          ],
          red: [
            lg`Explosion/Explosion_03_Regular_Red_400x400.webm`
          ],
          yellow: [
            lg`Explosion/Explosion_01_Yellow_400x400.webm`,
            lg`Explosion/Explosion_02_Yellow_400x400.webm`
          ],
          yellowblue: [
            lg`Explosion/Explosion_03_Regular_BlueYellow_400x400.webm`
          ],
          whiteblue: [
            lg`Explosion/Explosion_03_Dark_BlueWhite_400x400.webm`
          ]
        }
      },
      fear: {
        "01": {
          darkorange: [lg`Template/Circle/TemplateFearCircle_01_Dark_Orange_800x800.webm`],
          darkpurple: [lg`Template/Circle/TemplateFearCircle_01_Dark_Purple_800x800.webm`],
          orange: [lg`Template/Circle/TemplateFearCircle_01_Regular_Orange_800x800.webm`]
        }
      },
      fireball: {
        loop: {
          blue: [l3`Fireball/FireballLoop_01_Blue_800x800.webm`],
          orange: [l3`Fireball/FireballLoop_01_Orange_800x800.webm`],
          purple: [l3`Fireball/FireballLoop_01_Purple_800x800.webm`]
        },
        explode: {
          blue: [l3`Fireball/FireballExplosion_01_Blue_800x800.webm`],
          orange: [l3`Fireball/FireballExplosion_01_Orange_800x800.webm`],
          purple: [l3`Fireball/FireballExplosion_01_Purple_800x800.webm`]
        },
        nodebris: {
          blue: [l3`Fireball/FireballLoopNoDebris_01_Blue_800x800.webm`],
          orange: [l3`Fireball/FireballLoopNoDebris_01_Orange_800x800.webm`],
          purple: [l3`Fireball/FireballLoopNoDebris_01_Purple_800x800.webm`]
        }
      },
      fogcloud: {
        "01": {
          white: [l1`Fog_Cloud/FogCloud_01_White_800x800.webm`]
        },
        "02": {
          white: [l1`Fog_Cloud/FogCloud_02_Regular_White_800x800.webm`],
          green: [l1`Fog_Cloud/FogCloud_02_Regular_Green_800x800.webm`]
        }
      },
      heart: {
        "01": {
          darkred: [lg`Template/Circle/TemplateHeartCircle_01_Dark_Red_800x800.webm`],
          pink: [lg`Template/Circle/TemplateHeartCircle_01_Regular_Pink_800x800.webm`],
          teal: [lg`Template/Circle/TemplateHeartCircle_01_Regular_Teal_800x800.webm`]
        }
      },
      horror: {
        "01": {
          darkteal: [lg`Template/Circle/TemplateHorrorCircle_01_Dark_Teal_800x800.webm`],
          purple: [lg`Template/Circle/TemplateHorrorCircle_01_Regular_Purple_800x800.webm`],
          teal: [lg`Template/Circle/TemplateHorrorCircle_01_Regular_Teal_800x800.webm`]
        }
      },
      magicsign: {
        abjuration: {
          blue: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        conjuration: {
          blue: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        divination: {
          blue: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        enchantment: {
          blue: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        evocation: {
          blue: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        illusion: {
          blue: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        necromancy: {
          blue: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        transmutation: {
          blue: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Yellow_800x800.webm`]
        }
      },
      moonbeam: {
        loop: {
          blue: [l2`Moonbeam/Moonbeam_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/Moonbeam_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/Moonbeam_01_Regular_Rainbow_400x400.webm`]
        },
        nopulse: {
          blue: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Rainbow_400x400.webm`]
        },
        intro: {
          blue: [l2`Moonbeam/MoonbeamIntro_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/MoonbeamIntro_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/MoonbeamIntro_01_Regular_Rainbow_400x400.webm`]
        },
        outro: {
          blue: [l2`Moonbeam/MoonbeamOutro_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/MoonbeamOutro_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/MoonbeamOutro_01_Regular_Rainbow_400x400.webm`]
        }
      },
      musicnote: {
        "01": {
          blue: [lg`Template/Circle/TemplateMusicNoteCircle_01_Regular_Blue_800x800.webm`],
          darkred: [lg`Template/Circle/TemplateMusicNoteCircle_01_Dark_Red_800x800.webm`],
          purple: [lg`Template/Circle/TemplateMusicNoteCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      outpulse: {
        "01": {
          whiteblue: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_TealYellow_Burst_600x600.webm`]
        },
        "02": {
          whiteblue: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_TealYellow_Burst_600x600.webm`]
        }
      },
      poison: {
        "01": {
          darkgreen: [lg`Template/Circle/TemplatePoisonCircle_01_Dark_Green_800x800.webm`],
          purple: [lg`Template/Circle/TemplatePoisonCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      runes: {
        "01": {
          darkorange: [lg`Template/Circle/TemplateRunesCircle_01_Dark_Orange_800x800.webm`],
          darkred: [lg`Template/Circle/TemplateRunesCircle_01_Dark_Red_800x800.webm`],
          blue: [lg`Template/Circle/TemplateRunesCircle_01_Regular_Blue_800x800.webm`],
          green: [lg`Template/Circle/TemplateRunesCircle_01_Regular_Green02_800x800.webm`],
          orange: [lg`Template/Circle/TemplateRunesCircle_01_Regular_Orange_800x800.webm`]
        }
      },
      shatter: {
        "01": {
          purple: [l2`Shatter/Shatter_01_Purple_400x400.webm`],
          red: [l2`Shatter/Shatter_01_Red_400x400.webm`],
          blue: [l2`Shatter/Shatter_01_Blue_400x400.webm`],
          green: [l2`Shatter/Shatter_01_Green_400x400.webm`],
          orange: [l2`Shatter/Shatter_01_Orange_400x400.webm`]
        }
      },
      shields: {
        "01": {
          darkred: [lg`Template/Circle/TemplateShieldCircle_01_Dark_Red_800x800.webm`],
          green: [lg`Template/Circle/TemplateShieldCircle_01_Regular_Green_800x800.webm`]
        }
      },
      skull: {
        "01": {
          darkgreen: [lg`Template/Circle/TemplateSkullCircle_01_Dark_Green_800x800.webm`],
          darkorange: [lg`Template/Circle/TemplateSkullCircle_01_Dark_Orange_800x800.webm`],
          purple: [lg`Template/Circle/TemplateSkullCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      sleetstorm: {
        "01": {
          blue: [l3`Sleet_Storm/SleetStorm_01_Blue_800x800.webm`],
          green: [l3`Sleet_Storm/SleetStorm_01_Green_800x800.webm`],
          purple: [l3`Sleet_Storm/SleetStorm_01_Purple_800x800.webm`],
          tealyellow: [l3`Sleet_Storm/SleetStorm_01_TealYellow_800x800.webm`]
        }
      },
      snowflakes: {
        "01": {
          darkblue: [lg`Template/Circle/TemplateSnowflakeCircle_01_Dark_Blue_800x800.webm`],
          blue: [lg`Template/Circle/TemplateSnowflakeCircle_01_Regular_Blue_800x800.webm`]
        }
      },
      stun: {
        "01": {
          darkteal: [lg`Template/Circle/TemplateStunCircle_01_Dark_Teal_800x800.webm`],
          purple: [lg`Template/Circle/TemplateStunCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      snowflake: {
        "01": {
          whiteblue: [lg`Ice/SnowflakeBurst_01_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Ice/SnowflakeBurst_01_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Ice/SnowflakeBurst_01_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Ice/SnowflakeBurst_01_Regular_TealYellow_Burst_600x600.webm`]
        }
      },
      vortex: {
        loop: {
          black: [lg`Template/Circle/Vortex_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/Vortex_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/Vortex_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/Vortex_01_Regular_Purple_600x600.webm`]
        },
        intro: {
          black: [lg`Template/Circle/VortexIntro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/VortexIntro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/VortexIntro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/VortexIntro_01_Regular_Purple_600x600.webm`]
        },
        outro: {
          black: [lg`Template/Circle/VortexOutro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/VortexOutro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/VortexOutro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/VortexOutro_01_Regular_Purple_600x600.webm`]
        }
      },
      whirl: {
        loop: {
          black: [lg`Template/Circle/Whirl_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/Whirl_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/Whirl_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/Whirl_01_Regular_Purple_600x600.webm`]
        },
        intro: {
          black: [lg`Template/Circle/WhirlIntro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/WhirlIntro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/WhirlIntro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/WhirlIntro_01_Regular_Purple_600x600.webm`]
        },
        outro: {
          black: [lg`Template/Circle/WhirlOutro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/WhirlOutro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/WhirlOutro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/WhirlOutro_01_Regular_Purple_600x600.webm`]
        }
      }
    },
    cone: {
      breathweapon: {
        "cold": {
          blue: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Cold01_Regular_Blue_30ft_Cone_Burst_600x600.webm`],
          green: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Cold01_Regular_Green_30ft_Cone_Burst_600x600.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Cold01_Regular_Orange_30ft_Cone_Burst_600x600.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Cold01_Regular_Purple_30ft_Cone_Burst_600x600.webm`]
        },
        "fire01": {
          blue: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_Blue_30ft_Cone_Burst_600x600.webm`],
          green: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_Green_30ft_Cone_Burst_600x600.webm`],
          multi: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_MultiColor01_30ft_Cone_Burst_600x600.webm`],
          multi02: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_MultiColor02_30ft_Cone_Burst_600x600.webm`],
          multi03: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_MultiColor03_30ft_Cone_Burst_600x600.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_Orange_30ft_Cone_Burst_600x600.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_Purple_30ft_Cone_Burst_600x600.webm`],
          yellow: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_Yellow_30ft_Cone_Burst_600x600.webm`]
        },
        "fire02": {
          blue: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_Blue_30ft_Cone_Burst_600x600.webm`],
          green: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_Green_30ft_Cone_Burst_600x600.webm`],
          multi: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_MultiColor01_30ft_Cone_Burst_600x600.webm`],
          multi02: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_MultiColor02_30ft_Cone_Burst_600x600.webm`],
          multi03: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_MultiColor03_30ft_Cone_Burst_600x600.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_Orange_30ft_Cone_Burst_600x600.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_Purple_30ft_Cone_Burst_600x600.webm`],
          yellow: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire02_Regular_Yellow_30ft_Cone_Burst_600x600.webm`]
        },
        "poison": {
          black: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Dark_Black_30ft_Cone_Burst_600x600.webm`],
          blue: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Regular_Blue_30ft_Cone_Burst_600x600.webm`],
          darkred: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Dark_Red_30ft_Cone_Burst_600x600.webm`],
          green: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Regular_Green_30ft_Cone_Burst_600x600.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Regular_Orange_30ft_Cone_Burst_600x600.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Regular_Purple_30ft_Cone_Burst_600x600.webm`]
        }
      },
      breathweaponspray01: {
        burst: {
          green: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire01_Regular_Green_Cone_Burst_800x800.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire01_Regular_Orange_Cone_Burst_800x800.webm`],
          yellow: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Holy01_Regular_Yellow_Cone_Burst_800x800.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana01_Regular_Purple_Cone_Burst_800x800.webm`]
        },
        loop: {
          green: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire01_Regular_Green_Cone_Loop_800x800.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire01_Regular_Orange_Cone_Loop_800x800.webm`],
          yellow: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Holy01_Regular_Yellow_Cone_Loop_800x800.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana01_Regular_Purple_Cone_Loop_800x800.webm`]
        }
      },
      breathweaponspray02: {
        burst: {
          green: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire02_Regular_Green_Cone_Burst_800x800.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire02_Regular_Orange_Cone_Burst_800x800.webm`],
          yellow: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Holy02_Regular_Yellow_Cone_Burst_800x800.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana02_Regular_Purple_Cone_Burst_800x800.webm`]
        },
        loop: {
          green: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire02_Regular_Green_Cone_Loop_800x800.webm`],
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire02_Regular_Orange_Cone_Loop_800x800.webm`],
          yellow: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Holy02_Regular_Yellow_Cone_Loop_800x800.webm`],
          purple: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana02_Regular_Purple_Cone_Loop_800x800.webm`]
        }
      },
      coneofcold: {
        "01": {
          blue: [l5`Cone_Of_Cold/ConeOfCold_01_Regular_Blue_600x600.webm`],
          green: [l5`Cone_Of_Cold/ConeOfCold_01_Regular_Green_600x600.webm`],
          orange: [l5`Cone_Of_Cold/ConeOfCold_01_Regular_Orange_600x600.webm`],
          purple: [l5`Cone_Of_Cold/ConeOfCold_01_Regular_Purple_600x600.webm`]
        }
      },
      burninghands: {
        "01": {
          blue: [l1`Burning_Hands/BurningHands_01_Regular_Blue_600x600.webm`],
          green: [l1`Burning_Hands/BurningHands_01_Regular_Green_600x600.webm`],
          orange: [l1`Burning_Hands/BurningHands_01_Regular_Orange_600x600.webm`],
          purple: [l1`Burning_Hands/BurningHands_01_Regular_Purple_600x600.webm`]
        },
        "02": {
          blue: [l1`Burning_Hands/BurningHands_02_Regular_Blue_600x600.webm`],
          green: [l1`Burning_Hands/BurningHands_02_Regular_Green_600x600.webm`],
          orange: [l1`Burning_Hands/BurningHands_02_Regular_Orange_600x600.webm`],
          purple: [l1`Burning_Hands/BurningHands_02_Regular_Purple_600x600.webm`]
        }
      }
    },
    square: {
      armsofhadar: {
        "01": {
          darkgreen: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Green_500x500.webm`],
          darkpurple: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Purple_500x500.webm`],
          darkred: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Red_500x500.webm`]
        }
      },
      blacktentacles: {
        "01": {
          darkgreen: [l4`Black_Tentacles/BlackTentacles_01_Dark_Green_600x600.webm`],
          darkpurple: [l4`Black_Tentacles/BlackTentacles_01_Dark_Purple_600x600.webm`],
          darkred: [l4`Black_Tentacles/BlackTentacles_01_Dark_Red_600x600.webm`]
        }
      },
      crackedshield: {
        "01": {
          darkred: [lg`Template/Square/TemplateShieldCrackedSquare_01_Dark_Red_600x600.webm`],
          darkpurple: [lg`Template/Square/TemplateShieldCrackedSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      drop: {
        "01": {
          darkgreen: [lg`Template/Square/TemplateDropSquare_01_Dark_Green_600x600.webm`],
          red: [lg`Template/Square/TemplateDropSquare_01_Regular_Red_600x600.webm`]
        }
      },
      entangle: {
        "01": {
          brown: [l1`Entangle/Entangle_01_Brown_400x400.webm`],
          green: [l1`Entangle/Entangle_01_Green_400x400.webm`],
          yellow: [l1`Entangle/Entangle_01_Yellow_400x400.webm`],
          darkpurple: [l1`Entangle/Entangle_01_Dark_Purple_400x400.webm`],
          palegreen: [l1`Entangle/Entangle_01_Regular_Green02_400x400.webm`]
        }
      },
      fear: {
        "01": {
          darkorange: [lg`Template/Square/TemplateFearSquare_01_Dark_Orange_600x600.webm`],
          darkpurple: [lg`Template/Square/TemplateFearSquare_01_Dark_Purple_600x600.webm`],
          orange: [lg`Template/Square/TemplateFearSquare_01_Regular_Orange_600x600.webm`]
        }
      },
      grease: {
        "01": {
          brown: [l1`Grease/Grease_Dark_Brown_600x600.webm`],
          green: [l1`Grease/Grease_Dark_Green_600x600.webm`],
          grey: [l1`Grease/Grease_Dark_Grey_600x600.webm`],
          purple: [l1`Grease/Grease_Dark_Purple_600x600.webm`]
        }
      },
      heart: {
        "01": {
          darkred: [lg`Template/Square/TemplateHeartSquare_01_Dark_Red_600x600.webm`],
          pink: [lg`Template/Square/TemplateHeartSquare_01_Regular_Pink_600x600.webm`],
          teal: [lg`Template/Square/TemplateHeartSquare_01_Regular_Teal_600x600.webm`]
        }
      },
      horror: {
        "01": {
          darkteal: [lg`Template/Square/TemplateHorrorSquare_01_Dark_Teal_600x600.webm`],
          purple: [lg`Template/Square/TemplateHorrorSquare_01_Regular_Purple_600x600.webm`],
          teal: [lg`Template/Square/TemplateHorrorSquare_01_Regular_Teal_600x600.webm`]
        }
      },
      musicnote: {
        "01": {
          blue: [lg`Template/Square/TemplateMusicNoteSquare_01_Regular_Blue_600x600.webm`],
          darkred: [lg`Template/Square/TemplateMusicNoteSquare_01_Dark_Red_600x600.webm`],
          purple: [lg`Template/Square/TemplateMusicNoteSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      poison: {
        "01": {
          darkgreen: [lg`Template/Square/TemplatePoisonSquare_01_Dark_Green_600x600.webm`],
          purple: [lg`Template/Square/TemplatePoisonSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      runes: {
        "01": {
          darkorange: [lg`Template/Square/TemplateRunesSquare_01_Dark_Orange_600x600.webm`],
          darkred: [lg`Template/Square/TemplateRunesSquare_01_Dark_Red_600x600.webm`],
          blue: [lg`Template/Square/TemplateRunesSquare_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Square/TemplateRunesSquare_01_Regular_Green02_600x600.webm`],
          orange: [lg`Template/Square/TemplateRunesSquare_01_Regular_Orange_600x600.webm`]
        }
      },
      shields: {
        "01": {
          darkred: [lg`Template/Square/TemplateShieldSquare_01_Dark_Red_600x600.webm`],
          green: [lg`Template/Square/TemplateShieldSquare_01_Regular_Green_600x600.webm`]
        }
      },
      snowflakes: {
        "01": {
          darkblue: [lg`Template/Square/TemplateSnowflakeSquare_01_Dark_Blue_600x600.webm`],
          blue: [lg`Template/Square/TemplateSnowflakeSquare_01_Regular_Blue_600x600.webm`]
        }
      },
      skull: {
        "01": {
          darkgreen: [lg`Template/Square/TemplateSkullSquare_01_Dark_Green_600x600.webm`],
          darkorange: [lg`Template/Square/TemplateSkullSquare_01_Dark_Orange_600x600.webm`],
          purple: [lg`Template/Square/TemplateSkullSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      stun: {
        "01": {
          darkteal: [lg`Template/Square/TemplateStunSquare_01_Dark_Teal_600x600.webm`],
          purple: [lg`Template/Square/TemplateStunSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      thunderwave: {
        left: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BLeft_600x600.webm`],
          green: [l1`Thunderwave/Thunderwave_01_Bright_Green_BLeft_600x600.webm`],
          orange: [l1`Thunderwave/Thunderwave_01_Bright_Orange_BLeft_600x600.webm`],
          purple: [l1`Thunderwave/Thunderwave_01_Dark_Purple_BLeft_600x600.webm`],
          red: [l1`Thunderwave/Thunderwave_01_Dark_Red_BLeft_600x600.webm`]
        },
        mid: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BMid_600x600.webm`],
          green: [l1`Thunderwave/Thunderwave_01_Bright_Green_BMid_600x600.webm`],
          orange: [l1`Thunderwave/Thunderwave_01_Bright_Orange_BMid_600x600.webm`],
          purple: [l1`Thunderwave/Thunderwave_01_Dark_Purple_BMid_600x600.webm`],
          red: [l1`Thunderwave/Thunderwave_01_Dark_Red_BMid_600x600.webm`]
        },
        center: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_Center_600x600.webm`],
          green: [l1`Thunderwave/Thunderwave_01_Bright_Green_Center_600x600.webm`],
          orange: [l1`Thunderwave/Thunderwave_01_Bright_Orange_Center_600x600.webm`],
          purple: [l1`Thunderwave/Thunderwave_01_Dark_Purple_Center_600x600.webm`],
          red: [l1`Thunderwave/Thunderwave_01_Dark_Red_Center_600x600.webm`]
        }
      },
      web: {
        "01": {
          white: [l2`Web/Web_01_White_01_400x400.webm`]
        },
        "02": {
          white: [l2`Web/Web_01_White_02_400x400.webm`]
        }
      }
    },
    ray: {
      breathweapon: {
        acid: {
          blue: [lg`Template/Line/Breath_Weapon/BreathWeapon_Acid01_Regular_Blue_30ft_Line_Burst_1200x200.webm`],
          green: [lg`Template/Line/Breath_Weapon/BreathWeapon_Acid01_Regular_Green_30ft_Line_Burst_1200x200.webm`],
          orange: [lg`Template/Line/Breath_Weapon/BreathWeapon_Acid01_Regular_Orange_30ft_Line_Burst_1200x200.webm`],
          purple: [lg`Template/Line/Breath_Weapon/BreathWeapon_Acid01_Regular_Purple_30ft_Line_Burst_1200x200.webm`]
        },
        fire: {
          blue: [lg`Template/Line/Breath_Weapon/BreathWeapon_Fire01_Regular_Blue_30ft_Line_Burst_1200x200.webm`],
          green: [lg`Template/Line/Breath_Weapon/BreathWeapon_Fire01_Regular_Green_30ft_Line_Burst_1200x200.webm`],
          orange: [lg`Template/Line/Breath_Weapon/BreathWeapon_Fire01_Regular_Orange_30ft_Line_Burst_1200x200.webm`],
          purple: [lg`Template/Line/Breath_Weapon/BreathWeapon_Fire01_Regular_Purple_30ft_Line_Burst_1200x200.webm`]
        },
        lightning: {
          blue: [lg`Template/Line/Breath_Weapon/BreathWeapon_Lightning01_Regular_Blue_30ft_Line_Burst_1200x200.webm`],
          green: [lg`Template/Line/Breath_Weapon/BreathWeapon_Lightning01_Regular_Green_30ft_Line_Burst_1200x200.webm`],
          orange: [lg`Template/Line/Breath_Weapon/BreathWeapon_Lightning01_Regular_Orange_30ft_Line_Burst_1200x200.webm`],
          purple: [lg`Template/Line/Breath_Weapon/BreathWeapon_Lightning01_Regular_Purple_30ft_Line_Burst_1200x200.webm`]
        }
      },
      breathweaponspray01: {
        burst: {
          green: [lg`Template/Line/Breath_Weapon/Breathweapon02_Fire01_Regular_Green_Line_Burst_1200x400.webm`],
          orange: [lg`Template/Line/Breath_Weapon/Breathweapon02_Fire01_Regular_Orange_Line_Burst_1200x400.webm`],
          yellow: [lg`Template/Line/Breath_Weapon/Breathweapon02_Holy01_Regular_Yellow_Line_Burst_1200x400.webm`],
          purple: [lg`Template/Line/Breath_Weapon/Breathweapon02_Arcana01_Regular_Purple_Line_Burst_1200x400.webm`]
        },
        loop: {
          green: [lg`Template/Line/Breath_Weapon/Breathweapon02_Fire01_Regular_Green_Line_Loop_1200x400.webm`],
          orange: [lg`Template/Line/Breath_Weapon/Breathweapon02_Fire01_Regular_Orange_Line_Loop_1200x400.webm`],
          yellow: [lg`Template/Line/Breath_Weapon/Breathweapon02_Holy01_Regular_Yellow_Line_Loop_1200x400.webm`],
          purple: [lg`Template/Line/Breath_Weapon/Breathweapon02_Arcana01_Regular_Purple_Line_Loop_1200x400.webm`]
        }
      },
      lightningbolt: {
        "01": {
          darkblue: [l3`Lightning_Bolt/LightningBolt_01_Dark_Blue_4000x200.webm`],
          blue: [l3`Lightning_Bolt/LightningBolt_01_Regular_Blue_4000x200.webm`],
          green: [l3`Lightning_Bolt/LightningBolt_01_Regular_Green_4000x200.webm`],
          orange: [l3`Lightning_Bolt/LightningBolt_01_Regular_Orange_4000x200.webm`],
          purple: [l3`Lightning_Bolt/LightningBolt_01_Regular_Purple_4000x200.webm`],
          red: [l3`Lightning_Bolt/LightningBolt_01_Regular_Red_4000x200.webm`]
        },
        "02": {
          darkblue: [l3`Lightning_Bolt/LightningBolt_01_Dark_Blue_4000x400.webm`],
          blue: [l3`Lightning_Bolt/LightningBolt_01_Regular_Blue_4000x400.webm`],
          green: [l3`Lightning_Bolt/LightningBolt_01_Regular_Green_4000x400.webm`],
          orange: [l3`Lightning_Bolt/LightningBolt_01_Regular_Orange_4000x400.webm`],
          purple: [l3`Lightning_Bolt/LightningBolt_01_Regular_Purple_4000x400.webm`],
          red: [l3`Lightning_Bolt/LightningBolt_01_Regular_Red_4000x400.webm`]
        }
      },
      gustofwind: {
        slow: {
          white: [l2`Gust_Of_Wind/GustOfWind_01_White_1200x200.webm`]
        },
        fast: {
          white: [l2`Gust_Of_Wind/GustOfWind_01_White_VeryFast_1200x200.webm`]
        }
      }
    }
  };
  JB2APATREONDB.static = {
    chains: {
      diamond: {
        "01": {
          blue: [lg`Marker/MarkerChainDiamond01_01_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainDiamond01_01_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainDiamond01_01_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainDiamond01_01_Regular_Yellow_Loop_400x400.webm`]
        },
        complete: {
          _markers: {
            loop: { start: 2033, end: 7e3 },
            forcedEnd: 7933
          },
          blue: [lg`Marker/MarkerChainDiamond01_02_Regular_Blue_Complete_400x400.webm`],
          purple: [lg`Marker/MarkerChainDiamond01_02_Regular_Purple_Complete_400x400.webm`],
          red: [lg`Marker/MarkerChainDiamond01_02_Regular_Red_Complete_400x400.webm`],
          yellow: [lg`Marker/MarkerChainDiamond01_02_Regular_Yellow_Complete_400x400.webm`]
        },
        loop: {
          blue: [lg`Marker/MarkerChainDiamond01_02_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainDiamond01_02_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainDiamond01_02_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainDiamond01_02_Regular_Yellow_Loop_400x400.webm`]
        }
      },
      spike: {
        "01": {
          blue: [lg`Marker/MarkerChainSpike01_01_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainSpike01_01_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainSpike01_01_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainSpike01_01_Regular_Yellow_Loop_400x400.webm`]
        },
        complete: {
          _markers: {
            loop: { start: 2033, end: 7e3 },
            forcedEnd: 7933
          },
          blue: [lg`Marker/MarkerChainSpike01_02_Regular_Blue_Complete_400x400.webm`],
          purple: [lg`Marker/MarkerChainSpike01_02_Regular_Purple_Complete_400x400.webm`],
          red: [lg`Marker/MarkerChainSpike01_02_Regular_Red_Complete_400x400.webm`],
          yellow: [lg`Marker/MarkerChainSpike01_02_Regular_Yellow_Complete_400x400.webm`]
        },
        loop: {
          blue: [lg`Marker/MarkerChainSpike01_02_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainSpike01_02_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainSpike01_02_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainSpike01_02_Regular_Yellow_Loop_400x400.webm`]
        }
      },
      square: {
        "01": {
          blue: [lg`Marker/MarkerChainSquare01_01_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainSquare01_01_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainSquare01_01_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainSquare01_01_Regular_Yellow_Loop_400x400.webm`]
        },
        complete: {
          _markers: {
            loop: { start: 2033, end: 7e3 },
            forcedEnd: 7933
          },
          blue: [lg`Marker/MarkerChainSquare01_02_Regular_Blue_Complete_400x400.webm`],
          purple: [lg`Marker/MarkerChainSquare01_02_Regular_Purple_Complete_400x400.webm`],
          red: [lg`Marker/MarkerChainSquare01_02_Regular_Red_Complete_400x400.webm`],
          yellow: [lg`Marker/MarkerChainSquare01_02_Regular_Yellow_Complete_400x400.webm`]
        },
        loop: {
          blue: [lg`Marker/MarkerChainSquare01_02_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainSquare01_02_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainSquare01_02_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainSquare01_02_Regular_Yellow_Loop_400x400.webm`]
        }
      },
      standard: {
        "01": {
          blue: [lg`Marker/MarkerChainStandard01_01_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainStandard01_01_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainStandard01_01_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainStandard01_01_Regular_Yellow_Loop_400x400.webm`]
        },
        complete: {
          _markers: {
            loop: { start: 2033, end: 7e3 },
            forcedEnd: 7933
          },
          blue: [lg`Marker/MarkerChainStandard01_02_Regular_Blue_Complete_400x400.webm`],
          purple: [lg`Marker/MarkerChainStandard01_02_Regular_Purple_Complete_400x400.webm`],
          red: [lg`Marker/MarkerChainStandard01_02_Regular_Red_Complete_400x400.webm`],
          yellow: [lg`Marker/MarkerChainStandard01_02_Regular_Yellow_Complete_400x400.webm`]
        },
        loop: {
          blue: [lg`Marker/MarkerChainStandard01_02_Regular_Blue_Loop_400x400.webm`],
          purple: [lg`Marker/MarkerChainStandard01_02_Regular_Purple_Loop_400x400.webm`],
          red: [lg`Marker/MarkerChainStandard01_02_Regular_Red_Loop_400x400.webm`],
          yellow: [lg`Marker/MarkerChainStandard01_02_Regular_Yellow_Loop_400x400.webm`]
        }
      }
    },
    conditions: {
      drop: {
        "01": {
          green: [lg`Marker/MarkerDrop_01_Dark_Green_400x400.webm`],
          red: [lg`Marker/MarkerDrop_01_Regular_Red_400x400.webm`]
        },
        "02": {
          green: [lg`Marker/MarkerDrop_02_Dark_Green_400x400.webm`],
          red: [lg`Marker/MarkerDrop_02_Regular_Red_400x400.webm`]
        },
        "03": {
          green: [lg`Marker/MarkerDrop_03_Dark_Green_400x400.webm`],
          red: [lg`Marker/MarkerDrop_03_Regular_Red_400x400.webm`]
        }
      },
      fear: {
        "01": {
          orange: [lg`Marker/MarkerFear_01_Regular_Orange_400x400.webm`],
          darkorange: [lg`Marker/MarkerFear_01_Dark_Orange_400x400.webm`],
          darkpurple: [lg`Marker/MarkerFear_01_Dark_Purple_400x400.webm`]
        },
        "02": {
          orange: [lg`Marker/MarkerFear_02_Regular_Orange_400x400.webm`],
          darkorange: [lg`Marker/MarkerFear_02_Dark_Orange_400x400.webm`],
          darkpurple: [lg`Marker/MarkerFear_02_Dark_Purple_400x400.webm`]
        },
        "03": {
          orange: [lg`Marker/MarkerFear_03_Regular_Orange_400x400.webm`],
          darkorange: [lg`Marker/MarkerFear_03_Dark_Orange_400x400.webm`],
          darkpurple: [lg`Marker/MarkerFear_03_Dark_Purple_400x400.webm`]
        }
      },
      heart: {
        "01": {
          darkred: [lg`Marker/MarkerHeart_01_Dark_Red_400x400.webm`],
          pink: [lg`Marker/MarkerHeart_01_Regular_Pink_400x400.webm`],
          teal: [lg`Marker/MarkerHeart_01_Regular_Teal_400x400.webm`]
        },
        "02": {
          darkred: [lg`Marker/MarkerHeart_02_Dark_Red_400x400.webm`],
          pink: [lg`Marker/MarkerHeart_02_Regular_Pink_400x400.webm`],
          teal: [lg`Marker/MarkerHeart_02_Regular_Teal_400x400.webm`]
        },
        "03": {
          darkred: [lg`Marker/MarkerHeart_03_Dark_Red_400x400.webm`],
          pink: [lg`Marker/MarkerHeart_03_Regular_Pink_400x400.webm`],
          teal: [lg`Marker/MarkerHeart_03_Regular_Teal_400x400.webm`]
        }
      },
      horror: {
        "01": {
          purple: [lg`Marker/MarkerHorror_01_Regular_Purple_400x400.webm`],
          teal: [lg`Marker/MarkerHorror_01_Regular_Teal_400x400.webm`],
          darkteal: [lg`Marker/MarkerHorror_01_Dark_Teal_400x400.webm`]
        },
        "02": {
          purple: [lg`Marker/MarkerHorror_02_Regular_Purple_400x400.webm`],
          teal: [lg`Marker/MarkerHorror_02_Dark_Teal_400x400.webm`],
          darkteal: [lg`Marker/MarkerHorror_02_Dark_Teal_400x400.webm`]
        },
        "03": {
          purple: [lg`Marker/MarkerHorror_03_Regular_Purple_400x400.webm`],
          teal: [lg`Marker/MarkerHorror_02_Regular_Teal_400x400.webm`],
          darkteal: [lg`Marker/MarkerHorror_03_Dark_Teal_400x400.webm`]
        }
      },
      light: {
        pulse: {
          blue: [lg`Marker/MarkerLight_01_Regular_Blue_400x400.webm`],
          green: [lg`Marker/MarkerLight_01_Regular_Green_400x400.webm`],
          yellow: [lg`Marker/MarkerLight_01_Regular_Yellow_400x400.webm`]
        },
        nopulse: {
          blue: [lg`Marker/MarkerLightNoPulse_01_Regular_Blue_400x400.webm`],
          green: [lg`Marker/MarkerLightNoPulse_01_Regular_Green_400x400.webm`],
          yellow: [lg`Marker/MarkerLightNoPulse_01_Regular_Yellow_400x400.webm`]
        }
      },
      poison: {
        "01": {
          darkgreen: [lg`Marker/MarkerPoison_01_Dark_Green_400x400.webm`],
          purple: [lg`Marker/MarkerPoison_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          darkgreen: [lg`Marker/MarkerPoison_02_Dark_Green_400x400.webm`],
          purple: [lg`Marker/MarkerPoison_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          darkgreen: [lg`Marker/MarkerPoison_03_Dark_Green_400x400.webm`],
          purple: [lg`Marker/MarkerPoison_03_Regular_Purple_400x400.webm`]
        }
      },
      runes: {
        "01": {
          black: [lg`Marker/MarkerRunes_01_Dark_Black_400x400.webm`],
          blue: [lg`Marker/MarkerRunes_01_Regular_Blue_400x400.webm`],
          darkorange: [lg`Marker/MarkerRunes_01_Dark_Orange_400x400.webm`],
          green: [lg`Marker/MarkerRunes_01_Regular_Green02_400x400.webm`],
          orange: [lg`Marker/MarkerRunes_01_Regular_Orange_400x400.webm`],
          darkred: [lg`Marker/MarkerRunes_01_Dark_Red_400x400.webm`],
          red: [lg`Marker/MarkerRunes_01_Regular_Red_400x400.webm`],
          yellow: [lg`Marker/MarkerRunes_01_Regular_Yellow_400x400.webm`],
          white: [lg`Marker/MarkerRunes_01_Regular_White_400x400.webm`]
        },
        "02": {
          black: [lg`Marker/MarkerRunes_02_Dark_Black_400x400.webm`],
          blue: [lg`Marker/MarkerRunes_02_Regular_Blue_400x400.webm`],
          darkorange: [lg`Marker/MarkerRunes_02_Dark_Orange_400x400.webm`],
          green: [lg`Marker/MarkerRunes_02_Regular_Green02_400x400.webm`],
          orange: [lg`Marker/MarkerRunes_02_Regular_Orange_400x400.webm`],
          darkred: [lg`Marker/MarkerRunes_02_Dark_Red_400x400.webm`],
          red: [lg`Marker/MarkerRunes_02_Regular_Red_400x400.webm`],
          yellow: [lg`Marker/MarkerRunes_02_Regular_Yellow_400x400.webm`],
          white: [lg`Marker/MarkerRunes_02_Regular_White_400x400.webm`]
        },
        "03": {
          black: [lg`Marker/MarkerRunes_03_Dark_Black_400x400.webm`],
          blue: [lg`Marker/MarkerRunes_03_Regular_Blue_400x400.webm`],
          darkorange: [lg`Marker/MarkerRunes_03_Dark_Orange_400x400.webm`],
          green: [lg`Marker/MarkerRunes_03_Regular_Green02_400x400.webm`],
          orange: [lg`Marker/MarkerRunes_03_Regular_Orange_400x400.webm`],
          darkred: [lg`Marker/MarkerRunes_03_Dark_Red_400x400.webm`],
          red: [lg`Marker/MarkerRunes_02_Regular_Red_400x400.webm`],
          yellow: [lg`Marker/MarkerRunes_03_Regular_Yellow_400x400.webm`],
          white: [lg`Marker/MarkerRunes_03_Regular_White_400x400.webm`]
        }
      },
      shields: {
        "01": {
          blue: [lg`Marker/MarkerShield_01_Regular_Blue_400x400.webm`],
          darkred: [lg`Marker/MarkerShield_01_Dark_Red_400x400.webm`],
          green: [lg`Marker/MarkerShield_01_Regular_Green_400x400.webm`]
        },
        "02": {
          blue: [lg`Marker/MarkerShield_02_Regular_Blue_400x400.webm`],
          darkred: [lg`Marker/MarkerShield_02_Dark_Red_400x400.webm`],
          green: [lg`Marker/MarkerShield_02_Regular_Green_400x400.webm`]
        },
        "03": {
          blue: [lg`Marker/MarkerShield_03_Regular_Blue_400x400.webm`],
          darkred: [lg`Marker/MarkerShield_03_Dark_Red_400x400.webm`],
          green: [lg`Marker/MarkerShield_03_Regular_Green_400x400.webm`]
        }
      },
      crackedshield: {
        "01": {
          darkred: [lg`Marker/MarkerShieldCracked_01_Dark_Red_400x400.webm`],
          purple: [lg`Marker/MarkerShieldCracked_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          darkred: [lg`Marker/MarkerShieldCracked_02_Dark_Red_400x400.webm`],
          purple: [lg`Marker/MarkerShieldCracked_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          darkred: [lg`Marker/MarkerShieldCracked_03_Dark_Red_400x400.webm`],
          purple: [lg`Marker/MarkerShieldCracked_03_Regular_Purple_400x400.webm`]
        }
      },
      skull: {
        "01": {
          darkgreen: [lg`Marker/MarkerSkull_01_Dark_Green_400x400.webm`],
          darkorange: [lg`Marker/MarkerSkull_01_Dark_Orange_400x400.webm`],
          purple: [lg`Marker/MarkerSkull_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          darkgreen: [lg`Marker/MarkerSkull_02_Dark_Green_400x400.webm`],
          darkorange: [lg`Marker/MarkerSkull_02_Dark_Orange_400x400.webm`],
          purple: [lg`Marker/MarkerSkull_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          darkgreen: [lg`Marker/MarkerSkull_03_Dark_Green_400x400.webm`],
          darkorange: [lg`Marker/MarkerSkull_03_Dark_Orange_400x400.webm`],
          purple: [lg`Marker/MarkerSkull_03_Regular_Purple_400x400.webm`]
        }
      },
      snowflakes: {
        "01": {
          darkblue: [lg`Marker/MarkerSnowflake_01_Dark_Blue_400x400.webm`],
          blue: [lg`Marker/MarkerSnowflake_01_Regular_Blue_400x400.webm`]
        },
        "02": {
          darkblue: [lg`Marker/MarkerSnowflake_02_Dark_Blue_400x400.webm`],
          blue: [lg`Marker/MarkerSnowflake_02_Regular_Blue_400x400.webm`]
        },
        "03": {
          darkblue: [lg`Marker/MarkerSnowflake_03_Dark_Blue_400x400.webm`],
          blue: [lg`Marker/MarkerSnowflake_03_Regular_Blue_400x400.webm`]
        }
      },
      stun: {
        "01": {
          darkteal: [lg`Marker/MarkerStun_01_Dark_Teal_400x400.webm`],
          purple: [lg`Marker/MarkerStun_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          darkteal: [lg`Marker/MarkerStun_02_Dark_Teal_400x400.webm`],
          purple: [lg`Marker/MarkerStun_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          darkteal: [lg`Marker/MarkerStun_03_Dark_Teal_400x400.webm`],
          purple: [lg`Marker/MarkerStun_03_Regular_Purple_400x400.webm`]
        }
      },
      dizzystars: {
        "01": {
          black: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Black_400x400.webm`],
          blueorange: [lg`Conditions/Dizzy_Stars/DizzyStars_01_BlueOrange_400x400.webm`],
          green: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Green_400x400.webm`],
          orange: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Orange_400x400.webm`],
          pink: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Pink_400x400.webm`],
          purple: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Purple_400x400.webm`],
          red: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Red_400x400.webm`],
          white: [lg`Conditions/Dizzy_Stars/DizzyStars_01_White_400x400.webm`],
          yellow: [lg`Conditions/Dizzy_Stars/DizzyStars_01_Yellow_400x400.webm`]
        }
      }
    },
    creature: {
      bite: {
        "01": {
          red: [lg`Creature/Bite_01_Regular_Red_400x400.webm`],
          blue: [lg`Creature/Bite_01_Regular_Blue_400x400.webm`],
          green: [lg`Creature/Bite_01_Regular_Green_400x400.webm`],
          grey: [lg`Creature/Bite_01_Regular_Grey_400x400.webm`],
          orange: [lg`Creature/Bite_01_Regular_Orange_400x400.webm`],
          purple: [lg`Creature/Bite_01_Regular_Purple_400x400.webm`],
          yellow: [lg`Creature/Bite_01_Regular_Yellow_400x400.webm`]
        }
      },
      claw: {
        "01": {
          blue: [lg`Creature/Claws_01_Bright_Blue_400x400.webm`],
          brown: [lg`Creature/Claws_01_Regular_Brown_400x400.webm`],
          darkred: [lg`Creature/Claws_01_Dark_Red_400x400.webm`],
          green: [lg`Creature/Claws_01_Bright_Green_400x400.webm`],
          orange: [lg`Creature/Claws_01_Bright_Orange_400x400.webm`],
          purple: [lg`Creature/Claws_01_Bright_Purple_400x400.webm`],
          red: [lg`Creature/Claws_01_Regular_Red_400x400.webm`],
          yellow: [lg`Creature/Claws_01_Bright_Yellow_400x400.webm`]
        }
      }
    },
    energy: {
      energyfield: {
        "01": {
          blue: [lg`Energy/EnergyField_01_Regular_Blue_600x600.webm`],
          green: [lg`Energy/EnergyField_01_Regular_Green_600x600.webm`],
          rainbow: [lg`Energy/EnergyField_01_Regular_Rainbow_600x600.webm`]
        }
      },
      dodecahedron: {
        simple: {
          blue: [lg`Energy/Dodecahedron_01_Regular_Blue_600x600.webm`],
          green: [lg`Energy/Dodecahedron_01_Regular_Green_600x600.webm`]
        },
        rolled: {
          blue: [lg`Energy/DodecahedronRoll_01_Regular_Blue_600x600.webm`],
          green: [lg`Energy/DodecahedronRoll_01_Regular_Green_600x600.webm`]
        },
        runeabove: {
          yellowblue: [lg`Energy/DodecahedronRuneAbove_01_Regular_BlueYellow_600x600.webm`],
          darkgreenpurple: [lg`Energy/DodecahedronRuneAbove_01_Dark_GreenPurple_600x600.webm`]
        },
        runebelow: {
          yellowblue: [lg`Energy/DodecahedronRuneBelow_01_Regular_BlueYellow_600x600.webm`],
          darkgreenpurple: [lg`Energy/DodecahedronRuneBelow_01_Dark_GreenPurple_600x600.webm`]
        },
        skullabove: {
          darkgreenpurple: [lg`Energy/DodecahedronSkullAbove_01_Dark_GreenPurple_600x600.webm`]
        },
        skullbelow: {
          darkgreenpurple: [lg`Energy/DodecahedronSkullBelow_01_Dark_GreenPurple_600x600.webm`]
        },
        starabove: {
          yellowblue: [lg`Energy/DodecahedronStarAbove_01_Regular_BlueYellow_600x600.webm`]
        },
        starbelow: {
          yellowblue: [lg`Energy/DodecahedronStarBelow_01_Regular_BlueYellow_600x600.webm`]
        }
      },
      shimmer: {
        "01": {
          blue: [lg`Energy/Shimmer01_01_Regular_Blue_400x400.webm`],
          green: [lg`Energy/Shimmer01_01_Regular_Green_400x400.webm`],
          orange: [lg`Energy/Shimmer01_01_Regular_Orange_400x400.webm`],
          purple: [lg`Energy/Shimmer01_01_Regular_Purple_400x400.webm`]
        }
      },
      sparkles: {
        "01": {
          blue: [lg`Energy/SwirlingSparkles_01_Regular_Blue_400x400.webm`],
          bluepink: [lg`Energy/SwirlingSparkles_01_Regular_BluePink_400x400.webm`],
          greenorange: [lg`Energy/SwirlingSparkles_01_Regular_GreenOrange_400x400.webm`],
          orangepurple: [lg`Energy/SwirlingSparkles_01_Regular_OrangePurple_400x400.webm`]
        }
      },
      strands: {
        "01": {
          blue: [lg`Energy/EnergyStrandIN01_01_Regular_Blue_600x600.webm`],
          green: [lg`Energy/EnergyStrandIN01_01_Regular_Green_600x600.webm`],
          purple: [lg`Energy/EnergyStrandIN01_01_Regular_Purple_600x600.webm`],
          red: [lg`Energy/EnergyStrandIN01_01_Regular_Red_600x600.webm`],
          yellow: [lg`Energy/EnergyStrandIN01_01_Regular_Yellow_600x600.webm`]
        },
        "02": {
          blue: [lg`Energy/EnergyStrandIN01_02_Regular_Blue_600x600.webm`],
          green: [lg`Energy/EnergyStrandIN01_02_Regular_Green_600x600.webm`],
          purple: [lg`Energy/EnergyStrandIN01_02_Regular_Purple_600x600.webm`],
          red: [lg`Energy/EnergyStrandIN01_02_Regular_Red_600x600.webm`],
          yellow: [lg`Energy/EnergyStrandIN01_02_Regular_Yellow_600x600.webm`]
        },
        "03": {
          blue: [lg`Energy/EnergyStrandIN01_03_Regular_Blue_600x600.webm`],
          green: [lg`Energy/EnergyStrandIN01_03_Regular_Green_600x600.webm`],
          purple: [lg`Energy/EnergyStrandIN01_03_Regular_Purple_600x600.webm`],
          red: [lg`Energy/EnergyStrandIN01_03_Regular_Red_600x600.webm`],
          yellow: [lg`Energy/EnergyStrandIN01_03_Regular_Yellow_600x600.webm`]
        }
      }
    },
    fire: {
      eruption: {
        "01": {
          blue: [lg`Fire/Eruption_01_Regular_Blue_600x600.webm`],
          green: [lg`Fire/Eruption_01_Regular_Green_600x600.webm`],
          orange: [lg`Fire/Eruption_01_Regular_Orange_600x600.webm`]
        }
      },
      groundcrack: {
        "01": {
          blue: [lg`Fire/GroundCrackLoop_01_Regular_Blue_600x600.webm`],
          green: [lg`Fire/GroundCrackLoop_01_Regular_Green_600x600.webm`],
          orange: [lg`Fire/GroundCrackLoop_01_Regular_Orange_600x600.webm`],
          purple: [lg`Fire/GroundCrackLoop_01_Regular_Purple_600x600.webm`]
        },
        "02": {
          blue: [lg`Fire/GroundCrackLoop_02_Regular_Blue_600x600.webm`],
          green: [lg`Fire/GroundCrackLoop_02_Regular_Green_600x600.webm`],
          orange: [lg`Fire/GroundCrackLoop_02_Regular_Orange_600x600.webm`],
          purple: [lg`Fire/GroundCrackLoop_02_Regular_Purple_600x600.webm`]
        },
        "03": {
          blue: [lg`Fire/GroundCrackLoop_03_Regular_Blue_600x600.webm`],
          green: [lg`Fire/GroundCrackLoop_03_Regular_Green_600x600.webm`],
          orange: [lg`Fire/GroundCrackLoop_03_Regular_Orange_600x600.webm`],
          purple: [lg`Fire/GroundCrackLoop_03_Regular_Purple_600x600.webm`]
        }
      },
      fireworks: {
        "01": {
          green: [
            lg`Fireworks/Firework02_01_Regular_Green_600x600.webm`
          ],
          greenorange: [
            lg`Fireworks/Firework01_01_Regular_GreenOrange_600x600.webm`
          ],
          greenred: [
            lg`Fireworks/Firework01_01_Regular_GreenRed_600x600.webm`,
            lg`Fireworks/Firework03_01_Regular_GreenRed_600x600.webm`
          ],
          orange: [
            lg`Fireworks/Firework02_01_Regular_Orange_600x600.webm`
          ],
          orangeyellow: [
            lg`Fireworks/Firework01_01_Regular_OrangeYellow_600x600.webm`,
            lg`Fireworks/Firework03_01_Regular_OrangeYellow_600x600.webm`
          ],
          yellow: [
            lg`Fireworks/Firework02_01_Regular_Yellow_600x600.webm`
          ],
          bluepink: [
            lg`Fireworks/Firework03_01_Regular_BluePink_600x600.webm`
          ]
        },
        "02": {
          green: [
            lg`Fireworks/Firework02_02_Regular_Green_600x600.webm`
          ],
          greenorange: [
            lg`Fireworks/Firework01_02_Regular_GreenOrange_600x600.webm`
          ],
          greenred: [
            lg`Fireworks/Firework03_02_Regular_GreenRed_600x600.webm`
          ],
          orange: [
            lg`Fireworks/Firework02_02_Regular_Orange_600x600.webm`
          ],
          orangeyellow: [
            lg`Fireworks/Firework01_02_Regular_OrangeYellow_600x600.webm`,
            lg`Fireworks/Firework03_02_Regular_OrangeYellow_600x600.webm`
          ],
          yellow: [
            lg`Fireworks/Firework02_02_Regular_Yellow_600x600.webm`,
            lg`Fireworks/Firework03_02_Regular_OrangeYellow_600x600.webm`
          ],
          bluepink: [
            lg`Fireworks/Firework03_02_Regular_BluePink_600x600.webm`
          ]
        }
      }
    },
    generic: {
      boulderimpact: {
        "01": {
          white: [lg`Impact/BoulderImpact_01_Regular_White_500x500.webm`]
        }
      },
      explosion: {
        "01": {
          darkblue: [
            lg`Explosion/Explosion_05_Dark_Blue_400x400.webm`
          ],
          darkgreen: [
            lg`Explosion/Explosion_05_Dark_Green_400x400.webm`
          ],
          darkorange: [
            lg`Explosion/Explosion_05_Dark_Orange_400x400.webm`
          ],
          darkpurple: [
            lg`Explosion/Explosion_04_Dark_Purple_400x400.webm`
          ],
          darkred: [
            lg`Explosion/Explosion_04_Dark_Red_400x400.webm`
          ],
          blue: [
            lg`Explosion/Explosion_01_Blue_400x400.webm`,
            lg`Explosion/Explosion_02_Blue_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Blue_400x400.webm`,
            lg`Explosion/Explosion_05_Regular_Blue_400x400.webm`
          ],
          green: [
            lg`Explosion/Explosion_01_Green_400x400.webm`,
            lg`Explosion/Explosion_02_Green_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Green_400x400.webm`,
            lg`Explosion/Explosion_05_Regular_Green_400x400.webm`
          ],
          greenorange: [
            lg`Explosion/Explosion_03_Regular_GreenOrange_400x400.webm`
          ],
          orange: [
            lg`Explosion/Explosion_01_Orange_400x400.webm`,
            lg`Explosion/Explosion_02_Orange_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Orange_400x400.webm`,
            lg`Explosion/Explosion_05_Regular_Orange_400x400.webm`
          ],
          pink: [
            lg`Explosion/Explosion_03_Regular_Pink_400x400.webm`
          ],
          purplepink: [
            lg`Explosion/Explosion_03_Regular_PurplePink_400x400.webm`
          ],
          purple: [
            lg`Explosion/Explosion_01_Purple_400x400.webm`,
            lg`Explosion/Explosion_02_Purple_400x400.webm`
          ],
          red: [
            lg`Explosion/Explosion_03_Regular_Red_400x400.webm`
          ],
          yellow: [
            lg`Explosion/Explosion_01_Yellow_400x400.webm`,
            lg`Explosion/Explosion_02_Yellow_400x400.webm`
          ],
          yellowblue: [
            lg`Explosion/Explosion_03_Regular_BlueYellow_400x400.webm`
          ],
          whiteblue: [
            lg`Explosion/Explosion_03_Dark_BlueWhite_400x400.webm`
          ]
        }
      },
      fire: {
        ring: {
          blue: [lg`Fire/FireRing_01_Circle_Blue_900.webm`],
          green: [lg`Fire/FireRing_01_Circle_Green_900.webm`],
          red: [lg`Fire/FireRing_01_Circle_Red_900.webm`]
        }
      },
      impact: {
        "01": {
          blue: [
            lg`Impact/Impact_01_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_02_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_03_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_04_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_05_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_07_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_08_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_09_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_10_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_11_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_12_Regular_Blue_400x400.webm`
          ],
          darkpurple: [
            lg`Impact/Impact_01_Dark_Purple_400x400.webm`,
            lg`Impact/Impact_02_Dark_Purple_400x400.webm`,
            lg`Impact/Impact_03_Dark_Purple_400x400.webm`,
            lg`Impact/Impact_04_Dark_Purple_400x400.webm`,
            lg`Impact/Impact_11_Dark_Purple_400x400.webm`,
            lg`Impact/Impact_12_Dark_Purple_400x400.webm`
          ],
          darkred: [
            lg`Impact/Impact_01_Dark_Red_400x400.webm`,
            lg`Impact/Impact_02_Dark_Red_400x400.webm`,
            lg`Impact/Impact_03_Dark_Red_400x400.webm`,
            lg`Impact/Impact_04_Dark_Red_400x400.webm`,
            lg`Impact/Impact_11_Dark_Red_400x400.webm`,
            lg`Impact/Impact_12_Dark_Red_400x400.webm`
          ],
          green: [
            lg`Impact/Impact_01_Regular_Green_400x400.webm`,
            lg`Impact/Impact_02_Regular_Green_400x400.webm`,
            lg`Impact/Impact_03_Regular_Green_400x400.webm`,
            lg`Impact/Impact_04_Regular_Green_400x400.webm`,
            lg`Impact/Impact_05_Regular_Green_400x400.webm`,
            lg`Impact/Impact_07_Regular_Green_400x400.webm`,
            lg`Impact/Impact_08_Regular_Green_400x400.webm`,
            lg`Impact/Impact_09_Regular_Green_400x400.webm`,
            lg`Impact/Impact_10_Regular_Green_400x400.webm`,
            lg`Impact/Impact_11_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_12_Regular_Blue_400x400.webm`
          ],
          orange: [
            lg`Impact/Impact_01_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_02_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_03_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_04_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_05_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_07_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_08_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_09_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_10_Regular_Orange_400x400.webm`
          ],
          pink: [
            lg`Impact/Impact_07_Regular_Pink_400x400.webm`,
            lg`Impact/Impact_09_Regular_Pink_400x400.webm`
          ],
          purplepink: [
            lg`Impact/Impact_01_Regular_PinkPurple_400x400.webm`,
            lg`Impact/Impact_02_Regular_PinkPurple_400x400.webm`,
            lg`Impact/Impact_03_Regular_PinkPurple_400x400.webm`,
            lg`Impact/Impact_04_Regular_PinkPurple_400x400.webm`
          ],
          purple: [
            lg`Impact/Impact_05_Regular_Purple_400x400.webm`,
            lg`Impact/Impact_07_Regular_Purple_400x400.webm`,
            lg`Impact/Impact_09_Regular_Purple_400x400.webm`,
            lg`Impact/Impact_11_Regular_Purple_400x400.webm`,
            lg`Impact/Impact_12_Regular_Purple_400x400.webm`
          ],
          red: [
            lg`Impact/Impact_05_Regular_Red_400x400.webm`,
            lg`Impact/Impact_07_Regular_Red_400x400.webm`,
            lg`Impact/Impact_08_Regular_Red_400x400.webm`,
            lg`Impact/Impact_10_Regular_Red_400x400.webm`,
            lg`Impact/Impact_11_Regular_Red_400x400.webm`,
            lg`Impact/Impact_12_Regular_Red_400x400.webm`,
            lg`Impact/Impact_07_Regular_Red02_400x400.webm`
          ],
          white: [
            lg`Impact/Impact_07_Regular_White_400x400.webm`,
            lg`Impact/Impact_09_Regular_White_400x400.webm`
          ],
          yellow: [
            lg`Impact/Impact_01_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_02_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_03_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_04_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_05_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_06_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_07_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_11_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_12_Regular_Yellow_400x400.webm`
          ]
        }
      },
      indicator: {
        chevron: {
          green: [lg`UI/3Chevrons_01_Regular_Green_200x200.webm`],
          purple: [lg`UI/3Chevrons_01_Regular_Purple_200x200.webm`],
          red: [lg`UI/3Chevrons_01_Regular_Red_200x200.webm`],
          yellow: [lg`UI/3Chevrons_01_Regular_Yellow_200x200.webm`]
        },
        "01": {
          green: [lg`UI/Indicator_01_Regular_Green_200x200.webm`],
          purple: [lg`UI/Indicator_01_Regular_Purple_200x200.webm`],
          red: [lg`UI/Indicator_01_Regular_Red_200x200.webm`],
          yellow: [lg`UI/Indicator_01_Regular_Yellow_200x200.webm`]
        },
        "02": {
          green: [lg`UI/Indicator01_02_Regular_BlueGreen_400x400.webm`],
          red: [lg`UI/Indicator01_02_Regular_RedYellow_400x400.webm`]
        },
        "03": {
          green: [lg`UI/Indicator01_03_Regular_BlueGreen_200x200.webm`],
          red: [lg`UI/Indicator01_03_Regular_RedYellow_200x200.webm`]
        },
        "04": {
          green: [lg`UI/Indicator02_02_Regular_BlueGreen_400x400.webm`],
          red: [lg`UI/Indicator02_02_Regular_RedYellow_400x400.webm`]
        },
        "05": {
          green: [lg`UI/Indicator02_03_Regular_BlueGreen_200x200.webm`],
          red: [lg`UI/Indicator02_03_Regular_RedYellow_200x200.webm`]
        },
        "06": {
          green: [lg`UI/Indicator03_02_Regular_BlueGreen_400x400.webm`],
          red: [lg`UI/Indicator03_02_Regular_RedYellow_400x400.webm`]
        },
        "07": {
          green: [lg`UI/Indicator03_03_Regular_BlueGreen_200x200.webm`],
          red: [lg`UI/Indicator03_03_Regular_RedYellow_200x200.webm`]
        }
      },
      outpulse: {
        "01": {
          whiteblue: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_TealYellow_Burst_600x600.webm`]
        },
        "02": {
          whiteblue: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_TealYellow_Burst_600x600.webm`]
        }
      },
      smoke: {
        "01": {
          black: [lg`Smoke/SmokePuff01_01_Dark_Black_400x400.webm`],
          blue: [lg`Smoke/SmokePuff01_01_Regular_Blue_400x400.webm`],
          darkgreen: [lg`Smoke/SmokePuff01_01_Dark_Green_400x400.webm`],
          darkpurple: [lg`Smoke/SmokePuff01_01_Dark_Purple_400x400.webm`],
          grey: [lg`Smoke/SmokePuff01_01_Regular_Grey_400x400.webm`]
        },
        "02": {
          black: [lg`Smoke/SmokePuff01_02_Dark_Black_400x400.webm`],
          blue: [lg`Smoke/SmokePuff01_02_Regular_Blue_400x400.webm`],
          darkgreen: [lg`Smoke/SmokePuff01_02_Dark_Green_400x400.webm`],
          darkpurple: [lg`Smoke/SmokePuff01_02_Dark_Purple_400x400.webm`],
          grey: [lg`Smoke/SmokePuff01_02_Regular_Grey_400x400.webm`]
        },
        "03": {
          black: [lg`Smoke/SmokePuff01_03_Dark_Black_400x400.webm`],
          blue: [lg`Smoke/SmokePuff01_03_Regular_Blue_400x400.webm`],
          darkgreen: [lg`Smoke/SmokePuff01_03_Dark_Green_400x400.webm`],
          darkpurple: [lg`Smoke/SmokePuff01_03_Dark_Purple_400x400.webm`],
          grey: [lg`Smoke/SmokePuff01_03_Regular_Grey_400x400.webm`]
        },
        ring: {
          black: [lg`Smoke/SmokeRing_01_Dark_Black_800x800.webm`],
          white: [lg`Smoke/SmokeRing_01_Regular_White_800x800.webm`]
        },
        "ring02": {
          black: [
            lg`Smoke/SmokePuffRing01_01_Dark_Black_400x400.webm`,
            lg`Smoke/SmokePuffRing01_02_Dark_Black_400x400.webm`,
            lg`Smoke/SmokePuffRing01_03_Dark_Black_400x400.webm`
          ],
          white: [
            lg`Smoke/SmokePuffRing01_01_Regular_White_400x400.webm`,
            lg`Smoke/SmokePuffRing01_02_Regular_White_400x400.webm`,
            lg`Smoke/SmokePuffRing01_03_Regular_White_400x400.webm`
          ]
        },
        "ring03": {
          black: [lg`Smoke/SmokePuffRing02_01_Dark_Black_400x400.webm`],
          white: [lg`Smoke/SmokePuffRing02_01_Regular_White_400x400.webm`]
        }
      },
      ui: {
        drop: {
          green: [lg`UI/IconDrop_01_Dark_Green_200x200.webm`],
          red: [lg`UI/IconDrop_01_Regular_Red_200x200.webm`]
        },
        fear: {
          darkorange: [lg`UI/IconFear_01_Dark_Orange_200x200.webm`],
          orange: [lg`UI/IconFear_01_Regular_Orange_200x200.webm`],
          darkpurple: [lg`UI/IconFear_01_Dark_Purple_200x200.webm`]
        },
        heart: {
          darkred: [lg`UI/IconHeart_01_Dark_Red_200x200.webm`],
          pink: [lg`UI/IconHeart_01_Regular_Pink_200x200.webm`],
          teal: [lg`UI/IconHeart_01_Regular_Teal_200x200.webm`]
        },
        horror: {
          darkteal: [lg`UI/IconHorror_01_Dark_Teal_200x200.webm`],
          purple: [lg`UI/IconHorror_01_Regular_Purple_200x200.webm`],
          teal: [lg`UI/IconHorror_01_Regular_Teal_200x200.webm`]
        },
        music: {
          blue: [lg`UI/IconMusicNote_01_Regular_Blue_200x200.webm`],
          darkred: [lg`UI/IconMusicNote_01_Dark_Red_200x200.webm`],
          purple: [lg`UI/IconMusicNote_01_Regular_Purple_200x200.webm`]
        },
        poison: {
          darkgreen: [lg`UI/IconPoison_01_Dark_Green_200x200.webm`],
          purple: [lg`UI/IconPoison_01_Regular_Purple_200x200.webm`]
        },
        rune01: {
          black: [lg`UI/IconRunes_01_Dark_Black_200x200.webm`],
          blue: [lg`UI/IconRunes_01_Regular_Blue_200x200.webm`],
          darkorange: [lg`UI/IconRunes_01_Dark_Orange_200x200.webm`],
          darkred: [lg`UI/IconRunes_01_Dark_Red_200x200.webm`],
          green: [lg`UI/IconRunes_01_Regular_Green02_200x200.webm`],
          orange: [lg`UI/IconRunes_01_Regular_Orange_200x200.webm`],
          red: [lg`UI/IconRunes_01_Regular_Red_200x200.webm`],
          white: [lg`UI/IconRunes_01_Regular_White_200x200.webm`],
          yellow: [lg`UI/IconRunes_01_Regular_Yellow_200x200.webm`]
        },
        rune02: {
          black: [lg`UI/IconRunes02_01_Dark_Black_200x200.webm`],
          blue: [lg`UI/IconRunes02_01_Regular_Blue_200x200.webm`],
          darkorange: [lg`UI/IconRunes02_01_Dark_Orange_200x200.webm`],
          darkred: [lg`UI/IconRunes02_01_Dark_Red_200x200.webm`],
          green: [lg`UI/IconRunes02_01_Regular_Green02_200x200.webm`],
          orange: [lg`UI/IconRunes02_01_Regular_Orange_200x200.webm`],
          red: [lg`UI/IconRunes02_01_Regular_Red_200x200.webm`],
          white: [lg`UI/IconRunes02_01_Regular_White_200x200.webm`],
          yellow: [lg`UI/IconRunes02_01_Regular_Yellow_200x200.webm`]
        },
        rune03: {
          black: [lg`UI/IconRunes03_01_Dark_Black_200x200.webm`],
          blue: [lg`UI/IconRunes03_01_Regular_Blue_200x200.webm`],
          darkorange: [lg`UI/IconRunes03_01_Dark_Orange_200x200.webm`],
          darkred: [lg`UI/IconRunes03_01_Dark_Red_200x200.webm`],
          green: [lg`UI/IconRunes03_01_Regular_Green02_200x200.webm`],
          orange: [lg`UI/IconRunes03_01_Regular_Orange_200x200.webm`],
          red: [lg`UI/IconRunes03_01_Regular_Red_200x200.webm`],
          white: [lg`UI/IconRunes03_01_Regular_White_200x200.webm`],
          yellow: [lg`UI/IconRunes03_01_Regular_Yellow_200x200.webm`]
        },
        shields: {
          blue: [lg`UI/IconShield_01_Regular_Blue_200x200.webm`],
          darkred: [lg`UI/IconShield_01_Dark_Red_200x200.webm`],
          green: [lg`UI/IconShield_01_Regular_Green_200x200.webm`]
        },
        crackedshield: {
          darkred: [lg`UI/IconShieldCracked_01_Dark_Red_200x200.webm`],
          purple: [lg`UI/IconShieldCracked_01_Regular_Purple_200x200.webm`]
        },
        skull: {
          darkgreen: [lg`UI/IconSkull_01_Dark_Green_200x200.webm`],
          darkorange: [lg`UI/IconSkull_01_Dark_Orange_200x200.webm`],
          purple: [lg`UI/IconSkull_01_Regular_Purple_200x200.webm`]
        },
        snowflake: {
          darkblue: [lg`UI/IconSnowflake_01_Dark_Blue_200x200.webm`],
          blue: [lg`UI/IconSnowflake_01_Regular_Blue_200x200.webm`]
        },
        stun: {
          darkteal: [lg`UI/IconStun_01_Dark_Teal_200x200.webm`],
          purple: [lg`UI/IconStun_01_Regular_Purple_200x200.webm`]
        }
      },
      vortex: {
        loop: {
          black: [lg`Template/Circle/Vortex_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/Vortex_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/Vortex_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/Vortex_01_Regular_Purple_600x600.webm`]
        },
        intro: {
          black: [lg`Template/Circle/VortexIntro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/VortexIntro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/VortexIntro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/VortexIntro_01_Regular_Purple_600x600.webm`]
        },
        outro: {
          black: [lg`Template/Circle/VortexOutro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/VortexOutro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/VortexOutro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/VortexOutro_01_Regular_Purple_600x600.webm`]
        }
      },
      whirl: {
        loop: {
          black: [lg`Template/Circle/Whirl_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/Whirl_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/Whirl_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/Whirl_01_Regular_Purple_600x600.webm`]
        },
        intro: {
          black: [lg`Template/Circle/WhirlIntro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/WhirlIntro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/WhirlIntro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/WhirlIntro_01_Regular_Purple_600x600.webm`]
        },
        outro: {
          black: [lg`Template/Circle/WhirlOutro_01_Dark_Black_600x600.webm`],
          blue: [lg`Template/Circle/WhirlOutro_01_Regular_Blue_600x600.webm`],
          green: [lg`Template/Circle/WhirlOutro_01_Regular_Green_600x600.webm`],
          purple: [lg`Template/Circle/WhirlOutro_01_Regular_Purple_600x600.webm`]
        }
      }
    },
    ice: {
      icespikes: {
        "01": {
          blue: [lg`Ice/IceSpikesRadialBurst_01_Regular_Blue_1000x1000.webm`],
          red: [lg`Ice/IceSpikesRadialBurst_01_Regular_Red_1000x1000.webm`],
          white: [lg`Ice/IceSpikesRadialBurst_01_Regular_White_1000x1000.webm`]
        }
      },
      snowflake: {
        "01": {
          whiteblue: [lg`Ice/SnowflakeBurst_01_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Ice/SnowflakeBurst_01_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Ice/SnowflakeBurst_01_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Ice/SnowflakeBurst_01_Regular_TealYellow_Burst_600x600.webm`]
        }
      }
    },
    leaves: {
      complete: {
        "01": {
          green: [lg`Nature/SwirlingLeavesComplete01_01_Regular_Green_400x400.webm`],
          greenorange: [lg`Nature/SwirlingLeavesComplete01_01_Regular_GreenOrange_400x400.webm`]
        },
        "02": {
          green: [lg`Nature/SwirlingLeavesComplete01_02_Regular_Green_400x400.webm`],
          greenorange: [lg`Nature/SwirlingLeavesComplete01_02_Regular_GreenOrange_400x400.webm`]
        },
        "03": {
          green: [lg`Nature/SwirlingLeavesComplete02_01_Regular_Green_400x400.webm`],
          greenorange: [lg`Nature/SwirlingLeavesComplete02_01_Regular_GreenOrange_400x400.webm`]
        }
      },
      loop: {
        "01": {
          green: [lg`Nature/SwirlingLeavesLoop01_01_Regular_GreenOrange_400x400.webm`],
          greenorange: [lg`Nature/SwirlingLeavesLoop01_01_Regular_GreenOrange_400x400.webm`]
        },
        "02": {
          green: [lg`Nature/SwirlingLeavesLoop01_02_Regular_Green_400x400.webm`],
          greenorange: [lg`Nature/SwirlingLeavesLoop01_02_Regular_GreenOrange_400x400.webm`]
        },
        "03": {
          green: [lg`Nature/SwirlingLeavesLoop02_01_Regular_Green_400x400.webm`],
          greenorange: [lg`Nature/SwirlingLeavesLoop02_01_Regular_GreenOrange_400x400.webm`]
        }
      }
    },
    lightning: {
      ball: {
        "01": {
          blue: [lg`Lightning/LightningBall_01_Regular_Blue_400x400.webm`],
          green: [lg`Lightning/LightningBall_01_Regular_Green_400x400.webm`],
          darkgreen: [lg`Lightning/LightningBall_01_Regular_Green02_400x400.webm`],
          darkpurple: [lg`Lightning/LightningBall_01_Dark_Purple_400x400.webm`],
          darkred: [lg`Lightning/LightningBall_01_Dark_Red_400x400.webm`],
          orange: [lg`Lightning/LightningBall_01_Regular_Orange_400x400.webm`],
          purple: [lg`Lightning/LightningBall_01_Regular_Purple_400x400.webm`],
          purpleblue: [lg`Lightning/LightningBall_01_Regular_Blue02_400x400.webm`],
          red: [lg`Lightning/LightningBall_01_Regular_Red_400x400.webm`],
          yellow: [lg`Lightning/LightningBall_01_Regular_Yellow_400x400.webm`]
        }
      },
      strike: {
        "01": {
          blue: [
            lg`Lightning/LightningStrike01_01_Regular_Blue_800x800.webm`,
            lg`Lightning/LightningStrike01_02_Regular_Blue_800x800.webm`,
            lg`Lightning/LightningStrike01_03_Regular_Blue_800x800.webm`,
            lg`Lightning/LightningStrike01_04_Regular_Blue_800x800.webm`,
            lg`Lightning/LightningStrike01_05_Regular_Blue_800x800.webm`,
            lg`Lightning/LightningStrike01_06_Regular_Blue_800x800.webm`
          ],
          purple: [
            lg`Lightning/LightningStrike01_01_Regular_Purple_800x800.webm`,
            lg`Lightning/LightningStrike01_02_Regular_Purple_800x800.webm`,
            lg`Lightning/LightningStrike01_03_Regular_Purple_800x800.webm`,
            lg`Lightning/LightningStrike01_04_Regular_Purple_800x800.webm`,
            lg`Lightning/LightningStrike01_05_Regular_Purple_800x800.webm`,
            lg`Lightning/LightningStrike01_06_Regular_Purple_800x800.webm`
          ],
          yellow: [
            lg`Lightning/LightningStrike01_01_Regular_Yellow_800x800.webm`,
            lg`Lightning/LightningStrike01_02_Regular_Yellow_800x800.webm`,
            lg`Lightning/LightningStrike01_03_Regular_Yellow_800x800.webm`,
            lg`Lightning/LightningStrike01_04_Regular_Yellow_800x800.webm`,
            lg`Lightning/LightningStrike01_05_Regular_Yellow_800x800.webm`,
            lg`Lightning/LightningStrike01_06_Regular_Yellow_800x800.webm`
          ]
        }
      },
      staticelectricity: {
        "01": {
          blue: [lg`Lightning/StaticElectricity_01_Regular_Blue_400x400.webm`],
          darkgreen: [lg`Lightning/StaticElectricity_01_Regular_Green02_400x400.webm`],
          darkpurple: [lg`Lightning/StaticElectricity_01_Dark_Purple_400x400.webm`],
          darkred: [lg`Lightning/StaticElectricity_01_Dark_Red_400x400.webm`],
          green: [lg`Lightning/StaticElectricity_01_Regular_Green_400x400.webm`],
          orange: [lg`Lightning/StaticElectricity_01_Regular_Orange_400x400.webm`],
          purple: [lg`Lightning/StaticElectricity_01_Regular_Purple_400x400.webm`],
          purpleblue: [lg`Lightning/StaticElectricity_01_Regular_Blue02_400x400.webm`],
          red: [lg`Lightning/StaticElectricity_01_Regular_Red_400x400.webm`],
          yellow: [lg`Lightning/StaticElectricity_01_Regular_Yellow_400x400.webm`]
        },
        "02": {
          blue: [lg`Lightning/StaticElectricity_02_Regular_Blue_400x400.webm`],
          darkgreen: [lg`Lightning/StaticElectricity_02_Regular_Green02_400x400.webm`],
          darkpurple: [lg`Lightning/StaticElectricity_02_Dark_Purple_400x400.webm`],
          darkred: [lg`Lightning/StaticElectricity_02_Dark_Red_400x400.webm`],
          green: [lg`Lightning/StaticElectricity_02_Regular_Green_400x400.webm`],
          orange: [lg`Lightning/StaticElectricity_02_Regular_Orange_400x400.webm`],
          purple: [lg`Lightning/StaticElectricity_02_Regular_Purple_400x400.webm`],
          purpleblue: [lg`Lightning/StaticElectricity_02_Regular_Blue02_400x400.webm`],
          red: [lg`Lightning/StaticElectricity_02_Regular_Red_400x400.webm`],
          yellow: [lg`Lightning/StaticElectricity_02_Regular_Yellow_400x400.webm`]
        },
        "03": {
          blue: [lg`Lightning/StaticElectricity_03_Regular_Blue_400x400.webm`],
          darkgreen: [lg`Lightning/StaticElectricity_03_Regular_Green02_400x400.webm`],
          darkpurple: [lg`Lightning/StaticElectricity_03_Dark_Purple_400x400.webm`],
          darkred: [lg`Lightning/StaticElectricity_03_Dark_Red_400x400.webm`],
          green: [lg`Lightning/StaticElectricity_03_Regular_Green_400x400.webm`],
          orange: [lg`Lightning/StaticElectricity_03_Regular_Orange_400x400.webm`],
          purple: [lg`Lightning/StaticElectricity_03_Regular_Purple_400x400.webm`],
          purpleblue: [lg`Lightning/StaticElectricity_03_Regular_Blue02_400x400.webm`],
          red: [lg`Lightning/StaticElectricity_03_Regular_Red_400x400.webm`],
          yellow: [lg`Lightning/StaticElectricity_03_Regular_Yellow_400x400.webm`]
        }
      }
    },
    liquid: {
      splash: {
        "01": {
          black: [lg`Liquid/LiquidSplash01_Dark_Black_400x400.webm`],
          blue: [lg`Liquid/LiquidSplash01_Regular_Blue_400x400.webm`],
          brightgreen: [lg`Liquid/LiquidSplash01_Bright_Green_400x400.webm`],
          brightblue: [lg`Liquid/LiquidSplash01_Bright_Blue_400x400.webm`],
          green: [lg`Liquid/LiquidSplash01_Regular_Green_400x400.webm`],
          grey: [lg`Liquid/LiquidSplash01_Regular_Grey_400x400.webm`],
          purple: [lg`Liquid/LiquidSplash01_Bright_Purple_400x400.webm`],
          red: [lg`Liquid/LiquidSplash01_Regular_Red_400x400.webm`]
        }
      },
      blob: {
        "01": {
          blue: [lg`Liquid/LiquidBlob01_01_Regular_Blue_400x400.webm`],
          green: [lg`Liquid/LiquidBlob01_01_Regular_Green_400x400.webm`],
          purple: [lg`Liquid/LiquidBlob01_01_Regular_Purple_400x400.webm`]
        }
      }
    },
    magicsign: {
      abjuration: {
        "01": {
          blue: [lg`Magic_Signs/Abjuration_01_Blue_Circle_800x800.webm`],
          green: [lg`Magic_Signs/Abjuration_01_Green_Circle_800x800.webm`],
          red: [lg`Magic_Signs/Abjuration_01_Red_Circle_800x800.webm`]
        },
        "02": {
          blue: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      conjuration: {
        "01": {
          yellow: [lg`Magic_Signs/Conjuration_01_Yellow_Circle_800x800.webm`]
        },
        "02": {
          blue: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/ConjurationRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/ConjurationRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/ConjurationRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/ConjurationRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/ConjurationRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/ConjurationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      divination: {
        "01": {
          lightblue: [lg`Magic_Signs/Divination_01_Light_Blue_Circle_800x800.webm`]
        },
        "02": {
          blue: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      enchantment: {
        "02": {
          blue: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      evocation: {
        "02": {
          blue: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      illusion: {
        "02": {
          blue: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      necromancy: {
        "02": {
          blue: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      transmutation: {
        "02": {
          blue: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Blue_800x800.webm`],
          green: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Green_800x800.webm`],
          pink: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Pink_800x800.webm`],
          purple: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Purple_800x800.webm`],
          red: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Red_800x800.webm`],
          yellow: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Blue_400x400.webm`],
          green: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Green_400x400.webm`],
          pink: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Pink_400x400.webm`],
          purple: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Purple_400x400.webm`],
          red: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Red_400x400.webm`],
          yellow: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      }
    },
    marker: {
      bubble: {
        "01": {
          blue: [lg`Marker/MarkerBubble_01_Regular_Blue_400x400.webm`],
          green: [lg`Marker/MarkerBubble_01_Regular_Green_400x400.webm`],
          rainbow: [lg`Marker/MarkerBubble_01_Regular_Rainbow_400x400.webm`]
        }
      },
      circleofstars: {
        "01": {
          blue: [lg`Marker/MarkerCircleOfStars_Regular_Blue_400x400.webm`],
          green: [lg`Marker/MarkerCircleOfStars_Regular_Green_400x400.webm`],
          greenorange: [lg`Marker/MarkerCircleOfStars_Regular_GreenOrange_400x400.webm`],
          orangepurple: [lg`Marker/MarkerCircleOfStars_Regular_OrangePurple_400x400.webm`],
          purplegreen: [lg`Marker/MarkerCircleOfStars_Regular_PurpleGreen_400x400.webm`],
          yellowblue: [lg`Marker/MarkerCircleOfStars_Regular_YellowBlue_400x400.webm`]
        }
      },
      energystrand: {
        "01": {
          blue: [lg`Marker/EnergyStrands_01_Regular_Blue_600x600.webm`],
          blueorange: [lg`Marker/EnergyStrands_01_Regular_BlueOrange_600x600.webm`],
          darkred: [lg`Marker/EnergyStrands_01_Dark_Red_600x600.webm`],
          orange: [lg`Marker/EnergyStrands_01_Regular_Orange_600x600.webm`],
          pinkyellow: [lg`Marker/EnergyStrands_01_Regular_PinkYellow_600x600.webm`],
          purple: [lg`Marker/EnergyStrands_01_Regular_Purple_600x600.webm`]
        }
      },
      music: {
        "01": {
          darkred: [lg`Marker/MusicMarker_01_Dark_Red_400x400.webm`],
          yellowblue: [lg`Marker/MusicMarker_01_Regular_BlueYellow_400x400.webm`],
          greenorange: [lg`Marker/MusicMarker_01_Regular_GreenOrange_400x400.webm`],
          pink: [lg`Marker/MusicMarker_01_Regular_Pink_400x400.webm`],
          purplepink: [lg`Marker/MusicMarker_01_Regular_PurplePink_400x400.webm`]
        }
      },
      standard: {
        "01": {
          whiteblue: [lg`Marker/Marker_01_Dark_BlueWhite_400x400.webm`],
          yellowblue: [lg`Marker/Marker_01_Regular_BlueYellow_400x400.webm`],
          greenorange: [lg`Marker/Marker_01_Regular_GreenOrange_400x400.webm`],
          pink: [lg`Marker/Marker_01_Regular_Pink_400x400.webm`],
          purplepink: [lg`Marker/Marker_01_Regular_PurplePink_400x400.webm`],
          red: [lg`Marker/Marker_01_Regular_Red_400x400.webm`]
        },
        "02": {
          whiteblue: [lg`Marker/Marker_02_Dark_BlueWhite_400x400.webm`],
          yellowblue: [lg`Marker/Marker_02_Regular_BlueYellow_400x400.webm`],
          greenorange: [lg`Marker/Marker_02_Regular_GreenOrange_400x400.webm`],
          pink: [lg`Marker/Marker_02_Regular_Pink_400x400.webm`],
          purplepink: [lg`Marker/Marker_02_Regular_PurplePink_400x400.webm`],
          pink: [lg`Marker/Marker_02_Regular_Red_400x400.webm`]
        }
      }
    },
    music: {
      notes: {
        "01": {
          blue: [
            lg`Music_Notation/BassClef_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/BeamedQuavers_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Crotchet_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Flat_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Quaver_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Sharp_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/TrebleClef_01_Regular_Blue_200x200.webm`
          ],
          green: [
            lg`Music_Notation/BassClef_01_Regular_Green_200x200.webm`,
            lg`Music_Notation/BeamedQuavers_01_Regular_Green_200x200.webm`,
            lg`Music_Notation/Crotchet_01_Regular_Green_200x200.webm`,
            lg`Music_Notation/Flat_01_Regular_Green_200x200.webm`,
            lg`Music_Notation/Quaver_01_Regular_Green_200x200.webm`,
            lg`Music_Notation/Sharp_01_Regular_Green_200x200.webm`,
            lg`Music_Notation/TrebleClef_01_Regular_Green_200x200.webm`
          ],
          orange: [
            lg`Music_Notation/BassClef_01_Regular_Orange_200x200.webm`,
            lg`Music_Notation/BeamedQuavers_01_Regular_Orange_200x200.webm`,
            lg`Music_Notation/Crotchet_01_Regular_Orange_200x200.webm`,
            lg`Music_Notation/Flat_01_Regular_Orange_200x200.webm`,
            lg`Music_Notation/Quaver_01_Regular_Orange_200x200.webm`,
            lg`Music_Notation/Sharp_01_Regular_Orange_200x200.webm`,
            lg`Music_Notation/TrebleClef_01_Regular_Orange_200x200.webm`
          ],
          purple: [
            lg`Music_Notation/BassClef_01_Regular_Purple_200x200.webm`,
            lg`Music_Notation/BeamedQuavers_01_Regular_Purple_200x200.webm`,
            lg`Music_Notation/Crotchet_01_Regular_Purple_200x200.webm`,
            lg`Music_Notation/Flat_01_Regular_Purple_200x200.webm`,
            lg`Music_Notation/Quaver_01_Regular_Purple_200x200.webm`,
            lg`Music_Notation/Sharp_01_Regular_Purple_200x200.webm`,
            lg`Music_Notation/TrebleClef_01_Regular_Purple_200x200.webm`
          ]
        }
      }
    },
    particles: {
      dots: {
        "01": {
          blue: [lg`Particles/ParticlesOutward01_01_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward01_01_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward01_01_Regular_Orange_400x400.webm`]
        },
        "02": {
          blue: [lg`Particles/ParticlesOutward01_02_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward01_02_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward01_02_Regular_Orange_400x400.webm`]
        },
        "03": {
          blue: [lg`Particles/ParticlesOutward01_03_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward01_03_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward01_03_Regular_Orange_400x400.webm`]
        },
        "04": {
          blue: [lg`Particles/ParticlesOutward01_04_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward01_04_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward01_04_Regular_Orange_400x400.webm`]
        },
        "05": {
          blue: [lg`Particles/ParticlesOutward01_05_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward01_05_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward01_05_Regular_Orange_400x400.webm`]
        }
      },
      inwarddots: {
        "01": {
          blue: [lg`Particles/ParticlesInward01_01_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward01_01_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward01_01_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward01_01_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward01_01_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward01_01_Regular_White_400x400.webm`]
        },
        "02": {
          blue: [lg`Particles/ParticlesInward01_02_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward01_02_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward01_02_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward01_02_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward01_02_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward01_02_Regular_White_400x400.webm`]
        },
        "03": {
          blue: [lg`Particles/ParticlesInward01_03_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward01_03_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward01_03_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward01_03_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward01_03_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward01_03_Regular_White_400x400.webm`]
        },
        "04": {
          blue: [lg`Particles/ParticlesInward01_04_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward01_04_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward01_04_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward01_04_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward01_04_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward01_04_Regular_White_400x400.webm`]
        },
        "05": {
          blue: [lg`Particles/ParticlesInward01_05_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward01_05_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward01_05_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward01_05_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward01_05_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward01_05_Regular_White_400x400.webm`]
        }
      },
      stars: {
        "01": {
          blue: [lg`Particles/ParticlesOutward02_01_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward02_01_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward02_01_Regular_Orange_400x400.webm`]
        },
        "02": {
          blue: [lg`Particles/ParticlesOutward02_02_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward02_02_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward02_02_Regular_Orange_400x400.webm`]
        },
        "03": {
          blue: [lg`Particles/ParticlesOutward02_03_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward02_03_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward02_03_Regular_Orange_400x400.webm`]
        },
        "04": {
          blue: [lg`Particles/ParticlesOutward02_04_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward02_04_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward02_04_Regular_Orange_400x400.webm`]
        },
        "05": {
          blue: [lg`Particles/ParticlesOutward02_05_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesOutward02_05_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesOutward02_05_Regular_Orange_400x400.webm`]
        }
      },
      inwardstars: {
        "01": {
          blue: [lg`Particles/ParticlesInward02_01_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward02_01_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward02_01_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward02_01_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward02_01_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward02_01_Regular_White_400x400.webm`]
        },
        "02": {
          blue: [lg`Particles/ParticlesInward02_02_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward02_02_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward02_02_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward02_02_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward02_02_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward02_02_Regular_White_400x400.webm`]
        },
        "03": {
          blue: [lg`Particles/ParticlesInward02_03_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward02_03_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward02_03_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward02_03_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward02_03_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward02_03_Regular_White_400x400.webm`]
        },
        "04": {
          blue: [lg`Particles/ParticlesInward02_04_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward02_04_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward02_04_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward02_04_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward02_04_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward02_04_Regular_White_400x400.webm`]
        },
        "05": {
          blue: [lg`Particles/ParticlesInward02_05_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesInward02_05_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesInward02_05_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesInward02_05_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesInward02_05_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesInward02_05_Regular_White_400x400.webm`]
        }
      },
      swirl: {
        "01": {
          blue: [lg`Particles/ParticlesSwirl01_01_Regular_Blue_400x400.webm`],
          greenyellow: [lg`Particles/ParticlesSwirl01_01_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesSwirl01_01_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesSwirl01_01_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesSwirl01_01_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesSwirl01_01_Regular_White_400x400.webm`]
        },
        "02": {
          blue: [lg`Particles/ParticlesSwirl02_01_Regular_Blue_400x400.webm`],
          green: [lg`Particles/ParticlesSwirl02_01_Regular_GreenYellow_400x400.webm`],
          orange: [lg`Particles/ParticlesSwirl02_01_Regular_Orange_400x400.webm`],
          purple: [lg`Particles/ParticlesSwirl02_01_Regular_Purple_400x400.webm`],
          red: [lg`Particles/ParticlesSwirl02_01_Regular_Red_400x400.webm`],
          white: [lg`Particles/ParticlesSwirl02_01_Regular_White_400x400.webm`]
        }
      }
    },
    shieldfx: {
      eldritchweb: {
        "01": {
          darkgreen: [lg`Energy/ShieldEldritchWebAbove01_01_Dark_Green_400x400.webm`],
          darkpurple: [lg`Energy/ShieldEldritchWebAbove01_01_Dark_Purple_400x400.webm`]
        },
        "03": {
          darkgreen: [lg`Energy/ShieldEldritchWebAbove01_03_Dark_Green_400x400.webm`],
          darkpurple: [lg`Energy/ShieldEldritchWebAbove01_03_Dark_Purple_400x400.webm`]
        }
      },
      /*
      shieldeldritchwebbottom: {
          '01': {
              darkgreen: [lg`Energy/ShieldEldritchWebBelow01_02_Dark_Green_400x400.webm`],
              darkpurple: [lg`Energy/ShieldEldritchWebBelow01_02_Dark_Purple_400x400.webm`],
          },
          '03': {
              darkgreen: [lg`Energy/ShieldEldritchWebBelow01_03_Dark_Green_400x400.webm`],
              darkpurple: [lg`Energy/ShieldEldritchWebBelow01_03_Dark_Purple_400x400.webm`],
          }
      },
      */
      fire: {
        "01": {
          darkgreen: [lg`Fire/ShieldFireAbove01_01_Dark_Green_400x400.webm`],
          orange: [lg`Fire/ShieldFireAbove01_01_Regular_Orange_400x400.webm`]
        },
        "03": {
          darkgreen: [lg`Fire/ShieldFireAbove01_03_Dark_Green_400x400.webm`],
          orange: [lg`Fire/ShieldFireAbove01_03_Regular_Orange_400x400.webm`]
        }
      },
      /*
      shieldfirebottom: {
          '01': {
              darkgreen: [lg`Fire/ShieldFireBelow01_02_Dark_Green_400x400.webm`],
              orange: [lg`Fire/ShieldFireBelow01_02_Regular_Orange_400x400.webm`],
          },
          '03': {
              darkgreen: [lg`Fire/ShieldFireBelow01_03_Dark_Green_400x400.webm`],
              orange: [lg`Fire/ShieldFireBelow01_03_Regular_Orange_400x400.webm`],
          },
      },
      */
      earth: {
        "01": {
          darkorange: [lg`Fire/ShieldMoltenEarthAbove01_01_Dark_Orange_400x400.webm`],
          orange: [lg`Fire/ShieldMoltenEarthAbove01_01_Regular_Orange_400x400.webm`]
        },
        "03": {
          darkorange: [lg`Fire/ShieldMoltenEarthAbove01_03_Dark_Orange_400x400.webm`],
          orange: [lg`Fire/ShieldMoltenEarthAbove01_03_Regular_Orange_400x400.webm`]
        }
      },
      /*
      shieldearthbottom: {
          '01': {
              darkorange: [lg`Fire/ShieldMoltenEarthBelow01_02_Dark_Orange_400x400.webm`],
              orange: [lg`Fire/ShieldMoltenEarthBelow01_02_Regular_Orange_400x400.webm`],
          },
          '03': {
              darkorange: [lg`Fire/ShieldMoltenEarthBelow01_03_Dark_Orange_400x400.webm`],
              orange: [lg`Fire/ShieldMoltenEarthBelow01_03_Regular_Orange_400x400.webm`],
          },
      },
      */
      ice: {
        "01": {
          blue: [lg`Ice/ShieldIceAbove01_01_Regular_Blue_400x400.webm`],
          purple: [lg`Ice/ShieldIceAbove01_01_Regular_Purple_400x400.webm`]
        },
        "03": {
          blue: [lg`Ice/ShieldIceAbove01_03_Regular_Blue_400x400.webm`],
          purple: [lg`Ice/ShieldIceAbove01_03_Regular_Purple_400x400.webm`]
        }
      },
      /*
      shieldicebottom: {
          '01': {
              blue: [lg`Ice/ShieldIceBelow01_02_Regular_Blue_400x400.webm`],
              purple: [lg`Ice/ShieldIceBelow01_02_Regular_Purple_400x400.webm`],
          },
          '03': {
              blue: [lg`Ice/ShieldIceBelow01_03_Regular_Blue_400x400.webm`],
              purple: [lg`Ice/ShieldIceBelow01_03_Regular_Purple_400x400.webm`],
          },
      },
      energyfieldbottom: {
          '01': {
              blue: [lg`Energy/EnergyFieldBot_02_Regular_Blue_400x400.webm`],
              green: [lg`Energy/EnergyFieldBot_02_Regular_Green_400x400.webm`],
              purple: [lg`Energy/EnergyFieldBot_02_Regular_Purple_400x400.webm`],
          }
      },
      */
      energyfield: {
        "01": {
          blue: [lg`Energy/EnergyFieldTop_02_Regular_Blue_400x400.webm`],
          green: [lg`Energy/EnergyFieldTop_02_Regular_Green_400x400.webm`],
          purple: [lg`Energy/EnergyFieldTop_02_Regular_Purple_400x400.webm`]
        }
      }
    },
    shieldspell: {
      intro: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_Intro_400x400.webm`],
          green: [l1`Shield/Shield_01_Regular_Green_Intro_400x400.webm`],
          purple: [l1`Shield/Shield_01_Regular_Purple_Intro_400x400.webm`],
          red: [l1`Shield/Shield_01_Regular_Red_Intro_400x400.webm`],
          yellow: [l1`Shield/Shield_01_Regular_Yellow_Intro_400x400.webm`]
        },
        "02": {
          blue: [l1`Shield/Shield_02_Regular_Blue_Intro_400x400.webm`],
          green: [l1`Shield/Shield_02_Regular_Green_Intro_400x400.webm`],
          purple: [l1`Shield/Shield_02_Regular_Purple_Intro_400x400.webm`],
          red: [l1`Shield/Shield_02_Regular_Red_Intro_400x400.webm`],
          yellow: [l1`Shield/Shield_02_Regular_Yellow_Intro_400x400.webm`]
        },
        "03": {
          blue: [l1`Shield/Shield_03_Regular_Blue_Intro_400x400.webm`],
          green: [l1`Shield/Shield_03_Regular_Green_Intro_400x400.webm`],
          purple: [l1`Shield/Shield_03_Regular_Purple_Intro_400x400.webm`],
          red: [l1`Shield/Shield_03_Regular_Red_Intro_400x400.webm`],
          yellow: [l1`Shield/Shield_03_Regular_Yellow_Intro_400x400.webm`]
        }
      },
      loop: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_Loop_400x400.webm`],
          green: [l1`Shield/Shield_01_Regular_Green_Loop_400x400.webm`],
          purple: [l1`Shield/Shield_01_Regular_Purple_Loop_400x400.webm`],
          red: [l1`Shield/Shield_01_Regular_Red_Loop_400x400.webm`],
          yellow: [l1`Shield/Shield_01_Regular_Yellow_Loop_400x400.webm`]
        },
        "02": {
          blue: [l1`Shield/Shield_02_Regular_Blue_Loop_400x400.webm`],
          green: [l1`Shield/Shield_02_Regular_Green_Loop_400x400.webm`],
          purple: [l1`Shield/Shield_02_Regular_Purple_Loop_400x400.webm`],
          red: [l1`Shield/Shield_02_Regular_Red_Loop_400x400.webm`],
          yellow: [l1`Shield/Shield_02_Regular_Yellow_Loop_400x400.webm`]
        },
        "03": {
          blue: [l1`Shield/Shield_03_Regular_Blue_Loop_400x400.webm`],
          green: [l1`Shield/Shield_03_Regular_Green_Loop_400x400.webm`],
          purple: [l1`Shield/Shield_03_Regular_Purple_Loop_400x400.webm`],
          red: [l1`Shield/Shield_03_Regular_Red_Loop_400x400.webm`],
          yellow: [l1`Shield/Shield_03_Regular_Yellow_Loop_400x400.webm`]
        }
      },
      outro_explode: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_OutroExplode_400x400.webm`],
          green: [l1`Shield/Shield_01_Regular_Green_OutroExplode_400x400.webm`],
          purple: [l1`Shield/Shield_01_Regular_Purple_OutroExplode_400x400.webm`],
          red: [l1`Shield/Shield_01_Regular_Red_OutroExplode_400x400.webm`],
          yellow: [l1`Shield/Shield_01_Regular_Yellow_OutroExplode_400x400.webm`]
        },
        "02": {
          blue: [l1`Shield/Shield_02_Regular_Blue_OutroExplode_400x400.webm`],
          green: [l1`Shield/Shield_02_Regular_Green_OutroExplode_400x400.webm`],
          purple: [l1`Shield/Shield_02_Regular_Purple_OutroExplode_400x400.webm`],
          red: [l1`Shield/Shield_02_Regular_Red_OutroExplode_400x400.webm`],
          yellow: [l1`Shield/Shield_02_Regular_Yellow_OutroExplode_400x400.webm`]
        },
        "03": {
          blue: [l1`Shield/Shield_03_Regular_Blue_OutroExplode_400x400.webm`],
          green: [l1`Shield/Shield_03_Regular_Green_OutroExplode_400x400.webm`],
          purple: [l1`Shield/Shield_03_Regular_Purple_OutroExplode_400x400.webm`],
          red: [l1`Shield/Shield_03_Regular_Red_OutroExplode_400x400.webm`],
          yellow: [l1`Shield/Shield_03_Regular_Yellow_OutroExplode_400x400.webm`]
        }
      },
      outro_fade: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_OutroFade_400x400.webm`],
          green: [l1`Shield/Shield_01_Regular_Green_OutroFade_400x400.webm`],
          purple: [l1`Shield/Shield_01_Regular_Green_OutroFade_400x400.webm`],
          red: [l1`Shield/Shield_01_Regular_Red_OutroFade_400x400.webm`],
          yellow: [l1`Shield/Shield_01_Regular_Yellow_OutroFade_400x400.webm`]
        },
        "02": {
          blue: [l1`Shield/Shield_02_Regular_Blue_OutroFade_400x400.webm`],
          green: [l1`Shield/Shield_02_Regular_Green_OutroFade_400x400.webm`],
          purple: [l1`Shield/Shield_02_Regular_Purple_OutroFade_400x400.webm`],
          red: [l1`Shield/Shield_02_Regular_Red_OutroFade_400x400.webm`],
          yellow: [l1`Shield/Shield_02_Regular_Yellow_OutroFade_400x400.webm`]
        },
        "03": {
          blue: [l1`Shield/Shield_03_Regular_Blue_OutroFade_400x400.webm`],
          green: [l1`Shield/Shield_03_Regular_Green_OutroFade_400x400.webm`],
          purple: [l1`Shield/Shield_03_Regular_Purple_OutroFade_400x400.webm`],
          red: [l1`Shield/Shield_03_Regular_Red_OutroFade_400x400.webm`],
          yellow: [l1`Shield/Shield_03_Regular_Yellow_OutroFade_400x400.webm`]
        }
      },
      complete: {
        "01": {
          _markers: {
            loop: { start: 1533, end: 5533 },
            forcedEnd: 5533
          },
          blue: [l1`Shield/Shield_01_Regular_Blue_Complete_400x400.webm`],
          green: [l1`Shield/Shield_01_Regular_Green_Complete_400x400.webm`],
          purple: [l1`Shield/Shield_01_Regular_Purple_Complete_400x400.webm`],
          red: [l1`Shield/Shield_01_Regular_Red_Complete_400x400.webm`],
          yellow: [l1`Shield/Shield_01_Regular_Yellow_Complete_400x400.webm`]
        },
        "02": {
          _markers: {
            loop: { start: 1533, end: 5533 },
            forcedEnd: 5533
          },
          blue: [l1`Shield/Shield_02_Regular_Blue_Complete_400x400.webm`],
          green: [l1`Shield/Shield_02_Regular_Green_Complete_400x400.webm`],
          purple: [l1`Shield/Shield_02_Regular_Purple_Complete_400x400.webm`],
          red: [l1`Shield/Shield_02_Regular_Red_Complete_400x400.webm`],
          yellow: [l1`Shield/Shield_02_Regular_Yellow_Complete_400x400.webm`]
        },
        "03": {
          _markers: {
            loop: { start: 1533, end: 5533 },
            forcedEnd: 5533
          },
          blue: [l1`Shield/Shield_03_Regular_Blue_Complete_400x400.webm`],
          green: [l1`Shield/Shield_03_Regular_Green_Complete_400x400.webm`],
          purple: [l1`Shield/Shield_03_Regular_Purple_Complete_400x400.webm`],
          red: [l1`Shield/Shield_03_Regular_Red_Complete_400x400.webm`],
          yellow: [l1`Shield/Shield_03_Regular_Yellow_Complete_400x400.webm`]
        }
      }
    },
    shrapnel: {
      bomb: {
        "01": {
          black: [lg`Explosion/ShrapnelBomb01_01_Regular_Black_800x800.webm`],
          blue: [lg`Explosion/ShrapnelBomb01_01_Regular_Blue_800x800.webm`],
          green: [lg`Explosion/ShrapnelBomb01_01_Regular_Green_800x800.webm`],
          grey: [lg`Explosion/ShrapnelBomb01_01_Regular_Grey_800x800.webm`],
          red: [lg`Explosion/ShrapnelBomb01_01_Regular_Red_800x800.webm`]
        }
      },
      grenade: {
        "01": {
          green: [lg`Explosion/ShrapnelGrenade01_01_Regular_Green_800x800.webm`]
        },
        "02": {
          black: [lg`Explosion/ShrapnelGrenade02_01_Regular_Black_800x800.webm`]
        },
        "03": {
          black: [lg`Explosion/ShrapnelGrenade03_01_Regular_Black_800x800.webm`]
        }
      }
    },
    spell: {
      antilifeshell: {
        "01": {
          blue: [l5`Antilife_Shell/AntilifeShell_01_Blue_NoCircle_400x400.webm`]
        }
      },
      armsofhadar: {
        "01": {
          darkgreen: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Green_500x500.webm`],
          darkpurple: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Purple_500x500.webm`],
          darkred: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Red_500x500.webm`]
        }
      },
      bardicinspiration: {
        inspire: {
          yellowblue: [l1`Bardic_Inspiration/BardicInspiration_01_Regular_BlueYellow_400x400.webm`],
          greenorange: [l1`Bardic_Inspiration/BardicInspiration_01_Regular_GreenOrange_400x400.webm`],
          purplepink: [l1`Bardic_Inspiration/BardicInspiration_01_Regular_PurplePink_400x400.webm`],
          darkred: [l1`Bardic_Inspiration/BardicInspiration_01_Dark_Red_400x400.webm`],
          pink: [l1`Bardic_Inspiration/BardicInspiration_01_Regular_Pink_400x400.webm`]
        },
        marker: {
          yellowblue: [lg`Marker/MusicMarker_01_Regular_BlueYellow_400x400.webm`],
          greenorange: [lg`Marker/MusicMarker_01_Regular_GreenOrange_400x400.webm`],
          pink: [lg`Marker/MusicMarker_01_Regular_Pink_400x400.webm`],
          purplepink: [lg`Marker/MusicMarker_01_Regular_PurplePink_400x400.webm`],
          darkred: [lg`Marker/MusicMarker_01_Dark_Red_400x400.webm`]
        }
      },
      blacktentacles: {
        "01": {
          darkgreen: [l4`Black_Tentacles/BlackTentacles_01_Dark_Green_600x600.webm`],
          darkpurple: [l4`Black_Tentacles/BlackTentacles_01_Dark_Purple_600x600.webm`],
          darkred: [l4`Black_Tentacles/BlackTentacles_01_Dark_Red_600x600.webm`]
        }
      },
      bless: {
        "intro": {
          blue: [l1`Bless/Bless_01_Regular_Blue_Intro_400x400.webm`],
          green: [l1`Bless/Bless_01_Regular_Green_Intro_400x400.webm`],
          purple: [l1`Bless/Bless_01_Regular_Purple_Intro_400x400.webm`],
          yellow: [l1`Bless/Bless_01_Regular_Yellow_Intro_400x400.webm`]
        },
        "loop": {
          blue: [l1`Bless/Bless_01_Regular_Blue_Loop_400x400.webm`],
          green: [l1`Bless/Bless_01_Regular_Green_Loop_400x400.webm`],
          purple: [l1`Bless/Bless_01_Regular_Purple_Loop_400x400.webm`],
          yellow: [l1`Bless/Bless_01_Regular_Yellow_Loop_400x400.webm`]
        }
      },
      calllightning: {
        "01": {
          blue: [l3`Call_Lightning/CallLightning_01_Blue_1000x1000.webm`],
          blueorange: [l3`Call_Lightning/CallLightning_01_BlueOrange_1000x1000.webm`],
          green: [l3`Call_Lightning/CallLightning_01_Green_1000x1000.webm`],
          pinkyellow: [l3`Call_Lightning/CallLightning_01_PinkYellow_1000x1000.webm`],
          purple: [l3`Call_Lightning/CallLightning_01_Purple_1000x1000.webm`],
          red: [l3`Call_Lightning/CallLightning_01_Red_1000x1000.webm`],
          yellow: [l3`Call_Lightning/CallLightning_01_Yellow_1000x1000.webm`]
        }
      },
      cloudofdaggers: {
        "01": {
          darkpurple: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Dark_Purple_400x400.webm`],
          darkred: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Dark_Red_400x400.webm`],
          blue: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Blue_400x400.webm`],
          green: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Green_400x400.webm`],
          orange: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Orange_400x400.webm`],
          purple: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Purple_400x400.webm`],
          red: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Red_400x400.webm`],
          yellow: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Yellow_400x400.webm`]
        },
        kunai: {
          darkpurple: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Dark_Purple_400x400.webm`],
          darkred: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Dark_Red_400x400.webm`],
          blue: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Blue_400x400.webm`],
          green: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Green_400x400.webm`],
          orange: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Orange_400x400.webm`],
          purple: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Purple_400x400.webm`],
          red: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Red_400x400.webm`],
          yellow: [l2`Cloud_Of_Daggers/CloudOfDaggers_Kunai_01_Light_Yellow_400x400.webm`]
        }
      },
      curewounds: {
        "01": {
          blue: [l1`Cure_Wounds/CureWounds_01_Blue_400x400.webm`],
          green: [l1`Cure_Wounds/CureWounds_01_Green_400x400.webm`],
          pink: [l1`Cure_Wounds/CureWounds_01_Pink_400x400.webm`],
          purple: [l1`Cure_Wounds/CureWounds_01_Purple_400x400.webm`],
          red: [l1`Cure_Wounds/CureWounds_01_Red_400x400.webm`]
        }
      },
      darkness: {
        "01": {
          black: [l2`Darkness/Darkness_01_Black_600x600.webm`],
          green: [l2`Darkness/Darkness_01_Green_600x600.webm`]
        }
      },
      detectmagic: {
        "01": {
          blue: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Blue_1200x1200.webm`],
          green: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Green_1200x1200.webm`],
          greenorange: [l1`Detect_Magic/DetectMagicCircle_01_Regular_GreenOrange_1200x1200.webm`],
          grey: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Grey_1200x1200.webm`],
          purple: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Purple_1200x1200.webm`]
        }
      },
      divinesmite: {
        "source": {
          yellowblue: [l2`Divine_Smite/DivineSmite_01_Regular_BlueYellow_Caster_400x400.webm`],
          greenyellow: [l2`Divine_Smite/DivineSmite_01_Regular_GreenYellow_Caster_400x400.webm`],
          orange: [l2`Divine_Smite/DivineSmite_01_Regular_Orange_Caster_400x400.webm`],
          purplepink: [l2`Divine_Smite/DivineSmite_01_Regular_PurplePink_Caster_400x400.webm`],
          darkpurple: [l2`Divine_Smite/DivineSmite_01_Dark_Purple_Caster_400x400.webm`],
          yellowwhite: [l2`Divine_Smite/DivineSmite_01_Regular_YellowWhite_Caster_400x400.webm`],
          darkred: [l2`Divine_Smite/DivineSmite_01_Dark_Red_Caster_400x400.webm`]
        },
        "target": {
          yellowblue: [l2`Divine_Smite/DivineSmite_01_Regular_BlueYellow_Target_400x400.webm`],
          greenyellow: [l2`Divine_Smite/DivineSmite_01_Regular_GreenYellow_Target_400x400.webm`],
          orange: [l2`Divine_Smite/DivineSmite_01_Regular_Orange_Target_400x400.webm`],
          purplepink: [l2`Divine_Smite/DivineSmite_01_Regular_PurplePink_Target_400x400.webm`],
          darkpurple: [l2`Divine_Smite/DivineSmite_01_Dark_Purple_Target_400x400.webm`],
          yellowwhite: [l2`Divine_Smite/DivineSmite_01_Regular_YellowWhite_Target_400x400.webm`],
          darkred: [l2`Divine_Smite/DivineSmite_01_Dark_Red_Target_400x400.webm`]
        }
      },
      entangle: {
        "01": {
          brown: [l1`Entangle/Entangle_01_Brown_400x400.webm`],
          green: [l1`Entangle/Entangle_01_Green_400x400.webm`],
          yellow: [l1`Entangle/Entangle_01_Yellow_400x400.webm`],
          darkpurple: [l1`Entangle/Entangle_01_Dark_Purple_400x400.webm`],
          palegreen: [l1`Entangle/Entangle_01_Regular_Green02_400x400.webm`]
        }
      },
      fireball: {
        loop: {
          blue: [l3`Fireball/FireballLoop_01_Blue_800x800.webm`],
          orange: [l3`Fireball/FireballLoop_01_Orange_800x800.webm`],
          purple: [l3`Fireball/FireballLoop_01_Purple_800x800.webm`]
        },
        explode: {
          blue: [l3`Fireball/FireballExplosion_01_Blue_800x800.webm`],
          orange: [l3`Fireball/FireballExplosion_01_Orange_800x800.webm`],
          purple: [l3`Fireball/FireballExplosion_01_Purple_800x800.webm`]
        },
        nodebris: {
          blue: [l3`Fireball/FireballLoopNoDebris_01_Blue_800x800.webm`],
          orange: [l3`Fireball/FireballLoopNoDebris_01_Orange_800x800.webm`],
          purple: [l3`Fireball/FireballLoopNoDebris_01_Purple_800x800.webm`]
        }
      },
      fogcloud: {
        "01": {
          white: [l1`Fog_Cloud/FogCloud_01_White_800x800.webm`]
        },
        "02": {
          white: [l1`Fog_Cloud/FogCloud_02_Regular_White_800x800.webm`],
          green: [l1`Fog_Cloud/FogCloud_02_Regular_Green_800x800.webm`]
        }
      },
      generichealing: {
        "01": {
          blue: [lg`Healing/HealingAbility_01_Blue_400x400.webm`],
          green: [lg`Healing/HealingAbility_01_Green_400x400.webm`],
          purple: [lg`Healing/HealingAbility_01_Purple_400x400.webm`],
          red: [lg`Healing/HealingAbility_01_Red_400x400.webm`],
          yellow: [lg`Healing/HealingAbility_01_Yellow_400x400.webm`]
        },
        "02": {
          whiteblue: [lg`Healing/HealingAbility_02_Regular_BlueWhite_Burst_600x600.webm`],
          greenorange: [lg`Healing/HealingAbility_02_Regular_GreenOrange_Burst_600x600.webm`],
          purplepink: [lg`Healing/HealingAbility_02_Regular_PurplePink_Burst_600x600.webm`],
          tealyellow: [lg`Healing/HealingAbility_02_Regular_TealYellow_Burst_600x600.webm`]
        }
      },
      grease: {
        "01": {
          brown: [l1`Grease/Grease_Dark_Brown_600x600.webm`],
          green: [l1`Grease/Grease_Dark_Green_600x600.webm`],
          grey: [l1`Grease/Grease_Dark_Grey_600x600.webm`],
          purple: [l1`Grease/Grease_Dark_Purple_600x600.webm`]
        }
      },
      huntersmark: {
        "eye": {
          blue: [l1`Hunters_Mark/HuntersMark_01_Regular_Blue_Pulse_200x200.webm`],
          green: [l1`Hunters_Mark/HuntersMark_01_Regular_Green_Pulse_200x200.webm`],
          purple: [l1`Hunters_Mark/HuntersMark_01_Regular_Purple_Pulse_200x200.webm`],
          red: [l1`Hunters_Mark/HuntersMark_01_Regular_Red_Pulse_200x200.webm`]
        },
        "eyeloop": {
          blue: [l1`Hunters_Mark/HuntersMark_01_Regular_Blue_Loop_200x200.webm`],
          green: [l1`Hunters_Mark/HuntersMark_01_Regular_Green_Loop_200x200.webm`],
          purple: [l1`Hunters_Mark/HuntersMark_01_Regular_Purple_Loop_200x200.webm`],
          red: [l1`Hunters_Mark/HuntersMark_01_Regular_Red_Loop_200x200.webm`]
        },
        "paw": {
          blue: [l1`Hunters_Mark/HuntersMark_02_Regular_Blue_Pulse_200x200.webm`],
          green: [l1`Hunters_Mark/HuntersMark_02_Regular_Green_Pulse_200x200.webm`],
          purple: [l1`Hunters_Mark/HuntersMark_02_Regular_Purple_Pulse_200x200.webm`],
          red: [l1`Hunters_Mark/HuntersMark_02_Regular_Red_Pulse_200x200.webm`]
        },
        "pawloop": {
          blue: [l1`Hunters_Mark/HuntersMark_02_Regular_Blue_Loop_200x200.webm`],
          green: [l1`Hunters_Mark/HuntersMark_02_Regular_Green_Loop_200x200.webm`],
          purple: [l1`Hunters_Mark/HuntersMark_02_Regular_Purple_Loop_200x200.webm`],
          red: [l1`Hunters_Mark/HuntersMark_02_Regular_Red_Loop_200x200.webm`]
        }
      },
      mistystep: {
        "01": {
          black: [l2`Misty_Step/MistyStep_01_Dark_Black_400x400.webm`],
          blue: [l2`Misty_Step/MistyStep_01_Regular_Blue_400x400.webm`],
          green: [l2`Misty_Step/MistyStep_01_Regular_Green_400x400.webm`],
          orange: [l2`Misty_Step/MistyStep_01_Regular_Orange_400x400.webm`],
          purple: [l2`Misty_Step/MistyStep_01_Regular_Purple_400x400.webm`],
          darkgreen: [l2`Misty_Step/MistyStep_01_Dark_Green_400x400.webm`],
          darkred: [l2`Misty_Step/MistyStep_01_Dark_Red_400x400.webm`],
          grey: [l2`Misty_Step/MistyStep_01_Regular_Grey_400x400.webm`],
          red: [l2`Misty_Step/MistyStep_01_Regular_Red_400x400.webm`],
          yellow: [l2`Misty_Step/MistyStep_01_Regular_Yellow_400x400.webm`]
        },
        "02": {
          black: [l2`Misty_Step/MistyStep_02_Dark_Black_400x400.webm`],
          blue: [l2`Misty_Step/MistyStep_02_Regular_Blue_400x400.webm`],
          green: [l2`Misty_Step/MistyStep_02_Regular_Green_400x400.webm`],
          orange: [l2`Misty_Step/MistyStep_02_Regular_Orange_400x400.webm`],
          purple: [l2`Misty_Step/MistyStep_02_Regular_Purple_400x400.webm`],
          darkgreen: [l2`Misty_Step/MistyStep_02_Dark_Green_400x400.webm`],
          darkred: [l2`Misty_Step/MistyStep_02_Dark_Red_400x400.webm`],
          grey: [l2`Misty_Step/MistyStep_02_Regular_Grey_400x400.webm`],
          red: [l2`Misty_Step/MistyStep_02_Regular_Red_400x400.webm`],
          yellow: [l2`Misty_Step/MistyStep_02_Regular_Yellow_400x400.webm`]
        }
      },
      moonbeam: {
        loop: {
          blue: [l2`Moonbeam/Moonbeam_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/Moonbeam_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/Moonbeam_01_Regular_Rainbow_400x400.webm`]
        },
        nopulse: {
          blue: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Rainbow_400x400.webm`]
        },
        intro: {
          blue: [l2`Moonbeam/MoonbeamIntro_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/MoonbeamIntro_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/MoonbeamIntro_01_Regular_Rainbow_400x400.webm`]
        },
        outro: {
          blue: [l2`Moonbeam/MoonbeamOutro_01_Regular_Blue_400x400.webm`],
          green: [l2`Moonbeam/MoonbeamOutro_01_Regular_Green_400x400.webm`],
          rainbow: [l2`Moonbeam/MoonbeamOutro_01_Regular_Rainbow_400x400.webm`]
        }
      },
      sacredflame: {
        source: {
          blue: [l0`Sacred_Flame/SacredFlameSource_01_Regular_Blue_400x400.webm`],
          green: [l0`Sacred_Flame/SacredFlameSource_01_Regular_Green_400x400.webm`],
          purple: [l0`Sacred_Flame/SacredFlameSource_01_Regular_Purple_400x400.webm`],
          yellow: [l0`Sacred_Flame/SacredFlameSource_01_Regular_Yellow_400x400.webm`],
          white: [l0`Sacred_Flame/SacredFlameSource_01_Regular_White_400x400.webm`]
        },
        target: {
          blue: [l0`Sacred_Flame/SacredFlameTarget_01_Regular_Blue_400x400.webm`],
          green: [l0`Sacred_Flame/SacredFlameTarget_01_Regular_Green_400x400.webm`],
          purple: [l0`Sacred_Flame/SacredFlameTarget_01_Regular_Purple_400x400.webm`],
          yellow: [l0`Sacred_Flame/SacredFlameTarget_01_Regular_Yellow_400x400.webm`],
          white: [l0`Sacred_Flame/SacredFlameTarget_01_Regular_White_400x400.webm`]
        }
      },
      sneakattack: {
        "01": {
          darkgreen: [l1`Sneak_Attack/Sneak_Attack_Dark_Green_300x300.webm`],
          darkpurple: [l1`Sneak_Attack/Sneak_Attack_Dark_Purple_300x300.webm`],
          darkred: [l1`Sneak_Attack/Sneak_Attack_Dark_Red_300x300.webm`],
          blue: [l1`Sneak_Attack/Sneak_Attack_Regular_Blue_300x300.webm`],
          orange: [l1`Sneak_Attack/Sneak_Attack_Regular_Orange_300x300.webm`],
          pink: [l1`Sneak_Attack/Sneak_Attack_Regular_Pink_300x300.webm`],
          yellow: [l1`Sneak_Attack/Sneak_Attack_Regular_Yellow_300x300.webm`]
        }
      },
      thunderwave: {
        left: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BLeft_600x600.webm`],
          green: [l1`Thunderwave/Thunderwave_01_Bright_Green_BLeft_600x600.webm`],
          orange: [l1`Thunderwave/Thunderwave_01_Bright_Orange_BLeft_600x600.webm`],
          purple: [l1`Thunderwave/Thunderwave_01_Dark_Purple_BLeft_600x600.webm`],
          red: [l1`Thunderwave/Thunderwave_01_Dark_Red_BLeft_600x600.webm`]
        },
        mid: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BMid_600x600.webm`],
          green: [l1`Thunderwave/Thunderwave_01_Bright_Green_BMid_600x600.webm`],
          orange: [l1`Thunderwave/Thunderwave_01_Bright_Orange_BMid_600x600.webm`],
          purple: [l1`Thunderwave/Thunderwave_01_Dark_Purple_BMid_600x600.webm`],
          red: [l1`Thunderwave/Thunderwave_01_Dark_Red_BMid_600x600.webm`]
        },
        center: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_Center_600x600.webm`],
          green: [l1`Thunderwave/Thunderwave_01_Bright_Green_Center_600x600.webm`],
          orange: [l1`Thunderwave/Thunderwave_01_Bright_Orange_Center_600x600.webm`],
          purple: [l1`Thunderwave/Thunderwave_01_Dark_Purple_Center_600x600.webm`],
          red: [l1`Thunderwave/Thunderwave_01_Dark_Red_Center_600x600.webm`]
        }
      },
      shatter: {
        "01": {
          purple: [l2`Shatter/Shatter_01_Purple_400x400.webm`],
          red: [l2`Shatter/Shatter_01_Red_400x400.webm`],
          blue: [l2`Shatter/Shatter_01_Blue_400x400.webm`],
          green: [l2`Shatter/Shatter_01_Green_400x400.webm`],
          orange: [l2`Shatter/Shatter_01_Orange_400x400.webm`]
        }
      },
      sleep: {
        "01": {
          darkpurple: [l1`Sleep/Cloud01_01_Dark_Purple_400x400.webm`],
          blue: [l1`Sleep/Cloud01_01_Regular_Blue_400x400.webm`],
          green: [l1`Sleep/Cloud01_01_Regular_Green_400x400.webm`],
          orangepurple: [l1`Sleep/Cloud01_01_Dark_OrangePurple_400x400.webm`],
          pink: [l1`Sleep/Cloud01_01_Regular_Pink_400x400.webm`],
          yellow: [l1`Sleep/Cloud01_01_Regular_Yellow_400x400.webm`]
        },
        "02": {
          darkpurple: [l1`Sleep/Cloud01_02_Dark_Purple_400x400.webm`],
          blue: [l1`Sleep/Cloud01_02_Regular_Blue_400x400.webm`],
          green: [l1`Sleep/Cloud01_02_Regular_Green_400x400.webm`],
          orangepurple: [l1`Sleep/Cloud01_02_Dark_OrangePurple_400x400.webm`],
          pink: [l1`Sleep/Cloud01_02_Regular_Pink_400x400.webm`],
          yellow: [l1`Sleep/Cloud01_02_Regular_Yellow_400x400.webm`]
        },
        marker: {
          darkpurple: [l1`Sleep/SleepMarker01_01_Dark_Purple_400x400.webm`],
          blue: [l1`Sleep/SleepMarker01_01_Regular_Blue_400x400.webm`],
          green: [l1`Sleep/SleepMarker01_01_Regular_Green_400x400.webm`],
          orangepurple: [l1`Sleep/SleepMarker01_01_Dark_OrangePurple_400x400.webm`],
          pink: [l1`Sleep/SleepMarker01_01_Regular_Pink_400x400.webm`],
          yellow: [l1`Sleep/SleepMarker01_01_Regular_Yellow_400x400.webm`]
        },
        symbol: {
          darkpurple: [l1`Sleep/SleepSymbol01_01_Dark_Purple_400x400.webm`],
          blue: [l1`Sleep/SleepSymbol01_01_Regular_Blue_400x400.webm`],
          green: [l1`Sleep/SleepSymbol01_01_Regular_Green_400x400.webm`],
          orangepurple: [l1`Sleep/SleepSymbol01_01_Dark_OrangePurple_400x400.webm`],
          pink: [l1`Sleep/SleepSymbol01_01_Regular_Pink_400x400.webm`],
          yellow: [l1`Sleep/SleepSymbol01_01_Regular_Yellow_400x400.webm`]
        }
      },
      sleetstorm: {
        "01": {
          blue: [l3`Sleet_Storm/SleetStorm_01_Blue_800x800.webm`],
          green: [l3`Sleet_Storm/SleetStorm_01_Green_800x800.webm`],
          purple: [l3`Sleet_Storm/SleetStorm_01_Purple_800x800.webm`],
          tealyellow: [l3`Sleet_Storm/SleetStorm_01_TealYellow_800x800.webm`]
        }
      },
      spiritguardians: {
        "01": {
          black: [l3`Spirit_Guardians/SpiritGuardians_01_Dark_Black_600x600.webm`],
          darkblue: [l3`Spirit_Guardians/SpiritGuardians_01_Dark_Blue_600x600.webm`],
          darkpurple: [l3`Spirit_Guardians/SpiritGuardians_01_Dark_Purple_600x600.webm`],
          darkred: [l3`Spirit_Guardians/SpiritGuardians_01_Dark_Red_600x600.webm`],
          darkwhiteblue: [l3`Spirit_Guardians/SpiritGuardians_01_Dark_WhiteBlue_600x600.webm`],
          greenorange: [l3`Spirit_Guardians/SpiritGuardians_01_Light_GreenOrange_600x600.webm`],
          lightblue: [l3`Spirit_Guardians/SpiritGuardians_01_Light_Blue_600x600.webm`],
          lightgreen: [l3`Spirit_Guardians/SpiritGuardians_01_Light_Green_600x600.webm`],
          lightorange: [l3`Spirit_Guardians/SpiritGuardians_01_Light_Orange_600x600.webm`],
          yellowblue: [l3`Spirit_Guardians/SpiritGuardians_01_Light_BlueYellow_600x600.webm`],
          purplepink: [l3`Spirit_Guardians/SpiritGuardians_01_Light_PinkPurple_600x600.webm`]
        },
        "02": {
          black: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Dark_Black_600x600.webm`],
          darkblue: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Dark_Blue_600x600.webm`],
          darkpurple: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Dark_Purple_600x600.webm`],
          darkred: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Dark_Red_600x600.webm`],
          darkwhiteblue: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Dark_WhiteBlue_600x600.webm`],
          greenorange: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Light_GreenOrange_600x600.webm`],
          lightblue: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Light_Blue_600x600.webm`],
          lightgreen: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Light_Green_600x600.webm`],
          lightorange: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Light_Orange_600x600.webm`],
          yellowblue: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Light_BlueYellow_600x600.webm`],
          purplepink: [l3`Spirit_Guardians/SpiritGuardiansParticles_01_Light_PinkPurple_600x600.webm`]
        },
        "03": {
          black: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Dark_Black_600x600.webm`],
          darkblue: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Dark_Blue_600x600.webm`],
          darkpurple: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Dark_Purple_600x600.webm`],
          darkred: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Dark_Red_600x600.webm`],
          darkwhiteblue: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Dark_WhiteBlue_600x600.webm`],
          greenorange: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Light_GreenOrange_600x600.webm`],
          lightblue: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Light_Blue_600x600.webm`],
          lightgreen: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Light_Green_600x600.webm`],
          lightorange: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Light_Orange_600x600.webm`],
          yellowblue: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Light_BlueYellow_600x600.webm`],
          purplepink: [l3`Spirit_Guardians/SpiritGuardiansSpirits_01_Light_PinkPurple_600x600.webm`]
        },
        noring: {
          black: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Dark_Black_600x600.webm`],
          darkblue: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Dark_Blue_600x600.webm`],
          darkpurple: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Dark_Purple_600x600.webm`],
          darkred: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Dark_Red_600x600.webm`],
          darkwhiteblue: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Dark_WhiteBlue_600x600.webm`],
          greenorange: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Light_GreenOrange_600x600.webm`],
          lightblue: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Light_Blue_600x600.webm`],
          lightgreen: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Light_Green_600x600.webm`],
          lightorange: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Light_Orange_600x600.webm`],
          yellowblue: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Light_BlueYellow_600x600.webm`],
          purplepink: [l3`Spirit_Guardians/SpiritGuardiansNoRing_01_Light_PinkPurple_600x600.webm`]
        }
      },
      tollthedead: {
        bell: {
          blue: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Blue_400x400.webm`],
          green: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Green_400x400.webm`],
          purple: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Purple_400x400.webm`],
          red: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Red_400x400.webm`],
          grey: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Grey_400x400.webm`]
        },
        complete: {
          blue: [l0`Toll_The_Dead/TollTheDead_01_Regular_Blue_400x400.webm`],
          green: [l0`Toll_The_Dead/TollTheDead_01_Regular_Green_400x400.webm`],
          purple: [l0`Toll_The_Dead/TollTheDead_01_Regular_Purple_400x400.webm`],
          red: [l0`Toll_The_Dead/TollTheDead_01_Regular_Red_400x400.webm`],
          grey: [l0`Toll_The_Dead/TollTheDead_01_Regular_Grey_400x400.webm`]
        },
        shockwave: {
          blue: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Blue_400x400.webm`],
          green: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Green_400x400.webm`],
          purple: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Purple_400x400.webm`],
          red: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Red_400x400.webm`],
          grey: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Grey_400x400.webm`]
        },
        skull: {
          blue: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Blue_400x400.webm`],
          green: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Green_400x400.webm`],
          purple: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Purple_400x400.webm`],
          red: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Red_400x400.webm`],
          grey: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Grey_400x400.webm`]
        }
      },
      wallofforce: {
        "01": {
          blue: [l5`Wall_Of_Force/WallOfForce_01_Blue_Sphere_400x400.webm`],
          green: [l5`Wall_Of_Force/WallOfForce_01_Green_Sphere_400x400.webm`],
          grey: [l5`Wall_Of_Force/WallOfForce_01_Grey_Sphere_400x400.webm`],
          orange: [l5`Wall_Of_Force/WallOfForce_01_Orange_Sphere_400x400.webm`],
          purple: [l5`Wall_Of_Force/WallOfForce_01_Purple_Sphere_400x400.webm`],
          red: [l5`Wall_Of_Force/WallOfForce_01_Red_Sphere_400x400.webm`],
          yellow: [l5`Wall_Of_Force/WallOfForce_01_Yellow_Sphere_400x400.webm`]
        }
      },
      web: {
        "01": {
          white: [l2`Web/Web_01_White_01_400x400.webm`]
        },
        "02": {
          white: [l2`Web/Web_01_White_02_400x400.webm`]
        }
      },
      whirlwind: {
        "01": {
          blue: [l7`Whirlwind/Whirlwind_01_Blue_400x400.webm`],
          bluegrey: [l7`Whirlwind/Whirlwind_01_BlueGrey_01_400x400.webm`],
          green: [l7`Whirlwind/Whirlwind_01_Green_400x400.webm`],
          purple: [l7`Whirlwind/Whirlwind_01_Purple_400x400.webm`],
          red: [l7`Whirlwind/Whirlwind_01_Red_400x400.webm`]
        }
      }
    },
    tokenborder: {
      static: {
        "01": {
          blue: [lg`Token_Border/TokenBorderCircle_01_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_01_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          blue: [lg`Token_Border/TokenBorderCircle_02_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_02_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          blue: [lg`Token_Border/TokenBorderCircle_03_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_03_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_03_Regular_Purple_400x400.webm`]
        },
        "04": {
          blue: [lg`Token_Border/TokenBorderCircle_04_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_04_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_04_Regular_Purple_400x400.webm`]
        },
        "05": {
          blue: [lg`Token_Border/TokenBorderCircle_05_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_05_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_05_Regular_Purple_400x400.webm`]
        },
        "06": {
          blue: [lg`Token_Border/TokenBorderCircle_06_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_06_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_06_Regular_Purple_400x400.webm`]
        },
        "07": {
          blue: [lg`Token_Border/TokenBorderCircle_07_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_07_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_07_Regular_Purple_400x400.webm`]
        },
        "08": {
          blue: [lg`Token_Border/TokenBorderCircle_08_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_08_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_08_Regular_Purple_400x400.webm`]
        },
        "09": {
          blue: [lg`Token_Border/TokenBorderCircle_09_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_09_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_09_Regular_Purple_400x400.webm`]
        },
        "10": {
          blue: [lg`Token_Border/TokenBorderCircle_10_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_10_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_10_Regular_Purple_400x400.webm`]
        },
        "11": {
          blue: [lg`Token_Border/TokenBorderCircle_11_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_11_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_11_Regular_Purple_400x400.webm`]
        },
        "12": {
          blue: [lg`Token_Border/TokenBorderCircle_12_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_12_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_12_Regular_Purple_400x400.webm`]
        },
        "13": {
          blue: [lg`Token_Border/TokenBorderCircle_13_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircle_13_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircle_13_Regular_Purple_400x400.webm`]
        }
      },
      spinning: {
        "01": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_01_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_01_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_02_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_02_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_03_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_03_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_03_Regular_Purple_400x400.webm`]
        },
        "04": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_04_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_04_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_04_Regular_Purple_400x400.webm`]
        },
        "05": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_05_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_05_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_05_Regular_Purple_400x400.webm`]
        },
        "06": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_06_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_06_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_06_Regular_Purple_400x400.webm`]
        },
        "07": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_07_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_07_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_07_Regular_Purple_400x400.webm`]
        },
        "08": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_08_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_08_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_08_Regular_Purple_400x400.webm`]
        },
        "09": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_09_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_09_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_09_Regular_Purple_400x400.webm`]
        },
        "10": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_10_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_10_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_10_Regular_Purple_400x400.webm`]
        },
        "11": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_11_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_11_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_11_Regular_Purple_400x400.webm`]
        },
        "12": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_12_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_12_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_12_Regular_Purple_400x400.webm`]
        },
        "13": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_13_Regular_Blue_400x400.webm`],
          orange: [lg`Token_Border/TokenBorderCircleSpin_13_Regular_Orange_400x400.webm`],
          purple: [lg`Token_Border/TokenBorderCircleSpin_13_Regular_Purple_400x400.webm`]
        }
      }
    },
    trap: {
      fire: {
        single: {
          orange: [lg`Traps/FireTrap02_01_Regular_Orange_1400x1400.webm`],
          green: [lg`Traps/FireTrap02_01_Regular_Green_1400x1400.webm`]
        },
        double: {
          orange: [lg`Traps/FireTrapDual02_01_Regular_Orange_1400x1400.webm`],
          green: [lg`Traps/FireTrapDual02_01_Regular_Green_1400x1400.webm`]
        }
      }
    }
  };
  JB2APATREONDB.return = {
    _template: "ranged",
    weapon: {
      bone: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bone01_01_Regular_White_Return_90ft_4000x400.webm`]
          }
        }
      },
      chakram: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Chakram01_01_Regular_White_Return_90ft_4000x400.webm`]
          }
        }
      },
      dagger: {
        "01": {
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_Blue_Return_90ft_4000x400.webm`]
          },
          darkpurple: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Dark_Purple_Return_90ft_4000x400.webm`]
          },
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_90ft_4000x400.webm`]
          },
          pink: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_90ft_4000x400.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_Return_90ft_4000x400.webm`]
          }
        },
        "02": {
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Blue_Return_90ft_4000x400.webm`]
          },
          darkpurple: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Dark_Purple_Return_90ft_4000x400.webm`]
          },
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_White_Return_90ft_4000x400.webm`]
          },
          pink: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Pink_Return_90ft_4000x400.webm`]
          },
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger02_01_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      dart: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dart01_01_Regular_White_Return_90ft_4000x400.webm`]
          }
        }
      },
      greatsword: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_Return_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_Return_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_Return_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/GreatSword01_01_Regular_White_Return_90ft_4000x600.webm`]
          }
        }
      },
      hammer: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Hammer01_01_Regular_White_Return_90ft_4000x400.webm`]
          }
        }
      },
      javelin: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_Return_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_Return_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_Return_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Javelin01_01_Regular_White_Return_90ft_4000x600.webm`]
          }
        }
      },
      spear: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_Return_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_Return_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_Return_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Spear01_01_Regular_White_Return_90ft_4000x600.webm`]
          }
        }
      }
    }
  };
}
const JB2AFREEDB = {};
async function initializeJB2AFreeDB(path) {
  JB2AFREEDB._templates = {
    ranged: [200, 200, 200]
  };
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l0 = prefix("Cantrip");
  const l1 = prefix("1st_Level");
  const l2 = prefix("2nd_Level");
  const l3 = prefix("3rd_Level");
  const l4 = prefix("4th_Level");
  const l5 = prefix("5th_Level");
  const l6 = prefix("6th_Level");
  const l7 = prefix("7th_Level");
  const lg = prefix("Generic");
  JB2AFREEDB.range = {
    _template: "ranged",
    weapon: {
      arrow: {
        "regular": {
          regular: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_White_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow01_01_Regular_Green_90ft_4000x400.webm`]
          }
        },
        "physical": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Arrow02_01_Regular_Blue_Physical_90ft_4000x400.webm`]
          }
        }
      },
      bolt: {
        "physical": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bolt01_01_Regular_Orange_Physical_90ft_4000x400.webm`]
          }
        }
      },
      bomb: {
        "01": {
          black: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowBomb01_01_Regular_Black_90ft_4000x400.webm`]
          }
        }
      },
      bullet: {
        "1": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Orange_90ft_4000x400.webm`]
          }
        },
        "2": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Orange_90ft_4000x400.webm`]
          }
        },
        "3": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Blue_90ft_4000x400.webm`]
          }
        }
      },
      cannonball: {
        "01": {
          black: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaunchCannonBall01_01_Regular_Black_90ft_4000x400.webm`]
          }
        }
      },
      dagger: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_90ft_4000x400.webm`]
          }
        }
      },
      flask: {
        "01": {
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Orange_90ft_4000x400.webm`]
          }
        }
      },
      lasershot: {
        "01": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Blue_90ft_4000x400.webm`]
          },
          green: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Green_90ft_4000x400.webm`]
          },
          orange: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Orange_90ft_4000x400.webm`]
          },
          red: {
            "05ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserShot_01_Regular_Red_90ft_4000x400.webm`]
          }
        }
      },
      lasersword: {
        "01": {
          blue: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSword01_01_Regular_Blue_90ft_4000x600.webm`]
          }
        },
        "02": {
          red: {
            "15ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_15ft_1000x600.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_30ft_1600x600.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_60ft_2800x600.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/LaserSwordDB01_01_Regular_Red_90ft_4000x600.webm`]
          }
        }
      },
      snipe: {
        "01": {
          blue: {
            "05ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Blue_90ft_4000x400.webm`]
          }
        }
      },
      snowball: {
        "01": {
          white: {
            "05ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_05ft_600x500.webm`],
            "15ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_15ft_1000x500.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_30ft_1600x500.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_60ft_2800x500.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/SnowballToss_01_Regular_White_90ft_4000x500.webm`]
          }
        }
      }
    },
    spell: {
      chainlightning: {
        primary: {
          blue: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_05ft_Primary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_15ft_Primary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_30ft_Primary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_60ft_Primary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_90ft_Primary_4000x400.webm`]
          }
        },
        secondary: {
          blue: {
            "05ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_05ft_Secondary_600x400.webm`],
            "15ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_15ft_Secondary_1000x400.webm`],
            "30ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_30ft_Secondary_1600x400.webm`],
            "60ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_60ft_Secondary_2800x400.webm`],
            "90ft": [l6`Chain_Lightning/ChainLightning_01_Regular_Blue_90ft_Secondary_4000x400.webm`]
          }
        }
      },
      disintegrate: {
        "01": {
          green: {
            "05ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_05ft_600x400.webm`],
            "15ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_15ft_1000x400.webm`],
            "30ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_30ft_1600x400.webm`],
            "60ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_60ft_2800x400.webm`],
            "90ft": [l6`Disintegrate/Disintegrate_01_Regular_Green01_90ft_4000x400.webm`]
          }
        }
      },
      eldritchblast: {
        "01": {
          purple: {
            "05ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_05ft_600x400.webm`],
            "15ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_15ft_1000x400.webm`],
            "30ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_30ft_1600x400.webm`],
            "60ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_60ft_2800x400.webm`],
            "90ft": [l0`Eldritch_Blast/EldritchBlast_01_Regular_Purple_90ft_4000x400.webm`]
          }
        }
      },
      fireballbeam: {
        "01": {
          orange: {
            "05ft": [l3`Fireball/FireballBeam_01_Orange_05ft_600x400.webm`],
            "15ft": [l3`Fireball/FireballBeam_01_Orange_15ft_1000x400.webm`],
            "30ft": [l3`Fireball/FireballBeam_01_Orange_30ft_1600x400.webm`],
            "60ft": [l3`Fireball/FireballBeam_01_Orange_60ft_2800x400.webm`],
            "90ft": [l3`Fireball/FireballBeam_01_Orange_90ft_4000x400.webm`]
          }
        }
      },
      firebolt: {
        "01": {
          orange: {
            "05ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [l0`Fire_Bolt/FireBolt_01_Regular_Orange_90ft_4000x400.webm`]
          }
        }
      },
      guidingbolt: {
        "01": {
          yellowblue: {
            "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_05ft_600x400.webm`],
            "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_15ft_1000x400.webm`],
            "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_30ft_1600x400.webm`],
            "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_60ft_2800x400.webm`],
            "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_BlueYellow_90ft_4000x400.webm`]
          }
        }
      },
      magicmissile: {
        "01": {
          purple: {
            "05ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_01_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_02_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_03_600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_05ft_04_600x400.webm`
            ],
            "15ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_01_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_02_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_03_1000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_15ft_04_1000x400.webm`
            ],
            "30ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_01_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_02_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_03_1600x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_30ft_04_1600x400.webm`
            ],
            "60ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_01_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_02_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_03_2800x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_60ft_04_2800x400.webm`
            ],
            "90ft": [
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_01_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_02_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_03_4000x400.webm`,
              l1`Magic_Missile/MagicMissile_01_Regular_Purple_90ft_04_4000x400.webm`
            ]
          }
        }
      },
      rayoffrost: {
        "01": {
          blue: {
            "05ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l0`Ray_Of_Frost/RayOfFrost_01_Regular_Blue_90ft_4000x400.webm`]
          }
        }
      },
      scorchingray: {
        "01": {
          orange: {
            "05ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_05ft_600x400.webm`],
            "15ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_15ft_1000x400.webm`],
            "30ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_30ft_1600x400.webm`],
            "60ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_60ft_2800x400.webm`],
            "90ft": [l2`Scorching_Ray/ScorchingRay_01_Regular_Orange_90ft_4000x400.webm`]
          }
        }
      },
      witchbolt: {
        "01": {
          blue: {
            "05ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [l1`Witch_Bolt/WitchBolt_01_Regular_Blue_90ft_4000x400.webm`]
          }
        }
      }
    },
    generic: {
      conduit: {
        circle: {
          purpleblue: {
            "05ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_05ft_600x400.webm`],
            "15ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyConduitCircle_01_Regular_BluePurple_90ft_4000x400.webm`]
          }
        }
      },
      energybeam: {
        "01": {
          blue: {
            "15ft": [lg`Energy/EnergyBeam_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_01_Regular_Blue_90ft_4000x400.webm`]
          }
        },
        "02": {
          blue: {
            "15ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_02_Regular_BluePink_90ft_4000x400.webm`]
          }
        },
        "03": {
          blue: {
            "15ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_15ft_1000x400.webm`],
            "30ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_30ft_1600x400.webm`],
            "60ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_60ft_2800x400.webm`],
            "90ft": [lg`Energy/EnergyBeam_03_Regular_BluePink_90ft_4000x400.webm`]
          }
        }
      },
      energystrand: {
        "01": {
          purple: {
            "05ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_05ft_600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_05ft_600x400.webm`
            ],
            "15ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_15ft_1000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_15ft_1000x400.webm`
            ],
            "30ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_30ft_1600x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_30ft_1600x400.webm`
            ],
            "60ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_60ft_2800x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_60ft_2800x400.webm`
            ],
            "90ft": [
              lg`Energy/EnergyStrand_01_Regular_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_02_Regular_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_03_Regular_Purple_90ft_4000x400.webm`,
              lg`Energy/EnergyStrand_04_Regular_Purple_90ft_4000x400.webm`
            ]
          }
        }
      },
      iceshard: {
        "01": {
          blue: {
            "05ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_05ft_600x400.webm`],
            "15ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_15ft_1000x400.webm`],
            "30ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_30ft_1600x400.webm`],
            "60ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_60ft_2800x400.webm`],
            "90ft": [lg`RangedSpell/ProjectileIceShard01_01_Regular_Blue_90ft_4000x400.webm`]
          }
        }
      },
      leaves: {
        "01": {
          greenorange: {
            "05ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_05ft_600x400.webm`],
            "15ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_15ft_1000x400.webm`],
            "30ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_30ft_1600x400.webm`],
            "60ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_60ft_2800x400.webm`],
            "90ft": [lg`Nature/SwirlingLeaves01_01_Regular_GreenOrange_90ft_4000x400.webm`]
          }
        }
      }
    }
  };
  JB2AFREEDB.melee = {
    creature: {
      bite: {
        "01": {
          red: [lg`Creature/Bite_01_Regular_Red_400x400.webm`]
        }
      },
      claw: {
        "01": {
          red: [lg`Creature/Claws_01_Regular_Red_400x400.webm`]
        }
      }
    },
    weapon: {
      club: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Club01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Club01_06_Regular_White_800x600.webm`]
          ]
        }
      },
      dagger: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/Dagger02_01_Regular_White_800x600.webm`]
        }
      },
      falchion: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Falchion01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Falchion01_06_Regular_White_800x600.webm`
          ]
        }
      },
      flurryofblows: {
        "magical": {
          blue: {
            "1": [lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Blue_Magical01_800x600.webm`],
            "2": [lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Blue_Magical02_800x600.webm`]
          }
        },
        "physical": {
          blue: {
            "1": [lg`Unarmed_Attacks/Flurry_Of_Blows/FlurryOfBlows_01_Regular_Blue_Physical01_800x600.webm`]
          }
        }
      },
      glaive: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Glaive01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Glaive01_06_Regular_White_800x600.webm`
          ]
        }
      },
      greataxe: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/GreatAxe01_01_Regular_White_800x600.webm`]
        }
      },
      greatclub: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/GreatClub01_01_Regular_White_800x600.webm`]
        }
      },
      greatsword: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/GreatSword01_01_Regular_White_800x600.webm`]
        }
      },
      halberd: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Halberd01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Halberd01_06_Regular_White_800x600.webm`
          ]
        }
      },
      hammer: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Hammer01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Hammer01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Hammer01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Hammer01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Hammer01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Hammer01_06_Regular_White_800x600.webm`]
          ]
        }
      },
      handaxe: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/HandAxe02_01_Regular_White_800x600.webm`]
        }
      },
      lasersword: {
        "01": {
          blue: [lg`Weapon_Attacks/Melee/LaserSword01_01_Regular_Blue_800x600.webm`]
        }
      },
      mace: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/Mace01_01_Regular_White_800x600.webm`]
        },
        "02": {
          white: [
            [lg`Weapon_Attacks/Melee/Mace01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Mace01_06_Regular_White_800x600.webm`]
          ]
        }
      },
      maul: {
        "01": {
          white: [lg`Weapon_Attacks/Melee/Maul01_01_Regular_White_800x600.webm`]
        }
      },
      quarterstaff: {
        white: [
          lg`Weapon_Attacks/Melee/Quarterstaff01_01_Regular_White_800x600.webm`,
          lg`Weapon_Attacks/Melee/Quarterstaff01_02_Regular_White_800x600.webm`,
          lg`Weapon_Attacks/Melee/Quarterstaff01_03_Regular_White_800x600.webm`,
          lg`Weapon_Attacks/Melee/Quarterstaff01_04_Regular_White_800x600.webm`,
          lg`Weapon_Attacks/Melee/Quarterstaff01_05_Regular_White_800x600.webm`,
          lg`Weapon_Attacks/Melee/Quarterstaff01_06_Regular_White_800x600.webm`
        ]
      },
      rapier: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Rapier01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Rapier01_06_Regular_White_800x600.webm`
          ]
        }
      },
      scimitar: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Scimitar01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Scimitar01_06_Regular_White_800x600.webm`
          ]
        }
      },
      shortsword: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Shortsword01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Shortsword01_06_Regular_White_800x600.webm`
          ]
        }
      },
      spear: {
        "fire": {
          white: [lg`Weapon_Attacks/Melee/Spear01_01_Regular_White_800x600.webm`]
        },
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Spear01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Spear01_06_Regular_White_800x600.webm`
          ]
        }
      },
      sword: {
        "01": {
          white: [
            lg`Weapon_Attacks/Melee/Sword01_01_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_02_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_03_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_04_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_05_Regular_White_800x600.webm`,
            lg`Weapon_Attacks/Melee/Sword01_06_Regular_White_800x600.webm`
          ]
        }
      },
      unarmedstrike: {
        "magical": {
          blue: {
            "1": [lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Magical01_800x600.webm`],
            "2": [lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Magical02_800x600.webm`]
          }
        },
        "physical": {
          blue: {
            "1": [lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Physical01_800x600.webm`],
            "2": [lg`Unarmed_Attacks/Unarmed_Strike/UnarmedStrike_01_Regular_Blue_Physical02_800x600.webm`]
          }
        }
      },
      warhammer: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Warhammer01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Warhammer01_06_Regular_White_800x600.webm`]
          ]
        }
      },
      wrench: {
        "01": {
          white: [
            [lg`Weapon_Attacks/Melee/Wrench01_01_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_02_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_03_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_04_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_05_Regular_White_800x600.webm`],
            [lg`Weapon_Attacks/Melee/Wrench01_06_Regular_White_800x600.webm`]
          ]
        }
      }
    }
  };
  JB2AFREEDB.templatefx = {
    circle: {
      armsofhadar: {
        "01": {
          darkpurple: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Purple_500x500.webm`]
        }
      },
      blacktentacles: {
        "01": {
          darkpurple: [l4`Black_Tentacles/BlackTentacles_01_Dark_Purple_600x600.webm`]
        }
      },
      calllightning: {
        "01": {
          blue: [l3`Call_Lightning/CallLightning_01_Blue_1000x1000.webm`],
          blueorange: [l3`Call_Lightning/CallLightning_01_BlueOrange_1000x1000.webm`],
          green: [l3`Call_Lightning/CallLightning_01_Green_1000x1000.webm`],
          pinkyellow: [l3`Call_Lightning/CallLightning_01_PinkYellow_1000x1000.webm`],
          purple: [l3`Call_Lightning/CallLightning_01_Purple_1000x1000.webm`],
          red: [l3`Call_Lightning/CallLightning_01_Red_1000x1000.webm`],
          yellow: [l3`Call_Lightning/CallLightning_01_Yellow_1000x1000.webm`]
        }
      },
      cloudofdaggers: {
        "01": {
          blue: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Blue_400x400.webm`],
          green: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Green_400x400.webm`],
          orange: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Orange_400x400.webm`],
          purple: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Purple_400x400.webm`],
          red: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Red_400x400.webm`],
          yellow: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Yellow_400x400.webm`]
        }
      },
      crackedshield: {
        "01": {
          darkpurple: [lg`Template/Circle/TemplateShieldCrackedCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      darkness: {
        "01": {
          black: [l2`Darkness/Darkness_01_Black_600x600.webm`],
          green: [l2`Darkness/Darkness_01_Green_600x600.webm`]
        }
      },
      detectmagic: {
        "01": {
          blue: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Blue_1200x1200.webm`]
        }
      },
      drop: {
        "01": {
          red: [lg`Template/Circle/TemplateDropCircle_01_Regular_Red_800x800.webm`]
        }
      },
      explosion: {
        "01": {
          blue: [
            lg`Explosion/Explosion_02_Blue_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Blue_400x400.webm`
          ],
          orange: [
            lg`Explosion/Explosion_01_Orange_400x400.webm`,
            lg`Explosion/Explosion_05_Regular_Orange_400x400.webm`
          ],
          yellowblue: [
            lg`Explosion/Explosion_03_Regular_BlueYellow_400x400.webm`
          ]
        }
      },
      fear: {
        "01": {
          darkpurple: [lg`Template/Circle/TemplateFearCircle_01_Dark_Purple_800x800.webm`]
        }
      },
      fireball: {
        explode: {
          orange: [l3`Fireball/FireballExplosion_01_Orange_800x800.webm`]
        },
        loop: {
          orange: [l3`Fireball/FireballLoop_01_Orange_800x800.webm`]
        },
        nodebris: {
          orange: [l3`Fireball/FireballLoopNoDebris_01_Orange_800x800.webm`]
        }
      },
      fogcloud: {
        "01": {
          white: [l1`Fog_Cloud/FogCloud_01_White_800x800.webm`]
        }
      },
      heart: {
        "01": {
          pink: [lg`Template/Circle/TemplateHeartCircle_01_Regular_Pink_800x800.webm`]
        }
      },
      horror: {
        "01": {
          purple: [lg`Template/Circle/TemplateHorrorCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      magicsign: {
        abjuration: {
          blue: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Blue_800x800.webm`]
        },
        conjuration: {
          yellow: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        divination: {
          blue: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Blue_800x800.webm`]
        },
        enchantment: {
          pink: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Pink_800x800.webm`]
        },
        evocation: {
          red: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Red_800x800.webm`]
        },
        illusion: {
          purple: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Purple_800x800.webm`]
        },
        necromancy: {
          green: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Green_800x800.webm`]
        },
        transmutation: {
          yellow: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Yellow_800x800.webm`]
        }
      },
      moonbeam: {
        loop: {
          blue: [l2`Moonbeam/Moonbeam_01_Regular_Blue_400x400.webm`]
        },
        nopulse: {
          blue: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Blue_400x400.webm`]
        },
        intro: {
          blue: [l2`Moonbeam/MoonbeamIntro_01_Regular_Blue_400x400.webm`]
        },
        outro: {
          blue: [l2`Moonbeam/MoonbeamOutro_01_Regular_Blue_400x400.webm`]
        }
      },
      musicnote: {
        "01": {
          blue: [lg`Template/Circle/TemplateMusicNoteCircle_01_Regular_Blue_800x800.webm`]
        }
      },
      outpulse: {
        "01": {
          whiteblue: [
            lg`Template/Circle/OutPulse/OutPulse_01_Regular_BlueWhite_Burst_600x600.webm`
          ]
        },
        "02": {
          whiteblue: [
            lg`Template/Circle/OutPulse/OutPulse_02_Regular_BlueWhite_Burst_600x600.webm`
          ]
        }
      },
      poison: {
        "01": {
          darkgreen: [lg`Template/Circle/TemplatePoisonCircle_01_Dark_Green_800x800.webm`]
        }
      },
      runes: {
        "01": {
          orange: [lg`Template/Circle/TemplateRunesCircle_01_Regular_Orange_800x800.webm`]
        }
      },
      shatter: {
        "01": {
          blue: [l2`Shatter/Shatter_01_Blue_400x400.webm`]
        }
      },
      shields: {
        "01": {
          green: [lg`Template/Circle/TemplateShieldCircle_01_Regular_Green_800x800.webm`]
        }
      },
      skull: {
        "01": {
          purple: [lg`Template/Circle/TemplateSkullCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      sleetstorm: {
        "01": {
          blue: [l3`Sleet_Storm/SleetStorm_01_Blue_800x800.webm`]
        }
      },
      snowflakes: {
        "01": {
          blue: [lg`Template/Circle/TemplateSnowflakeCircle_01_Regular_Blue_800x800.webm`]
        }
      },
      stun: {
        "01": {
          purple: [lg`Template/Circle/TemplateStunCircle_01_Regular_Purple_800x800.webm`]
        }
      },
      snowflake: {
        "01": {
          whiteblue: [
            lg`Ice/SnowflakeBurst_01_Regular_BlueWhite_Burst_600x600.webm`
          ]
        }
      },
      vortex: {
        loop: {
          blue: [lg`Template/Circle/Vortex_01_Regular_Blue_600x600.webm`]
        },
        intro: {
          blue: [lg`Template/Circle/VortexIntro_01_Regular_Blue_600x600.webm`]
        },
        outro: {
          blue: [lg`Template/Circle/VortexOutro_01_Regular_Blue_600x600.webm`]
        }
      },
      whirl: {
        loop: {
          blue: [lg`Template/Circle/Whirl_01_Regular_Blue_600x600.webm`]
        },
        intro: {
          blue: [lg`Template/Circle/WhirlIntro_01_Regular_Blue_600x600.webm`]
        },
        outro: {
          blue: [lg`Template/Circle/WhirlOutro_01_Regular_Blue_600x600.webm`]
        }
      }
    },
    cone: {
      breathweapon: {
        "cold": {
          blue: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Cold01_Regular_Blue_30ft_Cone_Burst_600x600.webm`]
        },
        "fire01": {
          orange: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Fire01_Regular_Orange_30ft_Cone_Burst_600x600.webm`]
        },
        "poison": {
          green: [lg`Template/Cone/Breath_Weapon/BreathWeapon_Poison01_Regular_Green_30ft_Cone_Burst_600x600.webm`]
        }
      },
      breathweaponspray01: {
        burst: {
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire01_Regular_Orange_Cone_Burst_800x800.webm`]
        },
        loop: {
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire01_Regular_Orange_Cone_Loop_800x800.webm`]
        }
      },
      breathweaponspray02: {
        burst: {
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire02_Regular_Orange_Cone_Burst_800x800.webm`]
        },
        loop: {
          orange: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Fire02_Regular_Orange_Cone_Loop_800x800.webm`]
        }
      },
      coneofcold: {
        "01": {
          blue: [l5`Cone_Of_Cold/ConeOfCold_01_Regular_Blue_600x600.webm`]
        }
      },
      burninghands: {
        "01": {
          orange: [l1`Burning_Hands/BurningHands_01_Regular_Orange_600x600.webm`]
        }
      }
    },
    ray: {
      breathweapon: {
        acid: {
          green: [lg`Template/Line/Breath_Weapon/BreathWeapon_Acid01_Regular_Green_30ft_Line_Burst_1200x200.webm`]
        },
        fire: {
          orange: [lg`Template/Line/Breath_Weapon/BreathWeapon_Fire01_Regular_Orange_30ft_Line_Burst_1200x200.webm`]
        },
        lightning: {
          blue: [lg`Template/Line/Breath_Weapon/BreathWeapon_Lightning01_Regular_Blue_30ft_Line_Burst_1200x200.webm`]
        }
      },
      lightningbolt: {
        "01": {
          blue: [l3`Lightning_Bolt/LightningBolt_01_Regular_Blue_4000x200.webm`]
        },
        "02": {
          blue: [l3`Lightning_Bolt/LightningBolt_01_Regular_Blue_4000x400.webm`]
        }
      },
      gustofwind: {
        slow: {
          white: [l2`Gust_Of_Wind/GustOfWind_01_White_1200x200.webm`]
        },
        fast: {
          white: [l2`Gust_Of_Wind/GustOfWind_01_White_VeryFast_1200x200.webm`]
        }
      }
    },
    square: {
      armsofhadar: {
        "01": {
          darkpurple: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Purple_500x500.webm`]
        }
      },
      blacktentacles: {
        "01": {
          darkpurple: [l4`Black_Tentacles/BlackTentacles_01_Dark_Purple_600x600.webm`]
        }
      },
      crackedshield: {
        "01": {
          darkpurple: [lg`Template/Square/TemplateShieldCrackedSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      drop: {
        "01": {
          red: [lg`Template/Square/TemplateDropSquare_01_Regular_Red_600x600.webm`]
        }
      },
      entangle: {
        "01": {
          brown: [l1`Entangle/Entangle_01_Brown_400x400.webm`],
          green: [l1`Entangle/Entangle_01_Green_400x400.webm`],
          yellow: [l1`Entangle/Entangle_01_Yellow_400x400.webm`]
        }
      },
      fear: {
        "01": {
          darkpurple: [lg`Template/Square/TemplateFearSquare_01_Dark_Purple_600x600.webm`]
        }
      },
      grease: {
        "01": {
          brown: [l1`Grease/Grease_Dark_Brown_600x600.webm`]
        }
      },
      heart: {
        "01": {
          pink: [lg`Template/Square/TemplateHeartSquare_01_Regular_Pink_600x600.webm`]
        }
      },
      horror: {
        "01": {
          purple: [lg`Template/Square/TemplateHorrorSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      musicnote: {
        "01": {
          blue: [lg`Template/Circle/TemplateMusicNoteCircle_01_Regular_Blue_800x800.webm`]
        }
      },
      poison: {
        "01": {
          darkgreen: [lg`Template/Square/TemplatePoisonSquare_01_Dark_Green_600x600.webm`]
        }
      },
      runes: {
        "01": {
          orange: [lg`Template/Square/TemplateRunesSquare_01_Regular_Orange_600x600.webm`]
        }
      },
      shields: {
        "01": {
          green: [lg`Template/Square/TemplateShieldSquare_01_Regular_Green_600x600.webm`]
        }
      },
      snowflakes: {
        "01": {
          blue: [lg`Template/Square/TemplateSnowflakeSquare_01_Regular_Blue_600x600.webm`]
        }
      },
      skull: {
        "01": {
          purple: [lg`Template/Square/TemplateSkullSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      stun: {
        "01": {
          purple: [lg`Template/Square/TemplateStunSquare_01_Regular_Purple_600x600.webm`]
        }
      },
      thunderwave: {
        left: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BLeft_600x600.webm`]
        },
        mid: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BMid_600x600.webm`]
        },
        center: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_Center_600x600.webm`]
        }
      },
      web: {
        "01": {
          white: [l2`Web/Web_01_White_01_400x400.webm`]
        }
      }
    }
  };
  JB2AFREEDB.static = {
    chains: {
      standard: {
        "01": {
          red: [lg`Marker/MarkerChainStandard01_01_Regular_Red_Loop_400x400.webm`]
        },
        complete: {
          _markers: {
            loop: { start: 2033, end: 7e3 },
            forcedEnd: 7933
          },
          red: [lg`Marker/MarkerChainStandard01_02_Regular_Red_Complete_400x400.webm`]
        },
        loop: {
          red: [lg`Marker/MarkerChainStandard01_02_Regular_Red_Loop_400x400.webm`]
        }
      }
    },
    conditions: {
      drop: {
        "02": {
          red: [lg`Marker/MarkerDrop_02_Regular_Red_400x400.webm`]
        },
        "03": {
          red: [lg`Marker/MarkerDrop_03_Regular_Red_400x400.webm`]
        }
      },
      fear: {
        "01": {
          darkpurple: [lg`Marker/MarkerFear_01_Dark_Purple_400x400.webm`]
        },
        "02": {
          darkpurple: [lg`Marker/MarkerFear_02_Dark_Purple_400x400.webm`]
        },
        "03": {
          darkpurple: [lg`Marker/MarkerFear_03_Dark_Purple_400x400.webm`]
        }
      },
      heart: {
        "01": {
          pink: [lg`Marker/MarkerHeart_01_Regular_Pink_400x400.webm`]
        },
        "02": {
          pink: [lg`Marker/MarkerHeart_02_Regular_Pink_400x400.webm`]
        },
        "03": {
          pink: [lg`Marker/MarkerHeart_03_Regular_Pink_400x400.webm`]
        }
      },
      horror: {
        "01": {
          purple: [lg`Marker/MarkerHorror_01_Regular_Purple_400x400.webm`]
        },
        "02": {
          purple: [lg`Marker/MarkerHorror_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          purple: [lg`Marker/MarkerHorror_03_Regular_Purple_400x400.webm`]
        }
      },
      light: {
        pulse: {
          blue: [lg`Marker/MarkerLight_01_Regular_Blue_400x400.webm`]
        },
        nopulse: {
          blue: [lg`Marker/MarkerLightNoPulse_01_Regular_Blue_400x400.webm`]
        }
      },
      poison: {
        "02": {
          darkgreen: [lg`Marker/MarkerPoison_02_Dark_Green_400x400.webm`]
        },
        "03": {
          darkgreen: [lg`Marker/MarkerPoison_03_Dark_Green_400x400.webm`]
        }
      },
      runes: {
        "01": {
          darkorange: [lg`Marker/MarkerRunes_01_Dark_Orange_400x400.webm`]
        },
        "02": {
          orange: [lg`Marker/MarkerRunes_02_Regular_Orange_400x400.webm`]
        },
        "03": {
          orange: [lg`Marker/MarkerRunes_03_Regular_Orange_400x400.webm`]
        }
      },
      shields: {
        "02": {
          green: [lg`Marker/MarkerShield_02_Regular_Green_400x400.webm`]
        },
        "03": {
          green: [lg`Marker/MarkerShield_03_Regular_Green_400x400.webm`]
        }
      },
      crackedshield: {
        "02": {
          purple: [lg`Marker/MarkerShieldCracked_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          purple: [lg`Marker/MarkerShieldCracked_03_Regular_Purple_400x400.webm`]
        }
      },
      skull: {
        "01": {
          darkorange: [lg`Marker/MarkerSkull_01_Dark_Orange_400x400.webm`]
        },
        "02": {
          purple: [lg`Marker/MarkerSkull_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          purple: [lg`Marker/MarkerSkull_03_Regular_Purple_400x400.webm`]
        }
      },
      snowflakes: {
        "02": {
          blue: [lg`Marker/MarkerSnowflake_02_Regular_Blue_400x400.webm`]
        },
        "03": {
          blue: [lg`Marker/MarkerSnowflake_03_Regular_Blue_400x400.webm`]
        }
      },
      stun: {
        "02": {
          purple: [lg`Marker/MarkerStun_02_Regular_Purple_400x400.webm`]
        },
        "03": {
          purple: [lg`Marker/MarkerStun_03_Regular_Purple_400x400.webm`]
        }
      },
      dizzystars: {
        "01": {
          blueorange: [lg`Conditions/Dizzy_Stars/DizzyStars_01_BlueOrange_400x400.webm`]
        }
      }
    },
    creature: {
      bite: {
        "01": {
          red: [lg`Creature/Bite_01_Regular_Red_400x400.webm`]
        }
      },
      claw: {
        "01": {
          red: [lg`Creature/Claws_01_Regular_Red_400x400.webm`]
        }
      }
    },
    energy: {
      energyfield: {
        "01": {
          blue: [lg`Energy/EnergyField_01_Regular_Blue_600x600.webm`]
        }
      },
      shimmer: {
        "01": {
          blue: [lg`Energy/Shimmer01_01_Regular_Blue_400x400.webm`]
        }
      },
      sparkles: {
        "01": {
          blue: [lg`Energy/SwirlingSparkles_01_Regular_Blue_400x400.webm`]
        }
      },
      strands: {
        "01": {
          green: [lg`Energy/EnergyStrandIN01_01_Regular_Green_600x600.webm`]
        },
        "02": {
          green: [lg`Energy/EnergyStrandIN01_02_Regular_Green_600x600.webm`]
        },
        "03": {
          green: [lg`Energy/EnergyStrandIN01_03_Regular_Green_600x600.webm`]
        }
      }
    },
    fire: {
      eruption: {
        "01": {
          orange: [lg`Fire/Eruption_01_Regular_Orange_600x600.webm`]
        }
      },
      groundcrack: {
        "01": {
          orange: [lg`Fire/GroundCrackLoop_01_Regular_Orange_600x600.webm`]
        },
        "02": {
          orange: [lg`Fire/GroundCrackLoop_02_Regular_Orange_600x600.webm`]
        },
        "03": {
          orange: [lg`Fire/GroundCrackLoop_03_Regular_Orange_600x600.webm`]
        }
      },
      fireworks: {
        "01": {
          orangeyellow: [
            lg`Fireworks/Firework01_01_Regular_OrangeYellow_600x600.webm`,
            lg`Fireworks/Firework03_01_Regular_OrangeYellow_600x600.webm`
          ],
          yellow: [
            lg`Fireworks/Firework02_01_Regular_Yellow_600x600.webm`
          ]
        },
        "02": {
          orangeyellow: [
            lg`Fireworks/Firework01_02_Regular_OrangeYellow_600x600.webm`,
            lg`Fireworks/Firework03_02_Regular_OrangeYellow_600x600.webm`
          ],
          yellow: [
            lg`Fireworks/Firework02_02_Regular_Yellow_600x600.webm`
          ]
        }
      }
    },
    generic: {
      explosion: {
        "01": {
          blue: [
            lg`Explosion/Explosion_02_Blue_400x400.webm`,
            lg`Explosion/Explosion_04_Regular_Blue_400x400.webm`
          ],
          orange: [
            lg`Explosion/Explosion_01_Orange_400x400.webm`
          ],
          yellowblue: [
            lg`Explosion/Explosion_03_Regular_BlueYellow_400x400.webm`
          ]
        }
      },
      impact: {
        "01": {
          blue: [
            lg`Impact/Impact_01_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_02_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_03_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_04_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_11_Regular_Blue_400x400.webm`,
            lg`Impact/Impact_12_Regular_Blue_400x400.webm`
          ],
          orange: [
            lg`Impact/Impact_05_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_07_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_08_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_09_Regular_Orange_400x400.webm`,
            lg`Impact/Impact_10_Regular_Orange_400x400.webm`
          ],
          yellow: [
            lg`Impact/Impact_06_Regular_Yellow_400x400.webm`,
            lg`Impact/Impact_07_Regular_Yellow_400x400.webm`
          ]
        }
      },
      indicator: {
        chevron: {
          yellow: [lg`UI/3Chevrons_01_Regular_Yellow_200x200.webm`]
        },
        "01": {
          yellow: [lg`UI/Indicator_01_Regular_Yellow_200x200.webm`]
        },
        "02": {
          green: [lg`UI/Indicator01_02_Regular_BlueGreen_400x400.webm`]
        },
        "03": {
          green: [lg`UI/Indicator01_03_Regular_BlueGreen_200x200.webm`]
        },
        "04": {
          green: [lg`UI/Indicator02_02_Regular_BlueGreen_400x400.webm`]
        },
        "05": {
          green: [lg`UI/Indicator02_03_Regular_BlueGreen_200x200.webm`]
        }
      },
      outpulse: {
        "01": {
          whiteblue: [
            lg`Template/Circle/OutPulse/OutPulse_01_Regular_BlueWhite_Burst_600x600.webm`
          ]
        },
        "02": {
          whiteblue: [
            lg`Template/Circle/OutPulse/OutPulse_02_Regular_BlueWhite_Burst_600x600.webm`
          ]
        }
      },
      smoke: {
        "01": {
          grey: [lg`Smoke/SmokePuff01_01_Regular_Grey_400x400.webm`]
        },
        "02": {
          grey: [lg`Smoke/SmokePuff01_02_Regular_Grey_400x400.webm`]
        },
        "03": {
          grey: [lg`Smoke/SmokePuff01_03_Regular_Grey_400x400.webm`]
        },
        "ring02": {
          white: [
            lg`Smoke/SmokePuffRing01_01_Regular_White_400x400.webm`,
            lg`Smoke/SmokePuffRing01_02_Regular_White_400x400.webm`,
            lg`Smoke/SmokePuffRing01_03_Regular_White_400x400.webm`
          ]
        }
      },
      ui: {
        drop: {
          red: [lg`UI/IconDrop_01_Regular_Red_200x200.webm`]
        },
        fear: {
          darkpurple: [lg`UI/IconFear_01_Dark_Purple_200x200.webm`]
        },
        heart: {
          pink: [lg`UI/IconHeart_01_Regular_Pink_200x200.webm`]
        },
        horror: {
          purple: [lg`UI/IconHorror_01_Regular_Purple_200x200.webm`]
        },
        music: {
          blue: [lg`UI/IconMusicNote_01_Regular_Blue_200x200.webm`]
        },
        poison: {
          darkgreen: [lg`UI/IconPoison_01_Dark_Green_200x200.webm`]
        },
        rune01: {
          orange: [lg`UI/IconRunes_01_Regular_Orange_200x200.webm`]
        },
        rune02: {
          orange: [lg`UI/IconRunes02_01_Regular_Orange_200x200.webm`]
        },
        rune03: {
          orange: [lg`UI/IconRunes03_01_Regular_Orange_200x200.webm`]
        },
        shields: {
          green: [lg`UI/IconShield_01_Regular_Green_200x200.webm`]
        },
        crackedshield: {
          purple: [lg`UI/IconShieldCracked_01_Regular_Purple_200x200.webm`]
        },
        skull: {
          purple: [lg`UI/IconSkull_01_Regular_Purple_200x200.webm`]
        },
        snowflake: {
          blue: [lg`UI/IconSnowflake_01_Regular_Blue_200x200.webm`]
        },
        stun: {
          purple: [lg`UI/IconStun_01_Regular_Purple_200x200.webm`]
        }
      },
      vortex: {
        loop: {
          blue: [lg`Template/Circle/Vortex_01_Regular_Blue_600x600.webm`]
        },
        intro: {
          blue: [lg`Template/Circle/VortexIntro_01_Regular_Blue_600x600.webm`]
        },
        outro: {
          blue: [lg`Template/Circle/VortexOutro_01_Regular_Blue_600x600.webm`]
        }
      },
      whirl: {
        loop: {
          blue: [lg`Template/Circle/Whirl_01_Regular_Blue_600x600.webm`]
        },
        intro: {
          blue: [lg`Template/Circle/WhirlIntro_01_Regular_Blue_600x600.webm`]
        },
        outro: {
          blue: [lg`Template/Circle/WhirlOutro_01_Regular_Blue_600x600.webm`]
        }
      }
    },
    ice: {
      icespikes: {
        "01": {
          white: [lg`Ice/IceSpikesRadialBurst_01_Regular_White_1000x1000.webm`]
        }
      },
      snowflake: {
        "01": {
          whiteblue: [
            lg`Ice/SnowflakeBurst_01_Regular_BlueWhite_Burst_600x600.webm`
          ]
        }
      }
    },
    lightning: {
      ball: {
        "01": {
          blue: [lg`Lightning/LightningBall_01_Regular_Blue_400x400.webm`]
        }
      },
      staticelectricity: {
        "01": {
          blue: [lg`Lightning/StaticElectricity_01_Regular_Blue_400x400.webm`]
        },
        "02": {
          blue: [lg`Lightning/StaticElectricity_02_Regular_Blue_400x400.webm`]
        }
      }
    },
    liquid: {
      splash: {
        "01": {
          blue: [lg`Liquid/LiquidSplash01_Regular_Blue_400x400.webm`]
        }
      },
      blob: {
        "01": {
          blue: [lg`Liquid/LiquidBlob01_01_Regular_Blue_400x400.webm`]
        }
      }
    },
    magicsign: {
      abjuration: {
        "01": {
          blue: [lg`Magic_Signs/Abjuration_01_Blue_Circle_800x800.webm`]
        },
        "02": {
          blue: [lg`Magic_Signs/AbjurationCircleLoop_02_Regular_Blue_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/AbjurationRuneIntro_01_Regular_Blue_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/AbjurationRuneLoop_01_Regular_Blue_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/AbjurationRuneOutro_01_Regular_Blue_400x400.webm`]
        }
      },
      conjuration: {
        "01": {
          yellow: [lg`Magic_Signs/Conjuration_01_Yellow_Circle_800x800.webm`]
        },
        "02": {
          yellow: [lg`Magic_Signs/ConjurationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          yellow: [lg`Magic_Signs/Runes/,ConjurationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          yellow: [lg`Magic_Signs/Runes/ConjurationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          yellow: [lg`Magic_Signs/Runes/ConjurationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      },
      divination: {
        "01": {
          lightblue: [lg`Magic_Signs/Divination_01_Light_Blue_Circle_800x800.webm`]
        },
        "02": {
          blue: [lg`Magic_Signs/DivinationCircleLoop_02_Regular_Blue_800x800.webm`]
        },
        "runeintro": {
          blue: [lg`Magic_Signs/Runes/DivinationRuneIntro_01_Regular_Blue_400x400.webm`]
        },
        "runeloop": {
          blue: [lg`Magic_Signs/Runes/DivinationRuneLoop_01_Regular_Blue_400x400.webm`]
        },
        "runeoutro": {
          blue: [lg`Magic_Signs/Runes/DivinationRuneOutro_01_Regular_Blue_400x400.webm`]
        }
      },
      enchantment: {
        "02": {
          pink: [lg`Magic_Signs/EnchantmentCircleLoop_02_Regular_Pink_800x800.webm`]
        },
        "runeintro": {
          pink: [lg`Magic_Signs/Runes/EnchantmentRuneIntro_01_Regular_Pink_400x400.webm`]
        },
        "runeloop": {
          pink: [lg`Magic_Signs/Runes/EnchantmentRuneLoop_01_Regular_Pink_400x400.webm`]
        },
        "runeoutro": {
          pink: [lg`Magic_Signs/Runes/EnchantmentRuneOutro_01_Regular_Pink_400x400.webm`]
        }
      },
      evocation: {
        "02": {
          red: [lg`Magic_Signs/EvocationCircleLoop_02_Regular_Red_800x800.webm`]
        },
        "runeintro": {
          red: [lg`Magic_Signs/Runes/EvocationRuneIntro_01_Regular_Red_400x400.webm`]
        },
        "runeloop": {
          red: [lg`Magic_Signs/Runes/EvocationRuneLoop_01_Regular_Red_400x400.webm`]
        },
        "runeoutro": {
          red: [lg`Magic_Signs/Runes/EvocationRuneOutro_01_Regular_Red_400x400.webm`]
        }
      },
      illusion: {
        "02": {
          purple: [lg`Magic_Signs/IllusionCircleLoop_02_Regular_Purple_800x800.webm`]
        },
        "runeintro": {
          purple: [lg`Magic_Signs/Runes/IllusionRuneIntro_01_Regular_Purple_400x400.webm`]
        },
        "runeloop": {
          purple: [lg`Magic_Signs/Runes/IllusionRuneLoop_01_Regular_Purple_400x400.webm`]
        },
        "runeoutro": {
          purple: [lg`Magic_Signs/Runes/IllusionRuneOutro_01_Regular_Purple_400x400.webm`]
        }
      },
      necromancy: {
        "02": {
          green: [lg`Magic_Signs/NecromancyCircleLoop_02_Regular_Green_800x800.webm`]
        },
        "runeintro": {
          green: [lg`Magic_Signs/Runes/NecromancyRuneIntro_01_Regular_Green_400x400.webm`]
        },
        "runeloop": {
          green: [lg`Magic_Signs/Runes/NecromancyRuneLoop_01_Regular_Green_400x400.webm`]
        },
        "runeoutro": {
          green: [lg`Magic_Signs/Runes/NecromancyRuneOutro_01_Regular_Green_400x400.webm`]
        }
      },
      transmutation: {
        "02": {
          yellow: [lg`Magic_Signs/TransmutationCircleLoop_02_Regular_Yellow_800x800.webm`]
        },
        "runeintro": {
          yellow: [lg`Magic_Signs/Runes/TransmutationRuneIntro_01_Regular_Yellow_400x400.webm`]
        },
        "runeloop": {
          yellow: [lg`Magic_Signs/Runes/TransmutationRuneLoop_01_Regular_Yellow_400x400.webm`]
        },
        "runeoutro": {
          yellow: [lg`Magic_Signs/Runes/TransmutationRuneOutro_01_Regular_Yellow_400x400.webm`]
        }
      }
    },
    marker: {
      bubble: {
        "01": {
          blue: [lg`Marker/MarkerBubble_01_Regular_Blue_400x400.webm`]
        }
      },
      circleofstars: {
        "01": {
          blue: [lg`Marker/MarkerCircleOfStars_Regular_Blue_400x400.webm`]
        }
      },
      energystrands: {
        "01": {
          blue: [lg`Marker/EnergyStrands_01_Regular_Blue_600x600.webm`]
        }
      },
      music: {
        "01": {
          greenorange: [lg`Marker/MusicMarker_01_Regular_GreenOrange_400x400.webm`]
        }
      },
      standard: {
        "01": {
          marker01: {
            "yellowblue": [lg`Marker/Marker_01_Regular_BlueYellow_400x400.webm`]
          },
          musicMarker: {
            "greenorange": [lg`Marker/MusicMarker_01_Regular_GreenOrange_400x400.webm`]
          }
        }
      }
    },
    music: {
      notes: {
        "01": {
          blue: [
            lg`Music_Notation/BassClef_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/BeamedQuavers_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Crotchet_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Flat_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Quaver_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/Sharp_01_Regular_Blue_200x200.webm`,
            lg`Music_Notation/TrebleClef_01_Regular_Blue_200x200.webm`
          ]
        }
      }
    },
    particles: {
      dots: {
        "01": {
          green: [lg`Particles/ParticlesOutward01_01_Regular_GreenYellow_400x400.webm`]
        },
        "02": {
          green: [lg`Particles/ParticlesOutward01_02_Regular_GreenYellow_400x400.webm`]
        },
        "03": {
          green: [lg`Particles/ParticlesOutward01_03_Regular_GreenYellow_400x400.webm`]
        },
        "04": {
          green: [lg`Particles/ParticlesOutward01_04_Regular_GreenYellow_400x400.webm`]
        },
        "05": {
          green: [lg`Particles/ParticlesOutward01_05_Regular_GreenYellow_400x400.webm`]
        }
      },
      inwarddots: {
        "01": {
          greenyellow: [lg`Particles/ParticlesInward01_01_Regular_GreenYellow_400x400.webm`]
        },
        "02": {
          greenyellow: [lg`Particles/ParticlesInward01_02_Regular_GreenYellow_400x400.webm`]
        },
        "03": {
          greenyellow: [lg`Particles/ParticlesInward01_03_Regular_GreenYellow_400x400.webm`]
        },
        "04": {
          greenyellow: [lg`Particles/ParticlesInward01_04_Regular_GreenYellow_400x400.webm`]
        },
        "05": {
          greenyellow: [lg`Particles/ParticlesInward01_05_Regular_GreenYellow_400x400.webm`]
        }
      },
      stars: {
        "01": {
          green: [lg`Particles/ParticlesOutward02_01_Regular_GreenYellow_400x400.webm`]
        },
        "02": {
          green: [lg`Particles/ParticlesOutward02_02_Regular_GreenYellow_400x400.webm`]
        },
        "03": {
          green: [lg`Particles/ParticlesOutward02_03_Regular_GreenYellow_400x400.webm`]
        },
        "04": {
          green: [lg`Particles/ParticlesOutward02_04_Regular_GreenYellow_400x400.webm`]
        },
        "05": {
          green: [lg`Particles/ParticlesOutward02_05_Regular_GreenYellow_400x400.webm`]
        }
      },
      inwardstars: {
        "01": {
          greenyellow: [lg`Particles/ParticlesInward02_01_Regular_GreenYellow_400x400.webm`]
        },
        "02": {
          greenyellow: [lg`Particles/ParticlesInward02_02_Regular_GreenYellow_400x400.webm`]
        },
        "03": {
          greenyellow: [lg`Particles/ParticlesInward02_03_Regular_GreenYellow_400x400.webm`]
        },
        "04": {
          greenyellow: [lg`Particles/ParticlesInward02_04_Regular_GreenYellow_400x400.webm`]
        },
        "05": {
          greenyellow: [lg`Particles/ParticlesInward02_05_Regular_GreenYellow_400x400.webm`]
        }
      },
      swirl: {
        "01": {
          greenyellow: [lg`Particles/ParticlesSwirl01_01_Regular_GreenYellow_400x400.webm`]
        },
        "02": {
          greenyellow: [lg`Particles/ParticlesSwirl02_01_Regular_GreenYellow_400x400.webm`]
        }
      }
    },
    shieldfx: {
      eldritchweb: {
        "01": {
          darkpurple: [lg`Energy/ShieldEldritchWebAbove01_01_Dark_Purple_400x400.webm`]
        }
      },
      /*
      shieldeldritchwebbottom: {
          '01': {
              darkpurple: [lg`Energy/ShieldEldritchWebBelow01_01_Dark_Purple_400x400.webm`],
          },
      },
      */
      fire: {
        "01": {
          orange: [lg`Fire/ShieldFireAbove01_01_Regular_Orange_400x400.webm`]
        }
      },
      /*
      shieldfirebottom: {
          '01': {
              orange: [lg`Fire/ShieldFireBelow01_01_Regular_Orange_400x400.webm`],
          },
      },
      */
      earth: {
        "01": {
          orange: [lg`Fire/ShieldMoltenEarthAbove01_01_Regular_Orange_400x400.webm`]
        }
      },
      /*
      shieldearthbottom: {
          '01': {
              orange: [lg`Fire/ShieldMoltenEarthBelow01_01_Regular_Orange_400x400.webm`],
          },
      },
      */
      energyfield: {
        "01": {
          blue: [lg`Energy/EnergyFieldTop_02_Regular_Blue_400x400.webm`]
        }
      },
      /*
      energyfieldbottom: {
          '01': {
              blue: [lg`Energy/EnergyFieldBot_02_Regular_Blue_400x400.webm`],
          }
      },
      */
      ice: {
        "01": {
          blue: [lg`Ice/ShieldIceAbove01_01_Regular_Blue_400x400.webm`]
        }
      }
      /*
      shieldicebottom: {
          '01': {
              blue: [lg`Ice/ShieldIceBelow01_01_Regular_Blue_400x400.webm`],
          }
      },
      */
    },
    shieldspell: {
      intro: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_Intro_400x400.webm`]
        }
      },
      loop: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_Loop_400x400.webm`]
        }
      },
      outro_explode: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_OutroExplode_400x400.webm`]
        }
      },
      outro_fade: {
        "01": {
          blue: [l1`Shield/Shield_01_Regular_Blue_OutroFade_400x400.webm`]
        }
      },
      complete: {
        "01": {
          _markers: {
            loop: { start: 1533, end: 5533 },
            forcedEnd: 5533
          },
          blue: [l1`Shield/Shield_01_Regular_Blue_Complete_400x400.webm`]
        }
      }
    },
    shrapnel: {
      bomb: {
        "01": {
          black: [lg`Explosion/ShrapnelBomb01_01_Regular_Black_800x800.webm`]
        }
      }
    },
    spell: {
      antilifeshell: {
        "01": {
          blue: [l5`Antilife_Shell/AntilifeShell_01_Blue_NoCircle_400x400.webm`]
        }
      },
      armsofhadar: {
        "01": {
          darkpurple: [l1`Arms_Of_Hadar/ArmsOfHadar_01_Dark_Purple_500x500.webm`]
        }
      },
      bardicinspiration: {
        "inspire": {
          greenorange: [l1`Bardic_Inspiration/BardicInspiration_01_Regular_GreenOrange_400x400.webm`]
        },
        "marker": {
          greenorange: [lg`Marker/MusicMarker_01_Regular_GreenOrange_400x400.webm`]
        }
      },
      blacktentacles: {
        "01": {
          darkpurple: [l4`Black_Tentacles/BlackTentacles_01_Dark_Purple_600x600.webm`]
        }
      },
      bless: {
        "intro": {
          yellow: [l1`Bless/Bless_01_Regular_Yellow_Intro_400x400.webm`]
        },
        "loop": {
          yellow: [l1`Bless/Bless_01_Regular_Yellow_Loop_400x400.webm`]
        }
      },
      calllightning: {
        "01": {
          blue: [l3`Call_Lightning/CallLightning_01_Blue_1000x1000.webm`],
          blueorange: [l3`Call_Lightning/CallLightning_01_BlueOrange_1000x1000.webm`],
          green: [l3`Call_Lightning/CallLightning_01_Green_1000x1000.webm`],
          pinkyellow: [l3`Call_Lightning/CallLightning_01_PinkYellow_1000x1000.webm`],
          purple: [l3`Call_Lightning/CallLightning_01_Purple_1000x1000.webm`],
          red: [l3`Call_Lightning/CallLightning_01_Red_1000x1000.webm`],
          yellow: [l3`Call_Lightning/CallLightning_01_Yellow_1000x1000.webm`]
        }
      },
      cloudofdaggers: {
        "01": {
          blue: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Blue_400x400.webm`],
          green: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Green_400x400.webm`],
          orange: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Orange_400x400.webm`],
          purple: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Purple_400x400.webm`],
          red: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Red_400x400.webm`],
          yellow: [l2`Cloud_Of_Daggers/CloudOfDaggers_01_Light_Yellow_400x400.webm`]
        }
      },
      curewounds: {
        "01": {
          blue: [l1`Cure_Wounds/CureWounds_01_Blue_400x400.webm`]
        }
      },
      darkness: {
        "01": {
          black: [l2`Darkness/Darkness_01_Black_600x600.webm`],
          green: [l2`Darkness/Darkness_01_Green_600x600.webm`]
        }
      },
      detectmagic: {
        "01": {
          blue: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Blue_1200x1200.webm`]
        }
      },
      divinesmite: {
        "source": {
          yellowblue: [l2`Divine_Smite/DivineSmite_01_Regular_BlueYellow_Caster_400x400.webm`]
        },
        "target": {
          yellowblue: [l2`Divine_Smite/DivineSmite_01_Regular_BlueYellow_Target_400x400.webm`]
        }
      },
      entangle: {
        "01": {
          brown: [l1`Entangle/Entangle_01_Brown_400x400.webm`],
          green: [l1`Entangle/Entangle_01_Green_400x400.webm`],
          yellow: [l1`Entangle/Entangle_01_Yellow_400x400.webm`]
        }
      },
      fireball: {
        loop: {
          orange: [l3`Fireball/FireballLoop_01_Orange_800x800.webm`]
        },
        explode: {
          orange: [l3`Fireball/FireballExplosion_01_Orange_800x800.webm`]
        },
        nodebris: {
          orange: [l3`Fireball/FireballLoopNoDebris_01_Orange_800x800.webm`]
        }
      },
      fogcloud: {
        "01": {
          white: [l1`Fog_Cloud/FogCloud_01_White_800x800.webm`]
        }
      },
      generichealing: {
        "01": {
          blue: [lg`Healing/HealingAbility_01_Blue_400x400.webm`],
          green: [lg`Healing/HealingAbility_01_Green_400x400.webm`],
          purple: [lg`Healing/HealingAbility_01_Purple_400x400.webm`],
          yellow: [lg`Healing/HealingAbility_01_Yellow_400x400.webm`]
        },
        "02": {
          greenorange: [lg`Healing/HealingAbility_02_Regular_GreenOrange_Burst_600x600.webm`]
        }
      },
      grease: {
        "01": {
          brown: [l1`Grease/Grease_Dark_Brown_600x600.webm`]
        }
      },
      huntersmark: {
        "eye": {
          green: [l1`Hunters_Mark/HuntersMark_01_Regular_Green_Pulse_200x200.webm`]
        },
        "eyeloop": {
          green: [l1`Hunters_Mark/HuntersMark_01_Regular_Green_Loop_200x200.webm`]
        }
      },
      mistystep: {
        "01": {
          blue: [l2`Misty_Step/MistyStep_01_Regular_Blue_400x400.webm`]
        },
        "02": {
          blue: [l2`Misty_Step/MistyStep_02_Regular_Blue_400x400.webm`]
        }
      },
      moonbeam: {
        loop: {
          blue: [l2`Moonbeam/Moonbeam_01_Regular_Blue_400x400.webm`]
        },
        nopulse: {
          blue: [l2`Moonbeam/MoonbeamNoPulse_01_Regular_Blue_400x400.webm`]
        },
        intro: {
          blue: [l2`Moonbeam/MoonbeamIntro_01_Regular_Blue_400x400.webm`]
        },
        outro: {
          blue: [l2`Moonbeam/MoonbeamOutro_01_Regular_Blue_400x400.webm`]
        }
      },
      sacredflame: {
        source: {
          yellow: [l0`Sacred_Flame/SacredFlameSource_01_Regular_Yellow_400x400.webm`]
        },
        target: {
          yellow: [l0`Sacred_Flame/SacredFlameTarget_01_Regular_Yellow_400x400.webm`]
        }
      },
      shatter: {
        "01": {
          blue: [l2`Shatter/Shatter_01_Blue_400x400.webm`]
        }
      },
      sleep: {
        "01": {
          pink: [l1`Sleep/Cloud01_01_Regular_Pink_400x400.webm`]
        },
        "02": {
          pink: [l1`Sleep/Cloud01_02_Regular_Pink_400x400.webm`]
        },
        marker: {
          pink: [l1`Sleep/SleepMarker01_01_Regular_Pink_400x400.webm`]
        },
        symbol: {
          pink: [l1`Sleep/SleepSymbol01_01_Regular_Pink_400x400.webm`]
        }
      },
      sleetstorm: {
        "01": {
          blue: [l3`Sleet_Storm/SleetStorm_01_Blue_800x800.webm`]
        }
      },
      spiritguardians: {
        "01": {
          yellowblue: [l3`Spirit_Guardians/SpiritGuardians_01_Light_BlueYellow_600x600.webm`]
        }
      },
      sneakattack: {
        "01": {
          "darkgreen": [l1`Sneak_Attack/Sneak_Attack_Dark_Green_300x300.webm`]
        }
      },
      thunderwave: {
        left: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BLeft_600x600.webm`]
        },
        mid: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_BMid_600x600.webm`]
        },
        center: {
          blue: [l1`Thunderwave/Thunderwave_01_Bright_Blue_Center_600x600.webm`]
        }
      },
      tollthedead: {
        bell: {
          green: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Green_400x400.webm`]
        },
        complete: {
          green: [l0`Toll_The_Dead/TollTheDead_01_Regular_Green_400x400.webm`]
        },
        shockwave: {
          green: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Green_400x400.webm`]
        },
        skull: {
          green: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Green_400x400.webm`]
        }
      },
      wallofforce: {
        "01": {
          grey: [l5`Wall_Of_Force/WallOfForce_01_Grey_Sphere_400x400.webm`]
        }
      },
      web: {
        "01": {
          white: [l2`Web/Web_01_White_01_400x400.webm`]
        }
      },
      whirlwind: {
        "01": {
          bluegrey: [l7`Whirlwind/Whirlwind_01_BlueGrey_01_400x400.webm`]
        }
      }
    },
    tokenborder: {
      static: {
        "01": {
          blue: [lg`Token_Border/TokenBorderCircle_01_Regular_Blue_400x400.webm`]
        },
        "02": {
          blue: [lg`Token_Border/TokenBorderCircle_02_Regular_Blue_400x400.webm`]
        },
        "03": {
          blue: [lg`Token_Border/TokenBorderCircle_03_Regular_Blue_400x400.webm`]
        },
        "04": {
          blue: [lg`Token_Border/TokenBorderCircle_04_Regular_Blue_400x400.webm`]
        },
        "05": {
          blue: [lg`Token_Border/TokenBorderCircle_05_Regular_Blue_400x400.webm`]
        },
        "06": {
          blue: [lg`Token_Border/TokenBorderCircle_06_Regular_Blue_400x400.webm`]
        },
        "07": {
          blue: [lg`Token_Border/TokenBorderCircle_07_Regular_Blue_400x400.webm`]
        }
      },
      spinning: {
        "01": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_01_Regular_Blue_400x400.webm`]
        },
        "02": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_02_Regular_Blue_400x400.webm`]
        },
        "03": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_03_Regular_Blue_400x400.webm`]
        },
        "04": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_04_Regular_Blue_400x400.webm`]
        },
        "05": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_05_Regular_Blue_400x400.webm`]
        },
        "06": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_06_Regular_Blue_400x400.webm`]
        },
        "07": {
          blue: [lg`Token_Border/TokenBorderCircleSpin_07_Regular_Blue_400x400.webm`]
        }
      }
    },
    trap: {
      fire: {
        single: {
          orange: [lg`Traps/FireTrap02_01_Regular_Orange_1400x1400.webm`]
        },
        double: {
          orange: [lg`Traps/FireTrapDual02_01_Regular_Orange_1400x1400.webm`]
        }
      }
    }
  };
  JB2AFREEDB.return = {
    _template: "ranged",
    weapon: {
      dagger: {
        "01": {
          white: {
            "15ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_15ft_1000x400.webm`],
            "30ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_30ft_1600x400.webm`],
            "60ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_60ft_2800x400.webm`],
            "90ft": [lg`Weapon_Attacks/Ranged/Dagger01_01_Regular_White_Return_90ft_4000x400.webm`]
          }
        }
      }
    }
  };
}
async function db047(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l2 = prefix("2nd_Level");
  const lg = prefix("Generic");
  const patreonDB047 = {
    range: {
      _free: ["weapon"],
      weapon: {
        _free: ["missile"],
        missile: {
          _free: ["01", "02", "03", "04"],
          "01": {
            _free: ["blue"],
            blue: {
              "15ft": [lg`Weapon_Attacks/Ranged/Missile01_01_Regular_Blue_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Missile01_01_Regular_Blue_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Missile01_01_Regular_Blue_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Missile01_01_Regular_Blue_90ft_4000x400.webm`]
            }
          },
          "02": {
            _free: ["white"],
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Missile02_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Missile02_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Missile02_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Missile02_01_Regular_White_90ft_4000x400.webm`]
            }
          },
          "03": {
            _free: ["white"],
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Missile03_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Missile03_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Missile03_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Missile03_01_Regular_White_90ft_4000x400.webm`]
            }
          },
          "04": {
            _free: ["purplepink"],
            purplepink: {
              "15ft": [lg`Weapon_Attacks/Ranged/Missile04_01_Regular_PinkPurple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Missile04_01_Regular_PinkPurple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Missile04_01_Regular_PinkPurple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Missile04_01_Regular_PinkPurple_90ft_4000x400.webm`]
            }
          }
        }
      }
    },
    static: {
      _free: ["eyes", "shrapnel", "sideImpact"],
      eyes: {
        _free: ["single", "few", "many"],
        single: {
          _free: ["01", "02", "03"],
          "01": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Single01_01_Dark_Green_300x300.webm`],
            darkred: [lg`Eyes/Eyes_Single01_01_Dark_Red_300x300.webm`],
            yellow: [lg`Eyes/Eyes_Single01_01_Dark_Yellow_300x300.webm`],
            bluegreen: [lg`Eyes/Eyes_Single01_01_Regular_BlueGreen_300x300.webm`],
            orange: [lg`Eyes/Eyes_Single01_01_Regular_OrangeRed_300x300.webm`],
            orangeyellow: [lg`Eyes/Eyes_Single01_01_Regular_OrangeYellow_300x300.webm`]
          },
          "02": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Single01_02_Dark_Green_300x300.webm`],
            darkred: [lg`Eyes/Eyes_Single01_02_Dark_Red_300x300.webm`],
            yellow: [lg`Eyes/Eyes_Single01_02_Dark_Yellow_300x300.webm`],
            bluegreen: [lg`Eyes/Eyes_Single01_02_Regular_BlueGreen_300x300.webm`],
            orange: [lg`Eyes/Eyes_Single01_02_Regular_OrangeRed_300x300.webm`],
            orangeyellow: [lg`Eyes/Eyes_Single01_02_Regular_OrangeYellow_300x300.webm`]
          },
          "03": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Single01_03_Dark_Green_300x300.webm`],
            darkred: [lg`Eyes/Eyes_Single01_03_Dark_Red_300x300.webm`],
            yellow: [lg`Eyes/Eyes_Single01_03_Dark_Yellow_300x300.webm`],
            bluegreen: [lg`Eyes/Eyes_Single01_03_Regular_BlueGreen_300x300.webm`],
            orange: [lg`Eyes/Eyes_Single01_03_Regular_OrangeRed_300x300.webm`],
            orangeyellow: [lg`Eyes/Eyes_Single01_03_Regular_OrangeYellow_300x300.webm`]
          }
        },
        few: {
          _free: ["01", "02", "03"],
          "01": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Few01_01_Dark_Green_600x600.webm`],
            darkred: [lg`Eyes/Eyes_Few01_01_Dark_Red_600x600.webm`],
            yellow: [lg`Eyes/Eyes_Few01_01_Dark_Yellow_600x600.webm`],
            bluegreen: [lg`Eyes/Eyes_Few01_01_Regular_BlueGreen_600x600.webm`],
            orange: [lg`Eyes/Eyes_Few01_01_Regular_OrangeRed_600x600.webm`],
            orangeyellow: [lg`Eyes/Eyes_Few01_01_Regular_OrangeYellow_600x600.webm`]
          },
          "02": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Few01_02_Dark_Green_600x600.webm`],
            darkred: [lg`Eyes/Eyes_Few01_02_Dark_Red_600x600.webm`],
            yellow: [lg`Eyes/Eyes_Few01_02_Dark_Yellow_600x600.webm`],
            bluegreen: [lg`Eyes/Eyes_Few01_02_Regular_BlueGreen_600x600.webm`],
            orange: [lg`Eyes/Eyes_Few01_02_Regular_OrangeRed_600x600.webm`],
            orangeyellow: [lg`Eyes/Eyes_Few01_02_Regular_OrangeYellow_600x600.webm`]
          },
          "03": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Few01_03_Dark_Green_600x600.webm`],
            darkred: [lg`Eyes/Eyes_Few01_03_Dark_Red_600x600.webm`],
            yellow: [lg`Eyes/Eyes_Few01_03_Dark_Yellow_600x600.webm`],
            bluegreen: [lg`Eyes/Eyes_Few01_03_Regular_BlueGreen_600x600.webm`],
            orange: [lg`Eyes/Eyes_Few01_03_Regular_OrangeRed_600x600.webm`],
            orangeyellow: [lg`Eyes/Eyes_Few01_03_Regular_OrangeYellow_600x600.webm`]
          }
        },
        many: {
          _free: ["01", "02", "03"],
          "01": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Many01_01_Dark_Green_600x600.webm`],
            darkred: [lg`Eyes/Eyes_Many01_01_Dark_Red_600x600.webm`],
            yellow: [lg`Eyes/Eyes_Many01_01_Dark_Yellow_600x600.webm`],
            bluegreen: [lg`Eyes/Eyes_Many01_01_Regular_BlueGreen_600x600.webm`],
            orange: [lg`Eyes/Eyes_Many01_01_Regular_OrangeRed_600x600.webm`],
            orangeyellow: [lg`Eyes/Eyes_Many01_01_Regular_OrangeYellow_600x600.webm`]
          },
          "02": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Many01_02_Dark_Green_600x600.webm`],
            darkred: [lg`Eyes/Eyes_Many01_02_Dark_Red_600x600.webm`],
            yellow: [lg`Eyes/Eyes_Many01_02_Dark_Yellow_600x600.webm`],
            bluegreen: [lg`Eyes/Eyes_Many01_02_Regular_BlueGreen_600x600.webm`],
            orange: [lg`Eyes/Eyes_Many01_02_Regular_OrangeRed_600x600.webm`],
            orangeyellow: [lg`Eyes/Eyes_Many01_02_Regular_OrangeYellow_600x600.webm`]
          },
          "03": {
            _free: ["darkgreen"],
            darkgreen: [lg`Eyes/Eyes_Many01_03_Dark_Green_600x600.webm`],
            darkred: [lg`Eyes/Eyes_Many01_03_Dark_Red_600x600.webm`],
            yellow: [lg`Eyes/Eyes_Many01_03_Dark_Yellow_600x600.webm`],
            bluegreen: [lg`Eyes/Eyes_Many01_03_Regular_BlueGreen_600x600.webm`],
            orange: [lg`Eyes/Eyes_Many01_03_Regular_OrangeRed_600x600.webm`],
            orangeyellow: [lg`Eyes/Eyes_Many01_03_Regular_OrangeYellow_600x600.webm`]
          }
        }
      },
      shrapnel: {
        flask: {
          "01": {
            white: [
              lg`Explosion/TopFractureFlask01_01_400x400.webm`,
              lg`Explosion/TopFractureFlask02_01_400x400.webm`,
              lg`Explosion/TopFractureFlask03_01_400x400.webm`
            ]
          }
        }
      },
      sideImpact: {
        flask: {
          "01": {
            white: [
              lg`Explosion/SideFractureFlask01_01_800x400.webm`,
              lg`Explosion/SideFractureFlask01_02_400x400.webm`,
              lg`Explosion/SideFractureFlask02_01_800x400.webm`,
              lg`Explosion/SideFractureFlask02_02_400x400.webm`,
              lg`Explosion/SideFractureFlask03_01_800x400.webm`,
              lg`Explosion/SideFractureFlask03_02_400x400.webm`
            ]
          }
        }
      },
      spell: {
        divinesmite: {
          "source": {
            greenorange: [l2`Divine_Smite/DivineSmite_01_Regular_GreenOrange_Caster_400x400.webm`],
            pink: [l2`Divine_Smite/DivineSmite_01_Regular_Pink_Caster_400x400.webm`]
          },
          "target": {
            greenorange: [l2`Divine_Smite/DivineSmite_01_Regular_GreenOrange_Target_400x400.webm`],
            pink: [l2`Divine_Smite/DivineSmite_01_Regular_Pink_Target_400x400.webm`]
          }
        }
      }
    }
  };
  return patreonDB047;
}
async function db048(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l1 = prefix("1st_Level");
  const lg = prefix("Generic");
  const patreonDB048 = {
    templatefx: {
      _free: ["circle", "cone", "square", "vines"],
      circle: {
        _free: ["water"],
        water: {
          _free: ["01"],
          "01": {
            _free: ["blue"],
            black: [lg`Liquid/WaterSplashLoop_01_01_Regular_Black_600x600.webm`],
            blue: [lg`Liquid/WaterSplashLoop_01_01_Regular_Blue_600x600.webm`],
            green: [lg`Liquid/WaterSplashLoop_01_01_Regular_Green_600x600.webm`],
            purple: [lg`Liquid/WaterSplashLoop_01_01_Regular_Purple_600x600.webm`],
            red: [lg`Liquid/WaterSplashLoop_01_01_Regular_Red_600x600.webm`]
          }
        }
      },
      cone: {
        _free: ["water"],
        water: {
          _free: ["01"],
          "01": {
            _free: ["blue"],
            black: [lg`Liquid/WaterSplashConeLoop_01_01_Regular_Black_600x600.webm`],
            blue: [lg`Liquid/WaterSplashConeLoop_01_01_Regular_Blue_600x600.webm`],
            green: [lg`Liquid/WaterSplashConeLoop_01_01_Regular_Green_600x600.webm`],
            purple: [lg`Liquid/WaterSplashConeLoop_01_01_Regular_Purple_600x600.webm`],
            red: [lg`Liquid/WaterSplashConeLoop_01_01_Regular_Red_600x600.webm`]
          }
        }
      },
      square: {
        _free: ["entangle"],
        entangle: {
          _free: ["02", "complete"],
          "02": {
            _free: ["green"],
            purplepink: [l1`Entangle/EntangleLoop02_01_Dark_PinkPurple_500x500.webm`],
            green: [l1`Entangle/EntangleLoop02_02_Regular_Green_500x500.webm`],
            darkblue: [l1`Entangle/EntangleLoop02_03_Dark_Blue_500x500.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            _free: ["green"],
            purplepink: [l1`Entangle/Entangle02_01_Dark_PinkPurple_500x500.webm`],
            green: [l1`Entangle/Entangle02_02_Regular_Green_500x500.webm`],
            darkblue: [l1`Entangle/Entangle02_03_Dark_Blue_500x500.webm`]
          }
        }
      },
      vines: {
        _free: ["complete", "loop"],
        complete: {
          _free: ["nature"],
          nature: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            _free: ["greem"],
            green: [
              lg`Nature/GroupVineNature01_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature01_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature01_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNature01_03_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNature02_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature02_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature02_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNature02_03_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNature03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature03_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNature03_03_Regular_Green_300x300.webm`
            ]
          },
          elemental: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            darkblue: [
              lg`Nature/GroupVineElemental01_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental01_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental01_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental01_03_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElemental02_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental02_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental02_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental02_03_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElemental03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental03_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental03_03_Dark_Blue_300x300.webm`
            ]
          },
          void: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            purplepink: [
              lg`Nature/GroupVineVoid01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid01_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid01_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoid02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid02_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid02_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoid03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid03_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid03_03_Dark_PinkPurple_300x300.webm`
            ]
          }
        },
        loop: {
          _free: ["nature"],
          nature: {
            _free: ["green"],
            green: [
              lg`Nature/GroupVineNatureLoop01_01_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNatureLoop02_01_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNatureLoop03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop01_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop01_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop01_03_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop02_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop02_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop02_03_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop03_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop03_03_Regular_Green_300x300.webm`
            ]
          },
          elemental: {
            darkblue: [
              lg`Nature/GroupVineElementalLoop01_01_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElementalLoop02_01_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElementalLoop03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop01_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop01_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop01_03_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop02_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop02_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop02_03_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop03_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop03_03_Dark_Blue_300x300.webm`
            ]
          },
          void: {
            purplepink: [
              lg`Nature/GroupVineVoidLoop01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoidLoop02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoidLoop03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop01_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop01_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop02_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop02_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop03_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop03_03_Dark_PinkPurple_300x300.webm`
            ]
          }
        }
      }
    },
    static: {
      _free: ["generic", "vines"],
      generic: {
        _free: ["water"],
        water: {
          _free: ["01"],
          "01": {
            _free: ["blue"],
            black: [lg`Liquid/WaterSplashLoop_01_01_Regular_Black_600x600.webm`],
            blue: [lg`Liquid/WaterSplashLoop_01_01_Regular_Blue_600x600.webm`],
            green: [lg`Liquid/WaterSplashLoop_01_01_Regular_Green_600x600.webm`],
            purple: [lg`Liquid/WaterSplashLoop_01_01_Regular_Purple_600x600.webm`],
            red: [lg`Liquid/WaterSplashLoop_01_01_Regular_Red_600x600.webm`]
          }
        }
      },
      liquid: {
        blob: {
          "01": {
            red: [lg`Liquid/LiquidBlob01_01_Regular_Red_400x400.webm`]
          }
        }
      },
      spell: {
        entangle: {
          "02": {
            purplepink: [l1`Entangle/EntangleLoop02_01_Dark_PinkPurple_500x500.webm`],
            green: [l1`Entangle/EntangleLoop02_02_Regular_Green_500x500.webm`],
            darkblue: [l1`Entangle/EntangleLoop02_03_Dark_Blue_500x500.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            purplepink: [l1`Entangle/Entangle02_01_Dark_PinkPurple_500x500.webm`],
            green: [l1`Entangle/Entangle02_02_Regular_Green_500x500.webm`],
            darkblue: [l1`Entangle/Entangle02_03_Dark_Blue_500x500.webm`]
          }
        }
      },
      vines: {
        _free: ["complete", "loop"],
        complete: {
          _free: ["nature"],
          nature: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            _free: ["green"],
            green: [
              lg`Nature/GroupVineNature01_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature01_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature01_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNature01_03_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNature02_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature02_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature02_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNature02_03_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNature03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNature03_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNature03_03_Regular_Green_300x300.webm`
            ]
          },
          elemental: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            darkblue: [
              lg`Nature/GroupVineElemental01_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental01_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental01_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental01_03_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElemental02_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental02_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental02_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental02_03_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElemental03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental03_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElemental03_03_Dark_Blue_300x300.webm`
            ]
          },
          void: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            purplepink: [
              lg`Nature/GroupVineVoid01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid01_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid01_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoid02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid02_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid02_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoid03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid03_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoid03_03_Dark_PinkPurple_300x300.webm`
            ]
          }
        },
        loop: {
          _free: ["nature"],
          nature: {
            _free: ["green"],
            green: [
              lg`Nature/GroupVineNatureLoop01_01_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNatureLoop02_01_Regular_Green_300x300.webm`,
              lg`Nature/GroupVineNatureLoop03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop01_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop01_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop01_03_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop02_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop02_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop02_03_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop03_01_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop03_02_Regular_Green_300x300.webm`,
              lg`Nature/VineNatureLoop03_03_Regular_Green_300x300.webm`
            ]
          },
          elemental: {
            darkblue: [
              lg`Nature/GroupVineElementalLoop01_01_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElementalLoop02_01_Dark_Blue_300x300.webm`,
              lg`Nature/GroupVineElementalLoop03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop01_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop01_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop01_03_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop02_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop02_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop02_03_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop03_01_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop03_02_Dark_Blue_300x300.webm`,
              lg`Nature/VineElementalLoop03_03_Dark_Blue_300x300.webm`
            ]
          },
          void: {
            purplepink: [
              lg`Nature/GroupVineVoidLoop01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoidLoop02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/GroupVineVoidLoop03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop01_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop01_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop01_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop02_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop02_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop02_03_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop03_01_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop03_02_Dark_PinkPurple_300x300.webm`,
              lg`Nature/VineVoidLoop03_03_Dark_PinkPurple_300x300.webm`
            ]
          }
        }
      }
    }
  };
  return patreonDB048;
}
async function db049(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l2 = prefix("2nd_Level");
  const lg = prefix("Generic");
  const patreonDB049 = {
    range: {
      _free: [],
      weapon: {
        flask: {
          "01": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Purple_90ft_4000x400.webm`]
            },
            red: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Red_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Red_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Red_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Red_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_Red_90ft_4000x400.webm`]
            },
            white: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_White_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask01_01_Regular_White_90ft_4000x400.webm`]
            }
          },
          "02": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Purple_90ft_4000x400.webm`]
            },
            red: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Red_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Red_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Red_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Red_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_Red_90ft_4000x400.webm`]
            },
            white: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_White_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask02_01_Regular_White_90ft_4000x400.webm`]
            }
          },
          "03": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Purple_90ft_4000x400.webm`]
            },
            red: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Red_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Red_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Red_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Red_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_Red_90ft_4000x400.webm`]
            },
            white: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_White_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowFlask03_01_Regular_White_90ft_4000x400.webm`]
            }
          }
        },
        grenade: {
          "03": {
            green: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Green_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Green_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Green_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Green_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Green_90ft_4000x400.webm`]
            },
            orange: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Orange_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Orange_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Orange_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Orange_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Orange_90ft_4000x400.webm`]
            },
            red: {
              "05ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Red_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Red_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Red_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Red_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/ThrowGrenade03_01_Regular_Red_90ft_4000x400.webm`]
            }
          }
        },
        grenadelaunch: {
          "03": {
            green: {
              "05ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Green_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Green_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Green_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Green_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Green_90ft_4000x400.webm`]
            },
            orange: {
              "05ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Orange_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Orange_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Orange_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Orange_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Orange_90ft_4000x400.webm`]
            },
            red: {
              "05ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Red_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Red_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Red_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Red_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/LaunchGrenade03_01_Regular_Red_90ft_4000x400.webm`]
            }
          }
        }
      }
    },
    static: {
      _free: ["spell"],
      generic: {
        fire: {
          ring: {
            grey: [lg`Fire/FireRing_01_Circle_Grey_900x900.webm`],
            purple: [lg`Fire/FireRing_01_Circle_Purple_900x900.webm`],
            yellow: [lg`Fire/FireRing_01_Circle_Yellow_900x900.webm`]
          }
        }
      },
      spell: {
        _free: ["divinesmite"],
        divinesmite: {
          _free: ["reverse"],
          reverse: {
            _free: ["yellowblue"],
            yellowblue: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_BlueYellow_Caster_400x400.webm`],
            greenyellow: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_GreenYellow_Caster_400x400.webm`],
            orange: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_Orange_Caster_400x400.webm`],
            purplepink: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_PurplePink_Caster_400x400.webm`],
            darkpurple: [l2`Divine_Smite/DivineSmiteReversed_01_Dark_Purple_Caster_400x400.webm`],
            yellowwhite: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_YellowWhite_Caster_400x400.webm`],
            darkred: [l2`Divine_Smite/DivineSmiteReversed_01_Dark_Red_Caster_400x400.webm`],
            greenorange: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_GreenOrange_Caster_400x400.webm`],
            pink: [l2`Divine_Smite/DivineSmiteReversed_01_Regular_Pink_Caster_400x400.webm`]
          }
        }
      }
    }
  };
  return patreonDB049;
}
async function db050(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l1 = prefix("1st_Level");
  const l7 = prefix("7th_Level");
  const lg = prefix("Generic");
  const patreonDB050 = {
    range: {
      _free: [],
      weapon: {
        boulder: {
          "02": {
            white: {
              "05ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_02_Regular_White_05ft_600x500.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_02_Regular_White_15ft_1000x500.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_02_Regular_White_30ft_1600x500.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_02_Regular_White_60ft_2800x500.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/BoulderToss01_02_Regular_White_90ft_4000x500.webm`]
            }
          }
        }
      }
    },
    templatefx: {
      _free: [],
      cone: {
        breathweaponspray01: {
          burst: {
            blue: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Ice01_Regular_Blue_Cone_Burst_800x800.webm`]
          },
          loop: {
            blue: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Ice01_Regular_Blue_Cone_Loop_800x800.webm`]
          }
        },
        breathweaponspray02: {
          burst: {
            blue: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Ice02_Regular_Blue_Cone_Burst_800x800.webm`]
          },
          loop: {
            blue: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Ice02_Regular_Blue_Cone_Loop_800x800.webm`]
          }
        }
      },
      ray: {
        breathweaponspray01: {
          burst: {
            blue: [lg`Template/Line/Breath_Weapon/Breathweapon02_Ice01_Regular_Blue_Line_Burst_1200x400.webm`]
          },
          loop: {
            blue: [lg`Template/Line/Breath_Weapon/Breathweapon02_Ice01_Regular_Blue_Line_Loop_1200x400.webm`]
          }
        }
      },
      square: {
        entangle: {
          "02": {
            darkorange: [l1`Entangle/EntangleLoop02_03_Dark_Orange_500x500.webm`]
          },
          complete: {
            darkorange: [l1`Entangle/Entangle02_03_Dark_Orange_500x500.webm`]
          }
        }
      },
      vines: {
        complete: {
          elemental: {
            darkorange: [
              lg`Nature/GroupVineElemental01_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElemental02_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElemental03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental01_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental01_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental01_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental02_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental02_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental02_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental03_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental03_03_Dark_Orange_300x300.webm`
            ]
          }
        },
        loop: {
          elemental: {
            darkorange: [
              lg`Nature/GroupVineElementalLoop01_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElementalLoop02_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElementalLoop03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop01_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop01_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop01_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop02_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop02_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop02_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop03_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop03_03_Dark_Orange_300x300.webm`
            ]
          }
        }
      }
    },
    static: {
      _free: ["plants"],
      generic: {
        boulderimpact: {
          "02": {
            white: [lg`Impact/BoulderImpactNoCracks_01_Regular_White_500x500.webm`]
          }
        }
      },
      plants: {
        _free: ["circle", "ring", "square"],
        circle: {
          _free: ["complete", "loop"],
          complete: {
            _markers: {
              loop: { start: 2e3, end: 6e3 }
            },
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthRound01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthRound02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthRound03_01_Regular_GreenYellow_500x500.webm`]
          },
          loop: {
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthRoundLoop01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthRoundLoop02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthRoundLoop03_01_Regular_GreenYellow_500x500.webm`]
          }
        },
        ring: {
          _free: ["complete", "loop", "pulse"],
          complete: {
            _markers: {
              loop: { start: 2e3, end: 6e3 }
            },
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthRing01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthRing02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthRing03_01_Regular_GreenYellow_500x500.webm`]
          },
          loop: {
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthRingLoop01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthRingLoop02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthRingLoop03_01_Regular_GreenYellow_500x500.webm`]
          },
          pulse: {
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthRingPulse01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthRingPulse02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthRingPulse03_01_Regular_GreenYellow_500x500.webm`]
          }
        },
        square: {
          _free: ["complete", "loop"],
          complete: {
            _markers: {
              loop: { start: 2e3, end: 6e3 }
            },
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthSquare01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthSquare02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthSquare03_01_Regular_GreenYellow_500x500.webm`]
          },
          loop: {
            _free: ["greenyellow"],
            purpleblue: [lg`Nature/PlantGrowthSquareLoop01_01_Regular_BluePurple_500x500.webm`],
            greenred: [lg`Nature/PlantGrowthSquareLoop02_01_Regular_GreenRed_500x500.webm`],
            greenyellow: [lg`Nature/PlantGrowthSquareLoop03_01_Regular_GreenYellow_500x500.webm`]
          }
        }
      },
      spell: {
        entangle: {
          "02": {
            darkorange: [l1`Entangle/EntangleLoop02_03_Dark_Orange_500x500.webm`]
          },
          complete: {
            darkorange: [l1`Entangle/Entangle02_03_Dark_Orange_500x500.webm`]
          }
        },
        whirlwind: {
          "01": {
            whiteblue: [l7`Whirlwind/Whirlwind_01_BlueWhite_400x400.webm`]
          }
        }
      },
      vines: {
        complete: {
          elemental: {
            darkorange: [
              lg`Nature/GroupVineElemental01_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElemental02_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElemental03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental01_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental01_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental01_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental02_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental02_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental02_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental03_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElemental03_03_Dark_Orange_300x300.webm`
            ]
          }
        },
        loop: {
          elemental: {
            darkorange: [
              lg`Nature/GroupVineElementalLoop01_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElementalLoop02_01_Dark_Orange_300x300.webm`,
              lg`Nature/GroupVineElementalLoop03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop01_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop01_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop01_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop02_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop02_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop02_03_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop03_01_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop03_02_Dark_Orange_300x300.webm`,
              lg`Nature/VineElementalLoop03_03_Dark_Orange_300x300.webm`
            ]
          }
        }
      }
    }
  };
  return patreonDB050;
}
async function db051(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l1 = prefix("1st_Level");
  const l3 = prefix("3rd_Level");
  const lg = prefix("Generic");
  const patreonDB051 = {
    range: {
      _template: "ranged",
      _free: [],
      weapon: {
        boomerang: {
          "01": {
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_90ft_4000x400.webm`]
            }
          },
          "02": {
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Boomerang01_02_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Boomerang01_02_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Boomerang01_02_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Boomerang01_02_Regular_White_90ft_4000x400.webm`]
            }
          }
        },
        bullet: {
          "1": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Bullet_01_Regular_Purple_90ft_4000x400.webm`]
            }
          },
          "2": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Bullet_02_Regular_Purple_90ft_4000x400.webm`]
            }
          },
          "3": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Bullet_03_Regular_Purple_90ft_4000x400.webm`]
            }
          }
        },
        snipe: {
          "01": {
            purple: {
              "05ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Purple_05ft_600x400.webm`],
              "15ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Purple_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Purple_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Purple_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Snipe_01_Regular_Purple_90ft_4000x400.webm`]
            }
          }
        },
        triboomerang: {
          "01": {
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_90ft_4000x400.webm`]
            }
          },
          "02": {
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Boomerang02_02_Regular_White_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Boomerang02_02_Regular_White_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Boomerang02_02_Regular_White_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Boomerang02_02_Regular_White_90ft_4000x400.webm`]
            }
          }
        }
      },
      spell: {
        fireballbeam: {
          "01": {
            darkgreen: {
              "05ft": [l3`Fireball/FireballBeam_01_Dark_Green_05ft_600x400.webm`],
              "15ft": [l3`Fireball/FireballBeam_01_Dark_Green_15ft_1000x400.webm`],
              "30ft": [l3`Fireball/FireballBeam_01_Dark_Green_30ft_1600x400.webm`],
              "60ft": [l3`Fireball/FireballBeam_01_Dark_Green_60ft_2800x400.webm`],
              "90ft": [l3`Fireball/FireballBeam_01_Dark_Green_90ft_4000x400.webm`]
            }
          }
        }
      }
    },
    templatefx: {
      _free: [],
      circle: {
        fireball: {
          loop: {
            darkgreen: [l3`Fireball/FireballLoop_01_Dark_Green_800x800.webm`]
          },
          explode: {
            darkgreen: [l3`Fireball/FireballExplosion_01_Dark_Green_800x800.webm`]
          },
          nodebris: {
            darkgreen: [l3`Fireball/FireballLoopNoDebris_01_Dark_Green_800x800.webm`]
          }
        }
      },
      square: {
        entangle: {
          "02": {
            grey: [l1`Entangle/EntangleLoop02_04_Regular_Grey_500x500.webm`]
          },
          complete: {
            grey: [l1`Entangle/Entangle02_04_Regular_Grey_500x500.webm`]
          }
        }
      },
      vines: {
        complete: {
          liquid: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            grey: [
              lg`Nature/GroupVineLiquid01_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid01_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid01_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid01_03_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquid02_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid02_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid02_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid02_03_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquid03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid03_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid03_03_Regular_Grey_300x300.webm`
            ]
          }
        },
        loop: {
          liquid: {
            grey: [
              lg`Nature/GroupVineLiquidLoop01_01_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquidLoop02_01_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquidLoop03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop01_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop01_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop01_03_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop02_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop02_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop02_03_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop03_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop03_03_Regular_Grey_300x300.webm`
            ]
          }
        }
      }
    },
    static: {
      _free: ["leaves", "marker"],
      leaves: {
        _free: ["outburst"],
        complete: {
          "01": {
            orangered: [lg`Nature/SwirlingLeavesComplete01_01_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesComplete01_01_Regular_Pink_400x400.webm`]
          },
          "02": {
            orangered: [lg`Nature/SwirlingLeavesComplete01_02_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesComplete01_02_Regular_Pink_400x400.webm`]
          },
          "03": {
            orangered: [lg`Nature/SwirlingLeavesComplete02_01_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesComplete02_01_Regular_Pink_400x400.webm`]
          }
        },
        loop: {
          "01": {
            orangered: [lg`Nature/SwirlingLeavesLoop01_01_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesLoop01_01_Regular_Pink_400x400.webm`]
          },
          "02": {
            orangered: [lg`Nature/SwirlingLeavesLoop01_02_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesLoop01_02_Regular_Pink_400x400.webm`]
          },
          "03": {
            orangered: [lg`Nature/SwirlingLeavesLoop02_01_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesLoop02_01_Regular_Pink_400x400.webm`]
          }
        },
        outburst: {
          _free: ["01"],
          "01": {
            _free: ["pink"],
            purpleblue: [lg`Nature/SwirlingLeavesOutburst_01_01_Regular_BluePurple_400x400.webm`],
            greenorange: [lg`Nature/SwirlingLeavesOutburst_01_01_Regular_GreenOrange_400x400.webm`],
            orangered: [lg`Nature/SwirlingLeavesOutburst_01_01_Regular_OrangeRed_400x400.webm`],
            pink: [lg`Nature/SwirlingLeavesOutburst_01_01_Regular_Pink_400x400.webm`]
          }
        }
      },
      magicsign: {
        abjuration: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        conjuration: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        divination: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        enchantment: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        evocation: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        illusion: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        necromancy: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        },
        transmutation: {
          complete: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            blue: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        }
      },
      marker: {
        _free: ["energystrand"],
        energystrand: {
          _free: ["02"],
          "02": {
            _free: ["purpleblue"],
            purpleblue: [lg`Marker/EnergyStrands02_01_Regular_BluePurple_400x400.webm`],
            green: [lg`Marker/EnergyStrands02_01_Regular_Green_400x400.webm`],
            greenorange: [lg`Marker/EnergyStrands02_01_Regular_GreenOrange_400x400.webm`],
            orangered: [lg`Marker/EnergyStrands02_01_Regular_OrangeRed_400x400.webm`]
          }
        }
      },
      spell: {
        entangle: {
          "02": {
            grey: [l1`Entangle/EntangleLoop02_04_Regular_Grey_500x500.webm`]
          },
          complete: {
            grey: [l1`Entangle/Entangle02_04_Regular_Grey_500x500.webm`]
          }
        },
        fireball: {
          loop: {
            darkgreen: [l3`Fireball/FireballLoop_01_Dark_Green_800x800.webm`]
          },
          explode: {
            darkgreen: [l3`Fireball/FireballExplosion_01_Dark_Green_800x800.webm`]
          },
          nodebris: {
            darkgreen: [l3`Fireball/FireballLoopNoDebris_01_Dark_Green_800x800.webm`]
          }
        }
      },
      vines: {
        complete: {
          liquid: {
            _markers: {
              loop: { start: 2125, end: 6250 }
            },
            grey: [
              lg`Nature/GroupVineLiquid01_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid01_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid01_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid01_03_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquid02_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid02_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid02_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid02_03_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquid03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid03_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquid03_03_Regular_Grey_300x300.webm`
            ]
          }
        },
        loop: {
          liquid: {
            grey: [
              lg`Nature/GroupVineLiquidLoop01_01_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquidLoop02_01_Regular_Grey_300x300.webm`,
              lg`Nature/GroupVineLiquidLoop03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop01_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop01_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop01_03_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop02_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop02_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop02_03_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop03_01_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop03_02_Regular_Grey_300x300.webm`,
              lg`Nature/VineLiquidLoop03_03_Regular_Grey_300x300.webm`
            ]
          }
        }
      }
    },
    return: {
      _template: "ranged",
      _free: [],
      weapon: {
        boomerang: {
          "01": {
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_Return_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_Return_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_Return_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Boomerang01_01_Regular_White_Return_90ft_4000x400.webm`]
            }
          }
        },
        triboomerang: {
          "01": {
            white: {
              "15ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_Return_15ft_1000x400.webm`],
              "30ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_Return_30ft_1600x400.webm`],
              "60ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_Return_60ft_2800x400.webm`],
              "90ft": [lg`Weapon_Attacks/Ranged/Boomerang02_01_Regular_White_Return_90ft_4000x400.webm`]
            }
          }
        }
      }
    }
  };
  return patreonDB051;
}
async function db052(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const lg = prefix("Generic");
  const patreonDB052 = {
    range: {
      _free: [],
      generic: {
        poison: {
          "01": {
            greenyellow: {
              "05ft": [lg`RangedSpell/ProjectilePoison01_01_Regular_GreenYellow_05ft_600x400.webm`],
              "15ft": [lg`RangedSpell/ProjectilePoison01_01_Regular_GreenYellow_15ft_1000x400.webm`],
              "30ft": [lg`RangedSpell/ProjectilePoison01_01_Regular_GreenYellow_30ft_1600x400.webm`],
              "60ft": [lg`RangedSpell/ProjectilePoison01_01_Regular_GreenYellow_60ft_2800x400.webm`],
              "90ft": [lg`RangedSpell/ProjectilePoison01_01_Regular_GreenYellow_90ft_4000x400.webm`]
            }
          }
        }
      }
    },
    melee: {
      _free: ["weapon", "generic"],
      weapon: {
        _free: ["lasersword"],
        lasersword: {
          _free: ["02"],
          "02": {
            _free: ["blue"],
            blue: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Blue_800x600.webm`],
            blue02: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Blue02_800x600.webm`],
            blue03: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Blue03_800x600.webm`],
            darkred: [lg`Weapon_Attacks/Melee/LaserSword01_02_Dark_Red_800x600.webm`],
            darkwhite: [lg`Weapon_Attacks/Melee/LaserSword01_02_Dark_White_800x600.webm`],
            green: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Green_800x600.webm`],
            green02: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Green02_800x600.webm`],
            orange: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Orange_800x600.webm`],
            purple: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Purple_800x600.webm`],
            red: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Red_800x600.webm`],
            white: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_White_800x600.webm`],
            yellow: [lg`Weapon_Attacks/Melee/LaserSword01_02_Regular_Yellow_800x600.webm`]
          }
        }
      },
      generic: {
        _free: ["slashing", "whirlwind"],
        slashing: {
          _free: ["01", "02", "03"],
          "01": {
            _free: ["orange"],
            greenyellow: [lg`Weapon_Attacks/Melee/GenericSlash01_01_Regular_GreenYellow_800x600.webm`],
            purpleblue: [lg`Weapon_Attacks/Melee/GenericSlash01_01_Regular_BluePurple_800x600.webm`],
            orange: [lg`Weapon_Attacks/Melee/GenericSlash01_01_Regular_Orange_800x600.webm`]
          },
          "02": {
            _free: ["orange"],
            greenyellow: [lg`Weapon_Attacks/Melee/GenericSlash01_02_Regular_GreenYellow_800x600.webm`],
            purpleblue: [lg`Weapon_Attacks/Melee/GenericSlash01_02_Regular_BluePurple_800x600.webm`],
            orange: [lg`Weapon_Attacks/Melee/GenericSlash01_02_Regular_Orange_800x600.webm`]
          },
          "03": {
            _free: ["orange"],
            greenyellow: [lg`Weapon_Attacks/Melee/GenericSlash01_03_Regular_GreenYellow_800x600.webm`],
            purpleblue: [lg`Weapon_Attacks/Melee/GenericSlash01_03_Regular_BluePurple_800x600.webm`],
            orange: [lg`Weapon_Attacks/Melee/GenericSlash01_03_Regular_Orange_800x600.webm`]
          }
        },
        whirlwind: {
          _free: ["01", "02"],
          "01": {
            _free: ["orange"],
            greenyellow: [lg`Weapon_Attacks/Melee/GenericWhirlwind01_01_Regular_GreenYellow_800x600.webm`],
            purpleblue: [lg`Weapon_Attacks/Melee/GenericWhirlwind01_01_Regular_BluePurple_800x600.webm`],
            orange: [lg`Weapon_Attacks/Melee/GenericWhirlwind01_01_Regular_Orange_800x600.webm`]
          },
          "02": {
            _free: ["orange"],
            greenyellow: [lg`Weapon_Attacks/Melee/GenericWhirlwind01_02_Regular_GreenYellow_800x600.webm`],
            purpleblue: [lg`Weapon_Attacks/Melee/GenericWhirlwind01_02_Regular_BluePurple_800x600.webm`],
            orange: [lg`Weapon_Attacks/Melee/GenericWhirlwind01_02_Regular_Orange_800x600.webm`]
          }
        }
      }
    },
    templatefx: {
      _free: ["circle"],
      circle: {
        _free: ["magicsign"],
        magicsign: {
          _free: [
            "abjuration",
            "conjuration",
            "divination",
            "enchantment",
            "evocation",
            "illusion",
            "necromancy",
            "transmutation"
          ],
          abjuration: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["blue"],
            blue: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/AbjurationCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          conjuration: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["yellow"],
            blue: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/ConjurationCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          divination: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["blue"],
            blue: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/DivinationCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          enchantment: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["pink"],
            blue: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/EnchantmentCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          evocation: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["red"],
            blue: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/EvocationCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          illusion: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["purple"],
            blue: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/IllusionCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          necromancy: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["green"],
            blue: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/NecromancyCircleComplete_02_Regular_Yellow_800x800.webm`]
          },
          transmutation: {
            _markers: {
              loop: { start: 3e3, end: 8e3 },
              forcedEnd: 8e3
            },
            _free: ["yellow"],
            blue: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Blue_800x800.webm`],
            green: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Green_800x800.webm`],
            pink: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Pink_800x800.webm`],
            purple: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Purple_800x800.webm`],
            red: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Red_800x800.webm`],
            yellow: [lg`Magic_Signs/TransmutationCircleComplete_02_Regular_Yellow_800x800.webm`]
          }
        }
      }
    },
    static: {
      _free: ["magicsign"],
      fire: {
        groundcrack: {
          "01": {
            white: [lg`Fire/GroundCrackLoop_01_Regular_White_600x600.webm`]
          },
          "02": {
            white: [lg`Fire/GroundCrackLoop_02_Regular_White_600x600.webm`]
          },
          "03": {
            white: [lg`Fire/GroundCrackLoop_03_Regular_White_600x600.webm`]
          }
        }
      },
      impact: {
        frost: {
          "01": {
            blue: [lg`Impact/FrostImpact_01_Regular_Blue_600x600.webm`],
            green: [lg`Impact/FrostImpact_01_Regular_Green_600x600.webm`],
            orange: [lg`Impact/FrostImpact_01_Regular_Orange_600x600.webm`],
            purple: [lg`Impact/FrostImpact_01_Regular_Purple_600x600.webm`],
            white: [lg`Impact/FrostImpact_01_Regular_White_600x600.webm`]
          }
        },
        groundcrack: {
          "01": {
            blue: [
              lg`Impact/GroundCrackImpact_01_Regular_Blue_600x600.webm`,
              lg`Impact/GroundCrackImpact_02_Regular_Blue_600x600.webm`,
              lg`Impact/GroundCrackImpact_03_Regular_Blue_600x600.webm`
            ],
            green: [
              lg`Impact/GroundCrackImpact_01_Regular_Green_600x600.webm`,
              lg`Impact/GroundCrackImpact_02_Regular_Green_600x600.webm`,
              lg`Impact/GroundCrackImpact_03_Regular_Green_600x600.webm`
            ],
            orange: [
              lg`Impact/GroundCrackImpact_01_Regular_Orange_600x600.webm`,
              lg`Impact/GroundCrackImpact_02_Regular_Orange_600x600.webm`,
              lg`Impact/GroundCrackImpact_03_Regular_Orange_600x600.webm`
            ],
            purple: [
              lg`Impact/GroundCrackImpact_01_Regular_Purple_600x600.webm`,
              lg`Impact/GroundCrackImpact_02_Regular_Purple_600x600.webm`,
              lg`Impact/GroundCrackImpact_03_Regular_Purple_600x600.webm`
            ],
            white: [
              lg`Impact/GroundCrackImpact_01_Regular_White_600x600.webm`,
              lg`Impact/GroundCrackImpact_02_Regular_White_600x600.webm`,
              lg`Impact/GroundCrackImpact_03_Regular_White_600x600.webm`
            ]
          },
          frost: {
            blue: [lg`Impact/GroundCrackFrostImpact_01_Regular_Blue_600x600.webm`],
            green: [lg`Impact/GroundCrackFrostImpact_01_Regular_Green_600x600.webm`],
            orange: [lg`Impact/GroundCrackFrostImpact_01_Regular_Orange_600x600.webm`],
            purple: [lg`Impact/GroundCrackFrostImpact_01_Regular_Purple_600x600.webm`],
            white: [lg`Impact/GroundCrackFrostImpact_01_Regular_White_600x600.webm`]
          }
        },
        poison: {
          "01": {
            green: [lg`Impact/ImpactPoison01_01_Regular_GreenYellow_400x400.webm`]
          }
        }
      },
      magicsign: {
        _free: [
          "abjuration",
          "conjuration",
          "divination",
          "enchantment",
          "evocation",
          "illusion",
          "necromancy",
          "transmutation"
        ],
        abjuration: {
          _free: ["complete"],
          complete: {
            _free: ["darkblue"],
            darkblue: [lg`Magic_Signs/AbjurationCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/AbjurationCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/AbjurationCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/AbjurationCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/AbjurationCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/AbjurationCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        },
        conjuration: {
          _free: ["complete"],
          complete: {
            _free: ["darkyellow"],
            darkblue: [lg`Magic_Signs/ConjurationCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/ConjurationCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/ConjurationCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/ConjurationCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/ConjurationCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/ConjurationCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        },
        divination: {
          _free: ["complete"],
          complete: {
            _free: ["darkblue"],
            darkblue: [lg`Magic_Signs/DivinationCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/DivinationCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/DivinationCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/DivinationCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/DivinationCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/DivinationCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        },
        enchantment: {
          _free: ["complete"],
          complete: {
            _free: ["darkpink"],
            darkblue: [lg`Magic_Signs/EnchantmentCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/EnchantmentCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/EnchantmentCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/EnchantmentCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/EnchantmentCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/EnchantmentCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        },
        illusion: {
          _free: ["complete"],
          complete: {
            _free: ["darkpurple"],
            darkblue: [lg`Magic_Signs/IllusionCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/IllusionCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/IllusionCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/IllusionCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/IllusionCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/IllusionCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        },
        necromancy: {
          _free: ["complete"],
          complete: {
            _free: ["darkgreen"],
            darkblue: [lg`Magic_Signs/NecromancyCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/NecromancyCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/NecromancyCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/NecromancyCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/NecromancyCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/NecromancyCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        },
        transmutation: {
          _free: ["complete"],
          complete: {
            _free: ["darkyellow"],
            darkblue: [lg`Magic_Signs/TransmutationCircleComplete_02_Dark_Blue_800x800.webm`],
            darkgreen: [lg`Magic_Signs/TransmutationCircleComplete_02_Dark_Green_800x800.webm`],
            darkpink: [lg`Magic_Signs/TransmutationCircleComplete_02_Dark_Pink_800x800.webm`],
            darkpurple: [lg`Magic_Signs/TransmutationCircleComplete_02_Dark_Purple_800x800.webm`],
            darkred: [lg`Magic_Signs/TransmutationCircleComplete_02_Dark_Red_800x800.webm`],
            darkyellow: [lg`Magic_Signs/TransmutationCircleComplete_02_Dark_Yellow_800x800.webm`]
          }
        }
      },
      sideImpact: {
        poison: {
          regular: {
            greenyellow: [lg`Impact/SideImpactPoison01_01_Regular_GreenYellow_600x600.webm`]
          },
          slow: {
            purplepink: [lg`Impact/PartSideImpactSlowPoison01_01_Regular_GreenYellow_600x600.webm`]
          }
        }
      }
    }
  };
  return patreonDB052;
}
async function db053(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l0 = prefix("Cantrip");
  const l1 = prefix("1st_Level");
  const l2 = prefix("2nd_Level");
  const lg = prefix("Generic");
  const patreonDB053 = {
    range: {
      _free: [],
      spell: {
        guidingbolt: {
          "01": {
            yellow: {
              "05ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Yellow_05ft_600x400.webm`],
              "15ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [l1`Guiding_Bolt/GuidingBolt_01_Regular_Yellow_90ft_4000x400.webm`]
            }
          },
          "02": {
            yellow: {
              "05ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Yellow_05ft_600x400.webm`],
              "15ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [l1`Guiding_Bolt/GuidingBolt_02_Regular_Yellow_90ft_4000x400.webm`]
            }
          }
        }
      },
      generic: {
        energybeam: {
          "01": {
            yellow: {
              "15ft": [lg`Energy/EnergyBeam_01_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [lg`Energy/EnergyBeam_01_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [lg`Energy/EnergyBeam_01_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [lg`Energy/EnergyBeam_01_Regular_Yellow_90ft_4000x400.webm`]
            }
          },
          "02": {
            yellow: {
              "05ft": [lg`Energy/EnergyBeam_02_Regular_Yellow_05ft_600x400.webm`],
              "15ft": [lg`Energy/EnergyBeam_02_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [lg`Energy/EnergyBeam_02_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [lg`Energy/EnergyBeam_02_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [lg`Energy/EnergyBeam_02_Regular_Yellow_90ft_4000x400.webm`]
            }
          },
          "03": {
            yellow: {
              "05ft": [lg`Energy/EnergyBeam_03_Regular_Yellow_05ft_600x400.webm`],
              "15ft": [lg`Energy/EnergyBeam_03_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [lg`Energy/EnergyBeam_03_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [lg`Energy/EnergyBeam_03_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [lg`Energy/EnergyBeam_03_Regular_Yellow_90ft_4000x400.webm`]
            }
          },
          reverse: {
            yellow: {
              "15ft": [lg`Energy/EnergyBeamReverse_01_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [lg`Energy/EnergyBeamReverse_01_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [lg`Energy/EnergyBeamReverse_01_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [lg`Energy/EnergyBeamReverse_01_Regular_Yellow_90ft_4000x400.webm`]
            }
          }
        },
        energystrand: {
          "02": {
            yellow: {
              "05ft": [lg`Energy/EnergyStrand_Multiple02_Regular_Yellow_05ft_600x400.webm`],
              "15ft": [lg`Energy/EnergyStrand_Multiple02_Regular_Yellow_15ft_1000x400.webm`],
              "30ft": [lg`Energy/EnergyStrand_Multiple02_Regular_Yellow_30ft_1600x400.webm`],
              "60ft": [lg`Energy/EnergyStrand_Multiple02_Regular_Yellow_60ft_2800x400.webm`],
              "90ft": [lg`Energy/EnergyStrand_Multiple02_Regular_Yellow_90ft_4000x400.webm`]
            }
          }
        }
      }
    },
    templatefx: {
      _free: [],
      circle: {
        detectmagic: {
          "01": {
            yellow: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Yellow_1200x1200.webm`]
          }
        },
        moonbeam: {
          loop: {
            yellow: [l2`Moonbeam/Moonbeam_01_Regular_Yellow_400x400.webm`]
          },
          intro: {
            yellow: [l2`Moonbeam/MoonbeamIntro_01_Regular_Yellow_400x400.webm`]
          },
          outro: {
            yellow: [l2`Moonbeam/MoonbeamOutro_01_Regular_Yellow_400x400.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 3708, end: 8708 }
            },
            blue: [l2`Moonbeam/MoonbeamComplete_01_Regular_Blue_400x400.webm`],
            green: [l2`Moonbeam/MoonbeamComplete_01_Regular_Green_400x400.webm`],
            rainbow: [l2`Moonbeam/MoonbeamComplete_01_Regular_Rainbow_400x400.webm`],
            yellow: [l2`Moonbeam/MoonbeamComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        outpulse: {
          "01": {
            yellowwhite: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_YellowWhite_Burst_600x600.webm`]
          },
          "02": {
            yellowwhite: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_YellowWhite_Burst_600x600.webm`]
          }
        }
      },
      cone: {
        detectmagic: {
          "01": {
            blue: [l1`Detect_Magic/DetectMagicCone_01_Regular_Blue_15ft_500x500.webm`],
            green: [l1`Detect_Magic/DetectMagicCone_01_Regular_Green_15ft_500x500.webm`],
            greenorange: [l1`Detect_Magic/DetectMagicCone_01_Regular_GreenOrange_15ft_500x500.webm`],
            grey: [l1`Detect_Magic/DetectMagicCone_01_Regular_Grey_15ft_500x500.webm`],
            purple: [l1`Detect_Magic/DetectMagicCone_01_Regular_Purple_15ft_500x500.webm`],
            yellow: [l1`Detect_Magic/DetectMagicCone_01_Regular_Yellow_15ft_500x500.webm`]
          }
        }
      }
    },
    static: {
      _free: ["marker", "nature", "sideImpact", "smoke"],
      energy: {
        energyfield: {
          "01": {
            yellow: [lg`Energy/EnergyField_01_Regular_Yellow_600x600.webm`]
          }
        },
        sparkles: {
          "01": {
            yellow: [lg`Energy/SwirlingSparkles_01_Regular_Yellow_400x400.webm`]
          }
        }
      },
      generic: {
        outpulse: {
          "01": {
            yellowwhite: [lg`Template/Circle/OutPulse/OutPulse_01_Regular_YellowWhite_Burst_600x600.webm`]
          },
          "02": {
            yellowwhite: [lg`Template/Circle/OutPulse/OutPulse_02_Regular_YellowWhite_Burst_600x600.webm`]
          }
        },
        smoke: {
          "01": {
            green: [lg`Smoke/SmokePuff01_01_Regular_Green_400x400.webm`]
          },
          "02": {
            green: [lg`Smoke/SmokePuff01_02_Regular_Green_400x400.webm`]
          },
          "03": {
            green: [lg`Smoke/SmokePuff01_03_Regular_Green_400x400.webm`]
          }
        }
      },
      ice: {
        icespikes: {
          "01": {
            grey: [lg`Ice/IceSpikesRadialBurst_01_Regular_Grey_1000x1000.webm`],
            yellow: [lg`Ice/IceSpikesRadialBurst_01_Regular_Yellow_1000x1000.webm`]
          }
        },
        snowflake: {
          "01": {
            yellowwhite: [lg`Ice/SnowflakeBurst_01_Regular_YellowWhite_Burst_600x600.webm`]
          }
        }
      },
      marker: {
        _free: ["bubble", "roundshield", "smokering"],
        bubble: {
          _free: ["complete"],
          "01": {
            yellow: [lg`Marker/MarkerBubble_01_Regular_Yellow_400x400.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 2625, end: 7625 }
            },
            _free: ["blue", "_markers"],
            blue: [lg`Marker/MarkerBubbleComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Marker/MarkerBubbleComplete_01_Regular_Green_400x400.webm`],
            rainbow: [lg`Marker/MarkerBubbleComplete_01_Regular_Rainbow_400x400.webm`],
            yellow: [lg`Marker/MarkerBubbleComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        light: {
          intro: {
            blue: [lg`Marker/MarkerLightIntro_01_Regular_Blue_400x400.webm`],
            green: [lg`Marker/MarkerLightIntro_01_Regular_Green_400x400.webm`],
            yellow: [lg`Marker/MarkerLightIntro_01_Regular_Yellow_400x400.webm`]
          },
          outro: {
            blue: [lg`Marker/MarkerLightOutro_01_Regular_Blue_400x400.webm`],
            green: [lg`Marker/MarkerLightOutro_01_Regular_Green_400x400.webm`],
            yellow: [lg`Marker/MarkerLightOutro_01_Regular_Yellow_400x400.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 3750, end: 8750 }
            },
            blue: [lg`Marker/MarkerLightComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Marker/MarkerLightComplete_01_Regular_Green_400x400.webm`],
            yellow: [lg`Marker/MarkerLightComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        roundshield: {
          _free: ["loop", "complete"],
          loop: {
            _free: ["orange"],
            darkred: [lg`Marker/MarkerShieldRampartLoop01_01_Dark_Red_400x400.webm`],
            orange: [lg`Marker/MarkerShieldRampartLoop01_01_Regular_Orange_400x400.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 1916, end: 6208 }
            },
            _free: ["orange", "_markers"],
            darkred: [lg`Marker/MarkerShieldRampart01_01_Dark_Red_400x400.webm`],
            orange: [lg`Marker/MarkerShieldRampart01_01_Regular_Orange_400x400.webm`]
          }
        },
        boneshield: {
          loop: {
            green: [lg`Marker/MarkerShieldRampartLoop02_01_Regular_Green_400x400.webm`],
            purple: [lg`Marker/MarkerShieldRampartLoop02_01_Regular_Purple_400x400.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 1916, end: 6208 }
            },
            green: [lg`Marker/MarkerShieldRampart02_01_Regular_Green_400x400.webm`],
            purple: [lg`Marker/MarkerShieldRampart02_01_Regular_Purple_400x400.webm`]
          }
        },
        towershield: {
          loop: {
            blue: [lg`Marker/MarkerShieldRampartLoop03_01_Regular_Blue_400x400.webm`],
            yellow: [lg`Marker/MarkerShieldRampartLoop03_01_Regular_Yellow_400x400.webm`]
          },
          complete: {
            _markers: {
              loop: { start: 1916, end: 6208 }
            },
            blue: [lg`Marker/MarkerShieldRampart03_01_Regular_Blue_400x400.webm`],
            yellow: [lg`Marker/MarkerShieldRampart03_01_Regular_Yellow_400x400.webm`]
          }
        },
        smokering: {
          _free: ["loop"],
          loop: {
            _free: ["purpleblue"],
            darkred: [lg`Marker/MarkerSmokeRingLoop01_Dark_Red_400x400.webm`],
            purpleblue: [lg`Marker/MarkerSmokeRingLoop01_Regular_BluePurple_400x400.webm`],
            purple: [lg`Marker/MarkerSmokeRingLoop01_Regular_Purple_400x400.webm`],
            yellow: [lg`Marker/MarkerSmokeRingLoop01_Regular_Yellow_400x400.webm`]
          }
        },
        standard: {
          "01": {
            yellow: [lg`Marker/Marker_01_Regular_Yellow_400x400.webm`]
          },
          "02": {
            yellow: [lg`Marker/Marker_02_Regular_Yellow_400x400.webm`]
          }
        }
      },
      nature: {
        _free: ["feathers"],
        feathers: {
          _free: ["outburst"],
          outburst: {
            _free: ["textured"],
            blue: [
              lg`Nature/SwirlingFeathersOutburst01_01_Regular_Blue_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst02_01_Regular_Blue_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst03_01_Regular_Blue_400x400.webm`
            ],
            orange: [
              lg`Nature/SwirlingFeathersOutburst01_01_Regular_Orange_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst02_01_Regular_Orange_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst03_01_Regular_Orange_400x400.webm`
            ],
            purple: [
              lg`Nature/SwirlingFeathersOutburst01_01_Regular_Purple_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst02_01_Regular_Purple_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst03_01_Regular_Purple_400x400.webm`
            ],
            red: [
              lg`Nature/SwirlingFeathersOutburst01_01_Regular_Red_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst02_01_Regular_Red_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst03_01_Regular_Red_400x400.webm`
            ],
            textured: [
              lg`Nature/SwirlingFeathersOutburst01_01_Regular_Textured_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst02_01_Regular_Textured_400x400.webm`,
              lg`Nature/SwirlingFeathersOutburst03_01_Regular_Textured_400x400.webm`
            ]
          }
        }
      },
      shieldfx: {
        energyfield: {
          "01": {
            yellow: [lg`Energy/EnergyFieldTop_02_Regular_Yellow_400x400.webm`]
          }
        }
      },
      sideImpact: {
        _free: ["smoke"],
        smoke: {
          _free: ["01", "02"],
          "01": {
            _free: ["grey"],
            black: [
              lg`Smoke/SmokePuffSide01_01_Dark_Black_400x400.webm`,
              lg`Smoke/SmokePuffSide01_02_Dark_Black_400x400.webm`,
              lg`Smoke/SmokePuffSide01_03_Dark_Black_400x400.webm`,
              lg`Smoke/SmokePuffSide01_04_Dark_Black_400x400.webm`,
              lg`Smoke/SmokePuffSide01_05_Dark_Black_400x400.webm`
            ],
            blue: [
              lg`Smoke/SmokePuffSide01_01_Regular_Blue_400x400.webm`,
              lg`Smoke/SmokePuffSide01_02_Regular_Blue_400x400.webm`,
              lg`Smoke/SmokePuffSide01_03_Regular_Blue_400x400.webm`,
              lg`Smoke/SmokePuffSide01_04_Regular_Blue_400x400.webm`,
              lg`Smoke/SmokePuffSide01_05_Regular_Blue_400x400.webm`
            ],
            darkgreen: [
              lg`Smoke/SmokePuffSide01_01_Dark_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_02_Dark_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_03_Dark_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_04_Dark_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_05_Dark_Green_400x400.webm`
            ],
            darkpurple: [
              lg`Smoke/SmokePuffSide01_01_Dark_Purple_400x400.webm`,
              lg`Smoke/SmokePuffSide01_02_Dark_Purple_400x400.webm`,
              lg`Smoke/SmokePuffSide01_03_Dark_Purple_400x400.webm`,
              lg`Smoke/SmokePuffSide01_04_Dark_Purple_400x400.webm`,
              lg`Smoke/SmokePuffSide01_05_Dark_Purple_400x400.webm`
            ],
            green: [
              lg`Smoke/SmokePuffSide01_01_Regular_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_02_Regular_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_03_Regular_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_04_Regular_Green_400x400.webm`,
              lg`Smoke/SmokePuffSide01_05_Regular_Green_400x400.webm`
            ],
            grey: [
              lg`Smoke/SmokePuffSide01_01_Regular_Grey_400x400.webm`,
              lg`Smoke/SmokePuffSide01_02_Regular_Grey_400x400.webm`,
              lg`Smoke/SmokePuffSide01_03_Regular_Grey_400x400.webm`,
              lg`Smoke/SmokePuffSide01_04_Regular_Grey_400x400.webm`,
              lg`Smoke/SmokePuffSide01_05_Regular_Grey_400x400.webm`
            ]
          },
          "02": {
            _free: ["white"],
            black: [
              lg`Smoke/SmokePuffSide02_01_Dark_Black_400x400.webm`,
              lg`Smoke/SmokePuffSide02_02_Dark_Black_400x400.webm`,
              lg`Smoke/SmokePuffSide02_03_Dark_Black_400x400.webm`
            ],
            white: [
              lg`Smoke/SmokePuffSide02_01_Regular_White_400x400.webm`,
              lg`Smoke/SmokePuffSide02_02_Regular_White_400x400.webm`,
              lg`Smoke/SmokePuffSide02_03_Regular_White_400x400.webm`
            ]
          }
        }
      },
      smoke: {
        _free: ["plume"],
        plume: {
          _free: ["complete"],
          complete: {
            _markers: {
              loop: { start: 2e3, end: 4e3 }
            },
            _free: ["grey", "_markers"],
            blue: [
              lg`Smoke/SmokePlumes01_01_Regular_Blue_400x400.webm`,
              lg`Smoke/SmokePlumes01_02_Regular_Blue_400x400.webm`,
              lg`Smoke/SmokePlumes01_03_Regular_Blue_400x400.webm`
            ],
            darkgreen: [
              lg`Smoke/SmokePlumes01_01_Dark_Green_400x400.webm`,
              lg`Smoke/SmokePlumes01_02_Dark_Green_400x400.webm`,
              lg`Smoke/SmokePlumes01_03_Dark_Green_400x400.webm`
            ],
            darkred: [
              lg`Smoke/SmokePlumes01_01_Dark_Red_400x400.webm`,
              lg`Smoke/SmokePlumes01_02_Dark_Red_400x400.webm`,
              lg`Smoke/SmokePlumes01_03_Dark_Red_400x400.webm`
            ],
            grey: [
              lg`Smoke/SmokePlumes01_01_Regular_Grey_400x400.webm`,
              lg`Smoke/SmokePlumes01_02_Regular_Grey_400x400.webm`,
              lg`Smoke/SmokePlumes01_03_Regular_Grey_400x400.webm`
            ],
            purple: [
              lg`Smoke/SmokePlumes01_01_Regular_Purple_400x400.webm`,
              lg`Smoke/SmokePlumes01_02_Regular_Purple_400x400.webm`,
              lg`Smoke/SmokePlumes01_03_Regular_Purple_400x400.webm`
            ],
            yellow: [
              lg`Smoke/SmokePlumes01_01_Regular_Yellow_400x400.webm`,
              lg`Smoke/SmokePlumes01_02_Regular_Yellow_400x400.webm`,
              lg`Smoke/SmokePlumes01_03_Regular_Yellow_400x400.webm`
            ]
          }
        }
      },
      spell: {
        moonbeam: {
          loop: {
            yellow: [l2`Moonbeam/Moonbeam_01_Regular_Yellow_400x400.webm`]
          },
          intro: {
            yellow: [l2`Moonbeam/MoonbeamIntro_01_Regular_Yellow_400x400.webm`]
          },
          outro: {
            yellow: [l2`Moonbeam/MoonbeamOutro_01_Regular_Yellow_400x400.webm`]
          },
          complete: {
            blue: [l2`Moonbeam/MoonbeamComplete_01_Regular_Blue_400x400.webm`],
            green: [l2`Moonbeam/MoonbeamComplete_01_Regular_Green_400x400.webm`],
            rainbow: [l2`Moonbeam/MoonbeamComplete_01_Regular_Rainbow_400x400.webm`],
            yellow: [l2`Moonbeam/MoonbeamComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        curewounds: {
          "01": {
            yellow: [l1`Cure_Wounds/CureWounds_01_Yellow_400x400.webm`]
          }
        },
        detectmagic: {
          "01": {
            yellow: [l1`Detect_Magic/DetectMagicCircle_01_Regular_Yellow_1200x1200.webm`]
          }
        },
        tollthedead: {
          bell: {
            yellow: [l0`Toll_The_Dead/TollTheDeadBell_01_Regular_Yellow_400x400.webm`]
          },
          complete: {
            yellow: [l0`Toll_The_Dead/TollTheDead_01_Regular_Yellow_400x400.webm`]
          },
          shockwave: {
            yellow: [l0`Toll_The_Dead/TollTheDeadShockwave_01_Regular_Yellow_400x400.webm`]
          },
          skull: {
            yellow: [l0`Toll_The_Dead/TollTheDeadSkullSmoke_01_Regular_Yellow_400x400.webm`]
          }
        }
      }
    }
  };
  return patreonDB053;
}
async function db054(path) {
  const BASE = `${path}/Library/`;
  const prefix = (str) => (strs, ...exprs) => `${BASE}${str}/${strs.reduce((a, c, i) => a + exprs[i - 1] + c)}`;
  const l1 = prefix("1st_Level");
  const l2 = prefix("2nd_Level");
  const l3 = prefix("3rd_Level");
  const lg = prefix("Generic");
  const patreonDB054 = {
    range: {
      _template: "ranged",
      _free: ["generic"],
      spell: {
        fireballbeam: {
          "01": {
            darkred: {
              "05ft": [l3`Fireball/FireballBeam_01_Dark_Red_05ft_600x400.webm`],
              "15ft": [l3`Fireball/FireballBeam_01_Dark_Red_15ft_1000x400.webm`],
              "30ft": [l3`Fireball/FireballBeam_01_Dark_Red_30ft_1600x400.webm`],
              "60ft": [l3`Fireball/FireballBeam_01_Dark_Red_60ft_2800x400.webm`],
              "90ft": [l3`Fireball/FireballBeam_01_Dark_Red_90ft_4000x400.webm`]
            }
          }
        }
      },
      generic: {
        _free: ["energywall"],
        energywall: {
          _free: ["loop", "complete"],
          loop: {
            _free: ["orange"],
            blue: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Blue_05x05ft_Loop_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Blue_10x05ft_Loop_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Blue_15x05ft_Loop_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Blue_25x05ft_Loop_1400x400.webm`]
            },
            green: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Green_05x05ft_Loop_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Green_10x05ft_Loop_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Green_15x05ft_Loop_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Green_25x05ft_Loop_1400x400.webm`]
            },
            orange: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Orange_05x05ft_Loop_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Orange_10x05ft_Loop_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Orange_15x05ft_Loop_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Orange_25x05ft_Loop_1400x400.webm`]
            },
            purple: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Purple_05x05ft_Loop_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Purple_10x05ft_Loop_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Purple_15x05ft_Loop_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Purple_25x05ft_Loop_1400x400.webm`]
            },
            red: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Red_05x05ft_Loop_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Red_10x05ft_Loop_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Red_15x05ft_Loop_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Red_25x05ft_Loop_1400x400.webm`]
            }
          },
          complete: {
            _free: ["orange"],
            blue: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Blue_05x05ft_Complete_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Blue_10x05ft_Complete_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Blue_15x05ft_Complete_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Blue_25x05ft_Complete_1400x400.webm`]
            },
            green: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Green_05x05ft_Complete_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Green_10x05ft_Complete_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Green_15x05ft_Complete_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Green_25x05ft_Complete_1400x400.webm`]
            },
            orange: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Orange_05x05ft_Complete_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Orange_10x05ft_Complete_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Orange_15x05ft_Complete_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Orange_25x05ft_Complete_1400x400.webm`]
            },
            purple: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Purple_05x05ft_Complete_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Purple_10x05ft_Complete_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Purple_15x05ft_Complete_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Purple_25x05ft_Complete_1400x400.webm`]
            },
            red: {
              "05ft": [lg`Energy/EnergyWall01_01_Regular_Red_05x05ft_Complete_400x400.webm`],
              "10ft": [lg`Energy/EnergyWall01_01_Regular_Red_10x05ft_Complete_800x400.webm`],
              "15ft": [lg`Energy/EnergyWall01_01_Regular_Red_15x05ft_Complete_1000x400.webm`],
              "25ft": [lg`Energy/EnergyWall01_01_Regular_Red_25x05ft_Complete_1400x400.webm`]
            }
          }
        }
      }
    },
    templatefx: {
      _free: ["circle"],
      circle: {
        _free: ["energy"],
        detectmagic: {
          "01": {
            darkred: [l1`Detect_Magic/DetectMagicCircle_01_Dark_Red_1200x1200.webm`]
          }
        },
        energy: {
          _free: ["loop", "complete"],
          loop: {
            _free: ["orange"],
            blue: [lg`Energy/EnergyWall01_01_Regular_Blue_Circle_Loop_900x900.webm`],
            green: [lg`Energy/EnergyWall01_01_Regular_Green_Circle_Loop_900x900.webm`],
            orange: [lg`Energy/EnergyWall01_01_Regular_Orange_Circle_Loop_900x900.webm`],
            purple: [lg`Energy/EnergyWall01_01_Regular_Purple_Circle_Loop_900x900.webm`],
            red: [lg`Energy/EnergyWall01_01_Regular_Red_Circle_Loop_900x900.webm`]
          },
          complete: {
            _free: ["orange", "_markers"],
            _markers: {
              loop: { start: 700, end: 3333 }
            },
            blue: [lg`Energy/EnergyWall01_01_Regular_Blue_Circle_Complete_900x900.webm`],
            green: [lg`Energy/EnergyWall01_01_Regular_Green_Circle_Complete_900x900.webm`],
            orange: [lg`Energy/EnergyWall01_01_Regular_Orange_Circle_Complete_900x900.webm`],
            purple: [lg`Energy/EnergyWall01_01_Regular_Purple_Circle_Complete_900x900.webm`],
            red: [lg`Energy/EnergyWall01_01_Regular_Red_Circle_Complete_900x900.webm`]
          }
        },
        fireball: {
          loop: {
            darkred: [l3`Fireball/FireballLoop_01_Dark_Red_800x800.webm`]
          },
          explode: {
            darkred: [l3`Fireball/FireballExplosion_01_Dark_Red_800x800.webm`]
          },
          nodebris: {
            darkred: [l3`Fireball/FireballLoopNoDebris_01_Dark_Red_800x800.webm`]
          }
        }
      },
      cone: {
        breathweaponspray01: {
          burst: {
            black: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana01_Dark_Black_Cone_Burst_800x800.webm`]
          },
          loop: {
            black: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana01_Dark_Black_Cone_Loop_800x800.webm`]
          }
        },
        breathweaponspray02: {
          burst: {
            black: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana02_Dark_Black_Cone_Burst_800x800.webm`]
          },
          loop: {
            black: [lg`Template/Cone/Breath_Weapon/Breathweapon02_Arcana02_Dark_Black_Cone_Loop_800x800.webm`]
          }
        },
        detectmagic: {
          "01": {
            darkred: [l1`Detect_Magic/DetectMagicCone_01_Dark_Red_15ft_500x500.webm`]
          }
        }
      },
      ray: {
        breathweaponspray01: {
          burst: {
            black: [lg`Template/Line/Breath_Weapon/Breathweapon02_Arcana01_Dark_Black_Line_Burst_1200x400.webm`]
          },
          loop: {
            black: [lg`Template/Line/Breath_Weapon/Breathweapon02_Arcana01_Dark_Black_Line_Loop_1200x400.webm`]
          }
        }
      }
    },
    static: {
      _free: ["energy", "magicsign"],
      conditions: {
        skull: {
          "01": {
            darkred: [lg`Marker/MarkerSkull_01_Dark_Red_400x400.webm`]
          },
          "02": {
            darkred: [lg`Marker/MarkerSkull_02_Dark_Red_400x400.webm`]
          },
          "03": {
            darkred: [lg`Marker/MarkerSkull_03_Dark_Red_400x400.webm`]
          }
        }
      },
      energy: {
        _free: ["circle"],
        circle: {
          _free: ["loop", "complete"],
          loop: {
            _free: ["orange"],
            blue: [lg`Energy/EnergyWall01_01_Regular_Blue_Circle_Loop_500x500.webm`],
            green: [lg`Energy/EnergyWall01_01_Regular_Green_Circle_Loop_500x500.webm`],
            orange: [lg`Energy/EnergyWall01_01_Regular_Orange_Circle_Loop_500x500.webm`],
            purple: [lg`Energy/EnergyWall01_01_Regular_Purple_Circle_Loop_500x500.webm`],
            red: [lg`Energy/EnergyWall01_01_Regular_Red_Circle_Loop_500x500.webm`]
          },
          complete: {
            _free: ["orange"],
            blue: [lg`Energy/EnergyWall01_01_Regular_Blue_Circle_Complete_500x500.webm`],
            green: [lg`Energy/EnergyWall01_01_Regular_Green_Circle_Complete_500x500.webm`],
            orange: [lg`Energy/EnergyWall01_01_Regular_Orange_Circle_Complete_500x500.webm`],
            purple: [lg`Energy/EnergyWall01_01_Regular_Purple_Circle_Complete_500x500.webm`],
            red: [lg`Energy/EnergyWall01_01_Regular_Red_Circle_Complete_500x500.webm`]
          }
        }
      },
      fire: {
        groundcrack: {
          "01": {
            darkred: [lg`Fire/GroundCrackLoop_01_Dark_Red_600x600.webm`]
          },
          "02": {
            darkred: [lg`Fire/GroundCrackLoop_02_Dark_Red_600x600.webm`]
          },
          "03": {
            darkred: [lg`Fire/GroundCrackLoop_03_Dark_Red_600x600.webm`]
          }
        }
      },
      generic: {
        ui: {
          skull: {
            darkred: [lg`UI/IconSkull_01_Dark_Red_200x200.webm`]
          }
        }
      },
      lightning: {
        strike: {
          "01": {
            red: [
              lg`Lightning/LightningStrike01_01_Regular_Red_800x800.webm`,
              lg`Lightning/LightningStrike01_02_Regular_Red_800x800.webm`,
              lg`Lightning/LightningStrike01_03_Regular_Red_800x800.webm`,
              lg`Lightning/LightningStrike01_04_Regular_Red_800x800.webm`,
              lg`Lightning/LightningStrike01_05_Regular_Red_800x800.webm`,
              lg`Lightning/LightningStrike01_06_Regular_Red_800x800.webm`
            ]
          }
        }
      },
      magicsign: {
        _free: [
          "abjuration",
          "conjuration",
          "divination",
          "enchantment",
          "evocation",
          "illusion",
          "necromancy",
          "transmutation"
        ],
        abjuration: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["blue"],
            blue: [lg`Magic_Signs/Runes/AbjurationRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/AbjurationRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/AbjurationRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/AbjurationRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/AbjurationRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/AbjurationRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        conjuration: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["yellow"],
            blue: [lg`Magic_Signs/Runes/ConjurationRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/ConjurationRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/ConjurationRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/ConjurationRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/ConjurationRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/ConjurationRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        divination: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["blue"],
            blue: [lg`Magic_Signs/Runes/DivinationRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/DivinationRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/DivinationRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/DivinationRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/DivinationRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/DivinationRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        enchantment: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["pink"],
            blue: [lg`Magic_Signs/Runes/EnchantmentRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/EnchantmentRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/EnchantmentRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/EnchantmentRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/EnchantmentRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/EnchantmentRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        evocation: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["red"],
            blue: [lg`Magic_Signs/Runes/EvocationRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/EvocationRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/EvocationRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/EvocationRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/EvocationRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/EvocationRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        illusion: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["purple"],
            blue: [lg`Magic_Signs/Runes/IllusionRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/IllusionRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/IllusionRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/IllusionRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/IllusionRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/IllusionRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        necromancy: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["green"],
            blue: [lg`Magic_Signs/Runes/NecromancyRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/NecromancyRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/Runes/NecromancyRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/NecromancyRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/NecromancyRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/NecromancyRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        },
        transmutation: {
          _free: ["runecomplete"],
          runecomplete: {
            _free: ["yellow"],
            blue: [lg`Magic_Signs/Runes/TransmutationRuneComplete_01_Regular_Blue_400x400.webm`],
            green: [lg`Magic_Signs/Runes/TransmutationRuneComplete_01_Regular_Green_400x400.webm`],
            pink: [lg`Magic_Signs/RunesTransmutationRuneComplete_01_Regular_Pink_400x400.webm`],
            purple: [lg`Magic_Signs/Runes/TransmutationRuneComplete_01_Regular_Purple_400x400.webm`],
            red: [lg`Magic_Signs/Runes/TransmutationRuneComplete_01_Regular_Red_400x400.webm`],
            yellow: [lg`Magic_Signs/Runes/TransmutationRuneComplete_01_Regular_Yellow_400x400.webm`]
          }
        }
      },
      shieldfx: {
        fire: {
          "01": {
            blue: [lg`Fire/ShieldFireAbove01_01_Regular_Blue_400x400.webm`],
            purple: [lg`Fire/ShieldFireAbove01_01_Regular_Purple_400x400.webm`]
          },
          "03": {
            blue: [lg`Fire/ShieldFireAbove01_03_Regular_Blue_400x400.webm`],
            purple: [lg`Fire/ShieldFireAbove01_03_Regular_Purple_400x400.webm`]
          }
        }
      },
      spell: {
        mistystep: {
          "01": {
            pink: [l2`Misty_Step/MistyStep_01_Regular_Pink_400x400.webm`]
          },
          "02": {
            pink: [l2`Misty_Step/MistyStep_02_Regular_Pink_400x400.webm`]
          }
        },
        shatter: {
          "01": {
            darkred: [l2`Shatter/Shatter_01_Dark_Red_400x400.webm`]
          }
        }
      }
    }
  };
  return patreonDB054;
}
const dbMerge = {
  async handle(freeVersion, patreonVersion, s3Location) {
    const freePath = s3Location ? s3Location : "modules/JB2A_DnD5e";
    const patreonPath = s3Location ? s3Location : "modules/jb2a_patreon";
    if (patreonVersion) {
      for (let [version, migration] of Object.entries(this.migrations)) {
        if (!foundry.utils.isNewerVersion(patreonVersion, version)) {
          if (patreonVersion === version) {
            await migration(patreonPath, true);
            break;
          } else {
            break;
          }
        }
        await migration(patreonPath, true);
      }
    }
    if (freeVersion) {
      for (let [version, migration] of Object.entries(this.migrations)) {
        if (foundry.utils.isNewerVersion(patreonVersion, version)) {
          continue;
        }
        if (patreonVersion === version) {
          continue;
        }
        if (!foundry.utils.isNewerVersion(freeVersion, version)) {
          if (freeVersion === version) {
            await migration(freePath);
            break;
          } else {
            break;
          }
        }
        await migration(freePath);
      }
    }
    return;
  },
  migrations: {
    "0.4.7": async (path, isPatreon = false) => {
      let db047$1 = await db047(path);
      await sortDatabase(db047$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db047$1);
    },
    "0.4.8": async (path, isPatreon = false) => {
      let db048$1 = await db048(path);
      await sortDatabase(db048$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db048$1);
    },
    "0.4.9": async (path, isPatreon = false) => {
      let db049$1 = await db049(path);
      await sortDatabase(db049$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db049$1);
    },
    "0.5.0": async (path, isPatreon = false) => {
      let db050$1 = await db050(path);
      await sortDatabase(db050$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db050$1);
    },
    "0.5.1": async (path, isPatreon = false) => {
      let db051$1 = await db051(path);
      await sortDatabase(db051$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db051$1);
    },
    "0.5.2": async (path, isPatreon = false) => {
      let db052$1 = await db052(path);
      await sortDatabase(db052$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db052$1);
    },
    "0.5.3": async (path, isPatreon = false) => {
      let db053$1 = await db053(path);
      await sortDatabase(db053$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db053$1);
    },
    "0.5.4": async (path, isPatreon = false) => {
      let db054$1 = await db054(path);
      await sortDatabase(db054$1, isPatreon);
      foundry.utils.mergeObject(aaDatabase$1, db054$1);
    }
  }
};
function debug$1(...args) {
  if (game.settings.get("autoanimations", "debug")) {
    console.log(`DEBUG | Automated Animations |`, ...args);
  }
}
function custom_notify(message, consoleLog = false) {
  message = `Automated Animations | ${message}`;
  if (consoleLog) {
    console.log(`%c${message.replace("<br>", "\n")}`, "color: orange");
  } else {
    ui.notifications.notify(message);
  }
}
function custom_warning(warning, notify = false, ...args) {
  warning = `Automated Animations | ${warning}`;
  if (notify) {
    ui.notifications.warn(warning);
  }
  console.warn(warning.replace("<br>", "\n"), ...args);
}
function custom_error$1(error, notify = true) {
  error = `Automated Animations | ${error}`;
  if (notify) {
    ui.notifications.error(error);
  }
  return new Error(error.replace("<br>", "\n"));
}
function howToDelete(type) {
  if (game.settings.get("autoanimations", "noTips")) {
    return;
  }
  let disableTips = "You can disabled these tips in the Automated Animations module settings";
  switch (type) {
    case "overheadtile":
      custom_notify(`This is an OVERHEAD Tile. Use the Tile Foreground Layer to remove the Animation. ${disableTips}`);
      break;
    case "groundtile":
      custom_notify(`This is an GROUND Tile. Use the Tile Layer to remove the Animation. ${disableTips}`);
      break;
    case "sequencerground":
      custom_notify(`This is a SEQUENCER Persistent Effect. Use the Sequencer Effect Manager to remove the Animation. ${disableTips}`);
      break;
  }
}
let aaDatabase$1;
async function initializeAADB() {
  const freePath = "modules/JB2A_DnD5e";
  const patreonPath = "modules/jb2a_patreon";
  let s3Location = game.settings.get("autoanimations", "jb2aLocation");
  const jb2aFreeFound = game.modules.get("JB2A_DnD5e");
  const jb2aPatreonFound = game.modules.get("jb2a_patreon");
  if (game.user.isGM && (!jb2aFreeFound && !jb2aPatreonFound)) {
    if (s3Location && (s3Location.includes("jb2a_patreon") || s3Location.includes("JB2A_DnD5e"))) ;
    else {
      ui.notifications.error(game.i18n.format("autoanimations.settings.error"));
    }
  }
  const freeVersion = jb2aFreeFound?.version ?? "";
  const patreonVersion = jb2aPatreonFound?.version ?? "";
  if (s3Location) {
    if (s3Location.includes("patreon")) {
      await initializeJB2APatreonDB(s3Location);
      aaDatabase$1 = JB2APATREONDB;
      await dbMerge.handle("", patreonVersion, s3Location);
    } else if (s3Location.includes("JB2A_DnD5e")) {
      await initializeJB2AFreeDB(s3Location);
      aaDatabase$1 = JB2AFREEDB;
      await dbMerge.handle(freeVersion, "", s3Location);
    } else {
      await initializeJB2APatreonDB(s3Location);
      aaDatabase$1 = JB2APATREONDB;
      custom_error$1("You have specified an External path (S3 Bucket or other) incorrectly. Check your Automated Animations module settings", true);
    }
  } else if (!patreonVersion && !freeVersion) {
    await initializeJB2AFreeDB(freePath);
    custom_error$1("You do not have a JB2A module installed, Automated Animation Select menus will NOT work", true);
  } else {
    if (jb2aPatreonFound) {
      await initializeJB2APatreonDB(patreonPath);
      aaDatabase$1 = JB2APATREONDB;
    } else {
      await initializeJB2AFreeDB(freePath);
      aaDatabase$1 = JB2AFREEDB;
    }
    await dbMerge.handle(freeVersion, patreonVersion);
  }
  Sequencer.Database.registerEntries("autoanimations", aaDatabase$1, true);
  console.log("%cAutomated Animations Database has been compiled and registered", "color: green", { aaDatabase: aaDatabase$1 });
  Hooks.callAll("aa.ready", aaDatabase$1);
}
async function sortDatabase(database, isPatreon = false) {
  if (isPatreon) {
    return await removeFreeMarker(database);
  } else {
    await removePatreonContent();
  }
  return database;
  async function removePatreonContent() {
    let sections = Object.keys(database);
    for (let section2 of sections) {
      if (section2 === "_templates") {
        continue;
      }
      let freeOptions = database[section2]._free;
      if (!freeOptions) {
        continue;
      }
      await removePatreonTypes(freeOptions, section2);
      let types = Object.keys(database[section2]);
      for (let type of types) {
        if (type === "_template") {
          continue;
        }
        let freeOptions2 = database[section2][type]._free;
        if (!freeOptions2) {
          continue;
        }
        await removePatreonAnimations(freeOptions2, section2, type);
        let animations = Object.keys(database[section2][type]);
        for (let animation of animations) {
          let freeOptions3 = database[section2][type][animation]._free;
          if (!freeOptions3) {
            continue;
          }
          await removePatreonVariants(freeOptions3, section2, type, animation);
          let variants = Object.keys(database[section2][type][animation]);
          for (let variant of variants) {
            let freeOptions4 = database[section2][type][animation][variant]._free;
            if (!freeOptions4) {
              continue;
            }
            await removePatreonColors(freeOptions4, section2, type, animation, variant);
          }
        }
      }
    }
  }
  async function removePatreonTypes(freeOptions, section2) {
    let types = Object.keys(database[section2]);
    for (let i = 0; i < types.length; i++) {
      let typeFound = freeOptions.indexOf(types[i]);
      if (typeFound === -1) {
        delete database[section2][types[i]];
      }
    }
  }
  async function removePatreonAnimations(freeOptions, section2, type) {
    let animations = Object.keys(database[section2][type]);
    for (let i = 0; i < animations.length; i++) {
      let animationFound = freeOptions.indexOf(animations[i]);
      if (animationFound === -1) {
        delete database[section2][type][animations[i]];
      }
    }
  }
  async function removePatreonVariants(freeOptions, section2, type, animation) {
    let variants = Object.keys(database[section2][type][animation]);
    for (let i = 0; i < variants.length; i++) {
      let variantFound = freeOptions.indexOf(variants[i]);
      if (variantFound === -1) {
        delete database[section2][type][animation][variants[i]];
      }
    }
  }
  async function removePatreonColors(freeOptions, section2, type, animation, variant) {
    let colors = Object.keys(database[section2][type][animation][variant]);
    for (let i = 0; i < colors.length; i++) {
      let colorFound = freeOptions.indexOf(colors[i]);
      if (colorFound === -1) {
        delete database[section2][type][animation][variant][colors[i]];
      }
    }
  }
}
async function removeFreeMarker(database) {
  await deleteFreeMarker();
  return database;
  async function deleteFreeMarker() {
    let sections = Object.keys(database);
    for (let section2 of sections) {
      if (section2 === "_templates") {
        continue;
      }
      await removePatreonType(section2);
      let types = Object.keys(database[section2]);
      for (let type of types) {
        if (type === "_template") {
          continue;
        }
        await removePatreonAnimation(section2, type);
        let animations = Object.keys(database[section2][type]);
        for (let animation of animations) {
          await removePatreonVariant(section2, type, animation);
          let variants = Object.keys(database[section2][type][animation]);
          for (let variant of variants) {
            await removePatreonColor(section2, type, animation, variant);
          }
        }
      }
    }
  }
  async function removePatreonType(section2) {
    let types = Object.keys(database[section2]);
    for (let i = 0; i < types.length; i++) {
      delete database[section2]._free;
    }
  }
  async function removePatreonAnimation(section2, type) {
    let animations = Object.keys(database[section2][type]);
    for (let i = 0; i < animations.length; i++) {
      delete database[section2][type]._free;
    }
  }
  async function removePatreonVariant(section2, type, animation) {
    let variants = Object.keys(database[section2][type][animation]);
    for (let i = 0; i < variants.length; i++) {
      delete database[section2][type][animation]._free;
    }
  }
  async function removePatreonColor(section2, type, animation, variant) {
    let colors = Object.keys(database[section2][type][animation][variant]);
    for (let i = 0; i < colors.length; i++) {
      delete database[section2][type][animation][variant]._free;
    }
  }
}
class Hashing {
  static #regexUuidv = /^[0-9A-F]{8}-[0-9A-F]{4}-4[0-9A-F]{3}-[89AB][0-9A-F]{3}-[0-9A-F]{12}$/i;
  /**
   * @hideconstructor
   */
  constructor() {
    throw new Error("Hashing constructor: This is a static class and should not be constructed.");
  }
  /**
   * Provides a solid string hashing algorithm.
   *
   * Sourced from: https://stackoverflow.com/a/52171480
   *
   * @param {string}   str - String to hash.
   *
   * @param {number}   [seed=0] - A seed value altering the hash.
   *
   * @returns {number} Hash code.
   */
  static hashCode(str, seed = 0) {
    if (typeof str !== "string") {
      return 0;
    }
    let h1 = 3735928559 ^ seed, h2 = 1103547991 ^ seed;
    for (let ch, i = 0; i < str.length; i++) {
      ch = str.charCodeAt(i);
      h1 = Math.imul(h1 ^ ch, 2654435761);
      h2 = Math.imul(h2 ^ ch, 1597334677);
    }
    h1 = Math.imul(h1 ^ h1 >>> 16, 2246822507) ^ Math.imul(h2 ^ h2 >>> 13, 3266489909);
    h2 = Math.imul(h2 ^ h2 >>> 16, 2246822507) ^ Math.imul(h1 ^ h1 >>> 13, 3266489909);
    return 4294967296 * (2097151 & h2) + (h1 >>> 0);
  }
  /**
   * Validates that the given string is formatted as a UUIDv4 string.
   *
   * @param {unknown}   uuid - UUID string to test.
   *
   * @returns {uuid is string} Is UUIDv4 string.
   */
  static isUuidv4(uuid) {
    return typeof uuid === "string" && this.#regexUuidv.test(uuid);
  }
  /**
   * Generates a UUID v4 compliant ID. Please use a complete UUID generation package for guaranteed compliance.
   *
   * This code is an evolution of the following Gist.
   * https://gist.github.com/jed/982883
   *
   * There is a public domain / free copy license attached to it that is not a standard OSS license...
   * https://gist.github.com/jed/982883#file-license-txt
   *
   * @returns {string} UUIDv4
   */
  static uuidv4() {
    return ("10000000-1000-4000-8000" + -1e11).replace(/[018]/g, (c) => (c ^ (globalThis.crypto ?? globalThis.msCrypto).getRandomValues(
      new Uint8Array(1)
    )[0] & 15 >> c / 4).toString(16));
  }
}
class Strings {
  /**
   * @hideconstructor
   */
  constructor() {
    throw new Error("Strings constructor: This is a static class and should not be constructed.");
  }
  /**
   * Escape a given input string prefacing special characters with backslashes for use in a regular expression.
   *
   * @param {string}   string - An un-escaped input string.
   *
   * @returns {string} The escaped string suitable for use in a regular expression.
   */
  static escape(string) {
    return string.replace(/[-/\\^$*+?.()|[\]{}]/g, "\\$&");
  }
  /**
   * Normalizes a string.
   *
   * @param {string}   string - A string to normalize for comparisons.
   *
   * @returns {string} Cleaned string.
   *
   * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String/normalize
   */
  static normalize(string) {
    return string.trim().normalize("NFD").replace(/[\x00-\x1F]/gm, "");
  }
}
class Timing {
  /**
   * @hideconstructor
   */
  constructor() {
    throw new Error("Timing constructor: This is a static class and should not be constructed.");
  }
  /**
   * Wraps a callback in a debounced timeout. Delay execution of the callback function until the function has not been
   * called for the given delay in milliseconds.
   *
   * @template Args
   *
   * @param {(...args: Args[]) => void} callback - A function to execute once the debounced threshold has been passed.
   *
   * @param {number}   delay - An amount of time in milliseconds to delay.
   *
   * @returns {(...args: Args[]) => void} A wrapped function that can be called to debounce execution.
   *
   * @example
   * /**
   *  * Debounce the update invocation by 500ms.
   *  *\/
   * const updateDebounced = Timing.debounce(() => doc.update(), 500);
   *
   * // Use the function like:
   * updateDebounced();
   *
   * @example
   * /**
   *  * Debounce the update invocation by 500ms.
   *  *
   *  * \@param {string} value - A value to update.
   *  *\/
   * const updateDebounced = Timing.debounce((value) => doc.update(value), 500);
   *
   * // Use the function like:
   * updateDebounced('new value');
   */
  static debounce(callback, delay) {
    if (typeof callback !== "function") {
      throw new TypeError(`'callback' must be a function.`);
    }
    if (!Number.isInteger(delay) || delay < 0) {
      throw new TypeError(`'delay' must be a positive integer representing milliseconds.`);
    }
    let timeoutId;
    return function(...args) {
      globalThis.clearTimeout(timeoutId);
      timeoutId = globalThis.setTimeout(() => {
        callback.apply(this, args);
      }, delay);
    };
  }
  /**
   * Creates a double click event handler that distinguishes between single and double clicks. Calls the `single`
   * callback on a single click and the `double` callback on a double click. The default double click delay to invoke
   * the `double` callback is 400 milliseconds.
   *
   * @param {object}   opts - Optional parameters.
   *
   * @param {(event: Event) => void} [opts.single] - Single click callback.
   *
   * @param {(event: Event) => void} [opts.double] - Double click callback.
   *
   * @param {number}   [opts.delay=400] - Double click delay.
   *
   * @returns {(event: Event) => void} The gated double-click handler.
   *
   * @example
   * // Given a button element.
   * button.addEventListener('click', Timing.doubleClick({
   *    single: (event) => console.log('Single click: ', event),
   *    double: (event) => console.log('Double click: ', event)
   * });
   */
  static doubleClick({ single, double, delay = 400 }) {
    if (single !== void 0 && typeof single !== "function") {
      throw new TypeError(`'single' must be a function.`);
    }
    if (double !== void 0 && typeof double !== "function") {
      throw new TypeError(`'double' must be a function.`);
    }
    if (!Number.isInteger(delay) || delay < 0) {
      throw new TypeError(`'delay' must be a positive integer representing milliseconds.`);
    }
    let clicks = 0;
    let timeoutId;
    return (event) => {
      globalThis.clearTimeout(timeoutId);
      clicks++;
      if (clicks === 1) {
        timeoutId = globalThis.setTimeout(() => {
          if (typeof single === "function") {
            single(event);
          }
          clicks = 0;
        }, delay);
      } else {
        if (typeof double === "function") {
          double(event);
        }
        clicks = 0;
      }
    };
  }
}
async function version01(flags) {
  const oldFlags = flags || {};
  const type = oldFlags.animType;
  const data2 = {
    killAnim: oldFlags.killAnim ?? false,
    below: oldFlags.animLevel ?? false,
    override: oldFlags.override ?? false,
    //animType: 'function here',
    //animation: 'animation function here',
    //color: 'color funciton here',
    //'options.repeat': type === 't8' ? oldFlags.templates?.tempLoop || 1 : oldFlags.options?.loops || 1,
    //'options.delay': type === 't8' ? oldFlags.templates?.loopDelay || 250 : oldFlags.options?.loopDelay || 250,
    //'options.scale': oldFlags.options?.scale ?? 1,
    //enableCustom: 'function here',
    //customPath: 'function here',
    targetToken: oldFlags.targetToken?.enable ? oldFlags.targetToken : { enable: false },
    sourceToken: oldFlags.sourceToken?.enable ? oldFlags.sourceToken : { enable: false },
    allSounds: oldFlags.allSounds ?? {},
    autoOverride: oldFlags.options?.overrideAuto ? await overrideAuto() : { enable: false },
    version: 1
  };
  if (oldFlags.override) {
    switch (type) {
      case "t2":
        data2.animType = "melee";
        data2.animation = replaceName(oldFlags.animName);
        data2.color = replaceName(oldFlags.color);
        data2.meleeSwitch = oldFlags.meleeSwitch?.switchType === "custom" ? await rangeSwitch() : { switchType: oldFlags.meleeSwitch?.switchType ?? "on" };
        data2.explosions = oldFlags.explosion ? await explosions() : { enable: false };
        data2.options = {
          meleeType: "weapon",
          variant: oldFlags.uaStrikeType ?? "01",
          repeat: oldFlags.options?.loops || 1,
          delay: oldFlags.options?.loopDelay || 250,
          scale: oldFlags.options?.scale ?? 1,
          enableCustom: oldFlags.options?.enableCustom01 ?? false,
          customPath: oldFlags.options?.customPath01 ?? ""
        };
        break;
      case "t3":
        let genericList = ["flurryofblows", "unarmedstrike"];
        data2.animation = replaceName(oldFlags.animName);
        data2.animType = "melee";
        data2.color = replaceName(oldFlags.color);
        data2.meleeSwitch = oldFlags.meleeSwitch?.switchType === "custom" ? await rangeSwitch() : { switchType: oldFlags.meleeSwitch?.switchType ?? "on" };
        data2.explosions = oldFlags.explosion ? await explosions() : { enable: false };
        data2.options = {
          meleeType: genericList.includes(data2.animation) ? "weapon" : "generic",
          variant: oldFlags.uaStrikeType ?? "01",
          repeat: oldFlags.options?.loops || 1,
          delay: oldFlags.options?.loopDelay || 250,
          scale: oldFlags.options?.scale ?? 1,
          enableCustom: oldFlags.options?.enableCustom01 ?? false,
          customPath: oldFlags.options?.customPath01 ?? ""
        };
        break;
      case "t4":
        let t4VariantSwitch = function(name) {
          switch (name) {
            case "bolt":
            case "bullet":
            case "arrow":
              return oldFlags.rangedOptions?.rangeDmgType ?? "01";
            case "lasersword":
            case "dagger":
            case "handaxe":
            case "chakram":
              return oldFlags.dtvar ?? "01";
            default:
              return "01";
          }
        };
        data2.animType = "range";
        data2.animation = replaceName(oldFlags.animName);
        data2.color = replaceName(oldFlags.color);
        data2.explosions = oldFlags.explosion ? await explosions() : { enable: false };
        data2.options = {
          rangeType: "weapon",
          variant: t4VariantSwitch(replaceName(oldFlags.animName)),
          repeat: oldFlags.options?.loops || 1,
          delay: oldFlags.options?.loopDelay || 250
        };
        break;
      case "t5":
        data2.animType = "static";
        data2.animation = replaceName(oldFlags.animName);
        data2.color = replaceName(oldFlags.color);
        data2.explosions = oldFlags.explosion ? await explosions() : { enable: false };
        data2.options = {
          staticType: "target",
          staticOptions: "creature",
          variant: "01",
          repeat: oldFlags.options?.loops || 1,
          delay: oldFlags.options?.loopDelay || 250,
          scale: oldFlags.options?.scale ?? 1,
          enableCustom: oldFlags.options?.enableCustom01 ?? false,
          customPath: oldFlags.options?.customPath01 ?? ""
        };
        break;
      case "t6":
        data2.animType = "range";
        data2.animation = replaceName(oldFlags.animName);
        data2.color = replaceName(oldFlags.color);
        data2.explosions = oldFlags.explosion ? await explosions() : { enable: false };
        data2.options = {
          rangeType: "spell",
          variant: oldFlags.spellVar ?? "01",
          repeat: oldFlags.options?.loops || 1,
          delay: oldFlags.options?.loopDelay || 250
        };
        break;
      case "t7":
        data2.animType = "static";
        data2.animation = replaceName(oldFlags.animName);
        data2.color = replaceName(oldFlags.color);
        data2.explosions = oldFlags.explosion ? await explosions() : { enable: false };
        data2.options = {
          staticType: "targetDefault",
          staticOptions: "staticSpells",
          variant: oldFlags.spellVar ?? "01",
          repeat: oldFlags.options?.loops || 1,
          delay: oldFlags.options?.loopDelay || 250,
          scale: oldFlags.options?.scale ?? 1,
          enableCustom: oldFlags.options?.enableCustom01 ?? false,
          customPath: oldFlags.options?.customPath01 ?? ""
        };
        break;
      case "t8":
        const tempAnimVar = await templateAnimation2();
        data2.animType = "template";
        data2.animation = tempAnimVar.name;
        data2.color = replaceName(oldFlags.templates?.tempColor);
        data2.options = {
          tempType: oldFlags.templates?.tempType,
          variant: tempAnimVar.variant,
          removeTemplate: oldFlags.templates?.removeTemplate ?? false,
          enableCustom: oldFlags.templates?.customAnim ?? false,
          customPath: oldFlags.templates?.customPath ?? "",
          persistent: oldFlags.templates?.persistent ?? false,
          persistType: oldFlags.templates?.persistent && oldFlags.templates?.overhead ? "overheadtile" : "sequencerground",
          opacity: oldFlags.templates?.opacity ?? 0.75,
          overhead: oldFlags.templates?.overhead ?? false,
          occlusionMode: oldFlags.templates?.occlusionMode ?? "03",
          occlusionAlpha: oldFlags.templates?.occlusionAlpha ?? 0.75,
          repeat: oldFlags.templates?.tempLoop || 1,
          delay: oldFlags.templates?.loopDelay || 250
        };
        break;
      case "t9":
      case "t10":
        data2.animType = "static";
        data2.animation = replaceName(oldFlags.explodeVariant);
        data2.color = replaceName(oldFlags.explodeColor);
        data2.explosions = { enable: false };
        data2.options = {
          staticType: type === "t9" ? "target" : "source",
          staticOptions: "explosion",
          variant: oldFlags.options?.variant ?? "01",
          repeat: oldFlags.explodeLoop || 1,
          delay: oldFlags.explodeDelay || 250,
          scale: oldFlags.options?.scale ?? 1,
          enableCustom: oldFlags.options?.enableCustomExplosion ?? false,
          customPath: oldFlags.options?.customExplosion ?? ""
        };
        break;
      case "t11":
        data2.animType = "aura";
        data2.animation = replaceName(oldFlags.animName);
        data2.color = replaceName(oldFlags.color);
        data2.options = {
          variant: "01",
          enableCustom: oldFlags.options?.enableCustom01 ?? false,
          customPath: oldFlags.options?.customPath01 ?? "",
          auraRadius: oldFlags.selfRadius ?? 3.5,
          opacity: oldFlags.auraOpacity ?? 0.75,
          ignoreTarget: oldFlags.ignoreTarget ?? false
        };
        break;
      case "t12":
        data2.animType = "preset";
        data2.animation = "teleportation";
        data2.color = replaceName(oldFlags.color);
        data2.options = {
          name: replaceName(oldFlags.animName),
          variant: "01",
          teleDist: oldFlags.teleDist ?? 30,
          scale: oldFlags.options?.scale ?? 1,
          hideTemplate: oldFlags.options?.hideTemplate ?? false,
          enableCustom: oldFlags.options?.enableCustom01 ?? false,
          customPath: oldFlags.options?.customPath01 ?? ""
        };
        break;
      case "t13":
        const presetName = replaceName(oldFlags.animName);
        data2.animType = "preset";
        data2.animation = presetName;
        data2.color = replaceName(oldFlags.color);
        switch (presetName) {
          case "shieldspell":
            data2.options = {
              variant: oldFlags.spellVar ?? "01",
              shieldVar: oldFlags.shieldVar ?? "outro_explode"
            };
            break;
          case "bardicinspiration":
            data2.bards = oldFlags.bards;
            break;
          case "huntersmark":
            data2.options = {
              variant: replaceName(oldFlags.hmAnim),
              persistent: oldFlags.ctaOption ?? false
            };
            break;
          case "sneakattack":
            data2.options = {
              variant: "01"
            };
            break;
          case "bless":
            data2.options = {
              variant: "01",
              persistent: oldFlags.options.addCTA ?? false
            };
            break;
        }
        break;
    }
  }
  async function overrideAuto() {
    const auto = oldFlags.options ?? {};
    const data3 = {
      enable: true,
      variant: auto.autoVariant ?? "01",
      color: auto.autoColor ?? "",
      repeat: auto.autoRepeat ?? 1,
      endEffect: auto.endEffect ?? "outro_explode",
      delay: auto.autoDelay ?? 250,
      scale: auto.autoScale ?? 1,
      fireball: auto.autoFireball ?? {}
    };
    return data3;
  }
  async function explosions() {
    const explosion = {
      enable: true,
      below: oldFlags.exAnimLevel ?? false,
      radius: oldFlags.explodeRadius ?? 2,
      delay: oldFlags.explodeDelay ?? 500,
      animation: replaceName(oldFlags.explodeVariant) ?? "",
      variant: "01",
      color: replaceName(oldFlags.explodeColor),
      enableCustom: oldFlags.options?.enableCustomExplosion ?? false,
      customPath: oldFlags.options?.customExplosion ?? ""
    };
    return explosion;
  }
  async function rangeSwitch() {
    const data3 = {
      animation: oldFlags.meleeSwitch?.animName ?? "",
      variant: switchVariants(replaceName(oldFlags.animName)),
      switchType: "custom",
      color: oldFlags.meleeSwitch?.color ?? "white",
      detect: oldFlags.meleeSwitch?.detect ?? "auto",
      range: oldFlags.meleeSwitch?.detect === "custom" ? oldFlags.meleeSwitch?.range ?? 2 : 2,
      returning: oldFlags.meleeSwitch?.returning ?? false
    };
    function switchVariants(name) {
      switch (name) {
        case "bolt":
        case "bullet":
        case "arrow":
          return oldFlags.meleeSwitch?.rangeDmgType ?? "01";
        case "lasersword":
        case "dagger":
        case "handaxe":
          return oldFlags.meleeSwitch?.rangeVar ?? "01";
        default:
          return "01";
      }
    }
    return data3;
  }
  async function templateAnimation2() {
    switch (oldFlags.templates?.tempType) {
      case "cone":
        switch (oldFlags.templates?.tempAnim) {
          case "coneofcold":
            return { name: "coneofcold", variant: "01" };
          case "burninghands01":
            return { name: "burninghands", variant: "01" };
          case "burninghands02":
            return { name: "burninghands", variant: "02" };
          default:
            return { name: "breathweaponcone", variant: oldFlags.templates?.tempAnim };
        }
      case "ray":
        switch (oldFlags.templates?.tempAnim) {
          case "lightningbolt01":
            return { name: "lightningbolt", variant: "01" };
          case "lightningbolt02":
            return { name: "lightningbolt", variant: "02" };
          default:
            return { name: "breathweaponline", variant: oldFlags.templates?.tempAnim };
        }
      case "circle":
        switch (oldFlags.templates?.tempAnim) {
          case "snowflake":
            return { name: "snowflake", variant: "01" };
          case "outpulse01":
            return { name: "outpulse01", variant: "01" };
          case "outpulse02":
            return { name: "outpulse02", variant: "01" };
          case "shatter":
            return { name: "shatter", variant: "01" };
          case "fogcloud":
            return { name: "fogcloud", variant: "01" };
          case "darkness":
            return { name: "darkness", variant: "01" };
          case "calllightning":
            return { name: "calllightning", variant: "01" };
          case "sleetstorm":
            return { name: "sleetstorm", variant: "01" };
          case "cloudofdaggers":
            return { name: "cloudofdaggers", variant: "01" };
          case "cloudofkunais":
            return { name: "cloudofdaggers", variant: "02" };
          default:
            return { name: "explosion", variant: "01" };
        }
      case "rect":
        switch (oldFlags.templates?.tempAnim) {
          case "entangle":
            return { name: "entangle", variant: "01" };
          case "thunderwave":
            return { name: "thunderwave", variant: "01" };
          default:
            return { name: "web", variant: "01" };
        }
      default:
        return {};
    }
  }
  function replaceName(name) {
    if (!name) {
      return "";
    }
    const newName = name.replace(/\s+/g, "").toLowerCase();
    return newName;
  }
  return data2;
}
async function version02(flags) {
  const v2Flags = flags || {};
  const allSounds = v2Flags.allSounds || {};
  v2Flags.audio = {
    a01: {
      enable: allSounds.item?.enableAudio ?? false,
      file: allSounds.item?.file ?? "",
      delay: allSounds.item?.delay ?? 0,
      volume: allSounds.item?.volume ?? 0.25
    },
    e01: {
      enable: allSounds.explosion?.audioExplodeEnabled || false,
      file: allSounds.explosion?.file ?? "",
      delay: allSounds.explosion?.delay ?? 0,
      volume: allSounds.explosion?.volume ?? 0.25
    }
  };
  v2Flags.version = 2;
  return v2Flags;
}
async function version03(flags) {
  const v3Flags = flags || {};
  if (v3Flags.killAnim) {
    v3Flags.version = 3;
    return v3Flags;
  }
  if (v3Flags.override) {
    if (v3Flags.animType === "template") {
      v3Flags.options.scaleX = v3Flags.options.scale || 1;
      v3Flags.options.scaleY = v3Flags.options.scale || 1;
    }
    if (v3Flags.animType === "preset") {
      if (v3Flags.animation === "teleportation") {
        v3Flags.options.measureType = "alternating";
        v3Flags.options.hideFromPlayers = v3Flags.options?.hideTemplate === true ? true : false;
        v3Flags.options.enableCustom02 = v3Flags.options?.enableCustom ? true : false;
        v3Flags.options.customPath02 = v3Flags.options?.enableCustom ? v3Flags.options?.customPath : "";
        v3Flags.options.name02 = v3Flags.options?.name ?? "mistystep";
        v3Flags.options.variant02 = "02";
        v3Flags.color02 = v3Flags.color || "blue";
        v3Flags.options.scale02 = v3Flags.options?.scale ?? 1;
      }
    }
    v3Flags.version = 3;
    return v3Flags;
  }
}
async function version04(flags) {
  const v4Flags = flags || {};
  const options2 = v4Flags.options || {};
  if (v4Flags.killAnim) {
    v4Flags.version = 4;
    return v4Flags;
  }
  if (v4Flags.sourceToken?.enable) {
    await convertExtraFX(v4Flags.sourceToken);
  }
  if (v4Flags.sourceToken?.enable) {
    await convertExtraFX(v4Flags.targetToken);
  }
  if (v4Flags.override) {
    const section2 = v4Flags.animType;
    switch (section2) {
      case "melee":
        options2.menuType = options2.meleeType;
        if (v4Flags.explosions?.enable) {
          await convertExplosion(v4Flags.explosions);
        }
        delete options2.meleeType;
        break;
      case "range":
        const genericRange = ["energyconduitsquare", "energyconduitcircle", "energybeam", "heart", "iceshard", "musicnote", "skull", "energystrand"];
        if (genericRange.some((el) => v4Flags.animation === el)) {
          options2.menuType = "generic";
          if (v4Flags.animation === "energyconduitcircle") {
            v4Flags.animation = "conduit";
            options2.variant = "circle";
          }
          if (v4Flags.animation === "energyconduitsquare") {
            v4Flags.animation = "conduit";
            options2.variant = "square";
          }
        } else {
          options2.menuType = options2.rangeType;
        }
        if (v4Flags.explosions?.enable) {
          await convertExplosion(v4Flags.explosions);
        }
        delete options2.rangeType;
        break;
      case "static":
        const conditions = ["drop", "fear", "heart", "horror", "light", "poison", "runes", "shields", "crackedshield", "skull", "snowflakes", "stun", "dizzystars"];
        const creature = ["bite", "claw"];
        const energy = ["energyfield", "dodecahedron", "shimmer", "sparkles"];
        const fire = ["eruption", "groundcrack", "fireworks"];
        const generic = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02", "vortex", "whirl"];
        const ice = ["icespikes", "snowflake"];
        const lightning = ["lightningball", "staticelectricity"];
        const liquid = ["liquidsplash"];
        const magicsign = ["magicSign"];
        const marker = ["marker", "circleofstars", "energystrand"];
        const shieldfx = ["energyfieldtop", "shieldfiretop", "shieldicetop", "shieldearthtop", "shieldeldritchwebtop"];
        const tokenborder = ["staticborder", "spinningborder"];
        const fireball = ["fireballexplode"];
        switch (true) {
          case conditions.some((el) => v4Flags.animation === el):
            options2.menuType = "conditions";
            break;
          case creature.some((el) => v4Flags.animation === el):
            options2.menuType = "creature";
            break;
          case energy.some((el) => v4Flags.animation === el):
            options2.menuType = "energy";
            break;
          case fire.some((el) => v4Flags.animation === el):
            options2.menuType = "fire";
            break;
          case generic.some((el) => v4Flags.animation === el):
            options2.menuType = "generic";
            if (v4Flags.animation?.includes("outpulse")) {
              options2.variant = v4Flags.animation === "outpulse02" ? "02" : "01";
              v4Flags.animation = "outpulse";
            }
            break;
          case ice.some((el) => v4Flags.animation === el):
            options2.menuType = "ice";
            break;
          case lightning.some((el) => v4Flags.animation === el):
            options2.menuType = "lightning";
            break;
          case liquid.some((el) => v4Flags.animation === el):
            options2.menuType = "liquid";
            v4Flags.animation = "splash";
            break;
          case magicsign.some((el) => v4Flags.animation === el):
            options2.menuType = "magicsign";
            break;
          case marker.some((el) => v4Flags.animation === el):
            options2.menuType = "marker";
            if (v4Flags.animation === "circleofstars") ;
            else if (v4Flags.animation === "energystrand") {
              v4Flags.animation = "energystrand";
            } else {
              switch (v4Flags.variant) {
                case "03":
                  v4Flags.animation = "music";
                  v4Flags.variant = "01";
                  break;
                case "bubble":
                  v4Flags.animation = "bubble";
                  v4Flags.variant = "01";
                  break;
                case "energystrand":
                  v4Flags.animation = "energystrands";
                  v4Flags.variant = "01";
                  break;
                default:
                  v4Flags.animation = "standard";
                  v4Flags.variant = "01";
              }
            }
            break;
          case shieldfx.some((el) => v4Flags.animation === el):
            options2.menuType = "shieldfx";
            switch (v4Flags.animation) {
              case "energyfieldtop":
                v4Flags.animation = "energyfield";
                break;
              case "shieldfiretop":
                v4Flags.animation = "fire";
                break;
              case "shieldicetop":
                v4Flags.animation = "ice";
                break;
              case "shieldearthtop":
                v4Flags.animation = "earth";
                break;
              case "shieldeldritchwebtop":
                v4Flags.animation = "eldritchweb";
                break;
            }
            break;
          case tokenborder.some((el) => v4Flags.animation === el):
            options2.menuType = "tokenborder";
            if (v4Flags.animation === "staticborder") {
              v4Flags.animation = "static";
            } else {
              v4Flags.animation = "spinning";
            }
            break;
          case fireball.some((el) => v4Flags.animation === el):
            options2.menuType = "spell";
            v4Flags.animation = "fireball";
            options2.variant = "explode";
            break;
          default:
            options2.menuType = "spell";
        }
        if (v4Flags.explosions?.enable) {
          await convertExplosion(v4Flags.explosions);
        }
        delete options2.staticOptions;
        break;
      case "template":
        options2.menuType = options2.tempType === "rect" ? "square" : options2.tempType;
        switch (options2.menuType) {
          case "cone":
            if (v4Flags.animation === "breathweaponcone") {
              v4Flags.animation = "breathweapon";
            }
            break;
          case "circle":
            const circleTypes = ["dropct", "fearct", "heartct", "horrorct", "poisonct", "runesct", "shieldsct", "crackedshieldct", "skullct", "snowflakesct", "musicnotect"];
            if (circleTypes.some((el) => v4Flags.animation === el)) {
              v4Flags.animation = v4Flags.animation.replace("ct", "");
            }
            switch (v4Flags.animation) {
              case "outpulse01":
                v4Flags.animation = "outpulse";
                options2.variant = "01";
                break;
              case "outpulse02":
                v4Flags.animation = "outpulse";
                options2.variant = "02";
                break;
              case "fireballloop":
                v4Flags.animation = "fireball";
                options2.variant = options2.variant === "nodebris" ? "nodebris" : "loop";
                break;
              case "fireballexplode":
                v4Flags.animation = "fireball";
                options2.variant = "explode";
                break;
            }
            break;
          case "square":
            const squareTypes = ["dropct", "fearct", "heartct", "horrorct", "poisonct", "runesct", "shieldsct", "crackedshieldct", "skullct", "snowflakesct"];
            if (squareTypes.some((el) => v4Flags.animation === el)) {
              v4Flags.animation = v4Flags.animation.replace("ct", "");
            } else if (v4Flags.animation === "musicnotest") {
              v4Flags.animation = "musicnote";
            }
            break;
          case "ray":
            if (v4Flags.animation === "breathweaponline") {
              v4Flags.animation = "breathweapon";
            }
            break;
        }
        break;
      case "aura":
        switch (v4Flags.animation) {
          case "energystrand":
            options2.menuType = "marker";
            break;
          case "dodecahedron":
            options2.menuType = "energy";
            break;
          case "staticelectricity":
            options2.menuType = "lightning";
            break;
          default:
            options2.menuType = "spell";
        }
        break;
      case "preset":
        switch (v4Flags.animation) {
          case "teleportation":
            options2.menuType = "spell";
            options2.menuType02 = "spell";
            break;
          case "dualattach":
            switch (options2.name) {
              case "energystrand":
              case "energybeam":
                options2.menuType = "generic";
                break;
              default:
                options2.menuType = "spell";
            }
            break;
          case "fireball":
            const fire2 = ["eruption"];
            const generic2 = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02"];
            const ice2 = ["snowflake"];
            const liquid2 = ["liquidsplash"];
            const fireball2 = ["fireballexplode"];
            const fireSettings = v4Flags.fireball || {};
            switch (fireSettings.projectile) {
              case "energystrand":
              case "energybeam":
                fireSettings.rangeType = "generic";
                break;
              default:
                fireSettings.rangeType = "spell";
            }
            if (fireSettings.explosion01) {
              switch (true) {
                case fire2.some((el) => fireSettings.explosion01 === el):
                  fireSettings.ex01Type = "fire";
                  break;
                case generic2.some((el) => fireSettings.explosion01 === el):
                  fireSettings.ex01Type = "generic";
                  if (fireSettings.explosion01?.includes("outpulse")) {
                    fireSettings.explosion01 = "outpulse";
                    fireSettings.explosion01Variant = fireSettings.explosion01Variant === "outpulse02" ? "02" : "01";
                  }
                  break;
                case ice2.some((el) => fireSettings.explosion01 === el):
                  fireSettings.ex01Type = "ice";
                  break;
                case liquid2.some((el) => fireSettings.explosion01 === el):
                  fireSettings.ex01Type = "liquid";
                  fireSettings.explosion01 = "splash";
                  break;
                case fireball2.some((el) => fireSettings.explosion01 === el):
                  fireSettings.ex01Type = "spell";
                  fireSettings.explosion01 = "fireball";
                  fireSettings.explosion01Variant = "explode";
                  break;
                default:
                  if (fireSettings.explosion01 === "a1" || !fireSettings.explosion01) {
                    fireSettings.ex01Type === "";
                  } else {
                    fireSettings.ex01Type = "spell";
                  }
              }
            }
            if (fireSettings.explosion02) {
              switch (true) {
                case fire2.some((el) => fireSettings.explosion02 === el):
                  fireSettings.ex02Type = "fire";
                  break;
                case generic2.some((el) => fireSettings.explosion02 === el):
                  fireSettings.ex02Type = "generic";
                  if (fireSettings.explosion02?.includes("outpulse")) {
                    fireSettings.explosion02 = "outpulse";
                    fireSettings.explosion02Variant = fireSettings.explosion02Variant === "outpulse02" ? "02" : "01";
                  }
                  break;
                case ice2.some((el) => fireSettings.explosion02 === el):
                  fireSettings.ex02Type = "ice";
                  break;
                case liquid2.some((el) => fireSettings.explosion02 === el):
                  fireSettings.ex02Type = "liquid";
                  fireSettings.explosion02 = "splash";
                  break;
                case fireball2.some((el) => fireSettings.explosion02 === el):
                  fireSettings.ex02Type = "spell";
                  fireSettings.explosion02 = "fireball";
                  fireSettings.explosion02Variant = "explode";
                  break;
                default:
                  if (fireSettings.explosion02 === "a1" || !fireSettings.explosion02) {
                    fireSettings.ex02Type === "";
                  } else {
                    fireSettings.ex02Type = "spell";
                  }
              }
            }
            break;
        }
        break;
    }
    async function convertExplosion(flags2) {
      if (flags2.enableCustom) {
        return;
      } else {
        const fire = ["eruption"];
        const generic = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02"];
        const ice = ["snowflake"];
        const liquid = ["liquidsplash"];
        const fireball = ["fireballexplode"];
        switch (true) {
          case fire.some((el) => flags2.animation === el):
            flags2.menuType = "fire";
            break;
          case generic.some((el) => flags2.animation === el):
            flags2.menuType = "generic";
            if (flags2.animation?.includes("outpulse")) {
              flags2.animation = "outpulse";
              flags2.variant = flags2.variant === "outpulse02" ? "02" : "01";
            }
            break;
          case ice.some((el) => flags2.animation === el):
            flags2.menuType = "ice";
            break;
          case liquid.some((el) => flags2.animation === el):
            flags2.menuType = "liquid";
            flags2.animation = "splash";
            break;
          case fireball.some((el) => flags2.animation === el):
            flags2.menuType = "spell";
            flags2.animation = "fireball";
            flags2.variant = "explode";
            break;
          default:
            if (flags2.animation === "a1" || !flags2.animation) {
              flags2.menuType === "";
            } else {
              flags2.menuType = "spell";
            }
        }
      }
      return flags2;
    }
  }
  async function convertExtraFX(flags2) {
    const generic = ["explosion", "impact"];
    const ice = ["icespikes", "snowflake"];
    const fireball = ["fireballexplode"];
    switch (true) {
      case flags2.name?.includes("dizzystars"):
        flags2.menuType = "conditions";
        break;
      case flags2.name?.includes("eruption"):
        flags2.menuType = "fire";
        break;
      case generic.some((el) => flags2.name === el):
        flags2.menuType = "generic";
        break;
      case ice.some((el) => flags2.name === el):
        flags2.menuType = "ice";
        break;
      case flags2.name?.includes("liquidsplash"):
        flags2.menuType = "liquid";
        flags2.name = "splash";
        break;
      case flags2.name?.includes("magicSign"):
        flags2.menuType = "magicsign";
        switch (flags2.color) {
          case "blue":
            flags2.name = "abjuration";
            break;
          case "yellow":
            flags2.name = "conjuration";
            break;
          default:
            flags2.name = "divination";
        }
        flags2.variant = "01";
        break;
      case flags2.name?.includes("marker"):
        flags2.menuType = "marker";
        if (flags2.name === "circleofstars") ;
        else if (flags2.name === "energystrand") {
          flags2.name = "energystrand";
        } else {
          switch (flags2.variant) {
            case "03":
              flags2.name = "music";
              flags2.variant = "01";
              break;
            case "bubble":
              flags2.name = "bubble";
              flags2.variant = "01";
              break;
            case "energystrand":
              flags2.name = "energystrands";
              flags2.variant = "01";
              break;
            default:
              flags2.name = "standard";
              flags2.variant = "01";
          }
        }
        break;
      case fireball.some((el) => flags2.name === el):
        flags2.menuType = "spell";
        flags2.name = "fireball";
        flags2.variant = "explode";
        break;
      default:
        flags2.menuType = "spell";
    }
  }
  v4Flags.version = 4;
  return v4Flags;
}
async function version05(flags, isActiveEffect) {
  if (!flags) {
    console.error("Automated Animations | Critical A-A Flag Errors found in version 05 merge. Removing A-A flags from item");
    await item.update({ "flags.-=autoanimations": null });
    return;
  }
  const v4Flags = flags || {};
  if (v4Flags.killAnim && !v4Flags.macro?.enable && !v4Flags.audio?.a01?.enable) {
    const v5Flags = {
      isEnabled: false,
      isCustomized: false,
      fromAmmo: false,
      version: 5
    };
    custom_warning("Item is Disabled, and no Macro or Sound is set to play");
    return v5Flags;
  } else if (!v4Flags.killAnim && !v4Flags.override) {
    custom_warning("Item is enabled but not customized, delete flags");
    return void 0;
  } else if (v4Flags.override && v4Flags.animType !== "preset" && !v4Flags.options?.enableCustom && (!v4Flags.animType || !v4Flags.options?.menuType || !v4Flags.animation || !v4Flags.options?.variant || !v4Flags.color)) {
    custom_warning("Item is customized but has critical errors in the Primary Animation settings. Delete flags");
    return void 0;
  } else if (v4Flags.autoOverride?.enable) {
    custom_warning("Item was set to old Auto-Override, delete flags");
    return void 0;
  } else if (v4Flags.killAnim && (v4Flags.macro?.enable || v4Flags.audio?.a01?.enable)) {
    const v5Flags = {};
    await convertV6(v4Flags, v5Flags, "melee");
    if (v4Flags.macro?.enable) {
      v5Flags.macro.playWhen = "2";
    }
    if (v4Flags.audio?.a01?.enable) {
      v5Flags.soundOnly.sound = v5Flags.primary.sound;
    }
    custom_warning("Item was Disabled and either a Macro or Sound is set to play, reorganizing flags");
    return v5Flags;
  } else {
    const type = v4Flags.animType === "static" ? "ontoken" : v4Flags.animType === "template" ? "templatefx" : v4Flags.animType;
    const v5Flags = {};
    if (isActiveEffect) {
      await routeActiveEffect(v4Flags, v5Flags);
    } else {
      switch (type) {
        case "preset":
          await routePreset(v4Flags, v5Flags);
          break;
        default:
          await convertV6(v4Flags, v5Flags, type);
          break;
      }
    }
    v5Flags.version = 5;
    custom_warning(`Automated Animations | Version 5 Flag Migration Complete`, false, v5Flags);
    return v5Flags;
  }
  async function convertV6(oldMO, newMO, type) {
    let {
      animLevel,
      animType,
      animation,
      audio,
      autoOverride,
      color,
      explosions,
      killAnim,
      levels3d: levels3d2,
      macro: macro2,
      meleeSwitch: meleeSwitch2,
      options: options2,
      override,
      preview,
      sourceToken,
      targetToken
    } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.isEnabled = true;
    newMO.isCustomized = true;
    newMO.fromAmmo = options2?.ammo ?? false;
    if (type !== "aura" && type !== "templatefx") {
      newMO.levels3d = await new3d(oldMO);
    }
    newMO.macro = macro2 || {};
    if (type === "melee") {
      newMO.meleeSwitch = compileMeleeSwitch(oldMO);
    }
    newMO.menu = type;
    newMO.primary = {
      options: convertOptionsV6(oldMO, type),
      sound: setSound(audio, "a01"),
      video: {
        dbSection: setDBSection(type),
        menuType: options2?.menuType,
        animation,
        variant: options2?.variant,
        color,
        enableCustom: options2?.enableCustom ?? false,
        customPath: options2?.customPath ?? ""
      }
    };
    newMO.secondary = await convertExplosionV6(explosions, audio, oldMO);
    const primaryVideo = newMO.primary.video;
    if (!primaryVideo.menuType || !primaryVideo.animation || !primaryVideo.variant || !primaryVideo.color) {
      resetVideo(newMO.primary.video, type);
    }
    newMO.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    newMO.source = convertSourceFX(sourceToken, audio);
    newMO.target = convertTargetFX(targetToken, audio);
    return newMO;
  }
  function setSound(audio = {}, section2 = "a01", rebase = false) {
    if (rebase) {
      return {
        delay: 0,
        enable: false,
        file: "",
        startTime: 0,
        repeat: 1,
        repeatDelay: 250,
        volume: 1
      };
    } else {
      return {
        delay: audio?.[section2]?.delay ?? 0,
        enable: audio?.[section2]?.enable ?? false,
        file: audio?.[section2]?.file ?? "",
        startTime: audio?.[section2]?.startTime ?? 0,
        volume: audio?.[section2]?.volume ?? 1,
        repeat: 1,
        repeatDelay: 250
      };
    }
  }
  function setDBSection(type) {
    return type === "aura" || type === "ontoken" ? "static" : type;
  }
  function convertSourceFX(extraFX, audio, section2) {
    const oldData = extraFX || {};
    const data2 = {
      enable: oldData.enable ?? false,
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        delay: oldData.delayAfter ?? 0,
        elevation: oldData.animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isWait: true,
        isMasked: false,
        isRadius: false,
        opacity: oldData.opacity ?? 1,
        repeat: oldData.loops ?? 1,
        repeatDelay: oldData.loopDelay ?? 250,
        size: oldData.scale ?? 1,
        zIndex: 1
      },
      sound: setSound(audio, "s01"),
      video: {
        dbSection: "static",
        menuType: oldData.menuType,
        animation: oldData.name,
        variant: oldData.variant,
        color: oldData.color,
        enableCustom: oldData.enableCustom ?? false,
        customPath: oldData.customPath ?? ""
      }
    };
    let video2 = data2.video;
    if (!video2.menuType || !video2.animation || !video2.variant || !video2.color) {
      resetVideo(data2.video, "static");
    }
    return data2;
  }
  function convertTargetFX(extraFX, audio, section2) {
    const oldData = extraFX || {};
    const data2 = {
      enable: oldData.enable ?? false,
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        delay: oldData.delayStart ?? 0,
        elevation: oldData.animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        opacity: oldData.opacity ?? 1,
        persistent: oldData.persistent ?? false,
        repeat: oldData.loops ?? 1,
        repeatDelay: oldData.loopDelay ?? 250,
        size: oldData.scale ?? 1,
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      },
      sound: setSound(audio, "t01"),
      video: {
        dbSection: "static",
        menuType: oldData.menuType,
        animation: oldData.name,
        variant: oldData.variant,
        color: oldData.color,
        enableCustom: oldData.enableCustom ?? false,
        customPath: oldData.customPath ?? ""
      }
    };
    let video2 = data2.video;
    if (!video2.menuType || !video2.animation || !video2.variant || !video2.color) {
      resetVideo(data2.video, "static");
    }
    return data2;
  }
  function compileMeleeSwitch(oldMO) {
    let oldData = oldMO.meleeSwitch || {};
    let audio = oldMO.audio || {};
    const data2 = {
      video: {
        dbSection: "range",
        menuType: oldData.menuType,
        animation: oldData.animation,
        variant: oldData.variant,
        color: oldData.color,
        enableCustom: false,
        customPath: ""
      },
      sound: setSound(audio, "a02"),
      options: {
        detect: oldData.detect || "automatic",
        range: oldData.range || 2,
        isReturning: oldData.returning ?? false,
        switchType: oldData.switchType || "on"
      }
    };
    const switchVideo = data2.video;
    if (!switchVideo.menuType || !switchVideo.animation || !switchVideo.variant || !switchVideo.color) {
      resetVideo(data2.video, "range");
    }
    return data2;
  }
  function convertOptionsV6(oldMO, type) {
    const data2 = {};
    const options2 = oldMO.options || {};
    switch (type) {
      case "melee":
        data2.delay = 0;
        data2.elevation = oldMO.animLevel ? 0 : 1e3;
        data2.isWait = false;
        data2.opacity = 1;
        data2.repeat = options2.repeat ?? 1;
        data2.repeatDelay = options2.delay ?? 0;
        data2.size = options2.scale ?? 1;
        data2.zIndex = 1;
        break;
      case "range":
        data2.delay = 0;
        data2.elevation = oldMO.below ? 0 : 1e3;
        data2.isReturning = false;
        data2.isWait = false;
        data2.onlyX = options2.onlyX ?? false;
        data2.opacity = options2.opacity ?? 1;
        data2.repeat = options2.repeat ?? 1;
        data2.repeatDelay = options2.delay ?? 0;
        data2.zIndex = options2.zIndex ?? 1;
        break;
      case "ontoken":
        data2.addTokenWidth = false;
        data2.anchor = "0.5";
        data2.delay = 0;
        data2.elevation = oldMO.below ? 0 : 1e3;
        data2.fadeIn = 250;
        data2.fadeOut = 500;
        data2.isMasked = false;
        data2.isRadius = false;
        data2.isWait = false;
        data2.opacity = options2.opacity ?? 1;
        data2.persistent = options2.persistent ?? false;
        data2.playOn = options2.staticType === "targetDefault" ? "default" : options2.staticType === "sourceTarget" ? "both" : !options2.staticType ? "default" : options2.staticType;
        data2.repeat = options2.repeat ?? 1;
        data2.repeatDelay = options2.delay ?? 0;
        data2.size = options2.scale ?? 1;
        data2.unbindAlpha = options2.unbindAlpha ?? false;
        data2.unbindVisibility = options2.unbindVisibility ?? false;
        data2.zIndex = options2.zIndex ?? 1;
        break;
      case "templatefx":
        data2.delay = 0;
        data2.elevation = oldMO.below ? 0 : 1e3;
        data2.isMasked = false;
        data2.isWait = false;
        data2.occlusionAlpha = options2.occlusionAlpha ?? 0;
        data2.occlusionMode = options2.occlusionMode ?? 0;
        data2.opacity = options2.opacity ?? 1;
        data2.persistent = options2.persistent ?? false;
        data2.persistType = options2.persistType || "sequencerground";
        data2.removeTemplate = options2.removeTemplate ?? 1;
        data2.repeat = options2.repeat ?? 1;
        data2.repeatDelay = options2.delay ?? 0;
        data2.rotate = 0;
        data2.scale = `${options2.scaleX ?? 1}, ${options2.scaleY ?? 1}`;
        data2.zIndex = options2.zIndex ?? 1;
        break;
      case "aura":
        data2.addTokenWidth = options2.addTokenWidth ?? false;
        data2.alpha = false, data2.alphaMax = 0.5, data2.alphaMin = -0.5, data2.alphaDuration = 1e3, data2.breath = false, data2.breathMax = 1.05, data2.breathMin = 0.95, data2.breathDuration = 1e3, data2.delay = 0;
        data2.elevation = options2.below ? 0 : 1e3;
        data2.fadeIn = 250;
        data2.fadeOut = 500;
        data2.playOn = options2.ignoreTarget ? "source" : "default";
        data2.isRadius = true;
        data2.isWait = false;
        data2.opacity = options2.opacity ?? 1;
        data2.size = options2.auraRadius ?? 3;
        data2.tint = false, data2.tintColor = "#FFFFFF", data2.tintSaturate = 0, data2.unbindAlpha = options2.unbindAlpha ?? false;
        data2.unbindVisibility = options2.unbindVisibility ?? false;
        data2.zIndex = options2.zIndex ?? 1;
        break;
    }
    return data2;
  }
  async function new3d(oldData) {
    let newData = oldData.levels3d || {};
    let { type, addExplosion, ...rest } = newData;
    const data3d = {
      enable: type ? true : false,
      type: type || "",
      data: rest || {},
      secondary: {
        enable: addExplosion?.enable ?? false,
        data: addExplosion || {}
      },
      sound: setSound({}, "a01", true)
    };
    return data3d;
  }
  function resetVideo(data2, type) {
    switch (type) {
      case "melee":
        data2.menuType = "weapon";
        data2.animation = "dagger";
        data2.variant = "01";
        data2.color = "white";
        break;
      case "range":
        data2.menuType = "weapon";
        data2.animation = "arrow";
        data2.variant = "regular";
        data2.color = "regular";
        break;
      case "templatefx":
        data2.menuType = "circle";
        data2.animation = "calllightning";
        data2.variant = "01";
        data2.color = "blue";
        break;
      default:
        data2.menuType = "spell";
        data2.animation = "curewounds";
        data2.variant = "01";
        data2.color = "blue";
    }
  }
  async function convertExplosionV6(exp, audio, oldMO) {
    let data2 = {
      enable: exp?.enable ?? false,
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        delay: exp?.delay ?? 250,
        elevation: exp?.below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: exp?.isMasked ?? false,
        isRadius: true,
        isWait: false,
        opacity: 1,
        repeat: oldMO.options?.repeat ?? 1,
        repeatDelay: oldMO.delay ?? 0,
        size: exp?.radius ?? 1.5,
        zIndex: 1
      },
      sound: setSound(audio, "e01"),
      video: {
        dbSection: "static",
        menuType: exp?.menuType,
        animation: exp?.animation,
        variant: exp?.variant,
        color: exp?.color,
        enableCustom: exp?.enableCustom ?? false,
        customPath: exp?.customPath ?? ""
      }
    };
    const video2 = data2.video;
    if (!video2.menuType || !video2.animation || !video2.variant || !video2.color) {
      data2.video.menuType = "spell";
      data2.video.animation = "curewounds";
      data2.video.variant = "01";
      data2.video.color = "blue";
    }
    return data2;
  }
  async function routePreset(oldMO, newMO) {
    let current;
    switch (oldMO.animation) {
      case "teleportation":
        current = await updateTele(oldMO, newMO);
        return current;
      case "dualattach":
        current = await updateDAttach(oldMO, newMO);
        return current;
      case "fireball":
        current = await updateFireball(oldMO, newMO);
        return current;
      case "thunderwave":
        current = await updateThunderwave(oldMO, newMO);
        return current;
      default:
        return "deleteFlags";
    }
  }
  async function updateDAttach(oldData, newData) {
    let { animLevel, animType, animation, audio, color, killAnim, macro: macro2, options: options2, override, sourceToken, targetToken } = oldData;
    newData.id = Hashing.uuidv4();
    newData.isEnabled = true;
    newData.isCustomized = true;
    newData.fromAmmo = options2?.ammo ?? false;
    newData.menu = "preset";
    newData.presetType = "dualattach";
    newData.macro = macro2 || {};
    newData.data = {
      video: {
        dbSection: "range",
        menuType: options2?.menuType,
        animation: options2?.name,
        variant: options2?.variant,
        color,
        enableCustom: options2?.enableCustom ?? false,
        customPath: options2?.customPath ?? ""
      },
      options: {
        playbackRate: options2?.playbackRate,
        onlyX: options2?.onlyX ?? false,
        elevation: animLevel ? 0 : 1e3,
        opacity: 1
      },
      sound: setSound(audio, "a01")
    };
    if (!newData.data.video.menuType || !newData.data.video.animation || !newData.data.video.variant || !newData.data.video.color) {
      resetVideo(newData.data.video, "range");
    }
    newData.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    return newData;
  }
  async function updateFireball(oldData, newData) {
    newData.data = {};
    const root = newData.data;
    let { animLevel, animType, animation, audio, killAnim, macro: macro2, options: options2, override, sourceToken, targetToken } = oldData;
    let fireballData = oldData.fireball || {};
    let {
      afterEffect,
      afterEffectPath,
      ex01Type,
      ex02Type,
      explosion01,
      explosion01Color,
      explosion01Delay,
      explosion01Repeat,
      explosion01Scale,
      explosion01Variant,
      explosion02,
      explosion02Color,
      explosion02Delay,
      explosion02Repeat,
      explosion02Scale,
      explosion02Variant,
      projectile,
      projectileColor,
      projectileDelay,
      projectileRepeat,
      projectileVariant,
      rangeType,
      wait01,
      wait02,
      wait03
    } = fireballData;
    newData.id = Hashing.uuidv4();
    newData.isEnabled = true;
    newData.isCustomized = true;
    newData.fromAmmo = options2?.ammo ?? false;
    newData.menu = "preset";
    newData.presetType = "proToTemp";
    newData.macro = macro2 || {};
    root.projectile = {
      dbSection: "range",
      menuType: rangeType,
      animation: projectile,
      variant: projectileVariant,
      color: projectileColor,
      options: {
        repeat: projectileRepeat ?? 1,
        repeatDelay: projectileDelay ?? 250,
        wait: wait01,
        elevation: animLevel ? 0 : 1e3,
        removeTemplate: oldData?.options?.removeTemplate ?? false
      },
      sound: setSound(audio, "a01")
    };
    if (!root.projectile.menuType || !root.projectile.animation || !root.projectile.variant || !root.projectile.color) {
      resetVideo(root.projectile, "range");
    }
    root.preExplosion = {
      dbSection: "static",
      menuType: ex01Type,
      animation: explosion01,
      variant: explosion01Variant,
      color: explosion01Color,
      options: {
        repeat: explosion01Repeat,
        repeatDelay: explosion01Delay,
        scale: explosion01Scale,
        wait: wait02,
        elevation: animLevel ? 0 : 1e3
      },
      sound: setSound(audio, "e01")
    };
    if (!root.preExplosion.menuType || !root.preExplosion.animation || !root.preExplosion.variant || !root.preExplosion.color) {
      root.preExplosion.enable = false;
      resetVideo(root.preExplosion, "static");
    } else {
      root.preExplosion.enable = true;
    }
    root.explosion = {
      dbSection: "static",
      menuType: ex02Type,
      animation: explosion02,
      variant: explosion02Variant,
      color: explosion02Color,
      options: {
        elevation: animLevel ? 0 : 1e3,
        repeat: explosion02Repeat,
        repeatDelay: explosion02Delay,
        scale: explosion02Scale,
        wait: -500
      },
      sound: setSound(audio, "e02")
    };
    if (!root.explosion.menuType || !root.explosion.animation || !root.explosion.variant || !root.explosion.color) {
      resetVideo(root.explosion, "static");
    }
    root.afterImage = {
      enable: afterEffect,
      customPath: afterEffectPath,
      options: {
        elevation: 0,
        persistent: false,
        scale: 1
      }
    };
    newData.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    newData.secondary = {
      enable: false,
      options: {
        addTokenWidth: false,
        delay: 250,
        elevation: 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: true,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 0,
        size: 1.5,
        zIndex: 1
      },
      sound: setSound(audio, "e01"),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newData.target = newExtraFX();
    return newData;
  }
  async function updateTele(oldData, newData) {
    newData.data = {};
    const root = newData.data;
    let { animLevel, animType, animation, audio, color, color02, killAnim, macro: macro2, options: options2, override } = oldData;
    newData.id = Hashing.uuidv4();
    newData.isEnabled = true;
    newData.isCustomized = true;
    newData.fromAmmo = options2?.ammo ?? false;
    newData.menu = "preset";
    newData.presetType = "teleportation";
    newData.macro = macro2 || {};
    root.options = {
      alpha: 0,
      delayFade: 750,
      delayMove: 1e3,
      delayReturn: options2?.delay ?? 250,
      hideFromPlayers: options2?.hideFromPlayers ?? false,
      measureType: options2?.measureType ?? "alternating",
      range: options2?.teleDist ?? 30,
      speed: 120,
      teleport: true
    };
    root.sound = setSound(audio, "a01");
    root.start = {
      dbSection: "static",
      enable: true,
      menuType: options2?.menuType,
      animation: options2?.name,
      variant: options2?.variant,
      color,
      enableCustom: options2.enableCustom ?? false,
      customPath: options2.customPath ?? "",
      options: {
        delay: 0,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 250,
        isMasked: false,
        opacity: 1,
        isRadius: false,
        size: options2?.scale || 1.5
      }
    };
    root.between = {
      dbSection: "range",
      enable: false,
      menuType: "weapon",
      animation: "arrow",
      variant: "regular",
      color: "regular",
      options: {
        delay: 0,
        enable: false,
        elevation: 1e3,
        opacity: 1,
        playbackRate: 1
      }
    };
    root.end = {
      dbSection: "static",
      enable: true,
      menuType: options2?.menuType02,
      animation: options2?.name02,
      variant: options2?.variant02,
      color: color02,
      enableCustom: options2?.enableCustom02 ?? false,
      customPath: options2?.customPath02 ?? "",
      options: {
        delay: 500,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 250,
        isMasked: false,
        isRadius: false,
        opacity: 1,
        size: options2?.scale02 ?? 1
      }
    };
    if (!root.start.menuType || !root.start.animation || !root.start.variant || !root.start.color) {
      resetVideo(root.start, "static");
    }
    if (!root.end.menuType || !root.end.animation || !root.end.variant || !root.end.color) {
      resetVideo(root.end, "static");
    }
    newData.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    return newData;
  }
  async function updateThunderwave(oldData, newData) {
    let { animLevel, animType, animation, audio, color, killAnim, macro: macro2, options: options2, override } = oldData;
    newData.id = Hashing.uuidv4();
    newData.isEnabled = true;
    newData.isCustomized = true;
    newData.fromAmmo = options2?.ammo ?? false;
    newData.menu = "preset";
    newData.presetType = "thunderwave";
    newData.macro = macro2 || {};
    newData.data = {
      video: {
        dbSection: "templatefx",
        menuType: "square",
        animation: "thunderwave",
        variant: "mid",
        color: color || "blue"
      },
      options: {
        elevation: animLevel ? 0 : 1e3,
        repeat: options2?.repeat ?? 1,
        repeatDelay: options2?.delay ?? 250,
        opacity: options2?.opacity ?? 1,
        removeTemplate: options2?.removeTemplate ?? false
      },
      sound: setSound(audio, "a01")
    };
    newData.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    return newData;
  }
  async function routeActiveEffect(oldMO, newMO) {
    let current;
    switch (oldMO.animType) {
      case "static":
        current = await convertAEOnToken(oldMO, newMO);
        return current;
      case "aura":
        current = await convertAEAura(oldMO, newMO);
        return current;
      case "preset":
        switch (oldMO.animation) {
          case "bless":
            current = await convertAEBless(oldMO, newMO);
            return current;
          case "shieldspell":
            current = await convertAEShield(oldMO, newMO);
            return current;
        }
    }
  }
  function newExtraFX() {
    const data2 = {
      enable: false,
      options: {
        addTokenWidth: false,
        delay: 0,
        elevation: 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: true,
        opacity: 1,
        repeat: 1,
        repeatDelay: 250,
        size: 1,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    return data2;
  }
  async function convertAEOnToken(oldMO, newMO) {
    let { animLevel, animation, audio, color, explosions, macro: macro2, options: options2 } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.isEnabled = true;
    newMO.isCustomized = true;
    newMO.activeEffectType = "ontoken";
    newMO.primary = {
      options: {
        addTokenWidth: false,
        elevation: animLevel ? 0 : 1e3,
        delay: 0,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: options2?.opacity ?? 1,
        persistent: options2?.persistent ?? false,
        playOn: "source",
        repeat: options2?.repeat ?? 1,
        repeatDelay: options2?.delay || 250,
        size: options2?.scale || 1,
        unbindAlpha: options2?.unbindAlpha ?? false,
        unbindVisibility: options2?.unbindVisibility ?? false,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        animation,
        color,
        customPath: options2?.customPath ?? "",
        dbSection: "static",
        enableCustom: options2?.enableCustom ?? false,
        menuType: options2?.menuType,
        variant: options2?.variant
      }
    };
    const newVideo = newMO.primary.video;
    if (!newVideo.menuType || !newVideo.animation || !newVideo.variant || !newVideo.color) {
      resetVideo(newMO.primary.video);
    }
    newMO.macro = macro2 || {};
    newMO.menu = "aefx";
    newMO.secondary = await convertExplosionV6(explosions, audio, oldMO);
    newMO.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    newMO.source = newExtraFX();
    return newMO;
  }
  async function convertAEAura(oldMO, newMO) {
    let { animLevel, animType, animation, audio, color, macro: macro2, options: options2 } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.isEnabled = true;
    newMO.isCustomized = true;
    newMO.activeEffectType = "ontoken";
    newMO.menu = "aefx";
    newMO.secondary = {
      enable: false,
      options: {},
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue"
      }
    };
    newMO.primary = {
      options: {
        addTokenWidth: false,
        alpha: false,
        alphaMax: 0.5,
        alphaMin: -0.5,
        alphaDuration: 1e3,
        breath: false,
        breathMax: 1.05,
        breathMin: 0.95,
        breathDuration: 1e3,
        delay: 0,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isRadius: true,
        isWait: true,
        opacity: options2?.opacity || 1,
        playOn: "source",
        size: options2?.auraRadius || 3,
        tint: false,
        tintColor: "#FFFFFF",
        tintSaturate: 0,
        unbindAlpha: options2?.unbindAlpha ?? false,
        unbindVisibility: options2?.unbindVisibility ?? false,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        animation,
        color,
        customPath: options2?.customPath || "",
        dbSection: "static",
        enableCustom: options2?.enableCustom ?? false,
        menuType: options2?.menuType,
        variant: options2?.variant
      }
    };
    const newVideo = newMO.primary.video;
    if (!newVideo.menuType || !newVideo.animation || !newVideo.variant || !newVideo.color) {
      resetVideo(newMO.primary.video);
    }
    newMO.macro = macro2 || {};
    newMO.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    newMO.source = newExtraFX();
    return newMO;
  }
  async function convertAEBless(oldMO, newMO) {
    let { animLevel, animType, animation, audio, color, macro: macro2, options: options2 } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.isEnabled = true;
    newMO.isCustomized = true;
    newMO.activeEffectType = "ontoken";
    newMO.menu = "aefx";
    newMO.macro = macro2 || {};
    newMO.primary = {
      options: {
        addTokenWidth: false,
        delay: 0,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 0,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: true,
        opacity: 1,
        persistent: options2?.persistent ?? false,
        playOn: "source",
        repeat: 1,
        repeatDelay: 250,
        size: options2?.scale || 1,
        unbindAlpha: options2?.unbindAlpha ?? false,
        unbindVisibility: options2?.unbindVisibility ?? false,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "bless",
        variant: "loop",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.secondary = {
      enable: false,
      options: {},
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    newMO.source = {
      enable: true,
      options: {
        addTokenWidth: false,
        delay: -500,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: true,
        opacity: 1,
        repeat: 1,
        repeatDelay: 250,
        size: options2?.scale || 1,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "bless",
        variant: "intro",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    return newMO;
  }
  async function convertAEShield(oldMO, newMO) {
    let { animLevel, animType, animation, audio, color, macro: macro2, options: options2 } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.isEnabled = true;
    newMO.isCustomized = true;
    newMO.activeEffectType = "ontoken";
    newMO.menu = "aefx";
    newMO.primary = {
      options: {
        isWait: true,
        delay: -1e3,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 0,
        isMasked: false,
        isRadius: false,
        opacity: 1,
        persistent: options2?.persistent || false,
        repeat: 1,
        repeatDelay: 250,
        size: options2?.scale ?? 1,
        playOn: "source",
        unbindAlpha: options2?.unbindAlpha ?? false,
        unbindVisibility: options2?.unbindVisibility ?? false,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "shieldspell",
        animation: "loop",
        variant: options2?.variant || "01",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.source = {
      enable: true,
      options: {
        delay: -500,
        elevation: animLevel ? 0 : 1e3,
        fadeIn: 500,
        fadeOut: 0,
        isRadius: false,
        isWait: true,
        mask: false,
        repeat: 1,
        repeatDelay: 250,
        size: options2?.scale || 1
      },
      sound: setSound(audio, "a01"),
      video: {
        dbSection: "static",
        menuType: "shieldspell",
        animation: "intro",
        variant: options2?.variant || "01",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.secondary = {
      enable: true,
      options: {
        delay: 0,
        elevation: animLevel ? 0 : 1e3,
        isMasked: false,
        isRadius: false,
        isWait: false,
        repeat: 1,
        repeatDelay: 250,
        size: options2?.scale || 1,
        opacity: 1,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "shieldspell",
        animation: options2?.shieldVar || "outro_explode",
        variant: options2?.variant || "01",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.macro = macro2 || {};
    newMO.soundOnly = {
      sound: setSound({}, "a01", true)
    };
    return newMO;
  }
}
const flagMigrations = {
  async handle(item2, options2 = {}) {
    let flags = item2.flags?.autoanimations;
    if (!flags) return;
    if (this.upToDate(flags)) return flags;
    if (flags.version && isNaN(flags.version)) {
      console.error("Your A-A Item data may be corrupted. Please log this in the Automated Animations GitHub issues");
      return flags;
    }
    let newFlagData = item2.flags.autoanimations;
    for (let [version, migration] of Object.entries(this.migrations)) {
      let flagVersion = item2.flags.autoanimations.version;
      if (flagVersion >= Number(version)) continue;
      newFlagData = await migration(newFlagData, options2.isActiveEffect);
    }
    if (!newFlagData) {
      await item2.update({ "flags.-=autoanimations": null });
      return void 0;
    } else {
      await item2.update({ "flags.-=autoanimations": null });
      await item2.update({ "flags.autoanimations": newFlagData });
      return newFlagData;
    }
  },
  upToDate(flags) {
    const currentFlagVersion = Object.keys(this.migrations).map((n) => Number(n)).reverse()[0];
    return flags.version >= currentFlagVersion;
  },
  migrations: {
    "1": async (item2) => {
      return await version01(item2);
    },
    "2": async (item2) => {
      return await version02(item2);
    },
    "3": async (item2) => {
      return await version03(item2);
    },
    "4": async (item2) => {
      return await version04(item2);
    },
    "5": async (item2, isActiveEffect) => {
      return await version05(item2, isActiveEffect);
    }
  }
};
function noop() {
}
const identity = (x) => x;
function assign(tar, src) {
  for (const k in src) tar[k] = src[k];
  return (
    /** @type {T & S} */
    tar
  );
}
function run(fn) {
  return fn();
}
function blank_object() {
  return /* @__PURE__ */ Object.create(null);
}
function run_all(fns) {
  fns.forEach(run);
}
function is_function(thing) {
  return typeof thing === "function";
}
function safe_not_equal(a, b) {
  return a != a ? b == b : a !== b || a && typeof a === "object" || typeof a === "function";
}
let src_url_equal_anchor;
function src_url_equal(element_src, url) {
  if (element_src === url) return true;
  if (!src_url_equal_anchor) {
    src_url_equal_anchor = document.createElement("a");
  }
  src_url_equal_anchor.href = url;
  return element_src === src_url_equal_anchor.href;
}
function is_empty(obj2) {
  return Object.keys(obj2).length === 0;
}
function subscribe(store, ...callbacks) {
  if (store == null) {
    for (const callback of callbacks) {
      callback(void 0);
    }
    return noop;
  }
  const unsub = store.subscribe(...callbacks);
  return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;
}
function get_store_value(store) {
  let value;
  subscribe(store, (_) => value = _)();
  return value;
}
function component_subscribe(component, store, callback) {
  component.$$.on_destroy.push(subscribe(store, callback));
}
function create_slot(definition, ctx, $$scope, fn) {
  if (definition) {
    const slot_ctx = get_slot_context(definition, ctx, $$scope, fn);
    return definition[0](slot_ctx);
  }
}
function get_slot_context(definition, ctx, $$scope, fn) {
  return definition[1] && fn ? assign($$scope.ctx.slice(), definition[1](fn(ctx))) : $$scope.ctx;
}
function get_slot_changes(definition, $$scope, dirty, fn) {
  if (definition[2] && fn) {
    const lets = definition[2](fn(dirty));
    if ($$scope.dirty === void 0) {
      return lets;
    }
    if (typeof lets === "object") {
      const merged = [];
      const len = Math.max($$scope.dirty.length, lets.length);
      for (let i = 0; i < len; i += 1) {
        merged[i] = $$scope.dirty[i] | lets[i];
      }
      return merged;
    }
    return $$scope.dirty | lets;
  }
  return $$scope.dirty;
}
function update_slot_base(slot, slot_definition, ctx, $$scope, slot_changes, get_slot_context_fn) {
  if (slot_changes) {
    const slot_context = get_slot_context(slot_definition, ctx, $$scope, get_slot_context_fn);
    slot.p(slot_context, slot_changes);
  }
}
function get_all_dirty_from_scope($$scope) {
  if ($$scope.ctx.length > 32) {
    const dirty = [];
    const length = $$scope.ctx.length / 32;
    for (let i = 0; i < length; i++) {
      dirty[i] = -1;
    }
    return dirty;
  }
  return -1;
}
function exclude_internal_props(props) {
  const result = {};
  for (const k in props) if (k[0] !== "$") result[k] = props[k];
  return result;
}
function compute_slots(slots) {
  const result = {};
  for (const key in slots) {
    result[key] = true;
  }
  return result;
}
function null_to_empty(value) {
  return value == null ? "" : value;
}
function set_store_value(store, ret, value) {
  store.set(value);
  return ret;
}
function action_destroyer(action_result) {
  return action_result && is_function(action_result.destroy) ? action_result.destroy : noop;
}
const is_client = typeof window !== "undefined";
let now = is_client ? () => window.performance.now() : () => Date.now();
let raf = is_client ? (cb) => requestAnimationFrame(cb) : noop;
const tasks = /* @__PURE__ */ new Set();
function run_tasks(now2) {
  tasks.forEach((task) => {
    if (!task.c(now2)) {
      tasks.delete(task);
      task.f();
    }
  });
  if (tasks.size !== 0) raf(run_tasks);
}
function loop(callback) {
  let task;
  if (tasks.size === 0) raf(run_tasks);
  return {
    promise: new Promise((fulfill) => {
      tasks.add(task = { c: callback, f: fulfill });
    }),
    abort() {
      tasks.delete(task);
    }
  };
}
function append(target2, node) {
  target2.appendChild(node);
}
function get_root_for_style(node) {
  if (!node) return document;
  const root = node.getRootNode ? node.getRootNode() : node.ownerDocument;
  if (root && /** @type {ShadowRoot} */
  root.host) {
    return (
      /** @type {ShadowRoot} */
      root
    );
  }
  return node.ownerDocument;
}
function append_empty_stylesheet(node) {
  const style_element = element("style");
  style_element.textContent = "/* empty */";
  append_stylesheet(get_root_for_style(node), style_element);
  return style_element.sheet;
}
function append_stylesheet(node, style) {
  append(
    /** @type {Document} */
    node.head || node,
    style
  );
  return style.sheet;
}
function insert(target2, node, anchor) {
  target2.insertBefore(node, anchor || null);
}
function detach(node) {
  if (node.parentNode) {
    node.parentNode.removeChild(node);
  }
}
function destroy_each(iterations, detaching) {
  for (let i = 0; i < iterations.length; i += 1) {
    if (iterations[i]) iterations[i].d(detaching);
  }
}
function element(name) {
  return document.createElement(name);
}
function svg_element(name) {
  return document.createElementNS("http://www.w3.org/2000/svg", name);
}
function text(data2) {
  return document.createTextNode(data2);
}
function space() {
  return text(" ");
}
function empty() {
  return text("");
}
function listen(node, event, handler, options2) {
  node.addEventListener(event, handler, options2);
  return () => node.removeEventListener(event, handler, options2);
}
function prevent_default(fn) {
  return function(event) {
    event.preventDefault();
    return fn.call(this, event);
  };
}
function stop_propagation(fn) {
  return function(event) {
    event.stopPropagation();
    return fn.call(this, event);
  };
}
function attr(node, attribute, value) {
  if (value == null) node.removeAttribute(attribute);
  else if (node.getAttribute(attribute) !== value) node.setAttribute(attribute, value);
}
const always_set_through_set_attribute = ["width", "height"];
function set_attributes(node, attributes) {
  const descriptors = Object.getOwnPropertyDescriptors(node.__proto__);
  for (const key in attributes) {
    if (attributes[key] == null) {
      node.removeAttribute(key);
    } else if (key === "style") {
      node.style.cssText = attributes[key];
    } else if (key === "__value") {
      node.value = node[key] = attributes[key];
    } else if (descriptors[key] && descriptors[key].set && always_set_through_set_attribute.indexOf(key) === -1) {
      node[key] = attributes[key];
    } else {
      attr(node, key, attributes[key]);
    }
  }
}
function to_number(value) {
  return value === "" ? null : +value;
}
function children(element2) {
  return Array.from(element2.childNodes);
}
function set_data(text2, data2) {
  data2 = "" + data2;
  if (text2.data === data2) return;
  text2.data = /** @type {string} */
  data2;
}
function set_input_value(input, value) {
  input.value = value == null ? "" : value;
}
function set_style(node, key, value, important) {
  if (value == null) {
    node.style.removeProperty(key);
  } else {
    node.style.setProperty(key, value, "");
  }
}
function select_option(select, value, mounting) {
  for (let i = 0; i < select.options.length; i += 1) {
    const option = select.options[i];
    if (option.__value === value) {
      option.selected = true;
      return;
    }
  }
  if (!mounting || value !== void 0) {
    select.selectedIndex = -1;
  }
}
function select_value(select) {
  const selected_option = select.querySelector(":checked");
  return selected_option && selected_option.__value;
}
function toggle_class(element2, name, toggle) {
  element2.classList.toggle(name, !!toggle);
}
function custom_event(type, detail, { bubbles = false, cancelable = false } = {}) {
  return new CustomEvent(type, { detail, bubbles, cancelable });
}
class HtmlTag {
  /**
   * @private
   * @default false
   */
  is_svg = false;
  /** parent for creating node */
  e = void 0;
  /** html tag nodes */
  n = void 0;
  /** target */
  t = void 0;
  /** anchor */
  a = void 0;
  constructor(is_svg = false) {
    this.is_svg = is_svg;
    this.e = this.n = null;
  }
  /**
   * @param {string} html
   * @returns {void}
   */
  c(html) {
    this.h(html);
  }
  /**
   * @param {string} html
   * @param {HTMLElement | SVGElement} target
   * @param {HTMLElement | SVGElement} anchor
   * @returns {void}
   */
  m(html, target2, anchor = null) {
    if (!this.e) {
      if (this.is_svg)
        this.e = svg_element(
          /** @type {keyof SVGElementTagNameMap} */
          target2.nodeName
        );
      else
        this.e = element(
          /** @type {keyof HTMLElementTagNameMap} */
          target2.nodeType === 11 ? "TEMPLATE" : target2.nodeName
        );
      this.t = target2.tagName !== "TEMPLATE" ? target2 : (
        /** @type {HTMLTemplateElement} */
        target2.content
      );
      this.c(html);
    }
    this.i(anchor);
  }
  /**
   * @param {string} html
   * @returns {void}
   */
  h(html) {
    this.e.innerHTML = html;
    this.n = Array.from(
      this.e.nodeName === "TEMPLATE" ? this.e.content.childNodes : this.e.childNodes
    );
  }
  /**
   * @returns {void} */
  i(anchor) {
    for (let i = 0; i < this.n.length; i += 1) {
      insert(this.t, this.n[i], anchor);
    }
  }
  /**
   * @param {string} html
   * @returns {void}
   */
  p(html) {
    this.d();
    this.h(html);
    this.i(this.a);
  }
  /**
   * @returns {void} */
  d() {
    this.n.forEach(detach);
  }
}
function construct_svelte_component(component, props) {
  return new component(props);
}
const managed_styles = /* @__PURE__ */ new Map();
let active = 0;
function hash(str) {
  let hash2 = 5381;
  let i = str.length;
  while (i--) hash2 = (hash2 << 5) - hash2 ^ str.charCodeAt(i);
  return hash2 >>> 0;
}
function create_style_information(doc, node) {
  const info = { stylesheet: append_empty_stylesheet(node), rules: {} };
  managed_styles.set(doc, info);
  return info;
}
function create_rule(node, a, b, duration, delay, ease, fn, uid = 0) {
  const step = 16.666 / duration;
  let keyframes = "{\n";
  for (let p = 0; p <= 1; p += step) {
    const t = a + (b - a) * ease(p);
    keyframes += p * 100 + `%{${fn(t, 1 - t)}}
`;
  }
  const rule = keyframes + `100% {${fn(b, 1 - b)}}
}`;
  const name = `__svelte_${hash(rule)}_${uid}`;
  const doc = get_root_for_style(node);
  const { stylesheet, rules } = managed_styles.get(doc) || create_style_information(doc, node);
  if (!rules[name]) {
    rules[name] = true;
    stylesheet.insertRule(`@keyframes ${name} ${rule}`, stylesheet.cssRules.length);
  }
  const animation = node.style.animation || "";
  node.style.animation = `${animation ? `${animation}, ` : ""}${name} ${duration}ms linear ${delay}ms 1 both`;
  active += 1;
  return name;
}
function delete_rule(node, name) {
  const previous = (node.style.animation || "").split(", ");
  const next = previous.filter(
    name ? (anim) => anim.indexOf(name) < 0 : (anim) => anim.indexOf("__svelte") === -1
    // remove all Svelte animations
  );
  const deleted = previous.length - next.length;
  if (deleted) {
    node.style.animation = next.join(", ");
    active -= deleted;
    if (!active) clear_rules();
  }
}
function clear_rules() {
  raf(() => {
    if (active) return;
    managed_styles.forEach((info) => {
      const { ownerNode } = info.stylesheet;
      if (ownerNode) detach(ownerNode);
    });
    managed_styles.clear();
  });
}
let current_component;
function set_current_component(component) {
  current_component = component;
}
function get_current_component() {
  if (!current_component) throw new Error("Function called outside component initialization");
  return current_component;
}
function onMount(fn) {
  get_current_component().$$.on_mount.push(fn);
}
function onDestroy(fn) {
  get_current_component().$$.on_destroy.push(fn);
}
function createEventDispatcher() {
  const component = get_current_component();
  return (type, detail, { cancelable = false } = {}) => {
    const callbacks = component.$$.callbacks[type];
    if (callbacks) {
      const event = custom_event(
        /** @type {string} */
        type,
        detail,
        { cancelable }
      );
      callbacks.slice().forEach((fn) => {
        fn.call(component, event);
      });
      return !event.defaultPrevented;
    }
    return true;
  };
}
function setContext(key, context) {
  get_current_component().$$.context.set(key, context);
  return context;
}
function getContext(key) {
  return get_current_component().$$.context.get(key);
}
function bubble(component, event) {
  const callbacks = component.$$.callbacks[event.type];
  if (callbacks) {
    callbacks.slice().forEach((fn) => fn.call(this, event));
  }
}
const dirty_components = [];
const binding_callbacks = [];
let render_callbacks = [];
const flush_callbacks = [];
const resolved_promise = /* @__PURE__ */ Promise.resolve();
let update_scheduled = false;
function schedule_update() {
  if (!update_scheduled) {
    update_scheduled = true;
    resolved_promise.then(flush);
  }
}
function tick() {
  schedule_update();
  return resolved_promise;
}
function add_render_callback(fn) {
  render_callbacks.push(fn);
}
function add_flush_callback(fn) {
  flush_callbacks.push(fn);
}
const seen_callbacks = /* @__PURE__ */ new Set();
let flushidx = 0;
function flush() {
  if (flushidx !== 0) {
    return;
  }
  const saved_component = current_component;
  do {
    try {
      while (flushidx < dirty_components.length) {
        const component = dirty_components[flushidx];
        flushidx++;
        set_current_component(component);
        update(component.$$);
      }
    } catch (e) {
      dirty_components.length = 0;
      flushidx = 0;
      throw e;
    }
    set_current_component(null);
    dirty_components.length = 0;
    flushidx = 0;
    while (binding_callbacks.length) binding_callbacks.pop()();
    for (let i = 0; i < render_callbacks.length; i += 1) {
      const callback = render_callbacks[i];
      if (!seen_callbacks.has(callback)) {
        seen_callbacks.add(callback);
        callback();
      }
    }
    render_callbacks.length = 0;
  } while (dirty_components.length);
  while (flush_callbacks.length) {
    flush_callbacks.pop()();
  }
  update_scheduled = false;
  seen_callbacks.clear();
  set_current_component(saved_component);
}
function update($$) {
  if ($$.fragment !== null) {
    $$.update();
    run_all($$.before_update);
    const dirty = $$.dirty;
    $$.dirty = [-1];
    $$.fragment && $$.fragment.p($$.ctx, dirty);
    $$.after_update.forEach(add_render_callback);
  }
}
function flush_render_callbacks(fns) {
  const filtered = [];
  const targets2 = [];
  render_callbacks.forEach((c) => fns.indexOf(c) === -1 ? filtered.push(c) : targets2.push(c));
  targets2.forEach((c) => c());
  render_callbacks = filtered;
}
let promise;
function wait$4() {
  if (!promise) {
    promise = Promise.resolve();
    promise.then(() => {
      promise = null;
    });
  }
  return promise;
}
function dispatch(node, direction, kind) {
  node.dispatchEvent(custom_event(`${direction ? "intro" : "outro"}${kind}`));
}
const outroing = /* @__PURE__ */ new Set();
let outros;
function group_outros() {
  outros = {
    r: 0,
    c: [],
    p: outros
    // parent group
  };
}
function check_outros() {
  if (!outros.r) {
    run_all(outros.c);
  }
  outros = outros.p;
}
function transition_in(block, local) {
  if (block && block.i) {
    outroing.delete(block);
    block.i(local);
  }
}
function transition_out(block, local, detach2, callback) {
  if (block && block.o) {
    if (outroing.has(block)) return;
    outroing.add(block);
    outros.c.push(() => {
      outroing.delete(block);
      if (callback) {
        if (detach2) block.d(1);
        callback();
      }
    });
    block.o(local);
  } else if (callback) {
    callback();
  }
}
const null_transition = { duration: 0 };
function create_in_transition(node, fn, params) {
  const options2 = { direction: "in" };
  let config = fn(node, params, options2);
  let running = false;
  let animation_name;
  let task;
  let uid = 0;
  function cleanup() {
    if (animation_name) delete_rule(node, animation_name);
  }
  function go() {
    const {
      delay = 0,
      duration = 300,
      easing = identity,
      tick: tick2 = noop,
      css
    } = config || null_transition;
    if (css) animation_name = create_rule(node, 0, 1, duration, delay, easing, css, uid++);
    tick2(0, 1);
    const start_time = now() + delay;
    const end_time = start_time + duration;
    if (task) task.abort();
    running = true;
    add_render_callback(() => dispatch(node, true, "start"));
    task = loop((now2) => {
      if (running) {
        if (now2 >= end_time) {
          tick2(1, 0);
          dispatch(node, true, "end");
          cleanup();
          return running = false;
        }
        if (now2 >= start_time) {
          const t = easing((now2 - start_time) / duration);
          tick2(t, 1 - t);
        }
      }
      return running;
    });
  }
  let started = false;
  return {
    start() {
      if (started) return;
      started = true;
      delete_rule(node);
      if (is_function(config)) {
        config = config(options2);
        wait$4().then(go);
      } else {
        go();
      }
    },
    invalidate() {
      started = false;
    },
    end() {
      if (running) {
        cleanup();
        running = false;
      }
    }
  };
}
function create_out_transition(node, fn, params) {
  const options2 = { direction: "out" };
  let config = fn(node, params, options2);
  let running = true;
  let animation_name;
  const group = outros;
  group.r += 1;
  let original_inert_value;
  function go() {
    const {
      delay = 0,
      duration = 300,
      easing = identity,
      tick: tick2 = noop,
      css
    } = config || null_transition;
    if (css) animation_name = create_rule(node, 1, 0, duration, delay, easing, css);
    const start_time = now() + delay;
    const end_time = start_time + duration;
    add_render_callback(() => dispatch(node, false, "start"));
    if ("inert" in node) {
      original_inert_value = /** @type {HTMLElement} */
      node.inert;
      node.inert = true;
    }
    loop((now2) => {
      if (running) {
        if (now2 >= end_time) {
          tick2(0, 1);
          dispatch(node, false, "end");
          if (!--group.r) {
            run_all(group.c);
          }
          return false;
        }
        if (now2 >= start_time) {
          const t = easing((now2 - start_time) / duration);
          tick2(1 - t, t);
        }
      }
      return running;
    });
  }
  if (is_function(config)) {
    wait$4().then(() => {
      config = config(options2);
      go();
    });
  } else {
    go();
  }
  return {
    end(reset) {
      if (reset && "inert" in node) {
        node.inert = original_inert_value;
      }
      if (reset && config.tick) {
        config.tick(1, 0);
      }
      if (running) {
        if (animation_name) delete_rule(node, animation_name);
        running = false;
      }
    }
  };
}
function create_bidirectional_transition(node, fn, params, intro) {
  const options2 = { direction: "both" };
  let config = fn(node, params, options2);
  let t = intro ? 0 : 1;
  let running_program = null;
  let pending_program = null;
  let animation_name = null;
  let original_inert_value;
  function clear_animation() {
    if (animation_name) delete_rule(node, animation_name);
  }
  function init2(program, duration) {
    const d = (
      /** @type {Program['d']} */
      program.b - t
    );
    duration *= Math.abs(d);
    return {
      a: t,
      b: program.b,
      d,
      duration,
      start: program.start,
      end: program.start + duration,
      group: program.group
    };
  }
  function go(b) {
    const {
      delay = 0,
      duration = 300,
      easing = identity,
      tick: tick2 = noop,
      css
    } = config || null_transition;
    const program = {
      start: now() + delay,
      b
    };
    if (!b) {
      program.group = outros;
      outros.r += 1;
    }
    if ("inert" in node) {
      if (b) {
        if (original_inert_value !== void 0) {
          node.inert = original_inert_value;
        }
      } else {
        original_inert_value = /** @type {HTMLElement} */
        node.inert;
        node.inert = true;
      }
    }
    if (running_program || pending_program) {
      pending_program = program;
    } else {
      if (css) {
        clear_animation();
        animation_name = create_rule(node, t, b, duration, delay, easing, css);
      }
      if (b) tick2(0, 1);
      running_program = init2(program, duration);
      add_render_callback(() => dispatch(node, b, "start"));
      loop((now2) => {
        if (pending_program && now2 > pending_program.start) {
          running_program = init2(pending_program, duration);
          pending_program = null;
          dispatch(node, running_program.b, "start");
          if (css) {
            clear_animation();
            animation_name = create_rule(
              node,
              t,
              running_program.b,
              running_program.duration,
              0,
              easing,
              config.css
            );
          }
        }
        if (running_program) {
          if (now2 >= running_program.end) {
            tick2(t = running_program.b, 1 - t);
            dispatch(node, running_program.b, "end");
            if (!pending_program) {
              if (running_program.b) {
                clear_animation();
              } else {
                if (!--running_program.group.r) run_all(running_program.group.c);
              }
            }
            running_program = null;
          } else if (now2 >= running_program.start) {
            const p = now2 - running_program.start;
            t = running_program.a + running_program.d * easing(p / running_program.duration);
            tick2(t, 1 - t);
          }
        }
        return !!(running_program || pending_program);
      });
    }
  }
  return {
    run(b) {
      if (is_function(config)) {
        wait$4().then(() => {
          const opts = { direction: b ? "in" : "out" };
          config = config(opts);
          go(b);
        });
      } else {
        go(b);
      }
    },
    end() {
      clear_animation();
      running_program = pending_program = null;
    }
  };
}
function ensure_array_like(array_like_or_iterator) {
  return array_like_or_iterator?.length !== void 0 ? array_like_or_iterator : Array.from(array_like_or_iterator);
}
function destroy_block(block, lookup) {
  block.d(1);
  lookup.delete(block.key);
}
function outro_and_destroy_block(block, lookup) {
  transition_out(block, 1, 1, () => {
    lookup.delete(block.key);
  });
}
function update_keyed_each(old_blocks, dirty, get_key, dynamic, ctx, list, lookup, node, destroy, create_each_block2, next, get_context) {
  let o = old_blocks.length;
  let n = list.length;
  let i = o;
  const old_indexes = {};
  while (i--) old_indexes[old_blocks[i].key] = i;
  const new_blocks = [];
  const new_lookup = /* @__PURE__ */ new Map();
  const deltas = /* @__PURE__ */ new Map();
  const updates = [];
  i = n;
  while (i--) {
    const child_ctx = get_context(ctx, list, i);
    const key = get_key(child_ctx);
    let block = lookup.get(key);
    if (!block) {
      block = create_each_block2(key, child_ctx);
      block.c();
    } else {
      updates.push(() => block.p(child_ctx, dirty));
    }
    new_lookup.set(key, new_blocks[i] = block);
    if (key in old_indexes) deltas.set(key, Math.abs(i - old_indexes[key]));
  }
  const will_move = /* @__PURE__ */ new Set();
  const did_move = /* @__PURE__ */ new Set();
  function insert2(block) {
    transition_in(block, 1);
    block.m(node, next);
    lookup.set(block.key, block);
    next = block.first;
    n--;
  }
  while (o && n) {
    const new_block = new_blocks[n - 1];
    const old_block = old_blocks[o - 1];
    const new_key = new_block.key;
    const old_key = old_block.key;
    if (new_block === old_block) {
      next = new_block.first;
      o--;
      n--;
    } else if (!new_lookup.has(old_key)) {
      destroy(old_block, lookup);
      o--;
    } else if (!lookup.has(new_key) || will_move.has(new_key)) {
      insert2(new_block);
    } else if (did_move.has(old_key)) {
      o--;
    } else if (deltas.get(new_key) > deltas.get(old_key)) {
      did_move.add(new_key);
      insert2(new_block);
    } else {
      will_move.add(old_key);
      o--;
    }
  }
  while (o--) {
    const old_block = old_blocks[o];
    if (!new_lookup.has(old_block.key)) destroy(old_block, lookup);
  }
  while (n) insert2(new_blocks[n - 1]);
  run_all(updates);
  return new_blocks;
}
function get_spread_update(levels, updates) {
  const update2 = {};
  const to_null_out = {};
  const accounted_for = { $$scope: 1 };
  let i = levels.length;
  while (i--) {
    const o = levels[i];
    const n = updates[i];
    if (n) {
      for (const key in o) {
        if (!(key in n)) to_null_out[key] = 1;
      }
      for (const key in n) {
        if (!accounted_for[key]) {
          update2[key] = n[key];
          accounted_for[key] = 1;
        }
      }
      levels[i] = n;
    } else {
      for (const key in o) {
        accounted_for[key] = 1;
      }
    }
  }
  for (const key in to_null_out) {
    if (!(key in update2)) update2[key] = void 0;
  }
  return update2;
}
function get_spread_object(spread_props) {
  return typeof spread_props === "object" && spread_props !== null ? spread_props : {};
}
function debug(file, line, column, values) {
  console.log(`{@debug} ${file + " "}(${line}:${column})`);
  console.log(values);
  return "";
}
function bind(component, name, callback) {
  const index = component.$$.props[name];
  if (index !== void 0) {
    component.$$.bound[index] = callback;
    callback(component.$$.ctx[index]);
  }
}
function create_component(block) {
  block && block.c();
}
function mount_component(component, target2, anchor) {
  const { fragment, after_update } = component.$$;
  fragment && fragment.m(target2, anchor);
  add_render_callback(() => {
    const new_on_destroy = component.$$.on_mount.map(run).filter(is_function);
    if (component.$$.on_destroy) {
      component.$$.on_destroy.push(...new_on_destroy);
    } else {
      run_all(new_on_destroy);
    }
    component.$$.on_mount = [];
  });
  after_update.forEach(add_render_callback);
}
function destroy_component(component, detaching) {
  const $$ = component.$$;
  if ($$.fragment !== null) {
    flush_render_callbacks($$.after_update);
    run_all($$.on_destroy);
    $$.fragment && $$.fragment.d(detaching);
    $$.on_destroy = $$.fragment = null;
    $$.ctx = [];
  }
}
function make_dirty(component, i) {
  if (component.$$.dirty[0] === -1) {
    dirty_components.push(component);
    schedule_update();
    component.$$.dirty.fill(0);
  }
  component.$$.dirty[i / 31 | 0] |= 1 << i % 31;
}
function init(component, options2, instance2, create_fragment2, not_equal, props, append_styles = null, dirty = [-1]) {
  const parent_component = current_component;
  set_current_component(component);
  const $$ = component.$$ = {
    fragment: null,
    ctx: [],
    // state
    props,
    update: noop,
    not_equal,
    bound: blank_object(),
    // lifecycle
    on_mount: [],
    on_destroy: [],
    on_disconnect: [],
    before_update: [],
    after_update: [],
    context: new Map(options2.context || (parent_component ? parent_component.$$.context : [])),
    // everything else
    callbacks: blank_object(),
    dirty,
    skip_bound: false,
    root: options2.target || parent_component.$$.root
  };
  append_styles && append_styles($$.root);
  let ready = false;
  $$.ctx = instance2 ? instance2(component, options2.props || {}, (i, ret, ...rest) => {
    const value = rest.length ? rest[0] : ret;
    if ($$.ctx && not_equal($$.ctx[i], $$.ctx[i] = value)) {
      if (!$$.skip_bound && $$.bound[i]) $$.bound[i](value);
      if (ready) make_dirty(component, i);
    }
    return ret;
  }) : [];
  $$.update();
  ready = true;
  run_all($$.before_update);
  $$.fragment = create_fragment2 ? create_fragment2($$.ctx) : false;
  if (options2.target) {
    if (options2.hydrate) {
      const nodes = children(options2.target);
      $$.fragment && $$.fragment.l(nodes);
      nodes.forEach(detach);
    } else {
      $$.fragment && $$.fragment.c();
    }
    if (options2.intro) transition_in(component.$$.fragment);
    mount_component(component, options2.target, options2.anchor);
    flush();
  }
  set_current_component(parent_component);
}
class SvelteComponent {
  /**
   * ### PRIVATE API
   *
   * Do not use, may change at any time
   *
   * @type {any}
   */
  $$ = void 0;
  /**
   * ### PRIVATE API
   *
   * Do not use, may change at any time
   *
   * @type {any}
   */
  $$set = void 0;
  /** @returns {void} */
  $destroy() {
    destroy_component(this, 1);
    this.$destroy = noop;
  }
  /**
   * @template {Extract<keyof Events, string>} K
   * @param {K} type
   * @param {((e: Events[K]) => void) | null | undefined} callback
   * @returns {() => void}
   */
  $on(type, callback) {
    if (!is_function(callback)) {
      return noop;
    }
    const callbacks = this.$$.callbacks[type] || (this.$$.callbacks[type] = []);
    callbacks.push(callback);
    return () => {
      const index = callbacks.indexOf(callback);
      if (index !== -1) callbacks.splice(index, 1);
    };
  }
  /**
   * @param {Partial<Props>} props
   * @returns {void}
   */
  $set(props) {
    if (this.$$set && !is_empty(props)) {
      this.$$.skip_bound = true;
      this.$$set(props);
      this.$$.skip_bound = false;
    }
  }
}
const PUBLIC_VERSION = "4";
class AAAutorecFunctions {
  static rinseName(oldName) {
    if (!oldName) {
      return;
    }
    const newName = oldName.replace(/\s+/g, "").toLowerCase();
    return newName;
  }
  static sortAndFilterMenus(menus) {
    let combinedMenus = [
      ...menus.melee,
      ...menus.range,
      ...menus.ontoken,
      ...menus.templatefx,
      ...menus.aura,
      ...menus.preset
    ];
    let sortedMenus2 = combinedMenus.sort((a, b) => b.label?.replace(/\s+/g, "").length - a.label?.replace(/\s+/g, "").length);
    return {
      exactMatchMenus: sortedMenus2.filter((x) => x.advanced?.exactMatch),
      bestMatchMenus: sortedMenus2.filter((x) => !x.advanced?.exactMatch)
    };
  }
  static allMenuSearch(menus, rinsedName, trueName) {
    return menus.exactMatchMenus.find((x) => x.label && x.label === trueName) || menus.bestMatchMenus.find(
      (x) => x.advanced?.excludedTerms?.length ? x.label && rinsedName.includes(this.rinseName(x.label)) && !x.advanced.excludedTerms.some((el) => rinsedName.includes(this.rinseName(el))) : x.label && rinsedName.includes(this.rinseName(x.label))
    ) || false;
  }
  /*
      static allMenuSearch(menus, name) {
  
          let combinedMenus = [...menus.melee, ...menus.range, ...menus.ontoken,
              ...menus.templatefx, ...menus.aura, ...menus.preset];
  
          let sortedMenus = combinedMenus.sort((a, b) => b.label?.replace(/\s+/g, '').length - a.label?.replace(/\s+/g, '').length);
  
          return sortedMenus.find(x => x.label && name.includes(this.rinseName(x.label))) || false;
      }
      */
  static allMenuTrueSearch(menus, rinsedName, trueName) {
    return menus.exactMatchMenus.find((x) => x.label && x.label === trueName) || menus.bestMatchMenus.find(
      (x) => x.advanced?.excludedTerms?.length ? x.label && rinsedName.includes(this.rinseName(x.label)) && !x.advanced.excludedTerms.some((el) => rinsedName.includes(this.rinseName(el))) : x.label && rinsedName.includes(this.rinseName(x.label))
    ) || false;
  }
  static sortAndFilterAllMenus(menus) {
    let combinedMenus = [
      ...menus.melee,
      ...menus.range,
      ...menus.ontoken,
      ...menus.templatefx,
      ...menus.aura,
      ...menus.preset,
      ...menus.aefx
    ];
    let sortedMenus2 = combinedMenus.sort((a, b) => b.label?.replace(/\s+/g, "").length - a.label?.replace(/\s+/g, "").length);
    return {
      exactMatchMenus: sortedMenus2.filter((x) => x.advanced?.exactMatch),
      bestMatchMenus: sortedMenus2.filter((x) => !x.advanced?.exactMatch)
    };
  }
  static singleMenuSearch(menu, rinsedName, trueName) {
    if (!rinsedName) {
      custom_warning("No Name was provided for the Global Menu search");
      return;
    }
    let sortedMenu = menu.sort((a, b) => b.label.replace(/\s+/g, "").length - a.label?.replace(/\s+/g, "").length);
    let exactMatchMenus = sortedMenu.filter((x) => x.advanced?.exactMatch);
    let bestMatchMenus = sortedMenu.filter((x) => !x.advanced?.exactMatch);
    return exactMatchMenus.find((x) => x.label && x.label === trueName) || bestMatchMenus.find(
      (x) => x.advanced?.excludedTerms?.length ? x.label && rinsedName.includes(this.rinseName(x.label)) && !x.advanced.excludedTerms.some((el) => rinsedName.includes(this.rinseName(el))) : x.label && rinsedName.includes(this.rinseName(x.label))
    ) || false;
  }
  static singleMenuStrictSearch(menu, name) {
    if (!name) {
      custom_warning("No Name was provided for the Global Menu search");
      return;
    }
    return menu.find((x) => name === this.rinseName(x.label)) || false;
  }
  static getAllLabelsInMenu(menu) {
    const nameArray = [];
    for (var i = 0; i < menu.length; i++) {
      if (!menu[i].label) {
        continue;
      }
      nameArray.push(this.rinseName(menu[i].label));
    }
    return nameArray;
  }
  static sortMenu(menu) {
    menu.sort((a, b) => b.label.replace(/\s+/g, "").length - a.label.replace(/\s+/g, "").length);
    return sortedMenus;
  }
  // If an Autorec section has advanced search features enabled for excluding an Item property, this will check that property against that of the item used
  static checkExcludedProperty(item2, property, path = "") {
    if (!path || !property || !item2) {
      return;
    }
    let value = path.split(".").reduce((a, b) => a[b], item2);
    if (typeof value !== "string") {
      debug("Invalid path for Excluded Item type", path);
      return false;
    }
    return this.rinseName(property) === this.rinseName(value);
  }
}
async function handleItem(data2) {
  if (!data2.item) {
    return;
  }
  const item2 = data2.item;
  const itemName = item2.name ?? item2.label;
  const rinsedItemName = itemName ? AAAutorecFunctions.rinseName(itemName) : "noitem";
  const ammoItem = data2.ammoItem;
  const rinsedAmmoName = ammoItem?.name ? AAAutorecFunctions.rinseName(ammoItem.name) : "";
  const itemFlags = await flagMigrations.handle(data2.item, { activeEffect: data2.activeEffect }) || {};
  const itemIsEnabled = !!itemFlags.killAnim ? false : itemFlags.isEnabled ?? true;
  if (!itemIsEnabled) {
    return false;
  }
  const ammoFlags = ammoItem ? await flagMigrations.handle(ammoItem, { activeEffect: data2.activeEffect }) || { isEnabled: true } : null;
  let autorecDisabled = game.settings.get("autoanimations", "disableAutoRec");
  if (autorecDisabled) {
    debug$1("Global Automatic Recognition menu is Disabled from the Module Settings");
  }
  const autorecSettings = {
    melee: game.settings.get("autoanimations", "aaAutorec-melee"),
    range: game.settings.get("autoanimations", "aaAutorec-range"),
    ontoken: game.settings.get("autoanimations", "aaAutorec-ontoken"),
    templatefx: game.settings.get("autoanimations", "aaAutorec-templatefx"),
    aura: game.settings.get("autoanimations", "aaAutorec-aura"),
    preset: game.settings.get("autoanimations", "aaAutorec-preset"),
    aefx: game.settings.get("autoanimations", "aaAutorec-aefx")
  };
  let menus = AAAutorecFunctions.sortAndFilterMenus(autorecSettings);
  let autorecObject;
  if (ammoItem && ammoFlags.isEnabled) {
    if (ammoFlags.isCustomized) {
      return ammoFlags;
    } else if (!autorecDisabled) {
      autorecObject = AAAutorecFunctions.allMenuSearch(menus, rinsedAmmoName, ammoItem?.name || "");
    }
    if (autorecObject) {
      return autorecObject;
    }
  }
  if (data2.activeEffect) {
    if (itemFlags.isCustomized) {
      return itemFlags;
    } else if (!autorecDisabled) {
      autorecObject = AAAutorecFunctions.singleMenuSearch(autorecSettings.aefx, rinsedItemName, itemName);
      return autorecObject;
    }
  } else {
    if (itemFlags.isCustomized) {
      return itemFlags;
    } else if (!autorecDisabled) {
      const prioritizedNames = [...data2.overrideNames || [], itemName, ...data2.extraNames || []];
      prioritizedNames.find((name) => {
        const rinsedName = AAAutorecFunctions.rinseName(name);
        const found = AAAutorecFunctions.allMenuSearch(menus, rinsedName, name);
        if (found) {
          autorecObject = found;
          data2.rinsedName = rinsedName;
        }
        return !!found;
      });
      if (!autorecObject && data2.isVariant && !data2.isTemplate) {
        let originalItemName = data2.originalItem?.name;
        let originalRinsedName = originalItemName ? AAAutorecFunctions.rinseName(originalItemName) : "noitem";
        autorecObject = AAAutorecFunctions.allMenuSearch(menus, originalRinsedName, originalItemName);
      }
    }
  }
  if (autorecObject && data2.isTemplate && !autorecDisabled) {
    let data3 = autorecObject;
    if (data3.menu === "range" || data3.menu === "melee" || data3.menu === "ontoken") {
      autorecObject = AAAutorecFunctions.singleMenuSearch(autorecSettings.templatefx, rinsedItemName, itemName);
    }
  } else if (data2.isVariant && !autorecObject && data2.isTemplate && !autorecDisabled) {
    let newItemName = data2.originalItem?.name;
    let newRinsedName = newItemName ? AAAutorecFunctions.rinseName(newItemName) : "noitem";
    autorecObject = AAAutorecFunctions.allMenuSearch(menus, newRinsedName, newItemName);
  }
  return autorecObject;
}
function sourceEffect(sourceFX, seq, handler) {
  const options2 = sourceFX.options;
  if (sourceFX.sound) {
    seq.addSequence(sourceFX.sound);
  }
  let thisSeq = seq.effect().file(sourceFX.path.file).anchor({ x: options2.anchor.x, y: options2.anchor.y }).fadeIn(options2.fadeIn).opacity(options2.opacity).origin(handler.itemUuid).playbackRate(options2.playbackRate).repeats(options2.repeat, options2.repeatDelay).size(handler.getSize(options2.isRadius, options2.size, handler.sourceToken, options2.addTokenWidth), { gridUnits: true }).zIndex(options2.zIndex);
  if (options2.elevation === 0) {
    thisSeq.belowTokens(true);
  } else {
    thisSeq.elevation(options2.isAbsolute ? options2.elevation : options2.elevation - 1, { absolute: options2.isAbsolute });
  }
  if (options2.tint) {
    thisSeq.tint(options2.tintColor);
    thisSeq.filter("ColorMatrix", { contrast: options2.contrast, saturate: options2.saturation });
  }
  if (options2.animationSource) {
    thisSeq.atLocation({ x: options2.fakeLocation.x, y: options2.fakeLocation.y });
  } else {
    if (options2.persistent) {
      thisSeq.attachTo(handler.sourceToken);
      thisSeq.persist(true, { persistTokenPrototype: true });
    } else {
      thisSeq.attachTo(handler.sourceToken);
    }
  }
  if (options2.isMasked) {
    thisSeq.mask(handler.sourceToken);
  }
  if (handler.systemData.tieToDocuments) {
    thisSeq.tieToDocuments(handler.item);
  }
  if (sourceFX.video.variant === "complete" || sourceFX.video.animation === "complete") ;
  else {
    thisSeq.fadeOut(options2.fadeOut);
  }
  if (options2.isWait) {
    thisSeq.waitUntilFinished(options2.delay);
  } else {
    thisSeq.delay(options2.delay);
  }
}
function secondaryEffect(secondary2, seq, targetArray, targetEnabled = false, missable = false, handler) {
  const options2 = secondary2.options;
  if (secondary2.sound) {
    seq.addSequence(secondary2.sound);
  }
  for (let i = 0; i < targetArray.length; i++) {
    let currentTarget = targetArray[i];
    let thisSeq = seq.effect().file(secondary2.path?.file).anchor({ x: options2.anchor.x, y: options2.anchor.y }).atLocation(missable ? `spot ${currentTarget.id}` : currentTarget).fadeIn(options2.fadeIn).fadeOut(options2.fadeOut).opacity(options2.opacity).origin(handler.itemUuid).playbackRate(options2.playbackRate).repeats(options2.repeat, options2.repeatDelay).size(handler.getSize(options2.isRadius, options2.size, currentTarget, options2.addTokenWidth), { gridUnits: true }).zIndex(options2.zIndex);
    if (options2.elevation === 0) {
      thisSeq.belowTokens(true);
    } else {
      thisSeq.elevation(handler.elevation(currentTarget, options2.isAbsolute, options2.elevation), { absolute: options2.isAbsolute });
    }
    if (options2.tint) {
      thisSeq.tint(options2.tintColor);
      thisSeq.filter("ColorMatrix", { contrast: options2.contrast, saturate: options2.saturation });
    }
    if (i === handler.allTargets.length - 1 && options2.isWait && targetEnabled) {
      thisSeq.waitUntilFinished(options2.delay);
    } else if (!options2.isWait) {
      thisSeq.delay(options2.delay);
    }
    if (options2.rotateSource) {
      thisSeq.rotateTowards(handler.sourceToken);
      thisSeq.rotate(180);
    }
    if (options2.isMasked) {
      thisSeq.mask(currentTarget);
    }
  }
}
function targetEffect(targetFX, seq, targetArray, missable = false, handler) {
  const options2 = targetFX.options;
  if (targetFX.sound) {
    seq.addSequence(targetFX.sound);
  }
  for (let i = 0; i < targetArray.length; i++) {
    let currentTarget = targetArray[i];
    let checkAnim = Sequencer.EffectManager.getEffects({ object: currentTarget, origin: handler.itemUuid }).length > 0;
    if (checkAnim) {
      continue;
    }
    let thisSeq = seq.effect().file(targetFX.path?.file).anchor({ x: options2.anchor.x, y: options2.anchor.y }).delay(options2.delay).fadeIn(options2.fadeIn).opacity(options2.opacity).origin(handler.itemUuid).playbackRate(options2.playbackRate).repeats(options2.repeat, options2.repeatDelay).size(handler.getSize(options2.isRadius, options2.size, currentTarget, options2.addTokenWidth), { gridUnits: true }).zIndex(options2.zIndex);
    if (options2.elevation === 0) {
      thisSeq.belowTokens(true);
    } else {
      thisSeq.elevation(handler.elevation(currentTarget, options2.isAbsolute, options2.elevation), { absolute: options2.isAbsolute });
    }
    if (options2.tint) {
      thisSeq.tint(options2.tintColor);
      thisSeq.filter("ColorMatrix", { contrast: options2.contrast, saturate: options2.saturation });
    }
    if (options2.persistent) {
      thisSeq.persist(true, { persistTokenPrototype: true });
      thisSeq.attachTo(currentTarget, { bindVisibility: !targetFX.unbindVisibility, bindAlpha: !targetFX.unbindAlpha });
    } else {
      thisSeq.atLocation(missable ? `spot ${currentTarget.id}` : currentTarget);
    }
    if (options2.rotateSource) {
      thisSeq.rotateTowards(handler.sourceToken);
      thisSeq.rotate(180);
    }
    if (options2.isMasked) {
      thisSeq.mask(currentTarget);
    }
    if (targetFX.video?.variant === "complete" || targetFX.video?.animation === "complete") ;
    else {
      thisSeq.fadeOut(options2.fadeOut);
    }
  }
}
function macroSection(seq, macro2, handler) {
  let userData = macro2.args;
  if (foundry.utils.isNewerVersion(game.version, 11)) {
    seq.macro(macro2.name, { args: [handler.workflow, handler, userData] });
  } else {
    if (game.modules.get("advanced-macros")?.active) {
      seq.macro(macro2.name, handler.workflow, handler, userData);
    } else {
      seq.macro(macro2.name);
    }
  }
}
let enabled = true;
class AnimationState {
  static get enabled() {
    return enabled;
  }
  static set enabled(newEnabled) {
    enabled = newEnabled;
  }
}
class AAHandler {
  static async make(data2) {
    if (!AnimationState.enabled) {
      custom_notify("Animations are Disabled from the Automated Animations Settings", true);
      return false;
    }
    let clonedData = foundry.utils.deepClone(data2);
    let animationData = await handleItem(clonedData);
    Hooks.callAll("AutomatedAnimations-WorkflowStart", clonedData, animationData);
    if (clonedData.stopWorkflow) {
      debug$1(`Animation Workflow was interrupted by an External Source`, clonedData);
      return;
    }
    let newAnimationData;
    if (clonedData.recheckAnimation) {
      newAnimationData = await handleItem(clonedData);
      if (!newAnimationData) {
        clonedData.item = data2.item;
      }
    }
    if (!animationData && !newAnimationData) {
      debug$1(`No Animation matched for Item`, clonedData);
      return false;
    }
    let finalAnimationData = newAnimationData ? newAnimationData : animationData;
    return new AAHandler({ ...clonedData, finalAnimationData });
  }
  constructor(data2) {
    debug$1("Compiling Automated Animations data");
    this.animationData = data2.finalAnimationData;
    this.isActiveEffect = data2.activeEffect ?? false;
    this.systemId = game.system.id;
    this.workflow = this.isActiveEffect ? "on" : data2.workflow;
    if (this.isActiveEffect) {
      this.workflowBackup = data2.workflow;
    }
    this.sourceToken = data2.token?.isEmbedded ? data2.token?.object : data2.token;
    this.item = data2.ammoItem || data2.item;
    this.itemUuid = this.item?.uuid || Hashing.uuidv4();
    this.itemName = this.item.name ?? this.item.label;
    this.rinsedName = data2.rinsedName || this.itemName ? this.itemName.replace(/\s+/g, "").toLowerCase() : "";
    this.reachCheck = data2.reach || 0;
    this.allTargets = data2.targets;
    this.hitTargets = data2.hitTargets;
    this.hitTargetsId = data2.hitTargets ? Array.from(this.hitTargets.filter((actor) => actor.id).map((actor) => actor.id)) : [];
    this.playOnMiss = data2.playOnMiss ?? (game.modules.get("midi-qol")?.active || game.system.id === "pf2e" ? game.settings.get("autoanimations", "playonmiss") : false) ?? false;
    this.menu = this.animationData.menu;
    this.templateData = data2.templateData;
    this.sequenceData = { moduleName: "Automated Animations", softFail: !game.settings.get("autoanimations", "debug") };
    this.systemData = data2;
  }
  get isTemplateAnimation() {
    const presetType = this.animationData.presetType;
    return this.menu === "templatefx" || this.menu === "preset" && presetType === "proToTemp" || this.menu === "preset" && presetType === "thunderwave";
  }
  get isAura() {
    return this.menu === "aura";
  }
  get isTeleport() {
    if (this.menu !== "preset") {
      return false;
    }
    return this.animationData.presetType === "teleportation";
  }
  get macroActive() {
    return this.flags.macro?.enable && this.flags.macro?.name;
  }
  // Sets the Elevation of the Effect
  elevation(token = {}, abs = false, level = 0) {
    return abs ? level : level - 1;
  }
  // Sets the Size of the effect
  getSize(isRadius = false, size = 1, token, addToken = false) {
    return isRadius ? addToken ? size * 2 + token.w / canvas.grid.size : size * 2 : token.w / canvas.grid.size * 1.5 * size;
  }
  getDistance(target2) {
    if (this.systemId === "pf1") {
      const scene = game.scenes.active;
      const gridSize = scene.grid.size;
      const left = (token) => token.x;
      const right = (token) => token.x + token.w;
      const top = (token) => token.y;
      const bottom = (token) => token.y + token.h;
      const isLeftOf = right(this.sourceToken) <= left(target2);
      const isRightOf = left(this.sourceToken) >= right(target2);
      const isAbove = bottom(this.sourceToken) <= top(target2);
      const isBelow = top(this.sourceToken) >= bottom(target2);
      let x12 = left(this.sourceToken);
      let x2 = left(target2);
      let y12 = top(this.sourceToken);
      let y2 = top(target2);
      if (isLeftOf) {
        x12 += (this.sourceToken.document.width - 1) * gridSize;
      } else if (isRightOf) {
        x2 += (target2.document.width - 1) * gridSize;
      }
      if (isAbove) {
        y12 += (this.sourceToken.document.height - 1) * gridSize;
      } else if (isBelow) {
        y2 += (target2.document.height - 1) * gridSize;
      }
      const ray = new Ray({ x: x12, y: y12 }, { x: x2, y: y2 });
      const distance2 = canvas.grid.grid.measureDistances([{ ray }], { gridSpaces: true })[0];
      return distance2 / canvas.dimensions.distance;
    } else {
      const t1 = this.sourceToken;
      const noResult = { distance: -1, acBonus: void 0 };
      if (!canvas || !canvas.scene)
        return noResult;
      if (!canvas.grid || !canvas.dimensions)
        ;
      if (!t1 || !target2)
        return noResult;
      if (!canvas || !canvas.grid || !canvas.dimensions)
        return noResult;
      const t1StartX = t1.document.width >= 1 ? 0.5 : t1.document.width / 2;
      const t1StartY = t1.document.height >= 1 ? 0.5 : t1.document.height / 2;
      const t2StartX = target2.document.width >= 1 ? 0.5 : target2.document.width / 2;
      const t2StartY = target2.document.height >= 1 ? 0.5 : target2.document.height / 2;
      var x, x1, y, y1, segments = [], rdistance, distance;
      for (x = t1StartX; x < t1.document.width; x++) {
        for (y = t1StartY; y < t1.document.height; y++) {
          const origin = new PIXI.Point(...canvas.grid.getCenter(Math.round(t1.document.x + canvas.dimensions.size * x), Math.round(t1.document.y + canvas.dimensions.size * y)));
          for (x1 = t2StartX; x1 < target2.document.width; x1++) {
            for (y1 = t2StartY; y1 < target2.document.height; y1++) {
              const dest = new PIXI.Point(...canvas.grid.getCenter(Math.round(target2.document.x + canvas.dimensions.size * x1), Math.round(target2.document.y + canvas.dimensions.size * y1)));
              const r = new Ray(origin, dest);
              segments.push({ ray: r });
            }
          }
        }
      }
      if (segments.length === 0) {
        return noResult;
      }
      rdistance = segments.map((ray) => canvas.grid.measureDistances([ray], { gridSpaces: true })[0]);
      distance = rdistance[0];
      rdistance.forEach((d) => {
        if (d < distance)
          distance = d;
      });
      return distance / canvas.dimensions.distance;
    }
  }
  complileMacroSection(seq, macro2, handler = this) {
    macroSection(seq, macro2, handler);
  }
  runMacro(macro2, handler = this) {
    let userData = macro2.args;
    if (foundry.utils.isNewerVersion(game.version, 11)) {
      new Sequence(handler.sequenceData).macro(macro2.name, { args: [handler.workflow, handler, userData] }).play();
    } else {
      if (game.modules.get("advanced-macros")?.active) {
        new Sequence(handler.sequenceData).macro(macro2.name, handler.workflow, handler, userData).play();
      } else {
        new Sequence(handler.sequenceData).macro(macro2.name).play();
      }
    }
  }
  compileSourceEffect(sourceFX, seq, handler = this) {
    sourceEffect(sourceFX, seq, handler);
  }
  compileSecondaryEffect(secondary2, seq, targetArray, targetEnabled = false, missable = false, handler = this) {
    secondaryEffect(secondary2, seq, targetArray, targetEnabled, missable, handler);
  }
  compileTargetEffect(targetFX, seq, targetArray, missable = false, handler = this) {
    targetEffect(targetFX, seq, targetArray, missable, handler);
  }
  // Returns a pseudo Token X/Y for Ranged effects
  fakeSource() {
    let templateSource = Sequencer.EffectManager.getEffects({ sceneId: canvas.scene.id, name: this.rinsedName })[0];
    if (!templateSource) {
      return this.sourceToken;
    }
    let gridSize = canvas.grid.size / 2;
    let tsXmin = templateSource.source.x - templateSource.source.width / 2 + gridSize;
    let tsXmax = templateSource.source.x + templateSource.source.width / 2 - gridSize;
    let tsYmin = templateSource.source.y - templateSource.source.height / 2 + gridSize;
    let txYmax = templateSource.source.y + templateSource.source.height / 2 - gridSize;
    let newX = Sequencer.Helpers.random_int_between(tsXmin, tsXmax);
    let newY = Sequencer.Helpers.random_int_between(tsYmin, txYmax);
    return { x: newX, y: newY };
  }
}
async function buildFile(dbType, video2, custom = true, options2 = {}) {
  const { menuType, animation, variant, color, customPath } = video2;
  if (!dbType && (!customPath || !custom)) {
    return false;
  }
  if (customPath) {
    return { file: customPath, fileData: customPath };
  }
  let cleanType = menuType;
  let cleanAnimation = animation;
  let cleanVariant = variant;
  let cleanColor = color;
  if (!validateVideoPath()) {
    debug$1("Error found while building database path, reverting a default");
    cleanType = getCleanProperty(aaDatabase$1[dbType], menuType);
    cleanAnimation = getCleanProperty(aaDatabase$1[dbType][cleanType], animation);
    cleanVariant = getCleanProperty(aaDatabase$1[dbType][cleanType][cleanAnimation], variant);
    cleanColor = getCleanProperty(aaDatabase$1[dbType][cleanType][cleanAnimation][cleanVariant], color);
  }
  const returnArray = Object.keys(aaDatabase$1.return.weapon);
  return {
    filePath: options2.getTruePath ? filePath() : void 0,
    file: databasePath(),
    returnFile: options2.isReturnable ? returnDatabasePath() : void 0,
    // Cleaned properties. Useful for debugging
    cleanProperties: {
      cleanType,
      cleanAnimation,
      cleanVariant,
      cleanColor
    },
    // Original properties. Useful for debugging
    originalProperties: {
      menuType,
      animation,
      variant,
      color
    }
  };
  function getCleanProperty(path, prop) {
    let newArray = Object.keys(path ?? {});
    return newArray.find((el) => prop === el) ? prop : newArray[0] !== "_markers" ? newArray[0] : newArray[1];
  }
  function validateVideoPath() {
    if (!dbType || !menuType || !animation || !variant || !color) {
      return false;
    }
    let dbPath = color === "random" ? `autoanimations.${dbType}.${[menuType]}.${animation}.${variant}` : `autoanimations.${dbType}.${[menuType]}.${animation}.${variant}.${color}`;
    return !!Sequencer.Database.getEntry(dbPath, { softFail: true });
  }
  function filePath() {
    let colorOptions = Object.keys(aaDatabase$1[dbType][cleanType]?.[cleanAnimation]?.[cleanVariant]);
    return color === "random" ? aaDatabase$1[dbType][cleanType]?.[cleanAnimation]?.[cleanVariant]?.[colorOptions[0]]?.[0] : aaDatabase$1[dbType][cleanType]?.[cleanAnimation]?.[cleanVariant]?.[cleanColor]?.[0];
  }
  function databasePath() {
    return color === "random" ? `autoanimations.${dbType}.${[cleanType]}.${cleanAnimation}.${cleanVariant}` : `autoanimations.${dbType}.${[cleanType]}.${cleanAnimation}.${cleanVariant}.${cleanColor}`;
  }
  function returnDatabasePath() {
    return returnArray.find((el) => cleanAnimation === el) ? color === "random" ? `autoanimations.return.weapon.${cleanAnimation}.${cleanVariant}` : `autoanimations.return.weapon.${cleanAnimation}.${cleanVariant}.${cleanColor}` : false;
  }
}
const particleDefaultValues = {
  explosion: {
    type: "explosion",
    speed: 0,
    repeat: 1,
    delay: 500,
    scale: 2,
    color01: "#FFFFFF",
    color02: "#FFFFFF",
    sprite: "modules/levels-3d-preview/assets/particles/dust.png",
    life: 500,
    emittersize: 1,
    alpha: 0.2,
    mass: 400,
    gravity: 2,
    rate: 10,
    explosion: {},
    onCenter: false,
    autoSize: true
  },
  projectile: {
    type: "projectile",
    speed: 5,
    repeat: 1,
    arc: 2,
    delay: 500,
    scale: 0.7,
    color01: "#FFFFFF",
    color02: "#FFFFFF",
    sprite: "modules/levels-3d-preview/assets/particles/emberssmall.png",
    life: 500,
    emittersize: 1e-4,
    alpha: 0.5,
    mass: 100,
    gravity: 0,
    rate: 10,
    duration: 3e3
  },
  ray: {
    type: "ray",
    speed: 5,
    repeat: 1,
    arc: 2,
    delay: 500,
    scale: 0.7,
    color01: "#FFFFFF",
    color02: "#FFFFFF",
    sprite: "modules/levels-3d-preview/assets/particles/emberssmall.png",
    life: 500,
    emittersize: 1e-4,
    alpha: 0.5,
    mass: 100,
    gravity: 0,
    rate: 10
  },
  sprite: {
    type: "sprite",
    speed: 5,
    repeat: 1,
    delay: 0,
    scale: 0.7,
    color01: "#FFFFFF",
    sprite: "modules/levels-3d-preview/assets/particles/emberssmall.png",
    alpha: 0.7
  },
  token: {
    repeat: 1,
    resetTime: 100
  }
};
class DataSanitizer {
  static async _getAnimationData(handler, flagData) {
    if (!flagData) {
      return;
    }
    let menu = flagData.menu;
    menu = menu === "aefx" ? flagData.activeEffectType : menu;
    const data2 = {};
    data2.primary = menu === "preset" ? await this.compilePreset(flagData) : await this.compilePrimary(flagData, menu, handler), data2.secondary = flagData.secondary ? await this.compileSecondary(flagData, handler) : false, data2.sourceFX = await this.compileSource(flagData, data2.primary), data2.targetFX = flagData.target ? await this.compileTarget(flagData) : false, data2.macro = await this.compileMacro(handler, flagData);
    return data2;
  }
  static async compileMacro(handler, flagData) {
    const macro2 = flagData.macro;
    if (!macro2 || !macro2.enable || !macro2.name) {
      return false;
    }
    const isItemMacro = macro2.name.startsWith("ItemMacro");
    let itemMacro;
    if (isItemMacro) {
      itemMacro = handler.item.getMacro();
    }
    if (isItemMacro && !itemMacro.command) {
      return false;
    }
    const data2 = {
      enable: macro2.enable ?? false,
      name: isItemMacro ? itemMacro : macro2.name,
      args: this.strToObj(macro2.args),
      playWhen: macro2.playWhen ?? "0"
    };
    return data2;
  }
  static strToObj(data) {
    if (!data) {
      return [];
    }
    let obj = {};
    try {
      if (data && typeof data === "string") {
        let objStr = data.replaceAll("\n", "").match(/\{(.)+\}/g);
        eval("obj =" + objStr);
      }
      return obj || data.split(",").map((s) => s.trim());
    } catch (err) {
      return data.split(",").map((s) => s.trim());
    }
  }
  static setSound(data2, addDelay = 0, overrideRepeat = false) {
    const input = {
      enable: data2.enable ?? false,
      file: data2.file,
      delay: data2.delay ?? 0,
      startTime: data2.startTime ?? 0,
      volume: data2.volume ?? 1,
      repeat: overrideRepeat || data2.repeat || 1,
      repeatDelay: data2.repeatDelay ?? 250
    };
    if (!input.enable || !input.file) {
      return false;
    }
    let soundSeq = new Sequence({ moduleName: "Automated Animations", softFail: !game.settings.get("autoanimations", "debug") });
    let section2 = soundSeq.sound();
    section2.file(input.file);
    section2.delay(input.delay + addDelay);
    section2.startTime(input.startTime);
    section2.volume(input.volume);
    section2.repeats(input.repeat, input.repeatDelay);
    return soundSeq;
  }
  static async compilePrimary(flagData, menu, handler) {
    const topLevel = flagData || {};
    const primary2 = topLevel.primary || topLevel.data || {};
    const options2 = primary2.options || {};
    const sound2 = primary2.sound || {};
    const video2 = primary2.video || {};
    const data2 = {
      video: {
        dbSection: video2.dbSection,
        menuType: video2.menuType,
        animation: video2.animation,
        variant: video2.variant,
        color: video2.color,
        customPath: video2.enableCustom && video2.customPath ? video2.customPath : false
      },
      options: this.setPrimaryOptions(options2, menu, handler)
      //sound: this.setSound(sound),
    };
    let addSoundDelay = 0;
    if (!data2.options.isWait) {
      addSoundDelay = data2.options.delay;
    }
    data2.sound = this.setSound(sound2, addSoundDelay, handler.systemData.overrideRepeat);
    if (menu === "melee") {
      data2.meleeSwitch = this.compileMeleeSwitch(topLevel.meleeSwitch);
    }
    if (data2.video.menuType === "shieldfx" && !video2.enableCustom) {
      data2.options.isShieldFX = true;
    }
    let truePathRequired = ["static", "templatefx"];
    let returnable = ["melee", "range"];
    data2.path = await buildFile(data2.video.dbSection, data2.video, data2.video.customPath, { getTruePath: truePathRequired.some((el) => el === data2.video.dbSection), isReturnable: returnable.some((el) => el === data2.video.dbSection) });
    return data2;
  }
  static compileMeleeSwitch(switchData) {
    const topLevel = switchData || {};
    const video2 = topLevel.video || {};
    const options2 = topLevel.options || {};
    const sound2 = topLevel.sound || {};
    const data2 = {
      video: {
        dbSection: "range",
        menuType: video2.menuType,
        animation: video2.animation,
        variant: video2.variant,
        color: video2.color,
        customPath: video2.enableCustom && video2.customPath ? video2.customPath : false
      },
      options: {
        detect: options2.detect || "automatic",
        range: options2.range || 2,
        isReturning: options2.isReturning ?? false,
        switchType: options2.switchType || "on"
      },
      sound: this.setSound(sound2)
    };
    return data2;
  }
  static setPrimaryOptions(data2, type, handler) {
    switch (type) {
      case "melee":
        return {
          contrast: data2.contrast ?? 0,
          delay: data2.delay || 0,
          elevation: data2.elevation ?? 1e3,
          isAbsolute: data2.isAbsolute ?? false,
          isWait: data2.isWait ?? false,
          opacity: data2.opacity ?? 1,
          playbackRate: data2.playbackRate || 1,
          repeat: data2.repeat || 1,
          repeatDelay: data2.repeatDelay ?? 1,
          saturation: data2.saturation ?? 0,
          size: data2.size || 1,
          tint: data2.tint ?? false,
          tintColor: data2.tintColor || "#FFFFFF",
          zIndex: data2.zIndex || 1
        };
      case "range":
        return {
          animationSource: data2.animationSource ?? false,
          contrast: data2.contrast ?? 0,
          fakeLocation: handler.fakeSource(),
          delay: data2.delay || 0,
          elevation: data2.elevation ?? 1e3,
          isAbsolute: data2.isAbsolute ?? false,
          isReturning: data2.isReturning ?? false,
          isWait: data2.isWait ?? false,
          onlyX: data2.onlyX ?? false,
          opacity: data2.opacity ?? 1,
          playbackRate: data2.playbackRate || 1,
          randomOffset: data2.randomOffset ?? false,
          repeat: handler.systemData.overrideRepeat || data2.repeat || 1,
          repeatDelay: data2.repeatDelay ?? 1,
          reverse: data2.reverse ?? false,
          saturation: data2.saturation ?? 0,
          tint: data2.tint ?? false,
          tintColor: data2.tintColor || "#FFFFFF",
          zIndex: data2.zIndex || 1
        };
      case "ontoken":
        return {
          addTokenWidth: data2.addTokenWidth ?? false,
          anchor: this.convertToXY(data2.anchor, true),
          contrast: data2.contrast ?? 0,
          delay: data2.delay ?? 1,
          elevation: data2.elevation ?? 1e3,
          isAbsolute: data2.isAbsolute ?? false,
          fadeIn: data2.fadeIn ?? 250,
          fadeOut: data2.fadeOut ?? 500,
          isMasked: data2.isMasked ?? false,
          isRadius: data2.isRadius ?? false,
          isWait: data2.isWait ?? false,
          opacity: data2.opacity ?? 1,
          persistent: data2.persistent ?? false,
          playbackRate: data2.playbackRate || 1,
          playOn: data2.playOn || "default",
          repeat: data2.repeat || 1,
          repeatDelay: data2.repeatDelay ?? 1,
          saturation: data2.saturation ?? 0,
          size: data2.size || 1,
          tint: data2.tint ?? false,
          tintColor: data2.tintColor || "#FFFFFF",
          unbindAlpha: data2.unbindAlpha ?? false,
          unbindVisibility: data2.unbindVisibility ?? false,
          zIndex: data2.zIndex || 1
        };
      case "templatefx":
        return {
          aboveTemplate: data2.aboveTemplate ?? false,
          anchor: data2.anchor,
          contrast: data2.contrast ?? 0,
          delay: data2.delay ?? 1,
          elevation: data2.elevation ?? 1e3,
          isAbsolute: data2.isAbsolute ?? false,
          isMasked: data2.isMasked ?? false,
          isWait: data2.isWait ?? false,
          occlusionMode: data2.occlusionMode || "3",
          occlusionAlpha: data2.occlusionAlpha ?? 1,
          opacity: data2.opacity ?? 1,
          persistent: data2.persistent ?? false,
          persistType: data2.persistType || "sequencerground",
          playbackRate: data2.playbackRate || 1,
          removeTemplate: data2.removeTemplate ?? false,
          repeat: data2.repeat || 1,
          repeatDelay: data2.repeatDelay ?? 1,
          rotate: data2.rotate ?? 0,
          saturation: data2.saturation ?? 0,
          scale: this.convertToXY(data2.scale),
          tint: data2.tint ?? false,
          tintColor: data2.tintColor || "#FFFFFF",
          scaleX: data2.scaleX || 1,
          scaleY: data2.scaleY || 1,
          xray: data2.xray ?? false,
          zIndex: data2.zIndex || 1
        };
      case "aura":
        return {
          addTokenWidth: data2.addTokenWidth ?? false,
          alpha: data2.alpha ?? false,
          alphaDuration: data2.alphaDuration || 1e3,
          alphaMax: data2.alphaMax ?? 0.5,
          alphaMin: data2.alphaMin ?? -0.5,
          breath: data2.breath ?? false,
          breathDuration: data2.breathDuration || 1e3,
          breathMax: data2.breathMax ?? 1.05,
          breathMin: data2.breathMin ?? 0.95,
          contrast: data2.contrast ?? 0,
          delay: data2.delay || 1,
          elevation: data2.elevation ?? 1e3,
          isAbsolute: data2.isAbsolute ?? false,
          fadeIn: data2.fadeIn ?? 250,
          fadeOut: data2.fadeOut ?? 500,
          isWait: data2.isWait ?? false,
          opacity: data2.opacity ?? 1,
          playbackRate: data2.playbackRate || 1,
          playOn: data2.playOn || "source",
          size: data2.size || 3,
          tint: data2.tint ?? false,
          tintColor: data2.tintColor || "#FFFFFF",
          tintSaturate: data2.tintSaturate ?? 0,
          unbindAlpha: data2.unbindAlpha ?? false,
          unbindVisibility: data2.unbindVisibility ?? false,
          zIndex: data2.zIndex || 1
        };
    }
  }
  static convertToXY(input, isAnchor) {
    let dNum = isAnchor ? 0.5 : 1;
    if (!input) {
      return { x: dNum, y: dNum };
    }
    let parsedInput = input.split(",").map((s) => s.trim());
    let posX = Number(parsedInput[0]);
    let posY = Number(parsedInput[1]);
    if (parsedInput.length === 2) {
      return { x: isNaN(posX) ? dNum : posX, y: isNaN(posY) ? dNum : posY };
    } else if (parsedInput.length === 1) {
      return { x: isNaN(posX) ? dNum : posX, y: isNaN(posX) ? dNum : posX };
    } else {
      return { x: dNum, y: dNum };
    }
  }
  static async compileSecondary(flagData, handler) {
    const topLevel = flagData || {};
    const secondary2 = topLevel.secondary || {};
    if (!secondary2.enable) {
      return false;
    }
    const video2 = secondary2.video || {};
    const options2 = secondary2.options || {};
    const sound2 = secondary2.sound || {};
    const data2 = {
      enable: secondary2.enable ?? false,
      video: {
        dbSection: "static",
        menuType: video2.menuType,
        animation: video2.animation,
        variant: video2.variant,
        color: video2.color,
        customPath: video2.enableCustom && video2.customPath ? video2.customPath : false
      },
      options: {
        addTokenWidth: options2.addTokenWidth ?? false,
        anchor: this.convertToXY(options2.anchor, true),
        contrast: options2.contrast ?? 0,
        delay: options2.delay ?? 0,
        elevation: options2.elevation ?? 1e3,
        isAbsolute: options2.isAbsolute ?? false,
        fadeIn: options2.fadeIn ?? 250,
        fadeOut: options2.fadeOut ?? 250,
        isMasked: options2.isMasked ?? false,
        isRadius: options2.isRadius ?? false,
        isWait: options2.isWait ?? false,
        opacity: options2.opacity || 1,
        playbackRate: options2.playbackRate || 1,
        repeat: handler.systemData.overrideRepeat || options2.repeat || 1,
        repeatDelay: options2.repeatDelay ?? 250,
        rotateSource: options2.rotateSource ?? false,
        saturation: options2.saturation ?? 0,
        size: options2.size || 1,
        tint: options2.tint ?? false,
        tintColor: options2.tintColor || "#FFFFFF",
        zIndex: options2.zIndex || 1
      }
      //sound: this.setSound(sound, topLevel.primary.options),
    };
    let addSoundDelay = 0;
    if (!data2.options.isWait) {
      addSoundDelay = data2.options.delay;
    }
    data2.sound = this.setSound(sound2, addSoundDelay, handler.systemData.overrideRepeat);
    data2.path = secondary2.enable ? await buildFile("static", data2.video, data2.video.customPath) : "";
    return data2;
  }
  static async compileSource(flagData, primary2) {
    const topLevel = flagData || {};
    const source2 = topLevel.source || {};
    const video2 = source2.video || {};
    const options2 = source2.options || {};
    const sound2 = source2.sound || {};
    if (!source2.enable) {
      return false;
    }
    const data2 = {
      enable: source2.enable ?? false,
      video: {
        dbSection: "static",
        menuType: video2.menuType,
        animation: video2.animation,
        variant: video2.variant,
        color: video2.color,
        customPath: video2.enableCustom && video2.customPath ? video2.customPath : false
      },
      options: {
        animationSource: primary2?.options?.animationSource ?? false,
        fakeLocation: primary2?.options?.fakeLocation,
        addTokenWidth: options2.addTokenWidth ?? false,
        anchor: this.convertToXY(options2.anchor, true),
        contrast: options2.contrast ?? 0,
        delay: options2.delay ?? 0,
        elevation: options2.elevation ?? 1e3,
        isAbsolute: options2.isAbsolute ?? false,
        fadeIn: options2.fadeIn ?? 250,
        fadeOut: options2.fadeOut ?? 500,
        isMasked: options2.isMasked ?? false,
        isRadius: options2.isRadius ?? false,
        isWait: options2.isWait ?? false,
        opacity: options2.opacity || 1,
        persistent: options2.persistent ?? false,
        playbackRate: options2.playbackRate || 1,
        repeat: options2.repeat || 1,
        repeatDelay: options2.repeatDelay || 1,
        saturation: options2.saturation ?? 0,
        size: options2.size || 1,
        tint: options2.tint ?? false,
        tintColor: options2.tintColor || "#FFFFFF",
        zIndex: options2.zIndex || 1
      }
      //sound: this.setSound(sound)
    };
    let addSoundDelay = 0;
    if (!data2.options.isWait) {
      addSoundDelay = data2.options.delay;
    }
    data2.sound = this.setSound(sound2, addSoundDelay);
    data2.path = data2.enable ? await buildFile(data2.video.dbSection, data2.video, data2.video.customPath) : "";
    return data2;
  }
  static async compileTarget(flagData) {
    const topLevel = flagData || {};
    const target2 = topLevel.target || {};
    const video2 = target2.video || {};
    const options2 = target2.options || {};
    const sound2 = target2.sound || {};
    if (!target2.enable) {
      return false;
    }
    const data2 = {
      enable: target2.enable ?? false,
      video: {
        dbSection: "static",
        menuType: video2.menuType,
        animation: video2.animation,
        variant: video2.variant,
        color: video2.color,
        customPath: video2.enableCustom && video2.customPath ? video2.customPath : false
      },
      options: {
        addTokenWidth: options2.addTokenWidth ?? false,
        anchor: this.convertToXY(options2.anchor, true),
        contrast: options2.contrast ?? 0,
        delay: options2.delay ?? 0,
        elevation: options2.elevation ?? 1e3,
        fadeIn: options2.fadeIn ?? 250,
        fadeOut: options2.fadeOut ?? 250,
        isAbsolute: options2.isAbsolute ?? false,
        isMasked: options2.isMasked ?? false,
        //isWait: options.isWait ?? false,
        isRadius: options2.isRadius ?? false,
        opacity: options2.opacity || 1,
        playbackRate: options2.playbackRate || 1,
        persistent: options2.persistent ?? false,
        repeat: options2.repeat || 1,
        repeatDelay: options2.repeatDelay ?? 250,
        rotateSource: options2.rotateSource ?? false,
        saturation: options2.saturation ?? 0,
        size: options2.size || 1,
        tint: options2.tint ?? false,
        tintColor: options2.tintColor || "#FFFFFF",
        unbindAlpha: options2.unbindAlpha ?? false,
        unbindVisibility: options2.unbindVisibility ?? false,
        zIndex: options2.zIndex || 1
      },
      sound: this.setSound(sound2, options2.delay ?? 0)
    };
    data2.path = data2.enable ? await buildFile("static", data2.video, data2.video.customPath) : "";
    return data2;
  }
  static _targetSequence(targetFX, target2, handler, addDelay = 0) {
    if (handler.playOnMiss) {
      handler.hitTargetsId.includes(target2.id) ? true : false;
    }
    const targetTokenGS = targetFX.options.isRadius ? targetFX.options.size * 2 : target2.w / canvas.grid.size * 1.5 * targetFX.options.size;
    targetFX.targetSeq = new Sequence();
    let targetEffect2 = targetFX.targetSeq.effect();
    targetEffect2.delay(targetFX.options.delay + addDelay);
    targetEffect2.file(targetFX.path?.file, true);
    targetEffect2.atLocation(target2);
    targetEffect2.size(targetTokenGS * 1.5 * targetFX.options.size, { gridUnits: true });
    targetEffect2.repeats(targetFX.options.repeat, targetFX.options.repeatDelay);
    if (targetFX.options.elevation === 0) {
      effectAfterImage.belowTokens(true);
    } else {
      targetEffect2.elevation(targetFX.options.elevation);
    }
    if (targetFX.options.isMasked) {
      targetEffect2.mask(target2);
    }
    targetEffect2.persist(targetFX.options.persistent);
    targetEffect2.fadeOut(500);
    targetEffect2.opacity(targetFX.options.opacity);
    targetEffect2.zIndex(targetFX.options.zIndex);
    return targetFX;
  }
  static howToDelete(type) {
    if (game.settings.get("autoanimations", "noTips")) {
      return;
    }
    let disableTips = "You can disabled these tips in the Automated Animations module settings";
    switch (type) {
      case "overheadtile":
        custom_notify(`This is an OVERHEAD Tile. Use the Tile Foreground Layer to remove the Animation. ${disableTips}`);
        break;
      case "groundtile":
        custom_notify(`This is an GROUND Tile. Use the Tile Layer to remove the Animation. ${disableTips}`);
        break;
      case "sequencerground":
        custom_notify(`This is a SEQUENCER Persistent Effect. Use the Sequencer Effect Manager to remove the Animation. ${disableTips}`);
        break;
    }
  }
  static async compileParticleData(animationData) {
    const options3d = animationData.levels3d;
    if (!options3d.enable) {
      return false;
    }
    const type = options3d.type;
    const options2 = options3d.data || {};
    const tokens = options3d.tokens || {};
    const secondary2 = options3d.secondary || {};
    const defaults = particleDefaultValues[type] ?? particleDefaultValues["projectile"];
    const data2 = {
      type,
      alpha: options2.alpha ?? defaults.alpha,
      animationType: options2.animationType ?? "twirl",
      arc: options2.arc ?? defaults.arc,
      color01: options2.color01 ?? defaults.color01,
      color02: options2.color02 ?? defaults.color02,
      delay: options2.delay ?? defaults.delay,
      emittersize: options2.emittersize ?? defaults.emittersize,
      gravity: options2.gravity ?? defaults.gravity,
      life: options2.life ?? defaults.life,
      duration: options2.duration ?? defaults.duration,
      mass: options2.mass ?? defaults.mass,
      playOn: options2.playOn ?? "source",
      rate: options2.rate ?? defaults.rate,
      repeat: options2.repeat ?? defaults.repeat,
      resetTime: options2.resetTime ?? 100,
      rotateTowards: options2.rotateTowards ?? false,
      rotationX: options2.rotationX ?? 0,
      rotationY: options2.rotationY ?? 0,
      rotationZ: options2.rotationZ ?? 0,
      scale: options2.scale ?? defaults.scale,
      speed: options2.speed ?? defaults.speed,
      sprite: options2.spritePath ?? defaults.sprite,
      autoSize: options2.autoSize ?? defaults.autoSize,
      onCenter: options2.onCenter ?? defaults.onCenter,
      sound: this.setSound(options3d.sound),
      tokenAnimation: {
        enable: tokens.enable ?? false,
        source: tokens.source ?? false,
        sourceType: tokens.sourceType ?? "twirl",
        sourceStart: tokens.sourcePlay !== "end" ? true : false,
        sourceEnd: tokens.sourcePlay !== "start" ? true : false,
        target: tokens.target ?? false,
        targetType: tokens.targetType ?? "shake",
        targetStart: tokens.targetPlay !== "end" ? true : false,
        targetEnd: tokens.targetPlay !== "start" ? true : false
      },
      secondary: {
        enable: secondary2.enable || false,
        alpha: secondary2.data?.alpha ?? 0.5,
        color01: secondary2.data?.color01 ?? "#FFFFFF",
        color02: secondary2.data?.color02 ?? "#FFFFFF",
        emittersize: secondary2.data?.emittersize ?? 1,
        gravity: secondary2.data?.gravity ?? 2,
        life: secondary2.data?.life ?? 500,
        mass: secondary2.data?.mass ?? 100,
        rate: secondary2.data?.rate ?? 10,
        scale: secondary2.data?.scale ?? 1,
        speed: secondary2.data?.speed ?? 1,
        autoSize: secondary2.data?.autoSize ?? false,
        onCenter: secondary2.data?.onCenter ?? false,
        duration: secondary2.data?.duration ?? 3e3,
        type: secondary2.data?.type ?? "explosion",
        sprite: secondary2.data?.spritePath ?? particleDefaultValues.explosion.sprite
      }
    };
    return data2;
  }
  static async compilePreset(flagData) {
    const topLevel = flagData || {};
    const presetType = topLevel.presetType;
    switch (presetType) {
      case "proToTemp":
        return await proToTemp2();
      case "teleportation":
        return teleportation2();
      case "dualattach":
        return dualAttach();
      case "thunderwave":
        return thunderwave2();
    }
    async function proToTemp2() {
      const flags = topLevel.data || {};
      const projectile = flags.projectile || {};
      const projectileOptions = projectile.options || {};
      const projectileSound = projectile.sound || {};
      const preExplosion = flags.preExplosion || {};
      const preExplosionOptions = preExplosion.options || {};
      const preExplosionSound = preExplosion.sound || {};
      const explosion = flags.explosion || {};
      const explosionOptions = explosion.options || {};
      const explosionSound = explosion.sound || {};
      const afterImage = flags.afterImage || {};
      const afterImageOptions = afterImage.options || {};
      const data2 = {
        projectile: {
          dbSection: "range",
          menuType: projectile.menuType,
          animation: projectile.animation,
          variant: projectile.variant,
          color: projectile.color,
          customPath: projectile.enableCustom && projectile.customPath ? projectile.customPath : false,
          options: {
            elevation: projectileOptions.elevation || 1e3,
            isAbsolute: projectileOptions.isAbsolute ?? false,
            playbackRate: projectileOptions.playbackRate || 1,
            randomOffset: projectileOptions.randomOffset ?? false,
            repeat: projectileOptions.repeat || 1,
            repeatDelay: projectileOptions.repeatDelay || 250,
            removeTemplate: projectileOptions.removeTemplate ?? false,
            wait: projectileOptions.wait ?? -500,
            opacity: projectileOptions.opacity ?? 1
          },
          sound: setSound(projectileSound)
        },
        preExplosion: {
          dbSection: "static",
          enable: preExplosion.enable || false,
          menuType: preExplosion.menuType,
          animation: preExplosion.animation,
          variant: preExplosion.variant,
          color: preExplosion.color,
          customPath: preExplosion.enableCustom && preExplosion.customPath ? preExplosion.customPath : false,
          options: {
            aboveTemplate: preExplosionOptions.aboveTemplate ?? false,
            elevation: preExplosionOptions.elevation ?? 1e3,
            isAbsolute: preExplosionOptions.isAbsolute ?? false,
            playbackRate: preExplosionOptions.playbackRate || 1,
            repeat: preExplosionOptions.repeat || 1,
            repeatDelay: preExplosionOptions.repeatDelay || 250,
            scale: preExplosionOptions.scale || 1,
            wait: preExplosionOptions.wait ?? -500,
            opacity: preExplosionOptions.opacity ?? 1
          },
          sound: setSound(preExplosionSound)
        },
        explosion: {
          dbSection: "static",
          menuType: explosion.menuType,
          animation: explosion.animation,
          variant: explosion.variant,
          color: explosion.color,
          customPath: explosion.enableCustom && explosion.customPath ? explosion.customPath : false,
          options: {
            aboveTemplate: explosionOptions.aboveTemplate ?? false,
            elevation: explosionOptions.elevation ?? 1e3,
            isAbsolute: explosionOptions.isAbsolute ?? false,
            playbackRate: explosionOptions.playbackRate || 1,
            repeat: explosionOptions.repeat || 1,
            repeatDelay: explosionOptions.repeatDelay || 250,
            scale: explosionOptions.scale || 1,
            wait: explosionOptions.wait ?? -500,
            opacity: explosionOptions.opacity ?? 1
          },
          sound: setSound(explosionSound)
        },
        afterImage: {
          customPath: afterImage.enable && afterImage.customPath ? afterImage.customPath : false,
          enable: afterImage.enable ?? false,
          options: {
            elevation: afterImageOptions.elevation ?? 1e3,
            isAbsolute: afterImageOptions.isAbsolute ?? false,
            persistent: afterImageOptions.persistent ?? false,
            scale: afterImageOptions.scale || 1
          }
        },
        soundOnly: {
          enable: false
        }
      };
      data2.projectile.path = await buildFile(data2.projectile.dbSection, data2.projectile, data2.projectile.customPath);
      data2.preExplosion.path = await buildFile(data2.preExplosion.dbSection, data2.preExplosion, data2.preExplosion.customPath);
      data2.explosion.path = await buildFile(data2.explosion.dbSection, data2.explosion, data2.explosion.customPath);
      return data2;
    }
    function teleportation2() {
      const flags = topLevel.data || {};
      const start = flags.start || {};
      const startOptions = start.options || {};
      const between = flags.between || {};
      const betweenOptions = between.options || {};
      const end = flags.end || {};
      const endOptions = end.options || {};
      const options2 = flags.options || {};
      const sound2 = flags.sound || {};
      const data2 = {
        start: !start.enable ? false : {
          menuType: start.menuType,
          animation: start.animation,
          variant: start.variant,
          color: start.color,
          customPath: start.enableCustom && start.customPath ? start.customPath : false,
          options: {
            //alpha: startOptions.alpha ?? 0,
            delay: startOptions.delay ?? 0,
            elevation: startOptions.elevation ?? 1e3,
            isAbsolute: startOptions.isAbsolute ?? false,
            fadeIn: startOptions.fadeIn ?? 250,
            fadeOut: startOptions.fadeOut ?? 500,
            isMasked: startOptions.isMasked ?? false,
            isRadius: startOptions.isRadius ?? false,
            opacity: startOptions.opacity ?? 1,
            playbackRate: startOptions.playbackRate || 1,
            size: startOptions.size ?? 1
          }
        },
        between: !between.enable ? false : {
          menuType: between.menuType,
          animation: between.animation,
          variant: between.variant,
          color: between.color,
          customPath: between.enableCustom && between.customPath ? between.customPath : false,
          options: {
            delay: betweenOptions.delay ?? 0,
            elevation: betweenOptions.elevation ?? 1e3,
            isAbsolute: betweenOptions.isAbsolute ?? false,
            opacity: betweenOptions.opacity ?? 1,
            playbackRate: betweenOptions.playbackRate ?? 1
          }
        },
        end: !end.enable ? false : {
          menuType: end.menuType,
          animation: end.animation,
          variant: end.variant,
          color: end.color,
          customPath: end.enableCustom && end.customPath ? end.customPath : false,
          options: {
            delay: endOptions.delay ?? 0,
            elevation: endOptions.elevation ?? 1e3,
            isAbsolute: endOptions.isAbsolute ?? false,
            fadeIn: startOptions.fadeIn ?? 250,
            fadeOut: startOptions.fadeOut ?? 500,
            isMasked: endOptions.isMasked ?? false,
            isRadius: endOptions.isRadius ?? false,
            opacity: endOptions.opacity ?? 1,
            playbackRate: endOptions.playbackRate || 1,
            size: endOptions.size ?? 1
          }
        },
        options: {
          measureType: options2.measureType || "alternating",
          hideFromPlayers: options2.hideFromPlayers ?? false,
          range: options2.range ?? 30,
          teleport: options2.teleport ?? false,
          delayMove: options2.delayMove ?? 0,
          speed: options2.speed || 6,
          alpha: options2.alpha ?? 1,
          delayFade: options2.delayFade ?? 0,
          delayReturn: options2.delayReturn ?? 0,
          checkCollision: options2.checkCollision ?? false
        },
        sound: setSound(sound2)
      };
      return data2;
    }
    function dualAttach() {
      const flags = topLevel.data || {};
      const video2 = flags.video || {};
      const options2 = flags.options || {};
      const sound2 = flags.sound || {};
      const data2 = {
        video: {
          menuType: video2.menuType,
          animation: video2.animation,
          variant: video2.variant,
          color: video2.color,
          customPath: video2.enableCustom && video2.customPath ? video2.customPath : false
        },
        options: {
          elevation: options2.elevation ?? 1e3,
          isAbsolute: options2.isAbsolute ?? false,
          onlyX: options2.onlyX ?? false,
          opacity: options2.opacity ?? 1,
          playbackRate: options2.playbackRate
        },
        sound: setSound(sound2)
      };
      return data2;
    }
    function thunderwave2() {
      const flags = topLevel.data || {};
      const options2 = flags.options || {};
      const sound2 = flags.sound || {};
      const data2 = {
        color: flags.color || "blue",
        options: {
          elevation: options2.elevation ?? 1e3,
          isAbsolute: options2.isAbsolute ?? false,
          opacity: options2.opacity ?? 1,
          repeat: options2.repeat || 1,
          repeatDelay: options2.repeatDelay ?? 250,
          removeTemplate: options2.removeTemplate ?? false
        },
        sound: setSound(sound2)
      };
      return data2;
    }
    function setSound(data2, addDelay = 0) {
      const input = {
        enable: data2.enable ?? false,
        file: data2.file,
        delay: data2.delay ?? 0,
        startTime: data2.startTime ?? 0,
        volume: data2.volume ?? 1,
        repeat: data2.repeat || 1,
        repeatDelay: data2.repeatDelay ?? 250
      };
      if (!input.enable || !input.file) {
        return false;
      }
      let soundSeq = new Sequence();
      let section2 = soundSeq.sound();
      section2.file(input.file);
      section2.delay(input.delay + addDelay);
      section2.startTime(input.startTime);
      section2.volume(input.volume);
      section2.repeats(input.repeat, input.repeatDelay);
      return soundSeq;
    }
  }
}
Hooks.once("aa.ready", async (jb2a) => {
  await menuOptions(jb2a);
});
let aaReturnWeapons;
let aaRangeWeapons;
const newTypeMenu = {};
const newNameMenu = {};
const newVariantMenu = {};
const newColorMenu = {};
async function menuOptions(database) {
  aaReturnWeapons = Object.keys(database.return.weapon);
  aaRangeWeapons = Object.keys(database.range.weapon);
  const jb2a = database;
  const menuSets = ["range", "return", "melee", "static", "templatefx"];
  for (let section2 of menuSets) {
    newTypeMenu[section2] = [];
    let currentTypeArray = [];
    Object.keys(jb2a[section2]).forEach(
      function(a) {
        currentTypeArray.push(a);
      }
    );
    currentTypeArray.sort((a, b) => a.localeCompare(b));
    currentTypeArray.forEach(function(d) {
      if (!newTypeMenu[section2]) {
        newTypeMenu[section2] = [];
      }
      newTypeMenu[section2].push([d, game.i18n.localize(`autoanimations.menuTypes.${d}`)]);
    });
  }
  for (let section2 of menuSets) {
    newNameMenu[section2] = {};
    let currentNameArray = [];
    Object.keys(jb2a[section2]).forEach(
      function(a) {
        currentNameArray = [];
        Object.keys(jb2a[section2][a]).forEach(function(b) {
          currentNameArray.push(b);
        });
        currentNameArray.sort((a2, b) => a2.localeCompare(b));
        currentNameArray.forEach(function(d) {
          if (!newNameMenu[section2][a]) {
            newNameMenu[section2][a] = [];
          }
          newNameMenu[section2][a].push([d, game.i18n.localize(`autoanimations.animations.${d}`)]);
        });
      }
    );
  }
  for (let section2 of menuSets) {
    newVariantMenu[section2] = {};
    let currentVariantArray = [];
    Object.keys(jb2a[section2]).forEach(
      function(a) {
        Object.keys(jb2a[section2][a]).forEach(function(b) {
          if (!newVariantMenu[section2][a]) {
            newVariantMenu[section2][a] = {};
          }
          currentVariantArray = [];
          Object.keys(jb2a[section2][a][b]).forEach(function(c) {
            currentVariantArray.push(c);
          });
          currentVariantArray.sort((a2, b2) => a2.localeCompare(b2));
          currentVariantArray.forEach(function(d) {
            if (!newVariantMenu[section2][a][b]) {
              newVariantMenu[section2][a][b] = [];
            }
            newVariantMenu[section2][a][b].push([d, game.i18n.localize(`autoanimations.variants.${d}`)]);
          });
        });
      }
    );
  }
  for (let section2 of menuSets) {
    newColorMenu[section2] = {};
    let currentColorArray = [];
    Object.keys(jb2a[section2]).forEach(
      function(a) {
        Object.keys(jb2a[section2][a]).forEach(function(b) {
          if (!newColorMenu[section2][a]) {
            newColorMenu[section2][a] = {};
          }
          Object.keys(jb2a[section2][a][b]).forEach(function(c) {
            if (!newColorMenu[section2][a][b]) {
              newColorMenu[section2][a][b] = {};
            }
            currentColorArray = [];
            Object.keys(jb2a[section2][a][b][c]).forEach(function(d) {
              currentColorArray.push(d);
            });
            currentColorArray.sort((a2, b2) => a2.localeCompare(b2));
            currentColorArray.forEach(function(d) {
              if (!newColorMenu[section2][a][b][c]) {
                newColorMenu[section2][a][b][c] = [];
              }
              if (d === "_markers") {
                return;
              }
              newColorMenu[section2][a][b][c].push([d, game.i18n.localize(`autoanimations.colors.${d}`)]);
            });
          });
        });
      }
    );
  }
  newAddRandom();
  async function newAddRandom() {
    Object.keys(newColorMenu).forEach(function(a) {
      Object.keys(newColorMenu[a]).forEach(function(b) {
        Object.keys(newColorMenu[a][b]).forEach(function(c) {
          Object.keys(newColorMenu[a][b][c]).forEach(function(d) {
            newColorMenu[a][b][c][d].push(["random", game.i18n.localize("autoanimations.colors.random")]);
          });
        });
      });
    });
  }
  newTypeMenu.range.splice(0, 1);
  newTypeMenu.return.splice(0, 1);
  delete newNameMenu.range._template;
  delete newNameMenu.return._template;
  delete newVariantMenu.range._template;
  delete newVariantMenu.return._template;
  debug$1("Compiled Select Menus", { newTypeMenu, newNameMenu, newVariantMenu, newColorMenu });
}
async function melee$3(handler, animationData) {
  const data2 = animationData.primary;
  const secondary2 = animationData.secondary;
  const sourceFX = animationData.sourceFX;
  const targetFX = animationData.targetFX;
  const macro2 = animationData.macro;
  const sourceToken = handler.sourceToken;
  let sourceTokenGS = sourceToken.w / canvas.grid.size * 5;
  if (data2.video?.animation === "claw" || data2.video?.animation === "bite") {
    sourceTokenGS = sourceToken.w / canvas.grid.size;
  }
  const switchDisabled = game.settings.get("autoanimations", "rangeSwitch");
  const switchReturn = data2.meleeSwitch.options.switchType === "on" && aaReturnWeapons.includes(data2.video.animation) ? data2.meleeSwitch.options.isReturning : data2.meleeSwitch.options.switchType === "custom" && aaReturnWeapons.includes(data2.meleeSwitch.video.animation) ? data2.meleeSwitch.options.isReturning : false;
  let range2 = {};
  if (data2.meleeSwitch.options.switchType === "on") {
    range2 = aaRangeWeapons.includes(data2.video.animation) && !data2.video.customPath ? await buildFile("range", data2.video, false, { isReturnable: true }) : {};
  } else if (data2.meleeSwitch.options.switchType === "custom") {
    range2 = !data2.meleeSwitch?.video?.customPath ? await buildFile("range", data2.meleeSwitch.video, data2.meleeSwitch.video.customPath, { isReturnable: true }) : {};
  }
  let switchDistance = 5;
  if (handler.systemId === "swade") {
    switchDistance = 1;
  }
  if (handler.systemId === "alienrpg") {
    switchDistance = canvas.grid.distance * 1.5;
  }
  let rangeArray = [];
  let meleeArray = [];
  for (let target2 of handler.allTargets) {
    let distanceTo = handler.getDistance(target2);
    let rangeDistance = data2.meleeSwitch.options.detect === "manual" ? data2.meleeSwitch.options.range : switchDistance / canvas.dimensions.distance + handler.reachCheck;
    let hit = !handler.playOnMiss ? true : handler.hitTargetsId.includes(target2.id) ? true : false;
    if (distanceTo > rangeDistance && range2.file && !switchDisabled) {
      rangeArray.push({
        token: target2,
        hit
      });
    } else {
      meleeArray.push({
        token: target2,
        moveTo: distanceTo > rangeDistance ? true : false,
        hit
      });
    }
  }
  let aaSeq = await new Sequence(handler.sequenceData);
  if (macro2 && macro2.playWhen === "1") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.sound && meleeArray.length > 0) {
    aaSeq.addSequence(data2.sound);
  }
  aaSeq.thenDo(function() {
    Hooks.callAll("aa.animationStart", sourceToken, handler.allTargets);
  });
  if (meleeArray.length) {
    for (let i = 0; i < meleeArray.length; i++) {
      let currentTarget = meleeArray[i];
      let meleeSeq = aaSeq.effect();
      meleeSeq.file(data2.path.file);
      meleeSeq.opacity(data2.options.opacity);
      meleeSeq.atLocation(sourceToken);
      if (currentTarget.moveTo) {
        meleeSeq.moveTowards(currentTarget.token);
      } else {
        meleeSeq.rotateTowards(currentTarget.token);
        meleeSeq.anchor({ x: 0.4, y: 0.5 });
      }
      meleeSeq.size(sourceTokenGS * data2.options.size, { gridUnits: true });
      meleeSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
      meleeSeq.randomizeMirrorY();
      meleeSeq.missed(!currentTarget.hit);
      meleeSeq.name(`spot ${currentTarget.token.id}`);
      if (data2.options.elevation === 0) {
        meleeSeq.belowTokens(true);
      } else {
        meleeSeq.elevation(handler.elevation(sourceToken, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
      }
      meleeSeq.zIndex(data2.options.zIndex);
      if (data2.options.tint) {
        meleeSeq.tint(data2.options.tintColor);
        meleeSeq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
      }
      if (i === meleeArray.length - 1 && data2.options.isWait) {
        meleeSeq.waitUntilFinished(data2.options.delay);
      } else if (!data2.options.isWait) {
        meleeSeq.delay(data2.options.delay);
      }
      meleeSeq.playbackRate(data2.options.playbackRate);
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, meleeArray.map((e) => e.token), targetFX.enable, true);
    }
    if (targetFX) {
      handler.compileTargetEffect(targetFX, aaSeq, meleeArray.map((e) => e.token), true);
    }
  }
  if (rangeArray.length) {
    if (data2.meleeSwitch?.sound) {
      aaSeq.addSequence(data2.meleeSwitch.sound);
    }
    for (let i = 0; i < rangeArray.length; i++) {
      let currentTarget = rangeArray[i];
      let rangeSeq = aaSeq.effect();
      rangeSeq.file(range2.file);
      rangeSeq.atLocation(sourceToken);
      rangeSeq.stretchTo(currentTarget.token);
      rangeSeq.opacity(data2.options.opacity);
      rangeSeq.zIndex(data2.options.zIndex);
      rangeSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
      rangeSeq.missed(!currentTarget.hit);
      rangeSeq.name(`spot ${currentTarget.token.id}`);
      if (data2.options.elevation === 0) {
        rangeSeq.belowTokens(true);
      } else {
        rangeSeq.elevation(handler.elevation(sourceToken, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
      }
      rangeSeq.playbackRate(data2.options.playbackRate);
      if (data2.options.tint) {
        rangeSeq.tint(data2.options.tintColor);
        rangeSeq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
      }
      if (i === rangeArray.length - 1 && data2.options.isWait) {
        rangeSeq.waitUntilFinished(data2.options.delay);
      } else if (!data2.options.isWait) {
        rangeSeq.delay(data2.options.delay);
      }
    }
    if (switchReturn) {
      for (let i = 0; i < rangeArray.length; i++) {
        let currentTarget = rangeArray[i].token;
        let returnSeq = aaSeq.effect();
        returnSeq.file(range2.returnFile);
        returnSeq.opacity(data2.options.opacity);
        returnSeq.atLocation(sourceToken);
        returnSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
        returnSeq.stretchTo(`spot ${currentTarget.id}`);
        returnSeq.zIndex(data2.options.zIndex);
        returnSeq.playbackRate(data2.options.playbackRate);
        if (data2.options.tint) {
          returnSeq.tint(data2.options.tintColor);
          returnSeq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
        }
      }
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, rangeArray.map((e) => e.token), targetFX.enable, true);
    }
    if (targetFX) {
      handler.compileTargetEffect(targetFX, aaSeq, rangeArray.map((e) => e.token), true);
    }
  }
  if (macro2 && macro2.playWhen === "0") {
    handler.runMacro(macro2);
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
}
const wait$3 = (delay) => new Promise((resolve) => setTimeout(resolve, delay));
async function range$3(handler, animationData) {
  const data2 = animationData.primary;
  const secondary2 = animationData.secondary;
  const sourceFX = animationData.sourceFX;
  const targetFX = animationData.targetFX;
  const macro2 = animationData.macro;
  const sourceToken = handler.sourceToken;
  const onlyX = data2.enableCustom ? data2.onlyX : false;
  const switchReturn = aaReturnWeapons.includes(data2.video.animation) && !data2.video.enableCustom ? data2.options.isReturning : false;
  switch (true) {
    case data2.video.animation.includes("dagger"):
    case data2.video.animation.includes("hammer"):
      break;
  }
  let aaSeq = await new Sequence(handler.sequenceData);
  if (macro2 && macro2.playWhen === "1") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.sound) {
    aaSeq.addSequence(data2.sound);
  }
  aaSeq.thenDo(function() {
    Hooks.callAll("aa.animationStart", sourceToken, handler.allTargets);
  });
  for (let i = 0; i < handler.allTargets.length; i++) {
    let currentTarget = handler.allTargets[i];
    let hit;
    if (handler.playOnMiss) {
      hit = handler.hitTargetsId.includes(currentTarget.id) ? true : false;
    } else {
      hit = true;
    }
    let nextSeq = aaSeq.effect();
    nextSeq.file(data2.path.file);
    if (data2.options.animationSource) {
      nextSeq.atLocation({ x: data2.options.fakeLocation.x, y: data2.options.fakeLocation.y });
    } else {
      if (data2.options.reverse) {
        nextSeq.atLocation(currentTarget);
      } else {
        nextSeq.atLocation(sourceToken);
      }
    }
    if (data2.options.reverse) {
      nextSeq.stretchTo(sourceToken, { onlyX, randomOffset: data2.options.randomOffset });
    } else {
      nextSeq.stretchTo(currentTarget, { onlyX, randomOffset: data2.options.randomOffset });
    }
    nextSeq.randomizeMirrorY();
    nextSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
    nextSeq.opacity(data2.options.opacity);
    nextSeq.missed(!hit || handler.systemData.forceMiss || false);
    nextSeq.name(`spot ${currentTarget.id}`);
    if (data2.options.elevation === 0) {
      nextSeq.belowTokens(true);
    } else {
      nextSeq.elevation(handler.elevation(sourceToken, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
    }
    nextSeq.zIndex(data2.options.zIndex);
    if (data2.options.tint) {
      nextSeq.tint(data2.options.tintColor);
      nextSeq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
    }
    if (i === handler.allTargets.length - 1 && data2.options.isWait) {
      nextSeq.waitUntilFinished(data2.options.delay);
    } else if (!data2.options.isWait) {
      nextSeq.delay(data2.options.delay);
    }
    nextSeq.playbackRate(data2.options.playbackRate);
  }
  if (switchReturn) {
    for (let i = 0; i < handler.allTargets.length; i++) {
      let currentTarget = handler.allTargets[i];
      let returnSeq = aaSeq.effect();
      returnSeq.file(data2.path.returnFile);
      returnSeq.opacity(data2.options.opacity);
      returnSeq.atLocation(sourceToken);
      returnSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
      returnSeq.stretchTo(`spot ${currentTarget.id}`);
      returnSeq.zIndex(data2.options.zIndex);
      returnSeq.playbackRate(data2.options.playbackRate);
      if (data2.options.tint) {
        returnSeq.tint(data2.options.tintColor);
        returnSeq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
      }
    }
  }
  if (secondary2) {
    handler.compileSecondaryEffect(secondary2, aaSeq, handler.allTargets, targetFX.enable, true);
  }
  if (targetFX) {
    handler.compileTargetEffect(targetFX, aaSeq, handler.allTargets, true);
  }
  if (macro2 && macro2.playWhen === "0") {
    handler.runMacro(macro2);
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
  await wait$3(handler.animEnd);
  Hooks.callAll("aa.animationEnd", sourceToken, handler.allTargets);
}
async function ontoken$3(handler, animationData) {
  const sourceToken = handler.sourceToken;
  const data2 = animationData.primary;
  const secondary2 = animationData.secondary;
  const sourceFX = animationData.sourceFX;
  const targetFX = animationData.targetFX;
  const macro2 = animationData.macro;
  const sourceSize = handler.getSize(data2.options.isRadius, data2.options.size, sourceToken, data2.options.addTokenWidth);
  const aaSeq = await new Sequence(handler.sequenceData);
  const bottomAnim = data2.path.filePath?.replace("Above", "Below");
  let newTargetArray = [];
  for (let target2 of handler.allTargets) {
    let checkAnim = Sequencer.EffectManager.getEffects({ object: target2, origin: handler.itemUuid }).length > 0;
    if (!checkAnim) {
      newTargetArray.push(target2);
    }
  }
  if (macro2 && macro2.playWhen === "1") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.sound) {
    aaSeq.addSequence(data2.sound);
  }
  aaSeq.thenDo(function() {
    Hooks.callAll("aa.animationStart", sourceToken, handler.allTargets);
  });
  if (data2.options.playOn === "source" || data2.options.playOn === "default" && handler.allTargets.length < 1) {
    const sourceCheckAnim = Sequencer.EffectManager.getEffects({ object: sourceToken, origin: handler.itemUuid }).length > 0;
    if (sourceCheckAnim) {
      return;
    }
    if (data2.options.isShieldFX) {
      let bottomEffect2 = aaSeq.effect();
      if (handler.isActiveEffect) {
        bottomEffect2.name(handler.itemName + `${sourceToken.id}`);
      } else {
        bottomEffect2.name(`spot ${sourceToken.id}`);
      }
      setBottom(sourceToken, sourceSize, bottomEffect2);
      let topEffect = aaSeq.effect();
      if (handler.isActiveEffect) {
        topEffect.name(handler.itemName + `${sourceToken.id}`);
      } else {
        topEffect.name(`spot ${sourceToken.id}`);
      }
      setTop(sourceToken, sourceSize, topEffect);
      if (data2.options.isWait) {
        topEffect.waitUntilFinished(data2.options.wait);
      }
    } else {
      let aaEffect = aaSeq.effect();
      if (handler.isActiveEffect) {
        aaEffect.name(handler.itemName + `${sourceToken.id}`);
      } else {
        aaEffect.name(`spot ${sourceToken.id}`);
      }
      setPrimary(sourceToken, sourceSize, aaEffect);
      if (data2.options.isWait) {
        aaEffect.waitUntilFinished(data2.options.delay);
      }
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, [sourceToken], false, false);
    }
  }
  if ((data2.options.playOn === "target" || data2.options.playOn === "default") && handler.allTargets.length > 0) {
    if (newTargetArray.length < 1) {
      return;
    }
    for (let i = 0; i < newTargetArray.length; i++) {
      let currentTarget = newTargetArray[i];
      let targetSize = handler.getSize(data2.options.isRadius, data2.options.size, currentTarget, data2.options.addTokenWidth);
      if (handler.playOnMiss) {
        handler.hitTargetsId.includes(currentTarget.id) ? true : false;
      }
      if (data2.options.isShieldFX) {
        let bottomEffect2 = aaSeq.effect();
        bottomEffect2.name(`spot ${currentTarget.id}`);
        setBottom(currentTarget, targetSize, bottomEffect2);
        let topEffect = aaSeq.effect();
        topEffect.name(`spot ${currentTarget.id}`);
        setTop(currentTarget, targetSize, topEffect);
        if (i === newTargetArray.length - 1 && data2.options.isWait) {
          topEffect.waitUntilFinished(data2.options.delay);
        } else if (!data2.options.isWait) {
          topEffect.delay(data2.options.delay);
        }
      } else {
        let aaEffect = aaSeq.effect();
        aaEffect.name(`spot ${currentTarget.id}`);
        setPrimary(currentTarget, targetSize, aaEffect);
        if (i === newTargetArray.length - 1 && data2.options.isWait) {
          aaEffect.waitUntilFinished(data2.options.delay);
        } else if (!data2.options.isWait) {
          aaEffect.delay(data2.options.delay);
        }
      }
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, newTargetArray, targetFX.enable, true);
    }
    if (targetFX) {
      handler.compileTargetEffect(targetFX, aaSeq, handler.allTargets, true);
    }
  }
  if (data2.options.playOn === "both") {
    const sourceCheckAnim = Sequencer.EffectManager.getEffects({ object: sourceToken, origin: handler.itemUuid }).length > 0;
    let newTargetArray2 = [];
    for (let target2 of handler.allTargets) {
      let checkAnim = Sequencer.EffectManager.getEffects({ object: target2, origin: handler.itemUuid }).length > 0;
      if (!checkAnim) {
        newTargetArray2.push(target2);
      }
    }
    if (sourceCheckAnim && newTargetArray2.length < 1) {
      return;
    }
    if (!sourceCheckAnim) {
      if (data2.options.isShieldFX) {
        let bottomEffect2 = aaSeq.effect();
        bottomEffect2.name(`spot ${sourceToken.id}`);
        setBottom(sourceToken, sourceSize, bottomEffect2);
        let topEffect = aaSeq.effect();
        topEffect.name(`spot ${sourceToken.id}`);
        setTop(sourceToken, sourceSize, topEffect);
        if (newTargetArray2.length < 1 && data2.options.isWait) {
          topEffect.waitUntilFinished(data2.options.delay);
        } else if (!data2.options.isWait) {
          topEffect.delay(data2.options.delay);
        }
      } else {
        let aaEffect = aaSeq.effect();
        aaEffect.name(`spot ${sourceToken.id}`);
        setPrimary(sourceToken, sourceSize, aaEffect);
        if (newTargetArray2.length < 1 && data2.options.isWait) {
          aaEffect.waitUntilFinished(data2.options.delay);
        } else if (!data2.options.isWait) {
          aaEffect.delay(data2.options.delay);
        }
      }
    }
    if (newTargetArray2.length) {
      for (let i = 0; i < newTargetArray2.length; i++) {
        let currentTarget = newTargetArray2[i];
        let targetSize = handler.getSize(data2.options.isRadius, data2.options.size, currentTarget, data2.options.addTokenWidth);
        if (handler.playOnMiss) {
          handler.hitTargetsId.includes(currentTarget.id) ? true : false;
        }
        if (data2.options.isShieldFX) {
          let bottomEffect2 = aaSeq.effect();
          bottomEffect2.name(`spot ${currentTarget.id}`);
          setBottom(currentTarget, targetSize, bottomEffect2);
          let topEffect = aaSeq.effect();
          topEffect.name(`spot ${currentTarget.id}`);
          setTop(currentTarget, targetSize, topEffect);
          if (i === newTargetArray2.length - 1 && data2.options.isWait) {
            topEffect.waitUntilFinished(data2.options.delay);
          } else if (!data2.options.isWait) {
            topEffect.delay(data2.options.delay);
          }
        } else {
          let aaEffect = aaSeq.effect();
          aaEffect.name(`spot ${currentTarget.id}`);
          setPrimary(currentTarget, targetSize, aaEffect);
          if (i === newTargetArray2.length - 1 && data2.options.isWait) {
            aaEffect.waitUntilFinished(data2.options.delay);
          } else if (!data2.options.isWait) {
            aaEffect.delay(data2.options.delay);
          }
        }
      }
    }
    if (secondary2 && !sourceCheckAnim) {
      handler.compileSecondaryEffect(secondary2, aaSeq, [sourceToken], false, false);
    }
    if (newTargetArray2.length) {
      if (secondary2) {
        handler.compileSecondaryEffect(secondary2, aaSeq, newTargetArray2, targetFX.enable, true);
      }
      if (targetFX) {
        handler.compileTargetEffect(targetFX, aaSeq, handler.allTargets, true);
      }
    }
  }
  function setBottom(token, size, seq) {
    seq.file(bottomAnim);
    seq.opacity(data2.options.opacity);
    seq.size(size, { gridUnits: true });
    seq.elevation(token.document?.elevation - 1);
    if (data2.options.isMasked) {
      bottomEffect.mask(token);
    }
    seq.rotate(180);
    seq.fadeIn(250);
    seq.fadeOut(500);
    if (data2.options.tint) {
      seq.tint(data2.options.tintColor);
      seq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
    }
    if (!data2.options.persistent) {
      seq.atLocation(token);
      seq.repeats(data2.options.repeat, data2.options.repeatDelay);
    }
    if (data2.options.persistent) {
      seq.attachTo(token, { bindAlpha: data2.options.unbindAlpha, bindVisibility: data2.options.unbindVisibility });
      seq.persist(true, { persistTokenPrototype: true });
      seq.origin(handler.itemUuid);
    }
    seq.playbackRate(data2.options.playbackRate);
    if (handler.systemData.tieToDocuments) {
      seq.tieToDocuments(handler.item);
    }
  }
  function setTop(token, size, seq) {
    seq.file(data2.path.filePath);
    seq.opacity(data2.options.opacity);
    seq.size(size, { gridUnits: true });
    seq.elevation(token.document?.elevation);
    if (data2.options.isMasked) {
      seq.mask(token);
    }
    seq.fadeIn(250);
    seq.fadeOut(500);
    if (data2.options.tint) {
      seq.tint(data2.options.tintColor);
      seq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
    }
    if (!data2.options.persistent) {
      seq.atLocation(token);
      seq.repeats(data2.options.repeat, data2.options.repeatDelay);
    }
    if (data2.options.persistent) {
      seq.attachTo(token, { bindAlpha: data2.options.unbindAlpha, bindVisibility: data2.options.unbindVisibility });
      seq.persist(true, { persistTokenPrototype: true });
      seq.origin(handler.itemUuid);
    }
    seq.playbackRate(data2.options.playbackRate);
    if (handler.systemData.tieToDocuments) {
      seq.tieToDocuments(handler.item);
    }
  }
  function setPrimary(token, size, seq) {
    seq.file(data2.path.file);
    seq.opacity(data2.options.opacity);
    seq.size(size, { gridUnits: true });
    if (data2.options.elevation === 0) {
      seq.belowTokens(true);
    } else {
      seq.elevation(handler.elevation(token, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
    }
    if (data2.options.isMasked) {
      seq.mask(token);
    }
    seq.zIndex(data2.options.zIndex);
    if (data2.options.tint) {
      seq.tint(data2.options.tintColor);
      seq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
    }
    if (!data2.options.persistent) {
      seq.atLocation(token);
      seq.repeats(data2.options.repeat, data2.options.repeatDelay);
      seq.fadeIn(data2.options.fadeIn);
      seq.fadeOut(data2.options.fadeOut);
    }
    if (data2.options.persistent) {
      seq.fadeIn(data2.options.fadeIn);
      if (data2.video.variant === "complete" || data2.video.animation === "complete") ;
      else {
        seq.fadeOut(data2.options.fadeOut);
      }
      seq.attachTo(token, { bindAlpha: data2.options.unbindAlpha, bindVisibility: data2.options.unbindVisibility });
      seq.persist(true, { persistTokenPrototype: true });
      seq.origin(handler.itemUuid);
    }
    seq.anchor({ x: data2.options.anchor.x, y: data2.options.anchor.y });
    seq.playbackRate(data2.options.playbackRate);
    if (handler.systemData.tieToDocuments) {
      seq.tieToDocuments(handler.item);
    }
  }
  if (macro2 && macro2.playWhen === "0") {
    handler.runMacro(macro2);
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
  Hooks.callAll("aa.animationEnd", sourceToken, handler.allTargets);
  if (data2.options.persistent) {
    howToDelete("sequencerground");
  }
}
var socketlibSocket = void 0;
let setupSocket = () => {
  if (game.modules.get("socketlib")?.active) {
    socketlibSocket = window.socketlib.registerModule("autoanimations");
    socketlibSocket.register("placeTile", placeTile);
    socketlibSocket.register("removeTile", removeTile);
    socketlibSocket.register("checkSettings", checkSettings);
  }
};
async function placeTile(data2) {
  await canvas.scene.createEmbeddedDocuments("Tile", [data2]);
}
async function removeTile(data2) {
  await canvas.scene.deleteEmbeddedDocuments("Tile", data2);
}
async function checkSettings() {
  let photoSensitive = game.settings.get("core", "photosensitiveMode");
  let sequencerPermissions = game.settings.get("sequencer", "permissions-effect-create");
  let sequencerEffectsEnabled = game.settings.get("sequencer", "effectsEnabled");
  let sequencerSoundsEnabled = game.settings.get("sequencer", "soundsEnabled");
  let aaEffectsEnabled = game.settings.get("autoanimations", "killAllAnim") === "off" ? false : true;
  let aaAutorecDisabled = game.settings.get("autoanimations", "disableAutoRec");
  return {
    coreSettings: { photoSensitive },
    sequencerSettings: { permission: sequencerPermissions, effects: sequencerEffectsEnabled, sounds: sequencerSoundsEnabled },
    aaSettings: { effects: aaEffectsEnabled, autorec: aaAutorecDisabled }
  };
}
const wait$2 = (delay) => new Promise((resolve) => setTimeout(resolve, delay));
async function templatefx$3(handler, animationData, templateDocument) {
  const sourceToken = handler.sourceToken;
  const template = handler.templateData ? handler.templateData : templateDocument;
  const templateType = template?.t;
  const data2 = animationData.primary;
  const secondary2 = animationData.secondary;
  const sourceFX = animationData.sourceFX;
  const targetFX = animationData.targetFX;
  const macro2 = animationData.macro;
  let aaSeq = await new Sequence(handler.sequenceData);
  if (data2.options.persistent && data2.options.persistType !== "attachtemplate" || !data2.options.persistent) {
    aaSeq.thenDo(function() {
      if (data2.options.removeTemplate) {
        canvas.scene.deleteEmbeddedDocuments("MeasuredTemplate", [template.id]);
      }
    });
  }
  if (macro2 && macro2.playWhen === "1" && !macro2?.args?.warpgateTemplate) {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.sound) {
    aaSeq.addSequence(data2.sound);
  }
  aaSeq.thenDo(function() {
    Hooks.callAll("aa.animationStart", sourceToken, "no-target");
  });
  if (data2.options.persistent && (data2.options.persistType === "overheadtile" || data2.options.persistType === "groundtile")) {
    let trueSize;
    if (templateType === "rect") {
      trueSize = template.width;
    } else {
      trueSize = template.distance * 2;
    }
    const templateLength = canvas.grid.size * (trueSize / canvas.dimensions.distance);
    const isOverhead = data2.options.persistType === "overheadtile" ? true : false;
    const tileWidth = templateLength * data2.options.scale.x;
    const tileHeight = templateLength * data2.options.scale.y;
    const tileX = templateType === "circle" ? template.x - tileWidth / 2 : template.x + (templateLength - tileWidth) / 2;
    const tileY = templateType === "circle" ? template.y - tileHeight / 2 : template.y + (templateLength - tileHeight) / 2;
    const templateObject = buildTile(tileX, tileY, isOverhead, tileWidth, tileHeight);
    aaSeq.thenDo(function() {
      socketlibSocket.executeAsGM("placeTile", templateObject);
    });
  } else {
    const templateSeq = aaSeq.effect();
    if (templateType === "cone" || templateType === "ray") {
      const trueHeight = templateType === "cone" ? template.distance : template.width * 2;
      setPrimary(templateSeq);
      templateSeq.size({
        width: canvas.grid.size * (template.distance / canvas.dimensions.distance) * data2.options.scale.x,
        height: canvas.grid.size * (trueHeight / canvas.dimensions.distance) * data2.options.scale.y
      });
      if (data2.options.isMasked) {
        templateSeq.mask(template);
      }
      if (data2.options.persistent) {
        templateSeq.persist(true);
        if (data2.options.persistType === "attachtemplate") {
          templateSeq.attachTo(template);
          templateSeq.rotateTowards(template, { attachTo: true });
        } else {
          templateSeq.atLocation(template, { cacheLocation: true });
          templateSeq.rotateTowards(template, { cacheLocation: true });
        }
      } else {
        templateSeq.atLocation(template, { cacheLocation: true });
        templateSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
        templateSeq.rotateTowards(template, { cacheLocation: true });
      }
      if (!data2.options.isWait) {
        templateSeq.delay(data2.options.delay);
      }
    }
    if (templateType === "circle" || templateType === "rect") {
      let trueSize;
      if (templateType === "rect") {
        trueSize = Math.sqrt(Math.pow(template.distance, 2) / 2);
      } else {
        trueSize = template.distance * 2;
      }
      setPrimary(templateSeq);
      templateSeq.size({
        width: canvas.grid.size * (trueSize / canvas.dimensions.distance) * data2.options.scale.x,
        height: canvas.grid.size * (trueSize / canvas.dimensions.distance) * data2.options.scale.y
      });
      if (data2.options.persistent) {
        templateSeq.persist(true);
        if (data2.options.persistType === "attachtemplate") {
          templateSeq.attachTo(template, { followRotation: true });
        } else {
          templateSeq.atLocation(template, { cacheLocation: true });
          templateSeq.persist();
        }
      } else {
        templateSeq.atLocation(template, { cacheLocation: true });
        templateSeq.repeats(data2.options.repeat, data2.options.repeatDelay);
      }
      if (!data2.options.isWait) {
        templateSeq.delay(data2.options.delay);
      }
    }
  }
  if (handler.allTargets.length > 0 && data2.options.isWait) {
    aaSeq.wait(data2.options.delay || 250);
  }
  if (secondary2) {
    handler.compileSecondaryEffect(secondary2, aaSeq, handler.allTargets, targetFX.enable, false);
  }
  if (targetFX) {
    handler.compileTargetEffect(targetFX, aaSeq, handler.allTargets, false);
  }
  if (macro2 && macro2.playWhen === "0" && !macro2?.args?.warpgateTemplate) {
    handler.runMacro(macro2);
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
  if (data2.options.persistent) {
    switch (data2.options.persistType) {
      case "overheadtile":
        howToDelete("overheadtile");
        break;
      case "groundtile":
        howToDelete("groundtile");
        break;
      case "sequencerground":
        howToDelete("sequencerground");
        break;
    }
  }
  await wait$2(500);
  Hooks.callAll("aa.animationEnd", sourceToken, "no-target");
  function setPrimary(seq) {
    seq.anchor(convertToXY(data2.options.anchor));
    seq.file(data2.path.file);
    seq.opacity(data2.options.opacity);
    seq.origin(handler.itemUuid);
    if (data2.options.elevation === 0) {
      seq.belowTokens(true);
    } else {
      seq.elevation(handler.elevation(sourceToken, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
    }
    seq.zIndex(data2.options.zIndex);
    seq.rotate(data2.options.rotate);
    if (data2.options.isMasked) {
      seq.mask(template);
    }
    seq.playbackRate(data2.options.playbackRate);
    seq.name(handler.rinsedName);
    seq.aboveLighting(data2.options.aboveTemplate);
    seq.xray(data2.options.xray);
    if (data2.options.tint) {
      seq.tint(data2.options.tintColor);
      seq.filter("ColorMatrix", { contrast: data2.options.contrast, saturate: data2.options.saturation });
    }
    function convertToXY(input) {
      let menuType = data2.video.menuType;
      let templateType2 = template.t;
      let defaultAnchor = templateType2 === "circle" || templateType2 === "rect" ? { x: 0.5, y: 0.5 } : { x: 0, y: 0.5 };
      if (!input) {
        return defaultAnchor;
      }
      let dNum = menuType === "cone" || menuType === "ray" ? input || "0, 0.5" : input || "0.5, 0.5";
      let parsedInput = dNum.split(",").map((s) => s.trim());
      let posX = Number(parsedInput[0]);
      let posY = Number(parsedInput[1]);
      if (parsedInput.length === 2) {
        return { x: posX, y: posY };
      } else if (parsedInput.length === 1) {
        return { x: posX, y: posX };
      }
    }
  }
  function buildTile(tileX, tileY, isOverhead, tileWidth, tileHeight) {
    return {
      alpha: data2.options.opacity,
      width: tileWidth,
      height: tileHeight,
      img: data2.path.filePath,
      texture: { src: data2.path.filePath },
      // v12 uses this instead of img:
      overhead: isOverhead,
      // false sets Tile in canvas.background. true sets Tile to canvas.foreground
      occlusion: {
        alpha: `${data2.options.occlusionAlpha}`,
        mode: data2.options.occlusionMode
      },
      video: {
        autoplay: true,
        loop: true,
        volume: 0
      },
      flags: {
        autoanimations: {
          origin: handler.itemUuid
        }
      },
      x: tileX,
      y: tileY,
      z: 100
    };
  }
}
async function aura$3(handler, animationData) {
  const data2 = animationData.primary;
  const secondary2 = animationData.secondary;
  const sourceFX = animationData.sourceFX;
  const targetFX = animationData.targetFX;
  const macro2 = animationData.macro;
  const sourceToken = handler.sourceToken;
  for (let target2 of handler.allTargets) {
    Sequencer.EffectManager.getEffects({ object: target2, origin: handler.itemUuid }).length > 0;
  }
  let aaSeq = new Sequence(handler.sequenceData);
  if (macro2 && macro2.playWhen === "1") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.sound) {
    aaSeq.addSequence(data2.sound);
  }
  aaSeq.thenDo(function() {
    Hooks.callAll("aa.animationStart", handler);
  });
  if (data2.options.playOn === "source" || data2.options.playOn === "default" && handler.allTargets.length < 1) {
    const sourceCheckAnim = Sequencer.EffectManager.getEffects({ object: sourceToken, origin: handler.itemUuid }).length > 0;
    if (sourceCheckAnim) {
      return;
    }
    let aaEffect = aaSeq.effect();
    if (handler.isActiveEffect) {
      aaEffect.name(handler.itemName + `${sourceToken.id}`);
    } else {
      aaEffect.name(`spot ${sourceToken.id}`);
    }
    setPrimary(sourceToken, aaEffect);
    if (data2.options.isWait) {
      aaEffect.waitUntilFinished(data2.options.delay);
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, [sourceToken], false, false);
    }
  }
  if ((data2.options.playOn === "target" || data2.options.playOn === "default") && handler.allTargets.length > 0) {
    let newTargetArray = [];
    for (let target2 of handler.allTargets) {
      let checkAnim = Sequencer.EffectManager.getEffects({ object: target2, origin: handler.itemUuid }).length > 0;
      if (!checkAnim) {
        newTargetArray.push(target2);
      }
    }
    if (newTargetArray.length < 1) {
      return;
    }
    for (let i = 0; i < newTargetArray.length; i++) {
      let currentTarget = newTargetArray[i];
      let aaEffect = aaSeq.effect();
      setPrimary(currentTarget, aaEffect);
      if (i === newTargetArray.length - 1 && data2.options.isWait) {
        aaEffect.waitUntilFinished(data2.options.delay);
      } else if (!data2.options.isWait) {
        aaEffect.delay(data2.options.delay);
      }
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, newTargetArray, targetFX.enable, false);
    }
    if (targetFX) {
      handler.compileTargetEffect(targetFX, aaSeq, newTargetArray, false);
    }
  }
  if (data2.options.playOn === "both") {
    const sourceCheckAnim = Sequencer.EffectManager.getEffects({ object: sourceToken, origin: handler.itemUuid }).length > 0;
    let newTargetArray = [];
    for (let target2 of handler.allTargets) {
      let checkAnim = Sequencer.EffectManager.getEffects({ object: target2, origin: handler.itemUuid }).length > 0;
      if (!checkAnim) {
        newTargetArray.push(target2);
      }
    }
    if (sourceCheckAnim && newTargetArray.length < 1) {
      return;
    }
    if (!sourceCheckAnim) {
      let aaEffect = aaSeq.effect();
      setPrimary(sourceToken, aaEffect);
      if (handler.allTargets.length < 1 && data2.options.isWait) {
        aaEffect.waitUntilFinished(data2.options.delay);
      } else if (!data2.options.isWait) {
        aaEffect.delay(data2.options.delay);
      }
    }
    if (newTargetArray.length > 0) {
      for (let i = 0; i < newTargetArray.length; i++) {
        let currentTarget = newTargetArray[i];
        let aaEffect = aaSeq.effect();
        setPrimary(currentTarget, aaEffect);
        if (i === newTargetArray.length - 1 && data2.options.isWait) {
          aaEffect.waitUntilFinished(data2.options.delay);
        } else if (!data2.options.isWait) {
          aaEffect.delay(data2.options.delay);
        }
      }
    }
    if (secondary2) {
      handler.compileSecondaryEffect(secondary2, aaSeq, [sourceToken], false, false);
    }
    if (newTargetArray.length > 0) {
      if (secondary2) {
        handler.compileSecondaryEffect(secondary2, aaSeq, newTargetArray, targetFX.enable, false);
      }
      if (targetFX) {
        handler.compileTargetEffect(targetFX, aaSeq, newTargetArray, false);
      }
    }
  }
  function setPrimary(token, seq) {
    const size = handler.getSize(true, data2.options.size, token, data2.options.addTokenWidth);
    seq.file(data2.path.file);
    seq.persist(true, { persistTokenPrototype: true });
    seq.origin(handler.itemUuid);
    if (data2.options.tint) {
      seq.tint(data2.options.tintColor);
      seq.filter("ColorMatrix", { saturate: data2.options.tintSaturate });
    }
    seq.size(size, { gridUnits: true });
    if (data2.options.elevation === 0) {
      seq.belowTokens(true);
    } else {
      seq.elevation(handler.elevation(token, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
    }
    seq.attachTo(token, { bindAlpha: data2.options.unbindAlpha, bindVisibility: data2.options.unbindVisibility });
    seq.opacity(data2.options.opacity);
    seq.fadeIn(data2.options.fadeIn);
    if (data2.video.variant === "complete" || data2.video.animation === "complete") ;
    else {
      seq.fadeOut(data2.options.fadeOut);
    }
    seq.zIndex(data2.options.zIndex);
    if (data2.options.breath) {
      seq.loopProperty("sprite", "scale.x", { from: data2.options.breathMin, to: data2.options.breathMax, duration: data2.options.breathDuration, pingPong: true, ease: "easeInOutSine", gridUnits: true });
      seq.loopProperty("sprite", "scale.y", { from: data2.options.breathMin, to: data2.options.breathMax, duration: data2.options.breathDuration, pingPong: true, ease: "easeInOutSine", gridUnits: true });
    }
    if (data2.options.alpha) {
      seq.loopProperty("alphaFilter", "alpha", { from: data2.options.alphaMin, to: data2.options.alphaMax, duration: data2.options.alphaDuration, pingPong: true });
    }
    seq.playbackRate(data2.options.playbackRate);
    if (handler.systemData.tieToDocuments) {
      seq.tieToDocuments(handler.item);
    }
  }
  if (macro2 && macro2.playWhen === "0") {
    handler.runMacro(macro2);
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
  howToDelete("sequencerground");
}
async function dualattach(handler, animationData) {
  const data2 = animationData.primary;
  const sourceFX = animationData.sourceFX;
  const macro2 = animationData.macro;
  const animFile = await buildFile("range", data2.video, data2.video.customPath);
  const onlyX = data2.video.customPath ? data2.options.onlyX : false;
  const sourceToken = handler.sourceToken;
  let effectExists = Sequencer.EffectManager.getEffects({ object: sourceToken, origin: handler.itemUuid });
  async function cast() {
    let aaSeq = await new Sequence(handler.sequenceData);
    if (macro2 && macro2.playWhen === "1" && !macro2?.args?.warpgateTemplate) {
      handler.complileMacroSection(aaSeq, macro2);
    }
    if (sourceFX) {
      handler.compileSourceEffect(sourceFX, aaSeq);
    }
    if (data2.sound) {
      aaSeq.addSequence(data2.sound);
    }
    aaSeq.thenDo(function() {
      Hooks.callAll("aa.animationStart", sourceToken, handler.allTargets);
    });
    for (let target2 of handler.allTargets) {
      let checkTarget = effectExists.filter((i) => i.data.target.includes(target2.id)).length > 0;
      if (!checkTarget) {
        const effect = aaSeq.effect().file(animFile.file).attachTo(sourceToken).stretchTo(target2, { attachTo: true, onlyX }).persist(true).playbackRate(data2.options.playbackRate).origin(handler.itemUuid);
        if (data2.options.elevation === 0) {
          effect.belowTokens(true);
        } else {
          effect.elevation(handler.elevation(sourceToken, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
        }
      }
    }
    if (macro2 && macro2.playWhen === "0" && !macro2?.args?.warpgateTemplate) {
      handler.runMacro(macro2);
    }
    if (macro2 && macro2.playWhen === "3") {
      handler.complileMacroSection(aaSeq, macro2);
    }
    aaSeq.play();
  }
  cast();
}
async function proToTemp(handler, animationData, templateDocument) {
  const data2 = animationData.primary;
  const sourceFX = animationData.sourceFX;
  const secondary2 = animationData.secondary;
  const targetFX = animationData.targetFX;
  const macro2 = animationData.macro;
  const template = handler.templateData ? handler.templateData : templateDocument;
  const sourceToken = handler.sourceToken;
  let aaSeq = await new Sequence(handler.sequenceData);
  if (data2.projectile.options.removeTemplate) {
    aaSeq.thenDo(function() {
      canvas.scene.deleteEmbeddedDocuments("MeasuredTemplate", [template.id]);
    });
  }
  if (macro2 && macro2.playWhen === "1" && !macro2?.args?.warpgateTemplate) {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.projectile.sound) {
    aaSeq.addSequence(data2.projectile.sound);
  }
  const effect1 = aaSeq.effect().file(data2.projectile.path.file).atLocation(sourceToken).stretchTo(template, { cacheLocation: true, randomOffset: data2.projectile.options.randomOffset }).repeats(data2.projectile.options.repeat, data2.projectile.options.repeatDelay).playbackRate(data2.projectile.options.playbackRate).waitUntilFinished(data2.projectile.options.wait);
  if (data2.projectile.options.elevation === 0) {
    effect1.belowTokens(true);
  } else {
    effect1.elevation(handler.elevation(sourceToken, data2.projectile.options.isAbsolute, data2.projectile.options.elevation), { absolute: data2.projectile.options.isAbsolute });
  }
  if (data2.preExplosion.sound) {
    aaSeq.addSequence(data2.preExplosion.sound);
  }
  if (data2.preExplosion.enable) {
    const effectExplode = aaSeq.effect().file(data2.preExplosion.path.file).atLocation(template, { cacheLocation: true }).scaleToObject(data2.preExplosion.options.scale).repeats(data2.preExplosion.options.repeat, data2.preExplosion.options.repeatDelay).playbackRate(data2.preExplosion.options.playbackRate).waitUntilFinished(data2.preExplosion.options.wait).aboveLighting(data2.preExplosion.options.aboveTemplate);
    if (data2.preExplosion.options.elevation === 0) {
      effectExplode.belowTokens(true);
    } else {
      effectExplode.elevation(handler.elevation(sourceToken, data2.preExplosion.options.isAbsolute, data2.preExplosion.options.elevation), { absolute: data2.preExplosion.options.isAbsolute });
    }
  }
  if (data2.explosion.sound) {
    aaSeq.addSequence(data2.explosion.sound);
  }
  const effect2 = aaSeq.effect().file(data2.explosion.path.file).atLocation(template, { cacheLocation: true }).scaleToObject(data2.explosion.options.scale).repeats(data2.explosion.options.repeat, data2.explosion.options.repeatDelay).zIndex(5).playbackRate(data2.explosion.options.playbackRate).waitUntilFinished(-750 + data2.explosion.options.wait).aboveLighting(data2.explosion.options.aboveTemplate);
  if (data2.explosion.options.elevation === 0) {
    effect2.belowTokens(true);
  } else {
    effect2.elevation(handler.elevation(sourceToken, data2.explosion.options.isAbsolute, data2.explosion.options.elevation), { absolute: data2.explosion.options.isAbsolute });
  }
  if (data2.afterImage.customPath) {
    const effectAfterImage2 = aaSeq.effect().file(data2.afterImage.customPath).atLocation(template, { cacheLocation: true }).scaleToObject(data2.afterImage.options.scale).persist(data2.afterImage.options.persistent).origin(handler.itemUuid).fadeIn(250).fadeOut(500);
    if (data2.afterImage.options.elevation === 0) {
      effectAfterImage2.belowTokens(true);
    } else {
      effectAfterImage2.elevation(handler.elevation(sourceToken, data2.afterImage.options.isAbsolute, data2.afterImage.options.elevation), { absolute: data2.afterImage.options.isAbsolute });
    }
  }
  if (secondary2) {
    handler.compileSecondaryEffect(secondary2, aaSeq, handler.allTargets, targetFX.enable, false);
  }
  if (targetFX) {
    handler.compileTargetEffect(targetFX, aaSeq, handler.allTargets, false);
  }
  if (macro2 && macro2.playWhen === "0" && !macro2?.args?.warpgateTemplate) {
    handler.runMacro(macro2);
  }
  if (data2.afterImage.enable && data2.afterImage.options.persistent) {
    howToDelete("sequencerground");
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
}
async function teleportation(handler, animationData) {
  const sourceToken = handler.sourceToken;
  const data2 = animationData.primary;
  const macro2 = animationData.macro;
  const startFile = await buildFile("static", data2.start, data2.start.customPath);
  const endFile = await buildFile("static", data2.end, data2.end.customPath);
  const betweenFile = await buildFile("range", data2.between, data2.between.customPath);
  let sourceTokenGS = sourceToken.w / canvas.grid.size;
  let userIDs = Array.from(game.users).map((user) => user.id);
  let gmIDs = Array.from(game.users).filter((i) => i.isGM).map((user) => user.id);
  const hideBorder = data2.options.hideFromPlayers ? gmIDs : userIDs;
  const delayFade = data2.options.delayFade || 0;
  const delayReturn = data2.options.delayReturn || 0;
  const borderSize = sourceTokenGS / canvas.grid.size + 0.5 + data2.options.range / canvas.dimensions.distance;
  const borderType = data2.options.measureType === "equidistant" ? "roundedRect" : "circle";
  const borderLocation = borderType === "circle" ? {} : { offset: { x: -borderSize, y: -borderSize }, gridUnits: true };
  const borderData = {
    lineSize: 4,
    lineColor: game.user.color.toString(),
    radius: borderType === "circle" ? borderSize : 0.25,
    width: borderSize * 2,
    height: borderSize * 2,
    gridUnits: true,
    name: "teleBorder"
  };
  let borderSeq = await new Sequence(handler.sequenceData);
  let borderEffect = borderSeq.effect().fadeIn(500).persist().fadeOut(500).atLocation(sourceToken, borderLocation).shape(borderType, borderData).elevation(sourceToken?.document?.elevation + 1).forUsers(hideBorder).name("teleportation").opacity(0.75);
  if (borderType === "circle") {
    borderEffect.loopProperty("shapes.teleBorder", "scale.x", { from: 0.98, to: 1.02, duration: 1500, pingPong: true, ease: "easeInOutSine" });
    borderEffect.loopProperty("shapes.teleBorder", "scale.y", { from: 0.98, to: 1.02, duration: 1500, pingPong: true, ease: "easeInOutSine" });
  }
  borderSeq.play();
  let pos;
  if (game.Levels3DPreview?._active) {
    let getPositionFrom3D = function() {
      game.Levels3DPreview.CONFIG.entityClass.Template3D.drawPreview(new MeasuredTemplateDocument(templateData), false).then((response) => {
        if (!response) return getPositionFrom3D();
        pos = {
          x: response.x,
          y: response.y,
          elevation: parseFloat(response.flags.levels.elevation)
        };
        let topLeft = canvas.grid.getTopLeft(pos.x, pos.y);
        if (canvas.grid.measureDistance(sourceToken, { x: topLeft[0], y: topLeft[1] }, { gridSpaces: true }) <= data2.options.range) {
          if (data2.options.checkCollision && testCollision(pos)) {
            ui.notifications.error("Your Path is Blocked!! Try Again");
            return getPositionFrom3D();
          } else {
            circle3d?.remove();
            deleteTemplatesAndMove();
          }
        } else {
          ui.notifications.error(game.i18n.format("autoanimations.settings.teleport"));
          return getPositionFrom3D();
        }
      });
    };
    const circle3d = data2.options.range ? new game.Levels3DPreview.CONFIG.entityClass.RangeRingEffect(sourceToken, data2.options.range, game.user.color) : null;
    const templateData = { t: "circle", user: game.user.id, distance: 5, x: 0, y: 0, fillColor: "#ffffff", width: 1, texture: "", direction: 0 };
    getPositionFrom3D();
  }
  canvas.app.stage.addListener("pointerdown", (event) => {
    if (event.data.button !== 0) {
      return;
    }
    pos = event.data.getLocalPosition(canvas.app.stage);
    let topLeft = canvas.grid.getTopLeft(pos.x, pos.y);
    if (canvas.grid.measureDistance(sourceToken, { x: topLeft[0], y: topLeft[1] }, { gridSpaces: true }) <= data2.options.range) {
      if (data2.options.checkCollision && testCollision(pos)) {
        ui.notifications.error("Your Path is Blocked!! Try Again");
      } else {
        deleteTemplatesAndMove();
        canvas.app.stage.removeListener("pointerdown");
      }
    } else {
      ui.notifications.error(game.i18n.format("autoanimations.settings.teleport"));
    }
  });
  function testCollision(pos2) {
    let pointerCenter = {
      x: canvas.grid.getCenter(pos2.x, pos2.y)[0],
      y: canvas.grid.getCenter(pos2.x, pos2.y)[1]
    };
    return sourceToken.checkCollision(pointerCenter);
  }
  async function deleteTemplatesAndMove() {
    let gridPos = canvas.grid.getTopLeft(pos.x, pos.y);
    let centerPos;
    if (canvas.scene.gridType === 0) {
      centerPos = [gridPos[0] + sourceToken.w, gridPos[1] + sourceToken.w];
    } else {
      centerPos = canvas.grid.getCenter(pos.x, pos.y);
    }
    Sequencer.EffectManager.endEffects({ name: "teleportation" });
    let aaSeq = new Sequence(handler.sequenceData);
    if (macro2 && macro2.playWhen === "1" && !macro2?.args?.warpgateTemplate) {
      handler.complileMacroSection(aaSeq, macro2);
    }
    let startX = sourceToken.center?.x;
    let startY = sourceToken.center?.y;
    if (data2.sound) {
      aaSeq.addSequence(data2.sound);
    }
    if (data2.start) {
      let startEffect = aaSeq.effect();
      startEffect.file(startFile.file);
      startEffect.atLocation({ x: startX, y: startY });
      startEffect.elevation(handler.elevation(sourceToken, data2.start.options.isAbsolute, data2.start.options.elevation), { absolute: data2.start.options.isAbsolute });
      startEffect.size(sourceTokenGS * 1.5 * data2.start.options.size, { gridUnits: true });
      startEffect.opacity(data2.start.options.opacity);
      startEffect.fadeIn(data2.start.options.fadeIn);
      startEffect.fadeOut(data2.start.options.fadeOut);
      startEffect.delay(data2.start.options.delay);
      startEffect.playbackRate(data2.start.options.playbackRate);
      if (data2.start.options.isMasked) {
        startEffect.mask(sourceToken);
      }
    }
    if (data2.between) {
      let betweenEffect = aaSeq.effect();
      betweenEffect.file(betweenFile.file);
      betweenEffect.atLocation({ x: startX, y: startY });
      betweenEffect.delay(data2.between.options.delay);
      betweenEffect.elevation(handler.elevation(sourceToken, data2.between.options.isAbsolute, data2.between.options.elevation), { absolute: data2.between.options.isAbsolute });
      betweenEffect.opacity(data2.between.options.opacity);
      betweenEffect.stretchTo({ x: centerPos[0], y: centerPos[1] });
      betweenEffect.playbackRate(data2.between.options.playbackRate);
    }
    if (data2.end) {
      let endEffect = aaSeq.effect();
      endEffect.file(endFile.file);
      endEffect.atLocation({ x: centerPos[0], y: centerPos[1] });
      endEffect.delay(data2.end.options.delay);
      endEffect.elevation(handler.elevation(sourceToken, data2.end.options.isAbsolute, data2.end.options.elevation), { absolute: data2.end.options.isAbsolute });
      endEffect.size(sourceTokenGS * 1.5 * data2.end.options.size, { gridUnits: true });
      endEffect.fadeIn(data2.end.options.fadeIn);
      endEffect.fadeOut(data2.end.options.fadeOut);
      endEffect.playbackRate(data2.end.options.playbackRate);
      if (data2.end.options.isMasked) {
        endEffect.mask(sourceToken);
      }
    }
    if (data2.options.alpha < 1) {
      let fadeSeq = aaSeq.animation();
      fadeSeq.on(sourceToken);
      fadeSeq.opacity(data2.options.alpha);
      fadeSeq.delay(delayFade);
    }
    let animSeq = aaSeq.animation();
    animSeq.on(sourceToken);
    animSeq.delay(data2.options.delayMove);
    if (data2.options.teleport) {
      animSeq.teleportTo({ x: gridPos[0], y: gridPos[1], elevation: pos.elevation });
    } else {
      animSeq.moveTowards({ x: gridPos[0], y: gridPos[1], elevation: pos.elevation });
      animSeq.moveSpeed(data2.options.speed);
    }
    if (data2.options.alpha < 1) {
      let tokenSeq = aaSeq.animation();
      tokenSeq.on(sourceToken);
      tokenSeq.opacity(1);
      tokenSeq.delay(delayFade + delayReturn);
    }
    if (macro2 && macro2.playWhen === "0" && !macro2?.args?.warpgateTemplate) {
      handler.runMacro(macro2);
    }
    if (macro2 && macro2.playWhen === "3") {
      handler.complileMacroSection(aaSeq, macro2);
    }
    aaSeq.play();
  }
}
const wait$1 = (delay) => new Promise((resolve) => setTimeout(resolve, delay));
async function thunderwave(handler, animationData, config) {
  const sourceToken = handler.sourceToken;
  const data2 = animationData.primary;
  const sourceFX = animationData.sourceFX;
  const macro2 = animationData.macro;
  let color = data2.color;
  const template = config ? config : canvas.templates.placeables[canvas.templates.placeables.length - 1];
  const templateData = config ? config || {} : template.document || {};
  Math.sqrt(Math.pow(templateData.distance, 2) / 2);
  const getPosition = getRelativePosition(sourceToken, templateData);
  const angle = getPosition.angle;
  const databasePath = color === "random" ? `autoanimations.templatefx.square.thunderwave.${getPosition.type}` : `autoanimations.templatefx.square.thunderwave.${getPosition.type}.${color}`;
  canvas.scene.dimensions.size;
  let aaSeq = await new Sequence(handler.sequenceData);
  if (macro2 && macro2.playWhen === "1") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  if (sourceFX) {
    handler.compileSourceEffect(sourceFX, aaSeq);
  }
  if (data2.sound) {
    aaSeq.addSequence(data2.sound);
  }
  aaSeq.thenDo(function() {
    Hooks.callAll("aa.animationStart", sourceToken, "no-target");
  });
  const effect = aaSeq.effect().file(databasePath).atLocation(template, { cacheLocation: true }).anchor({ x: 0.5, y: 0.5 }).rotate(angle).opacity(data2.options.opacity).size(3, { gridUnits: true }).repeats(data2.options.repeat, data2.options.repeatDelay);
  if (data2.options.elevation === 0) {
    effect.belowTokens(true);
  } else {
    effect.elevation(handler.elevation(sourceToken, data2.options.isAbsolute, data2.options.elevation), { absolute: data2.options.isAbsolute });
  }
  if (macro2 && macro2.playWhen === "0") {
    handler.runMacro(macro2);
  }
  if (data2.options.removeTemplate) {
    canvas.scene.deleteEmbeddedDocuments("MeasuredTemplate", [template.id]);
  }
  if (macro2 && macro2.playWhen === "3") {
    handler.complileMacroSection(aaSeq, macro2);
  }
  aaSeq.play();
  await wait$1(500);
  Hooks.callAll("aa.animationEnd", sourceToken, "no-target");
  function getRelativePosition(token, template2) {
    const xPos = token.x;
    const yPos = token.y;
    const tempY = template2.y;
    const tempX = template2.x;
    const gridSize = canvas.scene.dimensions.size;
    let type;
    let angle2;
    switch (true) {
      case (xPos >= tempX && xPos <= tempX + gridSize * 2 && (yPos >= tempY && yPos <= tempY + gridSize * 2)):
        type = "center";
        angle2 = 0;
        break;
      case (xPos >= tempX - gridSize && xPos <= tempX - gridSize * 0.5 && (yPos >= tempY - gridSize && yPos <= tempY - gridSize * 0.5)):
        type = "left";
        angle2 = 270;
        break;
      case (xPos >= tempX + gridSize * 2.5 && xPos <= tempX + gridSize * 3 && (yPos >= tempY - gridSize && yPos <= tempY - gridSize * 0.5)):
        type = "left";
        angle2 = 180;
        break;
      case (xPos >= tempX + gridSize * 2.5 && xPos <= tempX + gridSize * 3 && (yPos <= tempY + gridSize * 3 && yPos >= tempY + gridSize * 2.5)):
        type = "left";
        angle2 = 90;
        break;
      case (xPos <= tempX - gridSize * 0.5 && xPos >= tempX - gridSize && (yPos <= tempY + gridSize * 3 && yPos >= tempY + gridSize * 2.5)):
        type = "left";
        angle2 = 0;
        break;
      case (xPos >= tempX + gridSize * 2.5 && (yPos >= tempY && yPos <= tempY + gridSize * 2)):
        type = "mid";
        angle2 = 90;
        break;
      case (xPos >= tempX && xPos <= tempX + gridSize * 2 && (yPos >= tempY - gridSize && yPos <= tempY - gridSize * 0.5)):
        type = "mid";
        angle2 = 180;
        break;
      case (xPos >= tempX - gridSize && xPos <= tempX - gridSize * 0.5 && (yPos >= tempY && yPos <= tempY + gridSize * 2)):
        type = "mid";
        angle2 = 270;
        break;
      default:
        type = "mid";
        angle2 = 0;
    }
    return { type, angle: angle2 };
  }
}
async function particleEffects(handler, animationData = {}) {
  const data2 = await DataSanitizer.compileParticleData(animationData);
  if (!data2) {
    return;
  }
  let hit = true;
  try {
    if (handler.playOnMiss) {
      hit = handler.allTargets.some((target2) => handler.hitTargetsId.includes(target2.id)) ? true : false;
    }
  } catch (e) {
  }
  data2.miss = !hit;
  const secondary2 = data2.secondary;
  const tokenAnim = data2.tokenAnimation;
  const sourceToken = handler.sourceToken;
  const targets2 = handler.allTargets;
  if (data2.sound) {
    const audio = data2.sound;
    audio.play();
  }
  const tokenAnimationData = {};
  function compileTokenAnimationData() {
    if (tokenAnim.source) {
      tokenAnimationData.from = {
        id: tokenAnim.sourceType,
        options: {
          start: tokenAnim.sourceStart,
          end: tokenAnim.sourceEnd
        }
      };
    }
    if (tokenAnim.target) {
      tokenAnimationData.to = {
        id: tokenAnim.targetType,
        options: {
          start: tokenAnim.targetStart,
          end: tokenAnim.targetEnd
        }
      };
    }
    return tokenAnimationData;
  }
  class ParticleFunctions {
    static particle(data3, sourceToken2, targets3) {
      const spriteData = new Particle3D(data3.type);
      spriteData.from(sourceToken2);
      spriteData.to(targets3);
      spriteData.speed(data3.speed);
      spriteData.repeat(data3.repeat);
      spriteData.arc(data3.arc);
      spriteData.delay(data3.delay);
      spriteData.color(data3.color01, data3.color02);
      spriteData.scale(data3.scale);
      spriteData.sprite(data3.sprite);
      spriteData.life(data3.life);
      spriteData.emitterSize(data3.emittersize);
      spriteData.alpha(data3.alpha);
      spriteData.mass(data3.mass);
      spriteData.miss(!!data3.miss);
      spriteData.gravity(data3.gravity);
      spriteData.rotateTowards(data3.rotateTowards);
      spriteData.rotation(data3.rotationX, data3.rotationY, data3.rotationZ);
      spriteData.duration(data3.duration);
      spriteData.onCenter(data3.onCenter);
      spriteData.autoSize(data3.autoSize);
      spriteData.rate(data3.rate, 1);
      spriteData.presetIntensity(data3.rate);
      if (tokenAnim.enable && (tokenAnim.source || tokenAnim.target)) {
        spriteData.playAnimation(compileTokenAnimationData());
      }
      if (secondary2.enable) {
        spriteData.onEnd(
          new Particle3D(secondary2.type ?? "e").sprite(secondary2.sprite).speed(secondary2.speed).color(secondary2.color01, secondary2.color02).scale(secondary2.scale).gravity(secondary2.gravity).life(secondary2.life).rate(secondary2.rate, 1).presetIntensity(secondary2.rate).emitterSize(secondary2.emittersize).duration(secondary2.duration).onCenter(secondary2.onCenter).autoSize(secondary2.autoSize).alpha(secondary2.alpha).mass(secondary2.mass)
        );
      }
      spriteData.start();
    }
    static token() {
      let tokens;
      switch (data2.playOn) {
        case "target":
          tokens = targets2;
          break;
        case "default":
          if (targets2.length) {
            tokens = targets2;
          } else {
            tokens = sourceToken;
          }
          break;
        case "both":
          if (targets2.length) {
            tokens = [sourceToken, ...targets2];
          } else {
            tokens = sourceToken;
          }
          break;
        default:
          tokens = sourceToken;
      }
      let options2 = {
        repeats: data2.repeat,
        resetTime: data2.resetTime
      };
      game.Levels3DPreview.playTokenAnimation(tokens, data2.animationType, options2);
    }
  }
  data2.type == "token" ? ParticleFunctions.token(data2, sourceToken, targets2) : ParticleFunctions.particle(data2, sourceToken, targets2);
}
const animate = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
  __proto__: null,
  aura: aura$3,
  dualattach,
  melee: melee$3,
  ontoken: ontoken$3,
  particleEffects,
  proToTemp,
  range: range$3,
  teleportation,
  templatefx: templatefx$3,
  thunderwave
}, Symbol.toStringTag, { value: "Module" }));
const wait = (delay) => new Promise((resolve) => setTimeout(resolve, delay));
async function trafficCop$1(handler) {
  if (!handler) {
    return;
  }
  const data2 = foundry.utils.deepClone(handler.animationData);
  if (data2.advanced?.excludedType?.enabled && data2.advanced?.excludedType?.path && data2.advanced?.excludedType?.property) {
    if (AAAutorecFunctions.checkExcludedProperty(handler.item, data2.advanced?.excludedType?.property, data2.advanced?.excludedType?.path)) {
      return;
    }
  }
  Hooks.callAll("aa.preDataSanitize", handler, data2);
  const sanitizedData = await DataSanitizer._getAnimationData(handler, data2);
  Hooks.callAll("aa.preAnimationStart", sanitizedData);
  let globalDelay = game.settings.get("autoanimations", "globaldelay");
  await wait(globalDelay);
  let aaTemplateHook;
  if (sanitizedData.macro && sanitizedData.macro.enable && sanitizedData.macro.playWhen === "2") {
    let playMacro = function() {
      handler.runMacro(sanitizedData.macro);
    };
    if (handler.isTemplateAnimation) {
      switch (game.system.id) {
        case "a5e":
        case "sw5e":
        case "tormenta20":
        case "swade":
          aaTemplateHook = Hooks.once("createMeasuredTemplate", async (template) => {
            await wait(500);
            handler.templateData = template;
            playMacro();
          });
          setTimeout(killHook, 3e4);
          break;
        default:
          await wait(500);
          handler.templateData = canvas.templates?.placeables?.[canvas.templates.placeables.length - 1]?.document;
          playMacro();
      }
    } else {
      playMacro();
    }
    return;
  }
  if (data2.soundOnly?.sound?.enable && data2.soundOnly?.sound?.file) {
    const sound2 = {
      file: data2.soundOnly?.sound?.file ?? "",
      volume: data2.soundOnly?.sound?.volume ?? 0.75,
      delay: data2.soundOnly?.sound?.delay ?? 0,
      startTime: data2.soundOnly?.sound?.startTime ?? 0,
      repeat: data2.soundOnly?.sound?.repeat ?? 1,
      repeatDelay: data2.soundOnly?.sound?.repeatDelay ?? 250
    };
    new Sequence(handler.sequenceData).sound().file(sound2.file).volume(sound2.volume).delay(sound2.delay).startTime(sound2.startTime).repeats(sound2.repeat, sound2.repeatDelay).play();
    return;
  }
  if (data2.levels3d?.type && game.Levels3DPreview?._active) {
    particleEffects(handler, data2);
    return;
  }
  const animationType = data2.menu === "preset" ? data2.presetType : data2.menu === "aefx" ? data2.activeEffectType : data2.menu;
  const targets2 = handler.allTargets?.length;
  if (animationType === "templatefx" || animationType === "proToTemp") {
    if (animationType === "proToTemp" && !handler.sourceToken) {
      debug$1("Failed to initialize a Source Token");
      return;
    }
    debug$1(`${animationType} Animation Start"`, handler, sanitizedData);
    if (handler.templateData) {
      await wait(500);
      animate[animationType](handler, sanitizedData);
      return;
    }
    if (sanitizedData?.macro && sanitizedData?.macro?.args?.warpgateTemplate) {
      if (foundry.utils.isNewerVersion(game.version, 11)) {
        new Sequence().macro(sanitizedData.macro.name, { args: [handler.workflow, handler, sanitizedData.macro.args] }).play();
      } else {
        if (game.modules.get("advanced-macros")?.active) {
          new Sequence().macro(sanitizedData.macro.name, handler.workflow, handler, sanitizedData.macro.args).play();
        } else {
          new Sequence().macro(sanitizedData.macro.name).play();
        }
      }
      aaTemplateHook = Hooks.once("createMeasuredTemplate", async (template) => {
        await wait(500);
        animate[animationType](handler, sanitizedData, template);
      });
      setTimeout(killHook, 3e4);
      return;
    }
    switch (game.system.id) {
      case "a5e":
      case "pf2e":
      case "sw5e":
      case "tormenta20":
      case "swade":
        aaTemplateHook = Hooks.once("createMeasuredTemplate", async (template2) => {
          await wait(500);
          animate[animationType](handler, sanitizedData, template2);
        });
        setTimeout(killHook, 3e4);
        break;
      default:
        await wait(500);
        let template = canvas.templates?.placeables?.[canvas.templates.placeables.length - 1]?.document;
        if (!template) {
          debug$1("No template found for the Template animaiton, existing early");
          return;
        }
        animate[animationType](handler, sanitizedData, template);
    }
    return;
  } else {
    if (!handler.sourceToken || targets2 < 1 && (animationType === "melee" || animationType === "range")) {
      Hooks.callAll("aa.animationEnd", handler.sourceToken, "no-target");
      debug$1(`${animationType} Animation End", "NO TARGETS`);
      return;
    }
    debug$1(`${animationType} Animation Start"`, sanitizedData);
    animate[animationType](handler, sanitizedData);
    return;
  }
  function killHook() {
    Hooks.off("createMeasuredTemplate", aaTemplateHook);
  }
}
class AutoAnimations {
  static async playAnimation(sourceToken, targets2, item2, options2 = {}) {
    custom_warning("AutoAnimations.playAnimation is deprecated in favor of AutomatedAnimations.PlayAnimation. This will be removed in Version 5");
    if (!Array.isArray(targets2)) {
      targets2 = Array.from(targets2);
    }
    const data2 = {
      token: sourceToken,
      targets: targets2,
      item: item2,
      ...options2
    };
    const handler = await AAHandler.make(data2);
    trafficCop$1(handler);
  }
}
async function playAnimation(sourceToken, item2, options2 = {}) {
  if (!item2) {
    return;
  }
  let targets2;
  if (options2.targets) {
    if (options2.targets instanceof Set) {
      targets2 = Array.from(options2.targets);
    } else if (options2.targets instanceof Array) {
      targets2 = options2.targets;
    } else {
      targets2 = [options2.targets];
    }
  } else {
    targets2 = Array.from(game.user.targets);
  }
  const data2 = {
    token: sourceToken,
    targets: targets2,
    item: item2,
    ...options2
  };
  const handler = await AAHandler.make(data2);
  trafficCop$1(handler);
  return handler;
}
async function mergeVersion01(data2) {
  let currentAutorec = data2;
  const staticObject = currentAutorec.static;
  if (staticObject) {
    const staticLength = Object.keys(staticObject).length;
    for (var i = 0; i < staticLength; i++) {
      switch (staticObject[i].animation) {
        case "curewounds":
        case "generichealing":
        case "tollthedead":
          staticObject[i].staticOptions = "staticSpells";
          break;
        case "bite":
        case "claw":
          staticObject[i].staticOptions = "creature";
          break;
        default:
          staticObject[i].staticOptions = "explosion";
      }
    }
  }
  const templates = currentAutorec.templates;
  if (templates) {
    const templateLength = Object.keys(templates).length;
    for (var i = 0; i < templateLength; i++) {
      switch (true) {
        case templates[i].persist:
          if (templates[i].overhead) {
            templates[i].persistType = "overheadtile";
          } else {
            templates[i].persistType = "sequencerground";
          }
          break;
      }
    }
  }
  currentAutorec.version = 1;
  return currentAutorec;
}
async function mergeVersion02(data2) {
  let currentAutorec = data2;
  const meleeObject = currentAutorec.melee;
  if (meleeObject) {
    const meleeLength = Object.keys(meleeObject).length;
    for (var i = 0; i < meleeLength; i++) {
      meleeObject[i].meleeType = "weapon";
    }
  }
  currentAutorec.version = 2;
  return currentAutorec;
}
async function mergeVersion03(data2) {
  let currentAutorec = data2;
  const templateObject = currentAutorec.templates;
  if (templateObject) {
    const templateLength = Object.keys(templateObject).length;
    for (var i = 0; i < templateLength; i++) {
      templateObject[i].scaleX = templateObject[i].scale || 1;
      templateObject[i].scaleY = templateObject[i].scale || 1;
    }
  }
  const presetObject = currentAutorec.preset;
  if (presetObject) {
    const presetLength = Object.keys(presetObject).length;
    for (var i = 0; i < presetLength; i++) {
      if (presetObject[i].animation === "teleportation") {
        presetObject[i].measureType = "alternating";
        presetObject[i].custom02 = presetObject[i].custom ? true : false;
        presetObject[i].customPath02 = presetObject[i].custom ? presetObject[i].customPath : "";
        presetObject[i].subAnimation02 = presetObject[i].subAnimation ?? "mistystep";
        presetObject[i].variant = "01";
        presetObject[i].variant02 = "02";
        presetObject[i].color02 = presetObject[i].color ?? "blue";
        presetObject[i].scale02 = presetObject[i].scale || 1;
      }
    }
  }
  currentAutorec.version = 3;
  return currentAutorec;
}
async function mergeVersion04(data2) {
  let currentAutorec = data2;
  const meleeObject = currentAutorec.melee;
  const rangeObject = currentAutorec.range;
  const staticObject = currentAutorec.static;
  const templateObject = currentAutorec.templates;
  const auraObject = currentAutorec.auras;
  const presetObject = currentAutorec.preset;
  if (meleeObject) {
    const generic = ["1hs", "2hs", "1hp", "2hp", "1hb", "2hb"];
    const meleeLength = Object.keys(meleeObject).length;
    for (var i = 0; i < meleeLength; i++) {
      let co = meleeObject[i];
      if (co.custom) ;
      else {
        if (generic.some((el) => co.animation === el)) {
          co.menuType = "generic";
        } else {
          co.menuType = co.meleeType;
        }
      }
      if (co.switchType === "custom") {
        co.switchMenuType = "weapon";
      }
      if (co.explosion?.enable && !co.explosion.custom) {
        const fire = ["eruption"];
        const generic2 = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02"];
        const ice = ["snowflake"];
        const liquid = ["liquidsplash"];
        const fireball = ["fireballexplode"];
        switch (true) {
          case fire.some((el) => co.explosion.animation === el):
            co.explosion.menuType = "fire";
            break;
          case generic2.some((el) => co.explosion.animation === el):
            co.explosion.menuType = "generic";
            if (co.explosion.animation.includes("outpulse")) {
              co.explosion.animation = "outpulse";
              co.explosion.variant = co.explosion.variant === "outpulse02" ? "02" : "01";
            }
            break;
          case ice.some((el) => co.explosion.animation === el):
            co.explosion.menuType = "ice";
            break;
          case liquid.some((el) => co.explosion.animation === el):
            co.explosion.menuType = "liquid";
            co.explosion.animation = "splash";
            break;
          case fireball.some((el) => co.explosion.animation === el):
            co.explosion.menuType = "spell";
            co.explosion.animation = "fireball";
            co.explosion.variant = "explode";
            break;
          default:
            co.explosion.menuType = "spell";
        }
      }
    }
  }
  if (rangeObject) {
    const generic = ["energyconduitsquare", "energyconduitcircle", "energybeam", "heart", "iceshard", "musicnote", "skull", "energystrand"];
    const rangeLength = Object.keys(rangeObject).length;
    for (var i = 0; i < rangeLength; i++) {
      let ro = rangeObject[i];
      if (generic.some((el) => ro.animation === el)) {
        ro.menuType = "generic";
        if (ro.animation === "energyconduitcircle") {
          ro.animation = "conduit";
          ro.variant = "circle";
        }
        if (ro.animation === "energyconduitsquare") {
          ro.animation = "conduit";
          ro.variant = "square";
        }
      } else {
        ro.menuType = ro.type;
      }
      if (ro.explosion?.enable && !ro.explosion.custom) {
        const fire = ["eruption"];
        const generic2 = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02"];
        const ice = ["snowflake"];
        const liquid = ["liquidsplash"];
        const fireball = ["fireballexplode"];
        switch (true) {
          case fire.some((el) => ro.explosion.animation === el):
            ro.explosion.menuType = "fire";
            break;
          case generic2.some((el) => ro.explosion.animation === el):
            ro.explosion.menuType = "generic";
            if (ro.explosion.animation.includes("outpulse")) {
              ro.explosion.animation = "outpulse";
              ro.explosion.variant = ro.explosion.variant === "outpulse02" ? "02" : "01";
            }
            break;
          case ice.some((el) => ro.explosion.animation === el):
            ro.explosion.menuType = "ice";
            break;
          case liquid.some((el) => ro.explosion.animation === el):
            ro.explosion.menuType = "liquid";
            ro.explosion.animation = "splash";
            break;
          case fireball.some((el) => ro.explosion.animation === el):
            ro.explosion.menuType = "spell";
            ro.explosion.animation = "fireball";
            ro.explosion.variant = "explode";
            break;
          default:
            ro.explosion.menuType = "spell";
        }
      }
    }
  }
  if (staticObject) {
    const conditions = ["drop", "fear", "heart", "horror", "light", "poison", "runes", "shields", "crackedshield", "skull", "snowflakes", "stun", "dizzystars"];
    const creature = ["bite", "claw"];
    const energy = ["energyfield", "dodecahedron", "shimmer", "sparkles"];
    const fire = ["eruption", "groundcrack", "fireworks"];
    const generic = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02", "vortex", "whirl"];
    const ice = ["icespikes", "snowflake"];
    const lightning = ["lightningball", "staticelectricity"];
    const liquid = ["liquidsplash"];
    const magicsign = ["magicSign"];
    const marker = ["marker", "circleofstars", "energystrand"];
    const shieldfx = ["energyfieldtop", "shieldfiretop", "shieldicetop", "shieldearthtop", "shieldeldritchwebtop"];
    const tokenborder = ["staticborder", "spinningborder"];
    const fireball = ["fireballexplode"];
    const staticLength = Object.keys(staticObject).length;
    for (var i = 0; i < staticLength; i++) {
      let so = staticObject[i];
      switch (true) {
        case conditions.some((el) => so.animation === el):
          so.menuType = "conditions";
          break;
        case creature.some((el) => so.animation === el):
          so.menuType = "creature";
          break;
        case energy.some((el) => so.animation === el):
          so.menuType = "energy";
          break;
        case fire.some((el) => so.animation === el):
          so.menuType = "fire";
          break;
        case generic.some((el) => so.animation === el):
          so.menuType = "generic";
          if (so.animation.includes("outpulse")) {
            so.variant = so.animation === "outpulse02" ? "02" : "01";
            so.animation = "outpulse";
          }
          break;
        case ice.some((el) => so.animation === el):
          so.menuType = "ice";
          break;
        case lightning.some((el) => so.animation === el):
          so.menuType = "lightning";
          break;
        case liquid.some((el) => so.animation === el):
          so.menuType = "liquid";
          so.animation = "splash";
          break;
        case magicsign.some((el) => so.animation === el):
          so.menuType = "magicsign";
          break;
        case marker.some((el) => so.animation === el):
          so.menuType = "marker";
          if (so.animation === "circleofstars") ;
          else if (so.animation === "energystrand") {
            so.animation = "energystrand";
          } else {
            switch (so.variant) {
              case "03":
                so.animation = "music";
                so.variant = "01";
                break;
              case "bubble":
                so.animation = "bubble";
                so.variant = "01";
                break;
              case "energystrand":
                so.animation = "energystrands";
                so.variant = "01";
                break;
              default:
                so.animation = "standard";
                so.variant = "01";
            }
          }
          break;
        case shieldfx.some((el) => so.animation === el):
          so.menuType = "shieldfx";
          switch (so.animation) {
            case "energyfieldtop":
              so.animation = "energyfield";
              break;
            case "shieldfiretop":
              so.animation = "fire";
              break;
            case "shieldicetop":
              so.animation = "ice";
              break;
            case "shieldearthtop":
              so.animation = "earth";
              break;
            case "shieldeldritchwebtop":
              so.animation = "eldritchweb";
              break;
          }
          break;
        case tokenborder.some((el) => so.animation === el):
          so.menuType = "tokenborder";
          if (so.animation === "staticborder") {
            so.animation = "static";
          } else {
            so.animation = "spinning";
          }
          break;
        case fireball.some((el) => so.animation === el):
          so.menuType = "spell";
          so.animation = "fireball";
          so.variant = "explode";
          break;
        default:
          so.menuType = "spell";
      }
      if (so.explosion?.enable && !so.explosion.custom) {
        const fire2 = ["eruption"];
        const generic2 = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02"];
        const ice2 = ["snowflake"];
        const liquid2 = ["liquidsplash"];
        const fireball2 = ["fireballexplode"];
        switch (true) {
          case fire2.some((el) => so.explosion.animation === el):
            so.explosion.menuType = "fire";
            break;
          case generic2.some((el) => so.explosion.animation === el):
            so.explosion.menuType = "generic";
            if (so.explosion.animation.includes("outpulse")) {
              so.explosion.animation = "outpulse";
              so.explosion.variant = so.explosion.variant === "outpulse02" ? "02" : "01";
            }
            break;
          case ice2.some((el) => so.explosion.animation === el):
            so.explosion.menuType = "ice";
            break;
          case liquid2.some((el) => so.explosion.animation === el):
            so.explosion.menuType = "liquid";
            so.explosion.animation = "splash";
            break;
          case fireball2.some((el) => so.explosion.animation === el):
            so.explosion.menuType = "spell";
            so.explosion.animation = "fireball";
            so.explosion.variant = "explode";
            break;
          default:
            so.explosion.menuType = "spell";
        }
      }
    }
  }
  if (templateObject) {
    const templateLength = Object.keys(templateObject).length;
    for (var i = 0; i < templateLength; i++) {
      let to = templateObject[i];
      to.menuType = to.type === "rect" ? "square" : to.type;
      switch (to.menuType) {
        case "cone":
          if (to.animation === "breathweaponcone") {
            to.animation = "breathweapon";
          }
          break;
        case "circle":
          const circleTypes = ["dropct", "fearct", "heartct", "horrorct", "poisonct", "runesct", "shieldsct", "crackedshieldct", "skullct", "snowflakesct", "musicnotect"];
          if (circleTypes.some((el) => to.animation === el)) {
            to.animation = to.animation.replace("ct", "");
          }
          switch (to.animation) {
            case "outpulse01":
              to.animation = "outpulse";
              to.variant = "01";
              break;
            case "outpulse02":
              to.animation = "outpulse";
              to.variant = "02";
              break;
            case "fireballloop":
              to.animation = "fireball";
              to.variant = to.variant === "nodebris" ? "nodebris" : "loop";
              break;
            case "fireballexplode":
              to.animation = "fireball";
              to.variant = "explode";
              break;
          }
          break;
        case "square":
          const squareTypes = ["dropct", "fearct", "heartct", "horrorct", "poisonct", "runesct", "shieldsct", "crackedshieldct", "skullct", "snowflakesct"];
          if (squareTypes.some((el) => to.animation === el)) {
            to.animation = to.animation.replace("ct", "");
          } else if (to.animation === "musicnotest") {
            to.animation = "musicnote";
          }
          break;
        case "ray":
          if (to.animation === "breathweaponline") {
            to.animation = "breathweapon";
          }
          break;
      }
    }
  }
  if (auraObject) {
    const auraLength = Object.keys(auraObject).length;
    for (var i = 0; i < auraLength; i++) {
      let ao = auraObject[i];
      switch (ao.animation) {
        case "energystrand":
          ao.menuType = "marker";
          break;
        case "dodecahedron":
          ao.menuType = "energy";
          break;
        case "staticelectricity":
          ao.menuType = "lightning";
          break;
        default:
          ao.menuType = "spell";
      }
    }
  }
  if (presetObject) {
    const presetLength = Object.keys(presetObject).length;
    for (var i = 0; i < presetLength; i++) {
      let po = presetObject[i];
      switch (po.animation) {
        case "teleportation":
          po.menuType = "spell";
          po.menuType02 = "spell";
          break;
        case "dualattach":
          switch (po.subAnimation) {
            case "energystrand":
            case "energybeam":
              po.menuType = "generic";
              break;
            default:
              po.menuType = "spell";
          }
          break;
        case "fireball":
          const fire = ["eruption"];
          const generic = ["boulderimpact", "explosion", "impact", "outpulse01", "outpulse02"];
          const ice = ["snowflake"];
          const liquid = ["liquidsplash"];
          const fireball = ["fireballexplode"];
          switch (po.projectile) {
            case "energystrand":
            case "energybeam":
              po.rangeType = "generic";
              break;
            default:
              po.rangeType = "spell";
          }
          if (po.explosion01) {
            switch (true) {
              case fire.some((el) => po.explosion01 === el):
                po.ex01Type = "fire";
                break;
              case generic.some((el) => po.explosion01 === el):
                po.ex01Type = "generic";
                if (po.explosion01.includes("outpulse")) {
                  po.explosion01 = "outpulse";
                  po.explosion01Variant = po.explosion01Variant === "outpulse02" ? "02" : "01";
                }
                break;
              case ice.some((el) => po.explosion01 === el):
                po.ex01Type = "ice";
                break;
              case liquid.some((el) => po.explosion01 === el):
                po.ex01Type = "liquid";
                po.explosion01 = "splash";
                break;
              case fireball.some((el) => po.explosion01 === el):
                po.ex01Type = "spell";
                po.explosion01 = "fireball";
                po.explosion01Variant = "explode";
                break;
              default:
                po.ex01Type = "spell";
            }
          }
          if (po.explosion02) {
            switch (true) {
              case fire.some((el) => po.explosion02 === el):
                po.ex02Type = "fire";
                break;
              case generic.some((el) => po.explosion02 === el):
                po.ex02Type = "generic";
                if (po.explosion01.includes("outpulse")) {
                  po.explosion01 = "outpulse";
                  po.explosion01Variant = po.explosion01Variant === "outpulse02" ? "02" : "01";
                }
                break;
              case ice.some((el) => po.explosion02 === el):
                po.ex02Type = "ice";
                break;
              case liquid.some((el) => po.explosion02 === el):
                po.ex02Type = "liquid";
                po.explosion02 = "splash";
                break;
              case fireball.some((el) => po.explosion02 === el):
                po.ex02Type = "spell";
                po.explosion02 = "fireball";
                po.explosion02Variant = "explode";
                break;
              default:
                po.ex02Type = "spell";
            }
          }
          break;
      }
    }
  }
  currentAutorec.version = 4;
  return currentAutorec;
}
async function mergeVersion05(data2) {
  let currentAutorec = data2;
  const meleeObject = currentAutorec.melee;
  const rangeObject = currentAutorec.range;
  const staticObject = currentAutorec.static;
  const templateObject = currentAutorec.templates;
  const auraObject = currentAutorec.auras;
  const presetObject = currentAutorec.preset;
  const aefxObject = currentAutorec.aefx;
  const newMenu = {
    melee: [],
    range: [],
    ontoken: [],
    templatefx: [],
    aura: [],
    preset: [],
    aefx: [],
    version: 5
  };
  if (meleeObject) {
    const dataLength = Object.keys(meleeObject).length;
    for (var i = 0; i < dataLength; i++) {
      const oldMO = meleeObject[i];
      let newMO = {};
      let current = await convertV6(oldMO, newMO, "melee");
      newMenu.melee.push(current);
    }
  }
  if (rangeObject) {
    const dataLength = Object.keys(rangeObject).length;
    for (var i = 0; i < dataLength; i++) {
      const oldMO = rangeObject[i];
      let newMO = {};
      let current = await convertV6(oldMO, newMO, "range");
      newMenu.range.push(current);
    }
  }
  if (staticObject) {
    const dataLength = Object.keys(staticObject).length;
    for (var i = 0; i < dataLength; i++) {
      const oldMO = staticObject[i];
      let newMO = {};
      let current = await convertV6(oldMO, newMO, "ontoken");
      newMenu.ontoken.push(current);
    }
  }
  if (templateObject) {
    const dataLength = Object.keys(templateObject).length;
    for (var i = 0; i < dataLength; i++) {
      const oldMO = templateObject[i];
      let newMO = {};
      let current = await convertV6(oldMO, newMO, "templatefx");
      let thunderwaveVariants = ["left", "mid", "center"];
      if (current.primary.video.animation === "thunderwave") {
        if (thunderwaveVariants.some((el) => !current.primary.video.variant.includes(el))) {
          current.primary.video.variant = "center";
        }
      }
      if (current.primary.options?.persistent && current.primary.options?.persistType === "attachtemplate" && current.primary.options?.removeTemplate) {
        current.primary.options.removeTemplate = false;
      }
      newMenu.templatefx.push(current);
    }
  }
  if (auraObject) {
    const dataLength = Object.keys(auraObject).length;
    for (var i = 0; i < dataLength; i++) {
      const oldMO = auraObject[i];
      let newMO = {};
      let current = await convertV6(oldMO, newMO, "aura");
      newMenu.aura.push(current);
    }
  }
  if (presetObject) {
    const presetLength = Object.keys(presetObject).length;
    for (var i = 0; i < presetLength; i++) {
      const oldMO = presetObject[i];
      let newMO = {};
      let current;
      switch (oldMO.animation) {
        case "bardicinspiration":
        case "bless":
        case "shieldspell":
        case "huntersmark":
        case "sneakattack":
          break;
        case "teleportation":
          current = await updateTele(oldMO, newMO);
          current.menu = "preset";
          newMenu.preset.push(current);
          break;
        case "dualattach":
          current = await updateDAttach(oldMO, newMO);
          current.menu = "preset";
          newMenu.preset.push(current);
          break;
        case "fireball":
          current = await updateFireball(oldMO, newMO);
          current.menu = "preset";
          newMenu.preset.push(current);
          break;
        default:
          current = await updateThunderwave(oldMO, newMO);
          current.menu = "preset";
          newMenu.preset.push(current);
      }
    }
  }
  if (aefxObject) {
    const aefxLength = Object.keys(aefxObject).length;
    for (var i = 0; i < aefxLength; i++) {
      const oldMO = aefxObject[i];
      let newMO = {};
      let current;
      switch (oldMO.aeType) {
        case "auras":
          current = await convertAEAura(oldMO, newMO);
          current.activeEffectType = "aura";
          newMenu.aefx.push(current);
          break;
        case "preset":
          switch (oldMO.menuType) {
            case "bless":
              current = await convertAEBless(oldMO, newMO);
              current.activeEffectType = "ontoken";
              newMenu.aefx.push(current);
              break;
            case "shieldspell":
              current = await convertAEShield(oldMO, newMO);
              current.activeEffectType = "ontoken";
              newMenu.aefx.push(current);
              break;
          }
          break;
        default:
          current = await convertAEOnToken(oldMO, newMO);
          current.activeEffectType = "ontoken";
          newMenu.aefx.push(current);
      }
    }
  }
  async function new3d(oldData) {
    let newData = oldData || {};
    let { type, addExplosion, ...rest } = newData;
    const data3d = {
      enable: type ? true : false,
      type: type || "",
      data: rest || {},
      secondary: {
        enable: addExplosion?.enable ?? false,
        data: addExplosion || {}
      },
      sound: setSound({}, "a01", true)
    };
    return data3d;
  }
  function setSound(audio = {}, section2 = "a01", rebase = false) {
    if (rebase) {
      return {
        delay: 0,
        enable: false,
        file: "",
        startTime: 0,
        repeat: 1,
        repeatDelay: 250,
        volume: 1
      };
    } else {
      return {
        delay: audio?.[section2]?.delay ?? 0,
        enable: audio?.[section2]?.enable ?? false,
        file: audio?.[section2]?.file ?? "",
        startTime: audio?.[section2]?.startTime ?? 0,
        volume: audio?.[section2]?.volume ?? 1,
        repeat: 1,
        repeatDelay: 250
      };
    }
  }
  async function convertExplosionV6(exp, audio, oldMO) {
    let data3 = {
      enable: exp?.enable ?? false,
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        delay: exp?.delay ?? 250,
        elevation: exp?.below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: exp?.isMasked ?? false,
        isRadius: true,
        isWait: false,
        opacity: exp?.opacity ?? 1,
        repeat: oldMO.repeat ?? 1,
        repeatDelay: oldMO.delay ?? 0,
        size: exp?.radius ?? 1.5,
        zIndex: exp?.zIndex ?? 1
      },
      sound: setSound(audio, "e01"),
      video: {
        dbSection: "static",
        menuType: exp?.menuType,
        animation: exp?.animation,
        variant: exp?.variant,
        color: exp?.color,
        enableCustom: exp?.enableCustom ?? false,
        customPath: exp?.customPath ?? ""
      }
    };
    const video2 = data3.video;
    if (!video2.menuType || !video2.animation || !video2.variant || !video2.color) {
      data3.video.menuType = "spell";
      data3.video.animation = "curewounds";
      data3.video.variant = "01";
      data3.video.color = "blue";
    }
    return data3;
  }
  async function convertV6(oldMO, newMO, type) {
    let {
      menuType,
      variant,
      custom,
      customPath,
      name,
      animation,
      color,
      audio,
      macro: macro2,
      soundOnly,
      explosion,
      levels3d: levels3d2,
      meleeSwitch: meleeSwitch2,
      ...rest
    } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.label = name;
    if (type !== "aura" && type !== "templatefx") {
      newMO.levels3d = await new3d(levels3d2);
    }
    newMO.macro = macro2 || {};
    if (type === "melee") {
      newMO.meleeSwitch = compileMeleeSwitch(oldMO);
    }
    newMO.menu = type;
    newMO.primary = {
      options: convertOptionsV6(oldMO, type),
      sound: setSound(audio, "a01"),
      video: {
        dbSection: setDBSection(type),
        menuType,
        animation,
        variant,
        color,
        enableCustom: custom,
        customPath
      }
    };
    newMO.secondary = await convertExplosionV6(explosion, audio, oldMO);
    const primaryVideo = newMO.primary.video;
    if (!primaryVideo.menuType || !primaryVideo.animation || !primaryVideo.variant || !primaryVideo.color) {
      resetVideo(newMO.primary.video, type);
    }
    newMO.soundOnly = {
      sound: {
        enable: soundOnly?.enable || false,
        delay: oldMO.audio?.a01?.delay ?? 0,
        startTime: oldMO.audio?.a01?.startTime ?? 0,
        volume: oldMO.audio?.a01?.volume ?? 1,
        file: oldMO.audio?.a01?.file,
        repeat: 1,
        repeatDelay: 250
      }
    };
    newMO.source = newExtraFX();
    newMO.target = newExtraFX(true);
    return newMO;
  }
  function compileMeleeSwitch(oldMO) {
    let oldData = oldMO || {};
    const data3 = {
      video: {
        dbSection: "range",
        menuType: oldData.switchMenuType,
        animation: oldData.switchAnimation,
        variant: oldData.switchVariant,
        color: oldData.switchColor,
        enableCustom: false,
        customPath: ""
      },
      sound: setSound(oldMO?.audio, "a02"),
      options: {
        detect: oldData.detect || "automatic",
        range: oldData.range || 2,
        isReturning: oldData.return ?? false,
        switchType: oldData.switchType || "on"
      }
    };
    const switchVideo = data3.video;
    if (!switchVideo.menuType || !switchVideo.animation || !switchVideo.variant || !switchVideo.color) {
      resetVideo(data3.video, "range");
    }
    return data3;
  }
  function resetVideo(data3, type) {
    switch (type) {
      case "melee":
        data3.menuType = "weapon";
        data3.animation = "dagger";
        data3.variant = "01";
        data3.color = "white";
        break;
      case "range":
        data3.menuType = "weapon";
        data3.animation = "arrow";
        data3.variant = "regular";
        data3.color = "regular";
        break;
      case "templatefx":
        data3.menuType = "circle";
        data3.animation = "calllightning";
        data3.variant = "01";
        data3.color = "blue";
        break;
      default:
        data3.menuType = "spell";
        data3.animation = "curewounds";
        data3.variant = "01";
        data3.color = "blue";
    }
  }
  function convertOptionsV6(oldMO, type) {
    const data3 = {};
    switch (type) {
      case "melee":
        data3.delay = 0;
        data3.elevation = oldMO.below ? 0 : 1e3;
        data3.isWait = false;
        data3.opacity = oldMO.opacity ?? 1;
        data3.repeat = oldMO.repeat ?? 1;
        data3.repeatDelay = oldMO.delay ?? 0;
        data3.size = oldMO.scale ?? 1;
        data3.zIndex = oldMO.zIndex ?? 1;
        break;
      case "range":
        data3.delay = 0;
        data3.elevation = oldMO.below ? 0 : 1e3;
        data3.isReturning = false;
        data3.isWait = false;
        data3.onlyX = oldMO.onlyX ?? false;
        data3.opacity = oldMO.opacity ?? 1;
        data3.repeat = oldMO.repeat ?? 1;
        data3.repeatDelay = oldMO.delay ?? 0;
        data3.zIndex = oldMO.zIndex ?? 1;
        break;
      case "ontoken":
        data3.addTokenWidth = false;
        data3.anchor = "0.5";
        data3.delay = 0;
        data3.elevation = oldMO.below ? 0 : 1e3;
        data3.fadeIn = 250;
        data3.fadeOut = 500;
        data3.isMasked = oldMO.isMasked ?? false;
        data3.isRadius = false;
        data3.isWait = false;
        data3.opacity = oldMO.opacity ?? 1;
        data3.persistent = oldMO.persistent ?? false;
        data3.playOn = oldMO.type === "targetDefault" ? "default" : oldMO.type === "sourceTarget" ? "both" : !oldMO.type ? "default" : oldMO.type;
        data3.repeat = oldMO.repeat ?? 1;
        data3.repeatDelay = oldMO.delay ?? 0;
        data3.size = oldMO.scale ?? 1;
        data3.unbindAlpha = oldMO.unbindAlpha ?? false;
        data3.unbindVisibility = oldMO.unbindVisibility ?? false;
        data3.zIndex = oldMO.zIndex ?? 1;
        break;
      case "templatefx":
        data3.delay = 0;
        data3.elevation = oldMO.below ? 0 : 1e3;
        data3.isMasked = oldMO.isMasked ?? false;
        data3.isWait = false;
        data3.occlusionAlpha = oldMO.occlusionAlpha ?? 0;
        data3.occlusionMode = oldMO.occlusionMode ?? 0;
        data3.opacity = oldMO.opacity ?? 1;
        data3.persistent = oldMO.persist ?? false;
        data3.persistType = oldMO.persistType || "sequencerground";
        data3.removeTemplate = oldMO.removeTemplate ?? 1;
        data3.repeat = oldMO.repeat ?? 1;
        data3.repeatDelay = oldMO.delay ?? 0;
        data3.rotate = 0;
        data3.scale = `${oldMO.scaleX ?? 1}, ${oldMO.scaleY ?? 1}`;
        data3.zIndex = oldMO.zIndex ?? 1;
        break;
      case "aura":
        data3.addTokenWidth = oldMO.addTokenWidth ?? false;
        data3.alpha = false, data3.alphaMax = 0.5, data3.alphaMin = -0.5, data3.alphaDuration = 1e3, data3.breath = false, data3.breathMax = 1.05, data3.breathMin = 0.95, data3.breathDuration = 1e3, data3.delay = 0;
        data3.elevation = oldMO.below ? 0 : 1e3;
        data3.fadeIn = 250;
        data3.fadeOut = 500;
        data3.playOn = oldMO.ignoretargets ? "source" : "default";
        data3.isRadius = true;
        data3.isWait = false;
        data3.opacity = oldMO.opacity ?? 1;
        data3.size = oldMO.scale ?? 3;
        data3.tint = false, data3.tintColor = "#FFFFFF", data3.tintSaturate = 0, data3.unbindAlpha = oldMO.unbindAlpha ?? false;
        data3.unbindVisibility = oldMO.unbindVisibility ?? false;
        data3.zIndex = oldMO.zIndex ?? 1;
        break;
    }
    return data3;
  }
  function newExtraFX(target2 = false) {
    if (target2) {
      return {
        enable: false,
        options: {
          addTokenWidth: false,
          anchor: "0.5",
          delay: 0,
          elevation: 1e3,
          fadeIn: 250,
          fadeOut: 500,
          isMasked: false,
          isWait: false,
          isRadius: false,
          opacity: 1,
          persistent: false,
          repeat: 1,
          repeatDelay: 250,
          size: 1,
          unbindAlpha: false,
          unbindVisibility: false,
          zIndex: 1
        },
        sound: setSound({}, "t01", true),
        video: {
          dbSection: "static",
          menuType: "spell",
          animation: "curewounds",
          variant: "01",
          color: "blue",
          enableCustom: false,
          customPath: ""
        }
      };
    } else {
      return {
        enable: false,
        options: {
          addTokenWidth: false,
          anchor: "0.5",
          delay: 0,
          elevation: 1e3,
          fadeIn: 250,
          fadeOut: 500,
          isMasked: false,
          isRadius: false,
          isWait: true,
          opacity: 1,
          repeat: 1,
          repeatDelay: 250,
          size: 1,
          zIndex: 1
        },
        sound: setSound({}, "s01", true),
        video: {
          dbSection: "static",
          menuType: "spell",
          animation: "curewounds",
          variant: "01",
          color: "blue",
          enableCustom: false,
          customPath: ""
        }
      };
    }
  }
  function setDBSection(type) {
    return type === "aura" || type === "ontoken" ? "static" : type;
  }
  async function updateTele(oldData, newData) {
    newData.id = Hashing.uuidv4();
    newData.data = {};
    const root = newData.data;
    let {
      menuType,
      subAnimation,
      variant,
      color,
      below,
      custom,
      customPath,
      hideTemplate,
      name,
      range: range2,
      measureType,
      scale,
      menuType02,
      subAnimation02,
      variant02,
      color02,
      scale02,
      custom02,
      customPath02,
      macro: macro2,
      delay,
      audio,
      soundOnly
    } = oldData;
    newData.macro = macro2 || {};
    newData.presetType = "teleportation";
    newData.label = name;
    root.options = {
      alpha: 0,
      delayFade: 750,
      delayMove: 1e3,
      delayReturn: delay ?? 250,
      hideFromPlayers: hideTemplate ?? false,
      measureType: measureType ?? "alternating",
      range: range2 ?? 30,
      speed: 120,
      teleport: true
    };
    root.sound = setSound(audio, "a01");
    root.start = {
      enable: true,
      dbSection: "static",
      menuType,
      animation: subAnimation,
      variant,
      color,
      enableCustom: custom || false,
      customPath,
      options: {
        delay: 0,
        elevation: below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 250,
        isMasked: false,
        opacity: 1,
        isRadius: false,
        size: scale || 1.5
      }
    };
    root.between = {
      dbSection: "range",
      enable: false,
      menuType: "weapon",
      animation: "arrow",
      variant: "regular",
      color: "regular",
      options: {
        delay: 0,
        elevation: 1e3,
        opacity: 1,
        playbackRate: 1
      }
    };
    root.end = {
      enable: true,
      dbSection: "static",
      menuType: menuType02,
      animation: subAnimation02,
      variant: variant02,
      color: color02,
      enableCustom: custom02 || false,
      customPath: customPath02,
      options: {
        delay: 500,
        elevation: below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 250,
        isMasked: false,
        isRadius: false,
        opacity: 1,
        size: scale02 ?? 1
      }
    };
    if (!root.start.menuType || !root.start.animation || !root.start.variant || !root.start.color) {
      resetVideo(root.start, "static");
    }
    if (!root.end.menuType || !root.end.animation || !root.end.variant || !root.end.color) {
      resetVideo(root.end, "static");
    }
    newData.soundOnly = {
      sound: {
        enable: soundOnly?.enable || false,
        delay: oldData.audio?.a01?.delay ?? 0,
        startTime: oldData.audio?.a01?.startTime ?? 0,
        volume: oldData.audio?.a01?.volume ?? 1,
        file: oldData.audio?.a01?.file
      }
    };
    return newData;
  }
  async function updateDAttach(oldData, newData) {
    newData.id = Hashing.uuidv4();
    let { name, below, macro: macro2, audio, menuType, subAnimation, variant, color, custom, customPath, playbackRate, onlyX, soundOnly } = oldData;
    newData.macro = macro2 || {};
    newData.presetType = "dualattach";
    newData.label = name;
    newData.data = {
      video: {
        dbSection: "range",
        menuType,
        animation: subAnimation,
        variant,
        color,
        enableCustom: custom || false,
        customPath: customPath || ""
      },
      options: {
        playbackRate,
        onlyX,
        opacity: 1,
        elevation: below ? 0 : 1e3
      },
      sound: setSound(audio, "a01")
    };
    if (!newData.data.video.menuType || !newData.data.video.animation || !newData.data.video.variant || !newData.data.video.color) {
      resetVideo(newData.data.video, "range");
    }
    newData.soundOnly = {
      sound: {
        enable: soundOnly?.enable || false,
        delay: oldData.audio?.a01?.delay ?? 0,
        startTime: oldData.audio?.a01?.startTime ?? 0,
        volume: oldData.audio?.a01?.volume ?? 1,
        file: oldData.audio?.a01?.file
      }
    };
    return newData;
  }
  async function updateFireball(oldData, newData) {
    newData.id = Hashing.uuidv4();
    newData.data = {};
    const root = newData.data;
    let {
      audio,
      macro: macro2,
      name,
      below,
      animation,
      rangeType,
      projectile,
      projectilVariant,
      projectileColor,
      projectileRepeat,
      projectileDelay,
      wait01,
      removeTemplate,
      ex01Type,
      explosion01,
      explosion01Variant,
      explosion01Color,
      explosion01Repeat,
      explosion01Delay,
      explosion01Scale,
      wait02,
      ex02Type,
      explosion02,
      explosion02Variant,
      explosion02Color,
      explosion02Repeat,
      explosion02Delay,
      explosion02Scale,
      afterEffect,
      afterEffectPath,
      wait03,
      soundOnly
    } = oldData;
    newData.macro = macro2 || {};
    newData.presetType = "proToTemp";
    newData.label = name;
    root.projectile = {
      dbSection: "range",
      menuType: rangeType,
      animation: projectile,
      variant: projectilVariant,
      color: projectileColor,
      options: {
        repeat: projectileRepeat,
        repeatDelay: projectileDelay,
        wait: wait01,
        elevation: below ? 0 : 1e3,
        removeTemplate
      },
      sound: setSound(audio, "a01")
    };
    if (!root.projectile.menuType || !root.projectile.animation || !root.projectile.variant || !root.projectile.color) {
      resetVideo(root.projectile, "range");
    }
    root.preExplosion = {
      dbSection: "static",
      menuType: ex01Type,
      animation: explosion01,
      variant: explosion01Variant,
      color: explosion01Color,
      options: {
        repeat: explosion01Repeat,
        repeatDelay: explosion01Delay,
        scale: explosion01Scale,
        wait: wait02,
        elevation: below ? 0 : 1e3
      },
      sound: setSound(audio, "e01")
    };
    if (!root.preExplosion.menuType || !root.preExplosion.animation || !root.preExplosion.variant || !root.preExplosion.color) {
      root.preExplosion.enable = false;
      resetVideo(root.preExplosion, "static");
    } else {
      root.preExplosion.enable = true;
    }
    root.explosion = {
      dbSection: "static",
      menuType: ex02Type,
      animation: explosion02,
      variant: explosion02Variant,
      color: explosion02Color,
      options: {
        elevation: below ? 0 : 1e3,
        repeat: explosion02Repeat,
        repeatDelay: explosion02Delay,
        scale: explosion02Scale,
        wait: wait03
      },
      sound: setSound(audio, "e01")
    };
    if (!root.explosion.menuType || !root.explosion.animation || !root.explosion.variant || !root.explosion.color) {
      resetVideo(root.explosion, "range");
    }
    root.afterImage = {
      enable: afterEffect,
      customPath: afterEffectPath,
      options: {
        elevation: 0,
        persistent: false,
        scale: 1
      }
    };
    newData.soundOnly = {
      sound: {
        enable: soundOnly?.enable || false,
        delay: oldData.audio?.a01?.delay ?? 0,
        startTime: oldData.audio?.a01?.startTime ?? 0,
        volume: oldData.audio?.a01?.volume ?? 1,
        file: oldData.audio?.a01?.file
      }
    };
    newData.secondary = {
      enable: false,
      options: {
        addTokenWidth: false,
        delay: 250,
        elevation: 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: true,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 0,
        size: 1.5,
        zIndex: 1
      },
      sound: setSound(audio, "e01"),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newData.target = newExtraFX(true);
    return newData;
  }
  async function updateThunderwave(oldData, newData) {
    newData.id = Hashing.uuidv4();
    let { audio, macro: macro2, name, below, color, repeat, delay, scaleX, scaleY, opacity, removeTemplate, persist: persistent, persistType, occlusionMode, occlusionAlpha, soundOnly } = oldData;
    newData.macro = macro2 || {};
    newData.label = name;
    newData.presetType = "thunderwave";
    newData.data = {
      video: {
        dbSection: "templatefx",
        menuType: "square",
        animation: "thunderwave",
        variant: "mid",
        color: color || "blue"
      },
      options: {
        elevation: below ? 0 : 1e3,
        repeat: repeat || 1,
        repeatDelay: delay ?? 250,
        opacity: opacity ?? 1,
        removeTemplate: removeTemplate ?? false
      },
      sound: setSound(audio, "a01")
    };
    newData.soundOnly = {
      sound: {
        enable: soundOnly?.enable || false,
        delay: oldData.audio?.a01?.delay ?? 0,
        startTime: oldData.audio?.a01?.startTime ?? 0,
        volume: oldData.audio?.a01?.volume ?? 1,
        file: oldData.audio?.a01?.file
      }
    };
    return newData;
  }
  async function convertAEOnToken(oldMO, newMO) {
    let {
      aeDelay,
      aeType,
      animation,
      audio,
      below,
      color,
      custom,
      customPath,
      delay,
      explosion,
      macro: macro2,
      menuType,
      name,
      opacity,
      persistent,
      repeat,
      scale,
      soundOnly,
      type,
      unbindAlpha,
      unbindVisibility,
      variant
    } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.label = name;
    newMO.menu = "aefx";
    newMO.secondary = await convertExplosionV6(explosion, audio, oldMO);
    newMO.primary = {
      options: {
        addTokenWidth: false,
        elevation: below ? 0 : 1e3,
        delay: delay || 250,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: opacity || 1,
        persistent: persistent || false,
        playOn: "source",
        repeat: repeat || 1,
        size: scale || 1,
        unbindAlpha: unbindAlpha || false,
        unbindVisibility: unbindVisibility || false,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        animation,
        color,
        customPath: customPath || "",
        dbSection: "static",
        enableCustom: custom || false,
        menuType,
        variant
      }
    };
    const newVideo = newMO.primary.video;
    if (!newVideo.menuType || !newVideo.animation || !newVideo.variant || !newVideo.color) {
      resetVideo(newMO.primary.video);
    }
    newMO.macro = macro2 || {};
    newMO.soundOnly = {
      sound: {
        delay: audio?.a01?.delay ?? 0,
        enable: soundOnly?.enable ?? false,
        file: audio?.a01?.file ?? "",
        startTime: audio?.a01?.startTime ?? 0,
        volume: audio?.a01?.volume ?? 1
      }
    };
    newMO.source = newExtraFX();
    return newMO;
  }
  async function convertAEAura(oldMO, newMO) {
    let {
      aeDelay,
      aeType,
      animation,
      audio,
      below,
      color,
      custom,
      customPath,
      macro: macro2,
      menuType,
      name,
      opacity,
      scale,
      soundOnly,
      type,
      unbindAlpha,
      unbindVisibility,
      variant
    } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.label = name;
    newMO.menu = "aefx";
    newMO.secondary = {
      enable: false,
      options: {},
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue"
      }
    };
    newMO.primary = {
      options: {
        addTokenWidth: false,
        alpha: false,
        alphaMax: 0.5,
        alphaMin: -0.5,
        alphaDuration: 1e3,
        breath: false,
        breathMax: 1.05,
        breathMin: 0.95,
        breathDuration: 1e3,
        delay: 0,
        elevation: below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isRadius: true,
        isWait: true,
        opacity: opacity || 1,
        playOn: "source",
        size: scale || 1,
        tint: false,
        tintColor: "#FFFFFF",
        tintSaturate: 0,
        unbindAlpha: unbindAlpha || false,
        unbindVisibility: unbindVisibility || false,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        animation,
        color,
        customPath: customPath || "",
        dbSection: "static",
        enableCustom: custom || false,
        menuType,
        variant
      }
    };
    const newVideo = newMO.primary.video;
    if (!newVideo.menuType || !newVideo.animation || !newVideo.variant || !newVideo.color) {
      resetVideo(newMO.primary.video);
    }
    newMO.macro = macro2 || {};
    newMO.soundOnly = {
      sound: {
        delay: audio?.a01?.delay ?? 0,
        enable: soundOnly?.enable ?? false,
        file: audio?.a01?.file ?? "",
        startTime: audio?.a01?.startTime ?? 0,
        volume: audio?.a01?.volume ?? 1
      }
    };
    newMO.source = newExtraFX();
    return newMO;
  }
  async function convertAEBless(oldMO, newMO) {
    let {
      addCTA,
      aeType,
      animation,
      audio,
      below,
      color,
      custom,
      macro: macro2,
      menuType,
      name,
      scale,
      soundOnly,
      type,
      unbindAlpha,
      unbindVisibility,
      variant
    } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.label = name;
    newMO.menu = "aefx";
    newMO.macro = macro2 || {};
    newMO.primary = {
      options: {
        addTokenWidth: false,
        delay: 0,
        elevation: below ? 0 : 1e3,
        fadeIn: 0,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: true,
        opacity: 1,
        persistent: addCTA || false,
        playOn: "source",
        repeat: 1,
        repeatDelay: 250,
        size: scale || 1,
        unbindAlpha: unbindAlpha || false,
        unbindVisibility: unbindVisibility || false,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "bless",
        variant: "intro",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.secondary = {
      enable: false,
      options: {},
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.soundOnly = {
      sound: {
        enable: soundOnly?.enable || false,
        delay: oldMO.audio?.a01?.delay ?? 0,
        startTime: oldMO.audio?.a01?.startTime ?? 0,
        volume: oldMO.audio?.a01?.volume ?? 1,
        file: oldMO.audio?.a01?.file
      }
    };
    newMO.source = {
      enable: true,
      options: {
        addTokenWidth: false,
        delay: -500,
        elevation: below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: true,
        opacity: 1,
        repeat: 1,
        repeatDelay: 250,
        size: scale || 1,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        dbSection: "static",
        menuType: "spell",
        animation: "bless",
        variant: "intro",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    return newMO;
  }
  async function convertAEShield(oldMO, newMO) {
    let {
      addCTA,
      aeType,
      animation,
      audio,
      below,
      color,
      custom,
      endEffect,
      macro: macro2,
      menuType,
      name,
      scale,
      soundOnly,
      type,
      unbindAlpha,
      unbindVisibility,
      variant
    } = oldMO;
    newMO.id = Hashing.uuidv4();
    newMO.label = name;
    newMO.menu = "aefx";
    newMO.primary = {
      options: {
        isWait: true,
        delay: -1e3,
        elevation: below ? 0 : 1e3,
        fadeIn: 250,
        fadeOut: 0,
        isMasked: false,
        isRadius: false,
        opacity: 1,
        persistent: addCTA || false,
        repeat: 1,
        repeatDelay: 250,
        size: scale ?? 1,
        playOn: "source",
        unbindAlpha: unbindAlpha ?? false,
        unbindVisibility: unbindVisibility ?? false,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "shieldspell",
        animation: "loop",
        variant: variant || "01",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.source = {
      enable: true,
      options: {
        addTokenWidth: false,
        delay: -500,
        elevation: below ? 0 : 1e3,
        fadeIn: 500,
        fadeOut: 0,
        isMasked: false,
        isRadius: false,
        isWait: true,
        opacity: 1,
        repeat: 1,
        repeatDelay: 250,
        size: scale || 1,
        zIndex: 1
      },
      sound: setSound(audio, "a01"),
      video: {
        dbSection: "static",
        menuType: "shieldspell",
        animation: "intro",
        variant: variant || "01",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.secondary = {
      options: {
        delay: 0,
        elevation: below ? 0 : 1e3,
        isMasked: false,
        isRadius: false,
        isWait: false,
        repeat: 1,
        repeatDelay: 250,
        size: scale || 1,
        opacity: 1,
        zIndex: 1
      },
      sound: setSound({}, "a01", true),
      video: {
        dbSection: "static",
        menuType: "shieldspell",
        animation: endEffect || "outro_explode",
        variant: variant || "01",
        color: color || "blue",
        enableCustom: false,
        customPath: ""
      }
    };
    newMO.macro = macro2 || {};
    newMO.soundOnly = {
      sound: {
        delay: audio?.a01?.delay ?? 0,
        enable: soundOnly?.enable ?? false,
        file: audio?.a01?.file ?? "",
        startTime: audio?.a01?.startTime ?? 0,
        volume: audio?.a01?.volume ?? 1
      }
    };
    return newMO;
  }
  return newMenu;
}
class AutorecSanitizer {
  static getMenu() {
    let menu = AAAutorecManager.getAutorecEntries();
    delete menu.version;
    return menu;
  }
  static async checkForDuplicates() {
    let menu = this.getMenu();
    let menuKeys = Object.keys(menu);
    for (let i = 0; i < menuKeys.length; i++) {
      var valueArr = menu[menuKeys[i]].map(function(item2) {
        return item2.id;
      });
      var isDuplicate = valueArr.some(function(item2, idx) {
        return valueArr.indexOf(item2) != idx;
      });
      if (isDuplicate) {
        custom_error$1(`The ${game.i18n.localize(`autoanimations.animTypes.${menuKeys[i]}`)} Global Menu contains Duplicate ID's, commencing Sanitization`);
        await this.cleanIds(menuKeys[i], menu);
      }
    }
  }
  static async cleanIds(menuId, menu) {
    let sanitizedMenu = menu[menuId];
    sanitizedMenu.forEach((section2) => section2.id = Hashing.uuidv4());
    game.settings.set("autoanimations", `aaAutorec-${menuId}`, sanitizedMenu);
    custom_error$1(`The ${game.i18n.localize(`autoanimations.animTypes.${menuId}`)} Global Menu has been corrected from catastrophic errors. Please refresh your game world`);
  }
  static newSectionIds(menu) {
    menu.forEach((section2) => section2.id = Hashing.uuidv4());
    return menu;
  }
}
function currentAutorecVersion() {
  return Object.keys(autoRecMigration.migrations).map((n) => Number(n)).reverse()[0];
}
const autoRecMigration = {
  /**
   * 
   * @param {*} autoObject 
   * @param {
   * shouldSubmit: Boolean (Merges should be submitted), 
   * newSchema: Boolean (Is a new data Schema?), 
   * submitAll: Boolean (A-A ONLY override to submit ALL merged Menus)
   * } options 
   * @returns 
   */
  async handle(autoObject, options2 = {}) {
    if (options2.newSchema) {
      ui.notifications.info("Automated Animations | Exporting your Global Automatic Recognition Menu before running Migration");
      const data2 = game.settings.get("autoanimations", "aaAutorec");
      const filename = `Autorec-Menu-Backup`;
      saveDataToFile(JSON.stringify(data2, null, 2), "text/json", filename);
      autoObject = {
        melee: game.settings.get("autoanimations", "aaAutorec-melee"),
        range: game.settings.get("autoanimations", "aaAutorec-range"),
        ontoken: game.settings.get("autoanimations", "aaAutorec-ontoken"),
        templatefx: game.settings.get("autoanimations", "aaAutorec-templatefx"),
        aura: game.settings.get("autoanimations", "aaAutorec-aura"),
        preset: game.settings.get("autoanimations", "aaAutorec-preset"),
        aefx: game.settings.get("autoanimations", "aaAutorec-aefx"),
        version: game.settings.get("autoanimations", "aaAutorec").version
      };
    }
    if (!autoObject) {
      return;
    }
    if (this.upToDate(autoObject) && !options2.isOverwrite) {
      return autoObject;
    }
    ui.notifications.info("Automated Animations: Updating the Automatic Recognition Menu");
    let currentAutorec = autoObject;
    for (let [version, migration] of Object.entries(this.migrations)) {
      let flagVersion = currentAutorec.version;
      if (flagVersion >= Number(version)) continue;
      currentAutorec = await migration(currentAutorec);
    }
    if (!options2.shouldSubmit) {
      return currentAutorec;
    } else {
      if (options2.melee || options2.submitAll) {
        let newMelee = AutorecSanitizer.newSectionIds(currentAutorec.melee);
        await game.settings.set("autoanimations", "aaAutorec-melee", newMelee);
      }
      if (options2.range || options2.submitAll) {
        let newRange = AutorecSanitizer.newSectionIds(currentAutorec.range);
        await game.settings.set("autoanimations", "aaAutorec-range", newRange);
      }
      if (options2.ontoken || options2.submitAll) {
        let newOnToken = AutorecSanitizer.newSectionIds(currentAutorec.ontoken);
        await game.settings.set("autoanimations", "aaAutorec-ontoken", newOnToken);
      }
      if (options2.templatefx || options2.submitAll) {
        let newTemplateFx = AutorecSanitizer.newSectionIds(currentAutorec.templatefx);
        await game.settings.set("autoanimations", "aaAutorec-templatefx", newTemplateFx);
      }
      if (options2.aura || options2.submitAll) {
        let newAura = AutorecSanitizer.newSectionIds(currentAutorec.aura);
        await game.settings.set("autoanimations", "aaAutorec-aura", newAura);
      }
      if (options2.preset || options2.submitAll) {
        let newPreset = AutorecSanitizer.newSectionIds(currentAutorec.preset);
        await game.settings.set("autoanimations", "aaAutorec-preset", newPreset);
      }
      if (options2.aefx || options2.submitAll) {
        let newAefx = AutorecSanitizer.newSectionIds(currentAutorec.aefx);
        await game.settings.set("autoanimations", "aaAutorec-aefx", newAefx);
      }
      if (Object.keys(this.migrations).map((n) => Number(n)).reverse()[0] === 5) {
        game.settings.set("autoanimations", "aaAutorec", { version: 5 });
      } else {
        let versionHandler = game.settings.get("autoanimations", "aaAutorec");
        versionHandler.version = Object.keys(this.migrations).map((n) => Number(n)).reverse()[0];
        await game.settings.set("autoanimations", "aaAutorec", versionHandler);
      }
    }
    ui.notifications.info("Automatic Recognition Menu update is Complete!");
  },
  upToDate(autoObject) {
    const currentFlagVersion = Object.keys(this.migrations).map((n) => Number(n)).reverse()[0];
    return autoObject.version >= currentFlagVersion;
  },
  migrations: {
    "1": async (currentAutorec) => {
      return await mergeVersion01(currentAutorec);
    },
    "2": async (currentAutorec) => {
      return await mergeVersion02(currentAutorec);
    },
    "3": async (currentAutorec) => {
      return await mergeVersion03(currentAutorec);
    },
    "4": async (currentAutorec) => {
      return await mergeVersion04(currentAutorec);
    },
    "5": async (currentAutorec) => {
      return await mergeVersion05(currentAutorec);
    }
  }
};
function set(obj2, key, val) {
  if (typeof val.value === "object") val.value = klona(val.value);
  if (!val.enumerable || val.get || val.set || !val.configurable || !val.writable || key === "__proto__") {
    Object.defineProperty(obj2, key, val);
  } else obj2[key] = val.value;
}
function klona(x) {
  if (typeof x !== "object") return x;
  var i = 0, k, list, tmp, str = Object.prototype.toString.call(x);
  if (str === "[object Object]") {
    tmp = Object.create(x.__proto__ || null);
  } else if (str === "[object Array]") {
    tmp = Array(x.length);
  } else if (str === "[object Set]") {
    tmp = /* @__PURE__ */ new Set();
    x.forEach(function(val) {
      tmp.add(klona(val));
    });
  } else if (str === "[object Map]") {
    tmp = /* @__PURE__ */ new Map();
    x.forEach(function(val, key) {
      tmp.set(klona(key), klona(val));
    });
  } else if (str === "[object Date]") {
    tmp = /* @__PURE__ */ new Date(+x);
  } else if (str === "[object RegExp]") {
    tmp = new RegExp(x.source, x.flags);
  } else if (str === "[object DataView]") {
    tmp = new x.constructor(klona(x.buffer));
  } else if (str === "[object ArrayBuffer]") {
    tmp = x.slice(0);
  } else if (str.slice(-6) === "Array]") {
    tmp = new x.constructor(x);
  }
  if (tmp) {
    for (list = Object.getOwnPropertySymbols(x); i < list.length; i++) {
      set(tmp, list[i], Object.getOwnPropertyDescriptor(x, list[i]));
    }
    for (i = 0, list = Object.getOwnPropertyNames(x); i < list.length; i++) {
      if (Object.hasOwnProperty.call(tmp, k = list[i]) && tmp[k] === x[k]) continue;
      set(tmp, k, Object.getOwnPropertyDescriptor(x, k));
    }
  }
  return tmp || x;
}
function deepMerge(target2, ...sourceObj) {
  if (Object.prototype.toString.call(target2) !== "[object Object]") {
    throw new TypeError(`deepMerge error: 'target' is not an object.`);
  }
  if (sourceObj.length === 0) {
    throw new TypeError(`deepMerge error: 'sourceObj' is not an object.`);
  }
  for (let cntr = 0; cntr < sourceObj.length; cntr++) {
    if (Object.prototype.toString.call(sourceObj[cntr]) !== "[object Object]") {
      throw new TypeError(`deepMerge error: 'sourceObj[${cntr}]' is not an object.`);
    }
  }
  if (sourceObj.length === 1) {
    const stack = [];
    for (const obj2 of sourceObj) {
      stack.push({ target: target2, source: obj2 });
    }
    while (stack.length > 0) {
      const { target: target3, source: source2 } = stack.pop();
      for (const prop in source2) {
        if (Object.hasOwn(source2, prop)) {
          const sourceValue = source2[prop];
          const targetValue = target3[prop];
          if (Object.hasOwn(target3, prop) && targetValue?.constructor === Object && sourceValue?.constructor === Object) {
            stack.push({ target: targetValue, source: sourceValue });
          } else {
            target3[prop] = sourceValue;
          }
        }
      }
    }
  } else {
    const stack = [{ target: target2, sources: sourceObj }];
    while (stack.length > 0) {
      const { target: target3, sources } = stack.pop();
      for (const source2 of sources) {
        for (const prop in source2) {
          if (Object.hasOwn(source2, prop)) {
            const sourceValue = source2[prop];
            const targetValue = target3[prop];
            if (Object.hasOwn(target3, prop) && targetValue?.constructor === Object && sourceValue?.constructor === Object) {
              target3[prop] = Object.assign({}, targetValue);
              stack.push({ target: target3[prop], sources: [sourceValue] });
            } else {
              target3[prop] = sourceValue;
            }
          }
        }
      }
    }
  }
  return target2;
}
function hasGetter(object, accessor) {
  if (typeof object !== "object" || object === null || object === void 0) {
    return false;
  }
  const iDescriptor = Object.getOwnPropertyDescriptor(object, accessor);
  if (iDescriptor !== void 0 && iDescriptor.get !== void 0) {
    return true;
  }
  for (let o = Object.getPrototypeOf(object); o; o = Object.getPrototypeOf(o)) {
    const descriptor = Object.getOwnPropertyDescriptor(o, accessor);
    if (descriptor !== void 0 && descriptor.get !== void 0) {
      return true;
    }
  }
  return false;
}
function hasPrototype(target2, Prototype) {
  if (typeof target2 !== "function") {
    return false;
  }
  if (target2 === Prototype) {
    return true;
  }
  for (let proto = Object.getPrototypeOf(target2); proto; proto = Object.getPrototypeOf(proto)) {
    if (proto === Prototype) {
      return true;
    }
  }
  return false;
}
function isIterable(value) {
  if (value === null || value === void 0 || typeof value !== "object") {
    return false;
  }
  return Symbol.iterator in value;
}
function isObject(value) {
  return value !== null && typeof value === "object" && !Array.isArray(value);
}
function isPlainObject(value) {
  if (Object.prototype.toString.call(value) !== "[object Object]") {
    return false;
  }
  const prototype = Object.getPrototypeOf(value);
  return prototype === null || prototype === Object.prototype;
}
function safeAccess(data2, accessor, defaultValue) {
  if (typeof data2 !== "object" || data2 === null) {
    return defaultValue;
  }
  if (typeof accessor !== "string") {
    return defaultValue;
  }
  const keys = accessor.split(".");
  let result = data2;
  for (let cntr = 0; cntr < keys.length; cntr++) {
    if (result[keys[cntr]] === void 0 || result[keys[cntr]] === null) {
      return defaultValue;
    }
    result = result[keys[cntr]];
  }
  return result;
}
function safeSet(data2, accessor, value, { operation = "set", createMissing = false } = {}) {
  if (typeof data2 !== "object" || data2 === null) {
    throw new TypeError(`safeSet error: 'data' is not an object.`);
  }
  if (typeof accessor !== "string") {
    throw new TypeError(`safeSet error: 'accessor' is not a string.`);
  }
  if (typeof operation !== "string") {
    throw new TypeError(`safeSet error: 'options.operation' is not a string.`);
  }
  if (operation !== "add" && operation !== "div" && operation !== "mult" && operation !== "set" && operation !== "set-undefined" && operation !== "sub") {
    throw new Error(`safeSet error: Unknown 'options.operation'.`);
  }
  if (typeof createMissing !== "boolean") {
    throw new TypeError(`safeSet error: 'options.createMissing' is not a boolean.`);
  }
  const access = accessor.split(".");
  let result = false;
  if (access.length === 1 && !createMissing && !(access[0] in data2)) {
    return false;
  }
  for (let cntr = 0; cntr < access.length; cntr++) {
    if (Array.isArray(data2)) {
      const number = +access[cntr];
      if (!Number.isInteger(number) || number < 0) {
        return false;
      }
    }
    if (cntr === access.length - 1) {
      switch (operation) {
        case "add":
          data2[access[cntr]] += value;
          result = true;
          break;
        case "div":
          data2[access[cntr]] /= value;
          result = true;
          break;
        case "mult":
          data2[access[cntr]] *= value;
          result = true;
          break;
        case "set":
          data2[access[cntr]] = value;
          result = true;
          break;
        case "set-undefined":
          if (data2[access[cntr]] === void 0) {
            data2[access[cntr]] = value;
          }
          result = true;
          break;
        case "sub":
          data2[access[cntr]] -= value;
          result = true;
          break;
      }
    } else {
      if (createMissing && data2[access[cntr]] === void 0) {
        data2[access[cntr]] = {};
      }
      if (data2[access[cntr]] === null || typeof data2[access[cntr]] !== "object") {
        return false;
      }
      data2 = data2[access[cntr]];
    }
  }
  return result;
}
function localize(stringId, data2) {
  const result = !isObject(data2) ? globalThis.game.i18n.localize(stringId) : globalThis.game.i18n.format(stringId, data2);
  return result !== void 0 ? result : "";
}
function sound({ enable = false, delay = 0, file = void 0, startTime = 0, volume = 0.75, repeat = 1, repeatDelay = 250 } = {}) {
  return {
    enable,
    delay,
    file,
    repeat,
    repeatDelay,
    startTime,
    volume
  };
}
function secondary() {
  return {
    enable: false,
    video: { dbSection: "static", menuType: "spell", animation: "curewounds", variant: "01", color: "blue", enableCustom: false, customPath: "" },
    sound: sound(),
    options: {
      addTokenWidth: false,
      anchor: "0.5",
      contrast: 0,
      delay: 0,
      elevation: 1e3,
      fadeIn: 250,
      fadeOut: 500,
      isMasked: false,
      isRadius: true,
      isWait: false,
      opacity: 1,
      repeat: 1,
      repeatDelay: 250,
      saturate: 0,
      size: 1.5,
      tint: false,
      tintColor: "#FFFFFF",
      zIndex: 1
    }
  };
}
function levels3d() {
  return {
    type: "explosion",
    data: {
      alpha: void 0,
      arc: void 0,
      color01: "#FFFFFF",
      color02: "#FFFFFF",
      delay: void 0,
      emittersize: void 0,
      gravity: void 0,
      life: void 0,
      mass: void 0,
      rate: void 0,
      repeat: void 0,
      scale: void 0,
      speed: void 0,
      spritePath: "modules/levels-3d-preview/assets/particles/dust.png"
    },
    sound: { enable: false },
    secondary: {
      enable: false,
      data: {
        alpha: void 0,
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        emittersize: void 0,
        gravity: void 0,
        life: void 0,
        mass: void 0,
        rate: void 0,
        scale: void 0,
        speed: void 0,
        spritePath: "modules/levels-3d-preview/assets/particles/dust.png"
      }
    }
  };
}
function macro() {
  return {
    enable: false,
    name: void 0,
    args: void 0,
    playWhen: void 0
  };
}
function main({ label, soundOnly }) {
  if (typeof label !== "string") {
    throw new TypeError(`'label' is not a string.`);
  }
  return {
    id: Hashing.uuidv4(),
    label: `autoanimations.animations.${label}`,
    soundOnly: {
      sound: {
        delay: 0,
        enable: false,
        startTime: 0,
        volume: 0.75
      }
    }
  };
}
function video({ menuType, animation, variant, color, enableCustom = false, customPath = "", dbSection } = {}) {
  if (menuType !== void 0 && typeof menuType !== "string") {
    throw new TypeError(`'menuType' is not a string.`);
  }
  if (animation !== void 0 && typeof animation !== "string") {
    throw new TypeError(`'animation' is not a string.`);
  }
  if (variant !== void 0 && typeof variant !== "string") {
    throw new TypeError(`'variant' is not a string.`);
  }
  if (color !== void 0 && typeof color !== "string") {
    throw new TypeError(`'color' is not a string.`);
  }
  if (typeof enableCustom !== "boolean") {
    throw new TypeError(`'enableCustom' is not a boolean.`);
  }
  if (typeof customPath !== "string") {
    throw new TypeError(`'customPath' is not a string.`);
  }
  return {
    dbSection,
    menuType,
    animation,
    variant,
    color,
    enableCustom,
    customPath
  };
}
function primary({ video: video$1 = {}, sound: sound$1 = {}, options: options2 = {}, dbSection = "" } = {}) {
  return {
    video: video(video$1),
    sound: sound(sound$1),
    options: options2
  };
}
function source() {
  return {
    enable: false,
    video: { dbSection: "static", menuType: "spell", animation: "curewounds", variant: "01", color: "blue", enableCustom: false, customPath: "" },
    sound: sound(),
    options: {
      addTokenWidth: false,
      anchor: "0.5",
      contrast: 0,
      delay: 0,
      elevation: 1e3,
      fadeIn: 250,
      fadeOut: 500,
      isMasked: false,
      isRadius: false,
      isWait: true,
      opacity: 1,
      repeat: 1,
      repeatDelay: 250,
      saturate: 0,
      size: 1,
      tint: false,
      tintColor: "#FFFFFF",
      zIndex: 1
    }
  };
}
function target() {
  return {
    enable: false,
    video: { dbSection: "static", menuType: "spell", animation: "curewounds", variant: "01", color: "blue", enableCustom: false, customPath: "" },
    sound: sound(),
    options: {
      addTokenWidth: false,
      anchor: "0.5",
      contrast: 0,
      delay: 0,
      elevation: 1e3,
      fadeIn: 250,
      fadeOut: 500,
      isMasked: false,
      //isWait: false,
      isRadius: false,
      opacity: 1,
      persistent: false,
      repeat: 1,
      repeatDelay: 250,
      saturate: 0,
      size: 1,
      tint: false,
      tintColor: "#FFFFFF",
      unbindAlpha: false,
      unbindVisibility: false,
      zIndex: 1
    }
  };
}
function meleeSwitch() {
  return {
    video: {
      dbSection: "range",
      menuType: "weapon",
      animation: "arrow",
      variant: "regular",
      color: "regular"
    },
    sound: sound(),
    options: {
      detect: "automatic",
      range: 2,
      returning: false,
      switchType: "on"
    }
  };
}
const aefx$2 = [
  {
    ...main({ label: "frightened" }),
    menu: "aefx",
    metaData: { default: true },
    activeEffectType: "ontoken",
    primary: {
      options: {
        addTokenWidth: true,
        delay: 0,
        elevation: 1e3,
        isMasked: false,
        isRadius: true,
        isWait: false,
        opacity: 0.75,
        persistent: true,
        playOn: "source",
        repeat: 1,
        size: 0.75,
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      },
      sound: { enable: false },
      video: { dbSection: "static", menuType: "conditions", animation: "horror", variant: "01", color: "purple" }
    },
    source: source(),
    macro: macro(),
    secondary: secondary()
  }
];
const aura$2 = [
  {
    ...main({ label: "spiritguardians" }),
    menu: "aura",
    metaData: { default: true },
    macro: macro(),
    primary: primary({
      video: { dbSection: "static", menuType: "spell", animation: "spiritguardians", variant: "01", color: "yellowblue" },
      options: {
        addTokenWidth: true,
        alpha: false,
        alphaMax: 0.5,
        alphaMin: -0.5,
        alphaDuration: 1e3,
        breath: false,
        breathMax: 1.05,
        breathMin: 0.95,
        breathDuration: 1e3,
        delay: 0,
        elevation: 0,
        fadeIn: 250,
        fadeOut: 500,
        isRadius: true,
        isWait: false,
        opacity: 0.75,
        playOn: "source",
        size: 3,
        tint: false,
        tintColor: "#FFFFFF",
        tintSaturate: 0,
        unbindAlpha: false,
        unbindVisbility: false,
        zIndex: 1
      }
    }),
    secondary: secondary(),
    source: source(),
    target: target()
  }
];
const melee$2 = [
  {
    ...main({ label: "dagger" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "dagger", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Dagger.glb",
        animationType: "swipe",
        playOn: "source",
        repeat: 1,
        rotationX: 0,
        rotateTowards: true,
        speed: 2,
        scale: 0.4,
        delay: 0,
        rotationZ: 0,
        rotationY: 270
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "swipe",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "flurryofblows" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "flurryofblows", variant: "physical", color: "blue" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "token",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        animationType: "slash",
        playOn: "source",
        repeat: 4,
        resetTime: null
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: false,
        source: false,
        target: false,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "greataxe" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "greataxe", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Axe_Double.glb",
        rotateTowards: true,
        rotationY: 90,
        speed: 2
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "bow",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "greatclub" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "greatclub", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Hammer_Double.glb",
        rotationY: 90,
        rotateTowards: true,
        speed: 2,
        scale: 0.5
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "greatsword" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "greatsword", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Sword_big.glb",
        speed: 2,
        rotationY: 90,
        rotateTowards: true,
        scale: 0.6
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "handaxe" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "handaxe", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Axe_small.glb",
        rotationX: null,
        rotationY: 270,
        rotateTowards: true,
        scale: 0.4,
        speed: 2
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "sword" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "sword", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Sword.glb",
        rotateTowards: true,
        speed: 2,
        scale: 0.4,
        rotationY: 90
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "mace" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "mace", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Hammer_Double.glb",
        speed: 2,
        scale: 0.4,
        rotateTowards: true,
        rotationY: 90
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "maul" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "maul", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Hammer_Double.glb",
        speed: 2,
        rotationY: 90,
        rotateTowards: true,
        scale: 0.4
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "spear" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "spear", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/Kenney/Food/chopstick.glb",
        rotationX: 180,
        scale: 3,
        speed: 2
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "rapier" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "rapier", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Dagger.glb",
        rotateTowards: true,
        rotationX: null,
        rotationY: 270
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "unarmedstrike" }),
    menu: "melee",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "melee", menuType: "weapon", animation: "unarmedstrike", variant: "physical", color: "blue" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "token",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        animationType: "swipe",
        playOn: "source"
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: false,
        source: false,
        target: false,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    meleeSwitch: meleeSwitch(),
    source: source(),
    target: target()
  }
];
const ontoken$2 = [
  {
    ...main({ label: "curewounds" }),
    menu: "ontoken",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "static", menuType: "spell", animation: "curewounds", variant: "01", color: "blue" },
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        contrast: 0,
        delay: 0,
        elevation: 0,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: 1,
        persistent: false,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1.5,
        playOn: "default",
        tint: false,
        tintColor: "#FFFFFF",
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "explosion",
      data: {
        color01: "#00ff08",
        color02: "#00ffaa",
        spritePath: "modules/levels-3d-preview/assets/particles/symbol_01.png",
        life: 2e3,
        rate: 1,
        gravity: -50,
        mass: 2e4,
        scale: 0.7,
        speed: 1
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: false,
        source: false,
        target: false,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "itemHealingWord" }),
    menu: "ontoken",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "static", menuType: "spell", animation: "generichealing", variant: "01", color: "blue" },
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        contrast: 0,
        delay: 0,
        elevation: 0,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: 1,
        persistent: false,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1.5,
        tint: false,
        tintColor: "#FFFFFF",
        playOn: "default",
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "explosion",
      data: {
        color01: "#0091ff",
        color02: "#00fbff",
        spritePath: "modules/levels-3d-preview/assets/particles/symbol_01.png",
        speed: 1,
        gravity: -50,
        mass: 2e4,
        life: 2e3,
        rate: 1,
        scale: 0.1,
        alpha: 1
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: false,
        source: false,
        target: false,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "tollthedead" }),
    menu: "ontoken",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "static", menuType: "spell", animation: "tollthedead", variant: "complete", color: "green" },
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: 1,
        persistent: false,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        playOn: "target",
        tint: false,
        tintColor: "#FFFFFF",
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "explosion",
      data: {
        color01: "#9900ff",
        color02: "#4400ff",
        spritePath: "modules/levels-3d-preview/assets/particles/magic_02.png",
        rate: 1,
        life: 2e3,
        gravity: 0,
        mass: 2e4,
        scale: 0.6,
        alpha: 1
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: false,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "debuff",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "bite" }),
    menu: "ontoken",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "static", menuType: "creature", animation: "bite", variant: "01", color: "red" },
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: 1,
        persistent: false,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        playOn: "target",
        tint: false,
        tintColor: "#FFFFFF",
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "token",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        animationType: "charge",
        playOn: "source"
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: false,
        source: false,
        target: false,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "claw" }),
    menu: "ontoken",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "static", menuType: "creature", animation: "claw", variant: "01", color: "red" },
      options: {
        addTokenWidth: false,
        anchor: "0.5",
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        fadeIn: 250,
        fadeOut: 500,
        isMasked: false,
        isRadius: false,
        isWait: false,
        opacity: 1,
        persistent: false,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        size: 1,
        playOn: "target",
        tint: false,
        tintColor: "#FFFFFF",
        unbindAlpha: false,
        unbindVisibility: false,
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "token",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        animationType: "swipe",
        playOn: "source"
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: false,
        source: false,
        target: false,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  }
];
const preset$1 = [
  {
    ...main({ label: "mistystep" }),
    menu: "preset",
    metaData: { default: true },
    presetType: "teleportation",
    macro: macro(),
    data: {
      options: {
        range: 30,
        hideFromPlayers: false,
        measureType: "alternating",
        teleport: true,
        speed: 120,
        delayMove: 1e3,
        alpha: 0,
        delayFade: 750,
        delayReturn: 250,
        checkCollision: true
      },
      start: {
        dbSection: "static",
        enable: true,
        menuType: "spell",
        animation: "mistystep",
        variant: "01",
        color: "blue",
        customPath: "",
        enableCustom: false,
        options: {
          delay: 0,
          elevation: 1e3,
          fadeIn: 250,
          fadeOut: 250,
          isMasked: false,
          opacity: 1,
          isRadius: false,
          size: 1.5
        }
      },
      end: {
        dbSection: "static",
        enable: true,
        menuType: "spell",
        animation: "mistystep",
        variant: "02",
        color: "blue",
        customPath: "",
        enableCustom: false,
        options: {
          delay: 500,
          elevation: 1e3,
          fadeIn: 250,
          fadeOut: 250,
          isMasked: false,
          isRadius: false,
          opacity: 1,
          size: 1.5
        }
      },
      between: {
        dbSection: "range",
        enable: false,
        menuType: "spell",
        animation: "chainlightning",
        variant: "primary",
        color: "blue",
        enableCustom: false,
        customPath: "",
        options: {
          delay: 0,
          elevation: 1e3,
          opacity: 1,
          playbackRate: 1
        }
      },
      sound: sound()
    }
  },
  {
    ...main({ label: "fireball" }),
    menu: "preset",
    metaData: { default: true },
    presetType: "proToTemp",
    macro: macro(),
    data: {
      projectile: {
        dbSection: "range",
        menuType: "spell",
        animation: "fireballbeam",
        variant: "01",
        color: "orange",
        customPath: "",
        enableCustom: false,
        options: {
          elevation: 1e3,
          opacity: 1,
          removeTemplate: false,
          repeat: 1,
          repeatDelay: 250,
          wait: -1800
        },
        sound: sound()
      },
      preExplosion: {
        enable: false,
        dbSection: "static",
        menuType: "spell",
        animation: "curewounds",
        variant: "01",
        color: "blue",
        customPath: "",
        enableCustom: false,
        options: {
          elevation: 1e3,
          opacity: 1,
          repeat: 1,
          repeatDelay: 250,
          scale: 1.5,
          wait: 0
        },
        sound: sound()
      },
      explosion: {
        dbSection: "static",
        menuType: "spell",
        animation: "fireball",
        variant: "explode",
        color: "orange",
        enableCustom: false,
        customPath: "",
        options: {
          elevation: 1e3,
          opacity: 1,
          repeat: 1,
          repeatDelay: 250,
          scale: 1.25,
          wait: -1e3
        },
        sound: sound()
      },
      afterImage: {
        enable: false,
        customPath: "",
        options: {
          elevation: 0,
          persistent: false,
          scale: 1
        }
      }
    },
    secondary: secondary(),
    target: target()
  }
];
const range$2 = [
  {
    ...main({ label: "crossbow" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "weapon", animation: "bolt", variant: "physical", color: "orange" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Arrow.glb",
        rotationY: 0,
        rotationX: 90,
        speed: 10,
        scale: 0.5
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "bow",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "bow" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "weapon", animation: "arrow", variant: "regular", color: "regular" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "sprite",
      data: {
        color01: "#FFFFFF",
        color02: "#FFFFFF",
        spritePath: "modules/canvas3dcompendium/assets/Tiles/RPG%20Items/Arrow.glb",
        speed: 10,
        rotationX: 90,
        scale: 0.5
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "bow",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "disintegrate" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "disintegrate", variant: "01", color: "green" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "ray",
      data: {
        color01: "#00ff08",
        color02: "#d4ff00",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        speed: 1,
        life: 2e3,
        rate: 50
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "debuff",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "eldritchblast" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "eldritchblast", variant: "01", color: "purple" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "ray",
      data: {
        color01: "#4e16a2",
        color02: "#1e00ff",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        life: 2e3,
        rate: 50
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "firebolt" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "firebolt", variant: "01", color: "orange" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "projectile",
      data: {
        color01: "#ff0000",
        color02: "#fff70a",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        arc: 1
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: true,
        data: {
          color01: "#ff0000",
          color02: "#ffda24",
          life: 400,
          speed: 0.1,
          mass: 1e3,
          scale: 1,
          rate: 1
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "guidingbolt" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "guidingbolt", variant: "01", color: "yellowblue" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "projectile",
      data: {
        color01: "#eeff00",
        color02: "#00d9ff",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        speed: 5,
        arc: 1,
        life: 2e3
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: true,
        data: {
          color01: "#fff700",
          color02: "#0adaff",
          mass: 1e3,
          life: 300,
          gravity: -10,
          speed: 1,
          alpha: 0.2,
          rate: 30
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "magicmissile" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "magicmissile", variant: "01", color: "purple" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "projectile",
      data: {
        color01: "#002aff",
        color02: "#aabacf",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        repeat: 3,
        scale: 0.5,
        life: 800
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "rayoffrost" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "rayoffrost", variant: "01", color: "blue" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "ray",
      data: {
        color01: "#002aff",
        color02: "#0400ff",
        spritePath: "modules/levels-3d-preview/assets/particles/star_07.png",
        life: 2e3,
        rate: 60,
        scale: 0.6
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "scorchingray" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "scorchingray", variant: "01", color: "orange" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "ray",
      data: {
        color01: "#ff0000",
        color02: "#ff9500",
        spritePath: "modules/levels-3d-preview/assets/particles/scorch_01.png",
        life: 2e3,
        rate: 60,
        scale: 0.7
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "witchbolt" }),
    menu: "range",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "range", menuType: "spell", animation: "witchbolt", variant: "01", color: "blue" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isReturning: false,
        isWait: false,
        onlyX: false,
        opacity: 1,
        repeat: 1,
        repeatDelay: 500,
        saturate: 0,
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    secondary: secondary(),
    levels3d: {
      type: "ray",
      data: {
        color01: "#00e1ff",
        color02: "#4138c2",
        spritePath: "modules/levels-3d-preview/assets/particles/emberssmall.png",
        life: 2e3,
        rate: 60,
        scale: 0.6
      },
      sound: {
        enable: false
      },
      secondary: {
        enable: false,
        data: {
          color01: "#FFFFFF",
          color02: "#FFFFFF"
        }
      },
      tokens: {
        enable: true,
        source: true,
        target: true,
        sourceType: "twirl",
        sourcePlay: "start",
        targetType: "shake",
        targetPlay: "end"
      },
      enable: true
    },
    macro: macro(),
    source: source(),
    target: target()
  }
];
const templatefx$2 = [
  {
    ...main({ label: "calllightning" }),
    menu: "templatefx",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "templatefx", menuType: "circle", animation: "calllightning", variant: "01", color: "blueorange" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isMasked: false,
        isWait: false,
        occlusionAlpha: 0.7,
        occlusionMode: "3",
        opacity: 0.75,
        persistType: "overheadtile",
        persistent: true,
        removeTemplate: true,
        repeat: 1,
        repeatDelay: 500,
        rotate: 0,
        saturate: 0,
        scale: "1",
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    macro: macro(),
    secondary: secondary(),
    source: source(),
    target: target()
  },
  {
    ...main({ label: "fogcloud" }),
    menu: "templatefx",
    metaData: { default: true },
    primary: primary({
      video: { dbSection: "templatefx", menuType: "circle", animation: "fogcloud", variant: "01", color: "white" },
      options: {
        contrast: 0,
        delay: 0,
        elevation: 1e3,
        isWait: false,
        isMasked: false,
        occlusionAlpha: 0.65,
        occlusionMode: "3",
        opacity: 0.75,
        persistType: "overheadtile",
        persistent: true,
        removeTemplate: true,
        repeat: 1,
        repeatDelay: 500,
        rotate: 0,
        saturate: 0,
        scale: "1",
        tint: false,
        tintColor: "#FFFFFF",
        zIndex: 1
      }
    }),
    macro: macro(),
    secondary: secondary(),
    source: source(),
    target: target()
  }
];
function loadDefault(type) {
  let data2;
  switch (type) {
    case "aefx":
      data2 = aefx$2;
      break;
    case "aura":
      data2 = aura$2;
      break;
    case "melee":
      data2 = melee$2;
      break;
    case "ontoken":
      data2 = ontoken$2;
      break;
    case "preset":
      data2 = preset$1;
      break;
    case "range":
      data2 = range$2;
      break;
    case "templatefx":
      data2 = templatefx$2;
      break;
    default:
      throw new Error(`Unknown type: '${type}'.`);
  }
  return data2.reduce((array, entry) => {
    entry.label = localize(entry.label);
    array.push(entry);
    return array;
  }, []);
}
function defaultData() {
  let defaultMenu = {
    melee: loadDefault("melee"),
    range: loadDefault("range"),
    ontoken: loadDefault("ontoken"),
    templatefx: loadDefault("templatefx"),
    aura: loadDefault("aura"),
    preset: loadDefault("preset"),
    aefx: loadDefault("aefx")
  };
  return {
    melee: newMenuIDs(foundry.utils.deepClone(defaultMenu.melee)),
    range: newMenuIDs(foundry.utils.deepClone(defaultMenu.range)),
    ontoken: newMenuIDs(foundry.utils.deepClone(defaultMenu.ontoken)),
    templatefx: newMenuIDs(foundry.utils.deepClone(defaultMenu.templatefx)),
    aura: newMenuIDs(foundry.utils.deepClone(defaultMenu.aura)),
    preset: newMenuIDs(foundry.utils.deepClone(defaultMenu.preset)),
    aefx: newMenuIDs(foundry.utils.deepClone(defaultMenu.aefx))
  };
}
function newMenuIDs(menu) {
  let newMenu = AutorecSanitizer.newSectionIds(menu);
  return newMenu;
}
class AAAutorecManager {
  static async restoreDefault() {
    let restoredMenu = defaultData();
    await game.settings.set("autoanimations", "aaAutorec", void 0);
    await game.settings.set("autoanimations", "aaAutorec-aefx", restoredMenu.aefx);
    await game.settings.set("autoanimations", "aaAutorec-aura", restoredMenu.aura);
    await game.settings.set("autoanimations", "aaAutorec-melee", restoredMenu.melee);
    await game.settings.set("autoanimations", "aaAutorec-preset", restoredMenu.preset);
    await game.settings.set("autoanimations", "aaAutorec-range", restoredMenu.range);
    await game.settings.set("autoanimations", "aaAutorec-ontoken", restoredMenu.ontoken);
    await game.settings.set("autoanimations", "aaAutorec-templatefx", restoredMenu.templatefx);
  }
  // Returns the current Global Automatic Recognition Menus with Version
  static getAutorecEntries() {
    let menu = {
      melee: game.settings.get("autoanimations", "aaAutorec-melee"),
      range: game.settings.get("autoanimations", "aaAutorec-range"),
      ontoken: game.settings.get("autoanimations", "aaAutorec-ontoken"),
      templatefx: game.settings.get("autoanimations", "aaAutorec-templatefx"),
      aura: game.settings.get("autoanimations", "aaAutorec-aura"),
      preset: game.settings.get("autoanimations", "aaAutorec-preset"),
      aefx: game.settings.get("autoanimations", "aaAutorec-aefx"),
      version: game.settings.get("autoanimations", "aaAutorec").version
    };
    return menu;
  }
  /**
   *
   * @param {Object} data // Expects an Object containing all MetaData to tag on the Menu Entries
   * @param {Object} options // Limit the Menus in which to tag with MetaData. Ex: {melee: true} will ONLY tag the Melee Menu entries with MetaData
   * @returns
   */
  static async addMetaData(data2, options2) {
    if (!data2) {
      return;
    }
    let addAll = false;
    if (!options2) {
      addAll = true;
    }
    let metaData = data2 || {};
    let exportData = {
      melee: await game.settings.get("autoanimations", "aaAutorec-melee"),
      range: await game.settings.get("autoanimations", "aaAutorec-range"),
      ontoken: await game.settings.get("autoanimations", "aaAutorec-ontoken"),
      templatefx: await game.settings.get("autoanimations", "aaAutorec-templatefx"),
      aura: await game.settings.get("autoanimations", "aaAutorec-aura"),
      preset: await game.settings.get("autoanimations", "aaAutorec-preset"),
      aefx: await game.settings.get("autoanimations", "aaAutorec-aefx"),
      version: await game.settings.get("autoanimations", "aaAutorec").version
    };
    if (exportData.melee.length && (options2?.melee || addAll)) {
      let newMelee = setMeta(exportData.melee);
      await game.settings.set("autoanimations", "aaAutorec-melee", newMelee);
    }
    if (exportData.range.length && (options2?.range || addAll)) {
      let newRange = setMeta(exportData.range);
      await game.settings.set("autoanimations", "aaAutorec-range", newRange);
    }
    if (exportData.ontoken.length && (options2?.ontoken || addAll)) {
      let newOnToken = setMeta(exportData.ontoken);
      await game.settings.set("autoanimations", "aaAutorec-ontoken", newOnToken);
    }
    if (exportData.templatefx.length && (options2?.templatefx || addAll)) {
      let newTemplateFx = setMeta(exportData.templatefx);
      await game.settings.set("autoanimations", "aaAutorec-templatefx", newTemplateFx);
    }
    if (exportData.aura.length && (options2?.aura || addAll)) {
      let newAura = setMeta(exportData.aura);
      await game.settings.set("autoanimations", "aaAutorec-aura", newAura);
    }
    if (exportData.preset.length && (options2?.preset || addAll)) {
      let newPreset = setMeta(exportData.preset);
      await game.settings.set("autoanimations", "aaAutorec-preset", newPreset);
    }
    if (exportData.aefx.length && (options2?.aefx || addAll)) {
      let newAefx = setMeta(exportData.aefx);
      await game.settings.set("autoanimations", "aaAutorec-aefx", newAefx);
    }
    function setMeta(menu) {
      let newMenu = foundry.utils.deepClone(menu);
      newMenu = AutorecSanitizer.newSectionIds(newMenu);
      newMenu.forEach((a) => a.metaData = metaData);
      return newMenu;
    }
  }
  // Exports ALL Global Automatic Recognition Menus
  static async exportMenu(string = "") {
    const exportData = {
      melee: await game.settings.get("autoanimations", "aaAutorec-melee"),
      range: await game.settings.get("autoanimations", "aaAutorec-range"),
      ontoken: await game.settings.get("autoanimations", "aaAutorec-ontoken"),
      templatefx: await game.settings.get("autoanimations", "aaAutorec-templatefx"),
      aura: await game.settings.get("autoanimations", "aaAutorec-aura"),
      preset: await game.settings.get("autoanimations", "aaAutorec-preset"),
      aefx: await game.settings.get("autoanimations", "aaAutorec-aefx"),
      version: await game.settings.get("autoanimations", "aaAutorec").version
    };
    const filename = `fvtt-AutomatedAnimations-GlobalMenu${string}.json`;
    saveDataToFile(JSON.stringify(exportData, null, 2), "text/json", filename);
  }
  /**
   *
   * @param {Object} menu // Expects a valid  Global Automatic Recognition Menu export
   * @param {*} options // Limit the Menus in which to perform the Merge. Ex: {melee: true} will ONLY merge the Melee Menus
   */
  static async mergeMenus(menu, options2 = {}) {
    const currentVersion = currentAutorecVersion();
    if (menu.version > currentVersion) {
      custom_error$1("You are attempting to import a menu that is from a newer version of Automated Animations. Please update your module and try again", true);
      return;
    }
    custom_warning("Merging the requested Menus", false, menu, options2);
    const updatedImport = await autoRecMigration.handle(menu, { ...options2 });
    let currentMenu = {
      melee: await game.settings.get("autoanimations", "aaAutorec-melee"),
      range: await game.settings.get("autoanimations", "aaAutorec-range"),
      ontoken: await game.settings.get("autoanimations", "aaAutorec-ontoken"),
      templatefx: await game.settings.get("autoanimations", "aaAutorec-templatefx"),
      aura: await game.settings.get("autoanimations", "aaAutorec-aura"),
      preset: await game.settings.get("autoanimations", "aaAutorec-preset"),
      aefx: await game.settings.get("autoanimations", "aaAutorec-aefx")
    };
    let mergeMenu = updatedImport;
    let mergeList = [];
    if (options2.melee) {
      mergeList.push("melee");
    }
    if (options2.range) {
      mergeList.push("range");
    }
    if (options2.ontoken) {
      mergeList.push("ontoken");
    }
    if (options2.templatefx) {
      mergeList.push("templatefx");
    }
    if (options2.aura) {
      mergeList.push("aura");
    }
    if (options2.preset) {
      mergeList.push("preset");
    }
    if (options2.aefx) {
      mergeList.push("aefx");
    }
    for (var i = 0; i < mergeList.length; i++) {
      let existingMenu = currentMenu[mergeList[i]];
      let incomingMenu = mergeMenu[mergeList[i]];
      for (var a = 0; a < incomingMenu.length; a++) {
        let incomingSectionLabel = incomingMenu[a].label.replace(/\s+/g, "").toLowerCase();
        let newSection = existingMenu.find((section2) => {
          return section2.label?.replace(/\s+/g, "")?.toLowerCase() === incomingSectionLabel;
        });
        if (!newSection) {
          incomingMenu[a].id = Hashing.uuidv4();
          currentMenu[mergeList[i]].push(incomingMenu[a]);
        }
      }
      custom_notify(`${game.i18n.localize(`autoanimations.animTypes.${mergeList[i]}`)} Menu has been successfully merged`);
      game.settings.set("autoanimations", `aaAutorec-${mergeList[i]}`, currentMenu[mergeList[i]]);
    }
  }
  /**
   *
   * @param {Object} menu // Expects a valid  Global Automatic Recognition Menu export
   * @param {*} options // Limit the Menus in which to perform the Overwrite. Ex: {melee: true} will ONLY overwrite the Melee Menus
   */
  static async overwriteMenus(menu, options2 = {}) {
    let isValid = this._validateJson(menu);
    if (!isValid) {
      custom_error$1("You did not provide a valid JSON!");
      return;
    }
    const menuData = JSON.parse(menu);
    const currentVersion = currentAutorecVersion();
    if (menuData.version > currentVersion) {
      custom_error$1("You are attempting to import a menu that is from a newer version of Automated Animations. Please update your module and try again", true);
      return;
    }
    await autoRecMigration.handle(menuData, { isOverwrite: true, shouldSubmit: true, ...options2 });
  }
  static _validateJson(json) {
    try {
      JSON.parse(json);
      return true;
    } catch (e) {
      return false;
    }
  }
}
async function createActiveEffects(effect) {
  if (effect.disabled) {
    return;
  }
  if (!AnimationState.enabled) {
    return;
  }
  const actor = effect.parent instanceof Item ? effect.parent.actor : effect.parent;
  const aeToken = actor.token ?? actor.getActiveTokens()[0];
  if (!aeToken) {
    debug$1("Failed to find the Token for the Active Effect");
    return;
  }
  const aeNameField = (effect.name ?? effect.label) + `${aeToken.id}`;
  const checkAnim = Sequencer.EffectManager.getEffects({ object: aeToken, name: aeNameField }).length > 0;
  if (checkAnim) {
    debug$1("Animation is already present on the Token, returning.");
    return;
  }
  const data2 = {
    token: aeToken,
    targets: [aeToken],
    item: effect,
    activeEffect: true,
    tieToDocuments: true
  };
  let handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  if (!handler.item || !handler.sourceToken) {
    debug$1("Failed to find the Item or Source Token", handler);
    return;
  }
  trafficCop$1(handler);
}
async function deleteActiveEffects(effect, shouldDelete = false) {
  const actor = effect.parent instanceof Item ? effect.parent.actor : effect.parent;
  const token = actor.token ?? actor.getActiveTokens()[0];
  const data2 = {
    token,
    targets: [],
    item: effect,
    activeEffect: true
  };
  const handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  const flagData = handler.animationData;
  const macro2 = await DataSanitizer.compileMacro(handler, flagData);
  if (macro2) {
    if (foundry.utils.isNewerVersion(game.version, 11)) {
      new Sequence().macro(macro2.name, { args: ["off", handler, macro2.args] }).play();
    } else {
      if (game.modules.get("advanced-macros")?.active) {
        new Sequence().macro(macro2.name, "off", handler, macro2.args).play();
      } else {
        new Sequence().macro(macro2.name).play();
      }
    }
  }
  if (shouldDelete) {
    let aaEffects = Sequencer.EffectManager.getEffects({ origin: effect.uuid });
    if (aaEffects.length > 0) {
      let currentEffect = aaEffects.filter((i) => effect.uuid.includes(i.source?.actor?.id));
      currentEffect = currentEffect.length < 1 ? aaEffects.filter((i) => effect.uuid.includes(i.source?.id)) : currentEffect;
      if (currentEffect.length < 0) {
        return;
      }
      if (!handler.sourceToken) {
        handler.sourceToken = currentEffect[0].source;
      }
      Sequencer.EffectManager.endEffects({ origin: effect.uuid, object: handler.sourceToken });
    }
  }
}
async function toggleActiveEffects(effect, toggle) {
  if (toggle.disabled === true) {
    deleteActiveEffects(effect, true);
  } else if (toggle.disabled === false) {
    createActiveEffects(effect);
  }
}
async function checkConcentration(effect) {
  const label = (effect.name ?? effect.label) || "";
  if (label.toLowerCase() !== "concentrating") {
    return;
  }
  const origin = effect.origin;
  if (!origin) {
    debug$1("Failed to find an Origin for Concentration");
    return;
  }
  const tiles = canvas.tiles.placeables.filter((i) => i.document.flags?.autoanimations?.origin === origin);
  if (tiles.length < 1) {
    debug$1("Failed to find any Tiles tied to Concentration");
    return;
  }
  let tileIdArray = [];
  if (tiles.length) {
    for (let tile of tiles) {
      tileIdArray.push(tile.id);
    }
    socketlibSocket.executeAsGM("removeTile", tileIdArray);
  }
}
async function createRuleElementPF2e(item2) {
  const aePF2eTypes = ["condition", "effect"];
  if (!aePF2eTypes.includes(item2.type)) {
    return;
  }
  if (!AnimationState.enabled) {
    return;
  }
  const itemId2 = item2.id;
  const aeToken = canvas.tokens.placeables.find((token) => token.actor?.items?.get(itemId2) != null);
  if (!aeToken) {
    debug$1("Failed to find the Token for the Active Effect");
    return;
  }
  if (game.settings.get("autoanimations", "disableGrantedAuraEffects")) {
    let tactorId = aeToken.actor.id;
    let origin = item2.flags?.pf2e?.aura?.origin;
    if (origin) {
      let idSplit = origin.split(".");
      let id = idSplit[idSplit.length - 1];
      if (tactorId !== id) {
        debug$1("This is a Granted Ruleset, exiting early");
        return;
      }
    }
  }
  const aeNameField = item2.name.replace(/[^A-Za-z0-9 .*_-]/g, "") + `${aeToken.id}`;
  const checkAnim = await Sequencer.EffectManager.getEffects({ object: aeToken, name: aeNameField }).length > 0;
  if (checkAnim) {
    debug$1("Animation is already present on the Token, returning.");
    return;
  }
  const data2 = {
    token: aeToken,
    targets: [],
    item: item2,
    activeEffect: true,
    tieToDocuments: true
  };
  let handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  if (!handler.item || !handler.sourceToken) {
    debug$1("Failed to find the Item or Source Token", handler);
    return;
  }
  trafficCop$1(handler);
}
async function deleteRuleElementPF2e(itemData = {}) {
  const data2 = {
    token: itemData.token,
    targets: [],
    item: itemData.item,
    activeEffect: true
  };
  const handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  const flagData = handler.animationData;
  const macro2 = await DataSanitizer.compileMacro(handler, flagData);
  if (macro2) {
    if (foundry.utils.isNewerVersion(game.version, 11)) {
      new Sequence().macro(macro2.name, { args: ["off", handler, macro2.args] }).play();
    } else {
      if (game.modules.get("advanced-macros")?.active) {
        new Sequence().macro(macro2.name, "off", handler, macro2.args).play();
      } else {
        new Sequence().macro(macro2.name).play();
      }
    }
  }
}
async function createActiveEffectsWfrp(effect) {
  if (effect.disabled) {
    return;
  }
  if (!AnimationState.enabled) {
    return;
  }
  const actor = effect.parent instanceof Item ? effect.parent.actor : effect.parent;
  if (!actor) {
    return;
  }
  const aeToken = actor.token ?? actor.getActiveTokens()[0];
  if (!aeToken) {
    debug$1("Failed to find the Token for the Active Effect");
    return;
  }
  const aeNameField = (effect.name ?? effect.label) + `${aeToken.id}`;
  const checkAnim = Sequencer.EffectManager.getEffects({ object: aeToken, name: aeNameField }).length > 0;
  if (checkAnim) {
    debug$1("Animation is already present on the Token, returning.");
    return;
  }
  const data2 = {
    token: aeToken,
    targets: [aeToken],
    item: effect,
    activeEffect: true,
    tieToDocuments: true
  };
  let handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  if (!handler.item || !handler.sourceToken) {
    debug$1("Failed to find the Item or Source Token", handler);
    return;
  }
  if (handler.animationData?.activeEffectType == "aura" && effect.system.transferData?.type != "aura") return;
  if (handler.animationData?.activeEffectType == "aura") {
    handler.animationData.primary.options.size = handler.item.radius / 2;
  }
  trafficCop$1(handler);
}
async function deleteActiveEffectsWfrp(effect, shouldDelete = false) {
  const actor = effect.parent instanceof Item ? effect.parent.actor : effect.parent;
  if (!actor) {
    return;
  }
  const token = actor.token ?? actor.getActiveTokens()[0];
  const data2 = {
    token,
    targets: [],
    item: effect,
    activeEffect: true
  };
  const handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  const flagData = handler.animationData;
  const macro2 = await DataSanitizer.compileMacro(handler, flagData);
  if (macro2) {
    if (isNewerVersion(game.version, 11)) {
      new Sequence().macro(macro2.name, { args: ["off", handler, macro2.args] }).play();
    } else {
      if (game.modules.get("advanced-macros")?.active) {
        new Sequence().macro(macro2.name, "off", handler, macro2.args).play();
      } else {
        new Sequence().macro(macro2.name).play();
      }
    }
  }
  if (shouldDelete) {
    let aaEffects = Sequencer.EffectManager.getEffects({ origin: effect.uuid });
    if (aaEffects.length > 0) {
      let currentEffect = aaEffects.filter((i) => effect.uuid.includes(i.source?.actor?.id));
      currentEffect = currentEffect.length < 1 ? aaEffects.filter((i) => effect.uuid.includes(i.source?.id)) : currentEffect;
      if (currentEffect.length < 0) {
        return;
      }
      if (!handler.sourceToken) {
        handler.sourceToken = currentEffect[0].source;
      }
      Sequencer.EffectManager.endEffects({ origin: effect.uuid, object: handler.sourceToken });
    }
  }
}
async function toggleActiveEffectsWfrp(effect, toggle) {
  if (toggle.disabled === true) {
    deleteActiveEffectsWfrp(effect, true);
  } else if (toggle.disabled === false) {
    createActiveEffectsWfrp(effect);
  }
}
async function createRuleElementPtu(item2) {
  if (!AnimationState.enabled) {
    return;
  }
  const itemId2 = item2.id;
  const aeToken = canvas.tokens.placeables.find((token) => token.actor?.items?.get(itemId2) != null);
  if (!aeToken) {
    debug$1("Failed to find the Token for the Active Effect");
    return;
  }
  if (game.settings.get("autoanimations", "disableGrantedAuraEffects")) {
    let tactorId = aeToken.actor.id;
    let origin = item2.flags?.ptu?.aura?.origin;
    if (origin) {
      let idSplit = origin.split(".");
      let id = idSplit[idSplit.length - 1];
      if (tactorId !== id) {
        debug$1("This is a Granted Ruleset, exiting early");
        return;
      }
    }
  }
  const aeNameField = item2.name.replace(/[^A-Za-z0-9 .*_-]/g, "") + `${aeToken.id}`;
  const checkAnim = await Sequencer.EffectManager.getEffects({ object: aeToken, name: aeNameField }).length > 0;
  if (checkAnim) {
    debug$1("Animation is already present on the Token, returning.");
    return;
  }
  const data2 = {
    token: aeToken,
    targets: [],
    item: item2,
    activeEffect: true,
    tieToDocuments: true
  };
  let handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  if (!handler.item || !handler.sourceToken) {
    debug$1("Failed to find the Item or Source Token", handler);
    return;
  }
  trafficCop$1(handler);
}
async function deleteRuleElementPtu(itemData = {}) {
  const data2 = {
    token: itemData.token,
    targets: [],
    item: itemData.item,
    activeEffect: true
  };
  const handler = await AAHandler.make(data2);
  if (!handler) {
    return;
  }
  const flagData = handler.animationData;
  const macro2 = await DataSanitizer.compileMacro(handler, flagData);
  if (macro2) {
    if (foundry.utils.isNewerVersion(game.version, 11)) {
      new Sequence().macro(macro2.name, { args: ["off", handler, macro2.args] }).play();
    } else {
      if (game.modules.get("advanced-macros")?.active) {
        new Sequence().macro(macro2.name, "off", handler, macro2.args).play();
      } else {
        new Sequence().macro(macro2.name).play();
      }
    }
  }
}
const pf2eDeletedItems = /* @__PURE__ */ new Map();
const ptuDeletedItems = /* @__PURE__ */ new Map();
function registerActiveEffectHooks() {
  switch (game.system.id) {
    case "pf2e":
      let shouldContinue = function(item2, userId) {
        if (game.user.id !== userId) {
          return false;
        }
        if (!["condition", "effect", "feat"].includes(item2.type)) {
          return false;
        }
        return true;
      };
      Hooks.on("createItem", (item2, data2, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        const aePF2eTypes = ["condition", "effect", "feat"];
        if (!aePF2eTypes.includes(item2.type)) {
          debug$1("This is not a PF2e Ruleset, exiting early");
          return;
        }
        if (item2.system?.references?.parent && game.settings.get("autoanimations", "disableNestedEffects")) {
          debug$1("This is a nested Ruleset, exiting early");
          return;
        }
        createRuleElementPF2e(item2);
      });
      Hooks.on("preDeleteItem", (item2, data2, userId) => {
        if (shouldContinue(item2, userId)) {
          pf2eDeletedItems.set(item2.id, {
            item: item2,
            token: item2.parent?.token || canvas.tokens.placeables.find((token) => token.actor?.items?.get(item2.id) != null)
          });
        }
      });
      Hooks.on("deleteItem", (item2, data2, userId) => {
        if (shouldContinue(item2, userId)) {
          let itemData = pf2eDeletedItems.get(item2.id);
          if (!itemData) {
            return;
          }
          deleteRuleElementPF2e(itemData);
        }
      });
      break;
    case "sfrpg":
      Hooks.on("updateItem", (item2, diff, action, userId) => {
        if (game.user.id !== userId) {
          return;
        }
        Hooks.once("updateToken", async (token, actor, updates, userId2) => {
          if (game.user.id !== userId2) {
            return;
          }
          if (item2.type !== "feat") {
            return;
          }
          if (!diff.isActive) {
            deleteActiveEffects(item2, token);
          } else {
            const sfrpgData = {
              item: item2,
              token,
              targets: game.user.targets
            };
            const handler = await AAHandler.make(sfrpgData);
            trafficCop(handler);
          }
        });
      });
    case "dnd5e":
      Hooks.on("updateActiveEffect", (data2, toggle, other, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        toggleActiveEffects(data2, toggle);
      });
    case "pf1":
      Hooks.on("createActiveEffect", async (effect, data2, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        if (effect.parent instanceof Item) {
          const flagData = effect.parent.flags["autoanimations"];
          if (flagData) {
            await effect.update({ "flags.autoanimations": flagData });
          }
        }
        createActiveEffects(effect);
      });
      Hooks.on("preDeleteActiveEffect", (effect, data2, userId) => {
        if (game.user.id !== userId) {
          return;
        }
        deleteActiveEffects(effect);
      });
      break;
    case "ptu":
      let ptuShouldContinue = function(item2, userId) {
        if (game.user.id !== userId) {
          return false;
        }
        if (!["condition", "effect"].includes(item2.type)) {
          return false;
        }
        return true;
      };
      Hooks.on("createItem", (item2, data2, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        const aePtuTypes = ["condition", "effect"];
        if (!aePtuTypes.includes(item2.type)) {
          debug$1("This is not a PTU Ruleset, exiting early");
          return;
        }
        if (item2.system?.references?.parent && game.settings.get("autoanimations", "disableNestedEffects")) {
          debug$1("This is a nested Ruleset, exiting early");
          return;
        }
        createRuleElementPtu(item2);
      });
      Hooks.on("preDeleteItem", (item2, data2, userId) => {
        if (ptuShouldContinue(item2, userId)) {
          ptuDeletedItems.set(item2.id, {
            item: item2,
            token: item2.parent?.token || canvas.tokens.placeables.find((token) => token.actor?.items?.get(item2.id) != null)
          });
        }
      });
      Hooks.on("deleteItem", (item2, data2, userId) => {
        if (ptuShouldContinue(item2, userId)) {
          let itemData = ptuDeletedItems.get(item2.id);
          if (!itemData) {
            return;
          }
          deleteRuleElementPtu(itemData);
        }
      });
    case "wfrp4e":
      Hooks.on("updateActiveEffect", (data2, toggle, other, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        toggleActiveEffectsWfrp(data2, toggle);
      });
      Hooks.on("createActiveEffect", (effect, data2, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        createActiveEffectsWfrp(effect);
      });
      Hooks.on("deleteActiveEffect", (effect, data2, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        deleteActiveEffectsWfrp(effect, userId);
      });
      break;
    default:
      Hooks.on("updateActiveEffect", (data2, toggle, other, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        toggleActiveEffects(data2, toggle);
      });
      Hooks.on("createActiveEffect", (effect, data2, userId) => {
        if (game.settings.get("autoanimations", "disableAEAnimations")) {
          debug$1(`Active Effect Animations are Disabled`);
          return;
        }
        if (game.user.id !== userId) {
          return;
        }
        createActiveEffects(effect);
      });
      Hooks.on("preDeleteActiveEffect", (effect, data2, userId) => {
        if (game.user.id !== userId) {
          return;
        }
        deleteActiveEffects(effect);
        if (game.modules.get("midi-qol")?.active) {
          checkConcentration(effect);
        }
      });
  }
}
const subscriber_queue = [];
function readable(value, start) {
  return {
    subscribe: writable(value, start).subscribe
  };
}
function writable(value, start = noop) {
  let stop;
  const subscribers = /* @__PURE__ */ new Set();
  function set2(new_value) {
    if (safe_not_equal(value, new_value)) {
      value = new_value;
      if (stop) {
        const run_queue = !subscriber_queue.length;
        for (const subscriber of subscribers) {
          subscriber[1]();
          subscriber_queue.push(subscriber, value);
        }
        if (run_queue) {
          for (let i = 0; i < subscriber_queue.length; i += 2) {
            subscriber_queue[i][0](subscriber_queue[i + 1]);
          }
          subscriber_queue.length = 0;
        }
      }
    }
  }
  function update2(fn) {
    set2(fn(value));
  }
  function subscribe2(run2, invalidate = noop) {
    const subscriber = [run2, invalidate];
    subscribers.add(subscriber);
    if (subscribers.size === 1) {
      stop = start(set2, update2) || noop;
    }
    run2(value);
    return () => {
      subscribers.delete(subscriber);
      if (subscribers.size === 0 && stop) {
        stop();
        stop = null;
      }
    };
  }
  return { set: set2, update: update2, subscribe: subscribe2 };
}
function derived(stores, fn, initial_value) {
  const single = !Array.isArray(stores);
  const stores_array = single ? [stores] : stores;
  if (!stores_array.every(Boolean)) {
    throw new Error("derived() expects stores as input, got a falsy value");
  }
  const auto = fn.length < 2;
  return readable(initial_value, (set2, update2) => {
    let started = false;
    const values = [];
    let pending = 0;
    let cleanup = noop;
    const sync = () => {
      if (pending) {
        return;
      }
      cleanup();
      const result = fn(single ? values[0] : values, set2, update2);
      if (auto) {
        set2(result);
      } else {
        cleanup = is_function(result) ? result : noop;
      }
    };
    const unsubscribers = stores_array.map(
      (store, i) => subscribe(
        store,
        (value) => {
          values[i] = value;
          pending &= ~(1 << i);
          if (started) {
            sync();
          }
        },
        () => {
          pending |= 1 << i;
        }
      )
    );
    started = true;
    sync();
    return function stop() {
      run_all(unsubscribers);
      cleanup();
      started = false;
    };
  });
}
function isReadableStore(store) {
  if (store === null || store === void 0) {
    return false;
  }
  switch (typeof store) {
    case "function":
    case "object":
      return typeof store.subscribe === "function";
  }
  return false;
}
function isMinimalWritableStore(store) {
  if (store === null || store === void 0) {
    return false;
  }
  switch (typeof store) {
    case "function":
    case "object":
      return typeof store.subscribe === "function" && typeof store.set === "function";
  }
  return false;
}
function isWritableStore(store) {
  if (store === null || store === void 0) {
    return false;
  }
  switch (typeof store) {
    case "function":
    case "object":
      return typeof store.subscribe === "function" && typeof store.set === "function" && typeof store.update === "function";
  }
  return false;
}
function subscribeIgnoreFirst(store, update2) {
  let firedFirst = false;
  return store.subscribe((value) => {
    if (!firedFirst) {
      firedFirst = true;
    } else {
      update2(value);
    }
  });
}
function subscribeFirstRest(store, first, update2) {
  let firedFirst = false;
  return store.subscribe((value) => {
    if (!firedFirst) {
      firedFirst = true;
      first(value);
    } else {
      update2(value);
    }
  });
}
class CrossWindow {
  /**
   * @private
   */
  constructor() {
  }
  // eslint-disable-line no-useless-constructor
  /**
   * Class names for all focusable element types.
   *
  