/*! For license information please see main.mjs.LICENSE.txt */
(()=>{"use strict";var __webpack_modules__={657:(e,t,a)=>{a.d(t,{A:()=>DDBMuncher});var i=a(421),n=a(775),s=a(132),r=a(38),o=a(382);class DDBRaceTrait{_generateDataStub(){this.data={_id:foundry.utils.randomID(),name:"A Racial Trait",type:"feat",system:o.SystemHelpers.getTemplate("feat"),flags:{ddbimporter:{type:"race"}},img:null}}constructor(e,t){i.logger.debug(`Trait build for ${e.fullName} started [${t.raceName}]`),this.trait=e,this.race=t,this.fullName=this.race.fullName,this.isLegacy=this.race.isLegacy,this.baseRaceName=this.race.baseRaceName,this.groupName=r.A.getGroupName(this.race.groupIds,this.baseRaceName),this.isSubRace=this.race.isSubRace||this.groupName!==this.raceName,this._generateDataStub(),this._compendiumLabel=i.CompendiumHelper.getCompendiumLabel("traits"),this.name=i.utils.nameString(this.trait.fullName??this.trait.name),this.data.name=`${this.name}`,this.data.system.description.value+=`${this.trait.description}\n\n`,this.data.flags.ddbimporter={type:"race",entityRaceId:this.trait.entityRaceId,version:CONFIG.DDBI.version,sourceId:this.trait.sources.length>0?[0].sourceId:-1,baseName:this.name,originalName:this.name,spellListIds:this.trait.spellListIds,definitionKey:this.trait.definitionKey,race:this.baseName,baseRaceName:this.baseRaceName,baseRaceId:this.race.baseRaceId,subRaceShortName:this.race.subRaceShortName,fullRaceName:this.race.fullName,isSubRace:this.isSubRace,groupIds:this.race.groupIds,groupName:this.groupName},this.trait.moreDetailsUrl&&(this.data.flags.ddbimporter.moreDetailsUrl=this.trait.moreDetailsUrl),this.data.system.source=i.DDBSources.parseSource(this.trait),this.trait.requiredLevel&&(this.data.system.prerequisite.level=this.trait.requiredLevel),this.baseRaceName&&(this.data.system.requirements=this.baseRaceName);game.settings.get("ddb-importer","munching-policy-legacy-postfix")&&this.isLegacy&&(this.data.name+=" (Legacy)",i.logger.debug(`Trait name ${this.data.name} is legacy`)),this.data.system.requirements=this.raceName,this.data.system.type={value:"race"},this.data.system.description.value=o.DDBReferenceLinker.parseTags(this.data.system.description.value)}}const l=["Speed","Ability Score Increase","Ability Score Increases","Size","Feat","Languages","Extra Language","Age","Alignment","Creature Type","Darkvision","Keen Senses","Natural Athlete","Necrotic Resistance","Skills","Skill Versatility"];var d=a(115),c=a(617);function getRaceData(){const e=i.Secrets.getCobalt(),t=i.DDBCampaigns.getCampaignId(i.utils.munchNote),a=i.DDBProxy.getProxy(),n={cobalt:e,campaignId:t,betaKey:i.PatreonHelper.getPatreonKey()},s=game.settings.get(d.y.MODULE_ID,"debug-json");return new Promise(((e,t)=>{fetch(`${a}/proxy/races`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)}).then((e=>e.json())).then((e=>(s&&i.FileHelper.download(JSON.stringify(e),"races-raw.json","application/json"),e.success||(i.utils.munchNote(`Failure: ${e.message}`),t(e.message)),e))).then((e=>async function getRaces(e){i.logger.debug("get races started");const t=game.settings.get("ddb-importer","munching-policy-update-existing");let a=[],n=[],s=[];const o=new i.DDBCompendiumFolders("traits");await o.loadCompendium("traits");const d=game.settings.get("ddb-importer","munching-policy-exclude-legacy"),c=e.filter((e=>!d||d&&!e.isLegacy));for(const e of c){i.logger.debug(`${e.fullName} features parsing started...`);const t=r.A.getGroupName(e.groupIds,e.baseRaceName);for(const n of e.racialTraits)if(i.logger.debug(`${n.definition.name} trait starting...`),!n.definition.hideInSheet&&!l.includes(n.definition.name)){const i=new DDBRaceTrait(n.definition,e);s.push(i.data),a.push({race:e.fullName,trait:n.definition.name}),await o.createSubTraitFolders(t,e.fullName)}}const u=new i.DDBCompendiumFolders("races");await u.loadCompendium("races");const m={chrisPremades:!0,matchFlags:["fullRaceName","groupName"],useCompendiumFolders:!0,notifier:i.utils.munchNote},p=await i.DDBItemImporter.buildHandler("traits",s,t,m),g=await r.A.getRacialTraitsLookup(p.documents);for(const e of c){i.logger.debug(`${e.fullName} race parsing started...`);const t=new r.A(null,e,g,!0);await t.build(),await u.getSpeciesBaseFolder(t.groupName),n.push(t.data)}i.logger.debug("Pre-fiddled races",foundry.utils.duplicate(n));const h={matchFlags:["fullRaceName","groupName"],useCompendiumFolders:!0,notifier:i.utils.munchNote};return await i.DDBItemImporter.buildHandler("races",n,t,h),a}(e.data))).then((t=>e(t))).catch((e=>t(e)))}))}var u=a(512);async function parseFeats(){const e=d.y.COMPENDIUMS.find((e=>"Feats"===e.title));await(0,c.k)(e);return await function getFeatData(){const e=i.Secrets.getCobalt(),t=i.DDBCampaigns.getCampaignId(i.utils.munchNote),a=i.DDBProxy.getProxy(),n={cobalt:e,campaignId:t,betaKey:i.PatreonHelper.getPatreonKey()},s=game.settings.get(d.y.MODULE_ID,"debug-json");return new Promise(((e,t)=>{fetch(`${a}/proxy/feats`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)}).then((e=>e.json())).then((e=>(s&&i.FileHelper.download(JSON.stringify(e),"feats-raw.json","application/json"),e.success||(i.utils.munchNote(`Failure: ${e.message}`),t(e.message)),e))).then((e=>(0,u.M)(e.data))).then((t=>e(t))).catch((e=>t(e)))}))}()}const m={name:"",type:"feat",system:{description:{value:"",chat:""},source:""},sort:26e5,flags:{ddbimporter:{type:"class"},obsidian:{source:{type:"class",text:""}}},img:null},p=["Speed","Size","Feat","Languages","Hit Points","Proficiencies"];async function buildBase(e){let t=foundry.utils.duplicate(m);const a=game.settings.get("ddb-importer","munching-policy-update-existing");t.name=e.name;const n=await o.DDBTable.generateTable({parentName:e.name,html:e.description,updateExisting:a,notifier:i.utils.munchNote});return t.system.description.value+=`${n}\n\n`,t.flags.ddbimporter={id:e.id,data:e,version:CONFIG.DDBI.version},e.moreDetailsUrl&&(t.flags.ddbimporter.moreDetailsUrl=e.moreDetailsUrl),t.system.source=i.DDBSources.parseSource(e),t}async function generateFeatureAdvancements(e,t,a=[]){i.logger.debug(`Parsing ${e.name} features for advancement`);const n=i.CompendiumHelper.getCompendiumLabel("features");let s=[];return e.classFeatures.filter((e=>!a.includes(e.id))).forEach((a=>{const i=t.find((t=>{const i=foundry.utils.hasProperty(t,"flags.ddbimporter.originalName")?foundry.utils.getProperty(t,"flags.ddbimporter.originalName").trim().toLowerCase():t.name.trim().toLowerCase();return a.name.trim().toLowerCase()==i&&foundry.utils.hasProperty(t,"flags.ddbimporter")&&(t.flags.ddbimporter.class==e.name||t.flags.ddbimporter.parentClassId==e.id||t.flags.ddbimporter.classId==e.id)}));if(i){const e=s.findIndex((e=>e.level===a.requiredLevel));if(-1==e){const e={_id:foundry.utils.randomID(),type:"ItemGrant",configuration:{items:[`Compendium.${n}.${i._id}`]},value:{},level:a.requiredLevel,title:"Features",icon:"",classRestriction:""};s.push(e)}else s[e].configuration.items.push(`Compendium.${n}.${i._id}`)}})),s}async function buildClassFeatures(e,t,a=[]){i.logger.debug(`Parsing ${e.name} features`);let n="<h1>Class Features</h1>\n\n",s=[];const r=i.CompendiumHelper.getCompendiumLabel("features");return e.classFeatures.forEach((i=>{if(!s.some((e=>e===i.name))&&!a.includes(i.id)){const a=t.find((t=>{const a=foundry.utils.hasProperty(t,"flags.ddbimporter.originalName")?foundry.utils.getProperty(t,"flags.ddbimporter.originalName").trim().toLowerCase():t.name.trim().toLowerCase();return i.name.trim().toLowerCase()==a&&foundry.utils.hasProperty(t,"flags.ddbimporter")&&(t.flags.ddbimporter.class==e.name||t.flags.ddbimporter.parentClassId==e.id||t.flags.ddbimporter.classId==e.id)})),o=a?`<p><b>@Compendium[${r}.${a._id}]{${i.name}}</b></p>`:`<p><b>${i.name}</b></p>`;n+=`${o}\n${i.description}\n\n`,s.push(i.name)}})),n}async function getClassFeature(e,t,a="",n=void 0){i.logger.debug("Class feature build started");let s=await buildBase(e);s.flags.obsidian.source.text=t.name,s.name=e.name,s.flags.ddbimporter.featureId=e.id,s.flags.ddbimporter.originalName=e.name,s.flags.ddbimporter.requiredLevel=e.requiredLevel,s.flags.ddbimporter.prerequisite=e.prerequisite,s.flags.ddbimporter.class=n??t.name,s.flags.ddbimporter.classId=t.id,s.flags.ddbimporter.subClass=a,s.flags.ddbimporter.parentClassId=t.parentClassId;const r=e.requiredLevel?` ${e.requiredLevel}`:"";return s.system.requirements=`${t.name}${r}`,s.system.description.value=o.DDBReferenceLinker.parseTags(s.system.description.value),s.system.type={value:"class"},s}async function getClassImages(e,t){let a,n,s;const r=game.settings.get(d.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),o=game.settings.get(d.y.MODULE_ID,"use-deep-file-paths"),l=e.fullName??e.name;if(e.portraitAvatarUrl){const a={type:"class-portrait",name:l,targetDirectory:r,imageNamePrefix:o?"":"class-portrait",pathPostfix:o?"/class/portrait":""};s=await i.FileHelper.getImagePath(e.portraitAvatarUrl,a),t.img=s,t.flags.ddbimporter.portraitAvatarUrl=e.portraitAvatarUrl}if(e.avatarUrl){const n={type:"class-avatar",name:l,targetDirectory:r,imageNamePrefix:o?"":"class-avatar",pathPostfix:o?"/class/avatar":""};a=await i.FileHelper.getImagePath(e.avatarUrl,n),t.flags.ddbimporter.avatarUrl=e.avatarUrl,t.img||(t.img=a)}if(e.largeAvatarUrl){const a={type:"class-large",name:l,targetDirectory:r,imageNamePrefix:o?"":"class-large",pathPostfix:o?"/class/large":""};n=await i.FileHelper.getImagePath(e.largeAvatarUrl,a),t.flags.ddbimporter.largeAvatarUrl=e.largeAvatarUrl,t.img||(t.img=n)}if(a||n){const e=a?`<img class="ddb-class-image" src="${a}">\n\n`:`<img class="ddb-class-image" src="${n}">\n\n`;foundry.utils.setProperty(t,"flags.ddbimporter.image",e)}else foundry.utils.setProperty(t,"flags.ddbimporter.image","")}async function buildBaseClass(e){let t=await buildBase(e);i.logger.debug(`Parsing ${e.name}`),t.flags.obsidian.source.text=e.name,t.type="class",t.system.identifier=i.utils.referenceNameString(e.name).toLowerCase(),t.system.advancement=[],await getClassImages(e,t),t.system.description.value+=foundry.utils.getProperty(t,"flags.ddbimporter.image"),t.flags.ddbimporter.parentClassId=e.parentClassId,t.flags.ddbimporter.class=e.name,t.flags.ddbimporter.hitDice=e.hitDice,t.flags.ddbimporter.spellCastingAbilityId=e.spellCastingAbilityId,t.flags.ddbimporter.canCastSpells=e.canCastSpells,t.system.levels=1,t.system.hitDice=`d${e.hitDice}`;let a={};if(e.canCastSpells){const t=d.x.spell.progression.find((t=>t.name==e.name)),i=e.spellCastingAbilityId?d.x.actor.abilities.find((t=>t.id==e.spellCastingAbilityId)).value:null;t&&(a={progression:t.value,ability:i})}t.system.spellcasting=a;const n=e.classFeatures.find((e=>"Proficiencies"===e.name&&1===e.requiredLevel)),s=i.utils.htmlToDocumentFragment(n.description),r=s.textContent.toLowerCase().split("skills:").pop().split("\n")[0].split("The")[0].split(".")[0].trim(),o=s.textContent.match(/Skills: Choose any (\w+)(.*)($|\.$|\w+:)/im),l=r.match(/choose (\w+)(?:\sskills)* from (.*)($|The|\.$|\w+:)/im);if(o){const e=d.x.actor.skills.map((e=>e.name)),a=d.x.numbers.find((e=>o[1].toLowerCase()===e.natural));t.system.skills={number:a?a.num:2,choices:e,value:[]}}else if(l){const e=l[2].replace("and",",").split(",").map((e=>e.trim())).filter((e=>d.x.actor.skills.some((t=>t.label.toLowerCase()===e.toLowerCase())))).map((e=>d.x.actor.skills.find((t=>t.label.toLowerCase()===e.toLowerCase())).name)),a=d.x.numbers.find((e=>l[1].toLowerCase()===e.natural));t.system.skills={number:a?a.num:2,choices:e,value:[]}}const c=s.textContent.toLowerCase().split("saving throws:").pop().split("\n")[0].split("The")[0].split(".")[0].split("skills:")[0].trim().match(/(.*)(?:$|The|\.$|\w+:)/im);if(c){const e=c[1].replace("and",",").split(",").map((e=>e.trim())).filter((e=>d.x.actor.abilities.some((t=>t.long.toLowerCase()===e.toLowerCase())))).map((e=>d.x.actor.abilities.find((t=>t.long.toLowerCase()===e.toLowerCase())).value));t.system.saves=e}if(e.equipmentDescription&&(t.system.description.value+=`<p><b>Starting Equipment</b></p>\n${e.equipmentDescription}\n\n`),e.wealthDice){const a=e.wealthDice.diceString,i=e.wealthDice.diceMultiplier;t.system.wealth=i&&a?`${a}*${i}`:""}return t}async function buildClass(e,t){let a=await buildBaseClass(e);return a.system.description.value+=await buildClassFeatures(e,t),a.system.description.value=o.DDBReferenceLinker.parseTags(a.system.description.value),a.system.advancement.push(function getHPAdvancement(e,t){const a={};if(e){const i=foundry.utils.getProperty(t,"flags.ddbimporter.rolledHP")??!1,n=!0===foundry.utils.getProperty(e,"flags.ddbimporter.isStartingClass"),s=game.settings.get("ddb-importer","character-update-policy-use-hp-max-for-rolled-hp");if(i&&!s){const i=foundry.utils.getProperty(t,"flags.ddbimporter.baseHitPoints"),s=foundry.utils.getProperty(t,"flags.ddbimporter.dndbeyond.totalLevels"),r=Math.floor(i/s),o=Math.floor(i%s);for(let t=1;t<=e.system.levels;t++)a[`${t}`]=1===t&&n?r+o:r}else for(let t=1;t<=e.system.levels;t++)a[`${t}`]=1===t&&n?"max":"avg"}return{_id:foundry.utils.randomID(),type:"HitPoints",configuration:{},value:a,title:"",icon:"",classRestriction:""}}(),...await generateFeatureAdvancements(e,t)),a.system.advancement=await async function addSRDAdvancements(e,t){for(const a of d.y.FOUNDRY_COMPENDIUM_MAP.classes){const n=i.CompendiumHelper.getCompendium(a,!1);if(!n)continue;await n.getIndex();const s=n.index.find((e=>e.name===t.name&&"class"===e.type));if(!s)continue;const r=(await n.getDocument(s._id)).system.advancement.filter((t=>"ScaleValue"===t.type&&!e.some((e=>e.configuration.identifier===t.configuration.identifier)))).map((e=>e.toObject()));return e.push(...r),e}return e}(a.system.advancement,a),a.system.startingEquipment=await async function _getSRDEquipment(e){for(const t of d.y.FOUNDRY_COMPENDIUM_MAP.classes){const a=i.CompendiumHelper.getCompendium(t,!1);if(!a)continue;await a.getIndex();const n=a.index.find((t=>t.name===e.name&&"class"===t.type));if(!n)continue;const s=await a.getDocument(n._id);return foundry.utils.duplicate(s.system.startingEquipment)}return[]}(a),a}async function buildSubClass(e,t,a){let n=await buildBaseClass(e.flags.ddbimporter.data),s=await async function buildSubClassBase(e,t){delete e._id,await getClassImages(t,e),e.flags.ddbimporter.parentClassId=t.parentClassId,e.flags.ddbimporter.spellCastingAbilityId=t.spellCastingAbilityId,e.flags.ddbimporter.canCastSpells=t.canCastSpells,e.flags.ddbimporter.moreDetailsUrl=t.moreDetailsUrl;const a=foundry.utils.getProperty(e,"flags.ddbimporter.image");if(a&&""!==a){const t=/$<img class="ddb-class-image"(.*)$/;e.system.description.value.replace(t,a)}return e.system.classIdentifier=i.utils.referenceNameString(e.name).toLowerCase(),e.system.identifier=i.utils.referenceNameString(t.name).toLowerCase(),e.type="subclass",e.name=t.name,e.system.description.value+=`<h3>${t.name}</h3>\n${t.description}\n\n`,""===e.system.spellcasting&&t.canCastSpells&&(e.system.spellcasting="third"),e}(n,t);const r=e.flags.ddbimporter.data.classFeatures.map((e=>e.id));return s.system.description.value+=await buildClassFeatures(t,a,r),s.system.description.value=o.DDBReferenceLinker.parseTags(s.system.description.value),s.system.advancement.push(...await generateFeatureAdvancements(t,a,r)),s}async function getSubClasses(e,t){if(!t||!e)return[];i.logger.debug("get subclasses started");const a=game.settings.get("ddb-importer","munching-policy-update-existing"),n=new i.DDBItemImporter("class",[],{deleteBeforeUpdate:!1,matchFlags:["is2014","is2024"],notifier:i.utils.munchNote});await n.init();const s=await n.compendium.getDocuments();let r=[],o=[],l=[];const d=new i.DDBCompendiumFolders("features");i.utils.munchNote("Checking compendium folders..",!0),await d.loadCompendium("features");const c=new i.DDBCompendiumFolders("subclasses");await c.loadCompendium("subclasses"),i.utils.munchNote("",!0);for(const a of e){const e=CONFIG.DDB.classConfigurations.find((e=>e.id===a.parentClassId));await d.createSubClassFeatureFolder(a.name,e.name),i.logger.debug(`${a.name} feature parsing started...`,{subClass:a,classMatch:e});const n=a.classFeatures.filter((e=>!t.classFeatures.some((t=>e.id===t.id))));for(const t of n){const n=o.some((e=>e.name===t.name&&e.flags.ddbimporter.classId===a.id));if(i.logger.debug(`${t.name} subclass feature starting...`,{existingFeature:n,feature:t}),!p.includes(t.name.trim())&&!n){const i=await getClassFeature(t,a,a.name,e.name);o.push(i),l.push({class:e.name,subClass:a.name,feature:t.name})}}}const u={chrisPremades:!0,removeSRDDuplicates:!1,filterDuplicates:!1,deleteBeforeUpdate:!1,matchFlags:["featureId"],useCompendiumFolders:!0,indexFilter:{fields:["name","flags.ddbimporter.classId","flags.ddbimporter.class","flags.ddbimporter.featureName","flags.ddbimporter.subClass","flags.ddbimporter.parentClassId"]}};i.logger.debug(`Creating ${t.name} subclass features`,{classFeatures:o,featureHandlerOptions:u,updateBool:a,notifier:i.utils.munchNote});const m=await i.DDBItemImporter.buildHandler("features",o,a,u);await m.buildIndex(u.indexFilter);const g=await m.compendiumIndex.filter((e=>m.documents.some((t=>e.name===t.name))));let h=[];for(const e of g){const t=await m.compendium.getDocument(e._id);h.push(t.toJSON())}i.logger.debug("Features fetched for classes",h);for(const t of e){const e=s.find((e=>foundry.utils.getProperty(e,"flags.ddbimporter.id")==t.parentClassId)),a=await buildSubClass(e,t,h);r.push(a)}i.logger.debug("Subclass build finished",r);const f={deleteBeforeUpdate:!1,matchFlags:["id"],useCompendiumFolders:!0,notifier:i.utils.munchNote};return await i.DDBItemImporter.buildHandler("subclasses",r,a,f),l}async function getClassOptions(e,t){i.logger.debug("get options started");const a=game.settings.get("ddb-importer","munching-policy-update-existing");let n=[],s=[];const r=CONFIG.DDB.classConfigurations.find((e=>e.name===t)),o={name:t,id:r.id};for(const a of e){const e=s.some((e=>e.name===a.name));if(i.logger.debug(`${a.name} feature starting...`),!p.includes(a.name.trim())&&!e){const e=await getClassFeature(a,o);foundry.utils.setProperty(e,"flags.ddbimporter.optionalFeature",!0),s.push(e),n.push({class:t,subClass:"",feature:a.name})}}const l={chrisPremades:!0,deleteBeforeUpdate:!1,removeSRDDuplicates:!1,filterDuplicates:!1,matchFlags:["featureId"],notifier:i.utils.munchNote};return await i.DDBItemImporter.buildHandler("features",s,a,l),n}function getSubClassesData(e){const t=i.Secrets.getCobalt(),a=i.DDBCampaigns.getCampaignId(i.utils.munchNote),n=i.DDBProxy.getProxy(),s={cobalt:t,campaignId:a,betaKey:i.PatreonHelper.getPatreonKey(),className:e},r=game.settings.get(d.y.MODULE_ID,"debug-json");return new Promise(((t,a)=>{fetch(`${n}/proxy/subclass`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(s)}).then((e=>e.json())).then((t=>(r&&i.FileHelper.download(JSON.stringify(t),`subclass-${e}-raw.json`,"application/json"),t.success||(i.utils.munchNote(`Failure: ${t.message}`),a(t.message)),t))).then((e=>t(e.data))).catch((e=>a(e)))}))}function getClassOptionsData(e){const t=i.Secrets.getCobalt(),a=i.DDBCampaigns.getCampaignId(i.utils.munchNote),n=i.DDBProxy.getProxy(),s={cobalt:t,campaignId:a,betaKey:i.PatreonHelper.getPatreonKey(),className:e},r=game.settings.get(d.y.MODULE_ID,"debug-json");return new Promise(((t,a)=>{fetch(`${n}/proxy/v5/classes/options`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(s)}).then((e=>e.json())).then((t=>(r&&i.FileHelper.download(JSON.stringify(t),`subclass-${e}-raw.json`,"application/json"),t.success||(i.utils.munchNote(`Failure: ${t.message}`),a(t.message)),t))).then((e=>t(e.data))).catch((e=>a(e)))}))}async function parseClasses(){const e=d.y.COMPENDIUMS.find((e=>"Classes"===e.title));await(0,c.k)(e);const t=d.y.COMPENDIUMS.find((e=>"Subclasses"===e.title));await(0,c.k)(t);const a=d.y.COMPENDIUMS.find((e=>"Class Features"===e.title));await(0,c.k)(a);const n=await function getClassesData(){const e=i.Secrets.getCobalt(),t=i.DDBCampaigns.getCampaignId(i.utils.munchNote),a=i.DDBProxy.getProxy(),n={cobalt:e,campaignId:t,betaKey:i.PatreonHelper.getPatreonKey()},s=game.settings.get(d.y.MODULE_ID,"debug-json");return new Promise(((e,t)=>{fetch(`${a}/proxy/classes`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)}).then((e=>e.json())).then((e=>(s&&i.FileHelper.download(JSON.stringify(e),"classes-raw.json","application/json"),e.success||(i.utils.munchNote(`Failure: ${e.message}`),t(e.message)),e))).then((t=>e(t.data))).catch((e=>t(e)))}))}(),s=await async function getClasses(e){let t=[];i.logger.debug("get clases started",{data:e});const a=game.settings.get("ddb-importer","munching-policy-update-existing");let n=[],s=[];const r=new i.DDBCompendiumFolders("features");i.utils.munchNote("Checking compendium folders..",!0),await r.loadCompendium("features"),i.utils.munchNote("",!0);for(const a of e){i.logger.debug(`${a.name} feature parsing started...`,{klass:a});for(const e of a.classFeatures.sort(((e,t)=>e.requiredLevel-t.requiredLevel))){const n=s.some((t=>t.flags.ddbimporter.originalName===e.name&&t.flags.ddbimporter.classId===a.id));if(i.logger.debug(`${e.name} class feature starting...`,{existingFeature:n,feature:e}),!p.includes(e.name)&&!n){const i=await getClassFeature(e,a);s.push(i),t.push({class:a.name,subClass:"",feature:e.name})}}}const o={chrisPremades:!0,deleteBeforeUpdate:!1,removeSRDDuplicates:!1,filterDuplicates:!1,matchFlags:["featureId"],useCompendiumFolders:!0};i.logger.debug("Creating class features",{classFeatures:s,featureHandlerOptions:o,updateBool:a,notifier:i.utils.munchNote});const l=await i.DDBItemImporter.buildHandler("features",s,a,o),d=await l.compendiumIndex.filter((e=>l.documents.some((t=>e.name===t.name))));let c=[];for(const e of d){const t=await l.compendium.getDocument(e._id);c.push(t.toJSON())}for(const t of e){i.logger.debug(`${t.name} class parsing started...`);const e=await buildClass(t,c);n.push(e)}return i.logger.debug("Class build finished",n),await i.DDBItemImporter.buildHandler("classes",n,a,{useCompendiumFolders:!0,notifier:i.utils.munchNote}),t}(n),r=CONFIG.DDB.classConfigurations.filter((e=>!e.name.includes("archived")&&!e.name.includes("(UA)"))).map((e=>e.name)),o=[];for(const e of r){const t=n.find((t=>t.name===e)),a=await getSubClassesData(e);if(!t||a&&i.utils.isArray(a)&&a.length>0){const e=await getSubClasses(a,t);o.push(...e)}}const l=[];for(const e of r){const t=await getClassOptionsData(e),a=await getClassOptions(t,e);l.push(...a)}return s.concat(o.flat(),l.flat())}async function parseFrames(){const e=await async function getFrameData(){const e=i.Secrets.getCobalt(),t=i.PatreonHelper.getPatreonKey(),a=i.DDBProxy.getProxy(),n=game.settings.get(d.y.MODULE_ID,"debug-json"),s={cobalt:e,betaKey:t};return new Promise(((e,t)=>{fetch(`${a}/proxy/frames`,{method:"POST",mode:"cors",headers:{"Content-Type":"application/json"},body:JSON.stringify(s)}).then((e=>e.json())).then((e=>(e.success||(i.utils.munchNote(`API Failure: ${e.message}`),t(e.message)),n&&i.FileHelper.download(JSON.stringify(e),"frames-raw.json","application/json"),e))).then((t=>{i.utils.munchNote(`Retrieved ${t.data.length} frames, starting parse...`,!0,!1),i.logger.info(`Retrieved ${t.data.length} frames`),e(t.data)})).catch((e=>t(e)))}))}();i.logger.debug("Importing frames",e);const t=game.settings.get(d.y.MODULE_ID,"frame-image-upload-directory").replace(/^\/|\/$/g,""),a=game.settings.get(d.y.MODULE_ID,"use-deep-file-paths")?"":"frames";return i.utils.munchNote("Fetching DDB Frames"),e.forEach((async e=>{const n={type:"frame",name:`DDB ${e.name}`,download:!0,targetDirectory:t,pathPostfix:"",imageNamePrefix:a};await i.FileHelper.getImagePath(e.frameAvatarUrl,n)})),i.utils.munchNote(""),e.length}var g=a(383),h=a(492);class AdventureMunchHelpers{static findEntityByImportId(e,t){return game.data[e].find((e=>e._id===t))}static async replaceAsync(e,t,a){const i=[];e.replace(t,((e,...t)=>{const n=a(e,...t);i.push(n)}));const n=await Promise.all(i);return e.replace(t,(()=>n.shift()))}static diff(e,t){let a={};for(const i in e)t[i]!=e[i]&&(a[i]=t[i]),"array"==typeof t[i]&&"array"==typeof e[i]&&(a[i]=this.diff(e[i],t[i])),"object"==typeof t[i]&&"object"==typeof e[i]&&(a[i]=this.diff(e[i],t[i]));return a}static reMatchAll(e,t){const a=t.match(new RegExp(e,"gm"));if(a){let i=0;return a.map((a=>{const n=a.match(e);return n.index=t.indexOf(a,i),i=n.index,n}))}return a}static async loadMissingDocuments(e,t){return new Promise((a=>{if(t&&t.length>0)switch(e){case"item":i.logger.debug(`Importing missing ${e}s from DDB`,t),AdventureMunch._progressNote(`Importing ${t.length} missing ${e}s from DDB`),a((0,n.m)({useSourceFilter:!1,ids:t,deleteBeforeUpdate:!1}));break;case"monster":try{const n=i.PatreonHelper.getPatreonTier();if(i.PatreonHelper.calculateAccessMatrix(n).all){i.logger.debug(`Importing missing ${e}s from DDB`,t),AdventureMunch._progressNote(`Importing ${t.length} missing ${e}s from DDB`);a(new h.A({notifier:i.utils.munchNote}).processIntoCompendium(t))}else i.logger.warn(`Unable to import missing ${e}s from DDB - link to patreon or use your own proxy`,t),ui.notifications.warn(`Unable to import missing ${e}s from DDB - link to patreon or use your own proxy`,{permanent:!0}),a([])}catch(e){if(!(e instanceof SyntaxError))throw e;ui.notifications.error("Error fetching monsters, likely cause outdated ddb-proxy",{permanent:!0})}break;case"spell":i.logger.debug(`Importing missing ${e}s from DDB`),AdventureMunch._progressNote("Missing spells detected, importing from DDB"),a((0,s.p)(null,!1))}else a([])}))}static async getCompendiumIndex(e){return new Promise((t=>{const a=i.CompendiumHelper.getCompendiumType(e),n="monster"===e?["flags.ddbimporter.id"]:["flags.ddbimporter.definitionId"];t(a.getIndex({fields:n}))}))}static async checkForMissingDocuments(e,t){const a=await AdventureMunchHelpers.getCompendiumIndex(e);return new Promise((n=>{const s=t.filter((t=>{switch(e){case"monster":return!a.some((e=>e.flags?.ddbimporter?.id&&String(e.flags.ddbimporter.id)==String(t)));case"spell":case"item":return!a.some((e=>e.flags?.ddbimporter?.definitionId&&String(e.flags.ddbimporter.definitionId)==String(t)));default:return!1}}));i.logger.debug(`${e} missing ids`,s);const r=AdventureMunchHelpers.loadMissingDocuments(e,s);i.logger.debug(`${e} missing`,r),n(r)}))}static async getDocuments(e,t,a={},n=!1){const s=i.CompendiumHelper.getCompendiumType(e),r=await AdventureMunchHelpers.getCompendiumIndex(e),o=t.map((e=>String(e)));return new Promise((t=>{const l=r.filter((t=>{switch(e){case"monster":return o.includes(String(foundry.utils.getProperty(t,"flags.ddbimporter.id")));case"spell":case"item":return o.includes(String(foundry.utils.getProperty(t,"flags.ddbimporter.definitionId")));default:return!1}})).map((t=>{switch(e){case"monster":return game.actors.importFromCompendium(s,t._id,a,{temporary:n,keepId:!0,keepEmbeddedIds:!0});case"spell":case"item":return game.items.importFromCompendium(s,t._id,a,{temporary:n,keepId:!0,keepEmbeddedIds:!0});default:return}}));i.logger.debug(`${e} documents loaded`,l),t(l)}))}static async linkExistingActorTokens(e){const t=await AdventureMunchHelpers.getCompendiumIndex("monster");return e.map((e=>{const a=t.find((t=>t.flags?.ddbimporter?.id&&e.flags.ddbActorFlags?.id&&t.flags.ddbimporter.id===e.flags.ddbActorFlags.id));return a&&(e.flags.compendiumActorId=a._id),e}))}static extractDocumentVersionData(e,t){const a=game.modules.get(d.y.MODULE_ID).version;if(t||(t={}),foundry.utils.setProperty(e,"flags.ddb.versions.importer",{}),e?.flags?.ddb?.versions?.ddbMetaData?.lastUpdate){const i=t.flags?.ddb?.versions?.ddbMetaData?.lastUpdate?t.flags.ddb.versions.ddbMetaData:{lastUpdate:"0.0.1",drawings:"0.0.1",notes:"0.0.1",tokens:"0.0.1",walls:"0.0.1",lights:"0.0.1",foundry:"0.8.9"},n={ddbImporter:t?.flags?.ddb?.versions?.ddbImporter?t.flags.ddb.versions.ddbImporter:"2.0.1",ddbMetaData:i,adventureMuncher:t?.flags?.ddb?.versions?.adventureMuncher?t.flags.ddb.versions.adventureMuncher:"0.3.0"},s=e.flags.ddb.versions,r=void 0!==s.ddbMetaData.foundry?s.ddbMetaData.foundry:"0.8.9",o=foundry.utils.isNewerVersion(a,n.ddbImporter),l=foundry.utils.isNewerVersion(s.ddbMetaData.lastUpdate,n.ddbMetaData.lastUpdate),d=foundry.utils.isNewerVersion(s.adventureMuncher,n.adventureMuncher),c=foundry.utils.isNewerVersion(r,game.version);let u={};(l||d||c)&&(u.importerVersionChanged=o,u.metaVersionChanged=l,u.muncherVersionChanged=d,u.foundryVersionNewer=c,u.drawingVersionChanged=foundry.utils.isNewerVersion(s.ddbMetaData.drawings,n.ddbMetaData.drawings),u.noteVersionChanged=foundry.utils.isNewerVersion(s.ddbMetaData.notes,n.ddbMetaData.notes),u.tokenVersionChanged=foundry.utils.isNewerVersion(s.ddbMetaData.tokens,n.ddbMetaData.tokens),u.wallVersionChanged=foundry.utils.isNewerVersion(s.ddbMetaData.walls,n.ddbMetaData.walls),u.lightVersionChanged=foundry.utils.isNewerVersion(s.ddbMetaData.lights,n.ddbMetaData.lights)),foundry.utils.setProperty(e,"flags.ddb.versions.ddbImporter",a),foundry.utils.setProperty(e,"flags.ddb.versions.importer",u),foundry.utils.setProperty(e,"flags.ddb.oldVersions",n)}return e}static getImportType(e){const t=e[0].toUpperCase()+e.slice(1);let a=t;switch(e){case"journal":a="JournalEntry";break;case"table":a="RollTable";break;default:a=t}return a}static folderExists(e,t){return Object.values(t.files).filter((t=>t.dir&&t.name.toLowerCase().includes(e))).length>0}static getFiles(e,t){return Object.values(t.files).filter((t=>!t.dir&&"json"===t.name.split(".").pop()&&t.name.includes(`${e}/`)))}}class AdventureMunch extends FormApplication{static COMPENDIUM_MAP={spells:"spells",magicitems:"items",weapons:"items",armor:"items","adventuring-gear":"items",monsters:"monsters",vehicles:"vehicles"};static DDB_MAP={spells:"spells",magicitems:"magic-items",weapons:"equipment",armor:"equipment","adventuring-gear":"equipment",monsters:"monsters",vehicles:"vehicles"};constructor(e={},t={}){super(e,t),this._itemsToRevisit=[],this.adventure=null,this.folders=null,this.raw={scene:[],journal:[],actor:[],item:[],table:[],playlist:[],macro:[],folder:[]},this.temporary={scenes:[],journals:[],actors:[],items:[],tables:[],playlists:[],macros:[],folders:[]},this.remove={folderIds:new Set},this.zip=null,this.allMonsters=!1,this.journalWorldActors=!1,this.importFilename=null,this.importToAdventureCompendium=!1,this.lookups={folders:{},compendiumFolders:{},import:{},actors:{},sceneTokens:{},adventureConfig:{}},this.addToCompendiums=!1,this.compendiums={journal:null,table:null},this._compendiumItemsToRevisit=[]}static get defaultOptions(){return this.pattern=/(@[a-z]*)(\[)([a-z0-9]*|[a-z0-9.]*)(\])(\{)(.*?)(\})/gim,this.altpattern=/((data-entity)=\\?["']?([a-zA-Z]*)\\?["']?|(data-pack)=\\?["']?([[\S.]*)\\?["']?) data-id=\\?["']?([a-zA-Z0-9]*)\\?["']?.*?>(.*?)<\/a>/gim,foundry.utils.mergeObject(super.defaultOptions,{id:"ddb-adventure-import",classes:["ddb-adventure-import"],title:"Adventure Munch",template:"modules/ddb-importer/handlebars/adventure/import.hbs",width:350})}findCompendiumEntityByImportId(e,t){return this.compendiums[e].index.find((e=>e._id===t))}replaceUUIDSForCompendium(e){return e=(e=e.replaceAll(/@UUID\[JournalEntry/g,`@UUID[Compendium.${this.compendiums.journal.metadata.id}.JournalEntry`)).replaceAll(/@UUID\[RollTable/g,`@UUID[Compendium.${this.compendiums.table.metadata.id}.RollTable`)}getImportFilePaths(e,t){const a=game.settings.get(d.y.MODULE_ID,"use-webp")&&!e.endsWith("svg")&&!e.endsWith("pdf"),n=this.adventure.name.replace(/[^a-z0-9]/gi,"_"),s=e.replace(/[\\/][^\\/]+$/,""),r=e.replace(/^.*[\\/]/,"").replace(/\?(.*)/,""),o=a&&!r.endsWith(".webp")?`${i.FileHelper.removeFileExtension(r)}.webp`:r,l=t?game.settings.get(d.y.MODULE_ID,"adventure-misc-path"):game.settings.get(d.y.MODULE_ID,"adventure-upload-path"),c=i.FileHelper.parseDirectory(l),u=t?`${l}/${s}`:`${l}/${n}/${s}`;return{pathKey:`${u}/${o}`,adventurePath:n,targetPath:s,filename:o,baseUploadPath:l,parsedBaseUploadPath:c,uploadPath:t?`${c.current}/${s}`:`${c.current}/${n}/${s}`,returnFilePath:t?`${s}/${o}`:`${n}/${s}/${o}`,baseFilename:r,fullUploadPath:u,forcingWebp:a&&r!==o}}async importRawFile(e,t,a,n){try{if("*"===e[0])return e.replace(/\*/g,"");if(e.startsWith("icons/")||e.startsWith("systems/dnd5e/icons/")||e.startsWith("ddb://"))return e;{const s=this.getImportFilePaths(e,n);if(s.fullUploadPath&&!CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(s.fullUploadPath)&&(i.logger.debug(`Checking dir path ${s.uploadPath}`,s),await i.FileHelper.verifyPath(s.parsedBaseUploadPath,`${s.uploadPath}`),await i.FileHelper.generateCurrentFiles(s.fullUploadPath),CONFIG.DDBI.KNOWN.CHECKED_DIRS.add(s.fullUploadPath)),CONFIG.DDBI.KNOWN.FILES.has(s.pathKey))i.logger.debug(`File already imported ${e}`);else{i.logger.debug(`Importing raw file from ${e}`,s);const n=new File([t],s.filename,{type:a}),r=(await i.FileHelper.uploadToPath(s.fullUploadPath,n))?.path;CONFIG.DDBI.KNOWN.FILES.add(s.pathKey),CONFIG.DDBI.KNOWN.LOOKUPS.set(`${s.pathKey}`,r)}return`${CONFIG.DDBI.KNOWN.LOOKUPS.get(s.pathKey)}`}}catch(t){i.logger.error(`Error importing image file ${e} : ${t.message}`,{err:t})}return e}async importImage(e,t=!1){try{if("*"===e[0])return e.replace(/\*/g,"");if(e.startsWith("icons/")||e.startsWith("systems/dnd5e/icons/")||e.startsWith("ddb://"))return e;{const a=this.getImportFilePaths(e,t);if(a.fullUploadPath&&!CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(a.fullUploadPath)&&(i.logger.debug(`Checking dir path ${a.uploadPath}`,a),await i.FileHelper.verifyPath(a.parsedBaseUploadPath,`${a.uploadPath}`),await i.FileHelper.generateCurrentFiles(a.fullUploadPath),CONFIG.DDBI.KNOWN.CHECKED_DIRS.add(a.fullUploadPath)),CONFIG.DDBI.KNOWN.FILES.has(a.pathKey))i.logger.debug(`File already imported ${e}`);else{i.logger.debug(`Importing image from ${e}`,a);const t=await this.zip.file(e).async("blob"),n=await i.FileHelper.uploadImage(t,a.fullUploadPath,a.filename,a.forcingWebp);CONFIG.DDBI.KNOWN.FILES.add(a.pathKey),CONFIG.DDBI.KNOWN.LOOKUPS.set(a.pathKey,n)}const n=`${a.fullUploadPath}/${a.filename}`;return`${CONFIG.DDBI.KNOWN.LOOKUPS.get(n)}`}}catch(t){i.logger.error(`Error importing image file ${e} : ${t.message}`,{err:t})}return e}async getData(){return{allScenes:game.settings.get(d.y.MODULE_ID,"adventure-policy-all-scenes"),allMonsters:game.settings.get(d.y.MODULE_ID,"adventure-policy-all-actors-into-world"),journalWorldActors:game.settings.get(d.y.MODULE_ID,"adventure-policy-journal-world-actors"),addToCompendiums:game.settings.get(d.y.MODULE_ID,"adventure-policy-add-to-compendiums"),cssClass:"ddb-importer-window"}}async importFolder(e,t){await i.utils.asyncForEach(e,(async e=>{const a=e,n=game.folders.find((e=>e._id===a._id&&e.type===a.type));if(n)this.temporary.folders.some((e=>e._id===n._id))||this.temporary.folders.push(n),i.logger.debug(`Found existing folder ${n._id} with data:`,a,n);else{a.parent&&(a.folder=a.parent);const e=await Folder.create(a,{keepId:!0});this.temporary.folders.push(e),this.importToAdventureCompendium&&this.remove.folderIds.add(e._id),i.logger.debug(`Created new folder ${e._id} with data:`,a,e)}let s=t.filter((e=>e.parent===a._id));s.length>0&&(i.logger.debug(`Creating subfolders for ${a._id} (${a.type})`,s),await this.importFolder(s,t))}))}async importCompendiumFolder(e,t){await i.utils.asyncForEach(e,(async e=>{let a=e;if(["JournalEntry","RollTable"].includes(a.type)){const e=i.CompendiumHelper.getCompendiumType(a.type);let n=e.folders.find((e=>(e._id===a._id||e.flags.importid===a._id)&&e.type===a.type));n||(null===a.parent?a.parent=this.lookups.folders[a.type]:a.parent=this.lookups.folders[a.parent],n=await Folder.create(a,{keepId:!0,pack:e.metadata.id}),i.logger.debug(`Created new compendium folder ${n._id} with data:`,a,n)),this.lookups.folders[a.flags.importid]=n._id;let s=t.filter((e=>e.parent===a._id));s.length>0&&await this.importCompendiumFolder(s,t)}}))}async _createFolders(){this.lookups.folders={},this.lookups.compendiumFolders={};const e=this.folders.filter((e=>null===e.parent));await this.importFolder(e,this.folders),this.addToCompendiums&&await this.importCompendiumFolder(e,this.folders)}activateListeners(e){super.activateListeners(e),e.find(".world-button").on("click",this._importAdventure.bind(this)),e.find(".compendium-button").on("click",this._importAdventure.bind(this))}async _checkForMissingData(){this.adventure.required?.spells&&this.adventure.required.spells.length>0&&(i.logger.debug(`${this.adventure.name} - spells required`,this.adventure.required.spells),AdventureMunch._progressNote("Checking for missing spells from DDB"),await AdventureMunchHelpers.checkForMissingDocuments("spell",this.adventure.required.spells)),this.adventure.required?.items&&this.adventure.required.items.length>0&&(i.logger.debug(`${this.adventure.name} - items required`,this.adventure.required.items),AdventureMunch._progressNote("Checking for missing items from DDB"),await AdventureMunchHelpers.checkForMissingDocuments("item",this.adventure.required.items)),this.adventure.required?.monsters&&this.adventure.required.monsters.length>0&&(i.logger.debug(`${this.adventure.name} - monsters required`,this.adventure.required.monsters),AdventureMunch._progressNote("Checking for missing monsters from DDB"),await AdventureMunchHelpers.checkForMissingDocuments("monster",this.adventure.required.monsters)),parseFloat(this.adventure.version)<4.1&&this.allMonsters?ui.notifications.warn("Unable to add all monsters from this adventure, please re-munch adventure with Adventure Muncher v1.0.9 or higher"):parseFloat(this.adventure.version)>=4.1&&this.allMonsters&&this.adventure.required?.monsterData&&this.adventure.required?.monsterData?.length>0&&(i.logger.debug(`${this.adventure.name} - Importing Remaining Actors`),AdventureMunch._progressNote(`Checking for missing world actors (${this.adventure.required.monsterData.length}) from compendium...`),await this.importRemainingActors(this.adventure.required.monsterData)),i.logger.debug("Missing data check complete")}async _importFiles(){AdventureMunchHelpers.folderExists("scene",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading scenes`),await this._checkForDataUpdates("scene")),AdventureMunchHelpers.folderExists("actor",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading actors`),await this._importFile("actor")),AdventureMunchHelpers.folderExists("item",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading item`),await this._importFile("item")),AdventureMunchHelpers.folderExists("journal",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading journal`),await this._importFile("journal")),AdventureMunchHelpers.folderExists("table",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading table`),await this._importFile("table")),AdventureMunchHelpers.folderExists("playlist",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading playlist`),await this._importFile("playlist")),AdventureMunchHelpers.folderExists("macro",this.zip)&&(i.logger.debug(`${this.adventure.name} - Loading macro`),await this._importFile("macro"))}_renderCompleteDialog(){new Dialog({title:`Successful Import of ${this.adventure.name}`,content:{adventure:this.adventure},buttons:{two:{label:"OK"}}},{classes:["dialog","adventure-import-export"],template:"modules/ddb-importer/handlebars/adventure/import-complete.hbs"}).render(!0)}fetchTemporaryItem(e){const t=e.split(".").pop();for(const[a,n]of Object.entries(this.temporary)){i.logger.debug(`Checking temporary ${a} for ${e}`,n);const s=n.find((e=>e._id===t));if(s)return i.logger.debug(`Found ${a} match for ${e}`,s),s}}_getWorldActor(e){return this.importToAdventureCompendium?this.temporary.actors.find((t=>t._id===e)):game.actors.get(e)}static async _getTokenUpdateData(e,t){const a=[],n=t.flags.ddbItems??[];for(const s of n)if(s.customItem)a.push(s.data);else{const n=foundry.utils.getProperty(s,"ddbId");if(Number.isInteger(n)){const e=i.CompendiumHelper.getCompendiumType(s.type),n=e.index.find((e=>e.name===s.name&&e.type===s.type));if(n){const t=(await e.getDocument(n._id)).toObject();delete t._id,a.push(t)}else i.logger.error(`Unable to find compendium item ${s.name}`,{item:s,sceneToken:t})}else{const n=e.items.find((e=>e.name===s.name&&e.type===s.type));if(n){const e=n.toObject();delete e._id,a.push(e)}else i.logger.error(`Unable to find monster feature/item ${s.name}`,{item:s,sceneToken:t,worldActor:e})}}const s={};if(foundry.utils.hasProperty(t,"actorData")){const e=foundry.utils.deepClone(t.actorData);e.data?(foundry.utils.setProperty(s,"delta.system",foundry.utils.deepClone(e.data)),e.name&&foundry.utils.setProperty(s,"delta.name",foundry.utils.deepClone(e.name))):foundry.utils.setProperty(s,"delta",foundry.utils.deepClone(t.actorData)),delete t.actorData}a.length>0&&foundry.utils.setProperty(s,"delta.items",a),t.flags.ddbImages?.keepToken&&foundry.utils.setProperty(s,"texture.src",t.flags.ddbImages.tokenImage),t.flags.ddbImages?.keepAvatar&&foundry.utils.setProperty(s,"delta.img",t.flags.ddbImages.avatarImage);const r=foundry.utils.mergeObject(s,t);r.name===e.name||foundry.utils.hasProperty(r,"delta.name")||foundry.utils.setProperty(r,"delta.name",r.name);const o=await e.getTokenDocument(r);return i.logger.debug(`${t.name} token data for id ${t.actorId}`,o),o.toObject()}async _getSceneTokensV11(e,t){const a=[],n=[];for(const i of t)if(i.actorId&&!i.actorLink){const t=e.flags.ddb.tokens.find((e=>e._id===foundry.utils.getProperty(i,"flags.ddbActorFlags.tokenLinkId")));delete t.scale;const s=this._getWorldActor(i.actorId);if(s){const e=await AdventureMunch._getTokenUpdateData(s,t);a.push(e)}else n.push(i._id)}else n.push(i);return n.length>0&&i.logger.warn(`Removing ${e.name} tokens with no world actors`,n),a}async _revisitScene(e){let t={};const a=foundry.utils.duplicate(e);if(i.logger.info(`Updating ${a.name}, ${a.tokens.length} tokens`),!this.importToAdventureCompendium){if(!e.thumb){const a=await e.createThumbnail();t.thumb=a.thumb}await e.update(t)}}async _revisitItems(){try{if(this._itemsToRevisit.length>0){let e=this._itemsToRevisit.length,t=0;await i.utils.asyncForEach(this._itemsToRevisit,(async a=>{const n=setTimeout((()=>{i.logger.warn("Reference update timed out."),this._renderCompleteDialog(),this.close()}),18e4);try{const e=this.importToAdventureCompendium?this.fetchTemporaryItem(a):await fromUuid(a);if("Scene"===e.documentName)await this._revisitScene(e)}catch(e){i.logger.warn(`Error updating references for object ${a}`,e)}t+=1,AdventureMunch._updateProgress(e,t,"References"),clearTimeout(n)}))}}catch(e){i.logger.warn(`Error during reference update for object ${item}`,e)}i.logger.info("Revisit data complete")}async _loadZip(){const e=document.querySelector('form[class="ddb-importer-window"]');if(e.data.files.length)this.importFilename=e.data.files[0].name,this.zip=await i.FileHelper.readBlobFromFile(e.data.files[0]).then(JSZip.loadAsync);else{const e=document.querySelector('[name="import-file"]').value;this.importFilename=e,this.zip=await fetch(`/${e}`).then((e=>200===e.status||0===e.status?Promise.resolve(e.blob()):Promise.reject(new Error(e.statusText)))).then(JSZip.loadAsync)}}async _importAdventureToWorld(){await this._importFiles(),await this._revisitItems()}async _importAdventureToCompendium(){try{const e=await this._createAdventure();i.logger.debug("adventureData to add to compendium",e),await this._importAdventureCompendium(e)}catch(e){throw i.logger.error("Error importing to compendium",e),e}finally{const e=[...this.remove.folderIds];if(e.length>0){i.logger.debug("Removing folders",e);const t=await Folder.deleteDocuments(e);i.logger.debug("Delete results",t)}}}_unpackZip(){for(const e of Object.keys(this.raw))this.raw[e]=AdventureMunchHelpers.getFiles(e,this.zip)}async _chooseScenes(){const e=this.raw.scene;i.logger.info(`Selecting Scenes for ${this.adventure.name} - (${e.length} possible scenes for import)`);let t=[];return await i.utils.asyncForEach(e,(async e=>{const a=await this.zip.file(e.name).async("text"),i=JSON.parse(a),n=await game.scenes.find((e=>e.id===i._id)),s=AdventureMunchHelpers.extractDocumentVersionData(i,n);t.push(s)})),new Promise((e=>{new Dialog({title:"Choose Scenes to Import",content:{fileData:t,cssClass:"import-data-selection"},buttons:{selection:{label:"Selected",callback:async()=>{const t=$(".import-data-selection").serializeArray(),a=[];for(let e=0;e<t.length;e++){const i=t[e].name;a.push(this.raw.scene.find((e=>e.name.includes(i))))}i.logger.debug("scenes to import",a),this.raw.scene=a,e(this)}},all:{label:"All",callback:async()=>{e(this)}}},default:"all",close:async()=>{e(this)}},{width:700,classes:["dialog","adventure-import-selection"],template:"modules/ddb-importer/handlebars/adventure/choose-scenes.hbs"}).render(!0)}))}async _importAdventure(e){e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation();const t=e.currentTarget.dataset.button;if("world"===t||"compendium"===t)try{if($(".import-progress").toggleClass("import-hidden"),$(".ddb-overlay").toggleClass("import-invalid"),this.allScenes=document.querySelector('[name="all-scenes"]').checked,game.settings.set(d.y.MODULE_ID,"adventure-policy-all-scenes",this.allScenes),this.allMonsters=document.querySelector('[name="all-monsters"]').checked,game.settings.set(d.y.MODULE_ID,"adventure-policy-all-actors-into-world",this.allMonsters),this.journalWorldActors=document.querySelector('[name="journal-world-actors"]').checked,game.settings.set(d.y.MODULE_ID,"adventure-policy-journal-world-actors",this.journalWorldActors),this.addToCompendiums=document.querySelector('[name="add-to-compendiums"]').checked,game.settings.set(d.y.MODULE_ID,"adventure-policy-add-to-compendiums",this.addToCompendiums),this.addToCompendiums){const e=d.y.COMPENDIUMS.find((e=>"Journals"===e.title));await(0,c.k)(e);for(const e of Object.keys(this.compendiums))this.compendiums[e]=i.CompendiumHelper.getCompendiumType(e),await this.compendiums[e].getIndex()}await this._loadZip(),this._unpackZip(),this.adventure=JSON.parse(await this.zip.file("adventure.json").async("text")),i.logger.debug("Loaded adventure data",{adventure:this.adventure});try{this.folders=JSON.parse(await this.zip.file("folders.json").async("text")),i.logger.debug("Adventure folders",{folders:this.folders})}catch(e){i.logger.warn("Folder structure file not found.")}if(this.adventure.system!==game.data.system.id)throw ui.notifications.error(`Invalid system for Adventure ${this.adventure.name}.  Expects ${this.adventure.system}`,{permanent:!0}),new Error(`Invalid system for Adventure ${this.adventure.name}.  Expects ${this.adventure.system}`);if(parseFloat(this.adventure.version)<4)throw ui.notifications.error(`This Adventure (${this.adventure.name}) was generated for v9.  Please regenerate your config file for Adventure Muncher.`,{permanent:!0}),new Error(`This Adventure (${this.adventure.name}) was generated for v9.  Please regenerate your config file for Adventure Muncher.`);if("compendium"===t&&(this.importToAdventureCompendium=!0),await this._createFolders(),this.allScenes||await this._chooseScenes(),await this._checkForMissingData(),this.lookups.adventureConfig=await(0,g.g)(!0),"world"===t)await this._importAdventureToWorld();else if("compendium"===t){const e=d.y.COMPENDIUMS.find((e=>"Adventures"===e.title));await(0,c.k)(e),await this._importAdventureToCompendium()}$(".ddb-overlay").toggleClass("import-invalid"),this._renderCompleteDialog(),this.close()}catch(e){$(".ddb-overlay").toggleClass("import-invalid"),ui.notifications.error(`There was an error importing ${this.importFilename}`),i.logger.error(`Error importing file ${this.importFilename}`,e),i.logger.error(e),i.logger.error(e.stack),this.close()}finally{this.lookups={}}}async ensureWorldActors(e){i.logger.debug("Trying to import actors from compendium",e);const t=i.CompendiumHelper.getCompendiumType("monster",!1),a=[];return await i.utils.asyncForEach(e,(async e=>{let n=this._getWorldActor(e.actorId);if(!n){i.logger.info(`Importing actor ${e.name} with DDB ID ${e.ddbId} from ${t.metadata.name} with compendium id ${e.compendiumId}`);try{const a={keepId:!0,keepEmbeddedIds:!0};n=await game.actors.importFromCompendium(t,e.compendiumId,{_id:e.actorId,folder:e.folderId},a)}catch(t){i.logger.error(t),i.logger.warn(`Unable to import actor ${e.name} with id ${e.compendiumId} from DDB Compendium`),i.logger.debug(`Failed on: game.actors.importFromCompendium(monsterCompendium, "${e.compendiumId}", { _id: "${e.actorId}", folder: "${e.folderId}" }, { keepId: true });`)}}n&&a.push(n),this.importToAdventureCompendium&&!this.temporary.actors.some((t=>t._id===e.actorId))&&this.temporary.actors.push(n)})),i.logger.debug("Actors transferred from compendium to world.",a),a}static async linkDDBActors(e){const t=(await AdventureMunchHelpers.linkExistingActorTokens(e)).filter((e=>e.flags.ddbActorFlags?.id&&e.flags.compendiumActorId));return Promise.all(t)}async importRemainingActors(e){const t=[],a=i.CompendiumHelper.getCompendiumType("monster",!1),n=await AdventureMunchHelpers.getCompendiumIndex("monster");return i.logger.debug("Checking for the following actors in world",e),await i.utils.asyncForEach(e,(async e=>{i.logger.debug(`Checking for ${e.ddbId}`,e);let s=this._getWorldActor(e.actorId);if(s)i.logger.debug(`Actor found for ${e.actorId}, with name ${s.name}`);else{const t=n.find((t=>t.flags?.ddbimporter?.id&&t.flags.ddbimporter.id==e.ddbId));if(t){i.logger.info(`Importing actor ${t.name} with DDB ID ${e.ddbId} from ${a.metadata.name} with compendium id ${t._id} (temporary? ${this.importToAdventureCompendium})`);try{const i={_id:e.actorId,folder:e.folderId},n={keepId:!0,keepEmbeddedIds:!0};s=await game.actors.importFromCompendium(a,t._id,i,n)}catch(a){i.logger.error(a),i.logger.warn(`Unable to import actor ${t.name} with id ${t._id} from DDB Compendium`),i.logger.debug(`Failed on: game.actors.importFromCompendium(monsterCompendium, "${t._id}", { _id: "${e.actorId}", folder: "${e.folderId}" }, { keepId: true });`)}}else i.logger.error("Actor not found in compendium",e)}s&&t.push(s),s&&this.importToAdventureCompendium&&!this.temporary.actors.some((e=>s.flags.ddbimporter.id==e.flags.ddbimporter.id))&&this.temporary.actors.push(s)})),t}async generateTokenActors(e){i.logger.debug(`Token Actor generation for ${e.name} starting`);const t=(await AdventureMunch.linkDDBActors(e.tokens)).map((e=>({name:e.name,ddbId:e.flags.ddbActorFlags.id,actorId:e.actorId,compendiumId:e.flags.compendiumActorId,folderId:e.flags.actorFolderId}))).filter(((e,t,a)=>a.map((e=>e.actorId)).indexOf(e.actorId)===t)),a=await this.ensureWorldActors(t);return i.logger.debug(`Token Actor generation for ${e.name} complete`,a),a}async _loadDocumentAssets(e,t){return e.flags.importid=e._id,e.background?.src?e.background.src=await this.importImage(e.background.src):e.img&&(e.img=await this.importImage(e.img)),e.thumb&&(e.thumb=await this.importImage(e.thumb)),e?.token?.img&&(e=await this._importTokenImage("token",e,{img:!0,texture:!1})),e.toke?.texture?.src&&(e=await this._importTokenImage("token",e)),e?.prototypeToken?.img&&(e=await this._importTokenImage("prototypeToken",e,{img:!0,texture:!1})),e.prototypeToken?.texture?.src&&(e=await this._importTokenImage("prototypeToken",e)),e?.items?.length&&await i.utils.asyncForEach(e.items,(async e=>{e.img&&(e.img=await this.importImage(e.img))})),e?.pages?.length&&await i.utils.asyncForEach(e.pages,(async e=>{e.src&&(e.src=await this.importImage(e.src))})),"Scene"===t?(e.tokens&&await this.generateTokenActors(e),e.flags["perfect-vision"]&&Array.isArray(e.flags["perfect-vision"])&&(e.flags["perfect-vision"]={})):"Playlist"===t?await i.utils.asyncForEach(e.sounds,(async e=>{e.path&&(e.path=await this.importImage(e.path))})):"RollTable"===t?await i.utils.asyncForEach(e.results,(async t=>{t.img&&(t.img=await this.importImage(t.img)),t.resultId&&(e.flags.ddb.needRevisit=!0),i.logger.debug(`Updating DDB links for ${e.name}`),e.text=this.foundryCompendiumReplace(e.text)})):"JournalEntry"===t&&e.pages&&await i.utils.asyncForEach(e.pages,(async e=>{if(e.text.content){const t=AdventureMunchHelpers.reMatchAll(/(src|href)="(?!http(?:s*):\/\/)([\w0-9\-._~%!$&'()*+,;=:@/]*)"/,e.text.content);t&&(i.logger.debug(`Updating Image links for ${e.name}`),await i.utils.asyncForEach(t,(async t=>{const a=await this.importImage(t[2]);e.text.content=e.text.content.replace(t[0],`${t[1]}="${a}"`)}))),i.logger.debug(`Updating DDB links for ${e.name}`),e.text.content=this.foundryCompendiumReplace(e.text.content)}})),e}async _createAdventure(){i.logger.debug("Packing up adventure"),this.allMonsters&&await this.importRemainingActors(this.adventure.required.monsterData,!0);const e=await AdventureMunchHelpers.getDocuments("items",this.adventure.required.items??[],{},!0),t=await AdventureMunchHelpers.getDocuments("spells",this.adventure.required.spells??[],{},!0);i.logger.debug("Writing out Journals"),await this._importFile("journal"),i.logger.debug("Cartographer is working on Scenes"),await this._importFile("scene"),i.logger.debug("Performing some table calculations"),await this._importFile("table");const a=CONFIG.DDB.sources.find((e=>e.description===this.adventure.name)),n=a?.avatarURL?a.avatarURL:await this.importImage("assets/images/cover.jpg");await this._revisitItems();return{img:n,name:this.adventure.name,description:this.adventure.description,folders:this.temporary.folders.map((e=>e.toObject())),combats:[],items:e.concat(t).map((e=>e.toObject())),actors:this.temporary.actors.map((e=>e.toObject())),journal:this.temporary.journals.map((e=>e.toObject())),scenes:this.temporary.scenes.map((e=>e.toObject())),tables:this.temporary.tables.map((e=>e.toObject())),macros:[],cards:[],playlists:[],flags:{ddbimporter:{isDDBAdventure:!0,adventure:{required:this.adventure.required,revisitUuids:this._itemsToRevisit}},core:{sheetClass:"ddb-importer.DDBAdventureImporter"}}}}async _importAdventureCompendium(e){try{const t=i.CompendiumHelper.getCompendiumType("adventure"),a=t.index.find((t=>t.name===e.name));let n;if(a){i.logger.debug("Deleting existing adventure",a._id),e._id=a._id;const s=await t.getDocument(a._id);n=await s.update(e,{diff:!1,recursive:!1}),ui.notifications.info(game.i18n.format("ADVENTURE.UpdateSuccess",{name:e.name}))}else n=await Adventure.createDocuments([e],{pack:t.metadata.id,keepId:!0,keepEmbeddedIds:!0}),ui.notifications.info(game.i18n.format("ADVENTURE.CreateSuccess",{name:e.name}));return n}catch(e){throw i.logger.error("error building adventure",{err:e,this:this}),e}}async _importRenderedSceneFile(e,t){if(!AdventureMunchHelpers.findEntityByImportId("scenes",e._id)||t||this.importToAdventureCompendium){await i.utils.asyncForEach(e.tokens,(async e=>{foundry.utils.setProperty(e,"flags.ddbActorFlags.tokenLinkId",e._id),e.img&&(e.img=await this.importImage(e.img)),e.prototypeToken?.texture?.src&&(e.prototypeToken.texture.src=await this.importImage(e.prototypeToken.texture.src))})),await i.utils.asyncForEach(e.sounds,(async e=>{e.path=await this.importImage(e.path)})),await i.utils.asyncForEach(e.notes,(async e=>{e.icon&&(e.icon=await this.importImage(e.icon,!0)),e.texture?.src&&(e.texture.src=await this.importImage(e.texture.src,!0))})),await i.utils.asyncForEach(e.tiles,(async e=>{e.img&&(e.img=await this.importImage(e.img)),e.texture?.src&&(e.texture.src=await this.importImage(e.texture.src))}));for(const t of e.walls)0===t.door||t.doorSound||""===t.doorSound||(t.doorSound="woodBasic");t&&await Scene.deleteDocuments([e._id]);const a={keepId:!0,keepEmbeddedIds:!0};i.logger.debug(`Creating Scene ${e.name}`,foundry.utils.deepClone(e));const n=foundry.utils.deepClone(e.tokens);e.tokens=[];const s=await Scene.create(e,a);i.logger.debug(`Created Scene ${e.name}`,s);const r=await this._getSceneTokensV11(s,n);i.logger.debug(`Token Updates for ${e.name}`,r);const o=await s.createEmbeddedDocuments("Token",r,{keepId:!1});i.logger.debug(`Token update response for ${e.name}`,o),this._itemsToRevisit.push(`Scene.${s.id}`),this.importToAdventureCompendium&&(this.temporary.scenes.push(s),s.delete())}}async _importRenderedFile(e,t,a,i){const n=i.includes(t._id),s={keepId:!0,keepEmbeddedIds:!0};switch(e){case"Scene":await this._importRenderedSceneFile(t,n);break;case"Actor":if(!AdventureMunchHelpers.findEntityByImportId("actors",t._id)){let e=await Actor.create(t,s);await e.update({"prototypeToken.actorId":e.id}),a&&this._itemsToRevisit.push(`Actor.${e.id}`),this.importToAdventureCompendium&&this.temporary.actors.push(e)}break;case"Item":if(!AdventureMunchHelpers.findEntityByImportId("items",t._id)){let e=await Item.create(t,s);a&&this._itemsToRevisit.push(`Item.${e.id}`),this.importToAdventureCompendium&&this.temporary.items.push(e)}break;case"JournalEntry":if(!AdventureMunchHelpers.findEntityByImportId("journal",t._id)){let e=await JournalEntry.create(t,s);a&&this._itemsToRevisit.push(`JournalEntry.${e.id}`),this.importToAdventureCompendium&&this.temporary.journals.push(e)}if(this.addToCompendiums&&!this.findCompendiumEntityByImportId("journal",t._id)){const e=foundry.utils.mergeObject(s,{pack:this.compendiums.journal.metadata.id});t.pages.forEach((e=>{"text"==e.type&&(e.text.content=this.replaceUUIDSForCompendium(e.text.content))}));let a=await JournalEntry.create(t,e);this._compendiumItemsToRevisit.push(a)}break;case"RollTable":if(!AdventureMunchHelpers.findEntityByImportId("tables",t._id)){let e=await RollTable.create(t,s);a&&this._itemsToRevisit.push(`RollTable.${e.id}`),this.importToAdventureCompendium&&this.temporary.tables.push(e)}if(this.addToCompendiums&&!this.findCompendiumEntityByImportId("table",t._id)){const e=foundry.utils.mergeObject(s,{pack:this.compendiums.table.metadata.id});let a=await RollTable.create(t,e);this._compendiumItemsToRevisit.push(a)}break;case"Playlist":if(!AdventureMunchHelpers.findEntityByImportId("playlists",t._id)){t.name=`${this.adventure.name}.${t.name}`;let e=await Playlist.create(t,s);this.importToAdventureCompendium&&this.temporary.playlists.push(e)}break;case"Macro":if(!AdventureMunchHelpers.findEntityByImportId("macros",t._id)){let e=await Macro.create(t,s);a&&this._itemsToRevisit.push(`Macro.${e.id}`),this.importToAdventureCompendium&&this.temporary.macros.push(e)}}}async _checkForDataUpdates(e){const t=AdventureMunchHelpers.getImportType(e),a=this.raw[e];i.logger.info(`Checking ${this.adventure.name} - ${t} (${a.length} for updates)`);let n=[],s=!1;return await i.utils.asyncForEach(a,(async e=>{const a=await this.zip.file(e.name).async("text"),i=JSON.parse(a);switch(!s&&i?.flags?.ddb?.versions&&(s=!0),t){case"Scene":{const e=await game.scenes.find((e=>e.id===i._id)),t=AdventureMunchHelpers.extractDocumentVersionData(i,e),a=t.flags?.ddb?.versions?.importer;e?a&&(a.metaVersionChanged||a.muncherVersionChanged||a.foundryVersionNewer)&&n.push(t):a&&a.foundryVersionNewer&&n.push(t);break}}})),i.logger.debug("Scene update choices",n),new Promise((a=>{s&&n.length>0?new Dialog({title:`${t} updates`,content:{dataType:e,dataTypeDisplay:t,fileData:n,cssClass:"import-data-updates"},buttons:{confirm:{label:"Confirm",callback:async()=>{const e=$(".import-data-updates").serializeArray();let t=[],i="";for(let a=0;a<e.length;a++){const n=e[a].name;n.startsWith("new_")?t.push(n.substr(4)):"type"===n&&(i=e[a].value)}a(this._importFile(i,{overwriteIds:t}))}}},default:"confirm",close:async()=>{a(this._importFile(e))}},{width:700,classes:["dialog","adventure-import-updates"],template:"modules/ddb-importer/handlebars/adventure/import-updates.hbs"}).render(!0):a(this._importFile(e))}))}async _importTokenImage(e,t,{img:a=!1,texture:n=!0}={}){if(t[e]?.randomImg){const s=t[e].img.split("/").reverse()[0],r=t[e].img.replace(s,""),o=Object.values(this.zip.files).filter((e=>!e.dir&&e.name.includes(r)));let l=this.adventure.name.replace(/[^a-z0-9]/gi,"_");if(a){const a=`${this._importPathData.current}/${l}/${t[e].img}`;t[e].img=a}if(n){const a=`${this._importPathData.current}/${l}/${t[e].texture.src}`;t[e].texture.src=a}if(o.length>0){let e=1;await i.utils.asyncForEach(o,(async t=>{await this.importImage(t.name),e+=1,AdventureMunch._updateProgress(o.length,e,"Token Image")}))}}else a&&(t[e].img=await this.importImage(t[e].img)),n&&(t[e].texture.src=await this.importImage(t[e].texture.src));return t}async _importFile(e,{overwriteIds:t=[]}={}){let a=0,n=0;i.logger.info(`IDs to overwrite of type ${e}: ${JSON.stringify(t)}`);const s=AdventureMunchHelpers.getImportType(e),r=this.raw[e];i.logger.info(`Importing ${this.adventure.name} - ${s} (${r.length} items)`),a=r.length,await i.utils.asyncForEach(r,(async e=>{const i=await this.zip.file(e.name).async("text");let r=JSON.parse(i),o=!1;(i.match(this.pattern)||i.match(this.altpattern))&&(o=!0),r=await this._loadDocumentAssets(r,s),r.flags.ddb.needRevisit&&(o=!0),foundry.utils.setProperty(r.flags,"ddbimporter.version",CONFIG.DDBI.version),await this._importRenderedFile(s,r,o,t),n+=1,AdventureMunch._updateProgress(a,n,s)}))}replaceLookupLinks(e){const t=this.lookups.adventureConfig.lookups,a=this.adventure.required?.monsterData??[];for(const n in AdventureMunch.COMPENDIUM_MAP){const s=e.querySelectorAll(`a[href*="ddb://${n}/"]`),r=new RegExp(`ddb://${n}/([0-9]*)`);s.forEach((s=>{const o=s.outerHTML.match(r),l=t[AdventureMunch.COMPENDIUM_MAP[n]];if(l){const d=this.journalWorldActors&&["monsters"].includes(n),c=d?a.find((e=>e.ddbId===parseInt(o[1]))):l.find((e=>e.id==o[1]));if(c){const t=c.pageId?`.JournalEntryPage.${c.pageId}`:"",a=c.headerLink?`#${c.headerLink}`:"",i=d?"UUID":"Compendium",n=d?`Actor.${c.actorId}`:`${c.compendium}.${c._id}${t}${a}`;e.body.innerHTML=e.body.innerHTML.replace(s.outerHTML,`@${i}[${n}]{${s.textContent}}`)}else i.logger.warn(`NO Lookup Compendium Entry for ${s.outerHTML}, using key "${n}"`,{lookups:t,actorData:a,lookupRegExp:r,lookupKey:n})}}))}return e}foundryCompendiumReplace(e){let t=this.replaceLookupLinks(i.utils.htmlToDoc(e));const a=t.querySelectorAll('a[href*="ddb://vehicles/"]'),n=/ddb:\/\/vehicles\/([0-9]*)/g;a.forEach((e=>{const a=e.outerHTML,s=e.outerHTML.match(n),r=this.lookups.adventureConfig.lookups.vehicles;if(s){const n=r.find((e=>e.id==s[1]));n?(e.setAttribute("href",`https://www.dndbeyond.com${n.url}`),t.body.innerHTML=t.body.innerHTML.replace(a,e.outerHTML)):i.logger.warn(`NO Vehicle Lookup Entry for ${e.outerHTML}`)}else i.logger.warn(`NO Vehicle Lookup Match for ${e.outerHTML}`)}));for(const e in AdventureMunch.COMPENDIUM_MAP){t.querySelectorAll(`a[href*="ddb://${e}/"]`).forEach((a=>{const n=a.outerHTML,s=AdventureMunch.DDB_MAP[e],r=a.textContent.toLowerCase().replace(" ","-").replace(/[^0-9a-z-]/gi,"");i.logger.warn(`No Compendium Entry for ${a.outerHTML} attempting to guess a link to DDB`),a.setAttribute("href",`https://www.dndbeyond.com/${s}/${r}`),t.body.innerHTML=t.body.innerHTML.replace(n,a.outerHTML)}))}return t.body.innerHTML=o.DDBReferenceLinker.parseTags(t.body.innerHTML),t.body.innerHTML}static _updateProgress(e,t,a){const i=`ddb-importer.label.${a}`;$(".import-progress-bar").width(`${Math.trunc(t/e*100)}%`).html(`<span>${game.i18n.localize("ddb-importer.label.Working")} (${game.i18n.localize(i)})...</span>`)}static _progressNote(e){$(".import-progress-bar").html(`<span>${game.i18n.localize("ddb-importer.label.Working")} (${e})...</span>`)}}class PageFinder{generateContentLinks(){for(const e of this.journal.pages.filter((e=>"text"===e.type))){const t=i.utils.htmlToDocumentFragment(e.text.content),a=t.querySelectorAll("[data-content-chunk-id]"),n=new Set;a.forEach((e=>{n.add(e.dataset.contentChunkId)})),this.contentChunkIds[e._id]=n;const s=t.querySelectorAll("[id]"),r=new Set;s.forEach((e=>{r.add(e.id)})),this.elementIds[e._id]=r}}constructor(e){this.journal=e,this.contentChunkIds={},this.elementIds={},this.generateContentLinks()}getPageIdForContentChunkId(e){for(const[t,a]of Object.entries(this.contentChunkIds))if(a.has(e))return t}getPageIdForElementId(e){for(const[t,a]of Object.entries(this.elementIds))if(a.has(e))return t}}const f="https://raw.githubusercontent.com/MrPrimate/ddb-third-party-scenes",y=`${f}/main/modules.json`;class ThirdPartyMunch extends FormApplication{constructor(e={},t={}){super(e,t),this._itemsToRevisit=[],this._adventure={},this._scenePackage={},this._packageName="",this._description="",this._pageFinders={},this.adventureMunch=new AdventureMunch}static get defaultOptions(){return this.pattern=/(@[a-z]*)(\[)([a-z0-9]*|[a-z0-9.]*)(\])(\{)(.*?)(\})/gim,this.altpattern=/((data-entity)=\\?["']?([a-zA-Z]*)\\?["']?|(data-pack)=\\?["']?([[\S.]*)\\?["']?) data-id=\\?["']?([a-zA-Z0-9]*)\\?["']?.*?>(.*?)<\/a>/gim,foundry.utils.mergeObject(super.defaultOptions,{id:"ddb-adventure-import",classes:["ddb-adventure-import"],title:"Third Party Munch",template:"modules/ddb-importer/handlebars/adventure/import-third.hbs",width:400,height:"auto"})}async getData(){let e,t=[];try{e=await $.getJSON(y),this._defaultRepoData=e;for(const[a,n]of Object.entries(e.packages))i.logger.debug(`${a}: ${n}`),t.push(n);const a=game.settings.get(d.y.MODULE_ID,"third-party-scenes-partial");t=t.filter((e=>e.released||a)).sort(((e,t)=>e.name.localeCompare(t.last_nom))),i.logger.debug("_defaultRepoData",this._defaultRepoData)}catch(e){i.logger.error(e),i.logger.warn("Unable to generate package list.")}return{data:e,packages:t,cssClass:"ddb-importer-third-party-window"}}activateListeners(e){super.activateListeners(e),e.find(".dialog-button").on("click",this._dialogButton.bind(this)),e.find("#select-package").on("change",this._selectPackage.bind(this,null,e))}async _selectPackage(e,t){const a=t.find("#select-package"),n=a[0].selectedOptions[0]?a[0].selectedOptions[0].value:void 0,s=t.find("#ddb-message");if(n){const e=[this._defaultRepoData.packages[n].module].filter((e=>!game.modules.get(e)?.active));this._packageName=a[0].selectedOptions[0].text,this._description=this._defaultRepoData.packages[n].description;let t="";if(e.length>0){t+=`<p>You need to install the modules: ${e.join(", ")}</p>`}const r=this._defaultRepoData.packages[n].books.filter((e=>game.journal.some((t=>t.flags.ddb?.bookCode===e))?(i.logger.info(`Found journals for ${e}`),!1):(i.logger.warn(`Missing journals for ${e}`),!0)));if(r.length>0){t+=`<p>You need to use Adventure Muncher to load the following books first: ${r.map((e=>i.DDBSources.getBookName(e))).join(", ")}</p>`}this._description&&""!==this.description&&(t+=`<p><b>Details</b>: ${this._description}</p>`),""!==t&&(s[0].innerHTML=t,$(".ddb-message").removeClass("import-hidden")),0===r.length&&0===e.length&&$(".dialog-button").prop("disabled",!1)}else s[0].innerHTML="",$(".ddb-message").addClass("import-hidden");$("#ddb-adventure-import").css("height","auto")}async _createFolders(e,t){if(t){CONFIG.DDBI.ADVENTURE.TEMPORARY.folders.null=null,CONFIG.DDBI.ADVENTURE.TEMPORARY.lookups=null;const a=t.filter((e=>null===e.parent));await this.adventureMunch.importFolder(a,e,t)}}async _checkForMissingData(e,t){await this._createFolders(e,t),e.required?.spells&&e.required.spells.length>0&&(i.logger.debug(`${e.name} - spells required`,e.required.spells),ThirdPartyMunch._progressNote("Checking for missing spells from DDB"),await AdventureMunchHelpers.checkForMissingDocuments("spell",e.required.spells)),e.required?.items&&e.required.items.length>0&&(i.logger.debug(`${e.name} - items required`,e.required.items),ThirdPartyMunch._progressNote("Checking for missing items from DDB"),await AdventureMunchHelpers.checkForMissingDocuments("item",e.required.items)),e.required?.monsters&&e.required.monsters.length>0&&(i.logger.debug(`${e.name} - monsters required`,e.required.monsters),ThirdPartyMunch._progressNote("Checking for missing monsters from DDB"),await AdventureMunchHelpers.checkForMissingDocuments("monster",e.required.monsters))}static _renderCompleteDialog(e,t){new Dialog({title:e,content:{adventure:t},buttons:{two:{label:"OK"}}},{classes:["dialog","adventure-import-export"],template:"modules/ddb-importer/handlebars/adventure/import-complete.hbs"}).render(!0)}static async _fixupScenes(e){try{if(e.length>0){let t=e.length,a=0;await i.utils.asyncForEach(e,(async e=>{try{let t={};if("Scene"===e.documentName){if(!e.thumb){const a=await e.createThumbnail();t.thumb=a.thumb}await e.update(t)}}catch(t){i.logger.warn(`Error updating references for scene ${e}`,t)}a+=1,ThirdPartyMunch._updateProgress(t,a,"References")}))}}catch(e){i.logger.warn(`Error during reference update for object ${item}`,e)}}static async _createFolder(e,t){const a={name:e,type:t,parent:null,sorting:"m"},n=await Folder.create(a);return i.logger.debug(`Created new folder ${n._id} with data:`,a,n),n}static async _findFolder(e,t){const a=game.folders.find((a=>a.type===t&&void 0===a.parentFolder&&a.name===e));return a||ThirdPartyMunch._createFolder(e,t)}static _generateMockAdventure(e){const t=e.flags?.ddbimporter?.export?.actors&&e.flags?.ddb?.tokens?e.flags.ddb.tokens.filter((e=>e.flags?.ddbActorFlags?.id)).map((e=>e.flags.ddbActorFlags.id)):[];return{id:foundry.utils.randomID(),name:i.DDBSources.getBookName(e.flags.ddb.bookCode),description:"",system:"dnd5e",modules:[],version:"2.5",options:{folders:!0},folderColour:"FF0000",required:{monsters:t}}}static _generateActorId(e){foundry.utils.hasProperty(e,"flags.ddbActorFlags.id")||i.logger.warn("Token does not link to DDB Actor",e);const t=e.flags.ddbActorFlags?.id,a=e.flags.actorFolderId,n=`${t}-${a}`;if(CONFIG.DDBI.ADVENTURE.TEMPORARY.mockActors[n])return CONFIG.DDBI.ADVENTURE.TEMPORARY.mockActors[n];{const e=game.actors.find((e=>foundry.utils.hasProperty(e,"flags.ddbimporter.id")&&e.folder?.id==a&&e.flags.ddbimporter.id==t)),i=e?e.id:foundry.utils.randomID();return CONFIG.DDBI.ADVENTURE.TEMPORARY.mockActors[n]=i,i}}static async _linkSceneTokens(e){i.logger.info(`Linking ${e.name}, ${e.tokens.length} tokens`);return await Promise.all(e.tokens.map((async t=>{if(t.actorId){const a=game.actors.get(t.actorId);if(a){const i=e.flags.ddb.tokens.find((e=>e._id===t._id));delete i.scale;return await AdventureMunch._getTokenUpdateData(a,i)}}return t})))}async _linkSceneNotes(e,t){const a=game.journal.filter((t=>t?.flags?.ddb?.bookCode===e.flags.ddb.bookCode));this.adventureMunch.adventure=foundry.utils.deepClone(t);const n=game.settings.get(d.y.MODULE_ID,"third-party-scenes-notes-merged"),s=await Promise.all([e].filter((e=>e.flags?.ddb?.notes)).map((e=>e.flags.ddb.notes)).flat().map((async e=>{const t=n?a.find((t=>t.flags.ddb.cobaltId==e.flags.ddb.parentId)):a.find((t=>{const a=!!e.flags.ddb.contentChunkId&&(t.flags.ddb&&e.flags.ddb&&t.flags.ddb.contentChunkId==e.flags.ddb.contentChunkId),i=!!(!e.flags.ddb.contentChunkId&&e.flags.ddb.originalLink&&e.flags.ddb.ddbId&&e.flags.ddb.parentId&&e.flags.ddb.slug&&e.flags.ddb.linkName)&&(t.flags.ddb.slug==e.flags.ddb.slug&&t.flags.ddb.ddbId==e.flags.ddbId&&t.flags.ddb.parentId==e.flags.ddb.parentId&&t.flags.ddb.cobaltId==e.flags.ddb.cobaltId&&t.flags.ddb.originalLink==e.flags.ddb.originalLink&&t.flags.ddb.linkName==e.flags.ddb.linkName),n=!a&&!i&&t.name.trim()==e.label.trim();return a||i||n}));if(t&&(i.logger.info(`Found note "${e.label}" matched to Journal with ID "${t.id}" (${t.name})`),e.flags.ddb.journalId=t.id,e.icon=await i.Iconizer.generateIcon(this.adventureMunch,e.label),n)){e.flags.ddb.labelName=`${e.label}`,e.flags.ddb.slugLink=e.label.replace(/[^\w\d]+/g,"").replace(/^([a-zA-Z]?)0+/,"$1"),e.flags.anchor={slug:e.flags.ddb.slugLink},e.text=e.label,this._pageFinders[t._id]||(this._pageFinders[t._id]=new PageFinder(t));const a=foundry.utils.hasProperty(e,"flags.ddb.contentChunkId")?this._pageFinders[t._id].getPageIdForContentChunkId(e.flags.ddb.contentChunkId):void 0,i=foundry.utils.hasProperty(e,"flags.ddb.slugLink")?this._pageFinders[t._id].getPageIdForElementId(e.flags.ddb.slugLink):void 0,n=t.pages.find((t=>foundry.utils.hasProperty(t,"flags.ddb")&&t.flags.ddb.parentId==e.flags.ddb.parentId&&(t.flags.ddb.slug==e.flags.ddb.slug||t.flags.ddb.slug.replace(/^([a-zA-Z]?)0+/,"$1")==e.flags.ddb.slug||t.flags.ddb.slug.startsWith(e.flags.ddb.slug)||e.flags.ddb.slug.startsWith(t.flags.ddb.slug))&&(t._id===a||t._id===i)));n&&(e.pageId=n._id)}return e}))),r=[];return s.forEach((e=>{e.flags?.ddb?.journalId&&e.positions.forEach((t=>{i.logger.info(`Matching ${e.label} to position ${t.x}/${t.y}`);const a=foundry.utils.randomID(),n={_id:a,flags:{ddb:e.flags.ddb,importid:a,anchor:e.flags.anchor??{}},entryId:e.flags.ddb.journalId,x:t.x,y:t.y,icon:e.icon,iconSize:e.iconSize?e.iconSize:40,iconTint:"",text:e.text?e.text:"",fontFamily:e.fontFamily?e.fontFamily:"Signika",fontSize:e.fontSize?e.fontSize:48,textAnchor:1,textColor:e.textColor?e.textColor:"",pageId:e.pageId?e.pageId:void 0};r.push(n)}))})),r}async _getAdjustedScenes(){const e=this._scenePackage.scenes.filter((e=>e.flags?.ddbimporter?.export?.actors&&e.flags?.ddb?.tokens));return await i.utils.asyncForEach(e,(async e=>{i.logger.debug(`Adjusting scene ${e.name}`);const t=ThirdPartyMunch._generateMockAdventure(e);if(e.flags?.ddbimporter?.export?.actors&&e.flags?.ddb?.tokens){await this._checkForMissingData(t,[]);const a=i.DDBSources.getBookName(e.flags.ddb.bookCode),n=await ThirdPartyMunch._findFolder(a,"Actor");e.tokens=e.flags.ddb.tokens.map((e=>(e.flags.actorFolderId=n.id,e.actorId=ThirdPartyMunch._generateActorId(e),foundry.utils.hasProperty(e,"actorData")&&(foundry.utils.setProperty(e,"delta",foundry.utils.deepClone(e.actorData)),delete e.actorData),e)))}e.notes=await this._linkSceneNotes(e,t),i.logger.debug(`Finished scene adjustment for ${e.name}`)})),e}async _getScene(e){const t=e.flags.ddbimporter.export.compendium,a=game.packs.get(t),n=this._scenePackage.folder?this._scenePackage.folder:a.metadata.label,s=await ThirdPartyMunch._findFolder(n,"Scene"),r=a.index.find((t=>t.name===e.name)),o=game.scenes.find((t=>t.name===e.name&&(t.folder?.id===s.id||t.folder?.ancestors?.some((e=>e.id===s.id)))));if(i.logger.debug("Third Party Scene Processing",{existingScene:o,scene:e,folder:s,folderName:n,compendiumScene:r}),o)return i.logger.info(`Updating ${e.name}`),i.logger.debug(`${e.name}update data`,{scene:e,existingScene:o}),await o.update(e),o;{e.folder=s.id;const t=await game.scenes.importFromCompendium(a,r._id,e,{keepId:!0});return i.logger.info(`Scene: ${e.name} folder:`,s),i.logger.debug("worldScene:",t),t}}async _updateScenes(e){i.logger.debug("Processing scenes!",e);const t=e.filter((e=>e.flags?.ddbimporter?.export?.compendium)).filter((async e=>!!game.packs.get(e.flags.ddbimporter.export.compendium).index.find((t=>t.name===e.name))));return await i.utils.asyncForEach(t,(async e=>{i.logger.debug(`Processing scene ${e.name} with DDB Updates`);const t=foundry.utils.duplicate(e.tokens);i.logger.debug("tokenUpdates",t),e.tokens=[];const a=await this._getScene(e);i.logger.debug("World scene to add tokens to",a);const n=t.filter((e=>a.tokens.some((t=>e._id===t._id))));i.logger.debug("existingTokens",n),await a.updateEmbeddedDocuments("Token",n,{keepId:!0,keepEmbeddedIds:!0});const s=t.filter((e=>!a.tokens.some((t=>e._id===t._id))));i.logger.debug("newTokens",s),await a.createEmbeddedDocuments("Token",s,{keepId:!0,keepEmbeddedIds:!0}),i.logger.debug(`Finished scene DDB update ${e.name}`)})),[]}async _dialogButton(e){e.preventDefault(),e.stopPropagation();const t=e.currentTarget.dataset.button,a=this._packageName;if("import"===t){$(".import-progress").toggleClass("import-hidden"),$(".ddb-overlay").toggleClass("import-invalid");const e=$("#select-package").val(),t=`${f}/main/${e}/module.json`;this._scenePackage=await fetch(t).then((e=>200===e.status||0===e.status?Promise.resolve(e.json()):Promise.reject(new Error(e.statusText)))),i.logger.debug("_scenePackage",this._scenePackage),CONFIG.DDBI.ADVENTURE.TEMPORARY={folders:{},import:{},actors:{},sceneTokens:{},mockActors:{}},this.folderNames=this._scenePackage.folder?[this._scenePackage.folder]:[...new Set(this._scenePackage.scenes.filter((e=>e.flags?.ddbimporter?.export?.compendium)).map((e=>{const t=e.flags.ddbimporter.export.compendium;return game.packs.get(t).metadata.label})))];const n=this.folderNames.map((e=>ThirdPartyMunch._findFolder(e,"Scene")));await Promise.all(n);const s=[...new Set(this._scenePackage.scenes.filter((e=>e.flags?.ddb?.bookCode)).map((e=>i.DDBSources.getBookName(e.flags.ddb.bookCode))))].map((e=>ThirdPartyMunch._findFolder(e,"Actor")));await Promise.all(s),i.logger.debug("Competed folder creation");const r=await this._getAdjustedScenes(this._scenePackage.scenes);i.logger.debug("adjustedScenes",foundry.utils.duplicate(r)),i.logger.debug("About to generate Token Actors"),await i.utils.asyncForEach(r,(async e=>{i.logger.debug(`Generating scene actors for ${e.name}`),await this.adventureMunch.generateTokenActors(e),i.logger.debug(`Finished scene actors for ${e.name}`)}));const o=await Promise.all(r.map((async e=>{i.logger.debug(`Generating scene tokens for ${e.name}`);const t=foundry.utils.duplicate(e);return t.tokens=await ThirdPartyMunch._linkSceneTokens(e),t})));i.logger.debug("tokenAdjustedScenes",o),CONFIG.DDBI.ADVENTURE.TEMPORARY.lookups=await(0,g.g)(!0),i.logger.debug("Lookups loaded",CONFIG.DDBI.ADVENTURE.TEMPORARY.lookups.lookups);const l=await this._updateScenes(o),d=setTimeout((()=>{i.logger.warn("Reference update timed out."),ThirdPartyMunch._renderCompleteDialog(`Un-Successful Import of ${a}`,{name:a}),this.close()}),12e4);await ThirdPartyMunch._fixupScenes(l),clearTimeout(d),$(".ddb-overlay").toggleClass("import-invalid"),ThirdPartyMunch._renderCompleteDialog(`Successful Import of ${a}`,{name:a}),CONFIG.DDBI.ADVENTURE.TEMPORARY={},this.close()}}static _updateProgress(e,t,a){const i=`ddb-importer.label.${a}`;$(".import-progress-bar").width(`${Math.trunc(t/e*100)}%`).html(`<span>${game.i18n.localize("ddb-importer.label.Working")} (${game.i18n.localize(i)})...</span>`)}static _progressNote(e){$(".import-progress-bar").html(`<span>${game.i18n.localize("ddb-importer.label.Working")} (${e})...</span>`)}}var b=a(36);class DDBFeature{}async function buildBackground(e){let t=e;const a=i.DDBSources.parseSource(t),n=new DDBFeature({ddbData:null,ddbDefinition:t,rawCharacter:null,type:"background",source:a,noMods:!0});n.build(),i.logger.debug(`DDBFeatures.buildBackground: ${n.ddbDefinition.name}`,{ddbFeature:n,featDefinition:t}),await n.generateAdvancements();const s=foundry.utils.getProperty(e,"featList.featIds")??[];return await n.buildBackgroundFeatAdvancements(s),n.data}function getBackgroundData(){const e=i.Secrets.getCobalt(),t=i.DDBCampaigns.getCampaignId(i.utils.munchNote),a=i.DDBProxy.getProxy(),n={cobalt:e,campaignId:t,betaKey:i.PatreonHelper.getPatreonKey()},s=game.settings.get(d.y.MODULE_ID,"debug-json");return new Promise(((e,t)=>{fetch(`${a}/proxy/backgrounds`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)}).then((e=>e.json())).then((e=>(s&&i.FileHelper.download(JSON.stringify(e),"backgrounds-raw.json","application/json"),e.success||(i.utils.munchNote(`Failure: ${e.message}`),t(e.message)),e))).then((e=>async function getBackgrounds(e){i.logger.debug("get backgrounds started");const t=game.settings.get("ddb-importer","munching-policy-update-existing");let a=[];for(const t of e){i.logger.debug(`${t.name} background parsing started...`);const e=await buildBackground(t);a.push(e)}return(await i.DDBItemImporter.buildHandler("backgrounds",a,t,{chrisPremades:!0,notifier:i.utils.munchNote})).documents}(e.data))).then((t=>e(t))).catch((e=>t(e)))}))}var D=a(535),v=a(293),C=a(489);class DDBMuncher extends Application{static get defaultOptions(){const e=super.defaultOptions;return e.id="ddb-importer-monsters",e.template="modules/ddb-importer/handlebars/munch.hbs",e.resizable=!1,e.height="auto",e.width=800,e.title="MrPrimate's Muncher",e.classes=["ddb-muncher","sheet"],e.tabs=[{navSelector:".tabs",contentSelector:"div",initial:"settings"}],e}static munchNote(e,t=!1,a=!1){i.utils.munchNote(e,t,a)}static munchMonsters(){DDBMuncher.munchNote("Downloading monsters...",!0),$('button[id^="munch-"]').prop("disabled",!0),$('button[id^="adventure-config-start"]').prop("disabled",!0),DDBMuncher.parseCritters()}static munchVehicles(){DDBMuncher.munchNote("Downloading vehicles...",!0),$('button[id^="munch-"]').prop("disabled",!0),$('button[id^="adventure-config-start"]').prop("disabled",!0),DDBMuncher.parseTransports()}activateListeners(e){super.activateListeners(e),e.find("#munch-monsters-start").click((async()=>{DDBMuncher.munchMonsters()})),e.find("#munch-vehicles-start").click((async()=>{DDBMuncher.munchVehicles()})),e.find("#munch-source-select").click((async()=>{(new v.A).render(!0)})),e.find("#munch-spells-start").click((async()=>{DDBMuncher.munchNote("Downloading spells...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseSpells()})),e.find("#munch-items-start").click((async()=>{DDBMuncher.munchNote("Downloading items...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseItems()})),e.find("#munch-races-start").click((async()=>{DDBMuncher.munchNote("Downloading races...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseRaces()})),e.find("#munch-feats-start").click((async()=>{DDBMuncher.munchNote("Downloading feats...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseFeats()})),e.find("#munch-backgrounds-start").click((async()=>{DDBMuncher.munchNote("Downloading backgrounds...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseBackgrounds()})),e.find("#munch-classes-start").click((async()=>{DDBMuncher.munchNote("Downloading classes...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseClasses()})),e.find("#munch-frames-start").click((async()=>{DDBMuncher.munchNote("Downloading frames...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.parseFrames()})),e.find("#munch-adventure-config-start").click((async()=>{DDBMuncher.munchNote("Generating config file...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.generateAdventureConfig()})),e.find("#munch-adventure-import-start").click((async()=>{(new AdventureMunch).render(!0)})),e.find("#munch-adventure-third-party-start").click((async()=>{(new ThirdPartyMunch).render(!0)})),e.find("#munch-migrate-compendium-monster").click((async()=>{DDBMuncher.munchNote("Migrating monster compendium...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.migrateCompendiumFolders("monsters")})),e.find("#munch-migrate-compendium-spell").click((async()=>{DDBMuncher.munchNote("Migrating spell compendium...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.migrateCompendiumFolders("spells")})),e.find("#munch-migrate-compendium-item").click((async()=>{DDBMuncher.munchNote("Migrating item compendium...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.migrateCompendiumFolders("items")})),e.find("#munch-fix-base64").click((async()=>{DDBMuncher.munchNote("Checking Scenes for base64 data...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.base64Check()})),e.find("#munch-world-monster-update").click((async()=>{DDBMuncher.munchNote("Updating world actors...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.updateWorldMonsters()})),e.find("#munch-reset-images").click((async()=>{DDBMuncher.munchNote("Resetting images...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.resetCompendiumActorImages()})),e.find("#munch-xanthar-price").click((async()=>{DDBMuncher.munchNote("Updating item prices...",!0),$('button[id^="munch-"]').prop("disabled",!0),DDBMuncher.addItemPrices()})),$(e).find(['.munching-generic-config input[type="checkbox"]','.munching-spell-config input[type="checkbox"]','.munching-item-config input[type="checkbox"]','.munching-monster-config input[type="checkbox"]','.munching-monster-world-update-config input[type="checkbox"]'].join(",")).on("change",(t=>{i.MuncherSettings.updateMuncherSettings(e,t,this)})),e.find("#monster-munch-filter").on("keyup",(e=>{e.preventDefault(),"Enter"===e.key&&DDBMuncher.munchMonsters()})),e.find("#compendium-folder-style-monster").on("change",(async()=>{const t=e.find("#compendium-folder-style-monster"),a=t[0].selectedOptions[0]?t[0].selectedOptions[0].value:"TYPE";game.settings.set("ddb-importer","munching-selection-compendium-folders-monster",a)})),e.find("#compendium-folder-style-spell").on("change",(async()=>{const t=e.find("#compendium-folder-style-spell"),a=t[0].selectedOptions[0]?t[0].selectedOptions[0].value:"SCHOOL";game.settings.set("ddb-importer","munching-selection-compendium-folders-spell",a)})),e.find("#compendium-folder-style-item").on("change",(async()=>{const t=e.find("#compendium-folder-style-item"),a=t[0].selectedOptions[0]?t[0].selectedOptions[0].value:"TYPE";game.settings.set("ddb-importer","munching-selection-compendium-folders-item",a)})),this.close()}static enableButtons(){const e=""!=i.Secrets.getCobalt(),t=i.PatreonHelper.getPatreonTier(),a=i.PatreonHelper.calculateAccessMatrix(t);e&&($('button[id^="munch-spells-start"]').prop("disabled",!1),$('button[id^="munch-items-start"]').prop("disabled",!1),$('button[id^="munch-adventure-config-start"]').prop("disabled",!1),$('button[id^="munch-adventure-import-start"]').prop("disabled",!1),$('button[id^="munch-adventure-third-party-start"]').prop("disabled",!1),$('button[id^="munch-migrate-compendium-monster"]').prop("disabled",!1),$('button[id^="munch-migrate-compendium-spell"]').prop("disabled",!1),$('button[id^="munch-migrate-compendium-item"]').prop("disabled",!1),$('button[id^="munch-reset-images"]').prop("disabled",!1),$('button[id^="munch-xanthar-price"]').prop("disabled",!1),a.all&&($('button[id^="munch-monsters-start"]').prop("disabled",!1),$('button[id^="munch-source-select"]').prop("disabled",!1)),a.supporter&&$('button[id^="munch-frames-start"]').prop("disabled",!1),a.experimentalMid)}static async parseCritters(){try{i.logger.info("Munching monsters!"),await o.DDBReferenceLinker.importCacheLoad();const e=new h.A({munchNote:DDBMuncher.munchNote}),t=await e.processIntoCompendium();await DDBMuncher.cleanupCompendiumFolders("monsters"),DDBMuncher.munchNote(`Finished importing ${t} monsters!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseTransports(){try{i.logger.info("Munching vehicles!");const e=await(0,D.y)();DDBMuncher.munchNote(`Finished importing ${e} vehicles!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseSpells(){try{i.logger.info("Munching spells!"),game.settings.get(d.y.MODULE_ID,"munching-policy-add-spell-effects")&&await i.DDBMacros.createWorldMacros("spells"),await o.DDBReferenceLinker.importCacheLoad(),await(0,s.p)(),await DDBMuncher.cleanupCompendiumFolders("spells"),DDBMuncher.munchNote("Finished importing spells!",!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async cleanupCompendiumFolders(e){const t=new i.DDBCompendiumFolders(e);DDBMuncher.munchNote("Cleaning compendium folders...",!0),await t.loadCompendium(e),await t.removeUnusedFolders(),DDBMuncher.munchNote("Cleaning compendium folders complete",!0)}static async generateCompendiumFolders(e){const t=new i.DDBCompendiumFolders(e);DDBMuncher.munchNote("Checking compendium folders..",!0),await t.loadCompendium(e),DDBMuncher.munchNote("",!0)}static async parseItems(){try{i.logger.info("Munching items!"),await o.DDBReferenceLinker.importCacheLoad(),await(0,n.m)(),await DDBMuncher.cleanupCompendiumFolders("items"),DDBMuncher.munchNote("Finished importing items!",!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseRaces(){try{i.logger.info("Munching races!"),await o.DDBReferenceLinker.importCacheLoad();const e=await async function parseRaces(){const e=d.y.COMPENDIUMS.find((e=>"Races"===e.title));await(0,c.k)(e);const t=d.y.COMPENDIUMS.find((e=>"Racial Traits"===e.title));return await(0,c.k)(t),await getRaceData()}();DDBMuncher.munchNote(`Finished importing ${e.length} races and features!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseFeats(){try{i.logger.info("Munching feats!"),await o.DDBReferenceLinker.importCacheLoad();const e=await parseFeats();DDBMuncher.munchNote(`Finished importing ${e.length} feats!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseBackgrounds(){try{i.logger.info("Munching backgrounds!"),await o.DDBReferenceLinker.importCacheLoad();const e=await async function parseBackgrounds(){const e=d.y.COMPENDIUMS.find((e=>"Backgrounds"===e.title));return await(0,c.k)(e),await getBackgroundData()}();DDBMuncher.munchNote(`Finished importing ${e.length} backgrounds!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseClasses(){try{i.logger.info("Munching classes!"),await o.DDBReferenceLinker.importCacheLoad();const e=await parseClasses();DDBMuncher.munchNote(`Finished importing ${e.length} classes and features!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async parseFrames(){try{i.logger.info("Munching frames!");const e=await parseFrames();DDBMuncher.munchNote(`Finished importing ${e.length} frames!`,!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async generateAdventureConfig(){try{i.logger.info("Generating adventure config!"),await(0,g.b)(),DDBMuncher.munchNote("Downloading config file",!0),DDBMuncher.munchNote(""),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async updateWorldMonsters(){try{i.logger.info("Updating world monsters!"),await(0,b.zU)(),DDBMuncher.enableButtons()}catch(e){i.logger.error(e),i.logger.error(e.stack)}}static async migrateCompendiumFolders(e){i.logger.info(`Migrating ${e} compendium`);const t=new i.DDBCompendiumFolders(e);await t.loadCompendium(e),await t.migrateExistingCompendium(),DDBMuncher.munchNote("Migrating complete.",!0),DDBMuncher.enableButtons()}static async base64Check(){i.logger.info("Checking base64 in scenes");const e=(0,i.base64Check)();let t="Check complete.";0===e.fixedScenes.length&&0===e.badScenes.length?t+=" No problems found.":(e.fixedScenes.length>0&&(t+=` Fixing ${e.fixedScenes.length} scenes (wait untill uploads complete).`),e.badScenes.length>0&&(t+=` Found ${e.badScenes.length} scenes that I couldn't fix.`)),DDBMuncher.munchNote(t,!0),DDBMuncher.enableButtons()}static async resetCompendiumActorImages(){i.logger.info("Resetting compendium actor images");const e=`Reset ${(await(0,b.i8)()).length} compendium actors.`;DDBMuncher.munchNote(e,!0),DDBMuncher.enableButtons()}static async addItemPrices(){i.logger.info("Checking to see if items need prices...");const e=`Added ${(await(0,C.f)()).length} prices to items.`;DDBMuncher.munchNote(e,!0),DDBMuncher.enableButtons()}async getData(){const e=i.MuncherSettings.getMuncherSettings();return await o.DDBReferenceLinker.importCacheLoad(),e}}},293:(e,t,a)=>{a.d(t,{A:()=>DDBSources});var i=a(657);class DDBSources extends FormApplication{static get defaultOptions(){const e=super.defaultOptions;return e.id="ddb-importer-sources",e.template="modules/ddb-importer/handlebars/sources.hbs",e.width=500,e}static getSourcesLookups(e){return CONFIG.DDB.sources.filter((e=>e.isReleased&&9!==e.sourceCategoryId&&3!==e.sourceCategoryId)).map((t=>({id:t.id,acronym:t.name,label:t.description,selected:e.includes(t.id)})))}get title(){return"Monster Muncher Sauce Selection"}activateListeners(e){super.activateListeners(e),e.find("#toggle-sources").click((async e=>{e.preventDefault(),$(".munching-sources input:checked").length&&$(".munching-sources input").not(":checked").length?$(".munching-sources input").prop("checked",!1):$(".munching-sources input").each((function(){$(this).prop("checked",!$(this).prop("checked"))}))}))}async getData(){const e=game.settings.get("ddb-importer","munching-policy-muncher-sources").flat();return{sources:DDBSources.getSourcesLookups(e).sort(((e,t)=>e.label>t.label?1:t.label>e.label?-1:0))}}async _updateObject(e,t){e.preventDefault();let a=[];for(const[e,i]of Object.entries(t))i&&a.push(parseInt(e));await game.settings.set("ddb-importer","munching-policy-muncher-sources",a),(new i.A).render(!0)}}},51:(e,t,a)=>{a.d(t,{JZ:()=>addStatusEffectChange,Kz:()=>forceItemEffect,Yg:()=>baseItemEffect,d:()=>baseFeatEffect,ff:()=>generateATLChange,o6:()=>generateOverrideChange,oH:()=>applyDefaultMidiFlags,tw:()=>effectModules});var i=a(111);function effectModules(){return i.AutoEffects.effectModules()}function baseItemEffect(e,t,{transfer:a=!0,disabled:n=!1,description:s=null,durationSeconds:r=null,durationRounds:o=null,durationTurns:l=null}={}){return i.AutoEffects.BaseEffect(e,t,{transfer:a,disabled:n,description:s,durationSeconds:r,durationRounds:o,durationTurns:l})}function baseFeatEffect(e,t,{transfer:a=!1,disabled:n=!1,description:s=null,durationSeconds:r=null,durationRounds:o=null,durationTurns:l=null}={}){return i.AutoEffects.BaseEffect(e,t,{transfer:a,disabled:n,description:s,durationSeconds:r,durationRounds:o,durationTurns:l})}function applyDefaultMidiFlags(e){return i.MidiEffects.applyDefaultMidiFlags(e)}function forceItemEffect(e){return i.AutoEffects.forceDocumentEffect(e)}function addStatusEffectChange({effect:e,statusName:t,priority:a=20,level:n=null}={}){return i.ChangeHelper.addStatusEffectChange({effect:e,statusName:t,priority:a,level:n})}function generateOverrideChange(e,t,a){return i.ChangeHelper.overrideChange(e,t,a)}function generateATLChange(e,t,a,n=20){return i.ChangeHelper.atlChange(e,t,a,n)}},791:(e,t,a)=>{a.d(t,{D:()=>baseSpellEffect,d:()=>spellEffectAdjustment});a(421);var i=a(222);a(51);function baseSpellEffect(e,t,{transfer:a=!1,disabled:n=!1,description:s=null,durationSeconds:r=null,durationRounds:o=null,durationTurns:l=null}={}){return i.A.BaseEffect(e,t,{transfer:a,disabled:n,description:s,durationSeconds:r,durationRounds:o,durationTurns:l})}async function spellEffectAdjustment(e,t=!1){return foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.homebrew"),e}},617:(e,t,a)=>{a.d(t,{A:()=>__WEBPACK_DEFAULT_EXPORT__,k:()=>createDDBCompendium});var i=a(115),n=a(421);async function createDDBCompendium(e){const t={id:game.settings.get(i.y.MODULE_ID,e.setting),type:e.type,label:`DDB ${e.title}`,image:e.image,dnd5eTypeTags:e.types,version:e.version},a=game.settings.get(i.y.MODULE_ID,"top-level-compendium-folder"),s=a?await n.FolderHelper.getFolder("compendium","","D&D Beyond","#6f0006","#98020a",!1):null;a&&(t.folder=s._id);const r=await n.CompendiumHelper.createIfNotExists(t);r.created?await game.settings.set(i.y.MODULE_ID,e.setting,r.compendium.metadata.id):null===r.compendium?.folder&&a&&r.compendium.configure({folder:s._id})}async function __WEBPACK_DEFAULT_EXPORT__(){if(game.settings.get(i.y.MODULE_ID,"auto-create-compendium"))for(const e of i.y.COMPENDIUMS.filter((e=>e.auto)))await createDDBCompendium(e)}},383:(e,t,a)=>{a.d(t,{b:()=>downloadAdventureConfig,g:()=>generateAdventureConfig});var i=a(421),n=a(535);const s={"Opportunity Attack":{hint:"Opportunity Attacks",page:"Making an Attack"},Grapple:{hint:"Grappling",page:"Making an Attack"},Shove:{hint:"Shoving a Creature",page:"Making an Attack"},"Two-Weapon Fighting":{hint:"Two-Weapon Fighting",page:"Making an Attack"},"Interact with an Object":{hint:"Use an Object",page:"Actions in Combat"}};async function generateAdventureConfig(e=!1,t=!0,a=!1,r=!1){const o={schemaVersion:CONFIG.DDBI.schemaVersion,debug:!1,observeAll:!1,version:game.modules.get("ddb-importer").version,lookups:{monsters:[],items:[],spells:[],skills:[],senses:[],conditions:[],actions:[],weaponproperties:[],vehicles:[],rule:[]},fullPageMap:[]};if(t&&(o.cobalt=i.Secrets.getCobalt(),o.campaignId=i.DDBCampaigns.getCampaignId()),e&&(o.lookups.monsters=await async function getMonsterMap(){const e=i.CompendiumHelper.getCompendiumLabel("monster"),t=i.CompendiumHelper.getCompendium(e),a=(await t.getIndex({fields:["name","flags.ddbimporter.id"]})).filter((e=>e.flags?.ddbimporter?.id)).map((t=>({id:t.flags.ddbimporter.id,_id:t._id,compendium:e,name:t.name,documentName:t.name})));return Promise.all(a)}(),o.lookups.spells=await async function getSpellMap(){const e=await game.settings.get("ddb-importer","entity-spell-compendium"),t=await game.packs.find((t=>t.collection===e)),a=(await t.getIndex({fields:["name","flags.ddbimporter.definitionId"]})).filter((e=>e.flags?.ddbimporter?.definitionId)).map((t=>({id:t.flags.ddbimporter.definitionId,_id:t._id,compendium:e,name:t.name,documentName:t.name})));return Promise.all(a)}(),o.lookups.items=await async function getItemMap(){const e=await game.settings.get("ddb-importer","entity-item-compendium"),t=await game.packs.find((t=>t.collection===e)),a=(await t.getIndex({fields:["name","flags.ddbimporter.definitionId"]})).filter((e=>e.flags?.ddbimporter?.definitionId)).map((t=>({id:t.flags.ddbimporter.definitionId,_id:t._id,compendium:e,name:t.name,documentName:t.name})));return Promise.all(a)}()),!i.DDBProxy.isCustom()&&t){const e=await(0,n.x)();o.lookups.vehicles=e.map((e=>({id:e.id,url:e.url,name:e.name})))}if(r){const e="dnd5e.rules",t=i.CompendiumHelper.getCompendium(e);if(!t)return o;const n=await t.getIndex(),r=await t.getDocuments();o.index=n;const l=r.find((e=>"Chapter 7: Using Ability Scores"===e.name));l&&(o.lookups.skills=CONFIG.DDB.abilitySkills.map((t=>{const a=l.pages.find((e=>"Using Each Ability"===e.name)),i=`${CONFIG.DDB.stats.find((e=>e.id===t.stat)).name} Checks`;return{id:t.id,_id:l._id,name:t.name,compendium:e,documentName:l.name,pageId:a._id,headerLink:i}})));const d=r.find((e=>"Appendix D: Senses and Speeds"===e.name));d&&(o.lookups.senses=CONFIG.DDB.senses.filter((e=>d.pages.some((t=>t.name===e.name)))).map((t=>{const a=d.pages.find((e=>e.name===t.name));return{id:t.id,_id:d._id,name:t.name,compendium:e,documentName:d.name,pageId:a._id,headerLink:null}})));const c=r.find((e=>"Appendix A: Conditions"===e.name));c&&(o.lookups.conditions=CONFIG.DDB.conditions.filter((e=>c.pages.some((t=>t.name.trim()===e.definition.name.trim())))).map((t=>{const a=c.pages.find((e=>e.name.trim()===t.definition.name.trim()));return{id:t.definition.id,_id:c.id,name:t.definition.name,compendium:e,slug:t.definition.slug,documentName:c.name,pageId:a._id,headerLink:null}})));const u=r.find((e=>"Chapter 9: Combat"===e.name));if(u){const t=u.pages.find((e=>"Actions in Combat"===e.name));CONFIG.DDB.basicActions.forEach((a=>{if(s[a.name]){const t=u.pages.find((e=>e.name===s[a.name].page));o.lookups.actions.push({id:a.id,_id:u._id,name:a.name,compendium:e,documentName:u.name,pageId:t._id,headerLink:s[a.name].hint})}else a.id<100&&o.lookups.actions.push({id:a.id,_id:u.id,name:a.name,compendium:e,documentName:u.name,pageId:t._id,headerLink:a.name})}))}const m=r.find((e=>"Chapter 5: Equipment"===e.name));if(m){const t=m.pages.find((e=>"Weapons"===e.name));o.lookups.weaponproperties=CONFIG.DDB.weaponProperties.map((a=>({id:a.id,_id:m._id,name:a.name,compendium:e,documentName:m.name,pageId:t._id,headerLink:"Weapon Properties"})))}a&&r.forEach((t=>{t.pages.forEach((a=>{o.fullPageMap.push({id:null,_id:t.id,name:a.name,compendium:e,documentName:t.name,pageId:a._id,headerLink:null})}))}))}return o}async function downloadAdventureConfig(){const e=game.settings.get("ddb-importer","adventure-muncher-full-config"),t=await generateAdventureConfig(e);return i.FileHelper.download(JSON.stringify(t,null,4),"adventure-config.json","application/json"),t}},512:(e,t,a)=>{a.d(t,{M:()=>getFeats});var i=a(421),n=a(382);const s={name:"",type:"feat",system:{description:{value:"",chat:""},type:{value:"feat"},source:""},sort:26e5,flags:{ddbimporter:{type:"feat"},obsidian:{source:{type:"feat"}}},img:null};async function buildFeat(e){return function buildBase(e){let t=foundry.utils.duplicate(s);if(t.name=e.name,t.system.description.value+=`${e.description}\n\n`,t.system.description.chat+=`${e.snippet}\n\n`,t.flags.ddbimporter={featId:e.id,version:CONFIG.DDBI.version},t.flags.ddbimporter.prerequisites=e.prerequisites,e.prerequisites.length>0){const a=e.prerequisites.map((e=>e.description));t.system.requirements=a.join(", "),t.system.description.value+=`<h3>Requirements</h3>\n\n${a.join("\n\n")}\n\n`}return t.system.source=i.DDBSources.parseSource(e),t.system.description.value=n.DDBReferenceLinker.parseTags(t.system.description.value),t}(e)}async function getFeats(e){i.logger.debug("get feats started");const t=game.settings.get("ddb-importer","munching-policy-update-existing");let a=[];e.forEach((e=>{i.logger.debug(`${e.name} feat parsing started...`);const t=buildFeat(e);a.push(t)}));return(await i.DDBItemImporter.buildHandler("feats",a,t,{chrisPremades:!0,notifier:i.utils.munchNote})).documents}},750:(e,t,a)=>{a.d(t,{$Q:()=>getNPCImage,D9:()=>useSRDMonsterImages,VJ:()=>addNPC,VL:()=>generateIconMap,dD:()=>copyExistingMonsterImages,oe:()=>buildNPC});var i=a(421),n=a(115);async function addNPCToCompendium(e,t="monster"){const a=new i.DDBItemImporter(t,[],{notifier:i.utils.munchNote});if(a.compendium){const t=(await a.addCompendiumFolderIds([foundry.utils.duplicate(e)]))[0];let s;if(foundry.utils.hasProperty(e,"_id")&&a.compendium.index.has(e._id)){if(game.settings.get(n.y.MODULE_ID,"munching-policy-update-existing")){const n=await a.compendium.getDocument(e._id);if(foundry.utils.hasProperty(t,"prototypeToken.flags.tagger.tags")&&foundry.utils.hasProperty(n,"prototypeToken.flags.tagger.tags")){const e=[...new Set(t.prototypeToken.flags.tagger.tags,n.prototypeToken.flags.tagger.tags)];foundry.utils.setProperty(n,"prototypeToken.flags.tagger.tags",e)}const r=foundry.utils.getProperty(n.prototypeToken,"flags.levels-3d-preview.model3d");r&&""!==r.trim()&&foundry.utils.setProperty(t.prototypeToken,"flags.levels-3d-preview.model3d",r);const o=t.items.map((t=>(foundry.utils.setProperty(t,"flags.ddbimporter.parentId",e._id),t))),l=n.getEmbeddedCollection("Item");t.items=await async function existingItemRetentionCheck(e,t,a=!0){const n=[];return await t.forEach((t=>{const i=e.find((e=>t.name===e.name&&t.type===e.type&&t.system.activation?.type===e.system.activation?.type&&(a&&t.flags?.ddbimporter?.id===e.flags?.ddbimporter?.id||!a)));i?i.flags.ddbimporter?.ignoreItemImport?n.push(foundry.utils.duplicate(i)):(t._id=i.id,!0===foundry.utils.getProperty(i,"flags.ddbimporter.ignoreIcon")&&(t.img=i.img,foundry.utils.setProperty(t,"flags.ddbimporter.ignoreIcon",!0)),foundry.utils.getProperty(i,"flags.ddbimporter.retainResourceConsumption")&&(t.system.consume=i.system.consume,t.system.uses.recovery=i.system.uses.recovery,foundry.utils.setProperty(t,"flags.ddbimporter.retainResourceConsumption",!0),foundry.utils.hasProperty(i,"flags.link-item-resource-5e")&&foundry.utils.setProperty(t,"flags.link-item-resource-5e",i.flags["link-item-resource-5e"])),(!t.effects||t.effects&&0==t.effects.length&&i.effects&&i.effects.length>0)&&(t.effects=foundry.utils.duplicate(i.getEmbeddedCollection("ActiveEffect"))),n.push(t)):n.push(t)})),i.logger.debug("Finished retaining items"),n}(l,o,!1),i.logger.debug("NPC Update Data",foundry.utils.duplicate(t)),await n.deleteEmbeddedDocuments("Item",[],{deleteAll:!0}),await n.deleteEmbeddedDocuments("ActiveEffect",[],{deleteAll:!0}),s=await n.update(t,{pack:a.compendium.collection,render:!1,keepId:!0}),s||(i.logger.debug("No changes made to base character",t),s=n)}}else{i.logger.debug(`Creating NPC actor ${t.name}`);const e={displaySheet:!1,pack:a.compendium.collection,keepId:!0};i.logger.debug("NPC New Data",foundry.utils.duplicate(t)),s=await Actor.create(t,e)}}else i.logger.error("Error opening compendium, check your settings");return e}async function getNPCImage(e,{type:t="monster",forceUpdate:a=!1,forceUseFullToken:s=!1,forceUseTokenAvatar:r=!1,disableAutoTokenizeOverride:o=!1}={}){if(!foundry.utils.hasProperty(e,"flags.monsterMunch.img"))return e;const l=game.settings.get(n.y.MODULE_ID,"munching-policy-update-images");if(!a&&!l&&e.img!==CONST.DEFAULT_TOKEN)return e;const d=e.flags.monsterMunch.isStockImg,c=game.settings.get(n.y.MODULE_ID,"munching-policy-use-full-token-image")||s;let u=game.settings.get(n.y.MODULE_ID,"munching-policy-use-token-avatar-image")||r?foundry.utils.getProperty(e,"flags.monsterMunch.tokenImg"):foundry.utils.getProperty(e,"flags.monsterMunch.img"),m=c?foundry.utils.getProperty(e,"flags.monsterMunch.img"):foundry.utils.getProperty(e,"flags.monsterMunch.tokenImg");!u&&m&&(u=m),!m&&u&&(m=u);const p=CONFIG.DDBI.KNOWN.AVATAR_LOOKUPS.get(u),g=CONFIG.DDBI.KNOWN.TOKEN_LOOKUPS.get(m),h=t.startsWith("vehicle")?"vehicle":e.system.details.type.value??(e.system.details.type.custom&&""!==e.system.details.type.custom?e.system.details.type.custom:"unknown"),f=i.utils.referenceNameString(h),y=i.utils.referenceNameString(e.name),b=game.settings.get(n.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),D=foundry.utils.getProperty(e,"system.details.type.value")??"other",v=game.settings.get(n.y.MODULE_ID,"use-deep-file-paths");if(u&&!0!==foundry.utils.getProperty(e,"flags.monsterMunch.imgSet"))if(p)e.img=CONFIG.DDBI.KNOWN.AVATAR_LOOKUPS.get(u);else{const t=u.split(".").pop().split(/#|\?|&/)[0],n=u.endsWith(h+"."+t)||d,s=n?"npc-generic":"npc",r={type:s,name:n?f:y,targetDirectory:b,pathPostfix:v?`/monster/avatar/${D}`:"",imageNamePrefix:v?"":s,force:a||l};e.img=await i.FileHelper.getImagePath(u,r)}if(m&&!0!==foundry.utils.getProperty(e,"flags.monsterMunch.tokenImgSet"))if(g)e.prototypeToken.texture.src=CONFIG.DDBI.KNOWN.TOKEN_LOOKUPS.get(m);else{const t=m.split(".").pop().split(/#|\?|&/)[0],n=m.endsWith(h+"."+t)||d,s=n?"npc-generic-token":"npc-token",r={type:s,name:n?f:y,download:!0,remoteImages:!1,force:a||l,imageNamePrefix:v?"":s,pathPostfix:v?`/monster/token/${D}`:"",targetDirectory:b};e.prototypeToken.texture.src=await i.FileHelper.getImagePath(m,r)}!e.img&&e.prototypeToken.texture.src&&(e.img=e.prototypeToken.texture.src),null===e.img&&(e.img=CONST.DEFAULT_TOKEN),null===e.prototypeToken.texture.src&&(e.prototypeToken.texture.src=CONST.DEFAULT_TOKEN);if(game.settings.get(n.y.MODULE_ID,"munching-policy-monster-tokenize")&&!o&&game.modules.get("vtta-tokenizer")?.active&&!g){const a=i.CompendiumHelper.getCompendiumLabel(t),n={name:d?h:e.name,nameSuffix:`-${a}`,updateActor:!1};e.prototypeToken.texture.src=await window.Tokenizer.autoToken(e,n),i.logger.debug(`Generated tokenizer image at ${e.prototypeToken.texture.src}`)}return p||CONFIG.DDBI.KNOWN.AVATAR_LOOKUPS.set(u,e.img),g||CONFIG.DDBI.KNOWN.TOKEN_LOOKUPS.set(m,e.prototypeToken.texture.src),e}async function buildNPC(e,t="monster",a=!0,s=!1,r=!1){if(i.logger.debug("Importing Images"),await getNPCImage(e,{type:t}),i.logger.debug("Checking Items"),await async function swapItems(e){if(game.settings.get(n.y.MODULE_ID,"munching-policy-monster-items")){i.logger.debug("Replacing items...");const t={monsterMatch:!0},a=await i.DDBItemImporter.getCompendiumItems(e.items,"inventory",t),n=a.map((e=>(i.logger.debug(`${e.name} to ${e.flags.ddbimporter.originalItemName}`),{name:e.flags.ddbimporter.originalItemName,type:e.type})));i.logger.debug("Swapping items",n);const s=e.items.filter((e=>!n.some((t=>e.name===t.name&&e.type===t.type)))).concat(a);e.items=s}}(e),i.logger.debug("Importing Icons"),e.items=await i.Iconizer.updateIcons(e.items,!1,!0,e.name),e=i.Iconizer.addActorEffectIcons(e),r){if(i.logger.debug("Creating NPC actor"),s){const t=game.actors.get(e._id);return await t.deleteEmbeddedDocuments("Item",[],{deleteAll:!0}),await Actor.updateDocuments([e]),t}{const t={temporary:a,displaySheet:!1};return a?new Actor.implementation(e,t):await Actor.create(e,t)}}return e}function addNPC(e,t){return new Promise(((a,n)=>{(async function parseNPC(e,t){const a=await buildNPC(e,t);return i.logger.info(`Processing ${t} ${a.name} for the compendium`),await addNPCToCompendium(a,t)})(e,t).then((e=>{a(e)})).catch((a=>{i.logger.error(`error parsing NPC type ${t}: ${a} ${e.name}`),i.logger.error(a.stack),n(a)}))}))}async function useSRDMonsterImages(e){if(game.settings.get(n.y.MODULE_ID,"munching-policy-use-srd-monster-images")){const t=await i.Iconizer.getSRDImageLibrary();i.utils.munchNote("Updating SRD Monster Images",!0),e.forEach((e=>{i.logger.debug(`Checking ${e.name} for srd images`);const a=t.find((t=>t.name===e.name&&"npc"===t.type));if(a){i.logger.debug(`Updating monster ${e.name} to srd images`,a);const t=n.y.SRD_COMPENDIUMS.find((e=>"monsters"==e.type)).name,s=game.dnd5e.moduleArt.map.get(`Compendium.${t}.${a._id}`);i.logger.debug(`Updating monster ${e.name} to srd images`,{nameMatch:a,moduleArt:s}),e.prototypeToken.texture.scaleY=a.prototypeToken.texture.scaleY,e.prototypeToken.texture.scaleX=a.prototypeToken.texture.scaleX,s?.actor&&""!==a.actor&&!s.actor.includes("mystery-man")?(e.img=s.actor,foundry.utils.setProperty(e,"flags.monsterMunch.imgSet",!0)):a.img&&""!==a.img&&!a.img.includes("mystery-man")&&(e.img=a.img,foundry.utils.setProperty(e,"flags.monsterMunch.imgSet",!0)),s?.token&&!foundry.utils.hasProperty(s,"token.texture.src")?e.prototypeToken.texture.src=s.token:s?.token?.texture?.src&&""!==s.token.texture.src&&!s.token.texture.src.includes("mystery-man")?(e.prototypeToken.texture.src=s.token.texture.src,foundry.utils.setProperty(e,"flags.monsterMunch.tokenImgSet",!0),s.token.texture.scaleY&&(e.prototypeToken.texture.scaleY=s.token.texture.scaleY),s.token.texture.scaleX&&(e.prototypeToken.texture.scaleX=s.token.texture.scaleX)):a.prototypeToken?.texture?.src&&""!==a.prototypeToken.texture.src&&!a.prototypeToken.texture.src.includes("mystery-man")&&(foundry.utils.setProperty(e,"flags.monsterMunch.tokenImgSet",!0),e.prototypeToken.texture.src=a.prototypeToken.texture.src)}}))}return e}async function generateIconMap(e){let t=[];if(game.settings.get(n.y.MODULE_ID,"munching-policy-use-srd-icons")){const a=await i.Iconizer.getSRDImageLibrary();i.utils.munchNote("Updating SRD Icons",!0);let n=[];e.forEach((e=>{i.utils.munchNote(`Processing ${e.name}`),t.push(i.Iconizer.copySRDIcons(e.items,a,n).then((t=>{e.items=t})))}))}return Promise.all(t)}function copyExistingMonsterImages(e,t){return e.map((e=>{const a=t.find((t=>e.name===t.name));if(a){e.img=a.img;for(const t of Object.keys(e.prototypeToken))!["sight","detectionModes","flags"].includes(t)&&foundry.utils.hasProperty(a.prototypeToken,t)&&(e.prototypeToken[t]=foundry.utils.deepClone(a.prototypeToken[t]));return e}return e}))}},775:(e,t,a)=>{a.d(t,{m:()=>parseItems});var i=a(657),n=a(421),s=a(115),r=a(431),o=a(391),l=a(521),d=a(382);async function parseItems({useSourceFilter:e=!0,ids:t=[],deleteBeforeUpdate:a=null}={}){const c=game.settings.get(s.y.MODULE_ID,"munching-policy-update-existing"),u=game.settings.get(s.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,"");n.logger.info("Checking for existing files..."),await n.FileHelper.generateCurrentFiles(u),n.logger.info("Check complete, getting ItemData."),await i.A.generateCompendiumFolders("items"),CONFIG.DDBI.EFFECT_CONFIG.MODULES.configured||(CONFIG.DDBI.EFFECT_CONFIG.MODULES.configured=await n.DDBMacros.configureDependencies()),n.utils.munchNote("Downloading item data..");const m=(null===t||0===t.length)&&e,p=await function getItemData({useSourceFilter:e=!0,ids:t=[]}={}){const a=n.Secrets.getCobalt(),i=n.DDBCampaigns.getCampaignId(n.utils.munchNote),r=n.DDBProxy.getProxy(),o={cobalt:a,campaignId:i,betaKey:n.PatreonHelper.getPatreonKey(),addSpells:!0},l=game.settings.get(s.y.MODULE_ID,"debug-json"),d=game.settings.get(s.y.MODULE_ID,"munching-policy-use-source-filter"),c=game.settings.get(s.y.MODULE_ID,"munching-policy-use-generic-items"),u=d?game.settings.get(s.y.MODULE_ID,"munching-policy-muncher-sources").flat():[],m=game.settings.get(s.y.MODULE_ID,"munching-policy-exclude-legacy");return n.logger.debug("Fetching Items with:",{debugJson:l,enableSources:d,useGenerics:c,sources:u,excludeLegacy:m,useSourceFilter:e}),new Promise(((a,i)=>{fetch(`${r}/proxy/items`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(o)}).then((e=>e.json())).then((e=>(l&&n.FileHelper.download(JSON.stringify(e),"items-raw.json","application/json"),e.success||(n.utils.munchNote(`Failure: ${e.message}`),i(e.message)),e.data))).then((e=>n.DDBProxy.isCustom()?{items:e,spells:[],extra:[]}:e)).then((e=>({items:e.items,spells:e.spells.map((e=>e.data)),extra:e.extra}))).then((t=>{const a=t.items.filter((e=>e.canBeAddedToInventory||c));return{items:0!==u.length&&e?a.filter((e=>e.sources.some((e=>u.includes(e.sourceId))))):a,spells:t.spells,extra:t.extra}})).then((e=>u.length>0?e:game.settings.get(s.y.MODULE_ID,"munching-policy-item-homebrew-only")?{items:e.items.filter((e=>e.isHomebrew)),spells:e.spells,extra:e.extra}:game.settings.get(s.y.MODULE_ID,"munching-policy-item-homebrew")?e:{items:e.items.filter((e=>!e.isHomebrew)),spells:e.spells,extra:e.extra})).then((e=>t.length>0?{items:e.items.filter((e=>t.includes(e.id))),spells:e.spells,extra:e.extra}:e)).then((e=>m?{items:e.items.filter((e=>!e.isLegacy)),spells:e.spells,extra:e.extra}:e)).then((e=>a(e))).catch((e=>i(e)))}))}({useSourceFilter:m,ids:t}),g=function getCharacterInventory(e,t=[]){return e.map((e=>{const a=t.find((t=>t.id==e.id)),i=a?a.data.limitedUse:null;return{chargesUsed:0,definitionId:0,definitionTypeId:0,displayAsAttack:null,entityTypeId:0,equipped:!1,id:0,isAttuned:!1,quantity:e.bundleSize?e.bundleSize:1,definition:e,limitedUse:i}}))}(p.items,p.extra),h=await async function generateImportItems(e,t,a=[]){const i={system:d.SystemHelpers.getTemplate("character"),type:"character",name:"",flags:{ddbimporter:{compendium:!0,dndbeyond:{effectAbilities:[],totalLevels:0,proficiencies:[],proficienciesIncludingEffects:[],characterValues:[]}}}},n={character:{classes:[],race:{racialTraits:[]},characterValues:[],inventory:e,customItems:null,options:{class:[],race:[],feat:[]},spells:{item:a},modifiers:{race:[],class:[],background:[],feat:[],item:[],condition:[]},feats:[]}},s=new r.A(n);s.raw.character=i,s.source={ddb:n};const o=await l.A.getItemSpells(n,s.raw.character,{generateSummons:!0,notifier:t});return s.raw.itemSpells=o,{items:await s.getInventory(t),spells:s.raw.itemSpells}}(g,n.utils.munchNote,p.spells);let f=h.items;n.utils.munchNote("Parsing item data.."),await n.Iconizer.preFetchDDBIconImages();const y=new n.DDBItemImporter("items",f,{deleteBeforeUpdate:a,matchFlags:["is2014","is2024"],notifier:n.utils.munchNote});await y.init(),await y.srdFiddling(),n.utils.munchNote(`Imps are creating iconographs for ${y.documents.length} possible items (this can take a while)`,!0),await y.iconAdditions();const b=null!==t&&t.length>0?y.documents.filter((e=>e.flags?.ddbimporter?.definitionId&&t.includes(String(e.flags.ddbimporter.definitionId)))):y.documents;y.documents=await o.Qs.applyChrisPremadeEffects({documents:b,compendiumItem:!0});const D=y.documents.length;n.utils.munchNote(`Preparing to import ${D} items!`,!0),n.logger.time("Item Import Time");const v=await y.updateCompendium(c),C=await Promise.all(v);return n.logger.debug("Final Item Import Data",{finalItems:y.documents,updateResults:v,updatePromiseResults:C}),n.utils.munchNote(""),n.logger.timeEnd("Item Import Time"),v}},489:(e,t,a)=>{a.d(t,{f:()=>updateItemPrices,y:()=>calculatePrice});var i=a(115),n=a(421);async function calculatePrice(e,t=!1){if(!i.x.equipment.priceFormulas[e])return null;const a=new Roll(i.x.equipment.priceFormulas[e]);return await a.evaluate({async:!0}),t?parseInt(a.total/2):a.total}async function updateItemPrices({keepExistingNonDDBPrices:e=!0,keepExistingDDBPrices:t=!0,compendiumName:a=null}={}){const s=a??await n.CompendiumHelper.getCompendiumLabel("equipment"),r=n.CompendiumHelper.getCompendium(s);if(r.configure({locked:!1}),!r)return n.logger.error("Compendium not found:",s),[];const o=(await r.getIndex({fields:["name","type","system.rarity","system.price.value","flags.ddbimporter.price"]})).filter((a=>{if(!(a.system.rarity in i.x.equipment.priceFormulas))return n.logger.info(`No update needed for ${a.name}, item has no rarity`),!1;const s=a.system.price.value;if(null==s||0===s)return!0;const r=foundry.utils.getProperty(a,"flags.ddbimporter.price.xgte");return!(t||!r)||(!e&&!r||(n.logger.info(`No update needed for ${a.name}`),!1))})),l=[];for(let e of o){const a=e.system.rarity,i=e.system.price.value,s="consumable"===e.type;n.logger.info(`Processing ${e.name}: Rarity - ${a}, Price - ${i}, Consumable - ${s}`);const r=t&&foundry.utils.hasProperty(e,"flags.ddbimporter.price.value")?foundry.utils.getProperty(e,"flags.ddbimporter.price.value"):await calculatePrice(a,s);null!==r&&(n.logger.info(`Adding update of GP price of ${e.name} (Rarity: ${a}) to ${r} gp`),l.push({_id:e._id,"system.price.value":r,"system.price.denomination":"gp","flags.ddbimporter.price":{xgte:!0,value:r}}))}return await Item.updateDocuments(l,{pack:s}),ui.notifications.info(`Attempted to update prices for ${l.length} items.`),o}},132:(e,t,a)=>{a.d(t,{p:()=>parseSpells});var i=a(421),n=a(657),s=a(115),r=a(391),o=a(521),l=a(976);function getSpellData(e,t,a=null){const n=i.Secrets.getCobalt(),r=i.DDBCampaigns.getCampaignId(i.utils.munchNote),o=i.DDBProxy.getProxy(),l=i.PatreonHelper.getPatreonKey(),d=game.settings.get(s.y.MODULE_ID,"munching-policy-exclude-legacy"),c={cobalt:n,campaignId:r,betaKey:l,className:e,rulesVersion:a??(d?"2024":"2014")},u=game.settings.get(s.y.MODULE_ID,"debug-json"),m=game.settings.get(s.y.MODULE_ID,"munching-policy-use-source-filter")?game.settings.get(s.y.MODULE_ID,"munching-policy-muncher-sources").flat():[];return new Promise(((e,a)=>{fetch(`${o}/proxy/class/spells`,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(c)}).then((e=>e.json())).then((e=>(u&&i.FileHelper.download(JSON.stringify(e),"spells-raw.json","application/json"),e.success||(i.utils.munchNote(`Failure: ${e.message}`),a(e.message)),e))).then((e=>0!=m.length&&t?e.data.filter((e=>e.definition.sources.some((e=>m.includes(e.sourceId))))):e.data)).then((e=>m.length>0?e:game.settings.get(s.y.MODULE_ID,"munching-policy-spell-homebrew-only")?e.filter((e=>e.definition.isHomebrew)):game.settings.get(s.y.MODULE_ID,"munching-policy-spell-homebrew")?e:e.filter((e=>!e.definition.isHomebrew)))).then((t=>e(t))).catch((e=>{i.logger.warn(e),a(e)}))}))}async function parseSpells(e=null,t=null){const a=game.settings.get(s.y.MODULE_ID,"munching-policy-update-existing"),d=game.settings.get(s.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,"");await i.FileHelper.generateCurrentFiles(d),await n.A.generateCompendiumFolders("spells"),CONFIG.DDBI.EFFECT_CONFIG.MODULES.configured||(CONFIG.DDBI.EFFECT_CONFIG.MODULES.configured=await i.DDBMacros.configureDependencies()),i.utils.munchNote("Downloading spell data..");const c=!(null!==e&&e.length>0),u=[],m=new l.A;for(const e of l.A.CLASS_NAMES){const t=await getSpellData(e,c);m.extractSpellListData(e,t),u.push(...t)}i.utils.munchNote("Parsing spell data.");const p=game.settings.get(s.y.MODULE_ID,"munching-policy-exclude-legacy"),g=u.filter((e=>!p||p&&!e.definition.isLegacy)).filter(((e,t,a)=>a.findIndex((t=>t.definition.name===e.definition.name&&t.definition.isLegacy===e.definition.isLegacy))===t)),h=(await o.A.getSpells(g,i.utils.munchNote)).filter((e=>e?.name)).map((e=>(e.name=i.utils.nameString(e.name),e)));await i.Iconizer.preFetchDDBIconImages();const f=h.filter(((e,t,a)=>a.findIndex((t=>t.name===e.name&&t.flags.ddbimporter.is2014===e.flags.ddbimporter.is2014&&t.flags.ddbimporter.is2024===e.flags.ddbimporter.is2024))===t)),y=new i.DDBItemImporter("spells",f,{deleteBeforeUpdate:t,matchFlags:["is2014","is2024"],notifier:i.utils.munchNote});await y.init(),await y.srdFiddling(),await y.iconAdditions();const b=null!==e&&e.length>0?y.documents.filter((t=>t.flags?.ddbimporter?.definitionId&&e.includes(String(t.flags.ddbimporter.definitionId)))):y.documents;y.documents=await r.Qs.applyChrisPremadeEffects({documents:b,compendiumItem:!0});const D=y.documents.length;i.utils.munchNote(`Importing ${D} spells...`,!0),i.logger.time("Spell Import Time");const v=await y.updateCompendium(a),C=await Promise.all(v);return i.logger.debug({finalSpells:y.documents,updateResults:v,updatePromiseResults:C}),i.utils.munchNote(""),i.logger.timeEnd("Spell Import Time"),i.logger.debug("Starting Spell List Generation"),i.utils.munchNote("Generating Spell List Journals...",!0),await m.buildSpellLists(),await m.registerSpellLists(),i.logger.debug("Spell List Generation Complete"),v}},36:(e,t,a)=>{a.d(t,{i8:()=>resetCompendiumActorImages,k5:()=>parseCritters,zU:()=>updateWorldMonsters});var i=a(421),n=a(750),s=a(492);let r=0,o=0;async function updateActorsWithActor(e,t){o++;for(let a of e){i.utils.munchNote(`Updating ${o}/${r} world monsters`),i.logger.debug(`Updating ${o}/${r} world monsters`,a);const e=t.items.toObject().map((e=>(delete e._id,e))),n=foundry.utils.duplicate(t);delete n.items;game.settings.get("ddb-importer","munching-policy-update-world-monster-update-images")||(n.img=a.img,n.prototypeToken.texture.src=a.prototypeToken.texture.src,n.prototypeToken.scale=a.prototypeToken.scale,n.prototypeToken.randomImg=a.prototypeToken.randomImg,n.prototypeToken.mirrorX=a.prototypeToken.mirrorX,n.prototypeToken.mirrorY=a.prototypeToken.mirrorY,n.prototypeToken.lockRotation=a.prototypeToken.lockRotation,n.prototypeToken.rotation=a.prototypeToken.rotation,n.prototypeToken.alpha=a.prototypeToken.alpha,n.prototypeToken.lightAlpha=a.prototypeToken.lightAlpha,n.prototypeToken.lightAnimation=a.prototypeToken.lightAnimation,n.prototypeToken.tint=a.prototypeToken.tint,n.prototypeToken.lightColor=a.prototypeToken.lightColor);game.settings.get("ddb-importer","munching-policy-update-world-monster-retain-biography")&&(n.system.details.biography=a.system.details.biography),n._id=a.id,a.folder&&(n.folder=a.folder._id),n.sort=a.sort,n.ownership=a.ownership,i.DDBItemImporter.copySupportedItemFlags(a,n),await a.deleteEmbeddedDocuments("Item",[],{deleteAll:!0}),await a.update(n),await a.createEmbeddedDocuments("Item",e)}return Promise.all([])}async function updateWorldMonsters(){let e=[];const t=i.CompendiumHelper.getCompendiumLabel("monster"),a=i.CompendiumHelper.getCompendium(t);if(a){const t=["name","flags.ddbimporter.id"],n=await a.getIndex({fields:t});r=game.actors.filter((e=>"npc"===e.type&&foundry.utils.hasProperty(e,"flags.ddbimporter.id"))).length,o=0,i.utils.munchNote(`Updating ${o}/${r} world monsters`),i.logger.debug(`Checking ${r} world monsters`);for(const[t,s]of n.entries()){const n=game.actors.filter((e=>e.flags?.ddbimporter?.id&&e.name===s.name&&e.flags.ddbimporter.id==s.flags?.ddbimporter?.id));if(n.length>0){i.utils.munchNote(`Found ${s.name} world monster`,!0),i.logger.debug(`Matched ${s.name} (${t})`);const r=await a.getDocument(s._id);let o=await updateActorsWithActor(n,r);e.push(o)}}i.utils.munchNote(`Finished updating ${r} world monsters`),i.utils.munchNote("",!0)}else i.logger.error("Error opening compendium, check your settings");return e}async function resetCompendiumActorImages(e=null,t="monster"){const a=e||i.CompendiumHelper.getCompendiumLabel(t),s=i.CompendiumHelper.getCompendium(a),r=await s.getIndex({fields:["name","flags.monsterMunch","system.details.type.value","img","prototypeToken.texture.src"]}),o=game.settings.get("ddb-importer","other-image-upload-directory").replace(/^\/|\/$/g,"");await i.FileHelper.generateCurrentFiles(o);const l=await Promise.all(r.filter((e=>"#[CF_tempEntity]"!==e.name)).map((async e=>{const a={forceUpdate:!0,disableAutoTokenizeOverride:!0,type:t},s=await(0,n.$Q)(foundry.utils.duplicate(e),a);return i.logger.info(`Resetting ${e.name}`,s),s}))),d=await Actor.updateDocuments(l,{pack:a});return i.logger.debug("Reset results",d),d}async function parseCritters(e=null){const t=new s.A;return await t.processIntoCompendium(e)}},535:(e,t,a)=>{a.d(t,{x:()=>getVehicleData,y:()=>parseTransports});var i=a(421),n=a(750),s=a(382);var r=a(115);const o=[{id:1,value:"str",long:"strength"},{id:2,value:"dex",long:"dexterity"},{id:3,value:"con",long:"constitution"},{id:4,value:"int",long:"intelligence"},{id:5,value:"wis",long:"wisdom"},{id:6,value:"cha",long:"charisma"}];const l=[{name:"Tiny",value:"tiny",size:.5},{name:"Small",value:"sm",size:.8},{name:"Medium",value:"med",size:1},{name:"Large",value:"lg",size:2},{name:"Huge",value:"huge",size:3},{name:"Gargantuan",value:"grg",size:4}];function getSize(e){const t=function getSizeFromId(e){const t=CONFIG.DDB.creatureSizes.find((t=>t.id==e)).name,a=l.find((e=>t==e.name));return a||(i.logger.warn("No size found, using medium",t),{name:"Medium",value:"med",size:1})}(e.sizeId),a={scale:t.size>=1?1:t.size,value:t.size>=1?t.size:1};return{value:t.value,token:a}}const d=["7","8"],c={land:"walk",water:"swim",air:"fly",magical:"Magical"};const u={hull:"equipment",helm:"equipment",weapon:"weapon",movement:"equipment",control:"equipment",feature:"feat"};function getWeaponProperties(e,t){e.name&&(t.name+=`: ${e.name}`),t.system.description.value+=`\n${e.description}`,null!==e.fixedToHit&&(t.system.attack.bonus=`${e.fixedToHit}`),t.system.type.value="siege",t.system.target={value:1,width:null,units:"",type:"creature"},Number.isInteger(e.numberOfTargets)&&(t.system.target.value=e.numberOfTargets);const a=r.x.actions.damageType.find((t=>t.id===e.damageTypeId)).name;if(e.dice?.diceString&&(t.system.damage.parts=[[e.dice.diceString,a]]),e.fixedSaveDc){const a=e.saveStatId?r.x.actor.abilities.find((t=>t.id===e.saveStatId)).value:function getSaveAbility(e){const t=e.match(/DC ([0-9]+) (.*?) saving throw|\(save DC ([0-9]+)\)/);return t&&t[2]?t[2].toLowerCase().substr(0,3):""}(e.description);t.system.save={ability:[a],dc:Number.parseInt(e.fixedSaveDc),scaling:"flat"}}return t.system.equipped=!0,t.system.actionType=function getActionType(e){let t="rwak";return t="number"==typeof e.saveStatId||e.fixedSaveDc?"save":1===e.actionType?2===e.attackTypeRange?"rwak":"mwak":e.rangeId&&1===e.rangeId?"mwak":e.rangeId&&2===e.rangeId?"rwak":"other",t}(e),t.system.uses=function getLimitedUse(e){if(e.limitedUse&&e.limitedUse.maxUses){const t=r.x.resets.find((t=>t.id===e.limitedUse.resetType));let a=e.limitedUse.maxUses&&-1!==e.limitedUse.maxUses?e.limitedUse.maxUses:0;const i=a?parseInt(a):null;return{spent:e.limitedUse.numberUsed??0,max:0!=i?i:null,per:t?t.value:"",recovery:t?[{period:t.value,type:"recoverAll",formula:void 0}]:[]}}return{spent:null,max:null,recovery:[]}}(e),t.system.activation=function getActivation(e,t=!1){const a=r.x.actions.activationTypes.find((t=>t.id===e.activation?.activationType));return{type:t?"crew":a?a.value:"action",cost:e.activation?.activationTime||1,condition:""}}(e,"crew"===t.system.activation.type),t=function calculateRange(e,t){return e.range&&e.range.aoeType&&e.range.aoeSize?(t.system.range={value:null,units:"self",long:""},t.system.target={value:e.range.aoeSize,type:r.x.actions.aoeType.find((t=>t.id===e.range.aoeType))?.value,units:"ft"}):e.range&&e.range.range?t.system.range={value:e.range.range,units:"ft",long:e.range.longRange||""}:t.system.range={value:5,units:"ft",long:""},t}(e,t),t}function buildComponents(e,t,a){const n=[],r=a.definition.types.map((e=>e.type)),o=foundry.utils.duplicate(function newComponent(e,t){return{name:e,type:t,system:s.SystemHelpers.getTemplate(t),flags:{ddbimporter:{dndbeyond:{}}}}}(a.definition.name,u[r[0]]));if("equipment"===r[0]&&foundry.utils.setProperty(o,"data.armor.type","vehicle"),a.description&&(o.system.description.value=s.DDBReferenceLinker.parseTags(a.description)),o.system.quantity=a.count,o.system.armor={value:null,type:"vehicle",dex:null},o.system.hp={value:null,max:null,dt:null,conditions:""},"action-station"===a.groupType)switch(o.system.activation.type="crew",a.definition.coverType){case"full":o.system.cover=1;break;case"half":o.system.cover=.5;break;case"three-quarters":o.system.cover=.75;break;default:o.system.cover=void 0}else if("component"===a.definition.groupType){if(a.definition.speeds&&a.definition.speeds.length>0&&(o.system.speed={value:a.definition.speeds[0].modes[0].value,conditions:a.definition.speeds[0].modes[0].description?a.definition.speeds[0].modes[0].description:""},a.definition.speeds[0].modes.length>1)){const e=[];for(let t=1;t<a.definition.speeds[0].modes.length;t++){const i=a.definition.speeds[0].modes[t].value,n=a.definition.speeds[0].modes[t].description?a.definition.speeds[0].modes[t].description:"",s=a.definition.speeds[0].modes[t].restrictionsText?a.definition.speeds[0].modes[t].restrictionsText:"";e.push(`${i} ${n}${s}`)}const t=a.definition.types.find((e=>"movement"===e.type));t&&t.adjustments&&t.adjustments.length>0&&t.adjustments.filter((e=>"speed"===e.type)).forEach((t=>{t.values.forEach((t=>{e.push(`-${t.perDamageValue}ft speed per ${t.perDamageTaken} damage taken`)}))})),e.length>0&&(o.system.speed.conditions+=e.join("; "))}Number.isInteger(a.definition.armorClass)&&(o.system.armor={value:parseInt(a.definition.armorClass),type:"vehicle",dex:null}),Number.isInteger(a.definition.hitPoints)&&(o.system.hp={value:parseInt(a.definition.hitPoints),max:parseInt(a.definition.hitPoints),dt:null,conditions:""},a.definition.damageThreshold&&(o.system.hp.dt=a.definition.damageThreshold))}return r.includes("weapon")&&a.definition.actions.length>0?(i.logger.debug("processing weapon",a),a.definition.actions.forEach((e=>{const t=getWeaponProperties(e,foundry.utils.duplicate(o));i.logger.debug("action item",t),n.push(t)}))):n.push(o),n}const m=[{id:"7",thresholds:{0:1,1:10,2:20}},{id:"11",thresholds:{0:null,1:null,2:null}},{id:"9",thresholds:{0:null,1:null,2:null}},{id:"1",thresholds:{0:3,1:20,2:40}},{id:"2",thresholds:{0:1,1:null,2:2}},{id:"3",thresholds:{0:20,1:null,2:40}},{id:"8",thresholds:{0:1,1:null,2:1}},{id:"4",thresholds:{0:1,1:null,2:2}},{id:"5",thresholds:{0:3,1:10,2:20}},{id:"12",thresholds:{0:null,1:null,2:null}},{id:"10",thresholds:{0:null,1:null,2:null}},{id:"6",thresholds:{0:3,1:10,2:20}}];async function parseVehicle(e,t={}){i.logger.debug("Parsing vehicle",{extra:t});let a=foundry.utils.duplicate(await async function newVehicle(e){let t=(await Actor.create({name:e,type:"vehicle"},{temporary:!0,displaySheet:!1})).toObject();return foundry.utils.setProperty(t,"flags",{dnd5e:{},monsterMunch:{},ddbimporter:{dndbeyond:{}}}),t}(e.name));const n={};e.configurations.forEach((e=>{n[e.key]=e.value}));let l=e.largeAvatarUrl;l&&l.match(/.gif$/)&&(l=null),a.prototypeToken.name=e.name,a.flags.monsterMunch={url:e.url,img:l||e.avatarUrl,tokenImg:e.avatarUrl},a.flags.ddbimporter={id:e.id,version:CONFIG.DDBI.version,configurations:n},a.system.abilities=function getAbilities(e,t){return o.forEach((a=>{const i=t.stats.find((e=>e.id===a.id))?.value||10,n=0===i?-5:CONFIG.DDB.statModifiers.find((e=>e.value==i)).modifier;e[a.value].value=i,e[a.value].proficient=0,e[a.value].mod=n})),e}(a.system.abilities,e),a.system.traits.di=function getDamageImmunities(e){const t=CONFIG.DDB.damageTypes;let a=[],i=[];const n=r.x.actions.damageType.filter((e=>null!==e.name)).map((e=>e.name));return e.damageImmunities.forEach((e=>{const s=t.find((t=>e===t.id));if(s&&n.includes(s.name.toLowerCase()))a.push(s.name.toLowerCase());else if(s&&"bludgeoning-piercing-and-slashing-from-nonmagical-attacks"===s.slug)a.push("bludgeoning","piercing","slashing");else if(s){const e=game.modules.get("midi-qol")?.active;e?s.name.toLowerCase().includes("silvered")?a.push("silver"):s.name.toLowerCase().includes("adamantine")?a.push("adamant"):"damage-from-spells"===s.slug?a.push("spell"):i.push(s.name):i.push(s.name)}})),{value:a,custom:i.join("; ")}}(e),a.system.traits.ci=function getConditionImmunities(e){const t=CONFIG.DDB.conditions.map((e=>({id:e.definition.id,name:e.definition.name,type:e.definition.type,slug:e.definition.slug})));let a=[],i=[];return e.conditionImmunities.forEach((e=>{const n=t.find((t=>e===t.id)),s=r.x.conditions.find((e=>e.label.toLowerCase()==n.name.toLowerCase()));n&&s?a.push(s.foundry):n&&i.push(n.name)})),{value:a,custom:i.join("; ")}}(e);const u=getSize(e);a.system.traits.size=u.value,a.prototypeToken.width=u.token.value,a.prototypeToken.height=u.token.value,a.prototypeToken.scale=u.token.scale,a.system.attributes.capacity=function getCapacity(e){let t={creature:"",cargo:null};if(e.cargoCapacity&&(t.cargo=e.cargoCapacity),e.creatureCapacity&&e.creatureCapacity.length>0){const a=e.creatureCapacity.map((e=>{const t=e.sizeId?`${CONFIG.DDB.creatureSizes.find((t=>t.id==e.sizeId)).name.toLowerCase()} `:"";return`${e.capacity} ${t}${e.type}`}));t.creature=a.join(", ")}return t}(e),"dimension"===n.ST&&(a.system.traits.dimensions=`(${e.length} ft. by ${e.width} ft.)`),"weight"===n.ST&&(a.system.traits.dimensions=`(${e.weight} lb.)`);const p=foundry.utils.duplicate(a.system.attributes.movement);a.system.attributes.movement=function getMovement(e,t,a){if(t.ETP){a.units="mi";const i=e.travelPace/5280;d.includes(e.id)||"spelljammer"===t.DT?a.fly=i:a.swim=i}else{const t=e.components.find((e=>e.isPrimaryComponent));t&&t.speeds&&t.speeds.length>0&&(a.units="ft",a[c[t.speeds[0].type]]=t.speeds[0].modes[0].value)}return a}(e,n,p);const g=e.components.find((e=>e.isPrimaryComponent));if(!n.ECCR&&g&&(a.system.attributes.hp.value=g.definition.hitPoints,a.system.attributes.hp.max=g.definition.hitPoints,!n.ECMT&&Number.isInteger(g.definition.mishapThreshold)&&(a.system.attributes.hp.mt=g.definition.mishapThreshold),!n.ECDT&&Number.isInteger(g.definition.damageThreshold)&&(a.system.attributes.hp.dt=g.definition.damageThreshold)),"vehicle"===n.PCMT&&g){const t=function getAbilityMods(e){let t={};return o.forEach((a=>{const i=e.stats.find((e=>e.id===a.id))?.value||10,n=0===i?-5:CONFIG.DDB.statModifiers.find((e=>e.value==i)).modifier;t[a.value]=n})),t}(e);"spelljammer"===n.DT?(a.system.attributes.ac.motionless=g.definition.armorClassDescription,a.system.attributes.ac.flat=g.definition.armorClass):(a.system.attributes.ac.motionless=g.definition.armorClass,a.system.attributes.ac.flat=g.definition.armorClass+t.dex)}if(a.system.vehicleType=d.includes(e.id)||"spelljammer"===n.DT?"air":"ship"===n.DT?"water":"land",a.items=function processComponents(e,t){const a=e.components.sort((e=>e.displayOrder)),i={},n=[];a.forEach((e=>{const t=e.definitionKey,a=i[t]||0;0===a&&n.push(e),i[t]=a+1}));const s=n.filter((e=>e.definition.name)).map((e=>(e.count=i[e.definitionKey],buildComponents(0,0,e)))).flat();return e.features.filter((e=>e.name)).map((e=>(foundry.utils.setProperty(e,"definition.types",[{type:"feature"}]),foundry.utils.setProperty(e,"definition.name",e.name),buildComponents(0,0,e)))).flat().concat(s)}(e),a.system.details.source=i.DDBSources.parseSource(e),a.system.details.biography.value=s.DDBReferenceLinker.parseTags(e.description),n.EAS&&(a.system.attributes.actions.stations=!0),e.actionsText){a.system.details.biography.value+=`<h2>Actions</h2>\n<p>${e.actionsText}</p>`;const t=e.componentActionSummaries.map((e=>`<h3>${e.name}</h3>\n<p>${e.description}</p>`)).join("\n");a.system.details.biography.value+=`\n<p>${t}</p>`;const i=/On its turn(?:,*) the (?:.*?) can take (\d+) action/g,n=e.actionsText.match(i),s=n?parseInt(n[1]):1;a.system.attributes.actions.value=s;const r=m.find((t=>t.id===e.id));a.system.attributes.actions.thresholds=r?r.thresholds:[]}else if(e.features.length>0){const t=e.features.map((e=>`<h3>${e.name}</h3>\n<p>${e.description}</p>`)).join("\n");a.system.details.biography.value+=`<h2>Features</h2>\n<p>${t}</p>`}return a=await i.CompendiumHelper.existingActorCheck("vehicle",a),a}var p=a(617);function getVehicleData(e){const t=i.Secrets.getCobalt(),a=i.PatreonHelper.getPatreonKey(),n=i.DDBProxy.getProxy(),s={cobalt:t,campaignId:i.DDBCampaigns.getCampaignId(i.utils.munchNote),betaKey:a};if(e&&e.length>0)s.ids=[...new Set(e)];else{const e=$("#monster-munch-filter")[0],t=e?.value||"",a=game.settings.get(r.y.MODULE_ID,"munching-policy-use-source-filter")?game.settings.get(r.y.MODULE_ID,"munching-policy-muncher-sources").flat():[];s.sources=a,s.search=t,s.homebrew=!(s.sources.length>0)&&game.settings.get(r.y.MODULE_ID,"munching-policy-monster-homebrew"),s.homebrewOnly=!(s.sources.length>0)&&game.settings.get(r.y.MODULE_ID,"munching-policy-monster-homebrew-only"),s.searchTerm=encodeURIComponent(t),s.exactMatch=game.settings.get(r.y.MODULE_ID,"munching-policy-monster-exact-match"),s.excludeLegacy=game.settings.get(r.y.MODULE_ID,"munching-policy-exclude-legacy")}const o=e&&e.length>0?`${n}/proxy/vehicles/ids`:`${n}/proxy/vehicles`,l=game.settings.get(r.y.MODULE_ID,"debug-json");return new Promise(((e,t)=>{fetch(o,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(s)}).then((e=>e.json())).then((e=>(l&&i.FileHelper.download(JSON.stringify(e),"vehicles-raw.json","application/json"),e.success||(i.utils.munchNote(`Failure: ${e.message}`),t(e.message)),e))).then((t=>e(t.data))).catch((e=>t(e)))}))}async function processVehicleData(e){i.utils.munchNote(`Retrieved ${e.length} vehicles, starting parse...`,!0,!1),i.logger.info(`Retrieved ${e.length} vehicles`);const t=await async function parseVehicles(e,t=!1){let a=[],n=[];return e.forEach((e=>{try{i.logger.debug(`Attempting to parse ${e.name}`);const n=parseVehicle(e,t);a.push(n)}catch(t){i.logger.error(`Failed parsing ${e.name}`),i.logger.error(t),i.logger.error(t.stack),n.push(e.name)}})),{actors:await Promise.all(a),failedVehicleNames:n}}(e);return i.utils.munchNote(`Parsed ${t.actors.length} vehicles, failed ${t.failedVehicleNames.length} vehicles`,!1,!0),i.logger.info(`Parsed ${t.actors.length} vehicles, failed ${t.failedVehicleNames.length} vehicles`),t.failedVehicleNames&&0!==t.failedVehicleNames.length&&i.logger.error("Failed to parse",t.failedVehicleNames),t.actors}async function parseTransports(e=null){const t=r.y.COMPENDIUMS.find((e=>"Vehicles"===e.title));await(0,p.k)(t),foundry.utils.setProperty(CONFIG.DDBI,"MUNCHER.TEMPORARY",{});const a=game.settings.get(r.y.MODULE_ID,"munching-policy-update-existing"),s=game.settings.get(r.y.MODULE_ID,"munching-policy-update-images"),o=game.settings.get(r.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,"");i.logger.info("Checking for existing files..."),i.utils.munchNote("Checking existing image files..."),await i.FileHelper.generateCurrentFiles(o),i.logger.info("Check complete getting vehicle data..."),i.utils.munchNote("Getting vehicle data from DDB...");let l=await getVehicleData(e),d=await processVehicleData(l);const c=new i.DDBItemImporter("vehicles",d,{matchFlags:["is2014","is2024"],notifier:i.utils.munchNote});if(await c.init(),!a||!s){i.utils.munchNote("Calculating which vehicles to update...",!0);const e=await i.DDBItemImporter.getCompendiumItems(d,"vehicles",{keepDDBId:!0}),t=e.length+1;a||(i.logger.debug("Removing existing vehicles from import list"),i.logger.debug(`Matched ${t}`),i.utils.munchNote(`Removing ${t} from update...`),c.removeItems(e)),s||(i.logger.debug("Copying vehicle images across..."),i.utils.munchNote(`Copying images for ${t} vehicles...`),d=(0,n.dD)(d,e))}i.utils.munchNote(""),i.utils.munchNote("Fiddling with the SRD data...",!0),await c.srdFiddling(),await c.iconAdditions(),i.utils.munchNote("Generating Icon Map..",!0),await(0,n.VL)(c.documents);const u=new i.DDBCompendiumFolders("vehicles");i.utils.munchNote("Checking compendium folders..",!0),await u.loadCompendium("vehicles"),i.utils.munchNote("",!0);let m=[],g=1;const h=c.documents.length;i.utils.munchNote(`Preparing to wax ${h} vehicles!`,!0);for(const e of c.documents){i.utils.munchNote(`[${g}/${h}] Importing ${e.name}`,!1,!0),i.logger.debug(`Importing/second parse of ${e.name} data`);const t=await(0,n.VJ)(e,"vehicle");m.push(t),g+=1}return i.logger.debug("Vehicles Parsed",m),i.utils.munchNote("",!1,!0),foundry.utils.setProperty(CONFIG.DDBI,"MUNCHER.TEMPORARY",{}),null!==e?Promise.all(m):h}},431:(e,t,a)=>{a.d(t,{A:()=>DDBCharacter});var i=a(421),n=a(43),s=a(486),r=a(686),o=a(115),l=a(382);class CharacterSpellFactory{constructor(e){this.ddbCharacter=e,this.ddb=e.source.ddb,this.character=e.raw.character,this.processed=[],this.proficiencyModifier=this.character.system.attributes.prof,this.lookups=(0,n.k)(this.ddb.character),i.logger.debug("Character spell lookups",this.lookups),this.characterAbilities=this.character.flags.ddbimporter.dndbeyond.effectAbilities,this.healingBoost=l.DDBModifiers.filterBaseModifiers(this.ddb,"bonus",{subType:"spell-group-healing"}).reduce(((e,t)=>e+t.value),0),this.spellCounts={},this.slots=foundry.utils.getProperty(this.character,"system.spells"),this.levelSlots=i.utils.arrayRange(9,1,1).some((e=>this.slots[`spell${e}`]&&0!==this.slots[`spell${e}`].max)),this.pactSlots=this.slots.pact?.max&&this.slots.pact.max>0,this.hasSlots=this.levelSlots||this.pactSlots,this.generateSummons=e.generateSummons}_getSpellCount(e){return this.spellCounts[e]||(this.spellCounts[e]=0),++this.spellCounts[e]}async _processClassSpell({classInfo:e,playerClass:t,spell:a,spellCastingAbility:n,abilityModifier:s,cantripBoost:o}){a.flags={ddbimporter:{dndbeyond:{lookup:"classSpell",class:e.definition.name,level:e.level,characterClassId:t.characterClassId,spellLevel:a.definition.level,ability:n,mod:s,dc:8+this.proficiencyModifier+s,cantripBoost:o,overrideDC:!1,id:a.id,entityTypeId:a.entityTypeId,healingBoost:this.healingBoost,usesSpellSlot:a.usesSpellSlot,forceMaterial:"Artificer"===e.definition.name,homebrew:a.definition.isHomebrew}},"spell-class-filter-for-5e":{parentClass:e.definition.name.toLowerCase()},"tidy5e-sheet":{parentClass:e.definition.name.toLowerCase()}};const l=await r.A.parseSpell(a,this.character,{ddbData:this.ddb,namePostfix:`${this._getSpellCount(a.definition.name)}`,generateSummons:this.generateSummons});foundry.utils.setProperty(l,"system.sourceClass",e.definition.name.toLowerCase());const d=this.processed.findIndex((t=>{const i=t.flags.ddbimporter.originalName?t.flags.ddbimporter.originalName:t.name,n=l.flags.ddbimporter.originalName?l.flags.ddbimporter.originalName:l.name,s=e.definition.name===t.flags.ddbimporter.dndbeyond.class||a.id===t.flags.ddbimporter.dndbeyond.id,r=(l.flags.ddbimporter.is2014??!0)===(t.flags.ddbimporter.is2014??!0)||(l.flags.ddbimporter.is2024??!1)===(t.flags.ddbimporter.is2024??!1);return i===n&&s&&r})),c=this.processed[d];c?a.alwaysPrepared||"always"===l.system.preparation.mode||a.alwaysPrepared===c.alwaysPrepared&&l.system.preparation.mode===c.system.preparation.mode&&l.prepared&&!c.prepared?this.processed[d]=l:i.logger.info(`Duplicate Spell ${a.definition.name} detected in class ${e.definition.name}.`):this.processed.push(l)}filterSpellsByAllowedCategories(e){return e.filter((e=>{const t=e.definition.sources.map((e=>e.sourceId));return CONFIG.DDB.sources.some((e=>t.includes(e.id)&&this.ddb.character.activeSourceCategories.includes(e.sourceCategoryId)))}))}removeSpellsBySourceCategoryIds(e,t=[]){return e.filter((e=>{const a=e.definition.sources.map((e=>e.sourceId));return!CONFIG.DDB.sources.some((e=>a.includes(e.id)&&t.includes(e.sourceCategoryId)))}))}async getClassSpells(){for(const e of this.ddb.character.classSpells){const t=this.ddb.character.classes.find((t=>t.id===e.characterClassId)),a=(0,s.s6)(t),n=i.utils.calculateModifier(this.characterAbilities[a].value),r=t.definition.sources.some((e=>Number.isInteger(e.sourceId)&&e.sourceId<145)),d=["Ranger","Paladin"].includes(t.definition.name);!r&&d&&(e.spells=e.spells.map((e=>(!e.alwaysPrepared&&e.countsAsKnownSpell&&(e.prepared=!0),e)))),i.logger.debug("Spell parsing, class info",t);const c=l.DDBModifiers.getChosenClassModifiers(this.ddb).filter((e=>"bonus"===e.type&&e.subType===`${t.definition.name.toLowerCase()}-cantrip-damage`&&(null===e.restriction||""===e.restriction))).length>0,u=[...e.spells,...e.alwaysPreparedSpells??[]];if(game.settings.get(o.y.MODULE_ID,"character-update-policy-import-full-spell-list")){const t=e.alwaysKnownSpells??[],a=game.settings.get(o.y.MODULE_ID,"character-update-policy-use-active-sources")?this.filterSpellsByAllowedCategories(t):t;u.push(...a)}const m=[];game.settings.get(o.y.MODULE_ID,"character-update-policy-remove-2024")&&m.push(24),game.settings.get(o.y.MODULE_ID,"character-update-policy-remove-legacy")&&m.push(23,26);const p=m.length>0?this.removeSpellsBySourceCategoryIds(u,m):u;for(const i of p)i.definition&&await this._processClassSpell({classInfo:t,playerClass:e,spell:i,spellCastingAbility:a,abilityModifier:n,cantripBoost:c})}}async getSpecialClassSpells(){for(const e of this.ddb.character.spells.class){if(!e.definition)continue;let t;const a=l.DDBDataUtils.determineActualFeatureId(this.ddb,e.componentId),n=this.lookups.classFeature.find((e=>e.id==a));if(i.logger.debug("Class spell parsing, class info",n),n||i.logger.warn(`Unable to add ${e.definition.name}`),!n)continue;let o=l.DDBDataUtils.getClassFromOptionID(this.ddb,e.componentId);o||(o=l.DDBDataUtils.findClassByFeatureId(this.ddb,e.componentId)),i.logger.debug("Class spell, class found?",o),(0,s.m9)(e.spellCastingAbilityId)?t=(0,s.cu)(e.spellCastingAbilityId):o?(t=(0,s.s6)(o),e.alwaysPrepared=!0):t="wis",e.alwaysPrepared||e.prepared||e.countsAsKnownSpell||!e.usesSpellSlot||e.limitedUse||(e.alwaysPrepared=!0);const d=i.utils.calculateModifier(this.characterAbilities[t].value);e.flags={ddbimporter:{dndbeyond:{class:o?o.definition.name:void 0,lookup:"classFeature",lookupName:n.name,lookupId:n.id,level:this.character.flags.ddbimporter.dndbeyond.totalLevels,ability:t,mod:d,dc:8+this.proficiencyModifier+d,overrideDC:!1,id:e.id,entityTypeId:e.entityTypeId,healingBoost:this.healingBoost,usesSpellSlot:e.usesSpellSlot,forceMaterial:"Artificer"===o?.definition?.name,homebrew:e.definition.isHomebrew,forcePact:"Warlock"===o?.definition?.name}},"tidy5e-sheet":{parentClass:o?o.definition.name:void 0}};const c=this.processed.findIndex((t=>(t.flags.ddbimporter.originalName?t.flags.ddbimporter.originalName:t.name)===e.definition.name&&o&&o.definition.name===t.flags.ddbimporter.dndbeyond.class&&e.usesSpellSlot&&t.flags.ddbimporter.dndbeyond.usesSpellSlot));if(this.processed[c])if(e.alwaysPrepared){const t=await r.A.parseSpell(e,this.character,{ddbData:this.ddb,namePostfix:`${this._getSpellCount(e.definition.name)}`,generateSummons:this.generateSummons});e.flags.ddbimporter.dndbeyond.class&&foundry.utils.setProperty(t,"system.sourceClass",e.flags.ddbimporter.dndbeyond.class.toLowerCase()),this.processed[c]=t}else i.logger.info(`Duplicate Spell ${e.definition.name} detected in class ${n.name}.`);else{const t=await r.A.parseSpell(e,this.character,{ddbData:this.ddb,namePostfix:`${this._getSpellCount(e.definition.name)}`,generateSummons:this.generateSummons});e.flags.ddbimporter.dndbeyond.class&&foundry.utils.setProperty(t,"system.sourceClass",e.flags.ddbimporter.dndbeyond.class.toLowerCase()),this.processed.push(t),t.flags.ddbimporter.is2024&&CharacterSpellFactory.CLASS_GRANTED_SPELLS_2024.includes(t.flags.ddbimporter.originalName)&&this.handleGrantedSpells(e,"class",{forceCopy:!0,flags:{lookup:"classFeature"}})}}}static CLASS_GRANTED_SPELLS_2024=["Hunter's Mark"];canCast(e){if(e.limitedUse||0===e.definition.level)return!0;if(!this.slots)return!1;if(this.pactSlots)return!0;return i.utils.arrayRange(9,1,1).some((t=>!(e.definition.level>t)&&(this.slots[`spell${t}`]&&0!==this.slots[`spell${t}`].max)))}async handleGrantedSpells(e,t,{forceCopy:a=!1,flags:n={}}={}){if(!(a||e.limitedUse&&0!==e.definition.level))return;if(!a&&!this.slots)return;if(!i.utils.arrayRange(9,1,1).some((t=>!(e.definition.level>t)&&(this.slots[`spell${t}`]&&0!==this.slots[`spell${t}`].max)))&&!this.pactSlots)return;const s=this.ddb.character.spells[t].filter((t=>t.definition&&t.definition.name===e.definition.name)).length>1,o=this.processed.findIndex((t=>(t.flags.ddbimporter.originalName?t.flags.ddbimporter.originalName:t.name)===e.definition.name&&t.flags.ddbimporter.dndbeyond.usesSpellSlot));if(s&&this.processed[o])return;let l=foundry.utils.duplicate(e);l.limitedUse=null,l.usesSpellSlot=!0,l.alwaysPrepared=!0,l.flags.ddbimporter.dndbeyond.usesSpellSlot=!0,l.flags.ddbimporter.dndbeyond.granted=!0,l.flags.ddbimporter.dndbeyond.lookup=n.lookup??t,delete l.id,delete l.flags.ddbimporter.dndbeyond.id;const d=await r.A.parseSpell(l,this.character,{ddbData:this.ddb,namePrefix:"Gr",namePostfix:`${this._getSpellCount(l.definition.name)}`,generateSummons:this.generateSummons});this.processed.push(d)}async getRaceSpells(){for(const e of this.ddb.character.spells.race){if(!e.definition)continue;let t="wis";(0,s.m9)(e.spellCastingAbilityId)&&(t=(0,s.cu)(e.spellCastingAbilityId));const a=i.utils.calculateModifier(this.characterAbilities[t].value);let n=this.lookups.race.find((t=>t.id===e.componentId));if(n||(n={name:"Racial spell",id:e.componentId}),e.flags={ddbimporter:{dndbeyond:{lookup:"race",lookupName:n.name,lookupId:n.id,race:this.ddb.character.race.fullName,level:e.castAtLevel,ability:t,mod:a,dc:8+this.proficiencyModifier+a,overrideDC:!1,id:e.id,entityTypeId:e.entityTypeId,healingBoost:this.healingBoost,usesSpellSlot:e.usesSpellSlot,homebrew:e.definition.isHomebrew}}},1===this.ddb.character.spells.race.filter((t=>t.definition&&t.definition.name===e.definition.name)).length&&this.handleGrantedSpells(e,"race"),!this.canCast(e))continue;const o=await r.A.parseSpell(e,this.character,{ddbData:this.ddb,namePostfix:`${this._getSpellCount(e.definition.name)}`,generateSummons:this.generateSummons});this.processed.push(o)}}async getFeatSpells(){for(const e of this.ddb.character.spells.feat){if(!e.definition)continue;let t="wis";(0,s.m9)(e.spellCastingAbilityId)&&(t=(0,s.cu)(e.spellCastingAbilityId));const a=i.utils.calculateModifier(this.characterAbilities[t].value);let n=this.lookups.feat.find((t=>t.id===e.componentId));if(n||(n={name:"Feat option spell",id:e.componentId}),e.flags={ddbimporter:{dndbeyond:{lookup:"feat",lookupName:n.name,lookupId:n.id,level:e.castAtLevel,ability:t,mod:a,dc:8+this.proficiencyModifier+a,overrideDC:!1,id:e.id,entityTypeId:e.entityTypeId,healingBoost:this.healingBoost,usesSpellSlot:e.usesSpellSlot,homebrew:e.definition.isHomebrew}}},1===this.ddb.character.spells.feat.filter((t=>t.definition&&t.definition.name===e.definition.name)).length&&this.handleGrantedSpells(e,"feat"),!this.canCast(e))continue;const o=await r.A.parseSpell(e,this.character,{ddbData:this.ddb,namePostfix:`${this._getSpellCount(e.definition.name)}`,generateSummons:this.generateSummons});this.processed.push(o)}}async getBackgroundSpells(){this.ddb.character.spells.background||(this.ddb.character.spells.background=[]);for(const e of this.ddb.character.spells.background){if(!e.definition)continue;let t="wis";(0,s.m9)(e.spellCastingAbilityId)&&(t=(0,s.cu)(e.spellCastingAbilityId));const a=i.utils.calculateModifier(this.characterAbilities[t].value);if(e.flags={ddbimporter:{dndbeyond:{lookup:"background",lookupName:"Background",level:e.castAtLevel,ability:t,mod:a,dc:8+this.proficiencyModifier+a,overrideDC:!1,id:e.id,entityTypeId:e.entityTypeId,healingBoost:this.healingBoost,usesSpellSlot:e.usesSpellSlot,homebrew:e.definition.isHomebrew}}},1===this.ddb.character.spells.background.filter((t=>t.definition&&t.definition.name===e.definition.name)).length&&this.handleGrantedSpells(e,"background"),!this.canCast(e))continue;const n=await r.A.parseSpell(e,this.character,{ddbData:this.ddb,namePostfix:`${this._getSpellCount(e.definition.name)}`,generateSummons:this.generateSummons});this.processed.push(n)}}async getCharacterSpells(){return await this.getClassSpells(),await this.getSpecialClassSpells(),await this.getRaceSpells(),await this.getFeatSpells(),await this.getBackgroundSpells(),this.processed.sort(((e,t)=>e.name.localeCompare(t.name)))}}var d=a(410);class DDBClass{static SPECIAL_ADVANCEMENTS={"Wild Shape":{fix:!0,fixFunction:d.A.rename,functionArgs:{newName:"Wild Shape CR"},additionalAdvancements:!1,additionalFunctions:[]}};static NO_ADVANCEMENT_2014=["rage"];static NO_ADVANCEMENT_2024=[];static NOT_ADVANCEMENT_FOR_FEATURE=[];static PROFICIENCY_FEATURES=["Core Barbarian Traits","Core Bard Traits","Core Cleric Traits","Core Druid Traits","Core Fighter Traits","Core Monk Traits","Core Paladin Traits","Core Ranger Traits","Core Rogue Traits","Core Sorcerer Traits","Core Warlock Traits","Core Wizard Traits","Proficiencies","Primal Knowledge","Master of Intrigue","Implements of Mercy","Bonus Proficiencies","Otherworldly Glamour","Survivalist","Training in War and Song","Blessings of Knowledge","Elegant Courtier"];static EXPERTISE_FEATURES=["Expertise","Canny","Deft Explorer","Survivalist","Blessings of Knowledge"];static PROFICIENCY_OR_EXPERTISE_FEATURES=["Mystical Erudition","Mystical Erudition (Additional)"];static LANGUAGE_FEATURES=["Proficiencies","Primal Knowledge","Master of Intrigue","Thieves' Cant","Druidic","Giant's Power","Blessings of Knowledge","Mystical Erudition","Draconic Disciple","Tongue of Dragons","Wind Speaker","Master of Intrigue","Favored Enemy","Deft Explorer","Canny","Draconic Gift","Speech of the Woods"];static LANGUAGE_OR_SKILL_FEATURE=["Bonus Proficiency"];static TOOL_FEATURES=["Core Barbarian Traits","Core Bard Traits","Core Cleric Traits","Core Druid Traits","Core Fighter Traits","Core Monk Traits","Core Paladin Traits","Core Ranger Traits","Core Rogue Traits","Core Sorcerer Traits","Core Warlock Traits","Core Wizard Traits","Proficiencies","Tool Proficiency","Tools of the Trade","Student of War","Gunsmith","Implements of Mercy","Master of Intrigue"];static ARMOR_FEATURES=["Core Barbarian Traits","Core Bard Traits","Core Cleric Traits","Core Druid Traits","Core Fighter Traits","Core Monk Traits","Core Paladin Traits","Core Ranger Traits","Core Rogue Traits","Core Sorcerer Traits","Core Warlock Traits","Core Wizard Traits","Proficiencies","Tools of the Trade","Training in War and Song"];static WEAPON_FEATURES=["Core Barbarian Traits","Core Bard Traits","Core Cleric Traits","Core Druid Traits","Core Fighter Traits","Core Monk Traits","Core Paladin Traits","Core Ranger Traits","Core Rogue Traits","Core Sorcerer Traits","Core Warlock Traits","Core Wizard Traits","Proficiencies","Firearm Proficiency","Training in War and Song"];static WEAPON_MASTERY_FEATURES=["Barbarian Weapon Masteries","Bard Weapon Masteries","Cleric Weapon Masteries","Druid Weapon Masteries","Fighter Weapon Masteries","Monk Weapon Masteries","Paladin Weapon Masteries","Ranger Weapon Masteries","Rogue Weapon Masteries","Sorcerer Weapon Masteries","Warlock Weapon Masteries","Wizard Weapon Masteries","Weapon Mastery","Weapon Masteries"];static CONDITION_FEATURES=["Inured to Undeath","Elemental Gift","Thought Shield","Necrotic Husk","Radiant Soul","Oceanic Soul","Fathomless Soul","Psychic Defenses","Heart of the Storm","Wind Soul","Beguiling Defenses","Emissary of Redemption","Aura of Warding","Supernatural Resistance","Guarded Mind","Soul of the Forge","Avatar of Battle","Saint of Forge and Fire","Divine Health","Purity of Body","Storm Soul","Chemical Mastery","Poison Resilience","Poison Immunity","Constructed Resilience","Natural Resilience","Mechanical Nature","Acid Resistance","Necrotic Resistance","Mountain Born","Fire Resistance","Psychic Resilience","Gnomish Magic Resistance","Dwarven Resilience","Lightning Resistance","Celestial Resistance","Draconic Resistance","Hellish Resistance","Magic Resistance"];_generateSource(){const e=i.DDBSources.parseSource(this.ddbClassDefinition);this.data.system.source=e,this.data.system.source.rules=this.is2014?"2014":"2024"}_fleshOutCommonDataStub(){this.data.system.identifier=l.DDBDataUtils.classIdentifierName(this.ddbClassDefinition.name),this._determineClassFeatures(),this._proficiencyFeatureIds=this.classFeatures.filter((e=>DDBClass.PROFICIENCY_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._proficiencyFeatures=this.classFeatures.filter((e=>this._proficiencyFeatureIds.includes(e.id))),this._expertiseFeatureIds=this.classFeatures.filter((e=>DDBClass.EXPERTISE_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._expertiseFeatures=this.classFeatures.filter((e=>this._expertiseFeatureIds.includes(e.id))),this._languageFeatureIds=this.classFeatures.filter((e=>DDBClass.LANGUAGE_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._languageFeatures=this.classFeatures.filter((e=>this._languageFeatureIds.includes(e.id))),this._toolFeatureIds=this.classFeatures.filter((e=>DDBClass.TOOL_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._toolFeatures=this.classFeatures.filter((e=>this._toolFeatureIds.includes(e.id))),this._armorFeatureIds=this.classFeatures.filter((e=>DDBClass.ARMOR_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._armorFeatures=this.classFeatures.filter((e=>DDBClass.ARMOR_FEATURES.includes(i.utils.nameString(e.name)))),this._weaponFeatureIds=this.classFeatures.filter((e=>DDBClass.WEAPON_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._weaponFeatures=this.classFeatures.filter((e=>DDBClass.WEAPON_FEATURES.includes(i.utils.nameString(e.name)))),this._weaponMasteryFeatureIds=this.classFeatures.filter((e=>DDBClass.WEAPON_MASTERY_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._weaponMasteryFeatures=this.classFeatures.filter((e=>DDBClass.WEAPON_MASTERY_FEATURES.includes(i.utils.nameString(e.name)))),this._languageOrSkillFeatureIds=this.classFeatures.concat(this._languageFeatures).filter((e=>DDBClass.LANGUAGE_OR_SKILL_FEATURE.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._languageOrSkillFeatures=this.classFeatures.filter((e=>DDBClass.LANGUAGE_OR_SKILL_FEATURE.includes(i.utils.nameString(e.name)))),this._conditionFeatureIds=this.classFeatures.filter((e=>DDBClass.CONDITION_FEATURES.includes(i.utils.nameString(e.name)))).map((e=>e.id)),this._conditionFeatures=this.classFeatures.filter((e=>DDBClass.CONDITION_FEATURES.includes(i.utils.nameString(e.name)))),this._generateSource()}_generateDataStub(){this.data={_id:foundry.utils.randomID(),name:this.ddbClass.definition.name,type:"class",system:l.SystemHelpers.getTemplate("class"),flags:{ddbimporter:{class:this.ddbClass.definition.name,id:this.ddbClass.id,definitionId:this.ddbClass.definition.id,entityTypeId:this.ddbClass.entityTypeId,type:"class",isStartingClass:this.ddbClass.isStartingClass,ddbImg:this.ddbClass.definition.portraitAvatarUrl,is2014:this.is2014,is2024:!this.is2014,legacy:this.legacy}},img:null}}_generateSpellCastingProgression(){if(this.ddbClassDefinition.canCastSpells){const e=o.x.spell.progression.find((e=>e.name===this.ddbClass.definition.name)),t=(0,s.s6)(this.ddbClass,this._isSubClass,this._isSubClass);if(e){this.data.system.spellcasting={progression:e.value,ability:t};let a="";(this.ddbClassDefinition.spellRules?.levelPreparedSpellMaxes??[]).filter((e=>e)).length>1?a=`@scale.${this.data.system.identifier}.max-prepared`:1===this.ddbClassDefinition.spellPrepareType&&(a=`max(@abilities.${t}.mod + @classes.${this.data.system.identifier}.levels, 1)`),this.data.system.spellcasting.preparation={formula:a}}const a=this.ddbClassDefinition.spellRules?.multiClassSpellSlotDivisor?this.ddbClassDefinition.spellRules.multiClassSpellSlotDivisor:void 0;this.data.flags.ddbimporter.spellSlotDivisor=a,this.data.flags.ddbimporter.spellCastingAbility=t}}async _buildCompendiumIndex(e,t={}){Object.keys(t).length>0&&(this._indexFilter[e]=t),this._compendiums[e]&&await this._compendiums[e].getIndex(this._indexFilter[e])}async _generateDescriptionStub(e){this.data.system.description.value="<h1>Description</h1>",this.data.system.description.value+=this.ddbClass.definition.description,this.data.system.description.value+=await this._buildClassFeaturesDescription(),this.ddbClass.definition.equipmentDescription&&!this._isSubClass&&this.is2014&&(this.data.system.description.value+=`<h1>Starting Equipment</h1>\n${this.ddbClass.definition.equipmentDescription}\n\n`),e&&(this.data.system.description.value=l.DDBTemplateStrings.parse(this.ddbData,e,this.data.system.description.value,this.data).text)}constructor(e,t,{noMods:a=!1,addToCompendium:n=null}={}){this._indexFilter={features:{fields:["name","flags.ddbimporter.classId","flags.ddbimporter.class","flags.ddbimporter.subClass","flags.ddbimporter.parentClassId","flags.ddbimporter.originalName","flags.ddbimporter.featureMeta"]},feats:{fields:["name","flags.ddbimporter","flags.ddbimporter.featureMeta"]},class:{},subclasses:{}},this.addToCompendium=n??!1,this.rules="2014",this.ddbData=e,this.ddbClass=e.character.classes.find((e=>e.definition.id===t)),this.ddbClassDefinition=this.ddbClass.definition;const s=this.ddbClassDefinition.sources.map((e=>e.sourceId));this.legacy=CONFIG.DDB.sources.some((e=>s.includes(e.id)&&o.x.sourceCategories.legacy.includes(e.sourceCategoryId))),this.is2014=this.ddbClassDefinition.sources.some((e=>Number.isInteger(e.sourceId)&&e.sourceId<145)),this.classFeatureIds=this.ddbClass.definition.classFeatures.map((e=>e.id)),this.subClassFeatureIds=this.ddbClass.subclassDefinition&&this.ddbClass.subclassDefinition.name?this.ddbClass.classFeatures.filter((e=>e.definition.classId===this.ddbClass.subclassDefinition.id)).map((e=>e.definition.id)):[],this._compendiums={features:i.CompendiumHelper.getCompendiumType("classfeatures",!1),feats:i.CompendiumHelper.getCompendiumType("feats",!1),class:i.CompendiumHelper.getCompendiumType("class",!1),subclasses:i.CompendiumHelper.getCompendiumType("subclasses",!1)},this._advancementMatches={features:{}},this._isSubClass=!1,this._generateDataStub(),this.options={noMods:a},this.dictionary=o.x.actor.class.find((e=>e.name===this.ddbClassDefinition.name))??{multiclassSkill:0},this.advancementHelper=new d.A({ddbData:e,type:"class",noMods:this.options.noMods}),this.SPECIAL_ADVANCEMENTS=DDBClass.SPECIAL_ADVANCEMENTS,this.NOT_ADVANCEMENT_FOR_FEATURE=DDBClass.NOT_ADVANCEMENT_FOR_FEATURE,this.NO_ADVANCEMENT_2014=DDBClass.NO_ADVANCEMENT_2014,this.NO_ADVANCEMENT_2024=DDBClass.NO_ADVANCEMENT_2024,this.isStartingClass=this.ddbClass.isStartingClass}_determineClassFeatures(){this._excludedFeatureIds=this._isSubClass?this.classFeatureIds:this.subClassFeatureIds,this.classFeatures=this.getClassFeatures(this._excludedFeatureIds)}isMartialArtist(){return this.classFeatures.some((e=>"Martial Arts"===e.name))}getClassFeatures(e=[]){const t=this.ddbData.character.optionalClassFeatures.filter((e=>e.affectedClassFeatureId)).map((e=>e.affectedClassFeatureId)),a=this.ddbData.classOptions?this.ddbData.classOptions.filter((t=>t.classId===this.ddbClassDefinition.id&&!e.includes(t.id))):[];return this.ddbClass.classFeatures.filter((a=>!t.includes(a.definition.id)&&!e.includes(a.definition.id)&&a.definition.classId===this.ddbClassDefinition.id)).map((e=>e.definition)).concat(a).sort(((e,t)=>e.displayOrder-t.displayOrder)).sort(((e,t)=>e.requiredLevel-t.requiredLevel))}getFeatureCompendiumMatch(e){return this._compendiums.features?this._compendiums.features.index.find((t=>{const a=foundry.utils.getProperty(t,"flags.ddbimporter.featureMeta")??foundry.utils.getProperty(t,"flags.ddbimporter");if(!a)return!1;const i=foundry.utils.getProperty(a,"originalName")?.trim().toLowerCase(),n=i&&i==e.name.trim().toLowerCase();if(!(!n&&t.name.trim().toLowerCase()==e.name.trim().toLowerCase())&&!n)return!1;const s=!this._isSubClass&&a.class==this.ddbClassDefinition.name&&a.classId==this.ddbClassDefinition.id,r=this._isSubClass&&a.subClass===this.ddbClassDefinition.name&&a.subClassId==this.ddbClassDefinition.id;return s||r})):[]}getFeatCompendiumMatch(e){if(!this._compendiums.feats)return[];const t=e.trim().toLowerCase();return this._compendiums.feats.index.find((e=>foundry.utils.hasProperty(e,"flags.ddbimporter.originalName")&&t==e.flags.ddbimporter.originalName.trim().toLowerCase()||!foundry.utils.hasProperty(e,"flags.ddbimporter.originalName")&&(t==e.name.trim().toLowerCase()||t.split(":")[0].trim()==e.name.trim().toLowerCase())))}async _buildClassFeaturesDescription(){i.logger.debug(`Parsing ${this.ddbClassDefinition.name} features`);let e="<h1>Class Features</h1>\n\n",t=[];return this.classFeatures.forEach((a=>{if(!t.some((e=>e===a.name))&&!this._excludedFeatureIds.includes(a.id)){const i=this.getFeatureCompendiumMatch(a),n=/^\d+/.test(a.name)?a.name:`${a.requiredLevel}: ${a.name}`,s=i?.uuid?`<p><b>@UUID[${i.uuid}]{Level ${n}}</b></p>`:`<p><b>Level ${n}</b></p>`;e+=`${s}\n${a.description}\n\n`,t.push(a.name)}})),e}_generateHitDice(){foundry.utils.isNewerVersion("4.2.0",game.system.version)?(this.data.system.hitDice=`d${this.ddbClass.definition.hitDice}`,this.data.system.hitDiceUsed=this.ddbClass.hitDiceUsed):this.data.system.hd={denomination:`d${this.ddbClass.definition.hitDice}`,value:this.ddbClass.hitDiceUsed}}_setClassLevel(){this.data.system.levels=this.ddbClass.level}static EXCLUDED_FEATURE_ADVANCEMENTS=["4: Ability Score Improvement","6: Ability Score Improvement","8: Ability Score Improvement","12: Ability Score Improvement","14: Ability Score Improvement","16: Ability Score Improvement","Ability Score Improvement","Expertise","Bonus Proficiencies","Bonus Proficiency","Tool Proficiency","Weapon Mastery","Speed","Size","Feat","Languages","Hit Points","Proficiencies","Martial Versatility"];static EXCLUDED_FEATURE_ADVANCEMENTS_2014=["Primal Knowledge"];featureAdvancements=[];async _generateFeatureAdvancementFromCompendiumMatch(e){const t=this.getFeatureCompendiumMatch(e);if(!t)return;const a=this.featureAdvancements.findIndex((t=>t.level===e.requiredLevel));if(-1==a){const a=new game.dnd5e.documents.advancement.ItemGrantAdvancement;this._advancementMatches.features[a._id]={},this._advancementMatches.features[a._id][t.name]=t.uuid;const i={configuration:{items:[{uuid:t.uuid}]},value:{},level:e.requiredLevel??0,title:"Features",icon:"",classRestriction:""};a.updateSource(i),this.featureAdvancements.push(a.toObject())}else this.featureAdvancements[a].configuration.items.push({uuid:t.uuid,optional:!1}),this._advancementMatches.features[this.featureAdvancements[a]._id][t.name]=t.uuid}async _generateFeatureAdvancements(){i.logger.debug(`Parsing ${this.ddbClass.definition.name} features for advancement`),this.featureAdvancements=[];const e=this.classFeatures.filter((e=>!DDBClass.EXCLUDED_FEATURE_ADVANCEMENTS.includes(e.name)||this.is2014&&DDBClass.EXCLUDED_FEATURE_ADVANCEMENTS_2014.includes(e.name)));for(const t of e)await this._generateFeatureAdvancementFromCompendiumMatch(t);this.data.system.advancement=this.data.system.advancement.concat(this.featureAdvancements)}_generateScaleValueAdvancementsFromFeatures(){let e=[];const t=this.classFeatures.filter((e=>e.levelScales?.length>0)).filter((e=>!this.NOT_ADVANCEMENT_FOR_FEATURE.includes(e.name))).map((t=>{let a=d.A.generateScaleValueAdvancement(t);const i=this.SPECIAL_ADVANCEMENTS[a.title];return i&&(i.additionalAdvancements&&i.additionalFunctions.forEach((t=>{e.push(t(a))})),i.fixFunction&&(a=i.fixFunction(a,i.functionArgs)),i.fixFunctions&&i.fixFunctions.forEach((e=>{a=e.fn(a,e.args)}))),a})).filter((e=>this.is2014&&!this.NO_ADVANCEMENT_2014.includes(e.configuration?.identifier)||!this.is2014&&!this.NO_ADVANCEMENT_2024.includes(e.configuration?.identifier)));this.data.system.advancement=this.data.system.advancement.concat(t,e)}_generateScaleValueSpellAdvancements(){if(this.ddbClassDefinition.spellRules){if(this.ddbClassDefinition.spellRules.levelPreparedSpellMaxes&&this.ddbClassDefinition.spellRules.levelPreparedSpellMaxes.filter((e=>e)).length>1){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"max-prepared",type:"number",scale:{}},value:{},title:"Maximum Prepared Spells",icon:null};this.ddbClassDefinition.spellRules.levelPreparedSpellMaxes.forEach(((t,a)=>{0!==a&&(e.configuration.scale[a]={value:t})})),this.data.system.advancement.push(e)}if(this.ddbClassDefinition.spellRules.levelCantripsKnownMaxes){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"cantrips-known",type:"number",scale:{}},value:{},title:"Cantrips Known",icon:null};this.ddbClassDefinition.spellRules.levelCantripsKnownMaxes.forEach(((t,a)=>{0!==a&&(e.configuration.scale[a]={value:t})})),this.data.system.advancement.push(e)}if(this.ddbClassDefinition.spellRules.levelSpellKnownMaxes){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"spells-known",type:"number",scale:{}},value:{},title:"Spells Known",icon:null};this.ddbClassDefinition.spellRules.levelSpellKnownMaxes.forEach(((t,a)=>{0!==a&&(e.configuration.scale[a]={value:t})})),this.data.system.advancement.push(e)}}}_generateHTMLSaveAdvancement(){this.data.system.advancement=this.data.system.advancement.concat([])}_generateSaveAdvancement(e,t,a){const i={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:a,availableToMulticlass:t,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},n=l.DDBModifiers.getChosenClassModifiers(this.ddbData,i);return d.A.getSaveAdvancement(n,t,a)}_generateSaveAdvancements(){if(this.options.noMods)return void this._generateHTMLSaveAdvancement();const e=[];for(let t=0;t<=20;t++)[!0,!1].forEach((a=>{if(!a&&t>1)return;const i=this._proficiencyFeatures.filter((e=>e.requiredLevel===t));for(const n of i){const i=this._generateSaveAdvancement(n,a,t);i&&e.push(i.toObject())}}));this.data.system.advancement=this.data.system.advancement.concat(e)}_generateSkillAdvancement(e,t,a){const i={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:a,availableToMulticlass:!1!==t||null,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},n=this.options.noMods?[]:l.DDBModifiers.getChosenClassModifiers(this.ddbData,i),s=n.filter((e=>"proficiency"===e.type&&o.x.actor.skills.map((e=>e.subType)).includes(e.subType))),r={subType:`choose-a-${this.ddbClassDefinition.name.toLowerCase()}-skill`},d=l.DDBModifiers.filterModifiers(n,"proficiency",r).concat(s);return this.advancementHelper.getSkillAdvancement(d,e,t,a,this.dictionary.multiclassSkill)}_generateSkillAdvancements(){const e=[];for(let t=0;t<=20;t++)[!0,!1].forEach((a=>{if(!a&&t>1)return;if(this._isSubClass&&!a)return;const i=this._proficiencyFeatures.filter((e=>e.requiredLevel===t));for(const n of i){const i="Proficiencies"===n.name||n.name.startsWith("Core")&&n.name.endsWith("Traits");if(a&&i&&0===this.dictionary.multiclassSkill)continue;const s=this._generateSkillAdvancement(n,a,t);s&&e.push(s.toObject())}}));this.data.system.advancement=this.data.system.advancement.concat(e)}_generateLanguageAdvancement(e,t){const a={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:t,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},i=this.options.noMods?[]:l.DDBModifiers.getChosenClassModifiers(this.ddbData,a);return this.advancementHelper.getLanguageAdvancement(i,e,t)}_generateLanguageAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._languageFeatures.filter((e=>e.requiredLevel===t));for(const i of a){const a=this._generateLanguageAdvancement(i,t);a&&e.push(a.toObject())}}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateSkillOrLanguageAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._languageOrSkillFeatures.filter((e=>e.requiredLevel===t));for(const n of a){const a=this._generateSkillAdvancement(n,!0,t),s=this._generateLanguageAdvancement(n,t);if(a&&s&&a.configuration.choices.length>0){const t=a.toObject();t.configuration.choices[0].pool.push(...s.toObject().configuration.choices[0].pool),e.push(t)}else i.logger.error("Failed Skill or Lanugage Advancement Generation",{i:t,feature:n,skillAdvancement:a,languageAdvancement:s})}}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateToolAdvancement(e,t){const a={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:t,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},i=this.options.noMods?[]:l.DDBModifiers.getChosenClassModifiers(this.ddbData,a);return this.advancementHelper.getToolAdvancement(i,e,t)}_generateToolAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._toolFeatures.filter((e=>e.requiredLevel===t));for(const i of a){const a=this._generateToolAdvancement(i,t);a&&e.push(a.toObject())}}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateArmorAdvancement(e,t,a){const i={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:a,availableToMulticlass:!1!==t||null,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},n=this.options.noMods?[]:l.DDBModifiers.getChosenClassModifiers(this.ddbData,i);return this.advancementHelper.getArmorAdvancement(n,e,t,a)}_generateArmorAdvancements(){const e=[];for(let t=0;t<=20;t++)[!0,!1].forEach((a=>{if(!a&&t>1)return;if(this._isSubClass&&!a)return;const i=this._armorFeatures.filter((e=>e.requiredLevel===t));for(const n of i){const i=this._generateArmorAdvancement(n,a,t);i&&e.push(i.toObject())}}));this.data.system.advancement=this.data.system.advancement.concat(e)}_generateWeaponAdvancement(e,t){const a={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:t,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},i=this.options.noMods?[]:l.DDBModifiers.getChosenClassModifiers(this.ddbData,a);return this.advancementHelper.getWeaponAdvancement(i,e,t)}_generateWeaponAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._weaponFeatures.filter((e=>e.requiredLevel===t));for(const i of a){const a=this._generateWeaponAdvancement(i,t);a&&e.push(a.toObject())}}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateWeaponMasteryAdvancement(e,t){const a={type:"feat",includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:t,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},i=this.options.noMods?[]:l.DDBModifiers.getChosenTypeModifiers(this.ddbData,a);return this.advancementHelper.getWeaponMasteryAdvancement(i,e,t)}_generateWeaponMasteryAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._weaponMasteryFeatures.filter((e=>e.requiredLevel===t));for(const i of a){const a=this._generateWeaponMasteryAdvancement(i,t);a&&e.push(a.toObject())}}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateExpertiseAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._expertiseFeatures.find((e=>e.requiredLevel===t));if(!a)continue;const i=this.advancementHelper.getExpertiseAdvancement(a,t);i&&e.push(i.toObject())}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateConditionAdvancement(e,t){const a={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:t,useUnfilteredModifiers:!0,filterOnFeatureIds:[e.id]},i=this.options.noMods?[]:l.DDBModifiers.getChosenClassModifiers(this.ddbData,a);return this.advancementHelper.getConditionAdvancement(i,e,t)}_generateConditionAdvancements(){const e=[];for(let t=0;t<=20;t++){const a=this._conditionFeatures.filter((e=>e.requiredLevel===t));for(const i of a){const a=this._generateConditionAdvancement(i,t);a&&e.push(a.toObject())}}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateHPAdvancement(e){const t={},a=foundry.utils.getProperty(e,"flags.ddbimporter.rolledHP")??!1,i=!0===foundry.utils.getProperty(this.data,"flags.ddbimporter.isStartingClass"),n=game.settings.get("ddb-importer","character-update-policy-use-hp-max-for-rolled-hp");if(a&&!n){const a=foundry.utils.getProperty(e,"flags.ddbimporter.baseHitPoints"),n=foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.totalLevels"),s=Math.floor(a/n),r=Math.floor(a%n);for(let e=1;e<=this.data.system.levels;e++)t[`${e}`]=1===e&&i?s+r:s}else for(let e=1;e<=this.data.system.levels;e++)t[`${e}`]=1===e&&i?"max":"avg";const s=new game.dnd5e.documents.advancement.HitPointsAdvancement;s.updateSource({value:t}),this.data.system.advancement.push(s.toObject())}async _addFoundryAdvancements(){const e=this.is2014?o.y.FOUNDRY_COMPENDIUM_MAP.classes:o.y.FOUNDRY_COMPENDIUM_MAP.classes2024;for(const t of e){const e=i.CompendiumHelper.getCompendium(t,!1);if(!e)continue;await e.getIndex();const a=e.index.find((e=>e.name===this.ddbClassDefinition.name&&"class"===e.type));if(!a)continue;const n=(await e.getDocument(a._id)).system.advancement.filter((e=>"ScaleValue"===e.type&&!this.data.system.advancement.some((t=>t.configuration.identifier===e.configuration.identifier)))).map((e=>e.toObject()));return void this.data.system.advancement.push(...n)}}_generateAbilityScoreAdvancement(){const e=[];for(let t=0;t<=20;t++){const a=this.classFeatures.find((e=>e.name.includes("Ability Score Improvement")&&e.requiredLevel===t));if(!a)continue;const n=new game.dnd5e.documents.advancement.AbilityScoreImprovementAdvancement;n.updateSource({configuration:{points:2},level:t,value:{type:"asi"}});const s={includeExcludedEffects:!0,classId:this.ddbClassDefinition.id,exactLevel:t,useUnfilteredModifiers:!0},r=l.DDBModifiers.getChosenClassModifiers(this.ddbData,s),d={};if(o.x.actor.abilities.forEach((e=>{const t=l.DDBModifiers.filterModifiers(r,"bonus",{subType:`${e.long}-score`}).length;t>0&&(d[e.value]=t)})),Object.keys(d).length>0)n.updateSource({value:{assignments:d}});else if(a.requiredLevel<=this.ddbClass.level){n.updateSource({value:{type:"feat",feat:{}}});const e=this.ddbData.character.feats.find((e=>e.componentId==a.id&&e.componentTypeId==a.entityTypeId)),t=e?this.getFeatCompendiumMatch(e.definition.name):null;t?(this._advancementMatches.features[n._id]={},this._advancementMatches.features[n._id][t.name]=t.uuid):i.logger.info("Missing asi feat linking match for",{abilityAdvancementFeature:a,featChoice:e,this:this})}e.push(n.toObject())}this.data.system.advancement=this.data.system.advancement.concat(e)}_generateWealth(){if(!this.ddbClassDefinition.wealthDice)return;const e=this.ddbClassDefinition.wealthDice.diceString,t=this.ddbClassDefinition.wealthDice.diceMultiplier;this.data.system.wealth=t&&e?`${e}*${t}`:""}async _copyFoundryEquipment(){const e=this.is2014?o.y.FOUNDRY_COMPENDIUM_MAP.classes:o.y.FOUNDRY_COMPENDIUM_MAP.classes2024;for(const t of e){const e=i.CompendiumHelper.getCompendium(t,!1);if(!e)continue;await e.getIndex();const a=e.index.find((e=>e.name===this.ddbClassDefinition.name&&"class"===e.type));if(!a)continue;const n=await e.getDocument(a._id),s=foundry.utils.duplicate(n.system.startingEquipment);return void(this.data.system.startingEquipment=s)}}async _generateCommonAdvancements(){this._generateScaleValueAdvancementsFromFeatures(),await this._generateFeatureAdvancements(),this._generateSaveAdvancements(),this._generateSkillAdvancements(),this._generateExpertiseAdvancements(),this._generateLanguageAdvancements(),this._generateToolAdvancements(),this._generateArmorAdvancements(),this._generateWeaponAdvancements(),this._generateWeaponMasteryAdvancements(),this._generateSkillOrLanguageAdvancements(),this._generateConditionAdvancements(),this._generateSpellCastingProgression(),this._generateScaleValueSpellAdvancements()}_fixes(){if("Druid"===this.data.name){for(let e of this.data.system.advancement)"Wild Shape CR"===e.title&&(e.configuration.type="cr",e.configuration.scale={2:{value:.25},4:{value:.5},8:{value:1}});if(this.is2014){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"wild-shape-uses",type:"number",scale:{2:{value:2},20:{value:99}}},value:{},title:"Wild Shape Uses",icon:null};this.data.system.advancement.push(e)}else{const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"wild-shape-uses",type:"number",scale:{2:{value:2},6:{value:3},17:{value:4}}},value:{},title:"Wild Shape Uses",icon:null};this.data.system.advancement.push(e);const t={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"elemental-fury",type:"dice",scale:{7:{number:1,faces:8},18:{number:2,faces:8}}},value:{},title:"Elemental Fury Damage",icon:null};this.data.system.advancement.push(t);const a={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"known-forms",type:"number",scale:{2:{value:4},4:{value:6},8:{value:8}}},value:{},title:"Known Forms",icon:null};this.data.system.advancement.push(a)}}else if("Monk"===this.data.name){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:this.is2014?"ki-points":"focus-points",type:"number",scale:{}},value:{},title:this.is2014?"Ki Points":"Focus Points",icon:null};i.utils.arrayRange(19,1,2).forEach((t=>{e.configuration.scale[t]={value:t}})),this.data.system.advancement.push(e)}else if("Rogue"!==this.data.name||this.is2014){if("Barbarian"===this.data.name&&!this.is2014){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"rage-damage",type:"number",scale:{1:{value:2},9:{value:3},16:{value:4}}},value:{},title:"Rage Damage",icon:null};this.data.system.advancement.push(e);for(let e of this.data.system.advancement)"Rage"===e.title&&(e.title="Rages",e.configuration.identifier="rages")}}else{const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"cunning-strike-uses",type:"number",scale:{5:{value:1},11:{value:2}}},value:{},title:"Cunning Strike Uses",icon:null};this.data.system.advancement.push(e);const t={type:"ScaleValue",configuration:{distance:{units:""},identifier:"sneak-attack",type:"dice",scale:{1:{number:1,faces:6},3:{number:2,faces:6},5:{number:3,faces:6},7:{number:4,faces:6},9:{number:5,faces:6},11:{number:6,faces:6},13:{number:7,faces:6},15:{number:8,faces:6},17:{number:9,faces:6},19:{number:10,faces:6}}},value:{},title:"Sneak Attack",icon:null};this.data.system.advancement.push(t)}}_generatePrimaryAbility(){this.data.system.primaryAbility={value:this.ddbClassDefinition.primaryAbilities.map((e=>o.x.actor.abilities.id===e))?.value,all:!1}}async _addToCompendium(){if(!this.addToCompendium)return;if(20!==this.ddbClass.level)return;const e=game.settings.get(o.y.MODULE_ID,"character-update-policy-update-add-features-to-compendiums"),t=this._isSubClass?"subclass":"class",a=new i.DDBCompendiumFolders(t,{noCreateClassFolders:!0});await a.loadCompendium(t),this._isSubClass?await a.createSubClassFeatureFolder(this.ddbClassDefinition.name,this.ddbClass.definition.name):await a.createClassFeatureFolder(this.ddbClassDefinition.name);const n=await i.DDBItemImporter.buildHandler(t,[foundry.utils.deepClone(this.data)],e,{chrisPremades:!1,removeSRDDuplicates:!1,filterDuplicates:!1,deleteBeforeUpdate:!1,useCompendiumFolders:!0,notifier:null});await n.buildIndex()}async generateFromCharacter(e){await this._buildCompendiumIndex("features"),this._setClassLevel(),this._generatePrimaryAbility(),this._fleshOutCommonDataStub(),this._generateHPAdvancement(e),await this._generateCommonAdvancements(),this._generateHitDice(),this._generateAbilityScoreAdvancement(),this._generateWealth(),this._copyFoundryEquipment(),await this._generateDescriptionStub(e),this._fixes(),await this._addFoundryAdvancements(),await this._addToCompendium()}}class DDBSubClass extends DDBClass{static SPECIAL_ADVANCEMENTS={"Combat Superiority":{fix:!0,fixFunction:d.A.renameTotal,additionalAdvancements:!0,additionalFunctions:[d.A.addAdditionalUses,d.A.addSingularDie]},"Rune Carver":{fix:!0,fixFunction:d.A.renameTotal,additionalAdvancements:!1,additionalFunctions:[]},"Psionic Power":{fix:!0,fixFunction:d.A.rename,functionArgs:{newName:"Energy Die",identifier:"energy-die"},additionalAdvancements:!1,additionalFunctions:[]}};static NOT_ADVANCEMENT_FOR_FEATURE=["Soul Blades"];static NO_ADVANCEMENT_2014=[];static NO_ADVANCEMENT_2024=[];_fleshOutCommonDataStub(){super._fleshOutCommonDataStub(),this.data.system.classIdentifier=l.DDBDataUtils.classIdentifierName(this.ddbClass.definition.name)}_generateDataStub(){this.data={_id:foundry.utils.randomID(),name:this.ddbClass.subclassDefinition.name,type:"subclass",system:l.SystemHelpers.getTemplate("subclass"),flags:{ddbimporter:{class:this.ddbClass.definition.name,subclass:this.ddbClass.subclassDefinition.name,subclassDefinitionId:this.ddbClass.id,id:this.ddbClass.subclassDefinition.id,type:"class",ddbImg:this.ddbClass.subclassDefinition.portraitAvatarUrl??this.ddbClass.definition.portraitAvatarUrl,is2014:this.is2014,is2024:!this.is2014}},img:null}}constructor(e,t,a={}){super(e,t,a),this.ddbClassDefinition=this.ddbClass.subclassDefinition,this._isSubClass=!0,this.SPECIAL_ADVANCEMENTS=DDBSubClass.SPECIAL_ADVANCEMENTS,this.NOT_ADVANCEMENT_FOR_FEATURE=DDBSubClass.NOT_ADVANCEMENT_FOR_FEATURE,this.NO_ADVANCEMENT_2014=DDBSubClass.NO_ADVANCEMENT_2014,this.NO_ADVANCEMENT_2024=DDBSubClass.NO_ADVANCEMENT_2024}_fixes(){if(this.data.name.startsWith("Order of the Profane Soul")){this.data.name="Order of the Profane Soul";const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"pact-slots",type:"number",scale:{3:{value:1},6:{value:2}}},value:{},title:"Pact Slots",icon:null},t={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"pact-level",type:"number",scale:{3:{value:1},7:{value:2},13:{value:3}}},value:{},title:"Pact Level",icon:null};this.data.system.advancement.push(e,t)}else if(this.data.name.startsWith("Path of the Storm Herald")){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"storm-aura-desert",type:"number",scale:{3:{value:2},5:{value:3},10:{value:4},15:{value:5},20:{value:6}}},value:{},title:"Storm Aura Desert",icon:null},t={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"storm-aura-sea",type:"dice",scale:{3:{number:1,faces:6},10:{number:2,faces:6},15:{number:3,faces:6},20:{number:4,faces:6}}},value:{},title:"Storm Aura Sea",icon:null},a={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"storm-aura-tundra",type:"number",scale:{3:{value:2},5:{value:3},10:{value:4},15:{value:5},20:{value:6}}},value:{},title:"Storm Aura Tundra",icon:null};this.data.system.advancement.push(e,t,a)}else if(this.data.name.startsWith("Circle of the Moon")){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"wild-shape-cr",type:"cr",scale:{6:{value:2},9:{value:3},12:{value:4},15:{value:5},18:{value:6}}},value:{},title:"Wild Shape CR",icon:null};this.is2014?e.configuration.scale[2]={value:1}:e.configuration.scale[3]={value:1},this.data.system.advancement.push(e)}else if(this.data.name.startsWith("Circle of the Land")&&!this.is2014){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"lands-aid",type:"dice",scale:{3:{number:2,faces:6},10:{number:3,faces:6},14:{number:4,faces:6}}},value:{},title:"Lands Aid Dice",icon:null};this.data.system.advancement.push(e)}else if(this.data.name.startsWith("Circle of the Stars")&&!this.is2014){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"starry-form",type:"dice",scale:{3:{number:1,faces:8},10:{number:2,faces:8}}},value:{},title:"Starry Form Dice",icon:null};this.data.system.advancement.push(e)}else if(!this.data.name.startsWith("Psi Warrior")&&!this.data.name.startsWith("Soulknife")||this.is2014){if(this.data.name.startsWith("Rune Knight")){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"rune-uses",type:"number",scale:{3:{value:1},15:{value:2}}},value:{},title:"Rune Uses",icon:null};this.data.system.advancement.push(e)}}else for(let e of this.data.system.advancement)"Energy Die"===e.title&&(e.configuration.scale=foundry.utils.mergeObject(e.configuration.scale,{3:{number:4,faces:6},5:{number:6,faces:8},9:{number:8,faces:8},11:{number:8,faces:10},13:{number:10,faces:10},17:{number:12,faces:12}}))}async generateFromCharacter(e){await this._buildCompendiumIndex("features"),this._fleshOutCommonDataStub(),await this._generateCommonAdvancements(),await this._generateDescriptionStub(e),this._fixes(),await this._addToCompendium()}}class CharacterClassFactory{constructor(e,{addToCompendium:t=!1}={}){this.ddbCharacter=e,this.character=this.ddbCharacter.raw.character,this.source=this.ddbCharacter.source.ddb,this.ddbClasses={},this.originalClass=null,this.addToCompendium=t}async processCharacter(){const e=[];for(const t of this.source.character.classes){const a=new DDBClass(this.source,t.definition.id,{addToCompendium:this.addToCompendium});if(await a.generateFromCharacter(this.character),this.ddbClasses[a.data.name]=a,e.push(foundry.utils.deepClone(a.data)),t.subclassDefinition&&t.subclassDefinition.name){const a=new DDBSubClass(this.source,t.definition.id,{addToCompendium:this.addToCompendium});await a.generateFromCharacter(this.character),this.ddbClasses[a.data.name]=a,e.push(foundry.utils.deepClone(a.data))}a.isStartingClass&&(this.originalClass=a.data._id)}return i.logger.debug(`Processed ${e.length} classes`,{documents:e}),this.ddbCharacter.updateItemIds(e),e}#e(e,t,a){const n=t.system.advancement[a],s=e._advancementMatches.features[n._id],r={};if(s&&n){for(const[a,o]of Object.entries(s)){i.logger.debug(`Advancement ${n._id} searching for Feature ${a} (${o})`,{a:n,ddbClass:e,advancementFeatureName:a,uuid:o});const s=this.ddbCharacter.getDataFeature(a,{hints:[t.name]});s&&(i.logger.debug(`Advancement ${n._id} found Feature ${a} (${o})`),r[s._id]=o,foundry.utils.setProperty(s,"flags.dnd5e.sourceId",o),foundry.utils.setProperty(s,"flags.dnd5e.advancementOrigin",`${t._id}.${n._id}`))}Object.keys(r).length>0&&(n.value={added:r},t.system.advancement[a]=n)}else i.logger.warn(`Advancement for ${t.name} (idx ${a}) missing required data for linking`,{advancement:n,aData:s,klass:t,ddbClass:e})}#t(e,t,a){const n=t.system.advancement[a],s=e._advancementMatches.features[n._id],r={};if(s&&n){for(const[a,o]of Object.entries(s)){i.logger.debug(`Ability Score Advancement ${n._id} searching for Feat ${a} (${o})`,{a:n,ddbClass:e,advancementFeatureName:a,uuid:o});const s=this.ddbCharacter.getDataFeature(a,{hints:[t.name]});s&&(i.logger.debug(`Ability Score Advancement ${n._id} found Feat ${a} (${o})`),r[s._id]=o,foundry.utils.setProperty(s,"flags.dnd5e.sourceId",o),foundry.utils.setProperty(s,"flags.dnd5e.advancementOrigin",`${t._id}.${n._id}`))}Object.keys(r).length>0&&(t.system.advancement[a].value={type:"feat",feat:r})}else i.logger.warn(`Advancement for ${t.name} (idx ${a}) missing required data for linking`,{advancement:n,aData:s,klass:t,ddbClass:e})}linkFeatures(){i.logger.debug("Linking Advancements to Features",{CharacterClassFactory:this});for(const e of this.ddbCharacter.data.classes){const t=this.ddbClasses[e.name];i.logger.debug("Linking Advancements to Features for Class",{klass:e,ddbClass:t});for(let a=0;a<e.system.advancement.length;a++){const i=e.system.advancement[a];"ItemGrant"===i.type&&i.level<=t.ddbClass.level?this.#e(t,e,a):"AbilityScoreImprovement"===i.type&&"feat"===i.value.type&&this.#t(t,e,a)}i.logger.debug(`Processed ${e.name} class advancements`,e.system.advancement)}}}var c=a(259),u=a(648);class DDBFeatureMixin extends u.mixins.DDBActivityFactoryMixin{static LEVEL_SCALE_EXCLUSION=["Fire Rune","Cloud Rune","Stone Rune","Frost Rune","Hill Rune","Storm Rune","Drake Companion: Summon","Drake Companion: Command","Drake Companion"];static LEVEL_SCALE_INFUSIONS=["Unarmed Strike","Arms of the Astral Self (WIS)","Arms of the Astral Self (DEX)","Arms of the Astral Self (DEX/STR)","Arms of the Astral Self","Body of the Astral Self","Starry Form: Archer","Sneak Attack"];static NATURAL_WEAPONS=["Bite","Claw","Claws","Claws","Fangs","Gore","Sting","Talon","Talons","Trunk"];static SPECIAL_ADVANCEMENTS={};static UTILITY_FEATURES=["Channel Divinity:","Maneuver:"];DDB_TYPE_ENRICHERS={class:u.DDBClassFeatureEnricher,race:u.DDBSpeciesTraitEnricher,feat:u.DDBFeatEnricher,other:u.DDBGenericEnricher,background:u.DDBBackgroundEnricher};_init(){i.logger.debug(`Generating Base Feature ${this.ddbDefinition.name}`)}_generateDataStub(){this.data={_id:foundry.utils.randomID(),name:l.DDBDataUtils.getName(this.ddbData,this.ddbDefinition,this.rawCharacter),type:this.documentType,system:l.SystemHelpers.getTemplate(this.documentType),effects:[],flags:{ddbimporter:{id:this.ddbDefinition.id,entityTypeId:this.ddbDefinition.entityTypeId,action:this.isAction,componentId:this.ddbDefinition.componentId,componentTypeId:this.ddbDefinition.componentTypeId,originalName:this.originalName,type:this.tagType,isCustomAction:this.ddbDefinition.isCustomAction,is2014:this.is2014,is2024:!this.is2014,legacy:this.legacy},infusions:{infused:!1}}}}_generateLevelScale(){this.excludedScale=DDBFeatureMixin.LEVEL_SCALE_EXCLUSION.includes(this.ddbDefinition.name)||DDBFeatureMixin.LEVEL_SCALE_EXCLUSION.includes(this.data.name),this.levelScaleInfusion=DDBFeatureMixin.LEVEL_SCALE_INFUSIONS.includes(this.ddbDefinition.name)||DDBFeatureMixin.LEVEL_SCALE_INFUSIONS.includes(this.data.name),this.scaleValueLink=l.DDBDataUtils.getScaleValueString(this.ddbData,this.ddbDefinition).value,this.useScaleValueLink=!this.excludedScale&&this.scaleValueLink&&"{{scalevalue-unknown}}"!==this.scaleValueLink}_generateFlagHints(){if(this.data.flags=foundry.utils.mergeObject(this.data.flags,this.extraFlags),this._actionType.class){const e=l.DDBDataUtils.findClassByFeatureId(this.ddbData,this._actionType.class.componentId);this.klass=e.definition.name,foundry.utils.setProperty(this.data.flags,"ddbimporter.type","class"),foundry.utils.setProperty(this.data.flags,"ddbimporter.class",e.definition.name),foundry.utils.setProperty(this.data.flags,"ddbimporter.classId",e.definition.id);const t=l.DDBDataUtils.findSubClassByFeatureId(this.ddbData,this._actionType.class.componentId);this.subKlass=t?.definition.name;const a=foundry.utils.getProperty(t,"subclassDefinition");foundry.utils.setProperty(this.data.flags,"ddbimporter.subClass",a?.name),foundry.utils.setProperty(this.data.flags,"ddbimporter.subClassId",a?.id)}else this._actionType.race?(foundry.utils.setProperty(this.data.flags,"ddbimporter.type","race"),foundry.utils.setProperty(this.data,"flags.ddbimporter.fullRaceName",this.ddbCharacter?._ddbRace.fullName),foundry.utils.setProperty(this.data,"flags.ddbimporter.groupName",this.ddbCharacter?._ddbRace.groupName)):this._actionType.feat&&foundry.utils.setProperty(this.data.flags,"ddbimporter.type","feat");const e=l.DDBDataUtils.findComponentByComponentId(this.ddbData,this.ddbDefinition.id)??l.DDBDataUtils.findComponentByComponentId(this.ddbData,this.ddbDefinition.componentId);e&&(foundry.utils.setProperty(this.data.flags,"ddbimporter.dndbeyond.levelScale",e.levelScale),foundry.utils.setProperty(this.data.flags,"ddbimporter.dndbeyond.levelScales",e.definition?.levelScales),foundry.utils.setProperty(this.data.flags,"ddbimporter.dndbeyond.limitedUse",e.definition?.limitedUse))}_generateSaveFromDescription(){const e=this.ddbDefinition.description??this.ddbDefinition.snippet??"",t=l.DDBDescriptions.dcParser({text:e});t.match?this._descriptionSave=t.save:this._descriptionSave=null}_generateActionTypes(){this._generateSaveFromDescription(),this._actionType={class:this.ddbData.character.actions.class.filter((e=>l.DDBDataUtils.findClassByFeatureId(this.ddbData,e.componentId))).find((e=>l.DDBDataUtils.getName(this.ddbData,e,this.rawCharacter)===this.data.name)),race:this.ddbData.character.actions.race.some((e=>l.DDBDataUtils.getName(this.ddbData,e,this.rawCharacter)===this.data.name)),feat:this.ddbData.character.actions.feat.some((e=>l.DDBDataUtils.getName(this.ddbData,e,this.rawCharacter)===this.data.name))}}_prepare(){this.ddbDefinition.infusionFlags&&foundry.utils.setProperty(this.data,"flags.infusions",this.ddbDefinition.infusionFlags),this._generateLevelScale(),this._generateActionTypes(),this._generateFlagHints()}_getActionParent(){return this.ddbDefinition.componentId?l.DDBDataUtils.findComponentByComponentId(this.ddbData,this.ddbDefinition.componentId):null}constructor({ddbData:e,ddbDefinition:t,type:a,source:n,documentType:s="feat",rawCharacter:r=null,noMods:d=!1,activityType:u=null,extraFlags:m={},enricher:p=null,ddbCharacter:g=null,fallbackEnricher:h=null}={}){super({enricher:p,activityGenerator:c.eK,documentType:s}),this.ddbCharacter=g,this.ddbData=e,this.rawCharacter=r,this.ddbFeature=t,this.extraFlags=m,this.ddbDefinition=t.definition??t,this.name=i.utils.nameString(this.ddbDefinition.name),this.originalName=this.ddbData?l.DDBDataUtils.getName(this.ddbData,this.ddbDefinition,this.rawCharacter,!1):i.utils.nameString(this.ddbDefinition.name),this.type=a,this.source=n,this.isAction=!1,this.excludedScale=!1,this.levelScaleInfusion=!1,this.scaleValueLink="",this.useScaleValueLink=!1,this.excludedScaleUses=!1,this.scaleValueUsesLink="",this.useUsesScaleValueLink=!1,this.tagType="other",this.activities=[],this.data={},this.noMods=d,this._init(),this.snippet="",this.description="",this.resourceCharges=null,this.activityType=u,this.klass=this.extraFlags.ddbimporter?.class,this.subKlass=this.extraFlags.ddbimporter?.subClass,this._parent=this._getActionParent();const f=this.ddbDefinition.sources??this._parent?.definition?.sources??[],y=f.map((e=>e.sourceId));this.legacy=CONFIG.DDB.sources.some((e=>y.includes(e.id)&&o.x.sourceCategories.legacy.includes(e.sourceCategoryId))),this.is2014=f.some((e=>Number.isInteger(e.sourceId)&&e.sourceId<145)),this._generateDataStub();const b=/^(\d+: )(.*)$/.exec(this.data.name);b&&(this.name=b[2].trim(),this.data.name=b[2].trim());const D=/(.*) \((\d) points?\)/i.exec(this.name.match);D&&(this.data.name=D[1],this.resourceCharges=Number.parseInt(D[2])),this._prepare(),this.naturalWeapon=DDBFeatureMixin.NATURAL_WEAPONS.includes(this.originalName),this.isCompanionFeature=this._isCompanionFeature(),this.isCompanionFeatureOption=this._isCompanionFeatureOption();const v=this.source&&i.utils.isObject(this.source)?this.source:i.DDBSources.parseSource(this.ddbDefinition);this.data.system.source=v,this.data.system.source.rules=this.is2014?"2014":"2024",this.fallbackEnricher=h,this.enricher=p??new this.DDB_TYPE_ENRICHERS[a]({activityGenerator:c.eK,fallbackEnricher:this.fallbackEnricher})}_getClassFeatureDescription(e=!1){if(!this.ddbData)return"";const t=this.ddbDefinition.componentId,a=this.ddbDefinition.componentTypeId,i=this.ddbData.character.classes.find((e=>e.classFeatures.find((e=>e.definition.id==t&&e.definition.entityTypeId==a))));if(i){const n=i.classFeatures.find((i=>i.definition.id==t&&i.definition.entityTypeId==a&&(!e||e&&i.definition.name==this.originalName)));if(n)return l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,n.definition.description,this.ddbFeature).text}return""}_getRaceFeatureDescription(){const e=this.ddbDefinition.componentId,t=this.ddbDefinition.componentTypeId,a=this.ddbData.character.race.racialTraits.find((a=>a.definition.id==e&&a.definition.entityTypeId==t));return a?l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,a.definition.description,this.ddbFeature).text:""}getParsedActionType(){const e=this.ddbDefinition.description&&""!==this.ddbDefinition.description?this.ddbDefinition.description:this.ddbDefinition.snippet&&""!==this.ddbDefinition.snippet?this.ddbDefinition.snippet:null;if(!e)return;if(e.match(/(?:as|spend|use) (?:a|an|your) action/gi))return"action";if(e.match(/(?:as|use|spend) (?:a|an|your) bonus action/gi))return"bonus";return e.match(/(?:as|use|spend) (?:a|an|your) reaction/gi)?"reaction":void 0}static buildFullDescription(e,t,a){let n="";return t&&!i.utils.stringKindaEqual(e,t)&&""!==t.trim()&&""!==e.trim()?(n+=t.trim(),n+=`<br>\n  <details>\n    <summary>\n      ${a||"More Details"}\n    </summary>\n    <p>\n      ${e.trim()}\n    </p>\n  </details>`):t&&""===e.trim()?n+=t.trim():n+=e.trim(),n}getDescription({forceFull:e=!1,extra:t=""}={}){const a=game.settings.get("ddb-importer","character-update-policy-use-combined-description"),n=game.settings.get("ddb-importer","add-description-to-chat");this.snippet=this.ddbDefinition.snippet&&""!==this.ddbDefinition.snippet?l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,this.ddbDefinition.snippet,this.ddbFeature).text:"";const s=this.ddbDefinition.snippet?this.snippet:"";this.description=this.ddbDefinition.description&&""!==this.ddbDefinition.description?l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,this.ddbDefinition.description,this.ddbFeature).text:!a||e?"race"===this.type?this._getRaceFeatureDescription():this._getClassFeatureDescription(!(a||e)):"";const r=t&&""!==t?l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,t,this.ddbFeature).text:"",o=i.DDBSimpleMacro.getDescriptionAddition(this.originalName,"feat");if(n){const e=""!==this.description&&i.utils.stringKindaEqual(this.description,s)?"":s;return{value:this.description+r+o,chat:e+o}}{const t=i.utils.stringKindaEqual(this.description,s)?"":s,l=a&&!e||""===this.description?t:null;return{value:DDBFeatureMixin.buildFullDescription(this.description,l)+r+o,chat:n?t+o:""}}}_generateDescription({forceFull:e=!1,extra:t=""}={}){this.data.system.description=this.getDescription({forceFull:e,extra:t})}_generateLimitedUse(){let e=o.x.resets.find((e=>e.id===this.ddbDefinition.limitedUse?.resetType));if(!e){const t=/(?:(Short) or )?(Long) Rest/gi.exec(this.ddbDefinition.description);t&&t[1]?e=o.x.resets.find((e=>e.id===t[1])):t&&t[2]&&(e=o.x.resets.find((e=>e.id===t[2])))}if(this.ddbDefinition.limitedUse&&(this.ddbDefinition.limitedUse.maxUses||this.ddbDefinition.limitedUse.statModifierUsesId||this.ddbDefinition.limitedUse.useProficiencyBonus)){let t=this.ddbDefinition.limitedUse.maxUses&&-1!==this.ddbDefinition.limitedUse.maxUses?this.ddbDefinition.limitedUse.maxUses:0;const a=foundry.utils.getProperty(this.ddbDefinition,"limitedUse.statModifierUsesId");if(a){const e=o.x.actor.abilities.find((e=>e.id===a)).value;if(0===t)t=`@abilities.${e}.mod`;else if(2===this.ddbDefinition.limitedUse.operator)t=`${t} * @abilities.${e}.mod`;else t=`${t} + @abilities.${e}.mod`}if(foundry.utils.getProperty(this.ddbDefinition,"limitedUse.useProficiencyBonus"))if(0===t)t="@prof";else if(2===this.ddbDefinition.limitedUse.proficiencyBonusOperator)t=`${t} * @prof`;else t=`${t} + @prof`;this.useUsesScaleValueLink&&this.scaleValueUsesLink&&(t=this.scaleValueUsesLink);const i=t?Number.isInteger(t)?parseInt(t):t:null;this.data.system.uses={spent:this.ddbDefinition.limitedUse.numberUsed??null,max:0!=i?`${i}`:null,recovery:[{period:e?e.value:"",type:"recoverAll",formula:void 0}]}}else if(this.useUsesScaleValueLink&&this.scaleValueUsesLink){let t=this.scaleValueUsesLink;this.data.system.uses={spent:this.ddbDefinition.limitedUse.numberUsed??null,max:""!==t?t:null,recovery:[{period:e?e.value:"",type:"recoverAll",formula:void 0}]}}else if(foundry.utils.hasProperty(this.ddbDefinition,"limitedUse.value"))this.data.system.uses={spent:this.ddbDefinition.limitedUse.numberUsed??null,max:this.ddbDefinition.limitedUse.value,recovery:[{period:e?e.value:"",type:"recoverAll",formula:void 0}]};else if(this.enricher?.activityNameMatchFeature)this.data.system.uses=foundry.utils.deepClone(this.enricher.activityNameMatchFeature.system.uses);else if(this.enricher?.defaultActionFeatures&&Object.keys(this.enricher.defaultActionFeatures).length>0){const e=Object.values(this.enricher.defaultActionFeatures).flat().find((e=>e.system.uses.max&&""!==e.system.uses.max));e&&(this.data.system.uses=foundry.utils.deepClone(e.system.uses))}}_generateRange(){"weapon"===this.documentType&&(this.ddbDefinition.range&&this.ddbDefinition.range.aoeType&&this.ddbDefinition.range.aoeSize?(this.data.system.range={value:null,units:"self",long:""},this.data.system.target={value:this.ddbDefinition.range.aoeSize,type:o.x.actions.aoeType.find((e=>e.id===this.ddbDefinition.range.aoeType))?.value,units:"ft",reach:null}):this.ddbDefinition.range&&this.ddbDefinition.range.range?this.data.system.range={value:this.ddbDefinition.range.range,units:"ft",long:this.ddbDefinition.range.long||"",reach:null}:this.data.system.range={value:5,units:"ft",long:""})}isMartialArtist(e=null){return e?e.classFeatures.some((e=>"Martial Arts"===e.definition.name)):this.ddbData.character.classes.some((e=>e.classFeatures.some((e=>"Martial Arts"===e.definition.name))))}getDamageType(){return this.ddbDefinition.damageTypeId?o.x.actions.damageType.find((e=>e.id===this.ddbDefinition.damageTypeId)).name:null}getDamageDie(){return this.ddbDefinition.dice?this.ddbDefinition.dice:this.ddbDefinition.die?this.ddbDefinition.die:void 0}getDamage(e=[]){const t=this.getDamageType(),a={number:null,denomination:null,bonus:"",types:t?[t]:[],custom:{enabled:!1,formula:""},scaling:{mode:"whole",number:null,formula:""}},n=this.getDamageDie(),s=n?.fixedValue?(this.ddbDefinition.snippet??this.ddbDefinition.description??"").includes("{{proficiency#signed}}")?" + @prof":` + ${n.fixedValue}`:"",r=e.join(" ");if(n||this.useScaleValueLink)if(this.useScaleValueLink)l.SystemHelpers.parseBasicDamageFormula(a,`${this.scaleValueLink}${r}${s}`);else if(n.diceString){const e=CONFIG.DDB.levelProficiencyBonuses.find((e=>e.level===this.ddbData.character.classes.reduce(((e,t)=>e+t.level),0)))?.bonus,t=this.ddbDefinition.snippet?.includes("{{proficiency#signed}}")&&Number.parseInt(n.fixedValue)===Number.parseInt(e),s=t?n.diceString.replace(`+ ${e}`,""):n.diceString,o=t?`${r} + @prof`:r,d=i.utils.parseDiceString(s,o).diceString;l.SystemHelpers.parseBasicDamageFormula(a,d)}else s&&l.SystemHelpers.parseBasicDamageFormula(a,s+r);return a}_generateDamage(){if("weapon"!==this.documentType)return;const e=this.getDamage();e&&(this.data.system.damage={base:e,versatile:""})}getMartialArtsDamage(e=[]){const t=this.getDamageType(),a=this.ddbDefinition.dice?this.ddbDefinition.dice:this.ddbDefinition.die?this.ddbDefinition.die:void 0,n=e.join(" "),s={number:null,denomination:null,bonus:"",types:t?[t]:[],custom:{enabled:!1,formula:""},scaling:{mode:"whole",number:null,formula:""}};if(this.isMartialArtist()){const e=this.ddbData.character.classes.filter((e=>this.isMartialArtist(e))).map((e=>{const t=e.classFeatures.find((e=>"Martial Arts"===e.definition.name)),i=t?.levelScale?.dice?t.levelScale.dice:t?.levelScale.die?t.levelScale.die:void 0;if(i?.diceString){const e=l.DDBDataUtils.getScaleValueLink(this.ddbData,t),n=e&&"{{scalevalue-unknown}}"!==e?e:i.diceString;return a?.diceValue>i.diceValue?a.diceString:n}return null!=a?a.diceString:"1"})),t=e.length>0?e[0]:"",r=t.includes("@")?`${t}${n} + @mod`:i.utils.parseDiceString(t,`${n} + @mod`).diceString;l.SystemHelpers.parseBasicDamageFormula(s,r)}else if(null!=a){const e=i.utils.parseDiceString(a.diceString,`${n} + @mod`).diceString;l.SystemHelpers.parseBasicDamageFormula(s,e)}else l.SystemHelpers.parseBasicDamageFormula(s,`1${n} + @mod`);return s}_generateResourceFlags(){const e=game.modules.get("link-item-resource-5e")?.active;if("disable"!==foundry.utils.getProperty(this.rawCharacter,"flags.ddbimporter.resources.type")&&e){const e=foundry.utils.getProperty(this.data.flags,"link-item-resource-5e.resource-link");Object.keys(this.rawCharacter.system.resources).forEach((t=>{const a=this.rawCharacter.system.resources[t];this.ddbDefinition.name===a.label?(foundry.utils.setProperty(this.data.flags,"link-item-resource-5e.resource-link",t),this.rawCharacter.system.resources[t]={value:0,max:0,sr:!1,lr:!1,label:""}):e===t&&foundry.utils.setProperty(this.data.flags,"link-item-resource-5e.resource-link",void 0)}))}}getActionAttackAbility(){return""}_getFeatModifierItem(e,t){if(this.ddbDefinition.grantedModifiers)return this.ddbDefinition;let a=foundry.utils.duplicate(this.ddbDefinition);const i=[l.DDBModifiers.getChosenClassModifiers(this.ddbData,{includeExcludedEffects:!0,effectOnly:!0}),l.DDBModifiers.getModifiers(this.ddbData,"race",!0,!0),l.DDBModifiers.getModifiers(this.ddbData,"background",!0,!0),l.DDBModifiers.getModifiers(this.ddbData,"feat",!0,!0)].flat();return a.definition||(a.definition={}),a.definition.grantedModifiers=i.filter((a=>{if(a.componentId===this.ddbDefinition?.id&&a.componentTypeId===this.ddbDefinition?.entityTypeId)return!0;if(e&&this.ddbData.character.options[t]?.length>0){if(this.ddbData.character.options[t].some((t=>e.componentId==t.componentId&&t.definition.id==a.componentId&&(e.componentTypeId==t.componentTypeId||e.componentTypeId==t.definition.entityTypeId)&&t.definition.entityTypeId==a.componentTypeId&&e.id==a.componentId)))return!0}else if(e){const t=e.choiceId.split("-").pop();if(a.id==t)return!0}if(a.componentId===this.ddbDefinition.id)if("class"===t){if(this.ddbData.character.classes.some((e=>e.classFeatures.some((e=>e.definition.entityTypeId==a.componentTypeId&&e.definition.id==this.ddbDefinition.id)))))return!0}else if("feat"===t){if(this.ddbData.character.feats.some((e=>e.definition.entityTypeId==a.componentTypeId&&e.definition.id==this.ddbDefinition.id)))return!0}else if("race"===t){if(this.ddbData.character.race.racialTraits.some((e=>e.definition.entityTypeId==a.componentTypeId&&e.definition.id==a.componentId&&e.definition.id==this.ddbDefinition.id)))return!0}return!1})),a}async _addEffects(e,t){const a=this.rawCharacter.flags.ddbimporter.compendium,i=this._getFeatModifierItem(e,t);this.data=u.Effects.EffectGenerator.generateEffects({ddb:this.ddbData,character:this.rawCharacter,ddbItem:i,document:this.data,isCompendiumItem:a,type:"feat",description:""!==this.snippet?this.snippet:this.description}),this.enricher.clearAutoEffects&&(this.data.effects=[]);const n=await this.enricher.createEffects();this.data.effects.push(...n),this.enricher.createDefaultEffects(),this._activityEffectLinking()}_addCustomValues(){l.DDBDataUtils.addCustomValues(this.ddbData,this.data)}_generateSystemSubType(){let e=null;"class"===this.type?this.data.name.startsWith("Ki:")?e="Ki":this.data.name.startsWith("Channel Divinity")?e="channelDivinity":this.data.name.startsWith("Artificer Infusion:")?e="artificerInfusion":this.data.name.startsWith("Invocation:")?e="eldritchInvocation":this.data.name.startsWith("Fighting Style:")?e="fightingStyle":this.data.name.startsWith("Maneuver:")||this.data.name.startsWith("Battle Master Maneuver:")?e="maneuver":["Metamagic:","Metamagic - "].some((e=>this.data.name.startsWith(e)))?e="metamagic":this.data.name.startsWith("Pact of the")?e="pact":this.data.name.startsWith("Rune Carver:")?e="rune":this.data.name.startsWith("Psionic Power")?e="psionicPower":this.data.name.startsWith("Hunter's Prey:")?e="huntersPrey":this.data.name.startsWith("Defensive Tactics:")?e="defensiveTactic":this.data.name.startsWith("Superior Hunter's Defense:")?e="superiorHuntersDefense":this.data.name.startsWith("Arcane Shot Options:")?e="arcaneShot":this.data.name.startsWith("Elemental Disciplines:")&&(e="elementalDiscipline"):"feat"===this.type&&this.ddbDefinition.categories&&(e=this.ddbDefinition.categories.some((e=>"Origin"===e.tagName))?"origin":this.ddbDefinition.categories.some((e=>"Fighting Style"===e.tagName))?"fightingStyle":this.ddbDefinition.categories.some((e=>"Epic Boon"===e.tagName))?"epicBoon":"general"),e&&foundry.utils.setProperty(this.data,"system.type.subtype",e)}_generateWeaponType(){if("weapon"!==this.documentType)return;const e=this.naturalWeapon?"natural":o.x.actions.attackTypes.find((e=>e.attackSubtype===this.ddbDefinition.attackSubtype))?.value,t=o.x.weapon.weaponRange.find((e=>e.attackType===this.ddbDefinition.attackTypeRange));this.data.system.type.value=e||(t?`simple${t.value}`:"simpleM")}_generateSystemType(){"weapon"===this.documentType?this._generateWeaponType():foundry.utils.setProperty(this.data,"system.type.value",this.type)}_isCompanionFeature(){return o.x.companions.COMPANION_FEATURES.includes(this.originalName)&&this.ddbData.character.classes.some((e=>e.classFeatures.some((e=>e.definition.name==this.originalName))))}_isCompanionFeatureOption(){for(const[e,t]of Object.entries(o.x.companions.COMPANION_OPTIONS))for(const a of t)if(this.originalName===e||this.originalName===`${e}: ${a}`)return this.companionFeatureOption={parentFeature:e,childName:a},!0;return!1}_getSummonsDescription(){if(this.isCompanionFeatureOption){const e=this.ddbData.character.options.class.find((e=>e.definition.name==this.companionFeatureOption.childName));return e?e.definition.description:null}return this.ddbDefinition.description}isForceResourceLinked(){for(const e of Object.values(o.x.CONSUMPTION_LINKS))if(e.some((e=>this.originalName.startsWith(e))))return!0;return!1}targetsCreature(){const e=this.ddbDefinition.description??this.ddbDefinition.snippet??"";return e.match(/You touch (?:a|one) (?:willing |living )?creature|affecting one creature|creature you touch|a creature you|creature( that)? you can see|interrupt a creature|would strike a creature|creature of your choice|creature or object within range|cause a creature|creature must be within range|a creature in range|each creature within/gi)||e.match(/(humanoid|monster|creature|target|beast)(s)? (or loose object )?(of your choice )?(that )?(you can see )?within range/gi)||e.match(/attack against the target|at a target in range/gi)}_getActivitiesType(){return this.isCompanionFeature||this._isCompanionFeatureOption()?"summon":"number"==typeof this.ddbDefinition.saveStatId||this._descriptionSave?"save":1===this.ddbDefinition.actionType||this.ddbDefinition.rangeId&&1===this.ddbDefinition.rangeId||this.ddbDefinition.rangeId&&2===this.ddbDefinition.rangeId?"attack":this.data.system.uses?.max&&"0"!==this.data.system.uses.max||this.data.effects.length>0||this.enricher.effects?.length>0||DDBFeatureMixin.UTILITY_FEATURES.some((e=>this.originalName.startsWith(e)))||this.isForceResourceLinked()||this.getParsedActionType()||this.isAction?"utility":null}_generateActivity({hintsOnly:e=!1,statusEffects:t=!0,name:a=null,nameIdPostfix:i=null,typeOverride:n=null}={},s={}){if("none"!==this.enricher.activity?.type){if(t){const e=u.Effects.AutoEffects.getStatusEffect({ddbDefinition:this.ddbDefinition,foundryItem:this.data});e&&this.data.effects.push(e)}if(!e||this.enricher.activity)return super._generateActivity({hintsOnly:e,name:a,nameIdPostfix:i,typeOverride:n??this.enricher.type??this.enricher.activity?.type??this.activityType},s)}}build(){return!1}static async finalFixes(e){const t=await l.DDBTable.generateTable({parentName:e.name,html:e.system.description.value,updateExisting:!0,type:e.type,notifier:this.notifier});e.system.description.value=t}}class DDBAction extends DDBFeatureMixin{static KEEP_ACTIONS=o.x.parsing.actions.KEEP_ACTIONS;static KEEP_ACTIONS_STARTSWITH=o.x.parsing.actions.KEEP_ACTIONS_STARTSWITH;static SKIPPED_ACTIONS=o.x.parsing.actions.SKIPPED_ACTIONS;static SKIPPED_ACTIONS_STARTSWITH=o.x.parsing.actions.SKIPPED_ACTIONS_STARTSWITH;static SKIPPED_2014_ONLY_ACTIONS=o.x.parsing.actions.SKIPPED_2014_ONLY_ACTIONS;static SKIPPED_2024_ONLY_ACTIONS=o.x.parsing.actions.SKIPPED_2024_ONLY_ACTIONS;static HIGHEST_LEVEL_ONLY_ACTION_MATCH=o.x.parsing.actions.HIGHEST_LEVEL_ONLY_ACTION_MATCH;_init(){this.isAction=!0,i.logger.debug(`Generating Action ${this.ddbDefinition.name}`)}displayAsAttack(){const e=this.rawCharacter?l.DDBDataUtils.getCustomValueFromCharacter(this.ddbDefinition,this.rawCharacter,16):l.DDBDataUtils.getCustomValue(this.ddbDefinition,this.ddbData,16);return"boolean"==typeof e?e:!!foundry.utils.hasProperty(this.ddbDefinition,"displayAsAttack")&&this.ddbDefinition.displayAsAttack}_generateSystemType(e=null){"weapon"===this.documentType?this._generateWeaponType():this.ddbData.character.actions.class.some((e=>e.name===this.ddbDefinition.name||foundry.utils.hasProperty(e,"definition.name")&&e.definition.name===this.ddbDefinition.name))?(this.type||(this.type="class"),this.data.system.type.value="class"):this.ddbData.character.actions.race.some((e=>e.name===this.ddbDefinition.name||foundry.utils.hasProperty(e,"definition.name")&&e.definition.name===this.ddbDefinition.name))?(this.type||(this.type="race"),this.data.system.type.value="race"):this.ddbData.character.actions.feat.some((e=>e.name===this.ddbDefinition.name||foundry.utils.hasProperty(e,"definition.name")&&e.definition.name===this.ddbDefinition.name))?(this.type||(this.type="feat"),this.data.system.type.value="feat"):e&&(this.type||(this.type=e),this.data.system.type.value=e,foundry.utils.setProperty(this.data,"flags.ddbimporter.type",e))}isMeleeOrRangedAction(){return this.ddbDefinition.attackTypeRange||this.ddbDefinition.rangeId}getDamage(e=[]){const t=this.isMeleeOrRangedAction(),a=(this.ddbDefinition.statId||this.ddbDefinition.abilityModifierStatId)&&!this.ddbDefinition.isOffhand&&t?" + @mod":"",i=l.DDBModifiers.filterBaseModifiers(this.ddbData,"damage",{subType:"unarmed-attacks"}).reduce(((e,t)=>e+t.value),0),n=this.ddbDefinition.isMartialArts?super.getMartialArtsDamage(e.concat(0===i?[]:[`+ ${i}`])):super.getDamage(e.concat([a]));return n.number||n.custom.enabled?n:void 0}getActionAttackAbility(){let e=this.ddbDefinition.abilityModifierStatId?o.x.actor.abilities.find((e=>e.id===this.ddbDefinition.abilityModifierStatId)).value:"";return!this.ddbDefinition.abilityModifierStatId||[1,2].includes(this.ddbDefinition.abilityModifierStatId)&&this.ddbDefinition.isMartialArts?this.ddbDefinition.isMartialArts?this.ddbDefinition.isMartialArts&&this.isMartialArtist()?this.rawCharacter.flags.ddbimporter.dndbeyond.effectAbilities.dex.value>=this.rawCharacter.flags.ddbimporter.dndbeyond.effectAbilities.str.value?"dex":"str":""!==e?e:"str":"":e}getBonusDamage(){return this.ddbDefinition.isMartialArts?l.DDBModifiers.filterBaseModifiers(this.ddbData,"bonus",{subType:"unarmed-attacks"}).reduce(((e,t)=>e+t.value),0):""}_generateProperties(){this.ddbData.character.classes.some((e=>e.classFeatures.some((t=>"Ki-Empowered Strikes"===t.definition.name&&e.level>=t.definition.requiredLevel))))&&"Unarmed Strike"==foundry.utils.getProperty(this.data,"flags.ddbimporter.originalName")&&i.utils.addToProperties(this.data.system.properties,"mgc")}async build(){try{(this.is2014&&DDBAction.SKIPPED_2014_ONLY_ACTIONS.includes(this.originalName)||!this.is2014&&DDBAction.SKIPPED_2024_ONLY_ACTIONS.includes(this.originalName))&&foundry.utils.setProperty(this.data,"flags.ddbimporter.skip",!0),this._generateSystemType(),this._generateSystemSubType(),this._generateDescription(),this._generateLimitedUse(),this._generateRange(),this.enricher.stopDefaultActivity||this._generateActivity(),await this.enricher.addAdditionalActivities(this),this._generateResourceFlags(),this.enricher.addDocumentOverride(),await this._addEffects(void 0,this.type),this._addCustomValues(),this.data.system.identifier=i.utils.referenceNameString(`${this.data.name.toLowerCase()}`)}catch(e){i.logger.warn(`Unable to Generate Action: ${this.name}, please log a bug report. Err: ${e.message}`,"extension"),i.logger.error("Error",e)}}}class DDBAttackAction extends DDBAction{static FORCE_WEAPON_FEATURES=o.x.parsing.attackActions.FORCE_WEAPON_FEATURES;_init(){this.isAction=!0,this.documentType=DDBAttackAction.FORCE_WEAPON_FEATURES.includes(this.ddbDefinition.name)?"weapon":"feat",i.logger.debug(`Generating Attack Action ${this.ddbDefinition.name}`)}async build(){try{this.ddbData.isMartialArts&&foundry.utils.setProperty(this.data,"flags.ddbimporter.dndbeyond.type","Martial Arts"),(this.is2014&&DDBAction.SKIPPED_2014_ONLY_ACTIONS.includes(this.originalName)||!this.is2014&&DDBAction.SKIPPED_2024_ONLY_ACTIONS.includes(this.originalName))&&foundry.utils.setProperty(this.data,"flags.ddbimporter.skip",!0),this.data.system.proficient=this.ddbDefinition.isProficient?1:0,this._generateDescription(),this.data.system.equipped=!0,this.data.system.rarity="",this.data.system.identified=!0,this._generateRange(),this._generateLimitedUse(),this._generateProperties(),this._generateSystemType(this.type),this._generateSystemSubType(),this.enricher.stopDefaultActivity||this._generateActivity(),await this.enricher.addAdditionalActivities(this),this._generateResourceFlags(),this.enricher.addDocumentOverride(),await this._addEffects(void 0,this.type),this._addCustomValues(),this.data.system.identifier=i.utils.referenceNameString(`${this.data.name.toLowerCase()}${this.is2014?" - legacy":""}`)}catch(e){i.logger.warn(`Unable to Generate Attack Action: ${this.name}, please log a bug report. Err: ${e.message}`,"extension"),i.logger.error("Error",e)}}}class DDBFeature extends DDBFeatureMixin{static DOC_TYPE={class:"feat",subclass:"feat",race:"feat",background:"background",feat:"feat"};static LEVEL_SCALE_EXCLUSION_USES=["Destroy Undead","Magical Cunning","Brutal Strike","Extra Attack","Improved Critical","Unarmored Movement","Metamagic"];static LEVEL_SCALE_EXCLUSION_USES_STARTS_WITH=["Aura of "];_init(){this.documentType=DDBFeature.DOC_TYPE[this.type],this.tagType=this.type,i.logger.debug(`Init Feature ${this.ddbDefinition.name}`),this._class=this.noMods?null:this.ddbData.character.classes.find((e=>this.ddbDefinition.classId&&(e.definition.id===this.ddbDefinition.classId||e.subclassDefinition?.id===this.ddbDefinition.classId)||this.ddbDefinition.className&&e.definition.name===this.ddbDefinition.className&&(!this.ddbDefinition.subclassName||""===this.ddbDefinition.subclassName||this.ddbDefinition.subclassName&&e.subclassDefinition?.name===this.ddbDefinition.subclassName))),this._choices=this.noMods?[]:l.DDBDataUtils.getChoices({ddb:this.ddbData,type:this.type,feat:this.ddbDefinition,selectionOnly:!1}).reduce(((e,t)=>(null!==t.parentChoiceId||e.some((e=>e.id===t.id))||e.push(t),e)),[]),this._chosen=this.noMods?[]:l.DDBDataUtils.getChoices({ddb:this.ddbData,type:this.type,feat:this.ddbDefinition,selectionOnly:!0}),this._parentOnlyChoices=l.DDBDataUtils.getChoices({ddb:this.ddbData,type:this.type,feat:this.ddbDefinition,selectionOnly:!1,filterByParentChoice:!0}),this._parentOnlyChosen=l.DDBDataUtils.getChoices({ddb:this.ddbData,type:this.type,feat:this.ddbDefinition,selectionOnly:!0,filterByParentChoice:!0}),this.isChoiceFeature=this._choices.length>0,this.include=!this.isChoiceFeature,this.hasRequiredLevel=!this._class||this._class&&this._class.level>=this.ddbDefinition.requiredLevel,this.advancementHelper=new d.A({ddbData:this.ddbData,type:this.type,noMods:this.noMods})}_generateDataStub(){this.data={_id:foundry.utils.randomID(),name:i.utils.nameString(this.ddbDefinition.name),type:this.documentType,effects:[],system:l.SystemHelpers.getTemplate(this.documentType),flags:{ddbimporter:{id:this.ddbDefinition.id,type:this.tagType,entityTypeId:this.ddbDefinition.entityTypeId,is2014:this.is2014,is2024:!this.is2014,componentId:this.ddbDefinition.componentId,componentTypeId:this.ddbDefinition.componentTypeId,originalName:this.originalName,dndbeyond:{requiredLevel:this.ddbDefinition.requiredLevel,displayOrder:this.ddbDefinition.displayOrder,featureType:this.ddbDefinition.featureType,class:this.ddbDefinition.className,classId:this.ddbDefinition.classId,entityId:this.ddbDefinition.entityId,entityRaceId:this.ddbDefinition.entityRaceId,entityType:this.ddbDefinition.entityType}}}};const e=foundry.utils.getProperty(this.ddbDefinition,"requiredLevel");Number.isInteger(Number.parseInt(e))&&(this.data.system.prerequisites={level:Number.parseInt(e)}),this.data.system.identifier=this.identifier}_prepare(){this._generateActionTypes(),this._generateFlagHints(),this.excludedScaleUses=DDBFeature.LEVEL_SCALE_EXCLUSION_USES.includes(this.ddbDefinition.name)||DDBFeature.LEVEL_SCALE_EXCLUSION_USES.includes(this.data.name)||DDBFeature.LEVEL_SCALE_EXCLUSION_USES_STARTS_WITH.some((e=>this.originalName.startsWith(e))),this.scaleValueUsesLink=l.DDBDataUtils.getScaleValueLink(this.ddbData,this.ddbFeature,!0),this.useUsesScaleValueLink=!this.excludedScaleUses&&this.scaleValueUsesLink&&""!==this.scaleValueUsesLink&&"{{scalevalue-unknown}}"!==this.scaleValueUsesLink}async _buildNatural(){const e={name:this.data.name,description:this.ddbDefinition.description,snippet:this.ddbDefinition.snippet,id:this.ddbDefinition.id,entityTypeId:this.ddbDefinition.entityTypeId,componentId:this.ddbDefinition.componentId,componentTypeId:this.ddbDefinition.componentTypeId},t=foundry.utils.deepClone(CONFIG.DDB.naturalActions[0]);t.displayAsAttack=!0;const a=Object.assign(t,e);i.logger.debug(`Building Natural Attack for ${this.data.name}`);const n=new DDBAttackAction({ddbData:this.ddbData,ddbDefinition:a,rawCharacter:this.rawCharacter,type:this.type,documentType:"weapon"});n.naturalWeapon=!0,await n.loadEnricher(),await n.build(),this.data=n.data}async _buildBasic(){this._generateSystemType(),this._generateSystemSubType(),this._generateLimitedUse(),this._generateActivity({hintsOnly:!0}),await this.enricher.addAdditionalActivities(this),this._generateDescription({forceFull:!0}),await this._addEffects(void 0,this.type),this.enricher.addDocumentOverride(),this.data.system.identifier=i.utils.referenceNameString(`${this.data.name.toLowerCase()}${this.is2014?" - legacy":""}`)}async _generateFeatureAdvancements(){i.logger.info(`Generating feature advancements for ${this.ddbDefinition.name} are not yet supported`)}_addAdvancement(e){if(!e)return;const t=e.toObject();(0!==t.configuration.choices.length||0!==t.configuration.grants.length||t.value&&0!==Object.keys(t.value).length)&&this.data.system.advancement.push(t)}generateBackgroundAbilityScoreAdvancement(){const e=[],t=this.ddbData.character.feats.filter((e=>(this.ddbDefinition.grantedFeats??[]).some((t=>e.componentId===t.id&&(!!t.featIds.includes(e.definition.id)&&!!e.definition.categories.some((e=>"__INITIAL_ASI"===e.tagName))))))),a=this.ddbData.character.modifiers.feat.filter((e=>t.some((t=>e.componentTypeId==t.definition.entityTypeId))));if(0===a.length)return;const i=new game.dnd5e.documents.advancement.AbilityScoreImprovementAdvancement;i.updateSource({configuration:{points:3},level:0,value:{type:"asi"}});const n={};o.x.actor.abilities.forEach((e=>{const t=l.DDBModifiers.filterModifiers(a,"bonus",{subType:`${e.long}-score`}).length;t>0&&(n[e.value]=t)})),i.updateSource({value:{assignments:n}}),e.push(i.toObject()),this.data.system.advancement=this.data.system.advancement.concat(e)}_generateSkillAdvancements(){const e=(this.advancementHelper.noMods?[]:l.DDBModifiers.getModifiers(this.ddbData,this.type)).filter((e=>"proficiency"===e.type&&o.x.actor.skills.map((e=>e.subType)).includes(e.subType))),t=this.advancementHelper.getSkillAdvancement(e,this.ddbDefinition,void 0,0);this._addAdvancement(t)}_generateLanguageAdvancements(){const e=this.advancementHelper.noMods?[]:l.DDBModifiers.getModifiers(this.ddbData,this.type),t=this.advancementHelper.getLanguageAdvancement(e,this.ddbDefinition,0);this._addAdvancement(t)}_generateToolAdvancements(){const e=this.advancementHelper.noMods?[]:l.DDBModifiers.getModifiers(this.ddbData,this.type),t=this.advancementHelper.getToolAdvancement(e,this.ddbDefinition,0);this._addAdvancement(t)}_generateSkillOrLanguageAdvancements(){i.logger.info(`Generating skill or language advancements for ${this.ddbDefinition.name} are not yet supported`)}async generateAdvancements(){await this._generateFeatureAdvancements(),this._generateSkillAdvancements(),this._generateLanguageAdvancements(),this._generateToolAdvancements(),this._generateSkillOrLanguageAdvancements()}async buildBackgroundFeatAdvancements(e=[]){const t=foundry.utils.getProperty(this.ddbData,"character.background.definition.featList.featIds")??[],a=e.concat(t);if(0===a.length)return;const n=new game.dnd5e.documents.advancement.ItemGrantAdvancement,s=i.CompendiumHelper.getCompendiumType("feats",!1);s&&await s.getIndex({fields:["name","flags.ddbimporter.featId"]});const r=s?s.index.filter((e=>a.includes(foundry.utils.getProperty(e,"flags.ddbimporter.featId")))):[];n.updateSource({configuration:{items:r.map((e=>({uuid:e.uuid})))},title:"Feat"}),this.data.system.advancement.push(n.toObject());const o=foundry.utils.getProperty(this.data,"flags.ddbimporter.advancementLink")??[],l={_id:n._id,features:{}};l[n._id]={},r.forEach((e=>{l.features[e.name]=e.uuid})),o.push(l),foundry.utils.setProperty(this.data,"flags.ddbimporter.advancementLink",o)}async _buildBackground(){try{this._generateSystemType(),this._generateSystemSubType(),i.logger.debug(`Found background ${this.ddbDefinition.name}`),i.logger.debug(`Found ${this._choices.map((e=>e.label)).join(",")}`),this._generateDescription({forceFull:!0}),this.data.system.description.value+="<h3>Proficiencies</h3><ul>";for(const e of this._parentOnlyChoices)await this._addEffects(e,this.type),this.data.system.description.value+=`<li>${e.label}</li>`;this.data.system.description.value+="</ul>",this.data.img="icons/skills/trades/academics-book-study-purple.webp",this.data.name=this.data.name.split("Background: ").pop(),this.enricher.addDocumentOverride(),this.data.system.identifier=i.utils.referenceNameString(`${this.data.name.toLowerCase()}${this.is2014?" - legacy":""}`)}catch(e){i.logger.warn(`Unable to Generate Background Feature: ${this.name}, please log a bug report. Err: ${e.message}`,"extension"),i.logger.error("Error",e)}}static CHOICE_DEFS=o.x.parsing.choiceFeatures;async _buildChoiceFeature(){this._generateSystemType(),this._generateSystemSubType(),this._generateActivity({hintsOnly:!0}),await this.enricher.addAdditionalActivities(this);const e=[],t=DDBFeature.CHOICE_DEFS.USE_CHOSEN_ONLY.includes(this.originalName),a=(t?this._chosen:DDBFeature.CHOICE_DEFS.USE_ALL_CHOICES.includes(this.originalName)?this._choices:this._parentOnlyChoices).sort(((e,t)=>e.label<t.label?-1:e.label>t.label?1:0)).reduce(((t,a)=>{if(a.description){const e=new RegExp(`^(<p>)?(?:<em><strong>|<strong>|<strong><em>)${a.label}\\.(?:<\\/strong><\\/em>|<\\/strong>|<\\/em><\\/strong>)`),i=a.description.startsWith("<p>")?a.description.replace(e,"$1").trim():`<p>${a.description.replace(e,"$1").trim()}</p>`;return`${t}\n<p><strong>${a.label}</strong></p>\n${i}`}return e.push(`<li><p>${a.label}</p></li>`),t}),"").replaceAll("<p></p>",""),n=e.length>0?`${a}\n<ul>${e.join("")}</ul>`:a,s=DDBFeature.CHOICE_DEFS.NO_CHOICE_DESCRIPTION_ADDITION.includes(this.originalName)||["feat"].includes(this.type)?"":DDBFeature.CHOICE_DEFS.NO_CHOICE_BUILD.includes(this.originalName)||DDBFeature.CHOICE_DEFS.NO_CHOICE_SECRET.includes(this.originalName)?n:`<section class="secret">${n}</section>`;this._generateDescription({forceFull:t,extra:s}),await this._addEffects(void 0,this.type),this.enricher.addDocumentOverride(),this.data.system.identifier=i.utils.referenceNameString(`${this.data.name.toLowerCase()}${this.is2014?" - legacy":""}`)}async build(){try{this.naturalWeapon?await this._buildNatural():"background"===this.type?(this.isChoiceFeature=!1,await this._buildBackground()):this.isChoiceFeature?(i.logger.debug(`${this.name} has multiple choices and you need to pass this instance to DDBChoiceFeature`),await this._buildChoiceFeature()):await this._buildBasic()}catch(e){i.logger.warn(`Unable to Generate Basic Feature: ${this.name}, please log a bug report. Err: ${e.message}`,"extension"),i.logger.error("Error",e)}}}class DDBChoiceFeature extends DDBFeature{static KEEP_CHOICE_FEATURE=o.x.parsing.choiceFeatures.KEEP_CHOICE_FEATURE;static KEEP_CHOICE_FEATURE_NAME=o.x.parsing.choiceFeatures.KEEP_CHOICE_FEATURE_NAME;static KEEP_CHOICE_FEATURE_NAME_STARTSWITH=o.x.parsing.choiceFeatures.KEEP_CHOICE_FEATURE_NAME_STARTSWITH;static NO_FEATURE_PREFIX_NAME=o.x.parsing.choiceFeatures.NO_FEATURE_PREFIX_NAME;static NO_CHOICE_BUILD=o.x.parsing.choiceFeatures.NO_CHOICE_BUILD;static NO_CHOICE_ACTIVITY=o.x.parsing.choiceFeatures.NO_CHOICE_ACTIVITY;_prepare(){this._levelScale=null,this._levelScales=null,this._limitedUse=null,this._classOption=null,this._classFeatureComponent=l.DDBDataUtils.findComponentByComponentId(this.ddbData,this.ddbDefinition.id),this._classFeatureComponent||(this._classOption=[this.ddbData.character.options.race,this.ddbData.character.options.class,this.ddbData.character.options.feat].flat().find((e=>e.definition.id===this.ddbDefinition.componentId)),this._classOption&&(this._classFeatureComponent=l.DDBDataUtils.findComponentByComponentId(this.ddbData,this._classOption.componentId))),this._classFeatureComponent&&(this._levelScale=this._classFeatureComponent.levelScale,this._levelScales=this._classFeatureComponent.definition?.levelScales,this._limitedUse=this._classFeatureComponent.definition?.limitedUse),this.data.flags=foundry.utils.mergeObject(this.data.flags,this.extraFlags)}async build(e){try{this._generateSystemType(),i.logger.debug(`Adding choice ${e.label} to ${this.data.name}`);const t=`${this.data.name}`;if(this.data.name===e.label)return void this._generateSystemSubType();const a=new RegExp(`${this.data.name}(?:\\s*)- `);if(this.data.name=DDBChoiceFeature.KEEP_CHOICE_FEATURE_NAME.includes(this.ddbDefinition.name)||DDBChoiceFeature.KEEP_CHOICE_FEATURE_NAME_STARTSWITH.some((e=>this.ddbDefinition.name.startsWith(e)))||!e.label?this.data.name:e.label.startsWith(this.data.name.trim())?e.label.replace(a,`${this.data.name}: `):`${this.data.name}: ${e.label}`,DDBChoiceFeature.NO_FEATURE_PREFIX_NAME.includes(this.ddbDefinition.name)){const e=new RegExp(`(${this.ddbDefinition.name}(?:[\\s:-]*))`);this.data.name=`${this.data.name}`.replace(e,"")}this.data.name=i.utils.nameString(this.data.name);const n=/^(\d+: )(.*)$/.exec(this.data.name);n&&(this.data.name=n[2].trim());const s=/(.*) \((\d) points?\)/i,r=this.data.name.match(s);r&&(this.data.name=r[1],this.resourceCharges=Number.parseInt(r[2])),this.originalName=this.data.name,foundry.utils.setProperty(this.data,"flags.ddbimporter.originalName",this.originalName),await this.loadEnricher(),this._generateSystemSubType(),this.ddbDefinition.description=e.description,this.ddbDefinition.snippet=e.snippet?e.snippet:"",this._generateDescription({forceFull:!0}),foundry.utils.setProperty(this.data,"flags.ddbimporter.initialFeature",foundry.utils.deepClone(this.data.system.description)),foundry.utils.setProperty(this.ddbDefinition,"flags.ddbimporter.dndbeyond.choice",e),this.enricher.stopDefaultActivity||this._generateActivity(),await this.enricher.addAdditionalActivities(this),this._generateDescription({forceFull:!1}),this.data.flags.ddbimporter.dndbeyond.choice={parentName:t,label:e.label,choiceId:e.choiceId,componentId:e.componentId,componentTypeId:e.componentTypeId,parentChoiceId:e.parentChoiceId,subType:e.subType,wasOption:e.wasOption,entityTypeId:e.entityTypeId,type:e.type},this.data._id=foundry.utils.randomID(),this.enricher.addDocumentOverride(),await this._addEffects(e,this.type),this.data.system.identifier=i.utils.referenceNameString(`${this.data.name.toLowerCase()}${this.is2014?" - legacy":""}`)}catch(e){i.logger.warn(`Unable to Generate Choice Action: ${this.name}, please log a bug report. Err: ${e.message}`,"extension"),i.logger.error("Error",e)}}static NEVER_CHOICES=["Strength","Dexterity","Constitution","Intelligence","Wisdom","Charisma","Strength Score","Dexterity Score","Constitution Score","Intelligence Score","Wisdom Score","Charisma Score"];static _copyFlags=["class","classId","baseName","fullRaceName","groupName","isLineage","optionalFeature","subClass","subClassId"];static async buildChoiceFeatures(e,t=!1){const a=[];if(DDBChoiceFeature.NO_CHOICE_BUILD.includes(e.originalName))return a;const n=(t?e._parentOnlyChoices:e._parentOnlyChosen).filter((e=>!DDBChoiceFeature.NEVER_CHOICES.includes(e.label)));i.logger.debug(`Processing Choice Features ${n.map((e=>e.label)).join(",")}`,{_choices:e._choices,_parentOnlyChoices:e._parentOnlyChoices,_parentOnlyChosen:e._parentOnlyChosen,choices:n,_chosen:e._chosen,feature:e,allFeatures:t});const s={};for(const t of DDBChoiceFeature._copyFlags){const a=foundry.utils.getProperty(e.data.flags,`ddbimporter.${t}`);a&&foundry.utils.setProperty(s,`ddbimporter.${t}`,a)}for(const t of n){const r=new DDBChoiceFeature({ddbData:e.ddbData,ddbDefinition:foundry.utils.deepClone(e.ddbDefinition),type:e.type,rawCharacter:e.rawCharacter,extraFlags:s});await r.build(t),i.logger.debug(`DDBChoiceFeature.buildChoiceFeatures: ${r.ddbDefinition.name}`,{choiceFeature:r,choice:t,ddbFeature:e}),1!==n.length||DDBChoiceFeature.KEEP_CHOICE_FEATURE.includes(e.originalName)?a.push(r.data):(e.data.name=r.data.name,0!==Object.keys(e.data.system.activities).length||DDBChoiceFeature.NO_CHOICE_ACTIVITY.some((t=>e.originalName.startsWith(t)))||(e.data.system.activities=r.data.system.activities),0===e.data.effects.length&&(e.data.effects=r.data.effects))}return a}}class DDBClassFeatures{static EXCLUDED_FEATURES=["Expertise"];static EXCLUDED_FEATURES_2014=[];static EXCLUDED_FEATURES_2024=["Rage"];deriveFeatures(){this.ddbData.character.classes.forEach((e=>{const t=e.classFeatures,a=e.definition.classFeatures,i=e.subclassDefinition?.classFeatures,n=a.map((e=>e.id)),s=e.subclassDefinition?t.filter((t=>t.definition.classId===e.subclassDefinition.id)).map((e=>e.definition.id)):[],r=t.filter((t=>s.includes(t.definition.id)&&CharacterFeatureFactory.includedFeatureNameCheck(t.definition.name)&&t.definition.requiredLevel<=e.level&&!this.excludedFeatures.includes(t.definition.id))),o=t.filter((t=>n.includes(t.definition.id)&&CharacterFeatureFactory.includedFeatureNameCheck(t.definition.name)&&t.definition.requiredLevel<=e.level&&!this.excludedFeatures.includes(t.definition.id)&&!r.some((e=>e.definition.name===t.definition.name))));this.klassFeatures[e.definition.name]={derived:t,class:a,classFeatureIds:n,subclass:i,subclassFeatureIds:s,filtered:{class:o,subclass:r}}}))}constructor({ddbData:e,rawCharacter:t=null,ddbCharacter:a=null}={}){this.ddbCharacter=a,this.ddbData=e,this.rawCharacter=t,this.data=[],this._parsed={},this._generated=[],this._processed=[],this.klassFeatures={},this.ddbData.character.classes.forEach((e=>{this._parsed[e.definition.name]=[],this.klassFeatures[e.definition.name]=[],e.subclassDefinition&&(this._parsed[e.subclassDefinition.name]=[])})),this.excludedFeatures=this.ddbData.character.optionalClassFeatures.filter((e=>e.affectedClassFeatureId)).map((e=>e.affectedClassFeatureId)),this.deriveFeatures()}async _getFeatures({featureDefinition:e,type:t,source:a,filterByLevel:n=!0,flags:s={}}={}){const r=new u.DDBClassFeatureEnricher({activityGenerator:c.eK,fallbackEnricher:"Generic"});await r.init();const o=new DDBFeature({ddbCharacter:this.ddbCharacter,ddbData:this.ddbData,ddbDefinition:e,rawCharacter:this.rawCharacter,type:t,source:a,extraFlags:s,enricher:r});await o.loadEnricher(),await o.build();const l=!n||n&&o.hasRequiredLevel;if(i.logger.debug(`DDBClassFeatures._getFeatures generated: ${o.ddbDefinition.name}`,{featureDefinition:e,feature:o,this:this}),DDBClassFeatures.EXCLUDED_FEATURES.some((e=>o.name.startsWith(e)))||o.is2014&&DDBClassFeatures.EXCLUDED_FEATURES_2014.includes(o.originalName)||!o.is2014&&DDBClassFeatures.EXCLUDED_FEATURES_2024.includes(o.originalName))return i.logger.debug(`DDBClassFeatures._getFeatures: ${o.ddbDefinition.name} excluded`,{featureDefinition:e,feature:o,this:this}),[];if(!l)return i.logger.debug(`DDBClassFeatures._getFeatures: ${o.ddbDefinition.name} not allowed by level`,{featureDefinition:e,feature:o,this:this}),[];const d=o.isChoiceFeature?await DDBChoiceFeature.buildChoiceFeatures(o):[];return[o.data].concat(d)}async _generateClassFeatures(e){const t=e.definition.name,a=this.klassFeatures[e.definition.name].filtered.class,i=[];for(const n of a){const a=await this._getFeatures({featureDefinition:n,type:"class",source:t,flags:{ddbimporter:{class:e.definition.name,classId:e.definition.id}}});i.push(...a)}this._parsed[t]=foundry.utils.duplicate(i),i.sort(((e,t)=>e.flags.ddbimporter.dndbeyond.displayOrder-t.flags.ddbimporter.dndbeyond.displayOrder)).forEach((e=>{if(!CharacterFeatureFactory.isDuplicateFeature(this._generated,e)){const a=e.flags.ddbimporter.originalName??e.name,i=CharacterFeatureFactory.getNameMatchedFeature(this._processed,e),n=CharacterFeatureFactory.isDuplicateFeature(this._processed,e)||CharacterFeatureFactory.FORCE_DUPLICATE_FEATURE.includes(a);if(i&&!n){const a=`<h3>${t}: Level ${e.flags.ddbimporter.dndbeyond.requiredLevel}</h3>${e.system.description.value}`;i.system.description.value+=a,i.effects.push(...e.effects)}else i||this._processed.push(e)}})),this._generated.push(...i)}async _generateSubClassFeatures(e){const t=e.definition.name,a=`${e.subclassDefinition.name}`,i=[],n=this.klassFeatures[e.definition.name].filtered.subclass,s=foundry.utils.getProperty(e,"subclassDefinition");for(const a of n){const n=await this._getFeatures({featureDefinition:a,type:"class",source:`${t} : ${e.subclassDefinition.name}`,flags:{ddbimporter:{class:e.definition.name,classId:e.definition.id,subClass:s?.name,subClassId:s?.id}}});i.push(...n)}this._parsed[a]=foundry.utils.duplicate(i);const r=[];i.forEach((e=>{if(!CharacterFeatureFactory.isDuplicateFeature(this._parsed[t],e)){const t=e.flags.ddbimporter.originalName??e.name,i=CharacterFeatureFactory.getNameMatchedFeature(r,e),n=CharacterFeatureFactory.isDuplicateFeature(r,e)||CharacterFeatureFactory.FORCE_DUPLICATE_FEATURE.includes(t);if(i&&!n)if(CharacterFeatureFactory.FORCE_DUPLICATE_OVERWRITE.includes(t))i.system.description.value=`${e.system.description.value}`;else{const t=`<h3>${a}: At Level ${e.flags.ddbimporter.dndbeyond.requiredLevel}</h3>${e.system.description.value}`;i.system.description.value+=t}else i||r.push(e)}})),this._generated.push(...i),r.sort(((e,t)=>e.flags.ddbimporter.dndbeyond.displayOrder-t.flags.ddbimporter.dndbeyond.displayOrder)).forEach((e=>{const t=e.flags.ddbimporter.originalName??e.name,i=CharacterFeatureFactory.getNameMatchedFeature(this._processed,e),n=CharacterFeatureFactory.isDuplicateFeature(this._processed,e)||CharacterFeatureFactory.FORCE_DUPLICATE_FEATURE.includes(t);if(i&&!n)if(CharacterFeatureFactory.FORCE_DUPLICATE_OVERWRITE.includes(t))i.system.description.value=`${e.system.description.value}`;else{const t=`<h3>${a}: At Level ${e.flags.ddbimporter.dndbeyond.requiredLevel}</h3>${e.system.description.value}`;i.system.description.value+=t}else i||this._processed.push(e)}))}async build(){for(const e of this.ddbData.character.classes)i.logger.debug(`Processing class features for ${e.definition.name}`),await this._generateClassFeatures(e),e.subclassDefinition&&e.subclassDefinition.classFeatures&&(i.logger.debug(`Processing subclass features for ${e.subclassDefinition.name}`),await this._generateSubClassFeatures(e)),i.logger.debug(`ddbClassFeatures for ${e.definition.name}`,{ddbClassFeatures:this});this.data=foundry.utils.duplicate(this._processed)}}class CharacterFeatureFactory{static LEGACY_SKIPPED_FEATURES=o.x.parsing.features.LEGACY_SKIPPED_FEATURES;static SKIPPED_FEATURES_2014=o.x.parsing.features.SKIPPED_FEATURES_2014;static TASHA_VERSATILE=o.x.parsing.features.TASHA_VERSATILE;static SKIPPED_FEATURES=o.x.parsing.features.SKIPPED_FEATURES;static SKIPPED_FEATURES_STARTS_WITH=o.x.parsing.features.SKIPPED_FEATURES_STARTS_WITH;static SKIPPED_FEATURES_ENDS_WITH=o.x.parsing.features.SKIPPED_FEATURES_ENDS_WITH;static SKIPPED_FEATURES_INCLUDES=o.x.parsing.features.SKIPPED_FEATURES_INCLUDES;static FORCE_DUPLICATE_FEATURE=o.x.parsing.features.FORCE_DUPLICATE_FEATURE;static FORCE_DUPLICATE_OVERWRITE=o.x.parsing.features.FORCE_DUPLICATE_OVERWRITE;constructor(e){this.ddbCharacter=e,this.ddbData=e.source.ddb,this.rawCharacter=e.raw.character,this.parsed={actions:[],features:[]},this.processed={actions:[],features:[]},this.data={actions:[],features:[]},this.excludedOriginFeatures=this.ddbData.character.optionalOrigins.filter((e=>e.affectedRacialTraitId)).map((e=>e.affectedRacialTraitId))}static isDuplicateFeature(e,t){return e.some((e=>e.name===t.name&&e.system.description.value===t.system.description.value))}static getNameMatchedFeature(e,t){return e.find((e=>e.name===t.name&&t.flags.ddbimporter.type===e.flags.ddbimporter.type))}static includedFeatureNameCheck(e){const t=game.settings.get(o.y.MODULE_ID,"character-update-policy-include-versatile-features"),a=!CharacterFeatureFactory.LEGACY_SKIPPED_FEATURES.includes(e)&&!CharacterFeatureFactory.SKIPPED_FEATURES.includes(e)&&!CharacterFeatureFactory.SKIPPED_FEATURES_STARTS_WITH.some((t=>e.startsWith(t)))&&!CharacterFeatureFactory.SKIPPED_FEATURES_ENDS_WITH.some((t=>e.endsWith(t)))&&!CharacterFeatureFactory.SKIPPED_FEATURES_INCLUDES.some((t=>e.includes(t)))&&!e.match(/(?:\w+) Weapon Masteries(?:y|ies)(?:$|:)/gim)&&!e.match(/(?:\d+:) Weapon Master(?:y|ies)(?:$|:)/gim)&&(t||!t&&!CharacterFeatureFactory.TASHA_VERSATILE.includes(e));return i.logger.debug(`Checking ${e}, status: ${a}`),a}_getCustomActions(e){return this.ddbData.character.customActions.filter((t=>t.displayAsAttack===e)).map((e=>{e.dice={diceString:e.diceCount&&e.diceType?`${e.diceCount}d${e.diceType}`:null,fixedValue:e.fixedValue};const t={aoeType:e.aoeType,aoeSize:e.aoeSize,range:e.range,long:e.longRange};return e.range=t,e.statId&&(e.abilityModifierStatId=e.statId),e.activation={activationTime:e.activationTime,activationType:e.activationType},e.isCustomAction=!0,e}))}async getUnarmedStrike(e={}){const t=CONFIG.DDB.naturalActions[0];t.displayAsAttack=!0;const a=Object.assign(t,e),i=new(0,CharacterFeatureFactory.DDB_TYPE_ENRICHERS.other)({activityGenerator:c.eK});await i.init();return await this.getFeatureFromAction({action:a,enricher:i,isAttack:!0})}async _generateUnarmedStrikeAction(e={}){const t=await this.getUnarmedStrike(e);this.parsed.actions.push(t)}static DDB_TYPE_ENRICHERS={class:u.DDBClassFeatureEnricher,race:u.DDBSpeciesTraitEnricher,feat:u.DDBFeatEnricher,other:u.DDBGenericEnricher,background:u.DDBBackgroundEnricher};async _generateAttackActions(){const e=[this.ddbData.character.actions.class.filter((e=>l.DDBDataUtils.findClassByFeatureId(this.ddbData,e.componentId))).map((e=>(e.actionSource="class",e))),this.ddbData.character.actions.race.map((e=>(e.actionSource="race",e))),this.ddbData.character.actions.feat.map((e=>(e.actionSource="feat",e))),this._getCustomActions(!0)].flat().filter((e=>e.name&&""!==e.name&&(e.isCustomAction||DDBAction.KEEP_ACTIONS.some((t=>i.utils.nameString(e.name)===t))||DDBAction.KEEP_ACTIONS_STARTSWITH.some((t=>i.utils.nameString(e.name).startsWith(t)))))).filter((e=>l.DDBDataUtils.displayAsAttack(this.ddbData,e,this.rawCharacter))),t=(await Promise.all(e.map((async e=>{const t=new(0,CharacterFeatureFactory.DDB_TYPE_ENRICHERS[e.actionSource??"other"])({activityGenerator:c.eK});await t.init();return await this.getFeatureFromAction({action:e,type:e.actionSource,enricher:t,isAttack:!0})})))).filter((e=>!foundry.utils.hasProperty(e,"flags.ddbimporter.skip")));i.logger.debug("attack actions",t),this.parsed.actions=this.parsed.actions.concat(t)}actionParsed(e){return this.parsed.actions.some((t=>(foundry.utils.getProperty(t,"flags.ddbimporter.originalName")??t.name)===e))}_highestLevelActionFeature(e,t){return this.ddbData.character.actions[t].filter((t=>t.name===e.name)).reduce(((e,t)=>{const a=l.DDBDataUtils.findClassByFeatureId(this.ddbData,t.componentId),i=a.classFeatures.find((e=>e.definition.id===t.componentId));return i?i.definition.requiredLevel>a.level||e.definition.requiredLevel>i.definition.requiredLevel?e:i:e}),{componentId:null,definition:{requiredLevel:0}})}async _generateOtherActions(){const e=[this.ddbData.character.actions.class.filter((e=>l.DDBDataUtils.findClassByFeatureId(this.ddbData,e.componentId)&&(!DDBAction.HIGHEST_LEVEL_ONLY_ACTION_MATCH.includes(i.utils.nameString(e.name))||DDBAction.HIGHEST_LEVEL_ONLY_ACTION_MATCH.includes(i.utils.nameString(e.name))&&this._highestLevelActionFeature(e,"class")?.definition?.id===e.componentId))).map((e=>(e.actionSource="class",e))),this.ddbData.character.actions.race.map((e=>(e.actionSource="race",e))),this.ddbData.character.actions.feat.map((e=>(e.actionSource="feat",e))),this._getCustomActions(!1)].flat().filter((e=>e.name&&""!==e.name&&(e.isCustomAction||DDBAction.KEEP_ACTIONS.some((t=>i.utils.nameString(e.name)===t))||DDBAction.KEEP_ACTIONS_STARTSWITH.some((t=>i.utils.nameString(e.name).startsWith(t)))))).filter((e=>{const t=l.DDBDataUtils.getName(this.ddbData,e,this.rawCharacter);return!this.actionParsed(t)})),t=(await Promise.all(e.map((async e=>{i.logger.debug(`Getting Other Action ${e.name}`);const t=new(0,CharacterFeatureFactory.DDB_TYPE_ENRICHERS[e.actionSource??"other"])({activityGenerator:c.eK});await t.init();return await this.getFeatureFromAction({action:e,type:e.actionSource,enricher:t,isAttack:!1})})))).filter((e=>!foundry.utils.hasProperty(e,"flags.ddbimporter.skip")));i.logger.debug("other actions",t),this.parsed.actions=this.parsed.actions.concat(t)}async processActions(){await this._generateAttackActions(),await this._generateUnarmedStrikeAction(),await this._generateOtherActions(),this.processed.actions=foundry.utils.duplicate(this.parsed.actions),this.processed.actions.sort().sort(((e,t)=>{if(Object.values(e.system.activities).some((e=>foundry.utils.hasProperty(e,"activation.type")))){if(Object.values(t.system.activities).some((e=>foundry.utils.hasProperty(e,"activation.type")))){const a=o.x.actions.activationTypes.find((t=>t.value===Object.values(e.system.activities).find((e=>foundry.utils.hasProperty(e,"activation.type"))).activation.type)).id,i=o.x.actions.activationTypes.find((e=>e.value===Object.values(t.system.activities).find((e=>foundry.utils.hasProperty(e,"activation.type"))).activation.type)).id;return a>i?1:a<i?-1:0}return-1}return 1}));for(const e of this.processed.actions)await DDBFeatureMixin.finalFixes(e);this.updateIds("actions")}updateIds(e){this.ddbCharacter.updateItemIds(this.processed[e])}#e(e,t){const a=foundry.utils.getProperty(e,"flags.ddbimporter.advancementLink"),n=e.system.advancement[t],s=a.find((e=>e._id===n._id));if(!s||!a||!n)return void i.logger.warn(`Advancement for ${e.name} (idx ${t}) missing required data for linking`,{advancement:n,linkingData:a,dataLink:s});const r={};for(const[t,a]of Object.entries(s.features)){i.logger.debug(`Advancement ${n._id} searching for Feature ${t} (${a})`,{advancement:n,advancementFeatureName:t,uuid:a});const s=this.ddbCharacter.getDataFeature(t);s&&(i.logger.debug(`Advancement ${n._id} found Feature ${t} (${a})`),r[s._id]=a,foundry.utils.setProperty(s,"flags.dnd5e.sourceId",a),foundry.utils.setProperty(s,"flags.dnd5e.advancementOrigin",`${e._id}.${n._id}`))}Object.keys(r).length>0&&(n.value={added:r},e.system.advancement[t]=n)}#a(e=["actions","features"]){for(const t of e)for(const e of this.ddbCharacter.data[t]){if(foundry.utils.hasProperty(e,"flags.dnd5e.advancementOrigin"))continue;const t=foundry.utils.getProperty(e,"flags.ddbimporter.type")??foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.type"),a=foundry.utils.getProperty(e,"flags.ddbimporter.class")??foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.class");if("race"==t&&foundry.utils.hasProperty(this.ddbCharacter,"data.race._id"))foundry.utils.setProperty(e,"flags.dnd5e.advancementOrigin",`${this.ddbCharacter.data.race._id}`);else if("background"===t){const t=this.ddbCharacter.data.features.find((e=>"background"===e.type));t&&foundry.utils.setProperty(e,"flags.dnd5e.advancementOrigin",`${t._id}`)}else if("class"===t&&a){const t=this.ddbCharacter.data.classes.find((e=>e.name===a));t&&foundry.utils.setProperty(e,"flags.dnd5e.advancementOrigin",`${t._id}`)}}}linkFeatures(e=["actions","features"]){i.logger.debug("Linking Feature Factory Advancements to Features",{CharacterFeatureFactory:this,types:e});for(const t of e)for(const e of this.ddbCharacter.data[t]){const t=foundry.utils.getProperty(e,"flags.ddbimporter.advancementLink");if(t){i.logger.debug("Linking Advancements to Features",{feature:e,linkingData:t});for(let a=0;a<e.system.advancement.length;a++){const i=e.system.advancement[a],n=t.find((e=>e._id===i._id));"ItemGrant"===i.type&&n&&this.#e(e,a)}}}this.#a(e)}async getFeaturesFromDefinition(e,t,a={}){const n=i.DDBSources.parseSource(e.definition?e.definition:e),s=new DDBFeature({ddbCharacter:this.ddbCharacter,ddbData:this.ddbData,ddbDefinition:e,rawCharacter:this.rawCharacter,type:t,source:n,extraFlags:a,fallbackEnricher:"Generic"});await s.loadEnricher(),await s.build(),i.logger.debug(`CharacterFeatureFactory.getFeaturesFromDefinition (type: ${t}): ${s.ddbDefinition.name}`,{ddbFeature:s,featDefinition:e,this:this,type:t}),"background"===t&&(s.generateBackgroundAbilityScoreAdvancement(),await s.generateAdvancements(),await s.buildBackgroundFeatAdvancements());const r=s.isChoiceFeature?await DDBChoiceFeature.buildChoiceFeatures(s):[];return[s.data].concat(r)}fixAcEffects(e="features"){for(const t of this.parsed[e]){i.logger.debug(`Checking ${t.name} for AC effects`);for(const e of t.effects??[])!["Natural","Unarmored Defense","Custom","Unarmored"].includes(this.ddbCharacter.armor.results.maxType)&&(2===e.changes.length&&e.changes.some((e=>"system.attributes.ac.formula"===e.key))&&e.changes.some((e=>"system.attributes.ac.calc"===e.key))||1===e.changes.length&&e.changes.some((e=>"system.attributes.ac.calc"===e.key)))&&(e.disabled=!0)}}async _buildRacialTraits(e="features"){i.logger.debug("Parsing racial traits");const t=this.ddbData.character.race.racialTraits.filter((e=>CharacterFeatureFactory.includedFeatureNameCheck(e.definition.name)&&!e.definition.hideInSheet&&!this.excludedOriginFeatures.includes(e.definition.id)&&this.ddbCharacter.totalLevels>=(e.requiredLevel??1)));for(const a of t){(await this.getFeaturesFromDefinition(a,"race")).forEach((t=>{const i=CharacterFeatureFactory.getNameMatchedFeature(this.parsed[e],t),n=CharacterFeatureFactory.isDuplicateFeature(this.parsed[e],t)||CharacterFeatureFactory.FORCE_DUPLICATE_FEATURE.includes(t.flags.ddbimporter.originalName??t.name);i&&!n?i.system.description.value+=`<h3>Racial Trait Addition</h3>${t.system.description.value}`:i||(foundry.utils.setProperty(t,"flags.ddbimporter.baseName",a.definition.fullName??a.definition.name),foundry.utils.setProperty(t,"flags.ddbimporter.fullRaceName",this.ddbCharacter._ddbRace.fullName),foundry.utils.setProperty(t,"flags.ddbimporter.groupName",this.ddbCharacter._ddbRace.groupName),foundry.utils.setProperty(t,"flags.ddbimporter.isLineage",this.ddbCharacter._ddbRace.isLineage),this.parsed[e].push(t))}))}}async _addFeats(e="features"){i.logger.debug("Parsing feats");const t=this.ddbData.character.feats.filter((e=>CharacterFeatureFactory.includedFeatureNameCheck(e.definition.name)));for(const a of t){const t=await this.getFeaturesFromDefinition(a,"feat");this.parsed[e].push(...t)}}async _addBackground(e="features"){i.logger.debug("Parsing background");const t=this.ddbCharacter.getBackgroundData(),a=await this.getFeaturesFromDefinition(t,"background");this.parsed[e].push(...a)}async _buildOptionalClassFeatures({type:e="features",requireLevel:t=!0}={}){if(i.logger.debug("Parsing optional class features"),this.ddbData.classOptions){const a=this.ddbData.classOptions.filter((e=>{if(!t||!foundry.utils.hasProperty(e,"requiredLevel"))return!0;const a=foundry.utils.getProperty(e,"requiredLevel"),n=this.ddbData.character.classes.find((t=>t.definition.id===e.classId||t.subclassDefinition?.id===e.classId));return n?n.level>=a:(i.logger.info(`Unable to determine class for optional feature ${e.name}, you might not have a suitable subclass`,{feat:e,this:this,requiredLevel:a}),!1)})).filter((e=>CharacterFeatureFactory.includedFeatureNameCheck(e.name)));for(const t of a){i.logger.debug(`Parsing Optional Feature ${t.name}`);const a=this.ddbData.character.classes.find((e=>e.definition.id===t.classId||e.subclassDefinition?.id===t.classId)),n={ddbimporter:{class:a.definition.name,classId:a.definition.id,optionalFeature:!0}},s=await this.getFeaturesFromDefinition(t,"class",n);this.parsed[e].push(...s)}}}_setLevelScales(e="features"){this.parsed[e].forEach((e=>{const t=i.utils.referenceNameString(e.name).toLowerCase(),a=this.ddbCharacter.raw.classes.find((e=>e.system.advancement.some((e=>"ScaleValue"===e.type&&e.configuration.identifier===t))));if(a&&!foundry.utils.hasProperty(e,"flags.ddbimporter.skipScale")){const n=i.utils.referenceNameString(a.system.identifier).toLowerCase(),s=l.SystemHelpers.buildDamagePart({damageString:`@scale.${n}.${t}`});if(foundry.utils.hasProperty(e,"system.damage.base"))e.system.damage.base.custom=s.custom;else if(foundry.utils.hasProperty(e,"system.activities"))for(const[t,a]of Object.entries(e.system.activities))a.damage&&0===a.damage.parts.length?a.damage.parts=[s]:a.damage&&a.damage.parts.length>0&&(a.damage.parts[0].custom=s.custom),e.system.activities[t]=a}}))}async _buildClassFeatures(){i.logger.debug("Parsing class and subclass features"),this._ddbClassFeatures=new DDBClassFeatures({ddbCharacter:this.ddbCharacter,ddbData:this.ddbData,rawCharacter:this.rawCharacter}),await this._ddbClassFeatures.build(),await this._buildOptionalClassFeatures(),i.logger.debug("ddbClassFeatures._buildClassFeatures",{ddbClassFeature:this._ddbClassFeatures,this:this}),i.logger.debug("Removing matching traits"),this._ddbClassFeatures.data.forEach((e=>{const t=CharacterFeatureFactory.getNameMatchedFeature(this.parsed.features,e),a=CharacterFeatureFactory.isDuplicateFeature(this.parsed.features,e)||CharacterFeatureFactory.FORCE_DUPLICATE_FEATURE.includes(e.flags.ddbimporter.originalName??e.name);if(t&&!a)if(CharacterFeatureFactory.FORCE_DUPLICATE_OVERWRITE.includes(e.flags.ddbimporter.originalName??e.name))t.system.description.value=`${e.system.description.value}`;else{const a=`<h3>${e.flags.ddbimporter.dndbeyond.class}</h3>${e.system.description.value}`;t.system.description.value+=a}else t||this.parsed.features.push(e)}))}async processFeatures(){await this._buildRacialTraits(),await this._buildClassFeatures(),await this._addFeats(),await this._addBackground(),this._setLevelScales();for(const e of this.parsed.features)await DDBFeatureMixin.finalFixes(e);this.fixAcEffects(),this.processed.features=foundry.utils.deepClone(this.parsed.features),this.updateIds("features")}async getFeatureFromAction({action:e,type:t,isAttack:a=null,manager:n=null,extraFlags:s={},enricher:r=null}){const o=a??l.DDBDataUtils.displayAsAttack(this.ddbData,e,this.rawCharacter),d=o?new DDBAttackAction({ddbCharacter:this.ddbCharacter,ddbData:this.ddbData,ddbDefinition:e,rawCharacter:this.rawCharacter,type:t??e.actionSource,extraFlags:s,enricher:r}):new DDBAction({ddbCharacter:this.ddbCharacter,ddbData:this.ddbData,ddbDefinition:e,rawCharacter:this.rawCharacter,type:t??e.actionSource,extraFlags:s,enricher:r});return n&&(d.enricher.manager=n),i.logger.debug(`Building Action ${e.name}`,{ddbAction:d,isAttackAction:o}),await d.loadEnricher(),await d.build(),d.data}getActions({name:e,type:t}){const a=this.ddbData.character.actions[t].filter((t=>i.utils.nameString(t.name)===e));return(a.length>1?a.filter((e=>"class"!==t||this._highestLevelActionFeature(e,t)?.definition?.id===e.componentId)):a).map((e=>(e.actionSource=t,e)))}async addToCompendiums(){if(!game.settings.get(o.y.MODULE_ID,"character-update-policy-add-features-to-compendiums"))return;const e=game.settings.get(o.y.MODULE_ID,"character-update-policy-update-add-features-to-compendiums"),t=[];t.push(...this.data.features),t.push(...this.data.actions);const a=t.filter((e=>"feat"===e.type)),n=new i.DDBCompendiumFolders("features",{noCreateClassFolders:!0});await n.loadCompendium("features");const s=[];for(const e of this.ddbData.character.classes)s.push(e.definition.name),await n.createClassFeatureFolder(e.definition.name),e.subclassDefinition&&await n.createSubClassFeatureFolder(e.subclassDefinition.name,e.definition.name);const r={chrisPremades:!0,removeSRDDuplicates:!1,filterDuplicates:!1,deleteBeforeUpdate:!1,matchFlags:["id"],useCompendiumFolders:!0,indexFilter:{fields:["name","flags.ddbimporter","system.type.subtype"]}};for(const t of s){i.logger.debug(`Processing class ${t} into the class compendium`);const n=a.filter((e=>["class","subclass"].includes(foundry.utils.getProperty(e,"flags.ddbimporter.type"))&&!foundry.utils.getProperty(e,"flags.ddbimporter.infusionFeature")&&(t===foundry.utils.getProperty(e,"flags.ddbimporter.class")||t===foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.class"))));i.logger.debug(`Adding class features for ${t} to the class compendium`,{classFeatures:n});const s=await i.DDBItemImporter.buildHandler("features",n,e,r);await s.buildIndex(r.indexFilter)}const l=new i.DDBCompendiumFolders("traits");await l.loadCompendium("traits");const d=a.filter((e=>["race","trait","species"].includes(foundry.utils.getProperty(e,"flags.ddbimporter.type"))&&!foundry.utils.hasProperty(e,"flags.ddbimporter.dndbeyond.choice")));i.logger.debug("Adding species traits to the species compendium",{traitFeatures:d});const c=this.ddbCharacter._ddbRace.groupName,u=this.ddbCharacter._ddbRace.fullName,m=this.ddbCharacter._ddbRace.isLineage;m?await l.createSubTraitFolders(c,c):await l.createSubTraitFolders(c,u);const p={chrisPremades:!0,matchFlags:m?["groupName","isLineage","is2014","legacy"]:["fullRaceName","groupName","isLineage","is2014","legacy"],useCompendiumFolders:!0,deleteBeforeUpdate:!1},g=await i.DDBItemImporter.buildHandler("trait",d,e,p);await g.buildIndex(p.indexFilter);const h={chrisPremades:!0,deleteBeforeUpdate:!1,matchFlags:["id","is2014"]},f=new i.DDBCompendiumFolders("feats");await f.loadCompendium("feats");const y=a.filter((e=>["feat"].includes(foundry.utils.getProperty(e,"flags.ddbimporter.type"))&&!foundry.utils.hasProperty(e,"flags.ddbimporter.dndbeyond.choice")));i.logger.debug("Adding feats to the feats compendium",{featFeatures:y});for(const e of y)await f.createFeatFolder(e);const b=await i.DDBItemImporter.buildHandler("feats",y,e,h);await b.buildIndex(h.indexFilter);const D=new i.DDBCompendiumFolders("backgrounds");await D.loadCompendium("backgrounds");const v=t.filter((e=>["background"].includes(foundry.utils.getProperty(e,"flags.ddbimporter.type"))&&!foundry.utils.hasProperty(e,"flags.ddbimporter.dndbeyond.choice")));i.logger.debug("Adding backgrounds to the backgrounds compendium",{backgroundFeatures:v});for(const e of v)await D.createBackgroundFolder(e);const C=await i.DDBItemImporter.buildHandler("background",v,e,h);await C.buildIndex(h.indexFilter)}filterActionFeatures(){this.data.actions=this.processed.actions.map((e=>{const t=foundry.utils.getProperty(e,"flags.ddbimporter.originalName")??e.name,a=this.processed.features.find((a=>{const n=foundry.utils.getProperty(a,"flags.ddbimporter.originalName")??a.name,s=n.split(":")[0].trim(),r=new RegExp(`${i.utils.regexSanitizeString(s)}(?:\\s*)-`),o=foundry.utils.getProperty(a,"flags.ddbimporter.type"),l=foundry.utils.getProperty(e,"flags.ddbimporter.type"),d=t.replace(r,`${s}:`);return(n===t||d===n||a.name===e.name||d===a.name)&&o===l}));if(a){const n=foundry.utils.getProperty(a,"flags.ddbimporter.originalName")??a.name;if(foundry.utils.setProperty(e,"flags.ddbimporter.featureNameMatch",n),e.system.description.value,e.system.description.value=a.system.description.value,""===e.system.description.chat&&(e.system.description.chat=a.system.description.chat),e.system.source=a.system.source,foundry.utils.setProperty(e,"flags.ddbimporter.featureMeta",a.flags.ddbimporter),i.logger.debug(`Found match for ${t} and ${a.name}`,{action:foundry.utils.deepClone(e),feature:foundry.utils.deepClone(a)}),0===Object.keys(e.system.activities).length)for(const[t,i]of Object.entries(a.system.activities))e.system.activities[t]?e.system.activities[t]&&0===e.system.activities[t].effects?.length&&(e.system.activities[t].effects=a.system.activities[t].effects):e.system.activities[t]=i;else for(const t of Object.keys(a.system.activities))e.system.activities[t]&&0===e.system.activities[t].effects?.length&&(e.system.activities[t].effects=a.system.activities[t].effects);if(0===Object.keys(a.system.activities).length&&Object.keys(e.system.activities).length>0&&a.effects.length>0&&0===e.effects.length)for(const t of Object.keys(e.system.activities)){if(foundry.utils.getProperty(e.system.activities[t],"flags.ddbimporter.noeffect"))continue;const i=[];for(const n of a.effects){if(n.transfer)continue;if(foundry.utils.getProperty(n,"flags.ddbimporter.noeffect"))continue;const a=foundry.utils.getProperty(n,"flags.ddbimporter.activityMatch");if(a&&e.system.activities[t].name!==a)continue;const s=n._id??foundry.utils.randomID();n._id=s,i.push({_id:s})}e.system.activities[t].effects=i}if(e.effects&&0===e.effects.length&&a.effects&&a.effects.length>0){e.effects=a.effects;const t=foundry.utils.duplicate(a.flags);delete t.ddbimporter,foundry.utils.mergeObject(e.flags,t,{overwrite:!0,insertKeys:!0,insertValues:!0})}!a.system.uses.max||!i.utils.isString(a.system.uses.max)&&e.system.uses.max||(e.system.uses.max=a.system.uses.max),foundry.utils.hasProperty(a,"system.prerequisites.level")&&foundry.utils.setProperty(e,"system.prerequisites.level",a.system.prerequisites.level)}return e})),this.data.features=this.processed.features.filter((e=>DDBAction.KEEP_ACTIONS.includes(foundry.utils.getProperty(e,"flags.ddbimporter.originalName")??e.name)||!this.data.actions.some((t=>((foundry.utils.getProperty(t,"flags.ddbimporter.originalName")??t.name).trim().toLowerCase()===(foundry.utils.getProperty(e,"flags.ddbimporter.originalName")??e.name).trim().toLowerCase()||foundry.utils.getProperty(t,"flags.ddbimporter.featureNameMatch")===(foundry.utils.getProperty(e,"flags.ddbimporter.originalName")??e.name))&&!0!==foundry.utils.getProperty(t,"flags.ddbimporter.isCustomAction")&&foundry.utils.getProperty(e,"flags.ddbimporter.type")===foundry.utils.getProperty(t,"flags.ddbimporter.type")))))}}class DDBInfusion{_init(){i.logger.debug(`Generating Infusion Feature ${this.ddbInfusion.name}`)}_generateDataStub(){this.data={_id:i.utils.namedIDStub(this.name,{postfix:this.nameIdPostfix}),name:i.utils.nameString(`Infusion: ${this.name}`),type:this.documentType,system:l.SystemHelpers.getTemplate(this.documentType),effects:[],flags:{ddbimporter:{id:this.ddbInfusion.id,infusionId:this.ddbInfusion.id,class:this.originClass,infusionFeature:!0,type:this.tagType,dndbeyond:{defintionKey:this.ddbInfusion.definitionKey,requiredLevel:this.ddbInfusion.level,modifierType:this.ddbInfusion.modifierDataType,type:this.ddbInfusion.type,requiresAttunement:this.ddbInfusion.requiresAttunement,allowDuplicates:this.ddbInfusion.allowDuplicates}}}},this.requiredLevel=null;const e=foundry.utils.getProperty(this.ddbInfusion,"level");Number.isInteger(Number.parseInt(e))&&(this.data.system.prerequisites={level:Number.parseInt(e)},this.requiredLevel=Number.parseInt(e)),this.data.system.source=i.DDBSources.parseSource(this.ddbInfusion),this.data.system.source.rules="2014",this.requiredLevel&&this.requiredLevel>1&&(this.data.system.requirements=` ${i.utils.ordinalSuffixOf(this.requiredLevel)}-level ${this.originClass}`)}_getActivityType(){return["augment","replicate"].includes(this.ddbInfusion.type)?"enchant":"creature"===this.ddbInfusion.type?"summon":void 0}constructor({ddbData:e,ddbInfusion:t,documentType:a="feat",rawCharacter:n=null,noMods:s=!1,addToCompendium:r=!0,nameIdPostfix:o=null}={}){this.ddbData=e,this.rawCharacter=n,this.ddbInfusion=t,this.name=i.utils.nameString(this.ddbInfusion.name),this.type="feat",this.originClass="Artificer",this.isAction=!1,this.documentType=a,this.tagType="infusion",this.data={},this.actions=[],this.grantedItems=[],this.noMods=s,this.idNames=[],this.compendium=null,this.snippet="",this._init(),this._generateDataStub(),this.addToCompendium=r,this.nameIdPostfix=o,this.activityType=this._getActivityType(),this.enricher=new u.DDBClassFeatureEnricher({activityGenerator:c.eK,fallbackEnricher:"Generic"})}_buildBaseActivity(){this.activity=new u.mixins.DDBBasicActivity({type:this.activityType,actor:this.rawCharacter,foundryFeature:this.data}),this.activity.data.consumption.targets=[{type:"itemUses",target:"",value:1,scaling:{mode:"",formula:""}}],this.activity.data.restrictions={type:"",allowMagical:!1},"summon"===this.activityType&&(this.activity.data.activation.type="action",this.activity.data.activation.value=1)}_buildDescription(){this.snippet=this.ddbInfusion.snippet?this.ddbInfusion.snippet:"";const e=game.settings.get("ddb-importer","add-description-to-chat"),t=foundry.utils.getProperty(this.ddbInfusion,"itemRuleData.text"),a=this.requiredLevel&&this.requiredLevel>1?`<p><i>Prerequisites: ${i.utils.ordinalSuffixOf(this.requiredLevel)}-level ${this.originClass}</i></p>`:"",n=t?`<p><i>Item: ${t}</i></p>`:"",s=l.DDBReferenceLinker.parseDamageRolls({text:this.ddbInfusion.description,document:this.data,actor:null}),r=e?l.DDBReferenceLinker.parseDamageRolls({text:this.snippet,document:this.data,actor:null}):"";this.data.system.description={value:l.DDBReferenceLinker.parseTags(a+n+s),chat:e?l.DDBReferenceLinker.parseTags(r):""}}_generateSystemType(){foundry.utils.setProperty(this.data,"system.type.value","enchantment"),foundry.utils.setProperty(this.data,"system.type.subtype",`${this.originClass.toLowerCase()}Infusion`)}_generateEnchantmentType(){"replicate"===this.ddbInfusion.type&&foundry.utils.setProperty(this.activity,"data.restrictions.allowMagical",!0);let e="";const t=foundry.utils.getProperty(this.ddbInfusion,"itemRuleData.text");t&&(t.includes("weapon")?e="weapon":t.includes("armor")||t.includes("shield")?e="equipment":t.includes("gem")&&(e="loot"),foundry.utils.setProperty(this.activity,"data.restrictions.type",e))}async compendiumInit(){this.compendiumFolders=new i.DDBCompendiumFolders("features",{noCreateClassFolders:!0}),await this.compendiumFolders.loadCompendium("features"),await this.compendiumFolders.createClassFeatureFolder(this.originClass)}async addInfusionsToCompendium(e){const t={chrisPremades:!1,deleteBeforeUpdate:!1,removeSRDDuplicates:!1,filterDuplicates:!1,matchFlags:["infusionId"],useCompendiumFolders:!0};i.logger.debug("Creating infusion compendium feature",{documents:e,handlerOptions:t,addToCompendium:this.addToCompendium,this:this});const a=this.addToCompendium?await i.DDBItemImporter.buildHandler("features",e,!0,t):new i.DDBItemImporter("features",e,t);await a.buildIndex({fields:["name","flags.ddbimporter.classId","flags.ddbimporter.class","flags.ddbimporter.subClass","flags.ddbimporter.parentClassId","flags.ddbimporter.originalName","flags.ddbimporter.infusionId"]});return await a.compendiumIndex.filter((e=>a.documents.some((t=>e.name===t.name))))}async _buildActions(){if(this.ddbInfusion.actions){for(const e of this.ddbInfusion.actions){if(!e.name){const t=foundry.utils.getProperty(e,"activation.activationType"),a=[3,4].includes(t)?` (${i.utils.capitalize(o.x.actions.activationTypes.find((e=>e.id===t)).value)})`:"";e.name=`${this.name}${a}`}const t=l.DDBDataUtils.displayAsAttack(this.ddbData,e,this.rawCharacter)?new DDBAttackAction({ddbData:this.ddbData,ddbDefinition:e,rawCharacter:this.rawCharacter,type:e.actionSource,enricher:this.enricher}):new DDBAction({ddbData:this.ddbData,ddbDefinition:e,rawCharacter:this.rawCharacter,enricher:this.enricher});await t.loadEnricher(),await t.build(),foundry.utils.setProperty(t.data,"flags.ddbimporter.class",this.originClass),foundry.utils.setProperty(t.data,"flags.ddbimporter.infusionFeature",!0),foundry.utils.setProperty(t.data,"flags.ddbimporter.infusionId",e.id),t._id=i.utils.namedIDStub(e.name),this.actions.push(t.data)}i.logger.debug("Generated Infusions Actions",this.actions)}}async _addActionsToEffects(){if(0===this.actions.length)return;const e=await this.addInfusionsToCompendium(this.actions);if(0===e.length)return;const t=this.ddbInfusion.actions.map((e=>`[[/item ${e.name}]]`)),a=e.map((e=>e.uuid));this.activity.data.effects?.length>0&&(this.activity.data.effects[0].riders.item=a),this.data.effects.forEach((e=>{e.changes.push({key:"system.description.value",mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:`<hr> <br><h2>Infusion Actions</h2><p> ${t.join(", ")} </p>`})}))}_specials(){this.name;for(let e of this.actions){switch(foundry.utils.getProperty(e,"flags.ddbimporter.originalName")??e.name){case"Radiant Weapon (Reaction)":e=u.Effects.AutoEffects.addSimpleConditionEffect(e,"Blinded",{transfer:!1});break;case"Spell-Refueling Ring (Reaction)":{const t='<br><p>[[/ddbifunc functionName="spellRefuelingRing" functionType="item"]]{Spell Refueling Macro}</div></p>';e.system.description.value+=t,""!==e.system.description.chat&&(this.data.system.description.chat+=t);break}}}}_getEnchantmentEffect(e,{useModifierLabelName:t=!1,useOrigin:a=!1}={}){const i=e.name??this.name,n=foundry.utils.deepClone(this.data);n.effects=[];const s=u.Effects.EnchantmentEffects.EnchantmentEffect(n,i,{origin:a?`Item.${this.data._id}`:null});s.flags.ddbimporter.infusion=!0;const r=foundry.utils.deepClone(e.modifiers)??[],o={definition:{name:this.name,grantedModifiers:r.filter((e=>!("bonus"===e.type&&"armor-class"===e.subType||"bonus"===e.type&&"magic"===e.subType)))}},l=u.Effects.EffectGenerator.generateEffects({ddb:this.ddbData,character:this.rawCharacter,ddbItem:o,document:n,isCompendiumItem:this.noMods,type:"infusion",description:this.snippet});l.effects.length>0&&(s.changes=l.effects.map((e=>e.changes)).flat(1)),s.changes.push(...this._getMagicBonusChanges(r)),this.ddbInfusion.requiresAttunement&&s.changes.push({key:"system.attunement",mode:CONST.ACTIVE_EFFECT_MODES.OVERRIDE,value:"required"});const d="replicate"===this.ddbInfusion.type?": Replicated [Infusion]":`: ${t?i:this.name} [Infusion]`;return s.changes.push({key:"name",mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:d,priority:20}),s}_generateEnchantmentStubEffect(){const e=["damage-type-choice"].includes(this.ddbInfusion.modifierDataType),t=this._getEnchantmentEffect([],{useModifierLabelName:e}),a={_id:t._id,level:{min:null,max:null},riders:{effect:[],item:[]}};this.activity.data.effects.push(a),this.data.effects.push(t)}_addDescriptionToEffect(e){const t=l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,this.ddbInfusion.description,this.ddbInfusion).text;e.changes.push({key:"system.description.value",mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:`<hr> <br> ${t}`})}_generateEnchantmentEffects(){const e=["damage-type-choice"].includes(this.ddbInfusion.modifierDataType);for(const[t,a]of this.ddbInfusion.modifierData.entries()){const n=this._getEnchantmentEffect(a,{useModifierLabelName:e}),s={_id:n._id,level:{min:null,max:null},riders:{effect:[],item:[]}},r=l.DDBTemplateStrings.parse(this.ddbData,this.rawCharacter,this.ddbInfusion.snippet,this.ddbInfusion).text;switch(this.ddbInfusion.modifierDataType){case"class-level":{const e=a.value,i=t<this.ddbInfusion.modifierData.length-1?this.ddbInfusion.modifierData[t+1].value??null:null;s.level={min:e,max:i},n.description=r,this._addDescriptionToEffect(n);break}case"granted":case"damage-type-choice":n.description=r,this._addDescriptionToEffect(n);break;default:this._addDescriptionToEffect(n),i.logger.debug(`Infusion ${this.name} has no additional config`)}this.activity.data.effects.push(s),this.data.effects.push(n)}}_getMagicBonusChanges(e){const t=l.DDBModifiers.filterModifiersOld(e,"bonus","magic"),a=l.DDBModifiers.getModifierSum(t,this.rawCharacter),i=l.DDBModifiers.filterModifiersOld(e,"bonus","armor-class"),n=l.DDBModifiers.getModifierSum(i,this.rawCharacter),s=[];return a&&0!==a&&""!==a&&s.push({key:"system.magicalBonus",mode:CONST.ACTIVE_EFFECT_MODES.OVERRIDE,value:a,priority:20}),n&&0!==n&&""!==n&&s.push({key:"system.armor.magicalBonus",mode:CONST.ACTIVE_EFFECT_MODES.OVERRIDE,value:n,priority:20}),s.push({key:"system.properties",mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:"mgc",priority:20}),s}_generateEnchantments(){"enchant"===this.activityType&&(this._generateEnchantmentEffects(),this.ddbInfusion.modifierDataType,0===this.data.effects.length&&this._generateEnchantmentStubEffect())}async build(){await this.compendiumInit(),this._buildDescription(),this._buildBaseActivity(),this._generateSystemType(),this._generateEnchantmentType(),this._generateEnchantments(),await this.enricher.init(),await this._buildActions(),this._specials(),await this._addActionsToEffects(),await this.addInfusionsToCompendium([this.data]),foundry.utils.setProperty(this.data,`system.activities.${this.activity.data._id}`,this.activity.data),i.logger.debug(`DDBInfusions for ${this.name}`,{data:foundry.utils.deepClone(this.data),actions:foundry.utils.deepClone(this.actions),this:this})}}class DDBInfusionFactory{constructor(e){this.ddbCharacter=e,this.ddbData=e.source.ddb,this.rawCharacter=e.raw.character,this.processed={actions:[],infusions:[]},this.infusionCount={}}_getInfusionCount(e){return this.infusionCount[e]||(this.infusionCount[e]=0),++this.infusionCount[e]}updateIds(e){this.ddbCharacter.updateItemIds(this.processed[e])}async processInfusions(){i.logger.debug("Parsing infusions");for(const e of foundry.utils.getProperty(this.ddbData,"infusions.infusions.definitionData")??[]){const t=Number.parseInt(this._getInfusionCount(e.name)),a=1===t,n=new DDBInfusion({ddbData:this.ddbData,ddbInfusion:e,rawCharacter:this.rawCharacter,nameIdPostfix:t>1?t:null,addToCompendium:a});await n.build(),i.logger.debug(`DDBInfusion: ${n.ddbInfusion.name}`,{ddbInfusion:n,infusion:e,this:this}),this.processed.infusions.push(n.data),this.processed.actions.push(...n.actions)}this.updateIds("infusions"),this.updateIds("actions")}}class DDBCharacter{constructor({currentActor:e=null,characterId:t=null,selectResources:a=!0,enableCompanions:n=!1,enableSummons:s=!1}={}){this.currentActor=e,this.currentActorId=e?.id,this.characterId=t,this.selectResources=a,this.resourceChoices=e&&foundry.utils.hasProperty(e,"flags.ddbimporter.resources.type")?foundry.utils.getProperty(e,"flags.ddbimporter.resources"):{ask:game.settings.get(o.y.MODULE_ID,"show-resource-chooser-default"),type:"remove",primary:"",secondary:"",tertiary:""},this.resources=[],this.source=null,this.raw={character:null,classes:[],spells:[],actions:[],features:[],race:null,inventory:[],itemSpells:[]},this.data={},this.abilities={overrides:{},core:{},withEffects:{}},this.spellSlots={},this.totalLevels=0,this.companionFactories=[],this.enableCompanions=n,this.enableSummons=s,this._currency={pp:0,gp:0,ep:0,sp:0,cp:0},this._itemCurrency={pp:0,gp:0,ep:0,sp:0,cp:0},this.itemCompendium=i.CompendiumHelper.getCompendiumType("inventory"),this.spellCompendium=i.CompendiumHelper.getCompendiumType("spell"),this.armor={},this.matchedFeatures=[],this.possibleFeatures=this.currentActor?.getEmbeddedCollection("Item")??[],this.proficiencyFinder=new l.ProficiencyFinder({ddb:this.source?.ddb}),this.addToCompendiums=game.settings.get(o.y.MODULE_ID,"character-update-policy-add-features-to-compendiums"),this._infusionFactory=null,this._classParser=null,this._characterFeatureFactory=null,this._spellParser=null}static getCharacterId(e){const t=e.match(/(?:https?:\/\/)?(?:www\.)?(?:dndbeyond\.com|ddb\.ac)(?:\/profile\/.+)?\/characters\/(\d+)\/?/);return t?t[1]:null}getCharacterAPIEndpoint(){return null!==this.characterId?`https://character-service.dndbeyond.com/character/v5/character/${this.characterId}`:null}async getCharacterData({syncId:e,localCobaltPostFix:t=""}={}){const a=i.Secrets.getCobalt(t),n=i.DDBProxy.getProxy(),s=game.settings.get("ddb-importer","beta-key"),r=i.DDBCampaigns.getCampaignId(),o=""===r?null:r;let d={cobalt:a,betaKey:s,characterId:this.characterId,campaignId:o,filterModifiers:!1,splitSpells:!0};e&&(d.updateId=e);try{const e=await fetch(`${n}/proxy/v5/character`,{method:"POST",headers:{"Content-Type":"application/json"},redirect:"follow",body:JSON.stringify(d)});if(this.source=await e.json(),!this.source.success)return;this.source.ddb=l.FilterModifiers.fixCharacterLevels(this.source.ddb),this.proficiencyFinder=new l.ProficiencyFinder({ddb:this.source.ddb}),await l.DDBReferenceLinker.importCacheLoad(),i.logger.debug("DDB Data to parse:",foundry.utils.duplicate(this.source.ddb)),i.logger.debug("currentActorId",this.currentActorId);try{await this._parseCharacter(),i.logger.debug("finalParsedData",foundry.utils.duplicate({source:this.source,data:foundry.utils.deepClone(this.data)}))}catch(e){throw game.settings.get("ddb-importer","debug-json")&&i.FileHelper.download(JSON.stringify(this.source),`${this.characterId}-raw.json`,"application/json"),e}}catch(e){throw i.logger.error("JSON Fetch and Parse Error"),i.logger.error(e),i.logger.error(e.stack),e}}async _generateClass(e=!1){this._classParser=new CharacterClassFactory(this,{addToCompendium:e}),this.raw.classes=await this._classParser.processCharacter(),i.logger.debug(`Classes parse complete (With Compendium: ${e})`)}async _generateFeatures(){this._characterFeatureFactory||(this._characterFeatureFactory=new CharacterFeatureFactory(this)),await this._characterFeatureFactory.processFeatures(),i.logger.debug("Feature parse complete")}async _generateActions(){this._characterFeatureFactory||(this._characterFeatureFactory=new CharacterFeatureFactory(this)),await this._characterFeatureFactory.processActions(),i.logger.debug("Action parse complete")}async _addFeatureFactoryDocuments(){this._characterFeatureFactory.filterActionFeatures(),this.raw.features.push(...this._characterFeatureFactory.data.features),this.raw.actions.push(...this._characterFeatureFactory.data.actions),await this._characterFeatureFactory.addToCompendiums()}async _generateInfusions(){i.logger.debug("Parsing infusions"),this._infusionFactory=new DDBInfusionFactory(this),await this._infusionFactory.processInfusions(),this.raw.features.push(...this._infusionFactory.processed.infusions),this.raw.actions.push(...this._infusionFactory.processed.actions),i.logger.debug("Infusion parse complete")}async _generateSpells(){this._spellParser=new CharacterSpellFactory(this),this.raw.spells.push(...await this._spellParser.getCharacterSpells()),i.logger.debug("Character Spells parse complete")}async _addFeaturesToCompendium(){this.addToCompendiums&&i.logger.debug("Adding features to compendium")}async _parseCharacter(){try{await this.itemCompendium.getIndex(),await this.spellCompendium.getIndex(),game.settings.get("ddb-importer","character-update-policy-add-spell-effects")&&await i.DDBMacros.createWorldMacros(),i.logger.debug("Starting core character parse",{thisDDB:this.source.ddb}),await this._generateCharacter(),this.selectResources&&(i.logger.debug("Character resources"),await this.resourceSelectionDialog()),i.logger.debug("Character structure parse complete"),await this._generateRace(),i.logger.debug("Race parse complete"),await this._generateClass(),await this._generateFeatures(),await this._generateInfusions(),await this._generateSpells(),await this._generateActions(),await this._generateInventory(),i.logger.debug("Inventory generation complete"),await this._addFeatureFactoryDocuments(),this.data=foundry.utils.deepClone({character:this.raw.character,features:this.raw.features,race:this.raw.race,classes:this.raw.classes,inventory:this.raw.inventory,spells:this.raw.spells,actions:this.raw.actions,itemSpells:this.raw.itemSpells}),this.addToCompendiums&&(await this._generateRace(!0),await this._generateClass(!0)),this._classParser.linkFeatures(),this._ddbRace.linkFeatures(this),this._characterFeatureFactory.linkFeatures(),this._addSpecialAdditions(),this.enableCompanions&&game.settings.get(o.y.MODULE_ID,"character-update-policy-create-companions")&&await this.generateCompanions(),this._linkItemsToContainers()}catch(e){throw i.logger.error(e),i.logger.error("Error during parse:",e.message),e}}getDataFeature(e,{featureTypes:t=["actions","features"],hints:a=[]}={}){for(const n of t){const t=this.data[n].findIndex((t=>{if(t.flags.ddbimporter?.isCustomAction??!1)return!1;const n=t.flags.ddbimporter?.originalName??t.name;for(const t of a)if(i.utils.nameString(`${n} (${t})`)===i.utils.nameString(e))return!0;return i.utils.nameString(n)===i.utils.nameString(e)}));if(-1!==t)return i.logger.debug(`Found ${n} : ${e}`),this.data[n][t]}}async disableDynamicUpdates(){this.currentActor.flags.ddbimporter.activeUpdate=!1;await this.currentActor.update({flags:{ddbimporter:{activeUpdate:!1}}})}async enableDynamicUpdates(){this.currentActor.flags.ddbimporter.activeUpdate=!0;await this.currentActor.update({flags:{ddbimporter:{activeUpdate:!0}}})}async updateDynamicUpdates(e){this.currentActor.flags.ddbimporter.activeUpdate=e;const t={flags:{ddbimporter:{activeUpdate:e}}};await this.currentActor.update(t)}getCurrentDynamicUpdateState(){return!!this.currentActor.flags?.ddbimporter?.activeUpdate&&this.currentActor.flags.ddbimporter.activeUpdate}async setActiveSyncSpellsFlag(e){this.currentActor.flags.ddbimporter.activeSyncSpells=e;const t={flags:{ddbimporter:{activeSyncSpells:e}}};await this.currentActor.update(t)}isMartialArtist(){return this.source.ddb.character.classes.some((e=>e.classFeatures.some((e=>"Martial Arts"===e.definition.name))))}updateItemId(e){const t=l.DDBDataUtils.findMatchedDDBItem(e,this.possibleFeatures,this.matchedFeatures);t&&(e._id=t._id,this.matchedFeatures.push(t))}updateItemIds(e){return this.currentActor?(e.forEach((e=>{this.updateItemId(e)})),e):e}_linkItemsToContainers(){const e=this.data.inventory.filter((e=>"container"===e.type&&foundry.utils.hasProperty(e,"flags.ddbimporter.id")&&foundry.utils.hasProperty(e,"flags.ddbimporter.containerEntityId")&&parseInt(e.flags.ddbimporter.containerEntityId)===parseInt(this.source.ddb.character.id)&&!foundry.utils.getProperty(e,"flags.ddbimporter.ignoreItemImport")));this.data.inventory.forEach((t=>{if(foundry.utils.hasProperty(t,"flags.ddbimporter.containerEntityId")&&parseInt(t.flags.ddbimporter.containerEntityId)!==parseInt(this.source.ddb.character.id)){const a=e.find((e=>parseInt(e.flags.ddbimporter.id)===parseInt(t.flags.ddbimporter.containerEntityId)));a&&foundry.utils.setProperty(t,"system.container",a._id)}}))}}},339:(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{__webpack_require__.d(__webpack_exports__,{Y:()=>generateCharacterExtras});var _lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__(421),_DDBMonsterFactory_js__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__(492),_monster_helpers_js__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__(702),_config_module_mjs__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__(115),_companions_DDBCompanionFactory_mjs__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__(186);function getCustomValue(e,t,a,i){const n=e.characterValues.find((e=>e.valueId==a&&e.valueTypeId==i&&e.typeId==t));return n?n.value:null}function generateBeastCompanionEffects(e,t){let a={changes:[{key:"data.bonuses.rwak.attack",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:`+${t}`,priority:20},{key:"data.bonuses.rwak.damage",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:`+${t}`,priority:20},{key:"data.bonuses.mwak.attack",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:`+${t}`,priority:20},{key:"data.bonuses.mwak.damage",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:`+${t}`,priority:20}],duration:{seconds:null,startTime:null,rounds:null,turns:null,startRound:null,startTurn:null},tint:"",disabled:!1,selectedKey:[],name:"Beast Companion Effects"};return _config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.x.actor.abilities.filter((t=>e.system.abilities[t.value].proficient>=1)).forEach((e=>{const i={key:`data.abilities.${e.value}.save`,mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:t,priority:20};a.selectedKey.push(`data.abilities.${e.value}.save`),a.changes.push(i)})),_config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.x.actor.skills.filter((t=>e.system.skills[t.name].prof>=1)).forEach((e=>{const i={key:`data.skills.${e.name}.mod`,mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:t,priority:20};a.selectedKey.push(`data.skills.${e.name}.mod`),a.changes.push(i)})),e.effects=[a],e}function generateArtificerDamageEffect(e,t){t.system.details.cr=e.flags.ddbimporter.dndbeyond.totalLevels;let a={changes:[{key:"data.bonuses.rwak.damage",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"+ @prof",priority:20},{key:"data.bonuses.mwak.damage",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"+ @prof",priority:20}],duration:{seconds:null,startTime:null,rounds:null,turns:null,startRound:null,startTurn:null},tint:"",disabled:!1,selectedKey:[],name:"Artificer Extra Effects"};return t.effects=[a],t}const creatureGroupMatrix=[{id:1,name:"Wildshape",animation:"fourelements"},{id:2,name:"Familiar",animation:"magic1"},{id:3,name:"Beast Companion",animation:"fourelements"},{id:4,name:"Mount",animation:"heart"},{id:5,name:"Pet",animation:"heart"},{id:6,name:"Summoned",animation:"magic1"},{id:7,name:"Misc",animation:"magic1"},{id:10,name:"Battle Smith Defender",animation:"energy1"},{id:11,name:"Sidekick",animation:"energy1"},{id:12,name:"Infusion",animation:"energy1"}];function getCreatureAnimationType(e,t){const a=e.toLowerCase();let i="magic1";switch(e){case a.includes("flame"):case a.includes("fire"):i="fire";break;case a.includes("air"):case a.includes("wind"):i="air";break;case a.includes("lightning"):case a.includes("thunder"):i="lightning";break;case a.includes("water"):case a.includes("aqua"):i="water";break;case a.includes("energy"):case a.includes("construct"):i="energy1";break;case a.includes("magic"):case a.includes("arcane"):i="magic1";break;default:{const e=creatureGroupMatrix.find((e=>e.id===t.id));e&&(i=e.animation)}}return i}function setExtraMunchDefaults(){let e=[];return _config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.y.MUNCH_DEFAULTS.forEach((t=>{_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug(`Loading extras munch settings ${t.name}`),t.chosen=game.settings.get("ddb-importer",t.name),e.push(t)})),e.forEach((e=>{game.settings.set("ddb-importer",e.name,e.needed)})),e}function revertExtraMunchDefaults(e){e.forEach((e=>{_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug(`Returning ${e.name} to ${e.chosen}`),game.settings.set("ddb-importer",e.name,e.chosen)}))}function addOwnerSkillProficiencies(e,t){let a=[];const i=CONFIG.DDB.challengeRatings.find((e=>e.id==t.challengeRatingId)).proficiencyBonus;return _config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.x.actor.skills.forEach((n=>{const s=t.skills.find((e=>n.valueId===e.skillId)),r=e.data.character.system.skills[n.name].value,o=_config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.x.actor.abilities.find((e=>e.value===n.ability)),l=t.stats.find((e=>e.statId===o.id)).value||10,d=CONFIG.DDB.statModifiers.find((e=>e.value==l)).modifier;if(s&&2===r){const e=2*i;a.push({skillId:n.valueId,value:d+e,additionalBonus:null})}else s?a.push(s):1===r&&a.push({skillId:n.valueId,value:d+i,additionalBonus:null})})),t.skills=a,t}function addOwnerSaveProficiencies(e,t){let a=[];return _config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.x.actor.abilities.forEach((i=>{const n=t.savingThrows.find((e=>e.statId===i.id))?1:0,s=e.abilities.withEffects[i.value].proficient;if(n||s){const e={bonusModifier:null,statId:i.id};a.push(e)}})),t.savingThrows=a,t}function addAverageHitPoints(e,t,a,i){const n=getCustomValue(e,43,a.id,a.entityTypeId);if(n&&(i.averageHitPoints=n),i.creatureFlags.includes("HPLM")){const t=e.classes.find((e=>5===e.definition.id)),a=t?t.level:0;i.averageHitPoints=Math.max(i.averageHitPoints,4*a)}if(i.creatureFlags.includes("MHPBAL")){const t=e.classes.find((e=>"Artificer"===e.definition.name));t&&(i.averageHitPoints=parseInt(t.level),foundry.utils.setProperty(i,"hitPointDice.diceCount",t.level),foundry.utils.setProperty(i,"hitPointDice.diceString",`${t.level}d${i.hitPointDice.diceValue}`))}if(i.creatureFlags.includes("AHM")){const t=e.classes.find((e=>"Artificer"===e.definition.name));t&&(i.averageHitPoints=parseInt(5*t.level))}if(i.creatureFlags.includes("MHPAIM")&&(i.averageHitPoints+=parseInt(t.system.abilities.int.mod)),i.creatureFlags.includes("MHPAMCM")){const e=(0,_monster_helpers_js__WEBPACK_IMPORTED_MODULE_2__.a)(i,CONFIG.DDB);i.averageHitPoints+=parseInt(e.con)}return i}function addCreatureStats(e,t){const a=e.stats.filter((t=>!e.creatureGroup.ownerStats.includes(t.statId))),i=e.stats.filter((t=>e.creatureGroup.ownerStats.includes(t.statId))).map((e=>{const a=t.system.abilities[_config_module_mjs__WEBPACK_IMPORTED_MODULE_3__.x.actor.abilities.find((t=>t.id===e.statId)).value].value;return{name:null,statId:e.statId,value:a}}));return e.stats=a.concat(i),e}function addCreatureFlags(e,t){const a=CONFIG.DDB.creatureGroups.find((t=>t.id==e.groupId));let i=a.flags;return"Homunculus Servant"===e.definition.name&&(i=i.concat(["MHPAMCM","MHPAIM","MHPBAL","ARPB","PSPB"])),t.creatureFlags=i,t.creatureGroupId=e.groupId,t.creatureGroup=a,t}function transformExtraToMonsterData(e,t,a){let i=e.source.ddb.character;_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug("Extra data",a);let n=foundry.utils.duplicate(a.definition);n.id=a.id,n.entityTypeId=a.entityTypeId,n=addCreatureFlags(a,n),a.name&&(n.name=a.name),n.automatedEvcoationAnimation=getCreatureAnimationType(n.name,n.creatureGroup);const s=getCustomValue(i,46,a.id,a.entityTypeId);s&&(n.sizeId=s),n=addAverageHitPoints(i,t,a,n),n.removedHitPoints=a.removedHitPoints,n.temporaryHitPoints=a.temporaryHitPoints;const r=getCustomValue(i,44,a.id,a.entityTypeId);r&&(n.typeId=r);const o=getCustomValue(i,42,a.id,a.entityTypeId);o&&(n.armorClass=o);const l=getCustomValue(i,45,a.id,a.entityTypeId);l&&(n.alignmentId=l);const d=getCustomValue(i,47,a.id,a.entityTypeId);return d&&(n.characteristicsDescription+=`\n\n${d}`),n=addCreatureStats(n,t),n.ownership=t.ownership,""!==n.creatureGroup.description&&(n.characteristicsDescription=`${n.creatureGroup.description}\n\n${n.characteristicsDescription}`),n.creatureGroup.specialQualityTitle&&(n.specialTraitsDescription=`${n.specialTraitsDescription} <p><em><strong>${n.creatureGroup.specialQualityTitle}.</strong></em> ${n.creatureGroup.specialQualityText}</p>`),n.creatureFlags.includes("ACPB")&&(n.armorClass+=t.system.attributes.prof),n.creatureFlags.includes("EOSKP")&&(n=addOwnerSkillProficiencies(e,n)),n.creatureFlags.includes("EOSVP")&&(n=addOwnerSaveProficiencies(e,n)),n.creatureFlags.includes("CULGA")&&(n.isLegendary=!1,n.legendaryActionsDescription=""),n.creatureFlags.includes("CULRA")&&(n.hasLair=!1,n.lairDescription=""),_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug("mock creature",n),n}function enhanceParsedExtra(actor,extra){const damageDiceExpression=/(\d*d\d+\s*\+*\s*)+/,characterProficiencyBonus=actor.system.attributes.prof,artificerBonusGroup=[10,12];return extra.flags?.ddbimporter?.creatureFlags?.includes("ARPB")&&extra.flags?.ddbimporter?.creatureFlags?.includes("PSPB")&&(3===extra.flags?.ddbimporter?.creatureGroupId?extra=generateBeastCompanionEffects(extra,characterProficiencyBonus):artificerBonusGroup.includes(extra.flags?.ddbimporter?.creatureGroupId)?extra=generateArtificerDamageEffect(actor,extra,characterProficiencyBonus):extra.system.details.cr=actor.flags.ddbimporter.dndbeyond.totalLevels),(extra.flags?.ddbimporter?.creatureFlags?.includes("DRPB")&&3!==extra.flags?.ddbimporter?.creatureGroupId||12===extra.flags?.ddbimporter?.creatureGroupId)&&(extra.items=extra.items.map((item=>{if("weapon"===item.type){let characterAbility;if(item.system.damage.parts=item.system.damage.parts.map((e=>{const t=e[0].match(damageDiceExpression);if(t){let a=t[0];artificerBonusGroup.includes(extra.flags?.ddbimporter?.creatureGroupId)&&(characterAbility="int",a=t[1].trim().endsWith("+")?t[1].trim().slice(0,-1):t[1]),e[0]=`${a.trim()}`}return e})),characterAbility){const ability=item.system.ability,mod=parseInt(extra.system.abilities[ability].mod),characterMod=parseInt(actor.system.abilities[characterAbility].mod),globalMod=parseInt(eval(actor.system.bonuses.rsak.attack||0));item.system.attack.bonus=characterMod+globalMod-mod}}return item}))),extra}async function generateCharacterExtras(e,t,a){const i=setExtraMunchDefaults();try{if(_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug("ddbCharacter",t),0===t.source.ddb.character.creatures.length)return;const e=await _lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.FolderHelper.getOrCreateFolder(a.folder,"Actor",`[Extras] ${a.name}`),i=t.source.ddb.character.creatures.map((e=>transformExtraToMonsterData(t,a,e))).map((t=>(t.folder=e.id,t)));_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug("Extracted creatures",foundry.utils.duplicate(i));const n=new _DDBMonsterFactory_js__WEBPACK_IMPORTED_MODULE_1__.A({ddbData:i,extra:!0}),s=await n.parse();_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug("Parsed Extras:",foundry.utils.duplicate(s.actors));const r=s.actors.map((e=>enhanceParsedExtra(a,e)));_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.debug("Enhanced Parsed Extras:",foundry.utils.duplicate(r));const o=new _companions_DDBCompanionFactory_mjs__WEBPACK_IMPORTED_MODULE_4__.A("",{actor:a,data:r,noCompendiums:!0});await o.init(),await o.updateOrCreateCompanions({folderOverride:e})}catch(e){_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.error("Failure parsing extra",e),_lib_module_mjs__WEBPACK_IMPORTED_MODULE_0__.logger.error(e.stack)}finally{revertExtraMunchDefaults(i)}}},913:(e,t,a)=>{a.d(t,{A:()=>DDBMonster});var i=a(449),n=a(421);var s=a(51);function avalancheOfBonesEffect(e){foundry.utils.setProperty(e,"system.duration",{value:null,units:"special"}),foundry.utils.setProperty(e,"system.target",{value:10,width:null,units:"ft",type:"creature"}),foundry.utils.setProperty(e,"system.range",{value:null,long:null,units:"self"});let t=(0,s.d)(e,e.name);return(0,s.JZ)({effect:t,statusName:"Prone"}),foundry.utils.setProperty(t,"duration.turns",99),foundry.utils.setProperty(t,"duration.seconds",9999),t.transfer=!1,e.effects.push(t),e=(0,s.Kz)(e)}function fallingApartEffect(e){let t=(0,s.d)(e,e.name);return t.changes.push({key:"flags.midi-qol.OverTime",mode:CONST.ACTIVE_EFFECT_MODES.OVERRIDE,value:`turn=start, damageRoll=10, damageType=none, condition=@attributes.hp.value > 0 && @attributes.hp.value < @attributes.hp.max, label=${e.name}`,priority:"20"}),t.transfer=!0,e.effects.push(t),e=(0,s.Kz)(e)}async function disassembleEffect(e){let t=(0,s.d)(e,e.name);return await n.DDBMacros.setItemMacroFlag(e,"monsterFeature","disassemble.js"),t.changes.push(n.DDBMacros.generateMacroChange({macroType:"monsterFeature",macroName:"disassemble.js",priority:0})),t.transfer=!0,foundry.utils.setProperty(t,"flags.dae.specialDuration",["zeroHP"]),e.effects.push(t),e=(0,s.Kz)(e)}async function deathlyChoirEffect(e){return await n.DDBMacros.setItemMacroFlag(e,"monsterFeature","deathlyChoir.js"),n.DDBMacros.setMidiOnUseMacroFlag(e,"monsterFeature","deathlyChoir.js",["prePreambleComplete"]),foundry.utils.setProperty(e,"system.target",{value:10,width:null,units:"ft",type:"creature"}),foundry.utils.setProperty(e,"system.range",{value:null,long:null,units:"spec"}),e}async function beholderEyeRaysEffect(e,t=3,a=120){return foundry.utils.setProperty(e,"system.target",{value:t,width:null,units:"",type:"creature"}),foundry.utils.setProperty(e,"system.range",{value:a,long:null,units:"ft"}),foundry.utils.setProperty(e,"system.damage",{parts:[],versatile:"",value:""}),foundry.utils.setProperty(e,"system.activation.type","action"),foundry.utils.setProperty(e,"system.actionType","other"),await n.DDBMacros.setItemMacroFlag(e,"monsterFeature","eyeRays.js"),n.DDBMacros.setMidiOnUseMacroFlag(e,"monsterFeature","eyeRays.js",["postActiveEffects"]),e.system.save={dc:null,ability:"",scaling:"spell"},foundry.utils.setProperty(e,"flags.midiProperties.magiceffect",!0),e.effects=[],e=(0,s.Kz)(e)}async function beholderEyeRayLegendaryEffect(e,t=3,a=120){return foundry.utils.setProperty(e,"system.target",{value:t,width:null,units:"",type:"creature"}),foundry.utils.setProperty(e,"system.range",{value:a,long:null,units:"ft"}),foundry.utils.setProperty(e,"system.damage",{parts:[],versatile:"",value:""}),foundry.utils.setProperty(e,"system.activation.type","action"),foundry.utils.setProperty(e,"system.actionType","other"),await n.DDBMacros.setItemMacroFlag(e,"monsterFeature","eyeRay.js"),n.DDBMacros.setMidiOnUseMacroFlag(e,"monsterFeature","eyeRay.js",["postActiveEffects"]),e.system.save={dc:null,ability:"",scaling:"spell"},foundry.utils.setProperty(e,"flags.midiProperties.magiceffect",!0),e.effects=[],e=(0,s.Kz)(e)}var r=a(222);function baseMonsterFeatureEffect(e,t,{transfer:a=!1,disabled:i=!1}={}){return r.A.MonsterFeatureEffect(e,t,{transfer:a,disabled:i})}async function monsterFeatureEffectAdjustment(e,t=!1){let a=foundry.utils.duplicate(e.npc);if(a.effects||(a.effects=[]),!t)return a;switch(a.name){case"Bard":a.items.forEach((e=>{"Taunt"===e.name&&(e=function generateTauntEffect(e){let t=(0,s.Yg)(e,e.name);return t.changes.push({key:"flags.midi-qol.disadvantage.all",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"1",priority:"20"}),t.duration.rounds=2,t.duration.seconds=12,t.flags.dae.specialDuration=["turnStart"],e.effects.push(t),(0,s.Kz)(e)}(e))}));break;case"Beholder":for(let[e,t]of a.items.entries())"Eye Rays"===t.name?a.items[e]=await beholderEyeRaysEffect(t,3,120):"Eye Ray"===t.name&&(a.items[e]=await beholderEyeRayLegendaryEffect(t,3,120));break;case"Beholder Zombie":for(let[e,t]of a.items.entries())"Eye Ray"===t.name&&(a.items[e]=await beholderEyeRaysEffect(t,1,60));break;case"Carrion Crawler":case"Reduced-threat Carrion Crawler":a.items.forEach((function(e,t){"Tentacles"===e.name&&((0,s.JZ)({effect:this[t].effects[0],statusName:"Paralyzed"}),this[t]=(0,s.Kz)(this[t]))}),a.items);break;case"Giant Spider":a=function giantSpiderEffects(e){for(let t of e.items)if(t.name.startsWith("Web")){let e=baseMonsterFeatureEffect(t,t.name);(0,s.JZ)({effect:e,statusName:"Restrained"}),e.changes.push({key:"flags.midi-qol.OverTime",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"turn=start,name=You can take an action to break free of the web by rolling a Strength Ability Check",priority:"20"},{key:"flags.midi-qol.OverTime",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"turn=end, rollType=check, actionSave=true, saveAbility=str, saveDC=@abilities.str.dc, label=Restrained by Web",priority:"20"}),foundry.utils.setProperty(e,"duration.seconds",60),foundry.utils.setProperty(e,"duration.rounds",10),foundry.utils.setProperty(e,"flags.dae.stackable","noneName"),t.effects.push(e),t=(0,s.Kz)(t)}return e}(a);break;case"Quasit":a=await function quasitEffects(e){for(let t of e.items)if(t.name.startsWith("Claws")){let e=baseMonsterFeatureEffect(t,t.name);e.changes.push({key:"flags.midi-qol.OverTime",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"turn=end, saveAbility=con, saveDC=@abilities.con.dc, label=Poisoned by Quasit Claws",priority:"20"}),(0,s.JZ)({effect:e,statusName:"Poisoned"}),foundry.utils.setProperty(e,"duration.seconds",60),foundry.utils.setProperty(e,"duration.rounds",10),foundry.utils.setProperty(e,"flags.dae.stackable","noneName"),t.effects.push(e),foundry.utils.setProperty(t,"flags.midiProperties.fulldam",!0),t=(0,s.Kz)(t)}return e}(a);break;case"Rahadin":for(let[e,t]of a.items.entries())"Deathly Choir"===t.name&&(a.items[e]=await deathlyChoirEffect(t));break;case"Skeletal Juggernaut":a=await async function skeletalJuggernautEffects(e){for(let t of e.items)t.name.startsWith("Avalanche of Bones")?t=avalancheOfBonesEffect(t):t.name.startsWith("Falling Apart")?t=fallingApartEffect(t):t.name.startsWith("Disassemble")&&(t=await disassembleEffect(t));return e}(a);break;case"Spectator":for(let[e,t]of a.items.entries())"Eye Rays"===t.name&&(a.items[e]=await beholderEyeRaysEffect(t,2,90));break;case"Strahd Zombie":a=await async function strahdZombieEffects(e){for(let t of e.items){if(t.name.startsWith("Loathsome Limbs")){let e=baseMonsterFeatureEffect(t,t.name);e.changes.push(n.DDBMacros.generateOnUseMacroChange({macroPass:"isDamaged",macroType:"monsterFeature",macroName:"loathsomeLimbs.js"})),e.transfer=!0,foundry.utils.setProperty(e,"flags.dae.stackable","noneName"),await n.DDBMacros.setItemMacroFlag(t,"monsterFeature","loathsomeLimbs.js"),t.effects.push(e)}t=(0,s.Kz)(t)}return e}(a);break;case"Venom Troll":a=await async function venomTrollEffects(e){for(let t of e.items){if(t.name.startsWith("Venom Spray")){let e=baseMonsterFeatureEffect(t,t.name);e.changes.push({key:"flags.midi-qol.OverTime",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"turn=end, saveAbility=con, saveDC=@abilities.str.dc, label=Poisoned by Venom Spray",priority:"20"}),(0,s.JZ)({effect:e,statusName:"Poisoned"}),foundry.utils.setProperty(e,"duration.seconds",60),foundry.utils.setProperty(e,"duration.rounds",10),foundry.utils.setProperty(e,"flags.dae.stackable","noneName"),await n.DDBMacros.setItemMacroFlag(t,"monsterFeature","venomSpray.js"),n.DDBMacros.setMidiOnUseMacroFlag(t,"monsterFeature","venomSpray.js",["postActiveEffects"]),t.effects.push(e)}else if("Poison Splash"===t.name){let e=baseMonsterFeatureEffect(t,t.name);e.changes.push(n.DDBMacros.generateOnUseMacroChange({macroPass:"isDamaged",macroType:"monsterFeature",macroName:"venomSpray.js"})),e.transfer=!0,foundry.utils.setProperty(e,"flags.dae.stackable","noneName"),await n.DDBMacros.setItemMacroFlag(t,"monsterFeature","poisonSplash.js"),t.effects.push(e),t.system.target={value:5,width:null,units:"ft",type:"creature"},t.system.range.units="spec",t.system.duration.units="inst"}else if("Regeneration"===t.name){let e=baseMonsterFeatureEffect(t,t.name);e.changes.push({key:"flags.midi-qol.OverTime",mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:`turn=start, damageRoll=${t.system.damage.parts[0][0]}, damageType=healing, condition=@attributes.hp.value > 0 && @attributes.hp.value < @attributes.hp.max, rollMode=gmroll, label=${t.name} (Fire or Acid prevents)`,priority:"20"}),foundry.utils.setProperty(e,"flags.dae.transfer",!0),e.transfer=!0,t.system.damage.parts=[],t.effects.push(e)}t=(0,s.Kz)(t)}return e}(a)}return a}var o=a(899),l=a(115),d=a(391);class DDBMonster{setProperty(e,t){this.overrides.name?this[e]=this.overrides.name:this[e]=t}constructor(e=null,{existingNpc:t=null,extra:a=!1,useItemAC:i=!0,legacyName:n=!0,addMonsterEffects:s=!1,addChrisPremades:r=!1}={},l={}){this.source=e,this.extra=a,this.npc=t,this.useItemAC=i,this.legacyName=n,this.addMonsterEffects=s,this.addChrisPremades=r,this.overrides=l,this.removedHitPoints=this.setProperty("removedHitPoints",this.source?.removedHitPoints??0),this.temporaryHitPoints=this.setProperty("temporaryHitPoints",this.source?.temporaryHitPoints??0),this.characterDescription="",this.unexpectedDescription=null,this.name=l.name??(t?t.name:null),this.abilities=null,this.proficiencyBonus=null,this.cr=0,this.typeName="",this.items=[],this.img=null,t&&(this.proficiencyBonus=this.setProperty("proficiencyBonus",t.system.attributes.prof),this.cr=this.setProperty("cr",t.system.details.cr),this.abilities=this.setProperty("abilities",t.system.abilities),this.items=foundry.utils.duplicate(t.items),this.img=t.img),this.stockImage=!1,this.featureFactory=new o.A({ddbMonster:this})}static STOCK_TYPE_IMAGES=["https://www.dndbeyond.com/avatars/4675/664/636747837303835953.jpeg","https://www.dndbeyond.com/avatars/4675/665/636747837392078487.jpeg","https://www.dndbeyond.com/avatars/4675/666/636747837434463638.jpeg","https://www.dndbeyond.com/avatars/4675/667/636747837482013331.jpeg","https://www.dndbeyond.com/avatars/4675/668/636747837521115242.jpeg","https://www.dndbeyond.com/avatars/4675/669/636747837569942785.jpeg","https://www.dndbeyond.com/avatars/4675/671/636747837638112910.jpeg","https://www.dndbeyond.com/avatars/4675/672/636747837699453839.jpeg","https://www.dndbeyond.com/avatars/4675/674/636747837751071918.jpeg","https://www.dndbeyond.com/avatars/4675/675/636747837794884984.jpeg","https://www.dndbeyond.com/avatars/4675/676/636747837839875603.jpeg","https://www.dndbeyond.com/avatars/4675/678/636747837893364274.jpeg","https://www.dndbeyond.com/avatars/4675/679/636747837952193011.jpeg","https://www.dndbeyond.com/avatars/4675/680/636747837998336262.jpeg"];_calculateImage(){this.source?(this.img=this.source.basicAvatarUrl?this.source.basicAvatarUrl:this.source.largeAvatarUrl,this.img&&this.img.match(/.gif$/)&&(this.img=null),DDBMonster.STOCK_TYPE_IMAGES.includes(this.source.avatarUrl)&&(this.stockImage=!0)):this.img=null}_generateFlags(){this.npc.flags.monsterMunch={url:this.source.url,img:this.img?this.img:this.source.avatarUrl,tokenImg:this.source.avatarUrl,isStockImg:DDBMonster.STOCK_TYPE_IMAGES.includes(this.source.avatarUrl)},this.npc.flags.ddbimporter={id:this.source.id,entityTypeId:this.source.entityTypeId,creatureGroupId:this.source.creatureGroupId?this.source.creatureGroupId:null,creatureFlags:this.source.creatureFlags?this.source.creatureFlags:[],automatedEvcoationAnimation:this.source.automatedEvcoationAnimation?this.source.automatedEvcoationAnimation:void 0,version:CONFIG.DDBI.version,isLegacy:this.source.isLegacy}}async fetchMonsterSourceFromDDB(e){if(!e&&Number.isInteger(e)&&Number.isInteger(Number.parseInt(e)))throw new Error("Please provide a monster ID (number) to fetch");const t=n.Secrets.getCobalt(),a=n.PatreonHelper.getPatreonKey(),i=n.DDBProxy.getProxy(),s={cobalt:t,betaKey:a,ids:[Number.parseInt(e)]},r=game.settings.get(l.y.MODULE_ID,"debug-json");return new Promise(((e,t)=>{fetch(`${i}/proxy/monsters/ids`,{method:"POST",mode:"cors",headers:{"Content-Type":"application/json"},body:JSON.stringify(s)}).then((e=>e.json())).then((e=>(e.success||(n.logger.error("API Failure:",e.message),t(e.message)),r&&n.FileHelper.download(JSON.stringify(e),"monsters-raw.json","application/json"),e))).then((e=>(n.logger.info("Retrieved monster",{monster:e.data}),this.source=e.data[0],e.data[0]))).catch((e=>t(e)))}))}_generateTaggerFlags(){const e=["dndbeyond","ddb-importer"],t=this.npc.system.details.type.value,a=this.npc.system.details.type.custom,i=this.npc.system.details.type.custom;for(const s of[t,a,i])n.utils.isString(s)&&""!==s.trim()&&e.push(s);foundry.utils.setProperty(this.npc.prototypeToken,"flags.tagger.tags",e)}_generate3DModels(){if(!game.canvas3D?.CONFIG?.UI?.TokenBrowser)return;const e=game.canvas3D.CONFIG.UI.TokenBrowser.findByName(this.name.replace("(Legacy)","").trim());e&&e.length>0&&foundry.utils.setProperty(this.npc.prototypeToken,"flags.levels-3d-preview.model3d",e[0].output)}async parse(){this.name||(this.name=this.source.name),this.npc=foundry.utils.duplicate((0,i.I)(this.name,this.source.id)),this.npc.system.identifier=n.utils.referenceNameString(this.name.toLowerCase()),this._calculateImage(),this.npc.prototypeToken.name=this.name,this._generateFlags(),this.proficiencyBonus=CONFIG.DDB.challengeRatings.find((e=>e.id==this.source.challengeRatingId)).proficiencyBonus,this.npc.system.attributes.prof=this.proficiencyBonus,this._generateAbilities(),n.utils.isString(this.source.skillsHtml)&&""!==this.source.skillsHtml.trim()?this._generateSkillsHTML():this._generateSkills(),this._generateSenses(),this._generateTokenSenses(),this._generateDamageImmunities(),this._generateDamageResistances(),this._generateDamageVulnerabilities(),this._generateConditionImmunities(),this._generateSize(),this._generateLanguages(),this._generateHitPoints(),this._generateMovement(),this.cr=CONFIG.DDB.challengeRatings.find((e=>e.id==this.source.challengeRatingId)),this._generateType();const e=CONFIG.DDB.alignments.find((e=>this.source.alignmentId==e.id));this.npc.system.details.alignment=e?e.name:"",this.npc.system.details.cr=this.cr.value,this.npc.system.details.xp={value:this.cr.xp},this._generateSource(),this._generateEnvironments(),this.npc.system.details.biography.value=this.source.characteristicsDescription,await this._generateFeatures(),await this._generateAC(this.featureFactory.gear),this._generateSpells(),await this.addSpells();const t=this.items.filter((e=>""===e.name||!e.name));if(t.length>0&&(n.logger.error(`${this.source.name} - ${t.length} items have no name.`,t),this.items=this.items.filter((e=>e.name&&""!==e.name))),this.npc.items=this.items,this.legacyName&&this.source.isLegacy&&(this.npc.name+=" (Legacy)",this.npc.prototypeToken.name+=" (Legacy)"),this.npc=await n.CompendiumHelper.existingActorCheck("monster",this.npc),this.npc=this.npc,this.npc=await monsterFeatureEffectAdjustment(this,this.addMonsterEffects),this.addChrisPremades)for(let e of this.npc.items)await d.Qs.applyChrisPremadeEffect({document:e,type:"monsterfeature",folderName:this.npc.name,isMonster:!0});return this._generateTaggerFlags(),this._generate3DModels(),this.items=this.items.map((e=>(foundry.utils.hasProperty(e,"flags.monsterMunch.description")&&delete e.flags.monsterMunch.description,e))),n.logger.debug(`Generated ${this.name}`,this),this.npc}}},492:(e,t,a)=>{a.d(t,{A:()=>DDBMonsterFactory});var i=a(421),n=a(913),s=a(115),r=a(750);class DDBMonsterFactory{static#i(e,t=!1,a=!1){i.logger.info(e,{nameField:t,monsterNote:a})}static defaultFetchOptions(e,t=null){const a=$("#monster-munch-filter")[0],n=t??a?.value??"",r=game.settings.get(s.y.MODULE_ID,"munching-policy-use-source-filter")?game.settings.get(s.y.MODULE_ID,"munching-policy-muncher-sources").flat():[],o=!(r.length>0)&&game.settings.get(s.y.MODULE_ID,"munching-policy-monster-homebrew"),l=!(r.length>0)&&game.settings.get(s.y.MODULE_ID,"munching-policy-monster-homebrew-only"),d=game.settings.get(s.y.MODULE_ID,"munching-policy-monster-exact-match"),c=game.settings.get(s.y.MODULE_ID,"munching-policy-exclude-legacy"),u={ids:e,searchTerm:n.trim(),sources:r,homebrew:o,homebrewOnly:l,exactMatch:d,excludeLegacy:c};return i.logger.debug("Generated monster fetch options",u),u}constructor({ddbData:e=null,extra:t=!1,notifier:a=null,type:n="monsters",forceUpdate:r=null}={}){this.extra=t,this.npcs=[],this.source=e,this.notifier=a??DDBMonsterFactory.#i,this.type=n,this.compendiumFolders=new i.DDBCompendiumFolders(n),this.update=r??game.settings.get(s.y.MODULE_ID,"munching-policy-update-existing"),this.updateImages=game.settings.get(s.y.MODULE_ID,"munching-policy-update-images"),this.uploadDirectory=game.settings.get(s.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),this.useItemAC=game.settings.get("ddb-importer","munching-policy-monster-use-item-ac"),this.legacyName=game.settings.get("ddb-importer","munching-policy-legacy-postfix"),this.addMonsterEffects=game.settings.get("ddb-importer","munching-policy-add-monster-effects"),this.addChrisPremades=game.settings.get("ddb-importer","munching-policy-use-chris-premades"),this.currentDocument=1,this.totalDocuments=0,this.monstersParsed=[]}async fetchDDBMonsterSourceData({ids:e=[],searchTerm:t="",sources:a=[],homebrew:n=!1,homebrewOnly:r=!1,exactMatch:o=!1,excludeLegacy:l=!1}){const d=i.Secrets.getCobalt(),c=i.PatreonHelper.getPatreonKey(),u=i.DDBProxy.getProxy(),m={cobalt:d,betaKey:c};e&&!Array.isArray(e)&&(e=[e]),e&&e.length>0?m.ids=[...new Set(e)]:(m.sources=a,m.search=t,m.homebrew=n,m.homebrewOnly=r,m.searchTerm=encodeURIComponent(t),m.exactMatch=o,m.excludeLegacy=l);const p=game.settings.get(s.y.MODULE_ID,"debug-json"),g=e&&e.length>0?`${u}/proxy/monsters/ids`:`${u}/proxy/monster`;return new Promise(((e,t)=>{fetch(g,{method:"POST",mode:"cors",headers:{"Content-Type":"application/json"},body:JSON.stringify(m)}).then((e=>e.json())).then((e=>(e.success||(this.notifier(`API Failure: ${e.message}`),i.logger.error("API Failure:",e.message),t(e.message)),p&&i.FileHelper.download(JSON.stringify(e),"monsters-raw.json","application/json"),e))).then((t=>{this.notifier(`Retrieved ${t.data.length+1} monsters from DDB`,!0,!1),i.logger.info(`Retrieved ${t.data.length+1} monsters from DDB`),this.source=t.data,e(this.source)})).catch((e=>t(e)))}))}async parse(e=[]){let t=[],a=[];const s=e.length>0?e:this.source,r=this.source.length+1;let o=this.currentDocument;i.logger.time("Monster Parsing");for(const e of s){const l=`${e.name}${e.isLegacy?" legacy":""}`;try{this.notifier(`[${o}/${this.currentDocument+s.length-1} of ${r}] Parsing Foundry Actor for ${l}`,!1,!0),o++,i.logger.debug(`Attempting to parse ${o}/${r} ${e.name}`),i.logger.time(`Monster Parse ${l}`);const a=new n.A(e,{extra:this.extra,useItemAC:this.useItemAC,legacyName:this.legacyName,addMonsterEffects:this.addMonsterEffects,addChrisPremades:this.addChrisPremades});await a.parse(),t.push(foundry.utils.duplicate(a.npc)),i.logger.timeEnd(`Monster Parse ${l}`)}catch(e){i.logger.error(`Failed parsing ${l}`),i.logger.error(e),i.logger.error(e.stack),a.push(l)}}const l={actors:await Promise.all(t),failedMonsterNames:a};return i.logger.timeEnd("Monster Parsing"),this.notifier(`Parsed ${l.actors.length} monsters, failed ${l.failedMonsterNames.length} monsters`,!1,!0),i.logger.info(`Parsed ${l.actors.length} monsters, failed ${l.failedMonsterNames.length} monsters`),l.failedMonsterNames&&0!==l.failedMonsterNames.length&&i.logger.error("Failed to parse",l.failedMonsterNames),this.npcs.push(...l.actors),l}async#n(){i.logger.info("Checking for existing files..."),this.notifier("Checking existing image files..."),CONFIG.DDBI.KNOWN.TOKEN_LOOKUPS.clear(),CONFIG.DDBI.KNOWN.AVATAR_LOOKUPS.clear(),await i.Iconizer.preFetchDDBIconImages(),await i.FileHelper.generateCurrentFiles(this.uploadDirectory),await i.FileHelper.generateCurrentFiles("[data] modules/ddb-importer/data"),game.canvas3D?.CONFIG?.UI&&await game.canvas3D.CONFIG.UI.TokenBrowser.preloadData()}async#s({monsters:e=[],i:t=0}={}){i.logger.time(`Monster Process Time ${t}`);const a=await this.parse(e),n=new i.DDBItemImporter(this.type,a.actors,{notifier:i.utils.munchNote});if(await n.init(),i.logger.debug("Item Importer Loaded"),!this.update||!this.updateImages){this.notifier("Calculating which monsters to update...",!0);const e=await n.loadPassedItemsFromCompendium(n.documents,"npc",{keepDDBId:!0}),t=e.length+1;this.update||(i.logger.debug("Removing existing monsters from import list"),i.logger.debug(`Matched ${t}`),this.notifier(`Removing ${t} from update...`),n.removeItems(e,!0)),this.updateImages||(i.logger.debug("Copying monster images across..."),this.notifier(`Copying images for ${t} monsters...`),n.documents=(0,r.dD)(n.documents,e))}return this.notifier(""),this.notifier("Fiddling with the SRD data...",!0),await n.srdFiddling(),await n.iconAdditions(),this.notifier("Generating Icon Map..",!0),await(0,r.VL)(n.documents),await(0,r.D9)(n.documents),i.logger.timeEnd(`Monster Process Time ${t}`),i.logger.debug(`Monster Document Generation ${t}`,{itemHandler:n}),n.documents}async#r(e){const t=this.currentDocument;for(const a of e){this.notifier(`[${this.currentDocument}/${e.length+t-1} of ${this.totalDocuments}] Importing ${a.name} to compendium`,!1,!0),i.logger.debug(`Preparing ${a.name} data for import`);const n=await(0,r.VJ)(a,"monster");this.monstersParsed.push(n),this.currentDocument+=1}}async processIntoCompendium(e=null){i.logger.time("Monster Import Time"),await this.#n(),i.logger.info("Check complete getting monster data..."),this.notifier("Getting monster data from DDB..."),await this.fetchDDBMonsterSourceData(DDBMonsterFactory.defaultFetchOptions(e)),this.notifier(""),this.notifier("Checking compendium folders..",!0),await this.compendiumFolders.loadCompendium("monsters"),this.notifier("",!0),this.totalDocuments=this.source.length;for(let e=0;e<this.source.length;e+=100){const t=this.source.slice(e,e+100);i.logger.debug(`Processing documents for ${e+1} to ${e+100}`,{sourceDocuments:t,this:this});const a=await this.#s({monsters:this.source.slice(e,e+100),i:e}),n=this.currentDocument+a.length;this.notifier(`Preparing dinner for monsters ${e+1} to ${n} of ${this.totalDocuments}!`,!0),await this.#r(a)}return i.logger.debug("Monsters Parsed",this.monstersParsed),this.notifier("",!1,!0),i.logger.timeEnd("Monster Import Time"),null!==e?Promise.all(this.monstersParsed):this.totalDocuments}}},410:(e,t,a)=>{a.d(t,{A:()=>AdvancementHelper});var i=a(115),n=a(421),s=a(111),r=a(382);class AdvancementHelper{constructor({ddbData:e,type:t,dictionary:a=null,noMods:i=!1}){this.ddbData=e,this.type=t,this.noMods=i,this.dictionary=a}static stripDescription(e){return function htmlToText(e){return e.replace(/<\/td>/g,"\n").replace(/<\/table>/g,"\n").replace(/<\/tr>/g,"\n").replace(/<\/p>/g,"\n").replace(/<\/div>/g,"\n").replace(/<\/h>/g,"\n").replace(/<br>/g,"\n").replace(/<br( )*\/>/g,"\n").replace(/<[A-Za-z/][^<>]*>/g,"")}(e.replaceAll(/<br \/>(?:\s*)*/g,"<br />\n").replaceAll(/<\/p>(?:\s*)*/g,"</p>\n").replaceAll(/<\/dt>(?:\s*)*<dt>/g,"</dt>\n<dt>"))}getSkillChoicesFromOptions(e,t,a=[]){const n=new Set,s=new Set,r=this.ddbData.character.choices.choiceDefinitions;return this.ddbData.character.choices[this.type].filter((i=>(null===e&&a.some((e=>e.id===i.componentId&&e.requiredLevel===t))||e&&e.id===i.componentId&&e.requiredLevel===t)&&1===i.subType&&2===i.type)).forEach((e=>{const t=r.find((t=>t.id===`${e.componentTypeId}-${e.type}`));if(!t)return;const a=t.options.find((t=>t.id===e.optionValue));if(!a)return;const o=i.x.actor.skills.find((e=>e.label===a.label));o&&n.add(o.name);const l=t.options.filter((t=>i.x.actor.skills.some((e=>e.label===t.label))&&e.optionIds.includes(t.id))).map((e=>i.x.actor.skills.find((t=>t.label===e.label)).name));l.forEach((e=>{s.add(e)}))})),{chosen:Array.from(n),choices:Array.from(s)}}getToolChoicesFromOptions(e,t){const a=new Set,n=new Set,s=this.ddbData.character.choices.choiceDefinitions;return this.ddbData.character.choices[this.type].filter((a=>e.id===a.componentId&&e.requiredLevel===t&&1===a.subType&&2===a.type)).forEach((e=>{const t=s.find((t=>t.id===`${e.componentTypeId}-${e.type}`));if(!t)return;const r=t.options.find((t=>t.id===e.optionValue));if(!r)return;const o=i.x.actor.proficiencies.find((e=>"Tool"===e.type&&e.name===r.label));if(o){const e=""===o.toolType?o.baseTool:`${o.toolType}:${o.baseTool}`;a.add(e)}const l=t.options.filter((t=>i.x.actor.proficiencies.some((e=>"Tool"===e.type&&e.name===t.label))&&e.optionIds.includes(t.id))).map((e=>i.x.actor.proficiencies.find((t=>"Tool"===t.type&&t.name===e.label))));l.forEach((e=>{const t=""===e.toolType?e.baseTool:`${e.toolType}:${e.baseTool}`;n.add(t)}))})),{chosen:Array.from(a),choices:Array.from(n)}}getLanguageChoicesFromOptions(e,t){const a=new Set,n=new Set,s=this.ddbData.character.choices.choiceDefinitions;return this.ddbData.character.choices[this.type].filter((a=>e.id===a.componentId&&e.requiredLevel===t&&3===a.subType&&2===a.type)).forEach((e=>{const t=s.find((t=>t.id===`${e.componentTypeId}-${e.type}`));if(!t)return;const r=t.options.find((t=>t.id===e.optionValue));if(!r)return;const o=i.x.actor.languages.find((e=>e.name===r.label));o&&a.add(o.value);const l=t.options.filter((t=>i.x.actor.languages.find((e=>e.name===t.label))&&e.optionIds.includes(t.id))).map((e=>i.x.actor.languages.find((t=>t.name===e.label)).value));l.forEach((e=>{n.add(e)}))})),{chosen:Array.from(a),choices:Array.from(n)}}getChoicesFromOptions(e,t,a,n=null){const s=new Set,r=new Set,o=this.ddbData.character.choices.choiceDefinitions;return this.ddbData.character.choices[n??this.type].filter((t=>e.id===t.componentId&&e.requiredLevel===a&&1===t.subType&&2===t.type)).forEach((e=>{const a=o.find((t=>t.id===`${e.componentTypeId}-${e.type}`));if(!a)return;const n=a.options.find((t=>t.id===e.optionValue));if(!n)return;const l=i.x.actor.proficiencies.find((e=>e.type===t&&e.name===n.label));if(l){const e=""===l.advancement?l.foundryValue:`${l.advancement}:${l.foundryValue}`;s.add(e)}const d=a.options.filter((a=>i.x.actor.proficiencies.some((e=>e.type===t&&e.name===a.label))&&e.optionIds.includes(a.id))).map((e=>i.x.actor.proficiencies.find((a=>a.type===t&&a.name===e.label))));d.forEach((e=>{const t=""===e.advancement?e.foundryValue:`${e.advancement}:${e.foundryValue}`;r.add(t)}))})),{chosen:Array.from(s),choices:Array.from(r)}}getExpertiseChoicesFromOptions(e,t){const a=new Set,n=new Set,s=new Set,r=new Set,o=this.ddbData.character.choices.choiceDefinitions;return this.ddbData.character.choices[this.type].filter((a=>e.id===a.componentId&&e.requiredLevel===t&&2===a.subType&&2===a.type)).forEach((e=>{const t=o.find((t=>t.id===`${e.componentTypeId}-${e.type}`));if(!t)return;const l=t.options.find((t=>t.id===e.optionValue));if(!l)return;const d=i.x.actor.skills.find((e=>e.label===l.label));d&&a.add(d.name);const c=i.x.actor.proficiencies.find((e=>"Tool"===e.type&&e.name===l.label));c&&s.add(c.baseTool);const u=t.options.filter((t=>i.x.actor.skills.some((e=>e.label===t.label))&&e.optionIds.includes(t.id))).map((e=>i.x.actor.skills.find((t=>t.label===e.label)).name));u.forEach((e=>{n.add(e)}));const m=t.options.filter((t=>i.x.actor.proficiencies.find((e=>"Tool"===e.type&&e.name===t.label))&&e.optionIds.includes(t.id))).map((e=>i.x.actor.proficiencies.find((t=>"Tool"===t.type&&t.name===e.label)).baseTool));m.forEach((e=>{r.add(e)}))})),{skills:{chosen:Array.from(a),choices:Array.from(n)},tools:{chosen:Array.from(s),choices:Array.from(r)}}}static advancementUpdate(e,{pool:t=[],chosen:a=[],count:i=0,grants:n=[]}={}){n.length>0&&e.updateSource({configuration:{grants:n}}),t.length>0&&e.updateSource({configuration:{choices:[{count:0===i?void 0:i,pool:t}]}}),a.length>0&&e.updateSource({value:{chosen:a}})}static getSaveAdvancement(e,t,a){const n=i.x.actor.abilities.filter((t=>r.DDBModifiers.filterModifiers(e,"proficiency",{subType:`${t.long}-saving-throws`}).length>0)).map((e=>`saves:${e.value}`));if(0===n.length)return null;const s=new game.dnd5e.documents.advancement.TraitAdvancement;return s.updateSource({classRestriction:a>1?"":t?"secondary":"primary",configuration:{grants:n,allowReplacements:!1},level:a}),n.length>0&&s.updateSource({value:{chosen:n}}),s}getSkillAdvancement(e,t,a,n,s=0){const r="Proficiencies"===t.name||t.name.startsWith("Core")&&t.name.endsWith("Traits"),o=e.filter((e=>i.x.actor.skills.find((t=>t.label===e.friendlySubtypeName)))).map((e=>i.x.actor.skills.find((t=>t.label===e.friendlySubtypeName)).name)),l=new game.dnd5e.documents.advancement.TraitAdvancement,d=AdvancementHelper.parseHTMLSkills(t.description),c=this.noMods?{chosen:[],choices:[]}:this.getSkillChoicesFromOptions(t,n),u=this.noMods||d.number>0||d.grants.length>0?d.number:r&&a?s:e.length;if(0===u&&0===d.grants.length)return null;const m=void 0===a?void 0:n>1?"":a?"secondary":"primary",p=r||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"Skill Proficiencies":t.name;l.updateSource({title:p,classRestriction:m,configuration:{allowReplacements:!0},level:n});const g=this.noMods||d.choices.length>0||d.grants.length>0?d.choices.map((e=>`skills:${e}`)):o.map((e=>`skills:${e}`)),h=this.noMods||c.chosen.length>0?c.chosen.map((e=>`skills:${e}`)).concat(d.grants.map((e=>`skills:${e}`))):o.map((e=>`skills:${e}`));return AdvancementHelper.advancementUpdate(l,{pool:g,chosen:h,count:u,grants:d.grants.map((e=>`skills:${e}`))}),l}getLanguageAdvancement(e,t,a){const n=r.DDBModifiers.filterModifiers(e,"language"),s=new game.dnd5e.documents.advancement.TraitAdvancement,o=AdvancementHelper.parseHTMLLanguages(t.description),l=this.noMods?{chosen:[],choices:[]}:this.getLanguageChoicesFromOptions(t,a),d=n.filter((e=>i.x.actor.languages.find((t=>t.name===e.friendlySubtypeName)))).map((e=>{const t=i.x.actor.languages.find((t=>t.name===e.friendlySubtypeName));return t.advancement?`${t.advancement}:${t.value}`:t.value})),c=this.noMods||o.number>0||o.grants.length>0?0!==o.number?o.number:1:n.length;if(0===c&&0===o.grants.length)return null;const u=this.noMods||o.choices.length>0||o.grants.length>0?o.choices.map((e=>`languages:${e}`)):d.map((e=>`languages:${e}`)),m=this.noMods||l.chosen.length>0?l.chosen.map((e=>`languages:${e}`)).concat(o.grants.map((e=>`languages:${e}`))):d.map((e=>`languages:${e}`));return s.updateSource({title:!t.name||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"Languages":t.name,configuration:{allowReplacements:!0},level:a}),AdvancementHelper.advancementUpdate(s,{pool:u,chosen:m,count:c,grants:o.grants.map((e=>`languages:${e}`))}),s}getToolAdvancement(e,t,a){const n=r.DDBModifiers.filterModifiers(e,"proficiency").filter((e=>i.x.actor.proficiencies.some((t=>"Tool"===t.type&&t.name===e.friendlySubtypeName)))),s=new game.dnd5e.documents.advancement.TraitAdvancement,o=AdvancementHelper.parseHTMLTools(t.description),l=this.noMods?{chosen:[],choices:[]}:this.getToolChoicesFromOptions(t,a),d=n.map((e=>{const t=i.x.actor.proficiencies.find((t=>"Tool"===t.type&&t.name===e.friendlySubtypeName));return""===t.toolType?t.baseTool:`${t.toolType}:${t.baseTool}`})),c=this.noMods||o.number>0||o.grants.length>0?o.number>0?o.number:1:n.length;if(0===c&&0===o.grants.length)return null;const u=this.noMods||o.choices.length>0||o.grants.length>0?o.choices.map((e=>`tool:${e}`)):d.map((e=>`tool:${e}`)),m=this.noMods||l.chosen.length>0?l.chosen.map((e=>`tool:${e}`)).concat(o.grants.map((e=>`tool:${e}`))):d.map((e=>`tool:${e}`));return s.updateSource({title:!t.name||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"Tool Proficiencies":t.name,configuration:{allowReplacements:!0},level:a}),AdvancementHelper.advancementUpdate(s,{pool:u,chosen:m,count:c,grants:o.grants.map((e=>`tool:${e}`))}),s}getArmorAdvancement(e,t,a,n){const s=r.DDBModifiers.filterModifiers(e,"proficiency").filter((e=>i.x.actor.proficiencies.some((t=>"Armor"===t.type&&t.name===e.friendlySubtypeName)))),o=new game.dnd5e.documents.advancement.TraitAdvancement,l=AdvancementHelper.parseHTMLArmorProficiencies(t.description),d=this.noMods?{chosen:[],choices:[]}:this.getChoicesFromOptions(t,"Armor",n),c=s.map((e=>{const t=i.x.actor.proficiencies.find((t=>"Armor"===t.type&&t.name===e.friendlySubtypeName));return""===t.advancement?t.foundryValue:`${t.advancement}:${t.foundryValue}`})),u=this.noMods||l.number>0||l.grants.length>0?l.number>0?l.number:1:s.length;if(0===u&&0===l.grants.length)return null;const m=void 0===a?void 0:n>1?"":a?"secondary":"primary",p=this.noMods||l.choices.length>0||l.grants.length>0?l.choices.map((e=>`armor:${e}`)):c.map((e=>`armor:${e}`)),g=this.noMods||d.chosen.length>0?d.chosen.map((e=>`armor:${e}`)).concat(l.grants.map((e=>`armor:${e}`))):c.map((e=>`armor:${e}`));return o.updateSource({title:!t.name||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"Armor Training":t.name,classRestriction:m,configuration:{allowReplacements:!1},level:n}),AdvancementHelper.advancementUpdate(o,{pool:p,chosen:g,count:u,grants:l.grants.map((e=>`armor:${e}`))}),o}getWeaponAdvancement(e,t,a){const n=r.DDBModifiers.filterModifiers(e,"proficiency").filter((e=>i.x.actor.proficiencies.some((t=>"Weapon"===t.type&&t.name===e.friendlySubtypeName)))),s=new game.dnd5e.documents.advancement.TraitAdvancement,o=AdvancementHelper.parseHTMLWeaponProficiencies(t.description),l=this.noMods?{chosen:[],choices:[]}:this.getChoicesFromOptions(t,"Weapon",a),d=n.map((e=>{const t=i.x.actor.proficiencies.find((t=>"Weapon"===t.type&&t.name===e.friendlySubtypeName));return""===t.advancement?t.foundryValue:`${t.advancement}:${t.foundryValue}`})),c=this.noMods||o.number>0||o.grants.length>0?o.number>0?o.number:1:n.length;if(0===c&&0===o.grants.length)return null;const u=this.noMods||o.choices.length>0||o.grants.length>0?o.choices.map((e=>`weapon:${e}`)):d.map((e=>`weapon:${e}`)),m=this.noMods||l.chosen.length>0?l.chosen.map((e=>`weapon:${e}`)).concat(o.grants.map((e=>`weapon:${e}`))):d.map((e=>`weapon:${e}`));return s.updateSource({title:!t.name||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"Weapon Proficiencies":t.name,configuration:{mode:"default",allowReplacements:!1},level:a}),AdvancementHelper.advancementUpdate(s,{pool:u,chosen:m,count:c,grants:o.grants.map((e=>`weapon:${e}`))}),s}getWeaponMasteryAdvancement(e,t,a){const n=r.DDBModifiers.filterModifiers(e,"weapon-mastery").filter((e=>i.x.actor.proficiencies.some((t=>{const a=/(\w+) \(([\w ]+)\)/gi.exec(e.friendlySubtypeName);return!!a&&("Weapon"===t.type&&t.name===a[2])})))),s=new game.dnd5e.documents.advancement.TraitAdvancement,o=AdvancementHelper.parseHTMLWeaponMasteryProficiencies(t.description),l=this.noMods?{chosen:[],choices:[]}:this.getChoicesFromOptions(t,"Weapon",a),d=n.map((e=>{const t=i.x.actor.proficiencies.find((t=>{const a=/(\w+) \(([\w ]+)\)/gi.exec(e.friendlySubtypeName);return!!a&&("Weapon"===t.type&&t.name===a[2])}));return""===t.advancement?t.foundryValue:`${t.advancement}:${t.foundryValue}`})),c=this.noMods||o.number>0||o.grants.length>0?o.number>0?o.number:1:n.length;if(0===c&&0===o.grants.length)return null;const u=this.noMods||o.choices.length>0||o.grants.length>0?o.choices.map((e=>`weapon:${e}`)):d.map((e=>`weapon:${e}`)),m=this.noMods||l.chosen.length>0?l.chosen.map((e=>`weapon:${e}`)).concat(o.grants.map((e=>`weapon:${e}`))):d.map((e=>`weapon:${e}`));return s.updateSource({title:!t.name||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"Weapon Masteries":t.name,configuration:{mode:"mastery",allowReplacements:!0},level:a}),AdvancementHelper.advancementUpdate(s,{pool:u,chosen:m,count:c,grants:o.grants.map((e=>`weapon:${e}`))}),s}getExpertiseAdvancement(e,t){const a=new game.dnd5e.documents.advancement.TraitAdvancement,i=this.noMods?{chosen:[],choices:[]}:this.getExpertiseChoicesFromOptions(e,t),n="Survivalist"===e.name?["skills:prc","skills:nat"]:"Expertise"===e.name?["skills:*","tool:thief"]:["skills:*"],s="Survivalist"===e.name?n:[],r="Survivalist"===e.name?0:i.length>0?i.length:2;a.updateSource({title:"Survivalist"===e.name?`${e.name} (Expertise)`:`${e.name}`,configuration:{allowReplacements:!1,mode:"expertise"},level:t});const o=i.skills.chosen.map((e=>`skills:${e}`)),l=i.tools.chosen.map((e=>`tool:${e}`)),d=[].concat(o,l,s);return AdvancementHelper.advancementUpdate(a,{chosen:d,pool:n,count:r,grants:s}),a}static CONDITION_ID_MAPPING={1:"dr",2:"di",3:"dv",4:"ci"};getConditionAdvancement(e,t,a){const i=[];["resistance","immunity","vulnerability","immunity"].forEach(((t,a)=>{const n=r.DDBModifiers.filterModifiers(e,t,{restriction:null}),o=a+1,l=s.AutoEffects.getGenericConditionAffectData(n,t,o,!0),d=new Set(l.map((e=>`${AdvancementHelper.CONDITION_ID_MAPPING[o]}:${e.value}`)));i.push(...d)}));const n=new game.dnd5e.documents.advancement.TraitAdvancement,o=AdvancementHelper.parseHTMLConditions(t.description),l=this.noMods||o.number>0||o.grants.length>0?o.number>0?o.number:1:i.length;if(0===l&&0===o.grants.length)return null;const d=this.noMods||o.choices.length>0||o.grants.length>0?o.choices.map((e=>e)):i.map((e=>e)),c=this.noMods?o.grants.map((e=>e)):i.map((e=>e));return n.updateSource({title:!t.name||t.name.startsWith("Background:")||t.name.startsWith("Core ")?"":t.name,configuration:{allowReplacements:!1,hint:o.hint},level:a}),AdvancementHelper.advancementUpdate(n,{pool:d,chosen:c,count:l,grants:o.grants.map((e=>e))}),n}static convertToSingularDie(e){e.title+=" (Die)";for(const t of Object.keys(e.configuration.scale))e.configuration.scale[t].n=1;return e}static renameTotal(e){return e.title+=" (Total)",e}static rename(e,{newName:t=null,identifier:a=null}={}){return t&&(e.title=t),a&&(e.configuration.identifier=a),e}static addAdditionalUses(e){const t=new game.dnd5e.documents.advancement.ScaleValueAdvancement,a={configuration:{identifier:`${e.configuration.identifier}-uses`,type:"number",scale:{}},title:`${e.title} (Uses)`};for(const[t,i]of Object.entries(e.configuration.scale))a.configuration.scale[t]={value:i.number};return t.updateSource(a),t.toObject()}static addSingularDie(e){const t=AdvancementHelper.convertToSingularDie(foundry.utils.duplicate(e));return t._id=foundry.utils.randomID(),t.configuration.identifier=`${e.configuration.identifier}-die`,t}static generateScaleValueAdvancement(e){let t="string";const a=e.levelScales[0]?.dice?e.levelScales[0]?.dice:e.levelScales[0]?.die?e.levelScales[0]?.die:void 0;!a?.diceString||a.fixedValue&&""!==a.fixedValue?e.levelScales[0].fixedValue&&""!==e.levelScales[0].fixedValue&&Number.isInteger(e.levelScales[0].fixedValue)&&(t="number"):t="dice";const i=new game.dnd5e.documents.advancement.ScaleValueAdvancement,s=n.utils.nameString(e.name),r={configuration:{identifier:n.utils.referenceNameString(s).toLowerCase(),type:t,scale:{}},value:{},title:s};return e.levelScales.forEach((a=>{const i=Math.max(a.level,e.requiredLevel??1),n=a.dice?a.dice:a.die?a.die:void 0;if("dice"===t)r.configuration.scale[i]={n:n.diceCount,die:n.diceValue};else if("number"===t)r.configuration.scale[i]={value:a.fixedValue};else{let e=n.diceString&&""!==n.diceString?n.diceString:"";n.fixedValue&&""!==n.fixedValue&&(e+=` + ${n.fixedValue}`),""===e&&(e=a.description),r.configuration.scale[i]={value:e}}})),i.updateSource(r),i.toObject()}static parseHTMLSaves(e){const t=[],a=AdvancementHelper.stripDescription(e).toLowerCase().split("saving throws:").pop().split("\n")[0].split("The")[0].split(".")[0].split("skills:")[0].trim().match(/(.*)(?:$|The|\.$|\w+:)/im);if(a){const e=a[1].replace(" and ",",").split(",").map((e=>e.trim())).filter((e=>i.x.actor.abilities.some((t=>t.long.toLowerCase()===e.toLowerCase())))).map((e=>i.x.actor.abilities.find((t=>t.long.toLowerCase()===e.toLowerCase())).value));t.push(...e)}return t}static parseHTMLSkills(e){const t={choices:[],grants:[],number:0,allowReplacements:!0},a=AdvancementHelper.stripDescription(e).replace(/\s/g," "),n=a.match(/Skills:\sChoose any (\w+)(.*)($|\.$|\w+:)/im);if(n){const e=i.x.numbers.find((e=>n[1].toLowerCase()===e.natural));return t.number=e?e.num:2,t.choices=["*"],t}const s=a.match(/Skill Proficiencies:\s(.*?)($|\.$|\w+:)/im);if(s){return s[1].replace(" and ",",").split(",").map((e=>e.trim())).forEach((e=>{const a=i.x.actor.skills.find((t=>t.label.toLowerCase()===e.toLowerCase().split(" ")[0]));a&&t.grants.push(a.name)})),t}const r=a.toLowerCase().split("skills:").pop().split("\n")[0].split("the")[0].split(".")[0].trim().match(/choose (\w+)(?:\sskills)* from (.*)($|The|\.|\w+:)/im),o=a.match(/you gain proficiency (?:in|with) (\w+) of the following skills of your choice:\s(.*?)(\.|$)/im),l=a.match(/also become proficient in your choice of (\w+) of the following skills:\s(.*?)(\.|$)/im);if(r||o||l){const e=r??o??l,a=e[2].replace(" and ",",").replace(" or "," ").split(",").map((e=>e.trim())).filter((e=>i.x.actor.skills.some((t=>t.label.toLowerCase()===e.toLowerCase())))).map((e=>i.x.actor.skills.find((t=>t.label.toLowerCase()===e.toLowerCase())).name)),n=i.x.numbers.find((t=>e[1].toLowerCase()===t.natural));return t.number=n?n.num:2,t.choices=a,t}if(!a.includes("proficiency"))return t;if(a.match(/You gain (?:one skill proficiency of your choice|proficiency in (?:an additional skill|one skill of your choice))/im))return t.number=1,t.choices=["*"],t;const d=a.match(/You gain proficiency in the (.*) skill( if you don’t already have it)?/i);if(d){return d[1].replace(" and ",",").split(",").map((e=>e.trim())).forEach((e=>{const a=i.x.actor.skills.find((t=>t.label.toLowerCase()===e.toLowerCase()));a&&t.grants.push(a.name)})),t}return t}static parseHTMLLanguages(e){const t={grants:[],choices:[],number:0},a=AdvancementHelper.stripDescription(e),n=a.match(/Languages:\s(.*?)($|\.$|\w+:)/im);if(n){const e=/(?:(\w+)?(?: and))?\s?(?:(\w+)(?: other language)*)\sof\syour\schoice(?: of (.*))*/im,s=n[1].match(e);if(s){if(s[1]){const e=i.x.actor.languages.find((e=>e.name.toLowerCase()===s[1].split(" ")[0].toLowerCase().trim()));if(e){const a=e.advancement?`${e.advancement}:${e.value}`:e.value;t.grants.push(a)}}if(s[2]){const e=i.x.numbers.find((e=>s[2].toLowerCase().trim()===e.natural));if(t.number=e?e.num:1,s[3]){s[3].replace(" or ",",").split(",").map((e=>e.trim())).forEach((e=>{const a=i.x.actor.languages.find((t=>t.name.toLowerCase()===e.toLowerCase().split(" ")[0]));if(a){const e=a.advancement?`${a.advancement}:${a.value}`:a.value;t.choices.push(e)}}))}else t.choices=["*"]}return t}const r=/choose (\w+)(?: of (.*))*/im,o=a.match(r);if(o){const e=i.x.numbers.find((e=>o[1].toLowerCase().trim()===e.natural));if(t.number=e?e.num:1,o[2]){o[2].replace(" or ",",").split(",").map((e=>e.trim())).forEach((e=>{const a=i.x.actor.languages.find((t=>t.name.toLowerCase()===e.toLowerCase().split(" ")[0]));if(a){const e=a.advancement?`${a.advancement}:${a.value}`:a.value;t.choices.push(e)}}))}else t.choices=["*"];return t}if(t.number=1,n[1]){return n[1].replace(" or ",",").split(",").map((e=>e.trim())).forEach((e=>{const a=i.x.actor.languages.find((t=>t.name.toLowerCase()===e.toLowerCase()));if(a){const e=a.advancement?`${a.advancement}:${a.value}`:a.value;t.choices.push(e)}})),t}}const s=a.match(/learn (\w+?|a new) language(?:s)? of your choice/im);if(s){const e=i.x.numbers.find((e=>s[1].toLowerCase()===e.natural));return t.number=e?e.num:2,t.choices=["*"],t}const r=a.match(/speak, read, and write (.*?)(?:\.|$)/im);if(r){const e=r[1].replace(" and ",",").split(",").map((e=>e.trim()));return t.number=0,e.forEach((e=>{if(e.includes("other language")||e.includes("of your choice"))t.number++,t.choices=["*"];else{const a=i.x.actor.languages.find((t=>t.name.toLowerCase()===e.toLowerCase()));if(a){const e=a.advancement?`${a.advancement}:${a.value}`:a.value;t.grants=[e]}}})),t}const o=a.match(/fluency in (\w+) language(?:s)? of your choice/i);if(o){const e=i.x.numbers.find((e=>o[1].toLowerCase()===e.natural));return t.number=e?e.num:1,t.number=1,t.choices=["*"],t}return t}static TOOL_GROUPS={"musical instrument":"music","gaming set":"game","artisan's tools":"art",vehicle:"vehicle"};static getToolGroup(e){for(const[t,a]of Object.entries(AdvancementHelper.TOOL_GROUPS))if(n.utils.nameString(e).toLowerCase().includes(t))return a;return null}static getDictionaryTool(e){const t=i.x.actor.proficiencies.find((t=>"Tool"===t.type&&t.name.toLowerCase()===n.utils.nameString(e).toLowerCase()));if(t)return t;const a=i.x.actor.proficiencies.filter((e=>"Tool"===e.type));for(const t of a)if(n.utils.nameString(e).toLowerCase().includes(t.name.toLowerCase()))return t;return null}static getToolAdvancementValue(e){const t=AdvancementHelper.getDictionaryTool(e);if(t){return""===t.toolType?t.baseTool:`${t.toolType}:${t.baseTool}`}return null}static parseHTMLTools(e){const t={choices:[],grants:[],number:0},a=AdvancementHelper.stripDescription(e);if(a.includes("Tools: None"))return t;const s=a.match(/^Tools:\sChoose (\w+) type of (.*)($|\.|\w+:)/im),r=a.match(/^Tools:\s(\w+)\s(.*) of your choice($|\.|\w+:)/im);if(s||r){const e=s??r,a=i.x.numbers.find((t=>e[1].toLowerCase()===t.natural));t.number=a?a.num:2;const o=e[2].split(" or ");for(const e of o){const a=AdvancementHelper.getToolGroup(e);a?t.choices.push(`${a}:*`):n.logger.error(`Could not find tool group for ${e}, please log an issue`)}return t}const o=a.match(/^(?:Tools|Tool Proficiencies):\s(.*?)($|\.|\w+:)/im),l=/(\w+) type of (.*)($|\.|\w+:)/i;if(o){const e=o[1].split(",").map((e=>e.trim()));for(const a of e){const e=a.match(l);if(e){const a=i.x.numbers.find((t=>e[1].toLowerCase()===t.natural));t.number=a?a.num:1,e[2].split(" or ").forEach((e=>{const a=AdvancementHelper.getToolGroup(e.trim());a&&t.choices.push(`${a}:*`)}))}else{const e=AdvancementHelper.getToolAdvancementValue(a);e&&t.grants.push(e)}}return t}if(!a.includes("proficiency"))return t;const d=a.match(/You gain proficiency with (.*?)($|\.|\w+:)/im);if(d){const e=d[2].replace(" and ",",").split(",").map((e=>e.trim()));for(const n of e){const e=/(\w+) (.*?) of your choice($|\.|\w+:)/i,s=a.match(e);if(s){const e=i.x.numbers.find((e=>s[1].toLowerCase()===e.natural));t.number=e?e.num:1;const a=AdvancementHelper.getToolGroup(s[2]);a&&t.choices.push(`${a}:*`)}else{const e=AdvancementHelper.getToolAdvancementValue(n);e&&t.grants.push(e)}}return t}return a.match(/(\w*) tool proficiency of your choice/i)?(t.number=1,t.choices=["*"],t):t}static ARMOR_GROUPS=i.x.actor.proficiencies.filter((e=>"Armor"===e.type&&foundry.utils.hasProperty(e,"foundryValue")&&""===e.advancement)).reduce(((e,t)=>(e[t.name.toLowerCase()]=t.foundryValue,e)),{});static getArmorGroup(e){for(const[t,a]of Object.entries(AdvancementHelper.ARMOR_GROUPS))if(n.utils.nameString(e).toLowerCase().includes(t))return a;return null}static getDictionaryArmor(e){const t=i.x.actor.proficiencies.find((t=>"Armor"===t.type&&foundry.utils.hasProperty(t,"foundryValue")&&t.name.toLowerCase()===n.utils.nameString(e).toLowerCase()));if(t)return t;const a=i.x.actor.proficiencies.filter((e=>"Armor"===e.type&&foundry.utils.hasProperty(e,"foundryValue")));for(const t of a)if(n.utils.nameString(e).toLowerCase().includes(t.name.toLowerCase()))return t;return null}static getArmorAdvancementValue(e){const t=AdvancementHelper.getDictionaryArmor(e);if(t){return""===t.advancement?t.foundryValue:`${t.advancement}:${t.foundryValue}`}return null}static parseHTMLArmorProficiencies(e){const t={choices:[],grants:[],number:0},a=AdvancementHelper.stripDescription(e);if(a.includes("Armor: None"))return t;const i=a.match(/^Armor:\s(.*?)($|\.|\w+:)/im);if(i){const e=i[1].split(",").map((e=>e.trim()));for(const a of e){const e=AdvancementHelper.getArmorAdvancementValue(a);"all"===e?t.grants.push("lgt","med","hvy"):e&&t.grants.push(e)}return t}if(!a.includes("proficiency"))return t;const n=a.match(/You gain proficiency with (.*?)($|\.|\w+:)/im);if(n){const e=n[2].replace(" and ",",").split(",").map((e=>e.trim()));for(const a of e){const e=AdvancementHelper.getArmorAdvancementValue(a);e&&t.grants.push(e)}}return t}static WEAPON_GROUPS=i.x.actor.proficiencies.filter((e=>"Weapon"===e.type&&""!==foundry.utils.getProperty(e,"foundryValue")&&""===e.advancement)).reduce(((e,t)=>(e[t.name.toLowerCase()]=t.foundryValue,e)),{});static getWeaponGroup(e){for(const[t,a]of Object.entries(AdvancementHelper.WEAPON_GROUPS))if(n.utils.nameString(e).toLowerCase().includes(t))return a;return null}static getDictionaryWeapon(e){const t=i.x.actor.proficiencies.find((t=>"Weapon"===t.type&&""!==foundry.utils.getProperty(t,"foundryValue")&&(t.name.toLowerCase()===n.utils.nameString(e).toLowerCase()||`${t.name.toLowerCase()}s`===n.utils.nameString(e).toLowerCase()||`the ${t.name.toLowerCase()}`===n.utils.nameString(e).toLowerCase())));return t||null}static getWeaponAdvancementValue(e){const t=AdvancementHelper.getDictionaryWeapon(e);if(t){return""===t.advancement?t.foundryValue:`${t.advancement}:${t.foundryValue}`}return null}static parseHTMLWeaponMasteryProficiencies(e){return{choices:["*"],grants:[],number:0}}static parseHTMLWeaponProficiencies(e){const t={choices:[],grants:[],number:0},a=AdvancementHelper.stripDescription(e);if(a.includes("Weapons: None"))return t;const s=a.match(/^Weapons:\s(.*?)($|\.|\w+:)/im),r=/(\w+) type of (.*)($|\.|\w+:)/i;if(s){const e=s[1].split(",").map((e=>e.trim()));for(const a of e){const e=a.match(r);if(e){const a=i.x.numbers.find((t=>e[1].toLowerCase()===t.natural));t.number=a?a.num:1;const n=AdvancementHelper.getWeaponGroup(e[2]);n&&t.choices.push(`${n}:*`)}else{const e=AdvancementHelper.getWeaponAdvancementValue(a);e&&t.grants.push(e)}}return t}if(!a.includes("proficiency"))return t;const o=a.match(/You gain proficiency with (.*?)($|\.|\w+:)/im);if(o){const e=o[2].replace(" and ",",").split(",").map((e=>e.trim()));for(const s of e){const e=/(\w+) (.*?) of your choice($|\.|\w+:)/i,r=a.match(e);if(r){const e=i.x.numbers.find((e=>r[1].toLowerCase()===e.natural));t.number=e?e.num:1;const a=AdvancementHelper.getWeaponGroup(r[2]);if(a)t.choices.push(`${a}:*`);else if(r[2].toLowerCase().includes("one-handed melee weapon")){const e=i.x.actor.proficiencies.filter((e=>"Weapon"===e.type&&""!==foundry.utils.getProperty(e,"foundryValue")&&!0!==foundry.utils.getProperty(e,"properties.two")&&!0===foundry.utils.getProperty(e,"melee"))).map((e=>""===e.advancement?e.foundryValue:`${e.advancement}:${e.foundryValue}`));t.choices.push(...e)}else n.logger.warn(`unknown weapon group choices ${r[2]}`)}else{const e=AdvancementHelper.getWeaponAdvancementValue(s);e&&t.grants.push(e)}}return t}if(/Choose two types of weapons to be your kensei weapons/im.test(a)){t.number=2;const e=i.x.actor.proficiencies.filter((e=>"Weapon"===e.type&&""!==foundry.utils.getProperty(e,"foundryValue")&&!0!==foundry.utils.getProperty(e,"properties.spc")&&(!0!==foundry.utils.getProperty(e,"properties.hvy")||"Longbow"===e.name))).map((e=>""===e.advancement?e.foundryValue:`${e.advancement}:${e.foundryValue}`));t.choices.push(...e)}return t}static CONDITION_MAPPING={resistance:"dr",immunity:"di",immune:"di",vulnerability:"dv"};static parseHTMLConditions(e){const t=new Set,a=new Set,n={choices:[],grants:[],number:0,hint:""},s=AdvancementHelper.stripDescription(e).toLowerCase(),r=s.includes("damage"),o=s.replaceAll(" damage","");if(r){const e=/(?:you|the paladin) (?:also have|have|gains*|are) ([^advantage].*) to (.*?)($|\.|and you have advantage|\w+:)/im,a=o.match(e);if(a){const e=a[2].replace(" and ",",").split(",").map((e=>e.trim().toLowerCase()));for(const n of e){const e=a[1].toLowerCase().trim(),s=i.x.actor.damageAdjustments.find((t=>t.kind===e&&4!==t.type&&n===t.name.toLowerCase()));if(s){const a=AdvancementHelper.CONDITION_MAPPING[e],i=foundry.utils.hasProperty(s,"foundryValues")?foundry.utils.getProperty(s,"foundryValues"):foundry.utils.hasProperty(s,"foundryValue")?{value:s.foundryValue}:void 0;if(!i)continue;(game.modules.get("midi-qol")?.active&&i.midiValues?i.midiValues:[]).concat(i.value).map((e=>e.toLowerCase())).forEach((e=>{a&&t.add(`${a}:${e}`),"di"===a&&"poison"===e&&t.add("ci:poisoned")}))}}}}if(s.includes("immunity")||s.includes("immune")){const e=/(?:you have|and|you are|makes you) (?:immune|immunity) to (.*?)($|\.|and you have advantage|\w+:)/im,a=s.match(e);if(a){let e=!1;const n=a[1].replace(" and ",",").split(",").map((t=>{const a=t.trim().toLowerCase();return"poison"===t?(e=!0,"poisoned"):"disease"===t?"diseased":a}));for(const a of n){const n=i.x.actor.damageAdjustments.find((e=>"immunity"===e.kind&&4===e.type&&a===e.name.toLowerCase()));n&&(t.add(`ci:${n.foundryValue}`),e&&"poisoned"===n.foundryValue&&t.add("di:poison"))}}}const l=s.match(/resistance to the damage type associated with your (\w*) Ancestry/im);if(l)switch(n.count=1,n.hint=s,l[1].toLowerCase()){case"metallic":["fire","lightning","acid","cold"].forEach((e=>{s.includes(e)&&a.add(`dr:${e}`)}));break;case"chromatic":["acid","lightning","poison","fire","cold"].forEach((e=>{s.includes(e)&&a.add(`dr:${e}`)}));break;case"gem":["force","radiant","psychic","thunder","necrotic"].forEach((e=>{s.includes(e)&&a.add(`dr:${e}`)}));break;default:["acid","lightning","poison","fire","acid","cold"].forEach((e=>{s.includes(e)&&a.add(`dr:${e}`)}))}return s.includes("resistance to a damage type determined by your patron’s kind:")&&(n.count=1,n.hint=s,["bludgeoning","thunder","fire","cold"].forEach((e=>{s.includes(e)&&a.add(`dr:${e}`)}))),s.includes("resistance to all damage dealt by other creatures")&&(t.add("dr:all"),Object.keys(CONFIG.DND5E.damageTypes).forEach((e=>{t.add(`dr:${e}`)}))),n.grants=Array.from(t),n.choices=Array.from(a),n}}},37:(e,t,a)=>{a.d(t,{A:()=>DDBMonsterFeature});var i=a(421),n=a(115),s=a(259),r=a(648),o=a(382);class DDBMonsterFeature extends r.mixins.DDBActivityFactoryMixin{#o(){if(this.originalName=`${this.name}`,!this.stripName)return;const e=this.name.replace(/[–-–−]/g,"-").match(/(.*)\s*\((:?costs? \d actions|Recharges after a (Short or Long|Long) Rest|(?!Spell;|Psionics;).*\d\/day|recharge \d ?- ?\d|Recharge \d)\)/i);if(e)this.data.name=e[1].trim(),this.nameSplit=e[2];else{const e=/(.*)\s*\((.*); (:?costs \d actions|Recharges after a (Short or Long|Long) Rest|(?!Spell;|Psionics;).*\d\/day|recharge \d-\d|Recharge \d)\)/i,t=this.name.replace(/[–-–−]/g,"-").match(e);t&&(this.data.name=`${t[1].trim()} (${t[2].trim()})`,this.nameSplit=t[3])}}createBaseFeature(){this.data={_id:foundry.utils.randomID(),name:this.name,type:this.templateType,system:o.SystemHelpers.getTemplate(this.templateType),effects:[],flags:{ddbimporter:{levelBonus:!1,dndbeyond:{}},monsterMunch:{titleHTML:this.titleHTML,fullName:this.fullName,actionCopy:this.actionCopy,type:this.type,description:this.html}}},this.data.system.requirements="",this.data.sort=this.sort,this.levelBonus=!1}prepare(){this.strippedHtml=i.utils.stripHtml(`${this.html}`).trim();const e=o.DDBDescriptions.featureBasics({text:this.strippedHtml});this.isAttack=e.properties.isAttack,this.spellSave=e.properties.spellSave,this.savingThrow=e.properties.savingThrow,this.isSave=e.properties.isSave,this.halfDamage=e.properties.halfDamage,this.pbToAttack=e.properties.pbToAttack,this.weaponAttack=e.properties.weaponAttack,this.spellAttack=e.properties.spellAttack,this.meleeAttack=e.properties.meleeAttack,this.rangedAttack=e.properties.rangedAttack,this.healingAction=e.properties.healingAction,this.toHit=e.properties.toHit,this.yourSpellAttackModToHit=e.properties.yourSpellAttackModToHit,this.descriptionSave=e.save,this.isRecharge=this.#l(),this.templateType=this.isAttack&&null===this.isRecharge?"weapon":"feat","Legendary Actions"===this.name&&(this.templateType="feat"),this.data||this.createBaseFeature(),this.#o(),foundry.utils.setProperty(this.data,"flags.midiProperties",e.midiProperties),this.identifier=i.utils.referenceNameString(this.data.name.toLowerCase()),this.data.system.identifier=this.identifier,this.isAttack||foundry.utils.setProperty(this.data,"system.type.value","monster"),this.isCompanion="companion-feature"===foundry.utils.getProperty(this.ddbMonster,"npc.flags.ddbimporter.entityTypeId")}async loadEnricher(){await this.enricher.init(),await this.enricher.load({ddbParser:this,monster:this.ddbMonster.npc,name:this.name})}resetActionInfo(){this.actionInfo={baseItem:null,baseTool:null,damage:{base:null,onSave:null,parts:[],versatile:""},damageParts:[],healingParts:[],formula:"",target:{template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:""},affects:{count:"",type:"",choice:!1,special:""},prompt:!0,override:!1},duration:{value:"",units:"inst"},extraAttackBonus:0,baseAbility:null,proficient:!1,properties:{amm:!1,fin:!1,fir:!1,foc:!1,hvy:!1,lgt:!1,lod:!1,rch:!1,rel:!1,ret:!1,spc:!1,thr:!1,two:!1,ver:!1,mgc:!1},range:{value:null,long:null,units:"",reach:null},activation:{type:"",value:null,condition:""},save:{ability:[],dc:{calculation:"",formula:null}},uses:{spent:null,max:null,recovery:[]},consumptionValue:null,consumptionTargets:[]}}constructor(e,{ddbMonster:t,html:a,type:i,titleHTML:o,fullName:l,actionCopy:d,updateExisting:c,hideDescription:u,sort:m}={}){super({enricher:new r.DDBMonsterFeatureEnricher({activityGenerator:s.sr}),activityGenerator:s.sr}),this.name=e.trim(),this.ddbMonster=t,this.type=i,this.html=a??"",this.titleHTML=o??void 0,this.fullName=l??this.name,this.actionCopy=d??!1,this.sort=m??null,this.hideDescription=u??game.settings.get(n.y.MODULE_ID,"munching-policy-hide-description"),this.updateExisting=c??game.settings.get(n.y.MODULE_ID,"munching-policy-update-existing"),this.stripName=game.settings.get(n.y.MODULE_ID,"munching-policy-monster-strip-name"),this.prepare(),this.ddbMonster&&(this.data.system.source=this.ddbMonster.npc.system.details.source),this.actionInfo={},this.resetActionInfo()}damageModReplace(e){let t;const a=i.utils.parseDiceString(e,null);if(this.actionInfo.baseAbility){const e=this.ddbMonster.abilities[this.actionInfo.baseAbility].mod,n=a.bonus&&0!==a.bonus?a.bonus-e:"",s=a.bonus&&0!==a.bonus?" + @mod ":"";t=i.utils.diceStringResultBuild(a.diceMap,a.dice,n,s).diceString}else t=a.diceString;return t}generateDamageInfo(){const e=this.strippedHtml.indexOf("Hit:");let t=e>0?this.strippedHtml.slice(e):`${this.strippedHtml}`;t=t.split("At the end of each")[0].split("At the start of each")[0],t=t.replace(/[–-–−]/g,"-");const a=new RegExp(/((?:takes|saving throw or take\s+)|(?:[\w]*\s+))(?:([0-9]+))?(?:\s*\(?([0-9]*d[0-9]+(?:\s*[-+]\s*(?:[0-9]+|PB|the spell[’']s level))*(?:\s+plus [^\)]+)?)\)?)?\s*([\w ]*?)\s*damage(?: when used with | if (?:used|wielded) with )?(\s?two hands|\s?at the start of|\son a failed save)?/gi),n=[...t.matchAll(a)],s=new RegExp(/(regains|regain)\s+?(?:([0-9]+))?(?: *\(?([0-9]*d[0-9]+(?:\s*[-+]\s*[0-9]+)??)\)?)?\s+hit\s+points/),r=t.match(s);i.logger.debug(`${this.name} Damage matches`,{hit:t,matches:n,regainMatch:r});let l=!1;for(const e of n){let t=!1,a=!1,i=!1,n=!1;if("DC "==e[1]||"hit points by this"==e[4])continue;"or "!=e[1]&&"two hands"!=e[5]||(l=!0),e[5]&&"at the start of"==e[5].trim()&&(t=!0);const s=e[3]?.includes(" + PB")||e[3]?.includes(" plus PB"),r=s&&!this.isCompanion?"@prof":"",d=e[3]&&/the spell[’']s level/i.test(e[3]);d&&(this.levelBonus=!0,foundry.utils.setProperty(this,"flags.ddbimporter.levelBonus",!0));const c=s||d?`${e[2]}${e[3].replace(" + PB","").replace(" plus PB","").replace(" + the spell’s level","").replace(" + the spell's level","")}`:e[3]??e[2];if(c){const s=/[0-9]*d[0-9]+/.test(c),u=[this.actionInfo&&s?this.damageModReplace(c.replace("plus","+"),e[4]):c.replace("plus","+"),r].filter((e=>""!==e)).join(" + "),m=e[1]&&e[1].includes("saving throw"),p="on a failed save"==(e[5]??"").trim();if((p&&"and"!==(e[1]??"").trim()||m)&&this.actionInfo.damageParts.length>=1&&(a=m||p,t=!0,n=!0),t){const c=o.SystemHelpers.buildDamagePart({damageString:u,type:e[4],stripMod:"weapon"===this.templateType});n||"plus"!=e[1].trim()?this.additionalActivities.push({name:a?"Save vs":"Damage",type:a?"save":"damage",options:{generateDamage:!0,damageParts:[c],includeBaseDamage:!1}}):(this.actionInfo.damage.versatile+=` + ${u}`,this.actionInfo.damageParts.push({profBonus:r,levelBonus:d,versatile:l,other:t,thisOther:n,thisVersatile:i,part:c,includesDice:s}))}else if(l){if(""==this.actionInfo.damage.versatile&&(this.actionInfo.damage.versatile=u),!i&&"plus"==e[1].trim()){this.actionInfo.damage.versatile+=` + ${u}`;const a=o.SystemHelpers.buildDamagePart({damageString:u,type:e[4],stripMod:"weapon"===this.templateType});this.actionInfo.damageParts.push({profBonus:r,levelBonus:d,versatile:l,other:t,thisOther:n,thisVersatile:i,part:a,includesDice:s})}}else{const a=o.SystemHelpers.buildDamagePart({damageString:u,type:e[4],stripMod:"weapon"===this.templateType});this.actionInfo.damageParts.push({profBonus:r,levelBonus:d,versatile:l,other:t,thisOther:n,thisVersatile:i,part:a,includesDice:s})}}}if(r){const e=r[3]?r[3]:r[2],t=o.SystemHelpers.buildDamagePart({damageString:i.utils.parseDiceString(e,null).diceString,type:"healing"});this.actionInfo.healingParts.push({versatile:l,part:t})}const d=t.match(/escape DC ([0-9]+)/);if(d&&this.additionalActivities.push({type:"check",name:"Escape Check",options:{generateCheck:!0,generateTargets:!1,generateRange:!1,checkOverride:{associated:["acr","ath"],ability:"",dc:{calculation:"",formula:d[1]}}}}),this.actionInfo.damageParts.length>0&&"weapon"===this.templateType)this.actionInfo.damage.base=this.actionInfo.damageParts[0].part;else if("weapon"!==this.templateType&&""!==this.actionInfo.damage.versatile.trim()){const e=o.SystemHelpers.buildDamagePart({damageString:this.actionInfo.damage.versatile,stripMod:"weapon"===this.templateType});this.additionalActivities.push({name:"Versatile",options:{generateDamage:!0,damageParts:[e],includeBaseDamage:!1}})}}getActionType(){let e=this.type;const t=this.strippedHtml.toLowerCase().match(/as (a|an) action/),a=this.strippedHtml.toLowerCase().match(/as a bonus action/),i=this.strippedHtml.toLowerCase().match(/as a reaction/),n=this.strippedHtml.toLowerCase().match(/dies/);return a?e="bonus":i?e="reaction":n?e="special":t&&(e="action"),"lair"===this.type?e="lair":"mythic"===this.type?e="mythic":"villain"===this.type?e="special":"legendary"===this.type&&(e="legendary"),e}#l(){return this.fullName.toLowerCase().match(/(?:\(|; )recharge ([0-9––−-]+)\)/)}#d(){const e=this.isRecharge;if(!e)return;return{period:"recharge",formula:e[1].replace(/[––−-]/,"-").split("-").shift(),type:"recoverAll"}}getUses(e=!1){let t={spent:null,max:null,recovery:[]},a={period:null,type:"recoverAll",formula:void 0};const i=e?/(\d+)\/(\w+)\)/:/\((\d+)\/(\w+)\)/,s=e?this.titleHTML?this.titleHTML:this.name:this.strippedHtml,r=s.match(i);if(r&&"turn"!==r[2].toLowerCase()){t.spent=0,t.max=r[1],a.period="day";const e=n.x.monsters.resets.find((e=>e.id===r[2]));e&&(a.period=e.value)}else{const e=/Recharges after a (Short or Long|Long) Rest/i,i=s.match(e);i&&(a.period="Long"===i[1]?"lr":"sr",t.max="1")}a.period&&t.recovery.push(a);const o=this.#d();return o&&(t.recovery.push(o),null===t.max&&(t.max="1"),t.spent=0,this.actionInfo.consumptionValue="1"),t}getActivationValue(){const e=this.strippedHtml.match(/\(costs ([0-9]+) actions\)/i);if(e)return parseInt(e[1]);const t=this.name.match(/\(costs ([0-9]+) actions\)/i);return t?parseInt(t[1]):null}getActivation(){const e=foundry.utils.deepClone(this.actionInfo.activation);return e.value=this.getActivationValue(),e.type=this.getActionType(),e}getFeatSave(){return this.actionInfo.save=this.descriptionSave,this.actionInfo.save}getReach(){const e=this.strippedHtml.match(/reach\s*(\s*\d+\s*)\s*ft/);return e?e[1].trim():null}getRange(){let e={value:null,long:null,units:"",reach:this.getReach()};const t=this.strippedHtml.match(/range\s*(\d+)\s*\/\s*(\d+)\s*ft/),a=this.strippedHtml.match(/range\s*(\d+)\s*ft[.]*\s*\/\s*(\d+)\s*ft/),i=this.strippedHtml.match(/range\s*(\d+)\s*(:?ft|feet)/),n=this.strippedHtml.match(/reach\s*(\d+)\s*(:?ft|feet)/),s=this.strippedHtml.match(/within\s*(\d+)\s*(:?ft|feet)/);return t?(e.value=parseInt(t[1]),e.long=parseInt(t[2]),e.units="ft"):a?(e.value=parseInt(a[1]),e.long=parseInt(a[2]),e.units="ft"):i?(e.value=parseInt(i[1]),e.units="ft"):n?(this.actionInfo.properties.rch=!0,e.reach=parseInt(n[1]),e.units="ft"):s&&(this.actionInfo.properties.rch=!0,e.reach=parseInt(s[1]),e.units="ft"),e}checkAbility(e){let t={success:!1,ability:null,proficient:null};for(const a of e){if(this.toHit==this.ddbMonster.proficiencyBonus+this.ddbMonster.abilities[a].mod){t.success=!0,t.ability=a,t.proficient=!0;break}if(t.toHit==this.ddbMonster.abilities[a].mod){t.success=!0,t.ability=a,t.proficient=!1;break}}return t}checkAbilities(e,t=!1){return e.map((e=>{let a={success:!1,ability:e,proficient:null,bonus:0};return this.toHit>this.ddbMonster.proficiencyBonus+this.ddbMonster.abilities[e].mod?(a.success=!0,a.proficient=!0,a.bonus=this.toHit-this.ddbMonster.proficiencyBonus-this.ddbMonster.abilities[e].mod):(a.toHit>this.ddbMonster.abilities[e].mod||t)&&(a.success=!0,a.proficient=!1,a.bonus=this.toHit-this.ddbMonster.abilities[e].mod),a}))}generateWeaponAttackInfo(){const e=["str","dex","int","wis","cha","con"];let t=[],a=["str","dex"],s=["cha","wis","int"];const r=n.x.monsters.weapons.find((e=>this.name.startsWith(e.name)));if(r){for(const[e,t]of Object.entries(r.properties))this.actionInfo.properties[e]=t;this.actionInfo.properties.ver&&this.ddbMonster.abilities.dex.mod>this.ddbMonster.abilities.str.mod||"rwak"==r.actionType?a=["dex"]:"mwak"==r.actionType&&(a=["str"]),this.actionInfo.weaponType=r.weaponType}else this.meleeAttack?this.actionInfo.weaponType="simpleM":this.rangedAttack&&(this.actionInfo.weaponType="simpleR");if(this.strippedHtml.includes("is a magic weapon attack")&&(this.actionInfo.properties.mgc=!0,foundry.utils.setProperty(this.data,"flags.midiProperties.magicdam",!0)),t=this.spellAttack?s:this.weaponAttack?a:e,this.yourSpellAttackModToHit)this.actionInfo.baseAbility=null,this.actionInfo.proficient=!0;else if(this.weaponAttack||this.spellAttack){const a=this.checkAbility(t);if(a.success&&(this.actionInfo.baseAbility=a.ability,this.actionInfo.proficient=a.proficient),!this.actionInfo.baseAbility){const t=this.checkAbility(e);t.success&&(this.actionInfo.baseAbility=t.ability,this.actionInfo.proficient=t.proficient)}if(!this.actionInfo.baseAbility){const e=this.checkAbilities(t).filter((e=>1==e.success)).sort(((e,t)=>{if(e.proficient==!t.proficient)return-1;if(t.proficient==!e.proficient)return 1;if(e.proficient==t.proficient){if(e.bonus>t.bonus)return 1;if(t.bonus>e.bonus)return-1}return 0}));e.length>=1&&e[0].success&&(this.actionInfo.baseAbility=e[0].ability,this.actionInfo.proficient=e[0].proficient,this.actionInfo.extraAttackBonus=e[0].bonus)}if(!this.actionInfo.baseAbility){i.logger.info(`Negative ability parse for ${this.ddbMonster.npc.name}, to hit ${this.toHit} with ${this.name}`);const e=this.checkAbilities(t,!0).filter((e=>1==e.success)).sort(((e,t)=>{if(e.proficient==!t.proficient)return-1;if(t.proficient==!e.proficient)return 1;if(e.proficient==t.proficient){if(e.bonus<t.bonus)return 1;if(t.bonus<e.bonus)return-1}return 0}));i.logger.debug("Filtered abilities",{filteredAbilities:e,html:this.strippedHtml}),e.length>=1&&e[0].success?(this.actionInfo.baseAbility=e[0].ability,this.actionInfo.proficient=e[0].proficient,this.actionInfo.extraAttackBonus=e[0].bonus):i.logger.error("Unable to calculate attack!",{filteredAbilities:e,html:this.strippedHtml,ddbFeature:this})}}}getTarget(){let e={template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:""},affects:{count:"",type:"",choice:!1,special:""},prompt:!0,override:!1};const t=this.strippedHtml.replace(/[­––−-]/gu,"-").replace(/-+/g,"-"),a=t.match(/(\d+)-foot cone/),i=t.match(/(\d+)-foot line|line that is (\d+) feet/),n=t.match(/(\d+)-foot cube/),s=t.match(/(\d+)-foot-radius sphere/);return a?(e.template.size=a[1],e.template.units="ft",e.template.type="cone"):i?(e.template.size=i[1]??i[2],e.template.units="ft",e.template.type="line"):n?(e.template.size=n[1],e.template.units="ft",e.template.type="cube"):s&&(e.template.size=s[1],e.template.units="ft",e.template.type="sphere"),""===e.template.type&&this.healingAction&&(e.template.type="self"),e}#c(){const e=game.settings.get(n.y.MODULE_ID,"munching-policy-hide-description-choice"),t=game.settings.get(n.y.MODULE_ID,"munching-policy-hide-item-name");let a="[[lookup @name]]";"TYPE"===e?a="[[lookup @details.type.config.label]]":"MONSTER"===e?a="Monster":"NPC"===e&&(a="NPC");let i=`<section class="secret">\n${this.html}`;if("attack"!==this.activityType||this.spellAttack)if(this.spellAttack||this.spellSave){i+=`\n</section>\nThe ${a} casts ${t?"a spell":"[[lookup @item.name]]"}.`}else if("save"===this.activityType){i+=`\n</section>\nThe ${a} uses ${t?"a feature":"[[lookup @item.name]]"} and a save is required.`}else i+=`\n</section>\nThe ${a} uses ${t?"a feature":"[[lookup @item.name]]"}.`;else{i+=`\n</section>\nThe ${a} attacks${t?"":" with its [[lookup @item.name]]"}.`}return i}async#u(){this.html=this.html.replace(/<strong> \.<\/strong>/,"").trim();let e=this.hideDescription?this.#c():`${this.html}`;e=e.replaceAll("<em><strong></strong></em>",""),e=o.DDBReferenceLinker.parseDamageRolls({text:e,document:this.data,actor:this.ddbMonster.npc}),e=o.DDBReferenceLinker.parseTags(e),this.data.system.description.value=await o.DDBTable.generateTable({parentName:this.ddbMonster.npc.name,html:e,updateExisting:this.updateExisting,notifier:this.notifier}),this.data.system.description.value=`<div class="ddb">\n${this.data.system.description.value}\n</div>`}#m(){Number.isInteger(parseInt(this.actionInfo.activation.value))?this.actionInfo.consumptionValue=this.actionInfo.activation.value:this.actionInfo.activation.value=1,"weapon"===this.templateType&&(this.data.system.damage=this.actionInfo.damage),this.data.system.proficient=this.actionInfo.proficient,"feat"!==this.templateType&&(this.weaponAttack||this.spellAttack)&&(this.data.system.equipped=!0),this.weaponAttack?"feat"!==this.templateType&&(this.data.system.type.value=this.actionInfo.weaponType):this.spellAttack&&(foundry.utils.setProperty(this.data,"flags.midiProperties.magicdam",!0),foundry.utils.setProperty(this.data,"flags.midiProperties.magiceffect",!0),this.actionInfo.properties.mgc=!0),"weapon"===this.templateType&&(this.data.system.damage=this.actionInfo.damage,this.data.system.range=this.actionInfo.range),this.data.system.uses=this.actionInfo.uses;for(const[e,t]of Object.entries(this.actionInfo.properties))t&&this.data.system.properties.push(e);return this.name.includes("/Day")&&(this.data.system.uses=this.getUses(!0)),this.data}#p(){return this.actionInfo.activation.type="lair","Lair Actions"===this.data.name.trim()?this.actionInfo.activation.value=1:"Regional Effects"===this.data.name.trim()&&(this.actionInfo.activation.type=""),this.data}#g(){if("Legendary Actions"===this.name)return this.activityType="none",void(this.actionInfo.activation.type="");if(this.actionInfo.activation.type="legendary",this.actionInfo.consumptionTargets.push({type:"attribute",target:"resources.legact.value",value:this.actionInfo.activation.value??1,scaling:{mode:"",formula:""}}),Number.isInteger(parseInt(this.actionInfo.activation.value))?this.actionInfo.consumptionValue=this.actionInfo.activation.value:this.actionInfo.activation.value=1,this.actionCopy)for(const e of Object.keys(this.data.system.activities))this.data.system.activities[e].activation=this.actionInfo.activation,this.data.system.activities[e].consumption.targets=this.actionInfo.consumptionTargets;else this.data.system.uses=this.actionInfo.uses,"weapon"===this.templateType&&(this.data.system.damage=this.actionInfo.damage,this.data.system.range=this.actionInfo.range)}#h(){Number.isInteger(parseInt(this.actionInfo.activation.value))?this.actionInfo.consumptionValue=this.actionInfo.activation.value:this.actionInfo.activation.value=1,this.data.system.uses=this.actionInfo.uses,"weapon"===this.templateType&&(this.data.system.damage=this.actionInfo.damage,this.data.system.range=this.actionInfo.range);this.name.match(/Legendary Resistance \((\d+)\/Day/i)&&(this.actionInfo.activation.type="special",this.actionInfo.activation.value=null,this.actionInfo.consumptionTargets.push({type:"attribute",target:"resources.legres.value",value:1,scaling:{mode:"",formula:""}}),this.data.system.uses={max:null,value:null})}#f(){"Villain Actions"!==this.name&&(this.data.system.uses={spent:0,max:this.actionInfo.uses.max,recovery:[{period:"sr",type:"recoverAll",formula:void 0}]}),"weapon"===this.templateType&&(this.data.system.damage=this.actionInfo.damage,this.data.system.range=this.actionInfo.range)}#y(){(this.weaponAttack||this.spellAttack)&&this.generateWeaponAttackInfo(),this.generateDamageInfo(),this.actionInfo.range=this.getRange(),this.actionInfo.activation=this.getActivation(),this.actionInfo.save=this.getFeatSave(),this.actionInfo.target=this.getTarget(),this.actionInfo.uses=this.getUses()}_getSaveActivity({name:e=null,nameIdPostfix:t=null}={},a={}){const i=foundry.utils.mergeObject({generateRange:"weapon"!==this.templateType,includeBaseDamage:"weapon"===this.templateType},a);return super._getSaveActivity({name:e,nameIdPostfix:t},i)}_getAttackActivity({name:e=null,nameIdPostfix:t=null}={},a={}){const i="weapon"===this.templateType&&this.actionInfo.damageParts.length>0&&!this.actionInfo.damageParts[0].includesDice,n=this.actionInfo.damageParts.length>1?this.isSave?[]:this.actionInfo.damageParts.slice(1).map((e=>e.part)):i?this.actionInfo.damageParts.map((e=>e.part)):[],s=foundry.utils.mergeObject({generateAttack:!0,generateRange:"weapon"!==this.templateType,generateDamage:!this.isSave,includeBaseDamage:"weapon"===this.templateType&&!i,damageParts:n},a);return super._getAttackActivity({name:e,nameIdPostfix:t},s)}_getUtilityActivity({name:e=null,nameIdPostfix:t=null}={},a={}){const i=foundry.utils.mergeObject({generateRange:"weapon"!==this.templateType,includeBaseDamage:"weapon"===this.templateType},a);return super._getUtilityActivity({name:e,nameIdPostfix:t},i)}_getDamageActivity({name:e=null,nameIdPostfix:t=null}={},a={}){const i=foundry.utils.mergeObject({generateRange:"weapon"!==this.templateType,includeBaseDamage:"weapon"===this.templateType},a);return super._getDamageActivity({name:e,nameIdPostfix:t},i)}#b(e=!1){this.additionalActivities.push({name:"Save",type:"save",options:{generateDamage:this.actionInfo.damageParts.length>1,damageParts:"weapon"!==this.templateType||e?this.actionInfo.damageParts.map((e=>e.part)):this.actionInfo.damageParts.slice(1).map((e=>e.part)),includeBaseDamage:!1}})}#D(){for(const e of this.actionInfo.healingParts)this.additionalActivities.push({type:"heal",options:{generateDamage:!1,includeBaseDamage:!1,generateHealing:!0,healingPart:e.part}})}_getActivitiesType(){return"Legendary Actions"===this.name?null:!this.healingAction||this.isAttack||this.isSave||0!==this.actionInfo.damageParts.length?this.isAttack?(this.isSave&&this.actionInfo.damageParts.length>0&&this.#b(!1),"attack"):this.isSave?"save":this.actionInfo.damageParts.length>0?"damage":!this.healingAction&&this.actionInfo.healingParts.length>0?null:("special"!==this.actionInfo.activation.type||this.actionInfo.uses.max)&&this.actionInfo.activation.type&&!this.healingAction?"utility":null:null}async _generateEffects(){const e={ddbimporter:{}};this.isAttack&&this.isSave&&(e.ddbimporter.activityMatch="Save");const t=new r.Effects.MidiOverTimeEffect({document:this.data,actor:this.ddbMonster.npc,otherDescription:this.strippedHtml,flags:e});r.Effects.AutoEffects.effectModules().hasCore&&this.ddbMonster.addMonsterEffects?this.ddbMonster.addMonsterEffects&&(i.logger.debug(`Adding Over Time Effects to ${this.name}`),t.generateOverTimeEffect()):(i.logger.debug(`Adding Condition Effects to ${this.name}`),t.generateConditionOnlyEffect()),this.enricher.clearAutoEffects&&(this.data.effects=[]);const a=await this.enricher.createEffects();this.data.effects.push(...a),this.enricher.createDefaultEffects(),this._activityEffectLinking(),r.Effects.AutoEffects.forceDocumentEffect(this.data)}async parse(){switch(await this.enricher.init(),this.#y(),this.type){case"action":case"mythic":case"reaction":case"bonus":this.#m();break;case"lair":this.#p();break;case"legendary":this.#g();break;case"villain":this.#f();break;case"special":this.#h();break;default:throw i.logger.error(`Unknown action parsing type ${this.type}`,{DDBFeature:this}),new Error(`Unknown action parsing type ${this.type}`)}this.actionCopy||(this._generateActivity(),this.#D(),this.enricher.addAutoAdditionalActivities&&this._generateAdditionalActivities(),await this.enricher.addAdditionalActivities(this),this._generateEffects()),foundry.utils.setProperty(this.data,"flags.monsterMunch.actionInfo.damage",this.actionInfo.damage),foundry.utils.setProperty(this.data,"flags.monsterMunch.actionInfo.damageParts",this.actionInfo.damageParts),foundry.utils.setProperty(this.data,"flags.monsterMunch.actionInfo.baseAbility",this.actionInfo.baseAbility),foundry.utils.setProperty(this.data,"flags.monsterMunch.actionInfo.toHit",this.toHit),foundry.utils.setProperty(this.data,"flags.monsterMunch.actionInfo.proficient",this.actionInfo.proficient),foundry.utils.setProperty(this.data,"flags.monsterMunch.actionInfo.extraAttackBonus",this.actionInfo.extraAttackBonus),await this.#u(),this.enricher.addDocumentOverride(),this.data.system.identifier=i.utils.referenceNameString(this.data.name.toLowerCase()),i.logger.debug(`Parsed Feature ${this.name} for ${this.ddbMonster.name}`,{feature:this})}}},899:(e,t,a)=>{a.d(t,{A:()=>DDBMonsterFeatureFactory});var i=a(421),n=a(37);class DDBMonsterFeatureFactory{static replaceRollable(e){const t=new RegExp(/(\[rollable\])([^;]*);(.*)(\[\/rollable\])/g);return e.replaceAll(t,"$2")}constructor({ddbMonster:e,hideDescription:t,updateExisting:a}={}){this.ddbMonster=e,this.hideDescription=t,this.updateExisting=a,this.featureBlocks={action:[],reaction:[],bonus:[],mythic:[],lair:[],legendary:[],special:[],villain:[]},this.features={action:[],reaction:[],bonus:[],mythic:[],lair:[],legendary:[],special:[],villain:[]},this.characterDescription={action:"",reaction:"",bonus:"",mythic:"",lair:"",legendary:"",special:"",villain:"",unexpected:null},this.html={action:"",reaction:"",bonus:"",mythic:"",lair:"",legendary:"",special:"",villain:""},this.resources={legendary:{value:3,max:3},lair:{value:!1,initiative:null},resistance:{value:0,max:0}},this.resistance={},this.gear=[]}getFeatures(e){return this.features[e].map((e=>foundry.utils.deepClone(e.data)))}get actions(){return this.getFeatures("action")}get reactions(){return this.getFeatures("reaction")}get bonus(){return this.getFeatures("bonus")}get mythic(){return this.getFeatures("mythic")}get lair(){return this.getFeatures("lair")}get legendary(){return this.getFeatures("legendary")}get special(){return this.getFeatures("special")}get villain(){return this.getFeatures("villain")}#v(e){const t=i.utils.htmlToDocumentFragment(this.html[e]);return t.childNodes.forEach((e=>{"\n"!=e.textContent&&"\r\n"!=e.textContent||t.removeChild(e)})),t}static EM_STRONG_EXCEPTIONS=["Yeenoghu"];#C(e){let t=this.html[e].split("<h3>Roleplaying Information</h3>");t.length>1&&(this.characterDescription[e]=`<h3>Roleplaying Information</h3>${t[1]}`);const a=t[0].split("<h3>Villain Actions</h3>");a.length>1&&(this.html.villain=a[1]),this.html[e]=a[0];let n=this.#v(e);n.querySelectorAll("p").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML),n=a.querySelector("em strong")??a.querySelector("strong em");if(!n)return;let s=n.textContent.trim().replace(/\./g,"");s=DDBMonsterFeatureFactory.splitName(s,t.textContent);const r={name:s,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:n.outerHTML,fullName:n.textContent}};this.featureBlocks[e].push(r)})),0==this.featureBlocks[e].length&&n.querySelectorAll("p").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML).querySelector("strong");if(!a)return;let n=a.textContent.trim().replace(/\./g,"");n=DDBMonsterFeatureFactory.splitName(n,t.textContent);const s={name:n,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:a.outerHTML,fullName:a.textContent}};this.featureBlocks[e].push(s)})),0==this.featureBlocks[e].length&&n.querySelectorAll("p").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML).querySelector("b");if(!a)return;let n=a.textContent.trim().replace(/\./g,"");n=DDBMonsterFeatureFactory.splitName(n,t.textContent);const s={name:n,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:a.outerHTML,fullName:a.textContent}};this.featureBlocks[e].push(s)})),0==this.featureBlocks[e].length&&n.querySelectorAll("p").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML),n=a.textContent.split(".")[0].trim();if(n&&n.length>0){const t=a.outerHTML?a.outerHTML.split(".")[0]:void 0,i={name:n,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:t}};this.featureBlocks[e].push(i)}})),0==this.featureBlocks[e].length&&n.querySelectorAll("div").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML),n=a.textContent.split(".")[0].trim();if(n&&n.length>0){const t=a.outerHTML?a.outerHTML.split(".")[0]:void 0,i={name:n,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:t}};this.featureBlocks[e].push(i)}}));let s=this.featureBlocks[e][0];n.childNodes.forEach((t=>{const a=t.textContent.split("."),n=a[0].trim(),r=a.length>2&&a[1].trim().startsWith("(")?`${n} ${a[1].trim()}`:n;let o=this.featureBlocks[e].find((e=>n===e.name||r===e.name));o||(o=this.featureBlocks[e].find((e=>e.options?.fullName&&t.textContent.startsWith(e.options.fullName))));let l=!1;if(o&&(s=o,""===s.options.html&&(l=!0)),s&&t.outerHTML){let e=`${t.outerHTML}`;if(o&&l){const t=foundry.utils.getProperty(s,"fullName")??n;e=e.replace(t,"");const a=i.utils.htmlToDocumentFragment(e);a.textContent.startsWith(".")&&(e=e.replace(".","")),a.textContent.startsWith(" .")&&(e=e.replace(" .",""))}s.options.html+=e}}))}#w(e="lair"){let t=this.#v(e);const a={name:"Lair Actions",options:{html:"",ddbMonster:this.ddbMonster,type:e}};this.featureBlocks[e].push(a),t.querySelectorAll("h4").forEach((t=>{const a=t.textContent.trim();if(""!==a){const i={name:a,options:{html:"",ddbMonster:this.ddbMonster,type:e}};if("Lair Actions"==t.textContent||""==t.textContent)return;this.featureBlocks[e].push(i)}})),t.querySelectorAll("h3").forEach((t=>{const a=t.textContent.trim();if(""!==a){const i={name:a,options:{html:"",ddbMonster:this.ddbMonster,type:e}};if("Lair Actions"==t.textContent||""==i.name)return;this.featureBlocks[e].push(i)}}));let i="Lair Actions",n=this.featureBlocks[e].find((e=>e.name==i));n||(n=this.featureBlocks[e][0]),t.childNodes.forEach((t=>{const a=t.textContent.split(".")[0].trim(),s=this.featureBlocks[e].find((e=>a===e.name));let r=!1;if(s&&(i=t.textContent,n=s,""===n.options.html&&(r=!0)),t.outerHTML){let e=t.outerHTML;s&&r&&(e=e.replace(`${a}.`,"")),n.options.html+=e}const o=t.textContent.match(/initiative count (\d+)/);o&&(this.resources.lair={value:!0,initiative:parseInt(o[1])})}))}#S(e){let t=this.#v(e);const a={name:"Legendary Actions",options:{html:"",ddbMonster:this.ddbMonster,type:e,actionCopy:!1}};a.options.html=`${this.html[e]}`,this.featureBlocks[e].push(a),t.querySelectorAll("strong").forEach(((t,a)=>{const i=t.textContent.trim().replace(/\.$/,"").trim(),s={name:i,options:{html:"",ddbMonster:this.ddbMonster,type:e,actionCopy:!1,sort:a+1}},r=this.features.action.concat(this.features.reaction,this.features.reaction,this.features.bonus).find((e=>i==e.name||i==`${e.name} Attack`||i==`${e.name}`.split("(",1)[0].trim()||i==`${e.name} Attack`.split("(",1)[0].trim()));if(r){const t=new n.A(i,{ddbMonster:this.ddbMonster,html:r.html,type:e,actionCopy:!0});t.data=foundry.utils.duplicate(r.data),t.data._id=foundry.utils.randomID(),t.data.name=s.name,Object.keys(t.data.system.activities).forEach((e=>{t.data.system.activities[e].activation.type="legendary"})),t.data.sort=a+1,this.features[e].push(t),s.options.actionCopy=!0,s.options.sort=a+1}this.featureBlocks[e].push(s)}));let i=this.featureBlocks[e].find((e=>"Legendary Actions"==e.name));t.childNodes.forEach((t=>{let a=!1;const n=t.textContent.match(/can take (d+) legendary actions/);n&&(this.resources.legendary.value=parseInt(n[1]),this.resources.legendary.max=parseInt(n[1]));const s=t.textContent.split(".")[0].trim(),r=this.featureBlocks[e].find((e=>s===e.name));if("Legendary Actions"!==i.name||r){if(r&&(i=r,""===i.options.html&&(a=!0)),i.options.actionCopy)return;if(t.outerHTML){let e=t.outerHTML;r&&a&&(e=e.replace(`${s}.`,"")),i.options.html+=e}}}))}#I(e="villain"){let t=this.#v(e);const a={name:"Villain Actions",options:{html:"",ddbMonster:this.ddbMonster,type:e,actionCopy:!1}};a.options.html=`${this.html[e]}`,this.featureBlocks[e].push(a),t.querySelectorAll("strong").forEach((t=>{const a={name:t.textContent.trim().replace(/\.$/,"").trim(),options:{html:"",ddbMonster:this.ddbMonster,type:e,actionCopy:!1}};this.featureBlocks[e].push(a)}));let i=this.featureBlocks[e].find((e=>"Villain Actions"==e.name));t.childNodes.forEach((t=>{let a=!1;const n=t.textContent.match(/^Action (.)+?[.!?]/),s=n?n[0].split(".")[0].trim():t.textContent.split(".")[0].trim(),r=this.featureBlocks[e].find((e=>s===e.name));if(("Villain Actions"!==i.name||r)&&(r&&(i=r,""===i.options.html&&(a=!0)),t.outerHTML)){let e=t.outerHTML;r&&a&&(e=e.replace(`${s}.`,"").replace(`${s}`,"")),i.options.html+=e}}))}static splitName(e,t){if(e.includes("Spell;")||e.includes("Psionics;")||e.includes("Mythic Trait;"))return e.includes("Spell;")?t.trim().split(".")[0]:e.trim();{const t=e.split(";");return t.length>1&&t[0].includes("(")&&!t[0].includes(")")?e.trim():t.length>1?t.pop().trim():e.trim()}}#T(e){const t=i.utils.stripHtml(e).replace("Gear.","").split(",").map((e=>e.trim()));this.gear.push(...t)}#A(e){let t=this.html[e].split("<h3>Roleplaying Information</h3>");t.length>1&&(this.characterDescription[e]=`<h3>Roleplaying Information</h3>${t[1]}`),this.html[e]=t[0];let a=this.#v(e);if(a.querySelectorAll("p").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML).querySelector("em");if(!a)return;let n=a.textContent.trim().replace(/\./g,"");if(n=DDBMonsterFeatureFactory.splitName(n,t.textContent),n){const t={name:n,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:a.outerHTML,fullName:a.textContent}};this.featureBlocks[e].push(t)}})),0==this.featureBlocks[e].length&&a.querySelectorAll("p").forEach((t=>{const a=i.utils.htmlToDocumentFragment(t.outerHTML).querySelector("strong");if(!a)return;let n=a.textContent.trim().replace(/\./g,"");if(n=DDBMonsterFeatureFactory.splitName(n,t.textContent),n){const t={name:n,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:a.outerHTML,fullName:a.textContent}};this.featureBlocks[e].push(t)}})),0==this.featureBlocks[e].length&&a.querySelectorAll("em").forEach((t=>{const a=t.textContent.trim().replace(/\.$/,"").trim();if(a){const i={name:a,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:t.outerHTML,fullName:t.textContent}};this.featureBlocks[e].push(i)}})),0==this.featureBlocks[e].length&&a.querySelectorAll("strong").forEach((t=>{const a=t.textContent.trim().replace(/\.$/,"").trim();if(a){const i={name:a,options:{html:"",ddbMonster:this.ddbMonster,type:e,titleHTML:t.outerHTML,fullName:t.textContent}};this.featureBlocks[e].push(i)}})),0==this.featureBlocks[e].length){const t={name:"Special Traits",options:{html:"",ddbMonster:this.ddbMonster,type:e}};this.featureBlocks[e].push(t)}if(0===this.featureBlocks[e].length)return;let n=this.featureBlocks[e][0];a.childNodes.forEach((t=>{const a=t.textContent.split(".")[0].trim();let s=this.featureBlocks[e].find((e=>a===e.name));n.name.includes("; Recharges after a Short or Long Rest")&&(n.name=n.name.replace("; Recharges after a Short or Long Rest","")),n.name.includes("; Recharges after a Long Rest")&&(n.name=n.name.replace("; Recharges after a Long Rest","")),s||(s=this.featureBlocks[e].find((e=>t.textContent.startsWith(e.options.fullName))));let r=!1;if(s&&(n=s,""===n.options.html&&(r=!0)),t.outerHTML){let e=t.outerHTML;s&&r&&(e=n.options.fullName?e.replace(n.fullName,""):e.replace(a,""));const o=i.utils.htmlToDocumentFragment(e);o.textContent.startsWith(". ")&&(e=e.replace(". ","")),o.textContent.startsWith(" .")&&(e=e.replace(" .","")),n.options.html+=e}const o=t.textContent.match(/Legendary Resistance \((\d+)\/Day/i);o&&(this.resources.resistance.value=parseInt(o[1]),this.resources.resistance.max=parseInt(o[1]))}));const s=this.featureBlocks[e].findIndex((e=>"Gear"===e.name));if(-1!==s){const t=this.featureBlocks[e].splice(s,1);this.#T(t[0].options.html)}}async generateActions(e,t="action"){if(e&&""!=e.trim()){switch(this.html[t]=DDBMonsterFeatureFactory.replaceRollable(i.utils.replaceHtmlSpaces(`${e}`)).replace(/<\/strong> <strong>/g,"").replace(/<\/strong><strong>/g,"").replace(/<strong> \.<\/strong>/g,".").replace(/<strong>\.<\/strong>/g,".").replace(/<em> \.<\/em>/g,".").replace(/<em>\.<\/em>/g,".").replace(/&shy;/g,""),t){case"action":case"bonus":case"mythic":case"reaction":this.#C(t);break;case"lair":this.#w(t);break;case"legendary":this.#S(t);break;case"special":this.#A(t);break;case"villain":this.#I(t);break;default:throw i.logger.error(`Unknown action parsing type ${this.type}`,{DDBFeatureFactory:this}),new Error(`Unknown action parsing type ${this.type}`)}for(const e of this.features[t])await e.loadEnricher(),await e.parse();for(const e of this.featureBlocks[t].filter((e=>!e.options.actionCopy))){i.logger.debug(`Generating Feature ${e.name} for ${this.ddbMonster.name}`,{feature:e}),e.options.hideDescription=this.hideDescription,e.options.updateExisting=this.updateExisting;const a=new n.A(e.name,e.options);await a.loadEnricher(),await a.parse(),this.features[t].push(a)}}}}},702:(e,t,a)=>{a.d(t,{a:()=>getAbilityMods});var i=a(115);function getAbilityMods(e){let t={};return i.x.actor.abilities.forEach((a=>{const i=e.stats.find((e=>e.statId===a.id)).value||0,n=CONFIG.DDB.statModifiers.find((e=>e.value==i)).modifier;t[a.value]=n})),t}},449:(e,t,a)=>{a.d(t,{I:()=>newNPC});var i=a(421);function newNPC(e,t=null){let a=new Actor.implementation({name:e,type:"npc"},{temporary:!0,displaySheet:!1}).toObject();a._id=null===t?foundry.utils.randomID():i.utils.namedIDStub(a.name,{postfix:t});const n={dnd5e:{},monsterMunch:{},ddbimporter:{compendiumId:a._id,dndbeyond:{}}};return foundry.utils.setProperty(a,"flags",n),a}},38:(e,t,a)=>{a.d(t,{A:()=>DDBRace});var i=a(115),n=a(421),s=a(410),r=a(382);class DDBRace{static SPECIAL_ADVANCEMENTS={};static EXCLUDED_FEATURE_ADVANCEMENTS=[];static EXCLUDED_FEATURE_ADVANCEMENTS_2014=[];static FORCE_SUBRACE_2024=["Elf","Gnome","Tiefling"];static getGroupName(e,t){const a=CONFIG.DDB.raceGroups.find((t=>e.includes(t.id)));if(a)return a.name;const i=t.toLowerCase().trim();return i.includes("elf")&&!i.includes("half")||["eladrin"].includes(i)?"Elf":["githzerai","githyanki"].includes(i)?"Gith":i.includes("genasi")?"Genasi":i.includes("gnome")?"Gnome":i.includes("human")?"Human":i.includes("yuan-ti")?"Yuan-ti":t}_generateDataStub(){this.data={_id:foundry.utils.randomID(),name:"",type:"race",system:r.SystemHelpers.getTemplate("race"),flags:{ddbimporter:{type:"race"}},img:null}}#k(){"Harengon"===this.race.baseName&&(this.race.sizeId=10)}get lineageName(){return this.lineageTrait?this.lineageTrait.label.replace(" Lineage","").replace(" Legacy","").trim():null}#E(){if(this.is2014)return null;if(DDBRace.FORCE_SUBRACE_2024.includes(this.race.baseRaceName)){const e=this.race.racialTraits.find((e=>e.definition.name.includes("Lineage")||e.definition.name.includes("Fiendish Legacy")));if(!e)return null;const t=r.DDBDataUtils.getChoices({ddb:this.ddbData,type:"race",feat:e,selectionOnly:!0});return this.isLineage=!0,t[0]}return null}#_(){const e=this.race.fullName??this.race.name,t=this.lineageName;return t||e}constructor(e,t,a,r=!1){this.ddbData=e,this.race=t,this.is2014=this.race.isLegacy&&this.race.sources.some((e=>Number.isInteger(e.sourceId)&&e.sourceId<145)),this.#k(),this.compendiumRacialTraits=a,this._generateDataStub(),this.type="humanoid",this._compendiumLabel=n.CompendiumHelper.getCompendiumLabel("traits"),this.isLineage=!1,this.lineageTrait=this.#E(),this.fullName=this.#_(),this.data.name=n.utils.nameString(this.fullName),this.data.system.description.value+=`${this.race.description}\n\n`,this.isLegacy=this.race.isLegacy,this.baseRaceName=this.race.baseRaceName,this.groupName=DDBRace.getGroupName(this.race.groupIds,this.baseRaceName),this.isSubRace=this.race.isSubRace||this.groupName!==this.fullName;const o=this.race.sources.map((e=>e.sourceId));this.legacy=CONFIG.DDB.sources.some((e=>o.includes(e.id)&&i.x.sourceCategories.legacy.includes(e.sourceCategoryId))),this.data.flags.ddbimporter={type:"race",entityRaceId:this.race.entityRaceId,version:CONFIG.DDBI.version,sourceId:this.race.sources.length>0?[0].sourceId:-1,baseName:this.race.baseName,baseRaceId:this.race.baseRaceId,baseRaceName:this.race.baseRaceName,fullName:this.fullName,fullRaceName:this.fullName,subRaceShortName:this.race.subRaceShortName,isHomebrew:this.race.isHomebrew,isLegacy:this.race.isLegacy,legacy:this.legacy,is2014:this.is2014,is2024:!this.is2014,isSubRace:this.isSubRace,moreDetailsUrl:this.race.moreDetailsUrl,featIds:this.race.featIds,groupIds:this.race.groupIds,groupName:this.groupName,isLineage:this.isLineage,lineageName:this.lineageName},this.race.moreDetailsUrl&&(this.data.flags.ddbimporter.moreDetailsUrl=this.race.moreDetailsUrl),this.data.system.source=n.DDBSources.parseSource(this.race),this.race.isSubRace&&this.race.baseRaceName&&(this.data.system.requirements=this.race.baseRaceName);game.settings.get("ddb-importer","munching-policy-legacy-postfix")&&this.race.isLegacy&&(this.data.name+=" (Legacy)"),this.#M(),this.#B(),this.abilityAdvancement=new game.dnd5e.documents.advancement.AbilityScoreImprovementAdvancement,this.noMods=r||null===e,this.advancementHelper=new s.A({ddbData:this.ddbData,type:"race",noMods:this.noMods}),this.featLink={advancementId:null,name:null,uuid:null},this._compendiums={traits:n.CompendiumHelper.getCompendiumType("traits",!1)},this._indexFilter={traits:{fields:["name","flags.ddbimporter.fullRaceName","flags.ddbimporter.groupName","flags.ddbimporter.isLineage","flags.ddbimporter.featureMeta","flags.ddbimporter.baseName","flags.ddbimporter.entityRaceId"]}},this._advancementMatches={traits:{}}}async _buildCompendiumIndex(e,t={}){Object.keys(t).length>0&&(this._indexFilter[e]=t),this._compendiums[e]&&await this._compendiums[e].getIndex(this._indexFilter[e])}async _generateRaceImage(){let e,t,a;const s=game.settings.get(i.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),r=game.settings.get(i.y.MODULE_ID,"use-deep-file-paths");if(this.race.portraitAvatarUrl){const e=r?"":"race-portrait",t=r?"/race/portrait":"",i={type:"race-portrait",name:this.race.fullName,targetDirectory:s,imageNamePrefix:e,pathPostfix:t};a=await n.FileHelper.getImagePath(this.race.portraitAvatarUrl,i),this.data.img=a,this.data.flags.ddbimporter.portraitAvatarUrl=this.race.portraitAvatarUrl}if(this.race.avatarUrl){const t=r?"":"race-avatar",a=r?"/race/avatar":"",i={type:"race-avatar",name:this.race.fullName,targetDirectory:s,imageNamePrefix:t,pathPostfix:a};e=await n.FileHelper.getImagePath(this.race.avatarUrl,i),this.data.flags.ddbimporter.avatarUrl=this.race.avatarUrl,this.data.img||(this.data.img=e)}if(this.race.largeAvatarUrl){const e=r?"":"race-large",a=r?"/race/large":"",i={type:"race-large",name:this.race.fullName,targetDirectory:s,imageNamePrefix:e,pathPostfix:a};t=await n.FileHelper.getImagePath(this.race.largeAvatarUrl,i),this.data.flags.ddbimporter.largeAvatarUrl=this.race.largeAvatarUrl,this.data.img||(this.data.img=t)}const o=e?`<img src="${e}">\n\n`:t?`<img src="${t}">\n\n`:"";return this.data.system.description.value+=o,o}#P(e){if("Creature Type"!==e.name.trim())return;const t=e.description.match(/You are a (\S*)\./i);t&&(n.logger.debug(`Explicit type detected: ${t[1]}`,t),this.type=t[1].toLowerCase())}#O(e){if(!this.is2014&&e.name.startsWith("Ability Score "))return;const t=this.compendiumRacialTraits?.find((t=>{const a=foundry.utils.getProperty(t,"flags.ddbimporter.baseName");if(!a)return!1;const i=foundry.utils.getProperty(t,"flags.ddbimporter.entityRaceId");return!!i&&(n.utils.nameString(e.name)===n.utils.nameString(a)&&i===e.entityRaceId)})),a=t?`<p><b>@Compendium[${this._compendiumLabel}.${t._id}]{${e.name}}</b></p>`:`<p><b>${e.name}</b></p>`;this.data.system.description.value+=`${a}\n${e.description}\n\n`}#M(){this.race.weightSpeeds?.normal&&(this.data.system.movement={burrow:this.race.weightSpeeds.normal.burrow??0,climb:this.race.weightSpeeds.normal.climb??0,fly:this.race.weightSpeeds.normal.fly??0,swim:this.race.weightSpeeds.normal.swim??0,walk:this.race.weightSpeeds.normal.walk??0,units:"ft",hover:!1})}#B(){const e=new game.dnd5e.documents.advancement.SizeAdvancement,t=CONFIG.DDB.creatureSizes.find((e=>e.id===this.race.sizeId));if(10===t.id)e.updateSource({configuration:{sizes:["med","sm"]}});else if(4!==t){const t=i.x.actor.actorSizes.find((e=>e.id===this.race.sizeId));e.updateSource({configuration:{sizes:[t.value]}})}this.data.system.advancement.push(e.toObject())}#F(e){if("Flight"===e.name.trim()&&0===foundry.utils.getProperty(this.race,"weightSpeeds.normal.fly")){const t=/you have a flying speed equal to your walking speed/i,a=e.description.match(t);a&&(n.logger.debug(`Missing flight detected: ${a[1]}`,a),this.data.system.movement.fly=this.data.system.movement.walk)}}#x(e){if(!["Ability Score Increase","Ability Score Increases"].includes(e.name.trim()))return;if(/Your ability scores each increase by 1|or increase three different scores by 1/i.test(e.description))this.abilityAdvancement.configuration.points=3,this.abilityAdvancement.updateSource({configuration:{points:3}});else{const t=this.abilityAdvancement.configuration.toObject(),a=/Your (\w+) score increases by (\d)/i,n=e.description.match(a);if(n){const e=i.x.actor.abilities.find((e=>e.long===n[1].toLowerCase()));e&&(t.fixed[e.value]=parseInt(n[2]))}const s=/and your (\w+) score increases by (\d)/i,r=e.description.match(s);if(r){const e=i.x.actor.abilities.find((e=>e.long===r[1].toLowerCase()));e&&(t.fixed[e.value]=parseInt(r[2]))}const o=/(\w+) other ability score of your choice increases by (\d)/i,l=e.description.match(o);if(l){const e=i.x.numbers.find((e=>e.natural===l[1].toLowerCase())),a=parseInt(l[2]);e&&Number.isInteger(a)&&(t.points=(t.points??0)+a*e.num,t.cap=Math.max(a,t.cap??0))}this.abilityAdvancement.updateSource({configuration:t})}}#L(){this.is2014&&(this.race.racialTraits.forEach((e=>{const t=e.definition;["Ability Score Increase","Ability Score Increases"].includes(t.name.trim())&&this.#x(t)})),this.data.system.advancement.push(this.abilityAdvancement.toObject()))}#R(e){const t=(this.advancementHelper.noMods?[]:r.DDBModifiers.getModifiers(this.ddbData,"race").filter((t=>t.componentId===e.id&&t.componentTypeId===e.entityTypeId))).filter((e=>"proficiency"===e.type&&i.x.actor.skills.map((e=>e.subType)).includes(e.subType))),a=this.advancementHelper.getSkillAdvancement(t,e,void 0,0);a&&this.data.system.advancement.push(a.toObject())}#N(e){const t=this.advancementHelper.noMods?[]:r.DDBModifiers.getModifiers(this.ddbData,"race").filter((t=>t.componentId===e.id&&t.componentTypeId===e.entityTypeId)),a=this.advancementHelper.getLanguageAdvancement(t,e,0);a&&this.data.system.advancement.push(a.toObject())}#$(e){const t=this.advancementHelper.noMods?[]:r.DDBModifiers.getModifiers(this.ddbData,"race").filter((t=>t.componentId===e.id&&t.componentTypeId===e.entityTypeId)),a=this.advancementHelper.getToolAdvancement(t,e,0);a&&this.data.system.advancement.push(a.toObject())}async#U(e){if(!["Feats","Feat"].includes(e.name.trim()))return;const t=new game.dnd5e.documents.advancement.ItemChoiceAdvancement,a=n.CompendiumHelper.getCompendiumType("feats",!1),i=a?await a.getIndex():[];t.updateSource({title:"Feat",configuration:{allowDrops:!0,pool:i.map((e=>e.uuid)),choices:{0:1},restriction:{type:"feat"}}}),this.data.system.advancement.push(t.toObject());const s=this.ddbData?.character?.feats?.find((t=>t.componentId===e.id&&t.componentTypeId===e.entityTypeId));if(!s)return void n.logger.warn("Unable to link advancement to feat",{advancement:t,trait:e,this:this});const r=i.find((e=>e.name===s.definition.name));r?(this.featLink.advancementId=t._id,this.featLink.name=s.definition.name,this.featLink.uuid=r.uuid):n.logger.warn(`Unable to link advancement to feat ${s.definition.name}, this is probably because the feats have not been munched to the compendium`,{feat:s})}#H(e){const t=this.advancementHelper.noMods?[]:r.DDBModifiers.getModifiers(this.ddbData,"race").filter((t=>t.componentId===e.id&&t.componentTypeId===e.entityTypeId)),a=this.advancementHelper.getConditionAdvancement(t,e,0);a&&this.data.system.advancement.push(a.toObject())}#G(e){return this._compendiums.traits?(n.logger.debug(`Getting trait match for ${e.name}`),this._compendiums.traits.index.find((t=>{const a=foundry.utils.getProperty(t,"flags.ddbimporter.featureMeta")??foundry.utils.getProperty(t,"flags.ddbimporter");if(!a)return!1;const i=foundry.utils.getProperty(a,"originalName")?.trim().toLowerCase(),s=i&&i==e.name.trim().toLowerCase();if(!(!s&&t.name.trim().toLowerCase()==e.name.trim().toLowerCase())&&!s)return n.logger.verbose(`Unable to find ${e.name} in compendium`,{trait:e,matchFlags:a,match:t}),!1;return a.fullRaceName==this.race.fullName||a.groupName==this.groupName&&a.isLineage==this.isLineage}))):[]}traitAdvancements=[];async#W(e){const t=this.#G(e);if(!t)return;if(!(!DDBRace.EXCLUDED_FEATURE_ADVANCEMENTS.includes(e.name)||this.is2014&&DDBRace.EXCLUDED_FEATURE_ADVANCEMENTS_2014.includes(e.name)))return;const a=e.requiredLevel??0,i=this.traitAdvancements.findIndex((e=>e.level===a));if(-1==i){const e=new game.dnd5e.documents.advancement.ItemGrantAdvancement;this._advancementMatches.traits[e._id]={},this._advancementMatches.traits[e._id][t.name]=t.uuid;const i={configuration:{items:[{uuid:t.uuid}]},value:{},level:a,title:"Traits",icon:"",classRestriction:""};e.updateSource(i);const n=e.toObject();this.traitAdvancements.push(n),this.data.system.advancement.push(n)}else this.traitAdvancements[i].configuration.items.push({uuid:t.uuid,optional:!1}),this._advancementMatches.traits[this.traitAdvancements[i]._id][t.name]=t.uuid}linkFeatures(e){n.logger.debug("Linking Advancements to Feats for Race",{DDBRace:this,ddbCharacter:e}),e.data.race.system.advancement.forEach(((t,a,i)=>{if("ItemChoice"===t.type){const s={};for(const r of["actions","features"]){for(const a of e.data[r]){"feat"===a.type&&"feat"===a.system.type.value&&"feat"===a.flags.ddbimporter.type&&a.name.startsWith(this.featLink.name)&&(n.logger.debug(`Advancement Race ${t._id} found Feature ${a.name} (${this.featLink.uuid})`),s[a._id]=this.featLink.uuid,foundry.utils.setProperty(a,"flags.dnd5e.sourceId",this.featLink.uuid),foundry.utils.setProperty(a,"flags.dnd5e.advancementOrigin",`${this.data._id}.${t._id}`))}if(Object.keys(s).length>0){const e={0:s};t.value={added:e},i[a]=t}}}})),n.logger.debug("Processed race advancements",e.data.race.system.advancement)}#j(){const e=s.A.stripDescription(this.data.system.description.value).match(/you can see in dim light within (\d+) feet of you as if it were bright light/im);e&&(this.data.system.senses.darkvision=parseInt(e[1]))}#q(){if(this.noMods)this.#j();else for(const e in this.data.system.senses){const t={subType:e};r.DDBModifiers.filterModifiers(this.ddbData?.character?.modifiers?.race??[],"sense",t).forEach((t=>{Number.isInteger(t.value)&&t.value>this.data.system.senses[e]&&(this.data.system.senses[e]=parseInt(t.value))})),r.DDBModifiers.filterModifiers(this.ddbData?.character?.modifiers?.race??[],"set-base",t).forEach((t=>{Number.isInteger(t.value)&&t.value>this.data.system.senses[e]&&(this.data.system.senses[e]=parseInt(t.value))}))}}#V(){if(!this.is2014&&this.data.name.startsWith("Dragonborn")){const e={_id:foundry.utils.randomID(),type:"ScaleValue",configuration:{distance:{units:""},identifier:"breath-weapon",type:"dice",scale:{1:{number:1,faces:10},5:{number:2,faces:10},11:{number:3,faces:10},17:{number:4,faces:10}}},value:{},title:"Breath Weapon Dice",icon:null};this.data.system.advancement.push(e)}}async build(){try{await this._generateRaceImage()}catch(e){n.logger.error("Error generating race image, probably because you don't have permission to browse the host file system.",{e})}await this._buildCompendiumIndex("traits",this._indexFilter.traits),this.race.racialTraits.forEach((e=>{const t=e.definition;this.#O(t),this.#P(t),this.#F(t),this.#R(t),this.#N(t),this.#$(t),this.#U(t),this.#H(t),this.#W(t)})),this.#L(),this.#V(),this.#q(),foundry.utils.setProperty(this.data,"system.type.value",this.type),this.data.system.description.value=r.DDBReferenceLinker.parseTags(this.data.system.description.value),n.logger.debug("Race generated",{DDBRace:this})}static async getRacialTraitsLookup(e,t=!0){const a=n.CompendiumHelper.getCompendiumType("traits",t);if(a){const t=["name","flags.ddbimporter.entityRaceId","flags.ddbimporter.baseName"],i=await a.getIndex({fields:t});return await i.filter((t=>e.some((e=>t.name===e.name))))}return[]}async addToCompendium(){if(!game.settings.get(i.y.MODULE_ID,"character-update-policy-add-features-to-compendiums"))return;const e=game.settings.get(i.y.MODULE_ID,"character-update-policy-update-add-features-to-compendiums"),t={chrisPremades:!0,matchFlags:["fullRaceName","groupName","isLineage"],useCompendiumFolders:!0,deleteBeforeUpdate:!1},a=new n.DDBCompendiumFolders("traits");await a.loadCompendium("traits"),this.isLineage?await a.createSubTraitFolders(this.groupName,this.groupName):await a.createSubTraitFolders(this.groupName,this.fullName);const s=foundry.utils.deepClone(this.data),r=await n.DDBItemImporter.buildHandler("race",[s],e,t);await r.buildIndex(t.indexFilter)}}},686:(e,t,a)=>{a.d(t,{A:()=>DDBSpell});var i=a(115),n=a(421),s=a(791),r=a(186),o=a(259),l=a(648),d=a(243),c=a(382),u=a(111);class DDBSpell extends l.mixins.DDBActivityFactoryMixin{_generateDataStub(){this.data={_id:n.utils.namedIDStub(this.name,{prefix:this.namePrefix,postfix:this.namePostfix}),type:"spell",system:c.SystemHelpers.getTemplate("spell"),effects:[],name:this.name,flags:{ddbimporter:{id:this.spellData.id,definitionId:this.ddbDefinition.id,entityTypeId:this.spellData.entityTypeId,dndbeyond:this.spellData.flags.ddbimporter.dndbeyond,originalName:this.originalName,sources:this.ddbDefinition.sources,tags:this.ddbDefinition.tags,version:CONFIG.DDBI.version,is2014:this.is2014,is2024:!this.is2014,addSpellEffects:this.addSpellEffects,legacy:this.legacy},"midi-qol":{removeAttackDamageButtons:"default"},midiProperties:{confirmTargets:"default",magicdam:!0,magiceffect:!0},"spell-class-filter-for-5e":this.spellData.flags["spell-class-filter-for-5e"],"tidy5e-sheet":this.spellData.flags["tidy5e-sheet"]}},this.legacyPostfix&&this.is2014&&(this.data.name+=" (Legacy)")}getCustomName(e){if(!this.rawCharacter||this.rawCharacter&&!foundry.utils.hasProperty(this.rawCharacter,"flags.ddbimporter.dndbeyond.characterValues"))return null;const t=this.rawCharacter.flags.ddbimporter.dndbeyond.characterValues.filter((t=>t.valueId==e.id&&t.valueTypeId==e.entityTypeId));if(t){const a=t.find((e=>8==e.typeId));if(a)return e.name=a.vale,a.value;if(a)return a.value}return null}getName(){const e=this.getCustomName(this.spellData);return e?n.utils.nameString(e):this.nameOverride?n.utils.nameString(this.nameOverride):n.utils.nameString(this.ddbDefinition.name)}async init(){await this.loadEnricher(),this.itemCompendium&&await this.itemCompendium.getIndex({fields:["name","system.rarity","system.type.value"]})}constructor({ddbData:e,spellData:t,rawCharacter:a=null,namePrefix:s=null,namePostfix:r=null,isGeneric:d=null,updateExisting:c=null,limitedUse:u=null,forceMaterial:m=null,klass:p=null,lookup:g=null,lookupName:h=null,ability:f=null,spellClass:y=null,dc:b=null,overrideDC:D=null,nameOverride:v=null,isHomebrew:C=null,enricher:w=null,generateSummons:S=null,notifier:I=null,healingBoost:T=null,cantripBoost:A=null}={}){super({enricher:w,activityGenerator:o.IP,documentType:"spell",notifier:I}),this.notifier=I,this.ddbData=e,this.spellData=t,this.ddbDefinition=t.definition,this.rawCharacter=a,this.namePrefix=s,this.namePostfix=r,this.nameOverride=v??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.nameOverride"),this.originalName=n.utils.nameString(this.ddbDefinition.name),this.name=this.getName(this.spellData,this.rawCharacter),this.data={},this.activities=[],this.activityTypes=[],this.activityType=null,this.additionalActivities=[],this.healingParts=[],this.isGeneric=d??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.generic"),this.addSpellEffects=this.isGeneric?game.settings.get(i.y.MODULE_ID,"munching-policy-add-spell-effects"):game.settings.get(i.y.MODULE_ID,"character-update-policy-add-spell-effects"),this.legacyPostfix=this.isGeneric?game.settings.get(i.y.MODULE_ID,"munching-policy-legacy-postfix"):!game.settings.get(i.y.MODULE_ID,"character-update-policy-remove-2024"),this.updateExisting=!!(c??this.isGeneric)&&game.settings.get(i.y.MODULE_ID,"munching-policy-update-existing"),this.pactSpellsPrepared=game.settings.get("ddb-importer","pact-spells-prepared"),this.limitedUse=u??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.limitedUse"),this.forceMaterial=m??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.forceMaterial"),this.forcePact=foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.forcePact"),this.spellClass=p??y??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.class"),this.lookup=g??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.lookup"),this.lookupName=h??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.lookupName"),this.ability=f??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.ability"),this.school=i.x.spell.schools.find((e=>e.name===this.ddbDefinition.school.toLowerCase())),this.dc=b??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.dc"),this.overrideDC=D??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.overrideDC"),this.isHomebrew=C??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.homebrew"),this.onlyPactMagic=1===this.ddbData?.character?.classes?.length&&"Warlock"===this.ddbData.character.classes[0].definition.name;const k=this.ddbDefinition.sources.map((e=>e.sourceId));this.legacy=CONFIG.DDB.sources.some((e=>k.includes(e.id)&&i.x.sourceCategories.legacy.includes(e.sourceCategoryId))),this.is2014=this.ddbDefinition.isLegacy&&this.ddbDefinition.sources.some((e=>Number.isInteger(e.sourceId)&&e.sourceId<145)),this._generateDataStub(),this.itemCompendium=n.CompendiumHelper.getCompendiumType("item",!1),this.enricher=w??new l.DDBSpellEnricher({activityGenerator:o.IP,notifier:this.notifier}),this.isCompanionSpell=i.x.companions.COMPANION_SPELLS.includes(this.originalName),this.isCRSummonSpell=i.x.companions.CR_SUMMONING_SPELLS.includes(this.originalName),this.isSummons=this.isCompanionSpell||this.isCRSummonSpell,this.generateSummons=this.isGeneric||(S??game.settings.get(i.y.MODULE_ID,"character-update-policy-create-companions")),this.DDBCompanionFactory=null,this.isCantrip=0===this.ddbDefinition.level;const E=A??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.cantripBoost");this.cantripBoost=this.isCantrip&&E;const _=T??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.healingBoost");this.healingBonus=_?` + ${_} + @item.level`:""}_generateProperties(){this.ddbDefinition.components.includes(1)&&this.data.system.properties.push("vocal"),this.ddbDefinition.components.includes(2)&&this.data.system.properties.push("somatic"),(this.ddbDefinition.components.includes(3)||this.forceMaterial)&&this.data.system.properties.push("material"),this.ddbDefinition.ritual&&this.data.system.properties.push("ritual"),this.ddbDefinition.concentration&&this.data.system.properties.push("concentration")}_generateMaterials(){if(this.ddbDefinition.componentsDescription&&this.ddbDefinition.componentsDescription.length>0){let e=0,t=/([\d.,]+)\s*gp/i.exec(this.ddbDefinition.componentsDescription);t&&(e=parseInt(t[1].replace(/,|\./g,""))),this.data.system.materials={value:this.ddbDefinition.componentsDescription,consumed:-1!==this.ddbDefinition.componentsDescription.toLowerCase().indexOf("consume"),cost:e,supply:0}}else this.data.system.materials={value:"",consumed:!1,cost:0,supply:0}}_generateClassPreparationMode(){const e=n.utils.findByProperty(i.x.spell.preparationModes,"name",this.spellClass);"As Ritual Only"===this.spellData.restriction||this.spellData.castOnlyAsRitual||null!==this.spellData.ritualCastingType&&"Warlock"!==this.spellClass&&!this.is2014?(this.data.system.preparation.mode="ritual",this.data.system.preparation.prepared=!1):this.spellData.usesSpellSlot||0===this.ddbDefinition.level?this.spellData.alwaysPrepared?this.data.system.preparation.mode=this.forcePact?"pact":"always":this.data.system.preparation.mode&&e&&(this.data.system.preparation.mode=e.value):this.data.system.preparation.mode="innate","pact"===this.data.system.preparation.mode&&this.isCantrip?(this.data.system.preparation.mode="prepared",this.data.system.preparation.prepared=!0):"pact"===this.data.system.preparation.mode&&this.pactSpellsPrepared&&(this.data.system.preparation.prepared=!0)}_generateSpellPreparationMode(){this.data.system.preparation={mode:"prepared",prepared:this.spellData.alwaysPrepared||this.spellData.prepared||this.isCantrip};const e="classFeature"===this.lookup&&this.spellClass;if("classSpell"===this.lookup||e)this._generateClassPreparationMode();else if("race"===this.lookup&&0!==this.ddbDefinition.level)this.data.system.preparation.mode="innate",this.spellData.usesSpellSlot&&(this.data.system.preparation.mode=this.onlyPactMagic?"pact":"always");else if(this.lookupName.startsWith("Mystic Arcanum"))this.data.system.preparation.mode="pact",this.data.system.preparation.prepared=!1;else if("item "===this.lookup&&0!==this.ddbDefinition.level)this.data.system.preparation.mode="prepared",this.data.system.preparation.prepared=!1;else{let e=!this.spellData.usesSpellSlot&&0!==this.ddbDefinition.level,t=null!==this.spellData.ritualCastingType||this.spellData.castOnlyAsRitual;e&&t?(this.data.system.preparation.mode="ritual",this.data.system.preparation.prepared=!1):e&&(this.data.system.preparation.mode="atwill",this.data.system.preparation.prepared=!0),["classFeature","subclassFeature","feat"].includes(this.lookup)&&this.spellData.alwaysPrepared&&(this.data.system.preparation.mode="always")}}async _generateDescription(){let e=await c.DDBTable.generateTable({parentName:this.data.name,html:this.ddbDefinition.description,updateExisting:this.updateExisting,notifier:this.notifier});this.data.system.description={value:c.DDBReferenceLinker.parseTags(e),chat:""}}_generateActivation(){const e=this.spellData.activation??this.ddbDefinition.activation,t=i.x.spell.activationTypes.find((t=>t.activationType===e.activationType));t&&e.activationTime?this.data.system.activation={type:t.value,value:e.activationTime,condition:this.ddbDefinition.castingTimeDescription??""}:this.data.system.activation={type:"action",value:1,condition:this.ddbDefinition.castingTimeDescription??""}}_generateDuration(){if(this.ddbDefinition.duration){let e="";e=null!==this.ddbDefinition.duration.durationUnit?this.ddbDefinition.duration.durationUnit.toLowerCase():this.ddbDefinition.duration.durationType.toLowerCase().substring(0,4),this.data.system.duration={concentration:this.ddbDefinition.concentration,value:this.ddbDefinition.duration.durationInterval??"",units:e}}}targetsCreature(){return this.ddbDefinition.description.match(/You touch (?:a|one) (?:willing |living )?creature|affecting one creature|creature you touch|a creature you|creature( that)? you can see|interrupt a creature|would strike a creature|creature of your choice|creature or object within range|cause a creature|creature must be within range|a creature in range/gi)||this.ddbDefinition.description.match(/(humanoid|monster|creature|target|beast)(s)? (or loose object )?(of your choice )?(that )?(you can see )?within range/gi)||this.ddbDefinition.description.match(/spell attack against the target|at a target in range/gi)}_getTargetValue(){const e=[...this.ddbDefinition.description.matchAll(/(?!At Higher Levels.*)(\w*) (?:falling )?(?:willing )?(?:Bloodied )?(creature(?:s)?|target|monster|celestial|fiend|fey|corpse(?:s)? of|humanoid)(?!.*you have animated)/gim)].filter((e=>i.x.numbers.some((t=>t.natural===e[1].toLowerCase())))).map((e=>i.x.numbers.find((t=>t.natural===e[1].toLowerCase())).num));return e.length>0?Math.max(...e):null}_generateTarget(){let e={prompt:!0,affects:{count:"",type:"",choice:!1,special:""},template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:"ft"}};const t=new RegExp(/ (\d*)(?:[ -])foot(?:[ -])(thick|wide)/).exec(this.ddbDefinition.description);t&&t[1]>5&&(e.template.width=parseInt(t[1]));const a=new RegExp(/ (\d*)(?:[ -])foot(?:[ -])(tall|high)/).exec(this.ddbDefinition.description);if(a&&a[1]>5&&(e.template.height=parseInt(a[1])),this.ddbDefinition.range.aoeType&&this.ddbDefinition.range.aoeValue){const t=this.ddbDefinition.range.aoeType.toLowerCase();return e.template.size=parseInt(this.ddbDefinition.range.aoeValue),e.template.type="emanation"===t?"radius":t,void(this.data.system.target=e)}const i=this.targetsCreature();if(i){const t=this._getTargetValue();e.affects.count=t?`${t}`:""}const n=foundry.utils.getProperty(this.ddbDefinition,"range.rangeValue");switch(this.ddbDefinition.range.origin){case"Touch":i&&(e.affects.count="1",e.affects.type="creature");break;case"Self":{const t=this.ddbDefinition.modifiers.some((e=>"damage"===e.type));t&&n?(this.data.system.range.value=n,this.data.system.range.units="ft",e.template.type="radius"):e.affects.type=t?"creature":"self";break}case"None":e.affects.type="none";break;case"Ranged":case"Feet":case"Miles":i&&(e.affects.type="creature");break;case"Sight":case"Special":this.data.system.range.units="spec";break;case"Any":this.data.system.range.units="any";break;case void 0:e.affects.type=""}if(this.ddbDefinition.name.includes("Wall"))if(e.template.type="wall",e.template.units="ft",this.ddbDefinition.description.includes("ten 10-foot-"))e.template.size=100;else{const t=new RegExp(/ (\d*) feet long/).exec(this.ddbDefinition.description);t&&(e.template.size=parseInt(t[1]))}this.data.system.target=e}#z(){if(this.isGeneric||!this.spellClass||!this.rawCharacter)return;c.DDBDataUtils.hasClassFeature({ddbData:this.ddbData,featureName:"Improved Illusions",className:"Wizard",subClassName:"Illusionist"})&&"ill"===this.school.id&&Number.parseInt(this.data.system.range.value)>=10&&(this.data.system.range.value=Number.parseInt(this.data.system.range.value)+60)}_generateRange(){let e=this.ddbDefinition.range.rangeValue??null,t="ft";switch(this.ddbDefinition.range.origin){case"Touch":e=null,t="touch";break;case"Self":e=null,t="self";break;case"None":t="none";break;case"Ranged":case"Feet":t="ft";break;case"Miles":t="ml";break;case"Sight":case"Special":t="spec";break;case"Any":t="any";break;case void 0:t=null}this.data.system.range={value:e,units:t},this.#z()}_generateUses(){this.data.system.uses={spent:null,max:"",recovery:[]};const e=this.limitedUse??this.spellData.limitedUse;if(!e)return;const t=i.x.resets.find((t=>t.id==e.resetType));if(t){if(e.maxUses||e.statModifierUsesId||e.useProficiencyBonus){let a=e.maxUses&&-1!==e.maxUses?e.maxUses:"";if(e.statModifierUsesId){const t=i.x.actor.abilities.find((t=>t.id===e.statModifierUsesId)).value;if(2===e.operator)a=`${a} * @abilities.${t}.mod`;else a=`${a} + @abilities.${t}.mod`}if(e.useProficiencyBonus)if(2===e.proficiencyBonusOperator)a=`${a} * @prof`;else a=`${a} + @prof`;const n=""!==a?a:null;this.data.system.uses={spent:e.numberUsed??null,max:`${n}`,recovery:t?[{period:t.value,type:"recoverAll"}]:[]}}}else n.logger.warn("Unknown reset type",{resetType:e.resetType,spell:this})}#K(){const e=new o.IP({type:"heal",ddbParent:this,healingBoost:this.healingBoost,cantripBoost:this.cantripBoost});this.ddbDefinition.modifiers.filter((e=>"bonus"===e.type&&["temporary-hit-points","hit-points"].includes(e.subType))).forEach((t=>{let a={part:null,chatFlavor:null};const i=t.restriction&&""!==t.restriction?t.restriction:"";""!==i&&(a.chatFlavor=`Restriction: ${i}`);const n=t.die.diceString?t.die.diceString:t.die.fixedValue,s=t.usePrimaryStat?`${n} + @mod${this.healingBonus}`:`${n}${this.healingBonus}`;if(s&&""!==s.trim()&&"null"!==s.trim()){const i=e.buildDamagePart({damageString:s,type:"hit-points"===t.subType?"healing":"temphp"});a.part=i,this.healingParts.push(a)}}))}async#Y(){if(this.enricher.activity?.generateSummons){const e=await this.enricher.activity.summonsFunction({ddbParser:this,document:this.data,raw:this.ddbDefinition.description,text:this.data.system.description});await d.A.addGeneratedSummons(e)}this.isSummons&&(this.ddbCompanionFactory=new r.A(this.ddbDefinition.description,{type:"spell",originDocument:this.data,is2014:this.is2014,notifier:this.notifier}),await this.ddbCompanionFactory.parse(),(this.isGeneric||game.settings.get(i.y.MODULE_ID,"character-update-policy-create-companions"))&&await this.ddbCompanionFactory.updateOrCreateCompanions(),n.logger.debug(`parsed companions for ${this.data.name}`,{factory:this.ddbCompanionFactory,parsed:this.ddbCompanionFactory.companions}))}_getAttackActivity({name:e=null,nameIdPostfix:t=null}={},a={}){const i=foundry.utils.mergeObject({modRestrictionFilterExcludes:this.ddbDefinition.requiresSavingThrow?["Save","saving throw"]:null},a);return super._getAttackActivity({name:e,nameIdPostfix:t},i)}_getActivitiesType(){return this.isSummons?"summon":this.ddbDefinition.requiresSavingThrow&&!this.ddbDefinition.requiresAttackRoll?"save":this.ddbDefinition.tags.includes("Damage")&&this.ddbDefinition.requiresAttackRoll||null!==this.ddbDefinition.attackType?(this.ddbDefinition.requiresSavingThrow&&(this.additionalActivities.push({type:"save",options:{generateDamage:!0,includeBaseDamage:!1,modRestrictionFilter:["Save","saving throw"],consumptionOverride:{targets:[],spellSlot:!1,scaling:{allowed:!1,max:""}}}}),n.logger.debug(`Generating separate save with attack for ${this.originalName}`,this)),"attack"):this.ddbDefinition.tags.includes("Damage")?"damage":this.ddbDefinition.tags.includes("Healing")&&0===this.healingParts.length||this.ddbDefinition.tags.includes("Buff")?"utility":this.ddbDefinition.modifiers.some((e=>"damage"===e.type))?"damage":this.healingParts.length>0?"heal":this.enricher.effects?.length>0?"utility":void 0}async _generateActivity({hintsOnly:e=!1,name:t=null,nameIdPostfix:a=null,typeOverride:n=null,typeFallback:s="utility"}={},r={}){const o=super._generateActivity({hintsOnly:e,name:t,nameIdPostfix:a,typeOverride:n,typeFallback:s},r);if(!o)return;const l=foundry.utils.getProperty(this.data,`system.activities.${o}`);return"summon"!==l.type||(this.isCompanionSpell?await this.ddbCompanionFactory.addCompanionsToDocuments([],l):i.x.companions.CR_SUMMONING_SPELLS.includes(this.originalName)&&await this.ddbCompanionFactory.addCRSummoning(l)),o}#J(){if(0!==(this.ddbDefinition.conditions??[]).length)for(const e of this.ddbDefinition.conditions.filter((e=>1===e.type))){const t=i.x.actor.damageAdjustments.filter((e=>4===e.type)).find((t=>t.id===e.conditionId));if(t){let e=(0,s.D)(this.data,`${this.data.name}: ${t.name}`);e._id=foundry.utils.randomID(),u.ChangeHelper.addStatusEffectChange({effect:e,statusName:t.foundryValue}),this.data.effects.push(e)}}}async _applyEffects(){await(0,s.d)(this.data,this.addSpellEffects),foundry.utils.setProperty(this.data,"flags.ddbimporter.effectsApplied",!0),0===this.data.effects.length&&this.#J(),this.enricher.clearAutoEffects&&(this.data.effects=[]);const e=await this.enricher.createEffects();this.data.effects.push(...e),this.enricher.createDefaultEffects(),this._activityEffectLinking()}#D(){const e="heal"===this.activityType?foundry.utils.deepClone(this.healingParts).slice(1):foundry.utils.deepClone(this.healingParts);for(const t of e)this.additionalActivities.push({type:"heal",options:{generateDamage:!1,includeBaseDamage:!1,generateHealing:!0,healingPart:t}})}async _generateAdditionalActivities(){if(0===this.additionalActivities.length)return;n.logger.debug(`Additional Spell Activities for ${this.data.name}`,this.additionalActivities);let e=0;for(const t of this.additionalActivities){e++;const a=await this._generateActivity({hintsOnly:!1,name:t.name,nameIdPostfix:e,typeOverride:t.type},t.options);n.logger.debug(`Generated additional Activity with id ${a}`,{this:this,activityData:t,id:a})}}getRangeAdjustmentMultiplier(){if(!this.ddbParser?.ddbData)return 1;return c.DDBModifiers.filterBaseModifiers(this.ddbParser.ddbData,"bonus",{subType:"spell-attack-range-multiplier"}).filter((e=>e.isGranted)).reduce(((e,t)=>(Number.isInteger(t.fixedValue)&&t.fixedValue>e?e=t.fixedValue:Number.isInteger(t.value)&&t.value>e&&(e=t.value),e)),1)}adjustRange(e,t){return"rsak"===this.data.spell.system.actionType&&Number.isInteger(t.system.range?.value)&&foundry.utils.setProperty(t,"system.range.value",t.system.range.value*e),t}async parse(){this.data.system.level=this.ddbDefinition.level,this.data.system.school=this.school?this.school.id:null,this.data.system.source=n.DDBSources.parseSource(this.ddbDefinition),this.data.system.source.rules=this.is2014?"2014":"2024",this.spellClass&&(this.data.system.sourceClass=this.spellClass),this._generateProperties(),this._generateMaterials(),this._generateSpellPreparationMode(),await this._generateDescription(),this._generateActivation(),this._generateDuration(),this._generateRange(),this._generateTarget(),this._generateUses(),this.#K(),await this.#Y(),this.enricher.stopDefaultActivity||await this._generateActivity(),this.enricher.activity?.stopHealSpellActivity||this.#D(),this.enricher.addAutoAdditionalActivities&&await this._generateAdditionalActivities(),await this.enricher.addAdditionalActivities(this),await this._applyEffects(),this.rawCharacter&&!this.spellClass&&(this.data.system.ability=[this.ability]),this.ddbData&&c.DDBDataUtils.addCustomValues(this.ddbData,this.data),this.enricher.addDocumentOverride(),this.data.system.identifier=n.utils.referenceNameString(`${this.data.name.toLowerCase()}${this.is2014?" - legacy":""}`)}static async parseSpell(e,t,{namePrefix:a=null,namePostfix:i=null,ddbData:n=null,enricher:s=null,generateSummons:r=null,notifier:o=null}={}){const l=new DDBSpell({ddbData:n,spellData:e,rawCharacter:t,namePrefix:a,namePostfix:i,enricher:s,generateSummons:r,notifier:o});return await l.init(),await l.parse(),l.data}_getHealActivity({name:e=null,nameIdPostfix:t=null}={},a={}){const i=foundry.utils.mergeObject({healingPart:this.healingParts[0]},a);return super._getHealActivity({name:e,nameIdPostfix:t},i)}}},521:(e,t,a)=>{a.d(t,{A:()=>GenericSpellFactory});var i=a(421),n=a(43),s=a(486),r=a(686);class GenericSpellFactory{static async getGenericItemSpells(e,t,a=null){let n=[];for(const s of t.filter((e=>e.definition))){const t=e.find((e=>e.definition.id===s.componentId));if(!t)continue;const o=!t.definition.canEquip&&!t.definition.canAttune||t.isAttuned||!t.definition.canAttune&&t.equipped;let l=null;s.overrideSaveDc&&(l=s.overrideSaveDc),s.flags={ddbimporter:{dndbeyond:{lookup:"item",lookupName:t.definition.name,lookupId:t.definition.id,level:s.castAtLevel,dc:l,limitedUse:t.limitedUse,nameOverride:`${s.definition.name} (${t.definition.name})`,overrideDC:!!s.overrideSaveDc,spellLimitedUse:s.limitedUse,castAtLevel:s.castAtLevel,active:o,homebrew:s.definition.isHomebrew}}};const d=i.utils.namedIDStub(t.definition.name,{prefix:"",length:5}),c=await r.A.parseSpell(s,null,{namePostfix:d,generateSummons:a});n.push(c)}return n}static async getSpells(e,t=null,a=null){const i=[],n=e.filter((e=>e.definition)).filter((e=>!e.definition.sources||!e.definition.sources.some((e=>39===e.sourceId))));let s=0;const o=n.length;for(const e of n){t&&t(`Parsing spell ${++s} of ${o}: ${e.definition.name}`,!0),e.flags={ddbimporter:{generic:!0,dndbeyond:{lookup:"generic",lookupName:"generic",level:e.castAtLevel,castAtLevel:e.castAtLevel,homebrew:e.definition.isHomebrew}}};const n=await r.A.parseSpell(e,null,{generateSummons:a,notifier:t});i.push(n)}return i}static getSpellCount(e,t){return e[t]||(e[t]=0),++e[t]}static async getItemSpells(e,t,{generateSummons:a=null,notifier:o=null}={}){let l=[];const d=t.system.attributes.prof,c=(0,n.k)(e.character),u={},m=[...e.character.spells.item];e.unequippedItemSpells&&m.push(...e.unequippedItemSpells);for(const e of m){if(!e.definition)continue;const n=c.item.find((t=>t.id===e.componentId));if(!n)continue;const m=!n.canEquip&&!n.canAttune||n.isAttuned||!n.canAttune&&n.equipped;let p=8;if(e.overrideSaveDc)p=e.overrideSaveDc;else if(e.spellCastingAbilityId){let a="wis";(0,s.m9)(e.spellCastingAbilityId)&&(a=(0,s.cu)(e.spellCastingAbilityId));p=8+d+i.utils.calculateModifier(t.flags.ddbimporter.dndbeyond.effectAbilities[a].value)}else p=null;e.flags={ddbimporter:{dndbeyond:{lookup:"item",lookupName:n.name,lookupId:n.id,level:e.castAtLevel,dc:p,limitedUse:n.limitedUse,nameOverride:`${e.definition.name} (${n.name})`,overrideDC:!!e.overrideSaveDc,spellLimitedUse:e.limitedUse,castAtLevel:e.castAtLevel,active:m,homebrew:e.definition.isHomebrew}}};const g=`It${GenericSpellFactory.getSpellCount(u,e.definition.name)}`;l.push(await r.A.parseSpell(e,t,{namePostfix:g,generateSummons:a,notifier:o}))}return l}}},486:(e,t,a)=>{a.d(t,{cu:()=>convertSpellCastingAbilityId,m9:()=>hasSpellCastingAbility,s6:()=>getSpellCastingAbility});var i=a(115);function hasSpellCastingAbility(e){return i.x.actor.abilities.some((t=>t.id===e))}function convertSpellCastingAbilityId(e){return i.x.actor.abilities.find((t=>t.id===e)).value}function getSpellCastingAbility(e,t=!0,a=!1){let i;return i=!a&&hasSpellCastingAbility(e.definition.spellCastingAbilityId)?convertSpellCastingAbilityId(e.definition.spellCastingAbilityId):t&&e.subclassDefinition&&hasSpellCastingAbility(e.subclassDefinition.spellCastingAbilityId)?convertSpellCastingAbilityId(e.subclassDefinition.spellCastingAbilityId):"wis",i}},43:(e,t,a)=>{function getLookups(e){let t={race:[],feat:[],class:[],classFeature:[],item:[]};return e.race.racialTraits.forEach((e=>{t.race.push({id:e.definition.id,name:e.definition.name})})),e.classes.forEach((e=>{t.class.push({id:e.definition.id,name:e.definition.name}),e.subclassDefinition&&t.class.push({id:e.subclassDefinition.id,name:e.subclassDefinition.name}),e.classFeatures&&e.classFeatures.forEach((e=>{t.classFeature.push({id:e.definition.id,name:e.definition.name,classId:e.definition.classId,componentId:e.definition.componentId})}))})),e.options.class.forEach((e=>{t.classFeature.push({id:e.definition.id,name:e.definition.name,componentId:e.componentId})})),e.feats.forEach((e=>{t.feat.push({id:e.definition.id,name:e.definition.name,componentId:e.componentId})})),e.inventory.forEach((e=>{t.item.push({id:e.definition.id,name:e.definition.name,limitedUse:e.limitedUse,equipped:e.equipped,isAttuned:e.isAttuned,canAttune:e.definition.canAttune,canEquip:e.definition.canEquip})})),t}a.d(t,{k:()=>getLookups})},830:(e,t,a)=>{a.d(t,{n:()=>isEqual}),e=a.hmd(e);var i="__lodash_hash_undefined__",n=1,s=2,r=9007199254740991,o="[object Arguments]",l="[object Array]",d="[object Boolean]",c="[object Date]",u="[object Error]",m="[object Function]",p="[object GeneratorFunction]",g="[object Map]",h="[object Number]",f="[object Object]",y="[object Promise]",b="[object RegExp]",D="[object Set]",v="[object String]",C="[object Symbol]",w="[object WeakMap]",S="[object ArrayBuffer]",I="[object DataView]",T=/^\[object .+?Constructor\]$/,A=/^(?:0|[1-9]\d*)$/,k={};k["[object Float32Array]"]=k["[object Float64Array]"]=k["[object Int8Array]"]=k["[object Int16Array]"]=k["[object Int32Array]"]=k["[object Uint8Array]"]=k["[object Uint8ClampedArray]"]=k["[object Uint16Array]"]=k["[object Uint32Array]"]=!0,k[o]=k[l]=k[S]=k[d]=k[I]=k[c]=k[u]=k[m]=k[g]=k[h]=k[f]=k[b]=k[D]=k[v]=k[w]=!1;var E="object"==typeof a.g&&a.g&&a.g.Object===Object&&a.g,_="object"==typeof self&&self&&self.Object===Object&&self,M=E||_||Function("return this")(),B="object"==typeof exports&&exports&&!exports.nodeType&&exports,P=B&&e&&!e.nodeType&&e,O=P&&P.exports===B&&E.process,F=function(){try{return O&&O.binding("util")}catch(e){}}(),x=F&&F.isTypedArray;function arraySome(e,t){for(var a=-1,i=e?e.length:0;++a<i;)if(t(e[a],a,e))return!0;return!1}function isHostObject(e){var t=!1;if(null!=e&&"function"!=typeof e.toString)try{t=!!(e+"")}catch(e){}return t}function mapToArray(e){var t=-1,a=Array(e.size);return e.forEach((function(e,i){a[++t]=[i,e]})),a}function setToArray(e){var t=-1,a=Array(e.size);return e.forEach((function(e){a[++t]=e})),a}var L,R=Array.prototype,N=Function.prototype,$=Object.prototype,U=M["__core-js_shared__"],H=(L=/[^.]+$/.exec(U&&U.keys&&U.keys.IE_PROTO||""))?"Symbol(src)_1."+L:"",G=N.toString,W=$.hasOwnProperty,j=$.toString,q=RegExp("^"+G.call(W).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$"),V=M.Symbol,z=M.Uint8Array,K=$.propertyIsEnumerable,Y=R.splice,J=function overArg(e,t){return function(a){return e(t(a))}}(Object.keys,Object),X=getNative(M,"DataView"),Q=getNative(M,"Map"),Z=getNative(M,"Promise"),ee=getNative(M,"Set"),te=getNative(M,"WeakMap"),ae=getNative(Object,"create"),ie=toSource(X),ne=toSource(Q),se=toSource(Z),re=toSource(ee),oe=toSource(te),le=V?V.prototype:void 0,de=le?le.valueOf:void 0;function Hash(e){var t=-1,a=e?e.length:0;for(this.clear();++t<a;){var i=e[t];this.set(i[0],i[1])}}function ListCache(e){var t=-1,a=e?e.length:0;for(this.clear();++t<a;){var i=e[t];this.set(i[0],i[1])}}function MapCache(e){var t=-1,a=e?e.length:0;for(this.clear();++t<a;){var i=e[t];this.set(i[0],i[1])}}function SetCache(e){var t=-1,a=e?e.length:0;for(this.__data__=new MapCache;++t<a;)this.add(e[t])}function Stack(e){this.__data__=new ListCache(e)}function arrayLikeKeys(e,t){var a=ue(e)||function isArguments(e){return function isArrayLikeObject(e){return isObjectLike(e)&&isArrayLike(e)}(e)&&W.call(e,"callee")&&(!K.call(e,"callee")||j.call(e)==o)}(e)?function baseTimes(e,t){for(var a=-1,i=Array(e);++a<e;)i[a]=t(a);return i}(e.length,String):[],i=a.length,n=!!i;for(var s in e)!t&&!W.call(e,s)||n&&("length"==s||isIndex(s,i))||a.push(s);return a}function assocIndexOf(e,t){for(var a=e.length;a--;)if(eq(e[a][0],t))return a;return-1}function baseIsEqual(e,t,a,i,r){return e===t||(null==e||null==t||!isObject(e)&&!isObjectLike(t)?e!=e&&t!=t:function baseIsEqualDeep(e,t,a,i,r,m){var p=ue(e),y=ue(t),w=l,T=l;p||(w=(w=ce(e))==o?f:w);y||(T=(T=ce(t))==o?f:T);var A=w==f&&!isHostObject(e),k=T==f&&!isHostObject(t),E=w==T;if(E&&!A)return m||(m=new Stack),p||me(e)?equalArrays(e,t,a,i,r,m):function equalByTag(e,t,a,i,r,o,l){switch(a){case I:if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case S:return!(e.byteLength!=t.byteLength||!i(new z(e),new z(t)));case d:case c:case h:return eq(+e,+t);case u:return e.name==t.name&&e.message==t.message;case b:case v:return e==t+"";case g:var m=mapToArray;case D:var p=o&s;if(m||(m=setToArray),e.size!=t.size&&!p)return!1;var f=l.get(e);if(f)return f==t;o|=n,l.set(e,t);var y=equalArrays(m(e),m(t),i,r,o,l);return l.delete(e),y;case C:if(de)return de.call(e)==de.call(t)}return!1}(e,t,w,a,i,r,m);if(!(r&s)){var _=A&&W.call(e,"__wrapped__"),M=k&&W.call(t,"__wrapped__");if(_||M){var B=_?e.value():e,P=M?t.value():t;return m||(m=new Stack),a(B,P,i,r,m)}}if(!E)return!1;return m||(m=new Stack),function equalObjects(e,t,a,i,n,r){var o=n&s,l=keys(e),d=l.length,c=keys(t),u=c.length;if(d!=u&&!o)return!1;var m=d;for(;m--;){var p=l[m];if(!(o?p in t:W.call(t,p)))return!1}var g=r.get(e);if(g&&r.get(t))return g==t;var h=!0;r.set(e,t),r.set(t,e);var f=o;for(;++m<d;){var y=e[p=l[m]],b=t[p];if(i)var D=o?i(b,y,p,t,e,r):i(y,b,p,e,t,r);if(!(void 0===D?y===b||a(y,b,i,n,r):D)){h=!1;break}f||(f="constructor"==p)}if(h&&!f){var v=e.constructor,C=t.constructor;v==C||!("constructor"in e)||!("constructor"in t)||"function"==typeof v&&v instanceof v&&"function"==typeof C&&C instanceof C||(h=!1)}return r.delete(e),r.delete(t),h}(e,t,a,i,r,m)}(e,t,baseIsEqual,a,i,r))}function baseIsNative(e){return!(!isObject(e)||function isMasked(e){return!!H&&H in e}(e))&&(isFunction(e)||isHostObject(e)?q:T).test(toSource(e))}function baseKeys(e){if(!function isPrototype(e){var t=e&&e.constructor,a="function"==typeof t&&t.prototype||$;return e===a}(e))return J(e);var t=[];for(var a in Object(e))W.call(e,a)&&"constructor"!=a&&t.push(a);return t}function equalArrays(e,t,a,i,r,o){var l=r&s,d=e.length,c=t.length;if(d!=c&&!(l&&c>d))return!1;var u=o.get(e);if(u&&o.get(t))return u==t;var m=-1,p=!0,g=r&n?new SetCache:void 0;for(o.set(e,t),o.set(t,e);++m<d;){var h=e[m],f=t[m];if(i)var y=l?i(f,h,m,t,e,o):i(h,f,m,e,t,o);if(void 0!==y){if(y)continue;p=!1;break}if(g){if(!arraySome(t,(function(e,t){if(!g.has(t)&&(h===e||a(h,e,i,r,o)))return g.add(t)}))){p=!1;break}}else if(h!==f&&!a(h,f,i,r,o)){p=!1;break}}return o.delete(e),o.delete(t),p}function getMapData(e,t){var a=e.__data__;return function isKeyable(e){var t=typeof e;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==e:null===e}(t)?a["string"==typeof t?"string":"hash"]:a.map}function getNative(e,t){var a=function getValue(e,t){return null==e?void 0:e[t]}(e,t);return baseIsNative(a)?a:void 0}Hash.prototype.clear=function hashClear(){this.__data__=ae?ae(null):{}},Hash.prototype.delete=function hashDelete(e){return this.has(e)&&delete this.__data__[e]},Hash.prototype.get=function hashGet(e){var t=this.__data__;if(ae){var a=t[e];return a===i?void 0:a}return W.call(t,e)?t[e]:void 0},Hash.prototype.has=function hashHas(e){var t=this.__data__;return ae?void 0!==t[e]:W.call(t,e)},Hash.prototype.set=function hashSet(e,t){return this.__data__[e]=ae&&void 0===t?i:t,this},ListCache.prototype.clear=function listCacheClear(){this.__data__=[]},ListCache.prototype.delete=function listCacheDelete(e){var t=this.__data__,a=assocIndexOf(t,e);return!(a<0)&&(a==t.length-1?t.pop():Y.call(t,a,1),!0)},ListCache.prototype.get=function listCacheGet(e){var t=this.__data__,a=assocIndexOf(t,e);return a<0?void 0:t[a][1]},ListCache.prototype.has=function listCacheHas(e){return assocIndexOf(this.__data__,e)>-1},ListCache.prototype.set=function listCacheSet(e,t){var a=this.__data__,i=assocIndexOf(a,e);return i<0?a.push([e,t]):a[i][1]=t,this},MapCache.prototype.clear=function mapCacheClear(){this.__data__={hash:new Hash,map:new(Q||ListCache),string:new Hash}},MapCache.prototype.delete=function mapCacheDelete(e){return getMapData(this,e).delete(e)},MapCache.prototype.get=function mapCacheGet(e){return getMapData(this,e).get(e)},MapCache.prototype.has=function mapCacheHas(e){return getMapData(this,e).has(e)},MapCache.prototype.set=function mapCacheSet(e,t){return getMapData(this,e).set(e,t),this},SetCache.prototype.add=SetCache.prototype.push=function setCacheAdd(e){return this.__data__.set(e,i),this},SetCache.prototype.has=function setCacheHas(e){return this.__data__.has(e)},Stack.prototype.clear=function stackClear(){this.__data__=new ListCache},Stack.prototype.delete=function stackDelete(e){return this.__data__.delete(e)},Stack.prototype.get=function stackGet(e){return this.__data__.get(e)},Stack.prototype.has=function stackHas(e){return this.__data__.has(e)},Stack.prototype.set=function stackSet(e,t){var a=this.__data__;if(a instanceof ListCache){var i=a.__data__;if(!Q||i.length<199)return i.push([e,t]),this;a=this.__data__=new MapCache(i)}return a.set(e,t),this};var ce=function baseGetTag(e){return j.call(e)};function isIndex(e,t){return!!(t=null==t?r:t)&&("number"==typeof e||A.test(e))&&e>-1&&e%1==0&&e<t}function toSource(e){if(null!=e){try{return G.call(e)}catch(e){}try{return e+""}catch(e){}}return""}function eq(e,t){return e===t||e!=e&&t!=t}(X&&ce(new X(new ArrayBuffer(1)))!=I||Q&&ce(new Q)!=g||Z&&ce(Z.resolve())!=y||ee&&ce(new ee)!=D||te&&ce(new te)!=w)&&(ce=function(e){var t=j.call(e),a=t==f?e.constructor:void 0,i=a?toSource(a):void 0;if(i)switch(i){case ie:return I;case ne:return g;case se:return y;case re:return D;case oe:return w}return t});var ue=Array.isArray;function isArrayLike(e){return null!=e&&isLength(e.length)&&!isFunction(e)}function isEqual(e,t){return baseIsEqual(e,t)}function isFunction(e){var t=isObject(e)?j.call(e):"";return t==m||t==p}function isLength(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=r}function isObject(e){var t=typeof e;return!!e&&("object"==t||"function"==t)}function isObjectLike(e){return!!e&&"object"==typeof e}var me=x?function baseUnary(e){return function(t){return e(t)}}(x):function baseIsTypedArray(e){return isObjectLike(e)&&isLength(e.length)&&!!k[j.call(e)]};function keys(e){return isArrayLike(e)?arrayLikeKeys(e):baseKeys(e)}},115:(e,t,a)=>{a.d(t,{x:()=>l,y:()=>m});var i=a(421),n=a(959);const s=[{title:"Backgrounds",setting:"entity-background-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/86797d176a398d9f2f05b75b2f54b6dd.jpg",auto:!0,types:["feat"],version:1},{title:"Classes",setting:"entity-class-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/b778ff3ca3f18e5f75ad4b348615cab5.jpg",auto:!0,types:["class","subclass","feat","weapon"],version:1},{title:"Feats",setting:"entity-feat-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/a69ab5bf67b03308893b582dbef700e9.jpg",auto:!0,types:["feat"],version:1},{title:"Items",setting:"entity-item-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/c06b79eae8ee234d1cea4688e117152b.jpg",auto:!0,types:["weapon","equipment","consumable","tool","loot","feat","container"],version:1},{title:"Monsters",setting:"entity-monster-compendium",type:"Actor",image:"https://media.dndbeyond.com/mega-menu/36ee49066331fc36e3b37147d123463a.jpg",auto:!0,types:["npc"],version:1},{title:"Vehicles",setting:"entity-vehicle-compendium",type:"Actor",image:"https://media.dndbeyond.com/mega-menu/e95485e82519aa807da5011d42b8c9d3.jpg",auto:!0,types:["npc","vehicle"],version:1},{title:"Species",setting:"entity-species-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/bfe65858aaa13919ce3d86d938bcb05b.jpg",auto:!0,types:["race","feat","weapon"],version:1},{title:"Spells",setting:"entity-spell-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/8894f93deeca83cdf0a6df3f36ffb52e.jpg",auto:!0,types:["spell"],version:1},{title:"Tables",setting:"entity-table-compendium",type:"RollTable",image:"https://media.dndbeyond.com/mega-menu/f1a2343aee786f21827daf763c60d30f.jpg",auto:!0,types:[],version:1},{title:"Override",setting:"entity-override-compendium",type:"Item",image:"https://media.dndbeyond.com/mega-menu/e116466f43544117a34ed5f642c680f7.jpg",auto:!0,types:["weapon","equipment","consumable","tool","loot","feat","container","spell","feat","class","subclass"],version:1},{title:"Adventures",setting:"entity-adventure-compendium",type:"Adventure",image:"https://media.dndbeyond.com/mega-menu/4af3d4c196428ab0809cf71d332d540d.png",auto:!1,types:[],version:1},{title:"Journals",setting:"entity-journal-compendium",type:"JournalEntry",image:"https://media.dndbeyond.com/mega-menu/4af3d4c196428ab0809cf71d332d540d.png",auto:!0,types:[],version:1},{title:"Summons",setting:"entity-summons-compendium",type:"Actor",image:"https://media.dndbeyond.com/mega-menu/4af3d4c196428ab0809cf71d332d540d.png",auto:!0,types:["npc"],version:1}],r={senseMapDefault:{blindsight:"basic",darkvision:"darkvision",truesight:"basic",unknown:"basic"},senseMapVision5e:{blindsight:"blindsight",darkvision:"darkvision",tremorsense:"tremorsense",truesight:"truesight",unknown:"basic"},senseMap:()=>game.modules.get("vision-5e")?.active?r.senseMapVision5e:r.senseMapDefault,detectionMap:{blindsight:"senseAll",truesight:"seeAll",tremorsense:"feelTremor"}},o={COMPANION_FEATURES:["Steel Defender","Artificer Infusions","Summon Wildfire Spirit","Drake Companion","Drake Companion: Summon"],COMPANION_SPELLS:["Summon Aberration","Summon Beast","Summon Celestial","Summon Construct","Summon Elemental","Summon Fey","Summon Fiend","Summon Shadowspawn","Summon Undead","Summon Draconic Spirit"],COMPANION_OPTIONS:{"Primal Companion":["Beast of the Land","Beast of the Sea","Beast of the Sky"],"Drake Companion":["Summon"]},CR_SUMMONING_SPELLS:["Conjure Animals","Conjure Celestial","Conjure Elemental","Conjure Fey","Conjure Minor Elementals","Conjure Woodland Beings","Summon Greater Demon","Infernal Calling","Summon Lesser Demons","Find Familiar"],CR_SUMMONING_FEATURES:["Wild Companion"]},l={sourceCategories:{legacy:[23,26]},numbers:[{num:1,natural:"a"},{num:1,natural:"a new"},{num:1,natural:"one"},{num:2,natural:"two"},{num:3,natural:"three"},{num:4,natural:"four"},{num:5,natural:"five"},{num:6,natural:"six"},{num:7,natural:"seven"},{num:8,natural:"eight"},{num:9,natural:"nine"},{num:10,natural:"ten"},{num:11,natural:"eleven"},{num:12,natural:"twelve"},{num:13,natural:"thirteen"},{num:14,natural:"fourteen"},{num:15,natural:"fifteen"},{num:16,natural:"sixteen"},{num:17,natural:"seventeen"},{num:18,natural:"eighteen"},{num:19,natural:"nineteen"},{num:20,natural:"twenty"}],currency:{cp:"copper",sp:"silver",ep:"electrum",gp:"gold",pp:"platinum"},sizes:[{name:"Tiny",value:"tiny",size:.5},{name:"Small",value:"sm",size:.8},{name:"Medium",value:"med",size:1},{name:"Large",value:"lg",size:2},{name:"Huge",value:"huge",size:3},{name:"Gargantuan",value:"grg",size:4}],resets:[{id:1,value:"sr"},{id:"ShortRest",value:"sr"},{id:"Short",value:"sr"},{id:"short",value:"sr"},{id:2,value:"lr"},{id:"LongRest",value:"lr"},{id:"Long",value:"lr"},{id:"long",value:"lr"},{id:"Day",value:"day"},{id:"day",value:"day"},{id:"Dawn",value:"dawn"},{id:"dusk",value:"dusk"},{id:"Consumable",value:"charges"},{id:"Other",value:"charges"},{id:"",value:""},{id:null,value:""},{id:3,value:"day"},{id:4,value:"charges"}],conditions:[{label:"Blinded",foundry:"blinded",ddbId:1,levelId:null,ddbType:1},{label:"Charmed",foundry:"charmed",ddbId:2,levelId:null,ddbType:1},{label:"Deafened",foundry:"deafened",ddbId:3,levelId:null,ddbType:1},{label:"Exhaustion",foundry:"exhaustion",ddbId:null,levelId:null,ddbType:null},{label:"Exhaustion 1",foundry:"exhaustion",ddbId:4,levelId:1,ddbType:2},{label:"Exhaustion 2",foundry:"exhaustion",ddbId:4,levelId:2,ddbType:2},{label:"Exhaustion 3",foundry:"exhaustion",ddbId:4,levelId:3,ddbType:2},{label:"Exhaustion 4",foundry:"exhaustion",ddbId:4,levelId:4,ddbType:2},{label:"Exhaustion 5",foundry:"exhaustion",ddbId:4,levelId:5,ddbType:2},{label:"Exhaustion 6",foundry:"exhaustion",ddbId:4,levelId:6,ddbType:2},{label:"Frightened",foundry:"frightened",ddbId:5,levelId:null,ddbType:1},{label:"Grappled",foundry:"grappled",ddbId:6,levelId:null,ddbType:1},{label:"Incapacitated",foundry:"incapacitated",ddbId:7,levelId:null,ddbType:1},{label:"Invisible",foundry:"invisible",ddbId:8,levelId:null,ddbType:1},{label:"Paralyzed",foundry:"paralyzed",ddbId:9,levelId:null,ddbType:1},{label:"Petrified",foundry:"petrified",ddbId:10,levelId:null,ddbType:1},{label:"Poisoned",foundry:"poisoned",ddbId:11,levelId:null,ddbType:1},{label:"Prone",foundry:"prone",ddbId:12,levelId:null,ddbType:1},{label:"Restrained",foundry:"restrained",ddbId:13,levelId:null,ddbType:1},{label:"Stunned",foundry:"stunned",ddbId:14,levelId:null,ddbType:1},{label:"Unconscious",foundry:"unconscious",ddbId:15,levelId:null,ddbType:1},{label:"Diseased",foundry:"diseased",ddbId:null,levelId:null,ddbType:null},{label:"Disease",foundry:"diseased",ddbId:16,levelId:null,ddbType:null}],magicitems:{rechargeUnits:[{id:1,value:"r4"},{id:"ShortRest",value:"r4"},{id:2,value:"r5"},{id:"LongRest",value:"r5"},{id:"Long",value:"r5"},{id:"long",value:"r5"},{id:"Dawn",value:"r2"},{id:"dawn",value:"r2"},{id:"Day",value:"r2"},{id:"day",value:"r2"},{id:"daily",value:"r1"},{id:"DawnRest",value:"r2"},{id:"Dusk",value:"r3"},{id:"dusk",value:"r3"},{id:"DuskRest",value:"r3"},{id:"Sunset",value:"r3"},{id:"Consumable",value:""},{id:"Other",value:""},{id:"Daily",value:"r1"},{id:"sr",value:"r4"},{id:"lr",value:"r5"},{id:"",value:""},{id:null,value:""},{id:3,value:"r2"},{id:4,value:""}],nums:[{id:"once",value:1},{id:"twice",value:2},{id:"thrice",value:3},{id:"one",value:1},{id:"two",value:2},{id:"three",value:3}]},types:{full:["weapon","equipment","consumable","tool","loot","class","subclass","background","spell","feat","container"],equipment:["equipment","consumable","tool","loot","container"],inventory:["equipment","consumable","tool","loot","container","weapon"],monster:["equipment","consumable","tool","loot","container","weapon","feat"]},...r,actor:{class:[{name:"Artificer",multiclassSkill:0},{name:"Bard",multiclassSkill:1},{name:"Barbarian",multiclassSkill:0},{name:"Blood Hunter",multiclassSkill:0},{name:"Blood Hunter (archived)",multiclassSkill:0},{name:"Cleric",multiclassSkill:0},{name:"Druid",multiclassSkill:0},{name:"Fighter",multiclassSkill:0},{name:"Hunter",multiclassSkill:0},{name:"Paladin",multiclassSkill:0},{name:"Ranger",multiclassSkill:1},{name:"Rogue",multiclassSkill:1},{name:"Sorcerer",multiclassSkill:0},{name:"Warlock",multiclassSkill:0},{name:"Wizard",multiclassSkill:0},{name:"Monk",multiclassSkill:0},{name:"Illrigger",multiclassSkill:0}],abilities:[{id:1,value:"str",long:"strength"},{id:2,value:"dex",long:"dexterity"},{id:3,value:"con",long:"constitution"},{id:4,value:"int",long:"intelligence"},{id:5,value:"wis",long:"wisdom"},{id:6,value:"cha",long:"charisma"}],skills:[{name:"acr",label:"Acrobatics",ability:"dex",subType:"acrobatics",valueId:3},{name:"ani",label:"Animal Handling",ability:"wis",subType:"animal-handling",valueId:11},{name:"arc",label:"Arcana",ability:"int",subType:"arcana",valueId:6},{name:"ath",label:"Athletics",ability:"str",subType:"athletics",valueId:2},{name:"dec",label:"Deception",ability:"cha",subType:"deception",valueId:16},{name:"his",label:"History",ability:"int",subType:"history",valueId:7},{name:"ins",label:"Insight",ability:"wis",subType:"insight",valueId:12},{name:"itm",label:"Intimidation",ability:"cha",subType:"intimidation",valueId:17},{name:"inv",label:"Investigation",ability:"int",subType:"investigation",valueId:8},{name:"med",label:"Medicine",ability:"wis",subType:"medicine",valueId:13},{name:"nat",label:"Nature",ability:"int",subType:"nature",valueId:9},{name:"prc",label:"Perception",ability:"wis",subType:"perception",valueId:14},{name:"prf",label:"Performance",ability:"cha",subType:"performance",valueId:18},{name:"per",label:"Persuasion",ability:"cha",subType:"persuasion",valueId:19},{name:"rel",label:"Religion",ability:"int",subType:"religion",valueId:10},{name:"slt",label:"Sleight of Hand",ability:"dex",subType:"sleight-of-hand",valueId:4},{name:"ste",label:"Stealth",ability:"dex",subType:"stealth",valueId:5},{name:"sur",label:"Survival",ability:"wis",subType:"survival",valueId:15}],customSkillProficiencies:[{value:1,proficient:0},{value:2,proficient:.5},{value:3,proficient:1},{value:4,proficient:2}],alignments:[{id:1,name:"Lawful Good",value:"lg"},{id:2,name:"Neutral Good",value:"ng"},{id:3,name:"Chaotic Good",value:"cg"},{id:4,name:"Lawful Neutral",value:"ln"},{id:5,name:"True Neutral",value:"tn"},{id:6,name:"Chaotic Neutral",value:"cn"},{id:7,name:"Lawful Evil",value:"le"},{id:8,name:"Neutral Evil",value:"ne"},{id:9,name:"Chaotic Evil",value:"ce"}],actorSizes:[{id:2,name:"Tiny",value:"tiny"},{id:3,name:"Small",value:"sm"},{id:4,name:"Medium",value:"med"},{id:5,name:"Large",value:"lg"},{id:6,name:"Huge",value:"huge"},{id:7,name:"Gargantuan",value:"grg"}],senses:[{id:1,name:"Blindsight"},{id:2,name:"Darkvision"},{id:3,name:"Tremorsense"}],speeds:[{id:1,type:"walk",innate:"walking"},{id:2,type:"burrow",innate:"burrowing"},{id:3,type:"climb",innate:"climbing"},{id:4,type:"fly",innate:"flying"},{id:5,type:"swim",innate:"swimming"}],languages:[{name:"Common",value:"common",type:"standard"},{name:"Aarakocra",value:"aarakocra",advancement:"exotic"},{name:"Abyssal",value:"abyssal",advancement:"exotic"},{name:"Aquan",value:"aquan",advancement:"exotic:primordial"},{name:"Auran",value:"auran",advancement:"exotic:primordial"},{name:"Celestial",value:"celestial",advancement:"exotic"},{name:"Deep Speech",value:"deep",advancement:"exotic"},{name:"Draconic",value:"draconic",advancement:"standard"},{name:"Druidic",value:"druidic",advancement:null},{name:"Dwarvish",value:"dwarvish",advancement:"standard"},{name:"Elvish",value:"elvish",advancement:"standard"},{name:"Giant",value:"giant",advancement:"standard"},{name:"Gith",value:"gith",advancement:"exotic"},{name:"Gnomish",value:"gnomish",advancement:"standard"},{name:"Goblin",value:"goblin",advancement:"standard"},{name:"Gnoll",value:"gnoll",advancement:"exotic"},{name:"Halfling",value:"halfling",advancement:"standard"},{name:"Ignan",value:"ignan",advancement:"exotic:primordial"},{name:"Infernal",value:"infernal",advancement:"exotic"},{name:"Orc",value:"orc",advancement:"standard"},{name:"Primordial",value:"primordial",advancement:"exotic"},{name:"Terran",value:"terran",advancement:"exotic:primordial"},{name:"Sylvan",value:"sylvan",advancement:"exotic"},{name:"Thieves' Cant",value:"cant",advancement:null},{name:"Thieves’ Cant",value:"cant",advancement:null},{name:"Undercommon",value:"undercommon",advancement:"exotic"},{name:"Common Sign Language",value:"sign",advancement:"standard"}],armorTypes:[{name:"Clothing",value:"clothing"},{name:"Light Armor",value:"light"},{name:"Medium Armor",value:"medium"},{name:"Heavy Armor",value:"heavy"},{name:"Magical Bonus",value:"bonus"},{name:"Natural Armor",value:"natural"},{name:"Shield",value:"shield"}],damageAdjustments:[{id:1,type:1,kind:"resistance",name:"Bludgeoning",foundryValues:{value:["bludgeoning"],bypass:[]}},{id:2,type:1,kind:"resistance",name:"Piercing",foundryValues:{value:["piercing"],bypass:[]}},{id:3,type:1,kind:"resistance",name:"Slashing",foundryValues:{value:["slashing"],bypass:[]}},{id:4,type:1,kind:"resistance",name:"Lightning",foundryValues:{value:["lightning"],bypass:[]}},{id:5,type:1,kind:"resistance",name:"Thunder",foundryValues:{value:["thunder"],bypass:[]}},{id:6,type:1,kind:"resistance",name:"Poison",foundryValues:{value:["poison"],bypass:[]}},{id:7,type:1,kind:"resistance",name:"Cold",foundryValues:{value:["cold"],bypass:[]}},{id:8,type:1,kind:"resistance",name:"Radiant",foundryValues:{value:["radiant"],bypass:[]}},{id:9,type:1,kind:"resistance",name:"Fire",foundryValues:{value:["fire"],bypass:[]}},{id:10,type:1,kind:"resistance",name:"Necrotic",foundryValues:{value:["necrotic"],bypass:[]}},{id:11,type:1,kind:"resistance",name:"Acid",foundryValues:{value:["acid"],bypass:[]}},{id:12,type:1,kind:"resistance",name:"Psychic",foundryValues:{value:["psychic"],bypass:[]}},{id:13,type:1,kind:"resistance",name:"Physical (Magical)",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc"]}},{id:14,type:1,kind:"resistance",name:"Physical (Silvered)",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc","sil"]}},{id:15,type:1,kind:"resistance",name:"Physical (Adamantine)",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc","ada"]}},{id:16,type:1,kind:"resistance",name:"Piercing and Slashing from Nonmagical Attacks that aren't Adamantine",foundryValues:{value:["piercing","slashing"],bypass:["mgc","ada"]}},{id:17,type:2,kind:"immunity",name:"Bludgeoning",foundryValues:{value:["bludgeoning"],bypass:[]}},{id:18,type:2,kind:"immunity",name:"Piercing",foundryValues:{value:["piercing"],bypass:[]}},{id:19,type:2,kind:"immunity",name:"Slashing",foundryValues:{value:["slashing"],bypass:[]}},{id:20,type:2,kind:"immunity",name:"Lightning",foundryValues:{value:["lightning"],bypass:[]}},{id:21,type:2,kind:"immunity",name:"Thunder",foundryValues:{value:["thunder"],bypass:[]}},{id:22,type:2,kind:"immunity",name:"Poison",foundryValues:{value:["poison"],bypass:[]}},{id:23,type:2,kind:"immunity",name:"Cold",foundryValues:{value:["cold"],bypass:[]}},{id:24,type:2,kind:"immunity",name:"Radiant",foundryValues:{value:["radiant"],bypass:[]}},{id:25,type:2,kind:"immunity",name:"Fire",foundryValues:{value:["fire"],bypass:[]}},{id:26,type:2,kind:"immunity",name:"Necrotic",foundryValues:{value:["necrotic"],bypass:[]}},{id:27,type:2,kind:"immunity",name:"Acid",foundryValues:{value:["acid"],bypass:[]}},{id:28,type:2,kind:"immunity",name:"Psychic",foundryValues:{value:["psychic"],bypass:[]}},{id:29,type:2,kind:"immunity",name:"Bludgeoning, Piercing, and Slashing from Nonmagical Attacks",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc"]}},{id:30,type:2,kind:"immunity",name:"Bludgeoning, Piercing, and Slashing from Nonmagical Attacks that aren't Silvered",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc","sil"]}},{id:31,type:2,kind:"immunity",name:"Bludgeoning, Piercing, and Slashing from Nonmagical Attacks that aren't Adamantine",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc","ada"]}},{id:32,type:2,kind:"immunity",name:"Piercing and Slashing from Nonmagical Attacks that aren't Adamantine",foundryValues:{value:["piercing","slashing"],bypass:["mgc","ada"]}},{id:33,type:3,kind:"vulnerability",name:"Bludgeoning",foundryValues:{value:["bludgeoning"],bypass:[]}},{id:34,type:3,kind:"vulnerability",name:"Piercing",foundryValues:{value:["piercing"],bypass:[]}},{id:35,type:3,kind:"vulnerability",name:"Slashing",foundryValues:{value:["slashing"],bypass:[]}},{id:36,type:3,kind:"vulnerability",name:"Lightning",foundryValues:{value:["lightning"],bypass:[]}},{id:37,type:3,kind:"vulnerability",name:"Thunder",foundryValues:{value:["thunder"],bypass:[]}},{id:38,type:3,kind:"vulnerability",name:"Poison",foundryValues:{value:["poison"],bypass:[]}},{id:39,type:3,kind:"vulnerability",name:"Cold",foundryValues:{value:["cold"],bypass:[]}},{id:40,type:3,kind:"vulnerability",name:"Radiant",foundryValues:{value:["radiant"],bypass:[]}},{id:41,type:3,kind:"vulnerability",name:"Fire",foundryValues:{value:["fire"],bypass:[]}},{id:42,type:3,kind:"vulnerability",name:"Necrotic",foundryValues:{value:["necrotic"],bypass:[]}},{id:43,type:3,kind:"vulnerability",name:"Acid",foundryValues:{value:["acid"],bypass:[]}},{id:44,type:3,kind:"vulnerability",name:"Psychic",foundryValues:{value:["psychic"],bypass:[]}},{id:45,type:3,kind:"vulnerability",name:"Piercing from Magic Weapons Wielded by Good Creatures",value:"piercing-from-magic-weapons-wielded-by-good"},{id:46,type:3,kind:"vulnerability",name:"Bludgeoning, Piercing, and Slashing from Magic Weapons",value:"bludgeoning-piercing-and-slashing-from-magic-weapons"},{id:47,type:1,kind:"resistance",name:"Force",foundryValues:{value:["force"],bypass:[]}},{id:48,type:2,kind:"immunity",name:"Force",foundryValues:{value:["force"],bypass:[]}},{id:49,type:3,kind:"vulnerability",name:"Force",foundryValues:{value:["force"],bypass:[]}},{id:51,type:1,kind:"resistance",name:"Ranged attacks",values:"ranged-attacks"},{id:52,type:1,kind:"resistance",name:"Damage dealt by traps",values:"damage-dealt-by-traps"},{id:54,type:1,kind:"resistance",name:"Bludgeoning from non magical attacks",foundryValues:{value:["bludgeoning"],bypass:["mgc"]}},{id:55,type:2,kind:"immunity",name:"Bludgeoning, Piercing, and Slashing from Metal Weapons",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:[]}},{id:56,type:1,kind:"resistance",name:"Bludgeoning, Piercing, and Slashing while in Dim Light or Darkness",value:"bludgeoning-piercing-and-slashing-while-in-dim-or-light-darkness"},{id:57,type:1,kind:"resistance",name:"Damage from Spells",values:"damage-from-spells",midiValues:["spells"]},{id:60,type:2,kind:"immunity",name:"Bludgeoning, Piercing, and Slashing from Nonmagical Attacks that aren't Adamantine or Silvered",foundryValues:{value:["slashing","bludgeoning","piercing"],bypass:["ada","sil","mgc"]}},{id:61,type:1,kind:"resistance",name:"Nonmagical Bludgeoning, Piercing, and Slashing (from Stoneskin)",foundryValues:{value:["bludgeoning","piercing","slashing"],bypass:["mgc"]}},{id:62,type:1,kind:"resistance",name:"All damage but Force, Radiant, and Psychic",foundryValues:{value:["bludgeoning","piercing","slashing","lightning","thunder","cold","fire","necrotic","acid","poison"],bypass:[]}},{id:63,type:2,kind:"immunity",name:"Petrified (Aberrant Armor Only)",value:"petrified-aberrant-armor-only"},{id:64,type:1,kind:"vulnerability",name:"Slashing from a Vorpal Sword",value:"slashing-from-a-vorpal-sword"},{id:65,type:1,kind:"resistance",name:"Damage of the type matching the animated breath's form (acid, cold, fire, lightning, or poison)",value:"damage-of-the-type-matching-the-animated-breaths-form-acid-cold-fire-lightning-or-poison"},{id:66,type:1,kind:"resistance",name:"Psychic (granted by Ruidium Armor)",foundryValues:{value:["psychic"],bypass:[]}},{id:67,type:2,kind:"immunity",name:"Bludgeoning, Piercing, and Slashing that is Nonmagical",foundryValues:{value:["slashing","bludgeoning","piercing"],bypass:["mgc"]}},{id:68,type:1,kind:"resistance",name:"One of the following: acid, cold, fire, lightning, or poison",value:"one-of-the-following-acid-cold-fire-lightning-or"},{id:69,type:1,kind:"resistance",name:"Lightning (granted by darksteel greataxe)",foundryValues:{value:["lightning"],bypass:[]}},{id:70,type:1,kind:"resistance",name:"Slashing and Piercing from Nonmagical Attacks",foundryValues:{value:["slashing","piercing"],bypass:["mgc"]}},{id:1,type:4,kind:"immunity",name:"Blinded",foundryValue:"blinded"},{id:2,type:4,kind:"immunity",name:"Charmed",foundryValue:"charmed"},{id:3,type:4,kind:"immunity",name:"Deafened",foundryValue:"deafened"},{id:4,type:4,kind:"immunity",name:"Exhaustion",foundryValue:"exhaustion"},{id:5,type:4,kind:"immunity",name:"Frightened",foundryValue:"frightened"},{id:6,type:4,kind:"immunity",name:"Grappled",foundryValue:"grappled"},{id:7,type:4,kind:"immunity",name:"Incapacitated",foundryValue:"incapacitated"},{id:8,type:4,kind:"immunity",name:"Invisible",foundryValue:"invisible"},{id:9,type:4,kind:"immunity",name:"Paralyzed",foundryValue:"paralyzed"},{id:10,type:4,kind:"immunity",name:"Petrified",foundryValue:"petrified"},{id:11,type:4,kind:"immunity",name:"Poisoned",foundryValue:"poisoned"},{id:12,type:4,kind:"immunity",name:"Prone",foundryValue:"prone"},{id:13,type:4,kind:"immunity",name:"Restrained",foundryValue:"restrained"},{id:14,type:4,kind:"immunity",name:"Stunned",foundryValue:"stunned"},{id:15,type:4,kind:"immunity",name:"Unconscious",foundryValue:"unconscious"},{id:16,type:4,kind:"immunity",name:"Diseased",value:"disease",foundryValue:"diseased"}],proficiencies:[{name:"All armor",type:"Armor",subType:null,foundryValue:"all",advancement:""},{name:"Light Armor",type:"Armor",subType:"Light Armor",foundryValue:"lgt",advancement:""},{name:"Medium Armor",type:"Armor",subType:"Medium Armor",foundryValue:"med",advancement:""},{name:"Heavy Armor",type:"Armor",subType:"Heavy Armor",foundryValue:"hvy",advancement:""},{name:"Shields",type:"Armor",subType:"Shield",foundryValue:"shl",advancement:""},{name:"Studded Leather",type:"Armor",subType:"Light Armor",foundryValue:"studded",advancement:"lgt"},{name:"Scale Mail",type:"Armor",subType:"Medium Armor",foundryValue:"scalemail",advancement:"med"},{name:"Shield",type:"Armor",subType:"Shield",foundryValue:"shield",advancement:"shl"},{name:"Padded",type:"Armor",subType:"Light Armor",foundryValue:"padded",advancement:"lgt"},{name:"Leather",type:"Armor",subType:"Light Armor",foundryValue:"leather",advancement:"lgt"},{name:"Hide",type:"Armor",subType:"Medium Armor",foundryValue:"hide",advancement:"med"},{name:"Chain Shirt",type:"Armor",subType:"Medium Armor",foundryValue:"chainshirt",advancement:"med"},{name:"Breastplate",type:"Armor",subType:"Medium Armor",foundryValue:"breastplate",advancement:"med"},{name:"Half Plate",type:"Armor",subType:"Medium Armor",foundryValue:"halfplate",advancement:"med"},{name:"Ring Mail",type:"Armor",subType:"Heavy Armor",foundryValue:"ringmail",advancement:"hvy"},{name:"Chain Mail",type:"Armor",subType:"Heavy Armor",foundryValue:"chainmail",advancement:"hvy"},{name:"Splint",type:"Armor",subType:"Heavy Armor",foundryValue:"splint",advancement:"hvy"},{name:"Plate",type:"Armor",subType:"Heavy Armor",foundryValue:"plate",advancement:"hvy"},{name:"Spiked Armor",type:"Armor",subType:"Medium Armor",advancement:"med"},{name:"Simple Weapons",type:"Weapon",subType:"Simple Weapons",foundryValue:"sim",advancement:""},{name:"Martial Weapons",type:"Weapon",subType:"Martial Weapons",foundryValue:"mar",advancement:""},{name:"Boomerang",type:"Weapon",subType:"Simple Weapon",foundryValue:"",advancement:"sim",melee:!1,ranged:!0,properties:{ret:!0}},{name:"Club",type:"Weapon",subType:"Simple Weapon",mastery:"slow",foundryValue:"club",advancement:"sim",melee:!0,ranged:!1,properties:{lgt:!0}},{name:"Crossbow, Light",type:"Weapon",subType:"Simple Weapon",mastery:"slow",ammunitionType:"crossbowBolt",foundryValue:"lightcrossbow",advancement:"sim",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,two:!0}},{name:"Dagger",type:"Weapon",subType:"Simple Weapon",mastery:"nick",foundryValue:"dagger",advancement:"sim",melee:!0,ranged:!0,properties:{lgt:!0,fin:!0,thr:!0}},{name:"Dart",type:"Weapon",subType:"Simple Weapon",mastery:"vex",foundryValue:"dart",advancement:"sim",melee:!1,ranged:!0,properties:{fin:!0,thr:!0}},{name:"Greatclub",type:"Weapon",subType:"Simple Weapon",mastery:"push",foundryValue:"greatclub",advancement:"sim",melee:!0,ranged:!1,properties:{two:!0}},{name:"Handaxe",type:"Weapon",subType:"Simple Weapon",mastery:"vex",foundryValue:"handaxe",advancement:"sim",melee:!0,ranged:!1,properties:{lgt:!0,thr:!0}},{name:"Javelin",type:"Weapon",subType:"Simple Weapon",mastery:"slow",foundryValue:"javelin",advancement:"sim",melee:!0,ranged:!0,properties:{thr:!0}},{name:"Light Hammer",type:"Weapon",subType:"Simple Weapon",mastery:"nick",foundryValue:"lighthammer",advancement:"sim",melee:!0,ranged:!0,properties:{lgt:!0,thr:!0}},{name:"Mace",type:"Weapon",subType:"Simple Weapon",mastery:"sap",foundryValue:"mace",advancement:"sim",melee:!0,ranged:!1,properties:{}},{name:"Quarterstaff",type:"Weapon",subType:"Simple Weapon",mastery:"topple",foundryValue:"quarterstaff",advancement:"sim",melee:!0,ranged:!1,properties:{ver:!0}},{name:"Shortbow",type:"Weapon",subType:"Simple Weapon",mastery:"vex",ammunitionType:"arrow",foundryValue:"shortbow",advancement:"sim",melee:!1,ranged:!0,properties:{amm:!0,two:!0}},{name:"Sickle",type:"Weapon",subType:"Simple Weapon",mastery:"nick",foundryValue:"sickle",advancement:"sim",melee:!0,ranged:!1,properties:{lgt:!0}},{name:"Sling",type:"Weapon",subType:"Simple Weapon",mastery:"slow",ammunitionType:"slingBullet",foundryValue:"sling",advancement:"sim",melee:!1,ranged:!0,properties:{amm:!0}},{name:"Spear",type:"Weapon",subType:"Simple Weapon",mastery:"sap",foundryValue:"spear",advancement:"sim",melee:!0,ranged:!0,properties:{thr:!0,ver:!0}},{name:"Yklwa",type:"Weapon",subType:"Simple Weapon",foundryValue:"",advancement:"sim",melee:!0,ranged:!1,properties:{amm:!0}},{name:"Antimatter Rifle",type:"Weapon",subType:"Martial Weapon",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,two:!0,fir:!0}},{name:"Battleaxe",type:"Weapon",subType:"Martial Weapon",mastery:"topple",foundryValue:"battleaxe",advancement:"mar",melee:!0,ranged:!1,properties:{ver:!0}},{name:"Blowgun",type:"Weapon",subType:"Martial Weapon",mastery:"vex",ammunitionType:"blowgunNeedle",foundryValue:"blowgun",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0}},{name:"Crossbow, Hand",type:"Weapon",subType:"Martial Weapon",mastery:"vex",ammunitionType:"crossbowBolt",foundryValue:"handcrossbow",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lgt:!0,lod:!0}},{name:"Crossbow, Heavy",type:"Weapon",subType:"Martial Weapon",mastery:"push",ammunitionType:"crossbowBolt",foundryValue:"heavycrossbow",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,hvy:!0,two:!0,lod:!0}},{name:"Double-Bladed Scimitar",type:"Weapon",subType:"Martial Weapon",foundryValue:"",advancement:"mar",melee:!0,ranged:!1,properties:{spc:!0}},{name:"Flail",type:"Weapon",subType:"Martial Weapon",mastery:"sap",foundryValue:"flail",advancement:"mar",melee:!0,ranged:!1,properties:{}},{name:"Glaive",type:"Weapon",subType:"Martial Weapon",mastery:"graze",foundryValue:"glaive",advancement:"mar",melee:!0,ranged:!1,properties:{hvy:!0,rch:!0,two:!0}},{name:"Greataxe",type:"Weapon",subType:"Martial Weapon",mastery:"cleave",foundryValue:"greataxe",advancement:"mar",melee:!0,ranged:!1,properties:{hvy:!0,two:!0}},{name:"Greatsword",type:"Weapon",subType:"Martial Weapon",mastery:"graze",foundryValue:"greatsword",advancement:"mar",melee:!0,ranged:!1,properties:{hvy:!0,two:!0}},{name:"Halberd",type:"Weapon",subType:"Martial Weapon",mastery:"cleave",foundryValue:"halberd",advancement:"mar",melee:!0,ranged:!1,properties:{hvy:!0,two:!0,rch:!0}},{name:"Lance",type:"Weapon",subType:"Martial Weapon",mastery:"topple",foundryValue:"lance",advancement:"mar",melee:!0,ranged:!1,properties:{rch:!0,spc:!0}},{name:"Laser Pistol",type:"Weapon",subType:"Martial Weapon",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0}},{name:"Laser Rifle",type:"Weapon",subType:"Martial Weapon",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0,two:!0}},{name:"Longbow",type:"Weapon",subType:"Martial Weapon",mastery:"slow",ammunitionType:"arrow",foundryValue:"longbow",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,hvy:!0,two:!0}},{name:"Longsword",type:"Weapon",subType:"Martial Weapon",mastery:"sap",foundryValue:"longsword",advancement:"mar",melee:!0,ranged:!1,properties:{ver:!0}},{name:"Maul",type:"Weapon",subType:"Martial Weapon",mastery:"topple",foundryValue:"maul",advancement:"mar",melee:!0,ranged:!1,properties:{hvy:!0,two:!0}},{name:"Morningstar",type:"Weapon",subType:"Martial Weapon",mastery:"sap",foundryValue:"morningstar",advancement:"mar",melee:!0,ranged:!1,properties:{}},{name:"Musket",type:"Weapon",subType:"Martial Weapon",mastery:"slow",ammunitionType:"firearmBullet",foundryValue:"musket",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0}},{name:"Net",type:"Weapon",subType:"Martial Weapon",foundryValue:"net",advancement:"mar",melee:!0,ranged:!1,properties:{spc:!0,thw:!0}},{name:"Pike",type:"Weapon",subType:"Martial Weapon",mastery:"push",foundryValue:"pike",advancement:"mar",melee:!0,ranged:!1,properties:{hvy:!0,two:!0,rch:!0}},{name:"Pistol, Automatic",type:"Weapon",subType:"Martial Weapon",mastery:"vex",ammunitionType:"firearmBullet",foundryValue:"pistol",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0}},{name:"Pistol",type:"Weapon",subType:"Martial Weapon",mastery:"vex",ammunitionType:"firearmBullet",foundryValue:"pistol",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0}},{name:"Rapier",type:"Weapon",subType:"Martial Weapon",mastery:"vex",foundryValue:"rapier",advancement:"mar",melee:!0,ranged:!1,properties:{fin:!0}},{name:"Revenant Double-Bladed Scimitar",type:"Weapon",subType:"Martial Weapon",foundryValue:"",advancement:"mar",properties:{spc:!0}},{name:"Revolver",type:"Weapon",subType:"Martial Weapon",mastery:"vex",ammunitionType:"firearmBullet",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0}},{name:"Rifle, Automatic",type:"Weapon",subType:"Martial Weapon",ammunitionType:"firearmBullet",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0,two:!0,burst:!0}},{name:"Rifle, Hunting",type:"Weapon",subType:"Martial Weapon",ammunitionType:"firearmBullet",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0,two:!0}},{name:"Scimitar",type:"Weapon",subType:"Martial Weapon",mastery:"nick",foundryValue:"scimitar",advancement:"mar",melee:!0,ranged:!1,properties:{fin:!0,lgt:!0}},{name:"Shortsword",type:"Weapon",subType:"Martial Weapon",mastery:"vex",foundryValue:"shortsword",advancement:"mar",melee:!0,ranged:!1,properties:{fin:!0,lgt:!0}},{name:"Shotgun",type:"Weapon",subType:"Martial Weapon",ammunitionType:"firearmBullet",foundryValue:"",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,fir:!0,two:!0}},{name:"Trident",type:"Weapon",subType:"Martial Weapon",mastery:"topple",foundryValue:"trident",advancement:"mar",melee:!0,ranged:!1,properties:{ver:!0,thr:!0}},{name:"War Pick",type:"Weapon",subType:"Martial Weapon",mastery:"sap",foundryValue:"warpick",advancement:"mar",melee:!0,ranged:!1,properties:{}},{name:"Warhammer",type:"Weapon",subType:"Martial Weapon",mastery:"push",foundryValue:"warhammer",advancement:"mar",melee:!0,ranged:!1,properties:{ver:!0}},{name:"Whip",type:"Weapon",subType:"Martial Weapon",mastery:"slow",foundryValue:"whip",advancement:"mar",melee:!0,ranged:!1,properties:{fin:!0,rch:!0}},{name:"Light Crossbow",type:"Weapon",subType:"Simple Weapon",mastery:"slow",ammunitionType:"crossbowBolt",foundryValue:"lightcrossbow",advancement:"sim",melee:!1,ranged:!0,properties:{amm:!0,lod:!0,two:!0}},{name:"Hand Crossbow",type:"Weapon",subType:"Martial Weapon",mastery:"vex",ammunitionType:"crossbowBolt",foundryValue:"handcrossbow",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,lgt:!0,lod:!0}},{name:"Heavy Crossbow",type:"Weapon",subType:"Martial Weapon",mastery:"push",ammunitionType:"crossbowBolt",foundryValue:"heavycrossbow",advancement:"mar",melee:!1,ranged:!0,properties:{amm:!0,hvy:!0,two:!0,lod:!0}},{name:"Ammunition",type:"Weapon",subType:"Simple Weapon",foundryValue:"",advancement:""},{name:"Crossbow Bolt",type:"Ammunition",ammunitionType:"crossbowBolt"},{name:"Crossbow",type:"Ammunition",ammunitionType:"crossbowBolt"},{name:"Sling Bullets",type:"Ammunition",ammunitionType:"slingBullet"},{name:"Sling",type:"Ammunition",ammunitionType:"slingBullet"},{name:"Bullets",type:"Ammunition",ammunitionType:"firearmBullet"},{name:"Blowgun Needles",type:"Ammunition",ammunitionType:"blowgunNeedle"},{name:"Blowgun",type:"Ammunition",ammunitionType:"blowgunNeedle"},{name:"Needles",type:"Ammunition",ammunitionType:"blowgunNeedle"},{name:"Arrows",type:"Ammunition",ammunitionType:"arrow"},{name:"Arrow",type:"Ammunition",ammunitionType:"arrow"},{name:"Alchemist's Supplies",type:"Tool",subType:"Supplies",ability:"int",baseTool:"alchemist",toolType:"art"},{name:"Brewer's Supplies",type:"Tool",subType:"Supplies",ability:"int",baseTool:"brewer",toolType:"art"},{name:"Calligrapher's Supplies",type:"Tool",subType:"Supplies",ability:"dex",baseTool:"calligrapher",toolType:"art"},{name:"Painter's Supplies",type:"Tool",subType:"Supplies",ability:"dex",baseTool:"painter",toolType:"art"},{name:"Carpenter's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"carpenter",toolType:"art"},{name:"Cartographer's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"cartographer",toolType:"art"},{name:"Cobbler's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"cobbler",toolType:"art"},{name:"Cook's Utensils",type:"Tool",subType:"Artisan's Tools",ability:"wis",baseTool:"cook",toolType:"art"},{name:"Glassblower's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"glassblower",toolType:"art"},{name:"Jeweler's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"jeweler",toolType:"art"},{name:"Leatherworker's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"leatherworker",toolType:"art"},{name:"Mason's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"mason",toolType:"art"},{name:"Navigator's Tools",type:"Tool",subType:"Artisan's Tools",ability:"int",baseTool:"navg",toolType:""},{name:"Potter's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"potter",toolType:"art"},{name:"Smith's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"smith",toolType:"art"},{name:"Tinker's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"tinker",toolType:"art"},{name:"Weaver's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"weaver",toolType:"art"},{name:"Woodcarver's Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"woodcarver",toolType:"art"},{name:"Dice Set",type:"Tool",subType:"Gaming Set",ability:"int",baseTool:"dice",toolType:"game"},{name:"Dragonchess Set",type:"Tool",subType:"Gaming Set",ability:"int",baseTool:"chess",toolType:"game"},{name:"Playing Card Set",type:"Tool",subType:"Gaming Set",ability:"int",baseTool:"card",toolType:"game"},{name:"Three-Dragon Ante Set",type:"Tool",subType:"Gaming Set",ability:"int",baseTool:"card",toolType:"game"},{name:"Thieves' Tools",type:"Tool",subType:"Artisan's Tools",ability:"dex",baseTool:"thief",toolType:""},{name:"Disguise Kit",type:"Tool",subType:"Kit",ability:"int",baseTool:"disg",toolType:""},{name:"Forgery Kit",type:"Tool",subType:"Kit",ability:"int",baseTool:"forg",toolType:""},{name:"Herbalism Kit",type:"Tool",subType:"Kit",ability:"int",baseTool:"herb",toolType:""},{name:"Poisoner's Kit",type:"Tool",subType:"Kit",ability:"int",baseTool:"pois",toolType:""},{name:"Bagpipes",type:"Tool",subType:"Musical Instrument",ability:"con",baseTool:"bagpipes",toolType:"music"},{name:"Birdpipes",type:"Tool",subType:"Musical Instrument",ability:"con",baseTool:null,toolType:"music"},{name:"Drum",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"drum",toolType:"music"},{name:"Dulcimer",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"dulcimer",toolType:"music"},{name:"Flute",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"flute",toolType:"music"},{name:"Glaur",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Hand Drum",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Horn",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"horn",toolType:"music"},{name:"Longhorn",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Lute",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"lute",toolType:"music"},{name:"Lyre",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"lyre",toolType:"music"},{name:"Pan Flute",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"panflute",toolType:"music"},{name:"Shawm",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Songhorn",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Tantan",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Thelarr",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Tocken",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Viol",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:"viol",toolType:"music"},{name:"Wargong",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Yarting",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Zulkoon",type:"Tool",subType:"Musical Instrument",ability:"dex",baseTool:null,toolType:"music"},{name:"Vehicles (Land)",type:"Tool",subType:"Vehicles",ability:"dex",baseTool:"land",toolType:"vehicle"},{name:"Vehicles (Air)",type:"Tool",subType:"Vehicles",ability:"dex",baseTool:"air",toolType:"vehicle"},{name:"Vehicles (Space)",type:"Tool",subType:"Vehicles",ability:"dex",baseTool:"space",toolType:"vehicle"},{name:"Vehicles (Water)",type:"Tool",subType:"Vehicles",ability:"dex",baseTool:"water",toolType:"vehicle"}],characterValuesLookup:[{name:"pactWeapon",typeId:28},{name:"hexWarrior",typeId:29}],pactFeatures:["Improved Pact Weapon","Lifedrinker","Eldritch Invocations: Pact of the Blade","Eldritch Invocations: Lifedrinker"]},item:{characterValues:[{typeId:8,value:"name"},{typeId:19,value:"price"},{typeId:22,value:"weight"}]},items:[{filterType:"Armor",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/armor.jpg"},{filterType:"Potion",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/potion.jpg"},{filterType:"Ring",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/ring.jpg"},{filterType:"Rod",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/rod.jpg"},{filterType:"Scroll",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/scroll.jpg"},{filterType:"Staff",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/staff.jpg"},{filterType:"Wand",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/wand.jpg"},{filterType:"Weapon",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/weapon.jpg"},{filterType:"Wondrous item",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/item_types/wondrousitem.jpg"}],genericItemIcons:[{name:"Adventuring Gear",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/adventuring-gear.jpg"},{name:"Tool",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/tool.jpg"},{name:"Gemstone",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/gemstone.jpg"},{name:"Holy Symbol",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/holy-symbol.jpg"},{name:"Weapon",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/weapon.jpg"},{name:"Arcane Focus",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/arcane-focus.jpg"},{name:"Druidic Focus",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/druidic-focus.jpg"},{name:"Ammunition",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/ammunition.jpg"},{name:"Poison",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/poison.jpg"},{name:"Mount",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/mount.jpg"},{name:"Potion",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/potion.jpg"},{name:"Equipment Pack",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/pack.jpg"},{name:"Vehicle",img:"https://www.dndbeyond.com/content/1-0-1358-0/skins/waterdeep/images/icons/equipment/vehicle.jpg"}],equipment:{armorType:[{name:"Light Armor",id:1,value:"light"},{name:"Medium Armor",id:2,value:"medium"},{name:"Heavy Armor",id:3,value:"heavy"},{name:"Shield",id:4,value:"shield"},{name:"Unarmored",id:0,value:null},{name:"Unarmored Defense",id:-1,value:null},{name:"Natural Armor",id:-2,value:"natural"},{name:"Magical Bonus",id:-3,value:"bonus"},{name:"Clothing",id:-4,value:"clothing"}],priceFormulas:{common:"1d6 * 10",uncommon:"1d6 * 100",rare:"2d10 * 1000",veryRare:"1d4 * 10000",legendary:"2d6 * 25000",artifact:"2d10 * 50000"}},weapon:{weaponRange:[{attackType:1,value:"M"},{attackType:2,value:"R"},{attackType:null,value:"R"}],weaponType:[{categoryId:1,value:"simple"},{categoryId:2,value:"martial"},{categoryId:3,value:"martial"},{categoryId:0,value:"simple"}],properties:[{name:"Adamantine",value:"ada"},{name:"Ammunition (Firearms)",value:"fir"},{name:"Ammunition",value:"amm"},{name:"Finesse",value:"fin"},{name:"Firearm",value:"fir"},{name:"Focus",value:"foc"},{name:"Heavy",value:"hvy"},{name:"Light",value:"lgt"},{name:"Loading",value:"lod"},{name:"Magical",value:"mgc"},{name:"Reach",value:"rch"},{name:"Reload",value:"rel"},{name:"Returning",value:"ret"},{name:"Silvered",value:"sil"},{name:"Special",value:"spc"},{name:"Thrown",value:"thr"},{name:"Two-Handed",value:"two"},{name:"Versatile",value:"ver"}]},actions:{activationTypes:[{id:0,value:"none"},{id:1,value:"action"},{id:2,value:"action"},{id:3,value:"bonus"},{id:4,value:"reaction"},{id:5,value:"action"},{id:6,value:"minute"},{id:7,value:"hour"},{id:8,value:"special"}],attackTypes:[{attackSubtype:2,value:"natural"},{attackSubtype:3,value:"simpleM"}],damageType:[{name:"bludgeoning",id:1},{name:"piercing",id:2},{name:"slashing",id:3},{name:"necrotic",id:4},{name:"acid",id:5},{name:"cold",id:6},{name:"fire",id:7},{name:"lightning",id:8},{name:"thunder",id:9},{name:"poison",id:10},{name:"psychic",id:11},{name:"radiant",id:12},{name:"force",id:13},{name:null,id:null}],aoeType:[{id:1,value:"cone"},{id:2,value:"cube"},{id:3,value:"cylinder"},{id:4,value:"line"},{id:5,value:"sphere"},{id:9,value:"square"},{id:13,value:"square"},{id:14,value:"radius"}]},spell:{schools:[{id:"abj",name:"abjuration",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/abjuration.png"},{id:"con",name:"conjuration",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/conjuration.png"},{id:"div",name:"divination",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/divination.png"},{id:"enc",name:"enchantment",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/enchantment.png"},{id:"evo",name:"evocation",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/evocation.png"},{id:"ill",name:"illusion",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/illusion.png"},{id:"nec",name:"necromancy",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/necromancy.png"},{id:"trs",name:"transmutation",img:"https://www.dndbeyond.com/content/1-0-1337-0/skins/waterdeep/images/spell-schools/35/transmutation.png"}],progression:[{name:"Artificer",value:"artificer"},{name:"Artificer (UA)",value:"artificer"},{name:"Bard",value:"full"},{name:"Barbarian",value:"none"},{name:"Blood Hunter",value:"pact"},{name:"Blood Hunter (archived)",value:"pact"},{name:"Cleric",value:"full"},{name:"Druid",value:"full"},{name:"Fighter",value:"third"},{name:"Hunter",value:"half"},{name:"Paladin",value:"half"},{name:"Ranger",value:"half"},{name:"Rogue",value:"third"},{name:"Sorcerer",value:"full"},{name:"Warlock",value:"pact"},{name:"Wizard",value:"full"},{name:"Monk",value:"none"}],preparationModes:[{name:"Artificer",value:"prepared"},{name:"Artificer (UA)",value:"prepared"},{name:"Bard",value:"always"},{name:"Blood Hunter",value:"pact"},{name:"Blood Hunter (archived)",value:"pact"},{name:"Cleric",value:"prepared"},{name:"Druid",value:"prepared"},{name:"Fighter",value:"always"},{name:"Hunter",value:"always"},{name:"Paladin",value:"prepared"},{name:"Ranger",value:"always"},{name:"Rogue",value:"always"},{name:"Sorcerer",value:"always"},{name:"Warlock",value:"pact"},{name:"Wizard",value:"prepared"},{name:"Monk",value:"always"}],activationTypes:[{activationType:0,value:"none",name:"No Action"},{activationType:1,value:"action",name:"Action"},{activationType:2,value:"none",name:"No Action"},{activationType:3,value:"bonus",name:"Bonus Action"},{activationType:4,value:"reaction",name:"Reaction"},{activationType:5,value:"special",name:"Unknown"},{activationType:6,value:"minute",name:"Minute"},{activationType:7,value:"hour",name:"Hour"},{activationType:8,value:"special",name:"Special"}]},monsters:{weapons:[{name:"Boomerang",actionType:"rwak",weaponType:"simpleR",properties:{ret:!0}},{name:"Club",actionType:"mwak",weaponType:"simpleM",properties:{lgt:!0}},{name:"Dagger",actionType:"mwak",weaponType:"simpleM",properties:{lgt:!0,fin:!0,thr:!0}},{name:"Dart",actionType:"rwak",weaponType:"simpleR",properties:{fin:!0,thr:!0}},{name:"Greatclub",actionType:"mwak",weaponType:"simpleM",properties:{two:!0}},{name:"Handaxe",actionType:"mwak",weaponType:"simpleM",properties:{lgt:!0,thr:!0}},{name:"Javelin",actionType:"mwak",weaponType:"simpleM",properties:{thr:!0}},{name:"Light Crossbow",actionType:"rwak",weaponType:"simpleR",properties:{amm:!0,lod:!0,two:!0}},{name:"Light Hammer",actionType:"mwak",weaponType:"simpleM",properties:{lgt:!0,thr:!0}},{name:"Mace",actionType:"mwak",weaponType:"simpleM",properties:{}},{name:"Quarterstaff",actionType:"mwak",weaponType:"simpleM",properties:{ver:!0}},{name:"Shortbow",actionType:"rwak",weaponType:"simpleR",properties:{amm:!0,two:!0}},{name:"Sickle",actionType:"mwak",weaponType:"simpleM",properties:{lgt:!0}},{name:"Sling",actionType:"rwak",weaponType:"simpleR",properties:{amm:!0}},{name:"Spear",actionType:"mwak",weaponType:"simpleM",properties:{thr:!0,ver:!0}},{name:"Yklwa",actionType:"rwak",weaponType:"simpleR",properties:{amm:!0}},{name:"Battleaxe",actionType:"mwak",weaponType:"martialM",properties:{ver:!0}},{name:"Blowgun",actionType:"rwak",weaponType:"martialR",properties:{amm:!0,lod:!0}},{name:"Flail",actionType:"mwak",weaponType:"martialM",properties:{}},{name:"Glaive",actionType:"mwak",weaponType:"martialM",properties:{hvy:!0,rch:!0,two:!0}},{name:"Greataxe",actionType:"mwak",weaponType:"martialM",properties:{hvy:!0,two:!0}},{name:"Greatsword",actionType:"mwak",weaponType:"martialM",properties:{hvy:!0,two:!0}},{name:"Halberd",actionType:"mwak",weaponType:"martialM",properties:{hvy:!0,two:!0,rch:!0}},{name:"Hand Crossbow",actionType:"rwak",weaponType:"martialR",properties:{amm:!0,lgt:!0,lod:!0}},{name:"Heavy Crossbow",actionType:"rwak",weaponType:"martialR",properties:{amm:!0,hvy:!0,two:!0,lod:!0}},{name:"Lance",actionType:"mwak",weaponType:"martialM",properties:{rch:!0,spc:!0}},{name:"Longbow",actionType:"rwak",weaponType:"martialR",properties:{amm:!0,hvy:!0,two:!0}},{name:"Longsword",actionType:"mwak",weaponType:"martialM",properties:{ver:!0}},{name:"Maul",actionType:"mwak",weaponType:"martialM",properties:{hvy:!0,two:!0}},{name:"Morningstar",actionType:"mwak",weaponType:"martialM",properties:{}},{name:"Musket",actionType:"rwak",weaponType:"martialR",properties:{amm:!0,lod:!0,fir:!0}},{name:"Net",actionType:"mwak",weaponType:"martialR",properties:{spc:!0,thw:!0}},{name:"Pike",actionType:"mwak",weaponType:"martialM",properties:{hvy:!0,two:!0,rch:!0}},{name:"Pistol",actionType:"rwak",weaponType:"martialR",properties:{amm:!0,lod:!0,fir:!0}},{name:"Rapier",actionType:"mwak",weaponType:"martialM",properties:{fin:!0}},{name:"Scimitar",actionType:"mwak",weaponType:"martialM",properties:{fin:!0,lgt:!0}},{name:"Shortsword",actionType:"mwak",weaponType:"martialM",properties:{fin:!0,lgt:!0}},{name:"Trident",actionType:"mwak",weaponType:"martialM",properties:{ver:!0,thr:!0}},{name:"War Pick",actionType:"mwak",weaponType:"martialM",properties:{}},{name:"Warhammer",actionType:"mwak",weaponType:"martialM",properties:{ver:!0}},{name:"Whip",actionType:"mwak",weaponType:"martialM",properties:{fin:!0,rch:!0}},{name:"Bite",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Claw",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Talons",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Teeth",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Tail",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Wing",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Slam",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Rake",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Beak",actionType:"mwak",weaponType:"natural",properties:{}},{name:"Tentacles",actionType:"mwak",weaponType:"natural",properties:{}}],resets:[{id:1,value:"sr"},{id:"ShortRest",value:"sr"},{id:"Short",value:"sr"},{id:"short",value:"sr"},{id:2,value:"lr"},{id:"LongRest",value:"lr"},{id:"Long",value:"lr"},{id:"long",value:"lr"},{id:"Day",value:"day"},{id:"day",value:"day"},{id:"Dawn",value:"day"},{id:"dusk",value:"day"},{id:"Consumable",value:"charges"},{id:"Other",value:"charges"}]},COMPENDIUM_FOLDERS:{SPELL_LEVEL:["0th Level (Cantrip)","1st Level","2nd Level","3rd Level","4th Level","5th Level","6th Level","7th Level","8th Level","9th Level"],RARITY:["Common","Uncommon","Rare","Very Rare","Legendary","Artifact","Varies","Unknown"],ITEM_ROOT:{equipment:"Equipment",tool:"Tools",loot:"Loot",weapon:"Weapon",container:"Container",consumable:"Consumable"},EQUIPMENT:{heavy:"Heavy Armor",medium:"Medium Armor",light:"Light Armor",trinket:"Trinket",shield:"Shield",clothing:"Clothing",wand:"Wand",rod:"Rod",trap:"Trap",ring:"Ring"},WEAPON:{simpleM:"Simple Melee",simpleR:"Simple Ranged",martialM:"Martial Melee",martialR:"Martial Ranged"},TRINKET:["Wondrous item","Ring","Arcane Focus","Holy Symbol","Druidic Focus","Adventuring Gear","Tattoo"],CONSUMABLE:["Adventuring Gear","Ammunition","Potion","Scroll","Poison","Wondrous item","Miscellaneous"],LOOT:["Gemstone","Adventuring Gear","Miscellaneous"],TOOLS:{art:"Artisan's Tools",music:"Musical Instrument",game:"Gaming Set"},CONTAINER:["Equipment Pack","Adventuring Gear","Vehicle","Mount","Wondrous item"]},CONSUMPTION_LINKS:{"Channel Divinity":["Channel Divinity:","Harness Divine Power","Sacred Weapon","Invoke Duplicity","War God's Blessing","Guided Strike","War Priest","Inspiring Smite","Peerless Athlete","Nature's Wrath","Vow of Enmity","Preserve Life"],"Superiority Dice":["Manoeuvres:","Maneuvers:","Maneuver:","Maneuver Options:"],"Combat Superiority":["Manoeuvres:","Maneuvers:","Maneuver:","Maneuver Options:"],"Sorcery Points":["Metamagic - ","Metamagic:","Hound of Ill Omen","Magical Guidance"],"Font of Magic: Sorcery Points":["Metamagic - ","Metamagic:","Hound of Ill Omen","Sorcerous Restoration","Bend Luck","Magical Guidance"],"Bardic Inspiration":["Mote of Potential","Unsettling Words","Mantle of Inspiration","Cutting Words","Peerless Skill","Tales from Beyond","Blade Flourish","Defensive Flourish","Slashing Flourish","Mobile Flourish","Psychic Blades","Superior Inspiration","Regain Bardic Inspiration","Inspiring Movement","Tandem Footwork","Beguiling Magic"],"Wild Shape":["Symbiotic Entity","Starry Form","Wild Companion","Summon Wildfire Spirit","Archdruid","Land's Aid","Wild Resurgence"],"Grit Points":["Trick Shots:","Bullying Shot","Dazing Shot","Deadeye Shot","Disarming Shot","Forceful Shot","Piercing Shot","Violent Shot","Winging Shot"],"Adept Marksman":["Trick Shots:","Bullying Shot","Deadeye Shot","Disarming Shot","Piercing Shot","Rapid Repair","Dazing Shot","Forceful Shot","Winging Shot","Violent Shot"],"Psionic Power":["Soul Blades","Psychic Blades: Psychic Teleportation","Soul Blades: Psychic Teleportation","Psychic Teleportation","Telekinetic Adept","Telekinetic Master"],"Psionic Power: Psionic Energy":["Psionic Power: Psionic Strike","Psionic Power: Protective Field","Guarded Mind","Psionic Power: Psi-Bolstered Knack","Soul Blades: Homing Strikes","Soul Blades: Psychic Teleportation","Psionic Power: Recovery","Psychic Blades: Homing Strikes","Psychic Teleportation"],"Psionic Power: Psionic Energy Dice":["Psionic Power: Psionic Strike","Psionic Power: Protective Field","Guarded Mind","Psionic Power: Psi-Bolstered Knack","Soul Blades: Homing Strikes","Soul Blades: Psychic Teleportation","Psionic Power: Recovery","Psychic Blades: Homing Strikes","Psychic Teleportation","Psionic Power: Psychic Whispers","Psychic Whispers"],Ki:["Ki-Fueled Attack","Flurry of Blows","Patient Defense","Step of the Wind","Deflect Missiles Attack","Arms of the Astral Self: Summon","Stunning Strike","Empty Body","Diamond Soul","Visage of the Astral Self","Quickened Healing","Focused Aim","Sharpen the Blade","Deft Strike","Shadow Arts","Extort Truth","Mind of Mercury","Debilitating Barrage","Tipsy Sway","Drunkard’s Luck","Drunkard's Luck","Touch of the Long Death","Quivering Palm","Radiant Sun Bolt","Searing Arc Strike","Breath of Winter","Clench of the North Wind","Eternal Mountain Defense","Fangs of the Fire Snake","Fist of Four Thunders","Fist of Unbroken Air","Flames of the Phoenix","Gong of the Summit","Mist Stance","Ride the Wind","River of Hungry Flame","Rush of the Gale Spirits","Shape the Flowing River","Sweeping Cinder Strike","Water Whip","Wave of Rolling Earth","Hand of Healing","Hand of Harm","Hand of Ultimate Mercy","Awakened Astral Self","Deflect Missiles"],"Monk's Focus":["Ki-Fueled Attack","Flurry of Blows","Patient Defense","Step of the Wind","Deflect Missiles Attack","Arms of the Astral Self: Summon","Stunning Strike","Empty Body","Diamond Soul","Visage of the Astral Self","Quickened Healing","Focused Aim","Sharpen the Blade","Deft Strike","Shadow Arts","Extort Truth","Mind of Mercury","Debilitating Barrage","Tipsy Sway","Drunkard’s Luck","Drunkard's Luck","Touch of the Long Death","Quivering Palm","Radiant Sun Bolt","Searing Arc Strike","Breath of Winter","Clench of the North Wind","Eternal Mountain Defense","Fangs of the Fire Snake","Fist of Four Thunders","Fist of Unbroken Air","Flames of the Phoenix","Gong of the Summit","Mist Stance","Ride the Wind","River of Hungry Flame","Rush of the Gale Spirits","Shape the Flowing River","Sweeping Cinder Strike","Water Whip","Wave of Rolling Earth","Hand of Healing","Hand of Harm","Hand of Ultimate Mercy","Awakened Astral Self","Uncanny Metabolism","Superior Defense","Deflect Attacks","Deflect Energy","Disciplined Survivor","Cloak of Shadows","Improved Shadow Step","Elemental Burst","Elemental Attunement"],"Infuse Item":["Infusion:"],"Maneuver Points":["Carrion Raven Martial Maneuvers:","Slippery Otter: Activate","Blade Breaker Maneuvers:"],"Jinx Points":["Misfortunes:","Curse Caster"],"Second Wind":["Tactical Mind"],Rage:["Rage: Regain Expended Uses","Intimidating Presence","Persistent Rage"],"Rage (Enter)":["Rage: Regain Expended Uses","Intimidating Presence","Persistent Rage"],"Divine Intervention":["Greater Divine Intervention"]},CONSUMPTION_SPELL_LINKS:{Ki:[{name:"Astral Projection",cost:8,lookupName:"Empty Body"},{name:"Darkness",cost:2,lookupName:"Shadow Arts"},{name:"Darkvision",cost:2,lookupName:"Shadow Arts"},{name:"Pass Without Trace",cost:2,lookupName:"Shadow Arts"},{name:"Silence",cost:2,lookupName:"Shadow Arts"},{name:"Burning Hands",cost:2,lookupName:"Searing Arc Strike"},{name:"Cone of Cold",cost:6,lookupName:"Breath of Winter"},{name:"Hold Person",cost:3,lookupName:"Clench of the North Wind"},{name:"Stoneskin",cost:5,lookupName:"Eternal Mountain Defense"},{name:"Thunderwave",cost:2,lookupName:"Fist of Four Thunders"},{name:"Fireball",cost:4,lookupName:"Flames of the Phoenix"},{name:"Shatter",cost:3,lookupName:"Gong of the Summit"},{name:"Gaseous Form",cost:4,lookupName:"Mist Stance"},{name:"Fly",cost:4,lookupName:"Ride the Wind"},{name:"Wall of Fire",cost:5,lookupName:"River of Hungry Flame"},{name:"Gust of Wind",cost:2,lookupName:"Rush of the Gale Spirits"},{name:"Burning Hands",cost:2,lookupName:"Sweeping Cinder Strike"},{name:"Wall of Stone",cost:6,lookupName:"Wave of Rolling Earth"}],"Maneuver Points":[{name:"Polymorph",cost:8,lookupName:"Bestial Transformation (8 points)"}],"Mantle of Majesty":[{name:"Command",cost:1,lookupName:"Activate Mantle of Majesty",nameUpdate:"Command (Mantle of Majesty)"}],"Divine Intervention":[{name:"Wish",cost:1,lookupName:"Greater Divine Intervention",nameUpdate:"Wish (Divine Intervention)"}],"War God's Blessing":[{name:"Shield of Faith",cost:1,lookupName:"War God's Blessing",nameUpdate:"Shield of Faith (War God's Blessing)"},{name:"Spiritual Weapon",cost:1,lookupName:"War God's Blessing",nameUpdate:"Spiritual Weapon (War God's Blessing)"}],"Telekinetic Master":[{name:"Telekinesis",cost:1,lookupName:"Telekinetic Master",nameUpdate:"Telekinesis (Telekinetic Master)"}],"Monk's Focus":[{name:"Darkness",cost:1,lookupName:"Shadow Arts"}],"Favored Enemy":[{name:"Hunter's Mark",cost:1,lookupName:"Favored Enemy",forceInnate:!0}]},parsing:{actions:{KEEP_ACTIONS:["Psychic Blades","Sorcery Points","Font of Magic: Sorcery Points","Form of the Beast: Bite","Form of the Beast: Claws","Form of the Beast: Tail"],KEEP_ACTIONS_STARTSWITH:["Metamagic:"],SKIPPED_ACTIONS:["Cleave","Graze","Nick","Push","Sap","Slow","Topple","Vex","Activate Large Form","Assume Unbreakable Majesty","Bardic Damage","Bardic Inspiration: Agile Strikes","Beguiling Magic: Regain Use","Blink Steps","Brew Poison","Channel Divinity: Abjure Foes","Channel Divinity: Divine Spark","Channel Divinity: Guided Strike (Benefit Ally)","Channel Divinity: Guided Strike (Self)","Channel Divinity: Invoke Duplicity","Channel Divinity: Sear Undead","Channel Divinity: Turn Undead","Channel Divinity: War God's Blessing","Charge Attack","Deflect Attack: Redirect Attack","Deflect Attack","Divine Strike","Embody Legends","Enhanced Dual Wielding","Enhanced Unarmed Strike","Evergreen Wildshape","Flurry of Blows (Heightened)","Flurry of Blows: Addle","Flurry of Blows: Push","Flurry of Blows: Topple","Flurry of Blows","Focus Points","Form of the Beast: Tail (reaction)","Free Casting","Ghostly Gaze","Grant Wrath of the Sea","Hand of Harm: Physician's Touch","Hand of Healing: Physician's Touch","Improved Dash","Invoke Duplicity: Cast Spells","Invoke Duplicity: Distract","Invoke Duplicity: Move Illusion","Invoke Duplicity: Shared Distraction","Ki Points","Lay On Hands: Heal","Lay On Hands: Purify Poison","Lay on Hands: Restoring Touch","Leave Druidic Message","Luck Points","Manifest Wrath of the Sea","Merge with Shadows","Moonlight Step: Regain Uses","Nature Magician","Patient Defense (Heightened)","Patient Defense","Polearm Master - Opportunity Attack","Psionic Power: Protective Field","Psionic Power: Psi-Bolstered Knack","Psionic Power: Psi-Powered Leap","Psionic Power: Psionic Energy Dice","Psionic Power: Psionic Energy","Psionic Power: Psionic Strike","Psionic Power: Psychic Whispers","Psionic Power: Recovery","Psionic Power: Telekinetic Movement","Psionic Power: Telekinetic Thrust","Psychic Blades: Attack (STR)","Psychic Blades: Bonus Attack (DEX)","Psychic Blades: Bonus Attack (STR)","Psychic Blades: Homing Strikes","Psychic Blades: Rend Mind","Psychic Teleportation","Quick Search","Rage (Instinctive Pounce)","Rage: Regain Expended Uses","Rage: Relentless Rage","Rage: Teleport","Reactive Spell","Sacred Weapon: Imbue Weapon","Saving Throw Reroll","Second Wind: Tactical Shift","Shift","Soul Blades: Homing Strikes","Soul Blades: Psychic Teleportation","Speedy Recovery","Step of the Wind (Heightened)","Step of the Wind: Fleet Step","Step of the Wind","Stonecunning (Tremorsense)","Summon Wildfire Spirit: Command","Superiority Dice","Telekinetic Master: Weapon Attack","Unerring Strike","War Priest: Bonus Attack","Wild Magic Surge table","Wild Shape: Circle Forms","Wild Shape: Improved Lunar Radiance","Imbue Aura of Protection","Channel Divinity: Divine Sense","Energy Redirection","Battle Medic","Avenging Angel","Hunter's Mark","Primal Companion: Restore Beast","Primal Companion: Summon","Hunter's Mark: Precise Hunter","Temporary Hit Points","Bolstering Performance","Dreadful Strike: Sudden Strike","Dreadful Strike: Mass Fear","Dreadful Strike","Hunter's Prey: Colossus Slayer","Hunter's Mark: Superior Hunter's Prey","Colossus Slayer","Masterful Mimicry","Steady Aim: Roving Aim","Improve Fate","Wild Magic Surge Table","Font of Magic: Convert Spell Slots","Telekinetic Shove","Revelation in Flesh: Transform","Trance of Order: Align Consciousness","Healing Light: Expend Healing","Awakened Mind: Clairvoyant Combatant","Arcane Ward: Hit Points","Arcane Ward - Hit Points","Defile Ground: Move Corruption","Unarmed Strike"],SKIPPED_ACTIONS_STARTSWITH:["Cleave (","Graze (","Nick (","Push (","Sap (","Slow (","Topple (","Vex (","Tactical Master:","Brutal Strike:","Channel Divinity: War God","Combat Inspiration: ","Font of Magic: Create","Improved Brutal Strike:","Land's Aid:","Maneuver: Disarming Attack (Dex.","Maneuver: Menacing Attack (Dex.","Maneuver: Parry (Dex.","Maneuver: Trip Attack (Dex.","Misty Step: ","Natural Recovery:","Pact of the Blade:","Sneak Attack:","Starry Form:","Wild Resurgence:","War Bond:","Slasher:","Fast Hands:","Use Magic Device:","Elemental Affinity:"],SKIPPED_2014_ONLY_ACTIONS:["Convert Sorcery Points"],SKIPPED_2024_ONLY_ACTIONS:["Lifedrinker"],HIGHEST_LEVEL_ONLY_ACTION_MATCH:["Bardic Inspiration","Channel Divinity: Invoke Duplicity","Moonlight Step","Warding Flare"]},attackActions:{FORCE_WEAPON_FEATURES:["Unarmed Strike","Psychic Blades: Attack (DEX)","Psychic Blades: Attack (STR)","Psychic Blades: Bonus Attack (DEX)","Psychic Blades: Bonus Attack (STR)","Psychic Blades","Thunder Gauntlets","Lightning Launcher","Guardian Armor: Thunder Gauntlets","Guardian Armor: Thunder Gauntlets (STR)","Infiltrator Armor: Lightning Launcher","Infiltrator Armor: Lightning Launcher (DEX)","Arcane Propulsion Armor Gauntlet","Arms of the Astral Self (WIS)","Arms of the Astral Self (DEX/STR)","Arms of the Astral Self","Bite","Claw","Gore","Sting","Talon","Trunk","Claws","Fangs","Form of the Beast: Bite","Form of the Beast: Claws","Form of the Beast: Tail","Fanged Bite"]},features:{LEGACY_SKIPPED_FEATURES:["Hit Points","Languages","Bonus Proficiency","Bonus Proficiencies","Speed","Skills","Feat","Creature Type"],SKIPPED_FEATURES_2014:["Primal Knowledge"],TASHA_VERSATILE:["Martial Versatility","Bardic Versatility","Cantrip Versatility","Sorcerous Versatility","Eldritch Versatility"],SKIPPED_FEATURES:["Equipment","Expertise","Darkvision","Core Barbarian Traits","Core Bard Traits","Core Cleric Traits","Core Druid Traits","Core Fighter Traits","Core Monk Traits","Core Paladin Traits","Core Ranger Traits","Core Rogue Traits","Core Sorcerer Traits","Core Warlock Traits","Core Wizard Traits","Weapon Mastery","Epic Boon: Choose an Epic Boon feat","Epic Boon","Maneuver: Trip Attack (Dex.)","Maneuver: Disarming Attack (Dex.)","Maneuver: Parry (Dex.)","Maneuver: Menacing Attack (Dex.)","Elven Lineage Spells","Gnomish Lineage Spells","Fiendish Legacy Spells","Keen Senses"],SKIPPED_FEATURES_STARTS_WITH:["Metamagic Options:","Weapon Mastery -","Expertise","Size","Proficiencies"],SKIPPED_FEATURES_ENDS_WITH:["Subclass"],SKIPPED_FEATURES_INCLUDES:["Ability Score"],FORCE_DUPLICATE_FEATURE:["Blessed Strikes","Wrath of the Sea","Elemental Attunement","Living Legend","Elder Champion","Defensive Tactics","Innate Sorcery","Magical Secrets","Infernal Majesty","Starry Form"],FORCE_DUPLICATE_OVERWRITE:["Cosmic Omen","Trance of Order"]},choiceFeatures:{KEEP_CHOICE_FEATURE:["Aspect of the Wilds","Blessed Strikes","Circle of the Land Spells","Defensive Tactics","Divine Order","Elemental Fury","Fighting Style","Genie's Vessel","Hunter's Prey","Mantle of Majesty","Power of the Wilds","Primal Order","The Third Eye","Unbreakable Majesty"],KEEP_CHOICE_FEATURE_NAME:["Defensive Tactics","Druidic Warrior","Hunter's Prey","Mantle of Majesty","Pact Boon","Primal Companion","The Third Eye","Unbreakable Majesty"],KEEP_CHOICE_FEATURE_NAME_STARTSWITH:["Boon of "],NO_FEATURE_PREFIX_NAME:["Rune Carver"],NO_CHOICE_BUILD:["Aspect of the Wilds","Boon of Energy Resistance","Charger","Circle of the Land Spells","Crusher","Deft Explorer","Dual Wielder","Elemental Adept","Elemental Affinity","Elven Lineage Spells","Fiendish Resilience","Gnomish Lineage Spells","Linguist","Magic Initiate (Cleric)","Magic Initiate (Druid)","Magic Initiate (Sorcerer)","Magic Initiate (Warlock)","Magic Initiate (Wizard)","Magical Secrets","Mantle of Majesty","Metamagic Options","Musician","Nature's Ward","Piercer","Poisoner","Power of the Wilds","Primal Knowledge","Rune Shaper","Shadow Touched","Shadow-Touched","Slasher","Telekinetic","Telepathic","The Third Eye","Thieves' Cant","Unbreakable Majesty","Forked Tongue","Cosmic Omen"],NO_CHOICE_SECRET:["Divine Order","Divine Order: Protector","Divine Order: Thaumaturge","Improved Blessed Strikes: Divine Strike","Improved Blessed Strikes: Potent Spellcasting","Improved Blessed Strikes","Circle of the Land Spells","Primal Order","Elemental Fury","Improved Elemental Fury","Improved Elemental Fury: Potent Spellcasting","Improved Elemental Fury: Primal Strike","Hunter's Prey","Defensive Tactics","Elven Lineage"],USE_ALL_CHOICES:[],USE_CHOSEN_ONLY:["Elven Lineage"],NO_CHOICE_ACTIVITY:["Mystic Arcanum ("],NO_CHOICE_DESCRIPTION_ADDITION:["Aspect of the Wilds","Breath Weapon (Acid)","Breath Weapon (Cold)","Breath Weapon (Fire)","Breath Weapon (Lightning)","Breath Weapon (Poison)","Breath Weapon","Charger","Crusher","Deft Explorer","Dual Wielder","Eldritch Invocations","Elemental Affinity","Elven Lineage Spells","Giant Ancestry","Gnomish Lineage Spells","Gnomish Lineage","Improved Elemental Fury: Potent Spellcasting","Improved Elemental Fury: Primal Strike","Improved Elemental Fury","Linguist","Magical Secrets","Mantle of Majesty","Nature's Ward","Otherworldly Glamour","Piercer","Poisoner","Power of the Wilds","Rune Carver","Rune Shaper","Slasher","Thieves' Cant","Unbreakable Majesty","Forked Tongue","Asmodeus's Blessing","Interdict Boons","Terrorizing Force","Kensei Weapon","Whispers of the Dead","Shifting","Celestial Revelation","Raging Storm","Storm Soul","Maneuver Options"]}},effects:{excludedModifiers:{common:[{type:"bonus",subType:"saving-throws"},{type:"bonus",subType:"ability-checks"},{type:"bonus",subType:"skill-checks"},{type:"bonus",subType:"proficiency-bonus"},{type:"set",subType:"strength-score"},{type:"set",subType:"dexterity-score"},{type:"set",subType:"constitution-score"},{type:"set",subType:"wisdom-score"},{type:"set",subType:"intelligence-score"},{type:"set",subType:"charisma-score"},{type:"bonus",subType:"acrobatics"},{type:"bonus",subType:"animal-handling"},{type:"bonus",subType:"arcana"},{type:"bonus",subType:"athletics"},{type:"bonus",subType:"deception"},{type:"bonus",subType:"history"},{type:"bonus",subType:"insight"},{type:"bonus",subType:"intimidation"},{type:"bonus",subType:"investigation"},{type:"bonus",subType:"medicine"},{type:"bonus",subType:"nature"},{type:"bonus",subType:"perception"},{type:"bonus",subType:"performance"},{type:"bonus",subType:"persuasion"},{type:"bonus",subType:"religion"},{type:"bonus",subType:"sleight-of-hand"},{type:"bonus",subType:"stealth"},{type:"bonus",subType:"survival"},{type:"advantage",subType:"acrobatics"},{type:"advantage",subType:"animal-handling"},{type:"advantage",subType:"arcana"},{type:"advantage",subType:"athletics"},{type:"advantage",subType:"deception"},{type:"advantage",subType:"history"},{type:"advantage",subType:"insight"},{type:"advantage",subType:"intimidation"},{type:"advantage",subType:"investigation"},{type:"advantage",subType:"medicine"},{type:"advantage",subType:"nature"},{type:"advantage",subType:"perception"},{type:"advantage",subType:"performance"},{type:"advantage",subType:"persuasion"},{type:"advantage",subType:"religion"},{type:"advantage",subType:"sleight-of-hand"},{type:"advantage",subType:"stealth"},{type:"advantage",subType:"survival"},{type:"bonus",subType:"passive-insight"},{type:"bonus",subType:"passive-investigation"},{type:"bonus",subType:"passive-perception"},{type:"advantage",subType:"initiative"},{type:"bonus",subType:"initiative"},{type:"bonus",subType:"strength-ability-checks"},{type:"bonus",subType:"dexterity-ability-checks"},{type:"bonus",subType:"constitution-ability-checks"},{type:"bonus",subType:"wisdom-ability-checks"},{type:"bonus",subType:"intelligence-ability-checks"},{type:"bonus",subType:"charisma-ability-checks"},{type:"bonus",subType:"strength-saving-throws"},{type:"bonus",subType:"dexterity-saving-throws"},{type:"bonus",subType:"constitution-saving-throws"},{type:"bonus",subType:"wisdom-saving-throws"},{type:"bonus",subType:"intelligence-saving-throws"},{type:"bonus",subType:"charisma-saving-throws"},{type:"bonus",subType:"weapon-attacks"},{type:"bonus",subType:"melee-attacks"},{type:"bonus",subType:"ranged-attacks"},{type:"bonus",subType:"melee-weapon-attacks"},{type:"bonus",subType:"ranged-weapon-attacks"},{type:"damage",subType:null},{type:"bonus",subType:"spell-save-dc"},{type:"bonus",subType:"spell-attacks"},{type:"bonus",subType:"melee-spell-attacks"},{type:"bonus",subType:"ranged-spell-attacks"},{type:"bonus",subType:"warlock-spell-save-dc"},{type:"bonus",subType:"warlock-spell-attacks"},{type:"bonus",subType:"druid-spell-save-dc"},{type:"bonus",subType:"druid-spell-attacks"},{type:"bonus",subType:"spell-group-healing"},{type:"bonus",subType:"hit-points-per-level"},{type:"bonus",subType:"hit-points"},{type:"set",subType:"attunement-slots"},{type:"resistance",subType:null},{type:"immunity",subType:null},{type:"vulnerability",subType:null}],senses:[{type:"set-base",subType:"darkvision"},{type:"sense",subType:"darkvision"},{type:"set-base",subType:"blindsight"},{type:"sense",subType:"blindsight"},{type:"set-base",subType:"tremorsense"},{type:"sense",subType:"tremorsense"},{type:"set-base",subType:"truesight"},{type:"sense",subType:"truesight"}],speedSet:[{type:"set",subType:"innate-speed-walking"},{type:"set",subType:"innate-speed-climbing"},{type:"set",subType:"innate-speed-swimming"},{type:"set",subType:"innate-speed-flying"}],speedBonus:[{type:"bonus",subType:"speed"},{type:"bonus",subType:"speed-walking"},{type:"bonus",subType:"speed-climbing"},{type:"bonus",subType:"speed-swimming"},{type:"bonus",subType:"speed-flying"}],speedMonk:[{type:"bonus",subType:"unarmored-movement"}],abilityBonus:[{type:"bonus",subType:"strength-score"},{type:"bonus",subType:"dexterity-score"},{type:"bonus",subType:"constitution-score"},{type:"bonus",subType:"wisdom-score"},{type:"bonus",subType:"intelligence-score"},{type:"bonus",subType:"charisma-score"},{type:"stacking-bonus",subType:"strength-score"},{type:"stacking-bonus",subType:"dexterity-score"},{type:"stacking-bonus",subType:"constitution-score"},{type:"stacking-bonus",subType:"wisdom-score"},{type:"stacking-bonus",subType:"intelligence-score"},{type:"stacking-bonus",subType:"charisma-score"}],proficiencyBonus:[{type:"proficiency",subType:null}],languages:[{type:"language",subType:null}],acBonus:[{type:"bonus",subType:"unarmored-armor-class"},{type:"bonus",subType:"armor-class"},{type:"bonus",subType:"armored-armor-class"},{type:"bonus",subType:"dual-wield-armor-class"}],ac:[{type:"set",subType:"unarmored-armor-class"},{type:"ignore",subType:"unarmored-dex-ac-bonus"},{type:"set",subType:"ac-max-dex-modifier"}]},vision5e:{"Detect Evil and Good":{effectName:"Detect Evil and Good",type:"spell",transfer:!1},Echolocation:{effectName:"Echolocation",type:"feat",transfer:!0},"Detect Thoughts":{effectName:"Detect Thoughts",type:"spell",transfer:!1},"Detect Magic":{effectName:"Detect Magic",type:"spell",transfer:!1},"Detect Poison and Disease":{effectName:"Detect Poison and Disease",type:"spell",transfer:!1},"Eldritch Invocations: Devil's Sight":{effectName:"Devil's Sight",type:"feat",transfer:!0},"Devil's Sight":{effectName:"Devil's Sight",type:"feat",transfer:!0},"See Invisibility":{effectName:"See Invisibility",type:"spell",transfer:!1},"Ghostly Gaze":{effectName:"Ghostly Gaze",type:"feat",transfer:!1}}},companions:o},d={BASE:"ddb.mrprimate.co.uk",PROXY:"https://proxy.ddb.mrprimate.co.uk",CORS:"https://images.ddb.mrprimate.co.uk/",DYNAMIC:"https://dynamic.ddb.mrprimate.co.uk"},c="ddb-importer";const u={MODULE_ID:"ddb-importer",FLAG_NAME:"ddbimporter",MODULE_NAME:"D&D Beyond Importer",DICTIONARY:l,COMPENDIUMS:s,SRD_COMPENDIUMS:[{type:"inventory",name:"dnd5e.items"},{type:"spells",name:"dnd5e.spells"},{type:"features",name:"dnd5e.classfeatures"},{type:"races",name:"dnd5e.races"},{type:"species",name:"dnd5e.races"},{type:"traits",name:"dnd5e.races"},{type:"features",name:"dnd5e.classfeatures"},{type:"feat",name:"dnd5e.classfeatures"},{type:"feats",name:"dnd5e.classfeatures"},{type:"classes",name:"dnd5e.classes"},{type:"subclasses",name:"dnd5e.subclasses"},{type:"weapon",name:"dnd5e.items"},{type:"consumable",name:"dnd5e.items"},{type:"tool",name:"dnd5e.items"},{type:"loot",name:"dnd5e.items"},{type:"container",name:"dnd5e.items"},{type:"spell",name:"dnd5e.spells"},{type:"equipment",name:"dnd5e.items"},{type:"monsters",name:"dnd5e.monsters"},{type:"monsterfeatures",name:"dnd5e.monsterfeatures"},{type:"backgrounds",name:"dnd5e.backgrounds"}],FOUNDRY_COMPENDIUM_MAP:{classes:["dnd5e.classes","dnd-tashas-cauldron.tcoe-character-options"],classes2024:["dnd-tashas-cauldron.tcoe-character-options","dnd-players-handbook.classes"],spells:["dnd5e.spells","dnd-tashas-cauldron.tcoe-character-options"],spells2024:["dnd-players-handbook.spells","dnd-tashas-cauldron.tcoe-character-options"],items:["dnd-tashas-cauldron.tcoe-magic-items"],items2024:["dnd-tashas-cauldron.tcoe-magic-items","dnd-players-handbook.equipment"]},FOUNDRY_COMPENDIUMS:{PHB2024:[{type:"inventory",name:"dnd-players-handbook.equipment"},{type:"spells",name:"dnd-players-handbook.spells"},{type:"features",name:"dnd-players-handbook.classes"},{type:"races",name:"dnd-players-handbook.origins"},{type:"species",name:"dnd-players-handbook.origins"},{type:"traits",name:"dnd-players-handbook.origins"},{type:"features",name:"dnd-players-handbook.classes"},{type:"feat",name:"dnd-players-handbook.feats"},{type:"feats",name:"dnd-players-handbook.feats"},{type:"classes",name:"dnd-players-handbook.classes"},{type:"subclasses",name:"dnd-players-handbook.classes"},{type:"weapon",name:"dnd-players-handbook.equipment"},{type:"consumable",name:"dnd-players-handbook.equipment"},{type:"tool",name:"dnd-players-handbook.equipment"},{type:"loot",name:"dnd-players-handbook.equipment"},{type:"container",name:"dnd-players-handbook.equipment"},{type:"spell",name:"dnd-players-handbook.spells"},{type:"equipment",name:"dnd-players-handbook.equipment"},{type:"backgrounds",name:"dnd-players-handbook.origins"}],TASHAS:[{type:"inventory",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"spells",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"features",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"races",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"species",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"traits",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"features",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"feat",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"feats",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"classes",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"subclasses",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"weapon",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"consumable",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"tool",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"loot",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"container",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"spell",name:"dnd-tashas-cauldron.tcoe-character-options"},{type:"equipment",name:"dnd-tashas-cauldron.tcoe-magic-items"},{type:"backgrounds",name:"dnd-tashas-cauldron.tcoe-character-options"}]},EFFECTS_IGNORE_FLAG_GROUPS:["dae","midi-qol","itemacro","itemmacro"],SUPPORTED_FLAG_GROUPS:["advancedspelleffects","arbron-summoner","autoanimations","automated-evocations","automated-polymorpher","boomingBladeChoice","cf","dae","enhancedcombathud","favtab","forien-unidentified-items","gm-notes","gng","greenFlameBladeChoice","GritNGlory","inventory-plus","itemacro","itemmacro","levels-3d-preview","maestro","mess","midi-qol","obsidian","siftoolkit","spell-class-filter-for-5e","tidy5e-sheet-kgar","spellbook-assistant-manager","tagger","tidy5e-sheet"],GAME_FOLDER_LOOKUPS:[{type:"itemSpells",folder:"magic-item-spells",itemType:"spell"},{type:"magicItems",folder:"magic-items",itemType:"item"},{type:"spells",folder:"spell",itemType:"spell"},{type:"monsters",folder:"npc",itemType:"actor"}],COMPENDIUM_REMOVE_FLAGS:["flags.ddbimporter.overrideId","flags.ddbimporter.ignoreItemImport","flags.ddbimporter.retainResourceConsumption","flags.ddbimporter.ignoreIcon"],ADVENTURE_FLAG:"isDDBAdventure",ADVENTURE_CSS:"ddbAdventure",NO_SOURCE_MATCH_IDS:[1,148],URLS:d,POPUPS:{json:null,web:null},DISABLE_FOUNDRY_UPGRADE:{applyFeatures:!1,addFeatures:!1,promptAddFeatures:!1},FILTER_SECTIONS:["classes","race","features","actions","inventory","spells"],MUNCH_DEFAULTS:[{name:"munching-policy-update-existing",needed:!0},{name:"munching-policy-use-srd",needed:!1},{name:"munching-policy-use-inbuilt-icons",needed:!0},{name:"munching-policy-use-srd-icons",needed:!1},{name:"munching-policy-use-srd-monster-images",needed:!1},{name:"munching-policy-download-images",needed:!0},{name:"munching-policy-remote-images",needed:!1},{name:"munching-policy-hide-description",needed:!1},{name:"munching-policy-monster-items",needed:!1},{name:"munching-policy-update-images",needed:!1}],DEFAULT_SETTINGS:{EARLY:{"log-level":{name:"ddb-importer.settings.log-level.name",hint:"ddb-importer.settings.log-level.hint",scope:"world",config:!0,type:String,choices:{VERBOSE:"VERBOSE",DEBUG:"DEBUG",INFO:"INFO",WARN:"WARN",ERR:"ERROR ",OFF:"OFF"},default:"INFO"},"show-munch-top":{name:"ddb-importer.settings.show-munch-top.name",hint:"ddb-importer.settings.show-munch-top.hint",scope:"world",config:!0,type:Boolean,default:!0},"patreon-tier":{scope:"world",config:!1,type:String,default:null},"custom-proxy":{name:"ddb-importer.settings.custom-proxy.name",hint:"ddb-importer.settings.custom-proxy.hint",scope:"world",config:!1,type:Boolean,default:!1,requiresReload:!0},"encounter-muncher-enabled":{scope:"world",config:!1,type:Boolean,default:!0,requiresReload:!0},"developer-mode":{scope:"world",config:!1,type:Boolean,default:!1},"add-ddb-languages":{name:"ddb-importer.settings.add-ddb-languages.name",hint:"ddb-importer.settings.add-ddb-languages.hint",scope:"world",config:!0,type:Boolean,default:!0},"register-source-books":{scope:"world",config:!1,type:Boolean,default:!0},"no-source-book-pages":{scope:"world",config:!1,type:Boolean,default:!0}},READY:{SETTINGS:{"auto-create-compendium":{type:Boolean,default:!0}},COMPENDIUMS:Object.fromEntries(s.map((e=>[e.setting,{name:e.title,type:String,default:`DDB ${e.title}`}]))),DIRECTORIES:{"image-upload-directory":{name:"ddb-importer.settings.image-upload-directory.name",hint:"ddb-importer.settings.image-upload-directory.hint",type:n.K.Directory,default:"[data] ddb-images/characters"},"other-image-upload-directory":{name:"ddb-importer.settings.other-image-upload-directory.name",hint:"ddb-importer.settings.other-image-upload-directory.hint",type:n.K.Directory,default:"[data] ddb-images/other"},"frame-image-upload-directory":{name:"ddb-importer.settings.frame-image-upload-directory.name",hint:"ddb-importer.settings.frame-image-upload-directory.hint",type:n.K.Directory,default:"[data] ddb-images/frames"},"adventure-upload-path":{name:"ddb-importer.settings.adventure-upload-path.name",hint:"ddb-importer.settings.adventure-upload-path.hint",default:"[data] ddb-images/adventures",type:n.K.Directory},"adventure-misc-path":{name:"ddb-importer.settings.adventure-misc-path.name",hint:"ddb-importer.settings.adventure-misc-path.hint",default:"[data] ddb-images/adventures/misc",type:n.K.Directory}},UI:{"monster-link-title":{name:"ddb-importer.settings.monster-link-title.name",hint:"ddb-importer.settings.monster-link-title.hint",config:!0,type:Boolean,default:!0},"character-link-title":{name:"ddb-importer.settings.character-link-title.name",hint:"ddb-importer.settings.character-link-title.hint",config:!0,type:Boolean,default:!1},"link-title-colour-white":{name:"ddb-importer.settings.link-title-colour-white.name",hint:"ddb-importer.settings.link-title-colour-white.hint",config:!0,type:Boolean,default:!1},"show-munch-top":{name:"ddb-importer.settings.show-munch-top.name",hint:"ddb-importer.settings.show-munch-top.hint",config:!0,type:Boolean,default:!0},"show-image-to-players":{name:"ddb-importer.settings.show-image-to-players.name",hint:"ddb-importer.settings.show-image-to-players.hint",config:!0,type:Boolean,default:!0},"show-read-alouds-button":{name:"ddb-importer.settings.show-read-alouds-button.name",hint:"ddb-importer.settings.show-read-alouds-button.hint",config:!0,type:Boolean,default:!0},"show-read-alouds-all-content":{name:"ddb-importer.settings.show-read-alouds-all-content.name",hint:"ddb-importer.settings.show-read-alouds-all-content.hint",config:!0,type:Boolean,default:!1}},PERMISSIONS:{"restrict-to-trusted":{name:"ddb-importer.settings.restrict-to-trusted.name",hint:"ddb-importer.settings.restrict-to-trusted.hint",config:!0,type:Boolean,default:!1},"allow-all-sync":{name:"ddb-importer.settings.allow-all-sync.name",hint:"ddb-importer.settings.allow-all-sync.hint",config:!0,type:Boolean,default:!1}},PARSING:{"show-resource-chooser-default":{name:"ddb-importer.settings.show-resource-chooser-default.name",hint:"ddb-importer.settings.show-resource-chooser-default.hint",config:!0,type:Boolean,default:!1},"add-damage-restrictions-to-hints":{name:"ddb-importer.settings.add-damage-restrictions-to-hints.name",hint:"ddb-importer.settings.add-damage-restrictions-to-hints.hint",config:!0,type:Boolean,default:!0},"embed-macros":{name:"ddb-importer.settings.embed-macros.name",hint:"ddb-importer.settings.embed-macros.hint",config:!0,type:Boolean,default:!0},"no-item-macros":{name:"ddb-importer.settings.no-item-macros.name",hint:"ddb-importer.settings.no-item-macros.hint",config:!0,type:Boolean,default:!0},"add-description-to-chat":{name:"ddb-importer.settings.add-description-to-chat.name",hint:"ddb-importer.settings.add-description-to-chat.hint",type:Boolean,default:!1},"use-loose-srd-reference-matching":{name:"ddb-importer.settings.use-loose-srd-reference-matching.name",hint:"ddb-importer.settings.use-loose-srd-reference-matching.hint",config:!0,type:Boolean,default:!0},"use-super-loose-srd-reference-matching":{config:!1,type:Boolean,default:!1},"append-chris-premade-effect-description":{name:"ddb-importer.settings.append-chris-premade-effect-description.name",hint:"ddb-importer.settings.append-chris-premade-effect-description.hint",config:!0,type:Boolean,default:!1},"spells-on-items-as-activities":{name:"ddb-importer.settings.spells-on-items-as-activities.name",hint:"ddb-importer.settings.spells-on-items-as-activities.hint",config:!1,type:Boolean,default:!1},"separate-ac-effects":{name:"ddb-importer.settings.separate-ac-effects.name",hint:"ddb-importer.settings.separate-ac-effects.hint",config:!1,type:Boolean,default:!0},"effects-uses-macro-status-effects":{name:"ddb-importer.settings.effects-uses-macro-status-effects.name",hint:"ddb-importer.settings.effects-uses-macro-status-effects.hint",config:!1,type:Boolean,default:!1}},MISC:{"use-webp":{name:"ddb-importer.settings.use-webp.name",hint:"ddb-importer.settings.use-webp.hint",type:Boolean,default:!1},"webp-quality":{name:"ddb-importer.settings.webp-quality.name",hint:"ddb-importer.settings.webp-quality.hint",type:Number,default:.9},"settings-call-muncher":{type:Boolean,default:!1},"update-check":{name:"ddb-importer.settings.update-check.name",config:!0,type:Boolean,default:!0},"use-deep-file-paths":{name:"ddb-importer.settings.use-deep-file-paths.name",hint:"ddb-importer.settings.use-deep-file-paths.hint",type:Boolean,default:!1}},CHARACTER:{ENHANCERS:{"allow-moon-druid-wildshape-enhancer":{type:Boolean,scope:"world",default:!0,config:!1,requiresReload:!0},"allow-arcane-ward-enhancer":{type:Boolean,scope:"world",default:!0,config:!1,requiresReload:!0},"allow-great-weapon-master-enhancer":{type:Boolean,scope:"world",default:!0,config:!1,requiresReload:!0}},IMPORT:{"character-update-policy-use-hp-max-for-rolled-hp":{type:Boolean,default:!1},"character-update-policy-create-companions":{scope:"player",type:Boolean,default:!0},"pact-spells-prepared":{type:Boolean,default:!1},"character-update-policy-add-character-effects":{scope:"player",type:Boolean,default:!1},"character-update-policy-add-item-effects":{scope:"player",type:Boolean,default:!1},"character-update-policy-add-spell-effects":{scope:"player",type:Boolean,default:!1},"character-update-policy-use-existing":{scope:"player",type:Boolean,default:!1},"character-update-policy-ignore-non-ddb-items":{scope:"player",type:Boolean,default:!1},"character-update-policy-use-override":{scope:"player",type:Boolean,default:!1},"character-update-policy-use-srd":{scope:"player",type:Boolean,default:!1},"character-update-policy-name":{scope:"player",type:Boolean,default:!0},"character-update-policy-hp":{scope:"player",type:Boolean,default:!0},"character-update-policy-hit-die":{scope:"player",type:Boolean,default:!0},"character-update-policy-class":{scope:"player",type:Boolean,default:!0},"character-update-policy-feat":{scope:"player",type:Boolean,default:!0},"character-update-policy-weapon":{scope:"player",type:Boolean,default:!0},"character-update-policy-equipment":{scope:"player",type:Boolean,default:!0},"character-update-policy-bio":{scope:"player",type:Boolean,default:!0},"character-update-policy-xp":{scope:"player",type:Boolean,default:!0},"character-update-policy-spell-use":{scope:"player",type:Boolean,default:!0},"character-update-policy-languages":{scope:"player",type:Boolean,default:!0},"character-update-policy-import-extras":{scope:"player",type:Boolean,default:!0},"character-update-policy-inventory":{scope:"player",type:Boolean,default:!0},"character-update-policy-currency":{scope:"player",type:Boolean,default:!0},"character-update-policy-spell":{scope:"player",type:Boolean,default:!0},"character-update-policy-image":{scope:"player",type:Boolean,default:!1},"character-update-policy-use-ddb-spell-icons":{scope:"player",type:Boolean,default:!0},"character-update-policy-use-ddb-generic-item-icons":{scope:"player",type:Boolean,default:!0},"character-update-policy-use-ddb-item-icons":{scope:"player",type:Boolean,default:!0},"character-update-policy-use-inbuilt-icons":{scope:"player",type:Boolean,default:!0},"character-update-policy-use-srd-icons":{scope:"player",type:Boolean,default:!1},"character-update-policy-use-combined-description":{scope:"player",type:Boolean,default:!1},"character-update-policy-dae-effect-copy":{scope:"player",type:Boolean,default:!1},"character-update-policy-active-effect-copy":{scope:"player",type:Boolean,default:!1},"character-update-policy-active-effect-character-copy":{scope:"player",type:Boolean,default:!1},"character-update-policy-use-chris-premades":{scope:"player",type:Boolean,default:!1},"character-update-policy-include-versatile-features":{scope:"player",type:Boolean,default:!1},"character-update-policy-remove-2024":{scope:"player",type:Boolean,default:!1},"character-update-policy-remove-legacy":{scope:"player",type:Boolean,default:!1},"character-update-policy-import-full-spell-list":{scope:"player",type:Boolean,default:!0},"character-update-policy-use-active-sources":{scope:"player",type:Boolean,default:!0},"character-update-policy-add-features-to-compendiums":{type:Boolean,default:!1},"character-update-policy-update-add-features-to-compendiums":{type:Boolean,default:!0}},SYNC:{"sync-policy-currency":{name:"ddb-importer.settings.sync-policy-currency.name",hint:"ddb-importer.settings.sync-policy-currency.hint",scope:"player",type:Boolean,default:!0},"sync-policy-hitpoints":{name:"ddb-importer.settings.sync-policy-hitpoints.name",hint:"ddb-importer.settings.sync-policy-hitpoints.hint",scope:"player",type:Boolean,default:!0},"sync-policy-hitdice":{name:"ddb-importer.settings.sync-policy-hitdice.name",hint:"ddb-importer.settings.sync-policy-hitdice.hint",scope:"player",type:Boolean,default:!0},"sync-policy-action-use":{name:"ddb-importer.settings.sync-policy-action-use.name",hint:"ddb-importer.settings.sync-policy-action-use.hint",scope:"player",type:Boolean,default:!0},"sync-policy-inspiration":{name:"ddb-importer.settings.sync-policy-inspiration.name",hint:"ddb-importer.settings.sync-policy-inspiration.hint",scope:"player",type:Boolean,default:!0},"sync-policy-condition":{name:"ddb-importer.settings.sync-policy-condition.name",hint:"ddb-importer.settings.sync-policy-condition.hint",scope:"player",type:Boolean,default:!0},"sync-policy-deathsaves":{name:"ddb-importer.settings.sync-policy-deathsaves.name",hint:"ddb-importer.settings.sync-policy-deathsaves.hint",scope:"player",type:Boolean,default:!0},"sync-policy-spells-prepared":{name:"ddb-importer.settings.sync-policy-spells-prepared.name",hint:"ddb-importer.settings.sync-policy-spells-prepared.hint",scope:"player",type:Boolean,default:!0},"sync-policy-spells-slots":{name:"ddb-importer.settings.sync-policy-spells-slots.name",hint:"ddb-importer.settings.sync-policy-spells-slots.hint",scope:"player",type:Boolean,default:!0},"sync-policy-spells-sync":{name:"ddb-importer.settings.sync-policy-spells-sync.name",hint:"ddb-importer.settings.sync-policy-spells-sync.hint",scope:"player",type:Boolean,default:!0},"sync-policy-equipment":{name:"ddb-importer.settings.sync-policy-equipment.name",hint:"ddb-importer.settings.sync-policy-equipment.hint",scope:"player",type:Boolean,default:!0},"sync-policy-xp":{name:"ddb-importer.settings.sync-policy-xp.name",hint:"ddb-importer.settings.sync-policy-xp.hint",scope:"player",type:Boolean,default:!0}},DYNAMIC_SYNC:{"dynamic-sync-policy-currency":{type:Boolean,default:!0},"dynamic-sync-policy-hitpoints":{type:Boolean,default:!0},"dynamic-sync-policy-hitdice":{type:Boolean,default:!0},"dynamic-sync-policy-action-use":{type:Boolean,default:!0},"dynamic-sync-policy-inspiration":{type:Boolean,default:!0},"dynamic-sync-policy-condition":{type:Boolean,default:!0},"dynamic-sync-policy-deathsaves":{type:Boolean,default:!0},"dynamic-sync-policy-spells-prepared":{type:Boolean,default:!0},"dynamic-sync-policy-spells-slots":{type:Boolean,default:!0},"dynamic-sync-policy-spells-sync":{type:Boolean,default:!0},"dynamic-sync-policy-equipment":{type:Boolean,default:!0},"dynamic-sync-policy-xp":{type:Boolean,default:!0}}},MUNCHER:{COMPENDIUM_FOLDERS:{"top-level-compendium-folder":{name:"ddb-importer.settings.top-level-compendium-folder.name",hint:"ddb-importer.settings.top-level-compendium-folder.hint",config:!0,type:Boolean,default:!0},"munching-selection-compendium-folders-monster":{name:"ddb-importer.settings.munching-selection-compendium-folders-monster.name",hint:"ddb-importer.settings.munching-selection-compendium-folders-monster.hint",config:!0,type:String,choices:{TYPE:"Creature type, e.g. Undead",CR:"Challenge Rating",ALPHA:"Alphabetical"},default:"TYPE"},"munching-selection-compendium-folders-spell":{name:"ddb-importer.settings.munching-selection-compendium-folders-spell.name",hint:"ddb-importer.settings.munching-selection-compendium-folders-spell.hint",config:!0,type:String,choices:{SCHOOL:"School of Magic",LEVEL:"Level"},default:"LEVEL"},"munching-selection-compendium-folders-item":{name:"ddb-importer.settings.munching-selection-compendium-folders-item.name",hint:"ddb-importer.settings.munching-selection-compendium-folders-item.hint",config:!0,type:String,choices:{TYPE:"Item Type",RARITY:"Rarity"},default:"TYPE"}},ADVENTURE:{"adventure-policy-all-scenes":{type:Boolean,default:!0},"adventure-policy-all-actors-into-world":{type:Boolean,default:!1},"adventure-policy-journal-world-actors":{type:Boolean,default:!1},"adventure-policy-add-to-compendiums":{type:Boolean,default:!1}},MUNCH:{"munching-policy-update-existing":{type:Boolean,default:!1},"munching-policy-delete-during-update":{type:Boolean,default:!1},"munching-policy-use-srd":{scope:"player",type:Boolean,default:!1},"munching-policy-exclude-legacy":{type:Boolean,default:!0},"munching-policy-legacy-postfix":{type:Boolean,default:!0},"munching-policy-use-srd-icons":{name:"ddb-importer.settings.munching-policy-use-srd-icons.name",hint:"ddb-importer.settings.munching-policy-use-srd-icons.hint",type:Boolean,default:!1},"munching-policy-use-inbuilt-icons":{name:"ddb-importer.settings.munching-policy-use-inbuilt-icons.name",hint:"ddb-importer.settings.munching-policy-use-inbuilt-icons.hint",type:Boolean,default:!0},"munching-policy-use-ddb-item-icons":{name:"ddb-importer.settings.munching-policy-use-ddb-item-icons.name",hint:"ddb-importer.settings.munching-policy-use-ddb-item-icons.hint",type:Boolean,default:!0},"munching-policy-use-ddb-spell-icons":{name:"ddb-importer.settings.munching-policy-use-ddb-spell-icons.name",hint:"ddb-importer.settings.munching-policy-use-ddb-spell-icons.hint",type:Boolean,default:!0},"munching-policy-use-ddb-generic-item-icons":{name:"ddb-importer.settings.munching-policy-use-ddb-generic-item-icons.name",hint:"ddb-importer.settings.munching-policy-use-ddb-generic-item-icons.hint",type:Boolean,default:!0},"munching-policy-use-full-token-image":{name:"ddb-importer.settings.munching-policy-use-full-token-image.name",hint:"ddb-importer.settings.munching-policy-use-full-token-image.hint",type:Boolean,default:!1},"munching-policy-use-token-avatar-image":{name:"ddb-importer.settings.munching-policy-use-token-avatar-image.name",hint:"ddb-importer.settings.munching-policy-use-token-avatar-image.hint",type:Boolean,default:!1},"munching-policy-remote-images":{name:"ddb-importer.settings.munching-policy-remote-images.name",hint:"ddb-importer.settings.munching-policy-remote-images.hint",type:Boolean,default:!0},"munching-policy-add-effects":{name:"ddb-importer.settings.munching-policy-add-effects.name",hint:"ddb-importer.settings.munching-policy-add-effects.hint",type:Boolean,default:!0},"munching-policy-add-spell-effects":{type:Boolean,default:!1},"munching-policy-add-monster-effects":{type:Boolean,default:!1},"munching-policy-download-images":{name:"ddb-importer.settings.munching-policy-download-images.name",hint:"ddb-importer.settings.munching-policy-download-images.hint",type:Boolean,default:!1},"munching-policy-use-chris-premades":{type:Boolean,default:!1},"munching-policy-hide-description":{name:"ddb-importer.settings.munching-policy-hide-description.name",hint:"ddb-importer.settings.munching-policy-hide-description.hint",type:Boolean,default:!1},"munching-policy-hide-item-name":{name:"ddb-importer.settings.munching-policy-hide-item-name.name",hint:"ddb-importer.settings.munching-policy-hide-item-name.hint",type:Boolean,default:!1},"munching-policy-hide-description-choice":{name:"ddb-importer.settings.munching-policy-hide-description-choice.name",hint:"ddb-importer.settings.munching-policy-hide-description-choice.hint",type:String,choices:{NAME:"Monster's name e.g. Goblin",TYPE:"Monster's type e.g. Abomination",MONSTER:'The word "Monster"',NPC:'The word "NPC"'},default:"NAME"},"munching-policy-monster-items":{name:"ddb-importer.settings.munching-policy-monster-items.name",hint:"ddb-importer.settings.munching-policy-monster-items.hint",type:Boolean,default:!1},"munching-policy-monster-homebrew":{name:"ddb-importer.settings.munching-policy-monster-homebrew.name",hint:"ddb-importer.settings.munching-policy-monster-homebrew.hint",type:Boolean,default:!1},"munching-policy-monster-homebrew-only":{name:"ddb-importer.settings.munching-policy-monster-homebrew-only.name",hint:"ddb-importer.settings.munching-policy-monster-homebrew-only.hint",type:Boolean,default:!1},"munching-policy-monster-tokenize":{type:Boolean,default:!1},"munching-policy-use-srd-monster-images":{type:Boolean,default:!1},"munching-policy-update-images":{name:"ddb-importer.settings.munching-policy-update-images.name",hint:"ddb-importer.settings.munching-policy-update-images.hint",type:Boolean,default:!0},"munching-policy-monster-exact-match":{name:"ddb-importer.settings.munching-policy-monster-match.name",hint:"ddb-importer.settings.munching-policy-monster-match.hint",type:Boolean,default:!1},"munching-policy-size-flat-scale":{type:Boolean,default:!0},"munching-policy-use-source-filter":{type:Boolean,default:!1},"munching-policy-muncher-sources":{type:Array,default:[]},"munching-policy-monster-use-item-ac":{type:Boolean,default:!0},"munching-policy-monster-retain-biography":{type:Boolean,default:!1},"munching-policy-monster-set-legendary-resource-bar":{type:Boolean,default:!0},"munching-policy-update-world-monster-update-images":{type:Boolean,default:!0},"munching-policy-update-world-monster-retain-biography":{type:Boolean,default:!0},"munching-policy-monster-strip-name":{type:Boolean,default:!0},"munching-policy-item-homebrew":{type:Boolean,default:!1},"munching-policy-item-homebrew-only":{type:Boolean,default:!1},"munching-policy-spell-homebrew":{type:Boolean,default:!1},"munching-policy-spell-homebrew-only":{type:Boolean,default:!1},"munching-policy-use-generic-items":{type:Boolean,default:!1}},ENCOUNTER:{"encounter-import-policy-create-scene":{type:Boolean,default:!0},"encounter-import-policy-existing-scene":{type:Boolean,default:!1},"encounter-import-policy-missing-characters":{type:Boolean,default:!0},"encounter-import-policy-missing-monsters":{type:Boolean,default:!0},"encounter-import-policy-create-journal":{type:Boolean,default:!0},"encounter-import-policy-roll-monster-initiative":{type:Boolean,default:!1},"encounter-import-policy-use-ddb-save":{type:Boolean,default:!1}}},DYNAMIC_SYNC:{"dynamic-sync":{type:Boolean,default:!1,requiresReload:!0},"dynamic-sync-user":{type:String,default:"",requiresReload:!0}},PROXY:{"api-endpoint":{type:String,default:"http://localhost:3000",requiresReload:!0},"cors-endpoint":{type:String,default:d.CORS,requiresReload:!0},"dynamic-api-endpoint":{type:String,default:d.DYNAMIC,requiresReload:!0},"cors-encode":{type:Boolean,default:!1},"cors-strip-protocol":{type:Boolean,default:!0},"cors-path-prefix":{type:String,default:"ddb/"},"beta-key":{type:String,default:""},"patreon-user":{type:String,default:null},"cobalt-cookie":{name:"ddb-importer.settings.cobalt-cookie.name",hint:"ddb-importer.settings.cobalt-cookie.hint",type:String,default:""},"cobalt-cookie-local":{name:"ddb-importer.settings.cobalt-cookie-local.name",hint:"ddb-importer.settings.cobalt-cookie-local.hint",type:Boolean,default:!0},"campaign-id":{name:"ddb-importer.settings.campaign-id.name",hint:"ddb-importer.settings.campaign-id.hint",type:String,default:""}},DEV:{"allow-scene-download":{type:Boolean,default:!1},"allow-third-party-scene-download":{type:Boolean,default:!1},"third-party-scenes-partial":{type:Boolean,default:!1},"third-party-scenes-notes-merged":{type:Boolean,default:!0},"allow-note-generation":{type:Boolean,default:!1},"debug-json":{scope:"player",type:Boolean,default:!1},"adventure-muncher-full-config":{type:Boolean,default:!1}}}},APPLY_GLOBAL_DEFAULTS(e){for(const[t,a]of Object.entries(e))e[t]=foundry.utils.mergeObject({scope:"world",config:!1},a);return e},GET_DEFAULT_SETTINGS(e=!1){const t=foundry.utils.deepClone(u.DEFAULT_SETTINGS),a=!e&&"undefined"!=typeof ForgeVTT&&ForgeVTT?.usingTheForge?"[forgevtt]":"[data]";for(const[e,i]of Object.entries(t.READY.DIRECTORIES))t.READY.DIRECTORIES[e].default=i.default.replace("[data]",a);let i=e?t.EARLY:{...t.READY.DEV,...t.READY.SETTINGS,...t.READY.PROXY,...t.READY.COMPENDIUMS,...t.READY.DIRECTORIES,...t.READY.UI,...t.READY.PERMISSIONS,...t.READY.PARSING,...t.READY.MISC,...t.READY.CHARACTER.IMPORT,...t.READY.CHARACTER.ENHANCERS,...t.READY.CHARACTER.SYNC,...t.READY.DYNAMIC_SYNC,...t.READY.CHARACTER.DYNAMIC_SYNC,...t.READY.MUNCHER.COMPENDIUM_FOLDERS,...t.READY.MUNCHER.ADVENTURE,...t.READY.MUNCHER.MUNCH,...t.READY.MUNCHER.ENCOUNTER};return u.APPLY_GLOBAL_DEFAULTS(i)},STATUS:{activeUpdate:function activeUpdate(){const e=i.PatreonHelper.calculateAccessMatrix(i.PatreonHelper.getPatreonTier());if(!(e.god||e.undying||e.experimentalMid))return!1;const t=game.settings.get(c,"dynamic-sync"),a=game.settings.get(c,"dynamic-sync-user"),n=game.user.isGM&&game.user.id==a;return t&&n}}},m=u},391:(e,t,a)=>{a.d(t,{uO:()=>DDBEffectHelper,Iq:()=>DDBEnhancers,ij:()=>i,Qs:()=>ExternalAutomations});var i={};a.r(i),a.d(i,{r:()=>ChrisPremadesHelper,Q:()=>ExternalAutomations});var n=a(115),s=a(421);class ChrisPremadesHelper{static DDB_FLAGS_TO_REMOVE=["midi-qol","midiProperties","ActiveAuras","dae","itemacro"];static CP_FLAGS_TO_REMOVE=["cf","ddbimporter","monsterMunch","core","link-item-resource-5e"];static CP_FIELDS_TO_COPY=["effects","system.damage","system.target","system.range","system.duration","system.save","system.activation","system.ability","system.critical","system.formula","system.actionType","system.scaling"];static CP_COMPENDIUM_TYPES=[{type:"spell",system:"spell"},{type:"feat",system:"feature"},{type:"feat",system:"trait"},{type:"feat",system:"feat"},{type:"equipment",system:"inventory"},{type:"weapon",system:"weapon"},{type:"consumable",system:"consumable"},{type:"tool",system:"tool"},{type:"loot",system:"loot"},{type:"equipment",system:"container"},{type:"equipment",system:"backback"},{type:"equipment",system:"equipment"}];static async getChrisCompendiumIndex(e,t={}){const a=s.CompendiumHelper.getCompendium(e);return await a.getIndex({fields:["name","type","flags.cf","folder"].concat(Object.keys(t))})}static async getChrisCompendiums(e,t=!1,a={}){if(chrisPremades.helpers.getSearchCompendiums){const i=ChrisPremadesHelper.CP_COMPENDIUM_TYPES.find((t=>t.system===e))?.type??e,n=(t?chrisPremades.helpers.getMonsterFeatureSearchCompendiums?chrisPremades.helpers.getMonsterFeatureSearchCompendiums():["chris-premades.CPR Monster Features"]:[]).concat(await chrisPremades.helpers.getSearchCompendiums(i));return(await Promise.all(n.filter((e=>game.packs.get(e))).map((async e=>({index:(await ChrisPremadesHelper.getChrisCompendiumIndex(e,a)).filter((e=>e.type===i)),packName:e,compendium:game.packs.get(e)}))))).filter((e=>e.index.length>0))}return[]}static getOriginalName(e,t=!1){const a=e.flags.ddbimporter?.originalName??e.name,i=a.replace(/[–-–−]/g,"-").match(/(.*)\s*\((:?costs \d actions|\d\/Turn|Recharges after a Short or Long Rest|\d\/day|recharge \d-\d)\)/i),n=i?i[1].trim():a;return t?n.split(":")[0].trim():n}static getTypeMatch(e,t=!1){if(n.x.types.inventory.includes(e.type))return"inventory";if("feat"!==e.type)return e.type;if(t)return"monsterfeature";const a=foundry.utils.getProperty(e,"system.type.value");if(a&&""!==a)return"class"===a?"feature":"race"===a?"trait":a;const i=foundry.utils.getProperty(e,"flags.ddbimporter.type");return i&&!["","other"].includes(i)?"class"===i?"feature":"race"===i?"trait":i:"feat"===e.type?"feature":e.type}static async getDocumentFromCompendium(e,t,a,i,n={}){const r=game.packs.get(e);if(!r)return ui.notifications.warn("Invalid compendium specified!"),!1;const o=await r.getIndex({fields:["name","type","folder"].concat(Object.keys(n))}),l=o.find((e=>e.name===t&&(!i||i&&e.folder===i)&&(0===Object.keys(n).length||s.utils.matchProperties(e,n))));return s.logger.debug(`Looking for ${t} in ${e} with properties`,{key:e,name:t,ignoreNotFound:a,folderId:i,matchedProperties:n,match:l,packIndex:o}),l?(await r.getDocument(l._id))?.toObject():void(a||(ui.notifications.warn(`Item not found in compendium ${e} with name ${t}! Check spelling?`),s.logger.warn(`Item not found in compendium ${e} with name ${t}! Check spelling?`,{key:e,name:t,folderId:i,matchedProperties:n})))}static async getDocumentFromName(e,t,{folderName:a=null,isMonster:i=!1,matchedProperties:n={}}={}){const r=await ChrisPremadesHelper.getChrisCompendiums(t,i);if(0!==r.length){for(const t of r){const r=i?await s.FolderHelper.getCompendiumFolderId(a??e,t.packName):void 0;if(a&&void 0===r){s.logger.debug(`No folder found for ${a} and ${e}, checking compendium name ${t.packName}`);continue}s.logger.debug(`CP Effect (From Name): Attempting to fetch ${e} from ${t.packName} with folderID ${r}`);const o=t.index.find((t=>t.name===e&&(!r||r&&t.folder===r)&&(0===Object.keys(n).length||s.utils.matchProperties(t,n))));if(o)return o}s.logger.debug(`No CP Effect found for ${e} from all matched compendiums with folderName ${a}`)}else s.logger.warn(`No compendium found for Chris's Premade effect for ${t} and ${e}, with type ${t}!`)}constructor(e,{chrisNameOverride:t=null,isMonster:a=!1,folderName:i=null,ignoreNotFound:s=!0,type:r=null,matchedProperties:o={}}={}){this.original=foundry.utils.deepClone(e),this.document=e,this.chrisNameOverride=t,this.isMonster=a,this.folderName=i,this.ignoreNotFound=s,this.type=r??ChrisPremadesHelper.getTypeMatch(e,a),this.matchProperties=o,this.ddbName=ChrisPremadesHelper.getOriginalName(e),this.chrisName=t??CONFIG.chrisPremades?.renamedItems[this.ddbName]??this.ddbName,this.chrisDoc=null,this.appendChrisDescription=game.settings.get(n.y.MODULE_ID,"append-chris-premade-effect-description")}async findReplacement(){const e=await ChrisPremadesHelper.getChrisCompendiums(this.original.type,this.isMonster);if(s.logger.debug("Compendiums found",{compendiums:e,this:this,type:this.original.type,isMonster:this.isMonster}),0===e.length)return void s.logger.warn(`No compendium found for Chris's Premade effect for "${this.original.name}" with original type ${this.original.type} and with type object type ${this.type}!`,{this:this});const t=["weapon","feat"].includes(this.original.type)&&this.isMonster;for(const a of e){const e=t?await s.FolderHelper.getCompendiumFolderId(this.folderName??this.chrisName,a.packName):void 0;if(t&&void 0===e){s.logger.debug(`Needed folder, but none found for ${this.folderName} and ${this.original.name}, using compendium name ${a.packName}`);continue}s.logger.debug(`CP Effect (find replacement): Attempting to fetch ${this.original.name} from ${a.packName} with folderID ${e}`);const i=await ChrisPremadesHelper.getDocumentFromCompendium(a.packName,this.chrisName,this.ignoreNotFound,e,this.matchedProperties);if(!i)continue;const n=ChrisPremadesHelper.getTypeMatch(i,this.isMonster);if(s.logger.debug("Found",{thisType:this.type,chrisType:n,chrisDoc:i,truthy:this.type===n}),this.type===n||e)return this.chrisDoc=i,i;s.logger.debug(`Skipping CP Effect found for ${this.original.name} from ${a.packName} with folderName ${this.folderName} as type mismatch`)}s.logger.debug(`No CP Effect found for ${this.original.name} from all matched compendiums with folderName ${this.folderName}`)}static appendDescription(e,t){const a=foundry.utils.getProperty(e,"system.description");if(!a||""===a.value.trim())return t;const i=a.value;i&&""!==i.trim()&&(t.system.description.value+=`\n<br>\n<section class="secret">\n<hr>\n<h5>Automation notes - Chris's Premades (CPR):</h5>\n${i}\n</section>`);const n=a.chat;return n&&""!==n.trim()&&(t.system.description.chat+=`\n<br>\n<section class="secret">\n<hr>\n<h5>Automation notes - Chris's Premades (CPR):</h5>\n${n}\n</section>`),t}static copyDescription(e,t,{appendSourceDescription:a=!1,prependSourceDescription:i=!1}={}){const n=foundry.utils.getProperty(e,"system.description");if(!n||""===n.value.trim())return t;if(a)ChrisPremadesHelper.appendDescription(e,t);else if(i){const a=foundry.utils.deepClone(t),i=foundry.utils.getProperty(e,"flags.ddbimporter.initialFeature")??foundry.utils.getProperty(e,"system.description");a.system.description=foundry.utils.deepClone(foundry.utils.getProperty(t,"system.description")),t.system.description=foundry.utils.deepClone(i),ChrisPremadesHelper.appendDescription(a,t)}else t.system.description=foundry.utils.deepClone(n);return t}updateOriginalDocument(){ChrisPremadesHelper.DDB_FLAGS_TO_REMOVE.forEach((e=>{delete this.document.flags[e]})),this.document.effects=[],ChrisPremadesHelper.CP_FLAGS_TO_REMOVE.forEach((e=>{delete this.chrisDoc.flags[e]})),this.document.flags=foundry.utils.mergeObject(this.document.flags,this.chrisDoc.flags),ChrisPremadesHelper.CP_FIELDS_TO_COPY.forEach((e=>{const t=foundry.utils.getProperty(this.chrisDoc,e);"effects"===e&&t.forEach((e=>{e._id=foundry.utils.randomID()})),foundry.utils.setProperty(this.document,e,t)})),this.appendChrisDescription&&ChrisPremadesHelper.appendDescription(this.chrisDoc,this.document),foundry.utils.setProperty(this.document,"flags.ddbimporter.effectsApplied",!0),foundry.utils.setProperty(this.document,"flags.ddbimporter.chrisEffectsApplied",!0),foundry.utils.setProperty(this.document,"flags.ddbimporter.chrisPreEffectName",this.ddbName);const e=foundry.utils.getProperty(CONFIG,`chrisPremades.correctedItems.${this.chrisName}`);e&&(s.logger.debug(`Updating ${this.original.name} with a Chris correction properties`),this.document=foundry.utils.mergeObject(this.document,e)),s.logger.debug(`Updated ${this.original.name} with a Chris effect`),delete this.document.folder}static async find({document:e,type:t,isMonster:a=!1,folderName:i=null,chrisNameOverride:n=null}={}){if(!game.modules.get("chris-premades")?.active)return e;if(!0===foundry.utils.getProperty(e,"flags.ddbimporter.ignoreItemForChrisPremades"))return s.logger.info(`${e.name} set to ignore Chris's Premade effect application`),e;const r=new ChrisPremadesHelper(e,{type:t,chrisNameOverride:n,folderName:i,ignoreNotFound:!0,isMonster:a}),o=await r.findReplacement();return o?o.document:e}static async findAndUpdate({document:e,type:t,isMonster:a=!1,folderName:i=null,chrisNameOverride:n=null}={}){if(!game.modules.get("chris-premades")?.active)return e;if(!0===foundry.utils.getProperty(e,"flags.ddbimporter.ignoreItemForChrisPremades"))return s.logger.info(`${e.name} set to ignore Chris's Premade effect application`),e;const r=new ChrisPremadesHelper(e,{type:t,chrisNameOverride:n,folderName:i,ignoreNotFound:!0,isMonster:a});return await r.findReplacement()?(r.updateOriginalDocument(),r.document):e}static async addAndReplaceRedundantChrisDocuments(e,t=null){if(!game.modules.get("chris-premades")?.active)return;s.logger.debug("Beginning additions and removals of extra effects.");const a=e.getEmbeddedCollection("Item").toObject(),i=[],n=new Set,r=foundry.utils.getProperty(CONFIG,"chrisPremades.removeChoices")??[],o=new Set;for(let e of a){if(["class","subclass","background"].includes(e.type))continue;const t=ChrisPremadesHelper.getOriginalName(e),l=CONFIG.chrisPremades?.renamedItems[t]??t,d=t.split(":")[0].trim(),c=new Set(foundry.utils.getProperty(CONFIG,`chrisPremades.additionalItems.${l}`)??[]);if(t!==d){const e=foundry.utils.getProperty(CONFIG,`chrisPremades.additionalItems.${d}`);e&&!o.has(d)&&(e.forEach((e=>c.add(e))),o.add(d))}if(c.size>0){s.logger.debug(`Adding new items for ${l}`);for(const n of c){s.logger.debug(`Adding new item ${n}`);const r=await ChrisPremadesHelper.getDocumentFromName(n,e.type);r?a.some((e=>e.name===r.name))||(ChrisPremadesHelper.copyDescription(e,r,{prependSourceDescription:this.appendDescription}),foundry.utils.setProperty(r,"flags.ddbimporter.ignoreItemUpdate",!0),i.push(r)):s.logger.error(`DDB Importer expected to find an item in Chris's Premades for ${n} but did not`,{ddbName:t,doc:e,chrisName:l,newItemNames:c,documents:a,chrisDoc:r})}}const u=new Set(foundry.utils.getProperty(CONFIG,`chrisPremades.removedItems.${l}`)??[]);if(r.includes(d)&&u.add(t),u.size>0){s.logger.debug(`Removing items for ${l}`);for(const e of u){s.logger.debug(`Removing item ${e}`);const t=a.find((t=>ChrisPremadesHelper.getOriginalName(t)===e));t&&n.add(t._id)}}}s.logger.debug("Final Chris's Premades list",{toDelete:n,toAdd:i}),await e.deleteEmbeddedDocuments("Item",Array.from(n)),await e.createEmbeddedDocuments("Item",i)}static async restrictedItemReplacer(e,t=null){if(!game.modules.get("chris-premades")?.active)return;s.logger.debug("Beginning additions and removals of restricted effects.");const a=e.getEmbeddedCollection("Item").toObject(),i=foundry.utils.getProperty(CONFIG,"chrisPremades.restrictedItems"),r=Object.keys(i).map((e=>{const t=i[e];return t.key=e,t})).sort(((e,t)=>(e.priority??0)-(t.priority??0))),o=[],l=new Set;for(const i of r){s.logger.debug(`Checking restricted Item ${i.key}: ${i.originalName}`);const r=a.find((e=>{const t=e.flags.ddbimporter?.chrisPreEffectName??ChrisPremadesHelper.getOriginalName(e),a=!0===foundry.utils.getProperty(document,"flags.ddbimporter.ignoreItemForChrisPremades");return t===i.originalName&&!a}));if(!r)continue;if(["class","subclass","background"].includes(r.type))continue;const d=r.flags.ddbimporter?.chrisPreEffectName??ChrisPremadesHelper.getOriginalName(r),c=e.getRollData();if(!i.requiredClass||c.classes[i.requiredClass.toLowerCase()]){if(i.requiredSubclass){const e=c.classes[i.requiredClass.toLowerCase()].subclass;if(!e)continue;if(e.parent.name.toLowerCase()!==i.requiredSubclass.toLowerCase())continue}if(!i.requiredRace||i.requiredRace.toLocaleLowerCase()===(c.details.race?.name??c.details?.race)?.toLocaleLowerCase()){if(i.requiredEquipment){if(!i.requiredEquipment.every((e=>a.some((t=>(t.flags.ddbimporter?.chrisPreEffectName??ChrisPremadesHelper.getOriginalName(t))===e&&n.x.types.inventory.includes(t.type))))))continue}if(i.requiredFeatures){if(!i.requiredFeatures.every((e=>a.some((t=>(t.flags.ddbimporter?.chrisPreEffectName??ChrisPremadesHelper.getOriginalName(t))===e&&"feat"===t.type)))))continue}if(i.replacedItemName&&""!==i.replacedItemName){s.logger.debug(`Replacing item data for ${d}, using restricted data from ${i.key}`);const a=await ChrisPremadesHelper.findAndUpdate({document:foundry.utils.duplicate(r),folderName:t,chrisNameOverride:i.replacedItemName});a&&(await e.deleteEmbeddedDocuments("Item",[r._id]),await e.createEmbeddedDocuments("Item",[a],{keepId:!0}))}if(i.additionalItems&&i.additionalItems.length>0){s.logger.debug(`Adding new items for ${d}, using restricted data from ${i.key}`);const e=a.find((e=>e.name===d));if(e)for(const t of i.additionalItems){s.logger.debug(`Adding new item ${t}`);const n=await ChrisPremadesHelper.getDocumentFromName(t,e.type);n?a.some((e=>e.name===n.name))||(foundry.utils.setProperty(n,"flags.ddbimporter.ignoreItemUpdate",!0),o.push(n)):s.logger.error(`DDB Importer expected to find an item in Chris's Premades for ${t} but did not`,{ddbName:d,doc:e,additionalItems:i.additionalItems,documents:a,chrisDoc:n})}}if(i.removedItems&&i.removedItems.length>0){s.logger.debug(`Removing items for ${d}, using restricted data from ${i.key}`);for(const e of i.removedItems){s.logger.debug(`Removing item ${e}`);const t=a.find((t=>ChrisPremadesHelper.getOriginalName(t)===e));t&&l.add(t._id)}}}}}s.logger.debug("Adding and removing the following restricted Chris's Premades",{toDelete:l,toAdd:o}),await e.deleteEmbeddedDocuments("Item",Array.from(l)),await e.createEmbeddedDocuments("Item",o)}}class ExternalAutomations{constructor(e){this.actor=e;const t=game.settings.get("ddb-importer","dynamic-sync"),a=game.settings.get("ddb-importer","dynamic-sync-user"),i=game.user.isGM&&game.user.id==a,n=s.PatreonHelper.getPatreonTier(),r=s.PatreonHelper.calculateAccessMatrix(n);this.dynamicUpdateAllowed=t&&i&&r?.experimentalMid,this.dynamicUpdateStatus=this.actor.flags?.ddbimporter?.activeUpdate}getCurrentDynamicUpdateState(){return this.actor.flags?.ddbimporter?.activeUpdate??!1}async disableDynamicUpdates(){if(!this.dynamicUpdateStatus)return;await this.actor.update({flags:{ddbimporter:{activeUpdate:!1}}})}async enableDynamicUpdates(){if(!this.dynamicUpdateStatus)return;await this.actor.update({flags:{ddbimporter:{activeUpdate:!0}}})}static async applyChrisPremadeEffect({document:e,type:t,isMonster:a=!1,folderName:i=null,chrisNameOverride:n=null}={}){return ChrisPremadesHelper.findAndUpdate({document:e,type:t,folderName:i,chrisNameOverride:n,isMonster:a})}static async applyChrisPremadeEffects({documents:e,compendiumItem:t=!1,force:a=!1,isMonster:i=!1,folderName:r=null}={}){if(!game.modules.get("chris-premades")?.active)return s.logger.debug("Chris Premades not active"),e;if(!(a||(t?game.settings.get(n.y.MODULE_ID,"munching-policy-use-chris-premades"):game.settings.get(n.y.MODULE_ID,"character-update-policy-use-chris-premades"))))return s.logger.debug("Not Applying basic premades"),e;for(let t of e){if(["class","subclass","background"].includes(t.type))continue;const e=ChrisPremadesHelper.getTypeMatch(t,i);s.logger.debug(`Evaluating ${t.name} of type ${e} for Chris's Premade application.`,{type:e,folderName:r,isMonster:i}),t=await ChrisPremadesHelper.findAndUpdate({document:t,type:e,folderName:r,isMonster:i}),i&&!["monsterfeature"].includes(e)&&!0==!foundry.utils.getProperty(t,"flags.ddbimporter.effectsApplied")&&(s.logger.debug(`No Chris' Premade found for ${t.name} with type "${e}", checking for monster feature.`),t=await ChrisPremadesHelper.findAndUpdate({document:t,type:"monsterfeature",folderName:r,isMonster:i}))}return e}static async addChrisEffectsToActorDocuments(e){if(!game.modules.get("chris-premades")?.active)return ui.notifications.error("Chris Premades module not installed"),[];const t=new ExternalAutomations(e);await t.disableDynamicUpdates(),s.logger.info("Starting to update actor documents with Chris Premades effects");let a=e.getEmbeddedCollection("Item").toObject();const i="npc"===e.type,n=i?e.name:null,r=(await ExternalAutomations.applyChrisPremadeEffects({documents:a,compendiumItem:!1,force:!0,folderName:n,isMonster:i})).filter((e=>!0===foundry.utils.getProperty(e,"flags.ddbimporter.chrisEffectsApplied")&&!foundry.utils.hasProperty(e,"flags.items-with-spells-5e.item-spells.parent-item"))),o=r.map((e=>e._id));return s.logger.debug("Chris premades generation complete, beginning replace",{isMonster:i,folderName:n,data:r,dataIds:o,actor:e,documents:a}),await e.deleteEmbeddedDocuments("Item",o),s.logger.debug("Chris premades, deletion complete"),s.logger.debug("Creating chris premade items",r),await e.createEmbeddedDocuments("Item",r,{keepId:!0}),s.logger.debug("Delete and recreate complete, beginning restricted item replacer"),await ChrisPremadesHelper.restrictedItemReplacer(e,n),s.logger.debug("Restricted item replacer complete, beginning Replacement of Redundant Chris Documents"),await ChrisPremadesHelper.addAndReplaceRedundantChrisDocuments(e),s.logger.info("Effect replacement complete"),await t.enableDynamicUpdates(),r.map((e=>e.name))}}var r=a(791),o=a(37),l=a(382),d=a(111);class DDBEffectHelper{static baseEffect=d.AutoEffects.BaseEffect;static Crosshairs=s.Crosshairs;static generateDAEStatusEffectChange=d.ChangeHelper.daeStatusEffectChange;static addStatusEffectChange=d.ChangeHelper.addStatusEffectChange;static generateTokenMagicFXChange=d.ChangeHelper.tokenMagicFXChange;static generateATLChange=d.ChangeHelper.atlChange;static getMonsterFeatureDamage(e,t=null){const a=foundry.utils.getProperty(t,"flags.monsterMunch.actionInfo.damage");if(a)return a;s.logger.debug("Monster feature damage miss",{damageText:e,featureDoc:t});const i=new o.A("overTimeFeature",{html:e});return i.prepare(),i.generateDamageInfo(),i.actionInfo.damageParts}static getOvertimeDamage(e,t=null){if(e.includes("taking")&&(e.includes("on a failed save")||e.includes("damage on a failure"))){const a=e.split("taking")[1];return DDBEffectHelper.getMonsterFeatureDamage(a,t)}}static generateConditionOnlyEffect(e,t,a=null){new d.MidiOverTimeEffect({document:t,actor:e,otherDescription:a}).generateConditionOnlyEffect()}static generateOverTimeEffect(e,t,a=null){new d.MidiOverTimeEffect({document:t,actor:e,otherDescription:a}).generateOverTimeEffect()}static damageOverTimeEffect({document:e,startTurn:t=!1,endTurn:a=!1,durationSeconds:i,damage:n,damageType:s,saveAbility:r,saveRemove:o=!0,saveDamage:l="nodamage",dc:c}={}){return d.MidiOverTimeEffect.damageOverTimeEffect({document:e,startTurn:t,endTurn:a,durationSeconds:i,damage:n,damageType:s,saveAbility:r,saveRemove:o,saveDamage:l,dc:c})}static addToProperties(e,t){return s.utils.addToProperties(e,t)}static removeFromProperties(e,t){s.utils.removeFromProperties(e,t)}static wait(e){s.utils.wait(e)}static async addDDBIEffectToDocument(e,{useChrisPremades:t=!1,isMonster:a=!1}={}){if(!0===foundry.utils.getProperty(e,"flags.ddbimporter.effectsApplied")||!0===foundry.utils.getProperty(e,"flags.ddbimporter.chrisEffectsApplied"))return void s.logger.warn(`Skipping effect generation for ${e.name} as DDB Importer or Chris effect is already present.`);const i=game.settings.get("ddb-importer","munching-policy-add-spell-effects"),o=game.settings.get("ddb-importer","munching-policy-add-effects");try{game.settings.set("ddb-importer","munching-policy-add-spell-effects",!0),game.settings.set("ddb-importer","munching-policy-add-effects",!0);let i=e.toObject();i.effects=[],foundry.utils.hasProperty(i,"flags.dae")&&delete i.flags.dae,foundry.utils.hasProperty(i,"flags.itemacro")&&delete i.flags.itemacro,foundry.utils.hasProperty(i,"flags.midi-qol")&&delete i.flags["midi-qol"],foundry.utils.hasProperty(i,"flags.ActiveAuras")&&delete i.flags.ActiveAuras,n.x.types.inventory.includes(i.type)||("spell"===i.type?i=await(0,r.d)(i,!0):i.type),t&&(i=(await ExternalAutomations.applyChrisPremadeEffects({documents:[i],force:!0,isMonster:a}))[0]),i=d.AutoEffects.addVision5eStub(i),!0===foundry.utils.getProperty(i,"flags.ddbimporter.effectsApplied")||!0===foundry.utils.getProperty(i,"flags.ddbimporter.chrisEffectsApplied")?(s.logger.debug("New effects generated, removing existing effects"),await e.deleteEmbeddedDocuments("ActiveEffect",[],{deleteAll:!0}),s.logger.debug(`Removal complete, adding effects to item ${e.name}`),s.logger.info(`Updating actor document ${e.name} with`,{data:foundry.utils.duplicate(i)}),await e.update(i)):s.logger.info(`No effects applied to document ${e.name}`)}finally{game.settings.set("ddb-importer","munching-policy-add-spell-effects",i),game.settings.set("ddb-importer","munching-policy-add-effects",o)}}static async addDDBIEffectsToActorDocuments(e,{useChrisPremades:t=!1}={}){s.logger.info("Starting to add effects to actor items");const a="npc"===e.type;for(const i of e.items)s.logger.debug(`Processing ${i.name}`),await DDBEffectHelper.addDDBIEffectToDocument(i,{useChrisPremades:t,isMonster:a});s.logger.info("Effect addition complete")}static async addSaveAdvantageToTarget(e,t,a,i="",n=null){const s={_id:foundry.utils.randomID(),changes:[{key:`flags.midi-qol.advantage.ability.save.${a}`,mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,value:"1",priority:20}],origin:t.uuid,disabled:!1,transfer:!1,icon:n,img:n,duration:{turns:1},flags:{dae:{specialDuration:[`isSave.${a}`]}}};s.name=`${t.name}${i}: Save Advantage`,await MidiQOL.socket().executeAsGM("createEffects",{actorUuid:e.uuid,effects:[s]})}static async attachSequencerFileToTemplate(e,t,a,i=1){if(game.modules.get("sequencer")?.active&&Sequencer.Database.entryExists(t)){s.logger.debug(`Trying to apply sequencer effect (${t}) to ${e} from ${a}`,t);const n=await fromUuid(e);(new Sequence).effect().file(Sequencer.Database.entryExists(t)).size({width:canvas.grid.size*(n.width/canvas.dimensions.distance),height:canvas.grid.size*(n.width/canvas.dimensions.distance)}).persist(!0).origin(a).belowTokens().opacity(.5).attachTo(n,{followRotation:!0}).scaleToObject(i).play()}}static async buttonDialog(e,t){return s.DialogHelper.buttonDialog(e,t)}static canSense(e,t){return MidiQOL.canSense(e,t)}static checkCollision(e,t=["sight","move"],a="any"){for(const i of t){const t=CONFIG.Canvas.polygonBackends[i].testCollision(e.A,e.B,{mode:a,type:i});if(t)return t}return!1}static checkCover(e,t,a,i){const n=MidiQOL.computeCoverBonus(e,t,a);if(!i)return n;switch(n){case 0:return"No Cover";case 2:return"Half Cover";case 5:return"Three-Quarters Cover";case 999:return"Full Cover";default:return"Unknown Cover"}}static configureCustomAAForCondition(e,t,a,i){const n=CONFIG.DND5E.conditionTypes[e];if(!n)return;const s=`${n.label} [${a}]`;if(AutomatedAnimations.AutorecManager.getAutorecEntries().aefx.find((e=>(e.label??e.name)===s))){const e=Hooks.on("AutomatedAnimations-WorkflowStart",(a=>{a.item instanceof CONFIG.ActiveEffect.documentClass&&a.item.name===n.label&&a.item.origin===t.sourceItemUuid&&(a.recheckAnimation=!0,a.item.name=s,Hooks.off("AutomatedAnimations-WorkflowStart",e))}));Hooks.once(`midi-qol.RollComplete.${i}`,(()=>{Hooks.off("AutomatedAnimations-WorkflowStart",e)}))}}static checkJB2a(e=!0,t=!0,a=!1){return!(!t||!game.modules.get("jb2a_patreon")?.active)||(e?!(!e||!game.modules.get("JB2A_DnD5e")?.active)||(a&&ui.notifications.error("This macro requires either the patreon or free version of JB2A"),!1):(a&&ui.notifications.error("This macro requires the patreon version of JB2A"),!1))}static async _createJB2aActors(e,t){const a=["jb2a_patreon.jb2a-actors","JB2A_DnD5e.jb2a-actors"];for(let i of a){let a=game.packs.get(i);if(!a)continue;const n=a.index.filter((e=>e.name.includes(t))),r=await s.FolderHelper.getFolder("npc",e,"JB2A Actors","#ceb180","#cccc00",!1);for(const e of n)game.actors.find((t=>t.name===e.name&&t.folder?.id===r.id))||await game.actors.importFromCompendium(a,e._id,{folder:r.id})}}static getSceneTargets(){let e=canvas.tokens.controlled.filter((e=>e.actor));return e.length&&game.user.character&&(e=game.user.character.getActiveTokens()),e}static async checkTargetInRange({sourceUuid:e,targetUuid:t,distance:a}){if(!game.modules.get("midi-qol")?.active)return ui.notifications.error("checkTargetInRange requires midiQoL, not checking"),s.logger.error("checkTargetInRange requires midiQoL, not checking"),!0;const i=await fromUuid(e);if(!i)return!1;return MidiQOL.findNearby(null,e,a).reduce(((e,a)=>{const n=new Ray(i,a),s=DDBEffectHelper.checkCollision(n,["sight"]);return a.uuid!==t||s||(e=!0),e}),!1)}static async displayItemCard(e){const t=await e.displayCard({createMessage:!1}),a=document.createElement("DIV");a.innerHTML=t.content,a.querySelector("div.card-buttons").remove(),await ChatMessage.create({content:a.innerHTML})}static findContainedTokensInTemplate(e){const t=new Set;for(const a of e.parent.tokens){const i=a.width>=1?.5:a.width/2,n=a.height>=1?.5:a.height/2;for(let s=i;s<a.width;s++)for(let i=n;i<a.width;i++){const n={x:a.x+s*e.parent.grid.size-e.x,y:a.y+i*e.parent.grid.size-e.y};e.object.shape.contains(n.x,n.y)&&t.add(a.id)}}return[...t]}static findEffect(e,t){return e.effects.getName(t)}static getActorEffects(e){return Array.from(e?.allApplicableEffects()??[])}static async getNewMidiQOLWorkflowTarget(e,t,a,i=void 0){e.targets.delete(a),e.saves.delete(a),e.hitTargets.delete(a),await DDBEffectHelper.displayItemCard(t),await MidiQOL.resolveTargetConfirmation(t,{forceDisplay:!0,title:i});const n=game.user.targets.first();if(n)return e.targets.add(n),e.hitTargets.add(n),e.saveResults=e.saveResults.filter((e=>e.data.tokenId!==a.id)),n}static findEffects(e,t){const a=[];for(const i of t)DDBEffectHelper.findEffect(e,i)&&a.push(DDBEffectHelper.findEffect(e,i));return a}static fromActorUuid(e){const t=fromUuidSync(e);return t instanceof CONFIG.Token.documentClass?t.actor:t instanceof CONFIG.Actor.documentClass?t:null}static getActor(e){return e instanceof Actor?e:e instanceof Token||e instanceof TokenDocument?e.actor:s.utils.isString(e)?DDBEffectHelper.fromActorUuid(e):null}static getCantripDice(e){const t="character"===e.type?e.system.details.level:e.system.details.cr;return 1+Math.floor((t+1)/6)}static getConcentrationEffect(e,t=null){return e?.effects.find((e=>foundry.utils.getProperty(e,"flags.midi-qol.isConcentration")))}static simpleMeasureDistances(e,t={}){if("BaseGrid"!==canvas?.grid?.grid.constructor.name||!t.gridSpaces){const a=canvas?.grid?.measureDistances(e,t);return a}const a=canvas?.grid.diagonalRule;if(!t.gridSpaces||!["555","5105","EUCL"].includes(a))return canvas?.grid?.measureDistances(e,t);let i=0;const n=canvas?.dimensions,s=canvas?.scene?.grid;return n&&n.size?e.map((e=>{const t=e.ray,r=Math.ceil(Math.max(0,Math.abs(t.dx/n.size))),o=Math.ceil(Math.max(0,Math.abs(t.dy/n.size))),l=Math.min(r,o),d=Math.abs(o-r);if(i+=l,"5105"===a){const e=Math.floor(i/2)-Math.floor((i-l)/2);return(2*e+(l-e)+d)*n.distance}if("EUCL"===a){const e=Math.max(0,Math.abs(t.dx/n.size)),a=Math.max(0,Math.abs(t.dy/n.size));return Math.ceil(Math.hypot(e,a)*s?.distance)}return Math.max(r,o)*s.distance})):0}static _getDistanceSegments(e,t,a=!1){const i=e.document.width>=1?.5:e.document.width/2,n=e.document.height>=1?.5:e.document.height/2,s=t.document.width>=1?.5:t.document.width/2,r=t.document.height>=1?.5:t.document.height/2;let o,l,d,c,u=[];for(o=i;o<e.document.width;o++)for(d=n;d<e.document.height;d++){const i=new PIXI.Point(...canvas.grid.getCenter(Math.round(e.document.x+canvas.dimensions.size*o),Math.round(e.document.y+canvas.dimensions.size*d)));for(l=s;l<t.document.width;l++)for(c=r;c<t.document.height;c++){const e=new PIXI.Point(...canvas.grid.getCenter(Math.round(t.document.x+canvas.dimensions.size*l),Math.round(t.document.y+canvas.dimensions.size*c))),n=new Ray(i,e);if(a){if(CONFIG.Canvas.polygonBackends.move.testCollision(i,e,{mode:"any",type:"move"}))continue}u.push({ray:n})}}return u}static _calculateTokeHeightDifference(e,t){const a=e.document.elevation??0,i=t.document.elevation??0,n=a+Math.max(e.document.height,e.document.width)*(canvas?.dimensions?.distance??5),s=i+Math.min(t.document.height,t.document.width)*(canvas?.dimensions?.distance??5);let r=0,o=Math.max(e.document.height,e.document.width)*(canvas?.dimensions?.distance??5);return Math.abs(i-a)<o?r=0:a<i?r=i-n:a>i&&(r=a-s),r}static getSimpleDistance(e,t,a=!1){if(!canvas||!canvas.scene)return-1;if(!canvas.grid||!canvas.dimensions)return-1;const i=DDBEffectHelper.getToken(e),n=DDBEffectHelper.getToken(t);if(!i||!n)return-1;if(!canvas||!canvas.grid||!canvas.dimensions)return-1;const s=DDBEffectHelper._getDistanceSegments(i,n,a);if(0===s.length)return-1;const r=s.map((e=>DDBEffectHelper.simpleMeasureDistances([e],{gridSpaces:!0})));let o=Math.min(...r);const l=DDBEffectHelper._calculateTokeHeightDifference(i,n),d=canvas.grid.diagonalRule;if(["555","5105"].includes(d)){let e=Math.min(o,l);o=e+Math.abs(o-l);let t=canvas?.dimensions?.distance??5;"5105"===d&&(o+=Math.floor(e/2/t)*t)}else o=Math.sqrt(l*l+o*o);return o}static getDistance(e,t,a=!1){return game.modules.get("midi-qol")?.active?MidiQOL.computeDistance(e,t,a):DDBEffectHelper.getSimpleDistance(e,t,a)}static getHighestAbility(e,t){return"string"==typeof t?t:Array.isArray(t)?t.reduce(((t,a)=>e.system.abilities[a].value>e.system.abilities[t].value?a:t),t[0]):void 0}static getRaceOrType(e){const t=DDBEffectHelper.getActor(e),a=t?.system;return a?a.details.race?(a.details?.race?.name??a.details?.race)?.toLocaleLowerCase()??"":a.details.type?.value.toLocaleLowerCase()??"":""}static getToken(e){if(e)return e instanceof Token?e:s.utils.isString(e)?fromUuidSync(e)?.object:e instanceof TokenDocument?e.object:void 0}static getTokenDocument(e){if(e){if(e instanceof TokenDocument)return e;if("string"==typeof e){const t=fromUuidSync(e);if(t instanceof TokenDocument)return t;if(t instanceof Actor)return DDBEffectHelper.getTokenForActor(t)?.document}return e instanceof Token?e.document:void 0}}static getTokenForActor(e){const t=e.getActiveTokens();if(!t.length)return;const a=t.filter((e=>e._controlled));return a.length?a.shift():t.shift()}static async getTokenImage(e){const t=game.settings.get("midi-qol","ConfigSettings");let a=e.document?.texture?.src??e.actor.img??"";return t.usePlayerPortrait&&"character"===e.actor.type&&(a=e.actor?.img??e.document?.texture?.src??""),VideoHelper.hasVideoExtension(a)&&(a=await game.video.createThumbnail(a,{width:100,height:100})),a}static getTypeOrRace(e){const t=DDBEffectHelper.getActor(e),a=t?.system;return a?a.details.type?.value?a.details.type?.value.toLocaleLowerCase()??"":(a.details?.race?.name??a.details?.race)?.toLocaleLowerCase()??"":""}static getRemainingDuration(e){const t={};if("seconds"===e.type)t.seconds=e.remaining;else if("turns"===e.type){const a=Math.floor(e.remaining),i=100*(e.remaining-a);t.rounds=a,t.turns=i}return t}static isRangedWeaponAttack(e){if(e.hitTargets.length<1)return!1;if("rwak"===e.item?.system.actionType)return!0;if("mwak"!==e.item?.system.actionType||!e.item?.system.properties?.thr)return!1;const t=canvas.tokens?.get(e.tokenId),a=e.hitTargets[0].object,i=MidiQOL.computeDistance(t,a,!0);return i>=0&&i>5}static isSmaller(e,t){const a=n.x.SIZES.find((t=>t.value===e.system.traits.size))?.size,i=n.x.SIZES.find((e=>e.value===t.system.traits.size))?.size;return a<i}static requirementsSatisfied(e,t){let a=!1;return t.forEach((t=>{if(!game.modules.get(t)?.active){const i=`${e}: ${t} must be installed and active.`;ui.notifications.error(i),s.logger.warn(i),a=!0}})),!a}static async rollSaveForItem(e,t,a=null){const{ability:i,dc:n}=foundry.utils.duplicate(e.system.save),s=MidiQOL.playerForActor(t.actor)?.active?MidiQOL.playerForActor(t.actor).id:game.users.activeGM.id,r={request:"save",targetUuid:t.document.uuid,ability:i,options:{name:"Reflect",skipDialogue:!0,targetValue:n}},o=await MidiQOL.socket().executeAsUser("rollAbility",s,r);return a&&a.saveResults.push(o),o}static selectTargetsWithinX(e,t,a){let i=MidiQOL.findNearby(null,e,t);a&&i.unshift(e);const n=i.map((e=>e.document.id));return game.user?.updateTokenTargets(n),game.user?.broadcastActivity({aoeTargetIds:n}),i}static updateUserTargets(e){game.user.updateTokenTargets(e)}static isConditionEffectAppliedAndActive(e,t){return DDBEffectHelper.getActorEffects(t).some((t=>t?.name.toLowerCase()==e.toLowerCase()&&!t?.disabled))}static getConditionEffectAppliedAndActive(e,t){return DDBEffectHelper.getActorEffects(t).find((t=>t?.name.toLowerCase()==e.toLowerCase()&&!t?.disabled))}static async removeCondition({actor:e,actorUuid:t,conditionName:a,level:i=null}={}){if(e||(e=await fromUuid(t)),!e)return void s.logger.error("No actor passed to remove condition");const n=CONFIG.statusEffects.find((e=>e.name.toLowerCase()===a.toLowerCase()));if(!n)return void s.logger.error(`Condition ${a} not found`);s.logger.debug(`removing ${n.name}`,{condition:n});const r=e.document?.effects?.get(game.dnd5e.utils.staticID(`dnd5e${n.id}`));r&&await r.delete(),"exhaustion"===n.id&&(s.logger.debug("Reducing exhaustion",i),await e.update({"system.attributes.exhaustion":i??0}))}static async addCondition({conditionName:e,actor:t,actorUuid:a,level:i=null,origin:n=null}={}){if(t||(t=await fromUuid(a)),!t)return void s.logger.error("No actor passed to remove condition");const r=CONFIG.statusEffects.find((t=>t.name.toLowerCase()===e.toLowerCase()));if(!r)return void s.logger.error(`Condition ${e} not found`);s.logger.debug(`adding ${r.name}`,{condition:r});const o=await ActiveEffect.implementation.fromStatusEffect(r.id);r.level&&o.updateSource({[`flags.dnd5e.${r.id}Level`]:r.level}),o.updateSource({origin:n});const l=o.toObject();await t.createEmbeddedDocuments("ActiveEffect",[l],{keepId:!0}),"exhaustion"===r.foundry&&(s.logger.debug("Updating actor exhaustion",i),await t.update({"system.attributes.exhaustion":i??1}))}static async adjustCondition({add:e=!1,remove:t=!1,actor:a,conditionName:i,level:n=null,origin:r=null}={}){game.users.find((e=>e.active&&e.isGM))?e||t?(s.logger.debug("Adjusting condition",{add:e,remove:t,actor:a,conditionName:i,level:n,origin:r}),t&&(s.logger.debug("Removing condition",{actor:a,conditionName:i,level:n}),await globalThis.DDBImporter.socket.executeAsGM("removeCondition",{actorUuid:a.uuid,conditionName:i,level:n})),e&&(s.logger.debug("Adding condition",{actor:a,conditionName:i,level:n,origin:r}),await globalThis.DDBImporter.socket.executeAsGM("addCondition",{actorUuid:a.uuid,conditionName:i,level:n,origin:r})),s.logger.debug("Condition adjusted",{add:e,remove:t,actor:a,conditionName:i,level:n,origin:r})):s.logger.warn("You must specify if you want to add or remove the condition"):ui.notifications.error("No GM user found, unable to adjust condition")}static extractListItems(e,{type:t="ol",titleType:a="em"}={}){const i=[],n=s.utils.htmlToDoc(e).body.querySelector(t);if(n){n.querySelectorAll("li").forEach(((e,t)=>{const n=e.querySelector(a),s=n.nextSibling;i.push({number:t+1,title:n.textContent.replace(/\.$/,"").trim(),content:s.innerHTML??s.wholeText??s.textContent,full:e.innerHTML})}))}return i.length>0?i:DDBEffectHelper.extractParagraphItems(e,{titleType:a})}static extractParagraphItems(e,{type:t="p",titleType:a="em"}={}){const i=[],n=s.utils.htmlToDoc(e).querySelectorAll(t);let r=1;for(const e of n){const t=e.querySelector(a);if(!t)continue;const n=t.nextSibling;i.push({number:r,title:t.textContent.replace(/\.$/,"").trim(),content:n.innerHTML?.trim()??n.wholeText?.trim()??n.textContent?.trim(),full:e.innerHTML}),r++}return i}static async _verySimpleDamageRollToChat({actor:e,flavor:t,formula:a,damageType:i="damage",item:n,itemId:s,itemUuid:r}={}){const o=new CONFIG.Dice.DamageRoll(a,{},{type:i});await o.evaluate({async:!0}),!n&&s&&!r&&e&&(n=e.getEmbeddedDocument("Item",s)),!n&&r&&e&&(n=await fromUuid(r)),n&&!s&&(s=n._id),n&&!r&&(r=n.uuid),o.toMessage({speaker:ChatMessage.getSpeaker({actor:e}),flavor:t,"flags.dnd5e":{targets:dnd5e.utils.getTargetDescriptors(),roll:{type:"damage",itemId:s,itemUuid:r}}})}static async simpleDamageRollToChat({event:e,actor:t,flavor:a,formulas:i=[],damageType:n="damage",item:s,itemId:r,itemUuid:o,fastForward:l=!1}={}){!s&&r&&!o&&t&&(s=t.getEmbeddedDocument("Item",r)),!s&&o&&t&&(s=await fromUuid(o)),s&&!r&&(r=s._id),s&&!o&&(o=s.uuid);const d=n in CONFIG.DND5E.healingTypes,c=game.i18n.localize(`DND5E.${d?"Healing":"Damage"}Roll`),u={rollConfigs:[{parts:i,type:n}],flavor:a??c,event:e,title:c,fastForward:l,messageData:{"flags.dnd5e":{targets:dnd5e.utils.getTargetDescriptors(),roll:{type:"damage",itemId:r,itemUuid:o}},speaker:ChatMessage.implementation.getSpeaker()}};if(!1===Hooks.call("dnd5e.preRollDamage",void 0,u))return;const m=await globalThis.dnd5e.dice.damageRoll(u);m&&Hooks.callAll("dnd5e.rollDamage",void 0,m)}static syntheticItemWorkflowOptions({targets:e,showFullCard:t=!1,useSpellSlot:a=!1,castLevel:i=!1,consume:n=!1,configureDialog:s=!1,targetConfirmation:r}={}){return[{showFullCard:t,createWorkflow:!0,consumeResource:n,consumeRecharge:n,consumeQuantity:n,consumeUsage:n,consumeSpellSlot:a,consumeSpellLevel:i,slotLevel:i},{targetUuids:e,configureDialog:s,workflowOptions:{autoRollDamage:"always",autoFastDamage:!0,autoRollAttack:!0,targetConfirmation:r}}]}static overTimeDamage({document:e,turn:t,damage:a,damageType:i,saveAbility:n,saveRemove:s,saveDamage:r,dc:o}={}){return d.ChangeHelper.overTimeDamageChange({document:e,turn:t,damage:a,damageType:i,saveAbility:n,saveRemove:s,saveDamage:r,dc:o})}static overTimeSave({document:e,turn:t,saveAbility:a,saveRemove:i=!0,dc:n}={}){return d.ChangeHelper.overTimeSaveChange({document:e,turn:t,saveAbility:a,saveRemove:i,dc:n})}static startOrEnd(e){return l.DDBDescriptions.startOrEnd(e)}static overTimeSaveEnd({document:e,effect:t,save:a,text:i}){const n=d.MidiOverTimeEffect.getOverTimeSaveEndChange({document:e,save:a,text:i});n&&t.changes.push(n)}static getSpecialDuration(e,t){return l.DDBDescriptions.addSpecialDurationFlagsToEffect(e,t)}static DEFAULT_DURATION_SECONDS=60;static getDuration(e,t=!0){return l.DDBDescriptions.getDuration(e,t)}static dcParser({text:e}={}){return l.DDBDescriptions.dcParser({text:e})}static parseStatusCondition({text:e,nameHint:t=null}={}){return l.DDBDescriptions.parseStatusCondition({text:e,nameHint:t})}}class WildShape{static registerHooks(){Hooks.on("dnd5e.transformActor",((e,t,a,i)=>{const n="legacy"===game.settings.get("dnd5e","rulesVersion");"wildshape"===i.preset&&e.classes?.druid&&("moon"!==e.classes.druid.subclass?.identifier||n?"blighted"===e.classes.druid.subclass?.identifier&&DDBEnhancers.addFeatureToEffects(e,a,"Blighted Shape"):(DDBEnhancers.addFeatureToEffects(e,a,"Circle Forms"),DDBEnhancers.addFeatureToEffects(e,a,"Improved Circle Forms")))}))}}class GreatWeaponMaster{static registerHooks(){Hooks.on("dnd5e.preRollDamageV2",((e,t,a)=>{if(0===e.rolls.length)return!0;if(!e.subject?.parent?.properties?.has("hvy"))return!0;const i=e.subject?.actor?.items?.some((e=>"Great Weapon Master"===e.name&&"2024"===e.system.source.rules));return!i||(e.rolls[0].parts.push("@prof"),!0)}))}}class ArcaneWard{static getEnricher({actor:e}={}){const t=`DDBI.ENRICHERS.class.wizard.ArcaneWard.${e.uuid}`,a=foundry.utils.getProperty(CONFIG,t);if(a)return a;const i=new ArcaneWard({actor:e});return foundry.utils.setProperty(CONFIG,t,i),i}static wardDocumentName="Arcane Ward";get wardStrength(){return this.wardDocument.system?.uses.value??0}get wardStrengthMax(){return this.wardDocument.system?.uses.max??0}async updateWardStrength(e){return this.wardDocument.update({"system.uses.spent":this.wardStrengthMax-e})}constructor({actor:e}={}){this.actor=e,this.wardDocument=e.items.find((e=>e.name===ArcaneWard.wardDocumentName))}async applyDamage(e){const t=this.wardStrength;if(0===t)return;const a=e.system.attributes.hp.value??0,i=this.actor.system.attributes.hp.value??0;if(a>=i)return;const n=i-a,s=Math.min(n,t??0);if(0===s)return;const r=t-s,o=a+s,l=ChatMessage.getSpeaker({actor:this.actor}),d={content:`${ArcaneWard.wardDocumentName} absorbs ${s} of ${n} points of damage.<br> Hp -> ${o}<br>Ward strength -> ${r}`,speaker:l};ChatMessage.create(d),e.system.attributes.hp.value=o,await this.updateWardStrength(r)}async addWard({spellLevel:e}={}){const t=this.wardStrength,a=this.wardStrengthMax,i=Math.min(t+2*e,a);if(t===i)return;const n=ChatMessage.getSpeaker({actor:this.actor}),s={content:`${ArcaneWard.wardDocumentName} gains ${2*e} points to ${i}/${a}`,speaker:n};ChatMessage.create(s),await this.updateWardStrength(i)}static isAbjurer(e){return e.classes?.wizard&&e.classes.wizard.subclass&&["Abjurer","School of Abjuration"].includes(e.classes.wizard.subclass.name)}static registerHooks(){Hooks.on("preUpdateActor",(async(e,t,a,i)=>{if(!ArcaneWard.isAbjurer(e))return!0;if(void 0!==t.system?.attributes?.hp?.value){const a=ArcaneWard.getEnricher({actor:e});await a.applyDamage(t)}return!0})),Hooks.on("dnd5e.activityConsumption",(async(e,t,a,i)=>{if("spell"!==a.data?.flags?.dnd5e?.item?.type)return!0;if(!t.consume?.spellSlot)return!0;const n=a.data?.flags?.dnd5e?.use?.spellLevel;if(void 0===n)return!0;const s=e.parent;if(!s)return!0;if("abj"!==s.school||0===s.level)return!0;const r=e.actor;if(!ArcaneWard.isAbjurer(r))return!0;const o=ArcaneWard.getEnricher({actor:r});return await o.addWard({spellLevel:n}),!0}))}}class DDBEnhancers{static addFeatureToEffects(e,t,a){const i=e.items.find((e=>e.name===a));i&&t.effects.push(...i.toObject().effects)}static druidEnhancers(){game.settings.get(n.y.MODULE_ID,"allow-moon-druid-wildshape-enhancer")&&WildShape.registerHooks()}static wizardEnhancers(){game.settings.get(n.y.MODULE_ID,"allow-arcane-ward-enhancer")&&ArcaneWard.registerHooks()}static addFeatEnhancers(){game.settings.get(n.y.MODULE_ID,"allow-great-weapon-master-enhancer")&&GreatWeaponMaster.registerHooks()}static loadEnhancers(){DDBEnhancers.druidEnhancers(),DDBEnhancers.wizardEnhancers(),DDBEnhancers.addFeatEnhancers()}}},959:(e,t,a)=>{a.d(t,{K:()=>DirectoryPicker});class DirectoryPicker extends FilePicker{constructor(e={}){super(e)}_onSubmit(e){e.preventDefault();const t=e.target.target.value,a=this.activeSource,i=this.sources.s3?.bucket&&""!==this.sources.s3.bucket?this.sources.s3.bucket:null;this.field.value=DirectoryPicker.format({activeSource:a,bucket:i,path:t}),this.close()}static Directory(e){return e}static format(e){return null!==e.bucket&&""!==e.bucket?`[${e.activeSource}:${e.bucket}] ${e.path??e.current??""}`:`[${e.activeSource}] ${e.path??e.current??""}`}static parse(e){let t=e.match(/\[(.+)\]\s*(.+)/);if(t){let a=t[1];const i=t[2].trim(),[n,s]=a.split(":");return void 0!==s?{activeSource:n,bucket:s,current:i,fullPath:e}:{activeSource:n,bucket:null,current:i,fullPath:e}}return{activeSource:"data",bucket:null,current:e}}static processHtml(e){$(e).find('input[data-dtype="Directory"], .ddb-directory').each(((e,t)=>{if($(t).prop("readonly",!0),!$(t).next().length){let e=new DirectoryPicker({field:$(t)[0],...DirectoryPicker.parse($(t).val())}),a=$('<button type="button" class="file-picker" data-type="imagevideo" data-target="img" title="Pick directory"><i class="fas fa-file-import fa-fw"></i></button>');a.on("click",(()=>{e.render(!0)})),$(t).parent().append(a)}}))}activateListeners(e){super.activateListeners(e),$(e).find("ol.files-list").remove(),$(e).find("footer div").remove(),$(e).find("footer button").text("Select Directory")}static async browseForgeFiles(e,t,a={}){t.startsWith(ForgeVTT.ASSETS_LIBRARY_URL_PREFIX)&&(a.wildcard&&(a.wildcard=t),t=(t=t.slice(ForgeVTT.ASSETS_LIBRARY_URL_PREFIX.length)).split("/").slice(1,-1).join("/"));const i=await ForgeAPI.call("assets/browse",{path:decodeURIComponent(t),options:a});return!i||i.error?(ui.notifications.error(i?i.error:"An unknown error occured accessing The Forge API"),{target:t,dirs:[],files:[],gridSize:null,private:!1,privateDirs:[],extensions:a.extensions}):(i.target=decodeURI(i.folder),delete i.folder,i.dirs=i.dirs.map((e=>e.path.slice(0,-1))),i.files=i.files.map((e=>e.url)),i.private=!0,i.privateDirs=[],i.gridSize=null,i.extensions=a.extensions,i)}static async browseFiles(e,t,a={}){return"undefined"!=typeof ForgeVTT&&ForgeVTT?.usingTheForge&&(t.startsWith(ForgeVTT.ASSETS_LIBRARY_URL_PREFIX)&&(e="forgevtt"),"forgevtt"===e)?DirectoryPicker.browseForgeFiles(e,t,a):FilePicker.browse(e,t,a)}}},908:(e,t,a)=>{a.r(t),a.d(t,{default:()=>s,setupLogger:()=>setupLogger});var i=a(421);const n={LOG_PREFIX:"DDB Importer",LOG_MSG_DEFAULT:"No logging message provided. Please see the payload for more information.",_showMessage:(e,t)=>{if(!e||!t||"string"!=typeof e)return!1;try{const t=game.settings.get("ddb-importer","log-level"),a=["VERBOSE","DEBUG","TIME","TIMEEND","TIMELOG","INFO","WARN","ERR","OFF"],i=a.indexOf(e.toUpperCase());return!("OFF"==t||-1===i||i<a.indexOf(t))}catch(e){return!0}},_addToLogFile:(e,t)=>{!0===foundry.utils.getProperty(CONFIG.debug,"ddbimporter.record")&&CONFIG.debug.ddbimporter.log.push({level:e,data:t})},log:(e,...t)=>{if(n._addToLogFile(e,t),!n._showMessage(e,t))return;const a=e.startsWith("TIME")?"DEBUG":e.toUpperCase(),i=t[0]&&(t[0],1)?t[0]:n.LOG_MSG_DEFAULT,s=t[0]&&(t[0],1)?t.length>1?t.slice(1):null:t.slice(),r=`${n.LOG_PREFIX} | ${a} > ${i}`;switch(e.toUpperCase()){case"VERBOSE":case"DEBUG":s?console.debug(r,...s):console.debug(r);break;case"INFO":s?console.info(r,...s):console.info(r);break;case"WARN":s?console.warn(r,...s):console.warn(r);break;case"ERR":s?console.error(r,...s):console.error(r);break;case"TIME":s?console.time(r,...s):console.time(r);break;case"TIMEEND":s?console.timeEnd(r,...s):console.timeEnd(r);break;case"TIMELOG":s?console.timeLog(r,...s):console.timeLog(r)}},debug:(...e)=>{n.log("DEBUG",...e)},info:(...e)=>{n.log("INFO",...e)},warn:(...e)=>{n.log("WARN",...e)},error:(...e)=>{n.log("ERR",...e)},time:(...e)=>{n.log("TIME",...e)},verbose:(...e)=>{n.log("VERBOSE",...e)},timeEnd:(...e)=>{n.log("TIMEEND",...e)},timeLog:(...e)=>{n.log("TIMELOG",...e)}},s=n,getCircularReplacer=()=>{const e=new WeakSet;return(t,a)=>{if("object"==typeof a&&null!==a){if(e.has(a))return;e.add(a)}return a}};function downloadLog(){i.FileHelper.download(JSON.stringify(CONFIG.debug.ddbimporter.log,getCircularReplacer()),"ddbimporter-log-data.json","application/json"),foundry.utils.setProperty(CONFIG.debug,"ddbimporter.log",[])}function setupLogger(){const e={record:!1,log:[],download:downloadLog};foundry.utils.setProperty(CONFIG.debug,"ddbimporter",e)}},421:(e,t,a)=>{a.r(t),a.d(t,{ChooserDialog:()=>ChooserDialog,CompendiumHelper:()=>m,Crosshairs:()=>Crosshairs,DDBCampaigns:()=>DDBCampaigns,DDBCompendiumFolders:()=>DDBCompendiumFolders,DDBItemImporter:()=>DDBItemImporter,DDBMacros:()=>DDBMacros,DDBProxy:()=>h,DDBSimpleMacro:()=>DDBSimpleMacro,DDBSources:()=>DDBSources,DialogHelper:()=>DialogHelper,DirectoryPicker:()=>f.K,FileHelper:()=>y,FolderHelper:()=>FolderHelper,Iconizer:()=>Iconizer,Logger:()=>s,MuncherSettings:()=>C,NameMatcher:()=>NameMatcher,Notifications:()=>i,OriginFixer:()=>OriginFixer,PatreonHelper:()=>S,Secrets:()=>n,Utils:()=>Utils,base64Check:()=>base64Check,logger:()=>s.default,utils:()=>Utils});var i={};a.r(i),a.d(i,{registerNotifications:()=>registerNotifications});var n={};a.r(n),a.d(n,{checkCobalt:()=>checkCobalt,deleteLocalCobalt:()=>deleteLocalCobalt,getCobalt:()=>getCobalt,isLocalCobalt:()=>isLocalCobalt,moveCobaltToLocal:()=>moveCobaltToLocal,moveCobaltToSettings:()=>moveCobaltToSettings,setCobalt:()=>setCobalt});var s=a(908);const r=10;function registerNotifications(){0===$("#ddbimporter-notifications").length&&$("body").append('<div id="ddbimporter-notifications"></div>'),0===$("#ddbimporter-hints").length&&$("body").append('<div id="ddbimporter-hints"></div>'),game.modules.get("ddb-importer").api.notification={clear:()=>{$("#ddbimporter-notifications div").fadeOut(200,(()=>{$("#ddbimporter-notifications").empty()}))},show:(e,t=4e3)=>{$("#ddbimporter-notifications").css("left",$("#players").css("left")),$("#ddbimporter-notifications").css("bottom",$("#players").height()+2*r);let a=$('<div style="display: none"></div>').append(e);$("#ddbimporter-notifications").append(a),$(a).fadeIn(200),t?setTimeout((()=>{$(a).fadeOut(200,(()=>{$(a).remove()}))}),t):$(a).append('<p style="text-align: center; color: #7e7e7e; margin: 0px;"><small>Click to close</small>'),$(a).on("click",(()=>{$(a).fadeOut(200,(()=>{$(a).remove()}))}))}},game.modules.get("ddb-importer").api.hint={clear:()=>{$("#ddbimporter-hints div").hide(200,(()=>{$("#ddbimporter-hints").empty()}))},show:(e,t={})=>new Promise((a=>{$("#ddbimporter-hints").css("width",t.width?t.width:300);let i=$('<div style="display: none"></div>');$(i).append(e),$(i).append('<div class="buttons"></div>'),$("#ddbimporter-hints").append(i),$(i).fadeIn(200),t.align||(t.align=t.element?"RIGHT":"CENTER");let n={width:0,height:0,top:Math.round(window.innerHeight/2),left:Math.round(window.innerWidth/2)};t.element&&(n=Object.assign({width:$(t.element).width(),height:$(t.element).height()},$(t.element).offset()));const s=Object.assign({width:$("#ddbimporter-hints").width(),height:$("#ddbimporter-hints").height()},$("#ddbimporter-hints").position());switch(t.align){case"RIGHT":$("#ddbimporter-hints").css("top",n.top),$("#ddbimporter-hints").css("left",n.left+n.width+r);break;case"LEFT":$("#ddbimporter-hints").css("top",n.top),$("#ddbimporter-hints").css("left",n.left-s.width-r);break;case"TOP":$("#ddbimporter-hints").css("top",n.top-s.height-r),$("#ddbimporter-hints").css("left",n.left);break;case"BOTTOM":$("#ddbimporter-hints").css("top",n.top+n.height+r),$("#ddbimporter-hints").css("left",n.left);break;default:$("#ddbimporter-hints").css("top",n.top-Math.round(s.height/2)),$("#ddbimporter-hints").css("left",n.left-Math.round(s.width/2))}if(t.buttons)for(let e of t.buttons){let t=$("<button>"+e+"</button>");$("div.buttons",i).append(t),$(t).on("click",(()=>{$(i).fadeOut(100,(()=>{$(i).remove(),a(e)}))}))}t.hide&&$(t.hide.selector).on(t.hide.event,(()=>{$(i).fadeOut(100,(()=>{$(i).remove(),a(!0)}))}))}))}}const Range=function*(e=0,t=1,a=0){for(let i=0;i<e;yield a+i++*t);};class Utils{static debug(){return!0}static capitalize(e){return"string"!=typeof e?"":e.charAt(0).toUpperCase()+e.slice(1)}static async asyncForEach(e,t){for(let a=0;a<e.length;a+=1)await t(e[a],a,e)}static _range=Range;static arrayRange(e=0,t=1,a=0){return Array.from(Utils._range(e,t,a))}static removeCompendiumLinks(e){function replaceRule(e,t,a){return a?`${a}`:`${t}`}return e.replaceAll(/@\w+\[(.*)\](\{.*?\})/g,replaceRule).replaceAll(/@\w+\[(.*)\]/g,replaceRule)}static normalizeString(e){return e.toLowerCase().replace(/\W/g,"")}static referenceNameString(e){return Utils.nameString(e).replaceAll("'","").replaceAll(/(\w+)([\\|/])(\w+)/g,"$1-$3").slugify({strict:!0})}static idString(e){return e.replace(/[^a-zA-Z0-9]/g,"")}static namedIDStub(e,{prefix:t="ddb",postfix:a=null,length:i=16}={}){const n=e.split(" ").map((e=>Utils.idString(e))),s=i-(t?`${t}`.length:0)-(a?`${a}`.length:0),r=Math.floor(s/n.length);let o=s%n.length,l=`${t??""}`;for(let e=0;e<n.length;e++){const t=n[e].length>r+o?r+o:Math.min(n[e].length,r+o);l+=Utils.capitalize(n[e].substring(0,t));o-=t>r?t-r:0}a&&(l+=a);const d=i-l.length;return d>0&&(l+="I".repeat(d)),l}static nameString(e){return e.replaceAll("’","'").trim()}static regexSanitizeString(e){return e.replace(/[^a-z0-9áéíóúñü \.,_-]/gim,(e=>`\\${e}`)).trim()}static stripHtml(e,t=!1){let a=document.createElement("DIV");return a.innerHTML=e,t?a.innerText??a.textContent??"":a.textContent||a.innerText||""}static htmlToElement(e){const t=document.createElement("template");return e=e.trim(),t.innerHTML=e,t.content.firstChild}static htmlToDoc(e){return(new DOMParser).parseFromString(e,"text/html")}static htmlToDocumentFragment(e){const t=new DocumentFragment;return $.parseHTML(e).forEach((e=>{t.appendChild(e)})),t}static replaceHtmlSpaces(e){return e.replace(/&nbsp;/g," ").replace(/\xA0/g," ").replace(/\s\s+/g," ").trim()}static renderLesserString(e){return Utils.replaceHtmlSpaces(Utils.stripHtml(e)).trim().toLowerCase()}static stringKindaEqual(e,t){return Utils.renderLesserString(e)===Utils.renderLesserString(t)}static findByProperty(e,t,a){let i,n=100;if(Array.isArray(e))return e.filter((e=>Object.prototype.hasOwnProperty.call(e,t))).forEach((e=>{let s=function levenshtein(e,t){let a;if(0===e.length)return t.length;if(0===t.length)return e.length;e.length>t.length&&(a=e,e=t,t=a);let i,n,s,r=e.length,o=t.length,l=Array(r);for(i=0;i<=r;i++)l[i]=i;for(i=1;i<=o;i++)for(s=i,n=1;n<=r;n++)a=l[n-1],l[n-1]=s,s=t[i-1]===e[n-1]?a:Math.min(a+1,Math.min(s+1,l[n]+1));return s}(a,e[t]);s<n&&s<=3&&s<100&&(i=e,n=s)})),i}static calculateModifier(e){return Math.floor((e-10)/2)}static diceStringResultBuild(e,t,a="",i="",n="",s="",r=!1){const o=0===a?"":`${a>0?" +":" "} ${a}`,l=r&&n&&e?n.replace("[]",""):"",d=e.map((({sign:e,count:t,die:a},i)=>`${i?`${e} `:""}${t}d${a}${s}${l}`)).join(" ");return{dice:t,diceMap:e,diceHintString:d,bonus:a,diceString:[d,i,o].join("").trim()}}static parseDiceString(e,t="",a="",i=""){const n=`${e}`.toLowerCase().replace(/[–-–−]/gu,"-").replace(/\s+/gu,"");let s=[],r=[];const o=/(?<rawSign>[+-]*)(?<count>\d+)(?:d(?<die>\d+))?/gu;for(const{groups:e}of n.matchAll(o)){const{rawSign:t="+",count:a,die:i}=e,n=""===t?"+":t.slice(-1);i?s.push({sign:n,count:parseInt(n+a),die:parseInt(i)}):r.push({sign:n,count:parseInt(n+a)})}const l=r.reduce(((e,t)=>e+t.count),0),d=[],c=Utils.groupBy(s,"sign");for(const e of c.values()){const t=Utils.groupBy(e,"die");for(const e of t.values())d.push(e.reduce(((e,t)=>({...e,count:e.count+t.count}))))}d.sort(((e,t)=>e.die<t.die?-1:e.die>t.die?1:e.sign===t.sign?e.count<t.count?-1:e.count>t.count?1:0:"+"===e.sign?-1:1));return Utils.diceStringResultBuild(d,s,l,t,a,i)}static isObject(e){return"object"==typeof e&&!Array.isArray(e)&&null!==e}static isString(e){return"string"==typeof e||e instanceof String}static isArray(e){return Array.isArray(e)}static isBoolean(e){return"boolean"==typeof e}static isFunction(e){return e instanceof Function}static mergeDeep(e,t){let a=Object.assign({},e);return Utils.isObject(e)&&Utils.isObject(t)&&Object.keys(t).forEach((i=>{Utils.isObject(t[i])?i in e?a[i]=Utils.mergeDeep(e[i],t[i]):Object.assign(a,{[i]:t[i]}):Object.assign(a,{[i]:t[i]})})),a}static filterDeprecated(e){for(let t in e)e[t]&&Object.prototype.hasOwnProperty.call(e[t],"_deprecated")&&!0===e[t]._deprecated&&delete e[t],"_deprecated"===t&&!0===e[t]&&delete e[t];return e}static entityMap(){let e=new Map;return e.set("npc","Actor"),e.set("character","Actor"),e.set("monsters","Actor"),e.set("monster","Actor"),e.set("extras","Actor"),e.set("summon","Actor"),e.set("summons","Actor"),e.set("scene","Scene"),e.set("page","JournalEntry"),e.set("journal","JournalEntry"),e.set("journalEntry","JournalEntry"),e.set("compendium","Compendium"),["feat","spell","inventory","equipment","consumable","tool","loot","item","class","backpack","container","magic-items","magic-item-spells","background","classes","subclass","feature","race","trait","species","classfeature"].forEach((t=>{e.set(t,"Item"),t.endsWith("s")||e.set(`${t}s`,"Item")})),e}static versionCompare(e,t,a){let i=a&&a.lexicographical,n=a&&a.zeroExtend,s=e.split("."),r=t.split(".");function isValidPart(e){return(i?/^\d+[A-Za-z]*$/:/^\d+$/).test(e)}if(!s.every(isValidPart)||!r.every(isValidPart))return NaN;if(n){for(;s.length<r.length;)s.push("0");for(;r.length<s.length;)r.push("0")}i||(s=s.map(Number),r=r.map(Number));for(let e=0;e<s.length;++e){if(r.length==e)return 1;if(s[e]>r[e])return 1;if(s[e]<r[e])return-1}return s.length!=r.length?-1:0}static groupBy(e,t){const a=new Map;for(const i of e){const e=i[t],n=a.get(e)??[];n.push(i),a.set(e,n)}return a}static async namePrompt(e){return await new Promise((t=>{new Dialog({title:e,content:'\n    <label class="text-label">\n      <input type="text" name="name"/>\n    </label>\n  ',buttons:{ok:{label:"Okay",callback:async e=>{const a=e.find("input[type='text'][name='name']").val();t(a)}},cancel:{label:"Cancel",callback:()=>{t("")}}},default:"ok",close:()=>{t("")}}).render(!0)}))}static renderPopup(e,t){if(CONFIG.DDBI.POPUPS[e]&&!CONFIG.DDBI.POPUPS[e].close)CONFIG.DDBI.POPUPS[e].focus(),CONFIG.DDBI.POPUPS[e].location.href=t;else{const a=window.innerWidth/window.innerHeight,i=Math.round(.5*window.innerWidth),n=Math.round(.5*window.innerWidth*a);CONFIG.DDBI.POPUPS[e]=window.open(t,"ddb_sheet_popup",`resizeable,scrollbars,location=no,width=${i},height=${n},toolbar=1`)}return!0}static addToProperties(e,t){const a=e?Utils.isArray(e)?new Set(e):e:new Set;return a.add(t),Array.from(a)}static addArrayToProperties(e,t){const a=e?Utils.isArray(e)?new Set(e):e:new Set;return t.forEach((e=>{a.add(e)})),Array.from(a)}static removeFromProperties(e,t){const a=e?Utils.isArray(e)?new Set(e):e:new Set;return a.delete(t),Array.from(a)}static removeArrayFromProperties(e,t){const a=e?Utils.isArray(e)?new Set(e):e:new Set;return t.forEach((e=>{a.delete(e)})),Array.from(a)}static matchProperties(e,t={}){for(const[a,i]of Object.entries(t))if(foundry.Utils.getProperty(e,a)!==i)return!1;return!0}static ordinalSuffixOf(e){let t=e%10,a=e%100;return 1===t&&11!==a?e+"st":2===t&&12!==a?e+"nd":3===t&&13!==a?e+"rd":e+"th"}static async wait(e){return new Promise((t=>{setTimeout(t,e)}))}static async waitFor(e,t=600,a=100){let i=0;for(;!e(i,i*a)&&(n=i,s=t,t<0||n<s);)i++,await Utils.wait(a);var n,s;return i!==t}static munchNote(e,t=!1,a=!1){t?($("#munching-task-name").text(e),$("#ddb-importer-monsters").css("height","auto")):a?($("#munching-task-monster").text(e),$("#ddb-importer-monsters").css("height","auto")):($("#munching-task-notes").text(e),$("#ddb-importer-monsters").css("height","auto"))}static stringIntAdder(e,t){const a=`${e}`.trim().replace(/^[+-]\s*/,""),i=`${t}`.trim().replace(/^[+-]\s*/,"");if(Number.isInteger(parseInt(a))&&Number.isInteger(parseInt(i))){return`${parseInt(a)+parseInt(i)}`}return`${e} ${/^[+-]/.test(`${t}`.trim())?t:`+ ${t}`}`}}var o=a(115);class DDBSources{static getBookName(e){const t=CONFIG.DDB.sources.find((t=>t.name.toLowerCase()==e.toLowerCase()));return t?t.description:""}static getAdjustedSourceBook(e){return["free-rules"].includes(e)?"PHB 2024":"BR"===e?"SRD 5.1":e.replace("-"," ")}static tweakSourceData(e){e.book=DDBSources.getAdjustedSourceBook(e.book),"BR"===e.book&&(e.license="CC-BY-4.0"),game.settings.get("ddb-importer","no-source-book-pages")&&(e.page="")}static getSourceData(e){const t=[];if(e.sources?.length>0){const a=e.sources.some((e=>2===e.sourceType&&1===e.sourceId)),i=e.sources.some((e=>null!==e.pageNumber))?e.sources.filter((e=>null!==e.pageNumber)):a?e.sources.filter((e=>2===e.sourceType&&1===e.sourceId)):e.sources.some((e=>1===e.sourceType))?e.sources.filter((e=>1===e.sourceType)):e.sources;for(const e of i){const a=CONFIG.DDB.sources.find((t=>t.id===e.sourceId)),i={book:a?a.name:"Homebrew",page:e.pageNumber??"",license:"",custom:"",id:a?a.id:9999999};DDBSources.tweakSourceData(i),t.push(i)}}else if(e.sourceIds)for(const a of e.sourceIds){const i=CONFIG.DDB.sources.find((e=>e.id===a)),n={book:i?i.name:"Homebrew",page:e.sourcePageNumber??"",license:"",custom:"",id:i?i.id:9999999};DDBSources.tweakSourceData(n),t.push(n)}else if(e.sourceId){const a=CONFIG.DDB.sources.find((t=>t.id===e.sourceId)),i={book:a?a.name:"Homebrew",page:e.sourcePageNumber??"",license:"",custom:"",id:a?a.id:9999999};DDBSources.tweakSourceData(i),t.push(i)}return t}static parseSource(e){const t=DDBSources.getSourceData(e),a=t.length>0?t.reduce(((e,t)=>e.id>t.id?e:t)):null;return a?(delete a.id,a):{book:"",page:"",license:"",custom:""}}static addSourcesHook(){if(!game.settings.get(o.y.MODULE_ID,"register-source-books"))return;const e=foundry.utils.getProperty(CONFIG,"DDB.sources");if(!e)return;const t={};for(const a of e.filter((e=>e.isReleased&&!o.y.NO_SOURCE_MATCH_IDS.includes(e.id))))t[a.name.replace("-"," ")]=a.description;t.Homebrew="Homebrew",Object.assign(CONFIG.DND5E.sourceBooks,t)}}const l={items:"items",weapons:"items",weapon:"items",item:"items",equipment:"items",consumable:"items",tool:"items",loot:"items",container:"items",inventory:"items",spells:"spells",spell:"spells",feats:"feats",feat:"feats",classes:"classes",class:"classes",subclass:"classes",monster:"monster",summons:"monster",summon:"monster",backgrounds:"backgrounds",background:"backgrounds",traits:"traits",races:"races",race:"races",tattoo:"items","dnd-tashas-cauldron.tattoo":"items"},d={items:["items.json","class-features.json","races.json"],traits:["class-features.json","races.json","general.json","items.json"],spells:["spells.json"],races:["races.json"],feats:["feats.json","class-features.json","races.json","general.json"],classes:["classes.json"],monster:["named-monster-features.json","generic-monster-features.json","spells.json","items.json","general.json"],backgrounds:["backgrounds.json","feats.json","class-features.json","races.json","general.json"]};function sanitiseName(e){return Utils.nameString(e).toLowerCase()}async function loadDataFile(e){s.default.debug(`Getting icon mapping for ${e}`);const t=await y.fileExists("[data] modules/ddb-importer/data",e),a=await y.getFileUrl("[data] modules/ddb-importer/data",e);t||s.default.warn(`Possible missing file, icon load may fail. Fetching ${a}`);return await foundry.utils.fetchJsonWithTimeout(a)}function getIconPath(e,t,a){const i=l[t];if(!i||!CONFIG.DDBI.ICONS[i])return null;const n=CONFIG.DDBI.ICONS[i].find((i=>{const n=sanitiseName(i.name),s=sanitiseName(e.name);return"monster"===t?n===s.split("(")[0].trim()&&i.monster&&sanitiseName(i.monster)==sanitiseName(a):n===s}));if(!n&&"monster"===t){const t=CONFIG.DDBI.ICONS[i].filter((e=>!e.monster)).find((t=>sanitiseName(t.name)===sanitiseName(e.name)));if(t)return t.path;const a=CONFIG.DDBI.ICONS[i].find((t=>sanitiseName(t.name)===sanitiseName(e.name)));if(a)return a.path}return n?n.path:function looseMatch(e,t){const a=e.flags?.ddbimporter?.originalName;if(a){const e=CONFIG.DDBI.ICONS[t].find((e=>sanitiseName(e.name)===sanitiseName(a)));if(e)return e.path}const i=sanitiseName(e.name);if(e.name.includes(":")){const e=i.split(":"),a=CONFIG.DDBI.ICONS[t].find((t=>sanitiseName(t.name)===e[1].trim()));if(a)return a.path;const n=CONFIG.DDBI.ICONS[t].find((t=>sanitiseName(t.name)===e[0].trim()));if(n)return n.path}const n=CONFIG.DDBI.ICONS[t].find((e=>i.split(":")[0].trim().startsWith(sanitiseName(e.name).split(":")[0].trim())));if(n)return n.path;const s=CONFIG.DDBI.ICONS[t].find((e=>sanitiseName(e.name).split(":")[0].trim().startsWith(i.split(":")[0].trim())));if(s)return s.path;if("subclass"===e.type&&e.system.classIdentifier){const a=sanitiseName(e.system.classIdentifier),i=CONFIG.DDBI.ICONS[t].find((e=>sanitiseName(e.name).startsWith(a)));if(i)return i.path}return null}(e,i)}async function loadIconMaps(e){let t=[];return e.filter((e=>l[e])).map((e=>l[e])).filter(((e,t,a)=>a.indexOf(e)===t)).forEach((e=>{t.push(async function loadIconMap(e){if(CONFIG.DDBI.ICONS[e])return;s.default.debug(`Loading Inbuilt Icon Map for ${e}`);let t=[];for(const a of d[e]){const e=await loadDataFile(a);t=t.concat(e)}CONFIG.DDBI.ICONS[e]=t}(e))})),Promise.all(t)}const c={1:'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd"\n  viewBox="0 0 512 512" width="512" height="512">\n    <g>\n      <circle style="fill:#ffffff;stroke:#010101;stroke-width:30;stroke-miterlimit:10;" cx="250" cy="250" r="220">\n      </circle>\n      <text font-family=\'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"\' font-size="300" font-weight="400" fill="black" x="50%" y="52%" text-anchor="middle" stroke="#000000" dy=".3em">REPLACEME</text>\n    </g>\n  </svg>',2:'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd"\n  viewBox="0 0 512 512" width="512" height="512">\n    <g>\n      <circle style="fill:#ffffff;stroke:#010101;stroke-width:30;stroke-miterlimit:10;" cx="250" cy="250" r="220">\n      </circle>\n      <text font-family=\'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"\' font-size="230" font-weight="400" fill="black" x="50%" y="52%" text-anchor="middle" stroke="#000000" dy=".3em">REPLACEME</text>\n    </g>\n  </svg>',3:'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd"\n  viewBox="0 0 512 512" width="512" height="512">\n    <g>\n      <circle style="fill:#ffffff;stroke:#010101;stroke-width:30;stroke-miterlimit:10;" cx="250" cy="250" r="220">\n      </circle>\n      <text font-family=\'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"\' font-size="170" font-weight="400" fill="black" x="50%" y="52%" text-anchor="middle" stroke="#000000" dy=".3em">REPLACEME</text>\n    </g>\n  </svg>',4:'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" style="shape-rendering:geometricPrecision; text-rendering:geometricPrecision; image-rendering:optimizeQuality; fill-rule:evenodd; clip-rule:evenodd"\n  viewBox="0 0 512 512" width="512" height="512">\n    <g>\n      <circle style="fill:#ffffff;stroke:#010101;stroke-width:30;stroke-miterlimit:10;" cx="250" cy="250" r="220">\n      </circle>\n      <text font-family=\'-apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol"\' font-size="140" font-weight="400" fill="black" x="50%" y="52%" text-anchor="middle" stroke="#000000" dy=".3em">REPLACEME</text>\n    </g>\n  </svg>'};function unPad(e,t){return isNaN(parseInt(t))?t:parseInt(t)}class Iconizer{constructor({notifier:e=null}={}){this.notifier=e,e||(this.notifier=(e,t=!1,a=!1)=>{s.default.info(e,{nameField:t,monsterNote:a})})}static async generateIcon(e,t){let a="icons/svg/book.svg",i=t.trim().split(".")[0].split(" ")[0];if(i=i.replace(/(\d+)/,unPad),i.length<=4){a=`assets/icons/${i}.svg`,s.default.info(i);let t=c[i.length];t=t.replace("REPLACEME",i);return await e.importRawFile(a,t,"text/plain",!0)}return a}static async iconPath(e,t=!1,a=""){const i=[e.type];let n;if(t&&i.push("monster"),await loadIconMaps(i),t){const t=getIconPath(e,"monster",a);t&&(n=t)}return n||(n=getIconPath(e,e.type)),n}static async copyInbuiltIcons(e,t=!1,a=""){const i=e.map((e=>e.type)).filter(((e,t,a)=>a.indexOf(e)===t));return t&&i.push("monster"),await loadIconMaps(i),new Promise((i=>{i(e.map((e=>{if(!0!==foundry.utils.getProperty(e,"flags.ddbimporter.keepIcon")){if(t&&!["spell"].includes(e.type)){const t=getIconPath(e,"monster",a);if(t)return e.img=t,e}const i=getIconPath(e,e.type);i&&(e.img=i,e.effects&&e.effects.forEach((e=>{e.img&&""!==e.img||(e.img=i)})))}return e})))}))}static async getSRDIconMatch(e){const t=o.y.SRD_COMPENDIUMS.find((t=>t.type==e)).name,a=m.getCompendium(t,!1);if(!a)return[];return await a.getIndex({fields:["name","img","prototypeToken.texture.src","type","prototypeToken.texture.scaleY","prototypeToken.texture.scaleX"]})}static async getOfficialIconMatch(e){const t=[];for(const a of Object.keys(o.y.FOUNDRY_COMPENDIUMS)){const i=o.y.FOUNDRY_COMPENDIUMS[a].find((t=>t.type==e))?.name;if(!i)continue;const n=m.getCompendium(i,!1);if(!n)continue;const s=["name","img","prototypeToken.texture.src","type","prototypeToken.texture.scaleY","prototypeToken.texture.scaleX"],r=await n.getIndex({fields:s});t.push(...r)}return Array.from(new Set(t))}static async getSRDImageLibrary(){if(CONFIG.DDBI.SRD_LOAD.mapLoaded)return CONFIG.DDBI.SRD_LOAD.iconMap;const e=await Iconizer.getOfficialIconMatch("features"),t=await Iconizer.getOfficialIconMatch("backgrounds"),a=await Iconizer.getOfficialIconMatch("feats"),i=await Iconizer.getOfficialIconMatch("inventory"),n=await Iconizer.getOfficialIconMatch("spells"),s=await Iconizer.getOfficialIconMatch("monsterfeatures"),r=await Iconizer.getOfficialIconMatch("monsters"),o=await Iconizer.getSRDIconMatch("features"),l=await Iconizer.getSRDIconMatch("inventory"),d=await Iconizer.getSRDIconMatch("spells"),c=await Iconizer.getSRDIconMatch("monsterfeatures"),u=await Iconizer.getSRDIconMatch("monsters");return CONFIG.DDBI.SRD_LOAD.iconMap=[...e,...t,...a,...i,...n,...s,...r,...l,...d,...o,...c,...u],CONFIG.DDBI.SRD_LOAD.iconMap}static async copySRDIcons(e,t=null,a=[]){t||(t=await Iconizer.getSRDImageLibrary());return e.map((e=>{s.default.debug(`Matching ${e.name}`);const i=a.find((t=>t.name===e.name));if(i)e.img=i.img;else{const a=NameMatcher.looseItemNameMatch(e,t,!0);a&&(t.push({name:e.name,img:a.img}),e.img=a.img)}return e}))}static async retainExistingIcons(e){return new Promise((t=>{t(e.map((e=>(e.flags.ddbimporter?.ignoreIcon&&(s.default.debug(`Retaining icon for ${e.name} to ${e.flags.ddbimporter.matchedImg}`),e.img=e.flags.ddbimporter.matchedImg),e))))}))}static async getDDBItemImages(e,t){Utils.munchNote("Fetching DDB Item Images");const a=!!t||game.settings.get(o.y.MODULE_ID,"munching-policy-download-images"),i=game.settings.get(o.y.MODULE_ID,"munching-policy-remote-images"),n=game.settings.get(o.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),s=game.settings.get(o.y.MODULE_ID,"use-deep-file-paths"),r=e.map((async e=>{let t={name:e.name,type:e.type,img:null,large:null};const r=s?`/item/${e.type}`:"";if(foundry.utils.hasProperty(e,"flags.ddbimporter.dndbeyond")){if(e.flags.ddbimporter.dndbeyond.avatarUrl){const o=e.flags.ddbimporter.dndbeyond.avatarUrl;if(o&&""!=o){Utils.munchNote(`Downloading ${e.name} image`);const l=s?"":"item",d={type:"item",name:e.name,download:a,remoteImages:i,targetDirectory:n,pathPostfix:r,imageNamePrefix:l},c=await y.getImagePath(o,d);t.img=c}}if(e.flags.ddbimporter.dndbeyond.largeAvatarUrl){const o=e.flags.ddbimporter.dndbeyond.largeAvatarUrl;if(o&&""!=o){const l=s?"":"item",d={type:"item-large",name:s?`${e.name}-large`:e.name,download:a,remoteImages:i,targetDirectory:n,pathPostfix:r,imageNamePrefix:l},c=await y.getImagePath(o,d);t.large=c,t.img||(t.img=c)}}}return Utils.munchNote(""),t}));return Promise.all(r)}static async getDDBHintImages(e,t){Utils.munchNote(`Fetching DDB Hint Images for ${e}`);const a=game.settings.get(o.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),i=game.settings.get(o.y.MODULE_ID,"use-deep-file-paths"),n=i?"":e;for(const s of t){if(s.type!==e||s.img)continue;const t=foundry.utils.getProperty(s,"flags.ddbimporter.ddbImg");if(!t||""===t)continue;const r=i?`/${e}/${s.type}`:"",o={type:e,name:i?`${s.name}`:s.name,download:!0,remoteImages:!1,targetDirectory:a,pathPostfix:r,imageNamePrefix:n},l=await y.getImagePath(t,o);l&&(s.img=l)}return Utils.munchNote(""),t}static async getDDBGenericItemImages(){Utils.munchNote("Fetching DDB Generic Item icons");const e=game.settings.get(o.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),t=game.settings.get(o.y.MODULE_ID,"use-deep-file-paths"),a=t?"":"item",i=t?"/ddb/item":"",n=o.x.items.map((async t=>{const n={type:"item",name:t.filterType,download:!0,targetDirectory:e,pathPostfix:i,imageNamePrefix:a},s=await y.getImagePath(t.img,n);return{filterType:t.filterType,img:s}}));return Utils.munchNote(""),Promise.all(n)}static async getDDBGenericLootImages(){Utils.munchNote("Fetching DDB Generic Loot icons");const e=game.settings.get(o.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),t=game.settings.get(o.y.MODULE_ID,"use-deep-file-paths"),a=t?"":"equipment",i=t?"/ddb/loot":"",n=o.x.genericItemIcons.map((async t=>{const n={type:"equipment",name:t.name,download:!0,targetDirectory:e,pathPostfix:i,imageNamePrefix:a},s=await y.getImagePath(t.img,n);return{name:t.name,img:s}}));return Utils.munchNote(""),Promise.all(n)}static async getDDBGenericItemIcons(e){const t=await Iconizer.getDDBGenericItemImages(),a=await Iconizer.getDDBGenericLootImages();let i=e.map((e=>{if(!["spell","feat","class"].includes(e.type)&&e.flags&&e.flags.ddbimporter&&e.flags.ddbimporter.dndbeyond){let i=null;e.flags.ddbimporter.dndbeyond.filterType?i=t.find((t=>t.filterType===e.flags.ddbimporter.dndbeyond.filterType)):e.flags.ddbimporter.dndbeyond.type&&(i=a.find((t=>t.name===e.flags.ddbimporter.dndbeyond.type))),!i||e.img&&""!=e.img&&e.img!=CONST.DEFAULT_TOKEN||(e.img=i.img)}return e}));return Promise.all(i)}static async getDDBSchoolSpellImages(){Utils.munchNote("Fetching spell school icons");const e=game.settings.get(o.y.MODULE_ID,"other-image-upload-directory").replace(/^\/|\/$/g,""),t=game.settings.get(o.y.MODULE_ID,"use-deep-file-paths"),a=t?"":"spell",i=t?"/spell/school":"",n=o.x.spell.schools.map((async t=>{const n={type:"spell",name:t.name,download:!0,targetDirectory:e,imageNamePrefix:a,pathPostfix:i},s=await y.getImagePath(t.img,n);return{name:t.name,img:s,id:t.id}}));return Utils.munchNote(""),Promise.all(n)}static async getDDBSpellSchoolIcons(e){const t=await Iconizer.getDDBSchoolSpellImages();let a=e.map((e=>{if("spell"==e.type){const a=t.find((t=>t.id===e.system.school));!a||e.img&&""!=e.img&&e.img!=CONST.DEFAULT_TOKEN||(e.img=a.img)}return e}));return Promise.all(a)}static async getDDBEquipmentIcons(e){const t=await Iconizer.getDDBItemImages(e.filter((e=>o.x.types.inventory.includes(e.type))),!0);let a=e.map((e=>{if(o.x.types.inventory.includes(e.type)&&(!e.img||""==e.img||e.img==CONST.DEFAULT_TOKEN)){const a=t.find((t=>t.name==e.name&&t.type==e.type));a&&a.img&&(e.img=a.img,foundry.utils.setProperty(e,"flags.ddbimporter.keepIcon",!0)),a&&a.large&&(e.flags.ddbimporter.dndbeyond.pictureUrl=a.large)}return e}));return Promise.all(a)}static async updateMagicItemImages(e){const t=game.settings.get(o.y.MODULE_ID,"character-update-policy-use-srd-icons"),a=game.settings.get(o.y.MODULE_ID,"character-update-policy-use-ddb-spell-icons"),i=game.settings.get(o.y.MODULE_ID,"character-update-policy-use-inbuilt-icons"),n=game.settings.get(o.y.MODULE_ID,"character-update-policy-use-ddb-item-icons");return e.length>0&&(n&&(s.default.debug("Magic items: adding equipment icons"),e=await Iconizer.getDDBEquipmentIcons(e)),i&&(s.default.debug("Magic items: adding inbuilt icons"),e=await Iconizer.copyInbuiltIcons(e)),t&&(s.default.debug("Magic items: adding srd compendium icons"),e=await Iconizer.copySRDIcons(e)),a&&(s.default.debug("Magic items: adding ddb spell school icons"),e=await Iconizer.getDDBSpellSchoolIcons(e))),e}static async preFetchDDBIconImages(){await Iconizer.getDDBGenericItemImages(),await Iconizer.getDDBGenericLootImages(),await Iconizer.getDDBSchoolSpellImages()}static addItemEffectIcons(e){return s.default.debug("Adding Icons to effects"),e.forEach((e=>{e.effects&&e.img&&(""!==e.img||e.img!==CONST.DEFAULT_TOKEN)&&e.effects.forEach((t=>{t.img&&""!==t.img&&t.img!==CONST.DEFAULT_TOKEN||(t.img=e.img)}))})),e}static addActorEffectIcons(e){return e.effects?(s.default.debug("Adding Icons to actor effects"),e.effects.forEach((t=>{const a=foundry.utils.getProperty(t,"flags.ddbimporter.originName");if(a){const i=e.items.find((e=>e.name===a));i&&(t.img=i.img)}})),e):e}static async updateIcons(e,t=!0,a=!1,i=""){game.settings.get(o.y.MODULE_ID,"munching-policy-use-ddb-item-icons")&&(s.default.debug("DDB Equipment Icon Match"),e=await Iconizer.getDDBEquipmentIcons(e));game.settings.get(o.y.MODULE_ID,"munching-policy-use-inbuilt-icons")&&(e=await Iconizer.getDDBHintImages("class",e),e=await Iconizer.getDDBHintImages("subclass",e),s.default.debug(`Inbuilt icon matching (Monster? ${a?i:a})`),e=await Iconizer.copyInbuiltIcons(e,a,i));game.settings.get(o.y.MODULE_ID,"munching-policy-use-srd-icons")&&t&&(s.default.debug("SRD Icon Matching"),e=await Iconizer.copySRDIcons(e));game.settings.get(o.y.MODULE_ID,"munching-policy-use-ddb-spell-icons")&&(s.default.debug("DDB Spell School Icon Match"),e=await Iconizer.getDDBSpellSchoolIcons(e));game.settings.get(o.y.MODULE_ID,"munching-policy-use-ddb-generic-item-icons")&&(s.default.debug("DDB Generic Item Icon Match"),e=await Iconizer.getDDBGenericItemIcons(e));return game.settings.get(o.y.MODULE_ID,"munching-policy-add-effects")&&(e=Iconizer.addItemEffectIcons(e)),e}}class AdvancedDialog{constructor(e=[],t=[],{title:a="",defaultButton:i="OK",close:n=e=>e({success:!1}),options:s={},render:r=null}={}){this.inputs=e,this.buttons=t,this.dialog=null,this.config={title:a,defaultButtonLabel:i,close:n,options:s,render:r,classes:["dialog","ddb-advanced-dialog"]}}static _generateTableHeaderLabel(e,t){return`<th><label for="ddb-${e}">${t}</label></th>`}static _generateSelectionHtmlStub(e,t,a,i){const n=AdvancedDialog._generateTableHeaderLabel(i,t);switch(e.toLowerCase()){case"button":return"";case"checkbox":return`${n}<td><input type="${e}" id="ddb-${i}" ${a?.checked?"checked":""} value="${i}"/></td>`;case"label":return`<td class="colspan2">${t}</td>`;case"radio":return`${n}<td><input type="${e}" id="ddb-${i}" ${a?.checked?"checked":""} value="${i}" name="${a?.group??"radio"}"/></td>`;case"select":{const e=a.map(((e,t)=>`<option value="${t}" ${e.selected?"selected":""}>${e.label}</option>`)).join("\n");return`${n}<td><select id="ddb-${i}">${e}</select></td>`}case"number":{let t="";if(Utils.isObject(a)){const e=[];for(const[t,i]of Object.entries(a)){const a=`${i}`.trim();e.push(`${t}="${a}"`)}t=e.join(" ")}else if(Array.isArray(a)){const e=[];for(const t of a)e.push(`${t.key}="${t.value}"`);t=e.join(" ")}else t=Utils.isString(a)?`value="${a}"`:'value=""';return`${n}</th><td><input type="${e}" id="ddb-${i}" ${t}/></td>`}default:return`${n}</th><td><input type="${e}" id="ddb-${i}" value="${Array.isArray(a)?a[0]:a}"/></td>`}}_generateSelectionHtml(){return['<table class="ddb-selection-table">',...this.inputs.map((({type:e,label:t,options:a},i)=>`<tr>${AdvancedDialog._generateSelectionHtmlStub(e,t,a,i)}</tr>`)),"</table>"].join("\n")}_parseSelectionResults(e){return this.inputs.map(((t,a)=>{switch(t.type.toLowerCase()){case"label":return null;case"radio":case"checkbox":return e.find(`input#ddb-${a}`)[0].checked;case"number":return e.find(`input#ddb-${a}`)[0].valueAsNumber;case"select":return t.options[e.find(`select#ddb-${a}`).val()].value;default:return e.find(`input#ddb-${a}`)[0].value}}))}}class ChooserDialog extends AdvancedDialog{async ask(){return new Promise((e=>{const t=this.buttons.length>0?this.buttons.reduce(((t,a)=>({...t,[a.label]:{label:a.label,callback:t=>{const i={button:a,results:this._parseSelectionResults(t),inputs:this.inputs,success:!0};Utils.isFunction(a.callback)?e(a.callback(i,t)):e(i)}}})),{}):{defaultButton:{label:this.config.defaultButtonLabel,callback:t=>e({button:{value:"default",label:this.config.defaultButtonLabel},results:this._parseSelectionResults(t),inputs:this.inputs,success:!0})}};this.dialog=new Dialog({title:this.config.title,content:this._generateSelectionHtml(),default:this.buttons.find((e=>e.default))?.label??this.config.defaultButtonLabel,close:(...t)=>this.config.close(e,...t),buttons:t,render:this.config.render},{classes:this.config.classes,focus:!0,...this.config.options}),this.dialog.render(!0)}))}static async Ask(...e){return new ChooserDialog(...e).ask()}}function checkBase64(e){let t=function occurrences(e,t,a){if(e+="",(t+="").length<=0)return e.length+1;let i=0,n=0,s=a?1:t.length;for(;n=e.indexOf(t,n),n>=0;)++i,n+=s;return i}(JSON.stringify(e),"base64");return t>0}function base64Check(){return function checkScenes(){let e=[],t=[];return game.scenes.forEach((a=>{checkBase64(a.thumb)&&(s.default.warn(`Scene ${a.name} has base 64 thumb data - fixing!`),a.createThumbnail().then((e=>{a.update({thumb:e.thumb},{diff:!1}),ui.notifications.info(`Regenerated thumbnail image for ${a.name} background image`)})),e.push(a.name)),checkBase64(a.img)?(s.default.warn(`Scene ${a.name} has base 64 Image data!`),ui.notifications.warn(`${a.name} has a base64 encoded scene image - please fix`),t.push(a.name)):checkBase64(a)&&!checkBase64(a.thumb)&&(s.default.warn(`Scene ${a.name} has unknown location base 64 data!`),s.default.warn(a),t.push(a.name))})),t.length>0&&s.default.warn("Please fix the following scenes with base64 data:",t),{fixedScenes:e,badScenes:t}}()}const u={LOOKUP:[{type:"adventure",compendium:"entity-adventure-compendium"},{type:"adventures",compendium:"entity-adventure-compendium"},{type:"background",compendium:"entity-background-compendium"},{type:"backgrounds",compendium:"entity-background-compendium"},{type:"class",compendium:"entity-class-compendium"},{type:"classes",compendium:"entity-class-compendium"},{type:"classfeatures",compendium:"entity-class-compendium"},{type:"consumable",compendium:"entity-item-compendium"},{type:"container",compendium:"entity-item-compendium"},{type:"custom",compendium:"entity-override-compendium"},{type:"equipment",compendium:"entity-item-compendium"},{type:"feat",compendium:"entity-class-compendium"},{type:"feats",compendium:"entity-feat-compendium"},{type:"feature",compendium:"entity-class-compendium"},{type:"features",compendium:"entity-class-compendium"},{type:"inventory",compendium:"entity-item-compendium"},{type:"item",compendium:"entity-item-compendium"},{type:"items",compendium:"entity-item-compendium"},{type:"journal",compendium:"entity-journal-compendium"},{type:"JournalEntry",compendium:"entity-journal-compendium"},{type:"journals",compendium:"entity-journal-compendium"},{type:"loot",compendium:"entity-item-compendium"},{type:"magicitem",compendium:"entity-item-compendium"},{type:"magicitems",compendium:"entity-item-compendium"},{type:"monster",compendium:"entity-monster-compendium"},{type:"monsters",compendium:"entity-monster-compendium"},{type:"npc",compendium:"entity-monster-compendium"},{type:"override",compendium:"entity-override-compendium"},{type:"race",compendium:"entity-species-compendium"},{type:"races",compendium:"entity-species-compendium"},{type:"species",compendium:"entity-species-compendium"},{type:"RollTable",compendium:"entity-table-compendium"},{type:"spell",compendium:"entity-spell-compendium"},{type:"spell",compendium:"entity-spell-compendium"},{type:"spells",compendium:"entity-spell-compendium"},{type:"subclass",compendium:"entity-class-compendium"},{type:"subclasses",compendium:"entity-class-compendium"},{type:"summon",compendium:"entity-summons-compendium"},{type:"summons",compendium:"entity-summons-compendium"},{type:"table",compendium:"entity-table-compendium"},{type:"tables",compendium:"entity-table-compendium"},{type:"tool",compendium:"entity-item-compendium"},{type:"trait",compendium:"entity-species-compendium"},{type:"traits",compendium:"entity-species-compendium"},{type:"vehicle",compendium:"entity-vehicle-compendium"},{type:"vehicles",compendium:"entity-vehicle-compendium"},{type:"weapon",compendium:"entity-item-compendium"}],getCompendiumLabel:e=>{const t=u.LOOKUP.find((t=>t.type==e)).compendium;return game.settings.get("ddb-importer",t)},getCompendium:(e,t=!0)=>{const a=game.packs.get(e);if(a)return a;if(t)throw s.default.error(`Unable to find compendium ${e}`),ui.notifications.error(`Unable to open the Compendium ${e}. Check the compendium exists and is set in "Module Settings > DDB Importer > Compendiums"`),new Error(`Unable to open the Compendium ${e}. Check the compendium exists and is set in "Module Settings > DDB Importer > Compendiums".`);s.default.info(`Unable to find compendium ${e}`)},getCompendiumType:(e,t=!0)=>{const a=u.getCompendiumLabel(e);s.default.debug(`Getting compendium ${a} for update of ${e}`);const i=u.getCompendium(a,!1);if(i)return i;if(t)throw s.default.error(`Unable to find compendium ${a} for ${e} documents`),ui.notifications.error(`Unable to open the Compendium ${a}. Check the compendium exists and is set in "Module Settings > DDB Importer > Compendiums"`),new Error(`Unable to open the Compendium ${a}. Check the compendium exists and is set in "Module Settings > DDB Importer > Compendiums"`);s.default.info(`Unable to open compendium, skipping compendium ${a} for ${e} integration`)},loadCompendiumIndex:async(e,t={})=>{const a=u.getCompendiumLabel(e);foundry.utils.setProperty(CONFIG.DDBI,`compendium.label.${e}`,a);const i=await u.getCompendium(a);if(i){const a=await i.getIndex(t);return foundry.utils.setProperty(CONFIG.DDBI,`compendium.index.${e}`,a),a}},copyExistingActorProperties:async(e,t)=>{const a=u.getCompendiumType(e);if(game.settings.get("ddb-importer","munching-policy-update-existing")){const e=await a.getDocument(t._id),i=game.settings.get("ddb-importer","munching-policy-update-images");i||e.system.img===CONST.DEFAULT_TOKEN||(t.img=e.system.img),i||foundry.utils.getProperty(e,"prototypeToken.texture.src")===CONST.DEFAULT_TOKEN||(t.prototypeToken.texture.src=e.prototypeToken.texture.src,t.prototypeToken.scale=e.prototypeToken.scale,t.prototypeToken.randomImg=e.prototypeToken.randomImg,t.prototypeToken.mirrorX=e.prototypeToken.mirrorX,t.prototypeToken.mirrorY=e.prototypeToken.mirrorY,t.prototypeToken.lockRotation=e.prototypeToken.lockRotation,t.prototypeToken.rotation=e.prototypeToken.rotation,t.prototypeToken.alpha=e.prototypeToken.alpha,t.prototypeToken.lightAlpha=e.prototypeToken.lightAlpha,t.prototypeToken.lightAnimation=e.prototypeToken.lightAnimation,t.prototypeToken.tint=e.prototypeToken.tint,t.prototypeToken.lightColor=e.prototypeToken.lightColor);game.settings.get("ddb-importer","munching-policy-monster-retain-biography")&&(t.system.details.biography=e.system.details.biography),DDBItemImporter.copySupportedItemFlags(e.toObject(),t)}return t},getActorIndexActor:async(e,t)=>{const a=game.settings.get("ddb-importer","munching-policy-legacy-postfix");return(await u.loadCompendiumIndex(e,{fields:["name","flags.ddbimporter.id"]})).contents.find((e=>foundry.utils.hasProperty(e,"flags.ddbimporter.id")&&e.flags.ddbimporter.id==t.flags.ddbimporter.id&&(!a&&e.name.toLowerCase()===t.name.toLowerCase()||a&&t.flags.ddbimporter.isLegacy&&t.name.toLowerCase().startsWith(e.name.toLowerCase())||a&&e.name.toLowerCase()===t.name.toLowerCase())))},existingActorCheck:async(e,t)=>{const a=await u.getActorIndexActor(e,t);return a?(s.default.debug(`Found existing ${e}, updating: ${a.name}`),t._id=a._id,t=await u.copyExistingActorProperties(e,t)):s.default.debug(`No existing compendium match for ${t.name}`),t},sanitize:e=>e&&"string"==typeof e?e.replace(/\s|\./g,"-").toLowerCase():e,getDefaultCompendiumName:e=>{const t=u.sanitize(e);return`ddb-${game.world.id}-${t}`},createIfNotExists:async({label:e,type:t,id:a,packageType:i="world",folderId:n=null,dnd5eTypeTags:r=[],version:l=null}={})=>{a?s.default.debug(`Checking if Compendium with id ${a} exists for ${o.y.MODULE_ID}`):e&&s.default.debug(`Checking if Compendium with label ${e} exists for ${o.y.MODULE_ID}`);const d=await game.packs.get(a)??game.packs.find((t=>t.metadata.label===e));if(d)return s.default.debug(`Compendium '${a}' (${d.metadata.label}) found, will not create compendium.`),{compendium:d,created:!1};{s.default.info(`Compendium for ${e}, was not found, creating it now.`);const r=u.getDefaultCompendiumName(e);if(await game.packs.get(`${i}.${r}`))return s.default.error(`Could not load Compendium '${a}', and could not create default Compendium '${r}' as it already exists. Please check your DDB Importer Compendium setup.`),{compendium:null,created:!1};{const a=await CompendiumCollection.createCompendium({type:t,label:e,name:r,package:i,flags:{ddbimporter:{schema:l}}});return n&&await a.setFolder(n),{compendium:a,created:!0}}}},getCompendiumNames:()=>o.y.COMPENDIUMS.map((e=>game.settings.get(o.y.MODULE_ID,e.setting))),deleteDefaultCompendiums:(e=!0)=>{e||s.default.warn("Pass 'true' to this function to force deletion."),game.settings.set(o.y.MODULE_ID,"auto-create-compendium",!1);const t=foundry.utils.deepClone(o.y.DEFAULT_SETTINGS),a=o.y.APPLY_GLOBAL_DEFAULTS(t.READY.COMPENDIUMS);for(const[e,t]of Object.entries(a)){const a=u.getDefaultCompendiumName(t.default);s.default.warn(`Setting: ${e} : Deleting compendium ${t.name} with key world.${a}}`),game.packs.delete(`world.${a}`)}},queryCompendiumEntry:async(e,t,a=!1)=>{t=Utils.normalizeString(t);const i=game.packs.get(e);if(!i)return null;let n=(await i.getIndex()).find((e=>Utils.normalizeString(e.name)===t));if(n&&a){return await i.getDocument(n._id)}return n||null},queryCompendiumEntries:async(e,t,a=!1)=>{let i=game.packs.get(e);if(!i)return null;let n=await i.getIndex();n=n.map((e=>(e.normalizedName=Utils.normalizeString(e.name),e)));let s=t.map((e=>{if(-1!==e.search(/(.+)\(([^()]+)\)*/)){const t=e.match(/(.+)\(([^()]+)\)*/);return{name:Utils.normalizeString(t[1].trim()),restriction:t[2].trim()}}return{name:Utils.normalizeString(e),restriction:null}})).map((e=>{let t=n.find((t=>t.normalizedName===e.name));return t?{_id:t._id,name:e.restriction?`${t.name} (${e.restriction})`:t.name}:null}));if(a){return await Promise.all(s.map((e=>new Promise((t=>{e?i.getDocument(e._id).then((a=>{a.name=e.name,delete a.id,delete a.ownership,t(a)})):t(null)})))))}return s},queryCompendium:async(e,t,a=!1)=>{t=Utils.normalizeString(t);let i=game.packs.get(e);if(!i)return null;let n=(await i.getIndex()).find((e=>Utils.normalizeString(e.name)===t));if(n&&a){return await i.getEntity(n._id)}return n||null},async retrieveMatchingCompendiumItems(e,t){const a=e.map((e=>"string"==typeof e?e:"object"==typeof e&&Object.prototype.hasOwnProperty.call(e,"name")?e.name:""));return(await u.queryCompendiumEntries(t,a,!0)).filter((e=>null!==e))},async createFolder({pack:e,name:t,parentId:a=null,color:i="",folderId:n=null,flagTag:r="",flags:o={},entityType:l}={}){s.default.debug("Finding folder",{folders:e.folders,parentId:a});const d=e.folders.find((e=>e.name===t&&r===e.flags?.ddbimporter?.flagTag&&(null===a||a===e.folder?._id)));if(d)return d;s.default.debug(`Creating folder ${t}`,{folders:e.folders,parentId:a,flagTag:r});return await Folder.create({_id:n,name:t,color:i,type:l,folder:a,flags:{ddbimporter:foundry.utils.mergeObject({flagTag:r},o)}},{pack:e.metadata.id,keepId:!0})}},m=u;class Crosshairs extends MeasuredTemplate{constructor(e,t={}){const a={t:e.shape??"circle",user:game.user.id,distance:e.size,x:e.x,y:e.y,document:{fillColor:e.fillColor},width:1,texture:e.texture,direction:e.direction};super(new CONFIG.MeasuredTemplate.documentClass(a,{parent:canvas.scene})),this.icon=e.icon??Crosshairs.ERROR_TEXTURE,this.label=e.label,this.labelOffset=e.labelOffset,this.tag=e.tag,this.drawIcon=e.drawIcon,this.drawOutline=e.drawOutline,this.fillAlpha=e.fillAlpha,this.tileTexture=e.tileTexture,this.lockSize=e.lockSize,this.lockPosition=e.lockPosition,this.resolution=e.resolution,this.callbacks=t,this.inFlight=!1,this.cancelled=!0,this.rightX=0,this.rightY=0,this.radius=this.document.distance*this.scene.grid.size/2}static defaultCrosshairsConfig(){return{size:canvas.dimensions.distance,icon:"icons/svg/dice-target.svg",label:"",labelOffset:{x:0,y:0},tag:"crosshairs",drawIcon:!0,drawOutline:!0,resolution:2,fillAlpha:0,tileTexture:!1,lockSize:!0,lockPosition:!1,rememberControlled:!1,texture:null,direction:0,fillColor:game.user.color}}static async showCrosshairs(e={},t={}){let a=[];if((e=foundry.utils.mergeObject(e,Crosshairs.defaultCrosshairsConfig(),{overwrite:!1})).rememberControlled&&(a=canvas.tokens.controlled),!Object.prototype?.hasOwnProperty?.call(e,"x")&&!Object.prototype?.hasOwnProperty?.call(e,"y")){let t=canvas.app.renderer.events.pointer.getLocalPosition(canvas.app.stage);t=Crosshairs.getSnappedPosition(t,e.resolution),e.x=t.x,e.y=t.y}const i=new Crosshairs(e,t);await i.drawPreview();let n=i.toObject();for(const e of a)e.control({releaseOthers:!1});return n}toObject(){const e=foundry.utils.mergeObject(this.document.toObject(),{cancelled:this.cancelled,scene:this.scene,radius:this.radius,size:this.document.distance});return delete e.width,e}static collectPlaceables(e,t="Token",a=Crosshairs._containsCenter){let i=Array.isArray(t);i||(t=[t]);let n=t.reduce(((t,i)=>{let n=e.scene.getEmbeddedCollection(i).filter((t=>a(t.object,e)));return t[i]=n,t}),{});return i?n:n[t[0]]}static _containsCenter(e,t){var a,i;return(a=e.center,i=t,Math.hypot(a.x-i.x,a.y-i.y))<=t.radius}static getCrosshair(e){return canvas.templates.preview.children.find((t=>t.tag===e))}static getSnappedPosition({x:e,y:t},a){const i=a<0?canvas.grid.size/2:0,n=canvas.grid.getSnappedPoint({x:e-i,y:t-i},{mode:1,resolution:a});return{x:n.x+i,y:n.y+i}}static ERROR_TEXTURE="icons/svg/hazard.svg";async drawPreview(){return await this.draw(),this.layer.preview.addChild(this),this.layer.interactiveChildren=!1,this.inFlight=!0,this.activatePreviewListeners(),this.callbacks?.show?.(this),await Utils.waitFor((()=>!this.inFlight),-1),this.activeHandlers&&this.clearHandlers(),this}async draw(){this.clear();const e=this.document.texture;return this._texture=e?await loadTexture(e,{fallback:"icons/svg/hazard.svg"}):null,this.template=this.addChild(new PIXI.Graphics),this.controlIcon=this.addChild(this._drawControlIcon()),this.ruler=this.addChild(Crosshairs.drawRulerText()),this.refresh(),this._setRulerText(),this.id&&this.activateListeners(),this}_setRulerText(){this.ruler.text=this.label,this.ruler.position.set(-this.ruler.width/2+this.labelOffset.x,this.template.height/2+5+this.labelOffset.y)}static drawRulerText(){const e=CONFIG.canvasTextStyle.clone();e.fontSize=Math.max(Math.round(.36*canvas.dimensions.size*12)/12,36);const t=new PreciseText(null,e);return t.anchor.set(0,0),t}_drawControlIcon(){const e=Math.max(20*Math.round(.5*canvas.dimensions.size/20),40);let t=new ControlIcon({texture:this.icon,size:e});return t.visible=this.drawIcon,t.pivot.set(.5*e,.5*e),t.angle=this.document.direction,t}refresh(){if(!this.template||this._destroyed)return;let e=canvas.dimensions;const t=this.document;this.position.set(t.x,t.y);let{direction:a,distance:i}=t;if(i*=e.size/2,a=Math.toRadians(a),this.ray=Ray.fromAngle(t.x,t.y,a,i),this.t=this.computeShape(this),this.template.clear().lineStyle(this._borderThickness,this.document.borderColor,this.drawOutline?.75:0),this._texture){let e=this.tileTexture?1:2*i/this._texture.width,t=this.tileTexture?0:i;this.template.beginTextureFill({texture:this._texture,matrix:(new PIXI.Matrix).scale(e,e).translate(-t,-t)})}else this.template.beginFill(this.document.fillColor,this.fillAlpha);this.template.drawShape(this.t),this.drawIcon&&(this.controlIcon.visible=!0,this.controlIcon.border.visible=this._hover,this.controlIcon.angle=t.direction),this._setRulerText()}get layer(){return canvas.activeLayer}activatePreviewListeners(){this.moveTime=0,this.initTime=Date.now(),this.removeAllListeners(),this.activeMoveHandler=this._mouseMoveHandler.bind(this),this.activeLeftClickHandler=this._leftClickHandler.bind(this),this.rightDownHandler=this._rightDownHandler.bind(this),this.rightUpHandler=this._rightUpHandler.bind(this),this.activeWheelHandler=this._mouseWheelHandler.bind(this),this.clearHandlers=this._clearHandlers.bind(this),canvas.stage.on("mousemove",this.activeMoveHandler),canvas.stage.on("mousedown",this.activeLeftClickHandler),canvas.app.view.onwheel=this.activeWheelHandler,canvas.app.view.onmousedown=this.rightDownHandler,canvas.app.view.onmouseup=this.rightUpHandler}_mouseMoveHandler(e){if(e.stopPropagation(),this.lockPosition)return;let t=Date.now();if(t-this.moveTime<=20)return;const a=e.data.getLocalPosition(this.layer),{x:i,y:n}=Crosshairs.getSnappedPosition(a,this.resolution);this.document.updateSource({x:i,y:n}),this.refresh(),this.moveTime=t,t-this.initTime>1e3&&canvas._onDragCanvasPan(e.data.originalEvent)}_leftClickHandler(e){e.preventDefault();const t=this.document,a=this.scene.grid.size,i=Crosshairs.getSnappedPosition(this.document,this.resolution);return this.radius=t.distance*a/2,this.cancelled=!1,this.document.updateSource({...i}),this.clearHandlers(e),!0}_mouseWheelHandler(e){e.ctrlKey&&e.preventDefault(),e.altKey||e.stopPropagation();const t=canvas.grid.type>CONST.GRID_TYPES.SQUARE?30:15,a=e.ctrlKey?t:5,i=this.document,n=this.scene.grid.size;if(e.shiftKey&&!this.lockSize){let t=i.distance+.25*Math.sign(e.deltaY);t=Math.max(t,.25),this.document.updateSource({distance:t}),this.radius=i.distance*n/2}else if(!e.altKey){const t=i.direction+a*Math.sign(e.deltaY);this.document.updateSource({direction:t})}this.refresh()}_rightDownHandler(e){2===e.button&&(this.rightX=e.screenX,this.rightY=e.screenY)}_rightUpHandler(e){if(2!==e.button)return;const isWithinThreshold=(e,t)=>Math.abs(e-t)<10;isWithinThreshold(this.rightX,e.screenX)&&isWithinThreshold(this.rightY,e.screenY)&&(this.cancelled=!0,this.clearHandlers(e))}_clearHandlers(e){this.template.destroy(),this._destroyed=!0,this.layer.preview.removeChild(this),this.inFlight=!1,canvas.stage.off("mousemove",this.activeMoveHandler),canvas.stage.off("mousedown",this.activeLeftClickHandler),canvas.app.view.onmousedown=null,canvas.app.view.onmouseup=null,canvas.app.view.onwheel=null,this.actorSheet&&this.actorSheet.maximize(),canvas.mouseInteractionManager.reset({interactionData:!0}),this.layer.interactiveChildren=!0}computeShape(e){let t=e._computeShape();if("rect"===e.document.t){let e=this.document.distance*this.scene.grid.size;t.height=e,t.width=e,t.y=this.scene.grid.size/-2,t.x=this.scene.grid.size/-2}else"ray"===e.document.t||"circle"!==e.document.t||game.settings.get("core","gridTemplates")||(t.radius=Math.round(t.radius/(canvas.grid.size/2))*(canvas.grid.size/2));return t}static async aimCrosshair({token:e,maxRange:t,crosshairsConfig:a,centerpoint:i,drawBoundries:n,customCallbacks:s,trackDistance:r=!0,fudgeDistance:o=0,validityFunctions:l=[]}={}){let d,c,u=0,m=0;if(!i&&e){let t=e.document.width/2;m+=canvas.grid.distance*Math.floor(t),o||m===t*canvas.grid.distance||(o=2.5),o+=m}i=i??e?.center??canvas.app.renderer.events.pointer.getLocalPosition(canvas.app.stage);const p={show:async s=>{if(t&&n){let e=canvas.grid.size*((t+o+m)/canvas.grid.distance);d=new PIXI.Graphics,d.lineStyle(5,16777215),game.settings.get("core","gridTemplates")&&game.settings.get("core","gridDiagonals")!==CONST.GRID_DIAGONALS.EXACT?d.drawPolygon(canvas.grid.getCircle(i,t+o+m)):d.drawCircle(i.x,i.y,e),d.tint=3329330,c=new PIXI.Container,c.addChild(d),canvas.drawings.addChild(c)}for(;s.inFlight;)await Utils.wait(100),r&&(u=canvas.grid.measurePath([i,s]).distance.toNearest(.01),u=Math.max(0,u-m),e.checkCollision(s,{origin:e.center,type:"move",mode:"any"})||u>t||l.some((e=>!e(s)))?(s.icon="icons/svg/hazard.svg",d&&(d.tint=16711680)):(s.icon=a?.icon,d&&(d.tint=3329330)),s.draw(),s.label=u+"/"+t+"ft.")},...s??{}};let g={};if(r&&(g.label="0ft"),g={...g,...a},!t){return await Crosshairs.showCrosshairs(g)}const h=await Crosshairs.showCrosshairs(g,p);return d&&(d.destroy(),c.destroy()),h}}class DDBCampaigns{static getCampaignId(e=null){const t=game.settings.get("ddb-importer","campaign-id").split("/").pop();return t&&""!==t&&!Number.isInteger(parseInt(t))?(e&&e(`Campaign Id is invalid! Set to "${t}", using empty string`,!0),s.default.error(`Campaign Id is invalid! Set to "${t}", using empty string`),""):t.includes("join")?(e&&e(`Campaign URL is a join campaign link, using empty string! Set to "${t}"`,!0),s.default.error(`Campaign URL is a join campaign link, using empty string! Set to "${t}"`),""):t}static getDDBCampaigns(e=null){const t=e||getCobalt(),a=h.getProxy(),i={cobalt:t,betaKey:S.getPatreonKey()};return new Promise(((e,t)=>{fetch(`${a}/proxy/campaigns`,{method:"POST",cache:"no-cache",headers:{"Content-Type":"application/json"},body:JSON.stringify(i)}).then((e=>e.json())).then((t=>{t.success?e(t.data):(s.default.error(`Campaign fetch failed, got the following message: ${t.message}`,t),e([]))})).catch((e=>{s.default.error("Cobalt cookie check error"),s.default.error(e),s.default.error(e.stack),t(e)}))}))}static async refreshCampaigns(e=null){if(e){const t=await DDBCampaigns.getDDBCampaigns(e);CONFIG.DDBI.CAMPAIGNS=t}return CONFIG.DDBI.CAMPAIGNS}static async getAvailableCampaigns(e=null){if(CONFIG.DDBI.CAMPAIGNS)return CONFIG.DDBI.CAMPAIGNS;CONFIG.DDBI.CAMPAIGNS=[];const t=DDBCampaigns.getCampaignId(e),a=await DDBCampaigns.getDDBCampaigns();return a&&0!==a.length?a&&a.length>0&&(CONFIG.DDBI.CAMPAIGNS=a):t&&""!==t.trim()&&(CONFIG.DDBI.CAMPAIGNS=[{id:t,name:"Unable to fetch campaigns, showing only selected",dmUsername:t}]),CONFIG.DDBI.CAMPAIGNS.forEach((e=>{const a=parseInt(e.id)===parseInt(t);e.selected=a})),CONFIG.DDBI.CAMPAIGNS}}class DDBCompendiumFolders{static SCHEMA_SUPPORT={feature:1,class:1,race:1,trait:1,subclass:1,feat:1};resetFolderLookups(){this.rootItemFolders={},this.equipmentFolders={},this.weaponFolders={},this.trinketFolders={},this.consumableFolders={},this.lootFolders={},this.toolFolders={},this.containerFolders={},this.validFolderIds=[],this.classFolders={},this.subClassFolders={},this.subClassFeaturesFolder={},this.speciesFolders={},this.traitSubFolders={},this.summonFolders={},this.summonSubFolders={},this.featFolders={},this.backgroundFolders={}}constructor(e,{packName:t=null,noCreateClassFolders:a=!1}={}){this.type=e,this.packName=t,this.resetFolderLookups(),this.entityTypes=Utils.entityMap(),this.entityType=this.entityTypes.get(e),this.compendiumFolderTypeMonster=game.settings.get("ddb-importer","munching-selection-compendium-folders-monster"),this.compendiumFolderTypeSpell=game.settings.get("ddb-importer","munching-selection-compendium-folders-spell"),this.compendiumFolderTypeItem=game.settings.get("ddb-importer","munching-selection-compendium-folders-item"),this.noCreateClassFolders=a}async addCompendiumFolderIds(e){const t=e.map((async e=>{const t=await this.getFolderId(e);return t&&(e.folder=t),e}));return Promise.all(t)}async loadCompendium(e=null){e&&(this.packName=await m.getCompendiumLabel(e),this.entityType=this.entityTypes.get(e)),this.compendium=m.getCompendium(this.packName),await this.createCompendiumFolders()}async createCompendiumFolder({name:e,parentId:t=null,color:a="#6f0006",folderId:i=null,flagTag:n=""}={}){return await m.createFolder({pack:this.compendium,name:e,parentId:t,color:a,folderId:i,flagTag:n,entityType:this.entityType})}async createCreatureTypeCompendiumFolders(){for(const e of CONFIG.DDB.monsterTypes){const t=this.getFolder(e.name)??await this.createCompendiumFolder({name:e.name,color:"#6f0006"});this.validFolderIds.push(t._id)}}async createAlphabeticalCompendiumFolders(){for(let e=9;++e<36;){const t=e.toString(36).toUpperCase(),a=this.getFolder(t)??await this.createCompendiumFolder({name:t,color:"#6f0006"});this.validFolderIds.push(a._id)}}async createChallengeRatingCompendiumFolders(){for(const e of CONFIG.DDB.challengeRatings){const t=String(e.value).padStart(2,"0"),a=this.getFolder(`CR ${t}`)??await this.createCompendiumFolder({name:`CR ${t}`,color:"#6f0006"});this.validFolderIds.push(a._id)}}async createSpellLevelCompendiumFolders(){for(const e of o.x.COMPENDIUM_FOLDERS.SPELL_LEVEL){s.default.debug(`Checking for folder '${e}'`);const t=this.getFolder(e)??await this.createCompendiumFolder({name:e});this.validFolderIds.push(t._id)}}async createSpellSchoolCompendiumFolders(){for(const e of o.x.spell.schools){const t=Utils.capitalize(e.name);s.default.debug(`Checking for folder '${t}'`);const a=this.getFolder(t)??await this.createCompendiumFolder({name:t});this.validFolderIds.push(a._id)}}async createItemRarityCompendiumFolders(){for(const e of o.x.COMPENDIUM_FOLDERS.RARITY){s.default.debug(`Checking for folder '${e}'`);const t=this.getFolder(e,e)??await this.createCompendiumFolder({name:e,flagTag:e});this.validFolderIds.push(t._id)}}async createItemTypeCompendiumFolders(){for(const[e,t]of Object.entries(o.x.COMPENDIUM_FOLDERS.ITEM_ROOT)){const a=t;s.default.debug(`Checking for root folder '${t}' with key '${e}'`);const i=this.getFolder(t,a)??await this.createCompendiumFolder({name:t,flagTag:t});this.rootItemFolders[e]=i,this.validFolderIds.push(i._id)}s.default.debug("Root item folders",this.rootItemFolders);for(const[e,t]of Object.entries(o.x.COMPENDIUM_FOLDERS.EQUIPMENT)){const a=`equipment/${t}`;s.default.debug(`Checking for Equipment folder '${t}' with key '${e}'`);const i=this.getFolder(t,a)??await this.createCompendiumFolder({name:t,parentId:this.rootItemFolders.equipment._id,color:"#222222",flagTag:a});this.equipmentFolders[e]=i,this.validFolderIds.push(i._id)}for(const[e,t]of Object.entries(o.x.COMPENDIUM_FOLDERS.WEAPON)){const a=`weapon/${t}`;s.default.debug(`Checking for Weapon folder '${t}' with key '${e}'`);const i=this.getFolder(t,a)??await this.createCompendiumFolder({name:t,parentId:this.rootItemFolders.weapon._id,color:"#222222",flagTag:a});this.weaponFolders[e]=i,this.validFolderIds.push(i._id)}for(const[e,t]of Object.entries(o.x.COMPENDIUM_FOLDERS.TOOLS)){const a=`tool/${t}`;s.default.debug(`Checking for Tool folder '${t}' with key '${e}'`);const i=this.getFolder(t,a)??await this.createCompendiumFolder({name:t,parentId:this.rootItemFolders.tool._id,color:"#222222",flagTag:a});this.toolFolders[e]=i,this.validFolderIds.push(i._id)}for(const e of o.x.COMPENDIUM_FOLDERS.TRINKET){const t=`trinket/${e}`;s.default.debug(`Checking for Equipment\\Trinket folder '${e}'`);const a=this.getFolder(e,t)??await this.createCompendiumFolder({name:e,parentId:this.equipmentFolders.trinket._id,color:"#444444",flagTag:t});this.trinketFolders[e]=a,this.validFolderIds.push(a._id)}for(const e of o.x.COMPENDIUM_FOLDERS.CONSUMABLE){const t=`consumable/${e}`;s.default.debug(`Checking for Consumable folder '${e}'`);const a=this.getFolder(e,t)??await this.createCompendiumFolder({name:e,parentId:this.rootItemFolders.consumable._id,color:"#222222",flagTag:t});this.consumableFolders[e]=a,this.validFolderIds.push(a._id)}for(const e of o.x.COMPENDIUM_FOLDERS.LOOT){const t=`loot/${e}`;s.default.debug(`Checking for Loot folder '${e}'`);const a=this.getFolder(e,t)??await this.createCompendiumFolder({name:e,parentId:this.rootItemFolders.loot._id,color:"#222222",flagTag:t});this.lootFolders[e]=a,this.validFolderIds.push(a._id)}for(const e of o.x.COMPENDIUM_FOLDERS.CONTAINER){const t=`container/${e}`;s.default.debug(`Checking for Container folder '${e}'`);const a=this.getFolder(e,t)??await this.createCompendiumFolder({name:e,parentId:this.rootItemFolders.container._id,color:"#222222",flagTag:t});this.containerFolders[e]=a,this.validFolderIds.push(a._id)}}async _createFeatParentFolder(e){const t=DDBCompendiumFolders.getSourceFolderName({document:e,type:"feat"});s.default.debug(`Checking for Feat Parent folder '${t.name}'`);const a=this.getFolder(t.name,t.flagTag);if(a)return a;s.default.debug(`Not found, creating Feat Parent folder '${t.name}'`,t);const i=await this.createCompendiumFolder({name:t.name,flagTag:t.flagTag});return this.validFolderIds.push(i._id),i}async createFeatFolder(e){const t=await this._createFeatParentFolder(e),a=DDBCompendiumFolders.getFeatFolderName(e);s.default.debug(`Checking for Feat folder '${a.name}'`);const i=this.getFolder(a.name,a.flagTag);if(i)return i;s.default.debug(`Not found, creating Feat folder '${a.name}'`);const n=await this.createCompendiumFolder({name:a.name,flagTag:a.flagTag,parentId:t._id});return this.validFolderIds.push(n._id),n}async createFeatureFolder(e,t,a,{tagPrefix:i="features",color:n="#222222"}={}){const s=`${i}/${e}/${t}`,r=this.getFolder(t,s)??await this.createCompendiumFolder({name:t,parentId:a,color:n,flagTag:s});return this.validFolderIds.push(r._id),r}async createClassFolder(e){const t=this.getFolder(e)??await this.createCompendiumFolder({name:e});return this.classFolders[e]=t._id,this.validFolderIds.push(t._id),t}async createClassFeatureFolder(e){s.default.debug(`Checking for class folder '${e}'`);const t=this.classFolders[e]??(await this.createClassFolder(e))._id,a=`features/${e}`,i=this.getFolder("Class Features",a)??await this.createCompendiumFolder({name:"Class Features",parentId:t,color:"#222222",flagTag:a});this.validFolderIds.push(i._id),await this.createFeatureFolder(e,"Optional Features",t),"Artificer"===e?await this.createFeatureFolder(e,"Infusions",t):"Sorcerer"===e?await this.createFeatureFolder(e,"Metamagic",t):"Warlock"===e&&(await this.createFeatureFolder(e,"Invocations",t),await this.createFeatureFolder(e,"Packs",t))}async createClassFeatureFolders(){if(this.noCreateClassFolders)return;const e=CONFIG.DDB.classConfigurations.filter((e=>!e.name.includes("archived")&&!e.name.includes("(UA)"))).map((e=>e.name));for(const t of e)await this.createClassFeatureFolder(t)}async createClassFeaturesHolderFolder(e,t){const a=`features/subclass/${e}`,i=this.getFolder("Subclass Features",a)??await this.createCompendiumFolder({name:"Subclass Features",parentId:t,color:"#222222",flagTag:a});return this.validFolderIds.push(i._id),i}async createSubClassFeatureFolder(e,t){s.default.debug(`Checking for Subclass folder '${e}' with Parent Class '${t}'`);const a=this.classFolders[t]??(await this.createClassFolder(t))._id;await this.createClassFeatureFolder(t);const i=this.subClassFeaturesFolder[t]??(await this.createClassFeaturesHolderFolder(t,a))._id,n=`features/${e}`,r=this.getFolder(e,n)??await this.createCompendiumFolder({name:`${e}`,parentId:i,color:"#222222",flagTag:n});this.subClassFolders[e]=r,this.validFolderIds.push(r._id),"Fighter"===t&&"Battle Master"===e?await this.createFeatureFolder(e,"Maneuver Options",a):"Fighter"===t&&"Rune Knight"===e&&await this.createFeatureFolder(e,"Runes",a)}async getSpeciesBaseFolder(e){s.default.debug(`Checking for species folder '${e}'`);const t=this.getFolder(e,`species/${e}`);if(t)return t;s.default.debug(`Not found, creating species folder '${e}'`);const a=await this.createCompendiumFolder({name:e,flagTag:`species/${e}`});return this.validFolderIds.push(a._id),this.speciesFolders[e]=a,a}async createBaseSpeciesFolders(){const e=CONFIG.DDB.raceGroups.map((e=>e.name));for(const t of e)await this.getSpeciesBaseFolder(t)}async createSubTraitFolders(e,t){const a=`trait/${e}/${t}`;s.default.debug(`Checking for Species folder '${t}' with Base Species '${e}'`);const i=await this.getSpeciesBaseFolder(e),n=t===e?"Traits":`${t} Traits`,r=this.getFolder(t,a)??await this.createCompendiumFolder({name:n,parentId:i._id,color:"#222222",flagTag:a});this.traitSubFolders[t]=r,this.validFolderIds.push(r._id)}async createSummonsFolder(e){const t=`summons/${e}`;s.default.debug(`Checking for Summons folder '${e}'`);const a=this.getFolder(e,t);if(a)return a;s.default.debug(`Not found, creating summons folder '${e}'`);const i=await this.createCompendiumFolder({name:e,flagTag:t});return this.validFolderIds.push(i._id),this.summonFolders[e]=i,i}async createBackgroundFolder(e){const t=DDBCompendiumFolders.getBackgroundFolderName(e);if(this.backgroundFolders[t.name])return this.backgroundFolders[t.name];s.default.debug(`Checking for Background folder '${t.name}'`);const a=this.getFolder(t.name,t.flagTag);if(a)return a;s.default.debug(`Not found, creating backgrounds folder '${t.name}'`);const i=await this.createCompendiumFolder({name:t.name,flagTag:t.flagTag});return this.validFolderIds.push(i._id),this.backgroundFolders[t.name]=i,i}async createSummonsSubFolder(e,t){const a=`summons/${e}/${t}`;s.default.debug(`Checking for Summons folder '${t}' with Base Folder '${t}'`);const i=await this.createSummonsFolder(e),n=this.getFolder(t,a)??await this.createCompendiumFolder({name:t,parentId:i._id,color:"#222222",flagTag:a});this.summonSubFolders[t]=n,this.validFolderIds.push(n._id)}async createCompendiumFolders(){switch(s.default.debug(`Checking and creating Compendium folder structure for ${this.type}`),this.resetFolderLookups(),this.type){case"monsters":case"npc":case"monster":switch(this.compendiumFolderTypeMonster){case"TYPE":await this.createCreatureTypeCompendiumFolders();break;case"ALPHA":await this.createAlphabeticalCompendiumFolders();break;case"CR":await this.createChallengeRatingCompendiumFolders()}break;case"spell":case"spells":switch(this.compendiumFolderTypeSpell){case"SCHOOL":await this.createSpellSchoolCompendiumFolders();break;case"LEVEL":await this.createSpellLevelCompendiumFolders()}break;case"inventory":case"item":case"items":switch(this.compendiumFolderTypeItem){case"TYPE":await this.createItemTypeCompendiumFolders();break;case"RARITY":await this.createItemRarityCompendiumFolders()}break;case"subclass":case"subclasses":case"features":await this.createClassFeatureFolders()}return this.compendium.folders}static getItemCompendiumFolderNameForRarity(e){let t;const a=e.system.rarity;if(a&&""!=a)switch(a.toLowerCase().trim()){case"common":t="Common";break;case"uncommon":t="Uncommon";break;case"rare":t="Rare";break;case"very rare":case"veryrare":t="Very Rare";break;case"legendary":t="Legendary";break;case"artifact":t="Artifact";break;case"varies":t="Varies";break;default:t="Unknown"}else t="Unknown";return{name:t,flagTag:t}}getItemCompendiumFolderNameForType(e){const t={name:void 0,flagTag:""};switch(e.type){case"dnd-tashas-cauldron.tattoo":case"tattoo":{const a=e.flags?.ddbimporter?.dndbeyond?.type;t.name=this.trinketFolders[a].name,t.flagTag=`trinket/${t.name}`;break}case"equipment":switch(e.system?.type?.value){case"trinket":{const a=e.flags?.ddbimporter?.dndbeyond?.type,i=!0===foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.isContainer");t.name=i?this.containerFolders[a].name:this.trinketFolders[a].name,t.flagTag=i?`container/${t.name}`:`trinket/${t.name}`;break}default:t.name=this.equipmentFolders[e.system.type.value].name,t.flagTag=`equipment/${t.name}`}break;case"weapon":t.name=this.weaponFolders[e.system.type.value].name,t.flagTag=`weapon/${t.name}`;break;case"consumable":{const a=e.flags?.ddbimporter?.dndbeyond?.type;a&&(t.name=this.consumableFolders[a].name,t.flagTag=`consumable/${t.name}`);break}case"loot":{const a=e.flags?.ddbimporter?.dndbeyond?.type;a&&(t.name=this.lootFolders[a].name,t.flagTag=`loot/${t.name}`);break}case"container":{const a=e.flags?.ddbimporter?.dndbeyond?.type;a&&(t.name=this.containerFolders[a].name,t.flagTag=`container/${t.name}`);break}case"tool":{const a=e.system.type.value,i=e.flags?.ddbimporter?.dndbeyond?.tags.includes("Instrument"),n=["art","music","game"].includes(a);i?(t.name=this.toolFolders.music.name,t.flagTag=`tool/${t.name}`):n?(t.name=this.toolFolders[a].name,t.flagTag=`tool/${t.name}`):(t.name=this.rootItemFolders[e.type].name,t.flagTag="Tools");break}default:t.name=this.rootItemFolders[e.type].name,t.flagTag=`${t.name}`}return t}getItemCompendiumFolderName(e){let t;switch(this.compendiumFolderTypeItem){case"RARITY":t=DDBCompendiumFolders.getItemCompendiumFolderNameForRarity(e);break;case"TYPE":t=this.getItemCompendiumFolderNameForType(e)}return t}getClassFeatureFolderName(e){const t={name:void 0,flagTag:""},a=foundry.utils.getProperty(e,"flags.ddbimporter.subClass"),i=foundry.utils.getProperty(e,"flags.ddbimporter.class"),n=foundry.utils.getProperty(e,"flags.ddbimporter.optionalFeature"),s=foundry.utils.getProperty(e,"flags.ddbimporter.infusionFeature"),r=foundry.utils.getProperty(e,"system.type.subtype"),o=a&&""!==a.trim(),l=i&&""!==i.trim();return s?(t.name="Infusions",t.flagTag=`features/${i}/Infusions`):n?(t.name="Optional Features",t.flagTag=`features/${i}/Optional Features`):"metamagic"===r&&"Sorcerer"===i?(t.name="Metamagic",t.flagTag=`features/${i}/Metamagic`):"pact"===r&&"Warlock"===i?(t.name="Pacts",t.flagTag=`features/${i}/Pacts`):"eldritchInvocation"===r&&"Warlock"===i?(t.name="Invocations",t.flagTag=`features/${i}/Invocations`):"maneuver"===r&&"Fighter"===i?(t.name="Maneuver Options",t.flagTag=`features/${a}/Maneuver Options`):"rune"===r&&"Fighter"===i?(t.name="Runes",t.flagTag=`features/${a}/Runes`):o?(t.name=a,t.flagTag=`features/${a}`):l?(t.name="Class Features",t.flagTag=`features/${i}`):t.name="Unknown",t.name?t:void 0}getRaceTraitFolderName(e){const t={name:void 0,flagTag:""},a=foundry.utils.getProperty(e,"flags.ddbimporter.fullRaceName"),i=foundry.utils.getProperty(e,"flags.ddbimporter.groupName"),n=foundry.utils.getProperty(e,"flags.ddbimporter.isLineage"),s=n?i:a;return t.name=a===i||n?"Traits":`${a} Traits`,t.flagTag=`trait/${i}/${s}`,t}getRaceFolderName(e){const t={name:void 0,flagTag:""},a=foundry.utils.getProperty(e,"flags.ddbimporter.fullRaceName"),i=foundry.utils.getProperty(e,"flags.ddbimporter.groupName");return t.name=i??a,t.flagTag=`species/${i??a}`,t}getSummonFolderName(e){const t={name:void 0,flagTag:""},a=foundry.utils.getProperty(e,"flags.ddbimporter.summons.folder"),i=foundry.utils.getProperty(e,"flags.ddbimporter.summons.name");return t.name=a??i??e.name,t.flagTag=`summon/${t.name}`,t}getClassFolderName(e){const t={name:void 0,flagTag:""},a=foundry.utils.getProperty(e,"flags.ddbimporter.class");return a&&""!==a.trim()?t.name=a:t.name="Unknown",t.name?t:void 0}static getSourceFolderName({document:e,type:t,noSourceNameOverride:a=null,suffixName:i="",suffixFolder:n=""}){const s={name:void 0,flagTag:"",parent:!1},r=foundry.utils.getProperty(e,"system.source.book"),o=foundry.utils.getProperty(e,"flags.ddbimporter.legacy"),l=n&&""!==n.trim()?`/${n}`:"",d=r&&""!==r.trim()?CONFIG.DND5E.sourceBooks[r]:null;if(d)s.name=""===i?d:i,s.flagTag=`${t}/${d}/${l}`,s.parent=!0;else{const e=a??(o?"Legacy":"Unknown");s.name=e,s.flagTag=`${t}/${e}`}return s}static getFeatFolderName(e){const t=foundry.utils.getProperty(e,"system.type.subtype"),a=CONFIG.DND5E.featureTypes.feat.subtypes[t],i=a?`${a.replace(" Feat","")}`:null;return DDBCompendiumFolders.getSourceFolderName({type:"feat",document:e,suffix:i??"General",suffixName:i??"General",noSourceNameOverride:"General"})}static getBackgroundFolderName(e){return DDBCompendiumFolders.getSourceFolderName({document:e,type:"background"})}getCompendiumFolderName(e){let t;switch(this.type){case"background":case"backgrounds":t=DDBCompendiumFolders.getBackgroundFolderName(e);break;case"feat":case"feats":t=DDBCompendiumFolders.getFeatFolderName(e);break;case"trait":case"traits":t=this.getRaceTraitFolderName(e);break;case"species":case"race":case"races":t=this.getRaceFolderName(e);break;case"feature":case"features":t=this.getClassFeatureFolderName(e);break;case"class":case"classes":case"subclass":case"subclasses":t=this.getClassFolderName(e);break;case"summon":case"summons":t=this.getSummonFolderName(e);break;case"monsters":case"npc":case"monster":switch(this.compendiumFolderTypeMonster){case"TYPE":{const a=e.system?.details?.type?.value?e.system?.details?.type?.value:"Unknown",i=CONFIG.DDB.monsterTypes.find((e=>a.toLowerCase()==e.name.toLowerCase()));i&&(t=i.name);break}case"ALPHA":t=e.name.replace(/[^a-z]/gi,"").charAt(0).toUpperCase();break;case"CR":if(void 0!==e.system.details.cr||""!==e.system.details.cr){t=`CR ${String(e.system.details.cr).padStart(2,"0")}`}}break;case"spell":case"spells":switch(this.compendiumFolderTypeSpell){case"SCHOOL":{const a=e.system?.school;a&&(t=Utils.capitalize(o.x.spell.schools.find((e=>a==e.id)).name));break}case"LEVEL":{const a=o.x.COMPENDIUM_FOLDERS.SPELL_LEVEL[e.system?.level];a&&(t=a);break}}break;case"inventory":case"item":case"items":try{t=this.getItemCompendiumFolderName(e)}catch(t){throw s.default.error("Error in getItemCompendiumFolderName",{error:t,document:e}),t}}return t}getFolder(e,t=""){return this.compendium.folders.find((a=>a.name==e&&a.flags?.ddbimporter?.flagTag===t))}getFolderId(e){const t=this.getCompendiumFolderName(e);if(t){const e=this.getFolder(t.name??t,t.flagTag??"");if(e)return e._id}}async addToCompendiumFolder(e){s.default.debug(`Checking ${e.name} in ${this.packName}`);const t=this.getCompendiumFolderName(e);if(t){const a=this.compendium.folders.find((e=>e.name==(t.name??t)));a?(s.default.info(`Moving ${this.type} ${e.name} to folder ${a.name}`),await e.update({folder:a._id})):s.default.error(`Unable to find folder "${t}" in "${this.packName}" for ${this.type}`)}}#X(){switch(this.type){case"spells":case"spell":return["name","system.level","system.school"];case"inventory":case"items":case"item":return["name","type","flags.ddbimporter.dndbeyond.type","flags.ddbimporter.dndbeyond.tags","system.armor.type","system.type.value","system.rarity","system.type.value","system.details.type.value","system.type.subtype"];case"monster":case"monsters":return["name","type","system.details.type.value","system.details.cr"];case"summon":case"summons":return["name","type","flags.ddbimporter.summons.name","flags.ddbimporter.summons.folder"];case"class":case"subclass":case"classes":case"subclasses":case"features":case"feature":return["name","flags.ddbimporter.class","flags.ddbimporter.subClass","flags.ddbimporter.optionalFeature","flags.ddbimporter.infusionFeature","system.type.subtype"];case"feat":case"feats":return["name","system.type.subtype","system.source.book","flags.ddbimporter.legacy"];case"trait":case"traits":case"species":case"race":case"races":return["name","flags.ddbimporter.baseRaceName","flags.ddbimporter.baseName","flags.ddbimporter.subRaceShortName","flags.ddbimporter.isSubRace","flags.ddbimporter.fullRaceName","flags.ddbimporter.groupName","flags.ddbimporter.isLineage"];case"background":case"backgrounds":return["name","system.source.book","flags.ddbimporter.legacy"];default:return["name","system.type.subtype"]}}async migrateExistingCompendium(){if(!this.compendium)return;const e=this.compendium.folders.filter((e=>!this.validFolderIds.includes(e._id)));await Folder.deleteDocuments(e.map((e=>e._id)),{pack:this.packName}),s.default.debug("Remaining Compendium Folders",this.compendium.folders);const t=await this.compendium.getIndex({fields:this.#X()}),a=[];for(const e of t){const t=this.getFolderId(e);t&&a.push({_id:e._id,folder:t})}switch(s.default.debug("Folder update results",a),this.type){case"summon":case"summons":case"monsters":case"npc":case"monster":await Actor.updateDocuments(a,{pack:this.packName});break;default:await Item.updateDocuments(a,{pack:this.packName})}return this.compendium.folders}async removeUnusedFolders(){const e=this.compendium.folders.filter((e=>0===e.contents.length&&0===e.children.length)).map((e=>e.id));s.default.debug("Deleting compendium folders",e),await Folder.deleteDocuments(e,{pack:this.packName})}}var p=a(391);class DDBItemImporter{constructor(e,t,{matchFlags:a=[],deleteBeforeUpdate:i=null,indexFilter:n={},useCompendiumFolders:r=null,notifier:l=null}={}){this.type=e,this.documents=t,this.useCompendiumFolders=r??!0,this.matchFlags=a,this.compendium=m.getCompendiumType(this.type),this.compendium.configure({locked:!1}),this.compendiumIndex=null,this.indexFilter=n,this.results=[],this.deleteBeforeUpdate=i??game.settings.get(o.y.MODULE_ID,"munching-policy-delete-during-update"),this.notifier=l,l||(this.notifier=(e,t=!1,a=!1)=>{s.default.info(e,{nameField:t,monsterNote:a})})}async buildIndex(e={}){this.indexFilter=e,this.compendiumIndex=await this.compendium.getIndex(this.indexFilter)}async init(){await this.buildIndex(this.indexFilter)}#Q(e,t){if(0===this.matchFlags.length)return!0;return this.matchFlags.some((a=>{const i="is2014"===a||void 0,n=foundry.utils.getProperty(e,`flags.ddbimporter.${a}`)??i;if(!n)return!1;const s=foundry.utils.getProperty(t,`flags.ddbimporter.${a}`)??i;return!!s&&n===s}))}static copyFlagGroup(e,t,a){void 0===a.flags&&(a.flags={});const i=foundry.utils.getProperty(a,"flags.ddbimporter.effectsApplied")&&o.y.EFFECTS_IGNORE_FLAG_GROUPS.includes(e);t.flags&&t.flags[e]&&!i&&(a.flags[e]=t.flags[e])}static copySupportedItemFlags(e,t){o.y.SUPPORTED_FLAG_GROUPS.forEach((a=>{this.copyFlagGroup(a,e,t)}))}static updateCharacterItemFlags(e,t){e.flags?.ddbimporter?.importId&&foundry.utils.setProperty(t,"flags.ddbimporter.importId",e.flags.ddbimporter.importId);const a=foundry.utils.getProperty(e,"flags.ddbimporter.overrideId")==t._id,i=foundry.utils.getProperty(e,"flags.ddbimporter.ddbCustomAdded");return(i||a)&&(t.name=e.name,foundry.utils.setProperty(t,"flags.ddbimporter.replacedId",e._id)),i||e.flags?.ddbimporter?.dndbeyond?.isCustomItem&&"loot"===e.type||(e.system.quantity&&(t.system.quantity=e.system.quantity),e.system.attuned&&(t.system.attuned=e.system.attuned),e.system.attunement&&(t.system.attunement=e.system.attunement),e.system.equipped&&(t.system.equipped=e.system.equipped),e.system.resources&&(t.system.resources=e.system.resources),e.system.preparation&&(t.system.preparation=e.system.preparation),e.system.proficient&&(t.system.proficient=e.system.proficient),o.x.types.inventory.includes(e.type)||(e.system.uses&&(t.system.uses=e.system.uses),e.system.consume&&(t.system.consume=e.system.consume),e.system.ability&&(t.system.ability=e.system.ability)),foundry.utils.hasProperty(e,"system.levels")&&(t.system.levels=e.system.levels),foundry.utils.getProperty(e,"flags.ddbimporter.price.xgte")&&(t.system.price.value=e.system.price.value,t.system.price.denomination=e.system.price.denomination,foundry.utils.setProperty(t,"flags.ddbimporter.price",e.flags.ddbimporter.price))),t}static updateMatchingItems(e,t,{looseMatch:a=!1,monster:i=!1,keepId:n=!1,keepDDBId:s=!1,overrideId:r=!1,linkItemFlags:o=!1}={}){let l=[];for(let d of t){let t=foundry.utils.duplicate(d);const c=r?e.find((e=>foundry.utils.getProperty(e,"flags.ddbimporter.overrideId")==t._id)):NameMatcher.looseItemNameMatch(t,e,a,i);if(c){const e=foundry.utils.duplicate(c);if(s&&foundry.utils.hasProperty(t,"flags.ddbimporter.id")&&foundry.utils.setProperty(e,"flags.ddbimporter.id",foundry.utils.duplicate(t.flags.ddbimporter.id)),t.flags.ddbimporter){if(e.flags.ddbimporter&&t.flags.ddbimporter){const a=foundry.utils.mergeObject(t.flags.ddbimporter,e.flags.ddbimporter);foundry.utils.setProperty(t,"flags.ddbimporter",a)}}else foundry.utils.setProperty(t,"flags.ddbimporter",e.flags.ddbimporter);!t.flags.monsterMunch&&e.flags.monsterMunch&&foundry.utils.setProperty(t,"flags.monsterMunch",e.flags.monsterMunch),foundry.utils.setProperty(t,"flags.ddbimporter.originalItemName",e.name),foundry.utils.setProperty(t,"flags.ddbimporter.replaced",!0),o&&foundry.utils.hasProperty(e,"flags.link-item-resource-5e")&&foundry.utils.setProperty(t,"flags.link-item-resource-5e",e.flags["link-item-resource-5e"]),t=DDBItemImporter.updateCharacterItemFlags(e,t),n||delete t._id,l.push(t)}}return l}removeItems(e,t=!1){this.documents=this.documents.filter((a=>!e.some((e=>(a.name===e.name||a.flags?.ddbimporter?.originalName===e.name)&&a.type===e.type&&(!t||t&&a.flags?.ddbimporter?.id===e.flags?.ddbimporter?.id)))))}async getSRDCompendiumItems(e=!1,t=!1,a=!1){const i=o.y.SRD_COMPENDIUMS.find((e=>e.type==this.type)).name,n=m.getCompendium(i),r=await n.getIndex({fields:["name","type","flags.ddbimporter.dndbeyond.alternativeNames"]}),l=r.filter((t=>r.some((a=>{const i=foundry.utils.getProperty(a,"flags.ddbimporter.dndbeyond.alternativeNames")??[];if(e){return NameMatcher.getLooseNames(a.name,i).includes(t.name.split("(")[0].trim().toLowerCase())}return t.name===a.name||i.includes(t.name)})))).map((e=>e._id)),d=(await n.getDocuments(l)).map((e=>{const t=e.toObject();return delete e.folder,t.flags.ddbimporter?t.flags.ddbimporter.pack=i:t.flags.ddbimporter={pack:i},t})),c={looseMatch:e,monster:a,keepId:t},u=DDBItemImporter.updateMatchingItems(this.documents,d,c);return s.default.debug(`SRD ${this.type} result items:`,u),u}async addCompendiumFolderIds(e){if(this.useCompendiumFolders){const t=new DDBCompendiumFolders(this.type,{noCreateClassFolders:!0});await t.loadCompendium(this.type);return await t.addCompendiumFolderIds(e)}return e}async getFilteredItems(e){const t=this.compendiumIndex.filter((t=>t.name===e.name));return(await Promise.all(t.map((e=>this.compendium.getDocument(e._id).then((e=>e)))))).filter((t=>{const a=t.name===e.name,i=this.#Q(t,e);return a&&i}))}async createCompendiumItem(e){let t;switch(this.type){case"table":case"tables":t=new RollTable(e);break;default:try{const a={displaySheet:!1,keepId:!0,temporary:!0};t=new Item.implementation(e,a)}catch(t){throw s.default.error(`Error creating ${e.name}`,{item:e,err:t}),t}}return t||s.default.error(`Item ${e.name} failed creation`,{item:e,newItem:t}),this.notifier(`Creating ${e.name}`),s.default.debug(`Pushing ${e.name} to compendium`),this.compendium.importDocument(t)}async updateCompendiumItem(e,t){t.results&&await t.deleteEmbeddedDocuments("TableResult",[],{deleteAll:!0}),t.effects&&await t.deleteEmbeddedDocuments("ActiveEffect",[],{deleteAll:!0}),t.flags&&DDBItemImporter.copySupportedItemFlags(t,e),this.notifier(`Updating ${e.name} compendium entry`),s.default.debug(`Updating ${e.name} compendium entry`,{updateItem:e,existingItem:t,packId:this.compendium.metadata.id});return t.update(e,{pack:this.compendium.metadata.id,render:!1})}async deleteCreateCompendiumItem(e,t){return t.flags&&DDBItemImporter.copySupportedItemFlags(t,e),this.notifier(`Removing and Recreating ${e.name} compendium entry`),s.default.debug(`Removing and Recreating ${e.name} compendium entry`),await t.delete(),await this.createCompendiumItem(e)}async updateCompendiumItems(e){let t=[];for(const a of e){const e=await this.getFilteredItems(a);if(e.length>=1){const i=e[0];if(a._id=i._id,a.type!==i.type||this.deleteBeforeUpdate){a.type!==i.type&&s.default.warn(`Item type mismatch ${a.name} from ${i.type} to ${a.type}. DDB Importer will delete and recreate this item from scratch. You can most likely ignore this message.`);let e=this.deleteCreateCompendiumItem(a,i);t.push(e)}else{let e=await this.updateCompendiumItem(a,i);t.push(e)}}}return Promise.all(t)}async createCompendiumItems(e){let t=[];for(const a of e){if(0===(await this.getFilteredItems(a)).length){let e=await this.createCompendiumItem(a);t.push(e)}}return Promise.all(t)}async updateCompendium(e=!1,t=!0){if(!game.user.isGM)return[];s.default.debug(`Getting compendium for update of ${this.type} documents (checking ${this.documents.length} docs)`),"Item"===this.compendium.metadata.type&&this.deleteBeforeUpdate&&await Item.deleteDocuments([],{pack:this.compendium.metadata.id,deleteAll:!0});const a=t?[...new Map(this.documents.map((e=>{let t=e.name+e.type;return this.matchFlags.forEach((a=>{t+=e.flags.ddbimporter[a]})),[t,e]}))).values()]:this.documents,i=(await this.addCompendiumFolderIds(a)).map((e=>(foundry.utils.hasProperty(e,"system.description.value")&&(e.system.description.value=`<div class="ddb">\n${e.system.description.value}\n</div>`,e.system.description.chat=""!==e.system.description.chat.trim()?`<div class="ddb">\n${e.system.description.chat}\n</div>`:""),e)));let n=[];this.notifier(`Creating and updating ${i.length} ${this.type} documents in compendium...`,!0),e&&(n=await this.updateCompendiumItems(i),s.default.debug(`Updated ${n.length} existing ${this.type} documents in compendium`));const r=await this.createCompendiumItems(i);return s.default.debug(`Created ${r.length} new ${this.type} documents in compendium`),this.notifier("",!0),this.results=r.concat(n),new Promise((e=>e(this.results)))}async loadPassedItemsFromCompendium(e,{looseMatch:t=!1,monsterMatch:a=!1,keepId:i=!1,deleteCompendiumId:n=!0,indexFilter:r={},keepDDBId:l=!1,linkItemFlags:d=!1}={}){await this.buildIndex(r);const c=await this.compendiumIndex.filter((i=>e.some((e=>{const n=foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.alternativeNames")??[];if(t){return NameMatcher.getLooseNames(e.name,n).includes(i.name.split("(")[0].trim().toLowerCase())}if(a){const t=NameMatcher.getMonsterNames(e.name);return i.name===e.name||!!t.includes(i.name.toLowerCase())}return i.name===e.name||n.includes(i.name)}))));let u=[];for(const e of c){let t=await this.compendium.getDocument(e._id).then((e=>{const t=e.toObject();return n&&delete t._id,delete t.folder,o.y.COMPENDIUM_REMOVE_FLAGS.forEach((e=>{foundry.utils.hasProperty(t,e)&&foundry.utils.setProperty(t,e,void 0)})),t}));foundry.utils.setProperty(t,"flags.ddbimporter.pack",`${this.compendium.metadata.id}`),u.push(t)}s.default.debug(`compendium ${this.type} loaded items:`,u);const m={looseMatch:t,monster:a,keepId:i,keepDDBId:l,linkItemFlags:d},p=await DDBItemImporter.updateMatchingItems(e,u,m);return s.default.debug(`compendium ${this.type} result items:`,p),p}static async getCompendiumItems(e,t,{looseMatch:a=!1,monsterMatch:i=!1,keepId:n=!1,deleteCompendiumId:s=!0,keepDDBId:r=!1,linkItemFlags:o=!1}={}){const l=new DDBItemImporter(t,[]);await l.init();const d={looseMatch:a,monsterMatch:i,keepId:n,keepDDBId:r,deleteCompendiumId:s,linkItemFlags:o,matchFlags:["is2014","is2024"]};return await l.loadPassedItemsFromCompendium(e,d)}async srdFiddling(e=!0,t=!1){}async iconAdditions(){this.documents=await Iconizer.updateIcons(this.documents)}static async buildHandler(e,t,a,{srdFidding:i=!0,removeSRDDuplicates:n=!0,ids:r=null,chrisPremades:o=!1,matchFlags:l=[],deleteBeforeUpdate:d=null,filterDuplicates:c=!0,useCompendiumFolders:u=null,updateIcons:m=!0,notifier:g=null}={}){const h=new DDBItemImporter(e,t,{matchFlags:l,deleteBeforeUpdate:d,useCompendiumFolders:u,notifier:g});await h.init(),i&&await h.srdFiddling(n),m&&await h.iconAdditions();const f=null!==r&&r.length>0?h.documents.filter((e=>e.flags?.ddbimporter?.definitionId&&r.includes(String(e.flags.ddbimporter.definitionId)))):h.documents;return h.documents=f,o&&(h.documents=await p.Qs.applyChrisPremadeEffects({documents:h.documents,compendiumItem:!0})),g&&g(`Importing ${h.documents.length} ${e} documents!`,!0),s.default.debug(`Importing ${h.documents.length} ${e} documents!`,foundry.utils.deepClone(t)),await h.updateCompendium(a,c),await h.buildIndex(),h}}const g={isCustom:()=>game.settings.get(o.y.MODULE_ID,"custom-proxy"),resetProxy:()=>{game.settings.set(o.y.MODULE_ID,"api-endpoint",o.y.DEFAULT_SETTINGS.READY.PROXY["api-endpoint"].default),game.settings.set(o.y.MODULE_ID,"custom-proxy",!1)},getProxy:()=>g.isCustom()||CONFIG.DDBI.DEV.enabled?game.settings.get(o.y.MODULE_ID,"api-endpoint"):o.y.URLS.PROXY,getDynamicProxy:()=>CONFIG.DDBI.DEV.enabled?game.settings.get(o.y.MODULE_ID,"dynamic-api-endpoint"):o.y.URLS.DYNAMIC,getCORSProxy:()=>g.isCustom()||CONFIG.DDBI.DEV.enabled||CONFIG.DDBI.DEV.customCors?game.settings.get(o.y.MODULE_ID,"cors-endpoint"):o.y.URLS.CORS},h=g;class DialogHelper{static async buttonDialog({title:e="",content:t="",buttons:a,options:i={height:"auto"}}={},n="row"){return new Promise((s=>{new Dialog({title:e,content:t,buttons:a.reduce(((e,t)=>({...e,[t.label]:{label:t.label,callback:()=>s(t.value)}})),{}),close:()=>s(this)},{classes:["dialog",`ddb-button-dialog-${n}`],...i}).render(!0)}))}static ChooserDialog=ChooserDialog;static async AskUserButtonDialog(e,...t){return globalThis.DDBImporter.socket.executeAsUser("simpleButtonDialog",e,...t)}static async AskUserChooserDialog(e,...t){return globalThis.DDBImporter.socket.executeAsUser("chooserDialog",e,...t)}}var f=a(959);class FileHelper{static BAD_DIRS=["[data]","[data] ","",null];static removeFileExtension(e){let t=e.split(".");return t.pop(),t.join(".")}static readBlobFromFile(e){const t=new FileReader;return new Promise(((a,i)=>{t.onload=()=>{a(t.result)},t.onerror=()=>{t.abort(),i()},t.readAsBinaryString(e)}))}static download(e,t,a){let i=document.createElement("a"),n=new Blob([e],{type:a});i.href=URL.createObjectURL(n),i.download=t,i.click()}static addFileToKnown(e,t){CONFIG.DDBI.KNOWN.FILES.add(t);const a=t.split(e.current);if(a.length>1){const i=a[1].startsWith("/")?a[1]:`/${a[1]}`;CONFIG.DDBI.KNOWN.FILES.add(`${e.fullPath}${i}`),CONFIG.DDBI.KNOWN.LOOKUPS.set(`${e.fullPath}${i}`,t)}}static fileExistsUpdate(e,t){const a=t.filter((e=>!CONFIG.DDBI.KNOWN.FILES.has(e)));for(const t of a)FileHelper.addFileToKnown(e,t)}static dirExistsUpdate(e){const t=e.filter((e=>!CONFIG.DDBI.KNOWN.DIRS.has(e)));for(const e of t)CONFIG.DDBI.KNOWN.DIRS.add(e)}static async doesDirExist(e){const t=f.K.parse(e);try{return await f.K.browse(t.activeSource,t.current,{bucket:t.bucket}),!0}catch(e){return!1}}static async generateCurrentFilesFromParsedDir(e){if(CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(e.fullPath))s.default.debug(`Skipping full dir scan for ${e.fullPath}...`);else{s.default.verbose(`Checking for files in ${e.fullPath}...`,e);const t=await f.K.browse(e.activeSource,e.current,{bucket:e.bucket});if(FileHelper.fileExistsUpdate(e,t.files),FileHelper.dirExistsUpdate(t.dirs),"undefined"!=typeof ForgeVTT&&ForgeVTT?.usingTheForge)if(t.bazaar)CONFIG.DDBI.KNOWN.FORGE.TARGETS[e.fullPath]={},t.files.forEach((t=>{const a=t.split("/").pop();CONFIG.DDBI.KNOWN.FORGE.TARGETS[e.fullPath][a]=t,FileHelper.addFileToKnown(e,t)}));else{const t=(ForgeAPI.lastStatus||await ForgeAPI.status()).user;CONFIG.DDBI.KNOWN.FORGE.TARGET_URL_PREFIX[e.fullPath]=`https://assets.forge-vtt.com/${t}/${e.current}`}CONFIG.DDBI.KNOWN.CHECKED_DIRS.add(e.fullPath)}}static async generateCurrentFiles(e){if(CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(e))s.default.debug(`Skipping full dir scan for ${e}...`);else{s.default.verbose(`Checking for files in directoryPath ${e}...`);const t=f.K.parse(e);await FileHelper.generateCurrentFilesFromParsedDir(t)}}static async fileExists(e,t){const a=`${e}/${t}`;if(CONFIG.DDBI.KNOWN.FILES.has(a))return!0;s.default.debug(`Checking for ${t} at ${a}...`),await FileHelper.generateCurrentFiles(e);const i=CONFIG.DDBI.KNOWN.FILES.has(a);return i?s.default.debug(`Found ${a} after directory scan.`):s.default.debug(`Could not find ${a}`,{directoryPath:e,filename:t,fileUrl:a}),i}static async convertImageToWebp(e,t){s.default.info(`Converting file ${t} to webp`);return new Promise((t=>{let a=new Image;a.addEventListener("load",(()=>{t(a)})),a.src=URL.createObjectURL(e)})).then((e=>new Promise((t=>{let a=document.createElement("canvas"),i=a.getContext("2d");const n=game.settings.get(o.y.MODULE_ID,"webp-quality");a.width=e.width,a.height=e.height,i.drawImage(e,0,0),a.toBlob((e=>{t(e)}),"image/webp",n)})))).then((e=>e))}static async uploadFile(e,t,a,i=!1){const n=game.settings.get(o.y.MODULE_ID,"use-webp"),s=new File([e],a,{type:e.type}),r=e.type.startsWith("image")&&"image/webp"!==e.type,l=n&&(r||i)?new File([await FileHelper.convertImageToWebp(s,a)],a,{type:"image/webp"}):s;return await FileHelper.uploadToPath(t,l)}static async uploadImage(e,t,a,i=!1){return new Promise(((n,r)=>{FileHelper.uploadFile(e,t,a,i).then((e=>{n(e.path)})).catch((e=>{s.default.error("error uploading file: ",e),r(e)}))}))}static async downloadImage(e){return new Promise(((t,a)=>{fetch(e,{method:"GET",headers:{"x-requested-with":"foundry"}}).then((e=>(e.ok||a("Could not retrieve image"),e.blob()))).then((e=>t(e))).catch((e=>a(e.message)))}))}static async uploadRemoteImage(e,t,a,i=!0){const n=a,r=game.settings.get(o.y.MODULE_ID,"use-webp")?"webp":e.split(".").pop().split(/#|\?|&/)[0],l=game.settings.get(o.y.MODULE_ID,"cors-encode"),d=game.settings.get(o.y.MODULE_ID,"cors-strip-protocol"),c=game.settings.get(o.y.MODULE_ID,"cors-path-prefix");let u=e.split("?")[0];try{const e=h.getCORSProxy(),s=d?u.replace(/^https:\/\//,c):`${c}${u}`,o=l?encodeURIComponent(s):s;u=i?e+o:u;const m=await FileHelper.downloadImage(u);if("application/xml"===m.type)return null;const p=await FileHelper.uploadImage(m,t,n+"."+r);return FileHelper.addFileToKnown(f.K.parse(t),p),CONFIG.DDBI.KNOWN.LOOKUPS.set(`${t}/${a}`,p),p}catch(t){return s.default.error("Image upload error",t),ui.notifications.warn(`Image upload failed. Please check your ddb-importer upload folder setting. ${e}`),null}}static async getForgeUrl(e,t){let a;CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(e)||await FileHelper.generateCurrentFiles(e);const i=CONFIG.DDBI.KNOWN.FORGE.TARGET_URL_PREFIX[e],n=CONFIG.DDBI.KNOWN.FORGE.TARGETS[e],s=n?n[t]:void 0;if(s)a=s;else if(i)a=`${i}/${t}`;else{const i=f.K.parse(e);if("data"==i.activeSource)a=`https://assets.forge-vtt.com/bazaar/${i.current}/${t}`;else if("forgevtt"==i.activeSource){a=`https://assets.forge-vtt.com/${(ForgeAPI.lastStatus||await ForgeAPI.status()).user}/${i.current}/${t}`}}return a}static async getFileUrl(e,t){let a;try{if("undefined"!=typeof ForgeVTT&&ForgeVTT?.usingTheForge)return a=await FileHelper.getForgeUrl(e,t),a;{const i=f.K.parse(e);if("data"==i.activeSource)a=i.current+"/"+t;else if("forgevtt"==i.activeSource){const e=ForgeAPI.lastStatus||await ForgeAPI.status();a=`https://assets.forge-vtt.com/${e.user}/${i.current}/${t}`}else"s3"==i.activeSource?a=`https://${i.bucket}.${game.data.files.s3.endpoint.hostname}/${i.current}/${t}`:s.default.error("DDB Importer cannot handle files stored in that location",i)}}catch(a){throw new Error(`Unable to determine file URL for directoryPath "${e}" and filename "${t}"`)}return encodeURI(a)}static async getImagePath(e,{type:t="ddb",imageNamePrefix:a="",name:i,download:n=!1,remoteImages:r=!1,force:l=!1,pathPostfix:d="",targetDirectory:c}={}){if(!i||!c)throw s.default.error(`You must supply a targetDirectory and name for the image ${e}`,{name:i,targetDirectory:c,type:t}),new Error(`You must supply a targetDirectory and name for the image ${e}`);s.default.verbose(`Getting image path for ${e}`,{type:t,imageNamePrefix:a,name:i,download:n,remoteImages:r,force:l,pathPostfix:d,targetDirectory:c});const u=`${c}${d}`;if(!CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(u)){const e=f.K.parse(u);await FileHelper.verifyPath(e),await FileHelper.generateCurrentFilesFromParsedDir(e)}const m=n||game.settings.get(o.y.MODULE_ID,"munching-policy-download-images"),p=r||game.settings.get(o.y.MODULE_ID,"munching-policy-remote-images"),g=game.settings.get(o.y.MODULE_ID,"use-webp");if(e&&m){const t=g?"webp":e.split(".").pop().split(/#|\?|&/)[0];i||(i=e.split("/").pop());const n=`${a&&""!==a.trim()?`${a}-`:""}${Utils.referenceNameString(i)}`;if(await FileHelper.fileExists(u,n+"."+t)&&!l){return CONFIG.DDBI.KNOWN.LOOKUPS.get(`${u}/${n}.${t}`).trim()}{const t=await FileHelper.uploadRemoteImage(e,u,n);return t?t.trim():null}}if(e&&p)try{return e.trim()}catch(e){return null}return null}static async forgeCreateDirectory(e){if(!e)return;const t=await ForgeAPI.call("assets/new-folder",{path:e});if(!t||t.error)throw new Error(t?t.error:"Unknown error while creating directory.");return t}static async createDirectory(e,t,a={}){if(!t)throw new Error("No directory name provided");return"undefined"!=typeof ForgeVTT&&ForgeVTT?.usingTheForge?FileHelper.forgeCreateDirectory(t):FilePicker.createDirectory(e,t,a)}static async verifyPath(e,t=null){try{if(CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(e.fullPath))return!0;const a=t?t.split("/"):e.current.split("/");let i=a[0];for(let n=0;n<a.length;n+=1)try{i!==a[n]&&(i=`${i}/${a[n]}`),await FileHelper.createDirectory(e.activeSource,`${i}`,{bucket:e.bucket})}catch(a){const i=`${a?.message??Utils.isString(a),a}`.replace(/^Error: /,"").trim();i.startsWith("EEXIST")||i.startsWith("The S3 key")||(s.default.error(`Error trying to verify path [${e.activeSource}], ${e.current}`,a),s.default.error("parsedPath",e),s.default.error("targetPath",t))}}catch(e){return s.default.error("Unable to verify path",e),!1}return!0}static async verifyDirectory(e,t=null){return!!CONFIG.DDBI.KNOWN.CHECKED_DIRS.has(e.fullPath)||FileHelper.verifyPath(e,t)}static async uploadToPath(e,t){const a=f.K.parse(e);return FilePicker.upload(a.activeSource,a.current,t,{bucket:a.bucket},{notify:!1})}static parseDirectory(e){return f.K.parse(e)}}const y=FileHelper;class FolderHelper{static async getOrCreateFolder(e,t,a,i=""){let n=game.folders.contents.find((i=>i.type===t&&i.name===a&&(e?e.id:null)===(i.folder?.id??null)));return n||(n=await Folder.create({name:a,type:t,color:i,parent:e?e.id:null},{displaySheet:!1}),n)}static async getFolder(e,t="",a="D&D Beyond Import",i="#6f0006",n="#98020a",s=!0){const r=Utils.entityMap(),o=game.i18n.localize(`ddb-importer.item-type.${e}`),l=r.get(e),d=await FolderHelper.getOrCreateFolder(null,l,a,i),c=s?await FolderHelper.getOrCreateFolder(d,l,o,n):d;if(""!==t){const e=t.charAt(0).toUpperCase()+t.slice(1);return await FolderHelper.getOrCreateFolder(c,l,e,n)}return c}static async getCompendiumFolderId(e,t){const a=game.packs.get(t);return a.folders.find((t=>t.name===e))?._id}static async updateFolderItems(e,t,a=!0){const i=o.y.GAME_FOLDER_LOOKUPS.find((t=>t.type==e)),n=[...new Set(t[e].filter((e=>e.flags?.ddbimporter?.dndbeyond?.lookupName)).map((e=>e.flags.ddbimporter.dndbeyond.lookupName)))],r=await(async()=>Promise.all(n.map((e=>FolderHelper.getFolder(i.folder,e)))))(),l=await FolderHelper.getFolder(i.folder),d=await game.items.entities.filter((e=>{const t=r.find((t=>e.flags?.ddbimporter?.dndbeyond?.lookupName&&t.name===e.flags.ddbimporter.dndbeyond.lookupName));return t&&e.type===i.itemType&&e.folder===t._id}));a&&await(async()=>Promise.all(t[e].filter((e=>d.some((t=>t.name===e.name)))).map((async t=>{const a=await d.find((e=>t.name===e.name));return t._id=a._id,s.default.info(`Updating ${e} ${t.name}`),DDBItemImporter.copySupportedItemFlags(a,t),await Item.update(t),t}))))(),await(async()=>Promise.all(t[e].filter((e=>!d.some((t=>t.name===e.name)))).map((async t=>{if(game.user.can("ITEM_CREATE")){s.default.info(`Creating ${e} ${t.name}`);const a=r.find((e=>t.flags?.ddbimporter?.dndbeyond?.lookupName&&e.name===t.flags.ddbimporter.dndbeyond.lookupName));t.folder=a?a._id:l._id,await Item.create(t)}else ui.notifications.warn(`Cannot create ${i.type} ${t.name} for ${e}`);return t}))))();const c=[l._id,...r.map((e=>e._id))];return Promise.all(game.items.entities.filter((e=>e.type===i.itemType&&c.includes(e.folder))).map((e=>{const t=e.flags.ddbimporter?.dndbeyond?.lookupName?e.flags.ddbimporter.dndbeyond.lookupName:null;return{magicItem:{_id:e._id,id:e._id,pack:"world",img:e.img,name:e.name,subFolder:t,flatDc:e.flags?.ddbimporter?.dndbeyond?.overrideDC,dc:e.flags?.ddbimporter?.dndbeyond?.dc},_id:e._id,name:e.name,compendium:!1}})))}}var b=a(293),D=a(111);const v={disableCharacterActiveEffectSettings:e=>{$(e).find("#character-import-policy-dae-effect-copy").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-dae-effect-copy",!1),$(e).find("#character-import-policy-add-spell-effects").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-add-spell-effects",!1),$(e).find("#character-import-policy-dae-effect-copy").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-dae-effect-copy",!1),$(e).find("#character-import-policy-add-item-effects").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-add-item-effects",!1),$(e).find("#character-import-policy-add-character-effects").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-add-character-effects",!1),$(e).find("#character-import-policy-active-effect-copy").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-active-effect-copy",!1),$(e).find("#character-update-policy-use-chris-premades").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-use-chris-premades",!1)},setRecommendedCharacterActiveEffectSettings:e=>{$(e).find("#character-import-policy-dae-effect-copy").prop("checked",!D.AutoEffects.effectModules().hasCore),game.settings.set(o.y.MODULE_ID,"character-update-policy-dae-effect-copy",!D.AutoEffects.effectModules().hasCore),$(e).find("#character-import-policy-add-spell-effects").prop("checked",D.AutoEffects.effectModules().hasCore),game.settings.set(o.y.MODULE_ID,"character-update-policy-add-spell-effects",D.AutoEffects.effectModules().hasCore),$(e).find("#character-import-policy-dae-effect-copy").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-dae-effect-copy",!1),$(e).find("#character-import-policy-add-item-effects").prop("checked",!0),game.settings.set(o.y.MODULE_ID,"character-update-policy-add-item-effects",!0),$(e).find("#character-import-policy-add-character-effects").prop("checked",!0),game.settings.set(o.y.MODULE_ID,"character-update-policy-add-character-effects",!0),$(e).find("#character-import-policy-active-effect-copy").prop("checked",!1),game.settings.set(o.y.MODULE_ID,"character-update-policy-active-effect-copy",!1),$(e).find("#character-update-policy-use-chris-premades").prop("checked",!D.AutoEffects.effectModules().chrisInstalled),game.settings.set(o.y.MODULE_ID,"character-update-policy-use-chris-premades",!D.AutoEffects.effectModules().chrisInstalled)},getInstalledIcon:e=>D.AutoEffects.effectModules()[e]?"<i class='fas fa-check-circle' style='color: green'></i>":"<i class='fas fa-times-circle' style='color: red'></i> ",getCharacterImportSettings:()=>{const e=[{name:"name",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-name"),description:"Name"},{name:"hp",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-hp"),description:"HP"},{name:"xp",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-xp"),description:"XP"},{name:"hit-die",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-hit-die"),description:"Hit Die"},{name:"image",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-image"),description:"Image"},{name:"bio",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-bio"),description:"Bio"},{name:"languages",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-languages"),description:"Languages"},{name:"spell-use",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-spell-use"),description:"Spell Slots"}],t=[{name:"class",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-class"),description:"Classes"},{name:"feat",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-feat"),description:"Features"},{name:"weapon",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-weapon"),description:"Weapons"},{name:"equipment",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-equipment"),description:"Other Equipment"},{name:"currency",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-currency"),description:"Currency"},{name:"spell",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-spell"),description:"Spells"}],a=D.AutoEffects.effectModules(),i=a.chrisInstalled,n=game.settings.get(o.y.MODULE_ID,"character-update-policy-add-spell-effects");n&&!a.hasCore&&game.settings.set(o.y.MODULE_ID,"character-update-policy-add-spell-effects",!1);const s=`These are highly automated and required the following modules: DAE${v.getInstalledIcon("daeInstalled")}, Midi-QOL${v.getInstalledIcon("midiQolInstalled")}, and Times Up${v.getInstalledIcon("timesUp")}. Optional, but recommended automation modules: Active Auras${v.getInstalledIcon("activeAurasInstalled")}, Active Token Effects${v.getInstalledIcon("atlInstalled")}.`,r=`\n<p>Some Active Effects do not require any external modules, many of these will be created regardless of what settings are checked here, some will need these options checked.</p>\n<p>Some Active Effects need DAE${v.getInstalledIcon("daeInstalled")}, and although not required, it is <em>strongly recommended</em> if generating active effects with DDB Importer.</p>\n<p>The following modules are entirely optional but offer pretty animations for your spells and attacks (Automated Animations${v.getInstalledIcon("autoAnimationsInstalled")}). DAE${v.getInstalledIcon("daeInstalled")} offers several effect options that are useful but not provided by the core system. Active Auras${v.getInstalledIcon("activeAurasInstalled")} offers support for things like Paladin auras, as well as more automated effects for spells such as Spike Growth. Active Token Effects${v.getInstalledIcon("atlInstalled")} allows for effects to change tokens size and vision.</p>\n<p>For games looking for high levels of automation, particularly around spells and more complex character features such as Battle Master Manoeuvres, then the "Midi-QOL" suite is required. This will allow varying degrees of automation from auto-calculating hit rolls, advantage damage, and even applying it for you (if desired).</p>\n<p>For high automation games you will need some additional modules, but are otherwise not required: Midi-QOL${v.getInstalledIcon("midiQolInstalled")}, and Times Up${v.getInstalledIcon("timesUp")}.</p>\n`,l=[{name:"use-inbuilt-icons",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-inbuilt-icons"),description:"Use icons from the inbuilt dictionary? (High coverage of items, feats, and spells).",enabled:!0},{name:"use-srd-icons",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-srd-icons"),description:"Use icons from the SRD compendium? (This can take a while).",enabled:!0},{name:"use-ddb-spell-icons",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-ddb-spell-icons"),description:"Use spell school icons from D&DBeyond?",enabled:!0},{name:"use-ddb-item-icons",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-ddb-item-icons"),description:"Use equipment icons from D&DBeyond (where they exist)?",enabled:!0},{name:"use-ddb-generic-item-icons",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-ddb-generic-item-icons"),description:"Use D&D Beyond generic item type images, if available? (final fallback)",enabled:!0},{name:"use-combined-description",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-combined-description"),description:"Use short snippets? If selected will use the short snippet snippet, with the full description in a collapsed box.",enabled:!0},{name:"add-description-to-chat",isChecked:game.settings.get(o.y.MODULE_ID,"add-description-to-chat"),description:"Use the short description for the chat card? (otherwise will use normal description).",enabled:!0},{name:"ignore-non-ddb-items",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-ignore-non-ddb-items"),description:"Ignore items on character sheet that have not been imported from D&D Beyond? This will remove items that have been removed from the DDB character since the last import, but will keep items added to the character within Foundry.",enabled:!0},{name:"create-companions",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-create-companions"),description:"Generate summon monster actors? (Requires item/actor create permissions)",enabled:!0}],d=[{name:"add-features-to-compendiums",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-add-features-to-compendiums"),title:"[EXPERIMENTAL] Import classes/class features, species, feats and backgrounds to compendiums?",description:"Adds classes (if level20), class features, backgrounds, species, species traits, and feats to your DDB Importer compendiums.",enabled:!0},{name:"import-full-spell-list",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-import-full-spell-list"),title:"Import full spell list?",description:"If a Cobalt Cookie is set, import all available spells for classes such as Cleric, where spells can be changed out on a long rest.",enabled:!0},{name:"use-active-sources",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-active-sources"),title:"Restrict imported spells to allowed sources?",description:"Use allowed source on DDB when adding spells to character.",enabled:!0},{name:"remove-2024",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-remove-2024"),title:"Remove 2024 Spells?",description:"Removes 2024 spells from character imports, and removes (Legacy) suffix on spell names.",enabled:!0},{name:"remove-legacy",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-remove-legacy"),title:"Remove Legacy Spells?",description:"Removes legacy spells from character imports.",enabled:!0},{name:"use-override",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-override"),title:"Replace Items using those in your Override compendium",description:"Use existing items from <i>ddb-import Override compendium</i>, rather than parsing from DDB. This is useful if you want to place customised items into the compendium for use by characters.",enabled:!0},{name:"use-existing",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-existing"),title:"[Caution] Replace Items using ddb-importer compendiums",description:"Use existing items from <i>ddb-import compendiums</i>, rather than parsing from DDB. This is useful if you have customised the items in the compendium, although you will lose any custom effects applied by this module e.g. Improved Divine Smite. Please consider marking the item you wish to keep as ignored by import instead.",enabled:!0},{name:"use-srd",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-srd"),title:"[Caution] Replace Items using SRD compendiums",description:"Use the <i>SRD compendiums</i>, rather than DDB. Importing using SRD will not include features like fighting style and divine smite in damage calculations. Please consider marking the item you wish to keep as ignored by import instead.",enabled:!0}],c=[{name:"add-character-effects",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-add-character-effects"),title:"Generate Automation Effects for Character Features/Racial Traits/Feats/Backgrounds",description:null,enabled:!0},{name:"add-item-effects",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-add-item-effects"),title:"Generate Automation Effects for Equipment",description:null,enabled:!0},{name:"add-spell-effects",isChecked:n&&a.hasCore,title:"Generate Automation Effects for Spells",description:s,enabled:a.hasCore},{name:"use-chris-premades",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-use-chris-premades"),title:"Use Automation Effects from the Cauldron of Plentiful Resources module?",description:`Cauldron of Plentiful Resources ${v.getInstalledIcon("chrisInstalled")} offer even more automation for all aspects of D&D, but have even more pre-requisites. You should investigate and set up this module before importing with this option selected. Requires Cauldron of Plentiful Resources ${v.getInstalledIcon("chrisInstalled")} module.<br>These will replace any effects created by DDB Importer.`,enabled:i},{name:"active-effect-copy",isChecked:game.settings.get(o.y.MODULE_ID,"character-update-policy-active-effect-copy"),title:"Retain Active Effects?",description:"Retain existing Active Effects, this will try and transfer any existing effects on the actor such as custom effects, effects from conditions or existing spells. Untick this option if you experience <i>odd</i> behaviour.",enabled:!0}],u=[{name:"action-use",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-action-use"),description:"Action Uses (Currently unavailable for this version of DDB Importer)",enabled:!1},{name:"currency",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-currency"),description:"Currency",enabled:!0},{name:"deathsaves",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-deathsaves"),description:"Death Saves",enabled:!0},{name:"equipment",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-equipment"),description:"Equipment",enabled:!0},{name:"condition",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-condition"),description:"Conditions/Exhaustion",enabled:!0},{name:"hitdice",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-hitdice"),description:"Hit Dice/Short Rest",enabled:!0},{name:"hitpoints",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-hitpoints"),description:"Hit Points",enabled:!0},{name:"inspiration",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-inspiration"),description:"Inspiration",enabled:!0},{name:"spells-prepared",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-spells-prepared"),description:"Spells Prepared",enabled:!0},{name:"spells-slots",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-spells-slots"),description:"Spell Slots",enabled:!0},{name:"spells-sync",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-spells-sync"),description:"Spells Known",enabled:!1},{name:"xp",isChecked:game.settings.get(o.y.MODULE_ID,"sync-policy-xp"),description:"XP",enabled:!0}],m=game.settings.get(o.y.MODULE_ID,"image-upload-directory"),p=!y.BAD_DIRS.includes(m),g=S.getPatreonTier();return{installedModulesText:r,importPolicies1:e,importPolicies2:t,importConfig:l,extrasConfig:[],advancedImportConfig:d,effectImportConfig:c,dataDirSet:p,syncConfig:u,tiers:S.calculateAccessMatrix(g)}},toggleByName(e,t=null){const a=document.querySelector(`input[type="checkbox"][name="${e}"]`);a.checked=null===t?!a.checked:t},updateActorSettings:(e,t)=>{const a=t.currentTarget.dataset.section,i=t.currentTarget.checked;s.default.debug(`Updating munching-policy-${a} to ${i}`),"add-description-to-chat"===a?(game.settings.set(o.y.MODULE_ID,"add-description-to-chat",i),game.settings.set(o.y.MODULE_ID,"character-update-policy-use-combined-description",!1),v.toggleByName("character-import-policy-use-combined-description",!1)):game.settings.set(o.y.MODULE_ID,"character-update-policy-"+a,i),"use-combined-description"===a&&(game.settings.set(o.y.MODULE_ID,"add-description-to-chat",!1),v.toggleByName("character-import-policy-add-description-to-chat",!1)),"remove-2024"===a&&i?(game.settings.set(o.y.MODULE_ID,"character-update-policy-remove-legacy",!1),v.toggleByName("character-import-policy-remove-legacy",!1)):"remove-legacy"===a&&i&&(game.settings.set(o.y.MODULE_ID,"character-update-policy-remove-2024",!1),v.toggleByName("character-import-policy-remove-2024",!1))},getCompendiumFolderLookups:e=>{const t=game.settings.settings.get(`ddb-importer.munching-selection-compendium-folders-${e}`),a=game.settings.get(o.y.MODULE_ID,`munching-selection-compendium-folders-${e}`);let i=[];for(const[e,n]of Object.entries(t.choices))i.push({key:e,label:n,selected:e===a});return i},getMuncherSettings:(e=!0)=>{const t=""!=getCobalt(),a=""!=S.getPatreonKey(),i=S.getPatreonTier(),n=S.calculateAccessMatrix(i),s=D.AutoEffects.effectModules(),r=game.settings.get(o.y.MODULE_ID,"campaign-id"),l=r&&""!==r,d=s.chrisInstalled,c=v.getCompendiumFolderLookups("monster"),u=v.getCompendiumFolderLookups("spell"),m=v.getCompendiumFolderLookups("item"),p=`Create Automation Effects for spells?<br>\nThese effects automate a lot of common spells, but do require the use of a number of external modules, including "Midi-QOL", which potentially introduces a much higher level of automation and complexity above the base Foundry system.<br>\nThese require the following modules: DAE${v.getInstalledIcon("daeInstalled")}, Midi-QOL${v.getInstalledIcon("midiQolInstalled")}, and Times Up${v.getInstalledIcon("timesUp")} as a minimum.<br>\nEffects can also be created to use Active Auras${v.getInstalledIcon("activeAurasInstalled")}, Active Token Effects${v.getInstalledIcon("atlInstalled")}, Token Magic FX${v.getInstalledIcon("tokenMagicInstalled")}, and Automated Animations${v.getInstalledIcon("autoAnimationsInstalled")}.\n`,g=game.settings.get(o.y.MODULE_ID,"munching-policy-add-spell-effects");g&&!s.hasCore&&game.settings.set(o.y.MODULE_ID,"munching-policy-add-spell-effects",!1);const h=game.settings.get(o.y.MODULE_ID,"munching-policy-use-source-filter"),f=h?game.settings.get(o.y.MODULE_ID,"munching-policy-muncher-sources").flat():[],y=h&&f.length>0,C=y?"Include homebrew? SOURCES SELECTED! You can't import homebrew with a source filter selected":"Include homebrew?",w=`Importing from the following sources only: ${b.A.getSourcesLookups(f).filter((e=>e.selected)).map((e=>e.label)).join(", ")}`,I=[{name:"use-ddb-item-icons",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-ddb-item-icons"),description:"Use D&D Beyond item images, if available",enabled:!0},{name:"use-ddb-generic-item-icons",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-ddb-generic-item-icons"),description:"Use D&D Beyond generic item type images, if available (final fallback)",enabled:!0},{name:"add-effects",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-add-effects"),description:"Add Automation effects to equipment?",enabled:!0},{name:"item-homebrew",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-item-homebrew"),description:C,enabled:!y},{name:"item-homebrew-only",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-item-homebrew-only"),description:"Only import homebrew items?",enabled:!y}],T=[{name:"use-ddb-spell-icons",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-ddb-spell-icons"),description:"If no other icon, use the D&DBeyond spell school icon.",enabled:!0},{name:"add-spell-effects",isChecked:g&&s.hasCore,description:p,enabled:s.hasCore},{name:"spell-homebrew",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-spell-homebrew"),description:C,enabled:!y},{name:"spell-homebrew-only",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-spell-homebrew-only"),description:"Only import homebrew spells?",enabled:!y}],A=game.modules.get("vtta-tokenizer")?.active,k=[{name:"hide-description",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-hide-description"),description:"Hide monster action description from players?",enabled:!0},{name:"monster-items",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-items"),description:"[Experimental] Load attack/weapon items from DDB compendium instead of parsing action/attack? (Poor success rate).",enabled:!0},{name:"monster-use-item-ac",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-use-item-ac"),description:"Use AC items instead of setting a flat AC? (Recommended if using spell effects like shield on NPC's).",enabled:!0},{name:"use-full-token-image",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-full-token-image"),description:"Use portrait image for token rather than token image (i.e. full art).",enabled:!0},{name:"use-token-avatar-image",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-token-avatar-image"),description:"Use token image for portrait rather than the portrait image (i.e. close up).",enabled:!0},{name:"use-srd-monster-images",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-srd-monster-images"),description:"Use images from the SRD compendiums.",enabled:!0},{name:"update-images",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-update-images"),description:"[CAUTION] Update Monster images on existing npcs? (This will dramatically slow down re-munching).",enabled:!0},{name:"download-images",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-download-images"),description:"Download D&D Beyond monster images (takes longer and needs space).",enabled:!0},{name:"remote-images",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-remote-images"),description:"Use D&D Beyond remote monster images (a lot quicker)",enabled:!0},{name:"monster-tokenize",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-tokenize"),description:"Auto-Tokenize monsters token image? (Adds Tokenizer default token ring using the Tokenizer module).",enabled:A},{name:"monster-retain-biography",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-retain-biography"),description:"Should monsters retain existing biography?",enabled:!0},{name:"monster-strip-name",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-strip-name"),description:"Strip uses and recharge information from action names?",enabled:!0},{name:"monster-set-legendary-resource-bar",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-set-legendary-resource-bar"),description:"Monsters display legendary resources on bar2? (Like the SRD Monsters).",enabled:!0},{name:"add-monster-effects",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-add-monster-effects"),description:`Generate Automation Effects that use Midi-QOL on monster attacks/features? <br>These are for a highly automated game, and are things such as managing abilities with conditions that have saves every round, or attacks which apply conditions such as frightened or prone.<br>Requires DAE${v.getInstalledIcon("daeInstalled")}, Midi-QOL${v.getInstalledIcon("midiQolInstalled")}.`,enabled:s.hasMonster}],E=e?[{name:"monster-homebrew",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-homebrew")&&!y,description:C,enabled:n.homebrew&&!y},{name:"monster-homebrew-only",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-homebrew-only")&&!y,description:"Homebrew monsters only? (Otherwise both)",enabled:n.homebrew&&!y},{name:"monster-exact-match",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-monster-exact-match"),description:"Exact name match?",enabled:n.homebrew}]:[],_=k.concat(E);return{cobalt:t,genericConfig:[{name:"update-existing",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-update-existing"),description:"Update existing things.",enabled:!0},{name:"delete-during-update",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-delete-during-update"),description:"Faster updates? Will delete items during updates, so they can be re-imported.",enabled:!0},{name:"use-inbuilt-icons",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-inbuilt-icons"),description:"Use icons from the inbuilt dictionary. (High coverage, recommended, fast).",enabled:!0},{name:"use-srd-icons",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-srd-icons"),description:"Use icons from the SRD compendiums.",enabled:!0},{name:"use-chris-premades",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-use-chris-premades"),description:`Use Automation Effects from the Cauldron of Plentiful Resources module? These provide high quality automations for spells, features, monsters, etc. (Requires Cauldron of Plentiful Resources ${v.getInstalledIcon("chrisInstalled")} module).<br>These will replace any effects created by DDB Importer.`,enabled:d},{name:"exclude-legacy",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-exclude-legacy"),description:"Exclude legacy things from import? These are replaced by newer versions e.g. in Monsters of the Multiverse, 2024 PHB.",enabled:!0},{name:"legacy-postfix",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-legacy-postfix"),description:"Append (Legacy) to Legacy names? These are replaced by newer versions e.g. in Monsters of the Multiverse, 2024 PHB.",enabled:!0},{name:"use-source-filter",isChecked:h,description:"Restrict import to specific source book(s)? (DDB sets this as the <i>first</i> book a monster appears in).",enabled:!0}],monsterConfig:_,spellConfig:T,itemConfig:I,worldUpdateConfig:[{name:"update-world-monster-update-images",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-update-world-monster-update-images"),description:"Update Monster images?",enabled:!0},{name:"update-world-monster-retain-biography",isChecked:game.settings.get(o.y.MODULE_ID,"munching-policy-update-world-monster-retain-biography"),description:"Retain existing biography?",enabled:!0}],beta:a&&t,tiers:n,compendiumFolderMonsterStyles:c,compendiumFolderItemStyles:m,compendiumFolderSpellStyles:u,sourcesSelected:y,sourceDescription:w,enableSources:h,version:CONFIG.DDBI.version,campaignId:r,isCampaign:l}},updateMuncherSettings:(e,t,a)=>{const i=t.currentTarget.dataset.section,n=t.currentTarget.checked;switch(s.default.debug(`Updating munching-policy-${i} to ${n}`),game.settings.set(o.y.MODULE_ID,"munching-policy-"+i,n),i){case"monster-homebrew":n||(game.settings.set(o.y.MODULE_ID,"munching-policy-monster-homebrew-only",!1),$("#munching-policy-monster-homebrew-only").prop("checked",!1));break;case"monster-homebrew-only":n&&(game.settings.set(o.y.MODULE_ID,"munching-policy-monster-homebrew",!0),$("#munching-policy-monster-homebrew").prop("checked",!0));break;case"spell-homebrew":n||(game.settings.set(o.y.MODULE_ID,"munching-policy-spell-homebrew-only",!1),$("#munching-policy-spell-homebrew-only").prop("checked",!1));break;case"spell-homebrew-only":n&&(game.settings.set(o.y.MODULE_ID,"munching-policy-spell-homebrew",!0),$("#munching-policy-spell-homebrew").prop("checked",!0));break;case"item-homebrew":n||(game.settings.set(o.y.MODULE_ID,"munching-policy-item-homebrew-only",!1),$("#munching-policy-item-homebrew-only").prop("checked",!1));break;case"item-homebrew-only":n&&(game.settings.set(o.y.MODULE_ID,"munching-policy-item-homebrew",!0),$("#munching-policy-item-homebrew").prop("checked",!0));break;case"remote-images":n&&(game.settings.set(o.y.MODULE_ID,"munching-policy-download-images",!1),$("#munching-generic-policy-download-images").prop("checked",!1));break;case"download-images":n&&(game.settings.set(o.y.MODULE_ID,"munching-policy-remote-images",!1),$("#munching-generic-policy-remote-images").prop("checked",!1));break;case"use-source-filter":$("#munch-source-select").prop("disabled",!n),$("#munch-source-div").toggleClass("ddbimporter-hidden"),a.render(!0)}}},C=v;class NameMatcher{static getMonsterNames(e){let t=[e,e.toLowerCase()],a=e.match(/^(\+\d*)\s*(.*)/);a&&t.push(`${a[2].trim()}, ${a[1]}`.toLowerCase().trim());let i=e.match(/(.*)\s*(\+\d*)$/);return i&&t.push(`${i[1].trim()}, ${i[2]}`.toLowerCase().trim()),t}static getLooseNames(e,t=[],a=!0){let i=new Set(t.map((e=>e.toLowerCase())));i.add(e.toLowerCase()),i.add(e.replace(",","").toLowerCase());let n=e.split("(")[0].trim().split(", ");n.unshift(n.pop());const s=n.join(" ").trim();i.add(s.toLowerCase());let r=e.replace("(","").replace(")","").trim().split(",");r.unshift(r.pop());const o=r.join(" ").trim();if(i.add(o.toLowerCase()),i.add(e.replace("'","’").toLowerCase()),i.add(e.replace("’","'").toLowerCase()),i.add(e.replace(" armor","").toLowerCase()),i.add(e.replace(/s$/,"").toLowerCase()),i.add(e.replace(",","").toLowerCase()),i.add(`${e} attack`.toLowerCase()),i.add(e.replace(" (1 day)","").toLowerCase()),i.add(e.replace(" (10-foot)","").toLowerCase()),i.add(e.replace(" (bag of 20)","").toLowerCase()),i.add(e.replace(" (bag of 1000)","").toLowerCase()),i.add(e.replace(" (per day)","").toLowerCase()),i.add(e.replace("(10 foot)","(10-foot)").toLowerCase()),i.add(e.replace("(10-foot)","(10 foot)").toLowerCase()),i.add(e.replace("(0 - Cantrip)","Cantrip").toLowerCase()),i.add(e.replace(/\((\d..) Level\)/,"$1 Level").toLowerCase()),(a||!a&&e.split(",")[0].length>1&&!/\+\d$/.test(e.trim()))&&i.add(e.split(",")[0].toLowerCase()),a){let t=e.replace(/\+\d*\s*/,"").trim().split("(")[0].trim().split(", ");t.unshift(t.pop());const a=t.join(" ").trim();i.add(a.toLowerCase()),i.add(s.replace(/\+\d*\s*/,"").trim().toLowerCase()),i.add(s.replace(/\+\d*\s*/,"").trim().toLowerCase().replace(/s$/,""))}return Array.from(i)}static looseItemNameMatch(e,t,a=!1,i=!1,n=!1){let r=t.find((t=>{let a=!1;const i=foundry.utils.getProperty(t,"flags.ddbimporter.dndbeyond.alternativeNames")??[],n=Object.prototype.hasOwnProperty.call(e.system,"activation"),s=Object.prototype.hasOwnProperty.call(e.system,"activation");n&&""==e.system?.activation?.type?a=!0:s&&n?a=s&&n:n||(a=!0);return(e.name===t.name||i.includes(e.name))&&e.type===t.type&&a}));if(!r&&i&&(r=t.find((t=>NameMatcher.getMonsterNames(t.name).includes(e.name.toLowerCase())&&o.x.types.monster.includes(t.type)&&o.x.types.inventory.includes(e.type)))),!r&&n){const a=e.name.replace(/(.*)\s+(\+\d*)\s*/,"$1, $2").trim().toLowerCase(),i=e.name.replace(/(.*)\s+(\+\d*)\s*/,"$2 $1").trim().toLowerCase();r=t.find((e=>[a,i].includes(e.name.trim().toLowerCase())))}if(!r&&a){const a=foundry.utils.getProperty(e,"flags.ddbimporter.dndbeyond.alternativeNames")??[],i=NameMatcher.getLooseNames(e.name,a,!n);for(const a of i)if(r=t.find((t=>(a===t.name.toLowerCase()||a===t.name.toLowerCase().replace(" armor",""))&&o.x.types.inventory.includes(e.type)&&o.x.types.inventory.includes(t.type))),r){s.default.debug(`Broke on ${a}`,r);break}r||(r=t.find((e=>i.includes(e.name.split("(")[0].trim().toLowerCase()))))}return r}}class OriginFixer{static ORIGIN_RE=/(.*)Actor\.([^.]+)(.*)$/g;static COMPENDIUM_ORIGIN_RE=/Compendium\.(.*)(?:Actor|null)\.([^.]+)(.*)$/g;static TOKEN_ORIGIN_RE=/(Scene.[^.]+.Token.[^.]+.Actor\.[^.]+)(.*)$/g;static _getEffectOrigin(e,t,a=!1){return a?e.origin.replace(OriginFixer.COMPENDIUM_ORIGIN_RE,`${t}.$2$3`):e.origin.match(OriginFixer.TOKEN_ORIGIN_RE)?e.origin.replace(OriginFixer.TOKEN_ORIGIN_RE,`${t}$2`):e.origin.replace(OriginFixer.ORIGIN_RE,`${t}$3`)}static async updateActorEffects(e,t=!1){if(!e)return;const a=[],i=e.uuid.replace("..",".");let n=!1;for(const r of e.effects){const o=r.toObject(),l=r.origin?.startsWith(`Compendium.${m.getCompendiumLabel("monsters")}.`),d=t||l?OriginFixer.COMPENDIUM_ORIGIN_RE:OriginFixer.ORIGIN_RE;if("string"==typeof r.origin&&r.origin.match(d)&&(!r.origin.startsWith("Compendium")||l)){const a=OriginFixer._getEffectOrigin(r,i,t||l);await fromUuid(a)&&a!==r.origin&&(n=!0,s.default.debug(`${e.name} effect ${r.name} origin ${r.origin} -> ${a} ${i}`),o.origin=a)}a.push(o)}n&&(s.default.debug(`Replacing effects on actor ${e.name} [${i}]`,a),await e.updateEmbeddedDocuments("ActiveEffect",a))}static async fixActorOrigins(e){await OriginFixer.updateActorEffects(e)}static async fixTokenOrigins(e){e.actor&&await OriginFixer.updateActorEffects(e.actor)}static async fixActorOriginsForAllActors(){for(const e of game.actors)await OriginFixer.updateActorEffects(e)}static async fixTokenOriginsForScene(e){for(const t of e.tokens)await OriginFixer.updateActorEffects(t.actor)}static async fixTokenOriginsForActiveScene(){await OriginFixer.fixTokenOriginsForScene(game.scenes.active)}static async fixTokenOriginsForAllScenes(){for(const e of game.scenes)await OriginFixer.fixTokenOriginsForScene(e)}}async function setLocalStorage(e,t){null==t?localStorage.removeItem(e):localStorage.setItem(e,t)}const w={getPatreonKey:(e=!1)=>e?localStorage.getItem("ddb-patreon-key"):game.settings.get(o.y.MODULE_ID,"beta-key"),setPatreonKey:async(e,t=!1)=>{t?setLocalStorage("ddb-patreon-key",e):await game.settings.set(o.y.MODULE_ID,"beta-key",e)},getPatreonUser:(e=!1)=>e?localStorage.getItem("ddb-patreon-user"):game.settings.get(o.y.MODULE_ID,"patreon-user"),setPatreonUser:async(e,t=!1)=>{t?setLocalStorage("ddb-patreon-user",e):await game.settings.set(o.y.MODULE_ID,"patreon-user",e)},getPatreonTier:(e=!1)=>e?localStorage.getItem("ddb-patreon-tier"):game.settings.get(o.y.MODULE_ID,"patreon-tier"),setPatreonTier:async(e=!1)=>{const t=await w.fetchPatreonTier(e);e?setLocalStorage("ddb-patreon-tier",t):await game.settings.set(o.y.MODULE_ID,"patreon-tier",t)},fetchPatreonTier:async(e=!1)=>{if(h.isCustom())return{success:!0,message:"custom proxy",data:"CUSTOM"};const t=w.getPatreonKey(e),a=h.getProxy(),i={betaKey:t};return new Promise(((t,n)=>{fetch(`${a}/patreon/tier`,{method:"POST",mode:"cors",headers:{"Content-Type":"application/json"},body:JSON.stringify(i)}).then((e=>e.json())).then((a=>{a.success||(Utils.munchNote(`API Failure: ${a.message}`),n(a.message));let i=w.getPatreonUser(e);s.default.debug("Fetched Patreon tier information",{user:a.email,tier:a.data}),a.email!==i?w.setPatreonUser(a.email,e).then((()=>{t(a.data)})):t(a.data)})).catch((e=>n(e)))}))},getPatreonValidity:async e=>{if(h.isCustom())return{success:!0,message:"custom proxy",data:!0};const t=h.getProxy(),a={betaKey:e};return new Promise(((e,i)=>{fetch(`${t}/patreon/valid`,{method:"POST",mode:"cors",headers:{"Content-Type":"application/json"},body:JSON.stringify(a)}).then((e=>e.json())).then((t=>{e(t)})).catch((e=>i(e)))}))},calculateAccessMatrix:e=>{const t="GOD"===e,a="UNDYING"===e,i="COFFEE"===e,n="CUSTOM"===e||h.isCustom();return{god:t,undying:a,custom:n,coffee:i,source:t||a||i||n,experimentalMid:t||a,homebrew:t||a||i||n,all:t||a||i||n,supporter:t||a||i,not:!(t||a||i||n)}},checkPatreon:async(e=!1)=>{const t=await w.fetchPatreonTier(e);return w.calculateAccessMatrix(t)},linkToPatreon:async()=>{const e=h.getProxy(),t=`${e}/patreon/auth`,a=encodeURI("identity identity[email]"),i=io(`${e}/`,{transports:["websocket","polling","flashsocket"]});i.on("connect",(()=>{s.default.debug("DDB Muncher socketID",i.id);const e={id:i.id,world:game.world.title,userId:game.userId};i.emit("register",e)})),i.on("registered",(e=>{s.default.info("Foundry instance registered with DDB Muncher Proxy"),s.default.debug(e),Utils.renderPopup("web",`https://www.patreon.com/oauth2/authorize?response_type=code&client_id=oXQUxnRAbV6mq2DXlsXY2uDYQpU-Ea2ds0G_5hIdi0Bou33ZRJgvV8Ub3zsEQcHp&redirect_uri=${t}&state=${e.userHash}&scope=${a}`)})),i.on("auth",(e=>{s.default.debug("Response from auth socket!",e),CONFIG.DDBI.POPUPS.web.close(),game.settings.set(o.y.MODULE_ID,"beta-key",e.key),game.settings.set(o.y.MODULE_ID,"patreon-user",e.email),game.settings.set(o.y.MODULE_ID,"patreon-tier",e.tier),$("#ddb-patreon-user").text(e.email),$("#ddb-patreon-tier").text(e.tier),$("#ddb-patreon-valid").text("True"),$("#ddb-beta-key").val(e.key),i.disconnect()})),i.on("error",(e=>{s.default.error("Error Response from socket!",e),i.disconnect()}))}},S=w;function isJSON(e){try{return JSON.parse(e)&&!!e&&null!==e}catch(e){return!1}}function isLocalCobalt(e){return e&&""!==e&&null!==localStorage.getItem(`ddb-cobalt-cookie-${e}`)}function getCobalt(e=""){let t;const a=game.settings.get(o.y.MODULE_ID,"cobalt-cookie-local"),i=isLocalCobalt(e);return s.default.debug(`Getting Cookie: Key postfix? "${e}" -  Local? ${a} - Character? ${i}`),t=i?localStorage.getItem(`ddb-cobalt-cookie-${e}`):a?localStorage.getItem("ddb-cobalt-cookie"):game.settings.get(o.y.MODULE_ID,"cobalt-cookie"),t}async function setCobalt(e,t=""){const a=game.settings.get(o.y.MODULE_ID,"cobalt-cookie-local"),i=t&&""!==t;let n=e;isJSON(e)&&(n=JSON.parse(e).cbt),s.default.debug(`Setting Cookie: Key postfix? "${t}" -  Local? ${a} - Character? ${i}`),i?localStorage.setItem(`ddb-cobalt-cookie-${t}`,n):a?localStorage.setItem("ddb-cobalt-cookie",n):await game.settings.set(o.y.MODULE_ID,"cobalt-cookie",n)}function deleteLocalCobalt(e){isLocalCobalt(e)&&localStorage.removeItem(`ddb-cobalt-cookie-${e}`)}async function moveCobaltToLocal(){localStorage.setItem("ddb-cobalt-cookie",game.settings.get("ddb-importer","cobalt-cookie")),await game.settings.set(o.y.MODULE_ID,"cobalt-cookie",""),game.settings.set(o.y.MODULE_ID,"cobalt-cookie-local",!0)}async function moveCobaltToSettings(){game.settings.set(o.y.MODULE_ID,"cobalt-cookie",localStorage.getItem("ddb-cobalt-cookie")),game.settings.set(o.y.MODULE_ID,"cobalt-cookie-local",!1)}async function checkCobalt(e="",t=null){const a=t?isJSON(t)?JSON.parse(t).cbt:t:getCobalt(e),i=h.getProxy(),n={cobalt:a,betaKey:S.getPatreonKey()};return new Promise(((e,t)=>{fetch(`${i}/proxy/auth`,{method:"POST",cache:"no-cache",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)}).then((e=>e.json())).then((t=>e(t))).catch((e=>{s.default.error("Cobalt cookie check error"),s.default.error(e),s.default.error(e.stack),t(e)}))}))}class DDBMacros{static MACROS={WORLD:{},ACTIVE_AURAS:{AA_ONLY:{name:"Active Aura Only (Generic)",type:"generic",file:"activeAuraOnly.js",isGM:!1,img:null,world:!0},AA_ON_ENTRY:{name:"Active Aura Damage and Condition On Entry (Generic)",type:"generic",file:"activeAuraDamageAndConditionOnEntry.js",isGM:!1,img:null,world:!0},AA_CONDITION_ON_ENTRY:{name:"Active Aura Condition On Entry (Generic)",type:"generic",file:"activeAuraConditionOnEntry.js",isGM:!1,img:null,world:!0},AA_DAMAGE_ON_ENTRY:{name:"Active Aura Damage On Entry (Generic)",type:"generic",file:"activeAuraDamageOnEntry.js",isGM:!1,img:null,world:!0}}};static async checkMacroFolder(){game.folders.find((e=>"DDB Macros"===e.name&&"Macro"===e.type))||await Folder.create({color:"#FF0000",name:"DDB Macros",parent:null,type:"Macro"})}static async configureDependencies(){if(game.modules.get("midi-qol")?.active){let e=game.settings.get("midi-qol","ConfigSettings");e.allowUseMacro||(e.allowUseMacro=!0,game.settings.set("midi-qol","ConfigSettings",e))}else s.default.info("Midi-QOL not installed, skipping configuration check.");if(game.modules.get("itemacro")?.active&&game.modules.get("dae")?.active){game.settings.get("itemacro","defaultmacro")&&game.settings.set("itemacro","defaultmacro",!1)}return!0}static async loadMacroFile(e,t,a=!1,i=!1){const n=game.settings.get("ddb-importer","embed-macros");s.default.debug(`Getting macro for ${e} ${t}`);const r=!!(a||"undefined"!=typeof ForgeVTT&&ForgeVTT?.usingTheForge)||await y.fileExists(`[data] modules/ddb-importer/macros/${e}s`,t);let o;if(r&&(a||n)&&!i){const a=await y.getFileUrl(`[data] modules/ddb-importer/macros/${e}s`,t),i=await fetch(a,{method:"GET"});o=await i.text()}else!r||n&&!i?r||(o="// Unable to load the macro file"):o=`// Execute DDB Importer dynamic macro\nreturn game.modules.get("ddb-importer")?.api.macros.executeMacro("${e}", "${t}", scope);\n`;return o}static generateItemMacroFlag(e,t){const a=foundry.utils.isNewerVersion(game.modules.get("dae")?.version??0,"11.0.21"),i={name:e.name,type:"script",scope:"global",command:t},n=a?"flags.dae.macro":"flags.itemacro.macro";return foundry.utils.setProperty(e,n,i),e}static async setItemMacroFlag(e,t,a){if(!game.settings.get("ddb-importer","no-item-macros")){const i=await DDBMacros.loadMacroFile(t,a);e=DDBMacros.generateItemMacroFlag(e,i)}return e}static generateMacroChange({macroValues:e="",macroType:t=null,macroName:a=null,keyPostfix:i="",priority:n=20,ddbFunctions:s=null}={}){const r=s??game.settings.get("ddb-importer","no-item-macros");return{key:`${r?"macro.execute":"macro.itemMacro"}${i}`,value:`${r?`function.DDBImporter.lib.DDBMacros.macroFunction.${t}("${a}") `:""}${e}`,mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,priority:n}}static generateMidiOnUseMacroFlagValue(e,t,a=[],i=null){const n=game.settings.get("ddb-importer","no-item-macros"),s=n?`function.DDBImporter.lib.DDBMacros.macroFunction.${e}("${t}")`:`ItemMacro${i&&!n?`.${i}`:""}`;return a.map((e=>`[${e}]${s}`)).join(",")}static setMidiOnUseMacroFlag(e,t,a,i=[]){const n=DDBMacros.generateMidiOnUseMacroFlagValue(t,a,i);foundry.utils.setProperty(e,"flags.midi-qol.onUseMacroName",n)}static generateItemMacroValue({macroType:e=null,macroName:t=null,document:a=null}={}){const i=game.settings.get("ddb-importer","no-item-macros"),n=a&&!i?`.${a.name}`:"";return i?`function.DDBImporter.lib.DDBMacros.macroFunction.${e}("${t}")`.trim():`ItemMacro${n}`.trim()}static generateOnUseMacroChange({macroPass:e,macroType:t=null,macroName:a=null,priority:i=20,document:n=null,macroParams:s=""}={}){return{key:"flags.midi-qol.onUseMacroName",value:`${DDBMacros.generateItemMacroValue({macroType:t,macroName:a,document:n})},${e} ${s}`.trim(),mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,priority:i}}static generateDamageBonusMacroChange({macroType:e=null,macroName:t=null,priority:a=20,document:i=null}={}){return{key:"flags.dnd5e.DamageBonusMacro",value:DDBMacros.generateItemMacroValue({macroType:e,macroName:t,document:i}),mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,priority:a}}static generateTargetUpdateMacroChange({macroPass:e,macroType:t=null,macroName:a=null,priority:i=20,document:n,macroParams:s=""}={}){return{key:"flags.dae.onUpdateTarget",value:`${game.settings.get("ddb-importer","no-item-macros")?DDBMacros.generateItemMacroValue({macroType:t,macroName:a,document:n}):`${n.name}, ItemMacro`},${e} ${s}`.trim(),mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,priority:i}}static generateOptionalMacroChange({optionPostfix:e,macroPass:t=null,macroType:a=null,macroName:i=null,priority:n=20,document:s=null,macroParams:r=""}={}){const o=DDBMacros.generateItemMacroValue({macroType:a,macroName:i,document:s});return{key:`flags.midi-qol.optional.${e}`,value:t?`${o},${t} ${r}`.trim():`${o} ${r}`.trim(),mode:CONST.ACTIVE_EFFECT_MODES.CUSTOM,priority:n}}static async createMacro({name:e,content:t,img:a,isGM:i,isTemp:n}){const s=n?void 0:game.folders.find((e=>"DDB Macros"===e.name&&"Macro"===e.type)),r={name:e,type:"script",img:a||"icons/svg/dice-target.svg",scope:"global",command:t,folder:s?s.id:void 0,flags:{"advanced-macros":{runAsGM:i,runForSpecificUser:""}},ownership:{default:i?0:2}},o=game.macros.find((t=>t.name==e));o&&(r._id=o.id);return o?o.update(r):new Macro.implementation(r,{displaySheet:!1,temporary:n})}static async createWorldMacros(){if(game.user.isGM){await DDBMacros.checkMacroFolder();const e=[].concat(Object.values(DDBMacros.MACROS.WORLD)).filter((e=>e.world));for(const t of e){const e=await DDBMacros.loadMacroFile(t.type,t.file,!0);e&&await DDBMacros.createMacro({name:t.name,content:e,img:t.img,isGM:t.isGM,isTemp:!1})}}}static async getMacroBody(e,t){const a=await DDBMacros.loadMacroFile(e,t,!0);if(!a)throw ui.notifications.error(`Unable to load macro (${e}) ${t}`),s.default.warn(`Unable to load macro (${e}) ${t}`),new Error(`Unable to load macro (${e}) ${t}`);return a}static _getMacroFileNameFromName(e){const t=e.split(".js")[0];return{name:t,fileName:`${t}.js`}}static async loadDDBMacroToConfig(e,t,a){const i=await DDBMacros.getMacroBody(e,a),n=await DDBMacros.createMacro({name:`${e} ${a}`,content:i,img:null,isGM:!1,isTemp:!0});return foundry.utils.setProperty(CONFIG.DDBI.MACROS,`${e}.${t}`,n),s.default.debug(`Macro (${e}) ${a} loaded from file into cache`,n),n}static async getMacro(e,t){const a=DDBMacros._getMacroFileNameFromName(t);return CONFIG.DDBI.MACROS[e]?.[a.name]??await DDBMacros.loadDDBMacroToConfig(e,a.name,a.fileName)}static async executeDDBMacro(e,t,...a){const i=await DDBMacros.getMacro(e,t);return s.default.debug(`Calling (${e}) macro "${t}" with spread params`,...a),i.execute(...a)}static _getEffectVariables(e){const t=e.parent instanceof Actor?e.parent:e.parent.parent??null,a=t?.token?.object??t?.getActiveTokens()[0]??null,i=a?.scene??game.scenes.active??null,n=e.origin?fromUuidSync(e.origin):null;return{actor:t,token:a,speaker:t?ChatMessage.implementation.getSpeaker({actor:t}):{},scene:i,origin:n,effect:e,item:e.parent instanceof Item?e.parent:null}}static async executeDDBMacroAsGM(e,t,a={},...i){if(game.users.find((e=>e.active&&e.isGM))){if(game.user.isGM)return DDBMacros.executeDDBMacro(e,t,...i);{s.default.debug("Executing macro as GM",{type:e,name:t,ids:a,params:i});const n=await globalThis.DDBImporter.socket.executeAsGM("ddbMacroFunction",e,t,{},a,...i);return s.default.debug("GM Macro Result",n),n}}ui.notifications.error("No GM user found")}static getMacroFunction(e,t){return async(...a)=>(await DDBMacros.getMacro(e,t)).execute(...a)}static macroFunction={spell:e=>DDBMacros.getMacroFunction("spell",e),feat:e=>DDBMacros.getMacroFunction("feat",e),gm:e=>DDBMacros.getMacroFunction("gm",e),item:e=>DDBMacros.getMacroFunction("item",e),monsterFeature:e=>DDBMacros.getMacroFunction("monsterFeature",e),generic:e=>DDBMacros.getMacroFunction("generic",e)}}class DDBSimpleMacro{static MACROS={feat:{"lay-on-hands":{name:"layOnHands",label:"Lay On Hands Macro"},"lay-on-hands-pool":{name:"layOnHands",label:"Lay On Hands Macro"},"arcane-recovery":{name:"arcaneRecovery",label:"Arcane Recovery Macro"},"font-of-magic":{name:"fontOfMagic",label:"Font of Magic Macro"},"convert-sorcery-points":{name:"fontOfMagic",label:"Font of Magic Macro"}},item:{"spell-refuleing-ring":{name:"spellRefuelingRing",label:"Spell Refueling Macro"}}};static getDescriptionAddition(e,t,a){const i=Utils.referenceNameString(e).toLowerCase(),n=foundry.utils.getProperty(DDBSimpleMacro.MACROS,`${t}.${i}`);if(!n)return"";const s=a||(n.parameters??"");return`<br><p>[[/ddbifunc functionName="${n.name??i}" functionType="${t}" functionParams="${s}"]]{${n.label}}</div></p>`}static async execute(e,t,a={},i={},{...n}={}){const r=DDBMacros._getMacroFileNameFromName(t),o=await DDBMacros.getMacroBody(e,r.fileName),l=i.effect?await fromUuid(i.effect):null,d=i.effect?DDBMacros._getEffectVariables(l):{},c=i.actor?await fromUuid(i.actor):null;c&&(d.actor=c);const u=i.token?await fromUuid(i.token):null;u&&(d.token=u);const m=i.item?await fromUuid(i.item):null;m&&(d.item=m);const p=i.origin?await fromUuid(i.origin):null;if(p&&(d.origin=p),!d.speaker&&c){const e=ChatMessage.implementation.getSpeaker({actor:c,token:u});e&&(d.speaker=e)}d.character=game.user.character,d.scope=n,foundry.utils.setProperty(d.scope,"flags.ddb-importer.ddbMacroFunction",!0);const g=foundry.utils.mergeObject(d,n),h=new(0,async function(){}.constructor)(...Object.keys(g),`{${o}\n}`);try{return await h.call(a,...Object.values(g))}catch(e){return s.default.error(e),null}}}},259:(e,t,a)=>{a.d(t,{eK:()=>DDBFeatureActivity,XO:()=>DDBItemActivity,sr:()=>DDBMonsterFeatureActivity,IP:()=>DDBSpellActivity});var i=a(115),n=a(421),s=a(929),r=a(382);class DDBFeatureActivity extends s.DDBBasicActivity{_init(){n.logger.debug(`Generating DDBFeatureActivity ${this.name??this.type??"?"} for ${this.ddbParent.name}`)}constructor({type:e,name:t=null,ddbParent:a,nameIdPrefix:i=null,nameIdPostfix:n=null}={}){super({type:e,name:t,ddbParent:a,foundryFeature:a.data,nameIdPrefix:i,nameIdPostfix:n}),this.ddbDefinition=this.ddbParent.ddbDefinition}_generateParsedActivation(){const e=this.ddbParent.getParsedActionType();e&&(n.logger.debug(`Parsed manual activation type: ${e} for ${this.name}`),this.data.activation={type:e,cost:1,condition:""})}_generateActivation({activationOverride:e=null}={}){if(e)return void(this.data.activation=e);if(!this.ddbDefinition.activation)return void this._generateParsedActivation();const t=i.x.actions.activationTypes.find((e=>e.id===this.ddbDefinition.activation.activationType));t?this.data.activation={type:t.value,value:this.ddbDefinition.activation.activationTime||1,condition:""}:this._generateParsedActivation()}_generateConsumption({consumptionOverride:e=null}={}){if(e)return void(this.data.consumption=e);let t=[];this.ddbParent.rawCharacter&&Object.keys(this.ddbParent.rawCharacter.system.resources).forEach((e=>{const a=this.ddbParent.rawCharacter.system.resources[e];this.ddbDefinition.name===a.label&&t.push({type:"attribute",target:`resources.${e}.value`,value:1,scaling:{mode:"",formula:""}})}));const a=this.ddbDefinition.description??this.ddbDefinition.snippet??"",i=/(?:spend|expend) (\d) (?:ki|focus) point/gi.exec(a)??/spend (\d) sorcery points/gi.exec(a);i?t.push({type:"itemUses",target:"",value:i[1],scaling:{mode:"",formula:""}}):null!==this.ddbParent.resourceCharges?t.push({type:"itemUses",target:"",value:this.ddbParent.resourceCharges??1,scaling:{mode:"",formula:""}}):this.ddbParent.data.system.uses.max&&t.push({type:"itemUses",target:"",value:1,scaling:{mode:"",formula:""}}),this.data.consumption={targets:t,scaling:{allowed:!1,max:""}}}_generateDuration({durationOverride:e=null}={}){if(e)return void(this.data.duration=e);const t=this.ddbDefinition.description??this.ddbDefinition.snippet??"",a=r.DDBDescriptions.getDuration(t,!1);null!==a.type?this.data.duration={value:a.value,units:a.units,special:a.special}:this.data.duration={value:null,units:"inst",special:""}}_generateEffects(){n.logger.debug(`Stubbed effect generation for ${this.name}`)}_generateRange({rangeOverride:e=null}={}){if(e)this.data.range=e;else if(this.ddbDefinition.range&&this.ddbDefinition.range.aoeType&&this.ddbDefinition.range.aoeSize)this.ddbDefinition.range.range?this.data.range={value:this.ddbDefinition.range.range,units:"ft",special:""}:this.data.range={value:null,units:"self",special:""};else if(this.ddbDefinition.range&&this.ddbDefinition.range.range)this.data.range={value:this.ddbDefinition.range.range,units:"ft",special:""};else{this.data.range={value:["utility","summons","enchant"].includes(this.type)?null:5,units:["utility","summons","enchant"].includes(this.type)?"self":"ft",special:""};const e=this.ddbDefinition.description??this.ddbDefinition.snippet??"";/touch a creature|creature you touch/gi.exec(e)&&(this.data.range.units="touch")}}_getDescriptionTarget(){const e=this.ddbDefinition.description??this.ddbDefinition.snippet??"";let t={prompt:!0,affects:{count:"",type:"",choice:!1,special:""},template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:"ft"}};const a=this.ddbParent.targetsCreature(),n=/(each|one|a|the) creature(?: or object)?/gi.exec(e);(a||n)&&(t.affects.count=n&&["one","a","the"].includes(n[1])?"1":"",t.affects.type=n&&n[2]?"creatureOrObject":"creature");const s=/(?:within|in a|fills a) (?<within>\d+)(?: |-)(?:feet|foot|ft|ft\.)(?: |-)(cone|radius|emanation|sphere|line|cube|of it|of an|of the|of you|of yourself)(\w+[. ])?/gi.exec(e);if(s)if(s[2]&&["of you"].includes(s[2].trim())){this.data.range.value=s.groups.within??"",this.data.range.units="ft";const a=/(?:in a) (?<within>\d+)(?: |-)(?:feet|foot|ft|ft\.)(?: |-)(cone|radius|emanation|sphere|line|cube|of it|of an|of the)(\w+[. ])?/gi.exec(e);if(a){const e=a[3]?.trim()??a[2]?.trim()??"radius";t.template.type=["cone","radius","sphere","line","cube"].includes(e)?e:"radius",t.template.size=a.groups.within??""}}else{const e=s[3]?.trim()??s[2]?.trim()??"radius";t.template.type=["cone","radius","sphere","line","cube"].includes(e)?e:"radius",t.template.size=s.groups.within??""}const r=/creature of your choice|choose (?<num>\w+) creatures within/gi.exec(e);if(r&&(this.data.damage?.parts?.length>0||["save","attack","damage"].includes(this.type)?t.affects.type="enemy":["heal"].includes(this.type)&&(t.affects.type="ally"),t.affects.choice=!0,r.groups.num)){const e=Number.isInteger(parseInt(r.groups.num))?r.groups.num:i.x.numbers.find((e=>r.groups.num.toLowerCase()===e.natural))?.num??null;t.affects.count=e??"",e||(t.affects.special=r.groups.num)}return t}_generateTarget({targetOverride:e=null,targetSelf:t=null,noTemplate:a=null}={}){if(e)return void(this.data.target=e);let n={template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:"ft"},affects:{count:"",type:"",choice:!1,special:""},prompt:!0};if(this.ddbDefinition.range&&this.ddbDefinition.range.aoeType&&this.ddbDefinition.range.aoeSize){const e=i.x.actions.aoeType.find((e=>e.id===this.ddbDefinition.range.aoeType))?.value??"";n=foundry.utils.mergeObject(n,{template:{type:e,size:"line"===e?`${this.ddbDefinition.range.range}`:`${this.ddbDefinition.range.aoeSize}`,width:"line"===e?`${this.ddbDefinition.range.aoeSize}`:""}}),n.affects.type="creature"}else n=this._getDescriptionTarget();t&&(n.affects.type="self"),a&&(n.template={count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:"ft"}),this.data.target=n}_generateDamage({parts:e=null,includeBase:t=!1}={}){if(!this.ddbParent.getDamage&&!e)return;const a=(e??[this.ddbParent.getDamage()]).filter((e=>!!e&&(e.denomination||e.custom.enabled)));a&&0!==a.length&&(this.data.damage={includeBase:t,parts:a})}_generateHealing({part:e=null}={}){if(e)return void(this.data.healing=e);if(!this.ddbParent.getDamage)return;const t=this.ddbParent.getDamage();t&&(0===t.types.length&&t.types.push("healing"),this.data.healing=t)}_generateSave({saveOverride:e=null}={}){if(e)return void(this.data.save=e);const t=this.ddbDefinition.fixedSaveDc?this.ddbDefinition.fixedSaveDc:null;let a=t?"":this.ddbDefinition.abilityModifierStatId?i.x.actor.abilities.find((e=>e.id===this.ddbDefinition.abilityModifierStatId)).value:"spellcasting",n=this.ddbDefinition.saveStatId?i.x.actor.abilities.find((e=>e.id===this.ddbDefinition.saveStatId)).value:null;n||!this.ddbParent._descriptionSave?this.data.save={ability:n?[n]:[Object.keys(CONFIG.DND5E.abilities)[0]],dc:{calculation:a,formula:String(t??"")}}:this.data.save=this.ddbParent._descriptionSave}_generateAttack({attackOverride:e=null,unarmed:t=!1,spell:a=!1}={}){if(e)return void(this.data.attack=e);let i="melee",s=t?"unarmed":a?"spell":"weapon";1===this.ddbDefinition.actionType?i=2===this.ddbDefinition.attackTypeRange?"ranged":"melee":this.ddbDefinition.rangeId&&1===this.ddbDefinition.rangeId?i="melee":this.ddbDefinition.rangeId&&2===this.ddbDefinition.rangeId&&(i="ranged");const r=this.ddbParent.getBonusDamage?this.ddbParent.getBonusDamage():"",o={ability:this.ddbParent.getActionAttackAbility(),bonus:r&&0!==r?String(r):"",damage:{parts:[]},critical:{threshold:void 0},flat:!1,type:{value:i,classification:s}};this.ddbDefinition.isMartialArts&&(this.ddbParent.data.system.properties=n.utils.addToProperties(this.ddbParent.data.system.properties,"fin")),this.data.attack=o,foundry.utils.setProperty(this.data.damage,"includeBase",!0)}build({activationOverride:e=null,additionalTargets:t=null,attackData:a={},attackOverride:i=null,spellOverride:n=null,chatFlavor:s=null,checkOverride:r=null,consumeActivity:o=null,consumeItem:l=null,consumptionOverride:d=null,criticalDamage:c=null,damageParts:u=null,damageScalingOverride:m=null,data:p=null,ddbMacroOverride:g=null,durationOverride:h=null,generateActivation:f=!0,generateAttack:y=!1,generateSpell:b=!1,generateCheck:D=!1,generateConsumption:v=!0,generateDamage:C=!1,generateDDBMacro:w=!1,generateDescription:S=!1,generateDuration:I=!0,generateEffects:T=!0,generateEnchant:A=!1,generateHealing:k=!1,generateRange:E=!0,generateRoll:_=!1,generateSave:M=!1,generateSummon:B=!1,generateTarget:P=!0,generateUses:O=!1,healingPart:F=null,img:x=null,includeBase:L=!1,includeBaseDamage:R=!1,noeffect:N=!1,noTemplate:$=null,onSave:U=null,rangeOverride:H=null,roll:G=null,saveOverride:W=null,targetOverride:j=null,targetSelf:q=null,usesOverride:V=null}={}){f&&this._generateActivation({activationOverride:e}),y&&this._generateAttack({attackOverride:i,unarmed:null,spell:null}),v&&this._generateConsumption({consumptionOverride:d}),I&&this._generateDuration({durationOverride:h}),M&&this._generateSave({saveOverride:W}),C&&this._generateDamage({includeBase:L,parts:u}),k&&this._generateHealing({part:F}),E&&this._generateRange({rangeOverride:H}),P&&this._generateTarget({targetOverride:j,targetSelf:q,noTemplate:$}),super.build({generateActivation:!1,generateAttack:!1,generateConsumption:!1,generateSpell:b,generateCheck:D,generateDamage:!1,generateDescription:S,generateDuration:!1,generateEffects:T,generateHealing:!1,generateRange:!1,generateSave:!1,generateTarget:!1,generateDDBMacro:w,generateEnchant:A,generateRoll:_,generateSummon:B,generateUses:O,chatFlavor:s,onSave:U,noeffect:N,roll:G,targetOverride:j,checkOverride:r,spellOverride:n,rangeOverride:H,activationOverride:e,noManualActivation:!0,durationOverride:h,img:x,ddbMacroOverride:g,usesOverride:V,additionalTargets:t,consumeActivity:o,consumeItem:l,saveOverride:W,data:p,attackData:a,includeBaseDamage:R,criticalDamage:c,damageScalingOverride:m,healingPart:F?.part??F??null,healingChatFlavor:F?.chatFlavor??null,damageParts:u})}}class DDBItemActivity extends s.DDBBasicActivity{_init(){n.logger.debug(`Generating DDBItemActivity ${this.name??this.type??"?"} for ${this.ddbParent.name}`)}constructor({type:e,name:t,ddbParent:a,nameIdPrefix:i=null,nameIdPostfix:n=null}={}){super({type:e,name:t,ddbParent:a,foundryFeature:a.data,nameIdPrefix:i,nameIdPostfix:n}),this.actionInfo=a.actionInfo}_generateConsumption({targetOverrides:e=null,consumptionOverride:t=null,additionalTargets:a=[],consumeActivity:i=!1}={}){if(t)return void(this.data.consumption=t);let n=[];i?n.push({type:"activityUses",target:"",value:1,scaling:{mode:"",formula:""}}):this.actionInfo.consumptionTargets?.length>0?n=this.actionInfo.consumptionTargets:this.actionInfo.consumptionValue?n.push({type:"itemUses",target:"",value:this.actionInfo.consumptionValue,scaling:{mode:"",formula:""}}):[0,null,void 0].includes(this.ddbParent.data.system.uses?.max)||n.push({type:"itemUses",target:"",value:1,scaling:{mode:"",formula:""}}),a&&a.length>0&&n.push(...a),this.data.consumption={targets:e??n,scaling:{allowed:!1,max:""}}}_generateCheck({checkOverride:e=null}={}){this.data.check=e??{associated:this.actionInfo.associatedToolsOrAbilities,ability:this.actionInfo.ability,dc:{}}}build({activationOverride:e=null,additionalTargets:t=null,attackData:a={},spellOverride:i=null,chatFlavor:n=null,checkOverride:s=null,consumeActivity:r=null,consumeItem:o=null,consumptionTargetOverrides:l=null,criticalDamage:d=null,criticalThreshold:c,damageParts:u=null,damageScalingOverride:m=null,data:p=null,ddbMacroOverride:g=null,durationOverride:h=null,generateActivation:f=!0,generateAttack:y=!1,generateSpell:b=!1,generateCheck:D=!1,generateConsumption:v=!0,generateDamage:C=!1,generateDDBMacro:w=!1,generateDescription:S=!1,generateDuration:I=!0,generateEffects:T=!0,generateEnchant:A=!1,generateHealing:k=!1,generateRange:E=!0,generateRoll:_=!1,generateSave:M=!1,generateSummon:B=!1,generateTarget:P=!0,generateUses:O=!1,healingChatFlavor:F=null,healingPart:x=null,img:L=null,includeBaseDamage:R=!0,noeffect:N=!1,onSave:$=null,rangeOverride:U=null,roll:H=null,saveOverride:G=null,targetOverride:W=null,usesOverride:j=null,consumptionOverride:q=null}={}){v&&this._generateConsumption({targetOverrides:l,additionalTargets:t,consumeActivity:r,consumptionOverride:q}),D&&this._generateCheck({checkOverride:s}),super.build({generateActivation:f,generateAttack:y,generateSpell:b,generateConsumption:!1,generateCheck:!1,generateDamage:C,generateDescription:S||n,generateDuration:I,generateEffects:T,generateHealing:k,generateRange:E,generateSave:M,generateTarget:P,generateDDBMacro:w,generateEnchant:A,generateRoll:_,generateSummon:B,healingChatFlavor:F,generateUses:O,chatFlavor:n,onSave:$,noeffect:N,spellOverride:i,roll:H,targetOverride:W??this.actionInfo.target,checkOverride:s,rangeOverride:U??this.actionInfo.range,activationOverride:e??this.actionInfo.activation,noManualActivation:!0,durationOverride:h??this.actionInfo.duration,img:L,ddbMacroOverride:g,usesOverride:j??this.actionInfo.uses,additionalTargets:t,consumeActivity:r,consumeItem:o,saveOverride:G??this.actionInfo.save,data:p,attackData:foundry.utils.mergeObject({criticalThreshold:c,ability:this.actionInfo.ability,bonus:this.actionInfo.extraAttackBonus,flat:this.actionInfo.isFlat,type:this.actionInfo.meleeAttack?"melee":"ranged",classification:this.actionInfo.spellAttack?"spell":"weapon"},a),includeBaseDamage:R??!0,criticalDamage:d,damageScalingOverride:m,healingPart:x||(this.ddbParent.healingParts.length>0?this.ddbParent.healingParts[0]:void 0),damageParts:u||(["weapon","staff"].includes(this.ddbParent.parsingType)?this.ddbParent.damageParts.slice(1):this.ddbParent.damageParts)}),!this.data.uses||this.data.uses?.max&&""!==this.data.uses?.max||(this.data.uses.spent=null)}}class DDBSpellActivity extends s.DDBBasicActivity{_init(){n.logger.debug(`Generating DDBSpellActivity ${this.name??this.type??"?"} for ${this.ddbParent.name}`)}constructor({type:e,name:t=null,ddbParent:a,nameIdPrefix:i=null,nameIdPostfix:n=null,spellEffects:s=null,cantripBoost:r=null,healingBoost:o=null}={}){super({type:e,name:t,ddbParent:a,foundryFeature:a.data,nameIdPrefix:i,nameIdPostfix:n}),this.spellData=a.spellData,this.ddbDefinition=this.spellData.definition,this.spellEffects=s??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.addSpellEffects"),this.damageRestrictionHints=game.settings.get("ddb-importer","add-damage-restrictions-to-hints")&&!this.spellEffects,this.isCantrip=0===this.ddbDefinition.level;const l=r??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.cantripBoost");this.cantripBoost=this.isCantrip&&l;const d=o??foundry.utils.getProperty(this.spellData,"flags.ddbimporter.dndbeyond.healingBoost");this.healingBonus=d?` + ${d} + @item.level`:"",this.additionalActivityDamageParts=[]}_generateConsumption({consumptionOverride:e=null,additionalTargets:t=[],consumeActivity:a=!1,consumeItem:i=null}={}){if(e)return void(this.data.consumption=e);let n=t??[],s=!0;a?(s=!1,n.push({type:"activityUses",target:"",value:1,scaling:{mode:"",formula:""}})):(this.spellData.limitedUse||i)&&(s=!1,n.push({type:"itemUses",target:"",value:this.spellData.limitedUse?.minNumberConsumed??1,scaling:{mode:"",formula:""}})),this.data.consumption={spellSlot:s,targets:n,scaling:{allowed:!1,max:""}}}#Z(){let e=this.ddbDefinition.description.match(/instead[\w\s]+(\d+d\d+) (\w+) damage/);return e?e[1]:""}getScaleType(e){let t=null;const a=e.atHigherLevels.scaleType?e.atHigherLevels.scaleType:this.ddbDefinition.scaleType;if(e.atHigherLevels.higherLevelDefinitions&&Array.isArray(e.atHigherLevels.higherLevelDefinitions)&&e.atHigherLevels.higherLevelDefinitions.length>=1&&"spellscale"===a){e.atHigherLevels.higherLevelDefinitions[0]?t=a:n.logger.warn("No spell definition found for "+this.ddbDefinition.name)}else"spellscale"===a||("characterlevel"===a?t=0===e.atHigherLevels.higherLevelDefinitions.length?null:a:("spelllevel"===a||n.logger.warn(`${this.ddbDefinition.name} parse failed: `,a),t=a));return t}getScaling({damageMod:e=null}={}){let t="",a="",i=null;if(this.ddbDefinition.canCastAtHigherLevel){const s=e?[e]:this.ddbDefinition.modifiers.filter((e=>"damage"===e.type||"bonus"===e.type&&"hit-points"===e.subType));for(const e of s){if(e&&e.die&&(null!==e.die.diceString&&(t=e.die.diceString),null!==e.die.fixedValue&&""===t&&(t=e.die.fixedValue)),!e.atHigherLevels)continue;const s=e.atHigherLevels.higherLevelDefinitions&&Array.isArray(e.atHigherLevels.higherLevelDefinitions)&&e.atHigherLevels.higherLevelDefinitions.length>=1,r=e.atHigherLevels.scaleType?e.atHigherLevels.scaleType:this.ddbDefinition.scaleType;if(s&&"spellscale"===r){const t=e.atHigherLevels.higherLevelDefinitions[0];if(t){const e=t.dice?t.dice:t.die?t.die:void 0,i=e?.diceString?e.diceString:e?.fixedValue?e.fixedValue:t.value,n=/(\d*)d\d*/,s=n.exec(a),r=n.exec(i),o=r?r.length>1?r[1]:r[0]:void 0;s||r?(!s||o>s[1])&&(a=i):a=i}else n.logger.warn("No definition found for "+this.ddbDefinition.name)}else s&&"characterlevel"===r&&(a=t);i=this.getScaleType(e)}}switch(i){case"characterlevel":return{old:"cantrip",mode:"whole",formula:String(a)};case"spellscale":return{old:"level",mode:"whole",formula:String(a)};case"spelllevel":case null:return{old:"none",mode:"",formula:""};default:return{old:"level",mode:"whole",formula:""}}}buildDamagePart({damageString:e,type:t,damageMod:a=null}={}){const i=r.SystemHelpers.buildDamagePart({damageString:e,type:t}),n=this.getScaling({damageMod:a});if(i.scaling.mode=n.mode,"none"===n.old)return i;const s=n.formula.match(/^\s*(\d+)d(\d+)\s*$/i);return s&&Number(s[2])===i.denomination?(i.scaling.number=Number(s[1]??1),i.scaling.formula=""):i.scaling.formula=n.formula,i}_generateDamage({damageParts:e=null,onSave:t=null,partialDamageParts:a,modRestrictionFilter:i=null,modRestrictionFilterExcludes:s=null}={}){if(e)return void(this.data.damage={parts:e,onSave:t??(this.isCantrip?"none":"half")});let r=[],o="",l=[];const d=this.ddbDefinition.modifiers.filter((e=>"damage"===e.type)).filter((e=>null===s||!e.restriction||""===e.restriction||e.restriction&&!s.some((t=>e.restriction.toLowerCase().includes(t.toLowerCase()))))).filter((e=>null===i||e.restriction&&i.some((t=>e.restriction.toLowerCase().includes(t.toLowerCase())))));if(0!==d.length){d.forEach((e=>{const t=e.restriction&&""!==e.restriction?e.restriction:"";this.damageRestrictionHints||""===t||l.push(`Restriction: ${t}`);const a=e.usePrimaryStat||this.cantripBoost?" + @mod":"";let i=n.utils.parseDiceString(e.die.diceString,a).diceString;if(i&&""!==i.trim()&&"null"!==i.trim()){const t=this.buildDamagePart({damageString:i,type:e.subType,damageMod:e});r.push(t)}}));const e=this.#Z(this.spellData);o=this.cantripBoost&&e&&""!=e?`${e} + @mod`:e}if(this.data.description.chatFlavor=l.join(", "),o){const e=this.buildDamagePart({damageString:o});this.additionalActivityDamageParts.push(e)}if(a){const e=[];for(const t of a)e.push(r[t]);r=e}this.ddbParent.enricher?.activity?.splitDamage&&(r=r.slice(0,1)),this.data.damage={parts:r,onSave:this.isCantrip?"none":"half"}}_generateSave({saveOverride:e=null}={}){if(e)this.data.save=e;else if(this.ddbDefinition.requiresSavingThrow&&this.ddbDefinition.saveDcAbilityId){const e=i.x.actor.abilities.find((e=>e.id===this.ddbDefinition.saveDcAbilityId))?.value;this.spellData.overrideSaveDc?this.data.save={ability:[e],dc:{formula:this.spellData.overrideSaveDc,calculation:""}}:this.data.save={ability:[e],dc:{formula:"",calculation:"spellcasting"}}}}build({activationOverride:e=null,additionalTargets:t=[],attackData:a={},spellOverride:i=null,chatFlavor:n=null,checkOverride:s=null,consumeActivity:r=!1,consumeItem:o=null,consumptionOverride:l=null,criticalDamage:d=null,damageParts:c=null,damageScalingOverride:u=null,data:m=null,ddbMacroOverride:p=null,durationOverride:g=null,generateActivation:h=!1,generateAttack:f=!1,generateCheck:y=!1,generateSpell:b=!1,generateConsumption:D=!0,generateDamage:v=!1,generateDDBMacro:C=!1,generateDescription:w=!1,generateDuration:S=!1,generateEffects:I=!0,generateEnchant:T=!1,generateHealing:A=!1,generateRange:k=!1,generateRoll:E=!1,generateSave:_=!1,generateSummon:M=!1,generateTarget:B=!1,generateUses:P=!1,healingPart:O=null,img:F=null,includeBaseDamage:x=!1,noeffect:L=!1,noSpellslot:R=!1,onSave:N=null,partialDamageParts:$=null,rangeOverride:U=null,roll:H=null,saveOverride:G=null,targetOverride:W=null,usesOverride:j=null,modRestrictionFilter:q=null,modRestrictionFilterExcludes:V=null}={}){D&&this._generateConsumption({consumptionOverride:l,additionalTargets:t,consumeActivity:r,consumeItem:o}),_&&this._generateSave({saveOverride:G}),v&&this._generateDamage({damageParts:c,onSave:N,partialDamageParts:$,modRestrictionFilter:q,modRestrictionFilterExcludes:V}),R&&foundry.utils.setProperty(this.data,"consumption.spellSlot",!1),super.build({generateActivation:h||null!==e,generateAttack:f,generateSpell:b,generateConsumption:!1,generateCheck:y,generateDamage:!1,generateDescription:w,generateDuration:S,generateEffects:I,generateHealing:A,generateRange:k,generateSave:!1,generateTarget:B,generateDDBMacro:C,generateEnchant:T,generateRoll:E,generateSummon:M,generateUses:P,chatFlavor:n,onSave:N,noeffect:L,roll:H,spellOverride:i,targetOverride:W,checkOverride:s,rangeOverride:U,activationOverride:e,noManualActivation:!0,durationOverride:g,img:F,ddbMacroOverride:p,usesOverride:j,additionalTargets:t,consumeActivity:r,consumeItem:o,saveOverride:G,data:m,attackData:foundry.utils.mergeObject({ability:"spellcasting",bonus:"",criticalThreshold:void 0,type:this.ddbDefinition.range.rangeValue&&this.ddbDefinition.range.rangeValue>0?"ranged":"melee",flat:!1,classification:"spell"},a),includeBaseDamage:x,criticalDamage:d,damageScalingOverride:u,healingPart:O?.part??O??null,healingChatFlavor:O?.chatFlavor??null,damageParts:c})}}class DDBMonsterFeatureActivity extends s.DDBBasicActivity{_init(){n.logger.debug(`Generating DDBMonsterFeatureActivity ${this.name??this.type??"?"} for ${this.actor.name}`)}constructor({type:e,name:t,ddbParent:a,nameIdPrefix:i=null,nameIdPostfix:n=null}={}){super({type:e,name:t,ddbParent:a,foundryFeature:a.data,nameIdPrefix:i,nameIdPostfix:n,actor:a.ddbMonster.npc}),this.actionInfo=a.actionInfo}_generateActivation(){this.data.activation=this.actionInfo.activation}_generateConsumption(){let e=[];this.actionInfo.consumptionTargets?.length>0?e=this.actionInfo.consumptionTargets:this.actionInfo.consumptionValue&&e.push({type:"itemUses",target:"",value:this.actionInfo.consumptionValue,scaling:{mode:"",formula:""}}),this.data.consumption={targets:e,scaling:{allowed:!1,max:""}}}_generateDescription(){this.data.description={chatFlavor:this.foundryFeature.system?.chatFlavor??""}}_generateDuration(){this.data.duration=this.actionInfo.duration}_generateEffects(){n.logger.debug(`Stubbed effect generation for ${this.name}`)}_generateRange(){this.data.range=this.actionInfo.range}_generateTarget(){this.data.target=this.actionInfo.target}_getFeaturePartsDamage(){return"weapon"===this.ddbParent.templateType?this.actionInfo.damageParts.slice(1):this.actionInfo.damageParts}_generateDamage({parts:e=[],includeBase:t=!0}={}){const a="companion-feature"===foundry.utils.getProperty(this.ddbParent.ddbMonster,"npc.flags.ddbimporter.entityTypeId");let i=e.length>0?e:this._getFeaturePartsDamage().map((e=>e.part));a&&(i=i.map((e=>(e.bonus=e.bonus.replace("@prof",""),e)))),this.data.damage={includeBase:t,parts:i}}_generateHealing({part:e=null}={}){const t=e||(this.actionInfo.healingParts.length>0?this.actionInfo.healingParts.map((e=>e.part))[0]:void 0);this.data.healing=t}_generateSave(){this.data.save=this.actionInfo.save}_generateAttack(){let e=this.ddbParent.spellAttack?"spell":"weapon",t=this.ddbParent.rangedAttack?"ranged":"melee";const a={ability:this.actionInfo.baseAbility,bonus:this.actionInfo.extraAttackBonus&&"0"!==`${this.actionInfo.extraAttackBonus}`.trim()?`${this.actionInfo.extraAttackBonus}`:"",critical:{threshold:void 0},flat:!1,type:{value:t,classification:e}};this.data.attack=a}_generateCheck({checkOverride:e=null}){this.data.check=e??{associated:this.actionInfo.associatedToolsOrAbilities,ability:this.actionInfo.ability,dc:{}}}build({damageParts:e=[],healingPart:t=null,generateActivation:a=!0,generateAttack:i=!1,generateConsumption:s=!0,generateCheck:r=!1,generateDamage:o=!1,generateDescription:l=!1,generateDuration:d=!0,generateEffects:c=!0,generateHealing:u=!1,generateRange:m=!0,generateSave:p=!1,generateTarget:g=!0,includeBaseDamage:h=!0,checkOverride:f=null}={}){n.logger.debug(`Generating Activity for ${this.ddbParent.name}`,{damageParts:e,healingPart:t,generateActivation:a,generateAttack:i,generateConsumption:s,generateDamage:o,generateDescription:l,generateDuration:d,generateEffects:c,generateHealing:u,generateRange:m,generateSave:p,generateTarget:g,includeBaseDamage:h,generateCheck:r,checkOverride:f,this:this}),a&&this._generateActivation(),i&&this._generateAttack(),s&&this._generateConsumption(),l&&this._generateDescription(),d&&this._generateDuration(),c&&this._generateEffects(),m&&this._generateRange(),g&&this._generateTarget(),p&&this._generateSave(),o&&this._generateDamage({parts:e,includeBase:h}),u&&this._generateHealing({part:t}),r&&this._generateCheck({checkOverride:f})}static createActivity({document:e,type:t,name:a,character:i}={},n={}){const s=new DDBMonsterFeatureActivity({name:a??null,type:t,foundryFeature:e,actor:i});return s.build(n),foundry.utils.setProperty(e,`system.activities.${s.data._id}`,s.data),s.data._id}}},81:(e,t,a)=>{a.d(t,{A:()=>DDBCompanion2024});var i=a(115),n=a(421),s=a(913),r=a(492),o=a(899),l=a(449),d=a(648);class DDBCompanion2024{constructor(e,t={}){this.options=t,this.block=e,this.blockDatas=this.block.querySelectorAll("p.Stat-Block-Styles_Stat-Block-Data"),this.npc=null,this.data={},this.parsed=!1,this.type=this.options.type,this.useItemAC=!1,this.legacyName=!1,this.addMonsterEffects=!0,this.removeSplitCreatureActions=!0,this.removeCreatureOnlyNames=!0,this.addChrisPremades=!0,this.summons={match:{proficiency:!1,attacks:!1,saves:!1},creatureSizes:[],creatureTypes:[],bonuses:{ac:"",hp:"",attackDamage:"",saveDamage:"",healing:""},profiles:[],summon:{identifier:"",mode:"",prompt:!0}}}static async addEnrichedImageData(e){if(!(await n.PatreonHelper.checkPatreon()).all||n.DDBProxy.isCustom())return e;const t=e.name;if(!CONFIG.DDBI.EXTRA_IMAGES){const t="/proxy/enriched/actor/images",a=n.DDBProxy.getProxy(),i=await fetch(`${a}${t}`,{method:"GET",headers:{"Content-Type":"application/json"}}),s=await i.json();if(!s.success)return e;foundry.utils.setProperty(CONFIG,"DDBI.EXTRA_IMAGES",s.data)}if(!foundry.utils.hasProperty(CONFIG,"DDBI.EXTRA_IMAGES.summons"))return e;const a=CONFIG.DDBI.EXTRA_IMAGES.summons[t]??CONFIG.DDBI.EXTRA_IMAGES.summons[t.split("(")[0].trim()];if(!a)return e;if(a.monsterIDs&&a.monsterIDs.length>0){const t=new r.A({type:"summons"});await t.fetchDDBMonsterSourceData(r.A.defaultFetchOptions(a.monsterIDs));for(const a of t.source){const t=a.basicAvatarUrl??a.largeAvatarUrl??a.avatarUrl,i=a.avatarUrl;return foundry.utils.setProperty(e,"flags.monsterMunch.tokenImg",i),foundry.utils.setProperty(e,"flags.monsterMunch.img",t),e}}return a.actor&&foundry.utils.setProperty(e,"flags.monsterMunch.img",a.actor),a.token&&foundry.utils.setProperty(e,"flags.monsterMunch.tokenImg",a.token),e}#ee(){this.block.querySelector("div.stat-block-ability-scores").querySelectorAll("div.stat-block-ability-scores-stat").forEach((e=>{const t=e.querySelector("div.stat-block-ability-scores-heading").innerText.toLowerCase(),a=e.querySelector("span.stat-block-ability-scores-score")?.innerText??(()=>{const t=e.querySelector("div.stat-block-ability-scores-data").cloneNode(!0);return t.getElementsByTagName("span")[0].innerHTML="",t.innerText.trim()})(),i=Number.parseInt(a),n=CONFIG.DDB.statModifiers.find((e=>e.value==i)).modifier;this.npc.system.abilities[t].value=i,this.npc.system.abilities[t].mod=n}))}getBlockData(e){const t=Array.from(this.blockDatas).find((t=>{const a=t.innerText.trim(),i=a.startsWith(e),n=!a.toLowerCase().includes("only")||a.toLowerCase().includes(this.options.subType.toLowerCase());return i&&n}));if(!t)return;const a=t.getElementsByTagName("strong")[0].innerText.toLowerCase();if(a.includes("only")&&!a.includes(this.options.subType.toLowerCase()))return;const i=t.cloneNode(!0);return i.getElementsByTagName("strong")[0].innerHTML="",i.innerText.trim()}#te(){const e=this.getBlockData("Saving Throws");if(!e)return;e.split(",").forEach((e=>{const t=e.trim().split(" ")[0].toLowerCase();(e.includes("plus PB")||e.includes("+ PB"))&&(this.npc.system.abilities[t].proficient=1)}))}#ae(){const e=this.getBlockData("Armor Class");if(!e)return;const t=Number.parseInt(e.split(",")[0]);Number.isInteger(t)&&(this.npc.system.attributes.ac={flat:t,calc:"natural",formula:""},e.includes("plus PB")||e.includes("+ PB")?this.summons.bonuses.ac="@prof":e.includes("+ the level of the spell")&&(this.summons.bonuses.ac="@item.level"))}#ie(){const e=this.block.querySelector("p.Stat-Block-Styles_Stat-Block-Data-Last")??this.getBlockData("Challenge");e&&e.innerText.includes("equals your bonus")&&(this.summons.match.proficiency=!0)}#ne(e){const t=(this.options.subType&&e.includes(" or ")?e.split("or").find((e=>e.toLowerCase().includes(this.options.subType.toLowerCase()))):e.trim()).trim().match(/(\d*)/),a=Number.parseInt(t);return Number.isInteger(a)?a:0}#se(){const e=this.getBlockData("Hit Points");if(!e)return;const t=this.#ne(e);this.npc.system.attributes.hp.max=t,this.npc.system.attributes.hp.value=t;const a=[],n=e.match(/\+ your (\w+) modifier/);n&&a.push(`@abilities.${n[1].toLowerCase().substring(0,3)}.mod`);const s=e.match(/\+ (\w+)?( times? )?your (\w+) level/);if(s){const e=s[3].trim().toLowerCase(),t=s[1]?i.x.numbers.find((e=>e.natural===s[1].trim().toLowerCase())).num:null,n=t?` * ${t}`:"";a.push(`(@classes.${e}.levels${n})`)}const r=e.match(/\+ (\d+) for each spell level above (\d)/);r&&a.push(`(${r[1]} * (@item.level - ${r[2]}))`),a.length>0&&(this.summons.bonuses.hp=a.join(" + "))}#re(){const e=this.getBlockData("Hit Points");if(!e||!e.includes("number of Hit Dice"))return;const t=e.match(/Hit Dice \[d(\d)s\] equal to your (\w+) level/);if(t){const e={key:"system.attributes.hp.formula",value:`(@classes.${t[2]}.levels)[d${t[1]}]`};this.npc.flags.ddbimporter.summons.changes.push(e)}}#oe(){const e=this.getBlockData("Skills");if(!e)return;const t=e.split(",").filter((e=>""!=e)).map((t=>{const a=t.trim().match(/(\w+ *\w* *\w*)(?: *)([+-])(?: *)(\d+) *(plus PB)? *(&times;|x|times)? *(\d*)?/);let i={};return a?(i={name:a[1].trim(),value:a[2]+a[3],proficient:void 0!==a[4],expertise:Number.isInteger(a[5]?.trim()),pbMultiplier:a[5]},n.logger.debug(`Found skill for companion ${this.npc.name}`,i)):(n.logger.error(`Skill Parsing failed for ${this.npc.name}`),n.logger.debug(e),n.logger.debug(t),n.logger.debug(a)),i})),a=Object.keys(this.npc.system.skills),s=i.x.actor.skills.map((e=>e.name));a.filter((e=>s.includes(e))).forEach((e=>{let a=this.npc.system.skills[e];const n=i.x.actor.skills.find((t=>t.name==e)),s=t.find((e=>e.name==n.label));if(s){a.value=s.expertise?2:s.proficient?1:0;const t=this.npc.system.abilities[a.ability];parseInt(t.mod)!==parseInt(s.value.trim())&&(a.bonuses.check=parseInt(s.value.trim())-parseInt(t.mod),a.bonuses.passive=parseInt(s.value.trim())-parseInt(t.mod)),this.npc.system.skills[e]=a}}))}#le(){const e=this.block.querySelector("p.Stat-Block-Styles_Stat-Block-Metadata").innerHTML;if(!e)return;const t=e.split(" ")[0],a=i.x.sizes.find((e=>t.toLowerCase()==e.name.toLowerCase()))??{name:"Medium",value:"med",size:1};this.npc.system.traits.size=a.value,this.npc.prototypeToken.width=a.size>=1?a.size:1,this.npc.prototypeToken.height=a.size>=1?a.size:1,this.npc.prototypeToken.scale=a.size>=1?1:a.size}#de(){const e=this.block.querySelector("p.Stat-Block-Styles_Stat-Block-Metadata").innerHTML;if(!e)return;const t=e.split(",")[0].split(" ").pop().toLowerCase();CONFIG.DND5E.creatureTypes[t]?this.npc.system.details.type.value=t:this.npc.system.details.type.value="Unknown"}#ce(){const e=this.block.querySelector("p.Stat-Block-Styles_Stat-Block-Metadata").innerHTML;if(!e)return;const t=e.split(",").pop().toLowerCase().trim();t&&""!==t&&(this.npc.system.details.alignment=t)}static getDamageAdjustments(e){const t=[],a=[],n=[],s=i.x.actions.damageType.filter((e=>null!==e.name)).map((e=>e.name));e.forEach((e=>{s.includes(e.toLowerCase())?t.push(e.toLowerCase()):e.includes("physical")?(t.push("bludgeoning","piercing","slashing"),n.push("mgc")):a.push(e)}));return{value:t,bypasses:n,custom:a.join("; ")}}filterDamageConditions(e){const t=e.split(/[;,]/).filter((e=>!e.includes("only")||!!e.toLowerCase().includes(this.options.subType.toLowerCase()))),a=[];return t.forEach((e=>{const t=e.split("and").map((e=>e.includes("determined by the")?this.options.subType.toLowerCase():e.split("(")[0].trim().toLowerCase()));a.push(...t)})),a}#ue(){const e=this.getBlockData("Damage Immunities");e&&(this.npc.system.traits.di=DDBCompanion2024.getDamageAdjustments(this.filterDamageConditions(e)))}#me(){const e=this.getBlockData("Damage Resistances");e&&(this.npc.system.traits.dr=DDBCompanion2024.getDamageAdjustments(this.filterDamageConditions(e)))}#pe(){const e=this.getBlockData("Damage Vulnerabilities");e&&(this.npc.system.traits.dv=DDBCompanion2024.getDamageAdjustments(this.filterDamageConditions(e)))}#ge(){const e=this.getBlockData("Condition Immunities");if(!e)return;let t=[],a=[];e.split(",").forEach((e=>{const n=i.x.conditions.find((t=>t.label.toLowerCase()==e.trim().toLowerCase()));n?t.push(n.foundry):a.push(e)})),this.npc.system.traits.ci={value:t,custom:a.join("; ")}}#q(){const e=this.getBlockData("Senses");e&&e.split(",").forEach((e=>{const t=e.match(/(darkvision|blindsight|tremorsense|truesight)\s+(\d+)/i);if(t){const e=parseInt(t[2]);this.npc.system.attributes.senses.units="ft",this.npc.system.attributes.senses[t[1].toLowerCase()]=e;const a=i.x.senseMap()[t[1].toLowerCase()];if(e>0&&e>this.npc.prototypeToken.sight.range&&foundry.utils.hasProperty(CONFIG.Canvas.visionModes,a)&&(foundry.utils.setProperty(this.npc.prototypeToken.sight,"visionMode",a),foundry.utils.setProperty(this.npc.prototypeToken.sight,"range",e),this.npc.prototypeToken.sight=foundry.utils.mergeObject(this.npc.prototypeToken.sight,CONFIG.Canvas.visionModes[a].vision.defaults)),e>0&&foundry.utils.hasProperty(i.x.detectionMap,t[1].toLowerCase())){const a={id:i.x.detectionMap[t[1].toLowerCase()],range:e,enabled:!0};this.npc.prototypeToken.detectionModes.some((e=>e.id===a.id))||this.npc.prototypeToken.detectionModes.push(a)}}}))}#he(){const e=this.getBlockData("Languages");e&&(this.npc.system.traits.languages.custom=e)}#fe(){const e=this.getBlockData("Speed");if(!e)return;const t=e.split(/[;,]/).filter((e=>!e.includes("only")||!!e.toLowerCase().includes(this.options.subType.toLowerCase()))),a=[];t.forEach((e=>{const t=e.split("and").map((e=>e.trim().toLowerCase()));a.push(...t)})),a.forEach((e=>{const t=e.match(/(\w+ )*(\d+)/i);if(t){const a=t[1]?.trim()??"walk";this.npc.system.attributes.movement[a]=parseInt(t[2]),e.includes("hover")&&(this.npc.system.attributes.movement.hover=!0)}}))}async getFeature(e,t){const a=new d.DDBMonsterFeatureEnricher;await a.init();const i={enricher:a,extra:!0,useItemAC:this.useItemAC,legacyName:this.legacyName,addMonsterEffects:this.addMonsterEffects,addChrisPremades:this.addChrisPremades},r=new s.A(null,i);r.name=this.name,r.npc=foundry.utils.duplicate(this.npc),r.abilities=r.npc.system.abilities,r.proficiencyBonus=0;const l=new o.A({ddbMonster:r,hideDescription:!1,updateExisting:!1});await l.generateActions(e,t),n.logger.debug("Generating companion feature",{text:e,type:t,featureFactory:l});/(your spell attack modifier to hit)/i.test(e)&&(this.summons.match.attacks=!0);return/(against your spell save DC)/i.test(e)&&(this.summons.match.saves=!0),l.getFeatures(t)}async#ye(e,t){let a=e.nextElementSibling;if(!a)return{next:a,featType:t};switch(a.innerText.trim().toLowerCase()){case"action":case"actions":return n.logger.debug("Companion parsing switching to actions"),{next:a,featType:"action"};case"reaction":case"reactions":return n.logger.debug("Companion parsing switching to reactions"),{next:a,featType:"reaction"};case"bonus actions":case"bonus":case"bonus action":return n.logger.debug("Companion parsing switching to bonus actions"),{next:a,featType:"bonus"}}return(await this.getFeature(a.outerHTML,t)).forEach((e=>{this.removeSplitCreatureActions&&e.name.toLowerCase().includes("only")&&e.name.toLowerCase().includes(this.options.subType.toLowerCase())?(this.removeCreatureOnlyNames&&(e.name=e.name.split("only")[0].split("(")[0].trim()),this.npc.items.push(e)):this.removeSplitCreatureActions&&e.name.toLowerCase().includes("only")||this.npc.items.push(e),foundry.utils.getProperty(e,"flags.ddbimporter.levelBonus")&&(this.summons.bonuses.attackDamage="@item.level",this.summons.bonuses.saveDamage="@item.level")})),{next:a,featType:t}}async#be(){const e=this.block.querySelector("p.Stat-Block-Styles_Stat-Block-Data-Last");if(!e)return void n.logger.error(`Unable to parse ${this.npc.name} features and actions`,{this:this});let t=e,a="special";for(;null!==t;){const e=await this.#ye(t,a);t=e.next,a=e.featType}}async parse(){const e=this.options.name??this.block.querySelector("p.Stat-Block-Styles_Stat-Block-Title").innerHTML,t=this.options.subType?`(${this.options.subType})`:"";if(!e)return;this.name=e,n.logger.debug(`Beginning companion parse for ${e}`,{name:e,block:this.block});const a=`${e} ${t}`.trim();this.npc=(0,l.I)(a),foundry.utils.setProperty(this.npc,"flags.ddbimporter.companion.modifiers",{}),this.npc.prototypeToken.name=a,foundry.utils.setProperty(this.npc,"flags.ddbimporter.summons.changes",[]),foundry.utils.setProperty(this.npc,"flags.ddbimporter.summons.name",`${e}`),foundry.utils.setProperty(this.npc,"flags.ddbimporter.id",`companion-${a}`),foundry.utils.setProperty(this.npc,"flags.ddbimporter.entityTypeId",`companion-${this.type}`),this.#le(),this.#de(),this.#ee(),this.#te(),this.#ae(),this.#ie(),this.#se(),this.#re(),this.#oe(),this.#ue(),this.#me(),this.#pe(),this.#ge(),this.#ce(),this.#q(),this.#he(),this.#fe(),await this.#be(),foundry.utils.setProperty(this.npc,"prototypeToken.disposition",1);const i=await DDBCompanion2024.addEnrichedImageData(foundry.utils.duplicate(this.npc));this.data=i,this.parsed=!0,n.logger.debug(`Finished companion parse for ${e}`,{name:e,block:this.block,data:this.data,npc:this.npc})}}},186:(e,t,a)=>{a.d(t,{A:()=>DDBCompanionFactory});var i=a(421),n=a(750),s=a(81),r=a(67),o=a(243),l=a(929);const d={"Conjure Animals":{profiles:[{count:"1 * floor((@item.level - 1) / 2)",cr:"2",types:["beast"]},{count:"2 * floor((@item.level - 1) / 2)",cr:"1",types:["beast"]},{count:"4 * floor((@item.level - 1) / 2)",cr:"0.5",types:["beast"]},{count:"8 * floor((@item.level - 1) / 2)",cr:"0.25",types:["beast"]}],creatureTypes:["beast"]},"Conjure Celestial":{profiles:[{count:"1",cr:"4",level:{min:null,max:8},types:["celestial"]},{count:"1",cr:"5",level:{min:9,max:null},types:["celestial"]}],creatureTypes:[]},"Conjure Elemental":{profiles:[{count:"1",cr:"@item.level",types:["elemental"]}],creatureTypes:["elemental"]},"Conjure Fey":{profiles:[{count:"1",cr:"@item.level",types:["fey"]}],creatureTypes:["fey"]},"Conjure Minor Elementals":{profiles:[{count:"1 * min(3, floor((@item.level - 2) / 2))",cr:"2",types:["elemental"]},{count:"2 * min(3, floor((@item.level - 2) / 2))",cr:"1",types:["elemental"]},{count:"4 * min(3, floor((@item.level - 2) / 2))",cr:"0.5",types:["elemental"]},{count:"8 * min(3, floor((@item.level - 2) / 2))",cr:"0.25",types:["elemental"]}],creatureTypes:[]},"Conjure Woodland Beings":{profiles:[{count:"1 * min(3, floor((@item.level - 2) / 2))",cr:"2",types:["fey"]},{count:"2 * min(3, floor((@item.level - 2) / 2))",cr:"1",types:["fey"]},{count:"4 * min(3, floor((@item.level - 2) / 2))",cr:"0.5",types:["fey"]},{count:"8 * min(3, floor((@item.level - 2) / 2))",cr:"0.25",types:["fey"]}],creatureTypes:["fey"]},"Summon Greater Demon":{profiles:[{count:"1",cr:"@item.level + 1",types:["fiend"]}],creatureTypes:[]},"Summon Lesser Demons":{profiles:[{count:"2 * min(3, floor((@item.level - 2) / 2))",cr:"1",types:["fiend"]},{count:"4 * min(3, floor((@item.level - 2) / 2))",cr:"0.5",types:["fiend"]},{count:"8 * min(3, floor((@item.level - 2) / 2))",cr:"0.25",types:["fiend"]}],creatureTypes:[]},"Infernal Calling":{profiles:[{count:"1",cr:"@item.level + 1",types:["fiend"]}],creatureTypes:[]}};class DDBCompanionFactory{constructor(e,t={}){this.options=t,this.html=e,this.doc=(new DOMParser).parseFromString(e.replaceAll("\n",""),"text/html"),this.companions=[],this.actor=this.options.actor,this.folderIds=new Set,this.updateCompanions=!0,this.updateImages=!1,this.results={created:[],updated:[]},this.originDocument=t.originDocument,this.originName=foundry.utils.getProperty(this.originDocument,"flags.ddbimporter.originalName")??this.originDocument?.name??null,this.is2014=t.is2014??!0,this.summons=null,this.badSummons=!1,this.noCompendiums=t.noCompendiums??!1,this.indexFilter={fields:["name","flags.ddbimporter.compendiumId","flags.ddbimporter.id","flags.ddbimporter.summons"]},this.notifier=t.notifier,this.summonsManager=new o.A({notifier:this.notifier}),this.itemHandler=null}async init(){await this.summonsManager.init(),this.itemHandler=this.summonsManager.itemHandler}get data(){return this.options.data??this.companions.map((e=>e.data))}static MULTI={"Aberrant Spirit":["Slaad","Beholderkin","Star Spawn"],"Bestial Spirit":["Air","Land","Water"],"Celestial Spirit":["Avenger","Defender"],"Construct Spirit":["Clay","Metal","Stone"],"Elemental Spirit":["Air","Earth","Fire","Water"],"Fey Spirit":["Fuming","Mirthful","Tricksy"],"Fiendish Spirit":["Demon","Devil","Yugoloth"],"Shadow Spirit":["Fury","Despair","Fear"],"Undead Spirit":["Ghostly","Putrid","Skeletal"],"Drake Companion":["Acid","Cold","Fire","Lightning","Poison"],"Draconic Spirit":["Chromatic","Gem","Metallic"]};async#De(e,t={}){i.logger.debug("Beginning companion parse",{block:e});const a=new s.A(e,foundry.utils.mergeObject(t,{type:this.options.type}));if(await a.parse(),a.parsed){this.companions.push(a);const e=foundry.utils.deepClone(a.summons),t=this.summons?foundry.utils.deepClone(this.summons):null,n=(0,r.n)(t,t);null===this.summons?this.summons=foundry.utils.deepClone(a.summons):n||(i.logger.error("Companion has different summons",{existingSummons:t,companionSummons:e,factory:this,ddbCompanion:a,equal:(0,r.n)(t,t),summonMatch:n}),this.badSummons=!1)}}async parse(){await this.init();const e=this.doc.querySelectorAll("div.stat-block-background, div.stat-block-finder, div.basic-text-frame");for(const t of e){const e=t.querySelector("p.Stat-Block-Styles_Stat-Block-Title").textContent.trim().toLowerCase().split(/\s/).map((e=>i.utils.capitalize(e.trim()))).join(" ");if(e&&e in DDBCompanionFactory.MULTI)for(const a of DDBCompanionFactory.MULTI[e])await this.#De(t,{name:e,subType:a});else await this.#De(t,{name:e,subType:null})}return this.data}async#ve(e="DDB Companions"){const t=await i.FolderHelper.getOrCreateFolder(null,"Actor",e);for(const e of this.companions){const a=await i.FolderHelper.getOrCreateFolder(t,"Actor",i.utils.capitalize(e.type??"other"));e.data.folder=a._id,this.folderIds.add(a._id)}}async getExistingCompendiumCompanions(){await this.itemHandler.buildIndex(this.indexFilter);return await Promise.all(this.itemHandler.compendiumIndex.filter((e=>foundry.utils.hasProperty(e,"flags.ddbimporter.id")&&this.companions.some((t=>foundry.utils.getProperty(t,"data.flags.ddbimporter.id")===e.flags.ddbimporter.id)))).map((async e=>this.itemHandler.compendium.getDocument(e._id))))}async getExistingWorldCompanions({folderOverride:e=null,rootFolderNameOverride:t,limitToFactory:a=!1}={}){if(game.user.isGM&&!this.noCompendiums)return[];e||await this.#ve(t);const n=a?this.data.map((e=>e.name)):[];i.logger.debug("Matched companion names",n);return await game.actors.contents.filter((t=>foundry.utils.hasProperty(t,"folder.id")&&(!e&&this.folderIds.has(t.folder.id)||e?.id===t.folder.id)&&(!a||a&&n.includes(t.name)))).map((e=>e))}static async addToWorld(e,t){const a=[];if(!game.user.can("ITEM_CREATE"))return a;const i=await(0,n.oe)(e,"monster",!1,t,!0);return a.push(i),a}async#Ce(e,t){const a=e.filter((e=>t.some((t=>t.flags?.ddbimporter?.id===e.flags.ddbimporter.id&&e.flags?.ddbimporter?.entityTypeId===e.flags.ddbimporter.entityTypeId)))),n=[];for(const e of a){const a=await t.find((t=>t.flags?.ddbimporter?.id===e.flags.ddbimporter.id&&e.flags?.ddbimporter?.entityTypeId===e.flags.ddbimporter.entityTypeId));e.folder=a.folder?.id,e._id=a._id,i.logger.info(`Updating companion ${e.name}`),i.DDBItemImporter.copySupportedItemFlags(a,e);const s=this.noCompendiums?await DDBCompanionFactory.addToWorld(e,!0):await this.summonsManager.addToCompendium(e);n.push(s)}return n}async#we(e,t,a){if(!game.user.can("ITEM_CREATE"))return ui.notifications.warn("User is unable to create world items, and cannot create companions"),[];const n=e.filter((e=>!t.some((t=>t.flags?.ddbimporter?.id===e.flags.ddbimporter.id&&e.flags?.ddbimporter?.entityTypeId===e.flags.ddbimporter.entityTypeId)))),s=[];for(const e of n){i.logger.info(`Creating Companion ${e.name}`),i.logger.debug("Companion data:",{companion:e,folderId:a}),a&&(e.folder=a);const t=game.user.isGM&&!this.noCompendiums?await this.summonsManager.addToCompendium(e):await DDBCompanionFactory.addToWorld(e,!1);s.push(t)}return s}async updateOrCreateCompanions({folderOverride:e=null,rootFolderNameOverride:t}={}){const a=this.noCompendiums?await this.getExistingWorldCompanions({folderOverride:e,rootFolderNameOverride:t}):await this.getExistingCompendiumCompanions();let s=this.data;game.user.isGM&&(this.updateCompanions&&this.updateImages||this.updateImages||(i.logger.debug("Copying monster images across..."),s=(0,n.dD)(s,a)),this.itemHandler.documents=s,await this.itemHandler.srdFiddling(),await this.itemHandler.iconAdditions(),await(0,n.VL)(this.itemHandler.documents),this.updateCompanions&&(this.results.updated=await this.#Ce(this.itemHandler.documents,a)),this.results.created=await this.#we(this.itemHandler.documents,a,e?.id))}static COMPANION_REMAP={"Artificer Infusions":"Infusion: Homunculus Servant"};#Se(e=null){const t=e??this.originDocument;for(const e of Object.keys(t.system.activities)){const a=t.system.activities[e];if("summon"===a.type)return a}const a=new l.DDBBasicActivity({type:"summon",foundryFeature:t});return a.build(),a.data}async addCompanionsToDocuments(e,t=null){if(!this.originDocument||!this.summons)return;const a=await this.getExistingCompendiumCompanions(),n=a.length>0?a:await this.getExistingWorldCompanions({limitToFactory:!0}),s=n.map((e=>({_id:e._id,name:e.name,uuid:e.uuid,count:null}))),r=DDBCompanionFactory.COMPANION_REMAP[this.originName],o=r?e.find((e=>e.name===r||e.flags.ddbimporter?.originalName===r))??this.originDocument:this.originDocument;i.logger.debug("Companion Data Load",{originDocument:o,profiles:s,worldActors:n,factory:this,summons:this.summons});const l=foundry.utils.deepClone(this.summons);l.profiles=s;const d=t?foundry.utils.mergeObject(t,l):foundry.utils.mergeObject(this.#Se(o),l);delete this.originDocument.system.activities[d._id],o.system.activities[d._id]=d}async addCRSummoning(e){const t=d[this.originName]?{summon:{prompt:!0,mode:"cr"},profiles:d[this.originName].profiles,creatureTypes:d[this.originName].creatureTypes}:"Find Familiar"===this.originName?await async function getFindFamiliarActivityData(){const e=i.CompendiumHelper.getCompendiumType("monster",!1);return await(e?.getIndex()),{creatureTypes:["celestial","fey","fiend"],profiles:[{name:"Bat",uuid:e?.index.find((e=>"Bat"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.qav2dvMIUiMQCCsy"},{name:"Cat",uuid:e?.index.find((e=>"Cat"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.hIf83RD3ZVW4Egfi"},{name:"Crab",uuid:e?.index.find((e=>"Crab"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.8RgUhb31VvjUNZU1"},{name:"Fish",uuid:e?.index.find((e=>"Quipper"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.nkyCGJ9wXeAZkyyz"},{name:"Frog",uuid:e?.index.find((e=>"Frog"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.EZgiprHXA2D7Uyb3"},{name:"Hawk",uuid:e?.index.find((e=>"Hawk"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.fnkPNfIpS62LqOu4"},{name:"Lizard",uuid:e?.index.find((e=>"Lizard"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.I2x01hzOjVN4NUjf"},{name:"Octopus",uuid:e?.index.find((e=>"Octopus"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.3UUNbGiG2Yf1ZPxM"},{name:"Owl",uuid:e?.index.find((e=>"Owl"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.d0prpsGSAorDadec"},{name:"Poisonous Snake",uuid:e?.index.find((e=>"Poisonous Snake"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.D5rwVIxmfFrdyyxT"},{name:"Rat",uuid:e?.index.find((e=>"Rat"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.pozQUPTnLZW8epox"},{name:"Raven",uuid:e?.index.find((e=>"Raven"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.LPdX5YLlwci0NDZx"},{name:"Sea Horse",uuid:e?.index.find((e=>"Sea Horse"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.FWSDiq9SZsdiBAa8"},{name:"Spider",uuid:e?.index.find((e=>"Spider"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.28gU50HtG8Kp7uIz"},{name:"Weasel",uuid:e?.index.find((e=>"Weasel"===e.name))?.uuid??"Compendium.dnd5e.monsters.Actor.WOdeacKCYVhgLDuN"}],creatureSizes:[],match:{attacks:!1,proficiency:!1,saves:!1},summon:{identifier:"",mode:"",prompt:!0},bonuses:{ac:"",hp:"",attackDamage:"",saveDamage:"",healing:""}}}():null;if(!t)return;const a=foundry.utils.mergeObject(e,t);delete this.originDocument.system.activities[e._id],this.originDocument.system.activities[e._id]=a}}},243:(e,t,a)=>{a.d(t,{A:()=>DDBSummonsManager});var i=a(421),n=a(750);const s={type:"npc",system:{abilities:{str:{value:100},dex:{value:100},con:{value:100},int:{value:100},wis:{value:100},cha:{value:100}},attributes:{movement:{burrow:null,climb:null,fly:null,swim:null,walk:null,units:null,hover:!0},ac:{flat:1e3,calc:"flat"},hp:{value:1e3,max:1e3,temp:0,tempmax:0,bonuses:{}}},traits:{size:"tiny"}},items:[],effects:[],folder:null,prototypeToken:{actorLink:!1,appendNumber:!0,prependAdjective:!1,width:.5,height:.5,texture:{anchorX:.5,anchorY:.5,offsetX:0,offsetY:0,fit:"contain",scaleX:1,scaleY:1,rotation:0,tint:"#ffffff",alphaThreshold:.75},hexagonalShape:0,lockRotation:!1,rotation:0,alpha:1,disposition:CONST.TOKEN_DISPOSITIONS.SECRET,displayBars:0,bar1:{attribute:null},bar2:{attribute:null},ring:{enabled:!1},randomImg:!1}},r={name:"Dancing Lights",img:"modules/ddb-importer/img/jb2a/DancingLights_01_Yellow_Thumb.webp",system:{attributes:{movement:{fly:60}}},prototypeToken:{name:"Dancing Lights",width:.5,height:.5,texture:{src:"modules/ddb-importer/img/jb2a/DancingLights_01_Yellow_200x200.webm"},light:{negative:!1,priority:0,alpha:.5,angle:360,bright:0,color:null,coloration:1,dim:10,attenuation:.5,luminosity:.5,saturation:0,contrast:0,shadows:0,animation:{type:"torch",speed:3,intensity:3,reverse:!1},darkness:{min:0,max:1}}}};function getArcaneHands(e,t="Arcane Hand",a=""){const n=game.modules.get("jb2a_patreon")?.active?"jb2a_patreon":"JB2A_DnD5e",s={},r=i.utils.idString(t);return(e=>[{color:"Red",needsJB2A:!1,token:"modules/ddb-importer/img/jb2a/ArcaneHand_Human_01_Idle_Red_400x400.webm",actor:"modules/ddb-importer/img/jb2a/ArcaneHand_Human_01_Idle_Red_Thumb.webp"},{color:"Purple",needsJB2A:!0,token:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Purple_400x400.webm`,actor:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Purple_Thumb.webp`},{color:"Green",needsJB2A:!0,token:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Green_400x400.webm`,actor:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Green_Thumb.webp`},{color:"Blue",needsJB2A:!0,token:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Blue_400x400.webm`,actor:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Blue_Thumb.webp`},{color:"Rock",needsJB2A:!0,needsJB2APatreon:!0,token:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rock01_400x400.webm`,actor:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rock01_Thumb.webp`},{color:"Rainbow",needsJB2A:!0,needsJB2APatreon:!0,token:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rainbow_400x400.webm`,actor:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rainbow_Thumb.webp`}])(n).forEach((i=>{const n=foundry.utils.mergeObject(foundry.utils.deepClone(e),{name:`${t} (${i.color})`,"prototypeToken.texture.src":i.token,img:i.actor});n.items.forEach((e=>{switch(e.name){case"Clenched Fist":e.img="icons/magic/earth/strike-fist-stone.webp";break;case"Forceful Hand":e.img="icons/magic/earth/strike-fist-stone-gray.webp";break;case"Grasping Hand":e.img="icons/magic/earth/strike-fist-stone-light.webp";break;case"Interposing Hand":e.img="icons/magic/earth/barrier-stone-explosion-debris.webp"}})),s[`${r}${i.color}${a}`]={name:`${t} (${i.color})`,version:"3",required:null,isJB2A:!0,needsJB2A:i.needsJB2A??!1,needsJB2APatreon:i.needsJB2APatreon??!1,folderName:t,data:n}})),s}async function get2024ArcaneHands({text:e}){const t=(await DDBSummonsManager.getSRDCompendiumDocument({name:"Arcane Hand"})).toObject();t.system.details.cr=null;const a=getArcaneHands(t,"Bigby's Hand","2024"),n=i.utils.htmlToDocumentFragment(e),s={};return n.querySelectorAll("p").forEach((e=>{const t=i.utils.htmlToDocumentFragment(e.outerHTML).querySelector("strong");if(!t)return;let a=t.textContent.trim().replace(/\./g,"");s[a]={description:e.innerHTML.replace(t.outerHTML,"").trim()}})),Object.keys(a).forEach((e=>{a[e].data.items.forEach((e=>{const t=s[e.name];switch(t&&(e.system.description.value=t.description),e.name){case"Clenched Fist":e.system.damage.base.custom.formula="(2 * @flags.dnd5e.summon.level - 8)d8";break;case"Grasping Hand":e.system.description.value+="\n<h3>Grapple Escape Tests</h3>\n<p>[[/check ability=str skill=ath dc=8+@prof+@flags.dnd5e.summon.mod]]{Strength (Athletics)} [[/check ability=dex skill=acr dc=8+@prof+@flags.dnd5e.summon.mod]]{Dexterity (Acrobatics)}</p>";for(const t of Object.keys(e.system.activities)){const a=e.system.activities[t];"damage"===a.type&&(a.damage.parts[0].custom.formula="(2 * @flags.dnd5e.summon.level - 6)d6 + @flags.dnd5e.summon.mod",e.system.activities[t]=a)}}}))})),a}function getEldritchCannonStub(e){return foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Eldritch Cannon",img:"icons/weapons/guns/gun-blunderbuss-gold.webp",system:{abilities:{str:{value:10},dex:{value:10},con:{value:10},int:{value:10},wis:{value:10},cha:{value:10}},attributes:{movement:{burrow:null,climb:null,fly:null,swim:null,walk:null,units:null,hover:!0},ac:{flat:18,calc:"flat"},hp:{value:1,max:1}},traits:{size:e}},prototypeToken:{name:"Eldritch Cannon",width:.5,height:.5,texture:{src:"icons/weapons/guns/gun-blunderbuss-gold.webp"}}})}async function getSRDActors(){const e={},t=game.packs.get("dnd5e.monsters");if(!t)return e;const a=i.CompendiumHelper.getCompendiumType("monster",!1),n=await DDBSummonsManager.getSRDCompendiumDocument({pack:t,name:"Arcane Hand"});n&&foundry.utils.mergeObject(e,getArcaneHands(n.toObject()));const s=await DDBSummonsManager.getSRDCompendiumDocument({pack:t,name:"Arcane Sword"});n&&foundry.utils.mergeObject(e,function getArcaneSwords(e){const t=game.modules.get("jb2a_patreon")?.active?"jb2a_patreon":"JB2A_DnD5e",a={};return a.ArcaneSwordSpectralGreen={name:"Arcane Sword (Spectral Green)",version:"1",required:null,isJB2A:!0,needsJB2A:!1,folderName:"Arcane Sword",data:foundry.utils.mergeObject(e.toObject(),{name:"Arcane Sword (Spectral Green)","prototypeToken.texture.src":"modules/ddb-importer/img/jb2a/SpiritualWeapon_Shortsword01_02_Spectral_Green_400x400.webm",img:"modules/ddb-importer/img/jb2a/SpiritualWeapon_Shortsword01_02_Spectral_Green_Thumb.webp"})},a.ArcaneSwordAstralBlue={name:"Arcane Sword (Astral Blue)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,needsJB2APatreon:!0,folderName:"Arcane Sword",data:foundry.utils.mergeObject(e.toObject(),{name:"Arcane Sword (Astral Blue)","prototypeToken.texture.src":`modules/${t}/Library/2nd_Level/Spiritual_Weapon/SpiritualWeapon_Shortsword01_01_Astral_Blue_400x400.webm`,img:`modules/${t}/Library/2nd_Level/Spiritual_Weapon/SpiritualWeapon_Shortsword01_01_Astral_Blue_Thumb.webp`})},a}(s));let r=await DDBSummonsManager.getDDBCompendiumDocument({pack:a,name:"Dire Wolf"}),o=2;return r||(r=await DDBSummonsManager.getSRDCompendiumDocument({pack:t,name:"Dire Wolf"}),o=1),r&&foundry.utils.mergeObject(e,function getHoundOfIllOmen(e,t){const a={};return e&&(a.HoundOfIllOmen={name:"Hound of Ill Omen",version:`${t}`,required:null,isJB2A:!1,needsJB2A:!1,needsJB2APatreon:!1,folderName:"Shadow Sorcerer",data:foundry.utils.mergeObject(e.toObject(),{name:"Hound of Ill Omen",prototypeToken:{name:"Hound of Ill Omen",width:1,height:1},"prototypeToken.name":"Hound of Ill Omen","system.traits.size":"med"})}),a}(r,o)),e}async function getSummonActors(){const e=game.modules.get("jb2a_patreon")?.active?"jb2a_patreon":"JB2A_DnD5e",t=await async function getArcaneEyes(){return{ArcaneEye:{name:"Arcane Eye",version:"1",required:null,isJB2A:!0,needsJB2A:!1,folderName:"Arcane Eye",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Arcane Eye","prototypeToken.name":"Arcane Eye","prototypeToken.texture.src":"modules/ddb-importer/img/jb2a/Marker_01_Regular_BlueYellow_400x400.webm",img:"modules/ddb-importer/img/jb2a/Marker_01_Regular_BlueYellow_Thumb.webp",system:{attributes:{movement:{fly:30}}},effects:[(await ActiveEffect.implementation.fromStatusEffect("invisible")).toObject()]})}}}(),a=function getDancingLights(e){const t=foundry.utils.mergeObject(foundry.utils.deepClone(s),foundry.utils.deepClone(r));return{DancingLightsYellow:{name:"Dancing Lights (Yellow)",version:"1",required:null,isJB2A:!0,needsJB2A:!1,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Yellow)","prototypeToken.texture.src":"modules/ddb-importer/img/jb2a/DancingLights_01_Yellow_200x200.webm","prototypeToken.light":{color:"#ffed7a",alpha:.25},img:"modules/ddb-importer/img/jb2a/DancingLights_01_Yellow_Thumb.webp"})},DancingLightsGreen:{name:"Dancing Lights (Green)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Green)","prototypeToken.texture.src":`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_Green_200x200.webm`,"prototypeToken.light":{color:"#a7ff7a",alpha:.25},img:`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_Green_Thumb.webp`})},DancingLightsBlueTeal:{name:"Dancing Lights (Blue Teal)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Blue Teal)","prototypeToken.texture.src":`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_BlueTeal_200x200.webm`,"prototypeToken.light":{color:"#80ffff",alpha:.25},img:`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_BlueTeal_Thumb.webp`})},DancingLightsBlueYellow:{name:"Dancing Lights (Blue Yellow)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Blue Yellow)","prototypeToken.texture.src":`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_BlueYellow_200x200.webm`,"prototypeToken.light":{color:"#c1e6e6",alpha:.25},img:`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_BlueYellow_Thumb.webp`})},DancingLightsPink:{name:"Dancing Lights (Pink)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Pink)","prototypeToken.texture.src":`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_Pink_200x200.webm`,"prototypeToken.light":{color:"#f080ff",alpha:.25},img:`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_Pink_Thumb.webp`})},DancingLightsPurpleGreen:{name:"Dancing Lights (Purple Green)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Purple Green)","prototypeToken.texture.src":`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_PurpleGreen_200x200.webm`,"prototypeToken.light":{color:"#a66bff",alpha:.25},img:`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_PurpleGreen_Thumb.webp`})},DancingLightsRed:{name:"Dancing Lights (Red)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Dancing Lights",data:foundry.utils.mergeObject(foundry.utils.deepClone(t),{name:"Dancing Lights (Red)","prototypeToken.texture.src":`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_Red_200x200.webm`,"prototypeToken.light":{color:"#ff817a",alpha:.25},img:`modules/${e}/Library/Cantrip/Dancing_Lights/DancingLights_01_Red_Thumb.webp`})}}}(e),i=function getMageHands(e){return{MageHandRed:{name:"Mage Hand (Red)",version:"1",required:null,isJB2A:!0,needsJB2A:!1,folderName:"Mage Hand",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Mage Hand (Red)","prototypeToken.name":"Mage Hand","prototypeToken.texture.src":"modules/ddb-importer/img/jb2a/ArcaneHand_Human_01_Idle_Red_400x400.webm",img:"modules/ddb-importer/img/jb2a/ArcaneHand_Human_01_Idle_Red_Thumb.webp",system:{attributes:{movement:{fly:30}}}})},MageHandPurple:{name:"Mage Hand (Purple)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Mage Hand",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Mage Hand (Purple)","prototypeToken.name":"Mage Hand","prototypeToken.texture.src":`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Purple_400x400.webm`,img:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Purple_Thumb.webp`,system:{attributes:{movement:{fly:30}}}})},MageHandGreen:{name:"Mage Hand (Green)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Mage Hand",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Mage Hand (Green)","prototypeToken.name":"Mage Hand","prototypeToken.texture.src":`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Green_400x400.webm`,img:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Green_Thumb.webp`,system:{attributes:{movement:{fly:30}}}})},MageHandBlue:{name:"Mage Hand (Blue)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,folderName:"Mage Hand",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Mage Hand (Blue)","prototypeToken.name":"Mage Hand","prototypeToken.texture.src":`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Blue_400x400.webm`,img:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Blue_Thumb.webp`,system:{attributes:{movement:{fly:30}}}})},MageHandRock:{name:"Mage Hand (Rock)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,needsJB2APatreon:!0,folderName:"Mage Hand",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Mage Hand (Rock)","prototypeToken.name":"Mage Hand","prototypeToken.texture.src":`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rock01_400x400.webm`,img:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rock01_Thumb.webp`,system:{attributes:{movement:{fly:30}}}})},MageHandRainbow:{name:"Mage Hand (Rainbow)",version:"1",required:null,isJB2A:!0,needsJB2A:!0,needsJB2APatreon:!0,folderName:"Mage Hand",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Mage Hand (Rainbow)","prototypeToken.name":"Mage Hand","prototypeToken.texture.src":`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rainbow_400x400.webm`,img:`modules/${e}/Library/5th_Level/Arcane_Hand/ArcaneHand_Human_01_Idle_Rainbow_Thumb.webp`,system:{attributes:{movement:{fly:30}}}})}}}(e),n={...t,...a,...i,...function getBubblingCauldrons(){return{TashasBubblingCauldron:{name:"Tasha's Bubbling Cauldron",version:"1",required:null,isJB2A:!1,needsJB2A:!1,needsJB2APatreon:!1,folderName:"Tasha's Bubbling Cauldron",data:foundry.utils.mergeObject(foundry.utils.deepClone(s),{name:"Bubbling Cauldron",prototypeToken:{name:"Bubbling Cauldron",width:1,height:1,texture:{src:"icons/skills/toxins/cauldron-pot-bubbles-green.webp",scaleX:.5,scaleY:.5}},"prototypeToken.name":"Bubbling Cauldron","system.traits.size":"sm",img:"icons/skills/toxins/cauldron-pot-bubbles-green.webp"})}}}()},o=await getSRDActors();return foundry.utils.mergeObject(o,n)}const o='<p>The assets in this actor are kindly provided by JB2A and are licensed by <a href="https://creativecommons.org/licenses/by-nc-sa/4.0">Attribution-NonCommercial-ShareAlike 4.0 International</a>.</p>\n<p>Check them out at <a href="https://jb2a.com">https://jb2a.com</a> they have a free and patreon supported Foundry module providing wonderful animations and assets for a variety of situations.</p>\n<p>You can learn more about their Foundry modules <a href="https://jb2a.com/home/install-instructions/">here</a>.</p>';class DDBSummonsManager{constructor({ddbData:e,notifier:t=null}={}){this.ddbData=e,this.indexFilter={fields:["name","flags.ddbimporter.compendiumId","flags.ddbimporter.id","flags.ddbimporter.summons"]},this.itemHandler=null,this.notifier=t}async generateDDBDataActors(e){if(e&&this.ddbData&&"Eldritch Cannon"===e.originalName)for(const e of["Small","Tiny"]){return getEldritchCannonStub(e.toLowerCase())}}async init(){this.compendiumFolders=new i.DDBCompendiumFolders("summons"),await this.compendiumFolders.loadCompendium("summons"),this.itemHandler=new i.DDBItemImporter("summons",[],{indexFilter:this.indexFilter,matchFlags:["is2014","is2024"],notifier:this.notifier}),await this.itemHandler.init()}async addToCompendium(e){const t=[];if(!game.user.isGM)return t;const a=foundry.utils.deepClone(e);delete a.folder;const i=this.compendiumFolders.getSummonFolderName(a),s=await this.compendiumFolders.createSummonsFolder(i.name);a.folder=s._id;const r=await(0,n.VJ)(a,"summons");return t.push(r),t}static async getSRDCompendiumDocument({pack:e=null,id:t=null,name:a=null}){const i=e??game.packs.get("dnd5e.monsters");if(!i)return;if(t||(t=DDBSummonsManager.MONSTER_MAP[a]),!t)return;return await i.getDocument(t)}static async getDDBCompendiumDocument({pack:e=null,id:t=null,name:a=null,srdFallback:n=!1}){const s=e??i.CompendiumHelper.getCompendiumType("monster",!1);if(s){if(await s.getIndex(),t){const e=await s.getDocument(t);if(e)return e}if(a){const e=s.index.find((e=>e.name===a));if(e){return await fromUuid(e.uuid)}}return n?DDBSummonsManager.getSRDCompendiumDocument({pack:e,id:t,name:a}):void 0}}static MONSTER_MAP={"Arcane Hand":"iHj5Tkm6HRgXuaWP","Arcane Sword":"Tac7eq0AXJco0nml","Dire Wolf":"EYiQZ3rFL25fEJY5"};static get2024ArcaneHands=get2024ArcaneHands;static async addGeneratedSummons(e,{notifier:t=null}={}){if(!game.user.isGM)return;const a=new DDBSummonsManager({notifier:t});await a.init();for(const[t,n]of Object.entries(e)){if(n.needsJB2A&&!game.modules.get("jb2a_patreon")?.active&&!game.modules.get("JB2A_DnD5e")?.active)continue;if(n.needsJB2APatreon&&!game.modules.get("jb2a_patreon")?.active)continue;const e=a.itemHandler.compendium.index.find((e=>e.flags?.ddbimporter?.summons?.summonsKey===t));if(e&&e.flags.ddbimporter.summons.version>=n.version)continue;const s=foundry.utils.deepClone(n.data);foundry.utils.setProperty(s,"flags.ddbimporter.summons",{summonsKey:t,version:n.version,folder:n.folderName}),s._id=i.utils.namedIDStub(n.name,{prefix:"ddbSum"}),n.isJB2A&&foundry.utils.setProperty(s,"system.details.biography",{value:o,public:o}),i.logger.debug(`Creating ${t}`,s),await a.addToCompendium(s)}}static async generateFixedSummons(){if(!game.user.isGM)return;i.logger.debug("Generating Fixed summons");const e=await getSummonActors();await DDBSummonsManager.addGeneratedSummons(e)}static DEFAULT_SUMMON={match:{proficiency:!1,attacks:!1,saves:!1},bonuses:{ac:"",hp:"",attackDamage:"",saveDamage:"",healing:""},profiles:[],creatureSizes:[],creatureTypes:[],summon:{prompt:!0,mode:""}};addProfilesToActivity(e,t=[],a={}){const i=this.itemHandler.compendium.index.filter((e=>t.includes(e.flags?.ddbimporter?.summons?.summonsKey))).map((e=>({_id:e._id,name:e.name,uuid:e.uuid,count:1}))),n=foundry.utils.mergeObject(foundry.utils.deepClone(DDBSummonsManager.DEFAULT_SUMMON),a);n.profiles=i,e=foundry.utils.mergeObject(e,n)}}},648:(e,t,a)=>{a.r(t),a.d(t,{BackgroundEnrichers:()=>W,ClassEnrichers:()=>T,DDBBackgroundEnricher:()=>DDBBackgroundEnricher,DDBClassFeatureEnricher:()=>DDBClassFeatureEnricher,DDBFeatEnricher:()=>DDBFeatEnricher,DDBGenericEnricher:()=>DDBGenericEnricher,DDBItemEnricher:()=>DDBItemEnricher,DDBMonsterFeatureEnricher:()=>DDDMonsterFeatureEnricher,DDBSpeciesTraitEnricher:()=>DDBSpeciesTraitEnricher,DDBSpellEnricher:()=>DDBSpellEnricher,Effects:()=>z,FeatEnrichers:()=>A,GenericEnrichers:()=>G,ItemEnrichers:()=>d,MonsterEnrichers:()=>l,SpeciesEnrichers:()=>H,SpellEnrichers:()=>c,data:()=>i,mixins:()=>j});var i={};a.r(i),a.d(i,{DDBEnricherData:()=>DDBEnricherData});var n={};a.r(n),a.d(n,{Absorption:()=>Absorption,Invisibility:()=>Invisibility,LegendaryResistance:()=>LegendaryResistance,MaskOfTheWild:()=>MaskOfTheWild,PackTactics:()=>PackTactics,ReversalOfFortune:()=>ReversalOfFortune,SuaveDefense:()=>SuaveDefense});var s={};a.r(s),a.d(s,{Bite:()=>Bite});var r={};a.r(r),a.d(r,{Bite:()=>Bite_Bite});var o={};a.r(o),a.d(o,{FrightfulPresence:()=>FrightfulPresence});var l={};a.r(l),a.d(l,{Dragon:()=>o,FlyingSnake:()=>s,Generic:()=>n,PurpleWorm:()=>r});var d={};a.r(d),a.d(d,{AbsorbingTattoo:()=>AbsorbingTattoo,Acid:()=>Acid,AcidVial:()=>AcidVial,AlchemistsFire:()=>AlchemistsFire,ArcaneOil:()=>ArcaneOil,ArmorOfInvulnerability:()=>ArmorOfInvulnerability,BeadOfForce:()=>BeadOfForce,BelashyrrasBeholderCrown:()=>BelashyrrasBeholderCrown,BloodFuryTattoo:()=>BloodFuryTattoo,BootsOfSpeed:()=>BootsOfSpeed,BracersOfArchery:()=>BracersOfArchery,CircletOfBlasting:()=>CircletOfBlasting,CloakOfDisplacement:()=>CloakOfDisplacement,ConcussionGrenade:()=>ConcussionGrenade,DemonArmor:()=>DemonArmor,DonjonsSunderingSphere:()=>DonjonsSunderingSphere,DustOfSneezingAndChoking:()=>DustOfSneezingAndChoking,FarRealmShard:()=>FarRealmShard,FlameTongue:()=>FlameTongue,GnomengardeGrenade:()=>GnomengardeGrenade,HammerOfThunderbolts:()=>HammerOfThunderbolts,HealersKit:()=>HealersKit,InstrumentOfTheBards:()=>InstrumentOfTheBards,IronBandsOfBinding:()=>IronBandsOfBinding,JavelinOfLightning:()=>JavelinOfLightning,KorolnorScepter:()=>KorolnorScepter,MoonSickle:()=>MoonSickle,NeedlerPistol:()=>NeedlerPistol,OilOfSharpness:()=>OilOfSharpness,ParalysisPistol:()=>ParalysisPistol,PearlOfPower:()=>PearlOfPower,PotionOfHealing:()=>PotionOfHealing,PotionOfHealingGreater:()=>PotionOfHealingGreater,PotionOfHealingSuperior:()=>PotionOfHealingSuperior,PotionOfHealingSupreme:()=>PotionOfHealingSupreme,PotionOfSpeed:()=>PotionOfSpeed,RingOfTheRam:()=>RingOfTheRam,SpellguardShield:()=>SpellguardShield,StaffOfCharming:()=>StaffOfCharming,StaffOfHealing:()=>StaffOfHealing,StinkBomb:()=>StinkBomb,WandOfFireballs:()=>WandOfFireballs,WandOfMagicMissiles:()=>WandOfMagicMissiles,WarriorsPasskey:()=>WarriorsPasskey,Waterskin:()=>Waterskin});var c={};a.r(c),a.d(c,{AbsorbElements:()=>AbsorbElements,AcidArrow:()=>AcidArrow,Aid:()=>Aid,AlterSelf:()=>AlterSelf,AnimalFriendship:()=>AnimalFriendship,AnimateObjects:()=>AnimateObjects,ArcaneEye:()=>ArcaneEye,ArcaneHand:()=>ArcaneHand,ArcaneSword:()=>ArcaneSword,ArcaneVigor:()=>ArcaneVigor,ArmorOfAgathys:()=>ArmorOfAgathys,AuraOfLife:()=>AuraOfLife,Bane:()=>Bane,BanishingSmite:()=>BanishingSmite,Barkskin:()=>Barkskin,BeaconOfHope:()=>BeaconOfHope,BladeWard:()=>BladeWard,Bless:()=>Bless,Blur:()=>Blur,BonesOfTheEarth:()=>BonesOfTheEarth,BoomingBlade:()=>BoomingBlade,CallLightning:()=>CallLightning,Catapult:()=>Catapult,ChaosBolt:()=>ChaosBolt,ChillTouch:()=>ChillTouch,ChromaticOrb:()=>ChromaticOrb,ColorSpray:()=>ColorSpray,Command:()=>Command,ComprehendLanguages:()=>ComprehendLanguages,ControlWeather:()=>ControlWeather,Counterspell:()=>Counterspell,CrownOfMadness:()=>CrownOfMadness,DancingLights:()=>DancingLights,Darkness:()=>Darkness,Darkvision:()=>Darkvision,DivineFavor:()=>DivineFavor,DivineSmite:()=>DivineSmite,DragonsBreath:()=>DragonsBreath,EldritchBlast:()=>EldritchBlast,ElementalWeapon:()=>ElementalWeapon,Entangle:()=>Entangle,FaerieFire:()=>FaerieFire,FalseLife:()=>FalseLife,FeatherFall:()=>FeatherFall,Feeblemind:()=>Feeblemind,FireShield:()=>FireShield,FlamingSphere:()=>FlamingSphere,Fly:()=>Fly,FountOfMoonlight:()=>FountOfMoonlight,Frostbite:()=>Frostbite,GlyphOfWarding:()=>GlyphOfWarding,GreenFlameBlade:()=>GreenFlameBlade,Guidance:()=>Guidance,GuidingBolt:()=>GuidingBolt,GustOfWind:()=>GustOfWind,Haste:()=>Haste,HeatMetal:()=>HeatMetal,HeroesFeast:()=>HeroesFeast,Heroism:()=>Heroism,Hex:()=>Hex,HungerOfHadar:()=>HungerOfHadar,HuntersMark:()=>HuntersMark,Invisibility:()=>Invisibility_Invisibility,JallarzisStormOfRadiance:()=>JallarzisStormOfRadiance,Light:()=>Light,MageArmor:()=>MageArmor,MageHand:()=>MageHand,MagicWeapon:()=>MagicWeapon,MassSuggestion:()=>MassSuggestion,MindBlank:()=>MindBlank,MirrorImage:()=>MirrorImage,PassWithoutTrace:()=>PassWithoutTrace,PowerWordFortify:()=>PowerWordFortify,PrimalSavagery:()=>PrimalSavagery,PrismaticWall:()=>PrismaticWall,ProduceFlame:()=>ProduceFlame,ProtectionFromEnergy:()=>ProtectionFromEnergy,ProtectionFromPoison:()=>ProtectionFromPoison,Pyrotechnics:()=>Pyrotechnics,RayOfEnfeeblement:()=>RayOfEnfeeblement,RayOfSickness:()=>RayOfSickness,ScorchingRay:()=>ScorchingRay,SearingSmite:()=>SearingSmite,ShadowBlade:()=>ShadowBlade,Shield:()=>Shield,ShieldOfFaith:()=>ShieldOfFaith,Shillelagh:()=>Shillelagh,ShiningSmite:()=>ShiningSmite,Sleep:()=>Sleep,Slow:()=>Slow,SorcerousBurst:()=>SorcerousBurst,SpiderClimb:()=>SpiderClimb,SpikeGrowth:()=>SpikeGrowth,SpiritGuardians:()=>SpiritGuardians,SpiritShroud:()=>SpiritShroud,SpiritualWeapon:()=>SpiritualWeapon,Stoneskin:()=>Stoneskin,StormSphere:()=>StormSphere,Suggestion:()=>Suggestion,SynapticStatic:()=>SynapticStatic,TashasBubblingCauldron:()=>TashasBubblingCauldron,TashasCausticBrew:()=>TashasCausticBrew,ThunderStep:()=>ThunderStep,Thunderclap:()=>Thunderclap,TidalWave:()=>TidalWave,TollTheDead:()=>TollTheDead,TrueStrike:()=>TrueStrike,VitriolicSphere:()=>VitriolicSphere,WallOfFire:()=>WallOfFire,WallOfForce:()=>WallOfForce,WallOfIce:()=>WallOfIce,WallOfLight:()=>WallOfLight,WallOfSand:()=>WallOfSand,WallOfStone:()=>WallOfStone,WallOfThorns:()=>WallOfThorns,WallOfWater:()=>WallOfWater,WardingBond:()=>WardingBond,WindWall:()=>WindWall,WitchBolt:()=>WitchBolt});var u={};a.r(u),a.d(u,{ArcanePropulsionArmorGauntlet:()=>ArcanePropulsionArmorGauntlet,EldritchCannonFlamethrower:()=>EldritchCannonFlamethrower,EldritchCannonForceBallista:()=>EldritchCannonForceBallista,EldritchCannonProtector:()=>EldritchCannonProtector,GuardianArmorDefensiveField:()=>GuardianArmorDefensiveField,SteelDefender:()=>SteelDefender});var m={};a.r(m),a.d(m,{AncestralProtectors:()=>AncestralProtectors,AspectOfTheBeastBear:()=>AspectOfTheBeastBear,AspectOfTheWilds:()=>AspectOfTheWilds,BatteringRoots:()=>BatteringRoots,BranchesOfTheTree:()=>BranchesOfTheTree,BrutalCritical:()=>BrutalCritical,BrutalStrike:()=>BrutalStrike,DemiurgicColossus:()=>DemiurgicColossus,ElementalCleaver:()=>ElementalCleaver,FormOfTheBeast:()=>FormOfTheBeast,FormOfTheBeastWeapons:()=>FormOfTheBeastWeapons,Frenzy:()=>Frenzy,GiantsHavoc:()=>GiantsHavoc,GiantsHavocCrushingThrow:()=>GiantsHavocCrushingThrow,GiantsHavocGiantStature:()=>GiantsHavocGiantStature,ImprovedBrutalStrike:()=>ImprovedBrutalStrike,IntimidatingPresence:()=>IntimidatingPresence,MindlessRage:()=>MindlessRage,PersistentRage:()=>PersistentRage,PowerOfTheWilds:()=>PowerOfTheWilds,Rage:()=>Rage,RageOfTheWilds:()=>RageOfTheWilds,RagingStormDesert:()=>RagingStormDesert,RagingStormSea:()=>RagingStormSea,RagingStormTundra:()=>RagingStormTundra,RelentlessRage:()=>RelentlessRage,Retaliation:()=>Retaliation,ShieldingStorm:()=>ShieldingStorm,StormAuraDesert:()=>StormAuraDesert,StormAuraSea:()=>StormAuraSea,StormAuraTundra:()=>StormAuraTundra,StormSoul:()=>StormSoul,StormSoulTundraFreezeWater:()=>StormSoulTundraFreezeWater,TravelAlongTheTree:()=>TravelAlongTheTree,VitalityOfTheTree:()=>VitalityOfTheTree});var p={};a.r(p),a.d(p,{BardicInspiration:()=>BardicInspiration,BeguilingMagic:()=>BeguilingMagic,CombatInspiration:()=>CombatInspiration,CuttingWords:()=>CuttingWords,DazzlingFootwork:()=>DazzlingFootwork,InspiringMovement:()=>InspiringMovement,JackOfAllTrades:()=>JackOfAllTrades,MantleOfInspiration:()=>MantleOfInspiration,RegainBardicInspiration:()=>RegainBardicInspiration,SongOfRest:()=>SongOfRest,SuperiorInspiration:()=>SuperiorInspiration,TandemFootwork:()=>TandemFootwork,UnbreakableMajesty:()=>UnbreakableMajesty});var g={};a.r(g),a.d(g,{BlessedHealer:()=>BlessedHealer,BlessedStrikes:()=>BlessedStrikes,BlessedStrikesDivineStrike:()=>BlessedStrikesDivineStrike,BlessingOfTheTrickster:()=>BlessingOfTheTrickster,ChannelDivinityCloakOfShadows:()=>ChannelDivinityCloakOfShadows,ChannelDivinityPreserveLife:()=>ChannelDivinityPreserveLife,ChannelDivinityRadianceOfTheDawn:()=>ChannelDivinityRadianceOfTheDawn,CoronaOfLight:()=>CoronaOfLight,DiscipleOfLife:()=>DiscipleOfLife,DivineIntervention:()=>DivineIntervention,DivineOrderThaumaturge:()=>DivineOrderThaumaturge,GreaterDivineIntervention:()=>GreaterDivineIntervention,GuidedStrike:()=>GuidedStrike,HarnessDivinePower:()=>HarnessDivinePower,ImprovedBlessedStrikesPotentSpellcasting:()=>ImprovedBlessedStrikesPotentSpellcasting,ImprovedDuplicity:()=>ImprovedDuplicity,ImprovedShadowStep:()=>ImprovedShadowStep,ImprovedWardingFlare:()=>ImprovedWardingFlare,InvokeDuplicity:()=>InvokeDuplicity,SearUndead:()=>SearUndead,StepsOfNight:()=>StepsOfNight,VigilantBlessing:()=>VigilantBlessing,WarGodsBlessing:()=>WarGodsBlessing,WarPriest:()=>WarPriest,WrathOfTheStorm:()=>WrathOfTheStorm});var h={};a.r(h),a.d(h,{Archdruid:()=>Archdruid,BlightedShape:()=>BlightedShape,CircleForms:()=>CircleForms,CosmicOmen:()=>CosmicOmen,DefileGround:()=>DefileGround,DefileGroundMoveCorruption:()=>DefileGroundMoveCorruption,ElementalFuryPotentSpellcasting:()=>ElementalFuryPotentSpellcasting,ElementalFuryPrimalStrike:()=>ElementalFuryPrimalStrike,FullOfStars:()=>FullOfStars,ImprovedCircleForms:()=>ImprovedCircleForms,LandsAid:()=>LandsAid,LunarForm:()=>LunarForm,MoonlightStep:()=>MoonlightStep,NaturalRecovery:()=>NaturalRecovery,NatureMagician:()=>NatureMagician,NaturesWard:()=>NaturesWard,StarryForm:()=>StarryForm,Stormborn:()=>Stormborn,SummonWildfireSpirit:()=>SummonWildfireSpirit,SummonWildfireSpiritCommand:()=>SummonWildfireSpiritCommand,TwinklingConstellations:()=>TwinklingConstellations,WildResurgence:()=>WildResurgence,WildShape:()=>WildShape,WrathOfTheSea:()=>WrathOfTheSea});var f={};a.r(f),a.d(f,{ActionSurge:()=>ActionSurge,CloudRune:()=>CloudRune,CombatSuperiority:()=>CombatSuperiority,EldritchStrike:()=>EldritchStrike,FireRune:()=>FireRune,FrostRune:()=>FrostRune,GiantsMight:()=>GiantsMight,HillRune:()=>HillRune,ImprovedCritical:()=>ImprovedCritical,Indomitable:()=>Indomitable,Maneuver:()=>Maneuver,ManeuverAmbush:()=>ManeuverAmbush,ManeuverBaitAndSwitch:()=>ManeuverBaitAndSwitch,ManeuverBrace:()=>ManeuverBrace,ManeuverCommandersStrike:()=>ManeuverCommandersStrike,ManeuverCommandingPresence:()=>ManeuverCommandingPresence,ManeuverDisarmingAttack:()=>ManeuverDisarmingAttack,ManeuverDistractingStrike:()=>ManeuverDistractingStrike,ManeuverEvasiveFootwork:()=>ManeuverEvasiveFootwork,ManeuverFeintingAttack:()=>ManeuverFeintingAttack,ManeuverGoadingAttack:()=>ManeuverGoadingAttack,ManeuverGrapplingStrike:()=>ManeuverGrapplingStrike,ManeuverLungingAttack:()=>ManeuverLungingAttack,ManeuverManeuveringAttack:()=>ManeuverManeuveringAttack,ManeuverMenacingAttack:()=>ManeuverMenacingAttack,ManeuverParry:()=>ManeuverParry,ManeuverPrecisionAttack:()=>ManeuverPrecisionAttack,ManeuverPushingAttack:()=>ManeuverPushingAttack,ManeuverQuickToss:()=>ManeuverQuickToss,ManeuverRally:()=>ManeuverRally,ManeuverRiposte:()=>ManeuverRiposte,ManeuverSweepingAttack:()=>ManeuverSweepingAttack,ManeuverTacticalAssessment:()=>ManeuverTacticalAssessment,ManeuverTripAttack:()=>ManeuverTripAttack,PsiPoweredLeap:()=>PsiPoweredLeap,PsionicStrike:()=>PsionicStrike,Relentless:()=>Relentless,RemarkableAthlete:()=>RemarkableAthlete,SecondWind:()=>SecondWind,StoneRune:()=>StoneRune,StormRune:()=>StormRune,SuperiorCritical:()=>SuperiorCritical,Survivor:()=>Survivor,TacticalMaster:()=>TacticalMaster,TacticalMind:()=>TacticalMind,TelekineticAdept:()=>TelekineticAdept,TelekineticMaster:()=>TelekineticMaster,TelekineticMovement:()=>TelekineticMovement,TelekineticThrust:()=>TelekineticThrust,WarBond:()=>WarBond});var y={};a.r(y),a.d(y,{ArmsOfTheAstralSelf:()=>ArmsOfTheAstralSelf,ArmsOfTheAstralSelfPhysicalAttack:()=>ArmsOfTheAstralSelfPhysicalAttack,ArmsOfTheAstralSelfSummon:()=>ArmsOfTheAstralSelfSummon,ArmsOfTheAstralSelfWisAttack:()=>ArmsOfTheAstralSelfWisAttack,AwakenedAstralSelf:()=>AwakenedAstralSelf,DeflectAttack:()=>DeflectAttack,DeflectAttackRedirectAttack:()=>DeflectAttackRedirectAttack,DeflectAttacks:()=>DeflectAttacks,DeflectEnergy:()=>DeflectEnergy,DeflectMissiles:()=>DeflectMissiles,DeflectMissilesAttack:()=>DeflectMissilesAttack,DeftStrike:()=>DeftStrike,DiamondSoul:()=>DiamondSoul,DisciplinedSurvivor:()=>DisciplinedSurvivor,ElementalAttunement:()=>ElementalAttunement,ElementalBurst:()=>ElementalBurst,ElementalEpitome:()=>ElementalEpitome,EmpoweredStrikes:()=>EmpoweredStrikes,EmptyBody:()=>EmptyBody,FleetStep:()=>FleetStep,FlurryOfBlowsAdditional:()=>FlurryOfBlowsAdditional,HandOfHarm:()=>HandOfHarm,HandOfHealing:()=>HandOfHealing,HeightenedFocus:()=>HeightenedFocus,Ki:()=>Ki,MonksFocus:()=>MonksFocus,OpenHandTechnique:()=>OpenHandTechnique,PatientDefense:()=>PatientDefense,PerfectFocus:()=>PerfectFocus,PhysiciansTouch:()=>PhysiciansTouch,QuickenedHealing:()=>QuickenedHealing,ShadowArts:()=>ShadowArts,SlowFall:()=>SlowFall,StrideOfTheElements:()=>StrideOfTheElements,StunningStrike:()=>StunningStrike,SuperiorDefense:()=>SuperiorDefense,TongueOfTheSunAndMoon:()=>TongueOfTheSunAndMoon,UncannyMetabolism:()=>UncannyMetabolism,VisageOfTheAstralSelf:()=>VisageOfTheAstralSelf,WholenessOfBody:()=>WholenessOfBody});var b={};a.r(b),a.d(b,{AbjureFoes:()=>AbjureFoes,AuraOfHate:()=>AuraOfHate,AvengingAngel:()=>AvengingAngel,ElderChampion:()=>ElderChampion,EmbodyLegends:()=>EmbodyLegends,GloriousDefense:()=>GloriousDefense,HolyNimbus:()=>HolyNimbus,InspiringSmite:()=>InspiringSmite,LayOnHands:()=>LayOnHands,LayOnHandsPool:()=>LayOnHandsPool,LayOnHandsPurifyPoison:()=>LayOnHandsPurifyPoison,LivingLegend:()=>LivingLegend,PeerlessAthlete:()=>PeerlessAthlete,RadiantStrikes:()=>RadiantStrikes,RelentlessAvenger:()=>RelentlessAvenger,SacredWeapon:()=>SacredWeapon,SmiteOfProtection:()=>SmiteOfProtection,SoulOfVengeance:()=>SoulOfVengeance,UndyingSentinel:()=>UndyingSentinel,VowOfEnmity:()=>VowOfEnmity});var D={};a.r(D),a.d(D,{BeguilingTwist:()=>BeguilingTwist,BestialFury:()=>BestialFury,DefensiveTactics:()=>DefensiveTactics,DrakeCompanion:()=>DrakeCompanion,DreadAmbusher:()=>DreadAmbusher,DreadfulStrike:()=>DreadfulStrike,DreadfulStrikeMassFear:()=>DreadfulStrikeMassFear,DreadfulStrikeSuddenStrike:()=>DreadfulStrikeSuddenStrike,DreadfulStrikes:()=>DreadfulStrikes,FoeSlayer:()=>FoeSlayer,HuntersPrey:()=>HuntersPrey,PlanarWarrior:()=>PlanarWarrior,PrimalCompanion:()=>PrimalCompanion,PrimalCompanionRestoreBeast:()=>PrimalCompanionRestoreBeast,PrimalCompanionSummon:()=>PrimalCompanionSummon,ShadowyDodge:()=>ShadowyDodge,SlayersPrey:()=>SlayersPrey,StalkersFlurry:()=>StalkersFlurry,SuperiorHuntersDefense:()=>SuperiorHuntersDefense,SuperiorHuntersPrey:()=>SuperiorHuntersPrey,TemporaryHitPoints:()=>TemporaryHitPoints,Tireless:()=>Tireless});var v={};a.r(v),a.d(v,{CunningAction:()=>CunningAction,CunningStrike:()=>CunningStrike,DeathStrike:()=>DeathStrike,DeviousStrikes:()=>DeviousStrikes,EnvenomWeapons:()=>EnvenomWeapons,Evasion:()=>Evasion,FastHands:()=>FastHands,GhostWalk:()=>GhostWalk,PsiBolsteredKnack:()=>PsiBolsteredKnack,PsychicBlade:()=>PsychicBlade,PsychicVeil:()=>PsychicVeil,PsychicWhispers:()=>PsychicWhispers,ReliableTalent:()=>ReliableTalent,RendMind:()=>RendMind,SneakAttack:()=>SneakAttack,SneakAttackPoisonEnvenom:()=>SneakAttackPoisonEnvenom,SneakAttackSupremeSneak:()=>SneakAttackSupremeSneak,SoulBlades:()=>SoulBlades,SoulBladesHomingStrikes:()=>SoulBladesHomingStrikes,SoulBladesPsychicTeleportation:()=>SoulBladesPsychicTeleportation,SteadyAim:()=>SteadyAim,SupremeSneak:()=>SupremeSneak,TokensOfTheDeparted:()=>TokensOfTheDeparted,UseMagicDevice:()=>UseMagicDevice,UseMagicDeviceCharges:()=>UseMagicDeviceCharges,UseMagicDeviceScroll:()=>UseMagicDeviceScroll,WailsFromTheGrave:()=>WailsFromTheGrave});var C={};a.r(C),a.d(C,{BastionOfLaw:()=>BastionOfLaw,BendLuck:()=>BendLuck,ClockworkCavalcade:()=>ClockworkCavalcade,DraconicResilience:()=>DraconicResilience,DragonWings:()=>DragonWings,ElementalAffinity:()=>ElementalAffinity,FontOfMagic:()=>FontOfMagic,FontOfMagicSorceryPoints:()=>FontOfMagicSorceryPoints,HoundOfIllOmen:()=>HoundOfIllOmen,InnateSorcery:()=>InnateSorcery,MetamagicOptions:()=>MetamagicOptions,RevelationInFlesh:()=>RevelationInFlesh,SorcerousRestoration:()=>SorcerousRestoration,SorceryIncarnate:()=>SorceryIncarnate,SorceryPoints:()=>SorceryPoints,TranceOfOrder:()=>TranceOfOrder,WarpingImplosion:()=>WarpingImplosion,WildMagicSurge:()=>WildMagicSurge});var w={};a.r(w),a.d(w,{CelestialResilience:()=>CelestialResilience,ClairvoyantCombatant:()=>ClairvoyantCombatant,CreateThrall:()=>CreateThrall,DarkOnesBlessing:()=>DarkOnesBlessing,DarkOnesOwnLuck:()=>DarkOnesOwnLuck,EldritchMaster:()=>EldritchMaster,FiendishResilience:()=>FiendishResilience,GeniesVessel:()=>GeniesVessel,GhostlyGaze:()=>GhostlyGaze,HealingLight:()=>HealingLight,HurlThroughHell:()=>HurlThroughHell,InvocationLifedrinker:()=>InvocationLifedrinker,InvocationPactOfTheBlade:()=>InvocationPactOfTheBlade,MagicalCunning:()=>MagicalCunning,PactBoonPactOfTheTalisman:()=>PactBoonPactOfTheTalisman,RadiantSoul:()=>RadiantSoul,SearingVengeance:()=>SearingVengeance,StepsOfTheFey:()=>StepsOfTheFey});var S={};a.r(S),a.d(S,{ArcaneRecovery:()=>ArcaneRecovery,ArcaneWard:()=>ArcaneWard,Bladesong:()=>Bladesong,EmpoweredEvocation:()=>EmpoweredEvocation,ExpertDivination:()=>ExpertDivination,HypnoticGaze:()=>HypnoticGaze,IllusorySelf:()=>IllusorySelf,MomentaryStasis:()=>MomentaryStasis,Overchannel:()=>Overchannel,SculptSpells:()=>SculptSpells,SongOfVictory:()=>SongOfVictory,TheThirdEye:()=>TheThirdEye});var I={};a.r(I),a.d(I,{ChannelDivinity:()=>ChannelDivinity,PactMagic:()=>PactMagic,PotentCantrip:()=>PotentCantrip,PsionicPower:()=>PsionicPower,PsionicPowerRecovery:()=>PsionicPowerRecovery,UnarmoredDefense:()=>UnarmoredDefense,UnarmoredMovement:()=>UnarmoredMovement});var T={};a.r(T),a.d(T,{Artificer:()=>u,Barbarian:()=>m,Bard:()=>p,Cleric:()=>g,Druid:()=>h,Fighter:()=>f,Generic:()=>Generic,Monk:()=>y,Paladin:()=>b,Ranger:()=>D,Rogue:()=>v,Shared:()=>I,Sorcerer:()=>C,Warlock:()=>w,Wizard:()=>S});var A={};a.r(A),a.d(A,{Alert:()=>Alert,BolsteringPerformance:()=>BolsteringPerformance,BoonOfEnergyResistance:()=>BoonOfEnergyResistance,BoonOfFate:()=>BoonOfFate,BoonOfFortitude:()=>BoonOfFortitude,BoonOfTheNightSpirit:()=>BoonOfTheNightSpirit,Charger:()=>Charger,Chef:()=>Chef,CrossbowExpert:()=>CrossbowExpert,Crusher:()=>Crusher,DefensiveDuelist:()=>DefensiveDuelist,DualWielder:()=>DualWielder,Durable:()=>Durable,ElvenAccuracy:()=>ElvenAccuracy,EnergyRedirection:()=>EnergyRedirection,EpicBoon:()=>EpicBoon,Generic:()=>Generic_Generic,GreatWeaponMaster:()=>GreatWeaponMaster,Healer:()=>Healer,HeavyArmorMaster:()=>HeavyArmorMaster,InspiringLeader:()=>InspiringLeader,MageSlayer:()=>MageSlayer,Observant:()=>Observant,Piercer:()=>Piercer,Poisoner:()=>Poisoner,PolearmMasterBonusAttack:()=>PolearmMasterBonusAttack,ReliableTalent:()=>ReliableTalent_ReliableTalent,SavageAttacker:()=>SavageAttacker,Sharpshooter:()=>Sharpshooter,Slasher:()=>Slasher,SpeedyRecovery:()=>SpeedyRecovery,SquireOfSolamniaPreciseStrike:()=>SquireOfSolamniaPreciseStrike,TavernBrawler:()=>TavernBrawler,Telekinetic:()=>Telekinetic,WarCaster:()=>WarCaster});var k={};a.r(k),a.d(k,{CelestialRevelation:()=>CelestialRevelation,CelestialRevelationHeavenlyWings:()=>CelestialRevelationHeavenlyWings,CelestialRevelationInnerRadiance:()=>CelestialRevelationInnerRadiance,CelestialRevelationNecroticShroud:()=>CelestialRevelationNecroticShroud,CelestialRevelationRadiantConsumption:()=>CelestialRevelationRadiantConsumption,CelestialRevelationRadiantSoul:()=>CelestialRevelationRadiantSoul,HealingHands:()=>HealingHands,RadiantSoul:()=>RadiantSoul_RadiantSoul});var E={};a.r(E),a.d(E,{BreathWeapon2024:()=>BreathWeapon2024,ChromaticInfusion:()=>ChromaticInfusion});var _={};a.r(_);var M={};a.r(M),a.d(M,{SavageAttacks:()=>SavageAttacks});var B={};a.r(B),a.d(B,{Generic:()=>generic_Generic_Generic,HoldBreath:()=>HoldBreath,Lineage:()=>Lineage,PowerfulBuild:()=>PowerfulBuild});var P={};a.r(P),a.d(P,{CloudsJaunt:()=>CloudsJaunt,FiresBurn:()=>FiresBurn,FrostsChill:()=>FrostsChill,HillsTumble:()=>HillsTumble,LargeForm:()=>LargeForm,StonesEndurance:()=>StonesEndurance,StormsThunder:()=>StormsThunder});var O={};a.r(O),a.d(O,{MindLinkResponse:()=>MindLinkResponse});var F={};a.r(F),a.d(F,{PartiallyAmphibious:()=>PartiallyAmphibious,VedalkenDispassion:()=>VedalkenDispassion});var x={};a.r(x),a.d(x,{Shift:()=>Shift,Shifting:()=>Shifting});var L={};a.r(L),a.d(L,{Stonecunning:()=>Stonecunning});var R={};a.r(R),a.d(R,{SurpriseAttack:()=>SurpriseAttack});var N={};a.r(N),a.d(N,{DauntingRoar:()=>DauntingRoar});var $={};a.r($),a.d($,{FuryOfTheSmall:()=>FuryOfTheSmall});var U={};a.r(U),a.d(U,{GlideReaction:()=>GlideReaction,HadozeeDodge:()=>HadozeeDodge});var H={};a.r(H),a.d(H,{Aasimar:()=>k,Bugbear:()=>R,Dragonborn:()=>E,Dwarf:()=>L,Generic:()=>B,Goblin:()=>$,Goliath:()=>P,Hadozee:()=>U,HalfOrc:()=>M,Halfling:()=>_,Kalashtar:()=>O,Leonin:()=>N,Shifter:()=>x,Vedalken:()=>F});var G={};a.r(G),a.d(G,{AuraOf:()=>AuraOf,FightingStyleInterception:()=>FightingStyleInterception,Lucky:()=>Lucky,None:()=>None,RecklessAttack:()=>RecklessAttack,UnarmedStrike:()=>UnarmedStrike,UncannyDodge:()=>UncannyDodge});var W={};a.r(W),a.d(W,{Generic:()=>background_Generic_Generic});var j=a(929),q=a(115),V=a(382),z=a(111);class DDBEnricherData{static META_DATA={};static AutoEffects=z.AutoEffects;static ChangeHelper=z.ChangeHelper;getFeatureActionsName({type:e=null}={}){return this.ddbEnricher.getFeatureActionsName({type:e})}hasClassFeature({featureName:e,className:t=null,subClassName:a=null}={}){return!!this.ddbParser?.ddbData&&V.DDBDataUtils.hasClassFeature({ddbData:this.ddbParser.ddbData,featureName:e,className:t,subClassName:a})}get isAction(){return this.ddbParser.isAction??!1}isClass(e){return this.ddbParser.klass===e}isSubclass(e){return this.ddbParser.subKlass===e||this.ddbParser.subClass===e}hasSubclass(e){return!!this.ddbParser?.ddbData&&V.DDBDataUtils.hasSubClass({ddbData:this.ddbParser.ddbData,subClassName:e})}hasAction({name:e,type:t}={}){return this.ddbParser?.ddbData?.character.actions[t].find((t=>t.name===e))}_getSpentValue(e,t,a=null){return this.ddbParser?.ddbData?.character.actions[e].find((e=>e.name===t&&(null===a||V.DDBDataUtils.findSubClassByFeatureId(this.ddbParser.ddbData,e.componentId)===a)))?.limitedUse?.numberUsed??null}_getUsesWithSpent({type:e,name:t,max:a,period:i="",formula:n=null,override:s=null,matchSubClass:r=null}={}){const o={spent:this._getSpentValue(e,t,r),max:a};return n?o.recovery=[{period:i,type:"formula",formula:n}]:""!=i&&(o.recovery=[{period:i,type:"recoverAll",formula:void 0}]),s&&(o.override=!0),o}_buildDamagePartsWithBase(){const e=this.ddbEnricher.originalActivity;return[foundry.utils.deepClone(this.data.system.damage.base),...foundry.utils.deepClone(e?.damage.parts??[])]}static allDamageTypes(e=[]){return q.x.actions.damageType.filter((e=>null!==e.name)).map((e=>e.name)).filter((t=>!e.includes(t)))}static basicDamagePart({number:e=null,denomination:t=null,type:a=null,types:i=[],bonus:n="",scalingMode:s="whole",scalingNumber:r=1,scalingFormula:o="",customFormula:l=null}={}){return{number:e,denomination:t,bonus:n,types:a?[a]:i,custom:{enabled:null!==l,formula:l},scaling:{mode:s,number:r,formula:o}}}get movementChange(){return z.AutoEffects.effectModules().daeInstalled?z.ChangeHelper.upgradeChange:z.ChangeHelper.customChange}constructor({ddbEnricher:e}){this.ddbEnricher=e,this.ddbParser=e.ddbParser,this.is2014=e.is2014,this.is2024=e.is2024,this.useLookupName=e.useLookupName,this.activityGenerator=e.activityGenerator,this.effectType=e.effectType,this.document=e.document,this.name=e.name,this.isCustomAction=e.isCustomAction,this.manager=e.manager}get featureType(){return foundry.utils.getProperty(this.data,"flags.ddbimporter.type")}get type(){return null}get data(){return this.ddbEnricher.ddbParser.data}get activity(){return null}get effects(){return[]}get override(){return null}get additionalActivities(){return null}get documentStub(){return null}get clearAutoEffects(){return!1}get useDefaultAdditionalActivities(){return!1}get addToDefaultAdditionalActivities(){return!1}get addAutoAdditionalActivities(){return!0}get stopDefaultActivity(){return!1}get itemMacro(){return null}get setMidiOnUseMacroFlag(){return null}customFunction(e={}){}}class Absorption extends DDBEnricherData{get effects(){const e=/is subjected to (\w+) damage, it takes no damage and (?:instead )?regains a number of hit points equal to (half )?the (\w+) damage/i.exec(this.ddbParser.strippedHtml);if(!e)return[];const t=e[2]?"0.5":"1";return[{options:{transfer:!0},name:`Absorption: ${e[1]}`,midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange(t,20,`system.traits.da.${e[1]}`)],img:"icons/svg/downgrade.svg"}]}}class Invisibility extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",rangeSelf:!0}}get effects(){const e=["special"].includes(foundry.utils.getProperty(this.data,"flags.monsterMunch.type")),t=foundry.utils.getProperty(this,"ddbParser.strippedHtml");return[{options:{transfer:e},name:"Invisibility",statuses:["Invisible"],daeStackable:"noneName",daeSpecialDurations:["Superior Invisibility"].includes(this.data.name)||/The ([\w ]+?) is invisible\./gi.test(t)?[]:["1Attack","1Spell","1Action"],midiProperties:{concentration:!0}}]}}class LegendaryResistance extends DDBEnricherData{get effects(){return[{options:{transfer:!0},name:"Legendary Resistance",midiOnly:!0,midiOptionalChanges:[{name:"LegRes",data:{"save.fail.all":"success",count:"@resources.legres.value",label:"Use Legendary Resistance to Succeed?"}}]}]}}class MaskOfTheWild extends DDBEnricherData{get type(){return"check"}get activity(){return{data:{check:{associated:["ste"],ability:"",dc:{calculation:"",formula:""}}}}}}class PackTactics extends DDBEnricherData{get effects(){return[{options:{transfer:!0},name:"Pack Tactics",midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.customChange("findNearby(-1, targetUuid, 5, 0).length > 1",20,"flags.midi-qol.advantage.attack.all")]}]}}class ReversalOfFortune extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"reaction",targetType:"self"}}get effects(){return[{options:{duration:{turns:1}},midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.DR.all")],daeSpecialDurations:["1Reaction"]}]}get override(){return{midiDamageReaction:!0}}}class SuaveDefense extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("@abilities.cha.mod",20,"system.attributes.ac.bonus")]}]}}class Bite extends DDBEnricherData{get type(){return"attack"}get activity(){return{data:{damage:{parts:this._buildDamagePartsWithBase()}}}}get override(){return{data:{"system.damage.base":{number:null,denomination:null,types:[],bonus:""}}}}}class Bite_Bite extends DDBEnricherData{get type(){return"attack"}get activity(){return{name:"Bite",activationType:"action"}}get effects(){return[{name:"Purple Worm: Swallowed",activityMatch:"Bite",statuses:["Blinded","Restrained"]}]}rename({enricher:e}={}){e.data.system.activities.damageDamageIIII.name="Swallowed Damage"}get override(){return{func:this.rename}}}class FrightfulPresence extends DDBEnricherData{get effects(){return[{noCreate:!0,data:{duration:{rounds:10}}}]}}class AbsorbingTattoo extends DDBEnricherData{get type(){return"utility"}get activity(){return{type:"utility",addItemConsume:!0,activationType:"reaction",activationCondition:`When you take ${this.ddbParser.originalName.split(",").pop().trim().toLowerCase()} damage`,targetType:"self",data:{name:"Healing Reaction"}}}}class Acid extends DDBEnricherData{get activity(){return{type:"save",addItemConsume:!0,targetType:"creature",data:{save:{ability:["con"],dc:{calculation:"dex",formula:""}}}}}}class AcidVial extends DDBEnricherData{get activity(){return{type:"attack",addItemConsume:!0,targetType:"creature",data:{attack:{ability:"dex",type:{value:"ranged",classification:"weapon"}}}}}}class AlchemistsFire extends DDBEnricherData{get type(){return this.is2014?"attack":"save"}get activity(){return this.is2014?{addItemConsume:!0,targetType:"creature",data:{attack:{ability:"dex",type:{value:"ranged",classification:"weapon"}}}}:{addItemConsume:!0,targetType:"creature",data:{save:{ability:["dex"],dc:{calculation:"dex",formula:""}}}}}get additionalActivities(){return this.is2014?[{constructor:{name:"Extinguish Flames Check",type:"check"},build:{generateCheck:!0,checkOverride:{associated:[],ability:"dex",dc:{calculation:"",formula:"10"}}}}]:null}get override(){return this.is2014?{options:{transfer:!1,description:"You are on fire, take [[/damage 1d4 fire]] at the start of your turn. You can use an action to distinguish with a [[/check dex 10]]."}}:{data:{"system.uses.autoDestroy":!1}}}get effects(){return this.is2014?[]:[{statuses:["Burning"],options:{transfer:!1,description:"You are &Reference[Burning] take [[/damage 1d4 fire]] at the start of your turn."}}]}}class ArcaneOil extends DDBEnricherData{get type(){return"enchant"}get effects(){return[{type:"enchant",magicalBonus:{makeMagical:!1,bonus:"2"}}]}}class ArmorOfInvulnerability extends DDBEnricherData{get type(){return"utility"}get activity(){return{type:"utility",addItemConsume:!0,targetType:"self",activationType:"action",data:{name:"Become Invulnerable!"}}}get effects(){return[{name:"Invulnerable!",options:{transfer:!1,description:"You are invincible!",durationRounds:100,durationSeconds:600},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.traits.di.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",20,"system.traits.di.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",20,"system.traits.di.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("mgc",20,"system.traits.di.bypasses")]}]}}class BeadOfForce extends DDBEnricherData{get type(){return"save"}get activity(){return{addItemConsume:!0}}get effects(){return[{options:{transfer:!1,description:"Trapped in a sphere of force!",durationRounds:10,durationSeconds:60}}]}}class BelashyrrasBeholderCrown extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.upgradeChange(120,10,"system.attributes.senses.darkvision")]}]}}class BloodFuryTattoo extends DDBEnricherData{get type(){return"damage"}get activity(){return{type:"damage",addItemConsume:!0}}get additionalActivities(){return[{constructor:{name:"Reactive Strike",type:"utility"},build:{generateTarget:!1,generateRange:!1,generateActivation:!0,activationOverride:{type:"reaction",value:1,condition:""}},overrides:{addItemConsume:!0}}]}}class BootsOfSpeed extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"bonus",targetType:"self"}}get effects(){return[{options:{transfer:!1,durationSeconds:600,durationRounds:100},data:{changes:[DDBEnricherData.ChangeHelper.multiplyChange(2,20,"system.attributes.movement.walk")]}}]}}class BracersOfArchery extends DDBEnricherData{get effects(){return[{noCreate:!0,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("2",20,"system.bonuses.rwak.damage")]}]}}class CircletOfBlasting extends DDBEnricherData{customFunction({name:e,activity:t}){return"Scorching Ray"===e&&(t.data=foundry.utils.mergeObject(t.data,{spell:{challenge:{attack:"5",override:!0}}})),t}}class CloakOfDisplacement extends DDBEnricherData{get effects(){return[{name:`${this.data.name} - Check`,macroChanges:[{macroType:"item",macroName:"cloakOfDisplacement.js"}],data:{"flags.dae.macroRepeat":"startEveryTurn"}}]}get itemMacro(){return{type:"item",name:"cloakOfDisplacement.js"}}}class ConcussionGrenade extends DDBEnricherData{get activity(){return{data:{range:{value:"60",unit:"ft"}}}}}class DemonArmor extends DDBEnricherData{get type(){return"enchant"}get effects(){return[{type:"enchant",descriptionHint:!0,magicalBonus:{makeMagical:!0,bonus:"1"},changes:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"system.bonuses.base.number"),DDBEnricherData.ChangeHelper.overrideChange("8",20,"system.damage.base.denomination"),DDBEnricherData.ChangeHelper.overrideChange("false",20,"system.damage.base.custom.enabled")],data:{"restrictions.type":"weapon"}}]}}class DonjonsSunderingSphere extends DDBEnricherData{get type(){return"enchant"}get effects(){return[{type:"enchant",magicalBonus:{bonus:"1"}}]}get additionalActivities(){return[{constructor:{name:"Isolating Smite: Save vs Banishment",type:"save"},build:{generateTarget:!1,generateRange:!1,generateSave:!0,generateUses:!0,usesOverride:{max:"1",spent:0,prompt:!0,recovery:[{period:"lr",type:"recoverAll"}]}},overrides:{addActivityConsume:!0}}]}}class DustOfSneezingAndChoking extends DDBEnricherData{get effects(){return[{name:"Sneezing and Choking",options:{transfer:!1,description:"You are &Reference[incapacitated]{incapacitated} and &Reference[suffocating]{suffocating}."},statuses:["Incapacitated","Suffocating"]}]}}class FarRealmShard extends DDBEnricherData{get type(){return"save"}get activity(){return{activationType:"special",data:{damage:{onSave:"none"}}}}}class FlameTongue extends DDBEnricherData{get activity(){return{additionalDamageIncludeBase:!0}}get effects(){return[{name:"Weapon Aflame"}]}}class GnomengardeGrenade extends DDBEnricherData{get activity(){return{noeffect:!0,data:{name:"Fire Damage",damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:8,denomination:6,type:"fire"})]}}}}get effects(){return[{options:{transfer:!1},statuses:["Stunned"]}]}get additionalActivities(){return[{constructor:{name:"Thunder Damage",type:"save"},build:{generateSave:!0,generateDamage:!0,onSave:"half",damageParts:[DDBEnricherData.basicDamagePart({number:8,denomination:6,type:"thunder"})]}}]}}class HammerOfThunderbolts extends DDBEnricherData{get activity(){return{noConsumeTargets:!0,name:"Attack",noeffect:!0}}get additionalActivities(){return[{constructor:{name:"Giant: Save vs Death",type:"save"},build:{generateSave:!0,generateTarget:!0,targetOverride:{affects:{type:"creature"}},saveOverride:{ability:["con"],dc:{calculation:"",formula:"17"}}}},{constructor:{name:"Ranged Attack (Uses Charge)",type:"attack"},build:{generateTarget:!0,generateRange:!0,generateDamage:!0,generateAttack:!0,generateConsumption:!0,attackOverride:{ability:"str",type:{value:"ranged",classification:"weapon"}},rangeOverride:{override:!0,value:"20",long:"60",units:"ft"},targetOverride:{affects:{count:"1",type:"creature"}}}},{constructor:{name:"Save vs Stunned",type:"save"},build:{generateSave:!0,generateTarget:!0,targetOverride:{affects:{type:"creature"},template:{type:"radius",size:"30",units:"ft"}},saveOverride:{ability:["con"],dc:{calculation:"",formula:"17"}}}}]}get override(){return{data:{"system.range.long":"60"}}}get effects(){return[{noCreate:!0,options:{transfer:!1},activityMatch:"Giant: Save vs Death"},{options:{transfer:!1},statuses:["Stunned"],activityMatch:"Save vs Stunned"}]}}class HealersKit extends DDBEnricherData{get type(){return"utility"}get activity(){return{addItemConsume:!0,activationType:"action",targetType:"creature",data:{"range.units":"touch"}}}get override(){return{data:{"flags.ddbimporter":{retainResourceConsumption:!0,retainUseSpent:!0},"system.uses":{spent:0,max:"10",recovery:[],autoDestroy:!1,autoUse:!0}}}}}class InstrumentOfTheBards extends DDBEnricherData{get activity(){return{noConsumeTargets:!0}}}class IronBandsOfBinding extends DDBEnricherData{get type(){return"attack"}get activity(){return{data:{attack:{bonus:"@prof",ability:"dex",type:{value:"ranged",classification:"weapon"}}}}}get overrides(){return{data:{"system.uses":{spent:0,max:"1",recovery:[{period:"day",type:"recoverAll"}],autoDestroy:!1,autoUse:!0}}}}get additionalActivities(){return[{constructor:{name:"Escape Check",type:"check"},build:{generateTarget:!1,generateRange:!1,generateCheck:!0,checkOverride:{associated:[],ability:"str",dc:{calculation:"",formula:"20"}}},overrides:{addItemConsume:!0}}]}}class JavelinOfLightning extends DDBEnricherData{get activity(){return{noConsumeTargets:!0}}get override(){const e={"flags.ddbimporter.retainUseSpent":!0,data:{system:{uses:{spent:null,max:"",recovery:[],autoDestroy:!1,autoUse:!0}}}};return this.is2014||(e.data.system.damage={base:DDBEnricherData.basicDamagePart({number:1,denomination:6,types:["piercing","lightning"]})}),e}get additionalActivities(){return[{constructor:{name:"Lightning Bolt",type:"save"},build:{onSave:"half",includeBaseDamage:!1,generateSave:!0,generateActivation:!0,generateConsumption:!1,generateDamage:!0,generateTarget:!0,generateRange:!0,generateUses:!0,saveOverride:{ability:["dex"],dc:{calculation:"",formula:"13"}},damageParts:[DDBEnricherData.basicDamagePart({number:4,denomination:6,types:["lightning"]})],usesOverride:{value:"1",max:"1",autoUse:!0,autoDestroy:!0,recovery:[{period:"dawn",type:"recoverAll"}]}},overrides:{addActivityConsume:!0,data:{img:"icons/magic/lightning/bolt-forked-large-blue-yellow.webp",range:{override:!0,value:"",units:"self"},target:{override:!0,affects:{count:"",type:"creature"},template:{contiguous:!1,type:"line",size:"120",units:"ft",width:"5"}}}}}]}get addAutoAdditionalActivities(){return!1}}class KorolnorScepter extends DDBEnricherData{get documentStub(){return{documentType:"weapon",parsingType:"weapon",replaceDefaultActivity:!1,systemType:{value:"simpleM",baseItem:"club"},copySRD:{name:"Club",type:"weapon",uuid:"Compendium.dnd5e.items.Item.nfIRTECQIG81CvM4"}}}get stopDefaultActivity(){return!0}}class MoonSickle extends DDBEnricherData{get effects(){return[{noCreate:!0,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("+1d4",20,"system.bonuses.heal.damage")]}]}}class NeedlerPistol extends DDBEnricherData{get type(){return"save"}get activity(){return{type:"save",addItemConsume:!0,data:{damage:{onSave:"half"}}}}get documentStub(){return{documentType:"consumable",parsingType:"wonderous",systemType:{value:"trinket"}}}get override(){return{"flags.ddbimporter.retainUseSpent":!0,data:{"system.uses":{spent:0,max:"10",recovery:[],autoDestroy:!1,autoUse:!0}}}}}class OilOfSharpness extends DDBEnricherData{get type(){return"enchant"}get activity(){return{allowMagical:!0}}get effects(){return[{type:"enchant",magicalBonus:{bonus:"3"}}]}}class ParalysisPistol extends DDBEnricherData{get type(){return"save"}get activity(){return{type:"save",addItemConsume:!0,targetType:"creature",data:{range:{value:"60",units:"ft"},target:{affects:{count:"1",type:"creature"},template:{contiguous:!1,type:"",size:"",units:"ft"}}}}}get documentStub(){return{documentType:"consumable",parsingType:"wonderous",systemType:{value:"trinket"}}}get override(){return{data:{"flags.ddbimporter.retainUseSpent":!0,"system.uses":{spent:0,max:"6",recovery:[],autoDestroy:!1,autoUse:!0}}}}}class PearlOfPower extends DDBEnricherData{get type(){return"ddbmacro"}get activity(){return{name:"Use Pearl of Power",addItemConsume:!0,data:{macro:{name:"Activate Macro",function:"ddb.item.pearlOfPower",visible:!1,parameters:""}}}}}class PotionOfHealing extends DDBEnricherData{get type(){return"heal"}get activity(){return{addItemConsume:!0,activationType:this.is2014?"action":"bonus",targetType:"creature",data:{range:{units:"touch"}}}}}class PotionOfHealingGreater extends PotionOfHealing{get override(){return{data:{"flags.ddbimporter.dndbeyond.alternativeNames":["Potion of Greater Healing"]}}}}class PotionOfHealingSuperior extends PotionOfHealing{get override(){return{data:{"flags.ddbimporter.dndbeyond.alternativeNames":["Potion of Superior Healing"]}}}}class PotionOfHealingSupreme extends PotionOfHealing{get override(){return{data:{"flags.ddbimporter.dndbeyond.alternativeNames":["Potion of Supreme Healing"]}}}}class PotionOfSpeed extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("2",20,"system.attributes.ac.bonus")],midiChanges:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"flags.midi-qol.advantage.ability.save.dex"),DDBEnricherData.ChangeHelper.customChange("*2",30,"system.attributes.movement.all")]}]}}class RingOfTheRam extends DDBEnricherData{get additionalActivities(){return[{constructor:{name:"Break Object",type:"utility"},build:{generateTarget:!0,generateRange:!0,generateActivation:!0,generateRoll:!0,generateConsumption:!0,roll:{name:"Strength Check",formula:"1d20 + @scaling * 5"}},overrides:{addScalingMode:"amount",addConsumptionScalingMax:"3"}}]}}class SpellguardShield extends DDBEnricherData{get effects(){return[{noCreate:!0,midiChanges:[DDBEnricherData.ChangeHelper.generateCustomChange(1,20,"flags.midi-qol.grants.disadvantage.attack.msak"),DDBEnricherData.ChangeHelper.generateCustomChange(1,20,"flags.midi-qol.grants.disadvantage.attack.rsak")]}]}}class StaffOfCharming extends DDBEnricherData{get additionalActivities(){return[{constructor:{name:"Auto Save vs Charmspell",type:"utility"},build:{generateSave:!1,generateDamage:!1,generateConsumption:!0,consumeActivity:!0,generateUses:!0,usesOverride:{override:!0,max:"1",spent:0,prompt:!0,recovery:[{period:"lr",type:"recoverAll"}]}}},{constructor:{name:"Reflect Spell",type:"utility"},build:{generateSave:!0,saveOverride:{ability:[""],dc:{calculation:"spellcasting",formula:""}}}}]}}class StaffOfHealing extends DDBEnricherData{customFunction({name:e,activity:t}){return"Cure Wounds"===e&&(t.data=foundry.utils.mergeObject(t.data,{consumption:{spellSlot:!1,targets:[{type:"itemUses",value:"1",target:"",scaling:{mode:"amount",formula:""}}],scaling:{allowed:!0,max:"4"}}})),t}}class StinkBomb extends DDBEnricherData{get activity(){return{targetType:"creature"}}}class WandOfFireballs extends DDBEnricherData{get activity(){return{type:"save",addItemConsume:!0,data:{save:{ability:["dex"],dc:{calculation:"",formula:"15"}},damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:8,denomination:6,type:"fire",scalingMode:"whole",scalingNumber:"1"})]},"consumption.scaling":{allowed:!0,max:"@item.uses.max - @item.uses.spent"},range:{value:"150",units:"ft"},target:{affects:{count:"",type:""},template:{contiguous:!1,type:"sphere",size:"20",units:"ft"}}}}}}class WandOfMagicMissiles extends DDBEnricherData{get activity(){return{type:"damage",addItemConsume:!0,targetType:"creature",data:{damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:3,denomination:4,types:["force"],scalingMode:"whole",scalingFormula:"1d4 + 1"})]},"consumption.scaling":{allowed:!0,max:"@item.uses.max - @item.uses.spent"},range:{value:"120",units:"ft"}}}}}class WarriorsPasskey extends DDBEnricherData{get override(){return{data:{"system.damage.base":{number:1,denomination:10,bonus:"",type:"force"}}}}get documentStub(){return{documentType:"weapon",parsingType:"weapon",replaceDefaultActivity:!1,systemType:{value:"martialM",baseItem:"longsword"},copySRD:{name:"Longsword +1",type:"weapon",uuid:"Compendium.dnd5e.items.Item.IPkf0XNowClwXnjQ"}}}get stopDefaultActivity(){return!0}}class Waterskin extends DDBEnricherData{get type(){return"utility"}get activity(){return{type:"utility",activationType:"special",addItemConsume:!0}}get override(){return{data:{"system.uses":{spent:0,max:"4",recovery:[],autoDestroy:!1,autoUse:!0}}}}}class AbsorbElements extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Absorb Elements Effect",data:{"description.chatFlavor":"Uses the damage type of the triggered attack: Acid, Cold, Fire, Lightning, or Poison."}}}get additionalActivities(){return[{constructor:{name:"Elemental Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:6,types:["acid","cold","fire","lightning","thunder"]})],noeffect:!0}}]}get effects(){return["Acid","Cold","Fire","Lightning","Thunder"].map((e=>({name:`Absorb ${e}`,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(e.toLowerCase(),1,"system.traits.dr.value")],activityMatch:"Absorb Elements Effect"})))}}class AcidArrow extends DDBEnricherData{get activity(){return{name:"Cast",data:{"damage.parts":[DDBEnricherData.basicDamagePart({number:4,denomination:4,type:"acid"})]}}}get additionalActivities(){return[{constructor:{name:"End of Targets Turn Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,damageParts:[DDBEnricherData.basicDamagePart({number:2,denomination:4,type:"acid"})],noeffect:!0}}]}get effects(){return[{activityMatch:"Cast",name:"Covered in Acid",options:{durationSeconds:6,durationRounds:1},midiChanges:[DDBEnricherData.ChangeHelper.customChange("label=Acid Arrow (End of Turn),turn=end,damageRoll=(@spellLevel)d4[acid],damageType=acid,killAnim=true",20,"flags.midi-qol.OverTime")],daeSpecialDurations:["turnEnd"]}]}}class Aid extends DDBEnricherData{get effects(){return[2,3,4,5,6,7,8,9].map((e=>({name:`Aid: Level ${e} Temp Max HP Bonus`,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(""+5*(e-1),20,"system.attributes.hp.bonuses.overall")]})))}}class AlterSelf extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{name:"Aquatic Adaptation",img:"icons/creatures/fish/fish-bluefin-yellow-blue.webp"}}}get additionalActivities(){return[{constructor:{name:"Change Appearance",type:"utility"},build:{img:"icons/creatures/magical/spirit-undead-ghost-blue.webp",generateDamage:!1,generateHealing:!1,generateRange:!1,generateConsumption:!0}},{constructor:{name:"Natural Weapons",type:"enchant"},build:{img:"icons/creatures/abilities/fang-tooth-blood-red.webp",generateDamage:!1,generateHealing:!1,generateRange:!1,generateConsumption:!0,data:{restrictions:{type:"weapon",allowMagical:!0}}}}]}get effects(){const e=[],t={name:"Natural Weapons",type:"enchant",changes:[DDBEnricherData.ChangeHelper.overrideChange("{} [Natural Weapons]",20,"name"),DDBEnricherData.ChangeHelper.unsignedAddChange("mgc",20,"system.properties"),DDBEnricherData.ChangeHelper.overrideChange("1",20,"system.damage.base.number"),DDBEnricherData.ChangeHelper.overrideChange("6",20,"system.damage.base.denomination"),DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.damage.base.types"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",20,"system.damage.base.types"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",20,"system.damage.base.types")],activityMatch:"Natural Weapons"};return this.is2014?t.magicalBonus={makeMagical:!1,bonus:"1"}:t.changes.push(DDBEnricherData.ChangeHelper.overrideChange("spellcasting",20,"system.ability")),e.push(t),e.push({name:"Change Appearance",activityMatch:"Change Appearance"},{name:"Aquatic Adaptation",activityMatch:"Aquatic Adaptation",changes:[this.movementChange("@attributes.movement.walk",5,"system.attributes.movement.swim")]}),e}}class AnimalFriendship extends DDBEnricherData{get effects(){return[{statuses:"Charmed"}]}}class AnimateObjects extends DDBEnricherData{get type(){return null}}class ArcaneEye extends DDBEnricherData{get type(){return"summon"}get activity(){return{noTemplate:!0,profileKeys:["ArcaneEye"]}}}var K=a(243);class ArcaneHand extends DDBEnricherData{get type(){return"summon"}get activity(){return{type:"summon",noTemplate:!0,generateSummons:!this.is2014,summonsFunction:K.A.get2024ArcaneHands,profileKeys:this.is2014?["ArcaneHandRed","ArcaneHandPurple","ArcaneHandGreen","ArcaneHandBlue","ArcaneHandRock","ArcaneHandRainbow"]:["BigbysHandRed2024","BigbysHandPurple2024","BigbysHandGreen2024","BigbysHandBlue2024","BigbysHandRock2024","BigbysHandRainbow2024"],summons:{match:{proficiency:!1,attacks:!0,saves:!1},bonuses:{ac:"",hp:"@attributes.hp.max",attackDamage:"",saveDamage:"",healing:""}}}}}class ArcaneSword extends DDBEnricherData{get type(){return"summon"}get activity(){return{noTemplate:!0,profileKeys:["ArcaneSwordSpectralGreen","ArcaneSwordAstralBlue"],summons:{match:{proficiency:!1,attacks:!0,saves:!1}}}}}class ArcaneVigor extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Cast Spell"}}get effects(){return[4,6,8,10,12].map((e=>({constructor:{name:`Spend spells level HD (d${e})`,type:"heal"},build:{generateDamage:!1,generateHealing:!0,generateRange:!0,generateConsumption:!0,healingPart:DDBEnricherData.basicDamagePart({number:2,denomination:e,bonus:"@mod",type:"healing",scalingMode:"whole",scalingNumber:1}),consumptionOverride:{spellSlot:!1,scaling:{allowed:!0,max:"@item.level"},targets:[{type:"hitDice",target:`d${e}`,value:2,scaling:{mode:"amount",formula:"1"}}]}}})))}}class ArmorOfAgathys extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Cast Spell",targetType:"self",targetOverride:!0,data:{healing:DDBEnricherData.basicDamagePart({bonus:"5",types:["temphp"],scalingMode:"whole",scalingFormula:5})}}}get additionalActivities(){return[{constructor:{name:"Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,damageParts:[DDBEnricherData.basicDamagePart({bonus:"5",type:"cold",scalingFormula:"5",scalingMode:"whole"})],noeffect:!0}}]}get effects(){return[{onUseMacroChanges:[{macroPass:"isHit",macroType:"spell",macroName:"armorOfAgathys.js",document:this.data},{macroPass:"isDamaged",macroType:"spell",macroName:"armorOfAgathys.js",document:this.data}],data:{flags:{dae:{selfTargetAlways:!0}}}}]}get itemMacro(){return{type:"spell",name:"armorOfAgathys.js"}}}class AuraOfLife extends DDBEnricherData{get type(){return"utility"}get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("necrotic",20,"system.traits.dr.value")]}]}}class Bane extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("-1d4",0,"system.bonuses.mwak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("-1d4",0,"system.bonuses.rwak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("-1d4",0,"system.bonuses.msak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("-1d4",0,"system.bonuses.rsak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("-1d4",20,"system.bonuses.abilities.save")]}]}}class BanishingSmite extends DDBEnricherData{get type(){return"damage"}}class Barkskin extends DDBEnricherData{get effects(){return this.is2014?[{changes:[DDBEnricherData.ChangeHelper.upgradeChange("16",100,"system.attributes.ac.min")]}]:[{changes:[DDBEnricherData.ChangeHelper.upgradeChange("17",100,"system.attributes.ac.min")]}]}}class BeaconOfHope extends DDBEnricherData{get effects(){return[{midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"flags.midi-qol.advantage.ability.save.wis"),DDBEnricherData.ChangeHelper.overrideChange("1",20,"flags.midi-qol.advantage.deathSave")]}]}}class BladeWard extends DDBEnricherData{get effects(){return this.is2014?[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",10,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",10,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",10,"system.traits.dr.value")],data:{"flags.dae.specialDuration":["turnEnd"]}}]:[]}}class Bless extends DDBEnricherData{get effects(){return[{options:{durationSeconds:60},changes:[DDBEnricherData.ChangeHelper.signedAddChange("+1d4",0,"system.bonuses.mwak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("+1d4",0,"system.bonuses.rwak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("+1d4",0,"system.bonuses.msak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("+1d4",0,"system.bonuses.rsak.attack"),DDBEnricherData.ChangeHelper.signedAddChange("+1d4",20,"system.bonuses.abilities.save")],tokenMagicChanges:[DDBEnricherData.ChangeHelper.tokenMagicFXChange("bloom")]}]}}class Blur extends DDBEnricherData{get effects(){return[{name:"Blur",midiChanges:[DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.grants.disadvantage.attack.all")],tokenMagicChanges:[DDBEnricherData.ChangeHelper.tokenMagicFXChange("blur")]}]}}class BonesOfTheEarth extends DDBEnricherData{get override(){return{data:{"system.target.template":{count:"6",size:"2.5"}}}}}class BoomingBlade extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",overrideTemplate:!0,overrideRange:!0,noTemplate:!0,data:{range:{override:!0,value:5,units:"ft"},damage:{parts:[{types:["thunder"],scaling:{mode:"whole",formula:"1d8"}}]}}}}get additionalActivities(){return[{constructor:{name:"Movement Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:8,type:"thunder"})],noeffect:!0,overrideRange:{value:"5",units:"ft"},overrideTarget:{affects:{type:"creature",count:"1"},template:{}},activationOverride:{type:"",condition:"Creature moves more than 5 ft"}}}]}get effects(){return[{}]}}class CallLightning extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{name:"Place Storm Cloud Template"}}}get additionalActivities(){return[{constructor:{name:"Damage",type:"save"},build:{noSpellslot:!0,generateDamage:!0,generateSave:!0,damageParts:[DDBEnricherData.basicDamagePart({number:3,denomination:10,type:"lightning",scalingMode:"whole",scalingNumber:"1"})],rangeOverride:{value:"",units:"spec",special:"Beneath storm cloud"},targetOverride:{template:{count:"",contiguous:!1,type:"radius",size:"5",width:"",height:"",units:"ft"}},durationOverride:{units:"inst",concentration:!1}}},{constructor:{name:"Damage (Outdoors in a Storm)",type:"save"},build:{generateDamage:!0,generateSave:!0,damageParts:[DDBEnricherData.basicDamagePart({number:4,denomination:10,type:"lightning",scalingMode:"whole",scalingNumber:"1"})],rangeOverride:{value:"",units:"spec",special:"Beneath storm cloud"},targetOverride:{template:{count:"",contiguous:!1,type:"radius",size:"5",width:"",height:"",units:"ft"}},durationOverride:{units:"inst",concentration:!1}}}]}}class Catapult extends DDBEnricherData{get override(){return{data:{"flags.midiProperties.nodam":!0}}}}class ChaosBolt extends DDBEnricherData{get activity(){return{data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"2d8 + 1d6",scalingMode:"whole",scalingFormula:"1d6"})]}}}}}class ChillTouch extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("healing",30,"system.traits.di.value")]}]}}class ChromaticOrb extends DDBEnricherData{get activity(){return{data:{damage:{parts:[DDBEnricherData.basicDamagePart({number:3,denomination:8,types:["acid","cold","fire","lightning","poison","thunder"],scalingMode:"whole",scalingNumber:1})]}}}}}class ColorSpray extends DDBEnricherData{get type(){return this.is2014?"utility":null}get activity(){return this.is2014?{data:{roll:{prompt:!1,visible:!1,formula:"4d10 + (2*@item.level)d10",name:"HP Effected"}}}:null}}class Command extends DDBEnricherData{get activity(){return{lookupName:{"Activate Mantle of Majesty":{data:{name:"Activate Mantle of Majesty"}}}}}get additionalActivities(){return this.useLookupName&&"Activate Mantle of Majesty"===this.ddbParser.lookupName?[{constructor:{name:"Free Cast",type:"save"},build:{noSpellslot:!0,generateConsumption:!0,generateSave:!0}}]:[]}get override(){return{lookupName:{"Activate Mantle of Majesty":{data:{"flags.ddbimporter":{ignoredConsumptionActivities:["Free Cast"]}}}}}}}class ComprehendLanguages extends DDBEnricherData{get effects(){return[{name:"Comprehend Languages",changes:[DDBEnricherData.ChangeHelper.customChange("1",20,"system.traits.languages.all")]}]}}class ControlWeather extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",data:{range:{override:!0,value:5,units:"mi"}}}}}class Counterspell extends DDBEnricherData{get type(){return this.is2014?"check":"save"}get activity(){return this.is2014?{type:"check",check:{associated:[],ability:"spellcasting",dc:{calculation:"",formula:""}}}:null}get override(){return{midiManualReaction:!0}}}class CrownOfMadness extends DDBEnricherData{get effects(){return[{name:"Crown of Madness Automation",midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.customChange("label=Crown of Madness (End of Turn),turn=end,saveDC=@attributes.spelldc,saveAbility=wis,saveMagic=true,killAnim=true",20,"flags.midi-qol.OverTime")]}]}}class DancingLights extends DDBEnricherData{get type(){return"summon"}get activity(){return{noTemplate:!0,profileKeys:["DancingLightsYellow","DancingLightsBlueTeal","DancingLightsGreen","DancingLightsBlueYellow","DancingLightsPink","DancingLightsPurpleGreen","DancingLightsRed"],summons:{}}}}class Darkness extends DDBEnricherData{get type(){return"ddbmacro"}get activity(){return{data:{img:"icons/magic/unholy/orb-glowing-purple.webp",macro:{name:"Toggle Darkness",function:"ddb.spell.darkness",visible:!1,parameters:""}}}}}class Darkvision extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.upgradeChange("60",20,"system.attributes.senses.darkvision")],atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.sight.range",CONST.ACTIVE_EFFECT_MODES.UPGRADE,60,5),DDBEnricherData.ChangeHelper.atlChange("ATL.sight.visionMode",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"darkvision",5)]}]}}class DivineFavor extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self"}}get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("1d4[radiant]",0,"system.bonuses.mwak.damage"),DDBEnricherData.ChangeHelper.unsignedAddChange("1d4[radiant]",0,"system.bonuses.rwak.damage")]}]}}class DivineSmite extends DDBEnricherData{get activity(){return{data:{damage:{parts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,types:["radiant"],scalingMode:"whole",scalingNumber:1})]}}}}get additionalActivities(){return[{duplicate:!0,overrides:{name:"vs Fiends or Undead",data:{damage:{parts:[DDBEnricherData.basicDamagePart({number:3,denomination:6,types:["radiant"],scalingMode:"whole",scalingNumber:1})]}}}}]}}class DragonsBreath extends DDBEnricherData{get activity(){return{data:{damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:3,denomination:6,types:["acid","cold","fire","lightning","poison"],scalingMode:"whole",scalingNumber:1})]}}}}}var Y=a(421);class EldritchBlast extends DDBEnricherData{_getEldritchInvocations(){let e="",t=0;return V.DDBModifiers.filterBaseModifiers(this.ddbParser.ddbData,"eldritch-blast").filter((e=>e.isGranted)).forEach((a=>{switch(a.subType){case"bonus-damage":{const t=q.x.actor.abilities.find((e=>e.id===a.statId));t?(""!==e&&(e+=" + "),e+=`@abilities.${t.value}.mod`):a.fixedValue&&(""!==e&&(e+=" + "),e+=`${a.fixedValue}`);break}case"bonus-range":t=a.value;break;default:Y.logger.warn(`Not yet able to process ${a.subType}, please raise an issue.`)}})),{damage:e,range:t}}eldritchBlastRangeAdjustments(e){const t=this.ddbParser?.ddbData?this._getEldritchInvocations():null;if(t?.range&&Number.parseInt(t.range)){return`${Number.parseInt(e)+Number.parseInt(t.range)}`}return e}eldritchBlastDamageBonus(){const e=this.ddbParser?.ddbData?this._getEldritchInvocations():null;return e?.damage?`${e.damage}`:""}get type(){return"attack"}get activity(){return{data:{damage:{parts:[DDBEnricherData.basicDamagePart({number:1,denomination:10,type:"force",scalingMode:"none",bonus:this.eldritchBlastDamageBonus()})]}}}}get override(){return{data:{"system.range.value":this.eldritchBlastRangeAdjustments(this.ddbParser.ddbDefinition?.range?.rangeValue??0)}}}}class ElementalWeapon extends DDBEnricherData{get type(){return"enchant"}get activity(){return{data:{restrictions:{type:"weapon",allowMagical:!1}}}}get effects(){return[{type:"acid",img:"icons/magic/acid/dissolve-bone-white.webp"},{type:"cold",img:"icons/magic/water/barrier-ice-crystal-wall-jagged-blue.webp"},{type:"fire",img:"icons/magic/fire/barrier-wall-flame-ring-yellow.webp"},{type:"lightning",img:"icons/magic/lightning/bolt-strike-blue.webp"},{type:"thunder",img:"icons/magic/sonic/explosion-shock-wave-teal.webp"}].map((e=>[{bonus:"1",min:null,max:3},{bonus:"2",min:5,max:6},{bonus:"3",min:7,max:null}].map((t=>({type:"enchant",name:`Elemental Weapon: ${Y.utils.capitalize(e.type)} +${t.bonus}`,magicalBonus:{makeMagical:!0,bonus:`+${t.bonus}`,nameAddition:`+${t.bonus}`},options:{description:`This weapon has become a +${t.bonus} magic weapon, granting a bonus to attack and damage rolls. It also gains additional elemental damage.`},data:{img:e.img,"flags.ddbimporter.effectIdLevel":{min:t.min,max:t.max}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(`[["${t.bonus}d4[${e.type}]", "${e.type}"]]`,20,"system.damage.parts")]}))))).flat()}}class Entangle extends DDBEnricherData{get effects(){return[{noCreate:!0,midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.customChange("You can take an action to break free by rolling a Strength Ability Check",20,"flags.midi-qol.OverTime"),DDBEnricherData.ChangeHelper.customChange(`turn=end, rollType=check, actionSave=true, saveAbility=str, saveDC=@attributes.spelldc, label=Restrained by ${this.data.name}`,20,"flags.midi-qol.OverTime")]}]}}class FaerieFire extends DDBEnricherData{get effects(){return[{colour:"Blue",hex:"#5ab9e2"},{colour:"Green",hex:"#55d553"},{colour:"Violet",hex:"#844ec6"}].map((e=>({name:`${e.colour} Light`,midiChanges:[DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.grants.advantage.attack.all")],atlChanges:[DDBEnricherData.ChangeHelper.overrideChange(e.hex,30,"ATL.light.color"),DDBEnricherData.ChangeHelper.overrideChange("0.65",30,"ATL.light.alpha"),DDBEnricherData.ChangeHelper.overrideChange("10",30,"ATL.light.dim"),DDBEnricherData.ChangeHelper.overrideChange('{"type": "pulse","speed": 1,"intensity": 3}',30,"ATL.light.animation")],tokenMagicChanges:[DDBEnricherData.ChangeHelper.tokenMagicFXChange("glow")]})))}}class FalseLife extends DDBEnricherData{get activity(){return{data:{healing:DDBEnricherData.basicDamagePart({customFormula:"1d4 + 4",types:["temphp"],scalingMode:"whole",scalingNumber:5})}}}}class FeatherFall extends DDBEnricherData{get type(){return"utility"}get override(){return{midiManualReaction:!0}}}class Feeblemind extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"system.abilities.cha.value"),DDBEnricherData.ChangeHelper.overrideChange("1",20,"system.abilities.int.value")],midiChanges:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"flags.midi-qol.fail.spell.all")]}]}}class FireShield extends DDBEnricherData{get type(){return"utility"}get effects(){return[{name:"Cold Shield",changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("fire",0,"system.traits.dr.value")]},{name:"Warm Shield",changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("cold",0,"system.traits.dr.value")]}]}}class FlamingSphere extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Cast/Place Template"}}get additionalActivities(){return[{constructor:{name:"Save vs Damage",type:"save"},build:{generateDamage:!0,generateSave:!0,generateActivation:!1,generateConsumption:!1,noSpellslot:!0}}]}get override(){return{data:{"system.target.template":{size:"2.5"}}}}}class Fly extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.upgradeChange("60",20,"system.attributes.movement.fly")]}]}}class FountOfMoonlight extends DDBEnricherData{get type(){return DDBEnricherData.AutoEffects.effectModules().atlInstalled?"utility":"ddbmacro"}get activity(){return DDBEnricherData.AutoEffects.effectModules().atlInstalled?{name:"Cast Spell"}:{name:"Cast Spell",data:{macro:{name:"Place Light on Token",function:"ddb.generic.light",visible:!1,parameters:'{"distance":20,"targetsSelf":true,"targetsToken":true,"lightConfig":{"dim":40,"bright":20},"flag":"light"}'}}}}get additionalActivities(){return[{constructor:{name:"Force Blinding Save",type:"save"},build:{generateDamage:!1,generateSave:!0,noSpellslot:!0,rangeOverride:{value:"60",units:"ft",special:""},targetOverride:{affects:{type:"creature",count:"1"},template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:""}},durationOverride:{units:"inst",concentration:!1}}}]}get clearAutoEffects(){return!0}get effects(){return[{name:"Wreathed in Moonlight",activityMatch:"Cast Spell",options:{durationSeconds:600,durationRounds:60},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("radiant",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("2d6[radiant]",20,"system.bonuses.mwak.damage"),DDBEnricherData.ChangeHelper.unsignedAddChange("2d6[radiant]",20,"system.bonuses.msak.damage")],atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.light.dim",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"40"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.bright",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"20"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.color",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"#ffffff"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.alpha",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"0.25")]},{name:"Blinded by Moonlight",activityMatch:"Force Blinding Save",options:{durationSeconds:6},statuses:["Blinded"]}]}}class Frostbite extends DDBEnricherData{get effects(){return[{noCreate:!0,name:"Frostbitten",midiOnly:!0,options:{durationRounds:2},midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"flags.midi-qol.disadvantage.attack.mwak"),DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"flags.midi-qol.disadvantage.attack.rwak")],daeSpecialDurations:["1Attack:rwak","1Attack:mwak","turnEnd"]}]}}class GlyphOfWarding extends DDBEnricherData{get activity(){return{data:{"damage.parts":[DDBEnricherData.basicDamagePart({number:5,denomination:8,types:["acid","cold","fire","lightning","thunder"],scalingFormula:"1",scalingMode:"whole"})]}}}}class GreenFlameBlade extends DDBEnricherData{get type(){return"damage"}get activity(){return{data:{name:"Secondary Target Damage",damage:{parts:[DDBEnricherData.basicDamagePart({bonus:"@mod",types:["fire"],scalingMode:"whole",scalingFormula:"1d8"})]}}}}get additionalActivities(){return[{constructor:{name:"Main Weapon Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"(ceil((@details.level+1)/6))d8",types:["fire"],scalingMode:"none"})]}}]}get effects(){return[{data:{"system.range":{value:"5",units:"ft"},"system.target.template":{size:"",type:""}}}]}}class Guidance extends DDBEnricherData{get activity(){return{targetType:"creature",data:{roll:{prompt:!1,visible:!0,formula:"1d4",name:"Guidance Roll"}}}}get effects(){return[{name:"Guidance",options:{durationSeconds:60}},{noCreate:!0,name:"Guidance",midiOnly:!0,midiOptionalChanges:[{name:"guidance",data:{label:"Guidance","check.all":"1d4","skill.all":"1d4","iniy.bonus":"1d4"}}],daeSpecialDurations:["isInitiative"]}]}}class GuidingBolt extends DDBEnricherData{get effects(){return[{name:"Glittering",options:{durationSeconds:6,durationRounds:1},daeSpecialDurations:["isAttacked"],midiChanges:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"flags.midi-qol.grants.advantage.attack.all")]}]}}class GustOfWind extends DDBEnricherData{get activity(){return{data:{target:{override:!0,template:{count:"",contiguous:!1,type:"line",size:"60",width:"10",height:"",units:"ft"},affects:{count:"",type:"creature",choice:!1,special:""}}}}}}class Haste extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("2",20,"system.attributes.ac.bonus")],midiChanges:[DDBEnricherData.ChangeHelper.overrideChange("1",20,"flags.midi-qol.advantage.ability.save.dex"),DDBEnricherData.ChangeHelper.customChange("*2",30,"system.attributes.movement.all")]}]}}class HeatMetal extends DDBEnricherData{get additionalActivities(){return[{duplicate:!0,overrides:{name:"Bonus Action Damage",activationType:"bonus",noSpellslot:!0,noConsumeTargets:!0,data:{type:"damage"}}},{constructor:{name:"Save vs Drop",type:"save"},build:{generateDamage:!1,generateSave:!0,noSpellslot:!0,saveOverride:{ability:["con"],dc:{calculation:"spellcasting"}}}}]}get effects(){return[{name:"Heat Metal: It's getting real hot"}]}get addAutoAdditionalActivities(){return!1}}class HeroesFeast extends DDBEnricherData{get activity(){return{data:{duration:{value:1,units:"day",override:!0}}}}get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("frightened",20,"system.traits.ci.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("poisoned",20,"system.traits.ci.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("poison",20,"system.traits.di.value")]}]}}class Heroism extends DDBEnricherData{get type(){return"utility"}get activity(){return{stopHealSpellActivity:!0,name:"Cast"}}get additionalActivities(){return[{constructor:{name:"Start of Turn Temp HP",type:"heal"},build:{generateHealing:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,healingPart:DDBEnricherData.basicDamagePart({customFormula:"@mod",type:"temphp"}),noeffect:!0,activationOverride:{type:"spec",condition:"Start of each creatures turn"},durationOverride:{units:"inst",concentration:!1}}}]}get effects(){return[{options:{description:"Gain temp hp at the start of your turn"},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("frightened",20,"system.traits.ci.value")]}]}}class Hex extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Mark Target"}}get additionalActivities(){return[{constructor:{name:"Hex Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:6,type:"necrotic"})],noeffect:!0,activationOverride:{type:"",condition:"When you hit creature with attack"}}}]}get effects(){return[{name:"Hexed"}]}}class HungerOfHadar extends DDBEnricherData{get type(){return"ddbmacro"}get activity(){return{name:"Cast and Place Darkness",data:{img:"icons/magic/unholy/orb-glowing-purple.webp",macro:{name:"Toggle Darkness",function:"ddb.generic.light",visible:!1,parameters:'{"darkness":true,"distance":20,"isTemplate":true,"lightConfig":{"dim":0,"bright":20},"flag":"darkness"}'}}}}get additionalActivities(){return[{constructor:{name:"Start of Turn Damage",type:"damage"},build:{generateSave:!1,generateDamage:!0,generateActivation:!0,generateConsumption:!1,noSpellslot:!0,generateDuration:!0,durationOverride:{units:"inst",concentration:!1},damageParts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,types:"cold",scalingMode:this.is2014?"":"whole",scalingNumber:this.is2014?"":"1"})]},overrides:{targetType:"creature",activationType:"special",activationCondition:"Start of turn",noTemplate:!0}},{constructor:{name:"End of Turn Save vs Damage",type:"save"},build:{generateSave:!0,generateDamage:!0,generateActivation:!0,generateConsumption:!1,noSpellslot:!0,generateDuration:!0,durationOverride:{units:"inst",concentration:!1},damageParts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,types:"acid",scalingMode:this.is2014?"":"whole",scalingNumber:this.is2014?"":"1"})]},overrides:{targetType:"creature",activationType:"special",activationCondition:"End of turn",noTemplate:!0}}]}}class HuntersMark extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{name:"Cast"}}}get additionalActivities(){const e=this.is2014?DDBEnricherData.allDamageTypes():["force"],t=this.is2024&&this.hasClassFeature({featureName:"Foe Slayer",className:"Ranger"})?10:6;return[{constructor:{name:"Bonus Damage",type:"damage"},build:{generateDamage:!0,generateSave:!1,generateConsumption:!1,noSpellslot:!0,onsave:!1,noeffect:!0,activationOverride:{type:"",condition:"When you hit creature with attack"},damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:t,types:e,scalingFormula:""})]}}]}get effects(){return[{name:"Hunter's Mark"}]}}class Invisibility_Invisibility extends DDBEnricherData{get effects(){return[{noCreate:!0,data:{"flags.dae.specialDuration":["1Attack","1Spell"]}}]}}class JallarzisStormOfRadiance extends DDBEnricherData{get effects(){return[{name:"Within Storm of Radiance",statuses:["Blinded","Deafened"],options:{description:"You are unable to cast spells with the verbal component"}}]}get clearAutoEffects(){return!0}}class Light extends DDBEnricherData{get additionalActivities(){const e={constructor:{name:"Place or Remove Light",type:"ddbmacro"},build:{noeffect:!0,generateConsumption:!1,generateTarget:!0,generateRange:!1,generateActivation:!0,generateDDBMacro:!0,ddbMacroOverride:{name:"Place or Remove Light",function:"ddb.generic.light",visible:!1,parameters:'{"distance":20,"isTemplate":true,"lightConfig":{"dim":40,"bright":20},"flag":"light"}'},targetOverride:{override:!0,affects:{type:""},template:{}}}};return DDBEnricherData.AutoEffects.effectModules().atlInstalled?[e,{constructor:{name:"Apply Light Effect",type:"utility"},build:{generateConsumption:!0,generateTarget:!0,generateRange:!1,generateActivation:!0,targetOverride:{override:!0,affects:{type:""},template:{}}}}]:[e,{constructor:{name:"Place on Targetted Token or Remove",type:"ddbmacro"},build:{generateConsumption:!1,generateTarget:!0,generateRange:!1,generateActivation:!0,generateDDBMacro:!0,ddbMacroOverride:{name:"Place on Targetted Token",function:"ddb.generic.light",visible:!1,parameters:'{"distance":20,"targetsToken":true,"lightConfig":{"dim":40,"bright":20},"flag":"light"}'},targetOverride:{override:!0,affects:{type:""},template:{}}}}]}get override(){return{data:{"flags.midiProperties.autoFailFriendly":!0}}}get effects(){return[{activityMatch:"Apply Light Effect",atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.light.dim",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"40"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.bright",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"20"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.color",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"#ffffff"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.alpha",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"0.25"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.animation",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,'{"type": "pulse", "speed": 3,"intensity": 1}')]}]}}class MageArmor extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.overrideChange("mage",5,"system.attributes.ac.calc")]}]}}class MageHand extends DDBEnricherData{get type(){return"summon"}get activity(){return{noTemplate:!0,profileKeys:["MageHandRed","MageHandPurple","MageHandGreen","MageHandBlue","MageHandRock","MageHandRainbow"],summons:{}}}}class MagicWeapon extends DDBEnricherData{get type(){return"enchant"}get activity(){return{data:{restrictions:{type:"weapon",allowMagical:!1}}}}get effects(){return[{bonus:"1",min:null,max:3},{bonus:"2",min:4,max:5},{bonus:"3",min:6,max:null}].map((e=>({type:"enchant",name:`Magic Weapon +${e.bonus}`,magicalBonus:{makeMagical:!0,bonus:e.bonus,nameAddition:`+${e.bonus}`},options:{description:`This weapon has become a +${e.bonus} magic weapon, granting a bonus to attack and damage rolls.`},data:{"flags.ddbimporter.effectIdLevel":{min:e.min,max:e.max}}})))}}class MassSuggestion extends DDBEnricherData{get effects(){return this.is2014?[]:[{statuses:["Charmed"]}]}}class MindBlank extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("psychic",20,"system.traits.di.value")]}]}}class MirrorImage extends DDBEnricherData{get effects(){return[{tokenMagicChanges:[DDBEnricherData.ChangeHelper.tokenMagicFXChange("images")]}]}}class PassWithoutTrace extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("10",20,"system.skills.ste.bonuses.check")]}]}}class PowerWordFortify extends DDBEnricherData{get override(){return{descriptionSuffix:"\n<details>\n    <summary><strong>Temp HP Helpers</strong></summary>\n    <p>[[/healing 20 type=temphp]]</p>\n    <p>[[/healing 30 type=temphp]]</p>\n    <p>[[/healing 40 type=temphp]]</p>\n    <p>[[/healing 60 type=temphp]]</p>\n    <p>[[/healing 120 type=temphp]]</p>\n</details>"}}}class PrimalSavagery extends DDBEnricherData{get overrides(){return{data:{"system.range":{value:"5",units:"ft"}}}}}class PrismaticWall extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Place Wall",data:{target:{override:!0,template:{type:"wall",size:"90",width:"1/12",height:"30",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Create Globe",type:"utility"},build:{generateDamage:!1,generateConsumption:!0,generateSave:!1,generateTarget:!0,targetOverride:{override:!0,template:{contiguous:!1,type:"radius",size:"15",units:"ft"},affects:{}}}},{constructor:{name:"Blinding Save",type:"save"},build:{generateDamage:!1,generateConsumption:!1,generateSave:!0,generateTarget:!0,noSpellslot:!0,activationOverride:{type:"spec",condition:"Within 20ft"},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}}}},{constructor:{name:"Damage Save",type:"save"},build:{generateDamage:!0,generateConsumption:!1,generateSave:!0,generateTarget:!0,noSpellslot:!0,activationOverride:{type:"spec",condition:"Moving through"},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}},damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:6,types:["fire","acid","lightning","poison","cold"]})]}}]}get override(){return{data:{"system.target":{template:{contiguous:!1,type:"",size:"",width:"",units:""}}}}}get effects(){return[{name:"Blinded",statuses:["Blinded"],options:{durationSeconds:60},activityMatch:"Blinding Save"},{name:"Restrained",statuses:["Restrained"],options:{durationSeconds:6,description:"Save at the end of each turn, 3 failures results in &Reference[Petrified]"},activityMatch:"Damage Save"},{name:"Petrified",statuses:["Petrified"],activityMatch:"Damage Save"},{name:"Blinded",statuses:["Blinded"],options:{durationSeconds:60},activityMatch:"Damage Save"}]}get clearAutoEffects(){return!0}}class ProduceFlame extends DDBEnricherData{get override(){return{data:{"system.range":{value:"30",units:"ft"}}}}}class ProtectionFromEnergy extends DDBEnricherData{get effects(){return["Acid","Cold","Fire","Lightning","Thunder"].map((e=>({name:`Protection from ${e}`,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(e.toLowerCase(),0,"system.traits.dr.value")]})))}}class ProtectionFromPoison extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("poison",20,"system.traits.dr.value")]}]}}class Pyrotechnics extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Fireworks",data:{target:{override:!0,affects:{type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Smoke",type:"utility"},build:{generateDamage:!1,generateConsumption:!1,noeffect:!0,targetOverride:{affects:{type:"creature"},template:{contiguous:!1,type:"radius",size:"20",units:"ft"}}}}]}get effects(){return[{statuses:["Blinded"],activityMatch:"Fireworks"}]}}class RayOfEnfeeblement extends DDBEnricherData{get type(){return"attack"}get effects(){return[{name:"Enfeebled",options:{description:this.ddbParser?.ddbDefinition?.description??""}}]}}class RayOfSickness extends DDBEnricherData{get activity(){return this.is2014?{noeffect:!0}:null}get additionalActivities(){return this.is2014?[{constructor:{name:"Save vs Poisoned",type:"save"},build:{generateDamage:!1,generateConsumption:!1,generateSave:!0,generateTarget:!0,noSpellslot:!0,saveOverride:{ability:["con"],dc:{calculation:"spellcasting"}}}}]:null}get addAutoAdditionalActivities(){return!this.is2014}}class ScorchingRay extends DDBEnricherData{get activity(){return{parent:[{lookupName:"Circlet of Blasting",flatAttack:"5"}]}}}class SearingSmite extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Initial Damage",damageParts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,types:["fire"],scalingMode:"whole",scalingNumber:"1"})]}}get additionalActivities(){return[{constructor:{name:"Save vs Ongoing Damage",type:"save"},build:{generateDamage:!0,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:6,type:"fire"})],noeffect:!0,activationOverride:{type:"",condition:"Start of the creatures turn"}}}]}get effects(){return[{name:"On fire from Searing Smite"}]}}class ShadowBlade extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{name:"Cast",targetType:"self"}}}get effects(){return[{name:"Wielding Shadow Blade"}]}}class Shield extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("5",20,"system.attributes.ac.bonus")],tokenMagicChanges:[DDBEnricherData.ChangeHelper.tokenMagicFXChange("water-field")],data:{"flags.dae.specialDuration":["turnStart"]}}]}}class ShieldOfFaith extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("2",20,"system.attributes.ac.bonus")],tokenMagicChanges:[DDBEnricherData.ChangeHelper.tokenMagicFXChange("bloom")]}]}}class Shillelagh extends DDBEnricherData{get type(){return"enchant"}get activity(){return{data:{restrictions:{type:"weapon",allowMagical:!0}}}}get effects(){return this.is2014?["Physical","Spellcasting"].map((e=>({name:`Shillelagh (${e})`,type:"enchant",changes:[...[DDBEnricherData.ChangeHelper.overrideChange(`{} [${this.data.name.split("(")[0]}]`,20,"name"),DDBEnricherData.ChangeHelper.unsignedAddChange("mgc",20,"system.properties"),DDBEnricherData.ChangeHelper.overrideChange("1",20,"system.damage.base.number"),DDBEnricherData.ChangeHelper.overrideChange("8",20,"system.damage.base.denomination")],..."Physical"!==e?[DDBEnricherData.ChangeHelper.overrideChange("spellcasting",20,"system.ability")]:[]]}))):["Physical","Spellcasting"].map((e=>[{level:1,denomination:8},{level:5,denomination:10},{level:11,denomination:12},{level:17,number:2,denomination:6}].map((t=>{const a=[DDBEnricherData.ChangeHelper.overrideChange(`{} [${this.data.name.split("(")[0]}]`,20,"name"),DDBEnricherData.ChangeHelper.unsignedAddChange("mgc",20,"system.properties"),DDBEnricherData.ChangeHelper.overrideChange(`${t.number??1}`,20,"system.damage.base.number"),DDBEnricherData.ChangeHelper.overrideChange(`${t.denomination}`,20,"system.damage.base.denomination"),DDBEnricherData.ChangeHelper.unsignedAddChange("force",20,"system.damage.base.types")],i="Physical"!==e?[DDBEnricherData.ChangeHelper.overrideChange("spellcasting",20,"system.ability")]:[];return{name:`Shillelagh (${e}) - Level ${t.level}`,type:"enchant",changes:[...a,...i]}})))).flat()}}class ShiningSmite extends DDBEnricherData{get effects(){return[{name:"Shedding Light",atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.light.bright",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"5"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.color",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"#ffffff"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.alpha",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"0.25"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.animation",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,'{"type": "pulse", "speed": 3,"intensity": 1}')]}]}}class Sleep extends DDBEnricherData{get type(){return this.is2014?"utility":null}get activity(){return this.is2014?{data:{roll:{prompt:!1,visible:!1,formula:"3d8 + (2*@item.level)d8",name:"HP Effected"}}}:null}}class Slow extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.signedAddChange("-2",20,"system.attributes.ac.bonus"),DDBEnricherData.ChangeHelper.signedAddChange("-2",20,"system.abilities.dex.bonuses.save"),DDBEnricherData.ChangeHelper.customChange("/2",20,"system.attributes.movement.all")]}]}}class SorcerousBurst extends DDBEnricherData{get type(){return"attack"}get activity(){return{name:"Initial Damage",removeDamageParts:!0,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"1d8x@mod=8",types:["acid","cold","fire","lightning","poison","psychic","thunder"],scalingMode:"whole",scalingNumber:"1"})]}}}class SpiderClimb extends DDBEnricherData{get effects(){return[{changes:[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.climb")]}]}}class SpikeGrowth extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Place Template"}}get additionalActivities(){return[{constructor:{name:"Movement Damage",type:"damage"},build:{generateDamage:!0,generateSave:!1,generateConsumption:!1,noSpellslot:!0,onsave:!1,noeffect:!0,activationOverride:{type:"",condition:"Moves 5ft"},damageParts:[DDBEnricherData.basicDamagePart({number:2,denomination:4,type:"piercing"})]}}]}}class SpiritGuardians extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Place Template"}}get additionalActivities(){return[{constructor:{name:"Save vs Damage",type:"save"},build:{generateDamage:!0,generateSave:!0,onSave:"half",damageParts:[DDBEnricherData.basicDamagePart({number:3,denomination:8,types:["necrotic","radiant"],scalingMode:"whole",scalingNumber:1})],noeffect:!0,activationOverride:{type:"",condition:"Enters or ends turn in emanation (1 turn only)"},durationOverride:{units:"inst",concentration:!1},targetOverride:{template:{},affects:{type:"creature"}},saveOverride:{ability:["wis"],dc:{formula:"",calculation:"spellcasting"}}}}]}}class SpiritShroud extends DDBEnricherData{get type(){return"damage"}get activity(){return{removeDamageParts:!0,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:8,types:["radiant","necrotic","cold"],scalingMode:"half",scalingNumber:"1"})]}}get effects(){return[{name:"Surrounded by a Spirit Shroud"}]}}class SpiritualWeapon extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{name:"Summon",target:{override:!0,template:{size:"2.5",type:"radius"}}}}}get additionalActivities(){return[{constructor:{name:"Attack",type:"attack"},build:{generateDamage:!0,generateConsumption:!1,generateAttack:!0,onsave:!1,noSpellslot:!0,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:8,type:"force",scalingMode:"half",scalingNumber:1})],activationOverride:{type:"bonus",condition:""}}}]}}class Stoneskin extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",0,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",0,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",0,"system.traits.dr.value")]}]}}class StormSphere extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Cast Spell",data:{save:{ability:["str"],dc:{calculation:"spellcasting"}},damage:{parts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,types:["bludgeoning"],scalingMode:"whole",scalingNumber:1})]}}}}get additionalActivities(){return[{constructor:{name:"Shoot Lightning",type:"attack"},build:{generateAttack:!0,generateConsumption:!1,generateActivation:!0,generateRange:!0},overrides:{targetType:"enemy",noTemplate:!0,activationType:"bonus",damageParts:[DDBEnricherData.basicDamagePart({number:4,denomination:6,types:["lightning"],scalingMode:"whole",scalingNumber:1})],data:{range:{value:"60",units:"ft"}}}}]}get effects(){return[{activityMatch:"Cast Spell",name:"Within Storm Sphere"}]}}class Suggestion extends DDBEnricherData{get effects(){return this.is2014?[]:[{statuses:["Charmed"]}]}}class SynapticStatic extends DDBEnricherData{get effects(){return[{name:"Synaptic Static: Muddled Thoughts",options:{durationSeconds:60},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("-1d6",20,"system.bonuses.mwak.attack"),DDBEnricherData.ChangeHelper.unsignedAddChange("-1d6",20,"system.bonuses.msak.attack"),DDBEnricherData.ChangeHelper.unsignedAddChange("-1d6",20,"system.bonuses.rwak.attack"),DDBEnricherData.ChangeHelper.unsignedAddChange("-1d6",20,"system.bonuses.rsak.attack"),DDBEnricherData.ChangeHelper.unsignedAddChange("-1d6",20,"system.bonuses.abilities.check"),DDBEnricherData.ChangeHelper.unsignedAddChange("-1d6",20,"system.attributes.concentration.bonuses.save")]}]}}class TashasBubblingCauldron extends DDBEnricherData{get type(){return"summon"}get activity(){return{name:"Create Cauldron",noTemplate:!0,profileKeys:["TashasBubblingCauldron"],addItemConsume:!0,itemConsumeValue:"-@attributes.spelldc",data:{img:"systems/dnd5e/icons/svg/activity/summon.svg",target:{override:!0,template:{count:"1",contiguous:!1,type:"",size:"",height:"",units:""},affects:{}}}}}get additionalActivities(){return[{constructor:{name:"Withdraw Potion",type:"utility"},build:{img:"systems/dnd5e/icons/svg/ink-pot.svg",generateDamage:!0,generateConsumption:!0,consumeItem:!0,noSpellslot:!0,generateAttack:!1,noeffect:!0,activationOverride:{type:"bonus",condition:""}}}]}get override(){let e="";if(this.ddbParser.itemCompendium?.index){const t=this.ddbParser.itemCompendium.index.filter((e=>["common","uncommon"].includes(e.system.rarity)&&"consumable"==e.type&&"potion"===e.system.type.value&&e.name.toLowerCase().includes("potion")));if(t.length>0){e+="<details>\n<summary><strong>Suggested Potions</strong></summary>";for(const a of t)e+=`<p>@UUID[${a.uuid}]</p>`;e+="</details>"}}return e+='\n<section class="secret" id="secret-ddbTasBubCauldro">\n<p><strong>Implementation Details</strong></p>\n<p>The Uses of this spell represent the number of potions remaining in the cauldron, which is reset by the <strong>Create Cauldron</strong> activity.</p>\n<p>The <strong>Withdraw Potion</strong> activity will consume a use of the cauldron.</p>\n</section>',{descriptionSuffix:e,data:{"system.uses":{max:"@attributes.spellmod",spent:"0"}}}}}class TashasCausticBrew extends DDBEnricherData{get effects(){return[{name:"Covered in Acid",options:{description:"You are covered in acid. Take 2d4 &Reference[acid] damage at start of each of your turns until you use an action to scrape it off."}}]}}class ThunderStep extends DDBEnricherData{get activity(){return{data:{range:{override:!0,value:"",units:"self"},target:{override:!0,affects:{type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}}}}}}class Thunderclap extends DDBEnricherData{get overrides(){return{data:{"system.range":{units:"spec"},"system.target":{template:{size:"15",type:"cube"}}}}}}class TidalWave extends DDBEnricherData{get type(){return"save"}get override(){return{data:{"system.target":{template:{contiguous:!1,type:"line",size:"30",width:"10",units:"ft"}}}}}}class TollTheDead extends DDBEnricherData{get additionalActivities(){return[{constructor:{name:"Save (D12 Damage)",type:"save"},build:{generateDamage:!0,damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:12,type:"necrotic"})],generateSave:!0}}]}}class TrueStrike extends DDBEnricherData{get type(){return this.is2014?null:"enchant"}get activity(){return this.is2014?null:{name:"Enchant Weapon",data:{restrictions:{type:"weapon",allowMagical:!0}}}}get effects(){return this.is2014?[]:[{type:"Melee",img:"icons/skills/melee/strike-sword-slashing-red.webp"},{type:"Ranged",img:"icons/skills/ranged/arrow-strike-glowing-teal.webp"}].map((e=>({type:"enchant",name:`${e.type} Weapon`,options:{description:"This weapon is infused with True Strike"},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("{} (True Strike)",20,"name"),DDBEnricherData.ChangeHelper.unsignedAddChange("radiant",20,"system.damage.base.types"),DDBEnricherData.ChangeHelper.unsignedAddChange("(floor((@details.level + 1) / 6))d6[radiant]",20,"system.damage.base.bonus"),DDBEnricherData.ChangeHelper.overrideChange("spellcasting",20,"system.ability")],data:{img:e.img}})))}}class VitriolicSphere extends DDBEnricherData{get type(){return"save"}get activity(){return{data:{name:"Save",damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:10,denomination:4,type:"acid",scalingMode:"whole",scalingNumber:"2"})]},target:{override:!0,affects:{type:"creature"},template:{contiguous:!1,type:"radius",size:"20",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Secondary Acid Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,noSpellslot:!0,generateAttack:!1,onsave:!1,noeffect:!0,activationOverride:{type:"spec",condition:"End of next turn"},durationOverride:{units:"inst",concentration:!1},damageParts:[DDBEnricherData.basicDamagePart({number:5,denomination:4,type:"acid"})]}}]}}class WallOfFire extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Wall",splitDamage:!0,data:{img:"icons/magic/fire/flame-burning-fence.webp",target:{override:!0,template:{type:"wall",size:"60",width:"1",height:"20",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Place Ring",type:"save"},build:{generateDamage:!0,generateConsumption:!0,generateSave:!0,generateTarget:!0,img:"icons/magic/fire/barrier-wall-flame-ring-yellow.webp",partialDamageParts:[0],targetOverride:{override:!0,template:{count:"1",contiguous:!1,type:"cylinder",size:"10",height:"20",units:"ft"},affects:{}}}},{constructor:{name:"Damage",type:"damage"},build:{img:"icons/magic/fire/flame-burning-skeleton-explosion.webp",generateDamage:!0,generateConsumption:!1,generateTarget:!0,partialDamageParts:[0],noSpellslot:!0,activationOverride:{type:"",condition:""},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}}}}]}get override(){return{noTemplate:!0}}}class WallOfForce extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Place Panels",data:{img:"icons/magic/water/barrier-ice-wall-snow.webp",target:{override:!0,template:{count:"10",contiguous:!0,type:"wall",size:"10",width:"0.02",height:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Create Dome/Globe",type:"utility"},build:{generateDamage:!0,generateConsumption:!0,generateSave:!0,generateTarget:!0,targetOverride:{override:!0,template:{count:"1",contiguous:!1,type:"sphere",size:"10",units:"ft"},affects:{}}}}]}get override(){return{noTemplate:!0}}}class WallOfIce extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Panels",splitDamage:!0,data:{img:"icons/magic/water/barrier-ice-wall-snow.webp",target:{override:!0,template:{count:"10",contiguous:!0,type:"wall",size:"10",width:"1",height:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Create Dome/Globe",type:"save"},build:{generateDamage:!0,generateConsumption:!0,generateSave:!0,generateTarget:!0,img:"icons/magic/water/barrier-ice-shield.webp",partialDamageParts:[0],targetOverride:{override:!0,template:{count:"1",contiguous:!1,type:"sphere",size:"10",units:"ft"},affects:{}}}},{constructor:{name:"Frigid Air Save",type:"save"},build:{generateDamage:!0,generateConsumption:!1,generateSave:!0,img:"icons/magic/water/snowflake-ice-blue-white.webp",generateTarget:!0,partialDamageParts:[1],noSpellslot:!0,activationOverride:{type:"spec",condition:"Moving through/starting in Frigid Air"},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}}}}]}get override(){return{noTemplate:!0}}}class WallOfLight extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Wall",splitDamage:!0,data:{target:{override:!0,template:{type:"wall",size:"60",width:"5",height:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Turn End Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,generateTarget:!0,partialDamageParts:[0],noSpellslot:!0,activationOverride:{type:"spec",condition:"Ends turn in Light"},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}}}},{constructor:{name:"Beam of Radiance Attack",type:"attack"},build:{generateAttack:!0,generateDamage:!0,generateConsumption:!1,generateTarget:!0,partialDamageParts:[0],noSpellslot:!0,rangeOverride:{value:60,units:"ft"},activationOverride:{type:"spec",condition:""},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}}}}]}get override(){return{noTemplate:!0,data:{"system.range":{units:""}}}}get effects(){return[{name:"Blinded",statuses:["Blinded"],options:{durationSeconds:600},activityMatch:"Place Wall"}]}}class WallOfSand extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Wall",data:{target:{override:!0,template:{type:"wall",size:"30",width:"10",height:"10",units:"ft"}}}}}}class WallOfStone extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Square Panels",data:{target:{override:!0,template:{count:"10",contiguous:!0,type:"wall",size:"10",width:"0.5",height:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Place Long Panels",type:"save"},build:{generateDamage:!1,generateConsumption:!0,generateSave:!0,generateTarget:!0,targetOverride:{override:!0,template:{count:"10",contiguous:!0,type:"wall",size:"20",width:"0.25",height:"10",units:"ft"},affects:{}}}}]}get override(){return{noTemplate:!0}}}class WallOfThorns extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Wall",splitDamage:!0,data:{img:"icons/magic/nature/root-vine-entwined-thorns.webp",target:{override:!0,template:{type:"wall",size:"60",width:"5",height:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Create Circle",type:"save"},build:{generateDamage:!0,generateConsumption:!0,generateSave:!0,generateTarget:!0,img:"icons/magic/nature/trap-spikes-thorns-green.webp",partialDamageParts:[0],targetOverride:{override:!0,template:{count:"1",contiguous:!1,type:"cylinder",size:"20",height:"20",width:"5",units:"ft"},affects:{}}}},{constructor:{name:"Save to Travel Through Wall",type:"save"},build:{generateDamage:!0,generateConsumption:!1,generateSave:!0,img:"icons/magic/nature/root-vine-entangled-humanoid.webp",generateTarget:!0,partialDamageParts:[1],noSpellslot:!0,activationOverride:{type:"spec",condition:"Moving through/starting in Frigid Air"},durationOverride:{units:"inst",concentration:!1},targetOverride:{override:!0,affects:{type:"creature"},template:{}}}}]}get override(){return{noTemplate:!0}}}class WallOfWater extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Place Wall",data:{target:{override:!0,template:{type:"wall",size:"30",width:"1",height:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Create Ring",type:"utility"},build:{generateDamage:!1,generateConsumption:!0,generateTarget:!0,targetOverride:{override:!0,template:{count:"1",contiguous:!1,type:"sphere",size:"10",units:"ft"},affects:{}}}}]}get override(){return{noTemplate:!0}}}class WardingBond extends DDBEnricherData{get effects(){return[{changes:[...DDBEnricherData.allDamageTypes().map((e=>DDBEnricherData.ChangeHelper.unsignedAddChange(e,0,"system.traits.dr.value"))),DDBEnricherData.ChangeHelper.signedAddChange("1",20,"system.attributes.ac.bonus"),DDBEnricherData.ChangeHelper.signedAddChange("1",20,"system.bonuses.abilities.save")]}]}}class WindWall extends DDBEnricherData{get type(){return"save"}get activity(){return{splitDamage:!0,data:{target:{override:!0,template:{count:"5",contiguous:!0,type:"wall",size:"10",width:"1",height:"15",units:"ft"}}}}}}class WitchBolt extends DDBEnricherData{get activity(){return{splitDamage:!0}}get additionalActivities(){return[{constructor:{name:"Ongoing Damage",type:"damage"},build:{generateDamage:!0,generateConsumption:!1,generateTarget:!0,generateActivation:!0,activationOverride:{value:"1",type:this.is2014?"action":"bonus"},targetOverride:{override:!0,template:{count:"1",contiguous:!1,type:"",size:this.is2014?"30":"60",units:"ft"},affects:{}},damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:12,type:"lightning",scalingMode:"none",scalingNumber:null})]}}]}get effects(){return[{}]}}class ArcanePropulsionArmorGauntlet extends DDBEnricherData{get type(){return null}get activity(){return null}get effects(){return[]}get additionalActivities(){return[]}get override(){return{data:{"system.properties":Y.utils.addToProperties(this.data.system.properties,"mgc")}}}}class EldritchCannonFlamethrower extends DDBEnricherData{get type(){return"save"}get activity(){return{targetType:"creature",data:{description:{chatFlavor:"Ignites flammable objects."},damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:2,denomination:8,type:"fire"})]}}}}get override(){return{data:{"system.uses":{value:null,max:""}}}}}class EldritchCannonForceBallista extends DDBEnricherData{get type(){return"attack"}get activity(){return{targetType:"creature",data:{description:{chatFlavor:"On hit pushed 5 ft away."},range:{value:120,units:"ft"},target:{},attack:{ability:"int",type:{value:"ranged",classification:"spell"}},damage:{parts:[DDBEnricherData.basicDamagePart({number:2,denomination:8,type:"force"})]}}}}get override(){return{data:{"system.uses":{value:null,max:""}}}}}class EldritchCannonProtector extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"creature",data:{healing:DDBEnricherData.basicDamagePart({number:1,denomination:8,bonus:"@abilities.int.mod",types:["temphp"]}),target:{affects:{type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}}}}}get override(){return{data:{"system.uses":{value:null,max:""}}}}}class GuardianArmorDefensiveField extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"self",data:{healing:DDBEnricherData.basicDamagePart({bonus:"@classes.artificer.levels",types:["temphp"]})}}}get effects(){return[]}}class SteelDefender extends DDBEnricherData{get activity(){return{noConsumeTargets:!0,noTemplate:!0}}get override(){return{data:{"system.uses":{spent:null,max:"",recovery:[]}}}}}class AncestralProtectors extends DDBEnricherData{get effects(){return[{options:{transfer:!0},macroChanges:[{macroValues:`${this.data.name}`,macroType:"feat",macroName:"ancestralProtectors.js"}]}]}get itemMacro(){return{type:"feat",name:"ancestralProtectors.js"}}}class AspectOfTheBeastBear extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.overrideChange("@attributes.encumbrance.max * 2",20,"system.attributes.encumbrance.max")],daeChanges:[DDBEnricherData.ChangeHelper.overrideChange("dae.eval(100 * attributes.encumbrance.value / attributes.encumbrance.max)",20,"system.attributes.encumbrance.pct")],midiChanges:[DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.advantage.ability.save.str")]}]}}class AspectOfTheWilds extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",name:"Owl",activationType:"special"}}get additionalActivities(){return[{constructor:{name:"Panther",type:"utility"},build:{generateTarget:!0,generateActivation:!0,activationOverride:{type:"special"},targetOverride:{affects:{type:"self"}}}},{constructor:{name:"Salmon",type:"utility"},build:{generateTarget:!0,generateActivation:!0,activationOverride:{type:"special"},targetOverride:{affects:{type:"self"}}}}]}get effects(){return[{name:"Owl",options:{},activityMatch:"Owl",changes:[DDBEnricherData.ChangeHelper.upgradeChange("60",20,"system.attributes.senses.darkvision")],atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.sight.range",CONST.ACTIVE_EFFECT_MODES.ADD,60,5),DDBEnricherData.ChangeHelper.atlChange("ATL.sight.visionMode",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"darkvision",5)]},{name:"Panther",options:{},activityMatch:"Panther",changes:[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.climb")]},{name:"Salmon",options:{},activityMatch:"Salmon",changes:[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.swim")]}]}}class BatteringRoots extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("push",20,"system.traits.weaponProf.mastery.bonus"),DDBEnricherData.ChangeHelper.unsignedAddChange("topple",20,"system.traits.weaponProf.mastery.bonus")]}]}}class BranchesOfTheTree extends DDBEnricherData{get type(){return"save"}get activity(){return{activationType:"reaction",data:{save:{ability:["str"],dc:{calculation:"str",formula:""}},target:{affects:{type:"creature",value:"1"}},range:{value:"30",units:"ft"}}}}}class BrutalCritical extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.signedAddChange("+1",20,"flags.dnd5e.meleeCriticalDamageDice")]}]}}class BrutalStrike extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Forceful Blow",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.barbarian.brutal-strike"})]}}}}get additionalActivities(){return[{constructor:{name:"Hamstrung Blow",type:"damage"},build:{generateActivation:!0,generateDamage:!0,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.barbarian.brutal-strike"})]}}]}get effects(){return[{name:"Hamstrung",changes:[DDBEnricherData.ChangeHelper.overrideChange("-15",90,"system.attributes.movement.walk")],data:{"flags.ddbimporter.activityMatch":"Hamstrung Blow"}}]}}class DemiurgicColossus extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",activationType:"special"}}get effects(){return[{name:"Demiurgic Colossus",changes:[DDBEnricherData.ChangeHelper.overrideChange("hg",20,"system.traits.size")],atlChanges:[DDBEnricherData.ChangeHelper.upgradeChange(3,5,"ATL.width"),DDBEnricherData.ChangeHelper.upgradeChange(3,5,"ATL.height")]}]}}class ElementalCleaver extends DDBEnricherData{get type(){return"enchant"}get activity(){return{data:{restrictions:{type:"weapon",allowMagical:!1}}}}get effects(){return[{type:"acid",img:"icons/magic/acid/dissolve-bone-white.webp"},{type:"cold",img:"icons/magic/water/barrier-ice-crystal-wall-jagged-blue.webp"},{type:"fire",img:"icons/magic/fire/barrier-wall-flame-ring-yellow.webp"},{type:"lightning",img:"icons/magic/lightning/bolt-strike-blue.webp"},{type:"thunder",img:"icons/magic/sonic/explosion-shock-wave-teal.webp"}].map((e=>[{bonus:"1",min:null,max:13},{bonus:"2",min:14,max:null}].map((t=>({type:"enchant",name:`Elemental Cleaver: ${Y.utils.capitalize(e.type)} +${t.bonus}d6`,options:{description:"This weapon is infused with elemental energy."},data:{img:e.img,"flags.ddbimporter.effectIdLevel":{min:t.min,max:t.max}},changes:[DDBEnricherData.ChangeHelper.overrideChange("{} [Elemental Cleaver]",20,"name"),DDBEnricherData.ChangeHelper.unsignedAddChange("thr",20,"system.properties"),DDBEnricherData.ChangeHelper.upgradeChange("20",20,"system.range.value"),DDBEnricherData.ChangeHelper.upgradeChange("60",20,"system.range.long"),DDBEnricherData.ChangeHelper.overrideChange("ft",20,"system.range.units"),DDBEnricherData.ChangeHelper.unsignedAddChange(`[["${t.bonus}d4[${e.type}]", "${e.type}"]]`,20,"system.damage.parts")]}))))).flat()}}class FormOfTheBeast extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Tail (reaction)"}}get effects(){return[{name:"Form of the Beast: Tail AC Bonus",options:{durationTurns:1},daeSpecialDurations:["isAttacked"],changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("+1d8",1,"system.attributes.ac.bonus")],data:{flags:{dae:{selfTarget:!0,selfTargetAlways:!0}}}}]}get override(){return{descriptionSuffix:'\n<section class="secret" id="secret-ddbFormOfTheBeast">\n<p><strong>Implementation Details</strong></p>\n<p>Bite, Claw and Tail attacks are added as character weapons.</p>\n</section>'}}}class FormOfTheBeastWeapons extends DDBEnricherData{get type(){return"Form of the Beast: Tail (reaction)"===this.ddbParser.originalName?"utility":null}get activity(){switch(this.ddbParser.originalName){case"Form of the Beast: Tail":return{name:"Tail Attack",noTemplate:!0,data:{range:{value:10,units:"ft"}}};case"Form of the Beast: Claw":return{name:"Claw Attack"};case"Form of the Beast: Bite":return{name:"Bite Attack"};case"Form of the Beast: Tail (reaction)":return{name:"Tail (reaction)"}}return null}get additionalActivities(){return"Form of the Beast: Bite"===this.ddbParser.originalName?[{constructor:{name:"Bite (Healing Bonus - 1/your turn)",type:"heal"},build:{generateConsumption:!1,generateTarget:!0,targetSelf:!0,generateRange:!1,generateActivation:!0,generateDamage:!1,generateHealing:!0,activationOverride:{type:"special",value:1,condition:""},healingPart:DDBEnricherData.basicDamagePart({customFormula:"@prof",type:"healing"})}}]:[]}get effects(){return this.ddbParser.originalName.startsWith("Form of the Beast: Tail")?[{name:"Form of the Beast: Tail AC Bonus",activityMatch:"Tail (reaction)",options:{durationTurns:1},daeSpecialDurations:["isAttacked"],changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("+1d8",1,"system.attributes.ac.bonus")],data:{flags:{dae:{selfTarget:!0,selfTargetAlways:!0}}}}]:[]}get override(){return{data:{"system.properties":this.hasClassFeature({featureName:"Bestial Soul"})?Y.utils.addToProperties(this.data.system.properties,"mgc"):this.data.system.properties}}}get useDefaultAdditionalActivities(){return!0}get addToDefaultAdditionalActivities(){return!0}}class Frenzy extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",activationType:"special",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"(@scale.barbarian.rage-damage)d6"})]}}}}}class GiantsHavoc extends DDBEnricherData{get additionalActivities(){return[{action:{name:"Giant's Havoc: Crushing Throw",type:"class",rename:["Crushing Throw"]},overrides:{noeffect:!0}},{action:{name:"Giant's Havoc: Giant Stature",type:"class",rename:["Giant Stature"]}}]}}class GiantsHavocCrushingThrow extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Damage",targetType:"creature",activationType:"special",damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.barbarian.rage-damage",types:DDBEnricherData.allDamageTypes()})]}}}class GiantsHavocGiantStature extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",activationType:"special"}}get effects(){return[{name:"Giant Stature",changes:[DDBEnricherData.ChangeHelper.overrideChange("lg",20,"system.traits.size")],atlChanges:[DDBEnricherData.ChangeHelper.upgradeChange(2,5,"ATL.width"),DDBEnricherData.ChangeHelper.upgradeChange(2,5,"ATL.height")]}]}}class ImprovedBrutalStrike extends DDBEnricherData{get type(){return"damage"}get activity(){return{type:"damage",targetType:"creature",name:"Staggering Blow",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.barbarian.brutal-strike"})]}}}}get additionalActivities(){return[{constructor:{name:"Staggering Blow",type:"damage"},build:{generateActivation:!0,generateDamage:!0,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.barbarian.brutal-strike"})]}}]}get effects(){return[{name:"Staggered",changes:[],activityMatch:"Staggering Blow"},{name:"Sundered",changes:[],activityMatch:"Sundering Blow"}]}}class IntimidatingPresence extends DDBEnricherData{get activity(){return{name:"Save",targetType:"creature",data:{save:{ability:["wis"],dc:{calculation:"str",formula:""}},target:{affects:{type:"enemy",choice:!0},template:{count:"",contiguous:!1,type:"radius",size:"30",width:"",height:"",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Restore With Rage Use",type:"utility"},build:{noeffect:!0,generateConsumption:!0,generateTarget:!1,generateRange:!1,generateActivation:!0,generateUtility:!0,activationOverride:{type:"special",value:null,condition:""},consumptionOverride:{targets:[{type:"itemUses",target:"",value:-1,scaling:{mode:"",formula:""}}],scaling:{allowed:!1,max:""}}}}]}get override(){return{data:{flags:{ddbimporter:{ignoredConsumptionActivities:["Save"],retainOriginalConsumption:!0,retainChildUses:!0},"midi-qol":{effectActivation:!0,effectCondition:"!target.effects.some((e)=> e.name?.toLowerCase().includes('blind') || e.name?.toLowerCase().includes('deaf'))"}}}}}get effects(){return[{activityMatch:"Save",noCreate:!0,midiOnly:!0,name:"Intimidating Presence: Frightened",data:{duration:{seconds:12,turns:2}},daeSpecialDurations:["turnEndSource"]}]}}class MindlessRage extends DDBEnricherData{get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("frighened",20,"system.traits.ci.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("charmed",20,"system.traits.ci.value")]}]}}class PersistentRage extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",activationType:"special",data:{"range.units":"self"}}}get override(){return{data:{"system.uses":this._getUsesWithSpent({type:"class",name:"Rage: Regain Expended Uses",max:"1",period:"lr"}),"flags.ddbimporter":{retainOriginalConsumption:!0,consumptionValue:"-@scale.barbarian.rages",retainChildUses:!0}}}}}class PowerOfTheWilds extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",name:"Falcon",activationType:"special"}}get additionalActivities(){return[{constructor:{name:"Lion",type:"utility"},build:{generateTarget:!0,generateActivation:!0,activationOverride:{type:"special"},targetOverride:{affects:{type:"creature"}}}},{constructor:{name:"Ram",type:"utility"},build:{generateTarget:!0,generateActivation:!0,activationOverride:{type:"special"},targetOverride:{affects:{type:"creature"}}}}]}get effects(){return[{name:"Falcoln",options:{},data:{"flags.ddbimporter.activityMatch":"Falcoln"},changes:[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.fly")]},{name:"Lion",options:{},data:{"flags.ddbimporter.activityMatch":"Lion"}},{name:"Ram",options:{},data:{"flags.ddbimporter.activityMatch":"Ram"}},{name:"Prone",options:{},data:{"flags.ddbimporter.activityMatch":"Ram"},statuses:["Prone"]}]}}class Rage extends DDBEnricherData{get activity(){return{targetType:"self",data:{"range.units":"self",duration:this.is2014?{units:"second",value:"60"}:{units:"minute",value:"10"}}}}get additionalActivities(){return[]}get override(){return{data:{name:"Rage","system.uses":{max:"@scale.barbarian.rages",recovery:this.is2014?[{period:"lr",type:"recoverAll",formula:""}]:[{period:"lr",type:"recoverAll",formula:""},{period:"sr",type:"formula",formula:"1"}]}}}}get effects(){return[{name:"Rage",options:{durationSeconds:this.is2014?60:600},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("@scale.barbarian.rage-damage",20,"system.bonuses.mwak.damage"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.traits.dr.value")],midiChanges:[DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.advantage.ability.save.str"),DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.advantage.ability.check.str")],tokenMagicChanges:[DDBEnricherData.ChangeHelper.customChange("outline",20,"macro.tokenMagic")]}]}}class RageOfTheWilds extends DDBEnricherData{get type(){return"none"}get activity(){return{targetType:"self",name:"Owl",activationType:"special"}}get additionalActivities(){return["Bear","Eagle","Wolf"].map((e=>({constructor:{name:e,type:"utility"},build:{generateTarget:!0,generateActivation:!0,activationOverride:{type:"special"},targetOverride:{affects:{type:"self"}}}})))}get effects(){return[{name:"Bear",options:{},activityMatch:"Bear",changes:DDBEnricherData.allDamageTypes(["force","necrotic","psychic","radiant"]).map((e=>DDBEnricherData.ChangeHelper.unsignedAddChange(e,20,"system.traits.dr.value")))},{name:"Eagle",options:{},activityMatch:"Eagle",changes:[]},{name:"Wolf",options:{description:"Allies have Advantage on attack rolls against your enemies within 5 ft ."},activityMatch:"Wolf",changes:[]}]}}class RagingStormDesert extends DDBEnricherData{get type(){return"save"}get activity(){return{type:"save",activationType:"reaction",targetType:"creature",rangeSelf:!0,data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"floor(@classes.barbarian.levels / 2)",types:["fire"]})]},save:{ability:["dex"],dc:{calculation:"con",formula:""}},target:{affects:{count:"1",type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"},prompt:!1}}}}}class RagingStormSea extends DDBEnricherData{get type(){return"save"}get activity(){return{type:"save",activationType:"reaction",targetType:"creature",rangeSelf:!0,data:{save:{ability:["str"],dc:{calculation:"con",formula:""}},target:{affects:{count:"1",type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"},prompt:!1}}}}get effects(){return[{name:"Prone",statuses:["Prone"]},{name:"Raging Seas Storm Automation",midiOnly:!0,options:{transfer:!0},optionalMacroChanges:[{optionPostfix:"ragingSea.damage.mwak",macroType:"feat",macroName:"ragingStormSea.js",document:this.data},{optionPostfix:"ragingSea.damage.msak",macroType:"feat",macroName:"ragingStormSea.js",document:this.data},{optionPostfix:"ragingSea.damage.rwak",macroType:"feat",macroName:"ragingStormSea.js",document:this.data},{optionPostfix:"ragingSea.damage.rsak",macroType:"feat",macroName:"ragingStormSea.js",document:this.data}],midiOptionalChanges:[{name:"ragingSea",data:{count:"reaction",label:"Use your reaction to induce a save to apply prone?"}}]}]}get itemMacro(){return{type:"feat",name:"ragingStormSea.js"}}}class RagingStormTundra extends DDBEnricherData{get type(){return"save"}get activity(){return{activationType:"reaction",targetType:"creature",rangeSelf:!0,data:{save:{ability:["str"],dc:{calculation:"con",formula:""}},target:{affects:{count:"1",type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"},prompt:!1}}}}get effects(){return[{changes:[DDBEnricherData.ChangeHelper.customChange("*0",20,"system.attributes.movement.all"),DDBEnricherData.ChangeHelper.overrideChange("0",60,"system.attributes.movement.walk"),DDBEnricherData.ChangeHelper.overrideChange("0",60,"system.attributes.movement.fly")]},{type:"item",midiOnly:!0,onUseMacroChanges:[{macroPass:"postActiveEffects",macroType:"feat",macroName:"ragingStormTundra.js",document:this.data}]}]}get itemMacro(){return{type:"feat",name:"ragingStormTundra.js"}}}class RelentlessRage extends DDBEnricherData{get type(){return"save"}get activity(){return{activationType:"special",targetType:"self",addItemConsume:!0,data:{save:{ability:["con"],dc:{calculation:"",formula:"10 + (@item.uses.spent * 5)"}}}}}get additionalActivities(){return[{constructor:{name:"Apply Healing",type:"heal"},build:{generateConsumption:!1,generateTarget:!0,targetSelf:!0,generateRange:!1,generateActivation:!0,generateDamage:!1,generateHealing:!0,activationOverride:{type:"special",value:1,condition:""},healingPart:DDBEnricherData.basicDamagePart({customFormula:"@classes.barbarian.levels * 2",type:"healing"})}}]}get override(){return{data:{"system.uses":{spent:0,max:"30",recovery:[{period:"lr",type:"recoverAll"}]},"flags.ddbimporter":{retainResourceConsumption:!0,retainUseSpent:!0}}}}}class Retaliation extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"reaction"}}}class ShieldingStorm extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Shielding Storm: Desert",activationType:"special"}}get additionalActivities(){return[{constructor:{name:"Shielding Storm: Sea",type:"utility"},build:{generateDamage:!1,generateAttack:!1,generateTarget:!1,generateRange:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}}},{constructor:{name:"Shielding Storm: Tundra",type:"utility"},build:{generateDamage:!1,generateAttack:!1,generateTarget:!1,generateRange:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}}}]}get effects(){return[{name:"Shielding Storm: Desert",options:{},data:{flags:{ddbimporter:{activityMatch:"Shielding Storm: Desert"},ActiveAuras:{aura:"Allies",radius:"10",isAura:!0,ignoreSelf:!0,inactive:!1,hidden:!1,displayTemp:!0}}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("fire",20,"system.traits.dr.value")]},{name:"Shielding Storm: Sea",options:{},data:{flags:{ddbimporter:{activityMatch:"Shielding Storm: Sea"},ActiveAuras:{aura:"Allies",radius:"10",isAura:!0,ignoreSelf:!0,inactive:!1,hidden:!1,displayTemp:!0}}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("lightning",20,"system.traits.dr.value")]},{name:"Shielding Storm: Tundra",options:{},data:{flags:{ddbimporter:{activityMatch:"Shielding Storm: Tundra"},ActiveAuras:{aura:"Allies",radius:"10",isAura:!0,ignoreSelf:!0,inactive:!1,hidden:!1,displayTemp:!0}}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("cold",20,"system.traits.dr.value")]}]}}class StormAuraDesert extends DDBEnricherData{get type(){return"damage"}get activity(){return{type:"damage",activationType:"bonus",rangeSelf:!0,data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.storm-herald.storm-aura-desert",types:["fire"]})]},target:{affects:{type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}}}}}}class StormAuraSea extends DDBEnricherData{get type(){return"save"}get activity(){return{activationType:"bonus",rangeSelf:!0,data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.storm-herald.storm-aura-sea",types:["lightning"]})]},save:{ability:["dex"],dc:{calculation:"con",formula:""}},target:{affects:{count:"1",choice:!0,type:"creature"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}}}}}}class StormAuraTundra extends DDBEnricherData{get type(){return"heal"}get activity(){return{activationType:"bonus",rangeSelf:!0,data:{target:{affects:{type:"ally"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}},healing:DDBEnricherData.basicDamagePart({customFormula:"@scale.path-of-the-storm-herald.storm-aura-tundra",types:["temphp"]})}}}get effects(){return[{midiOnly:!0,onUseMacroChanges:[{macroPass:"postActiveEffects",macroType:"feat",macroName:"stormAuraTundra.js",document:this.data}]}]}get itemMacro(){return{type:"feat",name:"stormAuraTundra.js"}}}class StormSoul extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"special"}}}class StormSoulTundraFreezeWater extends DDBEnricherData{get activity(){return{data:{target:{affects:{type:"space"},template:{contiguous:!1,type:"cube",size:"5",units:"ft"}}}}}}class TravelAlongTheTree extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",activationType:"bonus",data:{name:"Teleport 60 ft",range:{value:"60",units:"ft",special:""}}}}get additionalActivities(){return[{constructor:{name:"Group Teleport",type:"utility"},build:{generateConsumption:!0,generateTarget:!0,generateRange:!0,generateDuration:!0,generateActivation:!0,targetOverride:{affects:{count:"7",type:"willing",special:"Within 10 feet of you."}},rangeOverride:{value:"150",units:"ft"},durationOverride:{units:"inst"},activationOverride:{type:"bonus"}}}]}}class VitalityOfTheTree extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Vitality Surge",targetType:"self",rangeSelf:!0,activationType:"special",activationCondition:"You enter a rage.",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"@classes.barbarian.levels",types:["temphp"]})}}}get additionalActivities(){return[{constructor:{name:"Life-Giving Force",type:"heal"},build:{generateConsumption:!0,generateTarget:!0,generateHealing:!0,generateActivation:!0,generateRange:!0,rangeOverride:{value:"10",units:"ft"},activationOverride:{type:"special",value:1,condition:"At the start of each of your turns (whilst raging)"},targetOverride:{affects:{value:"1",type:"ally"}},healingPart:DDBEnricherData.basicDamagePart({customFormula:"(@scale.barbarian.rage-damage)d4",type:"temphp"})}}]}}class BardicInspiration extends DDBEnricherData{get activity(){return{name:"Inspire",targetType:"creature",addItemConsume:!0,data:{roll:{prompt:!1,visible:!1,formula:"@scale.bard.bardic-inspiration",name:"Inspiration Roll"},duration:{value:"10",units:"minutes"},range:{value:60,long:null,units:"ft"}}}}get effects(){const e="@scale.bard.bardic-inspiration",t={name:"bardicInspiration",priortiy:20,data:{label:"Use Bardic Inspiration?","attack.all":e,"save.all":e,"check.all":e,"skill.all":e}};return this.hasSubclass("College of Valor")&&(t.data["damage.all"]=e,t.data["ac.all"]=e),[{options:{durationSeconds:600,transfer:!1},daeStackable:"noneName",midiOptionalChanges:[t],data:{flags:{dae:{specialDuration:[]}}}}]}get override(){return{data:{"mid-qol":{effectActivation:!1}}}}}class BeguilingMagic extends DDBEnricherData{get activity(){return{name:"Save"}}get additionalActivities(){return[{constructor:{name:"Recharge",type:"utility"},build:{generateConsumption:!0,consumptionOverride:{targets:[{type:"itemUses",target:"",value:-1,scaling:{mode:"",formula:""}}],scaling:{allowed:!1,max:""}}}}]}get override(){return{data:{"flags.ddbimporter":{ignoredConsumptionActivities:["Save"],retainOriginalConsumption:!0}}}}get effects(){return[{name:"Frightened",options:{},statuses:["Frightened"]},{name:"Charmed",options:{},statuses:["Charmed"]}]}}class CombatInspiration extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"creature",data:{name:"Defense",roll:{prompt:!1,visible:!0,formula:"@scale.bard.bardic-inspiration",name:"Inspiration Roll"}}}}get additionalActivities(){return[{constructor:{name:"Damage",type:"damage"},build:{generateDamage:!0,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.bard.bardic-inspiration"})]}}]}}class CuttingWords extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"creature",data:{roll:{prompt:!1,visible:!1,formula:"@scale.bard.bardic-inspiration",name:"Subtraction Roll"},range:{value:60,long:null,units:"ft"}}}}}class DazzlingFootwork extends DDBEnricherData{get type(){return"enchant"}get activity(){return{targetType:"self",data:{name:"Bardic Damage",restrictions:{type:"weapon",allowMagical:!0}}}}get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.overrideChange("unarmoredBard",10,"system.attributes.ac.calc")],data:{"flags.ddbimporter.activityMatch":"No Activity"}},{type:"enchant",changes:[DDBEnricherData.ChangeHelper.overrideChange("{} [Dazzling Footwork]",20,"name"),DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.damage.base.types"),DDBEnricherData.ChangeHelper.overrideChange("dex",20,"system.ability"),DDBEnricherData.ChangeHelper.overrideChange("true",20,"system.damage.base.custom.enabled"),DDBEnricherData.ChangeHelper.overrideChange("@scale.dance.dazzling-footwork + @abilities.dex.mod",20,"system.damage.base.custom.formula")],data:{"flags.ddbimporter.activityMatch":"Bardic Damage"}}]}get clearAutoEffects(){return!0}}class InspiringMovement extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"reaction"}}}class JackOfAllTrades extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.overrideChange("true",20,"flags.dnd5e.jackOfAllTrades")]}]}}class MantleOfInspiration extends DDBEnricherData{get type(){return"heal"}get activity(){return{data:{"description.chatFlavor":"Each creature can immediately use its reaction to move up to its speed, without provoking opportunity attacks.","range.units":"self",target:{template:{count:"",contiguous:!1,type:"radius",size:"60",width:"",height:"",units:"ft"},affects:{count:"@abilities.cha.mod",type:"ally",choice:!0,special:""},prompt:!1},healing:DDBEnricherData.basicDamagePart({customFormula:"2 * @scale.college-of-glamour.mantle-of-inspiration",types:["temphp"]})}}}get setMidiOnUseMacroFlag(){return{macroType:"feat",macroName:"mantleOfInspiration.js",triggerPoints:["preTargeting"]}}get itemMacro(){return{type:"feat",name:"mantleOfInspiration.js"}}}class RegainBardicInspiration extends DDBEnricherData{get type(){return"utility"}get activity(){return{addItemConsume:!0,itemConsumeValue:"-1",activationType:"special",addConsumptionScalingMax:"9",additionalConsumptionTargets:[{type:"spellSlots",value:"1",target:"1",scaling:{mode:"level"}}],data:{name:"Regain via Spell Slot"}}}}class SongOfRest extends DDBEnricherData{get activity(){return{data:{duration:{value:"1",units:"hour"},healing:DDBEnricherData.basicDamagePart({customFormula:"@scale.bard.song-of-rest",types:["healing"]})}}}}class SuperiorInspiration extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Regain 1 Use",addItemConsume:!0,itemConsumeValue:"-1",activationType:"special"}}}class TandemFootwork extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"special",data:{roll:{prompt:!1,visible:!1,formula:"@scale.bard.bardic-inspiration",name:"Initiative bonus"}}}}}class UnbreakableMajesty extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{name:"Assume Unbreakable Majesty"}}}get effects(){return[{options:{durationSeconds:60},data:{"flags.ddbimporter.activityMatch":"Assume Unbreakable Majesty"}}]}get additionalActivities(){return[{constructor:{name:"Save",type:"save"},build:{generateSave:!0,generateDamage:!1,generateTarget:!0,generateActivation:!0,durationOverride:{value:"",units:"spec"},activationOverride:{type:"special"},targetOverride:{affects:{value:"1",type:"creatures"},template:{contiguous:!1,type:"",size:"",width:"",height:"",units:""}}}}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({type:"class",name:"Assume Unbreakable Majesty",max:"1",period:"sr"})}}}}class BlessedHealer extends DDBEnricherData{get type(){return"heal"}get activity(){return{activationType:"special",name:"Heal Self",targetType:"self",addScalingMode:"amount",addScalingFormula:"1",data:{description:{chatFlavor:"Choose level of spell for scaling"},"consumption.scaling":{allowed:!0,max:"9"},healing:DDBEnricherData.basicDamagePart({bonus:"3",types:["healing"],scalingMode:"whole",scalingFormula:"1"})}}}get effects(){return[{type:"item",midiOnly:!0,onUseMacroChanges:[{macroPass:"postActiveEffects",macroType:"feat",macroName:"blessedHealer.js",document:this.data}]}]}get itemMacro(){return{type:"feat",name:"blessedHealer.js"}}get setMidiOnUseMacroFlag(){return{macroType:"feat",macroName:"blessedHealer.js",triggerPoints:["postActiveEffects"]}}}class BlessedStrikes extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",noeffect:!0,activationOverride:"special",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"1d8",types:["radiant"]})]}}}}get effects(){return[{midiOnly:!0,optional:{transfer:!0},midiOptionalChanges:[{name:"divineStrike",data:{label:"Divine Strike Bonus Damage",count:"each-round","damage.all":"@scale.cleric.divine-strike"}}]}]}}class BlessedStrikesDivineStrike extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",noeffect:!0,activationOverride:"special",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.cleric.divine-strike",types:["radiant","necrotic"]})]}}}}get effects(){return[{midiOnly:!0,options:{transfer:!0},midiOptionalChanges:[{name:"divineStrike",data:{label:"Divine Strike Bonus Damage",count:"each-round","damage.all":"@scale.cleric.divine-strike"}}]}]}}class BlessingOfTheTrickster extends DDBEnricherData{get effects(){return[{options:{description:"Advantage on Dexterity (Stealth) checks."}}]}}class ChannelDivinityCloakOfShadows extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",data:{duration:{value:"1",units:"minute"}}}}get effects(){return[{name:"Invisible",options:{durationSeconds:60},statuses:["Invisible"]}]}}class ChannelDivinityPreserveLife extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"ally",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"@classes.cleric.levels * 5",types:["healing"]})}}}}class ChannelDivinityRadianceOfTheDawn extends DDBEnricherData{get type(){return"save"}get activity(){return{targetType:"enemy",data:{damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({customFormula:"2d10 + @classes.cleric.levels",type:"radiant"})]},target:{template:{value:"30",units:"ft",type:"radius"}}}}}}class CoronaOfLight extends DDBEnricherData{get type(){return DDBEnricherData.AutoEffects.effectModules().atlInstalled?"utility":"ddbmacro"}get activity(){return DDBEnricherData.AutoEffects.effectModules().atlInstalled?{type:"utility",data:{name:"Use/Apply Light"}}:{type:"ddbmacro",data:{name:"Use/Apply Light",macro:{name:"Apply Light",function:"ddb.generic.light",visible:!1,parameters:'{"targetsSelf":true,"targetsToken":true,"lightConfig":{"dim":60,"bright":30},"flag":"light"}'}}}}get effects(){return DDBEnricherData.AutoEffects.effectModules().atlInstalled?[{options:{},data:{"flags.ddbimporter.activityMatch":"Use/Apply Light"},atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.light.bright",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"30"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.dim",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"60"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.color",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"#ffffff"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.alpha",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"0.25")]}]:[]}}class DiscipleOfLife extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"creature",data:{description:{chatFlavor:"Choose level of spell for scaling"},"consumption.scaling":{allowed:!0,max:"9"},healing:DDBEnricherData.basicDamagePart({bonus:"3",types:["healing"],scalingMode:"whole",scalingFormula:"1"})}}}}class DivineIntervention extends DDBEnricherData{get activity(){return this.is2014?{type:"utility",addItemConsume:!0,data:{roll:{prompt:!1,visible:!1,formula:"1d100",name:"Implore Aid"}}}:{type:"utility",addItemConsume:!0}}get override(){return{data:{"flags.ddbimporter.retainOriginalConsumption":!0,"system.uses":{value:"0",max:"1",recovery:[{period:"lr",type:"recoverAll",formula:void 0}]}}}}}class DivineOrderThaumaturge extends DDBEnricherData{get effects(){return[{noCreate:!0,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"system.scale.cleric.cantrips-known.value")]}]}}class GreaterDivineIntervention extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{roll:{prompt:!1,visible:!1,formula:"2d4",name:"Long rests till next intervention"}}}}get effects(){return[]}}class GuidedStrike extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Self",targetType:"self",activationType:"special",activationCondition:"When you miss with an attack"}}get additionalActivities(){return[{constructor:{name:"Other",type:"utility"},build:{generateConsumption:!0,generateTarget:!0,generateRange:!0,generateActivation:!0,activationOverride:{type:"reaction",value:1,condition:""},targetOverride:{affects:{type:"ally",value:1}},rangeOverride:{units:"ft",value:"30"}}}]}}class HarnessDivinePower extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"bonus",addItemConsume:!0}}get override(){return{data:{"flags.ddbimporter.retainOriginalConsumption":!0}}}}class ImprovedBlessedStrikesPotentSpellcasting extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"creature",activationType:"special",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"@abilities.wis.mod * 2",types:["temphp"]}),range:{value:"60",units:"ft"}}}}}class ImprovedDuplicity extends DDBEnricherData{get type(){return"Improved Duplicity"}get activity(){return{targetType:"creature",activationType:"special",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"@classes.cleric.levels",types:["healing"]})}}}}class ImprovedShadowStep extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",activationType:"bonus"}}}class ImprovedWardingFlare extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"creature",activationType:"special",data:{healing:DDBEnricherData.basicDamagePart({number:2,denomination:6,bonus:"@abilities.wis.mod",types:["temphp"]}),range:{value:"60",units:"ft"}}}}}class InvokeDuplicity extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",activationType:"bonus",data:{duration:{value:"1",units:"minute"}}}}get additionalActivities(){return[{constructor:{name:"Move Duplicate",type:"utility"},build:{generateConsumption:!1,generateRange:!0,generateActivation:!0,activationOverride:{type:"bonus",value:1,condition:""},rangeOverride:{units:"ft",value:"120"}}}]}get effects(){return[]}}class SearUndead extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",activationType:"special",activationCondition:"When you Turn Undead",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"(@abilities.wis.mod)d8",types:["radiant"]})]}}}}get override(){return{data:{"system.type.subtype":"channelDivinity"}}}}class StepsOfNight extends DDBEnricherData{get addAutoAdditionalActivities(){return!0}get activity(){return{targetType:"self"}}get effects(){return[{options:{durationSeconds:60},changes:[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.fly")]}]}}class VigilantBlessing extends DDBEnricherData{get addAutoAdditionalActivities(){return!0}get activity(){return{targetType:"creature"}}get effects(){return[{changes:[DDBEnricherData.ChangeHelper.customChange("1",30,"flags.dnd5e.initiativeAdv")],daeSpecialDurations:["Initiative"],data:{duration:{seconds:null,rounds:null}}}]}}class WarGodsBlessing extends DDBEnricherData{get type(){return"utility"}}class WarPriest extends DDBEnricherData{get type(){return"utility"}get override(){return{data:{"system.uses":this._getUsesWithSpent({type:"class",name:"War Priest: Bonus Attack",max:"max(1, @abilities.wis.mod)",period:"sr"})}}}}class WrathOfTheStorm extends DDBEnricherData{get activity(){return{data:{damage:{onSave:"half",parts:[DDBEnricherData.basicDamagePart({number:2,denomination:8,types:["thunder","lightning"]})]}}}}}class Archdruid extends DDBEnricherData{get activity(){return{type:"utility",name:"Regain A Wild Shape Use",activationType:"special",activationCondition:"When you roll initiative and have no Wild Shape uses remaining",additionalConsumptionTargets:[{type:"itemUses",target:"",value:"-1",scaling:{mode:"",formula:""}}]}}get additionalActivities(){return[{action:{name:"Nature Magician",type:"class"}}]}}class BlightedShape extends DDBEnricherData{get effects(){return[{name:"Blighted Shape Changes",options:{description:"You gain +2 AC Bonus in Wild Shape"},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("2",20,"system.attributes.ac.bonus"),DDBEnricherData.ChangeHelper.unsignedAddChange("60",20,"system.attributes.senses.darkvision")],atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.sight.range",CONST.ACTIVE_EFFECT_MODES.ADD,60,5),DDBEnricherData.ChangeHelper.atlChange("ATL.sight.visionMode",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"darkvision",5)]}]}}class CircleForms extends DDBEnricherData{get effects(){return[{name:"Circle Form AC",options:{description:"You gain a minimum AC of 13 + your Wisdom modifier."},changes:[DDBEnricherData.ChangeHelper.upgradeChange("13 + @abilities.wis.mod",20,"system.attributes.ac.min")]}]}}class CosmicOmen extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"creature",activationType:"reaction",addItemConsume:!0,data:{roll:{prompt:!1,visible:!1,formula:"1d6",name:"Weal or Woe Roll"}}}}get override(){return{data:{"flags.ddbimporter.retainOriginalConsumption":!0,system:{uses:{spent:0,max:"@abilities.wis.mod",reovery:[{period:"lr",type:"recoverAll",formula:""}]}}}}}}class DefileGround extends DDBEnricherData{get activity(){return{name:"Place Template"}}get additionalActivities(){return[{action:{name:"Defile Ground: Move Corruption",type:"class"}},{constructor:{name:"Damage",type:"damage"},build:{generateDamage:!0,generateActivation:!0,generateConsumption:!1,generateTarget:!0,generateRange:!1,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.blighted.defile-ground.die",types:["necrotic"]})]},overrides:{notemplate:!0,targetType:"creature",activationType:"special"}}]}}class DefileGroundMoveCorruption extends DDBEnricherData{get activity(){return{name:"Move Corruption"}}}class ElementalFuryPotentSpellcasting extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",activationType:"special",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@ability.wis.mod",types:["cold","fire","lighting","thunder"]})]}}}}get override(){return{descriptionSuffix:'\n<section class="secret" id="secret-ddbElementalFuryPotentSpellcasting">\n<p><strong>Implementation Details</strong></p>\n<p>DDB Importer will automatically adjust cantrip damage on spells when importing a character.</p>\n</section>'}}}class ElementalFuryPrimalStrike extends DDBEnricherData{get type(){return"damage"}get activity(){return{targetType:"creature",activationType:"special",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.druid.elemental-fury",types:["cold","fire","lighting","thunder"]})]}}}}}class FullOfStars extends DDBEnricherData{get type(){return"none"}get effects(){return[{name:"Full of Stars (Level 14)",changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",20,"system.traits.dr.value")]}]}}class ImprovedCircleForms extends DDBEnricherData{get effects(){return[{noCreate:!0}]}}class LandsAid extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Save vs Thorn Damage",targetType:"creature",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.land.lands-aid",types:["necrotic"]})]}}}}get additionalActivities(){return[{constructor:{name:"Healing",type:"heal"},build:{generateConsumption:!1,generateTarget:!0,generateActivation:!0,generateHealing:!0,activationOverride:{type:"special",value:1,condition:""},healingPart:DDBEnricherData.basicDamagePart({customFormula:"@scale.land.lands-aid",types:["healing"]}),targetOverride:{affects:{type:"ally",value:1},template:{count:"",contiguous:!1,type:"",size:"",width:"",height:"",units:""}}}}]}get override(){return{data:{"flags.ddbimporter.ignoredConsumptionActivities":["Healing"]}}}}class LunarForm extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Lunar Radiance Damage",activationType:"special",activationCondition:"Once per turn, on hit, whilst in Wild Shape",targetType:"creature",data:{damage:{parts:[DDBEnricherData.basicDamagePart({number:2,denomination:10,type:"radiant"})]}}}}}class MoonlightStep extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Transport",targetType:"self",data:{range:{units:"ft",value:"30"}}}}get effects(){return[{name:"Moonlight Step: Advantage on Next Attack",options:{description:"You have Advantage on the next attack roll you make before the end of this turn."}}]}}class NaturalRecovery extends DDBEnricherData{get type(){return"utility"}get activity(){return{type:"utility",name:"Cast Circle Spell",addActivityConsume:!0,data:{uses:this._getUsesWithSpent({type:"class",name:"Natural Recovery: Cast Circle Spell",max:"1",period:"1r"})}}}get additionalActivities(){return[{constructor:{name:"Recover Spell Slots",type:"ddbmacro"},build:{generateConsumption:!0,generateRange:!0,generateTarget:!0,generateUses:!0,generateDDBMacro:!0,usesOverride:this._getUsesWithSpent({type:"class",name:"Natural Recovery: Recover Spell Slots",max:"1",period:"lr"}),targetOverride:{affects:{type:"self"}},rangeOverride:{units:"self"},consumptionOverride:{targets:[{type:"activityUses",target:"",value:"1",scaling:{mode:"",formula:""}}],scaling:{allowed:!1,max:""}},ddbMacroOverride:{name:"Natural Recovery",function:"ddb.feat.naturalRecovery",visible:!1,parameters:""}}}]}}class NatureMagician extends DDBEnricherData{get activity(){return{name:"Nature Magician",type:"utility",noConsumeTargets:!0,targetType:"self",rangeSelf:"self",addItemConsume:!0,addScalingMode:"formula",addActivityConsume:!0,additionalConsumptionTargets:[{type:"spellSlots",value:"-1",target:"2",scaling:{mode:"level",formula:"2"}}],data:{uses:foundry.utils.mergeObject({override:!0},this.data.system.uses),consumption:{scaling:{allowed:!0,max:"@scale.druid.wild-shape-uses"},spellSlot:!0}}}}}class NaturesWard extends DDBEnricherData{get effects(){const e=[{name:"Poison Immunity",options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("poisoned",20,"system.traits.ci.value")]}],t=this.ddbParser?._chosen.find((e=>Y.utils.nameString(e.label).startsWith("Nature's Ward")))?.label??"";return[{type:"fire",origin:"Arid"},{type:"cold",origin:"Polar"},{type:"lightning",origin:"Temperate"},{type:"poison",origin:"Tropical"}].forEach((a=>{e.push({name:`${a.origin}: Resistance to ${a.type}`,options:{transfer:!0,disabled:!t.includes(a.origin)},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(a.type,20,"system.traits.dr.value")]})})),e}get clearAutoEffects(){return!0}}class StarryForm extends DDBEnricherData{get type(){return"utility"}get activity(){return{noTemplate:!0,targetType:"self",activationType:"bonus",name:"Activate Starry Form"}}get additionalActivities(){return[{constructor:{name:"Archer Attack",type:"attack"},build:{generateAttack:!0,generateConsumption:!1,generateTarget:!0,generateDamage:!0,attackOverride:{ability:"spellcasting",type:{classification:"spell",value:"range"}},damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.stars.starry-form + @mod",type:"radiant"})],targetOverride:{affects:{count:"1",type:"creature"}},rangeOverride:{value:"60",units:"ft"},activationOverride:{type:"bonus",value:1,condition:""}}},{constructor:{name:"Chalice Healing",type:"heal"},build:{generateAttack:!1,generateConsumption:!1,generateTarget:!0,generateDamage:!1,generateHealing:!0,healingPart:DDBEnricherData.basicDamagePart({customFormula:"@scale.stars.starry-form + @mod",type:"healing"}),targetOverride:{affects:{count:"1",type:"creature"}},rangeOverride:{value:"30",units:"ft"},activationOverride:{type:"bonus",value:1,condition:""}}},{constructor:{name:"Dragon Constitution",type:"utility"},build:{generateAttack:!1,generateConsumption:!1,generateTarget:!0,generateDamage:!1,generateHealing:!1,targetOverride:{affects:{count:"1",type:"self"}},rangeOverride:{units:"self"},activationOverride:{type:"bonus",value:1,condition:""}}}]}get effects(){const e=[DDBEnricherData.ChangeHelper.atlChange("ATL.light.dim",CONST.ACTIVE_EFFECT_MODES.UPGRADE,"20"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.bright",CONST.ACTIVE_EFFECT_MODES.UPGRADE,"10"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.color",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"#f3f5e5"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.alpha",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"0.35"),DDBEnricherData.ChangeHelper.atlChange("ATL.light.animation",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,'{"type": ""starlight"", "speed": 5,"intensity": 5}')];return[{activityMatch:"Activate Starry Form",name:"Starry Form: Archer",atlChanges:e},{activityMatch:"Activate Starry Form",name:"Starry Form: Chalice",atlChanges:e},{activityMatch:"Activate Starry Form",name:"Starry Form: Dragon",changes:[DDBEnricherData.ChangeHelper.upgradeChange("10",10,"system.attributes.concentration.roll.min")],atlChanges:e},{activityMatch:"Activate Starry Form",name:"Twinkling Constellations (Level 10)",changes:[DDBEnricherData.ChangeHelper.upgradeChange("20",20,"system.attributes.movement.fly")]},{activityMatch:"Activate Starry Form",name:"Full of Stars (Level 14)",changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",20,"system.traits.dr.value")]}]}get override(){return{data:{"flags.ddbimporter.ignoredConsumptionActivities":["Archer Attack","Chalice Healing","Dragon Constitution"]}}}}class Stormborn extends DDBEnricherData{get effects(){return[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.fly"),DDBEnricherData.ChangeHelper.unsignedAddChange("cold",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("lightning",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("thunder",20,"system.traits.dr.value")]}}class SummonWildfireSpirit extends DDBEnricherData{get additionalActivities(){return[{constructor:{name:"Wildfire Summoning Damage",type:"save"},build:{noeffect:!0,generateConsumption:!1,generateTarget:!0,generateRange:!1,generateActivation:!0,generateDamage:!0,generateSave:!0,activationOverride:{type:"special",value:1,condition:""},saveOverride:{ability:["dex"],dc:{calculation:"spellcasting",formula:""}},targetOverride:{template:{count:"",contiguous:!1,type:"radius",size:"10",width:"",height:"",units:"ft"},affects:{count:"",type:"creature",choice:!1,special:""}},damageParts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,type:"fire"})]}}]}}class SummonWildfireSpiritCommand extends DDBEnricherData{get type(){return null}get activity(){return null}get effects(){return[]}get additionalActivities(){return[]}get override(){return{data:{"system.uses":{spent:null,max:""}}}}}class TwinklingConstellations extends DDBEnricherData{get type(){return"utility"}get activity(){return{noTemplate:!0,targetType:"self",noConsumeTargets:!0,noeffects:!0,activationType:"special",activationCondition:"Start of each turn"}}get effects(){return[{name:"Twinkling Constellations (Level 10)",changes:[DDBEnricherData.ChangeHelper.upgradeChange("20",20,"system.attributes.movement.fly"),DDBEnricherData.ChangeHelper.upgradeChange("true",20,"system.attributes.movement.hover")]}]}get useDefaultAdditionalActivities(){return!0}}class WildResurgence extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Spend Spell Slot for Wild Shape Use",addItemConsume:!0,itemConsumeValue:"-1",activationType:"special",activationCondition:"Once on each of your turns",data:{img:"systems/dnd5e/icons/svg/abilities/intelligence.svg"},additionalConsumptionTargets:[{type:"spellSlots",value:"1",target:"1",scaling:{mode:"",formula:""}}]}}get additionalActivities(){return[{constructor:{name:"Spend Wild Shape to Regain Spell Slot",type:"utility"},build:{img:"systems/dnd5e/icons/svg/trait.svg",generateConsumption:!0,generateTarget:!0,generateUses:!0,consumptionOverride:{targets:[{type:"itemUses",target:"",value:1,scaling:{mode:"",formula:""}},{type:"activityUses",target:"",value:1,scaling:{mode:"",formula:""}},{type:"spellSlots",value:"-1",target:"1",scaling:{}}],scaling:{allowed:!0,max:"9"}},targetOverride:{affects:{value:"1",type:"self"}},usesOverride:this._getUsesWithSpent({type:"class",name:"Wild Resurgence: Regain Spell Slot",max:"1",period:"lr",override:!0})}}]}}class WildShape extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{duration:{value:"(floor(@classes.druid.levels / 2))",units:"hour"},img:"systems/dnd5e/icons/svg/abilities/intelligence.svg"}}}get override(){return{data:{"system.uses.max":"@scale.druid.wild-shape-uses"}}}}class WrathOfTheSea extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Activate Emination/Aura",targetType:"self",activationType:"bonus",data:{target:{template:{type:"radius",size:"10",units:"ft"}}}}}get additionalActivities(){return[{constructor:{name:"Save for Damage",type:"save"},build:{generateActivation:!0,activationOverride:{type:"bonus"},generateTarget:!0,targetOverride:{affects:{value:"1",type:"self"}},generateDamage:!0,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"(@abilities.wis.mod)d6",types:["cold"]})],generateSave:!0,saveOverride:{ability:["con"],dc:{calculation:"spellcasting",formula:""}}}}]}}class ActionSurge extends DDBEnricherData{get override(){return{removeDamage:!0}}}class CloudRune extends DDBEnricherData{get activity(){return{name:"Invoke Rune (Redirect Attack)"}}get effects(){return[{noCreate:!0,name:"Cloud Rune: Passive Bonuses",options:{transfer:!0,description:"You have advantage on Dexterity (Sleight of Hand) checks and Charisma (Deception) checks."}}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({name:"Cloud Rune",type:"class",max:"@scale.rune-knight.rune-uses"})}}}}class CombatSuperiority extends DDBEnricherData{get override(){return{data:{"system.uses":this._getUsesWithSpent({type:"class",name:"Superiority Dice",max:"@scale.battle-master.combat-superiority-uses",period:"lr"})}}}}class EldritchStrike extends DDBEnricherData{get effects(){return[{name:"Struck",options:{description:""}}]}}class FireRune extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Invoke Rune",targetType:"creature",activationType:"special",addItemConsume:!0,activationCondition:"You hit a creature",data:{damage:{parts:[DDBEnricherData.basicDamagePart({number:2,denomination:6,types:["fire"]})]}}}}get additionalActivities(){return this.isAction?[]:[{constructor:{name:"Save vs Constrained",type:"save"},build:{generateSave:!0,generateActivation:!0,generateConsumption:!1,generateDamage:!1,generateTarget:!0},overrides:{targetType:"creature",activationType:"special"}}]}get clearAutoEffects(){return!0}get effects(){return[{activityMatch:"Save vs Constrained",name:"Fire Rune: Restrained",options:{durationSeconds:60},statuses:["Restrained"]},{noCreate:!0,activityMatch:"Save vs Constrained",midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.customChange("label=Fire Rune (Start of Turn Damage),turn=start,savingThrow=false,damageRoll=2d6,damageType=fire,killAnim=true",20,"flags.midi-qol.OverTime"),DDBEnricherData.ChangeHelper.customChange("label=Fire Rune (End of Turn Save),turn=end,saveDC=@attributes.spelldc,saveAbility=str,savingThrow=true,saveMagic=true,saveRemove=true,killAnim=true",20,"flags.midi-qol.OverTime")]}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({name:"Fire Rune",type:"class",max:"@scale.rune-knight.rune-uses"})}}}}class FrostRune extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Invoke Rune",activationType:"bonus",targetSelf:!0,data:{duration:{units:"minute",value:10}}}}get effects(){return[{noCreate:!0,name:"Frost Rune: Passive Bonuses",options:{transfer:!0,description:"You have advantage on Wisdom (Animal Handling) checks and Charisma (Intimidation) checks."}},{activityMatch:"Invoke Rune",name:"Frost Rune",options:{transfer:!1,durationSeconds:600},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("+2",20,"system.abilities.con.bonuses.check"),DDBEnricherData.ChangeHelper.unsignedAddChange("+2",20,"system.abilities.con.bonuses.save"),DDBEnricherData.ChangeHelper.unsignedAddChange("+2",20,"system.abilities.str.bonuses.check"),DDBEnricherData.ChangeHelper.unsignedAddChange("+2",20,"system.abilities.str.bonuses.save")]}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({name:"Frost Rune",type:"class",max:"@scale.rune-knight.rune-uses"})}}}}class GiantsMight extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self",data:{duration:{value:"1",units:"minute"}}}}get additionalActivities(){return[{constructor:{name:"Bonus Damage",type:"damage"},build:{noeffect:!0,generateConsumption:!1,generateTarget:!1,generateRange:!1,generateActivation:!0,generateDamage:!0,activationOverride:{type:"special",value:1,condition:""},damageParts:[DDBEnricherData.basicDamagePart({number:1,denomination:6,types:DDBEnricherData.allDamageTypes()})]}}]}get effects(){return[{options:{durationSeconds:60,description:"You also gain advantage on Strength checks and saving throws."},atlChanges:[DDBEnricherData.ChangeHelper.atlChange("ATL.width",CONST.ACTIVE_EFFECT_MODES.UPGRADE,2,5),DDBEnricherData.ChangeHelper.atlChange("ATL.height",CONST.ACTIVE_EFFECT_MODES.UPGRADE,2,5)],changes:[DDBEnricherData.ChangeHelper.overrideChange("lg",25,"system.traits.size")],midiChanges:[DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.advantage.ability.save.str"),DDBEnricherData.ChangeHelper.customChange("1",20,"flags.midi-qol.advantage.ability.check.str")],midiOptionalChanges:[{name:"giantsMight",data:{label:"Giant's Might Bonus Damage",count:"turn","damage.all":"1d6",criticalDamage:"1"}}]}]}}class HillRune extends DDBEnricherData{get activity(){return{name:"Invoke Rune",targetType:"self"}}get override(){return{data:{"system.uses":this._getUsesWithSpent({name:"Hill Rune",type:"class",max:"@scale.rune-knight.rune-uses"})}}}get effects(){return[{noCreate:!0,name:"Hill Rune: Passive Bonuses",options:{description:"You have advantage on saving throws against being poisoned."}},{activityMatch:"Invoke Rune",name:"Hill Rune",options:{transfer:!1,durationSeconds:60},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("bludgeoning",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("slashing",20,"system.traits.dr.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("piercing",20,"system.traits.dr.value")]}]}}class ImprovedCritical extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.downgradeChange("19",25,"flags.dnd5e.weaponCriticalThreshold")]}]}}class Indomitable extends DDBEnricherData{get addAutoAdditionalActivities(){return!0}get effects(){return[{midiOnly:!0,options:{transfer:!0},midiOptionalChanges:[{name:"Indomitable",data:{label:"Use Indomitable to Succeed?",count:"ItemUses.Indomitable","save.fail":"reroll"}}]}]}}class Maneuver extends DDBEnricherData{extraDamageActivity(){return{constructor:{name:"Damage",type:"damage"},build:{generateDamage:!0,generateTarget:!0,generateRange:!0,generateConsumption:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}},overrides:{targetType:"creature",activationType:"special",data:{damage:{onSave:"none",parts:[DDBEnricherData.basicDamagePart({customFormula:this.diceString,types:DDBEnricherData.allDamageTypes()})]}}}}}get fighterAbility(){const e=this.ddbParser.ddbCharacter.abilities.withEffects;return e.str?.value>e.dex?.value?"str":"dex"}get diceString(){return this.isClass("Fighter")&&this.hasClassFeature({featureName:"Combat Superiority",className:"Fighter"})?"@scale.battle-master.combat-superiority-die":"1d6"}get ignoredConsumptionActivities(){return["Damage"]}get override(){return{data:{name:this.data.name.replace("Maneuver Options:","Maneuver:").replace("Maneuvers:","Maneuver: "),"flags.ddbimporter":{ignoredConsumptionActivities:this.ignoredConsumptionActivities}}}}get type(){return"damage"}get activity(){return{targetType:"creature",addItemConsume:!0,activationType:"special",data:{damage:{onSave:"none",parts:[DDBEnricherData.basicDamagePart({customFormula:this.diceString,types:DDBEnricherData.allDamageTypes()})]}}}}}class ManeuverAmbush extends Maneuver{get type(){return"utility"}get activity(){return{activationType:"special",targetType:"self"}}get effects(){return[{name:"Ambush Bonus",daeSpecialDurations:["isSkill.ste","Initiative"],data:{duration:{turns:1}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.skills.ste.bonuses.check"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.attributes.init.bonus")]}]}}class ManeuverBaitAndSwitch extends Maneuver{get type(){return"utility"}get activity(){return{activationType:"special",targetType:"creature",data:{range:{value:5,units:"ft"}}}}get effects(){return[{name:"Maneuver: Bait and Switch",changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.attributes.ac.bonus")],daeSpecialDurations:["turnStartSource"]}]}}class ManeuverBrace extends Maneuver{get type(){return"utility"}get activity(){return{name:"Brace",activationType:"reaction",addItemConsume:!0}}get additionalActivities(){return[this.extraDamageActivity()]}get override(){return{midiManualReaction:!0,data:{name:this.data.name.replace("Maneuver Options:","Maneuver:").replace("Maneuvers:","Maneuver: "),"flags.ddbimporter":{ignoredConsumptionActivities:this.ignoredConsumptionActivities}}}}get effects(){return[{name:"Brace: Extra Damage Automation",midiOnly:!0,activityMatch:"Brace",daeSpecialDurations:["1Attack:mwak"],data:{duration:{turns:2}},midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.damage")]}]}}class ManeuverCommandersStrike extends Maneuver{get type(){return"utility"}get activity(){return{name:"Commander's Strike",targetType:"ally",activationType:"special",addItemConsume:!0}}get additionalActivities(){return[this.extraDamageActivity()]}get effects(){return[{midiOnly:!0,activityMatch:"Commander's Strike",daeSpecialDurations:["1Attack"],data:{duration:{turns:2}},midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.damage"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.rwak.damage")]}]}}class ManeuverCommandingPresence extends Maneuver{get type(){return DDBEnricherData.AutoEffects.effectModules().midiQolInstalled?"utility":"check"}get activity(){return DDBEnricherData.AutoEffects.effectModules().midiQolInstalled?{targetType:"self",activationType:"special",addItemConsume:!0}:{targetType:"self",activationType:"special",addItemConsume:!0,data:{name:"Roll Check (Apply Effect First)",check:{associated:["per","itm","prf"],ability:"",dc:{calculation:"",formula:""}}}}}get effects(){return[{name:"Commanding Presence Bonus",daeSpecialDurations:["isSkill.itm","isSkill.per","isSkill.prf"],data:{duration:{turns:2}},changes:["per","itm","prf"].map((e=>DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,`system.skills.${e}.bonuses.check`)))}]}}class ManeuverDisarmingAttack extends Maneuver{get additionalActivities(){return[{constructor:{name:"Save vs Disarmed",type:"save"},build:{generateTarget:!0,generateRange:!0,generateConsumption:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}},overrides:{data:{damage:{onSave:"none"},save:{ability:["str"],dc:{calculation:"",formula:"8 + @prof + max(@abilities.dex.mod, @abilities.str.mod)"}}}}}]}get ignoredConsumptionActivities(){return["Save vs Disarmed"]}}class ManeuverDistractingStrike extends Maneuver{get effects(){return[{name:"Distracting Strike",daeSpecialDurations:["isAttacked","turnStartSource"],midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"flags.midi-qol.advantage.attack.all")]}]}}class ManeuverEvasiveFootwork extends Maneuver{get type(){return"utility"}get activity(){return{targetType:"self",addItemConsumed:!0,activationType:"special"}}get effects(){return[{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.attributes.ac.bonus")]}]}}class ManeuverFeintingAttack extends Maneuver{get type(){return"utility"}get activity(){return{name:"Feint",activationType:"bonus",addItemConsume:!0}}get additionalActivities(){return[this.extraDamageActivity()]}get effects(){return[{name:"Feinting Attack: Extra Damage",activityMatch:"Feint",midiOnly:!0,daeSpecialDurations:["1Attack"],data:{duration:{turns:1}},midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"flags.midi-qol.advantage.attack.all")],changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.damage"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.rwak.damage")]}]}}class ManeuverGoadingAttack extends Maneuver{get additionalActivities(){return[{constructor:{name:"Save vs Goading",type:"save"},build:{generateTarget:!0,generateRange:!0,generateConsumption:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}},overrides:{data:{damage:{onSave:"none"},save:{ability:["wis"],dc:{calculation:"",formula:"8 + @prof + max(@abilities.dex.mod, @abilities.str.mod)"}}}}}]}get effects(){return[{name:"Goaded",activityMatch:"Save vs Goading",daeSpecialDurations:["turnEndSource"]}]}get ignoredConsumptionActivities(){return["Save vs Goading"]}}class ManeuverGrapplingStrike extends Maneuver{get type(){return"utility"}get effects(){return[{name:"Grappling Strike Bonus",daeSpecialDurations:["isSkill.ath"],data:{duration:{turns:1}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.skills.ath.bonuses.check")]}]}}class ManeuverLungingAttack extends Maneuver{get type(){return"utility"}get activity(){return{name:"Lunge",activationType:"special",addItemConsume:!0}}get additionalActivities(){return[this.extraDamageActivity()]}get effects(){return[{name:"Lunging Attack Bonus Damage",daeSpecialDurations:["1Attack"],data:{duration:{turns:1}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.damage")]}]}}class ManeuverManeuveringAttack extends Maneuver{get type(){return"damage"}get activity(){return{data:{damage:{onSave:"none",parts:[DDBEnricherData.basicDamagePart({customFormula:this.diceString,types:DDBEnricherData.allDamageTypes()})]}}}}}class ManeuverMenacingAttack extends Maneuver{get additionalActivities(){return[{constructor:{name:"Save vs Frightened",type:"save"},build:{generateTarget:!0,generateRange:!0,generateConsumption:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}},overrides:{data:{damage:{onSave:"none"},save:{ability:["wis"],dc:{calculation:"",formula:"8 + @prof + max(@abilities.dex.mod, @abilities.str.mod)"}}}}}]}get effects(){return[{name:"Menaced",statuses:["Frightened"],activityMatch:"Save vs Frightened",daeSpecialDurations:["turnEndSource"]}]}get ignoredConsumptionActivities(){return["Save vs Frightened"]}}class ManeuverParry extends Maneuver{get type(){return"utility"}get activity(){return{activationType:"reaction",targetType:"self",data:{roll:{prompt:!1,visible:!1,formula:this.diceString,name:"Reduce Damage Roll"}}}}get effects(){return[{midiOnly:!0,midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"flags.midi-qol.DR.all")],daeSpecialDurations:["isDamaged"]}]}}class ManeuverPrecisionAttack extends Maneuver{get type(){return"utility"}get activity(){return{name:"Precision Attack",activationType:"reaction",targetType:"self",addItemConsume:!0}}get effects(){return[{name:"Precision Attack Bonus",daeSpecialDurations:["1Attack"],data:{duration:{turns:1}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.attack"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.rwak.attack")]}]}}class ManeuverPushingAttack extends Maneuver{get additionalActivities(){return[{constructor:{name:"Save vs Pushed",type:"save"},build:{generateTarget:!0,generateRange:!0,generateConsumption:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}},overrides:{data:{damage:{onSave:"none"},save:{ability:["str"],dc:{calculation:"",formula:"8 + @prof + max(@abilities.dex.mod, @abilities.str.mod)"}}}}}]}get ignoredConsumptionActivities(){return["Save vs Pushed"]}}class ManeuverQuickToss extends Maneuver{get type(){return DDBEnricherData.AutoEffects.effectModules().midiQolInstalled?"utility":"damage"}get effects(){return[{midiOnly:!0,daeSpecialDurations:["1Attack"],data:{duration:{turns:1}},midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.damage"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.rwak.damage")]}]}}class ManeuverRally extends Maneuver{get type(){return"heal"}get activity(){return{data:{healing:DDBEnricherData.basicDamagePart({customFormula:`${this.diceString} + ${this.is2014?"@abilities.cha.mod":"@details.level"}`,types:["temphp"]})}}}}class ManeuverRiposte extends Maneuver{get type(){return"utility"}get override(){return{midiManualReaction:!0,data:{name:this.data.name.replace("Maneuver Options:","Maneuver:").replace("Maneuvers:","Maneuver: "),"flags.ddbimporter":{ignoredConsumptionActivities:this.ignoredConsumptionActivities}}}}get additionalActivities(){return[this.extraDamageActivity()]}get effects(){return[{daeSpecialDurations:["1Attack:mwak"],data:{duration:{turns:2}},midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.bonuses.mwak.damage")]}]}}class ManeuverSweepingAttack extends Maneuver{}class ManeuverTacticalAssessment extends Maneuver{get type(){return DDBEnricherData.AutoEffects.effectModules().midiQolInstalled?"utility":"check"}get activity(){return DDBEnricherData.AutoEffects.effectModules().midiQolInstalled?{targetType:"self",activationType:"special",addItemConsume:!0}:{data:{name:"Roll Check (Apply Effect First)",addItemConsume:!0,check:{associated:["his","inv","ins"],ability:"",dc:{calculation:"",formula:""}}}}}get effects(){return[{name:"Tactical Assessment Bonus",daeSpecialDurations:["isSkill.his","isSkill.inv","isSkill.ins"],data:{duration:{turns:2}},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.skills.his.bonuses.check"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.skills.inv.bonuses.check"),DDBEnricherData.ChangeHelper.unsignedAddChange(this.diceString,20,"system.skills.ins.bonuses.check")]}]}}class ManeuverTripAttack extends Maneuver{get additionalActivities(){return[{constructor:{name:"Save vs Trip",type:"save"},build:{generateTarget:!0,generateRange:!0,generateConsumption:!1,generateActivation:!0,activationOverride:{type:"special",value:1,condition:""}},overrides:{data:{damage:{onSave:"none"},save:{ability:["str"],dc:{calculation:"",formula:"8 + @prof + max(@abilities.dex.mod, @abilities.str.mod)"}}}}}]}get effects(){return[{name:"Tripped",activityMatch:"Save vs Trip",statuses:["Prone"]}]}get ignoredConsumptionActivities(){return["Save vs Trip"]}}class PsiPoweredLeap extends DDBEnricherData{get activity(){return{name:"Psi-Powered Leap",addItemConsume:!0,addSingleFreeUse:!0,addSingleFreeRecoveryPeriod:"sr"}}}class PsionicStrike extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Psionic Strike",activationType:"special",type:"damage",targetType:"creature",addItemConsume:!0,data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.psi-warrior.energy-die.die + @abilities.mod.int",types:["psychic"]})]},range:{units:"ft",value:"30"}}}}}class Relentless extends DDBEnricherData{get type(){return this.is2014?null:"utility"}get activity(){return this.is2014?null:{activationType:"special",data:{roll:{prompt:!1,visible:!1,formula:"1d8",name:"Maneuver Roll"}}}}}class RemarkableAthlete extends DDBEnricherData{get effects(){return[{noCreate:!this.is2014,options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.overrideChange("true",20,"flags.dnd5e.remarkableAthlete")]}]}}class SecondWind extends DDBEnricherData{get type(){return"heal"}get activity(){return{addItemConsume:!0,targetType:"self",data:{healing:DDBEnricherData.basicDamagePart({number:"1",denomination:"10",bonus:"@classes.fighter.levels",types:["healing"]})}}}get override(){const e={data:{}};if(this.is2024){const t=foundry.utils.deepClone(this.data.system.uses.recovery??[]);0===t.length&&t.push({period:"lr",type:"recoverAll"}),t.push({period:"sr",type:"formula",formula:"1"}),e.data={"system.uses.recovery":t}}return e}}class StoneRune extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Invoke Rune",data:{save:{ability:["wis"],dc:{calculation:"con",formula:""}}}}}get additionalActivities(){return this.isAction?[]:[{action:{name:"Stone Rune",type:"class"}}]}get effects(){return[{noCreate:!0,name:"Stone Rune: Passive Bonuses",options:{description:"You have advantage on Wisdom (Insight) checks"},atlChanges:[DDBEnricherData.ChangeHelper.generateATLChange("ATL.sight.range",CONST.ACTIVE_EFFECT_MODES.UPGRADE,120,5),DDBEnricherData.ChangeHelper.generateATLChange("ATL.sight.visionMode",CONST.ACTIVE_EFFECT_MODES.OVERRIDE,"darkvision",5)]},{activityMatch:"Invoke Rune",name:"Stone Rune: Dreamy Stupor",options:{durationSeconds:60},statuses:["Charmed","Incapacitated"],midiChanges:[DDBEnricherData.ChangeHelper.customChange("label=Stone Rune (End of Turn Save),turn=end,saveDC=@attributes.spelldc,saveAbility=con,savingThrow=true,saveMagic=true,saveRemove=true,killAnim=true",20,"flags.midi-qol.OverTime")]}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({name:"Stone Rune",type:"class",max:"@scale.rune-knight.rune-uses"})}}}}class StormRune extends DDBEnricherData{get activity(){return{name:"Invoke Rune: Enter Prophetic State",activationType:"bonus",targetType:"self",rangeSelf:!0}}get override(){return{data:{"system.uses":this._getUsesWithSpent({name:"Storm Rune",type:"class",max:"@scale.rune-knight.rune-uses"})}}}get additionalActivities(){return[]}get effects(){return[{noCreate:!0,name:"Storm Rune: Passive Bonuses",options:{description:"You can't be surprised."}},{activityMatch:"Invoke Rune: Enter Prophetic State",name:"Prophetic State",options:{durationSeconds:60}}]}}class SuperiorCritical extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.downgradeChange("18",30,"flags.dnd5e.weaponCriticalThreshold")]}]}}class Survivor extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Heroic Rally",targetType:"self",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"5 + @abilities.con.mod",types:["healing"]})}}}}class TacticalMaster extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("push",10,"system.traits.weaponProf.mastery.bonus"),DDBEnricherData.ChangeHelper.unsignedAddChange("sap",10,"system.traits.weaponProf.mastery.bonus"),DDBEnricherData.ChangeHelper.unsignedAddChange("slow",10,"system.traits.weaponProf.mastery.bonus")]}]}}class TacticalMind extends DDBEnricherData{get type(){return"utility"}get activity(){return{data:{roll:{prompt:!1,visible:!1,formula:"1d10",name:"Roll Ability Check Bonus"}}}}}class TelekineticAdept extends DDBEnricherData{get additionalActivities(){return this.is2024?[{action:{name:"Psionic Power: Psi-Powered Leap",type:"class"}},{action:{name:"Psionic Power: Telekinetic Thrust",type:"class"}}]:[{action:{name:"Telekinetic Adept: Psi-Powered Leap",type:"class"}},{action:{name:"Telekinetic Adept: Telekinetic Thrust",type:"class"}}]}}class TelekineticMaster extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Spend Energy Die to Regain Use",addItemConsume:!0,activationType:"",additionalConsumptionTargets:[{type:"itemUses",target:"",value:"-1",scaling:{mode:"",formula:""}}]}}get override(){return{data:{"flags.ddbimporter.retainChildUses":!0,"system.uses":this._getUsesWithSpent({type:"class",name:"Telekinetic Master: Weapon Attack",max:"1",period:"lr"})}}}}class TelekineticMovement extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Telekinetic Movement",targetType:"creature",addItemConsume:!0,addSingleFreeUse:!0,addSingleFreeRecoveryPeriod:"sr",data:{range:{units:"ft",value:"30"}}}}}class TelekineticThrust extends DDBEnricherData{get activity(){return{name:"Telekinetic Thrust",activationType:"special",addItemConsume:!0}}get effects(){return[{name:"Telekinetic Thrust: Prone",statuses:["Prone"]}]}}class WarBond extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Summon Weapon",activationType:"bonus",targetType:"self",noeffect:!0}}get effects(){return[{name:"Weapon Bond",type:"enchant",changes:[DDBEnricherData.ChangeHelper.overrideChange("{} [Bonded]",20,"name")]}]}get additionalActivities(){return[{constructor:{name:"Bond, 1st Weapon",type:"enchant"},build:{generateActivation:!0,generateRange:!0,generateConsumption:!0,activationOverride:{value:"1",units:"hour"},rangeOverride:{units:"self"},consumptionOverride:{targets:[{type:"itemUses",target:"",value:1,scaling:{mode:"",formula:""}}]},data:{restrictions:{type:"weapon",allowMagical:!0}}}},{constructor:{name:"Bond, 2nd Weapon",type:"enchant"},build:{generateActivation:!0,generateRange:!0,generateConsumption:!0,activationOverride:{value:"1",units:"hour"},rangeOverride:{units:"self"},consumptionOverride:{targets:[{type:"itemUses",target:"",value:1,scaling:{mode:"",formula:""}}]},data:{restrictions:{type:"weapon",allowMagical:!0}}}}]}get override(){return{data:{"flags.ddbimporter":{retainUseSpent:!0},"system.uses":{spent:0,max:"2"}}}}}class ArmsOfTheAstralSelf extends DDBEnricherData{get type(){return"none"}get additionalActivities(){return[{action:{name:"Arms of the Astral Self: Summon",type:"class",rename:["Summon"]}},{action:{name:"Arms of the Astral Self (DEX/STR)",type:"class",rename:["DEX/STR Attack"]}},{action:{name:"Arms of the Astral Self (WIS)",type:"class",rename:["WIS Attack"]}}]}get effects(){return[{activityMatch:"Summon",name:`${this.data.name} (Save Modifications)`,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("- @abilities.str.mod + @abilities.wis.mod",0,"system.abilities.str.bonuses.check"),DDBEnricherData.ChangeHelper.unsignedAddChange("- @abilities.str.mod + @abilities.wis.mod",0,"system.abilities.str.bonuses.save")],options:{durationSeconds:600}}]}get override(){return{replaceActivityUses:!0,data:{"flags.ddbimporter.skipScale":!0}}}}class ArmsOfTheAstralSelfPhysicalAttack extends DDBEnricherData{get activity(){return{noConsumeTargets:!0,noeffect:!0,data:{"attack.ability":"","damage.parts":[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die + @mod",types:["force"]})]}}}}class ArmsOfTheAstralSelfSummon extends DDBEnricherData{get activity(){return{noConsumeTargets:!0,addItemConsume:!0,itemConsumeTargetName:"Ki",rangeSelf:!0,data:{target:{affects:{type:"enemy"},template:{contiguous:!1,type:"radius",size:"10",units:"ft"}},damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"2@scale.monk.martial-arts.die",type:"force"})],onSave:"none"}}}}get override(){return{replaceActivityUses:!0}}}class ArmsOfTheAstralSelfWisAttack extends DDBEnricherData{get activity(){return{noConsumeTargets:!0,noeffect:!0,data:{"attack.ability":"","damage.parts":[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die + @mod",types:["force"]})]}}}}class AwakenedAstralSelf extends DDBEnricherData{get useDefaultAdditionalActivities(){return!0}get effects(){return[{name:"Armor of the Spirit",options:{description:"You gain +2 AC Bonus",durationSeconds:600},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("2",20,"system.attributes.ac.bonus")]}]}}class DeflectAttack extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Reduce Damage",targetType:"self",type:"heal",data:{"consumption.targets":[],healing:DDBEnricherData.basicDamagePart({number:1,denomination:10,bonus:"@abilities.dex.mod + @classes.monk.levels",types:["healing"]})}}}}class DeflectAttackRedirectAttack extends DDBEnricherData{get type(){return"save"}get activity(){return{name:"Redirect Attack",targetType:"creature",addItemConsume:!0,activationType:"special",type:"save",data:{save:{ability:["dex"],dc:{calculation:"dex",formula:""}},damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"2@scale.monk.martial-arts.die + @abilities.dex.mod",types:["bludgeoning","piercing","slashing"]})]}}}}}class DeflectAttacks extends DDBEnricherData{get additionalActivities(){return[{action:{name:"Deflect Attack",type:"class"}},{action:{name:"Deflect Attack: Redirect Attack",type:"class"}}]}get override(){return{data:{"flags.ddbimporter":{ignoredConsumptionActivities:["Reduce Damage"]}}}}}class DeflectEnergy extends DDBEnricherData{get type(){return"none"}get additionalActivities(){return[{action:{name:"Deflect Attack",type:"class"}},{action:{name:"Deflect Attack: Redirect Attack",type:"class"},override:{data:{"damage.types":DDBEnricherData.allDamageTypes()}}}]}get override(){return{data:{"flags.ddbimporter":{ignoredConsumptionActivities:["Reduce Damage"]}}}}}class DeflectMissiles extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Reduce Damage",targetType:"self",type:"heal",data:{"consumption.targets":[],healing:DDBEnricherData.basicDamagePart({number:1,denomination:10,bonus:"@abilities.dex.mod + @classes.monk.levels",types:["healing"]})}}}get additionalActivities(){return[{action:{name:"Deflect Missiles Attack",type:"class",rename:["Deflect Missiles Attack"]},overrides:{addItemConsume:!0,itemConsumeTargetName:"Ki"}}]}get effects(){return[{midiOnly:!0,name:"Deflect Missiles Automation",options:{transfer:!0},midiChanges:[DDBEnricherData.ChangeHelper.customChange("[[1d10 + @abilities.dex.mod + @classes.monk.levels]]",20,"flags.midi-qol.DR.rwak")],daeSpecialDurations:["isDamaged"]}]}get override(){return{midiDamageReaction:!0,data:{"flags.ddbimporter":{ignoredConsumptionActivities:["Reduce Damage"]}}}}}class DeflectMissilesAttack extends DDBEnricherData{get activity(){return{activationType:"special",targetType:"creature",data:{"damage.parts":[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die + @abilities.dex.mod",types:DDBEnricherData.allDamageTypes()})]}}}get override(){return{midiManualReaction:!0}}}class DeftStrike extends DDBEnricherData{get effects(){return[{midiOnly:!0,options:{transfer:!0},midiOptionalChanges:[{name:"deftStrike",data:{label:`${document.name} Additional Damage`,count:"turn","damage.all":"@scale.monk.martial-arts",countAlt:"ItemUses.Ki",criticalDamage:"1"}}]}]}}class DiamondSoul extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.overrideChange("true",20,"flags.dnd5e.diamondSoul")]}]}}class DisciplinedSurvivor extends DDBEnricherData{get type(){return"utility"}get activity(){return{targetType:"self"}}get clearAutoEffects(){return!0}}class ElementalAttunement extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Elemental Attunement",targetType:"self",activationType:"special",activationCondition:"Start of turn"}}get additionalActivities(){return[{constructor:{name:"Elemental Strike",type:"attack"},build:{generateAttack:!0,generateDamage:!0,generateRange:!0,generateTarget:!0,generateActivation:!0,generateConsumption:!1,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die + @mod",types:["bludgeoning","acid","cold","fire","lightning","thunder"]})]},overrides:{data:{target:{affects:{count:"1",type:"creature"}},range:{value:15,units:"ft"},attack:{ability:["dex"],type:{value:"melee",classification:"unarmed"}}}}},{constructor:{name:"Elemental Save",type:"save"},build:{generateSave:!0,generateRange:!1,generateTarget:!0,generateActivation:!0,generateConsumption:!1,saveOverride:{ability:["str"],dc:{calculation:"wis",formula:""}},activationOverride:{type:"special",condition:"You deal Elemental Strike damage"}},overrides:{data:{target:{affects:{count:"1",type:"creature"}},range:{value:15,units:"ft"}}}}]}get effects(){return[{name:"Elemental Attunement",data:{"flags.ddbimporter.activityMatch":"Elemental Attunement"}}]}get override(){return{data:{"flags.ddbimporter.ignoredConsumptionActivities":["Elemental Strike","Elemental Save"]}}}}class ElementalBurst extends DDBEnricherData{get activity(){return{data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.elements.elemental-burst",types:["acid","cold","fire","lightning","thunder"]})]}}}}}class ElementalEpitome extends DDBEnricherData{get type(){return"utility"}get activity(){return{name:"Elemental Attunement Effects",activationType:"special",activationCondition:"Become Elementally Attuned",targetType:"self",noTemplate:!0}}get additionalActivities(){return[{constructor:{name:"Elemental Epitome Damage",type:"damage"},build:{generateDamage:!0,generateActivation:!0,generateConsumption:!1,generateTarget:!1,generateRange:!1,damageParts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die",types:["acid","cold","fire","lightning","thunder"]})]},overrides:{data:{target:{affects:{count:"1",type:"creature"}},range:{units:"self"}}}}]}get effects(){return[...["acid","cold","fire","lightning","thunder"].map((e=>({name:`${Y.utils.capitalize(e)} Resistance`,changes:[DDBEnricherData.ChangeHelper.unsignedAddChange(e,20,"system.traits.dr.value")],activityMatch:"Elemental Attunement Effects"}))),{name:"Step of the Wind Bonus",changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("20",20,"system.attributes.speed.walk")],activityMatch:"Elemental Attunement Effects"}]}}class EmpoweredStrikes extends DDBEnricherData{get type(){return"attack"}get activity(){return{targetType:"creature",data:{range:{value:5,units:"ft"},attack:{ability:"dex",type:{value:"melee",classification:"unarmed"}},damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die + @mod",types:["bludgeoning","force"]})]}}}}get clearAutoEffects(){return!0}}class EmptyBody extends DDBEnricherData{get activity(){return{targetType:"self"}}get effects(){return[{options:{durationSeconds:60},statuses:["invisible"],changes:DDBEnricherData.allDamageTypes(["force"]).map((e=>DDBEnricherData.ChangeHelper.unsignedAddChange(e,20,"system.traits.dr.value")))}]}}class FleetStep extends DDBEnricherData{get additionalActivities(){return[{action:{name:"Step of the Wind: Fleet Step",type:"class"}}]}}class FlurryOfBlowsAdditional extends DDBEnricherData{get type(){return"utility"}get activity(){return{activationType:"special",activationCondition:"You hit a creature with a Flurry of Blows strike"}}get override(){return{data:{"flags.ddbimporter.retainResourceConsumption":!0}}}get effects(){return"Flurry of Blows: Topple"===this.ddbParser.originalName?[{name:"Prone",statuses:["Prone"]}]:[]}}class HandOfHarm extends DDBEnricherData{get type(){return"damage"}get activity(){return{name:"Hand of Harm",targetType:"creature",activationType:"special",data:{damage:{parts:[DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die",type:"necrotic"})]}}}}}class HandOfHealing extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Hand of Healing",activationType:"special",targetType:"creature",data:{"range.units":"touch","healing.custom.formula":"@scale.mercy.hand-of-healing + @abilities.wis.mod"}}}}class HeightenedFocus extends DDBEnricherData{get type(){return"heal"}get activity(){return{name:"Patient Defense Healing",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"2@scale.monk.martial-arts.die",types:["temphp"]})}}}get clearAutoEffects(){return!0}}class Ki extends DDBEnricherData{get additionalActivities(){return[{action:{name:"Flurry of Blows",type:"class",rename:["Flurry of Blows"]},overrides:{addItemConsume:!0}},{action:{name:"Patient Defense",type:"class"}},{action:{name:"Step of the Wind",type:"class",rename:["Step of the Wind"]},overrides:{addItemConsume:!0}}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({type:"class",name:"Ki Points",max:"@scale.monk.ki-points",period:"sr"})}}}}class MonksFocus extends DDBEnricherData{get type(){return null}get additionalActivities(){return[{action:{name:"Flurry of Blows",type:"class",rename:["Flurry of Blows"]},overrides:{addItemConsume:!0}},{action:{name:"Patient Defense",type:"class"}},{action:{name:"Step of the Wind",type:"class",rename:["Step of the Wind"]},overrides:{addItemConsume:!0}}]}get effects(){return[{name:"Disengage",activityMatch:"Step of the Wind"}]}get override(){return{data:{"flags.ddbimporter.ignoredConsumptionActivities":["Patient Defense: Disengage"],"system.uses":this._getUsesWithSpent({type:"class",name:"Focus Points",max:"@scale.monk.focus-points",period:"sr"})}}}}class OpenHandTechnique extends DDBEnricherData{get additionalActivities(){return this.is2024?[{action:{name:"Flurry of Blows: Addle",type:"class",rename:["Addle"]}},{action:{name:"Flurry of Blows: Push",type:"class",rename:["Push"]}},{action:{name:"Flurry of Blows: Topple",type:"class",rename:["Topple"]}}]:[]}}class PatientDefense extends DDBEnricherData{get activity(){return{name:this.is2014?"Patient Defense: Dodge":"Patient Defense: Disengage",targetType:"self",type:"utility"}}get additionalActivities(){return this.is2014?[]:[{duplicate:!0,overrides:{addItemConsume:!0,data:{name:"Patient Defense: Disengage & Dodge"}}}]}get effects(){return this.is2014?[{name:"Patient Defense: Dodging",options:{durationRounds:1,durationSeconds:6},statuses:["dodging"],data:{"flags.ddbimporter.activitiesMatch":["Patient Defense: Dodge"]}}]:[{name:"Patient Defense: Disengaged",options:{durationRounds:1,durationSeconds:6},data:{"flags.ddbimporter.activitiesMatch":["Patient Defense: Disengage"]}},{name:"Patient Defense: Disengaged & Dodging",options:{durationRounds:1,durationSeconds:6},statuses:["dodging"],data:{"flags.ddbimporter.activitiesMatch":["Patient Defense: Disengage & Dodge"]}}]}}class PerfectFocus extends DDBEnricherData{get type(){return"ddbmacro"}get activity(){return{type:"ddbmacro",data:{name:"Recover Focus",macro:{name:"Recover Focus",function:"ddb.feat.perfectFocus",visible:!1,parameters:""}}}}}class PhysiciansTouch extends DDBEnricherData{get additionalActivities(){return[{action:{name:"Hand of Healing",type:"class",rename:["Hand of Healing"]}},{action:{name:"Hand of Harm",type:"class",rename:["Hand of Harm"]}}]}get effects(){return[{name:"Poisoned",statuses:["Poisoned"],data:{"flags.ddbimporter.activitiesMatch":["Hand of Harm"]}}]}}class QuickenedHealing extends DDBEnricherData{get type(){return"heal"}get activity(){return{type:"heal",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"@scale.monk.martial-arts.die + @prof",types:["healing"]})}}}}class ShadowArts extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("60",20,"system.attributes.senses.darkvision")]}]}get clearAutoEffects(){return!0}}class SlowFall extends DDBEnricherData{get type(){return this.is2014?null:"heal"}get activity(){return this.is2014?null:{activationType:"reaction",targetType:"self",data:{healing:DDBEnricherData.basicDamagePart({customFormula:"@classes.sorcerer.levels",types:["healing"]})}}}get override(){return{midiManualReaction:!0}}}class StrideOfTheElements extends DDBEnricherData{get effects(){return[this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.fly"),this.movementChange("@attributes.movement.walk",20,"system.attributes.movement.swim")]}}class StunningStrike extends DDBEnricherData{get type(){return"save"}get activity(){return{targetType:"creature",activationType:"special",data:{"range.units":"touch",save:{ability:["con"],dc:{calculation:"wis",formula:""}}}}}}class SuperiorDefense extends DDBEnricherData{get effects(){return[{options:{durationSeconds:60},changes:DDBEnricherData.allDamageTypes(["force"]).map((e=>DDBEnricherData.ChangeHelper.unsignedAddChange(e,20,"system.traits.dr.value")))}]}get clearAutoEffects(){return!0}}class TongueOfTheSunAndMoon extends DDBEnricherData{get effects(){return[{options:{transfer:!0},changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("standard:*",20,"system.traits.languages.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("exotic:*",20,"system.traits.languages.value"),DDBEnricherData.ChangeHelper.unsignedAddChange("ddb:*",10,"system.traits.languages.value")]}]}}class UncannyMetabolism extends DDBEnricherData{get type(){return"heal"}get activity(){return{targetType:"self",rangeSelf:!0,addItemConsume:!0,itemConsumeValue:"-@scale.monk.focus-points",additionalConsumptionTargets:[{type:"itemUses",target:"",value:"1",scaling:{mode:"",formula:""}}]}}get override(){return{data:{"flags.ddbimporter":{retainChildUses:!0}}}}}class VisageOfTheAstralSelf extends DDBEnricherData{get addAutoAdditionalActivities(){return!0}get activity(){return{targetType:"self",rangeSelf:!0,data:{duration:{units:"minute",value:10}}}}get effects(){return[{options:{durationSeconds:360},changes:[DDBEnricherData.ChangeHelper.upgradeChange("120",20,"system.attributes.senses.truesight")],midiChanges:[DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"flags.midi-qol.advantage.skill.itm"),DDBEnricherData.ChangeHelper.unsignedAddChange("1",20,"flags.midi-qol.advantage.skill.ins")],atlChanges:[DDBEnricherData.ChangeHelper.overrideChange("truesight",20,"ATL.sight.visionMode"),DDBEnricherData.ChangeHelper.upgradeChange("120",20,"ATL.sight.range")],data:{flags:{dae:{selfTarget:!0,selfTargetAlways:!0}}}}]}}class WholenessOfBody extends DDBEnricherData{get type(){return"heal"}get activity(){const e=this.is2014?"3@classes.monk.levels":"@scale.monk.martial-arts.die + @abilities.wis.mod";return{targetType:"self",data:{healing:DDBEnricherData.basicDamagePart({customFormula:e,type:"healing"})}}}}class AbjureFoes extends DDBEnricherData{get activity(){return{type:"none"}}get additionalActivities(){return[{action:{name:"Channel Divinity: Abjure Foes",type:"class",rename:["Save vs Frightened"]}}]}}class AuraOfHate extends DDBEnricherData{get effects(){return[{name:"Aura of Hate (Self)",daeStackable:"none",data:{changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("+@abilities.cha.mod",20,"system.bonuses.mwak.damage")]},statuses:["Aura of Hate (Self)"],options:{transfer:!0}},{name:"Aura of Hate (Fiends and Undead)",activeAurasOnly:!0,daeStackable:"none",data:{flags:{ActiveAuras:{aura:"All",radius:"@scale.oathbreaker.aura-of-hate",isAura:!0,ignoreSelf:!0,inactive:!1,hidden:!1,displayTemp:!0,type:"undead; fiend"}}},statuses:["Aura of Hate (Fiends and Undead)"],changes:[DDBEnricherData.ChangeHelper.unsignedAddChange("+@abilities.cha.mod",20,"system.bonuses.mwak.damage")],options:{transfer:!0}}]}}class AvengingAngel extends DDBEnricherData{get activity(){return this.ddbParser.isAction?null:{name:"Activate",type:"utility",addItemConsume:!0,activationType:"bonus"}}get additionalActivities(){return this.ddbParser.isAction?[]:[{action:{name:"Avenging Angel",type:"class"}},{constructor:{name:"Spend Spell Slot to Restore Use",type:"utility"},build:{generateConsumption:!0,generateTarget:!0,generateActivation:!0,generateUtility:!0,activationOverride:{type:"none",value:null,condition:""},consumptionOverride:{targets:[{type:"itemUses",target:"",value:-1,scaling:{mode:"",formula:""}},{type:"spellSlots",value:"1",target:"5",scaling:{allowed:!1,max:""}}]}}}]}get effects(){return this.ddbParser.isAction?[]:[{name:"Avenging Angel (Wings)",options:{durationSeconds:600},data:{"flags.ddbimporter.activitiesMatch":["Activate"]},changes:[DDBEnricherData.ChangeHelper.upgradeChange("60",2,"system.attributes.speed.fly")]}]}get override(){return{data:{name:"Avenging Angel","system.uses":this._getUsesWithSpent({type:"class",name:"Avenging Angel",max:"1",period:"lr"})}}}get clearAutoEffects(){return!0}}class ElderChampion extends DDBEnricherData{get activity(){return{name:"Activate Elder Champion",type:"utility",addItemConsume:!0,activationType:"bonus"}}get additionalActivities(){return[{constructor:{name:"Regain HP",type:"heal"},build:{generateActivation:!0,generateTarget:!0,generateHealing:!0,healingPart:DDBEnricherData.basicDamagePart({bonus:"10",type:"healing"})},overrides:{data:{targetType:"self",activationType:"special",condition:"Start of your turn"}}},{constructor:{name:"Spend Spell Slot to Restore Use",type:"utility"},build:{generateConsumption:!0,generateTarget:!0,generateActivation:!0,generateUtility:!0,activationOverride:{type:"none",value:null,condition:""},consumptionOverride:{targets:[{type:"itemUses",target:"",value:-1,scaling:{mode:"",formula:""}},{type:"spellSlots",value:"1",target:"5",scaling:{allowed:!1,max:""}}]}}}]}get override(){return{data:{"system.uses":this._getUsesWithSpent({type:"class",name:"Imbue Aura of Protection",max:"1",period:"lr"})}}}get effects(){return[{name:"Diminish Defiance",options:{description:"Enemies in the aura have Disadvantage on saving throws against your spells and Channel Divinity options."},data:{"flags.ddbimporter.activitiesMatch":["Activate Elder Champion"]}}]}}class EmbodyLegends extends DDBEnricherData{get activity(){return{name:"Reroll Saving Throw",type:"utility",targetType:"self",activationType:"reaction",noConsumeTargets:!0}}get additionalActivities(){return[{constructor:{name:"Spend Spell Slot to Restore Use",type:"utility"},build:{generateConsumption:!0,generateTarget:!0,generateActivation:!0,generateUtility:!0,activationOverride:{type:"none",value:null,condition:""},consumptionOverride:{targets:[{type:"itemUses",target:"",value:-1,scaling:{mode:"",formula:""}},{type:"spellSlots",value:"1",target:"5",scaling:{allowed:!1,max:""}}]}}}]}}class GloriousDefense extends DDBEnricherData{get activity(){return{data:{roll:{prompt:!1,visible:!1,formula:"@abilities.cha.mod",name:"Bonus to attack"}}}}}class HolyNimbus extends DDBEnricherData{get activity(){return