import {initConfig} from "./config.js";
import {registerSettings} from "./settings.js";
import {RandomSoundController} from "./RandomSoundController.js";

export const MODULE_ID = "dynamic-soundscapes";

export const isActiveGM = () => game.users.activeGM === game.user;


Hooks.on("libWrapper.Ready", () => {
    libWrapper.register(MODULE_ID, "Playlist.prototype.playAll", async function (wrapped, ...args) { 
        const isSoundscape = this.folder?.name === "Soundscapes";
        if(isActiveGM() && isSoundscape) await ui.dynamicSoundscapes.setPlaylist(this.id);
        return await wrapped(...args);
    }, "WRAPPER");

    libWrapper.register(MODULE_ID, "Playlist.prototype.stopAll", async function (wrapped, ...args) { 
        const isCurrentSoundscape = ui.dynamicSoundscapes?.playingPlaylist === this;
        if(isActiveGM() && isCurrentSoundscape) await ui.dynamicSoundscapes.setPlaylist(null);
        return wrapped(...args);
    }, "WRAPPER");
});

Hooks.on("init", () => {
    initConfig();
    registerSettings();
});

Hooks.on("ready", () => {
    if (!isActiveGM()) return;
    const randomSoundController = new RandomSoundController();
    game.playlists.soundscapesRandomSoundController = randomSoundController;
});