import { MODULE_ID } from "../main.js";
import { Hexplorer } from "./Hexplorer.js";
import { HexplorerApp } from "../app/HexplorerApp.js";
import { getSetting, setSetting } from "../settings.js";
import { l } from "../lib/utils.js";

let enabled = false;


export function toggleActive(scene) {
    const hexplorerActive = scene.getFlag(MODULE_ID, "enabled");
    if(hexplorerActive && scene.grid.type === CONST.GRID_TYPES.GRIDLESS) ui.notifications.warn(l(`${MODULE_ID}.err.gridless`));
    if (hexplorerActive && scene.grid.type !== CONST.GRID_TYPES.GRIDLESS) {
        enableHexplorer(scene);
    } else {
        disableHexplorer(scene);
    }
}

export function enableHexplorer(scene) {
    if (enabled) disableHexplorer(scene);
    Hooks.on("renderSceneControls", onRenderSceneControls);
    Hooks.on("renderTokenConfig", onRenderTokenConfig);
    new Hexplorer(scene);
    ui.controls.initialize();
    enabled = true;
}

export function disableHexplorer(scene) {
    if (!enabled) return;
    canvas.hexplorer?.destroy();

    Hooks.off("renderSceneControls", onRenderSceneControls);
    Hooks.off("renderTokenConfig", onRenderTokenConfig);
    ui.controls.initialize();
    enabled = false;
}

function onRenderSceneControls(controls, b, c) {
    if (!game.user.isGM || !canvas.scene) return;
    const hexplorerActive = canvas.scene.getFlag(MODULE_ID, "enabled");
    if (!hexplorerActive) return;
    const mainControls = document.querySelector(".main-controls");
    if (!mainControls) return;
    const li = document.createElement("li");
    li.classList.add("scene-control");
    li.dataset.control = MODULE_ID;
    li.dataset.tooltip = "Hexplorer";
    li.innerHTML = `<i class="fas fa-compass"></i>`;
    li.addEventListener("click", async (e) => {
        e.preventDefault();
        new HexplorerApp(canvas.scene).render(true);
    });
    mainControls.appendChild(li);
}

export function onGetSceneControlButtons(controls, b, c) {
    if (!canvas.scene) return;
    const hexplorerActive = canvas.scene.getFlag(MODULE_ID, "enabled");
    if (!hexplorerActive) return;
    if (game.user.isGM || canvas.scene.getFlag(MODULE_ID, "config")?.showColor) {
        const tools = controls.find((x) => x["name"] == "token").tools;
        tools.push({
            active: getSetting("showColor"),
            icon: "fad fa-compass",
            name: "fog.showColor",
            title: `${MODULE_ID}.fog.showColor`,
            onClick: (toggle) => {
                setSetting("showColor", toggle);
            },
            toggle: true,
        });
    }
}

function onRenderTokenConfig(app, html, data) {
    const sceneEnabled = app.document.parent.getFlag(MODULE_ID, "enabled");
    if (!sceneEnabled) return;
    html = html[0] ?? html;
    const target = html.querySelector(`.tab[data-tab="character"]`);
    const checkbox = `
    <fieldset>
        <legend>Hexplorer</legend>
    <div class="form-group">
            <label for="flags.${MODULE_ID}.enabled">${l("hexplorer.token.enable.name")}</label>
            <input type="checkbox" name="flags.${MODULE_ID}.enabled" ${app.document.flags[MODULE_ID]?.enabled ? "checked" : ""}>
    </div>
    <div class="form-group">
        <label for="flags.${MODULE_ID}.revealRadius">${l("hexplorer.token.revealRadius.name")}</label>
        <input type="number" name="flags.${MODULE_ID}.revealRadius" value="${app.document.flags[MODULE_ID]?.revealRadius ?? 0}">
        <p class="notes">${l("hexplorer.token.revealRadius.hint")}</p>
    </div>
    <div class="form-group">
        <label for="flags.${MODULE_ID}.speed">${l("hexplorer.token.speed.name")}<span class="units"> (${app.document.parent.grid.units}/h)</span></label>
        
        <input type="number" name="flags.${MODULE_ID}.speed" value="${app.document.flags[MODULE_ID]?.speed ?? 0}">
        <p class="notes">${l("hexplorer.token.speed.hint")}</p>
    </div>
    </fieldset>
    `;
    target.insertAdjacentHTML("beforeend", checkbox);
    app.setPosition({ height: "auto" });
}
