Hooks.once("init", function () {
  /*libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onHoverIn",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onHoverOut",
    ignoreInteractivity,
    "MIXED"
  );*/
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onClickLeft",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onClickLeft2",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onClickRight2",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onDragLeftStart",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onDragLeftMove",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onDragLeftDrop",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._onDragLeftCancel",
    ignoreInteractivity,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype.refresh",
    onRefresh,
    "WRAPPER"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._canControl",
    canControl,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype._canHover",
    canHover,
    "MIXED"
  );
  libWrapper.register(
    "inactive-tokens-lmao",
    "Token.prototype.setTarget",
    ignoreTarget,
    "MIXED"
  );
  function ignoreInteractivity(wrapped, ...args) {
    if (this.document.flags["inactive-tokens-lmao"]?.isInactive){
      if(this.cursor !== "default") this._originalCursor = this.cursor;
      this.cursor = "default";
       return false;
    }
    this.cursor = this._originalCursor ?? this.cursor;
    return wrapped(...args);
  }

  function ignoreTarget(wrapped, ...args) {
    if (this.document.flags["inactive-tokens-lmao"]?.isInactive && args[0]){
      if(this.cursor !== "default") this._originalCursor = this.cursor;
      this.cursor = "default";
       return false;
    }
    this.cursor = this._originalCursor ?? this.cursor;
    return wrapped(...args);
  }

  function canControl(wrapped, ...args) {
    if (this.document.flags["inactive-tokens-lmao"]?.isInactive) {
      return false;
    } else {
      return wrapped(...args);
    }
  }

  function canHover(wrapped, ...args) {
    if (!game?.user?.isGM && this.document.flags["inactive-tokens-lmao"]?.isInactive) {
      return false;
    } else {
      return wrapped(...args);
    }
  }

  function onRefresh(wrapped, ...args) {
    wrapped(...args);
    if (!game?.user?.isGM && this.document.flags["inactive-tokens-lmao"]?.isInactive) {
      this.interactive = false;
      this.zIndex = -10000;
    } else {
      this.interactive = true;
    }
  }

  Hooks.on("refreshToken", (token) => {
    if (!game?.user?.isGM && token.document.flags["inactive-tokens-lmao"]?.isInactive) {
      token.interactive = false;
      token.zIndex = -10000;
    } else {
      token.interactive = true;
    }
  });

  Hooks.on("updateCombatant", (combatant, updateData) => {
    if(game.user.isGM && updateData.defeated != undefined && game.settings.get("inactive-tokens-lmao", "autoDefeated")){
      combatant.token.update({flags: {"inactive-tokens-lmao": {isInactive: updateData.defeated}}});
      combatant.token.object?.setTarget(false);
    }
  });

  Hooks.on("updateToken", (token, updateData) => {
    try {   
      if (updateData?.flags && updateData?.flags["inactive-tokens-lmao"]?.isInactive !== undefined)
        token.object.refresh();
        if(updateData?.flags["inactive-tokens-lmao"]?.isInactive && token.object.targeted.has(game.user)) token.object.setTarget(false, {releaseOthers: false});
    }catch(e){}
  });
});
