import {JournalPopout, setClassesCache} from "./app/app.js";
import { MODULE_ID } from "./main.js";

export function initConfig() {
    Hooks.on("renderJournalSheet", (app, html, data) => {
        setClassesCache(app.element[0].classList);
        const controlsContainer = html[0].querySelector(".journal-header");
        controlsContainer.style.position = "relative";
        const popoutButton = document.createElement("a");
        popoutButton.classList.add("popout");
        popoutButton.innerHTML = `<i class="fas fa-external-link-alt"></i>`;
        controlsContainer.appendChild(popoutButton);
        popoutButton.addEventListener("click", () => {
            const page = app.document.pages.get(app.pagesInView[0]?.dataset.pageId);
            const classes = app.element[0].classList;
            new JournalPopout(page, classes).render(true);
        });
    });

    document.addEventListener("mousedown", function (event) {
        if(event.button !== 1 && !event.shiftKey) return;
        const cl = event.target.closest(".content-link");
        if (!cl || cl.dataset.type !== "JournalEntryPage") return;
        event.preventDefault();
        event.stopPropagation();
        return false;
    });


    document.addEventListener("mouseup", async (event) => {
        const cl = event.target.closest(".content-link");

        if (!cl || cl.dataset.type !== "JournalEntryPage") return;
        const isMiddle = event.button === 1;
        const isLeftClickShift = event.button === 0 && event.shiftKey;
        const isRightClick = event.button === 2;
        if(!isMiddle && !isLeftClickShift && !isRightClick) return;
        event.preventDefault();
        event.stopPropagation();
        const page = await fromUuid(cl.dataset.uuid);
        const inJournalSheet = event.target.closest(".journal-sheet");
        const classes = inJournalSheet ? inJournalSheet.classList : null;
        new JournalPopout(page, classes).render(true);
        return false;
    });

}