import {LightSwitch} from './lightSwitch.js';
import { Socket } from './lib/socket.js';

export const MODULE_ID = "light-switch";

Hooks.once('init', async function () {

  Socket.register("toggleLight", LightSwitch.toggleLight);


  ControlsLayer.prototype.drawLightswitches = function() {
      {

          // Create the container
          if ( this.lightSwitches ) this.lightSwitches.destroy({children: true});
          this.lightSwitches = this.addChild(new PIXI.Container());
      
          // Iterate over all walls, selecting the doors
          for ( let l of canvas.lighting.placeables ) {
            this.createLightSwitch(l);
          }
      
          // Toggle visibility for the set of door control icons
          //this.doors.visible = !canvas.walls._active;
        }
  }

  ControlsLayer.prototype.createLightSwitch = function(light) {
      const lc = this.lightSwitches.addChild(new LightSwitch(light));
      lc.visible = false;
      return lc.draw();
    }

  libWrapper.register("light-switch", "ControlsLayer.prototype.draw", LightSwitch.drawLightswitches)
  libWrapper.register("light-switch", "CanvasVisibility.prototype.restrictVisibility", LightSwitch.restrictVisibility)
  libWrapper.register("light-switch", "AmbientLight.prototype._onDelete", function _onDelete(wrapped,...args) {
    this.lightSwitch?.destroy();
    wrapped(...args);
  })
  
});

Hooks.on('renderLightConfig', injeectLightSwitchConfig);
Hooks.on('renderAmbientLightConfig', injeectLightSwitchConfig);

function injeectLightSwitchConfig(app,html){
  const isLighswitch = app.document.getFlag("light-switch", "isLighswitch") ?? false;
  const isLighswitchimg = app.document.getFlag("light-switch", "img") ?? "";
const lsCheck = `
  <fieldset>
    <legend>Lightswitch</legend>
  <div class="form-group">
          <label>Is Lightswitch?</label>
          <div class="form-fields">
              <input type="checkbox" name="flags.light-switch.isLighswitch" ${isLighswitch ? "checked" : ""}>
          </div>
      </div>

      <div class="form-group">
      <label for="flags.light-switch.img">Lightswitch Image</label>
      <div class="form-fields">
      <file-picker name="flags.light-switch.img" type="imagevideo" value="${isLighswitchimg}"></file-picker>
      </div>
  </div>
  </fieldset>
  `
  html.querySelector(`.tab[data-tab="advanced"] fieldset:last-child`).insertAdjacentHTML('afterend', lsCheck);
  app.setPosition({height: "auto"});

}


Hooks.on("updateAmbientLight", (ambientLight) => {
  if(!ambientLight.object.lightSwitch)canvas.controls.createLightSwitch(ambientLight.object);
    ambientLight.object.lightSwitch.draw();
});

