Hooks.once('init', function() {
    ui.macroWheel = new MacroWheel();
    document.addEventListener("mousemove", (event) => {
        ui.macroWheel.clientX = event.clientX;
        ui.macroWheel.clientY = event.clientY;
    });
    document.addEventListener("click", (event) => {
        if(ui.macroWheel.rendered && !event.ctrlKey){
            const closeOnClick = game.settings.get("macro-wheel", "closeOnClick");
            if(event.target.classList.contains("macro-item") && !closeOnClick) return;
            ui.macroWheel.close();
        }
    });
    game.keybindings.register("macro-wheel", "openWheel", {
        name: game.i18n.localize("macro-wheel.bindings.open.name"),
        editable: [
          {key: "KeyM"}
        ],
        onDown: () => {
        },
        onUp: (e) => {
            if(ui.macroWheel.rendered) ui.macroWheel.close();
            else ui.macroWheel.render(true);
        },
    });


    game.settings.register("macro-wheel", "folderSize", {
        name: game.i18n.localize("macro-wheel.settings.folderSize.name"),
        hint: game.i18n.localize("macro-wheel.settings.folderSize.hint"),
        scope: "client",
        config: true,
        type: Number,
        default: 40,
      });

      game.settings.register("macro-wheel", "macroSize", {
        name: game.i18n.localize("macro-wheel.settings.macroSize.name"),
        hint: game.i18n.localize("macro-wheel.settings.macroSize.hint"),
        scope: "client",
        config: true,
        type: Number,
        default: 30,
      });

      game.settings.register("macro-wheel", "hoverDelay", {
        name: game.i18n.localize("macro-wheel.settings.hoverDelay.name"),
        hint: game.i18n.localize("macro-wheel.settings.hoverDelay.hint"),
        scope: "client",
        config: true,
        type: Number,
        default: 50,
      });

      game.settings.register("macro-wheel", "useMiddleMouse", {
        name: game.i18n.localize("macro-wheel.settings.useMiddleMouse.name"),
        hint: game.i18n.localize("macro-wheel.settings.useMiddleMouse.hint"),
        scope: "client",
        config: true,
        type: Boolean,
        default: true,
        requiresReload: true,
      });

      if(game.settings.get("macro-wheel", "useMiddleMouse")){
        document.addEventListener("mousedown", (event) => {
          if(event.button === 1){
            ui.macroWheel._middleMouseDown = true;
            setTimeout(() => {
              ui.macroWheel._middleMouseDown = false;
            }, 200);
          }
        });

        document.addEventListener("mouseup", (event) => {
          if(event.button === 1 && ui.macroWheel._middleMouseDown){
            ui.macroWheel._middleMouseDown = false;
            if(ui.macroWheel.rendered) ui.macroWheel.close();
            else ui.macroWheel.render(true);
          }
        });
      }

      game.settings.register("macro-wheel", "closeOnClick", {
        name: game.i18n.localize("macro-wheel.settings.closeOnClick.name"),
        hint: game.i18n.localize("macro-wheel.settings.closeOnClick.hint"),
        scope: "client",
        config: true,
        type: Boolean,
        default: true,
      });

      game.settings.register("macro-wheel", "enableTooltips", {
        name: game.i18n.localize("macro-wheel.settings.enableTooltips.name"),
        hint: game.i18n.localize("macro-wheel.settings.enableTooltips.hint"),
        scope: "client",
        config: true,
        type: Boolean,
        default: true,
      });

      game.settings.register("macro-wheel", "addHotbar", {
        name: game.i18n.localize("macro-wheel.settings.addHotbar.name"),
        hint: game.i18n.localize("macro-wheel.settings.addHotbar.hint"),
        scope: "client",
        config: true,
        type: Boolean,
        default: true,
      });

      game.settings.register("macro-wheel", "collapseHotbar", {
        name: game.i18n.localize("macro-wheel.settings.collapseHotbar.name"),
        hint: game.i18n.localize("macro-wheel.settings.collapseHotbar.hint"),
        scope: "client",
        config: true,
        type: Boolean,
        default: false,
      });

      game.settings.register("macro-wheel", "useRoot", {
        name: game.i18n.localize("macro-wheel.settings.useRoot.name"),
        hint: game.i18n.localize("macro-wheel.settings.useRoot.hint"),
        scope: "client",
        config: true,
        type: Boolean,
        default: false,
      });
      
});

Hooks.once("renderHotbar", () => {
  if(game.settings.get("macro-wheel", "collapseHotbar")) document.getElementById("bar-toggle").click();
})

Hooks.on("renderFolderConfig", (app, html, data) => {
    if(app.object.type !== "Macro") return;
    const folderImg = app.object.getFlag("macro-wheel", "folderImg") ?? "icons/svg/d20-grey.svg";
    const condition = app.object.getFlag("macro-wheel", "condition") ?? "";
    const presetCondition = app.object.getFlag("macro-wheel", "presetCondition") ?? "";

    const presetConditions = [
      {
        name: "custom",
        value: "",
      },
      {
        name: "tokens",
        value: "canvas.activeLayer === canvas.tokens",
      },
      {
        name: "tiles",
        value: "canvas.activeLayer === canvas.tiles",
      },
      {
        name: "walls",
        value: "canvas.activeLayer === canvas.walls",
      },
      {
        name: "sounds",
        value: "canvas.activeLayer === canvas.sounds",
      },
      {
        name: "lights",
        value: "canvas.activeLayer === canvas.lighting",
      },
      {
        name: "notes",
        value: "canvas.activeLayer === canvas.notes",
      },
      {
        name: "drawings",
        value: "canvas.activeLayer === canvas.drawings",
      },
      {
        name: "templates",
        value: "canvas.activeLayer === canvas.templates",
      },
      {
        name: "selectedtoken",
        value: "canvas.tokens.controlled.length > 0",
      },
      {
        name: "combat",
        value: "game.combat?.active",
      },
      {
        name: "enabled3d",
        value: "game.Levels3DPreview?._active",
      },
    ];

    let presetConditionsHtml = "";
    for(let presetConditionData of presetConditions){
      presetConditionsHtml += `<option ${presetConditionData.value == presetCondition ? 'selected=""' : ""} value="${presetConditionData.value}">${game.i18n.localize(`macro-wheel.flags.presetCondition.options.${presetConditionData.name}`)}</option>`;
    }

    const imageInput = $(`
    <h3 class="form-header"><i class="fa-regular fa-dharmachakra"></i> ${game.i18n.localize("macro-wheel.flags.header")}</h3>
    <div class="form-group">
            <label for="flags.macro-wheel.folderImg">${game.i18n.localize("macro-wheel.flags.folderImg.name")}</label>
            <div class="form-fields">
                
    <button type="button" class="file-picker" data-type="imagevideo" data-target="flags.macro-wheel.folderImg" title="Browse Files" tabindex="-1">
        <i class="fas fa-file-import fa-fw"></i>
    </button>
                <input class="image" type="text" name="flags.macro-wheel.folderImg" placeholder="path/image.png" value="${folderImg}">
            </div>
        </div>

        <div class="form-group">
        <label>${game.i18n.localize("macro-wheel.flags.presetCondition.name")}</label>
        <div class="form-fields">
            <select name="flags.macro-wheel.presetCondition">
                ${presetConditionsHtml}
            </select>
        </div>
    </div>


        <div class="form-group">
        <label>${game.i18n.localize("macro-wheel.flags.condition.name")}</label>
        <div class="form-fields">
            <input type="text" name="flags.macro-wheel.condition" placeholder="${game.i18n.localize("macro-wheel.flags.condition.placeholder")}" value="${condition}" autofocus="">
        </div>
    </div>
    <hr>
    `)

    html.find(`[name="color"]`).closest(".form-group").after(imageInput);
    app.activateListeners(app.element);
    app.setPosition({height: "auto"});
});

Hooks.on("renderMacroConfig", (app, html, data) => { 
  if(!game.user.isGM) return;
  const activeCondition = app.object.getFlag("macro-wheel", "activeCondition") ?? "";
  const activeConditionInput = $(`
  <div class="form-group">
        <label>Macro Wheel Condition</label>
        <input type="text" value="${activeCondition}" name="flags.macro-wheel.activeCondition">
    </div>
  `);
  html.find(`select[name="type"]`).closest(".form-group").after(activeConditionInput);
});