import { upload } from "./optimizer.js";
import { TileCombiner } from "./TileCombiner.js";
import {FileConverter} from "./Converter.js";
import { BloatDetector } from "./bloatDetector.js";

export const MODULE_ID = "media-optimizer";

Hooks.on("ready", () => {

    window.MediaOptimizer = {
        BloatDetector,
    };

    libWrapper.register(MODULE_ID, "FilePicker.upload", upload, "WRAPPER");

    game.settings.registerMenu(MODULE_ID, "bloatDetector", {
        name: "media-optimizer.settings.bloatDetector.name",
        label: "media-optimizer.settings.bloatDetector.label",
        hint: "media-optimizer.settings.bloatDetector.hint",
        icon: "fa-duotone fa-database",
        type: BloatDetector,
        restricted: true,
    });

    game.settings.register(MODULE_ID, "enabled", {
        name: "media-optimizer.settings.enabled.name",
        hint: "media-optimizer.settings.enabled.hint",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
    });

    game.settings.register(MODULE_ID, "compressionRatio", {
        name: "media-optimizer.settings.compressionRatio.name",
        hint: "media-optimizer.settings.compressionRatio.hint",
        scope: "world",
        config: true,
        type: Number,
        default: 0.75,
        range: {
            min: 0.1,
            max: 1,
            step: 0.05,
        },
    });

    game.settings.register(MODULE_ID, "maxResolution", {
        name: "media-optimizer.settings.maxResolution.name",
        hint: "media-optimizer.settings.maxResolution.hint",
        scope: "world",
        config: true,
        type: Number,
        default: 8192,
        choices: {
            1024: "media-optimizer.settings.maxResolution.choices.1024",
            2048: "media-optimizer.settings.maxResolution.choices.2048",
            4096: "media-optimizer.settings.maxResolution.choices.4096",
            8192: "media-optimizer.settings.maxResolution.choices.8192",
            16384: "media-optimizer.settings.maxResolution.choices.16384",
        },
    });

    game.settings.register(MODULE_ID, "excludeFolders", {
        name: "media-optimizer.settings.excludeFolders.name",
        hint: "media-optimizer.settings.excludeFolders.hint",
        scope: "world",
        config: true,
        type: String,
        default: "",
    });

    game.settings.register(MODULE_ID, "optimizeImages", {
        name: "media-optimizer.settings.optimizeImages.name",
        hint: "media-optimizer.settings.optimizeImages.hint",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
    });

    game.settings.register(MODULE_ID, "optimizeAudio", {
        name: "media-optimizer.settings.optimizeAudio.name",
        hint: "media-optimizer.settings.optimizeAudio.hint",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
    });

    game.settings.register(MODULE_ID, "optimizeVideo", {
        name: "media-optimizer.settings.optimizeVideo.name",
        hint: "media-optimizer.settings.optimizeVideo.hint",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
    });

    game.settings.register(MODULE_ID, "slugifyFileNames", {
        name: "media-optimizer.settings.slugifyFileNames.name",
        hint: "media-optimizer.settings.slugifyFileNames.hint",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
    });

    game.settings.register(MODULE_ID, "combinerSettings", {
        scope: "world",
        config: false,
        type: Object,
        default: {},
    });
});

Hooks.on("getSceneControlButtons", (buttons) => {
    buttons
        .find((b) => b.name === "tiles")
        ?.tools?.push({
            name: "tile-combiner",
            title: game.i18n.localize(`${MODULE_ID}.tile-combiner.title`),
            icon: "fas fa-compress",
            button: true,
            visible: true,
            onClick: () => {
                new TileCombiner().render(true);
            },
        });
});

Hooks.on("getFilePickerHeaderButtons", (app, buttons) => {
        buttons.unshift({
            class: "file-converter",
            icon: "fas fa-compress",
            label: game.i18n.localize(`${MODULE_ID}.file-converter.header-button`),
            onclick: () => {
                new FileConverter(app.result.files,app.result.target).render(true);
            },
        });
});
