/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/main/classes/ConfirmActivateProfileForm.ts":
/*!********************************************************!*\
  !*** ./src/main/classes/ConfirmActivateProfileForm.ts ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConfirmActivateProfileForm)
/* harmony export */ });
/* harmony import */ var _scripts_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scripts/settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _scripts_profile_interactions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scripts/profile-interactions */ "./src/main/scripts/profile-interactions.ts");
/* harmony import */ var _scripts_settings_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../scripts/settings-utils */ "./src/main/scripts/settings-utils.ts");



/**
 * A FormApplication to be rendered when you want a user's confirmation that yes, in fact, they *do* want to activate said profile.
 */
class ConfirmActivateProfileForm extends FormApplication {
    constructor(profileNameToActivate, object = {}, options = {}) {
        super(object, options);
        this.profileNameToActivate = profileNameToActivate;
    }
    static get defaultOptions() {
        const parent = super.defaultOptions;
        const parentClasses = parent?.classes ?? [];
        return {
            ...parent,
            classes: [...parentClasses, 'module-profiles-form'],
            id: 'module-profiles-confirm-activate-profile',
            template: `${_scripts_settings_utils__WEBPACK_IMPORTED_MODULE_2__.TEMPLATES_PATH}/confirm-activate-profile.hbs`,
            title: 'Confirm Activate Profile',
            width: 660
        };
    }
    getData() {
        return {
            profileNameToActivate: this.profileNameToActivate,
            activeProfileName: _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.getActiveProfile().name
        };
    }
    async _updateObject(event) {
        if (event?.submitter?.id === 'moduleProfilesActivateProfileSubmit') {
            _scripts_profile_interactions__WEBPACK_IMPORTED_MODULE_1__.activateProfile(this.profileNameToActivate, true);
        }
    }
}


/***/ }),

/***/ "./src/main/classes/ConfirmDeleteProfileForm.ts":
/*!******************************************************!*\
  !*** ./src/main/classes/ConfirmDeleteProfileForm.ts ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ConfirmDeleteProfileForm)
/* harmony export */ });
/* harmony import */ var _scripts_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scripts/settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _scripts_settings_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scripts/settings-utils */ "./src/main/scripts/settings-utils.ts");


/**
 * A FormApplication to be rendered when you want a user's confirmation that yes, in fact, they *do* want to delete said profile.
 */
class ConfirmDeleteProfileForm extends FormApplication {
    constructor(profileNameToDelete, object = {}, options = {}) {
        super(object, options);
        this.profileNameToDelete = profileNameToDelete;
    }
    static get defaultOptions() {
        const parent = super.defaultOptions;
        const parentClasses = parent?.classes ?? [];
        return {
            ...parent,
            classes: [...parentClasses, 'module-profiles-form'],
            id: 'module-profiles-confirm-delete-profile',
            template: `${_scripts_settings_utils__WEBPACK_IMPORTED_MODULE_1__.TEMPLATES_PATH}/confirm-delete-profile.hbs`,
            title: 'Confirm Delete Profile',
            width: 660
        };
    }
    getData() {
        return {
            profileNameToDelete: this.profileNameToDelete
        };
    }
    // TODO - bug, name for button on module management does not update when active profile name switches
    async _updateObject(event) {
        if (event?.submitter?.id === 'moduleProfilesDeleteProfileSubmit') {
            return await _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.deleteProfile(this.profileNameToDelete);
        }
    }
}


/***/ }),

/***/ "./src/main/classes/CreateModuleProfileForm.ts":
/*!*****************************************************!*\
  !*** ./src/main/classes/CreateModuleProfileForm.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ CreateModuleProfileForm)
/* harmony export */ });
/* harmony import */ var _scripts_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scripts/settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _scripts_settings_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scripts/settings-utils */ "./src/main/scripts/settings-utils.ts");


/**
 * A FormApplication that allows a user to create a new module profile.
 */
class CreateModuleProfileForm extends FormApplication {
    constructor(object = {}, options = {}) {
        super(object, options);
    }
    static get defaultOptions() {
        const parent = super.defaultOptions;
        const parentClasses = parent?.classes ?? [];
        return {
            ...parent,
            classes: [...parentClasses, 'module-profiles-form'],
            id: 'module-profiles-create-module-profile',
            template: `${_scripts_settings_utils__WEBPACK_IMPORTED_MODULE_1__.TEMPLATES_PATH}/create-module-profile.hbs`,
            title: 'Create New Module Profile',
            width: 660
        };
    }
    activateListeners(html) {
        if (html) {
            super.activateListeners(html);
        }
        document.getElementById('moduleProfilesCreateNewProfileName').focus();
    }
    async _updateObject(event, formData) {
        if (event?.submitter?.id === 'moduleProfilesCreateNewProfileSubmit') {
            return await _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.createProfile(formData.moduleProfilesCreateNewProfileName, _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.getCurrentModuleConfiguration());
        }
    }
}


/***/ }),

/***/ "./src/main/classes/EditModuleProfileForm.ts":
/*!***************************************************!*\
  !*** ./src/main/classes/EditModuleProfileForm.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ EditModuleProfileForm)
/* harmony export */ });
/* harmony import */ var _scripts_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scripts/settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _scripts_mapping_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scripts/mapping-utils */ "./src/main/scripts/mapping-utils.ts");
/* harmony import */ var _scripts_settings_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../scripts/settings-utils */ "./src/main/scripts/settings-utils.ts");



/**
 * A FormApplication that allows a user to edit a module profile.
 */
class EditModuleProfileForm extends FormApplication {
    constructor(profileName, object = {}, options = {}) {
        super(object, options);
        this.profileName = profileName;
    }
    static get defaultOptions() {
        const parent = super.defaultOptions;
        const parentClasses = parent?.classes ?? [];
        return {
            ...parent,
            classes: [...parentClasses, 'module-profiles-form'],
            id: 'module-profiles-edit-module-profile',
            resizable: true,
            template: `${_scripts_settings_utils__WEBPACK_IMPORTED_MODULE_2__.TEMPLATES_PATH}/edit-module-profile.hbs`,
            title: 'Edit Module Profile',
            width: 450
        };
    }
    getData() {
        const profile = _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.getProfileByName(this.profileName);
        if (!profile) {
            const errorMessage = `Unable to load profile "${this.profileName}". Please close the window and try again.`;
            ui.notifications.error(errorMessage);
            throw new Error(errorMessage);
        }
        return profile;
    }
    async _updateObject(event, formData) {
        if (event?.submitter?.id === 'moduleProfilesEditProfileSubmit') {
            return await _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.saveChangesToProfile(this.profileName, _scripts_mapping_utils__WEBPACK_IMPORTED_MODULE_1__.mapToModuleInfos(formData));
        }
    }
}


/***/ }),

/***/ "./src/main/classes/ImportModuleProfileForm.ts":
/*!*****************************************************!*\
  !*** ./src/main/classes/ImportModuleProfileForm.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ ImportModuleProfileForm)
/* harmony export */ });
/* harmony import */ var _scripts_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scripts/settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _scripts_settings_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scripts/settings-utils */ "./src/main/scripts/settings-utils.ts");


class ImportModuleProfileForm extends FormApplication {
    constructor(object = {}, options = {}) {
        super(object, options);
    }
    static get defaultOptions() {
        const parent = super.defaultOptions;
        const parentClasses = parent?.classes ?? [];
        return {
            ...parent,
            classes: [...parentClasses, 'module-profiles-form'],
            id: 'module-profiles-import-module-profile',
            template: `${_scripts_settings_utils__WEBPACK_IMPORTED_MODULE_1__.TEMPLATES_PATH}/import-module-profile.hbs`,
            title: 'Import Module Profile(s)',
            height: 800,
            width: 660
        };
    }
    async _updateObject(event, formData) {
        if (event?.submitter?.id === 'moduleProfilesImportProfileSubmit') {
            return _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.importProfiles(formData['import-module-profile-text']);
        }
    }
}


/***/ }),

/***/ "./src/main/classes/ManageModuleProfilesSettingsForm.ts":
/*!**************************************************************!*\
  !*** ./src/main/classes/ManageModuleProfilesSettingsForm.ts ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MODULE_PROFILES_UPDATED_HOOK_NAME": () => (/* binding */ MODULE_PROFILES_UPDATED_HOOK_NAME),
/* harmony export */   "RENDER_HOOK_NAME": () => (/* binding */ RENDER_HOOK_NAME),
/* harmony export */   "default": () => (/* binding */ ManageModuleProfilesSettingsForm),
/* harmony export */   "forceManageModuleProfilesHeightResize": () => (/* binding */ forceManageModuleProfilesHeightResize),
/* harmony export */   "reRenderManageModuleProfilesWindows": () => (/* binding */ reRenderManageModuleProfilesWindows)
/* harmony export */ });
/* harmony import */ var _scripts_settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../scripts/settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _scripts_profile_interactions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../scripts/profile-interactions */ "./src/main/scripts/profile-interactions.ts");
/* harmony import */ var _scripts_browser_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../scripts/browser-utils */ "./src/main/scripts/browser-utils.ts");
/* harmony import */ var _CreateModuleProfileForm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CreateModuleProfileForm */ "./src/main/classes/CreateModuleProfileForm.ts");
/* harmony import */ var _ConfirmDeleteProfileForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./ConfirmDeleteProfileForm */ "./src/main/classes/ConfirmDeleteProfileForm.ts");
/* harmony import */ var _EditModuleProfileForm__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./EditModuleProfileForm */ "./src/main/classes/EditModuleProfileForm.ts");
/* harmony import */ var _ImportModuleProfileForm__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ImportModuleProfileForm */ "./src/main/classes/ImportModuleProfileForm.ts");
/* harmony import */ var _scripts_settings_utils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../scripts/settings-utils */ "./src/main/scripts/settings-utils.ts");








const RENDER_HOOK_NAME = 'renderManageModuleProfilesSettingsForm';
const MODULE_PROFILES_UPDATED_HOOK_NAME = 'moduleProfilesUpdated';
/**
 * A FormApplication that provides an interface for a user to manage module profiles.
 */
class ManageModuleProfilesSettingsForm extends FormApplication {
    constructor(object = {}, options = {}) {
        super(object, options);
    }
    static get defaultOptions() {
        const parent = super.defaultOptions;
        const parentClasses = parent?.classes ?? [];
        return {
            ...parent,
            classes: [...parentClasses, 'module-profiles-form'],
            id: this.FORM_ID,
            template: `${_scripts_settings_utils__WEBPACK_IMPORTED_MODULE_7__.TEMPLATES_PATH}/manage-profiles.hbs`,
            title: 'Manage Module Profiles',
            width: 660
        };
    }
    getData() {
        const activeProfileName = _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.getActiveProfile().name;
        const profilesWithActiveFlag = _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.getAllProfiles().map(profile => ({
            ...profile,
            isProfileActive: activeProfileName === profile.name
        }));
        return {
            profiles: profilesWithActiveFlag
        };
    }
    activateListeners(html) {
        if (html) {
            super.activateListeners(html);
        }
        const createNewProfileElement = document.getElementById('module-profiles-manage-profiles-create-new');
        createNewProfileElement?.addEventListener('click', () => new _CreateModuleProfileForm__WEBPACK_IMPORTED_MODULE_3__["default"]().render(true));
        const importProfileElement = document.getElementById('module-profiles-manage-profiles-import');
        importProfileElement?.addEventListener('click', (e) => {
            // Prevents window from automatically closing
            e.preventDefault();
            new _ImportModuleProfileForm__WEBPACK_IMPORTED_MODULE_6__["default"]().render(true);
        });
        const exportAllProfilesElement = document.getElementById('module-profiles-manage-profiles-export-all');
        exportAllProfilesElement?.addEventListener('click', async (e) => {
            // Prevents window from automatically closing
            e.preventDefault();
            const exportedProfiles = _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.exportAllProfiles();
            if (exportedProfiles) {
                await _scripts_browser_utils__WEBPACK_IMPORTED_MODULE_2__.copyToClipboard(exportedProfiles);
                ui.notifications.info(`All profiles have been copied to clipboard!`);
            }
        });
        const activateProfileElements = document.getElementsByClassName('module-profiles-activate-profile');
        Array.from(activateProfileElements).forEach(element => element.addEventListener('click', () => _scripts_profile_interactions__WEBPACK_IMPORTED_MODULE_1__.activateProfile(element.dataset.profileName)));
        const editProfileElements = document.getElementsByClassName('module-profiles-edit-profile');
        Array.from(editProfileElements).forEach(element => element.addEventListener('click', () => new _EditModuleProfileForm__WEBPACK_IMPORTED_MODULE_5__["default"](element.dataset.profileName).render(true)));
        const duplicateProfileElements = document.getElementsByClassName('module-profiles-duplicate-profile');
        Array.from(duplicateProfileElements).forEach(element => element.addEventListener('click', () => {
            const profile = _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.getProfileByName(element.dataset.profileName);
            if (profile) {
                return _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.createProfile(profile.name + ' (Copy)', profile.modules);
            }
        }));
        const exportProfileElements = document.getElementsByClassName('module-profiles-export-profile');
        Array.from(exportProfileElements).forEach(element => element.addEventListener('click', async () => {
            const profileName = element.dataset.profileName;
            const exportedProfile = _scripts_settings__WEBPACK_IMPORTED_MODULE_0__.exportProfileByName(profileName);
            if (exportedProfile) {
                await _scripts_browser_utils__WEBPACK_IMPORTED_MODULE_2__.copyToClipboard(exportedProfile);
                ui.notifications.info(`Profile "${profileName}" copied to clipboard!`);
            }
        }));
        const deleteProfileElements = document.getElementsByClassName('module-profiles-delete-profile');
        Array.from(deleteProfileElements).forEach((element) => element.addEventListener('click', () => new _ConfirmDeleteProfileForm__WEBPACK_IMPORTED_MODULE_4__["default"](element.dataset.profileName).render(true)));
    }
    async _updateObject() { }
}
ManageModuleProfilesSettingsForm.FORM_ID = 'module-profiles-manage-profiles';
/**
 * Re-renders the ManageModuleProfiles windows. This can be useful because profiles can be added/removed while the window is open, and re-rendering the
 * Application instance refreshes that data.
 * @returns {void}
 */
function reRenderManageModuleProfilesWindows() {
    Object.values(ui.windows)
        .filter(app => app.options.id === ManageModuleProfilesSettingsForm.FORM_ID)
        .forEach(app => app.render());
}
/**
 * Forces the application to refresh the size of its first element (aka, the window content). This is primarily to be used whenever an Application adds or
 * removes elements so that the height of the Application is consistent with what is added.
 * @param {Application} app - The Application that needs to be resized.
 * @returns {void}
 */
function forceManageModuleProfilesHeightResize(app) {
    if (app?.element?.length > 0) {
        app.element[0].style.height = 'auto';
    }
}


/***/ }),

/***/ "./src/main/scripts/api.ts":
/*!*********************************!*\
  !*** ./src/main/scripts/api.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "registerApi": () => (/* binding */ registerApi)
/* harmony export */ });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _settings_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./settings-utils */ "./src/main/scripts/settings-utils.ts");


/**
 * Registers the module's API. This is only meant to be called on initial game load.
 */
function registerApi() {
    const api = {
        getCurrentModuleConfiguration: _settings__WEBPACK_IMPORTED_MODULE_0__.getCurrentModuleConfiguration,
        getAllProfiles: _settings__WEBPACK_IMPORTED_MODULE_0__.getAllProfiles,
        getActiveProfile: _settings__WEBPACK_IMPORTED_MODULE_0__.getActiveProfile,
        getProfileByName: _settings__WEBPACK_IMPORTED_MODULE_0__.getProfileByName,
        exportAllProfiles: _settings__WEBPACK_IMPORTED_MODULE_0__.exportAllProfiles,
        exportProfileByName: _settings__WEBPACK_IMPORTED_MODULE_0__.exportProfileByName,
        createProfile: _settings__WEBPACK_IMPORTED_MODULE_0__.createProfile,
        importProfiles: _settings__WEBPACK_IMPORTED_MODULE_0__.importProfiles,
        activateProfile: _settings__WEBPACK_IMPORTED_MODULE_0__.activateProfile,
        saveChangesToProfile: _settings__WEBPACK_IMPORTED_MODULE_0__.saveChangesToProfile,
        deleteProfile: _settings__WEBPACK_IMPORTED_MODULE_0__.deleteProfile,
        resetProfiles: _settings__WEBPACK_IMPORTED_MODULE_0__.resetProfiles
    };
    _settings_utils__WEBPACK_IMPORTED_MODULE_1__.registerAPI(api);
}


/***/ }),

/***/ "./src/main/scripts/browser-utils.ts":
/*!*******************************************!*\
  !*** ./src/main/scripts/browser-utils.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "copyToClipboard": () => (/* binding */ copyToClipboard)
/* harmony export */ });
async function copyToClipboard(text) {
    try {
        if (navigator.clipboard) {
            await navigator.clipboard.writeText(text);
        }
        else {
            const tempTextArea = document.createElement('textarea');
            tempTextArea.value = text;
            tempTextArea.setAttribute('readonly', '');
            tempTextArea.style.position = 'absolute';
            tempTextArea.style.left = '-99999px';
            tempTextArea.style.top = '-99999px';
            document.body.appendChild(tempTextArea);
            tempTextArea.select();
            document.execCommand('copy');
            document.body.removeChild(tempTextArea);
        }
        return true;
    }
    catch (error) {
        ui.notifications.error('Unable to copy to clipboard. Please check console for details.');
        console.log(error);
        return false;
    }
}


/***/ }),

/***/ "./src/main/scripts/mapping-utils.ts":
/*!*******************************************!*\
  !*** ./src/main/scripts/mapping-utils.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "mapToModuleInfos": () => (/* binding */ mapToModuleInfos),
/* harmony export */   "mapToModuleKeyIsActiveRecord": () => (/* binding */ mapToModuleKeyIsActiveRecord)
/* harmony export */ });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/main/scripts/settings.ts");

/**
 * Maps an array of ModuleInfo objects into a Record, identical to how the core module configuration stores which modules are active and which aren't.
 * @param {ModuleInfo[]} moduleInfos
 * @return {Record<string, boolean>} - The corresponding Record representation of the inputted data.
 */
function mapToModuleKeyIsActiveRecord(moduleInfos) {
    const record = {};
    moduleInfos.forEach(module => record[module.id] = module.isActive);
    return record;
}
/**
 * Maps a Record into an array of matching ModuleInfo objects stored in the game settings.
 * @param {Record<string, boolean>} moduleIDIsActiveRecord
 * @return {ModuleInfo[]} - The corresponding array of ModuleInfo objects based on the inputted data.
 */
function mapToModuleInfos(moduleIDIsActiveRecord) {
    const moduleInfos = [];
    Object.entries(moduleIDIsActiveRecord).forEach(([key, value]) => {
        moduleInfos.push({
            id: key,
            title: findModuleTitleFromModuleId(key),
            isActive: value,
        });
    });
    moduleInfos.sort((a, b) => {
        if (!a.title) {
            return 1;
        }
        if (!b.title) {
            return -1;
        }
        return a.title.localeCompare(b.title);
    });
    return moduleInfos;
}
function findModuleTitleFromModuleId(moduleId) {
    const foundryVersion = _settings__WEBPACK_IMPORTED_MODULE_0__.getFoundryVersion();
    if (foundryVersion === _settings__WEBPACK_IMPORTED_MODULE_0__.FoundryVersion.v12) {
        // @ts-expect-error - Title is inlined in the module object in v12
        return game.modules.get(moduleId)?.title;
    }
    return game.modules.get(moduleId)?.data.title;
}


/***/ }),

/***/ "./src/main/scripts/profile-interactions.ts":
/*!**************************************************!*\
  !*** ./src/main/scripts/profile-interactions.ts ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "activateProfile": () => (/* binding */ activateProfile)
/* harmony export */ });
/* harmony import */ var _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ui/module-management-scripts */ "./src/main/scripts/ui/module-management-scripts.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _classes_ConfirmActivateProfileForm__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../classes/ConfirmActivateProfileForm */ "./src/main/classes/ConfirmActivateProfileForm.ts");



/**
 * Activates the module profile with the given name. If changes are detected on an open Module Management window and shouldForce is false, a
 * {@link ConfirmActivateProfileForm} will be rendered instead to prevent losing unfinished work.
 * @param {string} profileName - The name of the module profile to activate.
 * @param {boolean} [shouldForce=false] - When true, will activate the profile without checking if the user will lose any unsaved work.
 * @returns {Application} - The confirmation Application when the user has work that may be overridden.
 */
function activateProfile(profileName, shouldForce = false) {
    if (!profileName) {
        const errorMessage = 'Unable to activate profile. Profile name undefined.';
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    const activeProfile = _settings__WEBPACK_IMPORTED_MODULE_1__.getActiveProfile();
    if (!shouldForce && _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_0__.isModuleManagementWindowOpen() && _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_0__.unsavedChangesExistOn(activeProfile.name)) {
        return new _classes_ConfirmActivateProfileForm__WEBPACK_IMPORTED_MODULE_2__["default"](profileName).render(true);
    }
    else {
        _settings__WEBPACK_IMPORTED_MODULE_1__.activateProfile(profileName);
    }
}


/***/ }),

/***/ "./src/main/scripts/settings-utils.ts":
/*!********************************************!*\
  !*** ./src/main/scripts/settings-utils.ts ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "DEFAULT_PROFILE_NAME": () => (/* binding */ DEFAULT_PROFILE_NAME),
/* harmony export */   "MODULE_ID": () => (/* binding */ MODULE_ID),
/* harmony export */   "TEMPLATES_PATH": () => (/* binding */ TEMPLATES_PATH),
/* harmony export */   "getActiveProfileName": () => (/* binding */ getActiveProfileName),
/* harmony export */   "getProfiles": () => (/* binding */ getProfiles),
/* harmony export */   "registerAPI": () => (/* binding */ registerAPI),
/* harmony export */   "registerMenus": () => (/* binding */ registerMenus),
/* harmony export */   "registerSettings": () => (/* binding */ registerSettings),
/* harmony export */   "reloadWindow": () => (/* binding */ reloadWindow),
/* harmony export */   "resetProfiles": () => (/* binding */ resetProfiles),
/* harmony export */   "setActiveProfileName": () => (/* binding */ setActiveProfileName),
/* harmony export */   "setProfiles": () => (/* binding */ setProfiles)
/* harmony export */ });
/* harmony import */ var _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../classes/ManageModuleProfilesSettingsForm */ "./src/main/classes/ManageModuleProfilesSettingsForm.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./settings */ "./src/main/scripts/settings.ts");


const MODULE_ID = 'module-profiles';
const TEMPLATES_PATH = `modules/${MODULE_ID}/templates`;
const DEFAULT_PROFILE_NAME = 'Default Profile';
const PROFILES_SETTING = 'profiles';
const ACTIVE_PROFILE_NAME_SETTING = 'activeProfileName';
/**
 * Registers settings for the module. This is only meant to be called on initial game load.
 */
function registerSettings() {
    game.settings.register(MODULE_ID, PROFILES_SETTING, {
        name: 'Profiles',
        hint: 'Existing module profiles',
        default: [buildDefaultProfile()],
        type: Array,
        scope: 'world'
    });
    game.settings.register(MODULE_ID, ACTIVE_PROFILE_NAME_SETTING, {
        name: 'Active Profile Name',
        default: DEFAULT_PROFILE_NAME,
        type: String,
        scope: 'world'
    });
    function buildDefaultProfile() {
        const savedModuleConfiguration = _settings__WEBPACK_IMPORTED_MODULE_1__.getCurrentModuleConfiguration();
        return {
            name: DEFAULT_PROFILE_NAME,
            modules: savedModuleConfiguration
        };
    }
}
/**
 * Registers menus for the module. This is only meant to be called on initial game load.
 */
function registerMenus() {
    game.settings.registerMenu(MODULE_ID, 'manageProfiles', {
        name: 'Manage Profiles',
        label: 'Manage Profiles',
        icon: 'fas fa-cog',
        type: _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_0__["default"],
        restricted: true
    });
}
/**
 * Registers an API for the current module, accessible by `game.modules.get(MODULE_ID).api.*function()*`. This is meant to be called only on initial game load.
 * @param {Record<string, Function>} api - The API to expose.
 * @returns {void}
 */
function registerAPI(api) {
    // @ts-ignore - Not recognized due to Foundry object
    game.modules.get(MODULE_ID).api = api;
    console.log(`${MODULE_ID} API registered`);
}
/**
 * Reloads the current window.
 * @returns {void}
 */
function reloadWindow() {
    window.location.reload();
}
/**
 * Get the Profiles game setting.
 * @return {ModuleProfile[]} - The value of the game setting.
 */
function getProfiles() {
    return game.settings.get(MODULE_ID, PROFILES_SETTING);
}
/**
 * Set the Profiles game setting.
 * @param {ModuleProfile[]} profiles - The value to save to the game setting.
 * @return {Promise<ModuleProfile[]>} - A Promise resolving to the new game setting value.
 */
async function setProfiles(profiles) {
    // Filter out references to modules that are no longer installed
    profiles.forEach(profile => profile.modules = profile.modules.filter(moduleInfo => moduleInfo.title !== undefined));
    // Sort profiles by profile name, and module infos by module title
    profiles.sort((a, b) => a.name.localeCompare(b.name));
    // @ts-ignore - undefined titles are filtered before this line
    profiles.forEach(profile => profile.modules.sort((a, b) => a.title.localeCompare(b.title)));
    return await game.settings.set(MODULE_ID, PROFILES_SETTING, profiles);
}
/**
 * Resets the Profiles game setting to the default profile.
 */
function resetProfiles() {
    return game.settings.set(MODULE_ID, PROFILES_SETTING, undefined);
}
/**
 * Get the Active Profile Name game setting.
 * @return {string} - The value of the game setting.
 */
function getActiveProfileName() {
    return game.settings.get(MODULE_ID, ACTIVE_PROFILE_NAME_SETTING);
}
/**
 * Set the Active Profile Name game setting.
 * @param {string} activeProfileName - The value to save to the game setting.
 * @return {Promise<string>} - A Promise resolving to the new game setting value.
 */
function setActiveProfileName(activeProfileName) {
    return game.settings.set(MODULE_ID, ACTIVE_PROFILE_NAME_SETTING, activeProfileName);
}


/***/ }),

/***/ "./src/main/scripts/settings.ts":
/*!**************************************!*\
  !*** ./src/main/scripts/settings.ts ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FoundryVersion": () => (/* binding */ FoundryVersion),
/* harmony export */   "activateProfile": () => (/* binding */ activateProfile),
/* harmony export */   "createProfile": () => (/* binding */ createProfile),
/* harmony export */   "deleteProfile": () => (/* binding */ deleteProfile),
/* harmony export */   "exportAllProfiles": () => (/* binding */ exportAllProfiles),
/* harmony export */   "exportProfileByName": () => (/* binding */ exportProfileByName),
/* harmony export */   "getActiveProfile": () => (/* binding */ getActiveProfile),
/* harmony export */   "getAllProfiles": () => (/* binding */ getAllProfiles),
/* harmony export */   "getCurrentModuleConfiguration": () => (/* binding */ getCurrentModuleConfiguration),
/* harmony export */   "getFoundryVersion": () => (/* binding */ getFoundryVersion),
/* harmony export */   "getProfileByName": () => (/* binding */ getProfileByName),
/* harmony export */   "importProfiles": () => (/* binding */ importProfiles),
/* harmony export */   "registerModuleSettings": () => (/* binding */ registerModuleSettings),
/* harmony export */   "resetProfiles": () => (/* binding */ resetProfiles),
/* harmony export */   "saveChangesToProfile": () => (/* binding */ saveChangesToProfile),
/* harmony export */   "setCoreModuleConfiguration": () => (/* binding */ setCoreModuleConfiguration)
/* harmony export */ });
/* harmony import */ var _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../classes/ManageModuleProfilesSettingsForm */ "./src/main/classes/ManageModuleProfilesSettingsForm.ts");
/* harmony import */ var _mapping_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mapping-utils */ "./src/main/scripts/mapping-utils.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _settings_utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./settings-utils */ "./src/main/scripts/settings-utils.ts");




function registerModuleSettings() {
    _settings_utils__WEBPACK_IMPORTED_MODULE_3__.registerSettings();
    _settings_utils__WEBPACK_IMPORTED_MODULE_3__.registerMenus();
    const profiles = _settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles();
    if (!profiles || profiles.length === 0) {
        _settings__WEBPACK_IMPORTED_MODULE_2__.resetProfiles();
    }
}
/**
 * Gets the currently active modules from the core game settings.
 * @returns {ModuleInfo[]} - The currently-active module configuration.
 */
function getCurrentModuleConfiguration() {
    const currentFoundryVersion = _settings__WEBPACK_IMPORTED_MODULE_2__.getFoundryVersion();
    if (currentFoundryVersion == FoundryVersion.v9) {
        return Array.from(game.modules).map(([key, value]) => ({
            id: key,
            title: value.data.title,
            isActive: value.active
        })).sort((a, b) => a.title.localeCompare(b.title));
    }
    else {
        return Array.from(game.modules).map(module => ({
            // @ts-ignore - v10 vs v9 schema
            id: module.id,
            // @ts-ignore - v10 vs v9 schema
            title: module.title,
            // @ts-ignore - v10 vs v9 schema
            isActive: module.active
        })).sort((a, b) => a.title.localeCompare(b.title));
    }
}
/**
 * Gets all saved module profiles from the game settings.
 * @returns {ModuleProfile[]}
 */
function getAllProfiles() {
    return _settings_utils__WEBPACK_IMPORTED_MODULE_3__.getProfiles();
}
/**
 * Gets the saved, currently-active module profile from the game settings.
 * @returns {ModuleProfile} - The currently-active module profile.
 */
function getActiveProfile() {
    const activeProfileName = _settings_utils__WEBPACK_IMPORTED_MODULE_3__.getActiveProfileName();
    const activeProfile = _settings__WEBPACK_IMPORTED_MODULE_2__.getProfileByName(activeProfileName);
    if (!activeProfile) {
        const errorMessage = 'Unable to load active profile. Please refresh the Foundry page.';
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    return activeProfile;
}
/**
 * Gets a saved profile from the game settings with the corresponding name.
 * @param {string} profileName - The name of the profile to return.
 * @returns {ModuleProfile | undefined} - The module profile with the given name, or `undefined` if none exists.
 */
function getProfileByName(profileName) {
    const profiles = _settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles();
    return profiles.find(profile => profile.name === profileName);
}
/**
 * Gets the array of saved profiles from the game settings in JSON format.
 * @return {string} - The JSON representation of the profile.
 */
function exportAllProfiles() {
    return JSON.stringify(_settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles(), null, 2);
}
/**
 * Gets a saved profile from the game settings in JSON format.
 * @param {string} profileName - The name of the profile to return.
 * @return {string | undefined} - The JSON representation of the profile, or `undefined` if none exists.
 */
function exportProfileByName(profileName) {
    const profile = _settings__WEBPACK_IMPORTED_MODULE_2__.getProfileByName(profileName);
    return profile ? JSON.stringify(profile, null, 2) : profile;
}
/**
 * Creates a new {@link ModuleProfile} in the game settings.
 * @param {string} profileName - The name of the profile to create.
 * @param {ModuleInfo[]} modules - The Array of {@link ModuleInfo} objects that represent each module's activation status.
 * @returns {Promise<ModuleProfile[]>} - The new Array of {@link ModuleProfile}s.
 * @throws Error - When a profile exists with the given profileName
 */
async function createProfile(profileName, modules) {
    if (!profileName) {
        const postfix = profileName === '' ? 'Profile name must not be empty.' : 'Profile name is undefined.';
        const errorMessage = `Unable to create module profile. ${postfix}`;
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    if (!modules) {
        const errorMessage = 'Unable to create module profile. Please refresh the page and try again.';
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    if (_settings__WEBPACK_IMPORTED_MODULE_2__.getProfileByName(profileName)) {
        const errorMessage = `Unable to create module profile. Profile "${profileName}" already exists!`;
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    const profiles = _settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles();
    profiles.push({ name: profileName, modules: modules });
    const response = _settings_utils__WEBPACK_IMPORTED_MODULE_3__.setProfiles(profiles);
    response.then(() => Hooks.callAll(_classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_0__.MODULE_PROFILES_UPDATED_HOOK_NAME));
    ui.notifications.info(`Profile "${profileName}" has been created!`);
    return response;
}
/**
 * Creates a {@link ModuleProfile} or multiple module profiles out of a JSON representation of those profiles.
 * @param {string} json - The JSON representation of a {@link ModuleProfile} or an Array of {@link ModuleProfile}[] objects.
 * @return {Promise<ModuleProfile[]>} - The saved array of module profiles in the game settings.
 */
async function importProfiles(json) {
    let profiles = JSON.parse(json);
    if (!Array.isArray(profiles)) {
        profiles = [profiles];
    }
    if (profiles.some(profile => !isValidModuleProfile(profile))) {
        const errorMessage = 'Unable to import profiles. Please re-export and try again.';
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    // Written this way to continue trying to create profiles, even when a previous profile could not be created
    for (const profile of profiles) {
        try {
            await _settings__WEBPACK_IMPORTED_MODULE_2__.createProfile(profile.name, profile.modules);
        }
        catch (ignored) { }
    }
    return _settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles();
    function isValidModuleProfile(profile) {
        if (!profile || !profile.name || !profile.modules) {
            return false;
        }
        return profile.modules.every(module => module.id && module.title && module.hasOwnProperty('isActive'));
    }
}
/**
 * Activates the profile with the given name, then reloads the page.
 * @param {string} profileName - The name of the module profile to load.
 * @returns {Promise<void>}
 * @throws {Error} - When profile name does not exist.
 */
async function activateProfile(profileName) {
    const profile = _settings__WEBPACK_IMPORTED_MODULE_2__.getProfileByName(profileName);
    if (!profile) {
        const errorMessage = `Unable to activate module profile. Profile "${profileName}" does not exist!`;
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    _settings_utils__WEBPACK_IMPORTED_MODULE_3__.setActiveProfileName(profile.name)
        .then(() => _settings__WEBPACK_IMPORTED_MODULE_2__.setCoreModuleConfiguration(profile.modules))
        .then(() => _settings_utils__WEBPACK_IMPORTED_MODULE_3__.reloadWindow());
}
/**
 * Saves the current profile settings to an existing profile.
 * @param {string} profileName - The name of the profile to update.
 * @param {ModuleInfo[]} modules - The Array of {@link ModuleInfo} objects that represent each module's activation status.
 * @returns {Promise<ModuleProfile[]>} - The new Array of module profiles.
 * @throws Error - When a profile name is passed and no profiles exist with that name.
 */
async function saveChangesToProfile(profileName, modules) {
    const savedProfiles = _settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles();
    const matchingProfileIndex = savedProfiles.findIndex(profile => profile.name === profileName);
    if (!savedProfiles[matchingProfileIndex]) {
        const errorMessage = `Unable to save module profile changes. Profile "${profileName}" does not exist!`;
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    savedProfiles[matchingProfileIndex] = { name: profileName, modules: modules };
    const response = _settings_utils__WEBPACK_IMPORTED_MODULE_3__.setProfiles(savedProfiles);
    response.then(() => Hooks.callAll(_classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_0__.MODULE_PROFILES_UPDATED_HOOK_NAME));
    ui.notifications.info(`Changes to profile "${profileName}" have been saved!`);
    return response;
}
/**
 * Deletes the profile with the given name. When the currently-active profile is deleted, the first profile is selected.
 * @param {string} profileName - The name of the profile to delete.
 * @return {Promise<ModuleProfile[] | undefined>} - The resulting value of the updated profiles setting, or `undefined` if no profiles remain.
 * @throws {Error} - When no profile with the given name exists.
 */
async function deleteProfile(profileName) {
    if (!_settings__WEBPACK_IMPORTED_MODULE_2__.getProfileByName(profileName)) {
        const errorMessage = `Unable to delete module profile. Profile "${profileName}" does not exist!`;
        ui.notifications.error(errorMessage);
        throw new Error(errorMessage);
    }
    const profilesToSave = _settings__WEBPACK_IMPORTED_MODULE_2__.getAllProfiles().filter(profile => profile.name !== profileName);
    const response = _settings_utils__WEBPACK_IMPORTED_MODULE_3__.setProfiles(profilesToSave);
    if (profilesToSave.length === 0) {
        await _settings__WEBPACK_IMPORTED_MODULE_2__.resetProfiles();
        return;
    }
    if (profileName === _settings_utils__WEBPACK_IMPORTED_MODULE_3__.getActiveProfileName()) {
        await _settings_utils__WEBPACK_IMPORTED_MODULE_3__.setActiveProfileName(profilesToSave[0].name);
    }
    response.then(() => Hooks.callAll(_classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_0__.MODULE_PROFILES_UPDATED_HOOK_NAME));
    ui.notifications.info(`Profile "${profileName}" has been deleted!`);
    return response;
}
/**
 * Reset all module profiles to the default values. WARNING: Doing this leads to unrecoverable data loss.
 * @return {Promise<void>}
 */
async function resetProfiles() {
    await _settings_utils__WEBPACK_IMPORTED_MODULE_3__.resetProfiles()
        .then(() => _settings_utils__WEBPACK_IMPORTED_MODULE_3__.setActiveProfileName(_settings_utils__WEBPACK_IMPORTED_MODULE_3__.DEFAULT_PROFILE_NAME))
        .then(() => _settings_utils__WEBPACK_IMPORTED_MODULE_3__.reloadWindow());
}
async function setCoreModuleConfiguration(moduleInfos) {
    const moduleInfosToSave = _mapping_utils__WEBPACK_IMPORTED_MODULE_1__.mapToModuleKeyIsActiveRecord(moduleInfos);
    const coreModuleConfiguration = game.settings.get('core', 'moduleConfiguration');
    const mergedConfiguration = { ...coreModuleConfiguration, ...moduleInfosToSave };
    return await game.settings.set('core', 'moduleConfiguration', mergedConfiguration);
}
var FoundryVersion;
(function (FoundryVersion) {
    FoundryVersion["v9"] = "9";
    FoundryVersion["v10"] = "10";
    FoundryVersion["v11"] = "11";
    FoundryVersion["v12"] = "12";
})(FoundryVersion || (FoundryVersion = {}));
function getFoundryVersion() {
    const foundryVersion = game.version.split('.')[0];
    switch (foundryVersion) {
        case "9":
            return FoundryVersion.v9;
        case "10":
            return FoundryVersion.v10;
        case "11":
            return FoundryVersion.v11;
        case "12":
            return FoundryVersion.v12;
        default:
            const errorMessage = `Module Profiles: Foundry version '${game.version}' is not supported. Please disable the Module Profiles module.`;
            ui.notifications.error(errorMessage);
            throw new Error(errorMessage);
    }
}


/***/ }),

/***/ "./src/main/scripts/ui/module-management-scripts.ts":
/*!**********************************************************!*\
  !*** ./src/main/scripts/ui/module-management-scripts.ts ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "checkUpdateActiveProfileStatuses": () => (/* binding */ checkUpdateActiveProfileStatuses),
/* harmony export */   "isModuleManagementWindowOpen": () => (/* binding */ isModuleManagementWindowOpen),
/* harmony export */   "modifyModuleManagementRender": () => (/* binding */ modifyModuleManagementRender),
/* harmony export */   "refreshStatusElementsOnDependenciesClose": () => (/* binding */ refreshStatusElementsOnDependenciesClose),
/* harmony export */   "unsavedChangesExistOn": () => (/* binding */ unsavedChangesExistOn)
/* harmony export */ });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _mapping_utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mapping-utils */ "./src/main/scripts/mapping-utils.ts");
/* harmony import */ var _module_management_scripts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./module-management-scripts */ "./src/main/scripts/ui/module-management-scripts.ts");
/* harmony import */ var _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../classes/ManageModuleProfilesSettingsForm */ "./src/main/classes/ManageModuleProfilesSettingsForm.ts");
/* harmony import */ var _classes_CreateModuleProfileForm__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../classes/CreateModuleProfileForm */ "./src/main/classes/CreateModuleProfileForm.ts");
/* harmony import */ var _settings_utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../settings-utils */ "./src/main/scripts/settings-utils.ts");







const MODULE_MANAGEMENT_WINDOW_ID = 'module-management';
// TODO - Needs to be a separate function just for closeDialog instances. updateActiveProfileStatuses() should be exposed and performed when things are changed
function refreshStatusElementsOnDependenciesClose(app) {
    if (app.data.title === 'Dependencies') {
        updateAllStatusElements();
    }
}
// TODO - definitely test and rename ^^ that method accordingly
function checkUpdateActiveProfileStatuses() {
    if (_module_management_scripts__WEBPACK_IMPORTED_MODULE_2__.isModuleManagementWindowOpen()) {
        updateAllStatusElements();
    }
}
/**
 * Determines if changes exist on the Module Management window that don't align with a given profile.
 * @param {string} profileName
 * @returns {boolean} - Whether unsaved changes exist on the profile with the given name.
 */
function unsavedChangesExistOn(profileName) {
    const savedProfile = _settings__WEBPACK_IMPORTED_MODULE_0__.getProfileByName(profileName);
    if (!savedProfile) {
        return false;
    }
    const unsavedModuleInfos = findUnsavedModuleInfos();
    return unsavedModuleInfos.some(unsavedModuleInfo => {
        const savedModuleInfo = savedProfile.modules.find(savedModuleInfo => savedModuleInfo.id === unsavedModuleInfo.id);
        return unsavedModuleInfo.isActive !== savedModuleInfo?.isActive;
    });
    // return Object.entries(unsavedModuleInfos).some(([moduleId, unsavedStatus]) => savedProfile.modules[moduleId] !== unsavedStatus);
}
/**
 * Determines if the Module Management window is open.
 * @returns {boolean} - Whether the Module Management window is open.
 */
function isModuleManagementWindowOpen() {
    return document.getElementById(MODULE_MANAGEMENT_WINDOW_ID) != null;
}
// TODO - test all
function modifyModuleManagementRender(app, html, data) {
    if (game.user?.isGM) {
        addFooterElements();
        modifyModuleListElements();
        updateAllStatusElements();
    }
    function addFooterElements() {
        // Create the elements
        const preFooterDiv = document.createElement('div');
        preFooterDiv.classList.add('module-profiles-footer-row');
        const statusButton = buildStatusButton();
        const saveCurrentConfigurationButton = buildCreateModuleProfileButton();
        const manageProfilesButton = buildManageProfilesButton();
        preFooterDiv.append(statusButton, saveCurrentConfigurationButton, manageProfilesButton);
        // Add elements just below the module list
        const moduleList = document.getElementById('module-list');
        moduleList.after(preFooterDiv);
        // Update status of status buttons
        updateProfileStatusButtons();
        // Update the height of the window with the new elements
        forceModuleManagementWindowHeightResize();
        function buildStatusButton() {
            const activeProfile = _settings__WEBPACK_IMPORTED_MODULE_0__.getActiveProfile();
            const statusButton = document.createElement('button');
            statusButton.type = 'button'; // TODO - prevents submission, therefore reloading page? (any button with type="submit" automatically submits form)
            statusButton.classList.add('module-profiles-status-button');
            statusButton.style.flexBasis = '130%';
            statusButton.dataset.profileName = activeProfile.name; // TODO - make this a little more... easier to find? idk
            statusButton.addEventListener('click', (event) => {
                event.preventDefault();
                const moduleInfos = findUnsavedModuleInfos();
                _settings__WEBPACK_IMPORTED_MODULE_0__.saveChangesToProfile(activeProfile.name, moduleInfos)
                    .then(() => updateProfileStatusButtons());
            });
            return statusButton;
        }
        function buildCreateModuleProfileButton() {
            const createModuleProfileButton = document.createElement('button');
            createModuleProfileButton.type = 'button'; // TODO - prevents submission, therefore reloading page? (any button with type="submit" automatically
            // submits form)
            createModuleProfileButton.innerHTML = `<i class="fa fa-plus"></i> ${game.i18n.localize('MODULE_MANAGEMENT.createNewButton.text')}</button>`;
            createModuleProfileButton.style.flexBasis = '80%';
            createModuleProfileButton.addEventListener('click', () => new _classes_CreateModuleProfileForm__WEBPACK_IMPORTED_MODULE_4__["default"]().render(true));
            return createModuleProfileButton;
        }
        function buildManageProfilesButton() {
            const manageProfilesButton = document.createElement('button');
            manageProfilesButton.type = 'button'; // TODO - prevents submission, therefore reloading page? (any button with type="submit" automatically submits
            // form)
            manageProfilesButton.innerHTML = `<i class="fa fa-cog"></i> ${game.i18n.localize('MODULE_MANAGEMENT.manageModuleProfilesButton.text')}</button>`;
            manageProfilesButton.addEventListener('click', (event) => {
                event.preventDefault();
                new _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__["default"]().render(true);
            });
            return manageProfilesButton;
        }
        // TODO - combine with 'forceManageModuleProfilesHeightResize'?
        function forceModuleManagementWindowHeightResize() {
            Object.values(ui.windows)
                .filter(app => app.options.id === MODULE_MANAGEMENT_WINDOW_ID)
                .forEach(app => app.element[0].style.height = 'auto');
        }
    }
    function modifyModuleListElements() {
        const moduleElements = getModuleListElements();
        // Add status blinkers and add an "update" event listener to each module in the list
        moduleElements.forEach(module => {
            let statusBlinkerContainer = createModuleStatusBlinker();
            if (module.children.length > 0) {
                module.children[0].prepend(statusBlinkerContainer);
                module.addEventListener('input', () => updateAllStatusElements());
            }
            else {
                console.log(`Error with ${_settings_utils__WEBPACK_IMPORTED_MODULE_5__.MODULE_ID} - invalid module`);
                console.log(module);
            }
        });
        function createModuleStatusBlinker() {
            const span = document.createElement('span');
            span.classList.add('module-profiles-status-container');
            span.innerHTML = '<span class="module-profiles-status module-profiles-status-saved"></span>';
            return span;
        }
    }
}
function updateAllStatusElements() {
    const activeProfile = _settings__WEBPACK_IMPORTED_MODULE_0__.getActiveProfile();
    const modules = getModuleListElements();
    modules.forEach(module => {
        if (module.children[0]?.children[1]?.children[0]) // TODO - appropriately handle this
         {
            const statusBlinker = module.children[0].children[0].firstChild;
            const checkbox = module.children[0].children[1].children[0];
            // @ts-ignore - 'name' field exists on Foundry checkboxes with the given module IDs
            const matchingModuleInfo = activeProfile.modules.find(module => module.id === checkbox.attributes.name.value);
            if (matchingModuleInfo && matchingModuleInfo.isActive === checkbox.checked) {
                statusBlinker.classList.remove('module-profiles-status-changed');
                statusBlinker.classList.add('module-profiles-status-saved');
            }
            else {
                statusBlinker.classList.remove('module-profiles-status-saved');
                statusBlinker.classList.add('module-profiles-status-changed');
            }
        }
    });
    updateProfileStatusButtons();
}
function updateProfileStatusButtons() {
    const activeProfile = _settings__WEBPACK_IMPORTED_MODULE_0__.getActiveProfile();
    const isUpToDate = !_module_management_scripts__WEBPACK_IMPORTED_MODULE_2__.unsavedChangesExistOn(activeProfile.name);
    const profileButtons = document.getElementsByClassName('module-profiles-status-button');
    Array.from(profileButtons).forEach(button => {
        const buttonProfileName = button.dataset.profileName;
        if (isUpToDate) {
            const statusButtonText = game.i18n.localize('MODULE_MANAGEMENT.statusButton.upToDate');
            button.style.backgroundColor = '';
            button.innerHTML = `<i class="fa fa-check-circle" style="color: mediumseagreen"></i><b>${(buttonProfileName)}</b> ${statusButtonText}`;
        }
        else {
            button.style.backgroundColor = 'orangered';
            button.innerHTML = `<i class="far fa-save"></i> ${game.i18n.localize('MODULE_MANAGEMENT.statusButton.saveChanges')} <b>${(buttonProfileName)}</b>`;
        }
        button.disabled = isUpToDate;
    });
}
function findUnsavedModuleInfos() {
    const moduleCheckboxes = document.getElementById('module-list').querySelectorAll('input[type=checkbox]');
    const activeModuleIds = Array.from(moduleCheckboxes)
        .filter(checkbox => checkbox.checked)
        // @ts-ignore - 'name' field exists on Foundry checkboxes with the given module IDs
        .map(checkbox => checkbox.attributes.name.value);
    const inactiveModuleIds = Array.from(moduleCheckboxes)
        .filter(checkbox => !checkbox.checked)
        // @ts-ignore - 'name' field exists on Foundry checkboxes with the given module IDs
        .map(checkbox => checkbox.attributes.name.value);
    const moduleList = {};
    activeModuleIds.forEach(moduleId => moduleList[moduleId] = true);
    inactiveModuleIds.forEach(moduleId => moduleList[moduleId] = false);
    return _mapping_utils__WEBPACK_IMPORTED_MODULE_1__.mapToModuleInfos(moduleList);
}
// Module management window swapped from using 'data-module-name' to 'data-module-id' when going from v9 to v10
function getModuleListElements() {
    if (_settings__WEBPACK_IMPORTED_MODULE_0__.getFoundryVersion() == _settings__WEBPACK_IMPORTED_MODULE_0__.FoundryVersion.v9) {
        return document.querySelectorAll('#module-management li[data-module-name]');
    }
    else {
        return document.querySelectorAll('#module-management li[data-module-id]');
    }
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry need to be wrapped in an IIFE because it need to be isolated against other modules in the chunk.
(() => {
/*!**********************************!*\
  !*** ./src/main/scripts/main.ts ***!
  \**********************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/main/scripts/settings.ts");
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./api */ "./src/main/scripts/api.ts");
/* harmony import */ var _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ui/module-management-scripts */ "./src/main/scripts/ui/module-management-scripts.ts");
/* harmony import */ var _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../classes/ManageModuleProfilesSettingsForm */ "./src/main/classes/ManageModuleProfilesSettingsForm.ts");




// Module setup
Hooks.once('ready', _settings__WEBPACK_IMPORTED_MODULE_0__.registerModuleSettings);
Hooks.once('ready', _api__WEBPACK_IMPORTED_MODULE_1__.registerApi);
// Module Management window hooks
Hooks.on('renderModuleManagement', _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_2__.modifyModuleManagementRender);
Hooks.on('closeDialog', _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_2__.refreshStatusElementsOnDependenciesClose);
Hooks.on(_classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__.MODULE_PROFILES_UPDATED_HOOK_NAME, _ui_module_management_scripts__WEBPACK_IMPORTED_MODULE_2__.checkUpdateActiveProfileStatuses);
// Module Profiles Management window hooks
Hooks.on(_classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__.MODULE_PROFILES_UPDATED_HOOK_NAME, _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__.reRenderManageModuleProfilesWindows);
Hooks.on(_classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__.RENDER_HOOK_NAME, _classes_ManageModuleProfilesSettingsForm__WEBPACK_IMPORTED_MODULE_3__.forceManageModuleProfilesHeightResize);

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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