# Monk's Common Display
Add-On Module for Foundry VTT

This module is used to display a common display for all players to view, such as a tv that your in person session can all view.
You do this by setting a player to be the common display and have them log into the account that is being displayed on that tv.
A handy control window allows you to specify how the screen is moved and what token to focus on.

## Installation
Simply use the install module screen within the FoundryVTT setup

## Usage & Current Features
You can set the common display player by either selecting the player in the settings window.

![monks-common-display](/screenshots/players.png)

Or by right clicking on the player in the players list and selecting `Set as Common Display`

![monks-common-display](/screenshots/player-list.png)

A player that is set to be common display will have a screen icon beside their name.

When you have a player selected as the common display, their ui will disappear, leaving just the viewing canvas.  You can specify which parts of the screen you want to remain in the settings, in case you want to show the chat log, or the combat tracker.

Using the common display toolbar you can clear any journal entries or images that have been shared.
As well, as in the settings you can have shared images clear after a certain amount of time.
You can toggle the toolbar being on the screen by clicking on the icon on the regular toolbar.

![monks-common-display](/screenshots/toolbar.png)

You can also set what the screen on the common display will mirror or what token will be focussed, by right clicking the icon and selecting from the context menu.
And can toggle the feature on or off by clicking on the icon.

![monks-common-display](/screenshots/toolbar-menu.png)

## Bug Reporting
I'm sure there are lots of issues with it.  It's very much a work in progress.
Please feel free to contact me on discord if you have any questions or concerns. ironmonk88#4075

## Support

If you feel like being generous, stop by my <a href="https://www.patreon.com/ironmonk">patreon</a>.

Or [![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/R6R7BH5MT)

Not necessary but definitely appreciated.

## License
This Foundry VTT module, writen by Ironmonk, is licensed under [GNU GPLv3.0](https://www.gnu.org/licenses/gpl-3.0.en.html), supplemented by [Commons Clause](https://commonsclause.com/).

This work is licensed under Foundry Virtual Tabletop <a href="https://foundryvtt.com/article/license/">EULA - Limited License Agreement for module development from May 29, 2020.</a>
