class spell_name {
    constructor(level,index) {
        this.level = level;
        this.index = index;
    }
    getValue(actor, pdffield) {
        let spells = actor.items.filter(item => item.type === 'spell' && item.system.level == this.level).sort();
        if (spells.length == 0 || this.index >= spells.length) return undefined;
        return spells[this.index].name;
    }
}

// Map PDF Field Name to Actor data field
export let actormap = {
    // 5E_CharacterSheet_Fillable.pdf
    "CharacterName": "name",
    "CharacterName 2": "name",
    "STR": "system.abilities.str.value",
    "DEX": "system.abilities.dex.value",
    "CON": "system.abilities.con.value",
    "INT": "system.abilities.int.value",
    "WIS": "system.abilities.wis.value",
    "CHA": "system.abilities.cha.value",
    "STRmod": "system.abilities.str.mod",
    "DEXmod ": "system.abilities.dex.mod",
    "CONmod": "system.abilities.con.mod",
    "INTmod": "system.abilities.int.mod",
    "WISmod": "system.abilities.wis.mod",
    "CHamod": "system.abilities.cha.mod",
    "HPCurrent": "system.attributes.hp.value",
    "HPMax":     "system.attributes.hp.max",
    "HPTemp":    "system.attributes.hp.temp",
    "HD":        "system.attributes.hd",
    "HDTotal":   "system.details.level",
    "ST Strength":     "system.abilities.str.save",
    "Check Box 11":    "system.abilities.str.proficient",
    "ST Dexterity":    "system.abilities.dex.save",
    "Check Box 18":    "system.abilities.dex.proficient",
    "ST Constitution": "system.abilities.con.save",
    "Check Box 19":    "system.abilities.con.proficient",
    "ST Intelligence": "system.abilities.int.save",
    "Check Box 20":    "system.abilities.int.proficient",
    "ST Wisdom":       "system.abilities.wis.save",
    "Check Box 21":    "system.abilities.wis.proficient",
    "ST Charisma":     "system.abilities.cha.save",
    "Check Box 22":    "system.abilities.cha.proficient",
    "Initiative":      "system.attributes.init.total",
    "PersonalityTraits ": "system.details.trait",
    "Ideals":            "system.details.ideal",
    "Bonds":             "system.details.bond",
    "Flaws":             "system.details.flaw",
    //"Features and Traits":
    //"Class and Level":
    "Background":       "system.details.background",
    //"Player Name":      "system.details.playerName",   "=game.actors.get(system.ownership.first)"
    "Race ":            "system.details.race",
    "Alignment":        "system.details.alignment",
    "XP":               "system.details.xp.value",
    "ProfBonus":        "system.attributes.prof",
    "Speed":            "system.attributes.movement.walk",
    "AC":               "system.attributes.ac.value",
    "Passive":          "system.skills.prc.passive",
    "CP":               "system.currency.cp",
    "SP":               "system.currency.sp",
    "EP":               "system.currency.ep",
    "GP":               "system.currency.gp",
    "PP":               "system.currency.pp",
    // Skills
    "Acrobatics":    "system.skills.acr.total",
    "Check Box 23":  "system.skills.acr.proficient",
    "Animal":        "system.skills.ani.total",
    "Check Box 24":  "system.skills.ani.proficient",
    "Arcana":        "system.skills.arc.total",
    "Check Box 25":  "system.skills.arc.proficient",
    "Athletics":     "system.skills.ath.total",
    "Check Box 26":  "system.skills.ath.proficient",
    "Deception":     "system.skills.dec.total",
    "Check Box 27":  "system.skills.dec.proficient",
    "History":       "system.skills.his.total",
    "Check Box 28":  "system.skills.his.proficient",
    "Insight":       "system.skills.ins.total",
    "Check Box 29":  "system.skills.ins.proficient",
    "Intimidation":  "system.skills.itm.total",
    "Check Box 30":  "system.skills.itm.proficient",
    "Investigation": "system.skills.inv.total",
    "Check Box 31":  "system.skills.inv.proficient",
    "Medicine":      "system.skills.med.total",
    "Check Box 32":  "system.skills.med.proficient",
    "Nature":        "system.skills.nat.total",
    "Check Box 33":  "system.skills.nat.proficient",
    "Perception":    "system.skills.prc.total",
    "Check Box 34":  "system.skills.prc.proficient",
    "Performance":   "system.skills.prf.total",
    "Check Box 35":  "system.skills.prf.proficient",
    "Persuasion":    "system.skills.per.total",
    "Check Box 36":  "system.skills.per.proficient",
    "Religion":      "system.skills.rel.total",
    "Check Box 37":  "system.skills.rel.proficient",
    "SleightofHand": "system.skills.slt.total",
    "Check Box 38":  "system.skills.slt.proficient",
    "Stealth":       "system.skills.ste.total",
    "Check Box 39":  "system.skills.ste.proficient",
    "Survival":      "system.skills.sur.total",
    "Check Box 40":  "system.skills.sur.proficient",
    // details
    "Age":    "system.details.age",
    "Height": "system.details.height",
    "Weight": "system.details.weight",
    "Eyes":   "system.details.eyes",
    "Skin":   "system.details.skin",
    "Hair":   "system.details.hair",
    "SlotsRemaining 19" : "system.spells.spell1.value",  // but sheet shows expended, not remaining
    "SlotsTotal 19"     : "system.spells.spell1.max",
    "SlotsRemaining 20" : "system.spells.spell2.value",
    "SlotsTotal 20"     : "system.spells.spell2.max",
    "SlotsRemaining 21" : "system.spells.spell3.value",
    "SlotsTotal 21"     : "system.spells.spell3.max",
    "SlotsRemaining 22" : "system.spells.spell4.value",
    "SlotsTotal 22"     : "system.spells.spell4.max",
    "SlotsRemaining 23" : "system.spells.spell5.value",
    "SlotsTotal 23"     : "system.spells.spell5.max",
    "SlotsRemaining 24" : "system.spells.spell6.value",
    "SlotsTotal 24"     : "system.spells.spell6.max",
    "SlotsRemaining 25" : "system.spells.spell7.value",
    "SlotsTotal 25"     : "system.spells.spell7.max",
    "SlotsRemaining 26" : "system.spells.spell8.value",
    "SlotsTotal 26"     : "system.spells.spell8.max",
    "SlotsRemaining 27" : "system.spells.spell9.value",
    "SlotsTotal 27"     : "system.spells.spell9.max",
    // Calculated
    "Inspiration": { // "system.attributes.inspiration"
        getValue(actor) {
            return actor.system.attributes.inspiration ? "Y" : "";
        },
        setValue(actor, value) {
            actor.update( { ["system.attributes.inspiration"] : (value?.length > 0) })
        }
    },     
    "PlayerName": { // readonly, so no setValue function
        getValue(actor) {
            let user;
            for (const [key, value] of Object.entries(actor.ownership)) {
                if (value === CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER &&
                    (user = game.users.get(key)) &&
                    user.role != CONST.USER_ROLES.GAMEMASTER)
                {
                    return user.name;
                } 
            }
        },
    },
    "Spells 1014": "items[type=spell,system.level=0][0].name", //new spell_name(0, 0),
    "Spells 1016": "items[type=spell,system.level=0][1].name",
    "Spells 1017": "items[type=spell,system.level=0][2].name",
    "Spells 1018": "items[type=spell,system.level=0][3].name",
    "Spells 1019": "items[type=spell,system.level=0][4].name",
    "Spells 1020": "items[type=spell,system.level=0][5].name",
    "Spells 1021": "items[type=spell,system.level=0][6].name",
    "Spells 1022": "items[type=spell,system.level=0][7].name",

    "Spells 1015": "items[type=spell,system.level=1][0].name",
    "Spells 1023": "items[type=spell,system.level=1][1].name",
    "Spells 1024": "items[type=spell,system.level=1][2].name",
    "Spells 1025": "items[type=spell,system.level=1][3].name",
    "Spells 1026": "items[type=spell,system.level=1][4].name",
    "Spells 1027": "items[type=spell,system.level=1][5].name",
    "Spells 1028": "items[type=spell,system.level=1][6].name",
    "Spells 1029": "items[type=spell,system.level=1][7].name",
    "Spells 1030": "items[type=spell,system.level=1][8].name",
    "Spells 1031": "items[type=spell,system.level=1][9].name",
    "Spells 1032": "items[type=spell,system.level=1][10].name",
    "Spells 1033": "items[type=spell,system.level=1][11].name",
    "Check Box 251": "items[type=spell,system.level=1][0].system.preparation.prepared",
    "Check Box 309": "items[type=spell,system.level=1][1].system.preparation.prepared",
    "Check Box 3010": "items[type=spell,system.level=1][2].system.preparation.prepared",
    "Check Box 3011": "items[type=spell,system.level=1][3].system.preparation.prepared",
    "Check Box 3012": "items[type=spell,system.level=1][4].system.preparation.prepared",
    "Check Box 3013": "items[type=spell,system.level=1][5].system.preparation.prepared",
    "Check Box 3014": "items[type=spell,system.level=1][6].system.preparation.prepared",
    "Check Box 3015": "items[type=spell,system.level=1][7].system.preparation.prepared",
    "Check Box 3016": "items[type=spell,system.level=1][8].system.preparation.prepared",
    "Check Box 3017": "items[type=spell,system.level=1][9].system.preparation.prepared",
    "Check Box 3018": "items[type=spell,system.level=1][10].system.preparation.prepared",
    "Check Box 3019": "items[type=spell,system.level=1][11].system.preparation.prepared",

    "Spells 1046": "items[type=spell,system.level=2][0].name",
    "Spells 1034": "items[type=spell,system.level=2][1].name",
    "Spells 1035": "items[type=spell,system.level=2][2].name",
    "Spells 1036": "items[type=spell,system.level=2][3].name",
    "Spells 1037": "items[type=spell,system.level=2][4].name",
    "Spells 1038": "items[type=spell,system.level=2][5].name",
    "Spells 1039": "items[type=spell,system.level=2][6].name",
    "Spells 1040": "items[type=spell,system.level=2][7].name",
    "Spells 1041": "items[type=spell,system.level=2][8].name",
    "Spells 1042": "items[type=spell,system.level=2][9].name",
    "Spells 1043": "items[type=spell,system.level=2][10].name",
    "Spells 1044": "items[type=spell,system.level=2][11].name",
    "Spells 1045": "items[type=spell,system.level=2][12].name",
    "Check Box 313": "items[type=spell,system.level=2][0].system.preparation.prepared",
    "Check Box 310": "items[type=spell,system.level=2][1].system.preparation.prepared",
    "Check Box 3020": "items[type=spell,system.level=2][2].system.preparation.prepared",
    "Check Box 3021": "items[type=spell,system.level=2][3].system.preparation.prepared",
    "Check Box 3022": "items[type=spell,system.level=2][4].system.preparation.prepared",
    "Check Box 3023": "items[type=spell,system.level=2][5].system.preparation.prepared",
    "Check Box 3024": "items[type=spell,system.level=2][6].system.preparation.prepared",
    "Check Box 3025": "items[type=spell,system.level=2][7].system.preparation.prepared",
    "Check Box 3026": "items[type=spell,system.level=2][8].system.preparation.prepared",
    "Check Box 3027": "items[type=spell,system.level=2][9].system.preparation.prepared",
    "Check Box 3028": "items[type=spell,system.level=2][10].system.preparation.prepared",
    "Check Box 3029": "items[type=spell,system.level=2][11].system.preparation.prepared",
    "Check Box 3030": "items[type=spell,system.level=2][12].system.preparation.prepared",

    "Spells 1048": "items[type=spell,system.level=3][0].name",
    "Spells 1047": "items[type=spell,system.level=3][1].name",
    "Spells 1049": "items[type=spell,system.level=3][2].name",
    "Spells 1050": "items[type=spell,system.level=3][3].name",
    "Spells 1051": "items[type=spell,system.level=3][4].name",
    "Spells 1052": "items[type=spell,system.level=3][5].name",
    "Spells 1053": "items[type=spell,system.level=3][6].name",
    "Spells 1054": "items[type=spell,system.level=3][7].name",
    "Spells 1055": "items[type=spell,system.level=3][8].name",
    "Spells 1056": "items[type=spell,system.level=3][9].name",
    "Spells 1057": "items[type=spell,system.level=3][10].name",
    "Spells 1058": "items[type=spell,system.level=3][11].name",
    "Spells 1059": "items[type=spell,system.level=3][12].name",
    "Check Box 315": "items[type=spell,system.level=3][0].system.preparation.prepared",
    "Check Box 314": "items[type=spell,system.level=3][1].system.preparation.prepared",
    "Check Box 3031": "items[type=spell,system.level=3][2].system.preparation.prepared",
    "Check Box 3032": "items[type=spell,system.level=3][3].system.preparation.prepared",
    "Check Box 3033": "items[type=spell,system.level=3][4].system.preparation.prepared",
    "Check Box 3034": "items[type=spell,system.level=3][5].system.preparation.prepared",
    "Check Box 3035": "items[type=spell,system.level=3][6].system.preparation.prepared",
    "Check Box 3036": "items[type=spell,system.level=3][7].system.preparation.prepared",
    "Check Box 3037": "items[type=spell,system.level=3][8].system.preparation.prepared",
    "Check Box 3038": "items[type=spell,system.level=3][9].system.preparation.prepared",
    "Check Box 3039": "items[type=spell,system.level=3][10].system.preparation.prepared",
    "Check Box 3040": "items[type=spell,system.level=3][11].system.preparation.prepared",
    "Check Box 3041": "items[type=spell,system.level=3][12].system.preparation.prepared",

    "Spells 1061": "items[type=spell,system.level=4][0].name",
    "Spells 1060": "items[type=spell,system.level=4][1].name",
    "Spells 1062": "items[type=spell,system.level=4][2].name",
    "Spells 1063": "items[type=spell,system.level=4][3].name",
    "Spells 1064": "items[type=spell,system.level=4][4].name",
    "Spells 1065": "items[type=spell,system.level=4][5].name",
    "Spells 1066": "items[type=spell,system.level=4][6].name",
    "Spells 1067": "items[type=spell,system.level=4][7].name",
    "Spells 1068": "items[type=spell,system.level=4][8].name",
    "Spells 1069": "items[type=spell,system.level=4][9].name",
    "Spells 1070": "items[type=spell,system.level=4][10].name",
    "Spells 1071": "items[type=spell,system.level=4][11].name",
    "Spells 1072": "items[type=spell,system.level=4][12].name",
    "Check Box 317": "items[type=spell,system.level=4][0].system.preparation.prepared",
    "Check Box 316": "items[type=spell,system.level=4][1].system.preparation.prepared",
    "Check Box 3042": "items[type=spell,system.level=4][2].system.preparation.prepared",
    "Check Box 3043": "items[type=spell,system.level=4][3].system.preparation.prepared",
    "Check Box 3044": "items[type=spell,system.level=4][4].system.preparation.prepared",
    "Check Box 3045": "items[type=spell,system.level=4][5].system.preparation.prepared",
    "Check Box 3046": "items[type=spell,system.level=4][6].system.preparation.prepared",
    "Check Box 3047": "items[type=spell,system.level=4][7].system.preparation.prepared",
    "Check Box 3048": "items[type=spell,system.level=4][8].system.preparation.prepared",
    "Check Box 3049": "items[type=spell,system.level=4][9].system.preparation.prepared",
    "Check Box 3050": "items[type=spell,system.level=4][10].system.preparation.prepared",
    "Check Box 3051": "items[type=spell,system.level=4][11].system.preparation.prepared",
    "Check Box 3052": "items[type=spell,system.level=4][12].system.preparation.prepared",

    "Spells 1074": "items[type=spell,system.level=5][0].name",
    "Spells 1073": "items[type=spell,system.level=5][1].name",
    "Spells 1075": "items[type=spell,system.level=5][2].name",
    "Spells 1076": "items[type=spell,system.level=5][3].name",
    "Spells 1077": "items[type=spell,system.level=5][4].name",
    "Spells 1078": "items[type=spell,system.level=5][5].name",
    "Spells 1079": "items[type=spell,system.level=5][6].name",
    "Spells 1080": "items[type=spell,system.level=5][7].name",
    "Spells 1081": "items[type=spell,system.level=5][8].name",
    "Check Box 319": "items[type=spell,system.level=5][0].system.preparation.prepared",
    "Check Box 318": "items[type=spell,system.level=5][1].system.preparation.prepared",
    "Check Box 3053": "items[type=spell,system.level=5][2].system.preparation.prepared",
    "Check Box 3054": "items[type=spell,system.level=5][3].system.preparation.prepared",
    "Check Box 3055": "items[type=spell,system.level=5][4].system.preparation.prepared",
    "Check Box 3056": "items[type=spell,system.level=5][5].system.preparation.prepared",
    "Check Box 3057": "items[type=spell,system.level=5][6].system.preparation.prepared",
    "Check Box 3058": "items[type=spell,system.level=5][7].system.preparation.prepared",
    "Check Box 3059": "items[type=spell,system.level=5][8].system.preparation.prepared",

    "Spells 1083": "items[type=spell,system.level=6][0].name",
    "Spells 1082": "items[type=spell,system.level=6][1].name",
    "Spells 1084": "items[type=spell,system.level=6][2].name",
    "Spells 1085": "items[type=spell,system.level=6][3].name",
    "Spells 1086": "items[type=spell,system.level=6][4].name",
    "Spells 1087": "items[type=spell,system.level=6][5].name",
    "Spells 1088": "items[type=spell,system.level=6][6].name",
    "Spells 1089": "items[type=spell,system.level=6][7].name",
    "Spells 1090": "items[type=spell,system.level=6][8].name",
    "Check Box 321": "items[type=spell,system.level=6][0].system.preparation.prepared",
    "Check Box 320": "items[type=spell,system.level=6][1].system.preparation.prepared",
    "Check Box 3060": "items[type=spell,system.level=6][2].system.preparation.prepared",
    "Check Box 3061": "items[type=spell,system.level=6][3].system.preparation.prepared",
    "Check Box 3062": "items[type=spell,system.level=6][4].system.preparation.prepared",
    "Check Box 3063": "items[type=spell,system.level=6][5].system.preparation.prepared",
    "Check Box 3064": "items[type=spell,system.level=6][6].system.preparation.prepared",
    "Check Box 3065": "items[type=spell,system.level=6][7].system.preparation.prepared",
    "Check Box 3066": "items[type=spell,system.level=6][8].system.preparation.prepared",

    "Spells 1092": "items[type=spell,system.level=7][0].name",
    "Spells 1091": "items[type=spell,system.level=7][1].name",
    "Spells 1093": "items[type=spell,system.level=7][2].name",
    "Spells 1094": "items[type=spell,system.level=7][3].name",
    "Spells 1095": "items[type=spell,system.level=7][4].name",
    "Spells 1096": "items[type=spell,system.level=7][5].name",
    "Spells 1097": "items[type=spell,system.level=7][6].name",
    "Spells 1098": "items[type=spell,system.level=7][7].name",
    "Spells 1099": "items[type=spell,system.level=7][8].name",
    "Check Box 323": "items[type=spell,system.level=7][0].system.preparation.prepared",
    "Check Box 322": "items[type=spell,system.level=7][1].system.preparation.prepared",
    "Check Box 3067": "items[type=spell,system.level=7][2].system.preparation.prepared",
    "Check Box 3068": "items[type=spell,system.level=7][3].system.preparation.prepared",
    "Check Box 3069": "items[type=spell,system.level=7][4].system.preparation.prepared",
    "Check Box 3070": "items[type=spell,system.level=7][5].system.preparation.prepared",
    "Check Box 3071": "items[type=spell,system.level=7][6].system.preparation.prepared",
    "Check Box 3072": "items[type=spell,system.level=7][7].system.preparation.prepared",
    "Check Box 3073": "items[type=spell,system.level=7][8].system.preparation.prepared",

    "Spells 10101": "items[type=spell,system.level=8][0].name",
    "Spells 10100": "items[type=spell,system.level=8][1].name",
    "Spells 10102": "items[type=spell,system.level=8][2].name",
    "Spells 10103": "items[type=spell,system.level=8][3].name",
    "Spells 10104": "items[type=spell,system.level=8][4].name",
    "Spells 10105": "items[type=spell,system.level=8][5].name",
    "Spells 10106": "items[type=spell,system.level=8][6].name",
    "Check Box 325": "items[type=spell,system.level=8][0].system.preparation.prepared",
    "Check Box 324": "items[type=spell,system.level=8][1].system.preparation.prepared",
    "Check Box 3074": "items[type=spell,system.level=8][2].system.preparation.prepared",
    "Check Box 3075": "items[type=spell,system.level=8][3].system.preparation.prepared",
    "Check Box 3076": "items[type=spell,system.level=8][4].system.preparation.prepared",
    "Check Box 3077": "items[type=spell,system.level=8][5].system.preparation.prepared",
    "Check Box 3078": "items[type=spell,system.level=8][6].system.preparation.prepared",

    "Spells 10108": "items[type=spell,system.level=9][0].name",
    "Spells 10107": "items[type=spell,system.level=9][1].name",
    "Spells 10109": "items[type=spell,system.level=9][2].name",
    "Spells 101010": "items[type=spell,system.level=9][3].name",
    "Spells 101011": "items[type=spell,system.level=9][4].name",
    "Spells 101012": "items[type=spell,system.level=9][5].name",
    "Spells 101013": "items[type=spell,system.level=9][6].name",
    "Check Box 327": "items[type=spell,system.level=9][0].system.preparation.prepared",
    "Check Box 327": "items[type=spell,system.level=9][1].system.preparation.prepared",
    "Check Box 3079": "items[type=spell,system.level=9][2].system.preparation.prepared",
    "Check Box 3080": "items[type=spell,system.level=9][3].system.preparation.prepared",
    "Check Box 3081": "items[type=spell,system.level=9][4].system.preparation.prepared",
    "Check Box 3082": "items[type=spell,system.level=9][5].system.preparation.prepared",
    "Check Box 3083": "items[type=spell,system.level=9][6].system.preparation.prepared",

}

// Map PDF field name to Item data field
export let itemmap = {
}