Hooks.once("init", async function () {

  game.settings.register("progress-tracker", "sliders", {
    name: "",
    hint: "",
    scope: "world",
    config: false,
    type: Object,
    default: {},
    onChange: function () {
      if(game.user.isGM) return;
      const id = canvas.scene.getFlag("progress-tracker", "progressId");
      new ProgressTracker(id).render(true);
    },
  });

  game.settings.register("progress-tracker", "windowpos", {
    name: "",
    hint: "",
    scope: "client",
    config: false,
    type: Object,
    default: {},
    onChange: function () {
    },
  });

});

Hooks.once("ready", async function () {
});

Hooks.on("updateScene", (scene, updates) => {
  if(updates.flags && updates.flags["progress-tracker"] && scene.id == canvas.scene.id){
    const id = scene.getFlag("progress-tracker", "progressId");
    if(id) new ProgressTracker(id).render(true);
  }
})

Hooks.on("getSceneControlButtons", (controls, b, c) => {
  controls
    .find((c) => c.name == "notes")
    .tools.push(
      {
        name: "showProgres",
        title: "Show Progress Tracker",
        icon: "fas fa-sliders-h",
        button: true,
        visible: true,
        onClick: () => {
          const id = canvas.scene.getFlag("progress-tracker", "progressId");
          const sett = game.settings.get("progress-tracker", "sliders")[id];
          if (!sett) {
            canvas.scene.unsetFlag("progress-tracker", "progressId");
          }
          if (sett && id) new ProgressTracker(id).render(true);
          else ui.notifications.warn("progress-tracker.error.noTracker", {localize: true});
        },
      },
      {
        name: "editTrackers",
        title: "Edit Progress Trackers",
        icon: "fas fa-exchange-alt",
        button: true,
        visible: game.user.isGM,
        onClick: () => {
          new ProgressBarsConfigurator().render(true);
        },
      }
    );
});