import { QuickdrawHandler, Quickdraw } from "./module.js";

export const MODULE_ID = "quickdraw";


Hooks.once('init', async function () {
    
    new QuickdrawHandler();

    game.settings.register("quickdraw", "linethicc", {
        name: "Line Thickness",
        hint: "Thickness of the line in pixels",
        scope: "world",
        config: true,
        type: Number,
        range: {
          min: 1,
          max: 30,
          step: 1,
        },
        default: 10,
      });

      game.settings.register("quickdraw", "pollrate", {
        name: "Polling Rate",
        hint: "Smaller numbers make the line more precise",
        scope: "world",
        config: true,
        type: Number,
        range: {
          min: 10,
          max: 100,
          step: 1,
        },
        default: 50,
      });

      game.settings.register("quickdraw", "fadeoutDelay", {
        name: "Fadeout Delay",
        hint: "Time in milliseconds before a Quickdraw fades out",
        scope: "world",
        config: true,
        type: Number,
        default: 10000,
      });

        game.keybindings.register("quickdraw", "hotkey", {
          name: "Quickdraw",
          editable: [
            {key: "KeyQ"},
          ],
          onDown: (e) => {
            if(game.QuickdrawHandler.current || e.event.target.localName !== "body") return;
            game.QuickdrawHandler.current = new Quickdraw();
            game.QuickdrawHandler.current.start();
          },
          onUp: (e) => {
              game.QuickdrawHandler.current?.end();
              game.QuickdrawHandler.current = null;
          },
      });


});