Hooks.once("init", async function () {
  game.settings.registerMenu("situational-shortcuts", "worldBonusConfig", {
    name: "Situational Bonuses (global)",
    label: "Configure Bonuses",
    icon: "fas fa-cogs",
    scope: "world",
    restricted: true,
    type: SituationalShortcutsConfig,
  });

  game.settings.registerMenu("situational-shortcuts", "userBonusConfig", {
    name: "Situational Bonuses (user)",
    label: "Configure Bonuses",
    icon: "fas fa-cogs",
    scope: "world",
    restricted: false,
    type: SituationalShortcutsConfigUser,
  });

  game.settings.register("situational-shortcuts", "worldBonusData", {
    name: "",
    hint: "",
    scope: "world",
    config: false,
    type: Object,
    default: {},
  });

  game.settings.register("situational-shortcuts", "bonusColors", {
    name: "Enable Color",
    hint: "Apply a color to bonuses depending on their starting operator",
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
  });

  game.settings.register("situational-shortcuts", "replaceMode", {
    name: "Replace",
    hint: "When selecting a bonus, replace the whole value instead of appending to it",
    scope: "world",
    config: true,
    type: Boolean,
    default: true,
  });

});
Hooks.once("ready", async function () {});


class SituationalShortcutsConfig extends FormApplication{

  static get defaultOptions() {
    return{
      ...super.defaultOptions,
      title: "Configure Bonuses",
      id: "SituationalShortcutsConfig",
      template: "modules/situational-shortcuts/templates/config.hbs",
      resizable: true,
      width: 400,
      height: 600,
    }
  }

  getData(){
    const data = super.getData();
    data.setting = game.settings.get("situational-shortcuts", "worldBonusData")
    return data;
  }

  _activateCoreListeners(){}

  activateListeners(html){
    super.activateListeners(html);
    html.on("click", ".add", (e) => {
      e.preventDefault();
      html.find(".bonuses-config").append(`
      <li class="bonus-config">
      <div class="form-group">
        <label for="" >Name: </label>
        <input type="text" class="name" value="">
        <label for="">Bonus: </label>
        <input type="text" class="value" value="">
        <i class="fas fa-trash"></i>
      </div>
      </li>
  `)
    })
    html.on("click", ".bonus-config .fas.fa-trash", (e) => {
      e.preventDefault();
      html.find(e.currentTarget).parent().remove();
    })
    html.on("click", ".submit", this._onSubmit.bind(this));
  }

  _onSubmit(){
    // Get the data
    const html = $(this.element);
    const $ol = html.find(".bonuses-config");
    const data = {};
    $ol.find(".bonus-config").each((i, el) => {
      const name = html.find(el).find(".name").val();
      const value = html.find(el).find(".value").val();
      if(name && value){
        data[name] = value;
      }
    });
    // Save it
    this.saveData(data);
    this.close();
  }

  async saveData(data){
    game.settings.set("situational-shortcuts", "worldBonusData", data);
  }
}

class SituationalShortcutsConfigUser extends SituationalShortcutsConfig{
  getData(){
    const data = super.getData();
    data.setting = game.user.getFlag("situational-shortcuts", "userBonusData")
    return data;
  }
  async saveData(data){
    await game.user.unsetFlag("situational-shortcuts", "userBonusData");
    await game.user.setFlag("situational-shortcuts", "userBonusData", data);
  }
}