class TokenNotes extends BasePlaceableHUD {

    static get defaultOptions() {
      return {
        ...super.defaultOptions,
        id: "token-notes",
        template: "modules/token-notes/templates/tokennote.hbs",
        dragDrop: [{ dragSelector: null, dropSelector: null }],
      };
    }
  
    _canDragDrop(selector) {
      return true;
    }
  
    getData() {
      //const data = this.object.document.getFlag("token-notes", "notes");
      //return data;
    }
  
    close() {
      this._save()
      super.close();
    }
  
    activateListeners(html) {
      super.activateListeners(html);
      const notes = this.object.document.getFlag("token-notes", "notes") ?? "";
      const textarea = html.find("textarea");
      const readarea = html.find(".token-notes-text-read");
      this.textarea = textarea;
      this.readarea = readarea;
      this.readOnly = game.settings.get("token-notes", "allowplayers") === 1 && !game.user.isGM;
      textarea.val(notes);
      this._generateReadArea();
      this.textarea.hide();
      html.find("#token-name").text(this.object.document.name);
      html.find("#edit").click(this._onEdit.bind(this));
      this.readarea.on("change", "input", this._updateTextArea.bind(this));
      if(this.readOnly) html.find("#edit").hide();
    }
    
    _onEdit(event) {
      event.preventDefault();
      this._toggleNoteState();
      this._save();
    }

    _save(){
      this.object.document.setFlag("token-notes", "notes", this.textarea.val());
    }

    _toggleNoteState(){
      if(this.textarea.is(":visible")){
        this._readMode();
      } else {
        this._editMode();
      }
    }

    _editMode(){
      this._updateTextArea();
      this.textarea.show();
      this.readarea.hide();
    }

    _readMode(){
      this.textarea.hide();
      this.readarea.show();
      this._generateReadArea();
    }

    _generateReadArea(){
      const text = this.textarea.val();
      const lines = text.split("\n");
      let parts = [];
      for(let line of lines){
        parts = parts.concat(line.split(" ").filter(p => p.length > 0));
        parts.push("\n");
      }
      parts.pop();
      let content = "";
      for(let part of parts){
        const isNumber = part.match(/^\d+$/) != null;
        const number = isNumber ? parseInt(part) : undefined;
        const length = part.length;
        if(part == "\n"){
          content += "<hr>";
          continue;
        }
        if(isNumber){
          content+= `<input type="number" value="${number}" min="0" max="99" style="width:${length+1}rem; border: none; margin-right: 0.3rem">`;
        }else{
          content+=`<span class="token-notes-text-read-word">${part}</span>`;
        }
      }
      this.readarea.html(content);
    }

    _updateTextArea(){
      let text = "";
      for(let c of this.readarea[0].children){
        if(c.nodeName == "HR"){
          text += "\n";
        }else{
        text += c.value ? c.value : c.innerText;
        text += " ";
        }
      }
      text.trim();
      this.textarea.val(text);
      this._save();
    }
  
    async _onDrop(event) {
      event.preventDefault();
    }
  
    setPosition() {
      if (!this.object) return;
      const position = {
        "z-index": 100,
      };
      this.element.css(position);
      this.element.removeClass("token-notes-bottom-left");
      this.element.removeClass("token-notes-bottom-right");
      this.element.removeClass("token-notes-top-left");
      this.element.removeClass("token-notes-top-right");
      this.element.addClass(game.settings.get("token-notes", "position"));
    }

    static checkPermission(token){
      const permissionLevel = game.settings.get("token-notes", "allowplayers");
      if(game.user.isGM) return true;
      if(!token.isOwner) return false;
      if(permissionLevel == 0) return false;
      if(permissionLevel >= 1) return true; 
    }
  }