Hooks.once('init', async function() {

    ui.TokenNotes = new TokenNotes();

});

Hooks.once('ready', function() {

    game.settings.register("token-notes", "autoopen", {
      name: "tokennotes.settings.autoopen.name",
      hint: "tokennotes.settings.autoopen.hint",
      scope: "client",
      config: true,
      type: Boolean,
      default: true,
    });

    game.settings.register("token-notes", "allowplayers", {
      name: "tokennotes.settings.allowplayers.name",
      hint: "tokennotes.settings.allowplayers.hint",
      scope: "world",
      config: true,
      type: Number,
      choices: {
            0: "tokennotes.settings.allowplayers.options.none",
            1: "tokennotes.settings.allowplayers.options.readonly",
            2: "tokennotes.settings.allowplayers.options.readwrite",
        },
      default: 0,
    }); 

    game.settings.register("token-notes", "position", {
      name: "tokennotes.settings.position.name",
      hint: "tokennotes.settings.position.hint",
      scope: "world",
      config: true,
      type: String,
      choices: {
        "token-notes-bottom-left" : "tokennotes.settings.position.options.bottomleft",
        "token-notes-bottom-right" : "tokennotes.settings.position.options.bottomright",
        "token-notes-top-left" : "tokennotes.settings.position.options.topleft",
        "token-notes-top-right" : "tokennotes.settings.position.options.topright",
      },
      default: "token-notes-bottom-left",
      onChange: () => {
        ui.TokenNotes.setPosition();
      }
    }); 
    

});

Hooks.on("controlToken", (token,controlled) => {
    
    if(!game.settings.get("token-notes", "autoopen")) return;
    if(!TokenNotes.checkPermission(token)) return;
    if (controlled) {
        ui.TokenNotes.bind(token);
    } else {
        setTimeout(() => {
            if(!canvas.tokens.controlled.length) ui.TokenNotes.close();
        }, 500);
    }
});


Hooks.on("renderTokenHUD", (app,html) => {
    const token = app.object;
    if(!TokenNotes.checkPermission(token)) return;
    isNotesVisible = ui.TokenNotes.object == token;
    const colLeft = $(html).find(".left")
    const button = $(`
    <div class="control-icon ${isNotesVisible ? "active" : ""}" id="toggle-token-notes">
        <img src="icons/svg/book.svg" width="36" height="36" title="${game.i18n.localize("tokennotes.togglenotes")}">
        </div>
    `)
    colLeft.append(button);
    button.on("click", (e) => {
        button.toggleClass("active");
        const isBtnActive = button.hasClass("active");
        isBtnActive ? ui.TokenNotes.bind(token) : ui.TokenNotes.close();
    })
})

Hooks.on("collapseSidebar", (sidebar, collapsed) => {
    document.documentElement.style.setProperty(
      "--tn-sidebar",
      collapsed ? "0px" : "305px"
    );
  });