export async function flip(token, id) {
    const faces = token.document.getFlag("tokenflip", "tokenfaces") ?? [];
    if (!faces.length) return;
    const storedCurrId = token.document.flags?.tokenflip?.currentId;
    const currentIdExists = faces.find((f) => f.id === storedCurrId);
    const currentId = currentIdExists ? storedCurrId : faces[0].id;
    const currentFace = faces.find((f) => f.id === currentId);
    const currentIndex = faces.indexOf(currentFace);
    const nextId = id ?? faces[(currentIndex + 1) % faces.length].id;

    id = id ?? nextId;

    const nextFace = faces.find((f) => f.id === id);
    if (!nextFace) return;

    const tokenDocument = token.document;
    const animationSpeed = (game.settings.get("tokenflip", "flipspeed") || 0.1) * 2;

    const updateData = {
        actorId: nextFace.actorId,
        texture: {
            src: nextFace.img,
            scaleX: nextFace.scaleX,
            scaleY: nextFace.scaleY,
        },
        ring: {
            subject: {
            },
        },
        flags: {
            tokenflip: {
                currentId: nextId,
            },
            "levels-3d-preview": {},
        },
    };
    if (nextFace.width) updateData.width = nextFace.width;
    if (nextFace.height) updateData.height = nextFace.height;
    if (nextFace.subject) updateData.ring.subject.texture = nextFace.subject;
    if (nextFace.model3d) updateData.flags["levels-3d-preview"].model3d = nextFace.model3d;

    await tokenDocument.update(
        {
            texture: {
                scaleX: 0.0001,
            },
        },
        { animation: { duration: animationSpeed * 1000 } },
    );
    const p = CanvasAnimation.getAnimation("Token." + token.id + ".animate")?.promise;
    if (p) await p;
    else await new Promise((r) => setTimeout(r, animationSpeed * 1000));
    await tokenDocument.update(updateData, { animation: { duration: animationSpeed * 1000 } });
    return;
}
