export class TokenFlipConfig extends FormApplication {
    constructor(token, app) {
        super(token, app);
        this.object = token;
        this.actor = app.actor;
        this.app = app;
        this.isPrototype = this.app.isPrototype;
    }

    get currentData() {
        if (this.isPrototype) return this.actor.prototypeToken.flags?.tokenflip?.tokenfaces ?? [];
        return this.object.flags?.tokenflip?.tokenfaces ?? [];
    }

    static get defaultOptions() {
        return {
            ...super.defaultOptions,
            title: game.i18n.localize("tokenflip.config.formapp.title"),
            id: `tokenflip`,
            template: `modules/tokenflip/templates/tokenflip.hbs`,
            resizable: true,
            width: 400,
            dragDrop: [{ dragSelector: null, dropSelector: null }],
        };
    }

    async makeRandomActorUpdate() {
        if (!this.actor || !this.isPrototype) return;
        await this.actor.update({
            flags: {
                tokenflip: { unfuck: !this.actor.flags?.tokenflip?.unfuck },
            },
        });
        return;
    }

    render(force=false, options={}) {
        this._render(force, options);
        return this;
      }

    async getData() {
        let faces = this.currentData;
        const actorsarray = game.actors.contents.map((a) => ({ name: a.name, id: a.id }));
        if (!faces.length) {
            faces = [
                {
                    actorId: this.object.actor.id,
                    img: this.object.texture.src,
                    subject: this.object.ring.subject.texture,
                    id: foundry.utils.randomID(20),
                    scaleX: this.object.texture.scaleX,
                    scaleY: this.object.texture.scaleY,
                    width: this.object.width,
                    height: this.object.height,
                    model3d: this.object.flags["levels-3d-preview"]?.model3d ?? "",
                },
            ];
            await this.object.update({ flags: { tokenflip: { tokenfaces: faces } } });
        } else {
            faces.forEach((f) => {
                if (f.model3d === undefined) f.model3d = this.object.flags["levels-3d-preview"]?.model3d ?? "";
                if (!f.width) f.width = this.object.width;
                if (!f.height) f.height = this.object.height;
            });
        }

        faces = foundry.utils.deepClone(faces);

        faces.forEach((f) => {
            f.actorsarray = actorsarray;
        });

        return {
            actorsarray,
            tokenfaces: faces,
            isPrototype: this.isPrototype,
        };
    }

    async activateListeners(html) {
        super.activateListeners(html);
        this.element[0].querySelector("button#add").addEventListener("click", this._onAdd.bind(this));
        this.element.on("change", "input", this.saveData.bind(this));
        this.element.on("click", "button.delete", this._onDelete.bind(this));
        this.setPosition({ height: "auto", width: 400 });
    }

    async _onDelete(e) {
        $(e.currentTarget).closest("li").remove();
        await this.saveData();
        await this.makeRandomActorUpdate();
        this.setPosition({ height: "auto", width: 400 });
    }

    async _onAdd(e) {
        e.preventDefault();
        const data = this.currentData;
        const id = foundry.utils.randomID(20);
        data.push({
            actorId: this.object.actor.id,
            img: this.object.texture.img,
            subject: this.object.ring.subject.texture,
            id: id,
            scaleX: this.object.texture.scaleX,
            scaleY: this.object.texture.scaleY,
            width: this.object.width,
            height: this.object.height,
            model3d: this.object.flags["levels-3d-preview"]?.model3d ?? "",
        });
        await this.object.update({ flags: { tokenflip: { tokenfaces: data } } });
        await this.makeRandomActorUpdate();
        this.render(true);
    }

    close() {
        this.saveData();
        super.close();
    }

    async _updateObject() {
        return await this.saveData();
    }

    async saveData() {
        const ul = this.element[0].querySelector("ul");
        //loop ul
        let data = [];
        for (const li of ul.children) {
            const actorId = li.querySelector(`select`).value;
            const img = li.querySelector(`[name="img"]`).value;
            const subject = li.querySelector(`[name="subject"]`).value;
            const id = li.id;
            const scaleX = parseFloat(li.querySelector(`input[name="scaleX"]`).value);
            const scaleY = parseFloat(li.querySelector(`input[name="scaleY"]`).value);
            const width = parseFloat(li.querySelector(`input[name="width"]`).value);
            const height = parseFloat(li.querySelector(`input[name="height"]`).value);
            const model3d = li.querySelector(`[name="model3d"]`).value;
            data.push({ actorId, img, id, scaleX, scaleY, width, height, model3d, subject });
        }
        await this.object.update({ flags: { tokenflip: { tokenfaces: data } } });
        return await this.makeRandomActorUpdate();
    }
}
