"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateFinalDropPositions = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _tree = require("../../utils/tree");
var _flatTree = require("../../utils/flat-tree");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2.default)(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
/*
    Translates a drag&drop movement from an index based position to a relative (parent, index) position
*/
var calculateFinalDropPositions = exports.calculateFinalDropPositions = function calculateFinalDropPositions(tree, flattenedTree, dragState) {
  var source = dragState.source,
    destination = dragState.destination,
    combine = dragState.combine,
    horizontalLevel = dragState.horizontalLevel;
  var sourcePath = (0, _flatTree.getSourcePath)(flattenedTree, source.index);
  var sourcePosition = (0, _tree.getTreePosition)(tree, sourcePath);
  if (combine) {
    return {
      sourcePosition: sourcePosition,
      destinationPosition: {
        parentId: combine.draggableId
      }
    };
  }
  if (!destination) {
    return {
      sourcePosition: sourcePosition,
      destinationPosition: undefined
    };
  }
  var destinationPath = (0, _flatTree.getDestinationPath)(flattenedTree, source.index, destination.index, horizontalLevel);
  var destinationPosition = _objectSpread({}, (0, _tree.getTreePosition)(tree, destinationPath));
  return {
    sourcePosition: sourcePosition,
    destinationPosition: destinationPosition
  };
};