"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.range = exports.oneOf = exports.noop = exports.between = void 0;
var noop = exports.noop = function noop() {};
var range = exports.range = function range(n) {
  return Array.from({
    length: n
  }, function (v, i) {
    return i;
  });
};
var between = exports.between = function between(min, max, number) {
  return Math.min(max, Math.max(min, number));
};
var oneOf = exports.oneOf = function oneOf(a, b) {
  return typeof a !== 'undefined' ? a : b;
};