/// <reference types="node" />
import { S3ClientConfig } from "./S3Client";
/**
 * @internal
 */
export declare const getRuntimeConfig: (config: S3ClientConfig) => {
    runtime: string;
    sha256: import("@smithy/types").HashConstructor;
    requestHandler: (import("@smithy/types").RequestHandler<any, any, import("@smithy/types").HttpHandlerOptions> & import("@smithy/protocol-http").HttpHandler) | import("@smithy/fetch-http-handler").FetchHttpHandler;
    apiVersion: string;
    urlParser: import("@smithy/types").UrlParser;
    bodyLengthChecker: import("@smithy/types").BodyLengthCalculator;
    streamCollector: import("@smithy/types").StreamCollector;
    base64Decoder: import("@smithy/types").Decoder;
    base64Encoder: import("@smithy/types").Encoder;
    utf8Decoder: import("@smithy/types").Decoder;
    utf8Encoder: import("@smithy/types").Encoder;
    disableHostPrefix: boolean;
    serviceId: string;
    useDualstackEndpoint: boolean | import("@smithy/types").Provider<boolean>;
    useFipsEndpoint: boolean | import("@smithy/types").Provider<boolean>;
    region: string | import("@smithy/types").Provider<any>;
    credentialDefaultProvider: (input: any) => import("@smithy/types").Provider<import("@aws-sdk/types").Credentials>;
    signingEscapePath: boolean;
    useArnRegion: boolean | import("@smithy/types").Provider<boolean>;
    defaultUserAgentProvider: import("@smithy/types").Provider<import("@smithy/types").UserAgent>;
    streamHasher: import("@smithy/types").StreamHasher<import("stream").Readable> | import("@smithy/types").StreamHasher<Blob>;
    md5: import("@smithy/types").HashConstructor;
    sha1: import("@smithy/types").HashConstructor;
    getAwsChunkedEncodingStream: import("@smithy/types").GetAwsChunkedEncodingStream<any> | import("@smithy/types").GetAwsChunkedEncodingStream<import("stream").Readable>;
    maxAttempts: number | import("@smithy/types").Provider<number>;
    retryMode: string | import("@smithy/types").Provider<string>;
    logger: import("@smithy/types").Logger;
    eventStreamSerdeProvider: import("@smithy/types").EventStreamSerdeProvider;
    defaultsMode: import("@smithy/smithy-client").DefaultsMode | import("@smithy/types").Provider<import("@smithy/smithy-client").DefaultsMode>;
    sdkStreamMixin: import("@smithy/types").SdkStreamMixinInjector;
    endpoint?: string | import("@smithy/types").Endpoint | import("@smithy/types").Provider<import("@smithy/types").Endpoint> | import("@smithy/types").EndpointV2 | import("@smithy/types").Provider<import("@smithy/types").EndpointV2> | undefined;
    endpointProvider: (endpointParams: import("./endpoint/EndpointParameters").EndpointParameters, context?: {
        logger?: import("@smithy/types").Logger | undefined;
    }) => import("@smithy/types").EndpointV2;
    tls?: boolean | undefined;
    retryStrategy?: import("@smithy/types").RetryStrategy | import("@smithy/types").RetryStrategyV2 | undefined;
    credentials?: import("@smithy/types").AwsCredentialIdentity | import("@smithy/types").Provider<import("@smithy/types").AwsCredentialIdentity> | undefined;
    signer?: import("@smithy/types").RequestSigner | ((authScheme?: import("@smithy/types").AuthScheme | undefined) => Promise<import("@smithy/types").RequestSigner>) | undefined;
    systemClockOffset?: number | undefined;
    signingRegion?: string | undefined;
    signerConstructor: (new (options: import("@smithy/signature-v4").SignatureV4Init & import("@smithy/signature-v4").SignatureV4CryptoInit) => import("@smithy/types").RequestSigner) | typeof import("@aws-sdk/signature-v4-multi-region").SignatureV4MultiRegion;
    forcePathStyle?: boolean | undefined;
    useAccelerateEndpoint?: boolean | undefined;
    disableMultiregionAccessPoints?: boolean | undefined;
    customUserAgent?: string | import("@smithy/types").UserAgent | undefined;
    useGlobalEndpoint?: boolean | import("@smithy/types").Provider<boolean> | undefined;
};
