"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const CounterStyle_1 = __importDefault(require("../CounterStyle"));
const koreanHangulFormal = CounterStyle_1.default.additive({
    /* 9000 구천, 8000 팔천, 7000 칠천, 6000 육천, 5000 오천, 4000 사천,
       3000 삼천, 2000 이천, 1000 일천, 900 구백, 800 팔백, 700 칠백,
       600 육백, 500 오백, 400 사백, 300 삼백, 200 이백, 100 일백, 90 구십,
       80 팔십, 70 칠십, 60 육십, 50 오십, 40 사십, 30 삼십, 20 이십, 10 일십,
       9 구, 8 팔, 7 칠, 6 육, 5 오, 4 사, 3 삼, 2 이, 1 일, 0 영 */
    9000: '\u4E5D\u5343',
    8000: '\u516B\u5343',
    7000: '\u4E03\u5343',
    6000: '\u516D\u5343',
    5000: '\u4E94\u5343',
    4000: '\u56DB\u5343',
    3000: '\u4E09\u5343',
    2000: '\u4E8C\u5343',
    1000: '\u5343',
    900: '\u4E5D\u767E',
    800: '\u516B\u767E',
    700: '\u4E03\u767E',
    600: '\u516D\u767E',
    500: '\u4E94\u767E',
    400: '\u56DB\u767E',
    300: '\u4E09\u767E',
    200: '\u4E8C\u767E',
    100: '\u767E',
    90: '\u4E5D\u5341',
    80: '\u516B\u5341',
    70: '\u4E03\u5341',
    60: '\u516D\u5341',
    50: '\u4E94\u5341',
    40: '\u56DB\u5341',
    30: '\u4E09\u5341',
    20: '\u4E8C\u5341',
    10: '\u5341',
    9: '\u4E5D',
    8: '\u516B',
    7: '\u4E03',
    6: '\u516D',
    5: '\u4E94',
    4: '\u56DB',
    3: '\u4E09',
    2: '\u4E8C',
    1: '\u4E00',
    0: '\u96F6'
})
    .withNegative('\uB9C8\uC774\uB108\uC2A4 ' /* 마이너스 (space) */)
    .withRange(-9999, 9999)
    .withSuffix(constants_1.CJK_SUFFIX);
exports.default = koreanHangulFormal;
//# sourceMappingURL=koreanHangulFormal.js.map