import { IconCategory, FigmaCategory } from "./types";
export type PhosphorIcon = (typeof icons)[number];
export declare const icons: readonly [{
    readonly name: "acorn";
    readonly pascal_name: "Acorn";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "savings", "nut", "vegetable", "veggies", "food", "groceries", "market"];
    readonly codepoint: 60314;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "address-book";
    readonly pascal_name: "AddressBook";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["contacts", "directory", "roledex"];
    readonly codepoint: 59128;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "address-book-tabs";
    readonly pascal_name: "AddressBookTabs";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "contacts", "directory", "roledex"];
    readonly codepoint: 61006;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "air-traffic-control";
    readonly pascal_name: "AirTrafficControl";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["airport", "travel", "transportation", "buildings"];
    readonly codepoint: 60632;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "airplane";
    readonly pascal_name: "Airplane";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "airports", "flights", "flying", "planes", "transit", "transportation", "traveling"];
    readonly codepoint: 57346;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "airplane-in-flight";
    readonly pascal_name: "AirplaneInFlight";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "airports", "flights", "flying", "planes", "transit", "transportation", "traveling", "arrival"];
    readonly codepoint: 58622;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "airplane-landing";
    readonly pascal_name: "AirplaneLanding";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "airports", "flights", "flying", "planes", "transit", "transportation", "traveling", "arrival"];
    readonly codepoint: 58626;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "airplane-takeoff";
    readonly pascal_name: "AirplaneTakeoff";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "airports", "flights", "flying", "planes", "transit", "transportation", "traveling", "departure"];
    readonly codepoint: 58628;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "airplane-taxiing";
    readonly pascal_name: "AirplaneTaxiing";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "vehicles", "airports", "flights", "flying", "planes", "transit", "transportation", "traveling", "arrival"];
    readonly codepoint: 58624;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "airplane-tilt";
    readonly pascal_name: "AirplaneTilt";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "airports", "flights", "flying", "planes", "transit", "transportation", "traveling", "departure"];
    readonly codepoint: 58838;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "airplay";
    readonly pascal_name: "Airplay";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["apple", "screencasting", "television", "tv"];
    readonly codepoint: 57348;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "alarm";
    readonly pascal_name: "Alarm";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "clock", "schedule", "events", "watch"];
    readonly codepoint: 57350;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "alien";
    readonly pascal_name: "Alien";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["ufo", "space", "flying saucer", "extra terrestrial", "sci-fi"];
    readonly codepoint: 59558;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "align-bottom";
    readonly pascal_name: "AlignBottom";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush bottom"];
    readonly codepoint: 58630;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "align-bottom-simple";
    readonly pascal_name: "AlignBottomSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush bottom"];
    readonly codepoint: 60172;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "align-center-horizontal";
    readonly pascal_name: "AlignCenterHorizontal";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "centered", "middle"];
    readonly codepoint: 58634;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "align-center-horizontal-simple";
    readonly pascal_name: "AlignCenterHorizontalSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "centered", "middle"];
    readonly codepoint: 60174;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "align-center-vertical";
    readonly pascal_name: "AlignCenterVertical";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "centered", "middle"];
    readonly codepoint: 58636;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "align-center-vertical-simple";
    readonly pascal_name: "AlignCenterVerticalSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "centered", "middle"];
    readonly codepoint: 60176;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "align-left";
    readonly pascal_name: "AlignLeft";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush left"];
    readonly codepoint: 58638;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "align-left-simple";
    readonly pascal_name: "AlignLeftSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush left"];
    readonly codepoint: 60142;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "align-right";
    readonly pascal_name: "AlignRight";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush right"];
    readonly codepoint: 58640;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "align-right-simple";
    readonly pascal_name: "AlignRightSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush right"];
    readonly codepoint: 60178;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "align-top";
    readonly pascal_name: "AlignTop";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush top"];
    readonly codepoint: 58642;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "align-top-simple";
    readonly pascal_name: "AlignTopSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["alignment", "arrangement", "layout", "flush top"];
    readonly codepoint: 60180;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "amazon-logo";
    readonly pascal_name: "AmazonLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["ecommerce", "shopping", "logos"];
    readonly codepoint: 59756;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "ambulance";
    readonly pascal_name: "Ambulance";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["*new*", "first-aid", "emt", "medical", "medicine", "injury", "safety", "emergency", "doctor", "vehicles"];
    readonly codepoint: 58738;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "anchor";
    readonly pascal_name: "Anchor";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["nautical", "boats", "ships", "hope", "safety", "insurance"];
    readonly codepoint: 58644;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "anchor-simple";
    readonly pascal_name: "AnchorSimple";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["nautical", "boats", "ships", "hope", "safety", "insurance"];
    readonly codepoint: 58840;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "android-logo";
    readonly pascal_name: "AndroidLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "google", "mobile", "phone", "cellular", "cellphone"];
    readonly codepoint: 57352;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "angle";
    readonly pascal_name: "Angle";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "geometry", "trigonometry", "degrees", "radians", "measurement", "protractor", "compass", "arc"];
    readonly codepoint: 59324;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "angular-logo";
    readonly pascal_name: "AngularLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["framework", "javascript", "google", "web"];
    readonly codepoint: 60288;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "aperture";
    readonly pascal_name: "Aperture";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["photography", "cameras", "pictures", "lens"];
    readonly codepoint: 57354;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "app-store-logo";
    readonly pascal_name: "AppStoreLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["macintosh", "imac", "iphone", "ipad", "macos", "ios"];
    readonly codepoint: 59764;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "app-window";
    readonly pascal_name: "AppWindow";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["windows", "software", "programs", "applications"];
    readonly codepoint: 58842;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "apple-logo";
    readonly pascal_name: "AppleLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["macintosh", "imac", "iphone", "ipad", "macos", "ios"];
    readonly codepoint: 58646;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "apple-podcasts-logo";
    readonly pascal_name: "ApplePodcastsLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["macintosh", "imac", "iphone", "ipad", "macos", "ios"];
    readonly codepoint: 60310;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "approximate-equals";
    readonly pascal_name: "ApproximateEquals";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "≈", "is approximately equal to", "congruent", "equality", "equivalent", "equivalence", "comparison", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60842;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "archive";
    readonly pascal_name: "Archive";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "downloaded", "downloading"];
    readonly codepoint: 57356;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "armchair";
    readonly pascal_name: "Armchair";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["seat", "furniture"];
    readonly codepoint: 57362;
    readonly published_in: 1.2;
    readonly updated_in: 1.4;
}, {
    readonly name: "arrow-arc-left";
    readonly pascal_name: "ArrowArcLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57364;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-arc-right";
    readonly pascal_name: "ArrowArcRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57366;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-double-up-left";
    readonly pascal_name: "ArrowBendDoubleUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "reply-all"];
    readonly codepoint: 57402;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-double-up-right";
    readonly pascal_name: "ArrowBendDoubleUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57404;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-down-left";
    readonly pascal_name: "ArrowBendDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57368;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-down-right";
    readonly pascal_name: "ArrowBendDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57370;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-left-down";
    readonly pascal_name: "ArrowBendLeftDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57372;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-left-up";
    readonly pascal_name: "ArrowBendLeftUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57374;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-right-down";
    readonly pascal_name: "ArrowBendRightDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57376;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-right-up";
    readonly pascal_name: "ArrowBendRightUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57378;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-up-left";
    readonly pascal_name: "ArrowBendUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "reply", "re"];
    readonly codepoint: 57380;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-bend-up-right";
    readonly pascal_name: "ArrowBendUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "forward", "fwd"];
    readonly codepoint: 57382;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-down";
    readonly pascal_name: "ArrowCircleDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57384;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-down-left";
    readonly pascal_name: "ArrowCircleDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57386;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-down-right";
    readonly pascal_name: "ArrowCircleDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57388;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-left";
    readonly pascal_name: "ArrowCircleLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57434;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-right";
    readonly pascal_name: "ArrowCircleRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57390;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-up";
    readonly pascal_name: "ArrowCircleUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57392;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-up-left";
    readonly pascal_name: "ArrowCircleUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57394;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-circle-up-right";
    readonly pascal_name: "ArrowCircleUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57396;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-clockwise";
    readonly pascal_name: "ArrowClockwise";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "redo", "refreshing", "rotate", "spin", "flip"];
    readonly codepoint: 57398;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrow-counter-clockwise";
    readonly pascal_name: "ArrowCounterClockwise";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "undo", "refreshing", "rotate", "spin", "flip"];
    readonly codepoint: 57400;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrow-down";
    readonly pascal_name: "ArrowDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57406;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-down-left";
    readonly pascal_name: "ArrowDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57408;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-down-right";
    readonly pascal_name: "ArrowDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57410;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-down-left";
    readonly pascal_name: "ArrowElbowDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57412;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-down-right";
    readonly pascal_name: "ArrowElbowDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57414;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-left";
    readonly pascal_name: "ArrowElbowLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57416;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-left-down";
    readonly pascal_name: "ArrowElbowLeftDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57418;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-left-up";
    readonly pascal_name: "ArrowElbowLeftUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57420;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-right";
    readonly pascal_name: "ArrowElbowRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57422;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-right-down";
    readonly pascal_name: "ArrowElbowRightDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57424;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-right-up";
    readonly pascal_name: "ArrowElbowRightUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57426;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-up-left";
    readonly pascal_name: "ArrowElbowUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57428;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-elbow-up-right";
    readonly pascal_name: "ArrowElbowUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57430;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-fat-down";
    readonly pascal_name: "ArrowFatDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58648;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-left";
    readonly pascal_name: "ArrowFatLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58650;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-line-down";
    readonly pascal_name: "ArrowFatLineDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58652;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-line-left";
    readonly pascal_name: "ArrowFatLineLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58654;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-line-right";
    readonly pascal_name: "ArrowFatLineRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58656;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-line-up";
    readonly pascal_name: "ArrowFatLineUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "caps lock", "outlined"];
    readonly codepoint: 58658;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-lines-down";
    readonly pascal_name: "ArrowFatLinesDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58660;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-lines-left";
    readonly pascal_name: "ArrowFatLinesLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58662;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-lines-right";
    readonly pascal_name: "ArrowFatLinesRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58664;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-lines-up";
    readonly pascal_name: "ArrowFatLinesUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58666;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-right";
    readonly pascal_name: "ArrowFatRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "outlined"];
    readonly codepoint: 58668;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-fat-up";
    readonly pascal_name: "ArrowFatUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "shift", "outlined"];
    readonly codepoint: 58670;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "arrow-left";
    readonly pascal_name: "ArrowLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57432;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-down";
    readonly pascal_name: "ArrowLineDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "bottom"];
    readonly codepoint: 57436;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-down-left";
    readonly pascal_name: "ArrowLineDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57438;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-down-right";
    readonly pascal_name: "ArrowLineDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57440;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-left";
    readonly pascal_name: "ArrowLineLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57442;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-right";
    readonly pascal_name: "ArrowLineRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57444;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-up";
    readonly pascal_name: "ArrowLineUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "top"];
    readonly codepoint: 57446;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-up-left";
    readonly pascal_name: "ArrowLineUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57448;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-line-up-right";
    readonly pascal_name: "ArrowLineUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57450;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-right";
    readonly pascal_name: "ArrowRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57452;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-down";
    readonly pascal_name: "ArrowSquareDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57454;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-down-left";
    readonly pascal_name: "ArrowSquareDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57456;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-down-right";
    readonly pascal_name: "ArrowSquareDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57458;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-in";
    readonly pascal_name: "ArrowSquareIn";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["import", "directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 58844;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "arrow-square-left";
    readonly pascal_name: "ArrowSquareLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57460;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-out";
    readonly pascal_name: "ArrowSquareOut";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["export", "external", "directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 58846;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "arrow-square-right";
    readonly pascal_name: "ArrowSquareRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57462;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-up";
    readonly pascal_name: "ArrowSquareUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57464;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-up-left";
    readonly pascal_name: "ArrowSquareUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57466;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-square-up-right";
    readonly pascal_name: "ArrowSquareUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57468;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-down-left";
    readonly pascal_name: "ArrowUDownLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "undo", "return", "u-turns"];
    readonly codepoint: 57470;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-down-right";
    readonly pascal_name: "ArrowUDownRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "redo", "u-turns"];
    readonly codepoint: 57472;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-left-down";
    readonly pascal_name: "ArrowULeftDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "undo", "return", "u-turns"];
    readonly codepoint: 57474;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-left-up";
    readonly pascal_name: "ArrowULeftUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "redo", "u-turns"];
    readonly codepoint: 57476;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-right-down";
    readonly pascal_name: "ArrowURightDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "undo", "return", "u-turns"];
    readonly codepoint: 57478;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-right-up";
    readonly pascal_name: "ArrowURightUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "redo", "u-turns"];
    readonly codepoint: 57480;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-up-left";
    readonly pascal_name: "ArrowUUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "undo", "return", "u-turns"];
    readonly codepoint: 57482;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-u-up-right";
    readonly pascal_name: "ArrowUUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead", "redo", "u-turns"];
    readonly codepoint: 57484;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-up";
    readonly pascal_name: "ArrowUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57486;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-up-left";
    readonly pascal_name: "ArrowUpLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57488;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrow-up-right";
    readonly pascal_name: "ArrowUpRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57490;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "arrows-clockwise";
    readonly pascal_name: "ArrowsClockwise";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "redo", "refreshing", "sync", "synchronize", "rotate", "spin", "flip"];
    readonly codepoint: 57492;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-counter-clockwise";
    readonly pascal_name: "ArrowsCounterClockwise";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "undo", "refreshing", "rotate", "spin", "flip"];
    readonly codepoint: 57494;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-down-up";
    readonly pascal_name: "ArrowsDownUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57496;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-horizontal";
    readonly pascal_name: "ArrowsHorizontal";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "cursor", "resize", "expand", "left", "right"];
    readonly codepoint: 60166;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-in";
    readonly pascal_name: "ArrowsIn";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "collapse", "minimize", "resize", "shrink"];
    readonly codepoint: 57498;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-in-cardinal";
    readonly pascal_name: "ArrowsInCardinal";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "collapse", "minimize", "resize", "shrink"];
    readonly codepoint: 57500;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-in-line-horizontal";
    readonly pascal_name: "ArrowsInLineHorizontal";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "close", "center", "align"];
    readonly codepoint: 58672;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-in-line-vertical";
    readonly pascal_name: "ArrowsInLineVertical";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "close", "center", "align"];
    readonly codepoint: 58674;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-in-simple";
    readonly pascal_name: "ArrowsInSimple";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "collapse", "minimize", "resize"];
    readonly codepoint: 57502;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-left-right";
    readonly pascal_name: "ArrowsLeftRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57504;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-merge";
    readonly pascal_name: "ArrowsMerge";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "arrowheads", "join", "combine"];
    readonly codepoint: 60734;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-out";
    readonly pascal_name: "ArrowsOut";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "expand", "fullscreen", "resize", "grow"];
    readonly codepoint: 57506;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-out-cardinal";
    readonly pascal_name: "ArrowsOutCardinal";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "expand", "fullscreen", "resize", "pan", "move", "grow"];
    readonly codepoint: 57508;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-out-line-horizontal";
    readonly pascal_name: "ArrowsOutLineHorizontal";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "open", "split"];
    readonly codepoint: 58676;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-out-line-vertical";
    readonly pascal_name: "ArrowsOutLineVertical";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "open", "split"];
    readonly codepoint: 58678;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-out-simple";
    readonly pascal_name: "ArrowsOutSimple";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "pointing", "arrowhead", "expand", "fullscreen", "resize"];
    readonly codepoint: 57510;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-split";
    readonly pascal_name: "ArrowsSplit";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "arrowheads", "fork"];
    readonly codepoint: 60732;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "arrows-vertical";
    readonly pascal_name: "ArrowsVertical";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*updated*", "directional", "pointer", "cursor", "resize", "expand", "up", "down"];
    readonly codepoint: 60164;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "article";
    readonly pascal_name: "Article";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["reading", "writing", "journals", "periodicals", "text", "newspaper"];
    readonly codepoint: 57512;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "article-medium";
    readonly pascal_name: "ArticleMedium";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "reading", "writing", "journals", "periodicals", "text", "newspaper"];
    readonly codepoint: 58848;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "article-ny-times";
    readonly pascal_name: "ArticleNyTimes";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "reading", "writing", "journals", "periodicals", "text", "news", "newspaper", "nyt", "new york times"];
    readonly codepoint: 58850;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "asclepius";
    readonly pascal_name: "Asclepius";
    readonly alias: {
        readonly name: "caduceus";
        readonly pascal_name: "Caduceus";
    };
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["*new*", "caduceus", "staff", "mythology", "rx", "medicine", "drugs", "pharmacy", "pharmacist", "pharmaceuticals", "doctor", "hospital", "snake", "mercury", "hermes"];
    readonly codepoint: 60980;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "asterisk";
    readonly pascal_name: "Asterisk";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["star", "wildcard", "bullet point", "6", "emergency"];
    readonly codepoint: 57514;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "asterisk-simple";
    readonly pascal_name: "AsteriskSimple";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*updated*", "star", "wildcard", "bullet point", "5", "emergency"];
    readonly codepoint: 59442;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "at";
    readonly pascal_name: "At";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["@", "address", "email", "at symbol", "commercial at", "arobase"];
    readonly codepoint: 57516;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "atom";
    readonly pascal_name: "Atom";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["atomic", "nucleus", "nuclear", "reactor", "science", "physics", "electron", "automation", "react"];
    readonly codepoint: 58852;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "avocado";
    readonly pascal_name: "Avocado";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "food", "vegetable", "veggie", "fruit", "groceries", "market"];
    readonly codepoint: 60932;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "axe";
    readonly pascal_name: "Axe";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "tools", "carpentry", "forestry", "construction"];
    readonly codepoint: 59900;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "baby";
    readonly pascal_name: "Baby";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["infant", "child", "children", "toddler"];
    readonly codepoint: 59252;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "baby-carriage";
    readonly pascal_name: "BabyCarriage";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "pram", "stroller", "infant", "child", "children", "toddler"];
    readonly codepoint: 59416;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "backpack";
    readonly pascal_name: "Backpack";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["knapsack", "camping", "school", "bag"];
    readonly codepoint: 59682;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "backspace";
    readonly pascal_name: "Backspace";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["keyboard", "remove", "delete"];
    readonly codepoint: 57518;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bag";
    readonly pascal_name: "Bag";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["suitcase", "valise", "baggage", "folders", "portfolio"];
    readonly codepoint: 57520;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bag-simple";
    readonly pascal_name: "BagSimple";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["suitcase", "valise", "baggage", "folders", "portfolio"];
    readonly codepoint: 58854;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "balloon";
    readonly pascal_name: "Balloon";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["helium", "birthday", "party"];
    readonly codepoint: 59244;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "bandaids";
    readonly pascal_name: "Bandaids";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["bandages", "medical", "medicine", "first aid", "injury"];
    readonly codepoint: 57522;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bank";
    readonly pascal_name: "Bank";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["banking", "checking", "money", "savings", "deposit", "withdraw", "places", "locations"];
    readonly codepoint: 57524;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "barbell";
    readonly pascal_name: "Barbell";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["gym", "weights", "dumbbells", "strength training", "workout", "exercises", "fitness"];
    readonly codepoint: 57526;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "barcode";
    readonly pascal_name: "Barcode";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["upc", "qr", "products", "shopping", "scanner"];
    readonly codepoint: 57528;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "barn";
    readonly pascal_name: "Barn";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "animals", "livestock", "buildings", "farming", "agriculture"];
    readonly codepoint: 60530;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "barricade";
    readonly pascal_name: "Barricade";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["construction", "safety", "gate"];
    readonly codepoint: 59720;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "baseball";
    readonly pascal_name: "Baseball";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["sports", "mlb"];
    readonly codepoint: 59162;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "baseball-cap";
    readonly pascal_name: "BaseballCap";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothes", "clothing", "sports", "hat"];
    readonly codepoint: 59944;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "baseball-helmet";
    readonly pascal_name: "BaseballHelmet";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "mlb"];
    readonly codepoint: 61002;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "basket";
    readonly pascal_name: "Basket";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ecommerce", "market", "cart", "buying", "shopping", "groceries", "checkout", "places", "locations"];
    readonly codepoint: 59748;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "basketball";
    readonly pascal_name: "Basketball";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["sports", "nba"];
    readonly codepoint: 59172;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "bathtub";
    readonly pascal_name: "Bathtub";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["bath", "shower", "bathroom", "faucet"];
    readonly codepoint: 59422;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "battery-charging";
    readonly pascal_name: "BatteryCharging";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 57530;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-charging-vertical";
    readonly pascal_name: "BatteryChargingVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 57532;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-empty";
    readonly pascal_name: "BatteryEmpty";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power", "dead"];
    readonly codepoint: 57534;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-full";
    readonly pascal_name: "BatteryFull";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power", "filled"];
    readonly codepoint: 57536;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-high";
    readonly pascal_name: "BatteryHigh";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 57538;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-low";
    readonly pascal_name: "BatteryLow";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 57540;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-medium";
    readonly pascal_name: "BatteryMedium";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 57542;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "battery-plus";
    readonly pascal_name: "BatteryPlus";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 59400;
    readonly published_in: 1.4;
    readonly updated_in: 2;
}, {
    readonly name: "battery-plus-vertical";
    readonly pascal_name: "BatteryPlusVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 60496;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "battery-vertical-empty";
    readonly pascal_name: "BatteryVerticalEmpty";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power", "dead"];
    readonly codepoint: 59334;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "battery-vertical-full";
    readonly pascal_name: "BatteryVerticalFull";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 59332;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "battery-vertical-high";
    readonly pascal_name: "BatteryVerticalHigh";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 59330;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "battery-vertical-low";
    readonly pascal_name: "BatteryVerticalLow";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 59326;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "battery-vertical-medium";
    readonly pascal_name: "BatteryVerticalMedium";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power"];
    readonly codepoint: 59328;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "battery-warning";
    readonly pascal_name: "BatteryWarning";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power", "empty", "critical"];
    readonly codepoint: 57544;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "battery-warning-vertical";
    readonly pascal_name: "BatteryWarningVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "power", "empty", "critical"];
    readonly codepoint: 57546;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "beach-ball";
    readonly pascal_name: "BeachBall";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "ocean", "party"];
    readonly codepoint: 60708;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "beanie";
    readonly pascal_name: "Beanie";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "clothes", "clothing", "sports", "hat", "winter"];
    readonly codepoint: 59946;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bed";
    readonly pascal_name: "Bed";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["hotels", "accommodations", "sleeping", "places", "locations", "medical", "hospital"];
    readonly codepoint: 57548;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "beer-bottle";
    readonly pascal_name: "BeerBottle";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["drinks", "beverages", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 59312;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "beer-stein";
    readonly pascal_name: "BeerStein";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["drinks", "beverages", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 60258;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "behance-logo";
    readonly pascal_name: "BehanceLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "illustration", "ui", "interface"];
    readonly codepoint: 59380;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "bell";
    readonly pascal_name: "Bell";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "calls"];
    readonly codepoint: 57550;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bell-ringing";
    readonly pascal_name: "BellRinging";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "calls"];
    readonly codepoint: 58856;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "bell-simple";
    readonly pascal_name: "BellSimple";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "calls"];
    readonly codepoint: 57552;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bell-simple-ringing";
    readonly pascal_name: "BellSimpleRinging";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "calls"];
    readonly codepoint: 58858;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "bell-simple-slash";
    readonly pascal_name: "BellSimpleSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "silent", "silenced", "disabled"];
    readonly codepoint: 57554;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bell-simple-z";
    readonly pascal_name: "BellSimpleZ";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "snooze"];
    readonly codepoint: 58860;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "bell-slash";
    readonly pascal_name: "BellSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "silent", "silenced", "ringer", "calls", "disabled"];
    readonly codepoint: 57556;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bell-z";
    readonly pascal_name: "BellZ";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["alarm", "notifications", "times", "timer", "clock", "schedule", "events", "ringer", "snooze"];
    readonly codepoint: 58862;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "belt";
    readonly pascal_name: "Belt";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "clothes", "clothing"];
    readonly codepoint: 59948;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bezier-curve";
    readonly pascal_name: "BezierCurve";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "drawing", "path", "pen", "vector"];
    readonly codepoint: 60160;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "bicycle";
    readonly pascal_name: "Bicycle";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["bikers", "bicycling", "cyclists", "transit", "transportation", "commuter", "exercises", "fitness"];
    readonly codepoint: 57558;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "binary";
    readonly pascal_name: "Binary";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*new*", "digital", "0", "1", "programming", "coding", "executable"];
    readonly codepoint: 61024;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "binoculars";
    readonly pascal_name: "Binoculars";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["telescope", "glasses", "search", "find", "explore"];
    readonly codepoint: 60004;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "biohazard";
    readonly pascal_name: "Biohazard";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["*new*", "contamination", "quarantine", "toxic", "poison", "danger", "caution"];
    readonly codepoint: 59872;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bird";
    readonly pascal_name: "Bird";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*updated*", "animals", "pets"];
    readonly codepoint: 59180;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "blueprint";
    readonly pascal_name: "Blueprint";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "architecture", "layout", "floorplan", "building", "construction"];
    readonly codepoint: 60832;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bluetooth";
    readonly pascal_name: "Bluetooth";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "connection", "connected", "connectivity"];
    readonly codepoint: 57562;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bluetooth-connected";
    readonly pascal_name: "BluetoothConnected";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "connection", "connected", "connectivity"];
    readonly codepoint: 57564;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bluetooth-slash";
    readonly pascal_name: "BluetoothSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "connection", "connectivity", "disconnected", "disabled"];
    readonly codepoint: 57566;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bluetooth-x";
    readonly pascal_name: "BluetoothX";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "connection", "connectivity", "disconnected", "errors"];
    readonly codepoint: 57568;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "boat";
    readonly pascal_name: "Boat";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["ferry", "ship", "cruise", "vehicles", "public transit", "transportation", "commuter", "traveling", "sailing", "places", "locations"];
    readonly codepoint: 59270;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "bomb";
    readonly pascal_name: "Bomb";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "gaming", "grenade", "explosive", "war", "weapon", "fuse"];
    readonly codepoint: 60938;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bone";
    readonly pascal_name: "Bone";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["dogbone"];
    readonly codepoint: 59378;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "book";
    readonly pascal_name: "Book";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "novel", "story", "library"];
    readonly codepoint: 57570;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "book-bookmark";
    readonly pascal_name: "BookBookmark";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "novel", "story", "library", "favorites", "favorited"];
    readonly codepoint: 57572;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "book-open";
    readonly pascal_name: "BookOpen";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["*updated*", "reading", "reader", "novel", "story", "library"];
    readonly codepoint: 57574;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "book-open-text";
    readonly pascal_name: "BookOpenText";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["*updated*", "reading", "reader", "novel", "story", "library"];
    readonly codepoint: 59634;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "book-open-user";
    readonly pascal_name: "BookOpenUser";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["*new*", "reading", "reader", "easy read", "library", "places", "locations"];
    readonly codepoint: 60896;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bookmark";
    readonly pascal_name: "Bookmark";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "novel", "story", "placeholder", "favorites", "favorited", "library"];
    readonly codepoint: 57576;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bookmark-simple";
    readonly pascal_name: "BookmarkSimple";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "novel", "story", "placeholder", "favorites", "favorited", "library"];
    readonly codepoint: 57578;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bookmarks";
    readonly pascal_name: "Bookmarks";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "novel", "story", "placeholder", "favorites", "favorited", "library"];
    readonly codepoint: 57580;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bookmarks-simple";
    readonly pascal_name: "BookmarksSimple";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "novel", "story", "placeholder", "favorites", "favorited", "library"];
    readonly codepoint: 58864;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "books";
    readonly pascal_name: "Books";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MAP, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["reading", "reader", "bookshelf", "library", "places", "locations"];
    readonly codepoint: 59224;
    readonly published_in: 1.3;
    readonly updated_in: 2;
}, {
    readonly name: "boot";
    readonly pascal_name: "Boot";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["hiking", "shoes", "sports", "exercise"];
    readonly codepoint: 60618;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "boules";
    readonly pascal_name: "Boules";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "balls", "sports", "pétanque", "raffa", "bocce", "boule lyonnaise", "lawn bowls"];
    readonly codepoint: 59170;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bounding-box";
    readonly pascal_name: "BoundingBox";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["polygon", "shapes", "outline", "corners", "rectangle"];
    readonly codepoint: 59086;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "bowl-food";
    readonly pascal_name: "BowlFood";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ramen", "food", "meal", "eating", "restaurants", "dining", "locations"];
    readonly codepoint: 60068;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "bowl-steam";
    readonly pascal_name: "BowlSteam";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "food", "meal", "eating", "restaurants", "dining", "locations"];
    readonly codepoint: 59620;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bowling-ball";
    readonly pascal_name: "BowlingBall";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "alley"];
    readonly codepoint: 59956;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "box-arrow-down";
    readonly pascal_name: "BoxArrowDown";
    readonly alias: {
        readonly name: "archive-box";
        readonly pascal_name: "ArchiveBox";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "downloaded", "downloading"];
    readonly codepoint: 57358;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "box-arrow-up";
    readonly pascal_name: "BoxArrowUp";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "unarchive", "archival", "upload"];
    readonly codepoint: 61012;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "boxing-glove";
    readonly pascal_name: "BoxingGlove";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "combat", "martial arts", "fight", "gym"];
    readonly codepoint: 59958;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "brackets-angle";
    readonly pascal_name: "BracketsAngle";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["code", "angle brackets", "angle braces"];
    readonly codepoint: 59490;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "brackets-curly";
    readonly pascal_name: "BracketsCurly";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["code", "curly brackets", "curly braces"];
    readonly codepoint: 59488;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "brackets-round";
    readonly pascal_name: "BracketsRound";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["code", "parentheses", "round brackets", "round braces"];
    readonly codepoint: 59492;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "brackets-square";
    readonly pascal_name: "BracketsSquare";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["code", "square brackets", "square braces", "array"];
    readonly codepoint: 59486;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "brain";
    readonly pascal_name: "Brain";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["mind", "mental"];
    readonly codepoint: 59214;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "brandy";
    readonly pascal_name: "Brandy";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["drinks", "beverages", "whiskey", "cocktail", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 59060;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "bread";
    readonly pascal_name: "Bread";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "food", "meal", "bakery", "sandwich", "gluten", "loaf", "toast", "slice"];
    readonly codepoint: 59420;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bridge";
    readonly pascal_name: "Bridge";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["travel", "transportation", "infrastucture"];
    readonly codepoint: 60008;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "briefcase";
    readonly pascal_name: "Briefcase";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["suitcase", "valise", "baggage", "folders", "portfolio"];
    readonly codepoint: 57582;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "briefcase-metal";
    readonly pascal_name: "BriefcaseMetal";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["suitcase", "valise", "baggage", "folders", "portfolio"];
    readonly codepoint: 58866;
    readonly published_in: 1.2;
    readonly updated_in: 1.4;
}, {
    readonly name: "broadcast";
    readonly pascal_name: "Broadcast";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["radio", "hotspot", "wifi", "emit"];
    readonly codepoint: 57586;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "broom";
    readonly pascal_name: "Broom";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["sweeping", "cleaning"];
    readonly codepoint: 60500;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "browser";
    readonly pascal_name: "Browser";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["web browsers", "windows", "internet", "website", "webpage", "chrome", "edge", "firefox"];
    readonly codepoint: 57588;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "browsers";
    readonly pascal_name: "Browsers";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["web browsers", "windows", "internet", "website", "webpage", "chrome", "edge", "firefox"];
    readonly codepoint: 57590;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "bug";
    readonly pascal_name: "Bug";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["debug", "errors", "insect", "ladybug"];
    readonly codepoint: 58868;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "bug-beetle";
    readonly pascal_name: "BugBeetle";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["debug", "errors", "insect", "ladybug"];
    readonly codepoint: 58870;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "bug-droid";
    readonly pascal_name: "BugDroid";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["debug", "errors", "insect", "android", "google"];
    readonly codepoint: 58872;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "building";
    readonly pascal_name: "Building";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "places", "locations", "company", "business", "buildings"];
    readonly codepoint: 57600;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "building-apartment";
    readonly pascal_name: "BuildingApartment";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "places", "locations", "buildings"];
    readonly codepoint: 57598;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "building-office";
    readonly pascal_name: "BuildingOffice";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "places", "locations", "company", "business", "buildings"];
    readonly codepoint: 57598;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "buildings";
    readonly pascal_name: "Buildings";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["places", "locations", "company", "business"];
    readonly codepoint: 57602;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "bulldozer";
    readonly pascal_name: "Bulldozer";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "vehicles", "construction", "earth mover", "dig", "digger"];
    readonly codepoint: 60524;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "bus";
    readonly pascal_name: "Bus";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "automobile", "public transit", "transportation", "commuter", "traveling", "places", "locations"];
    readonly codepoint: 57606;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "butterfly";
    readonly pascal_name: "Butterfly";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["animals", "insects", "moth"];
    readonly codepoint: 60014;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "cable-car";
    readonly pascal_name: "CableCar";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "vehicles", "gondola", "skiing", "mountains", "public transit", "transportation", "commuter", "traveling", "places", "locations"];
    readonly codepoint: 58524;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cactus";
    readonly pascal_name: "Cactus";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*updated*", "plants", "cacti", "desert", "western"];
    readonly codepoint: 59672;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "cake";
    readonly pascal_name: "Cake";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["dessert", "birthday", "celebration", "event"];
    readonly codepoint: 59264;
    readonly published_in: 1.3;
    readonly updated_in: 2;
}, {
    readonly name: "calculator";
    readonly pascal_name: "Calculator";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE, IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["addition", "sum", "subtraction", "difference", "multiply", "multiplication", "product", "divide", "division", "divisor", "dividend", "quotient", "equals", "equality", "mathematics", "arithmetic", "+", "-", "±", "×", "÷", "="];
    readonly codepoint: 58680;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "calendar";
    readonly pascal_name: "Calendar";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["dates", "times", "events", "schedule", "12"];
    readonly codepoint: 57608;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "calendar-blank";
    readonly pascal_name: "CalendarBlank";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["dates", "times", "events", "schedule", "none"];
    readonly codepoint: 57610;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "calendar-check";
    readonly pascal_name: "CalendarCheck";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["dates", "times", "events", "schedule", "todo", "checklist"];
    readonly codepoint: 59154;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "calendar-dot";
    readonly pascal_name: "CalendarDot";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "dates", "times", "events", "schedule", "today"];
    readonly codepoint: 59314;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "calendar-dots";
    readonly pascal_name: "CalendarDots";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "dates", "times", "events", "schedule"];
    readonly codepoint: 59316;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "calendar-heart";
    readonly pascal_name: "CalendarHeart";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "dates", "times", "events", "schedule", "favorite", "star"];
    readonly codepoint: 59568;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "calendar-minus";
    readonly pascal_name: "CalendarMinus";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "dates", "times", "events", "schedule", "remove", "delete"];
    readonly codepoint: 59924;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "calendar-plus";
    readonly pascal_name: "CalendarPlus";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["dates", "times", "events", "schedule", "add"];
    readonly codepoint: 59156;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "calendar-slash";
    readonly pascal_name: "CalendarSlash";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "dates", "times", "events", "schedule", "remove", "delete", "cancel. unavailable"];
    readonly codepoint: 59922;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "calendar-star";
    readonly pascal_name: "CalendarStar";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "dates", "times", "events", "schedule", "favorite", "star"];
    readonly codepoint: 59570;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "calendar-x";
    readonly pascal_name: "CalendarX";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["dates", "times", "events", "schedule", "closed", "cancelled"];
    readonly codepoint: 57612;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "call-bell";
    readonly pascal_name: "CallBell";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["service bell", "reception", "attendant", "concierge bell"];
    readonly codepoint: 59358;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "camera";
    readonly pascal_name: "Camera";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["photography", "pictures", "lens"];
    readonly codepoint: 57614;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "camera-plus";
    readonly pascal_name: "CameraPlus";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["photography", "pictures", "album", "add"];
    readonly codepoint: 60504;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "camera-rotate";
    readonly pascal_name: "CameraRotate";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["photography", "pictures", "orientation", "portrait", "landscape", "selfie", "flip"];
    readonly codepoint: 59300;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "camera-slash";
    readonly pascal_name: "CameraSlash";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["photography", "pictures", "lens", "disabled"];
    readonly codepoint: 57616;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "campfire";
    readonly pascal_name: "Campfire";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["camping", "flame", "bonfire", "outdoors"];
    readonly codepoint: 59864;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "car";
    readonly pascal_name: "Car";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "cars", "vehicles", "automobile", "transit", "transportation", "traveling"];
    readonly codepoint: 57618;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "car-battery";
    readonly pascal_name: "CarBattery";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "charged", "charger", "charging", "power", "voltage", "electricity"];
    readonly codepoint: 60976;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "car-profile";
    readonly pascal_name: "CarProfile";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["cars", "vehicles", "automobile", "transit", "transportation", "traveling"];
    readonly codepoint: 59596;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "car-simple";
    readonly pascal_name: "CarSimple";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["cars", "vehicles", "automobile", "transit", "transportation", "traveling"];
    readonly codepoint: 57620;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cardholder";
    readonly pascal_name: "Cardholder";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["wallet", "money", "payment", "paying", "purchase"];
    readonly codepoint: 58874;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "cards";
    readonly pascal_name: "Cards";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["card", "slides", "slideshow", "windows", "website", "webpage", "layers"];
    readonly codepoint: 57592;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cards-three";
    readonly pascal_name: "CardsThree";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "card", "slides", "slideshow", "windows", "website", "webpage", "layers", "stack"];
    readonly codepoint: 61008;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "caret-circle-double-down";
    readonly pascal_name: "CaretCircleDoubleDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57622;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-double-left";
    readonly pascal_name: "CaretCircleDoubleLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57624;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-double-right";
    readonly pascal_name: "CaretCircleDoubleRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57626;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-double-up";
    readonly pascal_name: "CaretCircleDoubleUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57628;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-down";
    readonly pascal_name: "CaretCircleDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57630;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-left";
    readonly pascal_name: "CaretCircleLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57632;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-right";
    readonly pascal_name: "CaretCircleRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57634;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-up";
    readonly pascal_name: "CaretCircleUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57636;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-circle-up-down";
    readonly pascal_name: "CaretCircleUpDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57662;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "caret-double-down";
    readonly pascal_name: "CaretDoubleDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57638;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-double-left";
    readonly pascal_name: "CaretDoubleLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57640;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-double-right";
    readonly pascal_name: "CaretDoubleRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57642;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-double-up";
    readonly pascal_name: "CaretDoubleUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57644;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-down";
    readonly pascal_name: "CaretDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57654;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-left";
    readonly pascal_name: "CaretLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57656;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-line-down";
    readonly pascal_name: "CaretLineDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*new*", "chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57652;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "caret-line-left";
    readonly pascal_name: "CaretLineLeft";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*new*", "chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57650;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "caret-line-right";
    readonly pascal_name: "CaretLineRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*new*", "chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57648;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "caret-line-up";
    readonly pascal_name: "CaretLineUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*new*", "chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57646;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "caret-right";
    readonly pascal_name: "CaretRight";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57658;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-up";
    readonly pascal_name: "CaretUp";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57660;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "caret-up-down";
    readonly pascal_name: "CaretUpDown";
    readonly categories: readonly [IconCategory.ARROWS];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["chevron", "directional", "pointer", "pointing", "arrowhead", "triangle"];
    readonly codepoint: 57664;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "carrot";
    readonly pascal_name: "Carrot";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["food", "vegetable", "veggie", "groceries", "market"];
    readonly codepoint: 60728;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "cash-register";
    readonly pascal_name: "CashRegister";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "retail", "point-of-sale", "pos", "transaction", "sales", "till"];
    readonly codepoint: 60800;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cassette-tape";
    readonly pascal_name: "CassetteTape";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["recording", "audio", "album", "music"];
    readonly codepoint: 60718;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "castle-turret";
    readonly pascal_name: "CastleTurret";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*updated*", "chess", "rook"];
    readonly codepoint: 59856;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "cat";
    readonly pascal_name: "Cat";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["pets", "animals", "kitty", "kitten"];
    readonly codepoint: 59208;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "cell-signal-full";
    readonly pascal_name: "CellSignalFull";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "reception", "service"];
    readonly codepoint: 57666;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-signal-high";
    readonly pascal_name: "CellSignalHigh";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "reception", "service"];
    readonly codepoint: 57668;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-signal-low";
    readonly pascal_name: "CellSignalLow";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "reception", "service"];
    readonly codepoint: 57670;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-signal-medium";
    readonly pascal_name: "CellSignalMedium";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "reception", "service"];
    readonly codepoint: 57672;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-signal-none";
    readonly pascal_name: "CellSignalNone";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "reception", "service"];
    readonly codepoint: 57674;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-signal-slash";
    readonly pascal_name: "CellSignalSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "disconnected", "disabled", "reception", "service"];
    readonly codepoint: 57676;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-signal-x";
    readonly pascal_name: "CellSignalX";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "cellular", "phone", "mobile", "network", "connection", "connectivity", "reception", "disconnected", "errors", "service"];
    readonly codepoint: 57678;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cell-tower";
    readonly pascal_name: "CellTower";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "wireless", "cellular", "broadcast", "phone", "mobile", "network", "connection", "connectivity"];
    readonly codepoint: 60330;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "certificate";
    readonly pascal_name: "Certificate";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["*updated*", "awards", "certification", "degree", "diploma"];
    readonly codepoint: 59238;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "chair";
    readonly pascal_name: "Chair";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["seat", "furniture"];
    readonly codepoint: 59728;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "chalkboard";
    readonly pascal_name: "Chalkboard";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["blackboard", "whiteboard", "classroom", "teacher", "education", "school", "college", "university"];
    readonly codepoint: 58876;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "chalkboard-simple";
    readonly pascal_name: "ChalkboardSimple";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["*updated*", "blackboard", "whiteboard", "classroom", "teacher", "education", "school", "college", "university"];
    readonly codepoint: 58878;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "chalkboard-teacher";
    readonly pascal_name: "ChalkboardTeacher";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["blackboard", "whiteboard", "classroom", "education", "school", "college", "university"];
    readonly codepoint: 58880;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "champagne";
    readonly pascal_name: "Champagne";
    readonly categories: readonly [IconCategory.MAP, IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["glass", "drinks", "beverages", "wine", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 60106;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "charging-station";
    readonly pascal_name: "ChargingStation";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["ev", "charge", "fuel", "pump"];
    readonly codepoint: 59600;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "chart-bar";
    readonly pascal_name: "ChartBar";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "histogram", "analyze", "analysis"];
    readonly codepoint: 57680;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chart-bar-horizontal";
    readonly pascal_name: "ChartBarHorizontal";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "histogram", "analyze", "analysis"];
    readonly codepoint: 57682;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chart-donut";
    readonly pascal_name: "ChartDonut";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "analyze", "analysis", "circle"];
    readonly codepoint: 60070;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "chart-line";
    readonly pascal_name: "ChartLine";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "analyze", "analysis", "stocks"];
    readonly codepoint: 57684;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chart-line-down";
    readonly pascal_name: "ChartLineDown";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*updated*", "graphs", "graphing", "charts", "statistics", "analyze", "analysis", "stocks"];
    readonly codepoint: 59574;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "chart-line-up";
    readonly pascal_name: "ChartLineUp";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*updated*", "graphs", "graphing", "charts", "statistics", "analyze", "analysis", "stocks"];
    readonly codepoint: 57686;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chart-pie";
    readonly pascal_name: "ChartPie";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "circle", "analyze", "analysis"];
    readonly codepoint: 57688;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chart-pie-slice";
    readonly pascal_name: "ChartPieSlice";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*updated*", "graphs", "graphing", "charts", "statistics", "circle", "analyze", "analysis"];
    readonly codepoint: 57690;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chart-polar";
    readonly pascal_name: "ChartPolar";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "analyze", "analysis", "circle"];
    readonly codepoint: 60072;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "chart-scatter";
    readonly pascal_name: "ChartScatter";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "analyze", "analysis"];
    readonly codepoint: 60076;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "chat";
    readonly pascal_name: "Chat";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57692;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-centered";
    readonly pascal_name: "ChatCentered";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57696;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-centered-dots";
    readonly pascal_name: "ChatCenteredDots";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57700;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-centered-slash";
    readonly pascal_name: "ChatCenteredSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57698;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chat-centered-text";
    readonly pascal_name: "ChatCenteredText";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57702;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-circle";
    readonly pascal_name: "ChatCircle";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "round", "bubble"];
    readonly codepoint: 57704;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-circle-dots";
    readonly pascal_name: "ChatCircleDots";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "round", "bubble"];
    readonly codepoint: 57708;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-circle-slash";
    readonly pascal_name: "ChatCircleSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "messages", "messaging", "sms", "texting", "comment", "round", "bubble"];
    readonly codepoint: 57706;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chat-circle-text";
    readonly pascal_name: "ChatCircleText";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "round", "bubble"];
    readonly codepoint: 57710;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-dots";
    readonly pascal_name: "ChatDots";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57712;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-slash";
    readonly pascal_name: "ChatSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57694;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chat-teardrop";
    readonly pascal_name: "ChatTeardrop";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "bubble"];
    readonly codepoint: 57714;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-teardrop-dots";
    readonly pascal_name: "ChatTeardropDots";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "bubble"];
    readonly codepoint: 57718;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-teardrop-slash";
    readonly pascal_name: "ChatTeardropSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "messages", "messaging", "sms", "texting", "comment", "bubble"];
    readonly codepoint: 57716;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chat-teardrop-text";
    readonly pascal_name: "ChatTeardropText";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "bubble"];
    readonly codepoint: 57720;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chat-text";
    readonly pascal_name: "ChatText";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57722;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chats";
    readonly pascal_name: "Chats";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "square", "bubble"];
    readonly codepoint: 57724;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chats-circle";
    readonly pascal_name: "ChatsCircle";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "round", "bubble"];
    readonly codepoint: 57726;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "chats-teardrop";
    readonly pascal_name: "ChatsTeardrop";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send", "sent", "messages", "messaging", "sms", "texting", "comment", "bubble"];
    readonly codepoint: 57728;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "check";
    readonly pascal_name: "Check";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["todo", "to-do", "task", "list", "checkbox", "ok", "done"];
    readonly codepoint: 57730;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "check-circle";
    readonly pascal_name: "CheckCircle";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["todo", "to-do", "task", "list", "checkbox", "round", "ok", "done"];
    readonly codepoint: 57732;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "check-fat";
    readonly pascal_name: "CheckFat";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["todo", "to-do", "task", "list", "checkbox", "ok", "done"];
    readonly codepoint: 60326;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "check-square";
    readonly pascal_name: "CheckSquare";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["todo", "to-do", "task", "list", "checkbox", "rectangle", "ok", "done"];
    readonly codepoint: 57734;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "check-square-offset";
    readonly pascal_name: "CheckSquareOffset";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "todo", "to-do", "task", "list", "checkbox", "rectangle", "ok", "done"];
    readonly codepoint: 57736;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "checkerboard";
    readonly pascal_name: "Checkerboard";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "crossword"];
    readonly codepoint: 59588;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "checks";
    readonly pascal_name: "Checks";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "todo", "task", "to-do", "list", "checkbox", "ok", "done"];
    readonly codepoint: 58682;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cheers";
    readonly pascal_name: "Cheers";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "glass", "drinks", "beverages", "champagne", "toast", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 59978;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cheese";
    readonly pascal_name: "Cheese";
    readonly categories: readonly [IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "dairy", "wedge", "food", "dining"];
    readonly codepoint: 59902;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "chef-hat";
    readonly pascal_name: "ChefHat";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "cooking", "cuisine", "kitchen", "clothes", "clothing"];
    readonly codepoint: 60814;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cherries";
    readonly pascal_name: "Cherries";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "food", "fruit", "cherry", "groceries", "market"];
    readonly codepoint: 59440;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "church";
    readonly pascal_name: "Church";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["christ", "christianity", "cathedral", "religion", "worship"];
    readonly codepoint: 60650;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "cigarette";
    readonly pascal_name: "Cigarette";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "smoking", "tobacco"];
    readonly codepoint: 60816;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cigarette-slash";
    readonly pascal_name: "CigaretteSlash";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "non-smoking", "tobacco"];
    readonly codepoint: 60818;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "circle";
    readonly pascal_name: "Circle";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "polygons"];
    readonly codepoint: 57738;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "circle-dashed";
    readonly pascal_name: "CircleDashed";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["missing", "round", "shapes", "polygons"];
    readonly codepoint: 58882;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "circle-half";
    readonly pascal_name: "CircleHalf";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "contrast", "brightness"];
    readonly codepoint: 57740;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "circle-half-tilt";
    readonly pascal_name: "CircleHalfTilt";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "contrast", "brightness"];
    readonly codepoint: 57742;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "circle-notch";
    readonly pascal_name: "CircleNotch";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "loading", "loader", "spinner", "waiting", "progress"];
    readonly codepoint: 60228;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "circles-four";
    readonly pascal_name: "CirclesFour";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "polygons", "4"];
    readonly codepoint: 57744;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "circles-three";
    readonly pascal_name: "CirclesThree";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "polygons", "3", "asana"];
    readonly codepoint: 57746;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "circles-three-plus";
    readonly pascal_name: "CirclesThreePlus";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "shapes", "polygons", "3", "+"];
    readonly codepoint: 57748;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "circuitry";
    readonly pascal_name: "Circuitry";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["processor", "microchip", "computer", "circuit", "electronics", "motherboard"];
    readonly codepoint: 59842;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "city";
    readonly pascal_name: "City";
    readonly categories: readonly [IconCategory.MAP, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "skyline", "skyscrapers", "places", "locations", "buildings"];
    readonly codepoint: 60010;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "clipboard";
    readonly pascal_name: "Clipboard";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["copy", "copied", "checklist"];
    readonly codepoint: 57750;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "clipboard-text";
    readonly pascal_name: "ClipboardText";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["copy", "copied", "checklist"];
    readonly codepoint: 57752;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "clock";
    readonly pascal_name: "Clock";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarm", "schedule", "events", "watch"];
    readonly codepoint: 57754;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "clock-afternoon";
    readonly pascal_name: "ClockAfternoon";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarm", "schedule", "events", "watch"];
    readonly codepoint: 57756;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "clock-clockwise";
    readonly pascal_name: "ClockClockwise";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarm", "schedule", "events", "restore", "fast forward", "update"];
    readonly codepoint: 57758;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "clock-countdown";
    readonly pascal_name: "ClockCountdown";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarm", "schedule", "events", "watch"];
    readonly codepoint: 60716;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "clock-counter-clockwise";
    readonly pascal_name: "ClockCounterClockwise";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarm", "schedule", "events", "backup", "rewind", "history"];
    readonly codepoint: 57760;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "clock-user";
    readonly pascal_name: "ClockUser";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["*new*", "times", "timer", "shift", "schedule", "events", "watch"];
    readonly codepoint: 60908;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "closed-captioning";
    readonly pascal_name: "ClosedCaptioning";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["subtitles", "television", "tv", "transcribed", "transcription", "accessibility", "a11y"];
    readonly codepoint: 57764;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cloud";
    readonly pascal_name: "Cloud";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["serverless", "backup", "storage", "meteorology", "cloudy", "overcast"];
    readonly codepoint: 57770;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-arrow-down";
    readonly pascal_name: "CloudArrowDown";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serverless", "backup", "storage", "download"];
    readonly codepoint: 57772;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-arrow-up";
    readonly pascal_name: "CloudArrowUp";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serverless", "backup", "storage", "upload"];
    readonly codepoint: 57774;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-check";
    readonly pascal_name: "CloudCheck";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serverless", "backup", "storage", "sync", "synchronized"];
    readonly codepoint: 57776;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-fog";
    readonly pascal_name: "CloudFog";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "cloudy", "overcast", "foggy", "mist", "haze"];
    readonly codepoint: 58684;
    readonly published_in: 1.1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-lightning";
    readonly pascal_name: "CloudLightning";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "cloudy", "overcast", "stormy", "thunderstorm"];
    readonly codepoint: 57778;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-moon";
    readonly pascal_name: "CloudMoon";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "cloudy", "partly cloudy", "night", "evening"];
    readonly codepoint: 58686;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "cloud-rain";
    readonly pascal_name: "CloudRain";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "cloudy", "rainy", "raining", "stormy", "rainstorm"];
    readonly codepoint: 57780;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-slash";
    readonly pascal_name: "CloudSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serverless", "backup", "storage", "sync", "disabled"];
    readonly codepoint: 57782;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cloud-snow";
    readonly pascal_name: "CloudSnow";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "cloudy", "snowy", "snowing", "stormy", "snowstorm"];
    readonly codepoint: 57784;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "cloud-sun";
    readonly pascal_name: "CloudSun";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "cloudy", "partly cloudy", "partly sunny"];
    readonly codepoint: 58688;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "cloud-warning";
    readonly pascal_name: "CloudWarning";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serverless", "backup", "storage", "errors"];
    readonly codepoint: 60056;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "cloud-x";
    readonly pascal_name: "CloudX";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serverless", "backup", "storage", "errors"];
    readonly codepoint: 60054;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "clover";
    readonly pascal_name: "Clover";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "four leaf clover", "plants", "luck", "lucky", "irish"];
    readonly codepoint: 60872;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "club";
    readonly pascal_name: "Club";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["clubs", "suits", "cards", "gambling", "casino", "gaming"];
    readonly codepoint: 57786;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "coat-hanger";
    readonly pascal_name: "CoatHanger";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothing", "clothes", "closet"];
    readonly codepoint: 59390;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "coda-logo";
    readonly pascal_name: "CodaLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["project management", "productivity", "documentation", "wiki", "logos"];
    readonly codepoint: 59342;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "code";
    readonly pascal_name: "Code";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["angle brackets", "angle braces", "snippets"];
    readonly codepoint: 57788;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "code-block";
    readonly pascal_name: "CodeBlock";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["angle brackets", "angle braces", "snippets"];
    readonly codepoint: 60158;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "code-simple";
    readonly pascal_name: "CodeSimple";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["angle brackets", "angle braces", "snippets"];
    readonly codepoint: 57790;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "codepen-logo";
    readonly pascal_name: "CodepenLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["ide", "logos"];
    readonly codepoint: 59768;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "codesandbox-logo";
    readonly pascal_name: "CodesandboxLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["ide", "logos"];
    readonly codepoint: 59910;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "coffee";
    readonly pascal_name: "Coffee";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tea", "java", "beverages", "drinks", "cafe", "cup", "mug", "espresso", "cappuccino", "latte", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 57794;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "coffee-bean";
    readonly pascal_name: "CoffeeBean";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "tea", "java", "beverages", "drinks", "cafe", "cup", "mug", "espresso", "cappuccino", "latte", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 57792;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "coin";
    readonly pascal_name: "Coin";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["coins", "cents", "change", "money", "currency", "payment", "paying", "purchase", "price", "sell"];
    readonly codepoint: 58894;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "coin-vertical";
    readonly pascal_name: "CoinVertical";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["cents", "change", "money", "currency", "payment", "paying", "purchase", "price", "sell"];
    readonly codepoint: 60232;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "coins";
    readonly pascal_name: "Coins";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["cents", "change", "money", "currency", "payment", "paying", "purchase", "price", "sell"];
    readonly codepoint: 59278;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "columns";
    readonly pascal_name: "Columns";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["2", "shapes", "polygons", "box", "stack", "list", "table", "cards"];
    readonly codepoint: 58694;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "columns-plus-left";
    readonly pascal_name: "ColumnsPlusLeft";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "2", "shapes", "polygons", "box", "stack", "list", "table", "cards", "prepend", "insert"];
    readonly codepoint: 58692;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "columns-plus-right";
    readonly pascal_name: "ColumnsPlusRight";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "2", "shapes", "polygons", "box", "stack", "list", "table", "cards", "append", "insert"];
    readonly codepoint: 58690;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "command";
    readonly pascal_name: "Command";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["apple", "keyboard", "shortcut", "modifier", "looped square", "bowen knot", "saint john's arms"];
    readonly codepoint: 57796;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "compass";
    readonly pascal_name: "Compass";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["navigation", "directions", "maps", "safari", "apple"];
    readonly codepoint: 57800;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "compass-rose";
    readonly pascal_name: "CompassRose";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "navigation", "directions", "maps", "cardinal", "cartography"];
    readonly codepoint: 57798;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "compass-tool";
    readonly pascal_name: "CompassTool";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["drawing", "geometry", "trigonometry", "degrees", "radians", "measurement", "protractor", "compass", "arc"];
    readonly codepoint: 59918;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "computer-tower";
    readonly pascal_name: "ComputerTower";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["desktop", "pc", "imac"];
    readonly codepoint: 58696;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "confetti";
    readonly pascal_name: "Confetti";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["tada", "party", "emoji"];
    readonly codepoint: 59418;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "contactless-payment";
    readonly pascal_name: "ContactlessPayment";
    readonly categories: readonly [IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["purchase", "credit card", "nfc"];
    readonly codepoint: 60738;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "control";
    readonly pascal_name: "Control";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["ctrl", "key", "keyboard", "shortcut", "caret"];
    readonly codepoint: 60582;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "cookie";
    readonly pascal_name: "Cookie";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["privacy", "dessert", "food", "dining"];
    readonly codepoint: 59082;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "cooking-pot";
    readonly pascal_name: "CookingPot";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["stew", "kitchen", "steaming", "restaurants", "food", "dining"];
    readonly codepoint: 59236;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "copy";
    readonly pascal_name: "Copy";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["duplicated", "copied", "clipboard"];
    readonly codepoint: 57802;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "copy-simple";
    readonly pascal_name: "CopySimple";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["duplicated", "copied", "clipboard"];
    readonly codepoint: 57804;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "copyleft";
    readonly pascal_name: "Copyleft";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["🄯", "intellectual property", "copr.", "symbol"];
    readonly codepoint: 59498;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "copyright";
    readonly pascal_name: "Copyright";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["©", "intellectual property", "copr.", "symbol"];
    readonly codepoint: 58698;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "corners-in";
    readonly pascal_name: "CornersIn";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "collapse", "windowed", "minimized"];
    readonly codepoint: 57806;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "corners-out";
    readonly pascal_name: "CornersOut";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "expand", "fullscreen", "maximized"];
    readonly codepoint: 57808;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "couch";
    readonly pascal_name: "Couch";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["furniture", "seat"];
    readonly codepoint: 59382;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "court-basketball";
    readonly pascal_name: "CourtBasketball";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.MAP];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "nba"];
    readonly codepoint: 60982;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cow";
    readonly pascal_name: "Cow";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "animals", "livestock", "beef", "bull", "milk", "dairy"];
    readonly codepoint: 60094;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cowboy-hat";
    readonly pascal_name: "CowboyHat";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "clothes", "clothing", "stetson"];
    readonly codepoint: 60690;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "cpu";
    readonly pascal_name: "Cpu";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["processor", "microchip", "computer", "circuit"];
    readonly codepoint: 58896;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "crane";
    readonly pascal_name: "Crane";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "construction", "industry"];
    readonly codepoint: 60744;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "crane-tower";
    readonly pascal_name: "CraneTower";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "construction", "industry"];
    readonly codepoint: 60744;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "credit-card";
    readonly pascal_name: "CreditCard";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["debit", "visa", "mastercard", "money", "payment", "paying", "purchase", "swipe"];
    readonly codepoint: 57810;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cricket";
    readonly pascal_name: "Cricket";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "ball", "bat"];
    readonly codepoint: 60946;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "crop";
    readonly pascal_name: "Crop";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["photography", "clip", "screenshots"];
    readonly codepoint: 57812;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cross";
    readonly pascal_name: "Cross";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["dagger", "crucifix", "christ", "christianity", "religion", "worship", "symbol"];
    readonly codepoint: 59552;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "crosshair";
    readonly pascal_name: "Crosshair";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["geolocation", "gps", "aiming", "targeting"];
    readonly codepoint: 57814;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "crosshair-simple";
    readonly pascal_name: "CrosshairSimple";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["geolocation", "gps", "aiming", "targeting"];
    readonly codepoint: 57816;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "crown";
    readonly pascal_name: "Crown";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*updated*", "king", "queen", "royalty", "monarch", "ruler", "leader", "chess"];
    readonly codepoint: 58900;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "crown-cross";
    readonly pascal_name: "CrownCross";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "king", "queen", "royalty", "monarch", "ruler", "leader", "chess"];
    readonly codepoint: 61022;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "crown-simple";
    readonly pascal_name: "CrownSimple";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*updated*", "king", "queen", "royalty", "monarch", "ruler", "leader", "chess"];
    readonly codepoint: 58902;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "cube";
    readonly pascal_name: "Cube";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["square", "box", "3d", "volume", "blocks"];
    readonly codepoint: 57818;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "cube-focus";
    readonly pascal_name: "CubeFocus";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["augmented reality", "ar", "virual reality", "vr", "3d", "scan"];
    readonly codepoint: 60682;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "cube-transparent";
    readonly pascal_name: "CubeTransparent";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["square", "box", "3d", "volume", "blocks", "necker"];
    readonly codepoint: 60540;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "currency-btc";
    readonly pascal_name: "CurrencyBtc";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "btc", "bitcoin", "crypto", "cryptocurrency", "payment", "paying", "purchase"];
    readonly codepoint: 58904;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "currency-circle-dollar";
    readonly pascal_name: "CurrencyCircleDollar";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "usd", "payment", "paying", "purchase"];
    readonly codepoint: 58700;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-cny";
    readonly pascal_name: "CurrencyCny";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "yuan", "payment", "paying", "purchase"];
    readonly codepoint: 58702;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-dollar";
    readonly pascal_name: "CurrencyDollar";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "usd", "payment", "paying", "purchase"];
    readonly codepoint: 58704;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-dollar-simple";
    readonly pascal_name: "CurrencyDollarSimple";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "usd", "payment", "paying", "purchase"];
    readonly codepoint: 58706;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-eth";
    readonly pascal_name: "CurrencyEth";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "ethereum", "crypto", "cryptocurrency", "payment", "paying", "purchase"];
    readonly codepoint: 60122;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "currency-eur";
    readonly pascal_name: "CurrencyEur";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "euros", "payment", "paying", "purchase"];
    readonly codepoint: 58708;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-gbp";
    readonly pascal_name: "CurrencyGbp";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "pounds sterling", "payment", "paying", "purchase"];
    readonly codepoint: 58710;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-inr";
    readonly pascal_name: "CurrencyInr";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "rupees", "payment", "paying", "purchase"];
    readonly codepoint: 58712;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-jpy";
    readonly pascal_name: "CurrencyJpy";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "yen", "payment", "paying", "purchase"];
    readonly codepoint: 58714;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-krw";
    readonly pascal_name: "CurrencyKrw";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "won", "payment", "paying", "purchase"];
    readonly codepoint: 58716;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "currency-kzt";
    readonly pascal_name: "CurrencyKzt";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "kazakhstan", "tenge", "payment", "paying", "purchase"];
    readonly codepoint: 60492;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "currency-ngn";
    readonly pascal_name: "CurrencyNgn";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "nigeria", "naira", "payment", "paying", "purchase"];
    readonly codepoint: 60242;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "currency-rub";
    readonly pascal_name: "CurrencyRub";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "rubles", "payment", "paying", "purchase"];
    readonly codepoint: 58718;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "cursor";
    readonly pascal_name: "Cursor";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["pointer", "arrowhead", "mouse", "click"];
    readonly codepoint: 57820;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "cursor-click";
    readonly pascal_name: "CursorClick";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["pointer", "arrowhead", "mouse"];
    readonly codepoint: 59336;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "cursor-text";
    readonly pascal_name: "CursorText";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["i-beam", "input", "select"];
    readonly codepoint: 59352;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "cylinder";
    readonly pascal_name: "Cylinder";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "tube"];
    readonly codepoint: 59644;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "database";
    readonly pascal_name: "Database";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "hard disk", "storage", "hdd", "servers", "databases"];
    readonly codepoint: 57822;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "desk";
    readonly pascal_name: "Desk";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "furniture", "workspace", "table"];
    readonly codepoint: 60694;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "desktop";
    readonly pascal_name: "Desktop";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["computer", "pc", "imac", "tower"];
    readonly codepoint: 58720;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "desktop-tower";
    readonly pascal_name: "DesktopTower";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "computer", "pc", "imac"];
    readonly codepoint: 58722;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "detective";
    readonly pascal_name: "Detective";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["incognito", "police", "law enforcement", "spy", "secret"];
    readonly codepoint: 59454;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "dev-to-logo";
    readonly pascal_name: "DevToLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["reading", "writing", "social media", "logos"];
    readonly codepoint: 60686;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "device-mobile";
    readonly pascal_name: "DeviceMobile";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["cellphone", "cellular"];
    readonly codepoint: 57824;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "device-mobile-camera";
    readonly pascal_name: "DeviceMobileCamera";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["cellphone", "cellular"];
    readonly codepoint: 57826;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "device-mobile-slash";
    readonly pascal_name: "DeviceMobileSlash";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "cellphone", "cellular"];
    readonly codepoint: 60998;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "device-mobile-speaker";
    readonly pascal_name: "DeviceMobileSpeaker";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["cellphone", "cellular"];
    readonly codepoint: 57828;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "device-rotate";
    readonly pascal_name: "DeviceRotate";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "orientation", "landscape", "portrait", "spin", "flip"];
    readonly codepoint: 60914;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "device-tablet";
    readonly pascal_name: "DeviceTablet";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["cellphone", "cellular", "ipad", "phablet"];
    readonly codepoint: 57830;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "device-tablet-camera";
    readonly pascal_name: "DeviceTabletCamera";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["cellphone", "cellular", "ipad", "phablet"];
    readonly codepoint: 57832;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "device-tablet-speaker";
    readonly pascal_name: "DeviceTabletSpeaker";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["cellphone", "cellular", "ipad", "phablet"];
    readonly codepoint: 57834;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "devices";
    readonly pascal_name: "Devices";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["responsive", "cellphone", "cellular", "tablet", "destop"];
    readonly codepoint: 60324;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "diamond";
    readonly pascal_name: "Diamond";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["rectangle", "shapes", "polygons", "diamonds", "suits", "cards", "gambling", "casino", "gaming"];
    readonly codepoint: 57836;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "diamonds-four";
    readonly pascal_name: "DiamondsFour";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "grid", "component"];
    readonly codepoint: 59636;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "dice-five";
    readonly pascal_name: "DiceFive";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["die", "rolling", "gamble", "gambling", "casino", "gaming", "5"];
    readonly codepoint: 57838;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dice-four";
    readonly pascal_name: "DiceFour";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["die", "rolling", "gamble", "gambling", "casino", "gaming", "4"];
    readonly codepoint: 57840;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dice-one";
    readonly pascal_name: "DiceOne";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["die", "rolling", "gamble", "gambling", "casino", "gaming", "1"];
    readonly codepoint: 57842;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dice-six";
    readonly pascal_name: "DiceSix";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["die", "rolling", "gamble", "gambling", "casino", "gaming", "6"];
    readonly codepoint: 57844;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dice-three";
    readonly pascal_name: "DiceThree";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["die", "rolling", "gamble", "gambling", "casino", "gaming", "3"];
    readonly codepoint: 57846;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dice-two";
    readonly pascal_name: "DiceTwo";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["die", "rolling", "gamble", "gambling", "casino", "gaming", "2"];
    readonly codepoint: 57848;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "disc";
    readonly pascal_name: "Disc";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["cd-rom", "compact disk", "album", "record"];
    readonly codepoint: 58724;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "disco-ball";
    readonly pascal_name: "DiscoBall";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "danging", "club", "70s"];
    readonly codepoint: 60824;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "discord-logo";
    readonly pascal_name: "DiscordLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "messages", "messaging", "chat"];
    readonly codepoint: 58906;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "divide";
    readonly pascal_name: "Divide";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["division", "divisor", "dividend", "quotient", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 57850;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dna";
    readonly pascal_name: "Dna";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["double helix", "gene", "genetics"];
    readonly codepoint: 59684;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "dog";
    readonly pascal_name: "Dog";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["pets", "animals", "puppy"];
    readonly codepoint: 59210;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "door";
    readonly pascal_name: "Door";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["entrance", "exit"];
    readonly codepoint: 58908;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "door-open";
    readonly pascal_name: "DoorOpen";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["entrance", "exit"];
    readonly codepoint: 59366;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "dot";
    readonly pascal_name: "Dot";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["dots", "circles", "shapes", "polygons"];
    readonly codepoint: 60638;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "dot-outline";
    readonly pascal_name: "DotOutline";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["dots", "circles", "shapes", "polygons"];
    readonly codepoint: 60640;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "dots-nine";
    readonly pascal_name: "DotsNine";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["grid", "circles", "shapes", "polygons", "9"];
    readonly codepoint: 57852;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dots-six";
    readonly pascal_name: "DotsSix";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "drag handle", "knurling", "circles", "shapes", "polygons", "6"];
    readonly codepoint: 59284;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "dots-six-vertical";
    readonly pascal_name: "DotsSixVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "drag handle", "knurling", "circles", "shapes", "polygons", "6"];
    readonly codepoint: 60130;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "dots-three";
    readonly pascal_name: "DotsThree";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["menu", "overflow", "circles", "shapes", "polygons", "3", "ellipsis", "ellipses", "more"];
    readonly codepoint: 57854;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dots-three-circle";
    readonly pascal_name: "DotsThreeCircle";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["menu", "overflow", "circles", "shapes", "polygons", "3", "ellipsis", "ellipses", "more"];
    readonly codepoint: 57856;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dots-three-circle-vertical";
    readonly pascal_name: "DotsThreeCircleVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["menu", "overflow", "circles", "shapes", "polygons", "3", "ellipsis", "ellipses", "more"];
    readonly codepoint: 57858;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dots-three-outline";
    readonly pascal_name: "DotsThreeOutline";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["menu", "overflow", "circles", "shapes", "polygons", "3", "ellipsis", "ellipses", "more"];
    readonly codepoint: 57860;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dots-three-outline-vertical";
    readonly pascal_name: "DotsThreeOutlineVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["menu", "overflow", "circles", "shapes", "polygons", "3", "ellipsis", "ellipses", "more"];
    readonly codepoint: 57862;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "dots-three-vertical";
    readonly pascal_name: "DotsThreeVertical";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["menu", "overflow", "circles", "shapes", "polygons", "3", "ellipsis", "ellipses", "more"];
    readonly codepoint: 57864;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "download";
    readonly pascal_name: "Download";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "downloaded", "downloading", "hard drive", "disk"];
    readonly codepoint: 57866;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "download-simple";
    readonly pascal_name: "DownloadSimple";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "saved", "saving", "archived", "archiving", "archival", "downloaded", "downloading", "hard drive", "disk", "import"];
    readonly codepoint: 57868;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "dress";
    readonly pascal_name: "Dress";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothes", "clothing"];
    readonly codepoint: 60030;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "dresser";
    readonly pascal_name: "Dresser";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "furniture", "bedroom", "storage", "drawers", "wardrobe"];
    readonly codepoint: 59726;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "dribbble-logo";
    readonly pascal_name: "DribbbleLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "round", "basketball", "sports", "design"];
    readonly codepoint: 57870;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "drone";
    readonly pascal_name: "Drone";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "aerial", "uav", "photography", "remote"];
    readonly codepoint: 60788;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "drop";
    readonly pascal_name: "Drop";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["droplet", "teardrop", "raindrop", "raining", "meteorology", "water", "blur"];
    readonly codepoint: 57872;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "drop-half";
    readonly pascal_name: "DropHalf";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["droplet", "teardrop", "raindrop", "humidity", "water", "contrast", "brightness"];
    readonly codepoint: 58726;
    readonly published_in: 1.1;
    readonly updated_in: 1.4;
}, {
    readonly name: "drop-half-bottom";
    readonly pascal_name: "DropHalfBottom";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["droplet", "teardrop", "raindrop", "humidity", "water", "contrast", "brightness"];
    readonly codepoint: 60224;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "drop-simple";
    readonly pascal_name: "DropSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "droplet", "teardrop", "raindrop", "raining", "humidity", "meteorology", "water", "blur"];
    readonly codepoint: 60978;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "drop-slash";
    readonly pascal_name: "DropSlash";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "droplet", "teardrop", "raindrop", "raining", "humidity", "meteorology", "water", "blur", "disabled"];
    readonly codepoint: 59732;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "dropbox-logo";
    readonly pascal_name: "DropboxLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["cloud", "storage", "backup", "logos"];
    readonly codepoint: 59344;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "ear";
    readonly pascal_name: "Ear";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["hearing", "audio", "sound"];
    readonly codepoint: 59148;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "ear-slash";
    readonly pascal_name: "EarSlash";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["hearing", "audio", "sound", "mute", "accessible"];
    readonly codepoint: 59150;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "egg";
    readonly pascal_name: "Egg";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["chicken", "food", "meal", "baby", "hatch"];
    readonly codepoint: 59410;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "egg-crack";
    readonly pascal_name: "EggCrack";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["chicken", "food", "meal", "baby", "hatch", "break"];
    readonly codepoint: 60260;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "eject";
    readonly pascal_name: "Eject";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["disconnect"];
    readonly codepoint: 57874;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "eject-simple";
    readonly pascal_name: "EjectSimple";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["disconnect"];
    readonly codepoint: 59054;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "elevator";
    readonly pascal_name: "Elevator";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["lift"];
    readonly codepoint: 60608;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "empty";
    readonly pascal_name: "Empty";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "∅", "empty set", "member", "mathematics", "arithmetic", "calculator", "null"];
    readonly codepoint: 60860;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "engine";
    readonly pascal_name: "Engine";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "motor", "repair", "vehicles", "automobile"];
    readonly codepoint: 60032;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "envelope";
    readonly pascal_name: "Envelope";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "message", "post", "letter"];
    readonly codepoint: 57876;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "envelope-open";
    readonly pascal_name: "EnvelopeOpen";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "message", "read", "post", "letter"];
    readonly codepoint: 57878;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "envelope-simple";
    readonly pascal_name: "EnvelopeSimple";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "message", "post", "letter"];
    readonly codepoint: 57880;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "envelope-simple-open";
    readonly pascal_name: "EnvelopeSimpleOpen";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "message", "read", "post", "letter"];
    readonly codepoint: 57882;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "equalizer";
    readonly pascal_name: "Equalizer";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "meter", "volume", "spectrum", "eq", "deezer"];
    readonly codepoint: 60348;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "equals";
    readonly pascal_name: "Equals";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["=", "equality", "equivalent", "equivalence", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 57884;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "eraser";
    readonly pascal_name: "Eraser";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "undo", "deleted"];
    readonly codepoint: 57886;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "escalator-down";
    readonly pascal_name: "EscalatorDown";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["stairs"];
    readonly codepoint: 60602;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "escalator-up";
    readonly pascal_name: "EscalatorUp";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["stairs"];
    readonly codepoint: 60604;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "exam";
    readonly pascal_name: "Exam";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["text", "examination", "paper", "school", "grade"];
    readonly codepoint: 59202;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "exclamation-mark";
    readonly pascal_name: "ExclamationMark";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["*new*", "!", "alert", "warning", "caution", "interjection", "punctuation", "symbol"];
    readonly codepoint: 60996;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "exclude";
    readonly pascal_name: "Exclude";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["venn-diagram", "difference", "intersection"];
    readonly codepoint: 59522;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "exclude-square";
    readonly pascal_name: "ExcludeSquare";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["venn-diagram", "difference", "intersection"];
    readonly codepoint: 59520;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "export";
    readonly pascal_name: "Export";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["share", "send to", "arrows"];
    readonly codepoint: 60144;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "eye";
    readonly pascal_name: "Eye";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["visible", "hidden", "show", "hide", "visibility", "view"];
    readonly codepoint: 57888;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "eye-closed";
    readonly pascal_name: "EyeClosed";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["visible", "hidden", "show", "hide", "visibility", "view", "invisible", "private"];
    readonly codepoint: 57890;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "eye-slash";
    readonly pascal_name: "EyeSlash";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["visible", "hidden", "show", "hide", "visibility", "view", "invisible", "eyelashes", "disabled", "private"];
    readonly codepoint: 57892;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "eyedropper";
    readonly pascal_name: "Eyedropper";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["colors", "color picker", "sample", "arts"];
    readonly codepoint: 58728;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "eyedropper-sample";
    readonly pascal_name: "EyedropperSample";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["colors", "color picker", "arts"];
    readonly codepoint: 60100;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "eyeglasses";
    readonly pascal_name: "Eyeglasses";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["vision", "spectacles"];
    readonly codepoint: 59322;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "eyes";
    readonly pascal_name: "Eyes";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "look", "glance"];
    readonly codepoint: 61020;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "face-mask";
    readonly pascal_name: "FaceMask";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["ppe", "facemask", "covid-19", "coronavirus", "flu", "cold"];
    readonly codepoint: 58730;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "facebook-logo";
    readonly pascal_name: "FacebookLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "social media"];
    readonly codepoint: 57894;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "factory";
    readonly pascal_name: "Factory";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["industry", "manufacture", "buildings", "places", "locations"];
    readonly codepoint: 59232;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "faders";
    readonly pascal_name: "Faders";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "sliders", "filters", "equalizer", "volume", "settings", "preferences"];
    readonly codepoint: 57896;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "faders-horizontal";
    readonly pascal_name: "FadersHorizontal";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "sliders", "filters", "equalizer", "volume", "settings", "preferences"];
    readonly codepoint: 57898;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "fallout-shelter";
    readonly pascal_name: "FalloutShelter";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["*new*", "radiation", "radioactive", "nuclear", "bunker", "contamination", "quarantine", "toxic", "danger", "caution"];
    readonly codepoint: 59870;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "fan";
    readonly pascal_name: "Fan";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["desk fan", "air conditioning"];
    readonly codepoint: 59890;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "farm";
    readonly pascal_name: "Farm";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "farmer", "field", "farming", "agriculture"];
    readonly codepoint: 60528;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "fast-forward";
    readonly pascal_name: "FastForward";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["audio", "music", "seek", "scrub", "scan", "ahead", "skip"];
    readonly codepoint: 59046;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "fast-forward-circle";
    readonly pascal_name: "FastForwardCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["audio", "music", "seek", "scrub", "scan", "ahead", "skip"];
    readonly codepoint: 57900;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "feather";
    readonly pascal_name: "Feather";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["bird"];
    readonly codepoint: 59840;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "fediverse-logo";
    readonly pascal_name: "FediverseLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "social media", "decentralized"];
    readonly codepoint: 60774;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "figma-logo";
    readonly pascal_name: "FigmaLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*updated*", "logos", "drawing", "art", "illustration", "ui", "interface", "prototype", "prototyping"];
    readonly codepoint: 57902;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file";
    readonly pascal_name: "File";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "save", "write", "page"];
    readonly codepoint: 57904;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-archive";
    readonly pascal_name: "FileArchive";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "zip", "compression"];
    readonly codepoint: 60202;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "file-arrow-down";
    readonly pascal_name: "FileArrowDown";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "save", "write", "download", "directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 57906;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-arrow-up";
    readonly pascal_name: "FileArrowUp";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "save", "write", "upload", "directional", "pointer", "pointing", "arrowhead"];
    readonly codepoint: 58910;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "file-audio";
    readonly pascal_name: "FileAudio";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "music", "sound"];
    readonly codepoint: 59936;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-c";
    readonly pascal_name: "FileC";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents", "code"];
    readonly codepoint: 60210;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-c-sharp";
    readonly pascal_name: "FileCSharp";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents", "code", "c#"];
    readonly codepoint: 60208;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-cloud";
    readonly pascal_name: "FileCloud";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "sync"];
    readonly codepoint: 59742;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-code";
    readonly pascal_name: "FileCode";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents"];
    readonly codepoint: 59668;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-cpp";
    readonly pascal_name: "FileCpp";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents", "code", "c++"];
    readonly codepoint: 60206;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-css";
    readonly pascal_name: "FileCss";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code"];
    readonly codepoint: 60212;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-csv";
    readonly pascal_name: "FileCsv";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "data"];
    readonly codepoint: 60188;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-dashed";
    readonly pascal_name: "FileDashed";
    readonly alias: {
        readonly name: "file-dotted";
        readonly pascal_name: "FileDotted";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "browse", "draft", "open", "dotted"];
    readonly codepoint: 59140;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "file-doc";
    readonly pascal_name: "FileDoc";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "word", "microsoft"];
    readonly codepoint: 60190;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-html";
    readonly pascal_name: "FileHtml";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "documents", "code"];
    readonly codepoint: 60216;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-image";
    readonly pascal_name: "FileImage";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "pictures", "photograph"];
    readonly codepoint: 59940;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-ini";
    readonly pascal_name: "FileIni";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents"];
    readonly codepoint: 60210;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-jpg";
    readonly pascal_name: "FileJpg";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "pictures", "photograph", "jpeg"];
    readonly codepoint: 60186;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-js";
    readonly pascal_name: "FileJs";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code", "javascript"];
    readonly codepoint: 60196;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-jsx";
    readonly pascal_name: "FileJsx";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code", "javascript"];
    readonly codepoint: 60218;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-lock";
    readonly pascal_name: "FileLock";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "secure", "locked", "private"];
    readonly codepoint: 59740;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-magnifying-glass";
    readonly pascal_name: "FileMagnifyingGlass";
    readonly alias: {
        readonly name: "file-search";
        readonly pascal_name: "FileSearch";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "search", "find", "locate", "browse", "missing"];
    readonly codepoint: 57912;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-md";
    readonly pascal_name: "FileMd";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents", "notes", "markdown"];
    readonly codepoint: 60752;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-minus";
    readonly pascal_name: "FileMinus";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "delete", "write", "remove", "-"];
    readonly codepoint: 57908;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-pdf";
    readonly pascal_name: "FilePdf";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "acrobat"];
    readonly codepoint: 59138;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-plus";
    readonly pascal_name: "FilePlus";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "save", "write", "add", "new", "create", "+"];
    readonly codepoint: 57910;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-png";
    readonly pascal_name: "FilePng";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "pictures", "photograph"];
    readonly codepoint: 60184;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-ppt";
    readonly pascal_name: "FilePpt";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "powerpoint", "microsoft"];
    readonly codepoint: 60192;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-py";
    readonly pascal_name: "FilePy";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents", "code", "python"];
    readonly codepoint: 60204;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-rs";
    readonly pascal_name: "FileRs";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code", "rust"];
    readonly codepoint: 60200;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-sql";
    readonly pascal_name: "FileSql";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "database"];
    readonly codepoint: 60750;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "file-svg";
    readonly pascal_name: "FileSvg";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "images", "vector"];
    readonly codepoint: 60680;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "file-text";
    readonly pascal_name: "FileText";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "save", "write"];
    readonly codepoint: 57914;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-ts";
    readonly pascal_name: "FileTs";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code", "typescript"];
    readonly codepoint: 60198;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-tsx";
    readonly pascal_name: "FileTsx";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code", "typescript"];
    readonly codepoint: 60220;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-txt";
    readonly pascal_name: "FileTxt";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "documents"];
    readonly codepoint: 60210;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "file-video";
    readonly pascal_name: "FileVideo";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "movie"];
    readonly codepoint: 59938;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-vue";
    readonly pascal_name: "FileVue";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "code"];
    readonly codepoint: 60222;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-x";
    readonly pascal_name: "FileX";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "files", "cancelled", "deleted", "removed", "errors"];
    readonly codepoint: 57916;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "file-xls";
    readonly pascal_name: "FileXls";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "excel", "microsoft"];
    readonly codepoint: 60194;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "file-zip";
    readonly pascal_name: "FileZip";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "archive", "compression"];
    readonly codepoint: 59736;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "files";
    readonly pascal_name: "Files";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["documents", "open", "library"];
    readonly codepoint: 59152;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "film-reel";
    readonly pascal_name: "FilmReel";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["videography", "films", "movies", "recording"];
    readonly codepoint: 59584;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "film-script";
    readonly pascal_name: "FilmScript";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["screenplay", "movie"];
    readonly codepoint: 60240;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "film-slate";
    readonly pascal_name: "FilmSlate";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "clapper", "movie"];
    readonly codepoint: 59586;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "film-strip";
    readonly pascal_name: "FilmStrip";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["camera", "photography", "darkroom", "movie", "analog"];
    readonly codepoint: 59282;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "fingerprint";
    readonly pascal_name: "Fingerprint";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["security", "secured", "authentication", "authenticated", "login", "locked", "biometrics", "encrypted", "encryption"];
    readonly codepoint: 57918;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "fingerprint-simple";
    readonly pascal_name: "FingerprintSimple";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["security", "secured", "authentication", "authenticated", "login", "locked", "biometrics", "encrypted", "encryption"];
    readonly codepoint: 57920;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "finn-the-human";
    readonly pascal_name: "FinnTheHuman";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["adventure time", "cartoons", "television", "tv", "character"];
    readonly codepoint: 58732;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "fire";
    readonly pascal_name: "Fire";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["flame", "burning", "match", "lighter"];
    readonly codepoint: 57922;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "fire-extinguisher";
    readonly pascal_name: "FireExtinguisher";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["safety", "prevention", "emergency", "hazard", "danger", "caution"];
    readonly codepoint: 59880;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "fire-simple";
    readonly pascal_name: "FireSimple";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["flame", "burning", "match", "lighter"];
    readonly codepoint: 58912;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "fire-truck";
    readonly pascal_name: "FireTruck";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["*new*", "first-aid", "emt", "medical", "medicine", "injury", "safety", "emergency", "firefighter"];
    readonly codepoint: 58740;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "first-aid";
    readonly pascal_name: "FirstAid";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["hospital", "cross", "medical", "medicine", "injury", "safety", "emergency", "doctor"];
    readonly codepoint: 58734;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "first-aid-kit";
    readonly pascal_name: "FirstAidKit";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["bandages", "medical", "medicine", "injury", "safety", "emergency", "doctor"];
    readonly codepoint: 58736;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "fish";
    readonly pascal_name: "Fish";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["animals", "pets", "food", "seafood", "restaurants", "dining"];
    readonly codepoint: 59176;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "fish-simple";
    readonly pascal_name: "FishSimple";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["animals", "pets", "food", "seafood", "restaurants", "dining"];
    readonly codepoint: 59178;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "flag";
    readonly pascal_name: "Flag";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["country", "countries", "finished", "completed", "flags"];
    readonly codepoint: 57924;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "flag-banner";
    readonly pascal_name: "FlagBanner";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["ribbon", "country", "countries", "finished", "completed", "flags", "swallowtail"];
    readonly codepoint: 58914;
    readonly published_in: 1.2;
    readonly updated_in: 2;
}, {
    readonly name: "flag-banner-fold";
    readonly pascal_name: "FlagBannerFold";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "ribbon", "country", "countries", "finished", "completed", "flags", "swallowtail"];
    readonly codepoint: 60658;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "flag-checkered";
    readonly pascal_name: "FlagCheckered";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["flags", "race", "racing", "finish line"];
    readonly codepoint: 59960;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "flag-pennant";
    readonly pascal_name: "FlagPennant";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MAP, IconCategory.SYSTEM, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["flags", "race", "sports", "team"];
    readonly codepoint: 60656;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "flame";
    readonly pascal_name: "Flame";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["fire", "burning", "match", "lighter"];
    readonly codepoint: 58916;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "flashlight";
    readonly pascal_name: "Flashlight";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["torch", "find", "search", "locate"];
    readonly codepoint: 57926;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "flask";
    readonly pascal_name: "Flask";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.NATURE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["beaker", "science", "chemistry", "experiment", "erlenmeyer"];
    readonly codepoint: 59294;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "flip-horizontal";
    readonly pascal_name: "FlipHorizontal";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "mirror", "rotate", "invert"];
    readonly codepoint: 60778;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "flip-vertical";
    readonly pascal_name: "FlipVertical";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "mirror", "rotate", "invert"];
    readonly codepoint: 60780;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "floppy-disk";
    readonly pascal_name: "FloppyDisk";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["diskette", "directory", "directories", "folders", "documents", "files", "save", "write"];
    readonly codepoint: 57928;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "floppy-disk-back";
    readonly pascal_name: "FloppyDiskBack";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "diskette", "directory", "directories", "folders", "documents", "files", "save", "write"];
    readonly codepoint: 60148;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "flow-arrow";
    readonly pascal_name: "FlowArrow";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*updated*", "flowchart", "arrowhead"];
    readonly codepoint: 59116;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "flower";
    readonly pascal_name: "Flower";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["plants", "green", "environmental"];
    readonly codepoint: 59230;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "flower-lotus";
    readonly pascal_name: "FlowerLotus";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["plants", "green", "environmental", "spirituality"];
    readonly codepoint: 59084;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "flower-tulip";
    readonly pascal_name: "FlowerTulip";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["plants", "green", "environmental"];
    readonly codepoint: 60108;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "flying-saucer";
    readonly pascal_name: "FlyingSaucer";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["ufo", "space", "aliens", "extra terrestrial", "sci-fi"];
    readonly codepoint: 60234;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder";
    readonly pascal_name: "Folder";
    readonly alias: {
        readonly name: "folder-notch";
        readonly pascal_name: "FolderNotch";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders"];
    readonly codepoint: 57930;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-dashed";
    readonly pascal_name: "FolderDashed";
    readonly alias: {
        readonly name: "folder-dotted";
        readonly pascal_name: "FolderDotted";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "missing", "temporary", "dotted"];
    readonly codepoint: 59640;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-lock";
    readonly pascal_name: "FolderLock";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "private", "secure"];
    readonly codepoint: 59964;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-minus";
    readonly pascal_name: "FolderMinus";
    readonly alias: {
        readonly name: "folder-notch-minus";
        readonly pascal_name: "FolderNotchMinus";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "delete", "write", "remove", "-"];
    readonly codepoint: 57940;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-open";
    readonly pascal_name: "FolderOpen";
    readonly alias: {
        readonly name: "folder-notch-open";
        readonly pascal_name: "FolderNotchOpen";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "load"];
    readonly codepoint: 57942;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-plus";
    readonly pascal_name: "FolderPlus";
    readonly alias: {
        readonly name: "folder-notch-plus";
        readonly pascal_name: "FolderNotchPlus";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "save", "write", "add", "new", "create", "+"];
    readonly codepoint: 57944;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-simple";
    readonly pascal_name: "FolderSimple";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders"];
    readonly codepoint: 57946;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-simple-dashed";
    readonly pascal_name: "FolderSimpleDashed";
    readonly alias: {
        readonly name: "folder-simple-dotted";
        readonly pascal_name: "FolderSimpleDotted";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "missing", "temporary", "dotted"];
    readonly codepoint: 60458;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-simple-lock";
    readonly pascal_name: "FolderSimpleLock";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "private", "secure"];
    readonly codepoint: 60254;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-simple-minus";
    readonly pascal_name: "FolderSimpleMinus";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "delete", "write", "remove", "-"];
    readonly codepoint: 57948;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-simple-plus";
    readonly pascal_name: "FolderSimplePlus";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "save", "write", "add", "new", "create", "+"];
    readonly codepoint: 57950;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "folder-simple-star";
    readonly pascal_name: "FolderSimpleStar";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "favorite", "starred"];
    readonly codepoint: 60462;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-simple-user";
    readonly pascal_name: "FolderSimpleUser";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "personal"];
    readonly codepoint: 60256;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-star";
    readonly pascal_name: "FolderStar";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "favorite", "starred"];
    readonly codepoint: 60038;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folder-user";
    readonly pascal_name: "FolderUser";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "personal"];
    readonly codepoint: 60230;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "folders";
    readonly pascal_name: "Folders";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["directory", "directories", "files", "folders", "copy", "copied", "duplicated"];
    readonly codepoint: 57952;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "football";
    readonly pascal_name: "Football";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["sports", "american football", "nfl"];
    readonly codepoint: 59160;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "football-helmet";
    readonly pascal_name: "FootballHelmet";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "american football", "nfl"];
    readonly codepoint: 61004;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "footprints";
    readonly pascal_name: "Footprints";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["path", "trail", "walk", "route", "hike", "hiking"];
    readonly codepoint: 60040;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "fork-knife";
    readonly pascal_name: "ForkKnife";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["food", "meal", "eating", "restaurants", "dining", "utensils"];
    readonly codepoint: 57954;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "four-k";
    readonly pascal_name: "FourK";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "uhd", "resolution", "video"];
    readonly codepoint: 59996;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "frame-corners";
    readonly pascal_name: "FrameCorners";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["expand", "fullscreen", "maximized", "resize", "windowed", "capture"];
    readonly codepoint: 58918;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "framer-logo";
    readonly pascal_name: "FramerLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "interface", "ui", "motion", "prototype", "prototyping"];
    readonly codepoint: 57956;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "function";
    readonly pascal_name: "Function";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["mathematics", "arithmetic", "f-stop"];
    readonly codepoint: 60388;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "funnel";
    readonly pascal_name: "Funnel";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["filters", "refine", "sorting"];
    readonly codepoint: 57958;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "funnel-simple";
    readonly pascal_name: "FunnelSimple";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["filters", "refine", "sorting"];
    readonly codepoint: 57960;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "funnel-simple-x";
    readonly pascal_name: "FunnelSimpleX";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "filters", "refine", "sorting"];
    readonly codepoint: 57962;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "funnel-x";
    readonly pascal_name: "FunnelX";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "filters", "refine", "sorting"];
    readonly codepoint: 57964;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "game-controller";
    readonly pascal_name: "GameController";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["gaming", "video games", "nintendo switch", "sony playstation", "microsoft xbox"];
    readonly codepoint: 57966;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "garage";
    readonly pascal_name: "Garage";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["vehicles", "automobile", "buildings", "transportation"];
    readonly codepoint: 60630;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "gas-can";
    readonly pascal_name: "GasCan";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["jerrycan", "petrol", "fuel", "gasoline"];
    readonly codepoint: 59598;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "gas-pump";
    readonly pascal_name: "GasPump";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["gas station", "petrol", "fuel", "gasoline"];
    readonly codepoint: 59240;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "gauge";
    readonly pascal_name: "Gauge";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["dashboard", "meter", "speed", "speedometer", "odometer", "performance"];
    readonly codepoint: 58920;
    readonly published_in: 1.2;
    readonly updated_in: 1.4;
}, {
    readonly name: "gavel";
    readonly pascal_name: "Gavel";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["judge", "justice", "legal", "law", "court", "hammer", "government"];
    readonly codepoint: 59954;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "gear";
    readonly pascal_name: "Gear";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["8", "settings", "setup", "preferences", "cogs", "gears", "machinery", "mechanical"];
    readonly codepoint: 57968;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "gear-fine";
    readonly pascal_name: "GearFine";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["setup", "preferences", "cogs", "gears", "machinery", "mechanical"];
    readonly codepoint: 59516;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "gear-six";
    readonly pascal_name: "GearSix";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["6", "settings", "setup", "preferences", "cogs", "gears", "machinery", "mechanical"];
    readonly codepoint: 57970;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "gender-female";
    readonly pascal_name: "GenderFemale";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["woman", "feminine", "venus"];
    readonly codepoint: 59104;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "gender-intersex";
    readonly pascal_name: "GenderIntersex";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["transgender", "non-binary"];
    readonly codepoint: 59110;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "gender-male";
    readonly pascal_name: "GenderMale";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["man", "masculine", "mars"];
    readonly codepoint: 59106;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "gender-neuter";
    readonly pascal_name: "GenderNeuter";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["agender", "non-binary", "asexual"];
    readonly codepoint: 59114;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "gender-nonbinary";
    readonly pascal_name: "GenderNonbinary";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["intersex", "non-binary"];
    readonly codepoint: 59108;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "gender-transgender";
    readonly pascal_name: "GenderTransgender";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["intersex", "non-binary"];
    readonly codepoint: 59112;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "ghost";
    readonly pascal_name: "Ghost";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["pac-man", "spirit", "scary", "halloween"];
    readonly codepoint: 58922;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "gif";
    readonly pascal_name: "Gif";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["gifs", ".gif", "giphy"];
    readonly codepoint: 57972;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "gift";
    readonly pascal_name: "Gift";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["presents", "holiday", "birthday"];
    readonly codepoint: 57974;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "git-branch";
    readonly pascal_name: "GitBranch";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*updated*", "github", "vcs", "source control", "version control", "versioning", "branches"];
    readonly codepoint: 57976;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "git-commit";
    readonly pascal_name: "GitCommit";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["github", "vcs", "source control", "version control", "versioning", "commits"];
    readonly codepoint: 57978;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "git-diff";
    readonly pascal_name: "GitDiff";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*updated*", "github", "vcs", "source control", "version control", "versioning", "difference", "compare"];
    readonly codepoint: 57980;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "git-fork";
    readonly pascal_name: "GitFork";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*updated*", "github", "vcs", "source control", "version control", "versioning", "split"];
    readonly codepoint: 57982;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "git-merge";
    readonly pascal_name: "GitMerge";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*updated*", "github", "vcs", "source control", "version control", "versioning", "split"];
    readonly codepoint: 57984;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "git-pull-request";
    readonly pascal_name: "GitPullRequest";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*updated*", "github", "vcs", "source control", "version control", "versioning", "merge request"];
    readonly codepoint: 57986;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "github-logo";
    readonly pascal_name: "GithubLogo";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["octocat", "vcs", "source control", "version control", "versioning", "branches"];
    readonly codepoint: 58742;
    readonly published_in: 1.1;
    readonly updated_in: 2;
}, {
    readonly name: "gitlab-logo";
    readonly pascal_name: "GitlabLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["vcs", "source control", "version control", "versioning", "branches"];
    readonly codepoint: 59028;
    readonly published_in: 1.3;
    readonly updated_in: 2;
}, {
    readonly name: "gitlab-logo-simple";
    readonly pascal_name: "GitlabLogoSimple";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["vcs", "source control", "version control", "versioning", "branches"];
    readonly codepoint: 59030;
    readonly published_in: 1.3;
    readonly updated_in: 2;
}, {
    readonly name: "globe";
    readonly pascal_name: "Globe";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["world", "earth", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography", "internet"];
    readonly codepoint: 57992;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "globe-hemisphere-east";
    readonly pascal_name: "GlobeHemisphereEast";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["world", "earth", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography", "europe", "africa", "asia", "australia"];
    readonly codepoint: 57994;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "globe-hemisphere-west";
    readonly pascal_name: "GlobeHemisphereWest";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["world", "earth", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography", "north america", "south america"];
    readonly codepoint: 57996;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "globe-simple";
    readonly pascal_name: "GlobeSimple";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["world", "earth", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography"];
    readonly codepoint: 57998;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "globe-simple-x";
    readonly pascal_name: "GlobeSimpleX";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "world", "earth", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography", "internet"];
    readonly codepoint: 57988;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "globe-stand";
    readonly pascal_name: "GlobeStand";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["world", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography"];
    readonly codepoint: 58000;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "globe-x";
    readonly pascal_name: "GlobeX";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "world", "earth", "global", "planet", "circle", "round", "internationalization", "i18n", "languages", "country", "countries", "geography", "internet"];
    readonly codepoint: 57990;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "goggles";
    readonly pascal_name: "Goggles";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["swim", "swimming", "sports", "exercise", "olympics", "aquatics"];
    readonly codepoint: 60596;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "golf";
    readonly pascal_name: "Golf";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "pga", "tee", "ball"];
    readonly codepoint: 59966;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "goodreads-logo";
    readonly pascal_name: "GoodreadsLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*updated*", "reading", "books", "social media", "logos"];
    readonly codepoint: 60688;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "google-cardboard-logo";
    readonly pascal_name: "GoogleCardboardLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["virtual reality", "vr", "logos"];
    readonly codepoint: 59318;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "google-chrome-logo";
    readonly pascal_name: "GoogleChromeLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["web browsers", "internet"];
    readonly codepoint: 59766;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "google-drive-logo";
    readonly pascal_name: "GoogleDriveLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["cloud", "storage", "backup", "logos"];
    readonly codepoint: 59638;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "google-logo";
    readonly pascal_name: "GoogleLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "search engine", "phone", "mobile", "android"];
    readonly codepoint: 58002;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "google-photos-logo";
    readonly pascal_name: "GooglePhotosLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["album", "pictures", "photography"];
    readonly codepoint: 60306;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "google-play-logo";
    readonly pascal_name: "GooglePlayLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.SYSTEM, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "games", "apps", "applications", "play store", "app store", "phone", "mobile", "android"];
    readonly codepoint: 58004;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "google-podcasts-logo";
    readonly pascal_name: "GooglePodcastsLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["audio"];
    readonly codepoint: 60308;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "gps";
    readonly pascal_name: "Gps";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "geolocation", "location", "navigation"];
    readonly codepoint: 60888;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "gps-fix";
    readonly pascal_name: "GpsFix";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "geolocation", "location", "navigation"];
    readonly codepoint: 60886;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "gps-slash";
    readonly pascal_name: "GpsSlash";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "geolocation", "location", "navigation", "disabled"];
    readonly codepoint: 60884;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "gradient";
    readonly pascal_name: "Gradient";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["fade", "ombre", "opacity"];
    readonly codepoint: 60226;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "graduation-cap";
    readonly pascal_name: "GraduationCap";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["classroom", "teacher", "education", "school", "college", "university", "degree", "graduate", "hat"];
    readonly codepoint: 58924;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "grains";
    readonly pascal_name: "Grains";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["wheat", "gluten", "farm", "farming", "agriculture"];
    readonly codepoint: 60520;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "grains-slash";
    readonly pascal_name: "GrainsSlash";
    readonly categories: readonly [IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["gluten-free", "wheat", "gluten", "farm", "farming", "agriculture"];
    readonly codepoint: 60522;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "graph";
    readonly pascal_name: "Graph";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["nodes", "tree"];
    readonly codepoint: 60248;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "graphics-card";
    readonly pascal_name: "GraphicsCard";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*new*", "graphics card", "microchip", "computer", "circuit"];
    readonly codepoint: 58898;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "greater-than";
    readonly pascal_name: "GreaterThan";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", ">", "greater than", "gt", "comparison", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60868;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "greater-than-or-equal";
    readonly pascal_name: "GreaterThanOrEqual";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "≥", "greater than or equal", "gte", "comparison", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60834;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "grid-four";
    readonly pascal_name: "GridFour";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["4", "apps", "applications", "squares", "tiles", "cells", "tables", "tabular", "spreadsheets", "excel"];
    readonly codepoint: 58006;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "grid-nine";
    readonly pascal_name: "GridNine";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["9", "apps", "applications", "squares", "tiles", "cells", "tables", "tabular", "spreadsheets", "excel"];
    readonly codepoint: 60556;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "guitar";
    readonly pascal_name: "Guitar";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "instrument"];
    readonly codepoint: 60042;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hair-dryer";
    readonly pascal_name: "HairDryer";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "blow dryer", "beauty", "grooming", "salon"];
    readonly codepoint: 60006;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hamburger";
    readonly pascal_name: "Hamburger";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["fast food", "party", "places", "locations", "restaurants", "food", "dining"];
    readonly codepoint: 59280;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "hammer";
    readonly pascal_name: "Hammer";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tools", "carpentry", "construction"];
    readonly codepoint: 59406;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hand";
    readonly pascal_name: "Hand";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pointers", "cursors", "emoji", "backhand"];
    readonly codepoint: 58008;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hand-arrow-down";
    readonly pascal_name: "HandArrowDown";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "take", "receive", "remove", "withdraw", "emoji"];
    readonly codepoint: 59982;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hand-arrow-up";
    readonly pascal_name: "HandArrowUp";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "give", "insert", "deposit", "donation", "emoji"];
    readonly codepoint: 61018;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hand-coins";
    readonly pascal_name: "HandCoins";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["donation", "payment", "money", "paying", "purchase"];
    readonly codepoint: 60044;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hand-deposit";
    readonly pascal_name: "HandDeposit";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "give", "insert", "donation", "atm", "emoji"];
    readonly codepoint: 61058;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hand-eye";
    readonly pascal_name: "HandEye";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*updated*", "emoji", "hamsa", "evil eye"];
    readonly codepoint: 59980;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "hand-fist";
    readonly pascal_name: "HandFist";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["emoji", "power", "protest", "blm"];
    readonly codepoint: 58746;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "hand-grabbing";
    readonly pascal_name: "HandGrabbing";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pointers", "cursors", "emoji", "drag", "hold"];
    readonly codepoint: 58748;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "hand-heart";
    readonly pascal_name: "HandHeart";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["donation", "care", "emoji"];
    readonly codepoint: 59408;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hand-palm";
    readonly pascal_name: "HandPalm";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pointers", "cursors", "emoji", "palm", "stop", "wait", "hamsa", "5"];
    readonly codepoint: 58750;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "hand-peace";
    readonly pascal_name: "HandPeace";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "emoji", "victory"];
    readonly codepoint: 59340;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hand-pointing";
    readonly pascal_name: "HandPointing";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pointers", "cursors", "emoji", "fingers", "clicks", "mouse"];
    readonly codepoint: 58010;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hand-soap";
    readonly pascal_name: "HandSoap";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["dispenser", "pump", "sanitizer", "disinfectant", "lotion", "bottle"];
    readonly codepoint: 58928;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "hand-swipe-left";
    readonly pascal_name: "HandSwipeLeft";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["pointers", "cursors", "gesture"];
    readonly codepoint: 60564;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hand-swipe-right";
    readonly pascal_name: "HandSwipeRight";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["pointers", "cursors", "gesture"];
    readonly codepoint: 60562;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hand-tap";
    readonly pascal_name: "HandTap";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["pointers", "cursors", "gesture"];
    readonly codepoint: 60560;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "hand-waving";
    readonly pascal_name: "HandWaving";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["emoji", "palm", "wave", "hello", "goodbye"];
    readonly codepoint: 58752;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "hand-withdraw";
    readonly pascal_name: "HandWithdraw";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "take", "remove", "withdrawal", "atm", "emoji"];
    readonly codepoint: 61056;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "handbag";
    readonly pascal_name: "Handbag";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["suitcases", "valises", "baggage", "purses"];
    readonly codepoint: 58012;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "handbag-simple";
    readonly pascal_name: "HandbagSimple";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["suitcases", "valises", "baggage", "purses"];
    readonly codepoint: 58926;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "hands-clapping";
    readonly pascal_name: "HandsClapping";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["emoji", "clap", "applause"];
    readonly codepoint: 59040;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "hands-praying";
    readonly pascal_name: "HandsPraying";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["emoji", "religion", "worship", "prayer", "thanks", "thank you"];
    readonly codepoint: 60616;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "handshake";
    readonly pascal_name: "Handshake";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["emoji", "deal", "agreement"];
    readonly codepoint: 58754;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "hard-drive";
    readonly pascal_name: "HardDrive";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "hard disk", "storage", "hdd", "servers", "databases"];
    readonly codepoint: 58014;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hard-drives";
    readonly pascal_name: "HardDrives";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "hard disk", "storage", "hdd", "servers", "databases"];
    readonly codepoint: 58016;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hard-hat";
    readonly pascal_name: "HardHat";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "safety", "construction", "industry", "helmet", "ppe"];
    readonly codepoint: 60742;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hash";
    readonly pascal_name: "Hash";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["hashtag", "octothorpe", "pound sign", "number sign", "tic-tac-toe", "symbol"];
    readonly codepoint: 58018;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hash-straight";
    readonly pascal_name: "HashStraight";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["hashtag", "octothorpe", "pound sign", "number sign", "tic-tac-toe", "symbol"];
    readonly codepoint: 58020;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "head-circuit";
    readonly pascal_name: "HeadCircuit";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*new*", "automaton", "artificial intelligence", "ai"];
    readonly codepoint: 59348;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "headlights";
    readonly pascal_name: "Headlights";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["brights", "high beams"];
    readonly codepoint: 59134;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "headphones";
    readonly pascal_name: "Headphones";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "listening"];
    readonly codepoint: 58022;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "headset";
    readonly pascal_name: "Headset";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "listening", "gaming", "voice chat", "microphone", "headphones", "support", "customer-service", "call-center"];
    readonly codepoint: 58756;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "heart";
    readonly pascal_name: "Heart";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.GAMES, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["wellness", "love", "healthy", "like", "favorites", "favorited", "suits", "cards", "gambling", "casino", "gaming", "emoji"];
    readonly codepoint: 58024;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "heart-break";
    readonly pascal_name: "HeartBreak";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["love", "hate", "crack", "split", "divorce", "emoji"];
    readonly codepoint: 60392;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "heart-half";
    readonly pascal_name: "HeartHalf";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.GAMES, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["wellness", "love", "healthy", "like", "favorites", "favorited"];
    readonly codepoint: 60488;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "heart-straight";
    readonly pascal_name: "HeartStraight";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.GAMES, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["wellness", "love", "healthy", "like", "favorites", "favorited", "suits", "cards", "gambling", "casino", "gaming", "emoji"];
    readonly codepoint: 58026;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "heart-straight-break";
    readonly pascal_name: "HeartStraightBreak";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["love", "hate", "crack", "split", "divorce", "emoji"];
    readonly codepoint: 60312;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "heartbeat";
    readonly pascal_name: "Heartbeat";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["wellness", "healthy", "ecg", "ekg", "vitals", "monitor"];
    readonly codepoint: 58028;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "hexagon";
    readonly pascal_name: "Hexagon";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["6", "shapes", "polygons"];
    readonly codepoint: 58030;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "high-definition";
    readonly pascal_name: "HighDefinition";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "hd", "resolution", "video"];
    readonly codepoint: 60046;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "high-heel";
    readonly pascal_name: "HighHeel";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*updated*", "pumps", "clothes", "clothing", "shoes"];
    readonly codepoint: 59624;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "highlighter";
    readonly pascal_name: "Highlighter";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "marker", "write", "writing", "editing"];
    readonly codepoint: 60534;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "highlighter-circle";
    readonly pascal_name: "HighlighterCircle";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "drawing"];
    readonly codepoint: 58930;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "hockey";
    readonly pascal_name: "Hockey";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "nhl", "stick", "puck"];
    readonly codepoint: 60550;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hoodie";
    readonly pascal_name: "Hoodie";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothes", "clothing", "sweatshirt"];
    readonly codepoint: 60624;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "horse";
    readonly pascal_name: "Horse";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["animals", "equestrian", "chess", "knight", "sports"];
    readonly codepoint: 58032;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hospital";
    readonly pascal_name: "Hospital";
    readonly categories: readonly [IconCategory.MAP, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "places", "locations", "medical", "medicine", "emergency", "doctor", "buildings"];
    readonly codepoint: 59460;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "hourglass";
    readonly pascal_name: "Hourglass";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58034;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-high";
    readonly pascal_name: "HourglassHigh";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58036;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-low";
    readonly pascal_name: "HourglassLow";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58038;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-medium";
    readonly pascal_name: "HourglassMedium";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58040;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-simple";
    readonly pascal_name: "HourglassSimple";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58042;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-simple-high";
    readonly pascal_name: "HourglassSimpleHigh";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58044;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-simple-low";
    readonly pascal_name: "HourglassSimpleLow";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58046;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hourglass-simple-medium";
    readonly pascal_name: "HourglassSimpleMedium";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarms", "clock", "schedule", "events", "waiting", "progress"];
    readonly codepoint: 58048;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "house";
    readonly pascal_name: "House";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["homes", "buildings", "places", "locations"];
    readonly codepoint: 58050;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "house-line";
    readonly pascal_name: "HouseLine";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "homes", "buildings", "places", "locations"];
    readonly codepoint: 58052;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "house-simple";
    readonly pascal_name: "HouseSimple";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["homes", "buildings", "places", "locations"];
    readonly codepoint: 58054;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "hurricane";
    readonly pascal_name: "Hurricane";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "meteorology", "cyclone", "storm", "disaster", "wind"];
    readonly codepoint: 59534;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "ice-cream";
    readonly pascal_name: "IceCream";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["food", "dessert", "cone"];
    readonly codepoint: 59396;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "identification-badge";
    readonly pascal_name: "IdentificationBadge";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["license", "credentials", "nametag", "user", "verification"];
    readonly codepoint: 59126;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "identification-card";
    readonly pascal_name: "IdentificationCard";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["license", "badge", "credentials", "nametag", "user", "verification"];
    readonly codepoint: 58056;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "image";
    readonly pascal_name: "Image";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "pictures", "photographs", "photography", "wallpapers", "gallery", "landscape"];
    readonly codepoint: 58058;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "image-broken";
    readonly pascal_name: "ImageBroken";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "pictures", "photographs", "photography", "wallpapers", "gallery", "landscape", "missing", "error", "404"];
    readonly codepoint: 59304;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "image-square";
    readonly pascal_name: "ImageSquare";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["pictures", "photographs", "photography", "wallpapers", "gallery", "landscape"];
    readonly codepoint: 58060;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "images";
    readonly pascal_name: "Images";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "pictures", "photographs", "photography", "wallpapers", "gallery", "landscape", "album"];
    readonly codepoint: 59446;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "images-square";
    readonly pascal_name: "ImagesSquare";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["pictures", "photographs", "photography", "wallpapers", "gallery", "landscape", "album"];
    readonly codepoint: 59444;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "infinity";
    readonly pascal_name: "Infinity";
    readonly alias: {
        readonly name: "lemniscate";
        readonly pascal_name: "Lemniscate";
    };
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["infinite", "lemniscate", "figure-eight", "mathematics", "arithmetic", "calculator", "∞"];
    readonly codepoint: 58932;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "info";
    readonly pascal_name: "Info";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["information", "help", "support"];
    readonly codepoint: 58062;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "instagram-logo";
    readonly pascal_name: "InstagramLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "social media", "photography", "camera"];
    readonly codepoint: 58064;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "intersect";
    readonly pascal_name: "Intersect";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["round", "join", "union", "merge", "combine", "intersecting", "intersection"];
    readonly codepoint: 58066;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "intersect-square";
    readonly pascal_name: "IntersectSquare";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["venn-diagram", "join", "intersection"];
    readonly codepoint: 59514;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "intersect-three";
    readonly pascal_name: "IntersectThree";
    readonly categories: readonly [IconCategory.PEOPLE, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["venn-diagram", "join", "intersection", "gender", "pronouns"];
    readonly codepoint: 60612;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "intersection";
    readonly pascal_name: "Intersection";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "∩", "intersection", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60858;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "invoice";
    readonly pascal_name: "Invoice";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "receipt", "expense", "bill"];
    readonly codepoint: 60994;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "island";
    readonly pascal_name: "Island";
    readonly categories: readonly [IconCategory.MAP, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "geography", "beach", "ocean", "tropical", "palm", "vacation", "trip", "locations", "places"];
    readonly codepoint: 60934;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "jar";
    readonly pascal_name: "Jar";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "mason jar", "kitchen", "pantry", "canning", "preserves", "food", "condiments"];
    readonly codepoint: 59360;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "jar-label";
    readonly pascal_name: "JarLabel";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "mason jar", "kitchen", "pantry", "canning", "preserves", "food", "condiments"];
    readonly codepoint: 59360;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "jeep";
    readonly pascal_name: "Jeep";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "vehicles", "automobile", "suv", "cars", "trucks", "wrangler", "off-road", "transit", "transportation", "traveling"];
    readonly codepoint: 58068;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "joystick";
    readonly pascal_name: "Joystick";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "gaming", "game controller", "video games", "arcade game", "atari"];
    readonly codepoint: 59998;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "kanban";
    readonly pascal_name: "Kanban";
    readonly categories: readonly [IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["scheduling", "tasks", "project management", "process", "lean", "agile"];
    readonly codepoint: 60244;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "key";
    readonly pascal_name: "Key";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption"];
    readonly codepoint: 58070;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "key-return";
    readonly pascal_name: "KeyReturn";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["keyboard", "enter"];
    readonly codepoint: 59266;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "keyboard";
    readonly pascal_name: "Keyboard";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["typing", "type", "keys", "input"];
    readonly codepoint: 58072;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "keyhole";
    readonly pascal_name: "Keyhole";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["lock", "security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption", "privacy", "private"];
    readonly codepoint: 60024;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "knife";
    readonly pascal_name: "Knife";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tools", "food", "meal", "eating", "restaurants", "dining", "utensils"];
    readonly codepoint: 58934;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "ladder";
    readonly pascal_name: "Ladder";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["stairs", "steps", "climbing"];
    readonly codepoint: 59876;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "ladder-simple";
    readonly pascal_name: "LadderSimple";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["stairs", "steps", "climbing"];
    readonly codepoint: 60454;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "lamp";
    readonly pascal_name: "Lamp";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["light", "furniture", "appliances"];
    readonly codepoint: 58936;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "lamp-pendant";
    readonly pascal_name: "LampPendant";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "light", "furniture", "appliances"];
    readonly codepoint: 60974;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "laptop";
    readonly pascal_name: "Laptop";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["computer", "notebook", "pc", "macbook"];
    readonly codepoint: 58758;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "lasso";
    readonly pascal_name: "Lasso";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "select", "selection", "loop", "rope", "cowboy"];
    readonly codepoint: 60870;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "lastfm-logo";
    readonly pascal_name: "LastfmLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "scrobble", "music", "social media"];
    readonly codepoint: 59458;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "layout";
    readonly pascal_name: "Layout";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["wireframe", "sidebar", "ui", "interface"];
    readonly codepoint: 59094;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "leaf";
    readonly pascal_name: "Leaf";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["plants", "trees", "branches", "leaves", "nodes", "green", "environmental"];
    readonly codepoint: 58074;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "lectern";
    readonly pascal_name: "Lectern";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["*new*", "lecture", "podium", "pulpit", "stand", "speech", "presentation", "keynote"];
    readonly codepoint: 59738;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "lego";
    readonly pascal_name: "Lego";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "toys", "blocks", "bricks"];
    readonly codepoint: 59590;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "lego-smiley";
    readonly pascal_name: "LegoSmiley";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "face", "emoji", "toys", "blocks", "bricks"];
    readonly codepoint: 59590;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "less-than";
    readonly pascal_name: "LessThan";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "<", "less than", "lt", "comparison", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60844;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "less-than-or-equal";
    readonly pascal_name: "LessThanOrEqual";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "≤", "less than or equal", "lte", "comparison", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60836;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "letter-circle-h";
    readonly pascal_name: "LetterCircleH";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.MAP, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "hospital", "letter", "glyph", "character"];
    readonly codepoint: 60408;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "letter-circle-p";
    readonly pascal_name: "LetterCircleP";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.MAP, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "parking lot", "valet", "vehicles", "letter", "glyph", "character"];
    readonly codepoint: 60424;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "letter-circle-v";
    readonly pascal_name: "LetterCircleV";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.DESIGN, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "vegan", "letter", "glyph", "character"];
    readonly codepoint: 60436;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "lifebuoy";
    readonly pascal_name: "Lifebuoy";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["lifebelt", "lifesaver", "safety", "help", "support", "nautical", "boats", "ships"];
    readonly codepoint: 58938;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "lightbulb";
    readonly pascal_name: "Lightbulb";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["flashlight", "bulbs", "lighting", "led", "energy", "idea"];
    readonly codepoint: 58076;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lightbulb-filament";
    readonly pascal_name: "LightbulbFilament";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["flashlight", "bulbs", "lighting", "led", "energy", "idea"];
    readonly codepoint: 58940;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "lighthouse";
    readonly pascal_name: "Lighthouse";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["buildings", "nautical", "navigation", "boats", "ships", "safety"];
    readonly codepoint: 59894;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "lightning";
    readonly pascal_name: "Lightning";
    readonly categories: readonly [IconCategory.WEATHER, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["meteorology", "stormy", "thunderstorm", "thunderbolt", "charged", "charger", "charging", "power", "electricity", "flash"];
    readonly codepoint: 58078;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lightning-a";
    readonly pascal_name: "LightningA";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["flash", "auto"];
    readonly codepoint: 60036;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "lightning-slash";
    readonly pascal_name: "LightningSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["thunderbolt", "charged", "charger", "charging", "power", "electricity", "disabled", "flash"];
    readonly codepoint: 58080;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "line-segment";
    readonly pascal_name: "LineSegment";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "drawing", "path", "pen", "vector"];
    readonly codepoint: 59090;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "line-segments";
    readonly pascal_name: "LineSegments";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "drawing", "path", "pen", "vector"];
    readonly codepoint: 59092;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "line-vertical";
    readonly pascal_name: "LineVertical";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "bar", "pipe", "|", "divider. symbol"];
    readonly codepoint: 60784;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "link";
    readonly pascal_name: "Link";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "anchor", "hyperlink", "hypertext", "chains", "chained"];
    readonly codepoint: 58082;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "link-break";
    readonly pascal_name: "LinkBreak";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["anchor", "hyperlink", "hypertext", "chains", "chained", "errors", "broken"];
    readonly codepoint: 58084;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "link-simple";
    readonly pascal_name: "LinkSimple";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["anchor", "hyperlink", "hypertext", "chains", "chained"];
    readonly codepoint: 58086;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "link-simple-break";
    readonly pascal_name: "LinkSimpleBreak";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["anchor", "hyperlink", "hypertext", "chains", "chained", "errors", "broken"];
    readonly codepoint: 58088;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "link-simple-horizontal";
    readonly pascal_name: "LinkSimpleHorizontal";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["anchor", "hyperlink", "hypertext", "chains", "chained"];
    readonly codepoint: 58090;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "link-simple-horizontal-break";
    readonly pascal_name: "LinkSimpleHorizontalBreak";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["anchor", "hyperlink", "hypertext", "chains", "chained", "errors", "broken"];
    readonly codepoint: 58092;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "linkedin-logo";
    readonly pascal_name: "LinkedinLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "jobs", "employment", "social media"];
    readonly codepoint: 58094;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "linktree-logo";
    readonly pascal_name: "LinktreeLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "social media", "links"];
    readonly codepoint: 60910;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "linux-logo";
    readonly pascal_name: "LinuxLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["penguin", "computer", "animals"];
    readonly codepoint: 60162;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "list";
    readonly pascal_name: "List";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "hamburger menu", "overflow menu", "sidebar", "3", "ul", "ol", "unordered list", "ordered list", "checklist", "lines"];
    readonly codepoint: 58096;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-bullets";
    readonly pascal_name: "ListBullets";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "ul", "unordered list", "bulleted list", "checklist"];
    readonly codepoint: 58098;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-checks";
    readonly pascal_name: "ListChecks";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "checklist", "todo"];
    readonly codepoint: 60124;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-dashes";
    readonly pascal_name: "ListDashes";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "ul", "unordered list", "dashed list", "checklist"];
    readonly codepoint: 58100;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-heart";
    readonly pascal_name: "ListHeart";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "favorites", "wishlist", "liked"];
    readonly codepoint: 60382;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-magnifying-glass";
    readonly pascal_name: "ListMagnifyingGlass";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["search", "find", "locate", "query", "inspect"];
    readonly codepoint: 60384;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "list-numbers";
    readonly pascal_name: "ListNumbers";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "ol", "ordered list", "numbered list", "checklist"];
    readonly codepoint: 58102;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-plus";
    readonly pascal_name: "ListPlus";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "ul", "ol", "unordered list", "ordered list", "checklist", "add", "+"];
    readonly codepoint: 58104;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "list-star";
    readonly pascal_name: "ListStar";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "favorites", "wishlist", "liked"];
    readonly codepoint: 60380;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "lock";
    readonly pascal_name: "Lock";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption", "privacy", "private"];
    readonly codepoint: 58106;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-key";
    readonly pascal_name: "LockKey";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption", "privacy", "private"];
    readonly codepoint: 58110;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-key-open";
    readonly pascal_name: "LockKeyOpen";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "unsecured", "authentication", "unauthenticated", "login", "unlocked", "unencrypted", "encryption", "privacy"];
    readonly codepoint: 58112;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-laminated";
    readonly pascal_name: "LockLaminated";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption", "privacy", "private"];
    readonly codepoint: 58114;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-laminated-open";
    readonly pascal_name: "LockLaminatedOpen";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "unsecured", "authentication", "unauthenticated", "login", "unlocked", "unencrypted", "encryption", "privacy", "private"];
    readonly codepoint: 58116;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-open";
    readonly pascal_name: "LockOpen";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "unsecured", "authentication", "unauthenticated", "login", "unlocked", "unencrypted", "encryption", "privacy"];
    readonly codepoint: 58118;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-simple";
    readonly pascal_name: "LockSimple";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption", "privacy", "private"];
    readonly codepoint: 58120;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lock-simple-open";
    readonly pascal_name: "LockSimpleOpen";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["padlock", "security", "unsecured", "authentication", "unauthenticated", "login", "unlocked", "unencrypted", "encryption", "privacy", "private"];
    readonly codepoint: 58122;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "lockers";
    readonly pascal_name: "Lockers";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["locker room", "gym", "storage"];
    readonly codepoint: 60600;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "log";
    readonly pascal_name: "Log";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "tree", "stump", "stick", "branch"];
    readonly codepoint: 60802;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "magic-wand";
    readonly pascal_name: "MagicWand";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["selection", "wizard", "games"];
    readonly codepoint: 59062;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "magnet";
    readonly pascal_name: "Magnet";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["magnetism", "science", "physics"];
    readonly codepoint: 59008;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "magnet-straight";
    readonly pascal_name: "MagnetStraight";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["magnetism", "science", "physics"];
    readonly codepoint: 59010;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "magnifying-glass";
    readonly pascal_name: "MagnifyingGlass";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["search", "find", "locate", "query", "inspect"];
    readonly codepoint: 58124;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "magnifying-glass-minus";
    readonly pascal_name: "MagnifyingGlassMinus";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["search", "find", "locate", "query", "inspect", "zoom out", "-"];
    readonly codepoint: 58126;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "magnifying-glass-plus";
    readonly pascal_name: "MagnifyingGlassPlus";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["search", "find", "locate", "query", "inspect", "zoom in", "+"];
    readonly codepoint: 58128;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "mailbox";
    readonly pascal_name: "Mailbox";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "email", "letters", "messaging", "post"];
    readonly codepoint: 60446;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "map-pin";
    readonly pascal_name: "MapPin";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["maps", "places", "markers", "pins", "locations", "poi", "point of interest"];
    readonly codepoint: 58134;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "map-pin-area";
    readonly pascal_name: "MapPinArea";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "maps", "places", "markers", "pins", "locations", "poi", "point of interest"];
    readonly codepoint: 60986;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "map-pin-line";
    readonly pascal_name: "MapPinLine";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["maps", "places", "markers", "pins", "locations", "poi", "point of interest"];
    readonly codepoint: 58136;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "map-pin-plus";
    readonly pascal_name: "MapPinPlus";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "maps", "places", "markers", "pins", "locations", "add", "point of interest"];
    readonly codepoint: 58132;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "map-pin-simple";
    readonly pascal_name: "MapPinSimple";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "maps", "places", "markers", "pins", "locations", "poi", "point of interest"];
    readonly codepoint: 60990;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "map-pin-simple-area";
    readonly pascal_name: "MapPinSimpleArea";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "maps", "places", "markers", "pins", "locations", "poi", "point of interest"];
    readonly codepoint: 60988;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "map-pin-simple-line";
    readonly pascal_name: "MapPinSimpleLine";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "maps", "places", "markers", "pins", "locations", "poi", "point of interest"];
    readonly codepoint: 60984;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "map-trifold";
    readonly pascal_name: "MapTrifold";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["maps", "places", "locations", "cartography", "geography"];
    readonly codepoint: 58138;
    readonly published_in: 1;
    readonly updated_in: 2;
}, {
    readonly name: "markdown-logo";
    readonly pascal_name: "MarkdownLogo";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OFFICE, IconCategory.MEDIA, IconCategory.BRAND];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["*new*", "markup", "editor", ".md"];
    readonly codepoint: 58632;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "marker-circle";
    readonly pascal_name: "MarkerCircle";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "drawing"];
    readonly codepoint: 58944;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "martini";
    readonly pascal_name: "Martini";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["glass", "drinks", "beverages", "cocktails", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 58140;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "mask-happy";
    readonly pascal_name: "MaskHappy";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["theater", "costume", "smile", "smiling", "thalia"];
    readonly codepoint: 59892;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "mask-sad";
    readonly pascal_name: "MaskSad";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["theater", "costume", "cry", "crying", "melpomene"];
    readonly codepoint: 60318;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "mastodon-logo";
    readonly pascal_name: "MastodonLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "fediverse", "social media", "decentralized"];
    readonly codepoint: 60776;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "math-operations";
    readonly pascal_name: "MathOperations";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["addition", "sum", "subtraction", "difference", "multiply", "multiplication", "product", "divide", "division", "divisor", "dividend", "quotient", "equals", "equality", "mathematics", "arithmetic", "calculator", "+", "-", "±", "×", "÷", "="];
    readonly codepoint: 58142;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "matrix-logo";
    readonly pascal_name: "MatrixLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "matrix protocol", "brands", "logos"];
    readonly codepoint: 60772;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "medal";
    readonly pascal_name: "Medal";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["ribbons", "winning", "victory", "awards", "rosette"];
    readonly codepoint: 58144;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "medal-military";
    readonly pascal_name: "MedalMilitary";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["ribbons", "winning", "victory", "awards", "military"];
    readonly codepoint: 60668;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "medium-logo";
    readonly pascal_name: "MediumLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "reading", "writing", "news", "social media"];
    readonly codepoint: 58146;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "megaphone";
    readonly pascal_name: "Megaphone";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["bullhorn", "announcements", "loudspeaker", "broadcast"];
    readonly codepoint: 58148;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "megaphone-simple";
    readonly pascal_name: "MegaphoneSimple";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["bullhorn", "announcements", "loudspeaker", "broadcast"];
    readonly codepoint: 58946;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "member-of";
    readonly pascal_name: "MemberOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "∈", "is element of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60866;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "memory";
    readonly pascal_name: "Memory";
    readonly categories: readonly [IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "ram", "microchip", "computer", "circuit", "electronics"];
    readonly codepoint: 59844;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "messenger-logo";
    readonly pascal_name: "MessengerLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "facebook", "social media"];
    readonly codepoint: 59096;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "meta-logo";
    readonly pascal_name: "MetaLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*updated*", "facebook", "logos", "social media", "logos"];
    readonly codepoint: 60674;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "meteor";
    readonly pascal_name: "Meteor";
    readonly categories: readonly [IconCategory.WEATHER, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "astronomy", "asteroid", "fireball"];
    readonly codepoint: 59834;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "metronome";
    readonly pascal_name: "Metronome";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "beat", "tempo", "bpm"];
    readonly codepoint: 60558;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "microphone";
    readonly pascal_name: "Microphone";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["audio", "recording", "music", "sound", "podcast", "studio"];
    readonly codepoint: 58150;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "microphone-slash";
    readonly pascal_name: "MicrophoneSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["audio", "recording", "music", "sound", "podcast", "studio", "muted", "disabled"];
    readonly codepoint: 58152;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "microphone-stage";
    readonly pascal_name: "MicrophoneStage";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["audio", "recording", "music", "sound", "performance", "concert"];
    readonly codepoint: 59228;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "microscope";
    readonly pascal_name: "Microscope";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.DEVELOPMENT, IconCategory.OBJECTS, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["*new*", "science", "biology", "experiment", "magnify"];
    readonly codepoint: 60538;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "microsoft-excel-logo";
    readonly pascal_name: "MicrosoftExcelLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["tables", "spreadsheets", "tabular"];
    readonly codepoint: 60268;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "microsoft-outlook-logo";
    readonly pascal_name: "MicrosoftOutlookLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["email", "logos"];
    readonly codepoint: 60272;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "microsoft-powerpoint-logo";
    readonly pascal_name: "MicrosoftPowerpointLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["slides", "slideshow", "presentation"];
    readonly codepoint: 60110;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "microsoft-teams-logo";
    readonly pascal_name: "MicrosoftTeamsLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["chat", "video conference"];
    readonly codepoint: 60262;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "microsoft-word-logo";
    readonly pascal_name: "MicrosoftWordLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["documents", "word processor", "doc", "docx"];
    readonly codepoint: 60266;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "minus";
    readonly pascal_name: "Minus";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["-", "subtraction", "difference", "mathematics", "arithmetic", "calculator", "line", "horizontal", "divider"];
    readonly codepoint: 58154;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "minus-circle";
    readonly pascal_name: "MinusCircle";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["-", "subtraction", "difference", "mathematics", "arithmetic", "calculator", "round"];
    readonly codepoint: 58156;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "minus-square";
    readonly pascal_name: "MinusSquare";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["-", "subtraction", "difference", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60748;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "money";
    readonly pascal_name: "Money";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["cash", "dollars", "paper bills", "payment", "paying", "purchase"];
    readonly codepoint: 58760;
    readonly published_in: 1.1;
    readonly updated_in: 2;
}, {
    readonly name: "money-wavy";
    readonly pascal_name: "MoneyWavy";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "cash", "dollars", "paper bills", "payment", "paying", "purchase"];
    readonly codepoint: 61032;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "monitor";
    readonly pascal_name: "Monitor";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["screen", "television", "tv", "displays"];
    readonly codepoint: 58158;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "monitor-arrow-up";
    readonly pascal_name: "MonitorArrowUp";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "screen", "screencast", "screenshare", "upload", "video", "movie"];
    readonly codepoint: 58762;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "monitor-play";
    readonly pascal_name: "MonitorPlay";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["screen", "television", "tv", "displays", "screencast", "video", "movie"];
    readonly codepoint: 58764;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "moon";
    readonly pascal_name: "Moon";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.SYSTEM, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["night", "evening", "clear", "sleep", "snooze", "night mode", "dark mode", "astronomy", "stargazing"];
    readonly codepoint: 58160;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "moon-stars";
    readonly pascal_name: "MoonStars";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["night", "evening", "clear", "sleep", "snooze", "night mode", "dark mode", "astronomy", "stargazing", "constellation"];
    readonly codepoint: 58766;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "moped";
    readonly pascal_name: "Moped";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["scooter", "vehicles", "vespa", "transportation", "travel"];
    readonly codepoint: 59428;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "moped-front";
    readonly pascal_name: "MopedFront";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["scooter", "vehicles", "vespa", "transportation", "travel"];
    readonly codepoint: 59426;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "mosque";
    readonly pascal_name: "Mosque";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["islam", "muslim", "religion", "worship"];
    readonly codepoint: 60654;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "motorcycle";
    readonly pascal_name: "Motorcycle";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "motorbike", "transportation", "travel"];
    readonly codepoint: 59402;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "mountains";
    readonly pascal_name: "Mountains";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*updated*", "hills", "outdoors", "terrain", "geology", "adventure"];
    readonly codepoint: 59310;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "mouse";
    readonly pascal_name: "Mouse";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "clicks", "input"];
    readonly codepoint: 58170;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "mouse-left-click";
    readonly pascal_name: "MouseLeftClick";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "clicks", "input"];
    readonly codepoint: 58164;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "mouse-middle-click";
    readonly pascal_name: "MouseMiddleClick";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "clicks", "input"];
    readonly codepoint: 58168;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "mouse-right-click";
    readonly pascal_name: "MouseRightClick";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "clicks", "input"];
    readonly codepoint: 58166;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "mouse-scroll";
    readonly pascal_name: "MouseScroll";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "clicks", "input"];
    readonly codepoint: 58162;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "mouse-simple";
    readonly pascal_name: "MouseSimple";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["clicks", "input"];
    readonly codepoint: 58948;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "music-note";
    readonly pascal_name: "MusicNote";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["songs", "audio", "playlist", "albums"];
    readonly codepoint: 58172;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "music-note-simple";
    readonly pascal_name: "MusicNoteSimple";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["songs", "audio", "playlist", "albums"];
    readonly codepoint: 58174;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "music-notes";
    readonly pascal_name: "MusicNotes";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["songs", "audio", "playlist", "albums"];
    readonly codepoint: 58176;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "music-notes-minus";
    readonly pascal_name: "MusicNotesMinus";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "songs", "audio", "playlist", "albums", "remove", "subtract"];
    readonly codepoint: 60940;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "music-notes-plus";
    readonly pascal_name: "MusicNotesPlus";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["songs", "audio", "playlist", "albums", "add"];
    readonly codepoint: 60284;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "music-notes-simple";
    readonly pascal_name: "MusicNotesSimple";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["songs", "audio", "playlist", "albums"];
    readonly codepoint: 58178;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "navigation-arrow";
    readonly pascal_name: "NavigationArrow";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["location", "directions", "compass", "gps"];
    readonly codepoint: 60126;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "needle";
    readonly pascal_name: "Needle";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["sewing", "thread", "awl", "tailor"];
    readonly codepoint: 59438;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "network";
    readonly pascal_name: "Network";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "internet", "ethernet", "lan"];
    readonly codepoint: 60894;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "network-slash";
    readonly pascal_name: "NetworkSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "internet", "ethernet", "lan", "error"];
    readonly codepoint: 60892;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "network-x";
    readonly pascal_name: "NetworkX";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "internet", "ethernet", "lan", "disabled"];
    readonly codepoint: 60890;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "newspaper";
    readonly pascal_name: "Newspaper";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["reading", "writing", "journals", "periodicals"];
    readonly codepoint: 58180;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "newspaper-clipping";
    readonly pascal_name: "NewspaperClipping";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "reading", "writing", "journals", "periodicals"];
    readonly codepoint: 58182;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "not-equals";
    readonly pascal_name: "NotEquals";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "≠", "equality", "equivalent", "equivalence", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60838;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "not-member-of";
    readonly pascal_name: "NotMemberOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "∉", "is not element of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60846;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "not-subset-of";
    readonly pascal_name: "NotSubsetOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "⊄", "not subset of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60848;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "not-superset-of";
    readonly pascal_name: "NotSupersetOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "⊉", "not superset of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60850;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "notches";
    readonly pascal_name: "Notches";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["textarea", "resize", "drag handle", "knurling"];
    readonly codepoint: 60730;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "note";
    readonly pascal_name: "Note";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["notes", "note-taking", "memorandum", "post-it", "reminders"];
    readonly codepoint: 58184;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "note-blank";
    readonly pascal_name: "NoteBlank";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["notes", "note-taking", "memorandum", "post-it", "reminders"];
    readonly codepoint: 58186;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "note-pencil";
    readonly pascal_name: "NotePencil";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["notes", "note-taking", "memorandum", "post-it", "reminders"];
    readonly codepoint: 58188;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "notebook";
    readonly pascal_name: "Notebook";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["notes", "note-taking", "memorandum", "journal", "diary", "logs", "logbook"];
    readonly codepoint: 58190;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "notepad";
    readonly pascal_name: "Notepad";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "logs", "logbook", "notes", "note-taking", "memorandum", "journal", "diary"];
    readonly codepoint: 58942;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "notification";
    readonly pascal_name: "Notification";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["badge", "pip"];
    readonly codepoint: 59130;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "notion-logo";
    readonly pascal_name: "NotionLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["documentation", "productivity", "wiki", "logos"];
    readonly codepoint: 59808;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "nuclear-plant";
    readonly pascal_name: "NuclearPlant";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "renewable", "energy", "power", "electricity"];
    readonly codepoint: 60796;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "number-circle-eight";
    readonly pascal_name: "NumberCircleEight";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["8", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58194;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-five";
    readonly pascal_name: "NumberCircleFive";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["5", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58200;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-four";
    readonly pascal_name: "NumberCircleFour";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*updated*", "4", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58206;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "number-circle-nine";
    readonly pascal_name: "NumberCircleNine";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["9", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58212;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-one";
    readonly pascal_name: "NumberCircleOne";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["1", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58218;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-seven";
    readonly pascal_name: "NumberCircleSeven";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["7", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58224;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-six";
    readonly pascal_name: "NumberCircleSix";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["6", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58230;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-three";
    readonly pascal_name: "NumberCircleThree";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["3", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58236;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-two";
    readonly pascal_name: "NumberCircleTwo";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["2", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58242;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-circle-zero";
    readonly pascal_name: "NumberCircleZero";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["0", "round", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58248;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-eight";
    readonly pascal_name: "NumberEight";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["8", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58192;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-five";
    readonly pascal_name: "NumberFive";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["5", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58198;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-four";
    readonly pascal_name: "NumberFour";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*updated*", "4", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58204;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "number-nine";
    readonly pascal_name: "NumberNine";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["9", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58210;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-one";
    readonly pascal_name: "NumberOne";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["1", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58216;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-seven";
    readonly pascal_name: "NumberSeven";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["7", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58222;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-six";
    readonly pascal_name: "NumberSix";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["6", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58228;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-eight";
    readonly pascal_name: "NumberSquareEight";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["8", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58196;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-five";
    readonly pascal_name: "NumberSquareFive";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["5", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58202;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-four";
    readonly pascal_name: "NumberSquareFour";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*updated*", "4", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58208;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "number-square-nine";
    readonly pascal_name: "NumberSquareNine";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["9", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58214;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-one";
    readonly pascal_name: "NumberSquareOne";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["1", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58220;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-seven";
    readonly pascal_name: "NumberSquareSeven";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["7", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58226;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-six";
    readonly pascal_name: "NumberSquareSix";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["6", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58232;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-three";
    readonly pascal_name: "NumberSquareThree";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["3", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58238;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-two";
    readonly pascal_name: "NumberSquareTwo";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["2", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58244;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-square-zero";
    readonly pascal_name: "NumberSquareZero";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["0", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58250;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-three";
    readonly pascal_name: "NumberThree";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["3", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58234;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-two";
    readonly pascal_name: "NumberTwo";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["2", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58240;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "number-zero";
    readonly pascal_name: "NumberZero";
    readonly categories: readonly [IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["0", "numbers", "numerals", "digits", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58246;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "numpad";
    readonly pascal_name: "Numpad";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "dialer", "dialpad", "call-center", "telephone", "landline", "password", "passcode"];
    readonly codepoint: 58312;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "nut";
    readonly pascal_name: "Nut";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["bolts", "screws", "machinery", "tools", "hexagon"];
    readonly codepoint: 58252;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "ny-times-logo";
    readonly pascal_name: "NyTimesLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["nyt", "new york times", "logos", "reading", "writing", "news", "newspaper"];
    readonly codepoint: 58950;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "octagon";
    readonly pascal_name: "Octagon";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["8", "shapes", "polygons"];
    readonly codepoint: 58254;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "office-chair";
    readonly pascal_name: "OfficeChair";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["furniture", "seat"];
    readonly codepoint: 59974;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "onigiri";
    readonly pascal_name: "Onigiri";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "rice ball", "japanese", "food", "restaurant"];
    readonly codepoint: 60972;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "open-ai-logo";
    readonly pascal_name: "OpenAiLogo";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "artificial intelligence", "ai", "chatgpt", "llm", "logos"];
    readonly codepoint: 59346;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "option";
    readonly pascal_name: "Option";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["keyboard", "shortcut", "modifier"];
    readonly codepoint: 59560;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "orange";
    readonly pascal_name: "Orange";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "food", "fruit", "juice", "citrus", "groceries", "market"];
    readonly codepoint: 60992;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "orange-slice";
    readonly pascal_name: "OrangeSlice";
    readonly categories: readonly [IconCategory.MAP, IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["food", "fruit", "juice", "citrus", "groceries", "market"];
    readonly codepoint: 60726;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "oven";
    readonly pascal_name: "Oven";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "stove", "stovetop", "food", "cooking", "cuisine", "kitchen"];
    readonly codepoint: 60812;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "package";
    readonly pascal_name: "Package";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["packages", "boxes", "delivery", "mail", "postal service", "bundles", "library", "libraries", "shipping"];
    readonly codepoint: 58256;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "paint-brush";
    readonly pascal_name: "PaintBrush";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["colors", "color picker", "arts"];
    readonly codepoint: 59120;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "paint-brush-broad";
    readonly pascal_name: "PaintBrushBroad";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["fill", "colors", "color picker", "arts"];
    readonly codepoint: 58768;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "paint-brush-household";
    readonly pascal_name: "PaintBrushHousehold";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["colors", "color picker", "arts"];
    readonly codepoint: 59122;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "paint-bucket";
    readonly pascal_name: "PaintBucket";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*updated*", "paintbucket", "colors", "color picker", "fill", "arts"];
    readonly codepoint: 58258;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "paint-roller";
    readonly pascal_name: "PaintRoller";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["colors", "color picker", "fill", "arts", "theme"];
    readonly codepoint: 59124;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "palette";
    readonly pascal_name: "Palette";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["paint", "colors", "color picker", "arts"];
    readonly codepoint: 59080;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "panorama";
    readonly pascal_name: "Panorama";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "image", "picture", "photography", "landscape", "360"];
    readonly codepoint: 60066;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pants";
    readonly pascal_name: "Pants";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothing", "clothes", "jeans"];
    readonly codepoint: 60552;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "paper-plane";
    readonly pascal_name: "PaperPlane";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "messages", "messaging", "toys", "games"];
    readonly codepoint: 58260;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "paper-plane-right";
    readonly pascal_name: "PaperPlaneRight";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "messages", "messaging", "toys", "games"];
    readonly codepoint: 58262;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "paper-plane-tilt";
    readonly pascal_name: "PaperPlaneTilt";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["mail", "email", "send", "sent", "messages", "messaging", "toys", "games"];
    readonly codepoint: 58264;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "paperclip";
    readonly pascal_name: "Paperclip";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.EDITOR, IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["attachments", "mail", "email", "office"];
    readonly codepoint: 58266;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "paperclip-horizontal";
    readonly pascal_name: "PaperclipHorizontal";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.EDITOR, IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["attachments", "mail", "email", "office"];
    readonly codepoint: 58770;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "parachute";
    readonly pascal_name: "Parachute";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["skydiving", "safety"];
    readonly codepoint: 60028;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "paragraph";
    readonly pascal_name: "Paragraph";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["pilcrow"];
    readonly codepoint: 59744;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "parallelogram";
    readonly pascal_name: "Parallelogram";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "bandcamp", "logos"];
    readonly codepoint: 60614;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "park";
    readonly pascal_name: "Park";
    readonly categories: readonly [IconCategory.MAP, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["bench", "outdoors"];
    readonly codepoint: 60594;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "password";
    readonly pascal_name: "Password";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["security", "secured", "authentication", "authenticated", "login", "locked", "encrypted", "encryption"];
    readonly codepoint: 59218;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "path";
    readonly pascal_name: "Path";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["transit", "travel", "trail", "gps", "navigation", "route", "destination", "vector"];
    readonly codepoint: 58268;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "patreon-logo";
    readonly pascal_name: "PatreonLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*updated*", "crowdfunding", "logos"];
    readonly codepoint: 59786;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "pause";
    readonly pascal_name: "Pause";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "resume", "start", "stop"];
    readonly codepoint: 58270;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "pause-circle";
    readonly pascal_name: "PauseCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "resume", "start", "stop", "round"];
    readonly codepoint: 58272;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "paw-print";
    readonly pascal_name: "PawPrint";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.COMMERCE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["pets", "pet store", "pet shop", "animals", "cat", "dog", "veterinarian"];
    readonly codepoint: 58952;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "paypal-logo";
    readonly pascal_name: "PaypalLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.FINANCE, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["payments", "paying", "purchase", "logos"];
    readonly codepoint: 59788;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "peace";
    readonly pascal_name: "Peace";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["love", "hippies", "peace sign", "symbols"];
    readonly codepoint: 58274;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "pen";
    readonly pascal_name: "Pen";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["ink", "write", "writing", "editing", "sign", "signature"];
    readonly codepoint: 58282;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "pen-nib";
    readonly pascal_name: "PenNib";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["ink", "write", "writing", "editing", "sign", "signature", "fountain pen", "illustrator"];
    readonly codepoint: 58284;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "pen-nib-straight";
    readonly pascal_name: "PenNibStraight";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["ink", "write", "writing", "editing", "sign", "signature", "fountain pen", "illustrator"];
    readonly codepoint: 58954;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "pencil";
    readonly pascal_name: "Pencil";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "sign", "signature"];
    readonly codepoint: 58286;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "pencil-circle";
    readonly pascal_name: "PencilCircle";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "sign", "signature"];
    readonly codepoint: 58288;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "pencil-line";
    readonly pascal_name: "PencilLine";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "sign", "signature"];
    readonly codepoint: 58290;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "pencil-ruler";
    readonly pascal_name: "PencilRuler";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "drawing", "drafting", "construction", "tools"];
    readonly codepoint: 59654;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pencil-simple";
    readonly pascal_name: "PencilSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "sign", "signature"];
    readonly codepoint: 58292;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "pencil-simple-line";
    readonly pascal_name: "PencilSimpleLine";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["write", "writing", "editing", "sign", "signature"];
    readonly codepoint: 60358;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "pencil-simple-slash";
    readonly pascal_name: "PencilSimpleSlash";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["read-only", "write", "writing", "editing"];
    readonly codepoint: 60662;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "pencil-slash";
    readonly pascal_name: "PencilSlash";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["read-only", "write", "writing", "editing"];
    readonly codepoint: 60664;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "pentagon";
    readonly pascal_name: "Pentagon";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "shapes", "polygons", "5"];
    readonly codepoint: 60542;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pentagram";
    readonly pascal_name: "Pentagram";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["star", "wicca", "satan", "satanism", "religion", "spirituality", "evil", "magic"];
    readonly codepoint: 60508;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "pepper";
    readonly pascal_name: "Pepper";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["food", "spicy", "chile", "vegetable"];
    readonly codepoint: 59722;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "percent";
    readonly pascal_name: "Percent";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["%", "percentage", "percentile", "ratio", "delta", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58294;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "person";
    readonly pascal_name: "Person";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["walking", "human", "woman", "man", "body", "transit", "transportation", "travel", "commuter", "user"];
    readonly codepoint: 58280;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "person-arms-spread";
    readonly pascal_name: "PersonArmsSpread";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["accessibility", "vitruvian", "stretch", "sports"];
    readonly codepoint: 60670;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "person-simple";
    readonly pascal_name: "PersonSimple";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pedestrian", "walking", "human", "woman", "man", "body", "transit", "transportation", "travel", "commuter", "user", "exercise"];
    readonly codepoint: 59182;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "person-simple-bike";
    readonly pascal_name: "PersonSimpleBike";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pedestrian", "biking", "bicycle", "human", "woman", "man", "body", "sports", "exercise"];
    readonly codepoint: 59188;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "person-simple-circle";
    readonly pascal_name: "PersonSimpleCircle";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "human", "accessibility", "a11y", "vitruvius", "vitruvian"];
    readonly codepoint: 61016;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "person-simple-hike";
    readonly pascal_name: "PersonSimpleHike";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.HEALTH, IconCategory.MAP, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "pedestrian", "climbing", "mountaineering", "bouldering"];
    readonly codepoint: 60756;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "person-simple-run";
    readonly pascal_name: "PersonSimpleRun";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pedestrian", "running", "human", "woman", "man", "body", "transit", "transportation", "travel", "commuter", "user", "exercise"];
    readonly codepoint: 59184;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "person-simple-ski";
    readonly pascal_name: "PersonSimpleSki";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "skiing", "winter", "mountain"];
    readonly codepoint: 59164;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "person-simple-snowboard";
    readonly pascal_name: "PersonSimpleSnowboard";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "snowboarding", "winter", "mountain"];
    readonly codepoint: 59166;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "person-simple-swim";
    readonly pascal_name: "PersonSimpleSwim";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "pedestrian", "swimming", "human", "woman", "man", "body", "sports", "exercise"];
    readonly codepoint: 59190;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "person-simple-tai-chi";
    readonly pascal_name: "PersonSimpleTaiChi";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "mindfulness", "martial arts", "meditation", "sports", "exercise", "yoga"];
    readonly codepoint: 60764;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "person-simple-throw";
    readonly pascal_name: "PersonSimpleThrow";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pedestrian", "tennis", "human", "woman", "man", "body", "sports", "exercise"];
    readonly codepoint: 59186;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "person-simple-walk";
    readonly pascal_name: "PersonSimpleWalk";
    readonly categories: readonly [IconCategory.MAP, IconCategory.PEOPLE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["pedestrian", "walking", "human", "woman", "man", "body", "transit", "transportation", "travel", "commuter", "user", "exercise"];
    readonly codepoint: 59194;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "perspective";
    readonly pascal_name: "Perspective";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["3d", "skew", "warp", "trapezoid"];
    readonly codepoint: 60390;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "phone";
    readonly pascal_name: "Phone";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "telephone", "landline", "talk"];
    readonly codepoint: 58296;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phone-call";
    readonly pascal_name: "PhoneCall";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "calling", "ringing", "telephone", "landline", "talk"];
    readonly codepoint: 58298;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phone-disconnect";
    readonly pascal_name: "PhoneDisconnect";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "hang up", "disconnected", "telephone", "landline", "talk"];
    readonly codepoint: 58300;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phone-incoming";
    readonly pascal_name: "PhoneIncoming";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "calling", "telephone", "landline", "talk"];
    readonly codepoint: 58302;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phone-list";
    readonly pascal_name: "PhoneList";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "calls", "call-center", "telephone", "landline", "talk"];
    readonly codepoint: 58316;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "phone-outgoing";
    readonly pascal_name: "PhoneOutgoing";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "calling", "telephone", "landline", "talk"];
    readonly codepoint: 58304;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phone-pause";
    readonly pascal_name: "PhonePause";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "calls", "hold", "call-center", "telephone", "landline", "talk"];
    readonly codepoint: 58314;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "phone-plus";
    readonly pascal_name: "PhonePlus";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "telephone", "landline", "talk", "conference", "add"];
    readonly codepoint: 60502;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "phone-slash";
    readonly pascal_name: "PhoneSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "disabled", "disconnected", "telephone", "landline", "talk"];
    readonly codepoint: 58306;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phone-transfer";
    readonly pascal_name: "PhoneTransfer";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*new*", "calls", "call-center", "telephone", "landline", "talk"];
    readonly codepoint: 58310;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "phone-x";
    readonly pascal_name: "PhoneX";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["calls", "missed", "errors", "telephone", "landline", "talk"];
    readonly codepoint: 58308;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "phosphor-logo";
    readonly pascal_name: "PhosphorLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos"];
    readonly codepoint: 58318;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "pi";
    readonly pascal_name: "Pi";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["π", "symbol", "mathematics", "circle"];
    readonly codepoint: 60544;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "piano-keys";
    readonly pascal_name: "PianoKeys";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "instrument", "keyboard"];
    readonly codepoint: 59848;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "picnic-table";
    readonly pascal_name: "PicnicTable";
    readonly categories: readonly [IconCategory.MAP, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "bench", "park", "outdoors"];
    readonly codepoint: 60966;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "picture-in-picture";
    readonly pascal_name: "PictureInPicture";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["pip", "pop-out", "minimize", "maximize"];
    readonly codepoint: 58956;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "piggy-bank";
    readonly pascal_name: "PiggyBank";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["savings", "deposit", "money", "coins"];
    readonly codepoint: 59908;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "pill";
    readonly pascal_name: "Pill";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["capsule", "medicine", "rx", "pharmacy", "pharmacist", "pharmaceuticals", "prescription", "drugs"];
    readonly codepoint: 59136;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "ping-pong";
    readonly pascal_name: "PingPong";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "paddle"];
    readonly codepoint: 59970;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pint-glass";
    readonly pascal_name: "PintGlass";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "water", "beverage", "drinks", "beverages", "food", "dining"];
    readonly codepoint: 60880;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pinterest-logo";
    readonly pascal_name: "PinterestLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "vision board", "mood board", "social media"];
    readonly codepoint: 58958;
    readonly published_in: 1.2;
    readonly updated_in: 1.4;
}, {
    readonly name: "pinwheel";
    readonly pascal_name: "Pinwheel";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["toys", "whirligig"];
    readonly codepoint: 60316;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "pipe";
    readonly pascal_name: "Pipe";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "tube", "plumber", "plumbing", "construction"];
    readonly codepoint: 60806;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pipe-wrench";
    readonly pascal_name: "PipeWrench";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "plumber", "plumbing", "tools", "construction"];
    readonly codepoint: 60808;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pix-logo";
    readonly pascal_name: "PixLogo";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "payments", "paying", "purchase", "logos"];
    readonly codepoint: 60610;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "pizza";
    readonly pascal_name: "Pizza";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["fast food", "party", "places", "locations", "restaurants", "food", "dining"];
    readonly codepoint: 59286;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "placeholder";
    readonly pascal_name: "Placeholder";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["empty", "notdef", "tofu", "rectangle slash", "missing"];
    readonly codepoint: 58960;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "planet";
    readonly pascal_name: "Planet";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["saturn", "world", "globe", "astronomy", "space"];
    readonly codepoint: 58962;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "plant";
    readonly pascal_name: "Plant";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["sprout", "vegan", "farm", "farming", "garden", "gardening"];
    readonly codepoint: 60334;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "play";
    readonly pascal_name: "Play";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "resume", "start"];
    readonly codepoint: 58320;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "play-circle";
    readonly pascal_name: "PlayCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "resume", "start", "round"];
    readonly codepoint: 58322;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "play-pause";
    readonly pascal_name: "PlayPause";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "resume", "start", "stop"];
    readonly codepoint: 59582;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "playlist";
    readonly pascal_name: "Playlist";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "queue"];
    readonly codepoint: 59050;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "plug";
    readonly pascal_name: "Plug";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["outlet", "socket", "plugin", "integration"];
    readonly codepoint: 59718;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "plug-charging";
    readonly pascal_name: "PlugCharging";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["outlet", "socket", "plugin", "integration", "charge", "charging"];
    readonly codepoint: 60252;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "plugs";
    readonly pascal_name: "Plugs";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["outlet", "socket", "plugin", "integration", "disconnected"];
    readonly codepoint: 60246;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "plugs-connected";
    readonly pascal_name: "PlugsConnected";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "outlet", "socket", "plugin", "integration"];
    readonly codepoint: 60250;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "plus";
    readonly pascal_name: "Plus";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["addition", "sum", "mathematics", "arithmetic", "calculator", "+"];
    readonly codepoint: 58324;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "plus-circle";
    readonly pascal_name: "PlusCircle";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["addition", "sum", "mathematics", "arithmetic", "calculator", "round", "+"];
    readonly codepoint: 58326;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "plus-minus";
    readonly pascal_name: "PlusMinus";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["plus or minus", "plus/minus", "add/subtract", "addition", "sum", "subtraction", "difference", "mathematics", "arithmetic", "calculator", "+", "-", "±"];
    readonly codepoint: 58328;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "plus-square";
    readonly pascal_name: "PlusSquare";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["addition", "sum", "mathematics", "arithmetic", "calculator", "+"];
    readonly codepoint: 60746;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "poker-chip";
    readonly pascal_name: "PokerChip";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["chips", "tokens", "cards", "gambling", "casino"];
    readonly codepoint: 58772;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "police-car";
    readonly pascal_name: "PoliceCar";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "vehicles", "cars", "automobiles", "law enforcement"];
    readonly codepoint: 60490;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "polygon";
    readonly pascal_name: "Polygon";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "drawing"];
    readonly codepoint: 59088;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "popcorn";
    readonly pascal_name: "Popcorn";
    readonly categories: readonly [IconCategory.MAP, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["food", "movies", "theater"];
    readonly codepoint: 60238;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "popsicle";
    readonly pascal_name: "Popsicle";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "ice cream", "dessert", "summer", "food"];
    readonly codepoint: 60350;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "potted-plant";
    readonly pascal_name: "PottedPlant";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["sprout", "vegan", "garden", "gardening"];
    readonly codepoint: 60450;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "power";
    readonly pascal_name: "Power";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["charged", "charger", "charging", "on", "off", "on/off", "switch", "power switch"];
    readonly codepoint: 58330;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "prescription";
    readonly pascal_name: "Prescription";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["rx", "medicine", "drugs", "pharmacy", "pharmacist", "pharmaceuticals", "doctor"];
    readonly codepoint: 59298;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "presentation";
    readonly pascal_name: "Presentation";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["whiteboard", "flipchart", "charts", "statistics", "analyze", "analysis", "meeting"];
    readonly codepoint: 58964;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "presentation-chart";
    readonly pascal_name: "PresentationChart";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["whiteboard", "flipchart", "graphs", "graphing", "charts", "statistics", "analyze", "analysis", "meeting"];
    readonly codepoint: 58966;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "printer";
    readonly pascal_name: "Printer";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["printing"];
    readonly codepoint: 58332;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "prohibit";
    readonly pascal_name: "Prohibit";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["forbidden", "prohibited", "cancelled", "prevent", "stop", "do not enter"];
    readonly codepoint: 58334;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "prohibit-inset";
    readonly pascal_name: "ProhibitInset";
    readonly categories: readonly [IconCategory.MAP, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["forbidden", "prohibited", "cancelled", "prevent", "stop", "do not enter"];
    readonly codepoint: 58336;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "projector-screen";
    readonly pascal_name: "ProjectorScreen";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.MEDIA, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["projection", "presentation", "slideshow", "movies", "charts", "statistics", "analyze", "analysis"];
    readonly codepoint: 58968;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "projector-screen-chart";
    readonly pascal_name: "ProjectorScreenChart";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["projection", "presentation", "slideshow", "graphs", "graphing", "charts", "statistics", "analyze", "analysis"];
    readonly codepoint: 58970;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "pulse";
    readonly pascal_name: "Pulse";
    readonly alias: {
        readonly name: "activity";
        readonly pascal_name: "Activity";
    };
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["activity", "heartbeat", "medical", "ecg", "ekg", "vitals", "monitor", "medicine"];
    readonly codepoint: 57344;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "push-pin";
    readonly pascal_name: "PushPin";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["favorites", "favorited", "pushpin"];
    readonly codepoint: 58338;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "push-pin-simple";
    readonly pascal_name: "PushPinSimple";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["favorites", "favorited", "pushpin"];
    readonly codepoint: 58972;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "push-pin-simple-slash";
    readonly pascal_name: "PushPinSimpleSlash";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["favorites", "favorited", "pushpin", "disabled"];
    readonly codepoint: 58974;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "push-pin-slash";
    readonly pascal_name: "PushPinSlash";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["favorites", "favorited", "pushpin", "disabled"];
    readonly codepoint: 58340;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "puzzle-piece";
    readonly pascal_name: "PuzzlePiece";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["board game", "element", "component", "extension", "plugin"];
    readonly codepoint: 58774;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "qr-code";
    readonly pascal_name: "QrCode";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["upc", "barcode", "products", "shopping", "scanner"];
    readonly codepoint: 58342;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "question";
    readonly pascal_name: "Question";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["information", "help", "support", "questions"];
    readonly codepoint: 58344;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "question-mark";
    readonly pascal_name: "QuestionMark";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["*new*", "?", "information", "help", "support", "questions", "punctuation", "symbol"];
    readonly codepoint: 58344;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "queue";
    readonly pascal_name: "Queue";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "playlist"];
    readonly codepoint: 59052;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "quotes";
    readonly pascal_name: "Quotes";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.EDITOR, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["quoations", "quotation marks", "double-quotes", "writing", "books"];
    readonly codepoint: 58976;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "rabbit";
    readonly pascal_name: "Rabbit";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "hare", "fast", "animal"];
    readonly codepoint: 60098;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "racquet";
    readonly pascal_name: "Racquet";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "sports", "tennis", "squash", "pickleball"];
    readonly codepoint: 60930;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "radical";
    readonly pascal_name: "Radical";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["√", "radix", "radicand", "square root", "squareroot", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58346;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "radio";
    readonly pascal_name: "Radio";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["broadcast", "fm", "am", "xm", "transmitter", "receiver"];
    readonly codepoint: 59262;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "radio-button";
    readonly pascal_name: "RadioButton";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["input", "checkbox", "checked"];
    readonly codepoint: 60168;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "radioactive";
    readonly pascal_name: "Radioactive";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["radiation", "danger", "warning", "nuclear", "atomic"];
    readonly codepoint: 59868;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "rainbow";
    readonly pascal_name: "Rainbow";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "rainstorm", "arc", "pride", "lgbtq+", "leprechaun"];
    readonly codepoint: 58776;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "rainbow-cloud";
    readonly pascal_name: "RainbowCloud";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "rainstorm", "cloudy", "partly cloudy", "partly sunny", "pride", "lgbtq+", "leprechaun"];
    readonly codepoint: 58778;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "ranking";
    readonly pascal_name: "Ranking";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "medal", "rank", "leaderboard", "winner", "sports"];
    readonly codepoint: 60770;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "read-cv-logo";
    readonly pascal_name: "ReadCvLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["resume", "jobs", "logos"];
    readonly codepoint: 60684;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "receipt";
    readonly pascal_name: "Receipt";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["purchase", "money", "clipping", "expense"];
    readonly codepoint: 58348;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "receipt-x";
    readonly pascal_name: "ReceiptX";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["purchase", "money", "clipping", "expense", "cancel"];
    readonly codepoint: 60736;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "record";
    readonly pascal_name: "Record";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "recording", "recorder", "voice memo"];
    readonly codepoint: 58350;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "rectangle";
    readonly pascal_name: "Rectangle";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["4", "shapes", "polygons", "box"];
    readonly codepoint: 58352;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "rectangle-dashed";
    readonly pascal_name: "RectangleDashed";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "4", "shapes", "polygons", "box", "missing"];
    readonly codepoint: 58354;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "recycle";
    readonly pascal_name: "Recycle";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["recycling", "trash", "environmental", "green"];
    readonly codepoint: 59226;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "reddit-logo";
    readonly pascal_name: "RedditLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "subreddit", "snoo", "social media"];
    readonly codepoint: 58780;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "repeat";
    readonly pascal_name: "Repeat";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "recycle"];
    readonly codepoint: 58358;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "repeat-once";
    readonly pascal_name: "RepeatOnce";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "recycle"];
    readonly codepoint: 58360;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "replit-logo";
    readonly pascal_name: "ReplitLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "logos", "ide", "editor", "coding"];
    readonly codepoint: 60298;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "resize";
    readonly pascal_name: "Resize";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "maximize", "expand", "grow"];
    readonly codepoint: 60782;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "rewind";
    readonly pascal_name: "Rewind";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "seek", "scrub", "scan", "skip", "back", "backwards", "reverse"];
    readonly codepoint: 59048;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "rewind-circle";
    readonly pascal_name: "RewindCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "seek", "scrub", "scan", "skip", "back", "backwards", "reverse"];
    readonly codepoint: 58362;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "road-horizon";
    readonly pascal_name: "RoadHorizon";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["trip", "drive", "road", "travel", "transportation", "highway"];
    readonly codepoint: 59448;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "robot";
    readonly pascal_name: "Robot";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["automaton", "artificial intelligence", "ai"];
    readonly codepoint: 59234;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "rocket";
    readonly pascal_name: "Rocket";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["spaceship", "launch", "deployment", "rocketship"];
    readonly codepoint: 58364;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "rocket-launch";
    readonly pascal_name: "RocketLaunch";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "spaceship", "flying", "blastoff", "deployment", "rocketship"];
    readonly codepoint: 58366;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "rows";
    readonly pascal_name: "Rows";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["2", "shapes", "polygons", "box", "stack", "list", "table", "cards"];
    readonly codepoint: 58786;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "rows-plus-bottom";
    readonly pascal_name: "RowsPlusBottom";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "2", "shapes", "polygons", "box", "stack", "list", "table", "cards", "prepend", "insert"];
    readonly codepoint: 58782;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "rows-plus-top";
    readonly pascal_name: "RowsPlusTop";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "2", "shapes", "polygons", "box", "stack", "list", "table", "cards", "prepend", "insert"];
    readonly codepoint: 58784;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "rss";
    readonly pascal_name: "Rss";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["radio", "broadcast", "web feed", "news", "aggregator"];
    readonly codepoint: 58368;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "rss-simple";
    readonly pascal_name: "RssSimple";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["radio", "broadcast", "web feed", "news", "aggregator"];
    readonly codepoint: 58370;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "rug";
    readonly pascal_name: "Rug";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*updated*", "tapestry", "carpet"];
    readonly codepoint: 59930;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "ruler";
    readonly pascal_name: "Ruler";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["measure", "scale", "distance"];
    readonly codepoint: 59064;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "sailboat";
    readonly pascal_name: "Sailboat";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "sailing", "ship", "vehicles", "transportation", "sports", "places", "locations"];
    readonly codepoint: 59274;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "scales";
    readonly pascal_name: "Scales";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["measure", "balance", "law", "justice", "government"];
    readonly codepoint: 59216;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "scan";
    readonly pascal_name: "Scan";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["upc", "barcode", "products", "shopping", "scanner"];
    readonly codepoint: 60342;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "scan-smiley";
    readonly pascal_name: "ScanSmiley";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "facial recognition", "face unlock", "scanner"];
    readonly codepoint: 60340;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "scissors";
    readonly pascal_name: "Scissors";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*updated*", "cut", "snip", "clipboard"];
    readonly codepoint: 60128;
    readonly published_in: 1.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "scooter";
    readonly pascal_name: "Scooter";
    readonly categories: readonly [IconCategory.MAP, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "transportation", "travel", "transit"];
    readonly codepoint: 59424;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "screencast";
    readonly pascal_name: "Screencast";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["apple", "airplay", "screencasting", "screen share", "television", "tv"];
    readonly codepoint: 58372;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "screwdriver";
    readonly pascal_name: "Screwdriver";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "tools", "construction", "flathead", "drill"];
    readonly codepoint: 59502;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "scribble";
    readonly pascal_name: "Scribble";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "doodles", "squiggle", "drawing", "sign", "signature"];
    readonly codepoint: 59398;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "scribble-loop";
    readonly pascal_name: "ScribbleLoop";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["doodles", "drawing", "sign", "signature"];
    readonly codepoint: 58978;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "scroll";
    readonly pascal_name: "Scroll";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*updated*", "parchment", "paper", "script", "spell", "fantasy"];
    readonly codepoint: 60282;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "seal";
    readonly pascal_name: "Seal";
    readonly alias: {
        readonly name: "circle-wavy";
        readonly pascal_name: "CircleWavy";
    };
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "verified", "verification", "shapes", "polygons", "circle-wavy"];
    readonly codepoint: 58884;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "seal-check";
    readonly pascal_name: "SealCheck";
    readonly alias: {
        readonly name: "circle-wavy-check";
        readonly pascal_name: "CircleWavyCheck";
    };
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "verified", "verification", "shapes", "polygons", "circle-wavy"];
    readonly codepoint: 58886;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "seal-percent";
    readonly pascal_name: "SealPercent";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["*new*", "badge", "discount", "sale", "shapes", "polygons", "circle-wavy"];
    readonly codepoint: 58890;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "seal-question";
    readonly pascal_name: "SealQuestion";
    readonly alias: {
        readonly name: "circle-wavy-question";
        readonly pascal_name: "CircleWavyQuestion";
    };
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "unverified", "verification", "shapes", "polygons", "circle-wavy"];
    readonly codepoint: 58888;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "seal-warning";
    readonly pascal_name: "SealWarning";
    readonly alias: {
        readonly name: "circle-wavy-warning";
        readonly pascal_name: "CircleWavyWarning";
    };
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "unverified", "verification", "errors", "shapes", "polygons", "circle-wavy"];
    readonly codepoint: 58892;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "seat";
    readonly pascal_name: "Seat";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "chair", "car seat", "airplane seat", "transit", "transportation", "traveling"];
    readonly codepoint: 60302;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "seatbelt";
    readonly pascal_name: "Seatbelt";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "vehicles", "safety"];
    readonly codepoint: 60926;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "security-camera";
    readonly pascal_name: "SecurityCamera";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["*new*", "cctv", "surveillance", "video", "monitor", "motion detector", "safety"];
    readonly codepoint: 60580;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "selection";
    readonly pascal_name: "Selection";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis", "select", "square dashed"];
    readonly codepoint: 59034;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "selection-all";
    readonly pascal_name: "SelectionAll";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis", "select all"];
    readonly codepoint: 59206;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "selection-background";
    readonly pascal_name: "SelectionBackground";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis"];
    readonly codepoint: 60152;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "selection-foreground";
    readonly pascal_name: "SelectionForeground";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis"];
    readonly codepoint: 60150;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "selection-inverse";
    readonly pascal_name: "SelectionInverse";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis", "invert"];
    readonly codepoint: 59204;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "selection-plus";
    readonly pascal_name: "SelectionPlus";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis", "add"];
    readonly codepoint: 59036;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "selection-slash";
    readonly pascal_name: "SelectionSlash";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["marquis", "unselect"];
    readonly codepoint: 59038;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "shapes";
    readonly pascal_name: "Shapes";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["geometry", "square", "circle", "triangle"];
    readonly codepoint: 60510;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "share";
    readonly pascal_name: "Share";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send to", "export", "arrows"];
    readonly codepoint: 58374;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "share-fat";
    readonly pascal_name: "ShareFat";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.SYSTEM, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["export", "send to"];
    readonly codepoint: 60754;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "share-network";
    readonly pascal_name: "ShareNetwork";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["send to", "export"];
    readonly codepoint: 58376;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shield";
    readonly pascal_name: "Shield";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "secured", "defense", "defended", "authentication", "authenticated", "guarded", "locked", "encrypted", "encryption"];
    readonly codepoint: 58378;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shield-check";
    readonly pascal_name: "ShieldCheck";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "defense", "authentication", "authenticated", "guarded", "locked", "encrypted", "encryption"];
    readonly codepoint: 58380;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shield-checkered";
    readonly pascal_name: "ShieldCheckered";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "defense", "authentication", "authenticated", "guarded", "locked", "encrypted", "encryption"];
    readonly codepoint: 59144;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "shield-chevron";
    readonly pascal_name: "ShieldChevron";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "defense", "authentication", "authenticated", "guarded", "locked", "encrypted", "encryption"];
    readonly codepoint: 58382;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shield-plus";
    readonly pascal_name: "ShieldPlus";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "defense", "authentication", "authenticated", "guarded", "locked", "encrypted", "encryption"];
    readonly codepoint: 59142;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "shield-slash";
    readonly pascal_name: "ShieldSlash";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "unsecured", "defense", "undefended", "authentication", "unauthenticated", "unguarded", "unlocked", "unencrypted", "encryption", "disabled"];
    readonly codepoint: 58384;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shield-star";
    readonly pascal_name: "ShieldStar";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "defense", "authentication", "authenticated", "guarded", "locked", "encrypted", "encryption"];
    readonly codepoint: 60468;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "shield-warning";
    readonly pascal_name: "ShieldWarning";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["badge", "security", "unsecured", "defense", "undefended", "authentication", "unauthenticated", "unguarded", "unlocked", "unencrypted", "encryption", "errors"];
    readonly codepoint: 58386;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shipping-container";
    readonly pascal_name: "ShippingContainer";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "shipping", "transportation", "places", "locations"];
    readonly codepoint: 59276;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "shirt-folded";
    readonly pascal_name: "ShirtFolded";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothes", "clothing"];
    readonly codepoint: 60050;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "shooting-star";
    readonly pascal_name: "ShootingStar";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["wish", "comet", "meteor"];
    readonly codepoint: 60666;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "shopping-bag";
    readonly pascal_name: "ShoppingBag";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ecommerce", "market", "basket", "cart", "buying", "checkout", "places", "locations"];
    readonly codepoint: 58390;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shopping-bag-open";
    readonly pascal_name: "ShoppingBagOpen";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ecommerce", "market", "basket", "cart", "buying", "checkout", "places", "locations"];
    readonly codepoint: 58392;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shopping-cart";
    readonly pascal_name: "ShoppingCart";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ecommerce", "market", "basket", "buying", "groceries", "checkout", "places", "locations"];
    readonly codepoint: 58398;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shopping-cart-simple";
    readonly pascal_name: "ShoppingCartSimple";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ecommerce", "market", "basket", "buying", "groceries", "checkout", "places", "locations"];
    readonly codepoint: 58400;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shovel";
    readonly pascal_name: "Shovel";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "tools", "digging", "construction"];
    readonly codepoint: 59878;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "shower";
    readonly pascal_name: "Shower";
    readonly categories: readonly [IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["bath", "bathtub", "bathroom", "faucet"];
    readonly codepoint: 59254;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "shrimp";
    readonly pascal_name: "Shrimp";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["food", "seafood", "prawn"];
    readonly codepoint: 60084;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "shuffle";
    readonly pascal_name: "Shuffle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.ARROWS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "randomize", "crossed"];
    readonly codepoint: 58402;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shuffle-angular";
    readonly pascal_name: "ShuffleAngular";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.ARROWS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "randomize", "crossed"];
    readonly codepoint: 58404;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "shuffle-simple";
    readonly pascal_name: "ShuffleSimple";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.ARROWS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "randomize", "crossed"];
    readonly codepoint: 58406;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "sidebar";
    readonly pascal_name: "Sidebar";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["left rail", "wireframe", "ui", "interface"];
    readonly codepoint: 60086;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "sidebar-simple";
    readonly pascal_name: "SidebarSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["left rail", "wireframe", "ui", "interface"];
    readonly codepoint: 60452;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "sigma";
    readonly pascal_name: "Sigma";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["σ", "symbol", "mathematics", "sum"];
    readonly codepoint: 60088;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "sign-in";
    readonly pascal_name: "SignIn";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "signin", "login", "log in", "enter"];
    readonly codepoint: 58408;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "sign-out";
    readonly pascal_name: "SignOut";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "signout", "logout", "log out", "exit"];
    readonly codepoint: 58410;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "signature";
    readonly pascal_name: "Signature";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["*updated*", "sign", "autograph", "verify"];
    readonly codepoint: 60332;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "signpost";
    readonly pascal_name: "Signpost";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["direction", "traffic", "road sign", "transit", "transportation"];
    readonly codepoint: 59548;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "sim-card";
    readonly pascal_name: "SimCard";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "cellular", "cellphone", "mobile"];
    readonly codepoint: 58980;
    readonly published_in: 1.2;
    readonly updated_in: 2.1;
}, {
    readonly name: "siren";
    readonly pascal_name: "Siren";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["alarm", "police", "lights", "warning"];
    readonly codepoint: 59832;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "sketch-logo";
    readonly pascal_name: "SketchLogo";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["drawing", "art", "illustration", "ui", "interface", "prototype", "prototyping", "gemstone", "diamond"];
    readonly codepoint: 58412;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "skip-back";
    readonly pascal_name: "SkipBack";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "seek", "scrub", "scan", "back", "backwards", "reverse", "previous"];
    readonly codepoint: 58788;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "skip-back-circle";
    readonly pascal_name: "SkipBackCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "seek", "scrub", "scan", "back", "backwards", "reverse", "previous"];
    readonly codepoint: 58414;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "skip-forward";
    readonly pascal_name: "SkipForward";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "seek", "scrub", "scan", "ahead", "next"];
    readonly codepoint: 58790;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "skip-forward-circle";
    readonly pascal_name: "SkipForwardCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "seek", "scrub", "scan", "ahead", "next"];
    readonly codepoint: 58416;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "skull";
    readonly pascal_name: "Skull";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["death", "dead", "kill"];
    readonly codepoint: 59670;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "skype-logo";
    readonly pascal_name: "SkypeLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "chat", "video conference"];
    readonly codepoint: 59612;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "slack-logo";
    readonly pascal_name: "SlackLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "messaging"];
    readonly codepoint: 58792;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "sliders";
    readonly pascal_name: "Sliders";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "faders", "filters", "equalizer", "volume", "settings", "preferences"];
    readonly codepoint: 58418;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "sliders-horizontal";
    readonly pascal_name: "SlidersHorizontal";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "faders", "filters", "equalizer", "volume", "settings", "preferences"];
    readonly codepoint: 58420;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "slideshow";
    readonly pascal_name: "Slideshow";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["pictures", "images", "photography", "gallery", "carousel"];
    readonly codepoint: 60722;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "smiley";
    readonly pascal_name: "Smiley";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "happy", "grinning", "smiling"];
    readonly codepoint: 58422;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "smiley-angry";
    readonly pascal_name: "SmileyAngry";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "mad", "frown"];
    readonly codepoint: 60514;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "smiley-blank";
    readonly pascal_name: "SmileyBlank";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "unimpressed", "no face"];
    readonly codepoint: 58424;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "smiley-meh";
    readonly pascal_name: "SmileyMeh";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "unimpressed", "neutral"];
    readonly codepoint: 58426;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "smiley-melting";
    readonly pascal_name: "SmileyMelting";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "face", "emoji", "embarrassment", "sarcasm", "shame", "hot", "heat"];
    readonly codepoint: 61014;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "smiley-nervous";
    readonly pascal_name: "SmileyNervous";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*updated*", "face", "emoji", "anxious", "uncomfortable", "uneasy", "queasy", "sick", "ill"];
    readonly codepoint: 58428;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "smiley-sad";
    readonly pascal_name: "SmileySad";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "unhappy", "frowning"];
    readonly codepoint: 58430;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "smiley-sticker";
    readonly pascal_name: "SmileySticker";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "happy", "grinning", "smiling"];
    readonly codepoint: 58432;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "smiley-wink";
    readonly pascal_name: "SmileyWink";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "winking", "flirting", "cute"];
    readonly codepoint: 58982;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "smiley-x-eyes";
    readonly pascal_name: "SmileyXEyes";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["face", "emoji", "dead", "killed", "unconscious"];
    readonly codepoint: 58434;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "snapchat-logo";
    readonly pascal_name: "SnapchatLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "messaging", "social media"];
    readonly codepoint: 58984;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "sneaker";
    readonly pascal_name: "Sneaker";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothes", "clothing", "shoes", "trainers", "sports"];
    readonly codepoint: 59404;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "sneaker-move";
    readonly pascal_name: "SneakerMove";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*updated*", "clothes", "clothing", "shoes", "trainers", "sports"];
    readonly codepoint: 60768;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "snowflake";
    readonly pascal_name: "Snowflake";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "snowy", "snowing", "snowstorm"];
    readonly codepoint: 58794;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "soccer-ball";
    readonly pascal_name: "SoccerBall";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*updated*", "sports", "football", "mls"];
    readonly codepoint: 59158;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "sock";
    readonly pascal_name: "Sock";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "clothes", "clothing"];
    readonly codepoint: 60622;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "solar-panel";
    readonly pascal_name: "SolarPanel";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "renewable", "energy", "power", "electricity"];
    readonly codepoint: 60794;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "solar-roof";
    readonly pascal_name: "SolarRoof";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "renewable", "energy", "power", "electricity"];
    readonly codepoint: 60794;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "sort-ascending";
    readonly pascal_name: "SortAscending";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "sorted", "sorting", "increasing", "a to z", "arrows", "list"];
    readonly codepoint: 58436;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "sort-descending";
    readonly pascal_name: "SortDescending";
    readonly categories: readonly [IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "sorted", "sorting", "decreasing", "z to a", "arrows", "list"];
    readonly codepoint: 58438;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "soundcloud-logo";
    readonly pascal_name: "SoundcloudLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["music", "social media", "logos"];
    readonly codepoint: 59614;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "spade";
    readonly pascal_name: "Spade";
    readonly categories: readonly [IconCategory.GAMES];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["spades", "suits", "cards", "gambling", "casino", "gaming"];
    readonly codepoint: 58440;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "sparkle";
    readonly pascal_name: "Sparkle";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["star", "rate", "ratings", "favorites", "favorited"];
    readonly codepoint: 59042;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "speaker-hifi";
    readonly pascal_name: "SpeakerHifi";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "sound", "stereo"];
    readonly codepoint: 59912;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "speaker-high";
    readonly pascal_name: "SpeakerHigh";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "volume", "sound"];
    readonly codepoint: 58442;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "speaker-low";
    readonly pascal_name: "SpeakerLow";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "volume", "sound"];
    readonly codepoint: 58444;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "speaker-none";
    readonly pascal_name: "SpeakerNone";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "muted", "volume", "sound"];
    readonly codepoint: 58446;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "speaker-simple-high";
    readonly pascal_name: "SpeakerSimpleHigh";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "volume", "sound"];
    readonly codepoint: 58448;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "speaker-simple-low";
    readonly pascal_name: "SpeakerSimpleLow";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "volume", "sound"];
    readonly codepoint: 58450;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "speaker-simple-none";
    readonly pascal_name: "SpeakerSimpleNone";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "muted", "volume", "sound"];
    readonly codepoint: 58452;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "speaker-simple-slash";
    readonly pascal_name: "SpeakerSimpleSlash";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "muted", "volume", "sound", "disabled"];
    readonly codepoint: 58454;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "speaker-simple-x";
    readonly pascal_name: "SpeakerSimpleX";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "muted", "volume", "sound", "disabled", "errors"];
    readonly codepoint: 58456;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "speaker-slash";
    readonly pascal_name: "SpeakerSlash";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "muted", "volume", "sound", "disabled"];
    readonly codepoint: 58458;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "speaker-x";
    readonly pascal_name: "SpeakerX";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "music", "audio", "muted", "volume", "sound", "disabled", "errors"];
    readonly codepoint: 58460;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "speedometer";
    readonly pascal_name: "Speedometer";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "gauge", "dashboard", "meter", "speed", "odometer", "performance"];
    readonly codepoint: 61044;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "sphere";
    readonly pascal_name: "Sphere";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "circle", "ball", "3d", "mesh", "cad", "model"];
    readonly codepoint: 61030;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "spinner";
    readonly pascal_name: "Spinner";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["loading", "loader", "waiting", "progress"];
    readonly codepoint: 58986;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "spinner-ball";
    readonly pascal_name: "SpinnerBall";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "loading", "loader", "waiting", "progress"];
    readonly codepoint: 60968;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "spinner-gap";
    readonly pascal_name: "SpinnerGap";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["loading", "loader", "waiting", "progress"];
    readonly codepoint: 58988;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "spiral";
    readonly pascal_name: "Spiral";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*updated*", "spin", "rotate", "dizzy"];
    readonly codepoint: 59898;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "split-horizontal";
    readonly pascal_name: "SplitHorizontal";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["resize", "columns"];
    readonly codepoint: 59506;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "split-vertical";
    readonly pascal_name: "SplitVertical";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["resize", "rows"];
    readonly codepoint: 59510;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "spotify-logo";
    readonly pascal_name: "SpotifyLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["music", "player", "streaming"];
    readonly codepoint: 58990;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "spray-bottle";
    readonly pascal_name: "SprayBottle";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "cleaner", "cleaning"];
    readonly codepoint: 59364;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "square";
    readonly pascal_name: "Square";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["4", "shapes", "polygons", "box"];
    readonly codepoint: 58462;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "square-half";
    readonly pascal_name: "SquareHalf";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["4", "shapes", "polygons", "box", "columns", "sidebar", "split vertical"];
    readonly codepoint: 58466;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "square-half-bottom";
    readonly pascal_name: "SquareHalfBottom";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["4", "shapes", "polygons", "box", "columns", "sidebar", "split vertical"];
    readonly codepoint: 60182;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "square-logo";
    readonly pascal_name: "SquareLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["squareup", "payment"];
    readonly codepoint: 59024;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "square-split-horizontal";
    readonly pascal_name: "SquareSplitHorizontal";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "polygons", "columns"];
    readonly codepoint: 59504;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "square-split-vertical";
    readonly pascal_name: "SquareSplitVertical";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["shapes", "polygons", "rows"];
    readonly codepoint: 59508;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "squares-four";
    readonly pascal_name: "SquaresFour";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["4", "shapes", "polygons", "apps", "applications", "grid", "table", "microsoft", "logos"];
    readonly codepoint: 58468;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "stack";
    readonly pascal_name: "Stack";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["cards", "layers"];
    readonly codepoint: 58470;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "stack-minus";
    readonly pascal_name: "StackMinus";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "cards", "layers", "remove", "delete"];
    readonly codepoint: 60916;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "stack-overflow-logo";
    readonly pascal_name: "StackOverflowLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "code"];
    readonly codepoint: 60280;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "stack-plus";
    readonly pascal_name: "StackPlus";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "cards", "layers", "add"];
    readonly codepoint: 60918;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "stack-simple";
    readonly pascal_name: "StackSimple";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["cards", "layers"];
    readonly codepoint: 58472;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "stairs";
    readonly pascal_name: "Stairs";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["staircase", "steps", "escalator", "exit", "signs"];
    readonly codepoint: 59628;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "stamp";
    readonly pascal_name: "Stamp";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["clone", "seal", "official"];
    readonly codepoint: 59976;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "standard-definition";
    readonly pascal_name: "StandardDefinition";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "sd", "resolution", "video"];
    readonly codepoint: 60048;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "star";
    readonly pascal_name: "Star";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.MAP, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["rate", "ratings", "favorites", "favorited"];
    readonly codepoint: 58474;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "star-and-crescent";
    readonly pascal_name: "StarAndCrescent";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["islam", "muslim", "moon", "religion", "worship", "symbol"];
    readonly codepoint: 60660;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "star-four";
    readonly pascal_name: "StarFour";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["rate", "ratings", "favorites", "favorited"];
    readonly codepoint: 59044;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "star-half";
    readonly pascal_name: "StarHalf";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["rate", "ratings"];
    readonly codepoint: 59146;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "star-of-david";
    readonly pascal_name: "StarOfDavid";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["judaism", "jewish", "hexagram", "religion", "worship", "symbol"];
    readonly codepoint: 59550;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "steam-logo";
    readonly pascal_name: "SteamLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "gaming", "games"];
    readonly codepoint: 60116;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "steering-wheel";
    readonly pascal_name: "SteeringWheel";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["cars", "vehicles", "automobiles", "driving"];
    readonly codepoint: 59820;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "steps";
    readonly pascal_name: "Steps";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["stairs", "staircase", "exit", "signs"];
    readonly codepoint: 60606;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "stethoscope";
    readonly pascal_name: "Stethoscope";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["hospital", "medical", "medicine", "injury", "safety", "emergency", "doctor", "heart"];
    readonly codepoint: 59370;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "sticker";
    readonly pascal_name: "Sticker";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["stickers", "sticker pack", "labels"];
    readonly codepoint: 58796;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "stool";
    readonly pascal_name: "Stool";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["chair", "seat", "furniture"];
    readonly codepoint: 59972;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "stop";
    readonly pascal_name: "Stop";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio"];
    readonly codepoint: 58476;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "stop-circle";
    readonly pascal_name: "StopCircle";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["music", "audio", "round"];
    readonly codepoint: 58478;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "storefront";
    readonly pascal_name: "Storefront";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["shops", "shopping", "markets", "stores", "buildings", "places", "locations"];
    readonly codepoint: 58480;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "strategy";
    readonly pascal_name: "Strategy";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["sports", "strategem", "plan", "tic-tac-toe"];
    readonly codepoint: 59962;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "stripe-logo";
    readonly pascal_name: "StripeLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMERCE, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["payment"];
    readonly codepoint: 59032;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "student";
    readonly pascal_name: "Student";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["pupil", "graduate", "classroom", "teacher", "education", "school", "college", "university"];
    readonly codepoint: 59198;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "subset-of";
    readonly pascal_name: "SubsetOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "⊆", "subset of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60864;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "subset-proper-of";
    readonly pascal_name: "SubsetProperOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "⊂", "proper subset of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60854;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "subtitles";
    readonly pascal_name: "Subtitles";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["subtitles", "television", "tv", "transcribed", "transcription", "accessibility", "a11y"];
    readonly codepoint: 57768;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "subtitles-slash";
    readonly pascal_name: "SubtitlesSlash";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "subtitles", "television", "tv", "transcribed", "transcription", "accessibility", "a11y", "disabled"];
    readonly codepoint: 57766;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "subtract";
    readonly pascal_name: "Subtract";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["boolean", "intersection", "combine", "split", "merge", "union"];
    readonly codepoint: 60374;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "subtract-square";
    readonly pascal_name: "SubtractSquare";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["boolean", "intersection", "combine", "split", "merge", "union"];
    readonly codepoint: 60372;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "subway";
    readonly pascal_name: "Subway";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "vehicles", "underground", "train", "tunnel", "metro", "light rail", "public transit", "transportation", "commuter", "traveling", "places", "locations"];
    readonly codepoint: 58520;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "suitcase";
    readonly pascal_name: "Suitcase";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["briefcase", "valise", "baggage", "folders", "portfolio"];
    readonly codepoint: 58798;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "suitcase-rolling";
    readonly pascal_name: "SuitcaseRolling";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["suitcase", "luggage", "travel", "transportation"];
    readonly codepoint: 59824;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "suitcase-simple";
    readonly pascal_name: "SuitcaseSimple";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["briefcase", "valise", "baggage", "folders", "portfolio"];
    readonly codepoint: 58800;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "sun";
    readonly pascal_name: "Sun";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.SYSTEM, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["day", "daytime", "daylight", "clear", "sunny", "sunshine", "light mode", "brightness", "lighten", "brighten"];
    readonly codepoint: 58482;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "sun-dim";
    readonly pascal_name: "SunDim";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.SYSTEM, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["day", "daytime", "daylight", "clear", "sunny", "sunshine", "light mode", "brightness", "darken"];
    readonly codepoint: 58484;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "sun-horizon";
    readonly pascal_name: "SunHorizon";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["day", "daytime", "daylight", "clear", "sunny", "sunshine", "sunrise", "sunset"];
    readonly codepoint: 58806;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "sunglasses";
    readonly pascal_name: "Sunglasses";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["vision", "sun", "spectacles"];
    readonly codepoint: 59414;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "superset-of";
    readonly pascal_name: "SupersetOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "⊇", "superset of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60856;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "superset-proper-of";
    readonly pascal_name: "SupersetProperOf";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "⊃", "proper superset of", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60852;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "swap";
    readonly pascal_name: "Swap";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["layers", "replace", "exchange", "reverse"];
    readonly codepoint: 59452;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "swatches";
    readonly pascal_name: "Swatches";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["colors", "color picker", "samples", "pantone"];
    readonly codepoint: 58808;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "swimming-pool";
    readonly pascal_name: "SwimmingPool";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["swim", "sports", "exercise", "olympics", "aquatics"];
    readonly codepoint: 60598;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "sword";
    readonly pascal_name: "Sword";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["weapon", "knife", "dagger", "gladius", "video games", "rpg", "gaming", "war"];
    readonly codepoint: 58810;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "synagogue";
    readonly pascal_name: "Synagogue";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["jewish", "judaism", "temple", "religion", "worship"];
    readonly codepoint: 60652;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "syringe";
    readonly pascal_name: "Syringe";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["needle", "hypodermic", "vaccine", "medicine", "doctor", "shot", "hospital"];
    readonly codepoint: 59752;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "t-shirt";
    readonly pascal_name: "TShirt";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["clothes", "clothing"];
    readonly codepoint: 58992;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "table";
    readonly pascal_name: "Table";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["tables", "tabular", "speadsheets", "excel", "grid", "form"];
    readonly codepoint: 58486;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tabs";
    readonly pascal_name: "Tabs";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "browser", "window", "folders", "files"];
    readonly codepoint: 59256;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "tag";
    readonly pascal_name: "Tag";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tags", "hashtag", "labels", "sale", "sell", "price", "discount"];
    readonly codepoint: 58488;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tag-chevron";
    readonly pascal_name: "TagChevron";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tags", "hashtag", "labels", "sale"];
    readonly codepoint: 58994;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "tag-simple";
    readonly pascal_name: "TagSimple";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.DEVELOPMENT, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tags", "hashtag", "labels", "sale", "sell", "price", "discount"];
    readonly codepoint: 58490;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "target";
    readonly pascal_name: "Target";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["bullseye", "radar", "archery", "accuracy", "precision"];
    readonly codepoint: 58492;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "taxi";
    readonly pascal_name: "Taxi";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*updated*", "vehicles", "cars", "automobiles", "livery", "limousine", "uber"];
    readonly codepoint: 59650;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "tea-bag";
    readonly pascal_name: "TeaBag";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "drinks", "beverages", "sachet", "caffeine", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 59622;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "telegram-logo";
    readonly pascal_name: "TelegramLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "messages", "messaging"];
    readonly codepoint: 58812;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "television";
    readonly pascal_name: "Television";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["screen", "tv", "displays"];
    readonly codepoint: 59220;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "television-simple";
    readonly pascal_name: "TelevisionSimple";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "screen", "tv", "displays"];
    readonly codepoint: 60134;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "tennis-ball";
    readonly pascal_name: "TennisBall";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["sports", "mlb"];
    readonly codepoint: 59168;
    readonly published_in: 1.3;
    readonly updated_in: 1.4;
}, {
    readonly name: "tent";
    readonly pascal_name: "Tent";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS, IconCategory.NATURE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["camping", "outdoors", "tarp"];
    readonly codepoint: 59578;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "terminal";
    readonly pascal_name: "Terminal";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["command line", "cli", "bash", "shell", "caret", "console"];
    readonly codepoint: 58494;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "terminal-window";
    readonly pascal_name: "TerminalWindow";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["command line", "cli", "bash", "shell", "caret", "console"];
    readonly codepoint: 60136;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "test-tube";
    readonly pascal_name: "TestTube";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.NATURE, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["science", "chemistry", "experiment", "vial"];
    readonly codepoint: 59296;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-a-underline";
    readonly pascal_name: "TextAUnderline";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["typography", "typeface", "print", "font", "underscore", "emphasis"];
    readonly codepoint: 60724;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "text-aa";
    readonly pascal_name: "TextAa";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["typography", "typeface", "print", "font"];
    readonly codepoint: 59118;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-align-center";
    readonly pascal_name: "TextAlignCenter";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "typography", "print", "font", "alignment", "centered"];
    readonly codepoint: 58496;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-align-justify";
    readonly pascal_name: "TextAlignJustify";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "typography", "print", "font", "alignment", "justified"];
    readonly codepoint: 58498;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-align-left";
    readonly pascal_name: "TextAlignLeft";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "typography", "print", "font", "alignment", "flush left"];
    readonly codepoint: 58500;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-align-right";
    readonly pascal_name: "TextAlignRight";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "typography", "print", "font", "alignment", "flush right"];
    readonly codepoint: 58502;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-b";
    readonly pascal_name: "TextB";
    readonly alias: {
        readonly name: "text-bolder";
        readonly pascal_name: "TextBolder";
    };
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["typography", "typeface", "print", "font", "bold", "boldface", "emphasis"];
    readonly codepoint: 58814;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "text-columns";
    readonly pascal_name: "TextColumns";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "typography", "print", "font", "alignment", "article"];
    readonly codepoint: 60566;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-h";
    readonly pascal_name: "TextH";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["heading", "typography", "print"];
    readonly codepoint: 59066;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-h-five";
    readonly pascal_name: "TextHFive";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["heading", "h5", "typography", "print"];
    readonly codepoint: 59076;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-h-four";
    readonly pascal_name: "TextHFour";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "heading", "h4", "typography", "print"];
    readonly codepoint: 59074;
    readonly published_in: 1.3;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-h-one";
    readonly pascal_name: "TextHOne";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["heading", "h1", "typography", "print"];
    readonly codepoint: 59068;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-h-six";
    readonly pascal_name: "TextHSix";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["heading", "h6", "typography", "print"];
    readonly codepoint: 59078;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-h-three";
    readonly pascal_name: "TextHThree";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["heading", "h3", "typography", "print"];
    readonly codepoint: 59072;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-h-two";
    readonly pascal_name: "TextHTwo";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["heading", "h2", "typography", "print"];
    readonly codepoint: 59070;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "text-indent";
    readonly pascal_name: "TextIndent";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "alignment", "tab", "menu"];
    readonly codepoint: 59934;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-italic";
    readonly pascal_name: "TextItalic";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["typography", "typeface", "print", "font", "slant", "oblique", "stress", "emphasis", "calligraphy"];
    readonly codepoint: 58816;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "text-outdent";
    readonly pascal_name: "TextOutdent";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*updated*", "alignment", "tab", "unindent", "dedent", "menu"];
    readonly codepoint: 59932;
    readonly published_in: 1.4;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-strikethrough";
    readonly pascal_name: "TextStrikethrough";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["typography", "typeface", "print", "font", "struck", "remove", "delete", "change"];
    readonly codepoint: 58818;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "text-subscript";
    readonly pascal_name: "TextSubscript";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "typography", "font", "formatting", "mathematics", "power", "exponent", "calculator"];
    readonly codepoint: 60568;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-superscript";
    readonly pascal_name: "TextSuperscript";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "typography", "font", "formatting", "mathematics", "calculator"];
    readonly codepoint: 60570;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-t";
    readonly pascal_name: "TextT";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["typography", "typeface", "print", "font"];
    readonly codepoint: 58506;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "text-t-slash";
    readonly pascal_name: "TextTSlash";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "typography", "typeface", "print", "font", "formatting", "clear"];
    readonly codepoint: 58504;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "text-underline";
    readonly pascal_name: "TextUnderline";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["typography", "typeface", "print", "font", "underscore", "emphasis"];
    readonly codepoint: 58820;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "textbox";
    readonly pascal_name: "Textbox";
    readonly categories: readonly [IconCategory.EDITOR, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["input", "cursor", "field"];
    readonly codepoint: 60170;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "thermometer";
    readonly pascal_name: "Thermometer";
    readonly categories: readonly [IconCategory.WEATHER, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "temperature", "degrees", "°", "celcius", "centigrade", "kelvin", "fahrenheit", "hot", "warm", "cold"];
    readonly codepoint: 58822;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "thermometer-cold";
    readonly pascal_name: "ThermometerCold";
    readonly categories: readonly [IconCategory.WEATHER, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "temperature", "degrees", "°", "celcius", "centigrade", "kelvin", "fahrenheit"];
    readonly codepoint: 58824;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "thermometer-hot";
    readonly pascal_name: "ThermometerHot";
    readonly categories: readonly [IconCategory.WEATHER, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "temperature", "degrees", "°", "celcius", "centigrade", "kelvin", "fahrenheit", "warm"];
    readonly codepoint: 58826;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "thermometer-simple";
    readonly pascal_name: "ThermometerSimple";
    readonly categories: readonly [IconCategory.WEATHER, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "temperature", "degrees", "°", "celcius", "centigrade", "kelvin", "fahrenheit", "hot", "warm", "cold"];
    readonly codepoint: 58828;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "threads-logo";
    readonly pascal_name: "ThreadsLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "meta", "instagram", "social media"];
    readonly codepoint: 60830;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "three-d";
    readonly pascal_name: "ThreeD";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "3d", "cad", "model"];
    readonly codepoint: 59994;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "thumbs-down";
    readonly pascal_name: "ThumbsDown";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["dislike", "hate", "emoji", "no"];
    readonly codepoint: 58508;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "thumbs-up";
    readonly pascal_name: "ThumbsUp";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["like", "love", "favorited", "favorites", "emoji", "yes"];
    readonly codepoint: 58510;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "ticket";
    readonly pascal_name: "Ticket";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["ticketstub", "movie ticket", "entry", "admissions", "events"];
    readonly codepoint: 58512;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tidal-logo";
    readonly pascal_name: "TidalLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["music", "logos"];
    readonly codepoint: 60700;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "tiktok-logo";
    readonly pascal_name: "TiktokLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "social media"];
    readonly codepoint: 60146;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "tilde";
    readonly pascal_name: "Tilde";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "~", "∼", "proportional", "comparison", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60840;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "timer";
    readonly pascal_name: "Timer";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["clock", "alarm", "schedule", "events", "stopwatch", "sports"];
    readonly codepoint: 58514;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tip-jar";
    readonly pascal_name: "TipJar";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "give", "deposit", "donation", "savings", "money"];
    readonly codepoint: 59360;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "tipi";
    readonly pascal_name: "Tipi";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.OBJECTS, IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["teepee", "lodge", "tent", "outdoors", "camping", "tarp"];
    readonly codepoint: 60720;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "tire";
    readonly pascal_name: "Tire";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "wheel", "vehicles", "transportation"];
    readonly codepoint: 60882;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "toggle-left";
    readonly pascal_name: "ToggleLeft";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["switch", "controls", "settings", "preferences"];
    readonly codepoint: 58996;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "toggle-right";
    readonly pascal_name: "ToggleRight";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["switch", "controls", "settings", "preferences"];
    readonly codepoint: 58998;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "toilet";
    readonly pascal_name: "Toilet";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["bathroom", "restroom", "lavatory", "water closet"];
    readonly codepoint: 59290;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "toilet-paper";
    readonly pascal_name: "ToiletPaper";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["bathroom", "restroom", "lavatory", "water closet"];
    readonly codepoint: 59292;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "toolbox";
    readonly pascal_name: "Toolbox";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tools", "carpentry", "construction"];
    readonly codepoint: 60576;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "tooth";
    readonly pascal_name: "Tooth";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["teeth", "dentistry", "medical", "medicine", "doctor", "cavity"];
    readonly codepoint: 59852;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "tornado";
    readonly pascal_name: "Tornado";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["*new*", "meteorology", "twister", "storm", "wind", "disaster"];
    readonly codepoint: 59532;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "tote";
    readonly pascal_name: "Tote";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["suitcases", "valises", "baggage", "tote-bag", "portfolios"];
    readonly codepoint: 58516;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tote-simple";
    readonly pascal_name: "ToteSimple";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["suitcases", "valises", "baggage", "tote-bag", "portfolios"];
    readonly codepoint: 59000;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "towel";
    readonly pascal_name: "Towel";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "clothing", "linen", "hotel", "beach", "pool", "swimming", "shower", "bath"];
    readonly codepoint: 60902;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "tractor";
    readonly pascal_name: "Tractor";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "vehicles", "farmer", "field", "farming", "agriculture"];
    readonly codepoint: 60526;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "trademark";
    readonly pascal_name: "Trademark";
    readonly categories: readonly [IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["tm", "®", "™", "intellectual property"];
    readonly codepoint: 59888;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "trademark-registered";
    readonly pascal_name: "TrademarkRegistered";
    readonly categories: readonly [IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["®", "™", "intellectual property"];
    readonly codepoint: 58356;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "traffic-cone";
    readonly pascal_name: "TrafficCone";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["pylon", "safety", "transit", "transportation"];
    readonly codepoint: 59816;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "traffic-sign";
    readonly pascal_name: "TrafficSign";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["road signs", "transit", "transportation"];
    readonly codepoint: 59002;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "traffic-signal";
    readonly pascal_name: "TrafficSignal";
    readonly categories: readonly [IconCategory.MAP];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["stop light", "safety", "transit", "transportation"];
    readonly codepoint: 59818;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "train";
    readonly pascal_name: "Train";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "subway", "light rail", "public transit", "transportation", "commuter", "traveling", "places", "locations"];
    readonly codepoint: 58518;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "train-regional";
    readonly pascal_name: "TrainRegional";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "subway", "railroad", "public transit", "transportation", "commuter", "freight", "shipping", "traveling", "places", "locations"];
    readonly codepoint: 58526;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "train-simple";
    readonly pascal_name: "TrainSimple";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "subway", "light rail", "public transit", "transportation", "commuter", "traveling", "places", "locations"];
    readonly codepoint: 58528;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tram";
    readonly pascal_name: "Tram";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["vehicles", "subway", "railroad", "public transit", "transportation", "commuter", "light rail", "shipping", "traveling", "places", "locations"];
    readonly codepoint: 59884;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "translate";
    readonly pascal_name: "Translate";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["translation", "languages", "internationalization", "i18n", "speech"];
    readonly codepoint: 58530;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "trash";
    readonly pascal_name: "Trash";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["garbage", "remove", "delete", "destroy", "recycle", "recycling"];
    readonly codepoint: 58534;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "trash-simple";
    readonly pascal_name: "TrashSimple";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["garbage", "remove", "delete", "destroy", "recycle", "recycling"];
    readonly codepoint: 58536;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tray";
    readonly pascal_name: "Tray";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.COMMUNICATION, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["inbox", "mailbox", "bin"];
    readonly codepoint: 58538;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tray-arrow-down";
    readonly pascal_name: "TrayArrowDown";
    readonly alias: {
        readonly name: "archive-tray";
        readonly pascal_name: "ArchiveTray";
    };
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["inbox", "saved", "saving", "archived", "archiving", "archival", "downloaded", "downloading"];
    readonly codepoint: 57360;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "tray-arrow-up";
    readonly pascal_name: "TrayArrowUp";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.OFFICE;
    readonly tags: readonly ["*new*", "outbox", "archival", "unarchive", "uploaded", "uploading"];
    readonly codepoint: 61010;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "treasure-chest";
    readonly pascal_name: "TreasureChest";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["*new*", "loot", "lootbox", "inventory", "rewards", "gaming", "pirate"];
    readonly codepoint: 60898;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "tree";
    readonly pascal_name: "Tree";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["plants", "branches", "leaves", "green", "environmental"];
    readonly codepoint: 59098;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "tree-evergreen";
    readonly pascal_name: "TreeEvergreen";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["plants", "branches", "leaves", "pine", "conifer", "green", "environmental"];
    readonly codepoint: 59100;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "tree-palm";
    readonly pascal_name: "TreePalm";
    readonly categories: readonly [IconCategory.NATURE];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["tropical", "beach", "plants", "branches", "leaves", "green", "environmental"];
    readonly codepoint: 59674;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "tree-structure";
    readonly pascal_name: "TreeStructure";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["data structures", "family tree", "genealogy", "hierarchy", "taxonomy", "charts", "flowchart"];
    readonly codepoint: 59004;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "tree-view";
    readonly pascal_name: "TreeView";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*new*", "hierarchy"];
    readonly codepoint: 61000;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "trend-down";
    readonly pascal_name: "TrendDown";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "analyze", "analysis", "decrease", "arrows"];
    readonly codepoint: 58540;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "trend-up";
    readonly pascal_name: "TrendUp";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["graphs", "graphing", "charts", "statistics", "analyze", "analysis", "increase", "arrows"];
    readonly codepoint: 58542;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "triangle";
    readonly pascal_name: "Triangle";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["3", "shapes", "polygons"];
    readonly codepoint: 58544;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "triangle-dashed";
    readonly pascal_name: "TriangleDashed";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*new*", "3", "shapes", "polygons", "missing"];
    readonly codepoint: 58546;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "trolley";
    readonly pascal_name: "Trolley";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "airport", "briefcase", "valise", "baggage"];
    readonly codepoint: 58802;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "trolley-suitcase";
    readonly pascal_name: "TrolleySuitcase";
    readonly categories: readonly [IconCategory.OFFICE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["*new*", "airport", "briefcase", "valise", "baggage"];
    readonly codepoint: 58804;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "trophy";
    readonly pascal_name: "Trophy";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["ribbons", "medals", "winning", "victory", "awards", "prize"];
    readonly codepoint: 59006;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "truck";
    readonly pascal_name: "Truck";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["trucks", "cars", "vehicles", "automobile", "shipping", "delivery"];
    readonly codepoint: 58548;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "truck-trailer";
    readonly pascal_name: "TruckTrailer";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "vehicles", "automobile", "shipping", "tractor", "semi"];
    readonly codepoint: 58550;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "tumblr-logo";
    readonly pascal_name: "TumblrLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "social media", "logos"];
    readonly codepoint: 59604;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "twitch-logo";
    readonly pascal_name: "TwitchLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION, IconCategory.GAMES];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "streaming", "livestream", "gaming", "video games", "social media"];
    readonly codepoint: 58830;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "twitter-logo";
    readonly pascal_name: "TwitterLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "social media", "tweets", "birds"];
    readonly codepoint: 58554;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "umbrella";
    readonly pascal_name: "Umbrella";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["raining", "rainy", "insurance"];
    readonly codepoint: 59012;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "umbrella-simple";
    readonly pascal_name: "UmbrellaSimple";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["raining", "rainy", "insurance"];
    readonly codepoint: 59014;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "union";
    readonly pascal_name: "Union";
    readonly categories: readonly [IconCategory.FINANCE, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["*new*", "∪", "union", "set", "member", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 60862;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "unite";
    readonly pascal_name: "Unite";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["*updated*", "round", "join", "union", "merge", "combine", "intersecting", "intersection"];
    readonly codepoint: 59518;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "unite-square";
    readonly pascal_name: "UniteSquare";
    readonly categories: readonly [IconCategory.DESIGN, IconCategory.EDITOR];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["join", "union", "merge", "combine", "intersecting", "intersection"];
    readonly codepoint: 59512;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "upload";
    readonly pascal_name: "Upload";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["saved", "saving", "archived", "archiving", "archival", "uploaded", "uploading", "hard drive", "disk"];
    readonly codepoint: 58558;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "upload-simple";
    readonly pascal_name: "UploadSimple";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["*updated*", "saved", "saving", "archived", "archiving", "archival", "uploaded", "uploading", "hard drive", "disk"];
    readonly codepoint: 58560;
    readonly published_in: 1;
    readonly updated_in: 2.1;
}, {
    readonly name: "usb";
    readonly pascal_name: "Usb";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["serial", "port", "plug", "peripheral", "device"];
    readonly codepoint: 59734;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "user";
    readonly pascal_name: "User";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "login"];
    readonly codepoint: 58562;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-check";
    readonly pascal_name: "UserCheck";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "person", "users", "profile", "account", "contact", "login", "verified"];
    readonly codepoint: 60154;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "user-circle";
    readonly pascal_name: "UserCircle";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "login"];
    readonly codepoint: 58564;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-circle-check";
    readonly pascal_name: "UserCircleCheck";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "person", "users", "profile", "account", "contact", "login", "verified"];
    readonly codepoint: 60472;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "user-circle-dashed";
    readonly pascal_name: "UserCircleDashed";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "person", "users", "profile", "account", "contact", "login", "pending", "missing", "removed"];
    readonly codepoint: 60470;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "user-circle-gear";
    readonly pascal_name: "UserCircleGear";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "settings", "preferences"];
    readonly codepoint: 58566;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-circle-minus";
    readonly pascal_name: "UserCircleMinus";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "delete", "remove", "-"];
    readonly codepoint: 58568;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-circle-plus";
    readonly pascal_name: "UserCirclePlus";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "add", "create", "+"];
    readonly codepoint: 58570;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-focus";
    readonly pascal_name: "UserFocus";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["identification", "biometrics", "facial recognition", "profile", "person", "account", "autofocus"];
    readonly codepoint: 59132;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "user-gear";
    readonly pascal_name: "UserGear";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "settings", "preferences"];
    readonly codepoint: 58572;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-list";
    readonly pascal_name: "UserList";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profiles", "accounts", "members", "address book"];
    readonly codepoint: 59196;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "user-minus";
    readonly pascal_name: "UserMinus";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "delete", "remove", "-"];
    readonly codepoint: 58574;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-plus";
    readonly pascal_name: "UserPlus";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "add", "create", "+"];
    readonly codepoint: 58576;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-rectangle";
    readonly pascal_name: "UserRectangle";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "login"];
    readonly codepoint: 58578;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-sound";
    readonly pascal_name: "UserSound";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["*new*", "person", "users", "profile", "speech", "speaking", "voice"];
    readonly codepoint: 60584;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "user-square";
    readonly pascal_name: "UserSquare";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "contact", "login"];
    readonly codepoint: 58580;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "user-switch";
    readonly pascal_name: "UserSwitch";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["person", "users", "profile", "account", "login", "logout", "signin", "signout", "settings", "preferences"];
    readonly codepoint: 59222;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "users";
    readonly pascal_name: "Users";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["user", "group", "team", "people", "profiles", "accounts", "contacts"];
    readonly codepoint: 58582;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "users-four";
    readonly pascal_name: "UsersFour";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["user", "group", "team", "department", "community", "people", "profiles", "accounts", "contacts"];
    readonly codepoint: 59020;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "users-three";
    readonly pascal_name: "UsersThree";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["user", "group", "team", "community", "people", "profiles", "accounts", "contacts"];
    readonly codepoint: 59022;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "van";
    readonly pascal_name: "Van";
    readonly categories: readonly [IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MAP;
    readonly tags: readonly ["westfalia", "microbus", "vanagon", "cars", "vehicles", "automobile", "transit", "transportation", "traveling"];
    readonly codepoint: 59430;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "vault";
    readonly pascal_name: "Vault";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM, IconCategory.FINANCE];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["safe", "bank", "security", "secured", "authentication", "authenticated", "locked", "encrypted", "encryption"];
    readonly codepoint: 59246;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "vector-three";
    readonly pascal_name: "VectorThree";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DEVELOPMENT, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*new*", "3d", "xyz", "cartesian", "coordinates", "plane", "volume", "dimensions", "mathematics"];
    readonly codepoint: 61026;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "vector-two";
    readonly pascal_name: "VectorTwo";
    readonly categories: readonly [IconCategory.ARROWS, IconCategory.DEVELOPMENT, IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.ARROWS;
    readonly tags: readonly ["*new*", "2d", "xy", "cartesian", "coordinates", "plane", "dimensions", "mathematics"];
    readonly codepoint: 61028;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "vibrate";
    readonly pascal_name: "Vibrate";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["audio", "volume", "viration", "ringer", "calls", "silent", "silenced"];
    readonly codepoint: 58584;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "video";
    readonly pascal_name: "Video";
    readonly categories: readonly [IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.EDUCATION;
    readonly tags: readonly ["training", "course", "education", "tutorial"];
    readonly codepoint: 59200;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "video-camera";
    readonly pascal_name: "VideoCamera";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["videography", "films", "movies", "recording"];
    readonly codepoint: 58586;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "video-camera-slash";
    readonly pascal_name: "VideoCameraSlash";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["videography", "films", "movies", "recording", "disabled"];
    readonly codepoint: 58588;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "video-conference";
    readonly pascal_name: "VideoConference";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.SYSTEM, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "video call", "zoom", "skype", "discord", "facetime", "meeting"];
    readonly codepoint: 60878;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "vignette";
    readonly pascal_name: "Vignette";
    readonly categories: readonly [IconCategory.DESIGN];
    readonly figma_category: FigmaCategory.DESIGN;
    readonly tags: readonly ["photography", "darkroom", "movie", "analog"];
    readonly codepoint: 60322;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "vinyl-record";
    readonly pascal_name: "VinylRecord";
    readonly categories: readonly [IconCategory.MEDIA, IconCategory.OFFICE];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["recording", "audio", "album", "music", "ep", "lp"];
    readonly codepoint: 60588;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "virtual-reality";
    readonly pascal_name: "VirtualReality";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["virtual reality", "vr", "headset", "metaverse"];
    readonly codepoint: 59320;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "virus";
    readonly pascal_name: "Virus";
    readonly categories: readonly [IconCategory.HEALTH];
    readonly figma_category: FigmaCategory.HEALTH;
    readonly tags: readonly ["germs", "disease", "illness"];
    readonly codepoint: 59350;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "visor";
    readonly pascal_name: "Visor";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.MEDIA, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "goggles", "vision"];
    readonly codepoint: 60970;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "voicemail";
    readonly pascal_name: "Voicemail";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["phonecalls", "missed", "recording", "telephone", "landline"];
    readonly codepoint: 58590;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "volleyball";
    readonly pascal_name: "Volleyball";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.HEALTH, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.GAMES;
    readonly tags: readonly ["sports"];
    readonly codepoint: 59174;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "wall";
    readonly pascal_name: "Wall";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["firewall", "security", "secured", "blocks", "bricks"];
    readonly codepoint: 59016;
    readonly published_in: 1.2;
    readonly updated_in: 1.4;
}, {
    readonly name: "wallet";
    readonly pascal_name: "Wallet";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.FINANCE, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["money", "payment", "paying", "purchase"];
    readonly codepoint: 59018;
    readonly published_in: 1.2;
    readonly updated_in: 1.2;
}, {
    readonly name: "warehouse";
    readonly pascal_name: "Warehouse";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["storage", "industry", "manufacture", "buildings", "places", "locations"];
    readonly codepoint: 60628;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "warning";
    readonly pascal_name: "Warning";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["alert", "danger", "dangerous", "caution", "errors"];
    readonly codepoint: 58592;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "warning-circle";
    readonly pascal_name: "WarningCircle";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["alert", "danger", "dangerous", "caution", "errors", "round"];
    readonly codepoint: 58594;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "warning-diamond";
    readonly pascal_name: "WarningDiamond";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["alert", "danger", "dangerous", "caution", "errors"];
    readonly codepoint: 59388;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "warning-octagon";
    readonly pascal_name: "WarningOctagon";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SECURITY;
    readonly tags: readonly ["alert", "danger", "dangerous", "caution", "errors", "8", "eight"];
    readonly codepoint: 58596;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "washing-machine";
    readonly pascal_name: "WashingMachine";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "clothing", "laundry", "cleaning"];
    readonly codepoint: 60904;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "watch";
    readonly pascal_name: "Watch";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.TIME;
    readonly tags: readonly ["times", "timer", "alarm", "schedule", "events", "clock", "wristwatch", "wearable"];
    readonly codepoint: 58598;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wave-sawtooth";
    readonly pascal_name: "WaveSawtooth";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["synth", "synthesizer", "sound", "audio", "music", "waveform"];
    readonly codepoint: 60060;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "wave-sine";
    readonly pascal_name: "WaveSine";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["synth", "synthesizer", "sound", "audio", "music", "waveform"];
    readonly codepoint: 60058;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "wave-square";
    readonly pascal_name: "WaveSquare";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["synth", "synthesizer", "sound", "audio", "music", "waveform"];
    readonly codepoint: 60062;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "wave-triangle";
    readonly pascal_name: "WaveTriangle";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["synth", "synthesizer", "sound", "audio", "music", "waveform"];
    readonly codepoint: 60064;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "waveform";
    readonly pascal_name: "Waveform";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*updated*", "audio", "sound", "spectrum", "spectrograph", "music"];
    readonly codepoint: 59394;
    readonly published_in: 2;
    readonly updated_in: 2.1;
}, {
    readonly name: "waveform-slash";
    readonly pascal_name: "WaveformSlash";
    readonly categories: readonly [IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["*new*", "audio", "sound", "spectrum", "spectrograph", "music"];
    readonly codepoint: 59392;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "waves";
    readonly pascal_name: "Waves";
    readonly categories: readonly [IconCategory.NATURE, IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["ocean", "tides", "surf"];
    readonly codepoint: 59102;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "webcam";
    readonly pascal_name: "Webcam";
    readonly categories: readonly [IconCategory.OBJECTS, IconCategory.SYSTEM, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["camera", "video conference"];
    readonly codepoint: 59826;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "webcam-slash";
    readonly pascal_name: "WebcamSlash";
    readonly categories: readonly [IconCategory.COMMUNICATION, IconCategory.OBJECTS, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.MEDIA;
    readonly tags: readonly ["camera", "video conference"];
    readonly codepoint: 60636;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "webhooks-logo";
    readonly pascal_name: "WebhooksLogo";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.BRAND];
    readonly figma_category: FigmaCategory.DEVELOPMENT;
    readonly tags: readonly ["api"];
    readonly codepoint: 60590;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "wechat-logo";
    readonly pascal_name: "WechatLogo";
    readonly categories: readonly [IconCategory.BRAND];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["weixin", "logos"];
    readonly codepoint: 59602;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "whatsapp-logo";
    readonly pascal_name: "WhatsappLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "messages", "messaging"];
    readonly codepoint: 58832;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "wheelchair";
    readonly pascal_name: "Wheelchair";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["handicapped", "medical", "disabled", "differently abled", "accessible", "accessibility", "a11y"];
    readonly codepoint: 58600;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wheelchair-motion";
    readonly pascal_name: "WheelchairMotion";
    readonly categories: readonly [IconCategory.HEALTH, IconCategory.MAP, IconCategory.PEOPLE];
    readonly figma_category: FigmaCategory.PEOPLE;
    readonly tags: readonly ["handicapped", "medical", "disabled", "differently abled", "accessible", "accessibility", "a11y"];
    readonly codepoint: 59546;
    readonly published_in: 2;
    readonly updated_in: 2;
}, {
    readonly name: "wifi-high";
    readonly pascal_name: "WifiHigh";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "internet", "network", "connection", "connectivity"];
    readonly codepoint: 58602;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wifi-low";
    readonly pascal_name: "WifiLow";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "internet", "network", "connection", "connectivity"];
    readonly codepoint: 58604;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wifi-medium";
    readonly pascal_name: "WifiMedium";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "internet", "network", "connection", "connectivity"];
    readonly codepoint: 58606;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wifi-none";
    readonly pascal_name: "WifiNone";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "internet", "network", "connection", "connectivity"];
    readonly codepoint: 58608;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wifi-slash";
    readonly pascal_name: "WifiSlash";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "internet", "network", "connection", "connectivity", "disabled", "disconnected"];
    readonly codepoint: 58610;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "wifi-x";
    readonly pascal_name: "WifiX";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.SYSTEM;
    readonly tags: readonly ["wireless", "internet", "network", "connection", "connectivity", "disconnected", "errors"];
    readonly codepoint: 58612;
    readonly published_in: 1;
    readonly updated_in: 1.4;
}, {
    readonly name: "wind";
    readonly pascal_name: "Wind";
    readonly categories: readonly [IconCategory.WEATHER];
    readonly figma_category: FigmaCategory.WEATHER;
    readonly tags: readonly ["meteorology", "windy", "stormy", "blustery", "gusty", "air"];
    readonly codepoint: 58834;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "windmill";
    readonly pascal_name: "Windmill";
    readonly categories: readonly [IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "turbine", "energy", "renewable", "sustainability", "countryside", "landscape", "green", "power", "buildings"];
    readonly codepoint: 59896;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "windows-logo";
    readonly pascal_name: "WindowsLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.DEVELOPMENT];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["microsoft", "computers"];
    readonly codepoint: 59026;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "wine";
    readonly pascal_name: "Wine";
    readonly categories: readonly [IconCategory.COMMERCE, IconCategory.MAP, IconCategory.OBJECTS];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["drinks", "beverages", "vineyard", "places", "locations", "bars", "restaurants", "food", "dining"];
    readonly codepoint: 59058;
    readonly published_in: 1.3;
    readonly updated_in: 1.3;
}, {
    readonly name: "wrench";
    readonly pascal_name: "Wrench";
    readonly categories: readonly [IconCategory.SYSTEM, IconCategory.OBJECTS, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["settings", "setup", "preferences", "tools", "machinery", "mechanical", "repairs"];
    readonly codepoint: 58836;
    readonly published_in: 1.1;
    readonly updated_in: 1.1;
}, {
    readonly name: "x";
    readonly pascal_name: "X";
    readonly categories: readonly [IconCategory.DEVELOPMENT, IconCategory.FINANCE, IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["×", "closed", "cancelled", "dismissed", "times", "multiply", "mulitplication", "product", "mathematics", "arithmetic", "calculator"];
    readonly codepoint: 58614;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "x-circle";
    readonly pascal_name: "XCircle";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["closed", "cancelled", "dismissed", "round"];
    readonly codepoint: 58616;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "x-logo";
    readonly pascal_name: "XLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["*new*", "twitter", "logos", "social media", "tweets"];
    readonly codepoint: 58556;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "x-square";
    readonly pascal_name: "XSquare";
    readonly categories: readonly [IconCategory.SYSTEM];
    readonly figma_category: FigmaCategory.FINANCE;
    readonly tags: readonly ["closed", "cancelled", "dismissed"];
    readonly codepoint: 58618;
    readonly published_in: 1;
    readonly updated_in: 1;
}, {
    readonly name: "yarn";
    readonly pascal_name: "Yarn";
    readonly categories: readonly [IconCategory.GAMES, IconCategory.COMMERCE];
    readonly figma_category: FigmaCategory.COMMERCE;
    readonly tags: readonly ["*new*", "knitting", "sewing"];
    readonly codepoint: 60826;
    readonly published_in: 2.1;
    readonly updated_in: 2.1;
}, {
    readonly name: "yin-yang";
    readonly pascal_name: "YinYang";
    readonly categories: readonly [IconCategory.COMMUNICATION];
    readonly figma_category: FigmaCategory.COMMUNICATION;
    readonly tags: readonly ["symbol", "good", "evil", "black", "white"];
    readonly codepoint: 59690;
    readonly published_in: 1.4;
    readonly updated_in: 1.4;
}, {
    readonly name: "youtube-logo";
    readonly pascal_name: "YoutubeLogo";
    readonly categories: readonly [IconCategory.BRAND, IconCategory.COMMUNICATION, IconCategory.MEDIA];
    readonly figma_category: FigmaCategory.BRAND;
    readonly tags: readonly ["logos", "google", "videos", "movies", "social media"];
    readonly codepoint: 58620;
    readonly published_in: 1;
    readonly updated_in: 1;
}];
