// @needsAudit
/**
 * The type of notification feedback generated by a UINotificationFeedbackGenerator object.
 * [`UINotificationFeedbackType`](https://developer.apple.com/documentation/uikit/uinotificationfeedbacktype)
 */
export enum NotificationFeedbackType {
  /**
   * A notification feedback type indicating that a task has completed successfully.
   */
  Success = 'success',
  /**
   * A notification feedback type indicating that a task has produced a warning.
   */
  Warning = 'warning',
  /**
   * A notification feedback type indicating that a task has failed.
   */
  Error = 'error',
}

// @needsAudit
/**
 * The mass of the objects in the collision simulated by a UIImpactFeedbackGenerator object
 * [`UINotificationFeedbackStyle`](https://developer.apple.com/documentation/uikit/uiimpactfeedbackstyle)
 */
export enum ImpactFeedbackStyle {
  /**
   * A collision between small, light user interface elements.
   */
  Light = 'light',
  /**
   * A collision between moderately sized user interface elements.
   */
  Medium = 'medium',
  /**
   * A collision between large, heavy user interface elements.
   */
  Heavy = 'heavy',
  /**
   * A collision between user interface elements that are soft, exhibiting a large amount of compression or elasticity.
   */
  Soft = 'soft',
  /**
   * A collision between user interface elements that are rigid, exhibiting a small amount of compression or elasticity.
   */
  Rigid = 'rigid',
}
